// Compiled by ClojureScript 1.8.51 {:static-fns true, :optimize-constants true}
goog.provide('hatti.views.table');
goog.require('cljs.core');
goog.require('hatti.views.record');
goog.require('chimera.js_interop');
goog.require('om.dom');
goog.require('hatti.ona.forms');
goog.require('sablono.core');
goog.require('cljs.core.async');
goog.require('hatti.shared');
goog.require('hatti.constants');
goog.require('hatti.views');
goog.require('om.core');
goog.require('hatti.utils');
goog.require('chimera.core');
goog.require('chimera.urls');
hatti.views.table.default_num_displayed_records = (25);
hatti.views.table.table_id = "submission-grid";
hatti.views.table.pager_id = "pager";
/**
 * Extra fields that will be displayed on the table.
 */
hatti.views.table.get_extra_fields = (function hatti$views$table$get_extra_fields(is_filtered_dataview_QMARK_){
var extra_field = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$full_DASH_name,hatti.constants._id,cljs.core.cst$kw$label,"id",cljs.core.cst$kw$name,hatti.constants._id,cljs.core.cst$kw$type,"integer"], null)], null);
if(cljs.core.truth_(is_filtered_dataview_QMARK_)){
return extra_field;
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(extra_field,hatti.ona.forms.submission_time_field);
}
});
/**
 * Given a (flat-)form, returns fields for table display.
 * Puts extra fields in the beginning, metadata at the end of the table,
 * and drops fields that have no data (eg. group/note).
 */
hatti.views.table.all_fields = (function hatti$views$table$all_fields(var_args){
var args__7287__auto__ = [];
var len__7280__auto___36391 = arguments.length;
var i__7281__auto___36392 = (0);
while(true){
if((i__7281__auto___36392 < len__7280__auto___36391)){
args__7287__auto__.push((arguments[i__7281__auto___36392]));

var G__36393 = (i__7281__auto___36392 + (1));
i__7281__auto___36392 = G__36393;
continue;
} else {
}
break;
}

var argseq__7288__auto__ = ((((1) < args__7287__auto__.length))?(new cljs.core.IndexedSeq(args__7287__auto__.slice((1)),(0),null)):null);
return hatti.views.table.all_fields.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7288__auto__);
});

hatti.views.table.all_fields.cljs$core$IFn$_invoke$arity$variadic = (function (form,p__36388){
var map__36389 = p__36388;
var map__36389__$1 = ((((!((map__36389 == null)))?((((map__36389.cljs$lang$protocol_mask$partition0$ & (64))) || (map__36389.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__36389):map__36389);
var is_filtered_dataview_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36389__$1,cljs.core.cst$kw$is_DASH_filtered_DASH_dataview_QMARK_);
return cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.has_data_QMARK_,cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic(hatti.views.table.get_extra_fields(is_filtered_dataview_QMARK_),hatti.ona.forms.non_meta_fields(form),cljs.core.array_seq([hatti.ona.forms.meta_fields.cljs$core$IFn$_invoke$arity$variadic(form,cljs.core.array_seq([cljs.core.cst$kw$with_DASH_submission_DASH_details_QMARK_,cljs.core.not(is_filtered_dataview_QMARK_)], 0))], 0))));
});

hatti.views.table.all_fields.cljs$lang$maxFixedArity = (1);

hatti.views.table.all_fields.cljs$lang$applyTo = (function (seq36386){
var G__36387 = cljs.core.first(seq36386);
var seq36386__$1 = cljs.core.next(seq36386);
return hatti.views.table.all_fields.cljs$core$IFn$_invoke$arity$variadic(G__36387,seq36386__$1);
});
/**
 * Comparator function for the slickgrid dataview.
 * args.sortCol is the column being sorted, a and b are rows to compare.
 * Claims a is bigger (return 1) if value for a > b, or a is null / empty.
 */
hatti.views.table.compfn = (function hatti$views$table$compfn(args){
return (function (a,b){
var col = (args["sortCol"]);
var lower = ((function (col){
return (function (p1__36394_SHARP_){
if(typeof p1__36394_SHARP_ === 'string'){
return clojure.string.lower_case(p1__36394_SHARP_);
} else {
return p1__36394_SHARP_;
}
});})(col))
;
var aval = lower((a[(col["field"])]));
var bval = lower((b[(col["field"])]));
if(((aval == null)) || ((aval > bval))){
return (1);
} else {
return (-1);
}
});
});
/**
 * Filter function for the slickgrid dataview, use as (partial filterfn form)
 * item is the row, args contains query.
 * Return value of false corresponds with exclusion, true with inclusion.
 */
hatti.views.table.filterfn = (function hatti$views$table$filterfn(form,item,args){
if(cljs.core.not(args)){
return true;
} else {
var indexed_form = cljs.core.zipmap(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$full_DASH_name,form),form);
var query = (args["query"]);
var fmt_subitem = ((function (indexed_form,query){
return (function (p__36398){
var vec__36399 = p__36398;
var fname = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36399,(0),null);
var answer = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36399,(1),null);
return hatti.ona.forms.format_answer.cljs$core$IFn$_invoke$arity$4(cljs.core.get.cljs$core$IFn$_invoke$arity$2(indexed_form,fname),answer,null,true);
});})(indexed_form,query))
;
var filtered = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (indexed_form,query,fmt_subitem){
return (function (p1__36395_SHARP_){
return cljs.core.re_find(chimera.js_interop.safe_regex(query),[cljs.core.str(p1__36395_SHARP_)].join(''));
});})(indexed_form,query,fmt_subitem))
,cljs.core.map.cljs$core$IFn$_invoke$arity$2(fmt_subitem,cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$1(item))));
return cljs.core.seq(filtered);
}
});
/**
 * Formatter for slickgrid columns takes row,cell,value,columnDef,dataContext.
 * Get one with (partial formatter field language).
 */
hatti.views.table.formatter = (function hatti$views$table$formatter(field,language,row,cell,value,columnDef,dataContext){
var clj_value = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(value,cljs.core.array_seq([cljs.core.cst$kw$keywordize_DASH_keys,true], 0));
return hatti.ona.forms.format_answer.cljs$core$IFn$_invoke$arity$4(field,clj_value,language,true);
});
hatti.views.action_buttons.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (owner){
return (function (row,cell,value,columnDef,dataContext){
var map__36400 = cljs.core.cst$kw$dataset_DASH_info.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.shared.app_state) : cljs.core.deref.call(null,hatti.shared.app_state)));
var map__36400__$1 = ((((!((map__36400 == null)))?((((map__36400.cljs$lang$protocol_mask$partition0$ & (64))) || (map__36400.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__36400):map__36400);
var owner__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36400__$1,cljs.core.cst$kw$owner);
var project = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36400__$1,cljs.core.cst$kw$project);
var formid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36400__$1,cljs.core.cst$kw$formid);
var form_owner = chimera.urls.last_url_param(owner__$1);
var project_id = chimera.urls.last_url_param(project);
var edit_link = chimera.urls.url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([form_owner,project_id,formid,[cljs.core.str("webform?instance-id="),cljs.core.str(value)].join('')], 0));
return hatti.utils.generate_html.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([(cljs.core.truth_(value)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$ul,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li$tooltip,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$tip_DASH_info$right,"View"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a$view_DASH_record,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$i$fa$fa_DASH_clone,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$data_DASH_id,value], null)], null)], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li$tooltip,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$tip_DASH_info$right,"Edit"], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a$edit_DASH_record,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$data_DASH_id,value,cljs.core.cst$kw$target,"_blank",cljs.core.cst$kw$href,edit_link], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$i$fa$fa_DASH_pencil_DASH_square_DASH_o], null)], null)], null)], null):null)], 0));
});
}));
/**
 * The html needed for a column name as a string.
 * String, String, Bool -> String
 */
hatti.views.table.column_name_html_string = (function hatti$views$table$column_name_html_string(column_class,label,hxl){
return [cljs.core.str("<div class=\""),cljs.core.str(column_class),cljs.core.str("\">"),cljs.core.str(label),cljs.core.str("</div>"),cljs.core.str((cljs.core.truth_(hxl)?[cljs.core.str("<div class=\"hxl-row\">"),cljs.core.str(hxl),cljs.core.str("</div>")].join(''):null))].join('');
});
hatti.views.table.actions_column = (function hatti$views$table$actions_column(owner,has_hxl_QMARK_){
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$headerCssClass,cljs.core.cst$kw$maxWidth,cljs.core.cst$kw$name,cljs.core.cst$kw$formatter,cljs.core.cst$kw$field,cljs.core.cst$kw$type,cljs.core.cst$kw$id,cljs.core.cst$kw$sortable,cljs.core.cst$kw$cssClass,cljs.core.cst$kw$toolTip],[[cljs.core.str((cljs.core.truth_(has_hxl_QMARK_)?"hxl-min-height ":null)),cljs.core.str("record-actions header")].join(''),(70),"",(hatti.views.action_buttons.cljs$core$IFn$_invoke$arity$1 ? hatti.views.action_buttons.cljs$core$IFn$_invoke$arity$1(owner) : hatti.views.action_buttons.call(null,owner)),hatti.constants._id,"text","actions",false,"record-actions",""]);
});
/**
 * Get a set of slick grid column objects when given a flat form.
 */
hatti.views.table.flat_form__GT_sg_columns = (function hatti$views$table$flat_form__GT_sg_columns(var_args){
var args36403 = [];
var len__7280__auto___36437 = arguments.length;
var i__7281__auto___36438 = (0);
while(true){
if((i__7281__auto___36438 < len__7280__auto___36437)){
args36403.push((arguments[i__7281__auto___36438]));

var G__36439 = (i__7281__auto___36438 + (1));
i__7281__auto___36438 = G__36439;
continue;
} else {
}
break;
}

var G__36409 = args36403.length;
switch (G__36409) {
case 1:
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__7299__auto__ = (new cljs.core.IndexedSeq(args36403.slice((3)),(0),null));
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7299__auto__);

}
});

hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$1 = (function (form){
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$2(form,true);
});

hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$2 = (function (form,get_label_QMARK_){
return hatti.views.table.flat_form__GT_sg_columns(form,get_label_QMARK_,null);
});

hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic = (function (form,get_label_QMARK_,language,p__36410){
var map__36411 = p__36410;
var map__36411__$1 = ((((!((map__36411 == null)))?((((map__36411.cljs$lang$protocol_mask$partition0$ & (64))) || (map__36411.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__36411):map__36411);
var is_filtered_dataview_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36411__$1,cljs.core.cst$kw$is_DASH_filtered_DASH_dataview_QMARK_);
var owner = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36411__$1,cljs.core.cst$kw$owner);
var has_hxl_QMARK_ = (function (){var G__36413 = cljs.core.false_QMARK_;
var G__36414 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (G__36413,map__36411,map__36411__$1,is_filtered_dataview_QMARK_,owner){
return (function (p1__36402_SHARP_){
return (cljs.core.cst$kw$hxl.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$instance.cljs$core$IFn$_invoke$arity$1(p1__36402_SHARP_)) == null);
});})(G__36413,map__36411,map__36411__$1,is_filtered_dataview_QMARK_,owner))
,form);
return (chimera.core.any_QMARK_.cljs$core$IFn$_invoke$arity$2 ? chimera.core.any_QMARK_.cljs$core$IFn$_invoke$arity$2(G__36413,G__36414) : chimera.core.any_QMARK_.call(null,G__36413,G__36414));
})();
var columns = (function (){var iter__6990__auto__ = ((function (has_hxl_QMARK_,map__36411,map__36411__$1,is_filtered_dataview_QMARK_,owner){
return (function hatti$views$table$iter__36415(s__36416){
return (new cljs.core.LazySeq(null,((function (has_hxl_QMARK_,map__36411,map__36411__$1,is_filtered_dataview_QMARK_,owner){
return (function (){
var s__36416__$1 = s__36416;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__36416__$1);
if(temp__4657__auto__){
var s__36416__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__36416__$2)){
var c__6988__auto__ = cljs.core.chunk_first(s__36416__$2);
var size__6989__auto__ = cljs.core.count(c__6988__auto__);
var b__36418 = cljs.core.chunk_buffer(size__6989__auto__);
if((function (){var i__36417 = (0);
while(true){
if((i__36417 < size__6989__auto__)){
var field = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__6988__auto__,i__36417);
cljs.core.chunk_append(b__36418,(function (){var map__36429 = field;
var map__36429__$1 = ((((!((map__36429 == null)))?((((map__36429.cljs$lang$protocol_mask$partition0$ & (64))) || (map__36429.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__36429):map__36429);
var map__36430 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36429__$1,cljs.core.cst$kw$instance);
var map__36430__$1 = ((((!((map__36430 == null)))?((((map__36430.cljs$lang$protocol_mask$partition0$ & (64))) || (map__36430.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__36430):map__36430);
var hxl = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36430__$1,cljs.core.cst$kw$hxl);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36429__$1,cljs.core.cst$kw$name);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36429__$1,cljs.core.cst$kw$type);
var full_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36429__$1,cljs.core.cst$kw$full_DASH_name);
var label = (cljs.core.truth_(get_label_QMARK_)?hatti.ona.forms.get_label.cljs$core$IFn$_invoke$arity$variadic(field,cljs.core.array_seq([language], 0)):name);
var column_class = hatti.ona.forms.get_column_class(field);
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$hxl,cljs.core.cst$kw$headerCssClass,cljs.core.cst$kw$name,cljs.core.cst$kw$formatter,cljs.core.cst$kw$minWidth,cljs.core.cst$kw$field,cljs.core.cst$kw$type,cljs.core.cst$kw$id,cljs.core.cst$kw$sortable,cljs.core.cst$kw$cssClass,cljs.core.cst$kw$toolTip],[hxl,(cljs.core.truth_(has_hxl_QMARK_)?"hxl-min-height":null),hatti.views.table.column_name_html_string(column_class,label,hxl),cljs.core.partial.cljs$core$IFn$_invoke$arity$3(hatti.views.table.formatter,field,language),(50),full_name,type,name,true,column_class,label]);
})());

var G__36441 = (i__36417 + (1));
i__36417 = G__36441;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__36418),hatti$views$table$iter__36415(cljs.core.chunk_rest(s__36416__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__36418),null);
}
} else {
var field = cljs.core.first(s__36416__$2);
return cljs.core.cons((function (){var map__36433 = field;
var map__36433__$1 = ((((!((map__36433 == null)))?((((map__36433.cljs$lang$protocol_mask$partition0$ & (64))) || (map__36433.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__36433):map__36433);
var map__36434 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36433__$1,cljs.core.cst$kw$instance);
var map__36434__$1 = ((((!((map__36434 == null)))?((((map__36434.cljs$lang$protocol_mask$partition0$ & (64))) || (map__36434.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__36434):map__36434);
var hxl = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36434__$1,cljs.core.cst$kw$hxl);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36433__$1,cljs.core.cst$kw$name);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36433__$1,cljs.core.cst$kw$type);
var full_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36433__$1,cljs.core.cst$kw$full_DASH_name);
var label = (cljs.core.truth_(get_label_QMARK_)?hatti.ona.forms.get_label.cljs$core$IFn$_invoke$arity$variadic(field,cljs.core.array_seq([language], 0)):name);
var column_class = hatti.ona.forms.get_column_class(field);
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$hxl,cljs.core.cst$kw$headerCssClass,cljs.core.cst$kw$name,cljs.core.cst$kw$formatter,cljs.core.cst$kw$minWidth,cljs.core.cst$kw$field,cljs.core.cst$kw$type,cljs.core.cst$kw$id,cljs.core.cst$kw$sortable,cljs.core.cst$kw$cssClass,cljs.core.cst$kw$toolTip],[hxl,(cljs.core.truth_(has_hxl_QMARK_)?"hxl-min-height":null),hatti.views.table.column_name_html_string(column_class,label,hxl),cljs.core.partial.cljs$core$IFn$_invoke$arity$3(hatti.views.table.formatter,field,language),(50),full_name,type,name,true,column_class,label]);
})(),hatti$views$table$iter__36415(cljs.core.rest(s__36416__$2)));
}
} else {
return null;
}
break;
}
});})(has_hxl_QMARK_,map__36411,map__36411__$1,is_filtered_dataview_QMARK_,owner))
,null,null));
});})(has_hxl_QMARK_,map__36411,map__36411__$1,is_filtered_dataview_QMARK_,owner))
;
return iter__6990__auto__(hatti.views.table.all_fields.cljs$core$IFn$_invoke$arity$variadic(form,cljs.core.array_seq([cljs.core.cst$kw$is_DASH_filtered_DASH_dataview_QMARK_,is_filtered_dataview_QMARK_], 0)));
})();
return cljs.core.clj__GT_js(cljs.core.conj.cljs$core$IFn$_invoke$arity$2(columns,hatti.views.table.actions_column(owner,has_hxl_QMARK_)));
});

hatti.views.table.flat_form__GT_sg_columns.cljs$lang$applyTo = (function (seq36404){
var G__36405 = cljs.core.first(seq36404);
var seq36404__$1 = cljs.core.next(seq36404);
var G__36406 = cljs.core.first(seq36404__$1);
var seq36404__$2 = cljs.core.next(seq36404__$1);
var G__36407 = cljs.core.first(seq36404__$2);
var seq36404__$3 = cljs.core.next(seq36404__$2);
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic(G__36405,G__36406,G__36407,seq36404__$3);
});

hatti.views.table.flat_form__GT_sg_columns.cljs$lang$maxFixedArity = (3);
hatti.views.table.init_sg_pager = (function hatti$views$table$init_sg_pager(grid,dataview){
var Pager = Slick.Controls.Pager;
return (new Pager(dataview,grid,(function (){var G__36443 = [cljs.core.str("#"),cljs.core.str(hatti.views.table.pager_id)].join('');
return jQuery(G__36443);
})()));
});
hatti.views.table.resizeColumns = (function hatti$views$table$resizeColumns(grid){
return grid.registerPlugin(Slick.AutoColumnSize());
});
/**
 * Options to feed the slickgrid constructor.
 */
hatti.views.table.sg_options = {"autoHeight": true, "enableColumnReorder": false, "enableTextSelectionOnCells": true, "rowHeight": (40), "syncColumnCellResize": false};
/**
 * Fixes the first column on slick table on horizontal scroll
 */
hatti.views.table.freeze_action_column_BANG_ = (function hatti$views$table$freeze_action_column_BANG_(){
var actions = document.getElementsByClassName("record-actions");
var sg_viewport = cljs.core.first(document.getElementsByClassName("slick-viewport"));
var seq__36451 = cljs.core.seq(actions);
var chunk__36452 = null;
var count__36453 = (0);
var i__36454 = (0);
while(true){
if((i__36454 < count__36453)){
var action = chunk__36452.cljs$core$IIndexed$_nth$arity$2(null,i__36454);
var leftOffset_36457 = (function (){var G__36455 = action.offsetLeft;
return parseInt(G__36455);
})();
sg_viewport.addEventListener("scroll",((function (seq__36451,chunk__36452,count__36453,i__36454,leftOffset_36457,action,actions,sg_viewport){
return (function (){
var sl = sg_viewport.scrollLeft;
var set_border_BANG_ = ((function (seq__36451,chunk__36452,count__36453,i__36454,sl,leftOffset_36457,action,actions,sg_viewport){
return (function (p1__36444_SHARP_){
return action.style.borderRight = p1__36444_SHARP_;
});})(seq__36451,chunk__36452,count__36453,i__36454,sl,leftOffset_36457,action,actions,sg_viewport))
;
if((sl === (0))){
set_border_BANG_("1px dotted #ededed");
} else {
set_border_BANG_("1px solid silver");
}

return action.style.left = [cljs.core.str((sl + leftOffset_36457)),cljs.core.str("px")].join('');
});})(seq__36451,chunk__36452,count__36453,i__36454,leftOffset_36457,action,actions,sg_viewport))
);

var G__36458 = seq__36451;
var G__36459 = chunk__36452;
var G__36460 = count__36453;
var G__36461 = (i__36454 + (1));
seq__36451 = G__36458;
chunk__36452 = G__36459;
count__36453 = G__36460;
i__36454 = G__36461;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq(seq__36451);
if(temp__4657__auto__){
var seq__36451__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__36451__$1)){
var c__7021__auto__ = cljs.core.chunk_first(seq__36451__$1);
var G__36462 = cljs.core.chunk_rest(seq__36451__$1);
var G__36463 = c__7021__auto__;
var G__36464 = cljs.core.count(c__7021__auto__);
var G__36465 = (0);
seq__36451 = G__36462;
chunk__36452 = G__36463;
count__36453 = G__36464;
i__36454 = G__36465;
continue;
} else {
var action = cljs.core.first(seq__36451__$1);
var leftOffset_36466 = (function (){var G__36456 = action.offsetLeft;
return parseInt(G__36456);
})();
sg_viewport.addEventListener("scroll",((function (seq__36451,chunk__36452,count__36453,i__36454,leftOffset_36466,action,seq__36451__$1,temp__4657__auto__,actions,sg_viewport){
return (function (){
var sl = sg_viewport.scrollLeft;
var set_border_BANG_ = ((function (seq__36451,chunk__36452,count__36453,i__36454,sl,leftOffset_36466,action,seq__36451__$1,temp__4657__auto__,actions,sg_viewport){
return (function (p1__36444_SHARP_){
return action.style.borderRight = p1__36444_SHARP_;
});})(seq__36451,chunk__36452,count__36453,i__36454,sl,leftOffset_36466,action,seq__36451__$1,temp__4657__auto__,actions,sg_viewport))
;
if((sl === (0))){
set_border_BANG_("1px dotted #ededed");
} else {
set_border_BANG_("1px solid silver");
}

return action.style.left = [cljs.core.str((sl + leftOffset_36466)),cljs.core.str("px")].join('');
});})(seq__36451,chunk__36452,count__36453,i__36454,leftOffset_36466,action,seq__36451__$1,temp__4657__auto__,actions,sg_viewport))
);

var G__36467 = cljs.core.next(seq__36451__$1);
var G__36468 = null;
var G__36469 = (0);
var G__36470 = (0);
seq__36451 = G__36467;
chunk__36452 = G__36468;
count__36453 = G__36469;
i__36454 = G__36470;
continue;
}
} else {
return null;
}
}
break;
}
});
hatti.views.table.bind_external_sg_grid_event_handlers = (function hatti$views$table$bind_external_sg_grid_event_handlers(grid,event_handlers){
return cljs.core.doall.cljs$core$IFn$_invoke$arity$1((function (){var iter__6990__auto__ = (function hatti$views$table$bind_external_sg_grid_event_handlers_$_iter__36481(s__36482){
return (new cljs.core.LazySeq(null,(function (){
var s__36482__$1 = s__36482;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__36482__$1);
if(temp__4657__auto__){
var s__36482__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__36482__$2)){
var c__6988__auto__ = cljs.core.chunk_first(s__36482__$2);
var size__6989__auto__ = cljs.core.count(c__6988__auto__);
var b__36484 = cljs.core.chunk_buffer(size__6989__auto__);
if((function (){var i__36483 = (0);
while(true){
if((i__36483 < size__6989__auto__)){
var vec__36489 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__6988__auto__,i__36483);
var handler_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36489,(0),null);
var handler_function = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36489,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case(cljs.core.name(handler_key));
var event = (grid[handler_name]);
cljs.core.chunk_append(b__36484,event.subscribe(handler_function));

var G__36491 = (i__36483 + (1));
i__36483 = G__36491;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__36484),hatti$views$table$bind_external_sg_grid_event_handlers_$_iter__36481(cljs.core.chunk_rest(s__36482__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__36484),null);
}
} else {
var vec__36490 = cljs.core.first(s__36482__$2);
var handler_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36490,(0),null);
var handler_function = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36490,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case(cljs.core.name(handler_key));
var event = (grid[handler_name]);
return cljs.core.cons(event.subscribe(handler_function),hatti$views$table$bind_external_sg_grid_event_handlers_$_iter__36481(cljs.core.rest(s__36482__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__6990__auto__(event_handlers);
})());
});
hatti.views.table.bind_external_sg_grid_dataview_handlers = (function hatti$views$table$bind_external_sg_grid_dataview_handlers(dataview,event_handlers){
return cljs.core.doall.cljs$core$IFn$_invoke$arity$1((function (){var iter__6990__auto__ = (function hatti$views$table$bind_external_sg_grid_dataview_handlers_$_iter__36502(s__36503){
return (new cljs.core.LazySeq(null,(function (){
var s__36503__$1 = s__36503;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__36503__$1);
if(temp__4657__auto__){
var s__36503__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__36503__$2)){
var c__6988__auto__ = cljs.core.chunk_first(s__36503__$2);
var size__6989__auto__ = cljs.core.count(c__6988__auto__);
var b__36505 = cljs.core.chunk_buffer(size__6989__auto__);
if((function (){var i__36504 = (0);
while(true){
if((i__36504 < size__6989__auto__)){
var vec__36510 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__6988__auto__,i__36504);
var handler_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36510,(0),null);
var handler_function = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36510,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case(cljs.core.name(handler_key));
var event = (dataview[handler_name]);
cljs.core.chunk_append(b__36505,event.subscribe(handler_function));

var G__36512 = (i__36504 + (1));
i__36504 = G__36512;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__36505),hatti$views$table$bind_external_sg_grid_dataview_handlers_$_iter__36502(cljs.core.chunk_rest(s__36503__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__36505),null);
}
} else {
var vec__36511 = cljs.core.first(s__36503__$2);
var handler_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36511,(0),null);
var handler_function = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36511,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case(cljs.core.name(handler_key));
var event = (dataview[handler_name]);
return cljs.core.cons(event.subscribe(handler_function),hatti$views$table$bind_external_sg_grid_dataview_handlers_$_iter__36502(cljs.core.rest(s__36503__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__6990__auto__(event_handlers);
})());
});
/**
 * Creates a Slick.Grid backed by Slick.Data.DataView from data and fields.
 * Most events are handled by slickgrid. On double-click, event is put on chan.
 * Returns [grid dataview].
 */
hatti.views.table.sg_init = (function hatti$views$table$sg_init(data,form,current_language,is_filtered_dataview_QMARK_,owner,p__36513){
var map__36523 = p__36513;
var map__36523__$1 = ((((!((map__36523 == null)))?((((map__36523.cljs$lang$protocol_mask$partition0$ & (64))) || (map__36523.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__36523):map__36523);
var grid_event_handlers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36523__$1,cljs.core.cst$kw$grid_DASH_event_DASH_handlers);
var dataview_event_handlers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36523__$1,cljs.core.cst$kw$dataview_DASH_event_DASH_handlers);
var columns = hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic(form,true,current_language,cljs.core.array_seq([cljs.core.cst$kw$is_DASH_filtered_DASH_dataview_QMARK_,is_filtered_dataview_QMARK_,cljs.core.cst$kw$owner,owner], 0));
var SlickGrid = Slick.Grid;
var DataView = Slick.Data.DataView;
var dataview = (new DataView());
var grid = (new SlickGrid([cljs.core.str("#"),cljs.core.str(hatti.views.table.table_id)].join(''),dataview,columns,hatti.views.table.sg_options));
var map__36525 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.shared.app_state) : cljs.core.deref.call(null,hatti.shared.app_state));
var map__36525__$1 = ((((!((map__36525 == null)))?((((map__36525.cljs$lang$protocol_mask$partition0$ & (64))) || (map__36525.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__36525):map__36525);
var map__36526 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36525__$1,cljs.core.cst$kw$table_DASH_page);
var map__36526__$1 = ((((!((map__36526 == null)))?((((map__36526.cljs$lang$protocol_mask$partition0$ & (64))) || (map__36526.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__36526):map__36526);
var map__36527 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36526__$1,cljs.core.cst$kw$paging);
var map__36527__$1 = ((((!((map__36527 == null)))?((((map__36527.cljs$lang$protocol_mask$partition0$ & (64))) || (map__36527.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__36527):map__36527);
var num_displayed_records = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36527__$1,cljs.core.cst$kw$num_DASH_displayed_DASH_records);
var total_page_count = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36527__$1,cljs.core.cst$kw$total_DASH_page_DASH_count);
hatti.views.table.bind_external_sg_grid_event_handlers(grid,grid_event_handlers);

hatti.views.table.bind_external_sg_grid_dataview_handlers(dataview,dataview_event_handlers);

dataview.onRowCountChanged.subscribe(((function (columns,SlickGrid,DataView,dataview,grid,map__36525,map__36525__$1,map__36526,map__36526__$1,map__36527,map__36527__$1,num_displayed_records,total_page_count,map__36523,map__36523__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
grid.updateRowCount();

return grid.render();
});})(columns,SlickGrid,DataView,dataview,grid,map__36525,map__36525__$1,map__36526,map__36526__$1,map__36527,map__36527__$1,num_displayed_records,total_page_count,map__36523,map__36523__$1,grid_event_handlers,dataview_event_handlers))
);

dataview.onRowsChanged.subscribe(((function (columns,SlickGrid,DataView,dataview,grid,map__36525,map__36525__$1,map__36526,map__36526__$1,map__36527,map__36527__$1,num_displayed_records,total_page_count,map__36523,map__36523__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
grid.invalidateRows((args["rows"]));

return grid.render();
});})(columns,SlickGrid,DataView,dataview,grid,map__36525,map__36525__$1,map__36526,map__36526__$1,map__36527,map__36527__$1,num_displayed_records,total_page_count,map__36523,map__36523__$1,grid_event_handlers,dataview_event_handlers))
);

grid.onDblClick.subscribe(((function (columns,SlickGrid,DataView,dataview,grid,map__36525,map__36525__$1,map__36526,map__36526__$1,map__36527,map__36527__$1,num_displayed_records,total_page_count,map__36523,map__36523__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
var rank = (dataview.getItem((args["row"]))[hatti.constants._rank]);
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$submission_DASH_to_DASH_rank,rank], null));
});})(columns,SlickGrid,DataView,dataview,grid,map__36525,map__36525__$1,map__36526,map__36526__$1,map__36527,map__36527__$1,num_displayed_records,total_page_count,map__36523,map__36523__$1,grid_event_handlers,dataview_event_handlers))
);

grid.onClick.subscribe(((function (columns,SlickGrid,DataView,dataview,grid,map__36525,map__36525__$1,map__36526,map__36526__$1,map__36527,map__36527__$1,num_displayed_records,total_page_count,map__36523,map__36523__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
var elem = e.target;
var row = dataview.getItem((args["row"]));
var elem_data_id = elem.getAttribute("data-id");
var data_id = (cljs.core.truth_(elem_data_id)?(function (){var G__36531 = elem.getAttribute("data-id");
return parseInt(G__36531);
})():null);
var id = (row[hatti.constants._id]);
var rank = (row[hatti.constants._rank]);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(id,data_id)){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$submission_DASH_to_DASH_rank,rank], null));
} else {
return null;
}
});})(columns,SlickGrid,DataView,dataview,grid,map__36525,map__36525__$1,map__36526,map__36526__$1,map__36527,map__36527__$1,num_displayed_records,total_page_count,map__36523,map__36523__$1,grid_event_handlers,dataview_event_handlers))
);

hatti.views.table.init_sg_pager(grid,dataview);

dataview.setPagingOptions({"pageSize": (function (){var or__6210__auto__ = num_displayed_records;
if(cljs.core.truth_(or__6210__auto__)){
return or__6210__auto__;
} else {
return hatti.views.table.default_num_displayed_records;
}
})(), "totalPages": total_page_count});

dataview.setFilter(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(hatti.views.table.filterfn,form));

dataview.setItems(cljs.core.clj__GT_js(data),hatti.constants._id);

hatti.views.table.resizeColumns(grid);

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [grid,dataview], null);
});
/**
 * Event loop for the table view. Processes a tap of share/event-chan,
 * and updates app-state/dataview/grid as needed.
 */
hatti.views.table.handle_table_events = (function hatti$views$table$handle_table_events(app_state,grid,dataview){
var event_chan = hatti.shared.event_tap();
var c__11856__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11856__auto__,event_chan){
return (function (){
var f__11857__auto__ = (function (){var switch__11791__auto__ = ((function (c__11856__auto__,event_chan){
return (function (state_36793){
var state_val_36794 = (state_36793[(1)]);
if((state_val_36794 === (7))){
var inst_36702 = (state_36793[(7)]);
var inst_36702__$1 = (state_36793[(2)]);
var inst_36704 = (inst_36702__$1 == null);
var inst_36705 = cljs.core.not(inst_36704);
var state_36793__$1 = (function (){var statearr_36795 = state_36793;
(statearr_36795[(7)] = inst_36702__$1);

return statearr_36795;
})();
if(inst_36705){
var statearr_36796_36863 = state_36793__$1;
(statearr_36796_36863[(1)] = (8));

} else {
var statearr_36797_36864 = state_36793__$1;
(statearr_36797_36864[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36794 === (20))){
var inst_36732 = (state_36793[(8)]);
var inst_36724 = (state_36793[(9)]);
var inst_36741 = (inst_36732.cljs$core$IFn$_invoke$arity$1 ? inst_36732.cljs$core$IFn$_invoke$arity$1(inst_36724) : inst_36732.call(null,inst_36724));
var state_36793__$1 = state_36793;
var statearr_36798_36865 = state_36793__$1;
(statearr_36798_36865[(2)] = inst_36741);

(statearr_36798_36865[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36794 === (27))){
var state_36793__$1 = state_36793;
var statearr_36799_36866 = state_36793__$1;
(statearr_36799_36866[(2)] = null);

(statearr_36799_36866[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36794 === (1))){
var state_36793__$1 = state_36793;
var statearr_36800_36867 = state_36793__$1;
(statearr_36800_36867[(2)] = null);

(statearr_36800_36867[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36794 === (24))){
var state_36793__$1 = state_36793;
var statearr_36801_36868 = state_36793__$1;
(statearr_36801_36868[(2)] = null);

(statearr_36801_36868[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36794 === (4))){
var state_36793__$1 = state_36793;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36793__$1,(7),event_chan);
} else {
if((state_val_36794 === (15))){
var inst_36702 = (state_36793[(7)]);
var state_36793__$1 = state_36793;
var statearr_36802_36869 = state_36793__$1;
(statearr_36802_36869[(2)] = inst_36702);

(statearr_36802_36869[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36794 === (21))){
var state_36793__$1 = state_36793;
var statearr_36803_36870 = state_36793__$1;
(statearr_36803_36870[(2)] = null);

(statearr_36803_36870[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36794 === (31))){
var inst_36728 = (state_36793[(10)]);
var inst_36766 = (state_36793[(2)]);
var inst_36767 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_36728,cljs.core.cst$kw$table);
var state_36793__$1 = (function (){var statearr_36804 = state_36793;
(statearr_36804[(11)] = inst_36766);

return statearr_36804;
})();
if(inst_36767){
var statearr_36805_36871 = state_36793__$1;
(statearr_36805_36871[(1)] = (32));

} else {
var statearr_36806_36872 = state_36793__$1;
(statearr_36806_36872[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36794 === (32))){
var inst_36727 = (state_36793[(12)]);
var inst_36725 = (state_36793[(13)]);
var inst_36722 = (state_36793[(14)]);
var inst_36726 = (state_36793[(15)]);
var inst_36702 = (state_36793[(7)]);
var inst_36732 = (state_36793[(8)]);
var inst_36723 = (state_36793[(16)]);
var inst_36728 = (state_36793[(10)]);
var inst_36724 = (state_36793[(9)]);
var inst_36733 = (state_36793[(17)]);
var inst_36780 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_36781 = (function (){var new_columns = inst_36727;
var submission_clicked = inst_36724;
var submission_unclicked = inst_36725;
var map__36700 = inst_36722;
var get_submission_data = inst_36733;
var c__11856__auto____$1 = inst_36780;
var re_render = inst_36728;
var update_data_BANG_ = inst_36732;
var submission_to_rank = inst_36723;
var e = inst_36702;
var filter_by = inst_36726;
return ((function (new_columns,submission_clicked,submission_unclicked,map__36700,get_submission_data,c__11856__auto____$1,re_render,update_data_BANG_,submission_to_rank,e,filter_by,inst_36727,inst_36725,inst_36722,inst_36726,inst_36702,inst_36732,inst_36723,inst_36728,inst_36724,inst_36733,inst_36780,state_val_36794,c__11856__auto__,event_chan){
return (function (){
var f__11857__auto__ = (function (){var switch__11791__auto__ = ((function (new_columns,submission_clicked,submission_unclicked,map__36700,get_submission_data,c__11856__auto____$1,re_render,update_data_BANG_,submission_to_rank,e,filter_by,inst_36727,inst_36725,inst_36722,inst_36726,inst_36702,inst_36732,inst_36723,inst_36728,inst_36724,inst_36733,inst_36780,state_val_36794,c__11856__auto__,event_chan){
return (function (state_36778){
var state_val_36779 = (state_36778[(1)]);
if((state_val_36779 === (1))){
var inst_36769 = cljs.core.async.timeout((20));
var state_36778__$1 = state_36778;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36778__$1,(2),inst_36769);
} else {
if((state_val_36779 === (2))){
var inst_36771 = (state_36778[(2)]);
var inst_36772 = grid.resizeCanvas();
var inst_36773 = grid.invalidateAllRows();
var inst_36774 = hatti.views.table.resizeColumns(grid);
var inst_36775 = grid.render();
var inst_36776 = hatti.views.table.init_sg_pager(grid,dataview);
var state_36778__$1 = (function (){var statearr_36807 = state_36778;
(statearr_36807[(7)] = inst_36772);

(statearr_36807[(8)] = inst_36773);

(statearr_36807[(9)] = inst_36771);

(statearr_36807[(10)] = inst_36774);

(statearr_36807[(11)] = inst_36775);

return statearr_36807;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_36778__$1,inst_36776);
} else {
return null;
}
}
});})(new_columns,submission_clicked,submission_unclicked,map__36700,get_submission_data,c__11856__auto____$1,re_render,update_data_BANG_,submission_to_rank,e,filter_by,inst_36727,inst_36725,inst_36722,inst_36726,inst_36702,inst_36732,inst_36723,inst_36728,inst_36724,inst_36733,inst_36780,state_val_36794,c__11856__auto__,event_chan))
;
return ((function (switch__11791__auto__,new_columns,submission_clicked,submission_unclicked,map__36700,get_submission_data,c__11856__auto____$1,re_render,update_data_BANG_,submission_to_rank,e,filter_by,inst_36727,inst_36725,inst_36722,inst_36726,inst_36702,inst_36732,inst_36723,inst_36728,inst_36724,inst_36733,inst_36780,state_val_36794,c__11856__auto__,event_chan){
return (function() {
var hatti$views$table$handle_table_events_$_state_machine__11792__auto__ = null;
var hatti$views$table$handle_table_events_$_state_machine__11792__auto____0 = (function (){
var statearr_36811 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_36811[(0)] = hatti$views$table$handle_table_events_$_state_machine__11792__auto__);

(statearr_36811[(1)] = (1));

return statearr_36811;
});
var hatti$views$table$handle_table_events_$_state_machine__11792__auto____1 = (function (state_36778){
while(true){
var ret_value__11793__auto__ = (function (){try{while(true){
var result__11794__auto__ = switch__11791__auto__(state_36778);
if(cljs.core.keyword_identical_QMARK_(result__11794__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__11794__auto__;
}
break;
}
}catch (e36812){if((e36812 instanceof Object)){
var ex__11795__auto__ = e36812;
var statearr_36813_36873 = state_36778;
(statearr_36813_36873[(5)] = ex__11795__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_36778);

return cljs.core.cst$kw$recur;
} else {
throw e36812;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11793__auto__,cljs.core.cst$kw$recur)){
var G__36874 = state_36778;
state_36778 = G__36874;
continue;
} else {
return ret_value__11793__auto__;
}
break;
}
});
hatti$views$table$handle_table_events_$_state_machine__11792__auto__ = function(state_36778){
switch(arguments.length){
case 0:
return hatti$views$table$handle_table_events_$_state_machine__11792__auto____0.call(this);
case 1:
return hatti$views$table$handle_table_events_$_state_machine__11792__auto____1.call(this,state_36778);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$handle_table_events_$_state_machine__11792__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$handle_table_events_$_state_machine__11792__auto____0;
hatti$views$table$handle_table_events_$_state_machine__11792__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$handle_table_events_$_state_machine__11792__auto____1;
return hatti$views$table$handle_table_events_$_state_machine__11792__auto__;
})()
;})(switch__11791__auto__,new_columns,submission_clicked,submission_unclicked,map__36700,get_submission_data,c__11856__auto____$1,re_render,update_data_BANG_,submission_to_rank,e,filter_by,inst_36727,inst_36725,inst_36722,inst_36726,inst_36702,inst_36732,inst_36723,inst_36728,inst_36724,inst_36733,inst_36780,state_val_36794,c__11856__auto__,event_chan))
})();
var state__11858__auto__ = (function (){var statearr_36814 = (f__11857__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11857__auto__.cljs$core$IFn$_invoke$arity$0() : f__11857__auto__.call(null));
(statearr_36814[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11856__auto____$1);

return statearr_36814;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11858__auto__);
});
;})(new_columns,submission_clicked,submission_unclicked,map__36700,get_submission_data,c__11856__auto____$1,re_render,update_data_BANG_,submission_to_rank,e,filter_by,inst_36727,inst_36725,inst_36722,inst_36726,inst_36702,inst_36732,inst_36723,inst_36728,inst_36724,inst_36733,inst_36780,state_val_36794,c__11856__auto__,event_chan))
})();
var inst_36782 = cljs.core.async.impl.dispatch.run(inst_36781);
var state_36793__$1 = (function (){var statearr_36815 = state_36793;
(statearr_36815[(18)] = inst_36782);

return statearr_36815;
})();
var statearr_36816_36875 = state_36793__$1;
(statearr_36816_36875[(2)] = inst_36780);

(statearr_36816_36875[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36794 === (33))){
var state_36793__$1 = state_36793;
var statearr_36817_36876 = state_36793__$1;
(statearr_36817_36876[(2)] = null);

(statearr_36817_36876[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36794 === (13))){
var inst_36714 = (state_36793[(2)]);
var state_36793__$1 = state_36793;
var statearr_36818_36877 = state_36793__$1;
(statearr_36818_36877[(2)] = inst_36714);

(statearr_36818_36877[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36794 === (22))){
var inst_36725 = (state_36793[(13)]);
var inst_36744 = (state_36793[(2)]);
var state_36793__$1 = (function (){var statearr_36819 = state_36793;
(statearr_36819[(19)] = inst_36744);

return statearr_36819;
})();
if(cljs.core.truth_(inst_36725)){
var statearr_36820_36878 = state_36793__$1;
(statearr_36820_36878[(1)] = (23));

} else {
var statearr_36821_36879 = state_36793__$1;
(statearr_36821_36879[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36794 === (29))){
var inst_36726 = (state_36793[(15)]);
var inst_36758 = [cljs.core.cst$kw$query];
var inst_36759 = [inst_36726];
var inst_36760 = cljs.core.PersistentHashMap.fromArrays(inst_36758,inst_36759);
var inst_36761 = cljs.core.clj__GT_js(inst_36760);
var inst_36762 = dataview.setFilterArgs(inst_36761);
var inst_36763 = dataview.refresh();
var state_36793__$1 = (function (){var statearr_36822 = state_36793;
(statearr_36822[(20)] = inst_36762);

return statearr_36822;
})();
var statearr_36823_36880 = state_36793__$1;
(statearr_36823_36880[(2)] = inst_36763);

(statearr_36823_36880[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36794 === (6))){
var inst_36789 = (state_36793[(2)]);
var state_36793__$1 = state_36793;
var statearr_36824_36881 = state_36793__$1;
(statearr_36824_36881[(2)] = inst_36789);

(statearr_36824_36881[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36794 === (28))){
var inst_36726 = (state_36793[(15)]);
var inst_36756 = (state_36793[(2)]);
var state_36793__$1 = (function (){var statearr_36825 = state_36793;
(statearr_36825[(21)] = inst_36756);

return statearr_36825;
})();
if(cljs.core.truth_(inst_36726)){
var statearr_36826_36882 = state_36793__$1;
(statearr_36826_36882[(1)] = (29));

} else {
var statearr_36827_36883 = state_36793__$1;
(statearr_36827_36883[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36794 === (25))){
var inst_36727 = (state_36793[(12)]);
var inst_36749 = (state_36793[(2)]);
var state_36793__$1 = (function (){var statearr_36828 = state_36793;
(statearr_36828[(22)] = inst_36749);

return statearr_36828;
})();
if(cljs.core.truth_(inst_36727)){
var statearr_36829_36884 = state_36793__$1;
(statearr_36829_36884[(1)] = (26));

} else {
var statearr_36830_36885 = state_36793__$1;
(statearr_36830_36885[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36794 === (34))){
var inst_36785 = (state_36793[(2)]);
var state_36793__$1 = (function (){var statearr_36831 = state_36793;
(statearr_36831[(23)] = inst_36785);

return statearr_36831;
})();
var statearr_36832_36886 = state_36793__$1;
(statearr_36832_36886[(2)] = null);

(statearr_36832_36886[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36794 === (17))){
var inst_36732 = (state_36793[(8)]);
var inst_36723 = (state_36793[(16)]);
var inst_36733 = (state_36793[(17)]);
var inst_36735 = (inst_36733.cljs$core$IFn$_invoke$arity$2 ? inst_36733.cljs$core$IFn$_invoke$arity$2(hatti.constants._rank,inst_36723) : inst_36733.call(null,hatti.constants._rank,inst_36723));
var inst_36736 = (inst_36732.cljs$core$IFn$_invoke$arity$1 ? inst_36732.cljs$core$IFn$_invoke$arity$1(inst_36735) : inst_36732.call(null,inst_36735));
var state_36793__$1 = state_36793;
var statearr_36833_36887 = state_36793__$1;
(statearr_36833_36887[(2)] = inst_36736);

(statearr_36833_36887[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36794 === (3))){
var inst_36791 = (state_36793[(2)]);
var state_36793__$1 = state_36793;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36793__$1,inst_36791);
} else {
if((state_val_36794 === (12))){
var state_36793__$1 = state_36793;
var statearr_36834_36888 = state_36793__$1;
(statearr_36834_36888[(2)] = false);

(statearr_36834_36888[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36794 === (2))){
var state_36793__$1 = state_36793;
var statearr_36835_36889 = state_36793__$1;
(statearr_36835_36889[(1)] = (4));



return cljs.core.cst$kw$recur;
} else {
if((state_val_36794 === (23))){
var inst_36732 = (state_36793[(8)]);
var inst_36746 = (inst_36732.cljs$core$IFn$_invoke$arity$1 ? inst_36732.cljs$core$IFn$_invoke$arity$1(null) : inst_36732.call(null,null));
var state_36793__$1 = state_36793;
var statearr_36837_36890 = state_36793__$1;
(statearr_36837_36890[(2)] = inst_36746);

(statearr_36837_36890[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36794 === (19))){
var inst_36724 = (state_36793[(9)]);
var inst_36739 = (state_36793[(2)]);
var state_36793__$1 = (function (){var statearr_36838 = state_36793;
(statearr_36838[(24)] = inst_36739);

return statearr_36838;
})();
if(cljs.core.truth_(inst_36724)){
var statearr_36839_36891 = state_36793__$1;
(statearr_36839_36891[(1)] = (20));

} else {
var statearr_36840_36892 = state_36793__$1;
(statearr_36840_36892[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36794 === (11))){
var state_36793__$1 = state_36793;
var statearr_36841_36893 = state_36793__$1;
(statearr_36841_36893[(2)] = true);

(statearr_36841_36893[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36794 === (9))){
var state_36793__$1 = state_36793;
var statearr_36842_36894 = state_36793__$1;
(statearr_36842_36894[(2)] = false);

(statearr_36842_36894[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36794 === (5))){
var state_36793__$1 = state_36793;
var statearr_36843_36895 = state_36793__$1;
(statearr_36843_36895[(2)] = null);

(statearr_36843_36895[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36794 === (14))){
var inst_36702 = (state_36793[(7)]);
var inst_36719 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_36702);
var state_36793__$1 = state_36793;
var statearr_36844_36896 = state_36793__$1;
(statearr_36844_36896[(2)] = inst_36719);

(statearr_36844_36896[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36794 === (26))){
var inst_36727 = (state_36793[(12)]);
var inst_36751 = grid.setColumns(inst_36727);
var inst_36752 = hatti.views.table.resizeColumns(grid);
var inst_36753 = grid.render();
var state_36793__$1 = (function (){var statearr_36845 = state_36793;
(statearr_36845[(25)] = inst_36751);

(statearr_36845[(26)] = inst_36752);

return statearr_36845;
})();
var statearr_36846_36897 = state_36793__$1;
(statearr_36846_36897[(2)] = inst_36753);

(statearr_36846_36897[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36794 === (16))){
var inst_36727 = (state_36793[(12)]);
var inst_36725 = (state_36793[(13)]);
var inst_36722 = (state_36793[(14)]);
var inst_36726 = (state_36793[(15)]);
var inst_36702 = (state_36793[(7)]);
var inst_36732 = (state_36793[(8)]);
var inst_36723 = (state_36793[(16)]);
var inst_36728 = (state_36793[(10)]);
var inst_36724 = (state_36793[(9)]);
var inst_36722__$1 = (state_36793[(2)]);
var inst_36723__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_36722__$1,cljs.core.cst$kw$submission_DASH_to_DASH_rank);
var inst_36724__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_36722__$1,cljs.core.cst$kw$submission_DASH_clicked);
var inst_36725__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_36722__$1,cljs.core.cst$kw$submission_DASH_unclicked);
var inst_36726__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_36722__$1,cljs.core.cst$kw$filter_DASH_by);
var inst_36727__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_36722__$1,cljs.core.cst$kw$new_DASH_columns);
var inst_36728__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_36722__$1,cljs.core.cst$kw$re_DASH_render);
var inst_36729 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36730 = [cljs.core.cst$kw$table_DASH_page,cljs.core.cst$kw$submission_DASH_clicked,cljs.core.cst$kw$data];
var inst_36731 = (new cljs.core.PersistentVector(null,3,(5),inst_36729,inst_36730,null));
var inst_36732__$1 = cljs.core.partial.cljs$core$IFn$_invoke$arity$3(om.core.update_BANG_,app_state,inst_36731);
var inst_36733 = (function (){var e = inst_36702;
var map__36700 = inst_36722__$1;
var submission_to_rank = inst_36723__$1;
var submission_clicked = inst_36724__$1;
var submission_unclicked = inst_36725__$1;
var filter_by = inst_36726__$1;
var new_columns = inst_36727__$1;
var re_render = inst_36728__$1;
var update_data_BANG_ = inst_36732__$1;
return ((function (e,map__36700,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_36727,inst_36725,inst_36722,inst_36726,inst_36702,inst_36732,inst_36723,inst_36728,inst_36724,inst_36722__$1,inst_36723__$1,inst_36724__$1,inst_36725__$1,inst_36726__$1,inst_36727__$1,inst_36728__$1,inst_36729,inst_36730,inst_36731,inst_36732__$1,state_val_36794,c__11856__auto__,event_chan){
return (function (field,value){
return cljs.core.first(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (e,map__36700,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_36727,inst_36725,inst_36722,inst_36726,inst_36702,inst_36732,inst_36723,inst_36728,inst_36724,inst_36722__$1,inst_36723__$1,inst_36724__$1,inst_36725__$1,inst_36726__$1,inst_36727__$1,inst_36728__$1,inst_36729,inst_36730,inst_36731,inst_36732__$1,state_val_36794,c__11856__auto__,event_chan){
return (function (p1__36532_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(value,cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__36532_SHARP_,field));
});})(e,map__36700,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_36727,inst_36725,inst_36722,inst_36726,inst_36702,inst_36732,inst_36723,inst_36728,inst_36724,inst_36722__$1,inst_36723__$1,inst_36724__$1,inst_36725__$1,inst_36726__$1,inst_36727__$1,inst_36728__$1,inst_36729,inst_36730,inst_36731,inst_36732__$1,state_val_36794,c__11856__auto__,event_chan))
,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(app_state) : cljs.core.deref.call(null,app_state)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data], null))));
});
;})(e,map__36700,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_36727,inst_36725,inst_36722,inst_36726,inst_36702,inst_36732,inst_36723,inst_36728,inst_36724,inst_36722__$1,inst_36723__$1,inst_36724__$1,inst_36725__$1,inst_36726__$1,inst_36727__$1,inst_36728__$1,inst_36729,inst_36730,inst_36731,inst_36732__$1,state_val_36794,c__11856__auto__,event_chan))
})();
var state_36793__$1 = (function (){var statearr_36847 = state_36793;
(statearr_36847[(12)] = inst_36727__$1);

(statearr_36847[(13)] = inst_36725__$1);

(statearr_36847[(14)] = inst_36722__$1);

(statearr_36847[(15)] = inst_36726__$1);

(statearr_36847[(8)] = inst_36732__$1);

(statearr_36847[(16)] = inst_36723__$1);

(statearr_36847[(10)] = inst_36728__$1);

(statearr_36847[(9)] = inst_36724__$1);

(statearr_36847[(17)] = inst_36733);

return statearr_36847;
})();
if(cljs.core.truth_(inst_36723__$1)){
var statearr_36848_36898 = state_36793__$1;
(statearr_36848_36898[(1)] = (17));

} else {
var statearr_36849_36899 = state_36793__$1;
(statearr_36849_36899[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36794 === (30))){
var state_36793__$1 = state_36793;
var statearr_36850_36900 = state_36793__$1;
(statearr_36850_36900[(2)] = null);

(statearr_36850_36900[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36794 === (10))){
var inst_36717 = (state_36793[(2)]);
var state_36793__$1 = state_36793;
if(cljs.core.truth_(inst_36717)){
var statearr_36851_36901 = state_36793__$1;
(statearr_36851_36901[(1)] = (14));

} else {
var statearr_36852_36902 = state_36793__$1;
(statearr_36852_36902[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36794 === (18))){
var state_36793__$1 = state_36793;
var statearr_36853_36903 = state_36793__$1;
(statearr_36853_36903[(2)] = null);

(statearr_36853_36903[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36794 === (8))){
var inst_36702 = (state_36793[(7)]);
var inst_36707 = inst_36702.cljs$lang$protocol_mask$partition0$;
var inst_36708 = (inst_36707 & (64));
var inst_36709 = inst_36702.cljs$core$ISeq$;
var inst_36710 = (inst_36708) || (inst_36709);
var state_36793__$1 = state_36793;
if(cljs.core.truth_(inst_36710)){
var statearr_36854_36904 = state_36793__$1;
(statearr_36854_36904[(1)] = (11));

} else {
var statearr_36855_36905 = state_36793__$1;
(statearr_36855_36905[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11856__auto__,event_chan))
;
return ((function (switch__11791__auto__,c__11856__auto__,event_chan){
return (function() {
var hatti$views$table$handle_table_events_$_state_machine__11792__auto__ = null;
var hatti$views$table$handle_table_events_$_state_machine__11792__auto____0 = (function (){
var statearr_36859 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_36859[(0)] = hatti$views$table$handle_table_events_$_state_machine__11792__auto__);

(statearr_36859[(1)] = (1));

return statearr_36859;
});
var hatti$views$table$handle_table_events_$_state_machine__11792__auto____1 = (function (state_36793){
while(true){
var ret_value__11793__auto__ = (function (){try{while(true){
var result__11794__auto__ = switch__11791__auto__(state_36793);
if(cljs.core.keyword_identical_QMARK_(result__11794__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__11794__auto__;
}
break;
}
}catch (e36860){if((e36860 instanceof Object)){
var ex__11795__auto__ = e36860;
var statearr_36861_36906 = state_36793;
(statearr_36861_36906[(5)] = ex__11795__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_36793);

return cljs.core.cst$kw$recur;
} else {
throw e36860;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11793__auto__,cljs.core.cst$kw$recur)){
var G__36907 = state_36793;
state_36793 = G__36907;
continue;
} else {
return ret_value__11793__auto__;
}
break;
}
});
hatti$views$table$handle_table_events_$_state_machine__11792__auto__ = function(state_36793){
switch(arguments.length){
case 0:
return hatti$views$table$handle_table_events_$_state_machine__11792__auto____0.call(this);
case 1:
return hatti$views$table$handle_table_events_$_state_machine__11792__auto____1.call(this,state_36793);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$handle_table_events_$_state_machine__11792__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$handle_table_events_$_state_machine__11792__auto____0;
hatti$views$table$handle_table_events_$_state_machine__11792__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$handle_table_events_$_state_machine__11792__auto____1;
return hatti$views$table$handle_table_events_$_state_machine__11792__auto__;
})()
;})(switch__11791__auto__,c__11856__auto__,event_chan))
})();
var state__11858__auto__ = (function (){var statearr_36862 = (f__11857__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11857__auto__.cljs$core$IFn$_invoke$arity$0() : f__11857__auto__.call(null));
(statearr_36862[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11856__auto__);

return statearr_36862;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11858__auto__);
});})(c__11856__auto__,event_chan))
);

return c__11856__auto__;
});
hatti.views.table.render_options = (function hatti$views$table$render_options(options,owner,colset_BANG_){
var choose_display_key = (function (k){
om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$name_DASH_or_DASH_label,k);

return (colset_BANG_.cljs$core$IFn$_invoke$arity$1 ? colset_BANG_.cljs$core$IFn$_invoke$arity$1(k) : colset_BANG_.call(null,k));
});
var iter__6990__auto__ = ((function (choose_display_key){
return (function hatti$views$table$render_options_$_iter__36918(s__36919){
return (new cljs.core.LazySeq(null,((function (choose_display_key){
return (function (){
var s__36919__$1 = s__36919;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__36919__$1);
if(temp__4657__auto__){
var s__36919__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__36919__$2)){
var c__6988__auto__ = cljs.core.chunk_first(s__36919__$2);
var size__6989__auto__ = cljs.core.count(c__6988__auto__);
var b__36921 = cljs.core.chunk_buffer(size__6989__auto__);
if((function (){var i__36920 = (0);
while(true){
if((i__36920 < size__6989__auto__)){
var vec__36926 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__6988__auto__,i__36920);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36926,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36926,(1),null);
cljs.core.chunk_append(b__36921,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$on_DASH_click,hatti.utils.click_fn(((function (i__36920,vec__36926,k,v,c__6988__auto__,size__6989__auto__,b__36921,s__36919__$2,temp__4657__auto__,choose_display_key){
return (function (){
return choose_display_key(k);
});})(i__36920,vec__36926,k,v,c__6988__auto__,size__6989__auto__,b__36921,s__36919__$2,temp__4657__auto__,choose_display_key))
),cljs.core.cst$kw$href,"#"], null),v], null)], null));

var G__36928 = (i__36920 + (1));
i__36920 = G__36928;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__36921),hatti$views$table$render_options_$_iter__36918(cljs.core.chunk_rest(s__36919__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__36921),null);
}
} else {
var vec__36927 = cljs.core.first(s__36919__$2);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36927,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36927,(1),null);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$on_DASH_click,hatti.utils.click_fn(((function (vec__36927,k,v,s__36919__$2,temp__4657__auto__,choose_display_key){
return (function (){
return choose_display_key(k);
});})(vec__36927,k,v,s__36919__$2,temp__4657__auto__,choose_display_key))
),cljs.core.cst$kw$href,"#"], null),v], null)], null),hatti$views$table$render_options_$_iter__36918(cljs.core.rest(s__36919__$2)));
}
} else {
return null;
}
break;
}
});})(choose_display_key))
,null,null));
});})(choose_display_key))
;
return iter__6990__auto__(options);
});
hatti.views.label_changer.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (_,owner){
if(typeof hatti.views.table.t_hatti$views$table36930 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRenderState}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IInitState}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table36930 = (function (_,owner,meta36931){
this._ = _;
this.owner = owner;
this.meta36931 = meta36931;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table36930.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_36932,meta36931__$1){
var self__ = this;
var _36932__$1 = this;
return (new hatti.views.table.t_hatti$views$table36930(self__._,self__.owner,meta36931__$1));
});

hatti.views.table.t_hatti$views$table36930.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_36932){
var self__ = this;
var _36932__$1 = this;
return self__.meta36931;
});

hatti.views.table.t_hatti$views$table36930.prototype.om$core$IInitState$ = true;

hatti.views.table.t_hatti$views$table36930.prototype.om$core$IInitState$init_state$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$name_DASH_or_DASH_label,cljs.core.cst$kw$label], null);
});

hatti.views.table.t_hatti$views$table36930.prototype.om$core$IRenderState$ = true;

hatti.views.table.t_hatti$views$table36930.prototype.om$core$IRenderState$render_state$arity$2 = (function (___$1,p__36933){
var self__ = this;
var map__36934 = p__36933;
var map__36934__$1 = ((((!((map__36934 == null)))?((((map__36934.cljs$lang$protocol_mask$partition0$ & (64))) || (map__36934.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__36934):map__36934);
var name_or_label = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36934__$1,cljs.core.cst$kw$name_DASH_or_DASH_label);
var language = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36934__$1,cljs.core.cst$kw$language);
var ___$2 = this;
var options = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$label,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$strong,"Label"], null),cljs.core.cst$kw$name,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$strong,"Name"], null)], null);
var map__36936 = om.core.get_shared.cljs$core$IFn$_invoke$arity$1(self__.owner);
var map__36936__$1 = ((((!((map__36936 == null)))?((((map__36936.cljs$lang$protocol_mask$partition0$ & (64))) || (map__36936.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__36936):map__36936);
var flat_form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36936__$1,cljs.core.cst$kw$flat_DASH_form);
var new_language = cljs.core.cst$kw$current.cljs$core$IFn$_invoke$arity$1(om.core.observe(self__.owner,hatti.shared.language_cursor()));
var colset_BANG_ = ((function (options,map__36936,map__36936__$1,flat_form,new_language,___$2,map__36934,map__36934__$1,name_or_label,language){
return (function (p1__36929_SHARP_){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$new_DASH_columns,hatti.views.table.flat_form__GT_sg_columns(flat_form,cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$label,p1__36929_SHARP_),new_language)], null));
});})(options,map__36936,map__36936__$1,flat_form,new_language,___$2,map__36934,map__36934__$1,name_or_label,language))
;
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(new_language,language)){
om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(self__.owner,cljs.core.cst$kw$language,new_language);

colset_BANG_(name_or_label);
} else {
}

var G__36945 = {"className": "label-changer"};
var G__36946 = (function (){var G__36948 = {"className": "label-changer-label"};
var G__36949 = "Show:";
return React.DOM.span(G__36948,G__36949);
})();
var G__36947 = (function (){var G__36950 = {"id": "header-display-dropdown", "className": "drop-hover"};
var G__36951 = (function (){var attrs36940 = (options.cljs$core$IFn$_invoke$arity$1 ? options.cljs$core$IFn$_invoke$arity$1(name_or_label) : options.call(null,name_or_label));
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(React.DOM.span,((cljs.core.map_QMARK_(attrs36940))?sablono.interpreter.attributes(attrs36940):null),cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,((cljs.core.map_QMARK_(attrs36940))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__36953 = {"className": "fa fa-angle-down"};
return React.DOM.i(G__36953);
})()], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret(attrs36940),(function (){var G__36954 = {"className": "fa fa-angle-down"};
return React.DOM.i(G__36954);
})()], null))));
})();
var G__36952 = (function (){var G__36955 = {"className": "submenu no-dot"};
var G__36956 = sablono.interpreter.interpret(hatti.views.table.render_options(options,self__.owner,colset_BANG_));
return React.DOM.ul(G__36955,G__36956);
})();
return React.DOM.div(G__36950,G__36951,G__36952);
})();
return React.DOM.div(G__36945,G__36946,G__36947);
});

hatti.views.table.t_hatti$views$table36930.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta36931], null);
});

hatti.views.table.t_hatti$views$table36930.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table36930.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table36930";

hatti.views.table.t_hatti$views$table36930.cljs$lang$ctorPrWriter = (function (this__6816__auto__,writer__6817__auto__,opt__6818__auto__){
return cljs.core._write(writer__6817__auto__,"hatti.views.table/t_hatti$views$table36930");
});

hatti.views.table.__GT_t_hatti$views$table36930 = (function hatti$views$table$__GT_t_hatti$views$table36930(___$1,owner__$1,meta36931){
return (new hatti.views.table.t_hatti$views$table36930(___$1,owner__$1,meta36931));
});

}

return (new hatti.views.table.t_hatti$views$table36930(_,owner,cljs.core.PersistentArrayMap.EMPTY));
}));
/**
 * Delayed search fires a query-event on event-chan if the value of the input
 * doesn't change within 150 ms (ie, user is still typing).
 * Call on-change or on-key-up, with (.-target event) as first argument.
 */
hatti.views.table.delayed_search = (function hatti$views$table$delayed_search(input,query_event_key){
var query = input.value;
var c__11856__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11856__auto__,query){
return (function (){
var f__11857__auto__ = (function (){var switch__11791__auto__ = ((function (c__11856__auto__,query){
return (function (state_36999){
var state_val_37000 = (state_36999[(1)]);
if((state_val_37000 === (1))){
var inst_36985 = cljs.core.async.timeout((150));
var state_36999__$1 = state_36999;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36999__$1,(2),inst_36985);
} else {
if((state_val_37000 === (2))){
var inst_36987 = (state_36999[(2)]);
var inst_36988 = input.value;
var inst_36989 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(query,inst_36988);
var state_36999__$1 = (function (){var statearr_37001 = state_36999;
(statearr_37001[(7)] = inst_36987);

return statearr_37001;
})();
if(inst_36989){
var statearr_37002_37013 = state_36999__$1;
(statearr_37002_37013[(1)] = (3));

} else {
var statearr_37003_37014 = state_36999__$1;
(statearr_37003_37014[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37000 === (3))){
var inst_36991 = [query_event_key];
var inst_36992 = [query];
var inst_36993 = cljs.core.PersistentHashMap.fromArrays(inst_36991,inst_36992);
var inst_36994 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_chan,inst_36993);
var state_36999__$1 = state_36999;
var statearr_37004_37015 = state_36999__$1;
(statearr_37004_37015[(2)] = inst_36994);

(statearr_37004_37015[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37000 === (4))){
var state_36999__$1 = state_36999;
var statearr_37005_37016 = state_36999__$1;
(statearr_37005_37016[(2)] = null);

(statearr_37005_37016[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37000 === (5))){
var inst_36997 = (state_36999[(2)]);
var state_36999__$1 = state_36999;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36999__$1,inst_36997);
} else {
return null;
}
}
}
}
}
});})(c__11856__auto__,query))
;
return ((function (switch__11791__auto__,c__11856__auto__,query){
return (function() {
var hatti$views$table$delayed_search_$_state_machine__11792__auto__ = null;
var hatti$views$table$delayed_search_$_state_machine__11792__auto____0 = (function (){
var statearr_37009 = [null,null,null,null,null,null,null,null];
(statearr_37009[(0)] = hatti$views$table$delayed_search_$_state_machine__11792__auto__);

(statearr_37009[(1)] = (1));

return statearr_37009;
});
var hatti$views$table$delayed_search_$_state_machine__11792__auto____1 = (function (state_36999){
while(true){
var ret_value__11793__auto__ = (function (){try{while(true){
var result__11794__auto__ = switch__11791__auto__(state_36999);
if(cljs.core.keyword_identical_QMARK_(result__11794__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__11794__auto__;
}
break;
}
}catch (e37010){if((e37010 instanceof Object)){
var ex__11795__auto__ = e37010;
var statearr_37011_37017 = state_36999;
(statearr_37011_37017[(5)] = ex__11795__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_36999);

return cljs.core.cst$kw$recur;
} else {
throw e37010;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11793__auto__,cljs.core.cst$kw$recur)){
var G__37018 = state_36999;
state_36999 = G__37018;
continue;
} else {
return ret_value__11793__auto__;
}
break;
}
});
hatti$views$table$delayed_search_$_state_machine__11792__auto__ = function(state_36999){
switch(arguments.length){
case 0:
return hatti$views$table$delayed_search_$_state_machine__11792__auto____0.call(this);
case 1:
return hatti$views$table$delayed_search_$_state_machine__11792__auto____1.call(this,state_36999);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$delayed_search_$_state_machine__11792__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$delayed_search_$_state_machine__11792__auto____0;
hatti$views$table$delayed_search_$_state_machine__11792__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$delayed_search_$_state_machine__11792__auto____1;
return hatti$views$table$delayed_search_$_state_machine__11792__auto__;
})()
;})(switch__11791__auto__,c__11856__auto__,query))
})();
var state__11858__auto__ = (function (){var statearr_37012 = (f__11857__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11857__auto__.cljs$core$IFn$_invoke$arity$0() : f__11857__auto__.call(null));
(statearr_37012[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11856__auto__);

return statearr_37012;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11858__auto__);
});})(c__11856__auto__,query))
);

return c__11856__auto__;
});
hatti.views.table_search.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (_,owner){
if(typeof hatti.views.table.t_hatti$views$table37020 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table37020 = (function (_,owner,meta37021){
this._ = _;
this.owner = owner;
this.meta37021 = meta37021;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table37020.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_37022,meta37021__$1){
var self__ = this;
var _37022__$1 = this;
return (new hatti.views.table.t_hatti$views$table37020(self__._,self__.owner,meta37021__$1));
});

hatti.views.table.t_hatti$views$table37020.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_37022){
var self__ = this;
var _37022__$1 = this;
return self__.meta37021;
});

hatti.views.table.t_hatti$views$table37020.prototype.om$core$IRender$ = true;

hatti.views.table.t_hatti$views$table37020.prototype.om$core$IRender$render$arity$1 = (function (this__18961__auto__){
var self__ = this;
var this__18961__auto____$1 = this;
var G__37025 = {"className": "table-search"};
var G__37026 = (function (){var G__37028 = {"className": "fa fa-search"};
return React.DOM.i(G__37028);
})();
var G__37027 = (function (){var G__37029 = {"type": "text", "placeholder": "Search", "onChange": ((function (G__37025,G__37026,this__18961__auto____$1){
return (function (p1__37019_SHARP_){
return hatti.views.table.delayed_search(p1__37019_SHARP_.target,cljs.core.cst$kw$filter_DASH_by);
});})(G__37025,G__37026,this__18961__auto____$1))
};
return (sablono.interpreter.input.cljs$core$IFn$_invoke$arity$1 ? sablono.interpreter.input.cljs$core$IFn$_invoke$arity$1(G__37029) : sablono.interpreter.input.call(null,G__37029));
})();
return React.DOM.div(G__37025,G__37026,G__37027);
});

hatti.views.table.t_hatti$views$table37020.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta37021], null);
});

hatti.views.table.t_hatti$views$table37020.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table37020.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table37020";

hatti.views.table.t_hatti$views$table37020.cljs$lang$ctorPrWriter = (function (this__6816__auto__,writer__6817__auto__,opt__6818__auto__){
return cljs.core._write(writer__6817__auto__,"hatti.views.table/t_hatti$views$table37020");
});

hatti.views.table.__GT_t_hatti$views$table37020 = (function hatti$views$table$__GT_t_hatti$views$table37020(___$1,owner__$1,meta37021){
return (new hatti.views.table.t_hatti$views$table37020(___$1,owner__$1,meta37021));
});

}

return (new hatti.views.table.t_hatti$views$table37020(_,owner,null));
}));
hatti.views.table_header.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (app_state,owner){
if(typeof hatti.views.table.t_hatti$views$table37030 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table37030 = (function (app_state,owner,meta37031){
this.app_state = app_state;
this.owner = owner;
this.meta37031 = meta37031;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table37030.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_37032,meta37031__$1){
var self__ = this;
var _37032__$1 = this;
return (new hatti.views.table.t_hatti$views$table37030(self__.app_state,self__.owner,meta37031__$1));
});

hatti.views.table.t_hatti$views$table37030.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_37032){
var self__ = this;
var _37032__$1 = this;
return self__.meta37031;
});

hatti.views.table.t_hatti$views$table37030.prototype.om$core$IRender$ = true;

hatti.views.table.t_hatti$views$table37030.prototype.om$core$IRender$render$arity$1 = (function (this__18961__auto__){
var self__ = this;
var this__18961__auto____$1 = this;
var G__37035 = {"className": "topbar"};
var G__37036 = (function (){var G__37040 = {"id": hatti.views.table.pager_id};
return React.DOM.div(G__37040);
})();
var G__37037 = sablono.interpreter.interpret(om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.views.label_changer,null));
var G__37038 = sablono.interpreter.interpret(om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.views.table_search,self__.app_state));
var G__37039 = (function (){var G__37041 = {"style": {"clear": "both"}};
return React.DOM.div(G__37041);
})();
return React.DOM.div(G__37035,G__37036,G__37037,G__37038,G__37039);
});

hatti.views.table.t_hatti$views$table37030.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$app_DASH_state,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta37031], null);
});

hatti.views.table.t_hatti$views$table37030.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table37030.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table37030";

hatti.views.table.t_hatti$views$table37030.cljs$lang$ctorPrWriter = (function (this__6816__auto__,writer__6817__auto__,opt__6818__auto__){
return cljs.core._write(writer__6817__auto__,"hatti.views.table/t_hatti$views$table37030");
});

hatti.views.table.__GT_t_hatti$views$table37030 = (function hatti$views$table$__GT_t_hatti$views$table37030(app_state__$1,owner__$1,meta37031){
return (new hatti.views.table.t_hatti$views$table37030(app_state__$1,owner__$1,meta37031));
});

}

return (new hatti.views.table.t_hatti$views$table37030(app_state,owner,null));
}));
hatti.views.table.init_grid_BANG_ = (function hatti$views$table$init_grid_BANG_(data,owner,slick_grid_event_handlers){

if(cljs.core.seq(data)){
var map__37045 = om.core.get_shared.cljs$core$IFn$_invoke$arity$1(owner);
var map__37045__$1 = ((((!((map__37045 == null)))?((((map__37045.cljs$lang$protocol_mask$partition0$ & (64))) || (map__37045.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__37045):map__37045);
var flat_form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37045__$1,cljs.core.cst$kw$flat_DASH_form);
var is_filtered_dataview_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37045__$1,cljs.core.cst$kw$is_DASH_filtered_DASH_dataview_QMARK_);
var current_language = cljs.core.cst$kw$current.cljs$core$IFn$_invoke$arity$1(om.core.observe(owner,hatti.shared.language_cursor()));
var vec__37046 = hatti.views.table.sg_init(data,flat_form,current_language,is_filtered_dataview_QMARK_,owner,slick_grid_event_handlers);
var grid = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37046,(0),null);
var dataview = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37046,(1),null);
om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$grid,grid);

om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$dataview,dataview);

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [grid,dataview], null);
} else {
return null;
}
});
hatti.views.table_page.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (app_state,owner,p__37049){
var map__37050 = p__37049;
var map__37050__$1 = ((((!((map__37050 == null)))?((((map__37050.cljs$lang$protocol_mask$partition0$ & (64))) || (map__37050.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__37050):map__37050);
var opts = map__37050__$1;
var slick_grid_event_handlers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37050__$1,cljs.core.cst$kw$slick_DASH_grid_DASH_event_DASH_handlers);

if(typeof hatti.views.table.t_hatti$views$table37052 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRenderState}
 * @implements {om.core.IWillReceiveProps}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IDidMount}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table37052 = (function (app_state,owner,p__37049,map__37050,opts,slick_grid_event_handlers,meta37053){
this.app_state = app_state;
this.owner = owner;
this.p__37049 = p__37049;
this.map__37050 = map__37050;
this.opts = opts;
this.slick_grid_event_handlers = slick_grid_event_handlers;
this.meta37053 = meta37053;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table37052.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (map__37050,map__37050__$1,opts,slick_grid_event_handlers){
return (function (_37054,meta37053__$1){
var self__ = this;
var _37054__$1 = this;
return (new hatti.views.table.t_hatti$views$table37052(self__.app_state,self__.owner,self__.p__37049,self__.map__37050,self__.opts,self__.slick_grid_event_handlers,meta37053__$1));
});})(map__37050,map__37050__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table37052.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (map__37050,map__37050__$1,opts,slick_grid_event_handlers){
return (function (_37054){
var self__ = this;
var _37054__$1 = this;
return self__.meta37053;
});})(map__37050,map__37050__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table37052.prototype.om$core$IRenderState$ = true;

hatti.views.table.t_hatti$views$table37052.prototype.om$core$IRenderState$render_state$arity$2 = ((function (map__37050,map__37050__$1,opts,slick_grid_event_handlers){
return (function (_,___$1){
var self__ = this;
var ___$2 = this;
var no_data_QMARK_ = cljs.core.empty_QMARK_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data], null)));
var map__37055 = cljs.core.cst$kw$dataset_DASH_info.cljs$core$IFn$_invoke$arity$1(self__.app_state);
var map__37055__$1 = ((((!((map__37055 == null)))?((((map__37055.cljs$lang$protocol_mask$partition0$ & (64))) || (map__37055.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__37055):map__37055);
var dataset_info = map__37055__$1;
var num_of_submissions = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37055__$1,cljs.core.cst$kw$num_of_submissions);
var with_info = ((function (no_data_QMARK_,map__37055,map__37055__$1,dataset_info,num_of_submissions,___$2,map__37050,map__37050__$1,opts,slick_grid_event_handlers){
return (function (p1__37048_SHARP_){
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([p1__37048_SHARP_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$dataset_DASH_info,dataset_info], null)], 0));
});})(no_data_QMARK_,map__37055,map__37055__$1,dataset_info,num_of_submissions,___$2,map__37050,map__37050__$1,opts,slick_grid_event_handlers))
;
var attrs37057 = om.core.build.cljs$core$IFn$_invoke$arity$3(hatti.views.submission_view,with_info(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.app_state,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$table_DASH_page,cljs.core.cst$kw$submission_DASH_clicked], null))),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$opts,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.select_keys(self__.opts,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$role,null,cljs.core.cst$kw$delete_DASH_record_BANG_,null], null), null)),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$view,cljs.core.cst$kw$table], null)], 0))], null));
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(React.DOM.div,((cljs.core.map_QMARK_(attrs37057))?sablono.interpreter.attributes(sablono.util.merge_with_class.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["table-view"], null)], null),attrs37057], 0))):{"className": "table-view"}),cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,((cljs.core.map_QMARK_(attrs37057))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret(om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.views.table_header,self__.app_state)),(function (){var G__37058 = {"id": hatti.views.table.table_id, "className": "slickgrid"};
var G__37059 = (((no_data_QMARK_) && ((num_of_submissions === (0))))?(function (){var G__37064 = {"className": "empty-state"};
var G__37065 = "No data";
return React.DOM.span(G__37064,G__37065);
})():(function (){var G__37067 = null;
var G__37068 = (function (){var G__37070 = {"className": "fa fa-spinner fa-pulse"};
return React.DOM.i(G__37070);
})();
var G__37069 = "Loading...";
return React.DOM.span(G__37067,G__37068,G__37069);
})());
return React.DOM.div(G__37058,G__37059);
})()], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret(attrs37057),sablono.interpreter.interpret(om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.views.table_header,self__.app_state)),(function (){var G__37071 = {"id": hatti.views.table.table_id, "className": "slickgrid"};
var G__37072 = (((no_data_QMARK_) && ((num_of_submissions === (0))))?(function (){var G__37077 = {"className": "empty-state"};
var G__37078 = "No data";
return React.DOM.span(G__37077,G__37078);
})():(function (){var G__37080 = null;
var G__37081 = (function (){var G__37083 = {"className": "fa fa-spinner fa-pulse"};
return React.DOM.i(G__37083);
})();
var G__37082 = "Loading...";
return React.DOM.span(G__37080,G__37081,G__37082);
})());
return React.DOM.div(G__37071,G__37072);
})()], null))));
});})(map__37050,map__37050__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table37052.prototype.om$core$IDidMount$ = true;

hatti.views.table.t_hatti$views$table37052.prototype.om$core$IDidMount$did_mount$arity$1 = ((function (map__37050,map__37050__$1,opts,slick_grid_event_handlers){
return (function (_){
var self__ = this;
var ___$1 = this;
var data = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data], null));
var temp__4657__auto__ = hatti.views.table.init_grid_BANG_(data,self__.owner,self__.slick_grid_event_handlers);
if(cljs.core.truth_(temp__4657__auto__)){
var vec__37084 = temp__4657__auto__;
var grid = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37084,(0),null);
var dataview = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37084,(1),null);
return hatti.views.table.handle_table_events(self__.app_state,grid,dataview);
} else {
return null;
}
});})(map__37050,map__37050__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table37052.prototype.om$core$IWillReceiveProps$ = true;

hatti.views.table.t_hatti$views$table37052.prototype.om$core$IWillReceiveProps$will_receive_props$arity$2 = ((function (map__37050,map__37050__$1,opts,slick_grid_event_handlers){
return (function (_,next_props){
var self__ = this;
var ___$1 = this;

var old_data = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(om.core.get_props.cljs$core$IFn$_invoke$arity$1(self__.owner),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data], null));
var new_data = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(next_props,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data], null));
var map__37085 = om.core.get_state.cljs$core$IFn$_invoke$arity$1(self__.owner);
var map__37085__$1 = ((((!((map__37085 == null)))?((((map__37085.cljs$lang$protocol_mask$partition0$ & (64))) || (map__37085.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__37085):map__37085);
var grid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37085__$1,cljs.core.cst$kw$grid);
var dataview = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37085__$1,cljs.core.cst$kw$dataview);
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(old_data,new_data)){
if(cljs.core.empty_QMARK_(old_data)){
var temp__4657__auto__ = hatti.views.table.init_grid_BANG_(new_data,self__.owner,self__.slick_grid_event_handlers);
if(cljs.core.truth_(temp__4657__auto__)){
var vec__37087 = temp__4657__auto__;
var grid__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37087,(0),null);
var dataview__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37087,(1),null);
return hatti.views.table.handle_table_events(self__.app_state,grid__$1,dataview__$1);
} else {
return null;
}
} else {
grid.invalidateAllRows();

dataview.setItems(cljs.core.clj__GT_js(new_data),hatti.constants._id);

return grid.render();
}
} else {
return null;
}
});})(map__37050,map__37050__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table37052.getBasis = ((function (map__37050,map__37050__$1,opts,slick_grid_event_handlers){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$app_DASH_state,cljs.core.cst$sym$owner,cljs.core.cst$sym$p__37049,cljs.core.cst$sym$map__37050,cljs.core.cst$sym$opts,cljs.core.cst$sym$slick_DASH_grid_DASH_event_DASH_handlers,cljs.core.cst$sym$meta37053], null);
});})(map__37050,map__37050__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table37052.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table37052.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table37052";

hatti.views.table.t_hatti$views$table37052.cljs$lang$ctorPrWriter = ((function (map__37050,map__37050__$1,opts,slick_grid_event_handlers){
return (function (this__6816__auto__,writer__6817__auto__,opt__6818__auto__){
return cljs.core._write(writer__6817__auto__,"hatti.views.table/t_hatti$views$table37052");
});})(map__37050,map__37050__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.__GT_t_hatti$views$table37052 = ((function (map__37050,map__37050__$1,opts,slick_grid_event_handlers){
return (function hatti$views$table$__GT_t_hatti$views$table37052(app_state__$1,owner__$1,p__37049__$1,map__37050__$2,opts__$1,slick_grid_event_handlers__$1,meta37053){
return (new hatti.views.table.t_hatti$views$table37052(app_state__$1,owner__$1,p__37049__$1,map__37050__$2,opts__$1,slick_grid_event_handlers__$1,meta37053));
});})(map__37050,map__37050__$1,opts,slick_grid_event_handlers))
;

}

return (new hatti.views.table.t_hatti$views$table37052(app_state,owner,p__37049,map__37050__$1,opts,slick_grid_event_handlers,cljs.core.PersistentArrayMap.EMPTY));
}));
