// Compiled by ClojureScript 1.7.145 {}
goog.provide('c2.layout.histogram');
goog.require('cljs.core');
goog.require('c2.maths');
c2.layout.histogram.binary_search = (function c2$layout$histogram$binary_search(v,target){

var low = (0);
var high = (cljs.core.count.call(null,v) - (1));
while(true){
if((low > high)){
return (- (low + (1)));
} else {
var mid = cljs.core.quot.call(null,(low + high),(2));
var mid_val = v.call(null,mid);
if((mid_val < target)){
var G__20259 = (mid + (1));
var G__20260 = high;
low = G__20259;
high = G__20260;
continue;
} else {
if((target < mid_val)){
var G__20261 = low;
var G__20262 = (mid - (1));
low = G__20261;
high = G__20262;
continue;
} else {
return mid;

}
}
}
break;
}
});
/**
 * Calulate reasonable number of bins assuming an approximately normal
 *   distribution
 */
c2.layout.histogram.sturges = (function c2$layout$histogram$sturges(values){
return ((c2.maths.log.call(null,cljs.core.count.call(null,values),(2)) | (0)) + (1));
});
/**
 * Return the inclusive upper threshold of all bins
 */
c2.layout.histogram.fixed_size_bins = (function c2$layout$histogram$fixed_size_bins(p__20263,n){
var vec__20269 = p__20263;
var mn = cljs.core.nth.call(null,vec__20269,(0),null);
var mx = cljs.core.nth.call(null,vec__20269,(1),null);
var size = ((mx - mn) / n);
return cljs.core.vec.call(null,(function (){var iter__5341__auto__ = ((function (size,vec__20269,mn,mx){
return (function c2$layout$histogram$fixed_size_bins_$_iter__20270(s__20271){
return (new cljs.core.LazySeq(null,((function (size,vec__20269,mn,mx){
return (function (){
var s__20271__$1 = s__20271;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__20271__$1);
if(temp__4425__auto__){
var s__20271__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__20271__$2)){
var c__5339__auto__ = cljs.core.chunk_first.call(null,s__20271__$2);
var size__5340__auto__ = cljs.core.count.call(null,c__5339__auto__);
var b__20273 = cljs.core.chunk_buffer.call(null,size__5340__auto__);
if((function (){var i__20272 = (0);
while(true){
if((i__20272 < size__5340__auto__)){
var step = cljs.core._nth.call(null,c__5339__auto__,i__20272);
cljs.core.chunk_append.call(null,b__20273,(mn + (size * step)));

var G__20274 = (i__20272 + (1));
i__20272 = G__20274;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20273),c2$layout$histogram$fixed_size_bins_$_iter__20270.call(null,cljs.core.chunk_rest.call(null,s__20271__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20273),null);
}
} else {
var step = cljs.core.first.call(null,s__20271__$2);
return cljs.core.cons.call(null,(mn + (size * step)),c2$layout$histogram$fixed_size_bins_$_iter__20270.call(null,cljs.core.rest.call(null,s__20271__$2)));
}
} else {
return null;
}
break;
}
});})(size,vec__20269,mn,mx))
,null,null));
});})(size,vec__20269,mn,mx))
;
return iter__5341__auto__.call(null,cljs.core.range.call(null,(n + (1))));
})());
});
/**
 * The histogram layout transforms data by grouping descrete data points into
 *   bins. Returns a collection of values with the following metadata set:
 * 
 *   > *:x* the lower bound of the bin (inclusive).
 * 
 *   > *:dx* the width of the bin; x + dx is the upper bound (exclusive).
 * 
 *   > *:y* the count
 * 
 * Kwargs:
 * 
 * > *:value* fn that calculates value of node, defaults to `:value`
 * 
 * > *:index* opaque value passed to `:bins` and `:range`
 * 
 * > *:range* fn which calculates the minimum and maximum values given the array of values
 * 
 * > *:bins* Number of bins /or/ fn that takes the range, array of values, and current index
 */
c2.layout.histogram.histogram = (function c2$layout$histogram$histogram(var_args){
var args__5634__auto__ = [];
var len__5627__auto___20282 = arguments.length;
var i__5628__auto___20283 = (0);
while(true){
if((i__5628__auto___20283 < len__5627__auto___20282)){
args__5634__auto__.push((arguments[i__5628__auto___20283]));

var G__20284 = (i__5628__auto___20283 + (1));
i__5628__auto___20283 = G__20284;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((1) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((1)),(0))):null);
return c2.layout.histogram.histogram.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5635__auto__);
});

c2.layout.histogram.histogram.cljs$core$IFn$_invoke$arity$variadic = (function (data,p__20277){
var map__20278 = p__20277;
var map__20278__$1 = ((((!((map__20278 == null)))?((((map__20278.cljs$lang$protocol_mask$partition0$ & (64))) || (map__20278.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__20278):map__20278);
var value = cljs.core.get.call(null,map__20278__$1,new cljs.core.Keyword(null,"value","value",305978217),new cljs.core.Keyword(null,"value","value",305978217));
var index = cljs.core.get.call(null,map__20278__$1,new cljs.core.Keyword(null,"index","index",-1531685915));
var range = cljs.core.get.call(null,map__20278__$1,new cljs.core.Keyword(null,"range","range",1639692286),((function (map__20278,map__20278__$1,value,index){
return (function (xs,_){
return cljs.core.juxt.call(null,cljs.core.partial.call(null,cljs.core.reduce,cljs.core.min),cljs.core.partial.call(null,cljs.core.reduce,cljs.core.max)).call(null,xs);
});})(map__20278,map__20278__$1,value,index))
);
var bins = cljs.core.get.call(null,map__20278__$1,new cljs.core.Keyword(null,"bins","bins",1670395210),((function (map__20278,map__20278__$1,value,index,range){
return (function (r,xs,_){
return c2.layout.histogram.fixed_size_bins.call(null,r,c2.layout.histogram.sturges.call(null,xs));
});})(map__20278,map__20278__$1,value,index,range))
);
var values = cljs.core.map.call(null,value,data);
var r = ((cljs.core.fn_QMARK_.call(null,range))?range.call(null,values,index):range
);
var thresholds = ((cljs.core.fn_QMARK_.call(null,bins))?bins.call(null,r,values,index):((typeof bins === 'number')?c2.layout.histogram.fixed_size_bins.call(null,r,bins):bins
));
var binner = ((function (values,r,thresholds,map__20278,map__20278__$1,value,index,range,bins){
return (function (e){
return (Math.abs((c2.layout.histogram.binary_search.call(null,cljs.core.subvec.call(null,thresholds,(0),(cljs.core.count.call(null,thresholds) - (1))),value.call(null,e)) + (1))) - (1));
});})(values,r,thresholds,map__20278,map__20278__$1,value,index,range,bins))
;
var groups = cljs.core.group_by.call(null,binner,cljs.core.filter.call(null,((function (values,r,thresholds,binner,map__20278,map__20278__$1,value,index,range,bins){
return (function (p1__109951_SHARP_){
return ((value.call(null,p1__109951_SHARP_) >= r.call(null,(0)))) && ((value.call(null,p1__109951_SHARP_) <= r.call(null,(1))));
});})(values,r,thresholds,binner,map__20278,map__20278__$1,value,index,range,bins))
,data));
return cljs.core.map_indexed.call(null,((function (values,r,thresholds,binner,groups,map__20278,map__20278__$1,value,index,range,bins){
return (function (index__$1,p__20280){
var vec__20281 = p__20280;
var mn = cljs.core.nth.call(null,vec__20281,(0),null);
var mx = cljs.core.nth.call(null,vec__20281,(1),null);
var group = (function (){var or__4569__auto__ = groups.call(null,index__$1);
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})();
return cljs.core.with_meta.call(null,group,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"x","x",2099068185),mn,new cljs.core.Keyword(null,"dx","dx",-381796732),(mx - mn),new cljs.core.Keyword(null,"y","y",-1757859776),cljs.core.count.call(null,group)], null));
});})(values,r,thresholds,binner,groups,map__20278,map__20278__$1,value,index,range,bins))
,cljs.core.partition.call(null,(2),(1),thresholds));
});

c2.layout.histogram.histogram.cljs$lang$maxFixedArity = (1);

c2.layout.histogram.histogram.cljs$lang$applyTo = (function (seq20275){
var G__20276 = cljs.core.first.call(null,seq20275);
var seq20275__$1 = cljs.core.next.call(null,seq20275);
return c2.layout.histogram.histogram.cljs$core$IFn$_invoke$arity$variadic(G__20276,seq20275__$1);
});
