// Compiled by ClojureScript 1.9.229 {:static-fns true, :optimize-constants true}
goog.provide('hatti.charting');
goog.require('cljs.core');
goog.require('chimera.js_interop');
goog.require('c2.layout.histogram');
goog.require('hatti.maths');
goog.require('cljs_time.coerce');
goog.require('c2.scale');
goog.require('cljs_time.format');
goog.require('hatti.ona.forms');
goog.require('c2.svg');
goog.require('clojure.string');
hatti.charting.millis_in_day = (86400000);
/**
 * Parse an integer from a string.
 */
hatti.charting.parse_int = (function hatti$charting$parse_int(st){
var ans = parseInt(st);
if(cljs.core.truth_(isNaN(ans))){
return null;
} else {
return ans;
}
});
/**
 * Converts string to integer, for typ (int|date).
 */
hatti.charting.str__GT_int = (function hatti$charting$str__GT_int(typ){
var G__30745 = typ;
switch (G__30745) {
case "int":
return hatti.charting.parse_int;

break;
case "date":
return ((function (G__30745){
return (function (date_string){
if(cljs.core.truth_(date_string)){
return hatti.maths.floor((cljs_time.coerce.to_long((new Date(date_string))) / hatti.charting.millis_in_day));
} else {
return null;
}
});
;})(G__30745))

break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(typ)].join('')));

}
});
/**
 * Converts integers to strings, for type (int|date).
 * Optional digits parameter = number of digits after decimal, default is 1.
 */
hatti.charting.int__GT_str = (function hatti$charting$int__GT_str(var_args){
var args__7491__auto__ = [];
var len__7484__auto___30757 = arguments.length;
var i__7485__auto___30758 = (0);
while(true){
if((i__7485__auto___30758 < len__7484__auto___30757)){
args__7491__auto__.push((arguments[i__7485__auto___30758]));

var G__30759 = (i__7485__auto___30758 + (1));
i__7485__auto___30758 = G__30759;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return hatti.charting.int__GT_str.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

hatti.charting.int__GT_str.cljs$core$IFn$_invoke$arity$variadic = (function (typ,p__30753){
var map__30754 = p__30753;
var map__30754__$1 = ((((!((map__30754 == null)))?((((map__30754.cljs$lang$protocol_mask$partition0$ & (64))) || (map__30754.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__30754):map__30754);
var digits = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__30754__$1,cljs.core.cst$kw$digits,(1));
var int_fmt_s = [cljs.core.str("%."),cljs.core.str(digits),cljs.core.str("f")].join('');
var d__GT_millis = ((function (int_fmt_s,map__30754,map__30754__$1,digits){
return (function (p1__30747_SHARP_){
return (hatti.charting.millis_in_day * p1__30747_SHARP_);
});})(int_fmt_s,map__30754,map__30754__$1,digits))
;
var date__GT_str = ((function (int_fmt_s,d__GT_millis,map__30754,map__30754__$1,digits){
return (function (p1__30748_SHARP_){
if(cljs.core.truth_(p1__30748_SHARP_)){
return moment(p1__30748_SHARP_).format("ll");
} else {
return null;
}
});})(int_fmt_s,d__GT_millis,map__30754,map__30754__$1,digits))
;
var G__30756 = typ;
switch (G__30756) {
case "int":
return ((function (G__30756,int_fmt_s,d__GT_millis,date__GT_str,map__30754,map__30754__$1,digits){
return (function (p1__30749_SHARP_){
return chimera.js_interop.format.cljs$core$IFn$_invoke$arity$variadic(int_fmt_s,cljs.core.array_seq([p1__30749_SHARP_], 0));
});
;})(G__30756,int_fmt_s,d__GT_millis,date__GT_str,map__30754,map__30754__$1,digits))

break;
case "date":
return ((function (G__30756,int_fmt_s,d__GT_millis,date__GT_str,map__30754,map__30754__$1,digits){
return (function (p1__30750_SHARP_){
return date__GT_str(d__GT_millis(p1__30750_SHARP_));
});
;})(G__30756,int_fmt_s,d__GT_millis,date__GT_str,map__30754,map__30754__$1,digits))

break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(typ)].join('')));

}
});

hatti.charting.int__GT_str.cljs$lang$maxFixedArity = (1);

hatti.charting.int__GT_str.cljs$lang$applyTo = (function (seq30751){
var G__30752 = cljs.core.first(seq30751);
var seq30751__$1 = cljs.core.next(seq30751);
return hatti.charting.int__GT_str.cljs$core$IFn$_invoke$arity$variadic(G__30752,seq30751__$1);
});

/**
 * Converts a range of typ (int|date) to a string.
 */
hatti.charting.range__GT_str = (function hatti$charting$range__GT_str(p__30761,typ){
var vec__30768 = p__30761;
var mn = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30768,(0),null);
var mx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30768,(1),null);
var vec__30771 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [hatti.maths.ceil(mn),hatti.maths.floor(mx)], null);
var mn__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30771,(0),null);
var mx__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30771,(1),null);
var fmt = hatti.charting.int__GT_str.cljs$core$IFn$_invoke$arity$variadic(typ,cljs.core.array_seq([cljs.core.cst$kw$digits,(0)], 0));
if((mx__$1 <= mn__$1)){
return (fmt.cljs$core$IFn$_invoke$arity$1 ? fmt.cljs$core$IFn$_invoke$arity$1(mn__$1) : fmt.call(null,mn__$1));
} else {
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(" to ",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(fmt.cljs$core$IFn$_invoke$arity$1 ? fmt.cljs$core$IFn$_invoke$arity$1(mn__$1) : fmt.call(null,mn__$1)),(fmt.cljs$core$IFn$_invoke$arity$1 ? fmt.cljs$core$IFn$_invoke$arity$1(mx__$1) : fmt.call(null,mx__$1))], null));
}
});
/**
 * Given a list of answers, returns each one as a bin, in string form.
 * nil is mapped to nil. The bins, in order, are returned as metadata.
 * eg. (evenly-spaced-bins [1 2 10] 5 'int') => ['1 to 2' '1 to 2' '9 to 10']
 * metadata of this above value would be:
 * {:bins ['1 to 2', '3 to 4', '5 to 6', '7 to 8', '9 to 10']}
 */
hatti.charting.evenly_spaced_bins = (function hatti$charting$evenly_spaced_bins(answers,bins,typ){
var numbers = cljs.core.map.cljs$core$IFn$_invoke$arity$2(hatti.charting.str__GT_int(typ),answers);
var mx = cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core.max,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,numbers));
var mn = cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core.min,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,numbers));
var s = c2.scale.linear.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.cst$kw$domain,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [mn,mx], null),cljs.core.cst$kw$range,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(bins - ((1) / (10000)))], null)], 0));
var is = cljs.core.map.cljs$core$IFn$_invoke$arity$2(hatti.maths.floor,cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (numbers,mx,mn,s){
return (function (p1__30774_SHARP_){
if(cljs.core.truth_(p1__30774_SHARP_)){
return (s.cljs$core$IFn$_invoke$arity$1 ? s.cljs$core$IFn$_invoke$arity$1(p1__30774_SHARP_) : s.call(null,p1__30774_SHARP_));
} else {
return null;
}
});})(numbers,mx,mn,s))
,numbers));
var t = c2.scale.linear.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.cst$kw$domain,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),bins], null),cljs.core.cst$kw$range,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [mn,mx], null)], 0));
var lbounds = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.float$,cljs.core.map.cljs$core$IFn$_invoke$arity$2(t,cljs.core.range.cljs$core$IFn$_invoke$arity$1(bins))));
var ubounds = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (numbers,mx,mn,s,is,t,lbounds){
return (function (p1__30775_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__30775_SHARP_,hatti.maths.floor(p1__30775_SHARP_))){
return (p1__30775_SHARP_ - (1));
} else {
return p1__30775_SHARP_;
}
});})(numbers,mx,mn,s,is,t,lbounds))
,cljs.core.drop.cljs$core$IFn$_invoke$arity$2((1),lbounds)),mx);
var fmt = hatti.charting.int__GT_str.cljs$core$IFn$_invoke$arity$variadic(typ,cljs.core.array_seq([cljs.core.cst$kw$digits,(0)], 0));
var strings = cljs.core.mapv.cljs$core$IFn$_invoke$arity$3(((function (numbers,mx,mn,s,is,t,lbounds,ubounds,fmt){
return (function (p1__30776_SHARP_,p2__30777_SHARP_){
return hatti.charting.range__GT_str(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__30776_SHARP_,p2__30777_SHARP_], null),typ);
});})(numbers,mx,mn,s,is,t,lbounds,ubounds,fmt))
,lbounds,ubounds);
var results = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (numbers,mx,mn,s,is,t,lbounds,ubounds,fmt,strings){
return (function (i){
if(cljs.core.truth_(i)){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(strings,(i | (0)));
} else {
return null;
}
});})(numbers,mx,mn,s,is,t,lbounds,ubounds,fmt,strings))
,is);
var strings__$1 = cljs.core.vec(cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(strings));
return cljs.core.with_meta(results,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$bins,((cljs.core.contains_QMARK_(cljs.core.set(answers),null))?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(strings__$1,null):strings__$1)], null));
});
/**
 * Take chart-data from the ona API, returns label->count map.
 * eg. Input: {:field_xpath 'D' :data [{:count 2 :D ['Option_1']}]}
 * Output: {:Option_1 2}
 * eg. Input: {:field_xpath 'D' :data [{:count 1 :D ['O1' 'O_2']
 * :count 2 :D ['O1']}]}
 * Output: {:Option_1 3 :O_2 1}
 */
hatti.charting.label_count_pairs = (function hatti$charting$label_count_pairs(var_args){
var args30780 = [];
var len__7484__auto___30791 = arguments.length;
var i__7485__auto___30792 = (0);
while(true){
if((i__7485__auto___30792 < len__7484__auto___30791)){
args30780.push((arguments[i__7485__auto___30792]));

var G__30793 = (i__7485__auto___30792 + (1));
i__7485__auto___30792 = G__30793;
continue;
} else {
}
break;
}

var G__30782 = args30780.length;
switch (G__30782) {
case 1:
return hatti.charting.label_count_pairs.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return hatti.charting.label_count_pairs.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30780.length)].join('')));

}
});

hatti.charting.label_count_pairs.cljs$core$IFn$_invoke$arity$1 = (function (chart_data){
return hatti.charting.label_count_pairs.cljs$core$IFn$_invoke$arity$2(chart_data,null);
});

hatti.charting.label_count_pairs.cljs$core$IFn$_invoke$arity$2 = (function (chart_data,language){
var map__30783 = chart_data;
var map__30783__$1 = ((((!((map__30783 == null)))?((((map__30783.cljs$lang$protocol_mask$partition0$ & (64))) || (map__30783.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__30783):map__30783);
var data = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30783__$1,cljs.core.cst$kw$data);
var field_xpath = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30783__$1,cljs.core.cst$kw$field_xpath);
var unboxed = (function (){var iter__7189__auto__ = ((function (map__30783,map__30783__$1,data,field_xpath){
return (function hatti$charting$iter__30785(s__30786){
return (new cljs.core.LazySeq(null,((function (map__30783,map__30783__$1,data,field_xpath){
return (function (){
var s__30786__$1 = s__30786;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__30786__$1);
if(temp__4657__auto__){
var s__30786__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__30786__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__30786__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__30788 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__30787 = (0);
while(true){
if((i__30787 < size__7188__auto__)){
var data_item = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__30787);
cljs.core.chunk_append(b__30788,(function (){var labels = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(field_xpath).call(null,data_item);
var count = cljs.core.cst$kw$count.cljs$core$IFn$_invoke$arity$1(data_item);
var labelify = ((function (i__30787,labels,count,data_item,c__7187__auto__,size__7188__auto__,b__30788,s__30786__$2,temp__4657__auto__,map__30783,map__30783__$1,data,field_xpath){
return (function (p1__30778_SHARP_){
return hatti.ona.forms.get_label.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$label,p1__30778_SHARP_], null),cljs.core.array_seq([language], 0));
});})(i__30787,labels,count,data_item,c__7187__auto__,size__7188__auto__,b__30788,s__30786__$2,temp__4657__auto__,map__30783,map__30783__$1,data,field_xpath))
;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (i__30787,labels,count,labelify,data_item,c__7187__auto__,size__7188__auto__,b__30788,s__30786__$2,temp__4657__auto__,map__30783,map__30783__$1,data,field_xpath){
return (function (p1__30779_SHARP_){
return cljs.core.PersistentHashMap.fromArrays([labelify(p1__30779_SHARP_)],[count]);
});})(i__30787,labels,count,labelify,data_item,c__7187__auto__,size__7188__auto__,b__30788,s__30786__$2,temp__4657__auto__,map__30783,map__30783__$1,data,field_xpath))
,labels);
})());

var G__30795 = (i__30787 + (1));
i__30787 = G__30795;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__30788),hatti$charting$iter__30785(cljs.core.chunk_rest(s__30786__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__30788),null);
}
} else {
var data_item = cljs.core.first(s__30786__$2);
return cljs.core.cons((function (){var labels = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(field_xpath).call(null,data_item);
var count = cljs.core.cst$kw$count.cljs$core$IFn$_invoke$arity$1(data_item);
var labelify = ((function (labels,count,data_item,s__30786__$2,temp__4657__auto__,map__30783,map__30783__$1,data,field_xpath){
return (function (p1__30778_SHARP_){
return hatti.ona.forms.get_label.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$label,p1__30778_SHARP_], null),cljs.core.array_seq([language], 0));
});})(labels,count,data_item,s__30786__$2,temp__4657__auto__,map__30783,map__30783__$1,data,field_xpath))
;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (labels,count,labelify,data_item,s__30786__$2,temp__4657__auto__,map__30783,map__30783__$1,data,field_xpath){
return (function (p1__30779_SHARP_){
return cljs.core.PersistentHashMap.fromArrays([labelify(p1__30779_SHARP_)],[count]);
});})(labels,count,labelify,data_item,s__30786__$2,temp__4657__auto__,map__30783,map__30783__$1,data,field_xpath))
,labels);
})(),hatti$charting$iter__30785(cljs.core.rest(s__30786__$2)));
}
} else {
return null;
}
break;
}
});})(map__30783,map__30783__$1,data,field_xpath))
,null,null));
});})(map__30783,map__30783__$1,data,field_xpath))
;
return iter__7189__auto__(data);
})();
return cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3(cljs.core.last,cljs.core._GT_,cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.merge_with,cljs.core._PLUS_,cljs.core.flatten(unboxed)));
});

hatti.charting.label_count_pairs.cljs$lang$maxFixedArity = 2;

/**
 * Determine number of bins if there are n possible of values of data.
 *   Custom algorithm, based on a pleasant range of bins being between
 *   roughly 7 and 15 (though customizable). Idea is that we try to divide
 *   n into a number between 
 */
hatti.charting.num_bins = (function hatti$charting$num_bins(var_args){
var args__7491__auto__ = [];
var len__7484__auto___30801 = arguments.length;
var i__7485__auto___30802 = (0);
while(true){
if((i__7485__auto___30802 < len__7484__auto___30801)){
args__7491__auto__.push((arguments[i__7485__auto___30802]));

var G__30803 = (i__7485__auto___30802 + (1));
i__7485__auto___30802 = G__30803;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return hatti.charting.num_bins.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

hatti.charting.num_bins.cljs$core$IFn$_invoke$arity$variadic = (function (n,p__30798){
var map__30799 = p__30798;
var map__30799__$1 = ((((!((map__30799 == null)))?((((map__30799.cljs$lang$protocol_mask$partition0$ & (64))) || (map__30799.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__30799):map__30799);
var data_type = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__30799__$1,cljs.core.cst$kw$data_DASH_type,"int");
var rough_min = (7);
var rough_max = (15);
var real_max = (24);
var full_range = cljs.core.range.cljs$core$IFn$_invoke$arity$2(rough_min,rough_max);
var best_guess = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.max,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(hatti.maths.gcd,n),full_range));
if((best_guess < rough_min)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$3(cljs.core.min,real_max,n),cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(hatti.maths.lcm,n),full_range));
} else {
return best_guess;
}
});

hatti.charting.num_bins.cljs$lang$maxFixedArity = (1);

hatti.charting.num_bins.cljs$lang$applyTo = (function (seq30796){
var G__30797 = cljs.core.first(seq30796);
var seq30796__$1 = cljs.core.next(seq30796);
return hatti.charting.num_bins.cljs$core$IFn$_invoke$arity$variadic(G__30797,seq30796__$1);
});

/**
 * Turn numerical / date chart-data from ona API histogram-friendly.
 *   Return data looks like [(x dx y)] with-meta {:bins num-bins}.
 */
hatti.charting.extract_data_for_histogram = (function hatti$charting$extract_data_for_histogram(var_args){
var args__7491__auto__ = [];
var len__7484__auto___30817 = arguments.length;
var i__7485__auto___30818 = (0);
while(true){
if((i__7485__auto___30818 < len__7484__auto___30817)){
args__7491__auto__.push((arguments[i__7485__auto___30818]));

var G__30819 = (i__7485__auto___30818 + (1));
i__7485__auto___30818 = G__30819;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return hatti.charting.extract_data_for_histogram.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

hatti.charting.extract_data_for_histogram.cljs$core$IFn$_invoke$arity$variadic = (function (chart_data,p__30806){
var map__30807 = p__30806;
var map__30807__$1 = ((((!((map__30807 == null)))?((((map__30807.cljs$lang$protocol_mask$partition0$ & (64))) || (map__30807.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__30807):map__30807);
var data_type = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__30807__$1,cljs.core.cst$kw$data_DASH_type,"int");
var map__30809 = chart_data;
var map__30809__$1 = ((((!((map__30809 == null)))?((((map__30809.cljs$lang$protocol_mask$partition0$ & (64))) || (map__30809.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__30809):map__30809);
var data = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30809__$1,cljs.core.cst$kw$data);
var field_xpath = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30809__$1,cljs.core.cst$kw$field_xpath);
var retype_fn = hatti.charting.str__GT_int(data_type);
var qn_key = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(field_xpath);
var retyped_data = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (map__30809,map__30809__$1,data,field_xpath,retype_fn,qn_key,map__30807,map__30807__$1,data_type){
return (function (el){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(el,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [qn_key], null),retype_fn);
});})(map__30809,map__30809__$1,data,field_xpath,retype_fn,qn_key,map__30807,map__30807__$1,data_type))
,data);
var data_range = (cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.max,cljs.core.map.cljs$core$IFn$_invoke$arity$2(qn_key,retyped_data)) - cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.min,cljs.core.map.cljs$core$IFn$_invoke$arity$2(qn_key,retyped_data)));
var bins = (((data_range === (0)))?(1):hatti.charting.num_bins.cljs$core$IFn$_invoke$arity$variadic(data_range,cljs.core.array_seq([cljs.core.cst$kw$data_DASH_type,data_type], 0)));
var binned_data = c2.layout.histogram.histogram.cljs$core$IFn$_invoke$arity$variadic(retyped_data,cljs.core.array_seq([cljs.core.cst$kw$value,qn_key,cljs.core.cst$kw$bins,bins], 0));
return cljs.core.with_meta((function (){var iter__7189__auto__ = ((function (map__30809,map__30809__$1,data,field_xpath,retype_fn,qn_key,retyped_data,data_range,bins,binned_data,map__30807,map__30807__$1,data_type){
return (function hatti$charting$iter__30811(s__30812){
return (new cljs.core.LazySeq(null,((function (map__30809,map__30809__$1,data,field_xpath,retype_fn,qn_key,retyped_data,data_range,bins,binned_data,map__30807,map__30807__$1,data_type){
return (function (){
var s__30812__$1 = s__30812;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__30812__$1);
if(temp__4657__auto__){
var s__30812__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__30812__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__30812__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__30814 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__30813 = (0);
while(true){
if((i__30813 < size__7188__auto__)){
var data_item = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__30813);
cljs.core.chunk_append(b__30814,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$x.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(data_item)),cljs.core.cst$kw$dx.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(data_item)),cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$count,data_item))], null));

var G__30820 = (i__30813 + (1));
i__30813 = G__30820;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__30814),hatti$charting$iter__30811(cljs.core.chunk_rest(s__30812__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__30814),null);
}
} else {
var data_item = cljs.core.first(s__30812__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$x.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(data_item)),cljs.core.cst$kw$dx.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(data_item)),cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$count,data_item))], null),hatti$charting$iter__30811(cljs.core.rest(s__30812__$2)));
}
} else {
return null;
}
break;
}
});})(map__30809,map__30809__$1,data,field_xpath,retype_fn,qn_key,retyped_data,data_range,bins,binned_data,map__30807,map__30807__$1,data_type))
,null,null));
});})(map__30809,map__30809__$1,data,field_xpath,retype_fn,qn_key,retyped_data,data_range,bins,binned_data,map__30807,map__30807__$1,data_type))
;
return iter__7189__auto__(binned_data);
})(),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$bins,bins], null));
});

hatti.charting.extract_data_for_histogram.cljs$lang$maxFixedArity = (1);

hatti.charting.extract_data_for_histogram.cljs$lang$applyTo = (function (seq30804){
var G__30805 = cljs.core.first(seq30804);
var seq30804__$1 = cljs.core.next(seq30804);
return hatti.charting.extract_data_for_histogram.cljs$core$IFn$_invoke$arity$variadic(G__30805,seq30804__$1);
});

/**
 * Produces a linear mapping [0,max-count] -> [0, max-length], for data which
 * is a vector, each element a map with key :count. If total-asmax?, then
 * linear map is [0,total-count] -> [0, max-length].
 */
hatti.charting.counts__GT_lengths = (function hatti$charting$counts__GT_lengths(var_args){
var args__7491__auto__ = [];
var len__7484__auto___30827 = arguments.length;
var i__7485__auto___30828 = (0);
while(true){
if((i__7485__auto___30828 < len__7484__auto___30827)){
args__7491__auto__.push((arguments[i__7485__auto___30828]));

var G__30829 = (i__7485__auto___30828 + (1));
i__7485__auto___30828 = G__30829;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((2) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((2)),(0),null)):null);
return hatti.charting.counts__GT_lengths.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7492__auto__);
});

hatti.charting.counts__GT_lengths.cljs$core$IFn$_invoke$arity$variadic = (function (data,max_length,p__30824){
var map__30825 = p__30824;
var map__30825__$1 = ((((!((map__30825 == null)))?((((map__30825.cljs$lang$protocol_mask$partition0$ & (64))) || (map__30825.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__30825):map__30825);
var total_as_max_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30825__$1,cljs.core.cst$kw$total_DASH_as_DASH_max_QMARK_);
var datamin_as_min_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30825__$1,cljs.core.cst$kw$datamin_DASH_as_DASH_min_QMARK_);
var counts = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$count,data);
var xmax = (cljs.core.truth_(total_as_max_QMARK_)?cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._PLUS_,(0),counts):cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.max,(0),counts));
var xmin = (cljs.core.truth_(datamin_as_min_QMARK_)?cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.min,(0),counts):(0));
var scale = c2.scale.linear.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.cst$kw$domain,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [xmin,xmax], null),cljs.core.cst$kw$range,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),max_length], null)], 0));
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(scale,counts);
});

hatti.charting.counts__GT_lengths.cljs$lang$maxFixedArity = (2);

hatti.charting.counts__GT_lengths.cljs$lang$applyTo = (function (seq30821){
var G__30822 = cljs.core.first(seq30821);
var seq30821__$1 = cljs.core.next(seq30821);
var G__30823 = cljs.core.first(seq30821__$1);
var seq30821__$2 = cljs.core.next(seq30821__$1);
return hatti.charting.counts__GT_lengths.cljs$core$IFn$_invoke$arity$variadic(G__30822,G__30823,seq30821__$2);
});

hatti.charting.response_count_message = (function hatti$charting$response_count_message(response_count){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$t_DASH_right$t_DASH_grey,[cljs.core.str("Based on "),cljs.core.str(response_count),cljs.core.str(" responses.")].join('')], null);
});
/**
 * Create numeric (or date) chart out of some chart-data from ona API.
 */
hatti.charting.numeric_chart = (function hatti$charting$numeric_chart(var_args){
var args__7491__auto__ = [];
var len__7484__auto___30876 = arguments.length;
var i__7485__auto___30877 = (0);
while(true){
if((i__7485__auto___30877 < len__7484__auto___30876)){
args__7491__auto__.push((arguments[i__7485__auto___30877]));

var G__30878 = (i__7485__auto___30877 + (1));
i__7485__auto___30877 = G__30878;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return hatti.charting.numeric_chart.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

hatti.charting.numeric_chart.cljs$core$IFn$_invoke$arity$variadic = (function (chart_data,p__30832){
var map__30833 = p__30832;
var map__30833__$1 = ((((!((map__30833 == null)))?((((map__30833.cljs$lang$protocol_mask$partition0$ & (64))) || (map__30833.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__30833):map__30833);
var data_type = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__30833__$1,cljs.core.cst$kw$data_DASH_type,"int");
var chart_width = 700.0;
var chart_height = 300.0;
var margin = 33.0;
var small_margin = 2.0;
var y_lim = 8.0;
var neg_margin = (-15);
var extracted_data = hatti.charting.extract_data_for_histogram.cljs$core$IFn$_invoke$arity$variadic(chart_data,cljs.core.array_seq([cljs.core.cst$kw$data_DASH_type,data_type], 0));
var map__30835 = cljs.core.meta(chart_data);
var map__30835__$1 = ((((!((map__30835 == null)))?((((map__30835.cljs$lang$protocol_mask$partition0$ & (64))) || (map__30835.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__30835):map__30835);
var nil_count = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30835__$1,cljs.core.cst$kw$nil_DASH_count);
var non_nil_count = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30835__$1,cljs.core.cst$kw$non_DASH_nil_DASH_count);
var bins = cljs.core.cst$kw$bins.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(extracted_data));
var x_series = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first,extracted_data);
var dx_series = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.second,extracted_data);
var y_series = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.last,extracted_data);
var xmin = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.min,x_series);
var xmax = (cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.max,x_series) + cljs.core.last(dx_series));
var x_scale = c2.scale.linear.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.cst$kw$domain,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [xmin,xmax], null),cljs.core.cst$kw$range,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),chart_width], null)], 0));
var y_scale = c2.scale.linear.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.cst$kw$domain,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.max,y_series)], null),cljs.core.cst$kw$range,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),chart_height], null)], 0));
var bin_width = hatti.maths.floor(((chart_width / bins) - small_margin));
var x_ticks = cljs.core.take_nth.cljs$core$IFn$_invoke$arity$2((2),cljs.core.rest(x_series));
var fmt = hatti.charting.int__GT_str(data_type);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(extracted_data))){
var vec__30837 = cljs.core.first(extracted_data);
var value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30837,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30837,(1),null);
var total = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30837,(2),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$p,total," records have identical value: ",(fmt.cljs$core$IFn$_invoke$arity$1 ? fmt.cljs$core$IFn$_invoke$arity$1(value) : fmt.call(null,value))], null)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$svg,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$width,(margin + chart_width),cljs.core.cst$kw$height,(margin + chart_height)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$g$chart,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$transform,c2.svg.translate(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [margin,(0)], null))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$g,(function (){var iter__7189__auto__ = ((function (chart_width,chart_height,margin,small_margin,y_lim,neg_margin,extracted_data,map__30835,map__30835__$1,nil_count,non_nil_count,bins,x_series,dx_series,y_series,xmin,xmax,x_scale,y_scale,bin_width,x_ticks,fmt,map__30833,map__30833__$1,data_type){
return (function hatti$charting$iter__30840(s__30841){
return (new cljs.core.LazySeq(null,((function (chart_width,chart_height,margin,small_margin,y_lim,neg_margin,extracted_data,map__30835,map__30835__$1,nil_count,non_nil_count,bins,x_series,dx_series,y_series,xmin,xmax,x_scale,y_scale,bin_width,x_ticks,fmt,map__30833,map__30833__$1,data_type){
return (function (){
var s__30841__$1 = s__30841;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__30841__$1);
if(temp__4657__auto__){
var s__30841__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__30841__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__30841__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__30843 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__30842 = (0);
while(true){
if((i__30842 < size__7188__auto__)){
var vec__30858 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__30842);
var x = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30858,(0),null);
var dx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30858,(1),null);
var y = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30858,(2),null);
cljs.core.chunk_append(b__30843,(function (){var x_scaled = (x_scale.cljs$core$IFn$_invoke$arity$1 ? x_scale.cljs$core$IFn$_invoke$arity$1(x) : x_scale.call(null,x));
var y_scaled = (y_scale.cljs$core$IFn$_invoke$arity$1 ? y_scale.cljs$core$IFn$_invoke$arity$1(y) : y_scale.call(null,y));
var vec__30861 = (((((0) < y_scaled)) && ((y_scaled < y_lim)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [small_margin,neg_margin,"out-of-bar"], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [y_scaled,small_margin,"in-bar"], null));
var y_scaled__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30861,(0),null);
var txt_ht = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30861,(1),null);
var txt_cls = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30861,(2),null);
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$g$bars,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$transform,c2.svg.translate(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [x_scaled,(chart_height - y_scaled__$1)], null))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$g,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$rect,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$x,(1),cljs.core.cst$kw$height,y_scaled__$1,cljs.core.cst$kw$width,bin_width], null)], null)], null),(((y_scaled__$1 > (0)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$text,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$y,txt_ht,cljs.core.cst$kw$x,(bin_width / 2.0),cljs.core.cst$kw$dy,"1em",cljs.core.cst$kw$text_DASH_anchor,"middle",cljs.core.cst$kw$class,txt_cls], null),y], null):null)], null);
})());

var G__30879 = (i__30842 + (1));
i__30842 = G__30879;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__30843),hatti$charting$iter__30840(cljs.core.chunk_rest(s__30841__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__30843),null);
}
} else {
var vec__30864 = cljs.core.first(s__30841__$2);
var x = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30864,(0),null);
var dx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30864,(1),null);
var y = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30864,(2),null);
return cljs.core.cons((function (){var x_scaled = (x_scale.cljs$core$IFn$_invoke$arity$1 ? x_scale.cljs$core$IFn$_invoke$arity$1(x) : x_scale.call(null,x));
var y_scaled = (y_scale.cljs$core$IFn$_invoke$arity$1 ? y_scale.cljs$core$IFn$_invoke$arity$1(y) : y_scale.call(null,y));
var vec__30867 = (((((0) < y_scaled)) && ((y_scaled < y_lim)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [small_margin,neg_margin,"out-of-bar"], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [y_scaled,small_margin,"in-bar"], null));
var y_scaled__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30867,(0),null);
var txt_ht = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30867,(1),null);
var txt_cls = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30867,(2),null);
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$g$bars,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$transform,c2.svg.translate(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [x_scaled,(chart_height - y_scaled__$1)], null))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$g,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$rect,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$x,(1),cljs.core.cst$kw$height,y_scaled__$1,cljs.core.cst$kw$width,bin_width], null)], null)], null),(((y_scaled__$1 > (0)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$text,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$y,txt_ht,cljs.core.cst$kw$x,(bin_width / 2.0),cljs.core.cst$kw$dy,"1em",cljs.core.cst$kw$text_DASH_anchor,"middle",cljs.core.cst$kw$class,txt_cls], null),y], null):null)], null);
})(),hatti$charting$iter__30840(cljs.core.rest(s__30841__$2)));
}
} else {
return null;
}
break;
}
});})(chart_width,chart_height,margin,small_margin,y_lim,neg_margin,extracted_data,map__30835,map__30835__$1,nil_count,non_nil_count,bins,x_series,dx_series,y_series,xmin,xmax,x_scale,y_scale,bin_width,x_ticks,fmt,map__30833,map__30833__$1,data_type))
,null,null));
});})(chart_width,chart_height,margin,small_margin,y_lim,neg_margin,extracted_data,map__30835,map__30835__$1,nil_count,non_nil_count,bins,x_series,dx_series,y_series,xmin,xmax,x_scale,y_scale,bin_width,x_ticks,fmt,map__30833,map__30833__$1,data_type))
;
return iter__7189__auto__(extracted_data);
})()], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$g$axis,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$transform,c2.svg.translate(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),chart_height], null))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$line,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$x1,(0),cljs.core.cst$kw$x2,chart_width], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$g,(function (){var iter__7189__auto__ = ((function (chart_width,chart_height,margin,small_margin,y_lim,neg_margin,extracted_data,map__30835,map__30835__$1,nil_count,non_nil_count,bins,x_series,dx_series,y_series,xmin,xmax,x_scale,y_scale,bin_width,x_ticks,fmt,map__30833,map__30833__$1,data_type){
return (function hatti$charting$iter__30870(s__30871){
return (new cljs.core.LazySeq(null,((function (chart_width,chart_height,margin,small_margin,y_lim,neg_margin,extracted_data,map__30835,map__30835__$1,nil_count,non_nil_count,bins,x_series,dx_series,y_series,xmin,xmax,x_scale,y_scale,bin_width,x_ticks,fmt,map__30833,map__30833__$1,data_type){
return (function (){
var s__30871__$1 = s__30871;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__30871__$1);
if(temp__4657__auto__){
var s__30871__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__30871__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__30871__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__30873 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__30872 = (0);
while(true){
if((i__30872 < size__7188__auto__)){
var x = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__30872);
cljs.core.chunk_append(b__30873,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$g$tick,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$transform,c2.svg.translate(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(x_scale.cljs$core$IFn$_invoke$arity$1 ? x_scale.cljs$core$IFn$_invoke$arity$1(x) : x_scale.call(null,x)),(0)], null))], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$text,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$y,(25),cljs.core.cst$kw$text_DASH_anchor,"middle",cljs.core.cst$kw$class,data_type], null),(fmt.cljs$core$IFn$_invoke$arity$1 ? fmt.cljs$core$IFn$_invoke$arity$1(x) : fmt.call(null,x))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$line,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$class,"tick",cljs.core.cst$kw$y2,(10),cljs.core.cst$kw$x2,(0)], null)], null)], null));

var G__30880 = (i__30872 + (1));
i__30872 = G__30880;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__30873),hatti$charting$iter__30870(cljs.core.chunk_rest(s__30871__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__30873),null);
}
} else {
var x = cljs.core.first(s__30871__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$g$tick,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$transform,c2.svg.translate(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(x_scale.cljs$core$IFn$_invoke$arity$1 ? x_scale.cljs$core$IFn$_invoke$arity$1(x) : x_scale.call(null,x)),(0)], null))], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$text,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$y,(25),cljs.core.cst$kw$text_DASH_anchor,"middle",cljs.core.cst$kw$class,data_type], null),(fmt.cljs$core$IFn$_invoke$arity$1 ? fmt.cljs$core$IFn$_invoke$arity$1(x) : fmt.call(null,x))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$line,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$class,"tick",cljs.core.cst$kw$y2,(10),cljs.core.cst$kw$x2,(0)], null)], null)], null),hatti$charting$iter__30870(cljs.core.rest(s__30871__$2)));
}
} else {
return null;
}
break;
}
});})(chart_width,chart_height,margin,small_margin,y_lim,neg_margin,extracted_data,map__30835,map__30835__$1,nil_count,non_nil_count,bins,x_series,dx_series,y_series,xmin,xmax,x_scale,y_scale,bin_width,x_ticks,fmt,map__30833,map__30833__$1,data_type))
,null,null));
});})(chart_width,chart_height,margin,small_margin,y_lim,neg_margin,extracted_data,map__30835,map__30835__$1,nil_count,non_nil_count,bins,x_series,dx_series,y_series,xmin,xmax,x_scale,y_scale,bin_width,x_ticks,fmt,map__30833,map__30833__$1,data_type))
;
return iter__7189__auto__(x_ticks);
})()], null)], null)], null)], null),hatti.charting.response_count_message(non_nil_count)], null);
}
});

hatti.charting.numeric_chart.cljs$lang$maxFixedArity = (1);

hatti.charting.numeric_chart.cljs$lang$applyTo = (function (seq30830){
var G__30831 = cljs.core.first(seq30830);
var seq30830__$1 = cljs.core.next(seq30830);
return hatti.charting.numeric_chart.cljs$core$IFn$_invoke$arity$variadic(G__30831,seq30830__$1);
});

/**
 * Create category bar chart out of some data + count data. Data of form:
 *   {'Label1' 1 'Label2' 2}, etc. where the numbers are counts.
 */
hatti.charting.table_chart_h = (function hatti$charting$table_chart_h(data,nil_count,non_nil_count,field_type){
var max_count = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.max,cljs.core.vals(data));
var percent_s = ((function (max_count){
return (function (n,total){
var s = c2.scale.linear.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.cst$kw$domain,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),total], null),cljs.core.cst$kw$range,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(100)], null)], 0));
return [cljs.core.str(chimera.js_interop.format.cljs$core$IFn$_invoke$arity$variadic("%.1f",cljs.core.array_seq([(s.cljs$core$IFn$_invoke$arity$1 ? s.cljs$core$IFn$_invoke$arity$1(n) : s.call(null,n))], 0))),cljs.core.str("%")].join('');
});})(max_count))
;
var select_mult_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(field_type,"select all that apply");
var bar_div = ((select_mult_QMARK_)?cljs.core.cst$kw$div$bars$select_DASH_mult:cljs.core.cst$kw$div$bars$select_DASH_one);
var tdr = cljs.core.cst$kw$td$t_DASH_right;
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$table_SHARP_bar_DASH_chart$table,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$thead,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$tr,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$th], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$th], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$th$t_DASH_right,"Count"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$th$t_DASH_right,"Percent"], null)], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$tfoot,((select_mult_QMARK_)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$tr$t_DASH_grey,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [tdr,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$col_DASH_span,(4)], null),hatti.charting.response_count_message(non_nil_count)], null)], null):new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$tr$t_DASH_grey,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [tdr], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tdr,"Total"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tdr,non_nil_count], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tdr,"100%"], null)], null)),(((!(select_mult_QMARK_)) && ((nil_count > (0))))?new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$tr$t_DASH_grey,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$td], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$td$t_DASH_right,"No response"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$td$t_DASH_right,nil_count], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$td], null)], null):null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$tbody,(function (){var iter__7189__auto__ = ((function (max_count,percent_s,select_mult_QMARK_,bar_div,tdr){
return (function hatti$charting$table_chart_h_$_iter__30899(s__30900){
return (new cljs.core.LazySeq(null,((function (max_count,percent_s,select_mult_QMARK_,bar_div,tdr){
return (function (){
var s__30900__$1 = s__30900;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__30900__$1);
if(temp__4657__auto__){
var s__30900__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__30900__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__30900__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__30902 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__30901 = (0);
while(true){
if((i__30901 < size__7188__auto__)){
var vec__30911 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__30901);
var label = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30911,(0),null);
var val = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30911,(1),null);
cljs.core.chunk_append(b__30902,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$tr,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$td,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$title,label], null),label], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$td,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [bar_div,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$style,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$width,percent_s(val,max_count)], null)], null)], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$td$t_DASH_right,val], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$td$t_DASH_right,percent_s(val,non_nil_count)], null)], null));

var G__30917 = (i__30901 + (1));
i__30901 = G__30917;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__30902),hatti$charting$table_chart_h_$_iter__30899(cljs.core.chunk_rest(s__30900__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__30902),null);
}
} else {
var vec__30914 = cljs.core.first(s__30900__$2);
var label = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30914,(0),null);
var val = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30914,(1),null);
return cljs.core.cons(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$tr,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$td,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$title,label], null),label], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$td,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [bar_div,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$style,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$width,percent_s(val,max_count)], null)], null)], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$td$t_DASH_right,val], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$td$t_DASH_right,percent_s(val,non_nil_count)], null)], null),hatti$charting$table_chart_h_$_iter__30899(cljs.core.rest(s__30900__$2)));
}
} else {
return null;
}
break;
}
});})(max_count,percent_s,select_mult_QMARK_,bar_div,tdr))
,null,null));
});})(max_count,percent_s,select_mult_QMARK_,bar_div,tdr))
;
return iter__7189__auto__(data);
})()], null)], null);
});
/**
 * Removes nil from Ona API chart data; adds nil- and non-nil-count metadata.
 * ex. Input:  {:field_xpath 'D' :data [{:D nil :count 5} {:D 1 :count 10}]}
 *     Output: {:field_xpath 'D' :data [{:D 1 :count 10}]}
 *             w/ metadata: {:nil-count 5 :non-nil-count 10}
 */
hatti.charting.extract_nil = (function hatti$charting$extract_nil(chart_data){
var map__30923 = chart_data;
var map__30923__$1 = ((((!((map__30923 == null)))?((((map__30923.cljs$lang$protocol_mask$partition0$ & (64))) || (map__30923.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__30923):map__30923);
var field_xpath = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30923__$1,cljs.core.cst$kw$field_xpath);
var data = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30923__$1,cljs.core.cst$kw$data);
var na_QMARK_ = ((function (map__30923,map__30923__$1,field_xpath,data){
return (function (p1__30918_SHARP_){
return ((p1__30918_SHARP_ == null)) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,p1__30918_SHARP_));
});})(map__30923,map__30923__$1,field_xpath,data))
;
var nil_data = cljs.core.first(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (map__30923,map__30923__$1,field_xpath,data,na_QMARK_){
return (function (p1__30919_SHARP_){
return na_QMARK_(cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(field_xpath).call(null,p1__30919_SHARP_));
});})(map__30923,map__30923__$1,field_xpath,data,na_QMARK_))
,data));
var non_nil_data = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(((function (map__30923,map__30923__$1,field_xpath,data,na_QMARK_,nil_data){
return (function (p1__30920_SHARP_){
return na_QMARK_(cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(field_xpath).call(null,p1__30920_SHARP_));
});})(map__30923,map__30923__$1,field_xpath,data,na_QMARK_,nil_data))
,data);
var nil_count = (function (){var temp__4655__auto__ = cljs.core.cst$kw$count.cljs$core$IFn$_invoke$arity$1(nil_data);
if(cljs.core.truth_(temp__4655__auto__)){
var n = temp__4655__auto__;
return n;
} else {
return (0);
}
})();
var non_nil_count = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$count,non_nil_data));
return cljs.core.with_meta(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(chart_data,cljs.core.cst$kw$data,non_nil_data),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$nil_DASH_count,nil_count,cljs.core.cst$kw$non_DASH_nil_DASH_count,non_nil_count], null));
});
/**
 * Make chart depending on datatype.
 */
hatti.charting.make_chart = (function hatti$charting$make_chart(var_args){
var args30926 = [];
var len__7484__auto___30934 = arguments.length;
var i__7485__auto___30935 = (0);
while(true){
if((i__7485__auto___30935 < len__7484__auto___30934)){
args30926.push((arguments[i__7485__auto___30935]));

var G__30936 = (i__7485__auto___30935 + (1));
i__7485__auto___30935 = G__30936;
continue;
} else {
}
break;
}

var G__30928 = args30926.length;
switch (G__30928) {
case 1:
return hatti.charting.make_chart.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return hatti.charting.make_chart.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30926.length)].join('')));

}
});

hatti.charting.make_chart.cljs$core$IFn$_invoke$arity$1 = (function (chart_data){
return hatti.charting.make_chart.cljs$core$IFn$_invoke$arity$2(chart_data,null);
});

hatti.charting.make_chart.cljs$core$IFn$_invoke$arity$2 = (function (chart_data,language){
var map__30929 = chart_data;
var map__30929__$1 = ((((!((map__30929 == null)))?((((map__30929.cljs$lang$protocol_mask$partition0$ & (64))) || (map__30929.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__30929):map__30929);
var field_label = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30929__$1,cljs.core.cst$kw$field_label);
var data_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30929__$1,cljs.core.cst$kw$data_type);
var field_xpath = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30929__$1,cljs.core.cst$kw$field_xpath);
var field_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30929__$1,cljs.core.cst$kw$field_type);
var chart_data__$1 = hatti.charting.extract_nil(chart_data);
var map__30930 = cljs.core.meta(chart_data__$1);
var map__30930__$1 = ((((!((map__30930 == null)))?((((map__30930.cljs$lang$protocol_mask$partition0$ & (64))) || (map__30930.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__30930):map__30930);
var nil_count = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30930__$1,cljs.core.cst$kw$nil_DASH_count);
var non_nil_count = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30930__$1,cljs.core.cst$kw$non_DASH_nil_DASH_count);
var not_supported = ((function (map__30929,map__30929__$1,field_label,data_type,field_xpath,field_type,chart_data__$1,map__30930,map__30930__$1,nil_count,non_nil_count){
return (function (p1__30925_SHARP_){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$div$t_DASH_red,[cljs.core.str("Aplogies. At the moment, making a chart of\n                                     this data type ("),cljs.core.str(p1__30925_SHARP_),cljs.core.str(") is not supported.")].join('')],null));
});})(map__30929,map__30929__$1,field_label,data_type,field_xpath,field_type,chart_data__$1,map__30930,map__30930__$1,nil_count,non_nil_count))
;
var chart = (((non_nil_count === (0)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$p,"No data"], null):(function (){var G__30933 = data_type;
switch (G__30933) {
case "categorized":
return hatti.charting.table_chart_h(hatti.charting.label_count_pairs.cljs$core$IFn$_invoke$arity$2(chart_data__$1,language),nil_count,non_nil_count,field_type);

break;
case "time_based":
return hatti.charting.numeric_chart.cljs$core$IFn$_invoke$arity$variadic(chart_data__$1,cljs.core.array_seq([cljs.core.cst$kw$data_DASH_type,"date"], 0));

break;
case "numeric":
return hatti.charting.numeric_chart(chart_data__$1);

break;
default:
return not_supported(data_type);

}
})());
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$label,field_label,cljs.core.cst$kw$name,field_xpath,cljs.core.cst$kw$chart,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div,chart], null)], null);
});

hatti.charting.make_chart.cljs$lang$maxFixedArity = 2;

