// Compiled by ClojureScript 1.9.229 {:static-fns true, :optimize-constants true}
goog.provide('hatti.views.dataview');
goog.require('cljs.core');
goog.require('chimera.js_interop');
goog.require('chimera.om.state');
goog.require('hatti.views.photos');
goog.require('sablono.core');
goog.require('cljs.core.async');
goog.require('hatti.views.map');
goog.require('hatti.views.chart');
goog.require('hatti.shared');
goog.require('hatti.views.saved_charts');
goog.require('hatti.ona.forms');
goog.require('hatti.constants');
goog.require('hatti.views');
goog.require('hatti.views.settings');
goog.require('om.core');
goog.require('hatti.utils');
goog.require('hatti.views.overview');
goog.require('hatti.views.table');
hatti.views.dataview.dataview_map = new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$overview,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$view,cljs.core.cst$kw$overview,cljs.core.cst$kw$label,"Overview",cljs.core.cst$kw$component,hatti.views.overview_page], null),cljs.core.cst$kw$map,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$view,cljs.core.cst$kw$map,cljs.core.cst$kw$label,"Map",cljs.core.cst$kw$component,hatti.views.map_page], null),cljs.core.cst$kw$table,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$view,cljs.core.cst$kw$table,cljs.core.cst$kw$label,"Table",cljs.core.cst$kw$component,hatti.views.table_page], null),cljs.core.cst$kw$photos,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$view,cljs.core.cst$kw$photos,cljs.core.cst$kw$label,"Photos",cljs.core.cst$kw$component,hatti.views.photos_page], null),cljs.core.cst$kw$chart,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$view,cljs.core.cst$kw$chart,cljs.core.cst$kw$label,"Charts",cljs.core.cst$kw$component,hatti.views.chart_page], null),cljs.core.cst$kw$saved_DASH_charts,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$view,cljs.core.cst$kw$saved_DASH_charts,cljs.core.cst$kw$label,"Dashboard",cljs.core.cst$kw$component,hatti.views.saved_charts_page], null),cljs.core.cst$kw$settings,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$view,cljs.core.cst$kw$settings,cljs.core.cst$kw$label,"Settings",cljs.core.cst$kw$component,hatti.views.settings_page], null)], null);
hatti.views.dataview_actions.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (cursor,owner){
if(typeof hatti.views.dataview.t_hatti$views$dataview34344 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.dataview.t_hatti$views$dataview34344 = (function (cursor,owner,meta34345){
this.cursor = cursor;
this.owner = owner;
this.meta34345 = meta34345;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.dataview.t_hatti$views$dataview34344.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34346,meta34345__$1){
var self__ = this;
var _34346__$1 = this;
return (new hatti.views.dataview.t_hatti$views$dataview34344(self__.cursor,self__.owner,meta34345__$1));
});

hatti.views.dataview.t_hatti$views$dataview34344.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34346){
var self__ = this;
var _34346__$1 = this;
return self__.meta34345;
});

hatti.views.dataview.t_hatti$views$dataview34344.prototype.om$core$IRender$ = true;

hatti.views.dataview.t_hatti$views$dataview34344.prototype.om$core$IRender$render$arity$1 = (function (this__16392__auto__){
var self__ = this;
var this__16392__auto____$1 = this;
return null;
});

hatti.views.dataview.t_hatti$views$dataview34344.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$cursor,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta34345], null);
});

hatti.views.dataview.t_hatti$views$dataview34344.cljs$lang$type = true;

hatti.views.dataview.t_hatti$views$dataview34344.cljs$lang$ctorStr = "hatti.views.dataview/t_hatti$views$dataview34344";

hatti.views.dataview.t_hatti$views$dataview34344.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"hatti.views.dataview/t_hatti$views$dataview34344");
});

hatti.views.dataview.__GT_t_hatti$views$dataview34344 = (function hatti$views$dataview$__GT_t_hatti$views$dataview34344(cursor__$1,owner__$1,meta34345){
return (new hatti.views.dataview.t_hatti$views$dataview34344(cursor__$1,owner__$1,meta34345));
});

}

return (new hatti.views.dataview.t_hatti$views$dataview34344(cursor,owner,null));
}));
hatti.views.dataview_infobar.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (p__34347,owner){
var map__34348 = p__34347;
var map__34348__$1 = ((((!((map__34348 == null)))?((((map__34348.cljs$lang$protocol_mask$partition0$ & (64))) || (map__34348.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__34348):map__34348);
var dataset_info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34348__$1,cljs.core.cst$kw$dataset_DASH_info);
var status = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34348__$1,cljs.core.cst$kw$status);
if(typeof hatti.views.dataview.t_hatti$views$dataview34350 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {om.core.IWillMount}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.dataview.t_hatti$views$dataview34350 = (function (p__34347,owner,map__34348,dataset_info,status,meta34351){
this.p__34347 = p__34347;
this.owner = owner;
this.map__34348 = map__34348;
this.dataset_info = dataset_info;
this.status = status;
this.meta34351 = meta34351;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.dataview.t_hatti$views$dataview34350.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (map__34348,map__34348__$1,dataset_info,status){
return (function (_34352,meta34351__$1){
var self__ = this;
var _34352__$1 = this;
return (new hatti.views.dataview.t_hatti$views$dataview34350(self__.p__34347,self__.owner,self__.map__34348,self__.dataset_info,self__.status,meta34351__$1));
});})(map__34348,map__34348__$1,dataset_info,status))
;

hatti.views.dataview.t_hatti$views$dataview34350.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (map__34348,map__34348__$1,dataset_info,status){
return (function (_34352){
var self__ = this;
var _34352__$1 = this;
return self__.meta34351;
});})(map__34348,map__34348__$1,dataset_info,status))
;

hatti.views.dataview.t_hatti$views$dataview34350.prototype.om$core$IWillMount$ = true;

hatti.views.dataview.t_hatti$views$dataview34350.prototype.om$core$IWillMount$will_mount$arity$1 = ((function (map__34348,map__34348__$1,dataset_info,status){
return (function (_){
var self__ = this;
var ___$1 = this;
var form = om.core.get_shared.cljs$core$IFn$_invoke$arity$2(self__.owner,cljs.core.cst$kw$flat_DASH_form);
var langs = hatti.ona.forms.get_languages(form);
var default_lang = hatti.ona.forms.default_lang(langs);
var lang_state = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$all,langs,cljs.core.cst$kw$default,default_lang,cljs.core.cst$kw$current,default_lang], null);
if(cljs.core.truth_(hatti.ona.forms.multilingual_QMARK_(form))){
return chimera.om.state.merge_into_app_state_BANG_.cljs$core$IFn$_invoke$arity$3(hatti.shared.app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$languages], null),lang_state);
} else {
return null;
}
});})(map__34348,map__34348__$1,dataset_info,status))
;

hatti.views.dataview.t_hatti$views$dataview34350.prototype.om$core$IRender$ = true;

hatti.views.dataview.t_hatti$views$dataview34350.prototype.om$core$IRender$render$arity$1 = ((function (map__34348,map__34348__$1,dataset_info,status){
return (function (_){
var self__ = this;
var ___$1 = this;
var form = om.core.get_shared.cljs$core$IFn$_invoke$arity$2(self__.owner,cljs.core.cst$kw$flat_DASH_form);
var map__34353 = om.core.get_shared.cljs$core$IFn$_invoke$arity$1(self__.owner);
var map__34353__$1 = ((((!((map__34353 == null)))?((((map__34353.cljs$lang$protocol_mask$partition0$ & (64))) || (map__34353.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__34353):map__34353);
var dataset_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34353__$1,cljs.core.cst$kw$dataset_DASH_id);
var map__34354 = self__.dataset_info;
var map__34354__$1 = ((((!((map__34354 == null)))?((((map__34354.cljs$lang$protocol_mask$partition0$ & (64))) || (map__34354.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__34354):map__34354);
var num_of_submissions = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34354__$1,cljs.core.cst$kw$num_of_submissions);
var map__34355 = self__.status;
var map__34355__$1 = ((((!((map__34355 == null)))?((((map__34355.cljs$lang$protocol_mask$partition0$ & (64))) || (map__34355.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__34355):map__34355);
var loading_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34355__$1,cljs.core.cst$kw$loading_QMARK_);
var total_records = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34355__$1,cljs.core.cst$kw$total_DASH_records);
var G__34363 = ({"className": "right rec-summary rec-margin"});
var G__34364 = (function (){var attrs34359 = (cljs.core.truth_(hatti.ona.forms.multilingual_QMARK_(form))?om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.shared.language_selector,null):null);
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(React.DOM.div,((cljs.core.map_QMARK_(attrs34359))?sablono.interpreter.attributes(sablono.util.merge_with_class.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$id,"language-selector"], null),attrs34359], 0))):({"id": "language-selector"})),cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,((cljs.core.map_QMARK_(attrs34359))?cljs.core.PersistentVector.EMPTY:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret(attrs34359)], null))));
})();
var G__34365 = (function (){var G__34368 = ({"id": "data-status"});
var G__34369 = (function (){var attrs34360 = (cljs.core.truth_(loading_QMARK_)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$i$fa$fa_DASH_spinner$fa_DASH_pulse], null):null);
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(React.DOM.span,((cljs.core.map_QMARK_(attrs34360))?sablono.interpreter.attributes(sablono.util.merge_with_class.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["rec"], null)], null),attrs34360], 0))):({"className": "rec"})),cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,((cljs.core.map_QMARK_(attrs34360))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret(hatti.utils.pluralize_number(num_of_submissions," Record"))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret(attrs34360),sablono.interpreter.interpret(hatti.utils.pluralize_number(num_of_submissions," Record"))], null))));
})();
return React.DOM.div(G__34368,G__34369);
})();
var G__34366 = (function (){var G__34370 = ({"className": "divider"});
return React.DOM.div(G__34370);
})();
var G__34367 = sablono.interpreter.interpret(om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.views.dataview_actions,dataset_id));
return React.DOM.div(G__34363,G__34364,G__34365,G__34366,G__34367);
});})(map__34348,map__34348__$1,dataset_info,status))
;

hatti.views.dataview.t_hatti$views$dataview34350.getBasis = ((function (map__34348,map__34348__$1,dataset_info,status){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p__34347,cljs.core.cst$sym$owner,cljs.core.cst$sym$map__34348,cljs.core.cst$sym$dataset_DASH_info,cljs.core.cst$sym$status,cljs.core.cst$sym$meta34351], null);
});})(map__34348,map__34348__$1,dataset_info,status))
;

hatti.views.dataview.t_hatti$views$dataview34350.cljs$lang$type = true;

hatti.views.dataview.t_hatti$views$dataview34350.cljs$lang$ctorStr = "hatti.views.dataview/t_hatti$views$dataview34350";

hatti.views.dataview.t_hatti$views$dataview34350.cljs$lang$ctorPrWriter = ((function (map__34348,map__34348__$1,dataset_info,status){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"hatti.views.dataview/t_hatti$views$dataview34350");
});})(map__34348,map__34348__$1,dataset_info,status))
;

hatti.views.dataview.__GT_t_hatti$views$dataview34350 = ((function (map__34348,map__34348__$1,dataset_info,status){
return (function hatti$views$dataview$__GT_t_hatti$views$dataview34350(p__34347__$1,owner__$1,map__34348__$2,dataset_info__$1,status__$1,meta34351){
return (new hatti.views.dataview.t_hatti$views$dataview34350(p__34347__$1,owner__$1,map__34348__$2,dataset_info__$1,status__$1,meta34351));
});})(map__34348,map__34348__$1,dataset_info,status))
;

}

return (new hatti.views.dataview.t_hatti$views$dataview34350(p__34347,owner,map__34348__$1,dataset_info,status,cljs.core.PersistentArrayMap.EMPTY));
}));
/**
 * Strip off ampersand suffixes then switch to view if result is a valid view
 */
hatti.views.dataview.activate_view_BANG_ = (function hatti$views$dataview$activate_view_BANG_(view){
var view__$1 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1((function (){var or__6409__auto__ = cljs.core.last(cljs.core.re_find(/(.*?)&/,view));
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return view;
}
})());
var views = cljs.core.cst$kw$all.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$views.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.shared.app_state) : cljs.core.deref.call(null,hatti.shared.app_state))));
if(cljs.core.contains_QMARK_(cljs.core.set(views),view__$1)){
chimera.om.state.merge_into_app_state_BANG_.cljs$core$IFn$_invoke$arity$3(hatti.shared.app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$views], null),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$selected,view__$1], null));

return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$re_DASH_render,view__$1], null));
} else {
return null;
}
});
hatti.views.dataview.activate_settings_view_BANG_ = (function hatti$views$dataview$activate_settings_view_BANG_(view,settings_section){
var view__$1 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(view);
var settings_section__$1 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(settings_section);
var views = cljs.core.cst$kw$all.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$views.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.shared.app_state) : cljs.core.deref.call(null,hatti.shared.app_state))));
var settings_views = cljs.core.cst$kw$all.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$settings.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$views.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.shared.app_state) : cljs.core.deref.call(null,hatti.shared.app_state)))));
if(cljs.core.contains_QMARK_(cljs.core.set(settings_views),settings_section__$1)){
chimera.om.state.merge_into_app_state_BANG_.cljs$core$IFn$_invoke$arity$3(hatti.shared.app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$views], null),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$selected,view__$1], null));

chimera.om.state.merge_into_app_state_BANG_.cljs$core$IFn$_invoke$arity$3(hatti.shared.app_state,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$views,cljs.core.cst$kw$settings], null),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$active_DASH_tab,settings_section__$1], null));

return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$re_DASH_render,view__$1], null));
} else {
return null;
}
});
hatti.views.dataview.activate_integrated_apps_view_BANG_ = (function hatti$views$dataview$activate_integrated_apps_view_BANG_(view,settings_section,app_type){
var view__$1 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(view);
var settings_section__$1 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(settings_section);
var settings_views = cljs.core.cst$kw$all.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$settings.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$views.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.shared.app_state) : cljs.core.deref.call(null,hatti.shared.app_state)))));
if(cljs.core.contains_QMARK_(cljs.core.set(settings_views),settings_section__$1)){
chimera.om.state.transact_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.app_state,((function (view__$1,settings_section__$1,settings_views){
return (function (app_state){
return cljs.core.assoc_in(cljs.core.assoc_in(cljs.core.assoc_in(app_state,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$views,cljs.core.cst$kw$selected], null),view__$1),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$views,cljs.core.cst$kw$settings,cljs.core.cst$kw$active_DASH_tab], null),settings_section__$1),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$views,cljs.core.cst$kw$settings,cljs.core.cst$kw$integrated_DASH_apps,cljs.core.cst$kw$active_DASH_section], null),app_type);
});})(view__$1,settings_section__$1,settings_views))
);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(app_type,hatti.constants.google_sheets)){
chimera.om.state.merge_into_app_state_BANG_.cljs$core$IFn$_invoke$arity$3(hatti.shared.app_state,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$views,cljs.core.cst$kw$settings,cljs.core.cst$kw$integrated_DASH_apps], null),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$add_QMARK_,true], null));
} else {
}

return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$re_DASH_render,view__$1], null));
} else {
return null;
}
});
hatti.views.tabbed_dataview.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (app_state,owner,opts){
if(typeof hatti.views.dataview.t_hatti$views$dataview34374 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRenderState}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IInitState}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.dataview.t_hatti$views$dataview34374 = (function (app_state,owner,opts,meta34375){
this.app_state = app_state;
this.owner = owner;
this.opts = opts;
this.meta34375 = meta34375;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.dataview.t_hatti$views$dataview34374.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34376,meta34375__$1){
var self__ = this;
var _34376__$1 = this;
return (new hatti.views.dataview.t_hatti$views$dataview34374(self__.app_state,self__.owner,self__.opts,meta34375__$1));
});

hatti.views.dataview.t_hatti$views$dataview34374.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34376){
var self__ = this;
var _34376__$1 = this;
return self__.meta34375;
});

hatti.views.dataview.t_hatti$views$dataview34374.prototype.om$core$IInitState$ = true;

hatti.views.dataview.t_hatti$views$dataview34374.prototype.om$core$IInitState$init_state$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var form = om.core.get_shared.cljs$core$IFn$_invoke$arity$2(self__.owner,cljs.core.cst$kw$flat_DASH_form);
var geopoints_QMARK_ = cljs.core.cst$kw$instances_with_geopoints.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$dataset_DASH_info.cljs$core$IFn$_invoke$arity$1(self__.app_state));
var no_geodata_QMARK_ = cljs.core.not((function (){var or__6409__auto__ = geopoints_QMARK_;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
var or__6409__auto____$1 = cljs.core.some(hatti.ona.forms.geopoint_QMARK_,form);
if(cljs.core.truth_(or__6409__auto____$1)){
return or__6409__auto____$1;
} else {
return cljs.core.some(hatti.ona.forms.geofield_QMARK_,form);
}
}
})());
if((no_geodata_QMARK_) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$map,cljs.core.cst$kw$selected.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$views.cljs$core$IFn$_invoke$arity$1(self__.app_state))))){
om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(self__.app_state,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$views,cljs.core.cst$kw$selected], null),cljs.core.cst$kw$table);
} else {
}

return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$no_DASH_geodata_QMARK_,no_geodata_QMARK_], null);
});

hatti.views.dataview.t_hatti$views$dataview34374.prototype.om$core$IRenderState$ = true;

hatti.views.dataview.t_hatti$views$dataview34374.prototype.om$core$IRenderState$render_state$arity$2 = (function (_,p__34377){
var self__ = this;
var map__34378 = p__34377;
var map__34378__$1 = ((((!((map__34378 == null)))?((((map__34378.cljs$lang$protocol_mask$partition0$ & (64))) || (map__34378.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__34378):map__34378);
var no_geodata_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34378__$1,cljs.core.cst$kw$no_DASH_geodata_QMARK_);
var ___$1 = this;
var active_view = cljs.core.cst$kw$selected.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$views.cljs$core$IFn$_invoke$arity$1(self__.app_state));
var view__GT_display = ((function (active_view,___$1,map__34378,map__34378__$1,no_geodata_QMARK_){
return (function (p1__34371_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(active_view,p1__34371_SHARP_)){
return "block";
} else {
return "none";
}
});})(active_view,___$1,map__34378,map__34378__$1,no_geodata_QMARK_))
;
var view__GT_cls = ((function (active_view,view__GT_display,___$1,map__34378,map__34378__$1,no_geodata_QMARK_){
return (function (p1__34372_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(active_view,p1__34372_SHARP_)){
return "clicked";
} else {
return null;
}
});})(active_view,view__GT_display,___$1,map__34378,map__34378__$1,no_geodata_QMARK_))
;
var dataviews = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,cljs.core.map.cljs$core$IFn$_invoke$arity$2(hatti.views.dataview.dataview_map,cljs.core.cst$kw$all.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$views.cljs$core$IFn$_invoke$arity$1(self__.app_state))));
var dv__GT_link = ((function (active_view,view__GT_display,view__GT_cls,dataviews,___$1,map__34378,map__34378__$1,no_geodata_QMARK_){
return (function (p__34380){
var map__34381 = p__34380;
var map__34381__$1 = ((((!((map__34381 == null)))?((((map__34381.cljs$lang$protocol_mask$partition0$ & (64))) || (map__34381.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__34381):map__34381);
var view = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34381__$1,cljs.core.cst$kw$view);
var label = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34381__$1,cljs.core.cst$kw$label);
var active_QMARK_ = cljs.core.some(((function (map__34381,map__34381__$1,view,label,active_view,view__GT_display,view__GT_cls,dataviews,___$1,map__34378,map__34378__$1,no_geodata_QMARK_){
return (function (p1__34373_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(view,p1__34373_SHARP_);
});})(map__34381,map__34381__$1,view,label,active_view,view__GT_display,view__GT_cls,dataviews,___$1,map__34378,map__34378__$1,no_geodata_QMARK_))
,cljs.core.cst$kw$active.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$views.cljs$core$IFn$_invoke$arity$1(self__.app_state)));
if(cljs.core.truth_((function (){var and__6397__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(view,cljs.core.cst$kw$map);
if(and__6397__auto__){
return no_geodata_QMARK_;
} else {
return and__6397__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$class,"inactive",cljs.core.cst$kw$title,"No geodata"], null),cljs.core.name(view)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$href,(cljs.core.truth_(active_QMARK_)?[cljs.core.str("#/"),cljs.core.str(cljs.core.name(view))].join(''):null),cljs.core.cst$kw$class,(cljs.core.truth_(active_QMARK_)?view__GT_cls(view):"inactive")], null),label], null);

}
});})(active_view,view__GT_display,view__GT_cls,dataviews,___$1,map__34378,map__34378__$1,no_geodata_QMARK_))
;
var G__34384 = ({"className": "tab-container dataset-tabs"});
var G__34385 = (function (){var attrs34383 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(dv__GT_link,dataviews);
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(React.DOM.div,((cljs.core.map_QMARK_(attrs34383))?sablono.interpreter.attributes(sablono.util.merge_with_class.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["tab-bar"], null)], null),attrs34383], 0))):({"className": "tab-bar"})),cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,((cljs.core.map_QMARK_(attrs34383))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret(om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.views.dataview_infobar,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$dataset_DASH_info,cljs.core.cst$kw$dataset_DASH_info.cljs$core$IFn$_invoke$arity$1(self__.app_state),cljs.core.cst$kw$status,cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(self__.app_state)], null)))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret(attrs34383),sablono.interpreter.interpret(om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.views.dataview_infobar,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$dataset_DASH_info,cljs.core.cst$kw$dataset_DASH_info.cljs$core$IFn$_invoke$arity$1(self__.app_state),cljs.core.cst$kw$status,cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(self__.app_state)], null)))], null))));
})();
var G__34386 = cljs.core.into_array.cljs$core$IFn$_invoke$arity$1((function (){var iter__7189__auto__ = ((function (G__34384,G__34385,active_view,view__GT_display,view__GT_cls,dataviews,dv__GT_link,___$1,map__34378,map__34378__$1,no_geodata_QMARK_){
return (function hatti$views$dataview$iter__34387(s__34388){
return (new cljs.core.LazySeq(null,((function (G__34384,G__34385,active_view,view__GT_display,view__GT_cls,dataviews,dv__GT_link,___$1,map__34378,map__34378__$1,no_geodata_QMARK_){
return (function (){
var s__34388__$1 = s__34388;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__34388__$1);
if(temp__4657__auto__){
var s__34388__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__34388__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__34388__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__34390 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__34389 = (0);
while(true){
if((i__34389 < size__7188__auto__)){
var map__34401 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__34389);
var map__34401__$1 = ((((!((map__34401 == null)))?((((map__34401.cljs$lang$protocol_mask$partition0$ & (64))) || (map__34401.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__34401):map__34401);
var component = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34401__$1,cljs.core.cst$kw$component);
var view = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34401__$1,cljs.core.cst$kw$view);
cljs.core.chunk_append(b__34390,(function (){var G__34403 = ({"style": ({"display": view__GT_display(view)}), "className": [cljs.core.str("tab-page "),cljs.core.str(cljs.core.name(view)),cljs.core.str("-page")].join('')});
var G__34404 = sablono.interpreter.interpret(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(active_view,view))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$tab_DASH_content,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$id,[cljs.core.str("tab-content"),cljs.core.str(cljs.core.name(view))].join('')], null),om.core.build.cljs$core$IFn$_invoke$arity$3(component,self__.app_state,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$opts,self__.opts], null))], null):null));
return React.DOM.div(G__34403,G__34404);
})());

var G__34409 = (i__34389 + (1));
i__34389 = G__34409;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__34390),hatti$views$dataview$iter__34387(cljs.core.chunk_rest(s__34388__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__34390),null);
}
} else {
var map__34405 = cljs.core.first(s__34388__$2);
var map__34405__$1 = ((((!((map__34405 == null)))?((((map__34405.cljs$lang$protocol_mask$partition0$ & (64))) || (map__34405.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__34405):map__34405);
var component = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34405__$1,cljs.core.cst$kw$component);
var view = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34405__$1,cljs.core.cst$kw$view);
return cljs.core.cons((function (){var G__34407 = ({"style": ({"display": view__GT_display(view)}), "className": [cljs.core.str("tab-page "),cljs.core.str(cljs.core.name(view)),cljs.core.str("-page")].join('')});
var G__34408 = sablono.interpreter.interpret(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(active_view,view))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$tab_DASH_content,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$id,[cljs.core.str("tab-content"),cljs.core.str(cljs.core.name(view))].join('')], null),om.core.build.cljs$core$IFn$_invoke$arity$3(component,self__.app_state,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$opts,self__.opts], null))], null):null));
return React.DOM.div(G__34407,G__34408);
})(),hatti$views$dataview$iter__34387(cljs.core.rest(s__34388__$2)));
}
} else {
return null;
}
break;
}
});})(G__34384,G__34385,active_view,view__GT_display,view__GT_cls,dataviews,dv__GT_link,___$1,map__34378,map__34378__$1,no_geodata_QMARK_))
,null,null));
});})(G__34384,G__34385,active_view,view__GT_display,view__GT_cls,dataviews,dv__GT_link,___$1,map__34378,map__34378__$1,no_geodata_QMARK_))
;
return iter__7189__auto__(dataviews);
})());
return React.DOM.div(G__34384,G__34385,G__34386);
});

hatti.views.dataview.t_hatti$views$dataview34374.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$app_DASH_state,cljs.core.cst$sym$owner,cljs.core.cst$sym$opts,cljs.core.cst$sym$meta34375], null);
});

hatti.views.dataview.t_hatti$views$dataview34374.cljs$lang$type = true;

hatti.views.dataview.t_hatti$views$dataview34374.cljs$lang$ctorStr = "hatti.views.dataview/t_hatti$views$dataview34374";

hatti.views.dataview.t_hatti$views$dataview34374.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"hatti.views.dataview/t_hatti$views$dataview34374");
});

hatti.views.dataview.__GT_t_hatti$views$dataview34374 = (function hatti$views$dataview$__GT_t_hatti$views$dataview34374(app_state__$1,owner__$1,opts__$1,meta34375){
return (new hatti.views.dataview.t_hatti$views$dataview34374(app_state__$1,owner__$1,opts__$1,meta34375));
});

}

return (new hatti.views.dataview.t_hatti$views$dataview34374(app_state,owner,opts,cljs.core.PersistentArrayMap.EMPTY));
}));
