// Compiled by ClojureScript 1.9.229 {}
goog.provide('c2.layout.histogram');
goog.require('cljs.core');
goog.require('c2.maths');
c2.layout.histogram.binary_search = (function c2$layout$histogram$binary_search(v,target){

var low = (0);
var high = (cljs.core.count.call(null,v) - (1));
while(true){
if((low > high)){
return (- (low + (1)));
} else {
var mid = cljs.core.quot.call(null,(low + high),(2));
var mid_val = v.call(null,mid);
if((mid_val < target)){
var G__18863 = (mid + (1));
var G__18864 = high;
low = G__18863;
high = G__18864;
continue;
} else {
if((target < mid_val)){
var G__18865 = low;
var G__18866 = (mid - (1));
low = G__18865;
high = G__18866;
continue;
} else {
return mid;

}
}
}
break;
}
});
/**
 * Calulate reasonable number of bins assuming an approximately normal
 *   distribution
 */
c2.layout.histogram.sturges = (function c2$layout$histogram$sturges(values){
return ((c2.maths.log.call(null,cljs.core.count.call(null,values),(2)) | (0)) + (1));
});
/**
 * Return the inclusive upper threshold of all bins
 */
c2.layout.histogram.fixed_size_bins = (function c2$layout$histogram$fixed_size_bins(p__18867,n){
var vec__18875 = p__18867;
var mn = cljs.core.nth.call(null,vec__18875,(0),null);
var mx = cljs.core.nth.call(null,vec__18875,(1),null);
var size = ((mx - mn) / n);
return cljs.core.vec.call(null,(function (){var iter__7189__auto__ = ((function (size,vec__18875,mn,mx){
return (function c2$layout$histogram$fixed_size_bins_$_iter__18878(s__18879){
return (new cljs.core.LazySeq(null,((function (size,vec__18875,mn,mx){
return (function (){
var s__18879__$1 = s__18879;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__18879__$1);
if(temp__4657__auto__){
var s__18879__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__18879__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__18879__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__18881 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__18880 = (0);
while(true){
if((i__18880 < size__7188__auto__)){
var step = cljs.core._nth.call(null,c__7187__auto__,i__18880);
cljs.core.chunk_append.call(null,b__18881,(mn + (size * step)));

var G__18882 = (i__18880 + (1));
i__18880 = G__18882;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__18881),c2$layout$histogram$fixed_size_bins_$_iter__18878.call(null,cljs.core.chunk_rest.call(null,s__18879__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__18881),null);
}
} else {
var step = cljs.core.first.call(null,s__18879__$2);
return cljs.core.cons.call(null,(mn + (size * step)),c2$layout$histogram$fixed_size_bins_$_iter__18878.call(null,cljs.core.rest.call(null,s__18879__$2)));
}
} else {
return null;
}
break;
}
});})(size,vec__18875,mn,mx))
,null,null));
});})(size,vec__18875,mn,mx))
;
return iter__7189__auto__.call(null,cljs.core.range.call(null,(n + (1))));
})());
});
/**
 * The histogram layout transforms data by grouping descrete data points into
 *   bins. Returns a collection of values with the following metadata set:
 * 
 *   > *:x* the lower bound of the bin (inclusive).
 * 
 *   > *:dx* the width of the bin; x + dx is the upper bound (exclusive).
 * 
 *   > *:y* the count
 * 
 * Kwargs:
 * 
 * > *:value* fn that calculates value of node, defaults to `:value`
 * 
 * > *:index* opaque value passed to `:bins` and `:range`
 * 
 * > *:range* fn which calculates the minimum and maximum values given the array of values
 * 
 * > *:bins* Number of bins /or/ fn that takes the range, array of values, and current index
 */
c2.layout.histogram.histogram = (function c2$layout$histogram$histogram(var_args){
var args__7491__auto__ = [];
var len__7484__auto___18892 = arguments.length;
var i__7485__auto___18893 = (0);
while(true){
if((i__7485__auto___18893 < len__7484__auto___18892)){
args__7491__auto__.push((arguments[i__7485__auto___18893]));

var G__18894 = (i__7485__auto___18893 + (1));
i__7485__auto___18893 = G__18894;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return c2.layout.histogram.histogram.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

c2.layout.histogram.histogram.cljs$core$IFn$_invoke$arity$variadic = (function (data,p__18885){
var map__18886 = p__18885;
var map__18886__$1 = ((((!((map__18886 == null)))?((((map__18886.cljs$lang$protocol_mask$partition0$ & (64))) || (map__18886.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__18886):map__18886);
var value = cljs.core.get.call(null,map__18886__$1,new cljs.core.Keyword(null,"value","value",305978217),new cljs.core.Keyword(null,"value","value",305978217));
var index = cljs.core.get.call(null,map__18886__$1,new cljs.core.Keyword(null,"index","index",-1531685915));
var range = cljs.core.get.call(null,map__18886__$1,new cljs.core.Keyword(null,"range","range",1639692286),((function (map__18886,map__18886__$1,value,index){
return (function (xs,_){
return cljs.core.juxt.call(null,cljs.core.partial.call(null,cljs.core.reduce,cljs.core.min),cljs.core.partial.call(null,cljs.core.reduce,cljs.core.max)).call(null,xs);
});})(map__18886,map__18886__$1,value,index))
);
var bins = cljs.core.get.call(null,map__18886__$1,new cljs.core.Keyword(null,"bins","bins",1670395210),((function (map__18886,map__18886__$1,value,index,range){
return (function (r,xs,_){
return c2.layout.histogram.fixed_size_bins.call(null,r,c2.layout.histogram.sturges.call(null,xs));
});})(map__18886,map__18886__$1,value,index,range))
);
var values = cljs.core.map.call(null,value,data);
var r = ((cljs.core.fn_QMARK_.call(null,range))?range.call(null,values,index):range
);
var thresholds = ((cljs.core.fn_QMARK_.call(null,bins))?bins.call(null,r,values,index):((typeof bins === 'number')?c2.layout.histogram.fixed_size_bins.call(null,r,bins):bins
));
var binner = ((function (values,r,thresholds,map__18886,map__18886__$1,value,index,range,bins){
return (function (e){
return (Math.abs((c2.layout.histogram.binary_search.call(null,cljs.core.subvec.call(null,thresholds,(0),(cljs.core.count.call(null,thresholds) - (1))),value.call(null,e)) + (1))) - (1));
});})(values,r,thresholds,map__18886,map__18886__$1,value,index,range,bins))
;
var groups = cljs.core.group_by.call(null,binner,cljs.core.filter.call(null,((function (values,r,thresholds,binner,map__18886,map__18886__$1,value,index,range,bins){
return (function (p1__109951_SHARP_){
return ((value.call(null,p1__109951_SHARP_) >= r.call(null,(0)))) && ((value.call(null,p1__109951_SHARP_) <= r.call(null,(1))));
});})(values,r,thresholds,binner,map__18886,map__18886__$1,value,index,range,bins))
,data));
return cljs.core.map_indexed.call(null,((function (values,r,thresholds,binner,groups,map__18886,map__18886__$1,value,index,range,bins){
return (function (index__$1,p__18888){
var vec__18889 = p__18888;
var mn = cljs.core.nth.call(null,vec__18889,(0),null);
var mx = cljs.core.nth.call(null,vec__18889,(1),null);
var group = (function (){var or__6409__auto__ = groups.call(null,index__$1);
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})();
return cljs.core.with_meta.call(null,group,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"x","x",2099068185),mn,new cljs.core.Keyword(null,"dx","dx",-381796732),(mx - mn),new cljs.core.Keyword(null,"y","y",-1757859776),cljs.core.count.call(null,group)], null));
});})(values,r,thresholds,binner,groups,map__18886,map__18886__$1,value,index,range,bins))
,cljs.core.partition.call(null,(2),(1),thresholds));
});

c2.layout.histogram.histogram.cljs$lang$maxFixedArity = (1);

c2.layout.histogram.histogram.cljs$lang$applyTo = (function (seq18883){
var G__18884 = cljs.core.first.call(null,seq18883);
var seq18883__$1 = cljs.core.next.call(null,seq18883);
return c2.layout.histogram.histogram.cljs$core$IFn$_invoke$arity$variadic(G__18884,seq18883__$1);
});

