// Compiled by ClojureScript 1.9.229 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var args12276 = [];
var len__7484__auto___12282 = arguments.length;
var i__7485__auto___12283 = (0);
while(true){
if((i__7485__auto___12283 < len__7484__auto___12282)){
args12276.push((arguments[i__7485__auto___12283]));

var G__12284 = (i__7485__auto___12283 + (1));
i__7485__auto___12283 = G__12284;
continue;
} else {
}
break;
}

var G__12278 = args12276.length;
switch (G__12278) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12276.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async12279 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12279 = (function (f,blockable,meta12280){
this.f = f;
this.blockable = blockable;
this.meta12280 = meta12280;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async12279.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_12281,meta12280__$1){
var self__ = this;
var _12281__$1 = this;
return (new cljs.core.async.t_cljs$core$async12279(self__.f,self__.blockable,meta12280__$1));
});

cljs.core.async.t_cljs$core$async12279.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_12281){
var self__ = this;
var _12281__$1 = this;
return self__.meta12280;
});

cljs.core.async.t_cljs$core$async12279.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async12279.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async12279.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async12279.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async12279.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta12280","meta12280",1581091996,null)], null);
});

cljs.core.async.t_cljs$core$async12279.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async12279.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12279";

cljs.core.async.t_cljs$core$async12279.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"cljs.core.async/t_cljs$core$async12279");
});

cljs.core.async.__GT_t_cljs$core$async12279 = (function cljs$core$async$__GT_t_cljs$core$async12279(f__$1,blockable__$1,meta12280){
return (new cljs.core.async.t_cljs$core$async12279(f__$1,blockable__$1,meta12280));
});

}

return (new cljs.core.async.t_cljs$core$async12279(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || (buff.cljs$core$async$impl$protocols$UnblockingBuffer$)){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args12288 = [];
var len__7484__auto___12291 = arguments.length;
var i__7485__auto___12292 = (0);
while(true){
if((i__7485__auto___12292 < len__7484__auto___12291)){
args12288.push((arguments[i__7485__auto___12292]));

var G__12293 = (i__7485__auto___12292 + (1));
i__7485__auto___12292 = G__12293;
continue;
} else {
}
break;
}

var G__12290 = args12288.length;
switch (G__12290) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12288.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str("buf-or-n")].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var args12295 = [];
var len__7484__auto___12298 = arguments.length;
var i__7485__auto___12299 = (0);
while(true){
if((i__7485__auto___12299 < len__7484__auto___12298)){
args12295.push((arguments[i__7485__auto___12299]));

var G__12300 = (i__7485__auto___12299 + (1));
i__7485__auto___12299 = G__12300;
continue;
} else {
}
break;
}

var G__12297 = args12295.length;
switch (G__12297) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12295.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args12302 = [];
var len__7484__auto___12305 = arguments.length;
var i__7485__auto___12306 = (0);
while(true){
if((i__7485__auto___12306 < len__7484__auto___12305)){
args12302.push((arguments[i__7485__auto___12306]));

var G__12307 = (i__7485__auto___12306 + (1));
i__7485__auto___12306 = G__12307;
continue;
} else {
}
break;
}

var G__12304 = args12302.length;
switch (G__12304) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12302.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_12309 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_12309);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_12309,ret){
return (function (){
return fn1.call(null,val_12309);
});})(val_12309,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args12310 = [];
var len__7484__auto___12313 = arguments.length;
var i__7485__auto___12314 = (0);
while(true){
if((i__7485__auto___12314 < len__7484__auto___12313)){
args12310.push((arguments[i__7485__auto___12314]));

var G__12315 = (i__7485__auto___12314 + (1));
i__7485__auto___12314 = G__12315;
continue;
} else {
}
break;
}

var G__12312 = args12310.length;
switch (G__12312) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12310.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4655__auto__)){
var ret = temp__4655__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__4655__auto__)){
var retb = temp__4655__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__4655__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__4655__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__7324__auto___12317 = n;
var x_12318 = (0);
while(true){
if((x_12318 < n__7324__auto___12317)){
(a[x_12318] = (0));

var G__12319 = (x_12318 + (1));
x_12318 = G__12319;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__12320 = (i + (1));
i = G__12320;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async12324 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12324 = (function (alt_flag,flag,meta12325){
this.alt_flag = alt_flag;
this.flag = flag;
this.meta12325 = meta12325;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async12324.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_12326,meta12325__$1){
var self__ = this;
var _12326__$1 = this;
return (new cljs.core.async.t_cljs$core$async12324(self__.alt_flag,self__.flag,meta12325__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async12324.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_12326){
var self__ = this;
var _12326__$1 = this;
return self__.meta12325;
});})(flag))
;

cljs.core.async.t_cljs$core$async12324.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async12324.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async12324.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async12324.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async12324.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-flag","alt-flag",-1794972754,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(cljs.core.PersistentVector.EMPTY))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta12325","meta12325",1325754438,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async12324.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async12324.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12324";

cljs.core.async.t_cljs$core$async12324.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"cljs.core.async/t_cljs$core$async12324");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async12324 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async12324(alt_flag__$1,flag__$1,meta12325){
return (new cljs.core.async.t_cljs$core$async12324(alt_flag__$1,flag__$1,meta12325));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async12324(cljs$core$async$alt_flag,flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async12330 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12330 = (function (alt_handler,flag,cb,meta12331){
this.alt_handler = alt_handler;
this.flag = flag;
this.cb = cb;
this.meta12331 = meta12331;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async12330.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_12332,meta12331__$1){
var self__ = this;
var _12332__$1 = this;
return (new cljs.core.async.t_cljs$core$async12330(self__.alt_handler,self__.flag,self__.cb,meta12331__$1));
});

cljs.core.async.t_cljs$core$async12330.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_12332){
var self__ = this;
var _12332__$1 = this;
return self__.meta12331;
});

cljs.core.async.t_cljs$core$async12330.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async12330.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async12330.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async12330.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async12330.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-handler","alt-handler",963786170,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null)], null)))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta12331","meta12331",696614045,null)], null);
});

cljs.core.async.t_cljs$core$async12330.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async12330.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12330";

cljs.core.async.t_cljs$core$async12330.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"cljs.core.async/t_cljs$core$async12330");
});

cljs.core.async.__GT_t_cljs$core$async12330 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async12330(alt_handler__$1,flag__$1,cb__$1,meta12331){
return (new cljs.core.async.t_cljs$core$async12330(alt_handler__$1,flag__$1,cb__$1,meta12331));
});

}

return (new cljs.core.async.t_cljs$core$async12330(cljs$core$async$alt_handler,flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__12333_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__12333_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__12334_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__12334_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__6409__auto__ = wport;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return port;
}
})()], null));
} else {
var G__12335 = (i + (1));
i = G__12335;
continue;
}
} else {
return null;
}
break;
}
})();
var or__6409__auto__ = ret;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__4657__auto__ = (function (){var and__6397__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__6397__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__6397__auto__;
}
})();
if(cljs.core.truth_(temp__4657__auto__)){
var got = temp__4657__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__7491__auto__ = [];
var len__7484__auto___12341 = arguments.length;
var i__7485__auto___12342 = (0);
while(true){
if((i__7485__auto___12342 < len__7484__auto___12341)){
args__7491__auto__.push((arguments[i__7485__auto___12342]));

var G__12343 = (i__7485__auto___12342 + (1));
i__7485__auto___12342 = G__12343;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__12338){
var map__12339 = p__12338;
var map__12339__$1 = ((((!((map__12339 == null)))?((((map__12339.cljs$lang$protocol_mask$partition0$ & (64))) || (map__12339.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__12339):map__12339);
var opts = map__12339__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq12336){
var G__12337 = cljs.core.first.call(null,seq12336);
var seq12336__$1 = cljs.core.next.call(null,seq12336);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__12337,seq12336__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args12344 = [];
var len__7484__auto___12394 = arguments.length;
var i__7485__auto___12395 = (0);
while(true){
if((i__7485__auto___12395 < len__7484__auto___12394)){
args12344.push((arguments[i__7485__auto___12395]));

var G__12396 = (i__7485__auto___12395 + (1));
i__7485__auto___12395 = G__12396;
continue;
} else {
}
break;
}

var G__12346 = args12344.length;
switch (G__12346) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12344.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__12231__auto___12398 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__12231__auto___12398){
return (function (){
var f__12232__auto__ = (function (){var switch__12119__auto__ = ((function (c__12231__auto___12398){
return (function (state_12370){
var state_val_12371 = (state_12370[(1)]);
if((state_val_12371 === (7))){
var inst_12366 = (state_12370[(2)]);
var state_12370__$1 = state_12370;
var statearr_12372_12399 = state_12370__$1;
(statearr_12372_12399[(2)] = inst_12366);

(statearr_12372_12399[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12371 === (1))){
var state_12370__$1 = state_12370;
var statearr_12373_12400 = state_12370__$1;
(statearr_12373_12400[(2)] = null);

(statearr_12373_12400[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12371 === (4))){
var inst_12349 = (state_12370[(7)]);
var inst_12349__$1 = (state_12370[(2)]);
var inst_12350 = (inst_12349__$1 == null);
var state_12370__$1 = (function (){var statearr_12374 = state_12370;
(statearr_12374[(7)] = inst_12349__$1);

return statearr_12374;
})();
if(cljs.core.truth_(inst_12350)){
var statearr_12375_12401 = state_12370__$1;
(statearr_12375_12401[(1)] = (5));

} else {
var statearr_12376_12402 = state_12370__$1;
(statearr_12376_12402[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12371 === (13))){
var state_12370__$1 = state_12370;
var statearr_12377_12403 = state_12370__$1;
(statearr_12377_12403[(2)] = null);

(statearr_12377_12403[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12371 === (6))){
var inst_12349 = (state_12370[(7)]);
var state_12370__$1 = state_12370;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12370__$1,(11),to,inst_12349);
} else {
if((state_val_12371 === (3))){
var inst_12368 = (state_12370[(2)]);
var state_12370__$1 = state_12370;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12370__$1,inst_12368);
} else {
if((state_val_12371 === (12))){
var state_12370__$1 = state_12370;
var statearr_12378_12404 = state_12370__$1;
(statearr_12378_12404[(2)] = null);

(statearr_12378_12404[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12371 === (2))){
var state_12370__$1 = state_12370;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12370__$1,(4),from);
} else {
if((state_val_12371 === (11))){
var inst_12359 = (state_12370[(2)]);
var state_12370__$1 = state_12370;
if(cljs.core.truth_(inst_12359)){
var statearr_12379_12405 = state_12370__$1;
(statearr_12379_12405[(1)] = (12));

} else {
var statearr_12380_12406 = state_12370__$1;
(statearr_12380_12406[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12371 === (9))){
var state_12370__$1 = state_12370;
var statearr_12381_12407 = state_12370__$1;
(statearr_12381_12407[(2)] = null);

(statearr_12381_12407[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12371 === (5))){
var state_12370__$1 = state_12370;
if(cljs.core.truth_(close_QMARK_)){
var statearr_12382_12408 = state_12370__$1;
(statearr_12382_12408[(1)] = (8));

} else {
var statearr_12383_12409 = state_12370__$1;
(statearr_12383_12409[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12371 === (14))){
var inst_12364 = (state_12370[(2)]);
var state_12370__$1 = state_12370;
var statearr_12384_12410 = state_12370__$1;
(statearr_12384_12410[(2)] = inst_12364);

(statearr_12384_12410[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12371 === (10))){
var inst_12356 = (state_12370[(2)]);
var state_12370__$1 = state_12370;
var statearr_12385_12411 = state_12370__$1;
(statearr_12385_12411[(2)] = inst_12356);

(statearr_12385_12411[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12371 === (8))){
var inst_12353 = cljs.core.async.close_BANG_.call(null,to);
var state_12370__$1 = state_12370;
var statearr_12386_12412 = state_12370__$1;
(statearr_12386_12412[(2)] = inst_12353);

(statearr_12386_12412[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12231__auto___12398))
;
return ((function (switch__12119__auto__,c__12231__auto___12398){
return (function() {
var cljs$core$async$state_machine__12120__auto__ = null;
var cljs$core$async$state_machine__12120__auto____0 = (function (){
var statearr_12390 = [null,null,null,null,null,null,null,null];
(statearr_12390[(0)] = cljs$core$async$state_machine__12120__auto__);

(statearr_12390[(1)] = (1));

return statearr_12390;
});
var cljs$core$async$state_machine__12120__auto____1 = (function (state_12370){
while(true){
var ret_value__12121__auto__ = (function (){try{while(true){
var result__12122__auto__ = switch__12119__auto__.call(null,state_12370);
if(cljs.core.keyword_identical_QMARK_.call(null,result__12122__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12122__auto__;
}
break;
}
}catch (e12391){if((e12391 instanceof Object)){
var ex__12123__auto__ = e12391;
var statearr_12392_12413 = state_12370;
(statearr_12392_12413[(5)] = ex__12123__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12370);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12391;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__12121__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12414 = state_12370;
state_12370 = G__12414;
continue;
} else {
return ret_value__12121__auto__;
}
break;
}
});
cljs$core$async$state_machine__12120__auto__ = function(state_12370){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12120__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12120__auto____1.call(this,state_12370);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12120__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12120__auto____0;
cljs$core$async$state_machine__12120__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12120__auto____1;
return cljs$core$async$state_machine__12120__auto__;
})()
;})(switch__12119__auto__,c__12231__auto___12398))
})();
var state__12233__auto__ = (function (){var statearr_12393 = f__12232__auto__.call(null);
(statearr_12393[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12231__auto___12398);

return statearr_12393;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__12233__auto__);
});})(c__12231__auto___12398))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__12602){
var vec__12603 = p__12602;
var v = cljs.core.nth.call(null,vec__12603,(0),null);
var p = cljs.core.nth.call(null,vec__12603,(1),null);
var job = vec__12603;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__12231__auto___12789 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__12231__auto___12789,res,vec__12603,v,p,job,jobs,results){
return (function (){
var f__12232__auto__ = (function (){var switch__12119__auto__ = ((function (c__12231__auto___12789,res,vec__12603,v,p,job,jobs,results){
return (function (state_12610){
var state_val_12611 = (state_12610[(1)]);
if((state_val_12611 === (1))){
var state_12610__$1 = state_12610;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12610__$1,(2),res,v);
} else {
if((state_val_12611 === (2))){
var inst_12607 = (state_12610[(2)]);
var inst_12608 = cljs.core.async.close_BANG_.call(null,res);
var state_12610__$1 = (function (){var statearr_12612 = state_12610;
(statearr_12612[(7)] = inst_12607);

return statearr_12612;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12610__$1,inst_12608);
} else {
return null;
}
}
});})(c__12231__auto___12789,res,vec__12603,v,p,job,jobs,results))
;
return ((function (switch__12119__auto__,c__12231__auto___12789,res,vec__12603,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__12120__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__12120__auto____0 = (function (){
var statearr_12616 = [null,null,null,null,null,null,null,null];
(statearr_12616[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__12120__auto__);

(statearr_12616[(1)] = (1));

return statearr_12616;
});
var cljs$core$async$pipeline_STAR__$_state_machine__12120__auto____1 = (function (state_12610){
while(true){
var ret_value__12121__auto__ = (function (){try{while(true){
var result__12122__auto__ = switch__12119__auto__.call(null,state_12610);
if(cljs.core.keyword_identical_QMARK_.call(null,result__12122__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12122__auto__;
}
break;
}
}catch (e12617){if((e12617 instanceof Object)){
var ex__12123__auto__ = e12617;
var statearr_12618_12790 = state_12610;
(statearr_12618_12790[(5)] = ex__12123__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12610);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12617;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__12121__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12791 = state_12610;
state_12610 = G__12791;
continue;
} else {
return ret_value__12121__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__12120__auto__ = function(state_12610){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__12120__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__12120__auto____1.call(this,state_12610);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__12120__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__12120__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__12120__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__12120__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__12120__auto__;
})()
;})(switch__12119__auto__,c__12231__auto___12789,res,vec__12603,v,p,job,jobs,results))
})();
var state__12233__auto__ = (function (){var statearr_12619 = f__12232__auto__.call(null);
(statearr_12619[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12231__auto___12789);

return statearr_12619;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__12233__auto__);
});})(c__12231__auto___12789,res,vec__12603,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__12620){
var vec__12621 = p__12620;
var v = cljs.core.nth.call(null,vec__12621,(0),null);
var p = cljs.core.nth.call(null,vec__12621,(1),null);
var job = vec__12621;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__7324__auto___12792 = n;
var __12793 = (0);
while(true){
if((__12793 < n__7324__auto___12792)){
var G__12624_12794 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__12624_12794) {
case "compute":
var c__12231__auto___12796 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__12793,c__12231__auto___12796,G__12624_12794,n__7324__auto___12792,jobs,results,process,async){
return (function (){
var f__12232__auto__ = (function (){var switch__12119__auto__ = ((function (__12793,c__12231__auto___12796,G__12624_12794,n__7324__auto___12792,jobs,results,process,async){
return (function (state_12637){
var state_val_12638 = (state_12637[(1)]);
if((state_val_12638 === (1))){
var state_12637__$1 = state_12637;
var statearr_12639_12797 = state_12637__$1;
(statearr_12639_12797[(2)] = null);

(statearr_12639_12797[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12638 === (2))){
var state_12637__$1 = state_12637;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12637__$1,(4),jobs);
} else {
if((state_val_12638 === (3))){
var inst_12635 = (state_12637[(2)]);
var state_12637__$1 = state_12637;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12637__$1,inst_12635);
} else {
if((state_val_12638 === (4))){
var inst_12627 = (state_12637[(2)]);
var inst_12628 = process.call(null,inst_12627);
var state_12637__$1 = state_12637;
if(cljs.core.truth_(inst_12628)){
var statearr_12640_12798 = state_12637__$1;
(statearr_12640_12798[(1)] = (5));

} else {
var statearr_12641_12799 = state_12637__$1;
(statearr_12641_12799[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12638 === (5))){
var state_12637__$1 = state_12637;
var statearr_12642_12800 = state_12637__$1;
(statearr_12642_12800[(2)] = null);

(statearr_12642_12800[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12638 === (6))){
var state_12637__$1 = state_12637;
var statearr_12643_12801 = state_12637__$1;
(statearr_12643_12801[(2)] = null);

(statearr_12643_12801[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12638 === (7))){
var inst_12633 = (state_12637[(2)]);
var state_12637__$1 = state_12637;
var statearr_12644_12802 = state_12637__$1;
(statearr_12644_12802[(2)] = inst_12633);

(statearr_12644_12802[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__12793,c__12231__auto___12796,G__12624_12794,n__7324__auto___12792,jobs,results,process,async))
;
return ((function (__12793,switch__12119__auto__,c__12231__auto___12796,G__12624_12794,n__7324__auto___12792,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__12120__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__12120__auto____0 = (function (){
var statearr_12648 = [null,null,null,null,null,null,null];
(statearr_12648[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__12120__auto__);

(statearr_12648[(1)] = (1));

return statearr_12648;
});
var cljs$core$async$pipeline_STAR__$_state_machine__12120__auto____1 = (function (state_12637){
while(true){
var ret_value__12121__auto__ = (function (){try{while(true){
var result__12122__auto__ = switch__12119__auto__.call(null,state_12637);
if(cljs.core.keyword_identical_QMARK_.call(null,result__12122__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12122__auto__;
}
break;
}
}catch (e12649){if((e12649 instanceof Object)){
var ex__12123__auto__ = e12649;
var statearr_12650_12803 = state_12637;
(statearr_12650_12803[(5)] = ex__12123__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12637);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12649;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__12121__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12804 = state_12637;
state_12637 = G__12804;
continue;
} else {
return ret_value__12121__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__12120__auto__ = function(state_12637){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__12120__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__12120__auto____1.call(this,state_12637);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__12120__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__12120__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__12120__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__12120__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__12120__auto__;
})()
;})(__12793,switch__12119__auto__,c__12231__auto___12796,G__12624_12794,n__7324__auto___12792,jobs,results,process,async))
})();
var state__12233__auto__ = (function (){var statearr_12651 = f__12232__auto__.call(null);
(statearr_12651[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12231__auto___12796);

return statearr_12651;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__12233__auto__);
});})(__12793,c__12231__auto___12796,G__12624_12794,n__7324__auto___12792,jobs,results,process,async))
);


break;
case "async":
var c__12231__auto___12805 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__12793,c__12231__auto___12805,G__12624_12794,n__7324__auto___12792,jobs,results,process,async){
return (function (){
var f__12232__auto__ = (function (){var switch__12119__auto__ = ((function (__12793,c__12231__auto___12805,G__12624_12794,n__7324__auto___12792,jobs,results,process,async){
return (function (state_12664){
var state_val_12665 = (state_12664[(1)]);
if((state_val_12665 === (1))){
var state_12664__$1 = state_12664;
var statearr_12666_12806 = state_12664__$1;
(statearr_12666_12806[(2)] = null);

(statearr_12666_12806[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12665 === (2))){
var state_12664__$1 = state_12664;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12664__$1,(4),jobs);
} else {
if((state_val_12665 === (3))){
var inst_12662 = (state_12664[(2)]);
var state_12664__$1 = state_12664;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12664__$1,inst_12662);
} else {
if((state_val_12665 === (4))){
var inst_12654 = (state_12664[(2)]);
var inst_12655 = async.call(null,inst_12654);
var state_12664__$1 = state_12664;
if(cljs.core.truth_(inst_12655)){
var statearr_12667_12807 = state_12664__$1;
(statearr_12667_12807[(1)] = (5));

} else {
var statearr_12668_12808 = state_12664__$1;
(statearr_12668_12808[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12665 === (5))){
var state_12664__$1 = state_12664;
var statearr_12669_12809 = state_12664__$1;
(statearr_12669_12809[(2)] = null);

(statearr_12669_12809[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12665 === (6))){
var state_12664__$1 = state_12664;
var statearr_12670_12810 = state_12664__$1;
(statearr_12670_12810[(2)] = null);

(statearr_12670_12810[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12665 === (7))){
var inst_12660 = (state_12664[(2)]);
var state_12664__$1 = state_12664;
var statearr_12671_12811 = state_12664__$1;
(statearr_12671_12811[(2)] = inst_12660);

(statearr_12671_12811[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__12793,c__12231__auto___12805,G__12624_12794,n__7324__auto___12792,jobs,results,process,async))
;
return ((function (__12793,switch__12119__auto__,c__12231__auto___12805,G__12624_12794,n__7324__auto___12792,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__12120__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__12120__auto____0 = (function (){
var statearr_12675 = [null,null,null,null,null,null,null];
(statearr_12675[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__12120__auto__);

(statearr_12675[(1)] = (1));

return statearr_12675;
});
var cljs$core$async$pipeline_STAR__$_state_machine__12120__auto____1 = (function (state_12664){
while(true){
var ret_value__12121__auto__ = (function (){try{while(true){
var result__12122__auto__ = switch__12119__auto__.call(null,state_12664);
if(cljs.core.keyword_identical_QMARK_.call(null,result__12122__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12122__auto__;
}
break;
}
}catch (e12676){if((e12676 instanceof Object)){
var ex__12123__auto__ = e12676;
var statearr_12677_12812 = state_12664;
(statearr_12677_12812[(5)] = ex__12123__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12664);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12676;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__12121__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12813 = state_12664;
state_12664 = G__12813;
continue;
} else {
return ret_value__12121__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__12120__auto__ = function(state_12664){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__12120__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__12120__auto____1.call(this,state_12664);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__12120__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__12120__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__12120__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__12120__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__12120__auto__;
})()
;})(__12793,switch__12119__auto__,c__12231__auto___12805,G__12624_12794,n__7324__auto___12792,jobs,results,process,async))
})();
var state__12233__auto__ = (function (){var statearr_12678 = f__12232__auto__.call(null);
(statearr_12678[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12231__auto___12805);

return statearr_12678;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__12233__auto__);
});})(__12793,c__12231__auto___12805,G__12624_12794,n__7324__auto___12792,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__12814 = (__12793 + (1));
__12793 = G__12814;
continue;
} else {
}
break;
}

var c__12231__auto___12815 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__12231__auto___12815,jobs,results,process,async){
return (function (){
var f__12232__auto__ = (function (){var switch__12119__auto__ = ((function (c__12231__auto___12815,jobs,results,process,async){
return (function (state_12700){
var state_val_12701 = (state_12700[(1)]);
if((state_val_12701 === (1))){
var state_12700__$1 = state_12700;
var statearr_12702_12816 = state_12700__$1;
(statearr_12702_12816[(2)] = null);

(statearr_12702_12816[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12701 === (2))){
var state_12700__$1 = state_12700;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12700__$1,(4),from);
} else {
if((state_val_12701 === (3))){
var inst_12698 = (state_12700[(2)]);
var state_12700__$1 = state_12700;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12700__$1,inst_12698);
} else {
if((state_val_12701 === (4))){
var inst_12681 = (state_12700[(7)]);
var inst_12681__$1 = (state_12700[(2)]);
var inst_12682 = (inst_12681__$1 == null);
var state_12700__$1 = (function (){var statearr_12703 = state_12700;
(statearr_12703[(7)] = inst_12681__$1);

return statearr_12703;
})();
if(cljs.core.truth_(inst_12682)){
var statearr_12704_12817 = state_12700__$1;
(statearr_12704_12817[(1)] = (5));

} else {
var statearr_12705_12818 = state_12700__$1;
(statearr_12705_12818[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12701 === (5))){
var inst_12684 = cljs.core.async.close_BANG_.call(null,jobs);
var state_12700__$1 = state_12700;
var statearr_12706_12819 = state_12700__$1;
(statearr_12706_12819[(2)] = inst_12684);

(statearr_12706_12819[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12701 === (6))){
var inst_12681 = (state_12700[(7)]);
var inst_12686 = (state_12700[(8)]);
var inst_12686__$1 = cljs.core.async.chan.call(null,(1));
var inst_12687 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_12688 = [inst_12681,inst_12686__$1];
var inst_12689 = (new cljs.core.PersistentVector(null,2,(5),inst_12687,inst_12688,null));
var state_12700__$1 = (function (){var statearr_12707 = state_12700;
(statearr_12707[(8)] = inst_12686__$1);

return statearr_12707;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12700__$1,(8),jobs,inst_12689);
} else {
if((state_val_12701 === (7))){
var inst_12696 = (state_12700[(2)]);
var state_12700__$1 = state_12700;
var statearr_12708_12820 = state_12700__$1;
(statearr_12708_12820[(2)] = inst_12696);

(statearr_12708_12820[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12701 === (8))){
var inst_12686 = (state_12700[(8)]);
var inst_12691 = (state_12700[(2)]);
var state_12700__$1 = (function (){var statearr_12709 = state_12700;
(statearr_12709[(9)] = inst_12691);

return statearr_12709;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12700__$1,(9),results,inst_12686);
} else {
if((state_val_12701 === (9))){
var inst_12693 = (state_12700[(2)]);
var state_12700__$1 = (function (){var statearr_12710 = state_12700;
(statearr_12710[(10)] = inst_12693);

return statearr_12710;
})();
var statearr_12711_12821 = state_12700__$1;
(statearr_12711_12821[(2)] = null);

(statearr_12711_12821[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__12231__auto___12815,jobs,results,process,async))
;
return ((function (switch__12119__auto__,c__12231__auto___12815,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__12120__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__12120__auto____0 = (function (){
var statearr_12715 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_12715[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__12120__auto__);

(statearr_12715[(1)] = (1));

return statearr_12715;
});
var cljs$core$async$pipeline_STAR__$_state_machine__12120__auto____1 = (function (state_12700){
while(true){
var ret_value__12121__auto__ = (function (){try{while(true){
var result__12122__auto__ = switch__12119__auto__.call(null,state_12700);
if(cljs.core.keyword_identical_QMARK_.call(null,result__12122__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12122__auto__;
}
break;
}
}catch (e12716){if((e12716 instanceof Object)){
var ex__12123__auto__ = e12716;
var statearr_12717_12822 = state_12700;
(statearr_12717_12822[(5)] = ex__12123__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12700);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12716;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__12121__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12823 = state_12700;
state_12700 = G__12823;
continue;
} else {
return ret_value__12121__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__12120__auto__ = function(state_12700){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__12120__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__12120__auto____1.call(this,state_12700);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__12120__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__12120__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__12120__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__12120__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__12120__auto__;
})()
;})(switch__12119__auto__,c__12231__auto___12815,jobs,results,process,async))
})();
var state__12233__auto__ = (function (){var statearr_12718 = f__12232__auto__.call(null);
(statearr_12718[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12231__auto___12815);

return statearr_12718;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__12233__auto__);
});})(c__12231__auto___12815,jobs,results,process,async))
);


var c__12231__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__12231__auto__,jobs,results,process,async){
return (function (){
var f__12232__auto__ = (function (){var switch__12119__auto__ = ((function (c__12231__auto__,jobs,results,process,async){
return (function (state_12756){
var state_val_12757 = (state_12756[(1)]);
if((state_val_12757 === (7))){
var inst_12752 = (state_12756[(2)]);
var state_12756__$1 = state_12756;
var statearr_12758_12824 = state_12756__$1;
(statearr_12758_12824[(2)] = inst_12752);

(statearr_12758_12824[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12757 === (20))){
var state_12756__$1 = state_12756;
var statearr_12759_12825 = state_12756__$1;
(statearr_12759_12825[(2)] = null);

(statearr_12759_12825[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12757 === (1))){
var state_12756__$1 = state_12756;
var statearr_12760_12826 = state_12756__$1;
(statearr_12760_12826[(2)] = null);

(statearr_12760_12826[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12757 === (4))){
var inst_12721 = (state_12756[(7)]);
var inst_12721__$1 = (state_12756[(2)]);
var inst_12722 = (inst_12721__$1 == null);
var state_12756__$1 = (function (){var statearr_12761 = state_12756;
(statearr_12761[(7)] = inst_12721__$1);

return statearr_12761;
})();
if(cljs.core.truth_(inst_12722)){
var statearr_12762_12827 = state_12756__$1;
(statearr_12762_12827[(1)] = (5));

} else {
var statearr_12763_12828 = state_12756__$1;
(statearr_12763_12828[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12757 === (15))){
var inst_12734 = (state_12756[(8)]);
var state_12756__$1 = state_12756;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12756__$1,(18),to,inst_12734);
} else {
if((state_val_12757 === (21))){
var inst_12747 = (state_12756[(2)]);
var state_12756__$1 = state_12756;
var statearr_12764_12829 = state_12756__$1;
(statearr_12764_12829[(2)] = inst_12747);

(statearr_12764_12829[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12757 === (13))){
var inst_12749 = (state_12756[(2)]);
var state_12756__$1 = (function (){var statearr_12765 = state_12756;
(statearr_12765[(9)] = inst_12749);

return statearr_12765;
})();
var statearr_12766_12830 = state_12756__$1;
(statearr_12766_12830[(2)] = null);

(statearr_12766_12830[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12757 === (6))){
var inst_12721 = (state_12756[(7)]);
var state_12756__$1 = state_12756;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12756__$1,(11),inst_12721);
} else {
if((state_val_12757 === (17))){
var inst_12742 = (state_12756[(2)]);
var state_12756__$1 = state_12756;
if(cljs.core.truth_(inst_12742)){
var statearr_12767_12831 = state_12756__$1;
(statearr_12767_12831[(1)] = (19));

} else {
var statearr_12768_12832 = state_12756__$1;
(statearr_12768_12832[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12757 === (3))){
var inst_12754 = (state_12756[(2)]);
var state_12756__$1 = state_12756;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12756__$1,inst_12754);
} else {
if((state_val_12757 === (12))){
var inst_12731 = (state_12756[(10)]);
var state_12756__$1 = state_12756;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12756__$1,(14),inst_12731);
} else {
if((state_val_12757 === (2))){
var state_12756__$1 = state_12756;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12756__$1,(4),results);
} else {
if((state_val_12757 === (19))){
var state_12756__$1 = state_12756;
var statearr_12769_12833 = state_12756__$1;
(statearr_12769_12833[(2)] = null);

(statearr_12769_12833[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12757 === (11))){
var inst_12731 = (state_12756[(2)]);
var state_12756__$1 = (function (){var statearr_12770 = state_12756;
(statearr_12770[(10)] = inst_12731);

return statearr_12770;
})();
var statearr_12771_12834 = state_12756__$1;
(statearr_12771_12834[(2)] = null);

(statearr_12771_12834[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12757 === (9))){
var state_12756__$1 = state_12756;
var statearr_12772_12835 = state_12756__$1;
(statearr_12772_12835[(2)] = null);

(statearr_12772_12835[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12757 === (5))){
var state_12756__$1 = state_12756;
if(cljs.core.truth_(close_QMARK_)){
var statearr_12773_12836 = state_12756__$1;
(statearr_12773_12836[(1)] = (8));

} else {
var statearr_12774_12837 = state_12756__$1;
(statearr_12774_12837[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12757 === (14))){
var inst_12736 = (state_12756[(11)]);
var inst_12734 = (state_12756[(8)]);
var inst_12734__$1 = (state_12756[(2)]);
var inst_12735 = (inst_12734__$1 == null);
var inst_12736__$1 = cljs.core.not.call(null,inst_12735);
var state_12756__$1 = (function (){var statearr_12775 = state_12756;
(statearr_12775[(11)] = inst_12736__$1);

(statearr_12775[(8)] = inst_12734__$1);

return statearr_12775;
})();
if(inst_12736__$1){
var statearr_12776_12838 = state_12756__$1;
(statearr_12776_12838[(1)] = (15));

} else {
var statearr_12777_12839 = state_12756__$1;
(statearr_12777_12839[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12757 === (16))){
var inst_12736 = (state_12756[(11)]);
var state_12756__$1 = state_12756;
var statearr_12778_12840 = state_12756__$1;
(statearr_12778_12840[(2)] = inst_12736);

(statearr_12778_12840[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12757 === (10))){
var inst_12728 = (state_12756[(2)]);
var state_12756__$1 = state_12756;
var statearr_12779_12841 = state_12756__$1;
(statearr_12779_12841[(2)] = inst_12728);

(statearr_12779_12841[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12757 === (18))){
var inst_12739 = (state_12756[(2)]);
var state_12756__$1 = state_12756;
var statearr_12780_12842 = state_12756__$1;
(statearr_12780_12842[(2)] = inst_12739);

(statearr_12780_12842[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12757 === (8))){
var inst_12725 = cljs.core.async.close_BANG_.call(null,to);
var state_12756__$1 = state_12756;
var statearr_12781_12843 = state_12756__$1;
(statearr_12781_12843[(2)] = inst_12725);

(statearr_12781_12843[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12231__auto__,jobs,results,process,async))
;
return ((function (switch__12119__auto__,c__12231__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__12120__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__12120__auto____0 = (function (){
var statearr_12785 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12785[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__12120__auto__);

(statearr_12785[(1)] = (1));

return statearr_12785;
});
var cljs$core$async$pipeline_STAR__$_state_machine__12120__auto____1 = (function (state_12756){
while(true){
var ret_value__12121__auto__ = (function (){try{while(true){
var result__12122__auto__ = switch__12119__auto__.call(null,state_12756);
if(cljs.core.keyword_identical_QMARK_.call(null,result__12122__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12122__auto__;
}
break;
}
}catch (e12786){if((e12786 instanceof Object)){
var ex__12123__auto__ = e12786;
var statearr_12787_12844 = state_12756;
(statearr_12787_12844[(5)] = ex__12123__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12756);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12786;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__12121__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12845 = state_12756;
state_12756 = G__12845;
continue;
} else {
return ret_value__12121__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__12120__auto__ = function(state_12756){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__12120__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__12120__auto____1.call(this,state_12756);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__12120__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__12120__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__12120__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__12120__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__12120__auto__;
})()
;})(switch__12119__auto__,c__12231__auto__,jobs,results,process,async))
})();
var state__12233__auto__ = (function (){var statearr_12788 = f__12232__auto__.call(null);
(statearr_12788[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12231__auto__);

return statearr_12788;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__12233__auto__);
});})(c__12231__auto__,jobs,results,process,async))
);

return c__12231__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args12846 = [];
var len__7484__auto___12849 = arguments.length;
var i__7485__auto___12850 = (0);
while(true){
if((i__7485__auto___12850 < len__7484__auto___12849)){
args12846.push((arguments[i__7485__auto___12850]));

var G__12851 = (i__7485__auto___12850 + (1));
i__7485__auto___12850 = G__12851;
continue;
} else {
}
break;
}

var G__12848 = args12846.length;
switch (G__12848) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12846.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args12853 = [];
var len__7484__auto___12856 = arguments.length;
var i__7485__auto___12857 = (0);
while(true){
if((i__7485__auto___12857 < len__7484__auto___12856)){
args12853.push((arguments[i__7485__auto___12857]));

var G__12858 = (i__7485__auto___12857 + (1));
i__7485__auto___12857 = G__12858;
continue;
} else {
}
break;
}

var G__12855 = args12853.length;
switch (G__12855) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12853.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args12860 = [];
var len__7484__auto___12913 = arguments.length;
var i__7485__auto___12914 = (0);
while(true){
if((i__7485__auto___12914 < len__7484__auto___12913)){
args12860.push((arguments[i__7485__auto___12914]));

var G__12915 = (i__7485__auto___12914 + (1));
i__7485__auto___12914 = G__12915;
continue;
} else {
}
break;
}

var G__12862 = args12860.length;
switch (G__12862) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12860.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__12231__auto___12917 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__12231__auto___12917,tc,fc){
return (function (){
var f__12232__auto__ = (function (){var switch__12119__auto__ = ((function (c__12231__auto___12917,tc,fc){
return (function (state_12888){
var state_val_12889 = (state_12888[(1)]);
if((state_val_12889 === (7))){
var inst_12884 = (state_12888[(2)]);
var state_12888__$1 = state_12888;
var statearr_12890_12918 = state_12888__$1;
(statearr_12890_12918[(2)] = inst_12884);

(statearr_12890_12918[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12889 === (1))){
var state_12888__$1 = state_12888;
var statearr_12891_12919 = state_12888__$1;
(statearr_12891_12919[(2)] = null);

(statearr_12891_12919[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12889 === (4))){
var inst_12865 = (state_12888[(7)]);
var inst_12865__$1 = (state_12888[(2)]);
var inst_12866 = (inst_12865__$1 == null);
var state_12888__$1 = (function (){var statearr_12892 = state_12888;
(statearr_12892[(7)] = inst_12865__$1);

return statearr_12892;
})();
if(cljs.core.truth_(inst_12866)){
var statearr_12893_12920 = state_12888__$1;
(statearr_12893_12920[(1)] = (5));

} else {
var statearr_12894_12921 = state_12888__$1;
(statearr_12894_12921[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12889 === (13))){
var state_12888__$1 = state_12888;
var statearr_12895_12922 = state_12888__$1;
(statearr_12895_12922[(2)] = null);

(statearr_12895_12922[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12889 === (6))){
var inst_12865 = (state_12888[(7)]);
var inst_12871 = p.call(null,inst_12865);
var state_12888__$1 = state_12888;
if(cljs.core.truth_(inst_12871)){
var statearr_12896_12923 = state_12888__$1;
(statearr_12896_12923[(1)] = (9));

} else {
var statearr_12897_12924 = state_12888__$1;
(statearr_12897_12924[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12889 === (3))){
var inst_12886 = (state_12888[(2)]);
var state_12888__$1 = state_12888;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12888__$1,inst_12886);
} else {
if((state_val_12889 === (12))){
var state_12888__$1 = state_12888;
var statearr_12898_12925 = state_12888__$1;
(statearr_12898_12925[(2)] = null);

(statearr_12898_12925[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12889 === (2))){
var state_12888__$1 = state_12888;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12888__$1,(4),ch);
} else {
if((state_val_12889 === (11))){
var inst_12865 = (state_12888[(7)]);
var inst_12875 = (state_12888[(2)]);
var state_12888__$1 = state_12888;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12888__$1,(8),inst_12875,inst_12865);
} else {
if((state_val_12889 === (9))){
var state_12888__$1 = state_12888;
var statearr_12899_12926 = state_12888__$1;
(statearr_12899_12926[(2)] = tc);

(statearr_12899_12926[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12889 === (5))){
var inst_12868 = cljs.core.async.close_BANG_.call(null,tc);
var inst_12869 = cljs.core.async.close_BANG_.call(null,fc);
var state_12888__$1 = (function (){var statearr_12900 = state_12888;
(statearr_12900[(8)] = inst_12868);

return statearr_12900;
})();
var statearr_12901_12927 = state_12888__$1;
(statearr_12901_12927[(2)] = inst_12869);

(statearr_12901_12927[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12889 === (14))){
var inst_12882 = (state_12888[(2)]);
var state_12888__$1 = state_12888;
var statearr_12902_12928 = state_12888__$1;
(statearr_12902_12928[(2)] = inst_12882);

(statearr_12902_12928[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12889 === (10))){
var state_12888__$1 = state_12888;
var statearr_12903_12929 = state_12888__$1;
(statearr_12903_12929[(2)] = fc);

(statearr_12903_12929[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12889 === (8))){
var inst_12877 = (state_12888[(2)]);
var state_12888__$1 = state_12888;
if(cljs.core.truth_(inst_12877)){
var statearr_12904_12930 = state_12888__$1;
(statearr_12904_12930[(1)] = (12));

} else {
var statearr_12905_12931 = state_12888__$1;
(statearr_12905_12931[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12231__auto___12917,tc,fc))
;
return ((function (switch__12119__auto__,c__12231__auto___12917,tc,fc){
return (function() {
var cljs$core$async$state_machine__12120__auto__ = null;
var cljs$core$async$state_machine__12120__auto____0 = (function (){
var statearr_12909 = [null,null,null,null,null,null,null,null,null];
(statearr_12909[(0)] = cljs$core$async$state_machine__12120__auto__);

(statearr_12909[(1)] = (1));

return statearr_12909;
});
var cljs$core$async$state_machine__12120__auto____1 = (function (state_12888){
while(true){
var ret_value__12121__auto__ = (function (){try{while(true){
var result__12122__auto__ = switch__12119__auto__.call(null,state_12888);
if(cljs.core.keyword_identical_QMARK_.call(null,result__12122__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12122__auto__;
}
break;
}
}catch (e12910){if((e12910 instanceof Object)){
var ex__12123__auto__ = e12910;
var statearr_12911_12932 = state_12888;
(statearr_12911_12932[(5)] = ex__12123__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12888);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12910;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__12121__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12933 = state_12888;
state_12888 = G__12933;
continue;
} else {
return ret_value__12121__auto__;
}
break;
}
});
cljs$core$async$state_machine__12120__auto__ = function(state_12888){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12120__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12120__auto____1.call(this,state_12888);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12120__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12120__auto____0;
cljs$core$async$state_machine__12120__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12120__auto____1;
return cljs$core$async$state_machine__12120__auto__;
})()
;})(switch__12119__auto__,c__12231__auto___12917,tc,fc))
})();
var state__12233__auto__ = (function (){var statearr_12912 = f__12232__auto__.call(null);
(statearr_12912[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12231__auto___12917);

return statearr_12912;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__12233__auto__);
});})(c__12231__auto___12917,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__12231__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__12231__auto__){
return (function (){
var f__12232__auto__ = (function (){var switch__12119__auto__ = ((function (c__12231__auto__){
return (function (state_12997){
var state_val_12998 = (state_12997[(1)]);
if((state_val_12998 === (7))){
var inst_12993 = (state_12997[(2)]);
var state_12997__$1 = state_12997;
var statearr_12999_13020 = state_12997__$1;
(statearr_12999_13020[(2)] = inst_12993);

(statearr_12999_13020[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12998 === (1))){
var inst_12977 = init;
var state_12997__$1 = (function (){var statearr_13000 = state_12997;
(statearr_13000[(7)] = inst_12977);

return statearr_13000;
})();
var statearr_13001_13021 = state_12997__$1;
(statearr_13001_13021[(2)] = null);

(statearr_13001_13021[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12998 === (4))){
var inst_12980 = (state_12997[(8)]);
var inst_12980__$1 = (state_12997[(2)]);
var inst_12981 = (inst_12980__$1 == null);
var state_12997__$1 = (function (){var statearr_13002 = state_12997;
(statearr_13002[(8)] = inst_12980__$1);

return statearr_13002;
})();
if(cljs.core.truth_(inst_12981)){
var statearr_13003_13022 = state_12997__$1;
(statearr_13003_13022[(1)] = (5));

} else {
var statearr_13004_13023 = state_12997__$1;
(statearr_13004_13023[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12998 === (6))){
var inst_12980 = (state_12997[(8)]);
var inst_12977 = (state_12997[(7)]);
var inst_12984 = (state_12997[(9)]);
var inst_12984__$1 = f.call(null,inst_12977,inst_12980);
var inst_12985 = cljs.core.reduced_QMARK_.call(null,inst_12984__$1);
var state_12997__$1 = (function (){var statearr_13005 = state_12997;
(statearr_13005[(9)] = inst_12984__$1);

return statearr_13005;
})();
if(inst_12985){
var statearr_13006_13024 = state_12997__$1;
(statearr_13006_13024[(1)] = (8));

} else {
var statearr_13007_13025 = state_12997__$1;
(statearr_13007_13025[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12998 === (3))){
var inst_12995 = (state_12997[(2)]);
var state_12997__$1 = state_12997;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12997__$1,inst_12995);
} else {
if((state_val_12998 === (2))){
var state_12997__$1 = state_12997;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12997__$1,(4),ch);
} else {
if((state_val_12998 === (9))){
var inst_12984 = (state_12997[(9)]);
var inst_12977 = inst_12984;
var state_12997__$1 = (function (){var statearr_13008 = state_12997;
(statearr_13008[(7)] = inst_12977);

return statearr_13008;
})();
var statearr_13009_13026 = state_12997__$1;
(statearr_13009_13026[(2)] = null);

(statearr_13009_13026[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12998 === (5))){
var inst_12977 = (state_12997[(7)]);
var state_12997__$1 = state_12997;
var statearr_13010_13027 = state_12997__$1;
(statearr_13010_13027[(2)] = inst_12977);

(statearr_13010_13027[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12998 === (10))){
var inst_12991 = (state_12997[(2)]);
var state_12997__$1 = state_12997;
var statearr_13011_13028 = state_12997__$1;
(statearr_13011_13028[(2)] = inst_12991);

(statearr_13011_13028[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12998 === (8))){
var inst_12984 = (state_12997[(9)]);
var inst_12987 = cljs.core.deref.call(null,inst_12984);
var state_12997__$1 = state_12997;
var statearr_13012_13029 = state_12997__$1;
(statearr_13012_13029[(2)] = inst_12987);

(statearr_13012_13029[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__12231__auto__))
;
return ((function (switch__12119__auto__,c__12231__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__12120__auto__ = null;
var cljs$core$async$reduce_$_state_machine__12120__auto____0 = (function (){
var statearr_13016 = [null,null,null,null,null,null,null,null,null,null];
(statearr_13016[(0)] = cljs$core$async$reduce_$_state_machine__12120__auto__);

(statearr_13016[(1)] = (1));

return statearr_13016;
});
var cljs$core$async$reduce_$_state_machine__12120__auto____1 = (function (state_12997){
while(true){
var ret_value__12121__auto__ = (function (){try{while(true){
var result__12122__auto__ = switch__12119__auto__.call(null,state_12997);
if(cljs.core.keyword_identical_QMARK_.call(null,result__12122__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12122__auto__;
}
break;
}
}catch (e13017){if((e13017 instanceof Object)){
var ex__12123__auto__ = e13017;
var statearr_13018_13030 = state_12997;
(statearr_13018_13030[(5)] = ex__12123__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12997);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13017;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__12121__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13031 = state_12997;
state_12997 = G__13031;
continue;
} else {
return ret_value__12121__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__12120__auto__ = function(state_12997){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__12120__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__12120__auto____1.call(this,state_12997);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__12120__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__12120__auto____0;
cljs$core$async$reduce_$_state_machine__12120__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__12120__auto____1;
return cljs$core$async$reduce_$_state_machine__12120__auto__;
})()
;})(switch__12119__auto__,c__12231__auto__))
})();
var state__12233__auto__ = (function (){var statearr_13019 = f__12232__auto__.call(null);
(statearr_13019[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12231__auto__);

return statearr_13019;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__12233__auto__);
});})(c__12231__auto__))
);

return c__12231__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = xform.call(null,f);
var c__12231__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__12231__auto__,f__$1){
return (function (){
var f__12232__auto__ = (function (){var switch__12119__auto__ = ((function (c__12231__auto__,f__$1){
return (function (state_13051){
var state_val_13052 = (state_13051[(1)]);
if((state_val_13052 === (1))){
var inst_13046 = cljs.core.async.reduce.call(null,f__$1,init,ch);
var state_13051__$1 = state_13051;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13051__$1,(2),inst_13046);
} else {
if((state_val_13052 === (2))){
var inst_13048 = (state_13051[(2)]);
var inst_13049 = f__$1.call(null,inst_13048);
var state_13051__$1 = state_13051;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13051__$1,inst_13049);
} else {
return null;
}
}
});})(c__12231__auto__,f__$1))
;
return ((function (switch__12119__auto__,c__12231__auto__,f__$1){
return (function() {
var cljs$core$async$transduce_$_state_machine__12120__auto__ = null;
var cljs$core$async$transduce_$_state_machine__12120__auto____0 = (function (){
var statearr_13056 = [null,null,null,null,null,null,null];
(statearr_13056[(0)] = cljs$core$async$transduce_$_state_machine__12120__auto__);

(statearr_13056[(1)] = (1));

return statearr_13056;
});
var cljs$core$async$transduce_$_state_machine__12120__auto____1 = (function (state_13051){
while(true){
var ret_value__12121__auto__ = (function (){try{while(true){
var result__12122__auto__ = switch__12119__auto__.call(null,state_13051);
if(cljs.core.keyword_identical_QMARK_.call(null,result__12122__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12122__auto__;
}
break;
}
}catch (e13057){if((e13057 instanceof Object)){
var ex__12123__auto__ = e13057;
var statearr_13058_13060 = state_13051;
(statearr_13058_13060[(5)] = ex__12123__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13051);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13057;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__12121__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13061 = state_13051;
state_13051 = G__13061;
continue;
} else {
return ret_value__12121__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__12120__auto__ = function(state_13051){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__12120__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__12120__auto____1.call(this,state_13051);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__12120__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__12120__auto____0;
cljs$core$async$transduce_$_state_machine__12120__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__12120__auto____1;
return cljs$core$async$transduce_$_state_machine__12120__auto__;
})()
;})(switch__12119__auto__,c__12231__auto__,f__$1))
})();
var state__12233__auto__ = (function (){var statearr_13059 = f__12232__auto__.call(null);
(statearr_13059[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12231__auto__);

return statearr_13059;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__12233__auto__);
});})(c__12231__auto__,f__$1))
);

return c__12231__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args13062 = [];
var len__7484__auto___13114 = arguments.length;
var i__7485__auto___13115 = (0);
while(true){
if((i__7485__auto___13115 < len__7484__auto___13114)){
args13062.push((arguments[i__7485__auto___13115]));

var G__13116 = (i__7485__auto___13115 + (1));
i__7485__auto___13115 = G__13116;
continue;
} else {
}
break;
}

var G__13064 = args13062.length;
switch (G__13064) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13062.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__12231__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__12231__auto__){
return (function (){
var f__12232__auto__ = (function (){var switch__12119__auto__ = ((function (c__12231__auto__){
return (function (state_13089){
var state_val_13090 = (state_13089[(1)]);
if((state_val_13090 === (7))){
var inst_13071 = (state_13089[(2)]);
var state_13089__$1 = state_13089;
var statearr_13091_13118 = state_13089__$1;
(statearr_13091_13118[(2)] = inst_13071);

(statearr_13091_13118[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13090 === (1))){
var inst_13065 = cljs.core.seq.call(null,coll);
var inst_13066 = inst_13065;
var state_13089__$1 = (function (){var statearr_13092 = state_13089;
(statearr_13092[(7)] = inst_13066);

return statearr_13092;
})();
var statearr_13093_13119 = state_13089__$1;
(statearr_13093_13119[(2)] = null);

(statearr_13093_13119[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13090 === (4))){
var inst_13066 = (state_13089[(7)]);
var inst_13069 = cljs.core.first.call(null,inst_13066);
var state_13089__$1 = state_13089;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13089__$1,(7),ch,inst_13069);
} else {
if((state_val_13090 === (13))){
var inst_13083 = (state_13089[(2)]);
var state_13089__$1 = state_13089;
var statearr_13094_13120 = state_13089__$1;
(statearr_13094_13120[(2)] = inst_13083);

(statearr_13094_13120[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13090 === (6))){
var inst_13074 = (state_13089[(2)]);
var state_13089__$1 = state_13089;
if(cljs.core.truth_(inst_13074)){
var statearr_13095_13121 = state_13089__$1;
(statearr_13095_13121[(1)] = (8));

} else {
var statearr_13096_13122 = state_13089__$1;
(statearr_13096_13122[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13090 === (3))){
var inst_13087 = (state_13089[(2)]);
var state_13089__$1 = state_13089;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13089__$1,inst_13087);
} else {
if((state_val_13090 === (12))){
var state_13089__$1 = state_13089;
var statearr_13097_13123 = state_13089__$1;
(statearr_13097_13123[(2)] = null);

(statearr_13097_13123[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13090 === (2))){
var inst_13066 = (state_13089[(7)]);
var state_13089__$1 = state_13089;
if(cljs.core.truth_(inst_13066)){
var statearr_13098_13124 = state_13089__$1;
(statearr_13098_13124[(1)] = (4));

} else {
var statearr_13099_13125 = state_13089__$1;
(statearr_13099_13125[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13090 === (11))){
var inst_13080 = cljs.core.async.close_BANG_.call(null,ch);
var state_13089__$1 = state_13089;
var statearr_13100_13126 = state_13089__$1;
(statearr_13100_13126[(2)] = inst_13080);

(statearr_13100_13126[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13090 === (9))){
var state_13089__$1 = state_13089;
if(cljs.core.truth_(close_QMARK_)){
var statearr_13101_13127 = state_13089__$1;
(statearr_13101_13127[(1)] = (11));

} else {
var statearr_13102_13128 = state_13089__$1;
(statearr_13102_13128[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13090 === (5))){
var inst_13066 = (state_13089[(7)]);
var state_13089__$1 = state_13089;
var statearr_13103_13129 = state_13089__$1;
(statearr_13103_13129[(2)] = inst_13066);

(statearr_13103_13129[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13090 === (10))){
var inst_13085 = (state_13089[(2)]);
var state_13089__$1 = state_13089;
var statearr_13104_13130 = state_13089__$1;
(statearr_13104_13130[(2)] = inst_13085);

(statearr_13104_13130[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13090 === (8))){
var inst_13066 = (state_13089[(7)]);
var inst_13076 = cljs.core.next.call(null,inst_13066);
var inst_13066__$1 = inst_13076;
var state_13089__$1 = (function (){var statearr_13105 = state_13089;
(statearr_13105[(7)] = inst_13066__$1);

return statearr_13105;
})();
var statearr_13106_13131 = state_13089__$1;
(statearr_13106_13131[(2)] = null);

(statearr_13106_13131[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12231__auto__))
;
return ((function (switch__12119__auto__,c__12231__auto__){
return (function() {
var cljs$core$async$state_machine__12120__auto__ = null;
var cljs$core$async$state_machine__12120__auto____0 = (function (){
var statearr_13110 = [null,null,null,null,null,null,null,null];
(statearr_13110[(0)] = cljs$core$async$state_machine__12120__auto__);

(statearr_13110[(1)] = (1));

return statearr_13110;
});
var cljs$core$async$state_machine__12120__auto____1 = (function (state_13089){
while(true){
var ret_value__12121__auto__ = (function (){try{while(true){
var result__12122__auto__ = switch__12119__auto__.call(null,state_13089);
if(cljs.core.keyword_identical_QMARK_.call(null,result__12122__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12122__auto__;
}
break;
}
}catch (e13111){if((e13111 instanceof Object)){
var ex__12123__auto__ = e13111;
var statearr_13112_13132 = state_13089;
(statearr_13112_13132[(5)] = ex__12123__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13089);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13111;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__12121__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13133 = state_13089;
state_13089 = G__13133;
continue;
} else {
return ret_value__12121__auto__;
}
break;
}
});
cljs$core$async$state_machine__12120__auto__ = function(state_13089){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12120__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12120__auto____1.call(this,state_13089);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12120__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12120__auto____0;
cljs$core$async$state_machine__12120__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12120__auto____1;
return cljs$core$async$state_machine__12120__auto__;
})()
;})(switch__12119__auto__,c__12231__auto__))
})();
var state__12233__auto__ = (function (){var statearr_13113 = f__12232__auto__.call(null);
(statearr_13113[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12231__auto__);

return statearr_13113;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__12233__auto__);
});})(c__12231__auto__))
);

return c__12231__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__7072__auto__ = (((_ == null))?null:_);
var m__7073__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return m__7073__auto__.call(null,_);
} else {
var m__7073__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return m__7073__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__7072__auto__ = (((m == null))?null:m);
var m__7073__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return m__7073__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__7073__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return m__7073__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__7072__auto__ = (((m == null))?null:m);
var m__7073__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return m__7073__auto__.call(null,m,ch);
} else {
var m__7073__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return m__7073__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__7072__auto__ = (((m == null))?null:m);
var m__7073__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return m__7073__auto__.call(null,m);
} else {
var m__7073__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return m__7073__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async13359 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async13359 = (function (mult,ch,cs,meta13360){
this.mult = mult;
this.ch = ch;
this.cs = cs;
this.meta13360 = meta13360;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async13359.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_13361,meta13360__$1){
var self__ = this;
var _13361__$1 = this;
return (new cljs.core.async.t_cljs$core$async13359(self__.mult,self__.ch,self__.cs,meta13360__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async13359.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_13361){
var self__ = this;
var _13361__$1 = this;
return self__.meta13360;
});})(cs))
;

cljs.core.async.t_cljs$core$async13359.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async13359.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async13359.prototype.cljs$core$async$Mult$ = true;

cljs.core.async.t_cljs$core$async13359.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async13359.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async13359.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async13359.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"mult","mult",-1187640995,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mult(iple) of the supplied channel. Channels\n  containing copies of the channel can be created with 'tap', and\n  detached with 'untap'.\n\n  Each item is distributed to all taps in parallel and synchronously,\n  i.e. each tap must accept before the next item is distributed. Use\n  buffering/windowing to prevent slow taps from holding up the mult.\n\n  Items received when there are no taps get dropped.\n\n  If a tap puts to a closed channel, it will be removed from the mult."], null)),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta13360","meta13360",-2058838303,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async13359.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async13359.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async13359";

cljs.core.async.t_cljs$core$async13359.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"cljs.core.async/t_cljs$core$async13359");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async13359 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async13359(mult__$1,ch__$1,cs__$1,meta13360){
return (new cljs.core.async.t_cljs$core$async13359(mult__$1,ch__$1,cs__$1,meta13360));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async13359(cljs$core$async$mult,ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__12231__auto___13584 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__12231__auto___13584,cs,m,dchan,dctr,done){
return (function (){
var f__12232__auto__ = (function (){var switch__12119__auto__ = ((function (c__12231__auto___13584,cs,m,dchan,dctr,done){
return (function (state_13496){
var state_val_13497 = (state_13496[(1)]);
if((state_val_13497 === (7))){
var inst_13492 = (state_13496[(2)]);
var state_13496__$1 = state_13496;
var statearr_13498_13585 = state_13496__$1;
(statearr_13498_13585[(2)] = inst_13492);

(statearr_13498_13585[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13497 === (20))){
var inst_13395 = (state_13496[(7)]);
var inst_13407 = cljs.core.first.call(null,inst_13395);
var inst_13408 = cljs.core.nth.call(null,inst_13407,(0),null);
var inst_13409 = cljs.core.nth.call(null,inst_13407,(1),null);
var state_13496__$1 = (function (){var statearr_13499 = state_13496;
(statearr_13499[(8)] = inst_13408);

return statearr_13499;
})();
if(cljs.core.truth_(inst_13409)){
var statearr_13500_13586 = state_13496__$1;
(statearr_13500_13586[(1)] = (22));

} else {
var statearr_13501_13587 = state_13496__$1;
(statearr_13501_13587[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13497 === (27))){
var inst_13437 = (state_13496[(9)]);
var inst_13439 = (state_13496[(10)]);
var inst_13444 = (state_13496[(11)]);
var inst_13364 = (state_13496[(12)]);
var inst_13444__$1 = cljs.core._nth.call(null,inst_13437,inst_13439);
var inst_13445 = cljs.core.async.put_BANG_.call(null,inst_13444__$1,inst_13364,done);
var state_13496__$1 = (function (){var statearr_13502 = state_13496;
(statearr_13502[(11)] = inst_13444__$1);

return statearr_13502;
})();
if(cljs.core.truth_(inst_13445)){
var statearr_13503_13588 = state_13496__$1;
(statearr_13503_13588[(1)] = (30));

} else {
var statearr_13504_13589 = state_13496__$1;
(statearr_13504_13589[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13497 === (1))){
var state_13496__$1 = state_13496;
var statearr_13505_13590 = state_13496__$1;
(statearr_13505_13590[(2)] = null);

(statearr_13505_13590[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13497 === (24))){
var inst_13395 = (state_13496[(7)]);
var inst_13414 = (state_13496[(2)]);
var inst_13415 = cljs.core.next.call(null,inst_13395);
var inst_13373 = inst_13415;
var inst_13374 = null;
var inst_13375 = (0);
var inst_13376 = (0);
var state_13496__$1 = (function (){var statearr_13506 = state_13496;
(statearr_13506[(13)] = inst_13374);

(statearr_13506[(14)] = inst_13376);

(statearr_13506[(15)] = inst_13414);

(statearr_13506[(16)] = inst_13375);

(statearr_13506[(17)] = inst_13373);

return statearr_13506;
})();
var statearr_13507_13591 = state_13496__$1;
(statearr_13507_13591[(2)] = null);

(statearr_13507_13591[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13497 === (39))){
var state_13496__$1 = state_13496;
var statearr_13511_13592 = state_13496__$1;
(statearr_13511_13592[(2)] = null);

(statearr_13511_13592[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13497 === (4))){
var inst_13364 = (state_13496[(12)]);
var inst_13364__$1 = (state_13496[(2)]);
var inst_13365 = (inst_13364__$1 == null);
var state_13496__$1 = (function (){var statearr_13512 = state_13496;
(statearr_13512[(12)] = inst_13364__$1);

return statearr_13512;
})();
if(cljs.core.truth_(inst_13365)){
var statearr_13513_13593 = state_13496__$1;
(statearr_13513_13593[(1)] = (5));

} else {
var statearr_13514_13594 = state_13496__$1;
(statearr_13514_13594[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13497 === (15))){
var inst_13374 = (state_13496[(13)]);
var inst_13376 = (state_13496[(14)]);
var inst_13375 = (state_13496[(16)]);
var inst_13373 = (state_13496[(17)]);
var inst_13391 = (state_13496[(2)]);
var inst_13392 = (inst_13376 + (1));
var tmp13508 = inst_13374;
var tmp13509 = inst_13375;
var tmp13510 = inst_13373;
var inst_13373__$1 = tmp13510;
var inst_13374__$1 = tmp13508;
var inst_13375__$1 = tmp13509;
var inst_13376__$1 = inst_13392;
var state_13496__$1 = (function (){var statearr_13515 = state_13496;
(statearr_13515[(18)] = inst_13391);

(statearr_13515[(13)] = inst_13374__$1);

(statearr_13515[(14)] = inst_13376__$1);

(statearr_13515[(16)] = inst_13375__$1);

(statearr_13515[(17)] = inst_13373__$1);

return statearr_13515;
})();
var statearr_13516_13595 = state_13496__$1;
(statearr_13516_13595[(2)] = null);

(statearr_13516_13595[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13497 === (21))){
var inst_13418 = (state_13496[(2)]);
var state_13496__$1 = state_13496;
var statearr_13520_13596 = state_13496__$1;
(statearr_13520_13596[(2)] = inst_13418);

(statearr_13520_13596[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13497 === (31))){
var inst_13444 = (state_13496[(11)]);
var inst_13448 = done.call(null,null);
var inst_13449 = cljs.core.async.untap_STAR_.call(null,m,inst_13444);
var state_13496__$1 = (function (){var statearr_13521 = state_13496;
(statearr_13521[(19)] = inst_13448);

return statearr_13521;
})();
var statearr_13522_13597 = state_13496__$1;
(statearr_13522_13597[(2)] = inst_13449);

(statearr_13522_13597[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13497 === (32))){
var inst_13436 = (state_13496[(20)]);
var inst_13437 = (state_13496[(9)]);
var inst_13439 = (state_13496[(10)]);
var inst_13438 = (state_13496[(21)]);
var inst_13451 = (state_13496[(2)]);
var inst_13452 = (inst_13439 + (1));
var tmp13517 = inst_13436;
var tmp13518 = inst_13437;
var tmp13519 = inst_13438;
var inst_13436__$1 = tmp13517;
var inst_13437__$1 = tmp13518;
var inst_13438__$1 = tmp13519;
var inst_13439__$1 = inst_13452;
var state_13496__$1 = (function (){var statearr_13523 = state_13496;
(statearr_13523[(20)] = inst_13436__$1);

(statearr_13523[(22)] = inst_13451);

(statearr_13523[(9)] = inst_13437__$1);

(statearr_13523[(10)] = inst_13439__$1);

(statearr_13523[(21)] = inst_13438__$1);

return statearr_13523;
})();
var statearr_13524_13598 = state_13496__$1;
(statearr_13524_13598[(2)] = null);

(statearr_13524_13598[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13497 === (40))){
var inst_13464 = (state_13496[(23)]);
var inst_13468 = done.call(null,null);
var inst_13469 = cljs.core.async.untap_STAR_.call(null,m,inst_13464);
var state_13496__$1 = (function (){var statearr_13525 = state_13496;
(statearr_13525[(24)] = inst_13468);

return statearr_13525;
})();
var statearr_13526_13599 = state_13496__$1;
(statearr_13526_13599[(2)] = inst_13469);

(statearr_13526_13599[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13497 === (33))){
var inst_13455 = (state_13496[(25)]);
var inst_13457 = cljs.core.chunked_seq_QMARK_.call(null,inst_13455);
var state_13496__$1 = state_13496;
if(inst_13457){
var statearr_13527_13600 = state_13496__$1;
(statearr_13527_13600[(1)] = (36));

} else {
var statearr_13528_13601 = state_13496__$1;
(statearr_13528_13601[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13497 === (13))){
var inst_13385 = (state_13496[(26)]);
var inst_13388 = cljs.core.async.close_BANG_.call(null,inst_13385);
var state_13496__$1 = state_13496;
var statearr_13529_13602 = state_13496__$1;
(statearr_13529_13602[(2)] = inst_13388);

(statearr_13529_13602[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13497 === (22))){
var inst_13408 = (state_13496[(8)]);
var inst_13411 = cljs.core.async.close_BANG_.call(null,inst_13408);
var state_13496__$1 = state_13496;
var statearr_13530_13603 = state_13496__$1;
(statearr_13530_13603[(2)] = inst_13411);

(statearr_13530_13603[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13497 === (36))){
var inst_13455 = (state_13496[(25)]);
var inst_13459 = cljs.core.chunk_first.call(null,inst_13455);
var inst_13460 = cljs.core.chunk_rest.call(null,inst_13455);
var inst_13461 = cljs.core.count.call(null,inst_13459);
var inst_13436 = inst_13460;
var inst_13437 = inst_13459;
var inst_13438 = inst_13461;
var inst_13439 = (0);
var state_13496__$1 = (function (){var statearr_13531 = state_13496;
(statearr_13531[(20)] = inst_13436);

(statearr_13531[(9)] = inst_13437);

(statearr_13531[(10)] = inst_13439);

(statearr_13531[(21)] = inst_13438);

return statearr_13531;
})();
var statearr_13532_13604 = state_13496__$1;
(statearr_13532_13604[(2)] = null);

(statearr_13532_13604[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13497 === (41))){
var inst_13455 = (state_13496[(25)]);
var inst_13471 = (state_13496[(2)]);
var inst_13472 = cljs.core.next.call(null,inst_13455);
var inst_13436 = inst_13472;
var inst_13437 = null;
var inst_13438 = (0);
var inst_13439 = (0);
var state_13496__$1 = (function (){var statearr_13533 = state_13496;
(statearr_13533[(20)] = inst_13436);

(statearr_13533[(27)] = inst_13471);

(statearr_13533[(9)] = inst_13437);

(statearr_13533[(10)] = inst_13439);

(statearr_13533[(21)] = inst_13438);

return statearr_13533;
})();
var statearr_13534_13605 = state_13496__$1;
(statearr_13534_13605[(2)] = null);

(statearr_13534_13605[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13497 === (43))){
var state_13496__$1 = state_13496;
var statearr_13535_13606 = state_13496__$1;
(statearr_13535_13606[(2)] = null);

(statearr_13535_13606[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13497 === (29))){
var inst_13480 = (state_13496[(2)]);
var state_13496__$1 = state_13496;
var statearr_13536_13607 = state_13496__$1;
(statearr_13536_13607[(2)] = inst_13480);

(statearr_13536_13607[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13497 === (44))){
var inst_13489 = (state_13496[(2)]);
var state_13496__$1 = (function (){var statearr_13537 = state_13496;
(statearr_13537[(28)] = inst_13489);

return statearr_13537;
})();
var statearr_13538_13608 = state_13496__$1;
(statearr_13538_13608[(2)] = null);

(statearr_13538_13608[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13497 === (6))){
var inst_13428 = (state_13496[(29)]);
var inst_13427 = cljs.core.deref.call(null,cs);
var inst_13428__$1 = cljs.core.keys.call(null,inst_13427);
var inst_13429 = cljs.core.count.call(null,inst_13428__$1);
var inst_13430 = cljs.core.reset_BANG_.call(null,dctr,inst_13429);
var inst_13435 = cljs.core.seq.call(null,inst_13428__$1);
var inst_13436 = inst_13435;
var inst_13437 = null;
var inst_13438 = (0);
var inst_13439 = (0);
var state_13496__$1 = (function (){var statearr_13539 = state_13496;
(statearr_13539[(20)] = inst_13436);

(statearr_13539[(9)] = inst_13437);

(statearr_13539[(10)] = inst_13439);

(statearr_13539[(21)] = inst_13438);

(statearr_13539[(29)] = inst_13428__$1);

(statearr_13539[(30)] = inst_13430);

return statearr_13539;
})();
var statearr_13540_13609 = state_13496__$1;
(statearr_13540_13609[(2)] = null);

(statearr_13540_13609[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13497 === (28))){
var inst_13436 = (state_13496[(20)]);
var inst_13455 = (state_13496[(25)]);
var inst_13455__$1 = cljs.core.seq.call(null,inst_13436);
var state_13496__$1 = (function (){var statearr_13541 = state_13496;
(statearr_13541[(25)] = inst_13455__$1);

return statearr_13541;
})();
if(inst_13455__$1){
var statearr_13542_13610 = state_13496__$1;
(statearr_13542_13610[(1)] = (33));

} else {
var statearr_13543_13611 = state_13496__$1;
(statearr_13543_13611[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13497 === (25))){
var inst_13439 = (state_13496[(10)]);
var inst_13438 = (state_13496[(21)]);
var inst_13441 = (inst_13439 < inst_13438);
var inst_13442 = inst_13441;
var state_13496__$1 = state_13496;
if(cljs.core.truth_(inst_13442)){
var statearr_13544_13612 = state_13496__$1;
(statearr_13544_13612[(1)] = (27));

} else {
var statearr_13545_13613 = state_13496__$1;
(statearr_13545_13613[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13497 === (34))){
var state_13496__$1 = state_13496;
var statearr_13546_13614 = state_13496__$1;
(statearr_13546_13614[(2)] = null);

(statearr_13546_13614[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13497 === (17))){
var state_13496__$1 = state_13496;
var statearr_13547_13615 = state_13496__$1;
(statearr_13547_13615[(2)] = null);

(statearr_13547_13615[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13497 === (3))){
var inst_13494 = (state_13496[(2)]);
var state_13496__$1 = state_13496;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13496__$1,inst_13494);
} else {
if((state_val_13497 === (12))){
var inst_13423 = (state_13496[(2)]);
var state_13496__$1 = state_13496;
var statearr_13548_13616 = state_13496__$1;
(statearr_13548_13616[(2)] = inst_13423);

(statearr_13548_13616[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13497 === (2))){
var state_13496__$1 = state_13496;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13496__$1,(4),ch);
} else {
if((state_val_13497 === (23))){
var state_13496__$1 = state_13496;
var statearr_13549_13617 = state_13496__$1;
(statearr_13549_13617[(2)] = null);

(statearr_13549_13617[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13497 === (35))){
var inst_13478 = (state_13496[(2)]);
var state_13496__$1 = state_13496;
var statearr_13550_13618 = state_13496__$1;
(statearr_13550_13618[(2)] = inst_13478);

(statearr_13550_13618[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13497 === (19))){
var inst_13395 = (state_13496[(7)]);
var inst_13399 = cljs.core.chunk_first.call(null,inst_13395);
var inst_13400 = cljs.core.chunk_rest.call(null,inst_13395);
var inst_13401 = cljs.core.count.call(null,inst_13399);
var inst_13373 = inst_13400;
var inst_13374 = inst_13399;
var inst_13375 = inst_13401;
var inst_13376 = (0);
var state_13496__$1 = (function (){var statearr_13551 = state_13496;
(statearr_13551[(13)] = inst_13374);

(statearr_13551[(14)] = inst_13376);

(statearr_13551[(16)] = inst_13375);

(statearr_13551[(17)] = inst_13373);

return statearr_13551;
})();
var statearr_13552_13619 = state_13496__$1;
(statearr_13552_13619[(2)] = null);

(statearr_13552_13619[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13497 === (11))){
var inst_13395 = (state_13496[(7)]);
var inst_13373 = (state_13496[(17)]);
var inst_13395__$1 = cljs.core.seq.call(null,inst_13373);
var state_13496__$1 = (function (){var statearr_13553 = state_13496;
(statearr_13553[(7)] = inst_13395__$1);

return statearr_13553;
})();
if(inst_13395__$1){
var statearr_13554_13620 = state_13496__$1;
(statearr_13554_13620[(1)] = (16));

} else {
var statearr_13555_13621 = state_13496__$1;
(statearr_13555_13621[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13497 === (9))){
var inst_13425 = (state_13496[(2)]);
var state_13496__$1 = state_13496;
var statearr_13556_13622 = state_13496__$1;
(statearr_13556_13622[(2)] = inst_13425);

(statearr_13556_13622[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13497 === (5))){
var inst_13371 = cljs.core.deref.call(null,cs);
var inst_13372 = cljs.core.seq.call(null,inst_13371);
var inst_13373 = inst_13372;
var inst_13374 = null;
var inst_13375 = (0);
var inst_13376 = (0);
var state_13496__$1 = (function (){var statearr_13557 = state_13496;
(statearr_13557[(13)] = inst_13374);

(statearr_13557[(14)] = inst_13376);

(statearr_13557[(16)] = inst_13375);

(statearr_13557[(17)] = inst_13373);

return statearr_13557;
})();
var statearr_13558_13623 = state_13496__$1;
(statearr_13558_13623[(2)] = null);

(statearr_13558_13623[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13497 === (14))){
var state_13496__$1 = state_13496;
var statearr_13559_13624 = state_13496__$1;
(statearr_13559_13624[(2)] = null);

(statearr_13559_13624[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13497 === (45))){
var inst_13486 = (state_13496[(2)]);
var state_13496__$1 = state_13496;
var statearr_13560_13625 = state_13496__$1;
(statearr_13560_13625[(2)] = inst_13486);

(statearr_13560_13625[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13497 === (26))){
var inst_13428 = (state_13496[(29)]);
var inst_13482 = (state_13496[(2)]);
var inst_13483 = cljs.core.seq.call(null,inst_13428);
var state_13496__$1 = (function (){var statearr_13561 = state_13496;
(statearr_13561[(31)] = inst_13482);

return statearr_13561;
})();
if(inst_13483){
var statearr_13562_13626 = state_13496__$1;
(statearr_13562_13626[(1)] = (42));

} else {
var statearr_13563_13627 = state_13496__$1;
(statearr_13563_13627[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13497 === (16))){
var inst_13395 = (state_13496[(7)]);
var inst_13397 = cljs.core.chunked_seq_QMARK_.call(null,inst_13395);
var state_13496__$1 = state_13496;
if(inst_13397){
var statearr_13564_13628 = state_13496__$1;
(statearr_13564_13628[(1)] = (19));

} else {
var statearr_13565_13629 = state_13496__$1;
(statearr_13565_13629[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13497 === (38))){
var inst_13475 = (state_13496[(2)]);
var state_13496__$1 = state_13496;
var statearr_13566_13630 = state_13496__$1;
(statearr_13566_13630[(2)] = inst_13475);

(statearr_13566_13630[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13497 === (30))){
var state_13496__$1 = state_13496;
var statearr_13567_13631 = state_13496__$1;
(statearr_13567_13631[(2)] = null);

(statearr_13567_13631[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13497 === (10))){
var inst_13374 = (state_13496[(13)]);
var inst_13376 = (state_13496[(14)]);
var inst_13384 = cljs.core._nth.call(null,inst_13374,inst_13376);
var inst_13385 = cljs.core.nth.call(null,inst_13384,(0),null);
var inst_13386 = cljs.core.nth.call(null,inst_13384,(1),null);
var state_13496__$1 = (function (){var statearr_13568 = state_13496;
(statearr_13568[(26)] = inst_13385);

return statearr_13568;
})();
if(cljs.core.truth_(inst_13386)){
var statearr_13569_13632 = state_13496__$1;
(statearr_13569_13632[(1)] = (13));

} else {
var statearr_13570_13633 = state_13496__$1;
(statearr_13570_13633[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13497 === (18))){
var inst_13421 = (state_13496[(2)]);
var state_13496__$1 = state_13496;
var statearr_13571_13634 = state_13496__$1;
(statearr_13571_13634[(2)] = inst_13421);

(statearr_13571_13634[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13497 === (42))){
var state_13496__$1 = state_13496;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13496__$1,(45),dchan);
} else {
if((state_val_13497 === (37))){
var inst_13455 = (state_13496[(25)]);
var inst_13464 = (state_13496[(23)]);
var inst_13364 = (state_13496[(12)]);
var inst_13464__$1 = cljs.core.first.call(null,inst_13455);
var inst_13465 = cljs.core.async.put_BANG_.call(null,inst_13464__$1,inst_13364,done);
var state_13496__$1 = (function (){var statearr_13572 = state_13496;
(statearr_13572[(23)] = inst_13464__$1);

return statearr_13572;
})();
if(cljs.core.truth_(inst_13465)){
var statearr_13573_13635 = state_13496__$1;
(statearr_13573_13635[(1)] = (39));

} else {
var statearr_13574_13636 = state_13496__$1;
(statearr_13574_13636[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13497 === (8))){
var inst_13376 = (state_13496[(14)]);
var inst_13375 = (state_13496[(16)]);
var inst_13378 = (inst_13376 < inst_13375);
var inst_13379 = inst_13378;
var state_13496__$1 = state_13496;
if(cljs.core.truth_(inst_13379)){
var statearr_13575_13637 = state_13496__$1;
(statearr_13575_13637[(1)] = (10));

} else {
var statearr_13576_13638 = state_13496__$1;
(statearr_13576_13638[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12231__auto___13584,cs,m,dchan,dctr,done))
;
return ((function (switch__12119__auto__,c__12231__auto___13584,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__12120__auto__ = null;
var cljs$core$async$mult_$_state_machine__12120__auto____0 = (function (){
var statearr_13580 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_13580[(0)] = cljs$core$async$mult_$_state_machine__12120__auto__);

(statearr_13580[(1)] = (1));

return statearr_13580;
});
var cljs$core$async$mult_$_state_machine__12120__auto____1 = (function (state_13496){
while(true){
var ret_value__12121__auto__ = (function (){try{while(true){
var result__12122__auto__ = switch__12119__auto__.call(null,state_13496);
if(cljs.core.keyword_identical_QMARK_.call(null,result__12122__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12122__auto__;
}
break;
}
}catch (e13581){if((e13581 instanceof Object)){
var ex__12123__auto__ = e13581;
var statearr_13582_13639 = state_13496;
(statearr_13582_13639[(5)] = ex__12123__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13496);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13581;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__12121__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13640 = state_13496;
state_13496 = G__13640;
continue;
} else {
return ret_value__12121__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__12120__auto__ = function(state_13496){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__12120__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__12120__auto____1.call(this,state_13496);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__12120__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__12120__auto____0;
cljs$core$async$mult_$_state_machine__12120__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__12120__auto____1;
return cljs$core$async$mult_$_state_machine__12120__auto__;
})()
;})(switch__12119__auto__,c__12231__auto___13584,cs,m,dchan,dctr,done))
})();
var state__12233__auto__ = (function (){var statearr_13583 = f__12232__auto__.call(null);
(statearr_13583[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12231__auto___13584);

return statearr_13583;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__12233__auto__);
});})(c__12231__auto___13584,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args13641 = [];
var len__7484__auto___13644 = arguments.length;
var i__7485__auto___13645 = (0);
while(true){
if((i__7485__auto___13645 < len__7484__auto___13644)){
args13641.push((arguments[i__7485__auto___13645]));

var G__13646 = (i__7485__auto___13645 + (1));
i__7485__auto___13645 = G__13646;
continue;
} else {
}
break;
}

var G__13643 = args13641.length;
switch (G__13643) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13641.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__7072__auto__ = (((m == null))?null:m);
var m__7073__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return m__7073__auto__.call(null,m,ch);
} else {
var m__7073__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return m__7073__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__7072__auto__ = (((m == null))?null:m);
var m__7073__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return m__7073__auto__.call(null,m,ch);
} else {
var m__7073__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return m__7073__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__7072__auto__ = (((m == null))?null:m);
var m__7073__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return m__7073__auto__.call(null,m);
} else {
var m__7073__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return m__7073__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__7072__auto__ = (((m == null))?null:m);
var m__7073__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return m__7073__auto__.call(null,m,state_map);
} else {
var m__7073__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return m__7073__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__7072__auto__ = (((m == null))?null:m);
var m__7073__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return m__7073__auto__.call(null,m,mode);
} else {
var m__7073__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return m__7073__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__7491__auto__ = [];
var len__7484__auto___13658 = arguments.length;
var i__7485__auto___13659 = (0);
while(true){
if((i__7485__auto___13659 < len__7484__auto___13658)){
args__7491__auto__.push((arguments[i__7485__auto___13659]));

var G__13660 = (i__7485__auto___13659 + (1));
i__7485__auto___13659 = G__13660;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((3) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7492__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__13652){
var map__13653 = p__13652;
var map__13653__$1 = ((((!((map__13653 == null)))?((((map__13653.cljs$lang$protocol_mask$partition0$ & (64))) || (map__13653.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__13653):map__13653);
var opts = map__13653__$1;
var statearr_13655_13661 = state;
(statearr_13655_13661[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__4657__auto__ = cljs.core.async.do_alts.call(null,((function (map__13653,map__13653__$1,opts){
return (function (val){
var statearr_13656_13662 = state;
(statearr_13656_13662[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__13653,map__13653__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4657__auto__)){
var cb = temp__4657__auto__;
var statearr_13657_13663 = state;
(statearr_13657_13663[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq13648){
var G__13649 = cljs.core.first.call(null,seq13648);
var seq13648__$1 = cljs.core.next.call(null,seq13648);
var G__13650 = cljs.core.first.call(null,seq13648__$1);
var seq13648__$2 = cljs.core.next.call(null,seq13648__$1);
var G__13651 = cljs.core.first.call(null,seq13648__$2);
var seq13648__$3 = cljs.core.next.call(null,seq13648__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__13649,G__13650,G__13651,seq13648__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async13829 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async13829 = (function (change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta13830){
this.change = change;
this.mix = mix;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta13830 = meta13830;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async13829.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_13831,meta13830__$1){
var self__ = this;
var _13831__$1 = this;
return (new cljs.core.async.t_cljs$core$async13829(self__.change,self__.mix,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta13830__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async13829.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_13831){
var self__ = this;
var _13831__$1 = this;
return self__.meta13830;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async13829.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async13829.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async13829.prototype.cljs$core$async$Mix$ = true;

cljs.core.async.t_cljs$core$async13829.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async13829.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async13829.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async13829.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async13829.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str("(solo-modes mode)")].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async13829.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),cljs.core.with_meta(new cljs.core.Symbol(null,"mix","mix",2121373763,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mix of one or more input channels which will\n  be put on the supplied out channel. Input sources can be added to\n  the mix with 'admix', and removed with 'unmix'. A mix supports\n  soloing, muting and pausing multiple inputs atomically using\n  'toggle', and can solo using either muting or pausing as determined\n  by 'solo-mode'.\n\n  Each channel can have zero or more boolean modes set via 'toggle':\n\n  :solo - when true, only this (ond other soloed) channel(s) will appear\n          in the mix output channel. :mute and :pause states of soloed\n          channels are ignored. If solo-mode is :mute, non-soloed\n          channels are muted, if :pause, non-soloed channels are\n          paused.\n\n  :mute - muted channels will have their contents consumed but not included in the mix\n  :pause - paused channels will not have their contents consumed (and thus also not included in the mix)\n"], null)),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta13830","meta13830",538204164,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async13829.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async13829.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async13829";

cljs.core.async.t_cljs$core$async13829.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"cljs.core.async/t_cljs$core$async13829");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async13829 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async13829(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta13830){
return (new cljs.core.async.t_cljs$core$async13829(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta13830));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async13829(change,cljs$core$async$mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__12231__auto___13994 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__12231__auto___13994,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__12232__auto__ = (function (){var switch__12119__auto__ = ((function (c__12231__auto___13994,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_13931){
var state_val_13932 = (state_13931[(1)]);
if((state_val_13932 === (7))){
var inst_13847 = (state_13931[(2)]);
var state_13931__$1 = state_13931;
var statearr_13933_13995 = state_13931__$1;
(statearr_13933_13995[(2)] = inst_13847);

(statearr_13933_13995[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13932 === (20))){
var inst_13859 = (state_13931[(7)]);
var state_13931__$1 = state_13931;
var statearr_13934_13996 = state_13931__$1;
(statearr_13934_13996[(2)] = inst_13859);

(statearr_13934_13996[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13932 === (27))){
var state_13931__$1 = state_13931;
var statearr_13935_13997 = state_13931__$1;
(statearr_13935_13997[(2)] = null);

(statearr_13935_13997[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13932 === (1))){
var inst_13835 = (state_13931[(8)]);
var inst_13835__$1 = calc_state.call(null);
var inst_13837 = (inst_13835__$1 == null);
var inst_13838 = cljs.core.not.call(null,inst_13837);
var state_13931__$1 = (function (){var statearr_13936 = state_13931;
(statearr_13936[(8)] = inst_13835__$1);

return statearr_13936;
})();
if(inst_13838){
var statearr_13937_13998 = state_13931__$1;
(statearr_13937_13998[(1)] = (2));

} else {
var statearr_13938_13999 = state_13931__$1;
(statearr_13938_13999[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13932 === (24))){
var inst_13905 = (state_13931[(9)]);
var inst_13882 = (state_13931[(10)]);
var inst_13891 = (state_13931[(11)]);
var inst_13905__$1 = inst_13882.call(null,inst_13891);
var state_13931__$1 = (function (){var statearr_13939 = state_13931;
(statearr_13939[(9)] = inst_13905__$1);

return statearr_13939;
})();
if(cljs.core.truth_(inst_13905__$1)){
var statearr_13940_14000 = state_13931__$1;
(statearr_13940_14000[(1)] = (29));

} else {
var statearr_13941_14001 = state_13931__$1;
(statearr_13941_14001[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13932 === (4))){
var inst_13850 = (state_13931[(2)]);
var state_13931__$1 = state_13931;
if(cljs.core.truth_(inst_13850)){
var statearr_13942_14002 = state_13931__$1;
(statearr_13942_14002[(1)] = (8));

} else {
var statearr_13943_14003 = state_13931__$1;
(statearr_13943_14003[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13932 === (15))){
var inst_13876 = (state_13931[(2)]);
var state_13931__$1 = state_13931;
if(cljs.core.truth_(inst_13876)){
var statearr_13944_14004 = state_13931__$1;
(statearr_13944_14004[(1)] = (19));

} else {
var statearr_13945_14005 = state_13931__$1;
(statearr_13945_14005[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13932 === (21))){
var inst_13881 = (state_13931[(12)]);
var inst_13881__$1 = (state_13931[(2)]);
var inst_13882 = cljs.core.get.call(null,inst_13881__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_13883 = cljs.core.get.call(null,inst_13881__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_13884 = cljs.core.get.call(null,inst_13881__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_13931__$1 = (function (){var statearr_13946 = state_13931;
(statearr_13946[(13)] = inst_13883);

(statearr_13946[(10)] = inst_13882);

(statearr_13946[(12)] = inst_13881__$1);

return statearr_13946;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_13931__$1,(22),inst_13884);
} else {
if((state_val_13932 === (31))){
var inst_13913 = (state_13931[(2)]);
var state_13931__$1 = state_13931;
if(cljs.core.truth_(inst_13913)){
var statearr_13947_14006 = state_13931__$1;
(statearr_13947_14006[(1)] = (32));

} else {
var statearr_13948_14007 = state_13931__$1;
(statearr_13948_14007[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13932 === (32))){
var inst_13890 = (state_13931[(14)]);
var state_13931__$1 = state_13931;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13931__$1,(35),out,inst_13890);
} else {
if((state_val_13932 === (33))){
var inst_13881 = (state_13931[(12)]);
var inst_13859 = inst_13881;
var state_13931__$1 = (function (){var statearr_13949 = state_13931;
(statearr_13949[(7)] = inst_13859);

return statearr_13949;
})();
var statearr_13950_14008 = state_13931__$1;
(statearr_13950_14008[(2)] = null);

(statearr_13950_14008[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13932 === (13))){
var inst_13859 = (state_13931[(7)]);
var inst_13866 = inst_13859.cljs$lang$protocol_mask$partition0$;
var inst_13867 = (inst_13866 & (64));
var inst_13868 = inst_13859.cljs$core$ISeq$;
var inst_13869 = (inst_13867) || (inst_13868);
var state_13931__$1 = state_13931;
if(cljs.core.truth_(inst_13869)){
var statearr_13951_14009 = state_13931__$1;
(statearr_13951_14009[(1)] = (16));

} else {
var statearr_13952_14010 = state_13931__$1;
(statearr_13952_14010[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13932 === (22))){
var inst_13891 = (state_13931[(11)]);
var inst_13890 = (state_13931[(14)]);
var inst_13889 = (state_13931[(2)]);
var inst_13890__$1 = cljs.core.nth.call(null,inst_13889,(0),null);
var inst_13891__$1 = cljs.core.nth.call(null,inst_13889,(1),null);
var inst_13892 = (inst_13890__$1 == null);
var inst_13893 = cljs.core._EQ_.call(null,inst_13891__$1,change);
var inst_13894 = (inst_13892) || (inst_13893);
var state_13931__$1 = (function (){var statearr_13953 = state_13931;
(statearr_13953[(11)] = inst_13891__$1);

(statearr_13953[(14)] = inst_13890__$1);

return statearr_13953;
})();
if(cljs.core.truth_(inst_13894)){
var statearr_13954_14011 = state_13931__$1;
(statearr_13954_14011[(1)] = (23));

} else {
var statearr_13955_14012 = state_13931__$1;
(statearr_13955_14012[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13932 === (36))){
var inst_13881 = (state_13931[(12)]);
var inst_13859 = inst_13881;
var state_13931__$1 = (function (){var statearr_13956 = state_13931;
(statearr_13956[(7)] = inst_13859);

return statearr_13956;
})();
var statearr_13957_14013 = state_13931__$1;
(statearr_13957_14013[(2)] = null);

(statearr_13957_14013[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13932 === (29))){
var inst_13905 = (state_13931[(9)]);
var state_13931__$1 = state_13931;
var statearr_13958_14014 = state_13931__$1;
(statearr_13958_14014[(2)] = inst_13905);

(statearr_13958_14014[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13932 === (6))){
var state_13931__$1 = state_13931;
var statearr_13959_14015 = state_13931__$1;
(statearr_13959_14015[(2)] = false);

(statearr_13959_14015[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13932 === (28))){
var inst_13901 = (state_13931[(2)]);
var inst_13902 = calc_state.call(null);
var inst_13859 = inst_13902;
var state_13931__$1 = (function (){var statearr_13960 = state_13931;
(statearr_13960[(15)] = inst_13901);

(statearr_13960[(7)] = inst_13859);

return statearr_13960;
})();
var statearr_13961_14016 = state_13931__$1;
(statearr_13961_14016[(2)] = null);

(statearr_13961_14016[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13932 === (25))){
var inst_13927 = (state_13931[(2)]);
var state_13931__$1 = state_13931;
var statearr_13962_14017 = state_13931__$1;
(statearr_13962_14017[(2)] = inst_13927);

(statearr_13962_14017[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13932 === (34))){
var inst_13925 = (state_13931[(2)]);
var state_13931__$1 = state_13931;
var statearr_13963_14018 = state_13931__$1;
(statearr_13963_14018[(2)] = inst_13925);

(statearr_13963_14018[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13932 === (17))){
var state_13931__$1 = state_13931;
var statearr_13964_14019 = state_13931__$1;
(statearr_13964_14019[(2)] = false);

(statearr_13964_14019[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13932 === (3))){
var state_13931__$1 = state_13931;
var statearr_13965_14020 = state_13931__$1;
(statearr_13965_14020[(2)] = false);

(statearr_13965_14020[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13932 === (12))){
var inst_13929 = (state_13931[(2)]);
var state_13931__$1 = state_13931;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13931__$1,inst_13929);
} else {
if((state_val_13932 === (2))){
var inst_13835 = (state_13931[(8)]);
var inst_13840 = inst_13835.cljs$lang$protocol_mask$partition0$;
var inst_13841 = (inst_13840 & (64));
var inst_13842 = inst_13835.cljs$core$ISeq$;
var inst_13843 = (inst_13841) || (inst_13842);
var state_13931__$1 = state_13931;
if(cljs.core.truth_(inst_13843)){
var statearr_13966_14021 = state_13931__$1;
(statearr_13966_14021[(1)] = (5));

} else {
var statearr_13967_14022 = state_13931__$1;
(statearr_13967_14022[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13932 === (23))){
var inst_13890 = (state_13931[(14)]);
var inst_13896 = (inst_13890 == null);
var state_13931__$1 = state_13931;
if(cljs.core.truth_(inst_13896)){
var statearr_13968_14023 = state_13931__$1;
(statearr_13968_14023[(1)] = (26));

} else {
var statearr_13969_14024 = state_13931__$1;
(statearr_13969_14024[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13932 === (35))){
var inst_13916 = (state_13931[(2)]);
var state_13931__$1 = state_13931;
if(cljs.core.truth_(inst_13916)){
var statearr_13970_14025 = state_13931__$1;
(statearr_13970_14025[(1)] = (36));

} else {
var statearr_13971_14026 = state_13931__$1;
(statearr_13971_14026[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13932 === (19))){
var inst_13859 = (state_13931[(7)]);
var inst_13878 = cljs.core.apply.call(null,cljs.core.hash_map,inst_13859);
var state_13931__$1 = state_13931;
var statearr_13972_14027 = state_13931__$1;
(statearr_13972_14027[(2)] = inst_13878);

(statearr_13972_14027[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13932 === (11))){
var inst_13859 = (state_13931[(7)]);
var inst_13863 = (inst_13859 == null);
var inst_13864 = cljs.core.not.call(null,inst_13863);
var state_13931__$1 = state_13931;
if(inst_13864){
var statearr_13973_14028 = state_13931__$1;
(statearr_13973_14028[(1)] = (13));

} else {
var statearr_13974_14029 = state_13931__$1;
(statearr_13974_14029[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13932 === (9))){
var inst_13835 = (state_13931[(8)]);
var state_13931__$1 = state_13931;
var statearr_13975_14030 = state_13931__$1;
(statearr_13975_14030[(2)] = inst_13835);

(statearr_13975_14030[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13932 === (5))){
var state_13931__$1 = state_13931;
var statearr_13976_14031 = state_13931__$1;
(statearr_13976_14031[(2)] = true);

(statearr_13976_14031[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13932 === (14))){
var state_13931__$1 = state_13931;
var statearr_13977_14032 = state_13931__$1;
(statearr_13977_14032[(2)] = false);

(statearr_13977_14032[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13932 === (26))){
var inst_13891 = (state_13931[(11)]);
var inst_13898 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_13891);
var state_13931__$1 = state_13931;
var statearr_13978_14033 = state_13931__$1;
(statearr_13978_14033[(2)] = inst_13898);

(statearr_13978_14033[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13932 === (16))){
var state_13931__$1 = state_13931;
var statearr_13979_14034 = state_13931__$1;
(statearr_13979_14034[(2)] = true);

(statearr_13979_14034[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13932 === (38))){
var inst_13921 = (state_13931[(2)]);
var state_13931__$1 = state_13931;
var statearr_13980_14035 = state_13931__$1;
(statearr_13980_14035[(2)] = inst_13921);

(statearr_13980_14035[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13932 === (30))){
var inst_13883 = (state_13931[(13)]);
var inst_13882 = (state_13931[(10)]);
var inst_13891 = (state_13931[(11)]);
var inst_13908 = cljs.core.empty_QMARK_.call(null,inst_13882);
var inst_13909 = inst_13883.call(null,inst_13891);
var inst_13910 = cljs.core.not.call(null,inst_13909);
var inst_13911 = (inst_13908) && (inst_13910);
var state_13931__$1 = state_13931;
var statearr_13981_14036 = state_13931__$1;
(statearr_13981_14036[(2)] = inst_13911);

(statearr_13981_14036[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13932 === (10))){
var inst_13835 = (state_13931[(8)]);
var inst_13855 = (state_13931[(2)]);
var inst_13856 = cljs.core.get.call(null,inst_13855,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_13857 = cljs.core.get.call(null,inst_13855,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_13858 = cljs.core.get.call(null,inst_13855,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_13859 = inst_13835;
var state_13931__$1 = (function (){var statearr_13982 = state_13931;
(statearr_13982[(16)] = inst_13857);

(statearr_13982[(7)] = inst_13859);

(statearr_13982[(17)] = inst_13856);

(statearr_13982[(18)] = inst_13858);

return statearr_13982;
})();
var statearr_13983_14037 = state_13931__$1;
(statearr_13983_14037[(2)] = null);

(statearr_13983_14037[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13932 === (18))){
var inst_13873 = (state_13931[(2)]);
var state_13931__$1 = state_13931;
var statearr_13984_14038 = state_13931__$1;
(statearr_13984_14038[(2)] = inst_13873);

(statearr_13984_14038[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13932 === (37))){
var state_13931__$1 = state_13931;
var statearr_13985_14039 = state_13931__$1;
(statearr_13985_14039[(2)] = null);

(statearr_13985_14039[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13932 === (8))){
var inst_13835 = (state_13931[(8)]);
var inst_13852 = cljs.core.apply.call(null,cljs.core.hash_map,inst_13835);
var state_13931__$1 = state_13931;
var statearr_13986_14040 = state_13931__$1;
(statearr_13986_14040[(2)] = inst_13852);

(statearr_13986_14040[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12231__auto___13994,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__12119__auto__,c__12231__auto___13994,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__12120__auto__ = null;
var cljs$core$async$mix_$_state_machine__12120__auto____0 = (function (){
var statearr_13990 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_13990[(0)] = cljs$core$async$mix_$_state_machine__12120__auto__);

(statearr_13990[(1)] = (1));

return statearr_13990;
});
var cljs$core$async$mix_$_state_machine__12120__auto____1 = (function (state_13931){
while(true){
var ret_value__12121__auto__ = (function (){try{while(true){
var result__12122__auto__ = switch__12119__auto__.call(null,state_13931);
if(cljs.core.keyword_identical_QMARK_.call(null,result__12122__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12122__auto__;
}
break;
}
}catch (e13991){if((e13991 instanceof Object)){
var ex__12123__auto__ = e13991;
var statearr_13992_14041 = state_13931;
(statearr_13992_14041[(5)] = ex__12123__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13931);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13991;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__12121__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14042 = state_13931;
state_13931 = G__14042;
continue;
} else {
return ret_value__12121__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__12120__auto__ = function(state_13931){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__12120__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__12120__auto____1.call(this,state_13931);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__12120__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__12120__auto____0;
cljs$core$async$mix_$_state_machine__12120__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__12120__auto____1;
return cljs$core$async$mix_$_state_machine__12120__auto__;
})()
;})(switch__12119__auto__,c__12231__auto___13994,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__12233__auto__ = (function (){var statearr_13993 = f__12232__auto__.call(null);
(statearr_13993[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12231__auto___13994);

return statearr_13993;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__12233__auto__);
});})(c__12231__auto___13994,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__7072__auto__ = (((p == null))?null:p);
var m__7073__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return m__7073__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__7073__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return m__7073__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__7072__auto__ = (((p == null))?null:p);
var m__7073__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return m__7073__auto__.call(null,p,v,ch);
} else {
var m__7073__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return m__7073__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args14043 = [];
var len__7484__auto___14046 = arguments.length;
var i__7485__auto___14047 = (0);
while(true){
if((i__7485__auto___14047 < len__7484__auto___14046)){
args14043.push((arguments[i__7485__auto___14047]));

var G__14048 = (i__7485__auto___14047 + (1));
i__7485__auto___14047 = G__14048;
continue;
} else {
}
break;
}

var G__14045 = args14043.length;
switch (G__14045) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14043.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__7072__auto__ = (((p == null))?null:p);
var m__7073__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return m__7073__auto__.call(null,p);
} else {
var m__7073__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return m__7073__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__7072__auto__ = (((p == null))?null:p);
var m__7073__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return m__7073__auto__.call(null,p,v);
} else {
var m__7073__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return m__7073__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args14051 = [];
var len__7484__auto___14176 = arguments.length;
var i__7485__auto___14177 = (0);
while(true){
if((i__7485__auto___14177 < len__7484__auto___14176)){
args14051.push((arguments[i__7485__auto___14177]));

var G__14178 = (i__7485__auto___14177 + (1));
i__7485__auto___14177 = G__14178;
continue;
} else {
}
break;
}

var G__14053 = args14051.length;
switch (G__14053) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14051.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__6409__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__6409__auto__,mults){
return (function (p1__14050_SHARP_){
if(cljs.core.truth_(p1__14050_SHARP_.call(null,topic))){
return p1__14050_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__14050_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__6409__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async14054 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async14054 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta14055){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta14055 = meta14055;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async14054.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_14056,meta14055__$1){
var self__ = this;
var _14056__$1 = this;
return (new cljs.core.async.t_cljs$core$async14054(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta14055__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async14054.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_14056){
var self__ = this;
var _14056__$1 = this;
return self__.meta14055;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async14054.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async14054.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async14054.prototype.cljs$core$async$Pub$ = true;

cljs.core.async.t_cljs$core$async14054.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async14054.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4657__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__4657__auto__)){
var m = temp__4657__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async14054.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async14054.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async14054.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta14055","meta14055",1926032324,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async14054.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async14054.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async14054";

cljs.core.async.t_cljs$core$async14054.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"cljs.core.async/t_cljs$core$async14054");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async14054 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async14054(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta14055){
return (new cljs.core.async.t_cljs$core$async14054(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta14055));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async14054(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__12231__auto___14180 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__12231__auto___14180,mults,ensure_mult,p){
return (function (){
var f__12232__auto__ = (function (){var switch__12119__auto__ = ((function (c__12231__auto___14180,mults,ensure_mult,p){
return (function (state_14128){
var state_val_14129 = (state_14128[(1)]);
if((state_val_14129 === (7))){
var inst_14124 = (state_14128[(2)]);
var state_14128__$1 = state_14128;
var statearr_14130_14181 = state_14128__$1;
(statearr_14130_14181[(2)] = inst_14124);

(statearr_14130_14181[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14129 === (20))){
var state_14128__$1 = state_14128;
var statearr_14131_14182 = state_14128__$1;
(statearr_14131_14182[(2)] = null);

(statearr_14131_14182[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14129 === (1))){
var state_14128__$1 = state_14128;
var statearr_14132_14183 = state_14128__$1;
(statearr_14132_14183[(2)] = null);

(statearr_14132_14183[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14129 === (24))){
var inst_14107 = (state_14128[(7)]);
var inst_14116 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_14107);
var state_14128__$1 = state_14128;
var statearr_14133_14184 = state_14128__$1;
(statearr_14133_14184[(2)] = inst_14116);

(statearr_14133_14184[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14129 === (4))){
var inst_14059 = (state_14128[(8)]);
var inst_14059__$1 = (state_14128[(2)]);
var inst_14060 = (inst_14059__$1 == null);
var state_14128__$1 = (function (){var statearr_14134 = state_14128;
(statearr_14134[(8)] = inst_14059__$1);

return statearr_14134;
})();
if(cljs.core.truth_(inst_14060)){
var statearr_14135_14185 = state_14128__$1;
(statearr_14135_14185[(1)] = (5));

} else {
var statearr_14136_14186 = state_14128__$1;
(statearr_14136_14186[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14129 === (15))){
var inst_14101 = (state_14128[(2)]);
var state_14128__$1 = state_14128;
var statearr_14137_14187 = state_14128__$1;
(statearr_14137_14187[(2)] = inst_14101);

(statearr_14137_14187[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14129 === (21))){
var inst_14121 = (state_14128[(2)]);
var state_14128__$1 = (function (){var statearr_14138 = state_14128;
(statearr_14138[(9)] = inst_14121);

return statearr_14138;
})();
var statearr_14139_14188 = state_14128__$1;
(statearr_14139_14188[(2)] = null);

(statearr_14139_14188[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14129 === (13))){
var inst_14083 = (state_14128[(10)]);
var inst_14085 = cljs.core.chunked_seq_QMARK_.call(null,inst_14083);
var state_14128__$1 = state_14128;
if(inst_14085){
var statearr_14140_14189 = state_14128__$1;
(statearr_14140_14189[(1)] = (16));

} else {
var statearr_14141_14190 = state_14128__$1;
(statearr_14141_14190[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14129 === (22))){
var inst_14113 = (state_14128[(2)]);
var state_14128__$1 = state_14128;
if(cljs.core.truth_(inst_14113)){
var statearr_14142_14191 = state_14128__$1;
(statearr_14142_14191[(1)] = (23));

} else {
var statearr_14143_14192 = state_14128__$1;
(statearr_14143_14192[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14129 === (6))){
var inst_14107 = (state_14128[(7)]);
var inst_14059 = (state_14128[(8)]);
var inst_14109 = (state_14128[(11)]);
var inst_14107__$1 = topic_fn.call(null,inst_14059);
var inst_14108 = cljs.core.deref.call(null,mults);
var inst_14109__$1 = cljs.core.get.call(null,inst_14108,inst_14107__$1);
var state_14128__$1 = (function (){var statearr_14144 = state_14128;
(statearr_14144[(7)] = inst_14107__$1);

(statearr_14144[(11)] = inst_14109__$1);

return statearr_14144;
})();
if(cljs.core.truth_(inst_14109__$1)){
var statearr_14145_14193 = state_14128__$1;
(statearr_14145_14193[(1)] = (19));

} else {
var statearr_14146_14194 = state_14128__$1;
(statearr_14146_14194[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14129 === (25))){
var inst_14118 = (state_14128[(2)]);
var state_14128__$1 = state_14128;
var statearr_14147_14195 = state_14128__$1;
(statearr_14147_14195[(2)] = inst_14118);

(statearr_14147_14195[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14129 === (17))){
var inst_14083 = (state_14128[(10)]);
var inst_14092 = cljs.core.first.call(null,inst_14083);
var inst_14093 = cljs.core.async.muxch_STAR_.call(null,inst_14092);
var inst_14094 = cljs.core.async.close_BANG_.call(null,inst_14093);
var inst_14095 = cljs.core.next.call(null,inst_14083);
var inst_14069 = inst_14095;
var inst_14070 = null;
var inst_14071 = (0);
var inst_14072 = (0);
var state_14128__$1 = (function (){var statearr_14148 = state_14128;
(statearr_14148[(12)] = inst_14072);

(statearr_14148[(13)] = inst_14069);

(statearr_14148[(14)] = inst_14071);

(statearr_14148[(15)] = inst_14070);

(statearr_14148[(16)] = inst_14094);

return statearr_14148;
})();
var statearr_14149_14196 = state_14128__$1;
(statearr_14149_14196[(2)] = null);

(statearr_14149_14196[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14129 === (3))){
var inst_14126 = (state_14128[(2)]);
var state_14128__$1 = state_14128;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14128__$1,inst_14126);
} else {
if((state_val_14129 === (12))){
var inst_14103 = (state_14128[(2)]);
var state_14128__$1 = state_14128;
var statearr_14150_14197 = state_14128__$1;
(statearr_14150_14197[(2)] = inst_14103);

(statearr_14150_14197[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14129 === (2))){
var state_14128__$1 = state_14128;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14128__$1,(4),ch);
} else {
if((state_val_14129 === (23))){
var state_14128__$1 = state_14128;
var statearr_14151_14198 = state_14128__$1;
(statearr_14151_14198[(2)] = null);

(statearr_14151_14198[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14129 === (19))){
var inst_14059 = (state_14128[(8)]);
var inst_14109 = (state_14128[(11)]);
var inst_14111 = cljs.core.async.muxch_STAR_.call(null,inst_14109);
var state_14128__$1 = state_14128;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14128__$1,(22),inst_14111,inst_14059);
} else {
if((state_val_14129 === (11))){
var inst_14083 = (state_14128[(10)]);
var inst_14069 = (state_14128[(13)]);
var inst_14083__$1 = cljs.core.seq.call(null,inst_14069);
var state_14128__$1 = (function (){var statearr_14152 = state_14128;
(statearr_14152[(10)] = inst_14083__$1);

return statearr_14152;
})();
if(inst_14083__$1){
var statearr_14153_14199 = state_14128__$1;
(statearr_14153_14199[(1)] = (13));

} else {
var statearr_14154_14200 = state_14128__$1;
(statearr_14154_14200[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14129 === (9))){
var inst_14105 = (state_14128[(2)]);
var state_14128__$1 = state_14128;
var statearr_14155_14201 = state_14128__$1;
(statearr_14155_14201[(2)] = inst_14105);

(statearr_14155_14201[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14129 === (5))){
var inst_14066 = cljs.core.deref.call(null,mults);
var inst_14067 = cljs.core.vals.call(null,inst_14066);
var inst_14068 = cljs.core.seq.call(null,inst_14067);
var inst_14069 = inst_14068;
var inst_14070 = null;
var inst_14071 = (0);
var inst_14072 = (0);
var state_14128__$1 = (function (){var statearr_14156 = state_14128;
(statearr_14156[(12)] = inst_14072);

(statearr_14156[(13)] = inst_14069);

(statearr_14156[(14)] = inst_14071);

(statearr_14156[(15)] = inst_14070);

return statearr_14156;
})();
var statearr_14157_14202 = state_14128__$1;
(statearr_14157_14202[(2)] = null);

(statearr_14157_14202[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14129 === (14))){
var state_14128__$1 = state_14128;
var statearr_14161_14203 = state_14128__$1;
(statearr_14161_14203[(2)] = null);

(statearr_14161_14203[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14129 === (16))){
var inst_14083 = (state_14128[(10)]);
var inst_14087 = cljs.core.chunk_first.call(null,inst_14083);
var inst_14088 = cljs.core.chunk_rest.call(null,inst_14083);
var inst_14089 = cljs.core.count.call(null,inst_14087);
var inst_14069 = inst_14088;
var inst_14070 = inst_14087;
var inst_14071 = inst_14089;
var inst_14072 = (0);
var state_14128__$1 = (function (){var statearr_14162 = state_14128;
(statearr_14162[(12)] = inst_14072);

(statearr_14162[(13)] = inst_14069);

(statearr_14162[(14)] = inst_14071);

(statearr_14162[(15)] = inst_14070);

return statearr_14162;
})();
var statearr_14163_14204 = state_14128__$1;
(statearr_14163_14204[(2)] = null);

(statearr_14163_14204[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14129 === (10))){
var inst_14072 = (state_14128[(12)]);
var inst_14069 = (state_14128[(13)]);
var inst_14071 = (state_14128[(14)]);
var inst_14070 = (state_14128[(15)]);
var inst_14077 = cljs.core._nth.call(null,inst_14070,inst_14072);
var inst_14078 = cljs.core.async.muxch_STAR_.call(null,inst_14077);
var inst_14079 = cljs.core.async.close_BANG_.call(null,inst_14078);
var inst_14080 = (inst_14072 + (1));
var tmp14158 = inst_14069;
var tmp14159 = inst_14071;
var tmp14160 = inst_14070;
var inst_14069__$1 = tmp14158;
var inst_14070__$1 = tmp14160;
var inst_14071__$1 = tmp14159;
var inst_14072__$1 = inst_14080;
var state_14128__$1 = (function (){var statearr_14164 = state_14128;
(statearr_14164[(12)] = inst_14072__$1);

(statearr_14164[(13)] = inst_14069__$1);

(statearr_14164[(17)] = inst_14079);

(statearr_14164[(14)] = inst_14071__$1);

(statearr_14164[(15)] = inst_14070__$1);

return statearr_14164;
})();
var statearr_14165_14205 = state_14128__$1;
(statearr_14165_14205[(2)] = null);

(statearr_14165_14205[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14129 === (18))){
var inst_14098 = (state_14128[(2)]);
var state_14128__$1 = state_14128;
var statearr_14166_14206 = state_14128__$1;
(statearr_14166_14206[(2)] = inst_14098);

(statearr_14166_14206[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14129 === (8))){
var inst_14072 = (state_14128[(12)]);
var inst_14071 = (state_14128[(14)]);
var inst_14074 = (inst_14072 < inst_14071);
var inst_14075 = inst_14074;
var state_14128__$1 = state_14128;
if(cljs.core.truth_(inst_14075)){
var statearr_14167_14207 = state_14128__$1;
(statearr_14167_14207[(1)] = (10));

} else {
var statearr_14168_14208 = state_14128__$1;
(statearr_14168_14208[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12231__auto___14180,mults,ensure_mult,p))
;
return ((function (switch__12119__auto__,c__12231__auto___14180,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__12120__auto__ = null;
var cljs$core$async$state_machine__12120__auto____0 = (function (){
var statearr_14172 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14172[(0)] = cljs$core$async$state_machine__12120__auto__);

(statearr_14172[(1)] = (1));

return statearr_14172;
});
var cljs$core$async$state_machine__12120__auto____1 = (function (state_14128){
while(true){
var ret_value__12121__auto__ = (function (){try{while(true){
var result__12122__auto__ = switch__12119__auto__.call(null,state_14128);
if(cljs.core.keyword_identical_QMARK_.call(null,result__12122__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12122__auto__;
}
break;
}
}catch (e14173){if((e14173 instanceof Object)){
var ex__12123__auto__ = e14173;
var statearr_14174_14209 = state_14128;
(statearr_14174_14209[(5)] = ex__12123__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14128);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14173;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__12121__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14210 = state_14128;
state_14128 = G__14210;
continue;
} else {
return ret_value__12121__auto__;
}
break;
}
});
cljs$core$async$state_machine__12120__auto__ = function(state_14128){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12120__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12120__auto____1.call(this,state_14128);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12120__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12120__auto____0;
cljs$core$async$state_machine__12120__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12120__auto____1;
return cljs$core$async$state_machine__12120__auto__;
})()
;})(switch__12119__auto__,c__12231__auto___14180,mults,ensure_mult,p))
})();
var state__12233__auto__ = (function (){var statearr_14175 = f__12232__auto__.call(null);
(statearr_14175[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12231__auto___14180);

return statearr_14175;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__12233__auto__);
});})(c__12231__auto___14180,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args14211 = [];
var len__7484__auto___14214 = arguments.length;
var i__7485__auto___14215 = (0);
while(true){
if((i__7485__auto___14215 < len__7484__auto___14214)){
args14211.push((arguments[i__7485__auto___14215]));

var G__14216 = (i__7485__auto___14215 + (1));
i__7485__auto___14215 = G__14216;
continue;
} else {
}
break;
}

var G__14213 = args14211.length;
switch (G__14213) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14211.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args14218 = [];
var len__7484__auto___14221 = arguments.length;
var i__7485__auto___14222 = (0);
while(true){
if((i__7485__auto___14222 < len__7484__auto___14221)){
args14218.push((arguments[i__7485__auto___14222]));

var G__14223 = (i__7485__auto___14222 + (1));
i__7485__auto___14222 = G__14223;
continue;
} else {
}
break;
}

var G__14220 = args14218.length;
switch (G__14220) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14218.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args14225 = [];
var len__7484__auto___14296 = arguments.length;
var i__7485__auto___14297 = (0);
while(true){
if((i__7485__auto___14297 < len__7484__auto___14296)){
args14225.push((arguments[i__7485__auto___14297]));

var G__14298 = (i__7485__auto___14297 + (1));
i__7485__auto___14297 = G__14298;
continue;
} else {
}
break;
}

var G__14227 = args14225.length;
switch (G__14227) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14225.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__12231__auto___14300 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__12231__auto___14300,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__12232__auto__ = (function (){var switch__12119__auto__ = ((function (c__12231__auto___14300,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_14266){
var state_val_14267 = (state_14266[(1)]);
if((state_val_14267 === (7))){
var state_14266__$1 = state_14266;
var statearr_14268_14301 = state_14266__$1;
(statearr_14268_14301[(2)] = null);

(statearr_14268_14301[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14267 === (1))){
var state_14266__$1 = state_14266;
var statearr_14269_14302 = state_14266__$1;
(statearr_14269_14302[(2)] = null);

(statearr_14269_14302[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14267 === (4))){
var inst_14230 = (state_14266[(7)]);
var inst_14232 = (inst_14230 < cnt);
var state_14266__$1 = state_14266;
if(cljs.core.truth_(inst_14232)){
var statearr_14270_14303 = state_14266__$1;
(statearr_14270_14303[(1)] = (6));

} else {
var statearr_14271_14304 = state_14266__$1;
(statearr_14271_14304[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14267 === (15))){
var inst_14262 = (state_14266[(2)]);
var state_14266__$1 = state_14266;
var statearr_14272_14305 = state_14266__$1;
(statearr_14272_14305[(2)] = inst_14262);

(statearr_14272_14305[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14267 === (13))){
var inst_14255 = cljs.core.async.close_BANG_.call(null,out);
var state_14266__$1 = state_14266;
var statearr_14273_14306 = state_14266__$1;
(statearr_14273_14306[(2)] = inst_14255);

(statearr_14273_14306[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14267 === (6))){
var state_14266__$1 = state_14266;
var statearr_14274_14307 = state_14266__$1;
(statearr_14274_14307[(2)] = null);

(statearr_14274_14307[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14267 === (3))){
var inst_14264 = (state_14266[(2)]);
var state_14266__$1 = state_14266;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14266__$1,inst_14264);
} else {
if((state_val_14267 === (12))){
var inst_14252 = (state_14266[(8)]);
var inst_14252__$1 = (state_14266[(2)]);
var inst_14253 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_14252__$1);
var state_14266__$1 = (function (){var statearr_14275 = state_14266;
(statearr_14275[(8)] = inst_14252__$1);

return statearr_14275;
})();
if(cljs.core.truth_(inst_14253)){
var statearr_14276_14308 = state_14266__$1;
(statearr_14276_14308[(1)] = (13));

} else {
var statearr_14277_14309 = state_14266__$1;
(statearr_14277_14309[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14267 === (2))){
var inst_14229 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_14230 = (0);
var state_14266__$1 = (function (){var statearr_14278 = state_14266;
(statearr_14278[(9)] = inst_14229);

(statearr_14278[(7)] = inst_14230);

return statearr_14278;
})();
var statearr_14279_14310 = state_14266__$1;
(statearr_14279_14310[(2)] = null);

(statearr_14279_14310[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14267 === (11))){
var inst_14230 = (state_14266[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_14266,(10),Object,null,(9));
var inst_14239 = chs__$1.call(null,inst_14230);
var inst_14240 = done.call(null,inst_14230);
var inst_14241 = cljs.core.async.take_BANG_.call(null,inst_14239,inst_14240);
var state_14266__$1 = state_14266;
var statearr_14280_14311 = state_14266__$1;
(statearr_14280_14311[(2)] = inst_14241);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14266__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14267 === (9))){
var inst_14230 = (state_14266[(7)]);
var inst_14243 = (state_14266[(2)]);
var inst_14244 = (inst_14230 + (1));
var inst_14230__$1 = inst_14244;
var state_14266__$1 = (function (){var statearr_14281 = state_14266;
(statearr_14281[(7)] = inst_14230__$1);

(statearr_14281[(10)] = inst_14243);

return statearr_14281;
})();
var statearr_14282_14312 = state_14266__$1;
(statearr_14282_14312[(2)] = null);

(statearr_14282_14312[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14267 === (5))){
var inst_14250 = (state_14266[(2)]);
var state_14266__$1 = (function (){var statearr_14283 = state_14266;
(statearr_14283[(11)] = inst_14250);

return statearr_14283;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14266__$1,(12),dchan);
} else {
if((state_val_14267 === (14))){
var inst_14252 = (state_14266[(8)]);
var inst_14257 = cljs.core.apply.call(null,f,inst_14252);
var state_14266__$1 = state_14266;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14266__$1,(16),out,inst_14257);
} else {
if((state_val_14267 === (16))){
var inst_14259 = (state_14266[(2)]);
var state_14266__$1 = (function (){var statearr_14284 = state_14266;
(statearr_14284[(12)] = inst_14259);

return statearr_14284;
})();
var statearr_14285_14313 = state_14266__$1;
(statearr_14285_14313[(2)] = null);

(statearr_14285_14313[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14267 === (10))){
var inst_14234 = (state_14266[(2)]);
var inst_14235 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_14266__$1 = (function (){var statearr_14286 = state_14266;
(statearr_14286[(13)] = inst_14234);

return statearr_14286;
})();
var statearr_14287_14314 = state_14266__$1;
(statearr_14287_14314[(2)] = inst_14235);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14266__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14267 === (8))){
var inst_14248 = (state_14266[(2)]);
var state_14266__$1 = state_14266;
var statearr_14288_14315 = state_14266__$1;
(statearr_14288_14315[(2)] = inst_14248);

(statearr_14288_14315[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12231__auto___14300,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__12119__auto__,c__12231__auto___14300,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__12120__auto__ = null;
var cljs$core$async$state_machine__12120__auto____0 = (function (){
var statearr_14292 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14292[(0)] = cljs$core$async$state_machine__12120__auto__);

(statearr_14292[(1)] = (1));

return statearr_14292;
});
var cljs$core$async$state_machine__12120__auto____1 = (function (state_14266){
while(true){
var ret_value__12121__auto__ = (function (){try{while(true){
var result__12122__auto__ = switch__12119__auto__.call(null,state_14266);
if(cljs.core.keyword_identical_QMARK_.call(null,result__12122__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12122__auto__;
}
break;
}
}catch (e14293){if((e14293 instanceof Object)){
var ex__12123__auto__ = e14293;
var statearr_14294_14316 = state_14266;
(statearr_14294_14316[(5)] = ex__12123__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14266);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14293;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__12121__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14317 = state_14266;
state_14266 = G__14317;
continue;
} else {
return ret_value__12121__auto__;
}
break;
}
});
cljs$core$async$state_machine__12120__auto__ = function(state_14266){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12120__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12120__auto____1.call(this,state_14266);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12120__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12120__auto____0;
cljs$core$async$state_machine__12120__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12120__auto____1;
return cljs$core$async$state_machine__12120__auto__;
})()
;})(switch__12119__auto__,c__12231__auto___14300,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__12233__auto__ = (function (){var statearr_14295 = f__12232__auto__.call(null);
(statearr_14295[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12231__auto___14300);

return statearr_14295;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__12233__auto__);
});})(c__12231__auto___14300,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args14319 = [];
var len__7484__auto___14377 = arguments.length;
var i__7485__auto___14378 = (0);
while(true){
if((i__7485__auto___14378 < len__7484__auto___14377)){
args14319.push((arguments[i__7485__auto___14378]));

var G__14379 = (i__7485__auto___14378 + (1));
i__7485__auto___14378 = G__14379;
continue;
} else {
}
break;
}

var G__14321 = args14319.length;
switch (G__14321) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14319.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__12231__auto___14381 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__12231__auto___14381,out){
return (function (){
var f__12232__auto__ = (function (){var switch__12119__auto__ = ((function (c__12231__auto___14381,out){
return (function (state_14353){
var state_val_14354 = (state_14353[(1)]);
if((state_val_14354 === (7))){
var inst_14333 = (state_14353[(7)]);
var inst_14332 = (state_14353[(8)]);
var inst_14332__$1 = (state_14353[(2)]);
var inst_14333__$1 = cljs.core.nth.call(null,inst_14332__$1,(0),null);
var inst_14334 = cljs.core.nth.call(null,inst_14332__$1,(1),null);
var inst_14335 = (inst_14333__$1 == null);
var state_14353__$1 = (function (){var statearr_14355 = state_14353;
(statearr_14355[(7)] = inst_14333__$1);

(statearr_14355[(8)] = inst_14332__$1);

(statearr_14355[(9)] = inst_14334);

return statearr_14355;
})();
if(cljs.core.truth_(inst_14335)){
var statearr_14356_14382 = state_14353__$1;
(statearr_14356_14382[(1)] = (8));

} else {
var statearr_14357_14383 = state_14353__$1;
(statearr_14357_14383[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14354 === (1))){
var inst_14322 = cljs.core.vec.call(null,chs);
var inst_14323 = inst_14322;
var state_14353__$1 = (function (){var statearr_14358 = state_14353;
(statearr_14358[(10)] = inst_14323);

return statearr_14358;
})();
var statearr_14359_14384 = state_14353__$1;
(statearr_14359_14384[(2)] = null);

(statearr_14359_14384[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14354 === (4))){
var inst_14323 = (state_14353[(10)]);
var state_14353__$1 = state_14353;
return cljs.core.async.ioc_alts_BANG_.call(null,state_14353__$1,(7),inst_14323);
} else {
if((state_val_14354 === (6))){
var inst_14349 = (state_14353[(2)]);
var state_14353__$1 = state_14353;
var statearr_14360_14385 = state_14353__$1;
(statearr_14360_14385[(2)] = inst_14349);

(statearr_14360_14385[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14354 === (3))){
var inst_14351 = (state_14353[(2)]);
var state_14353__$1 = state_14353;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14353__$1,inst_14351);
} else {
if((state_val_14354 === (2))){
var inst_14323 = (state_14353[(10)]);
var inst_14325 = cljs.core.count.call(null,inst_14323);
var inst_14326 = (inst_14325 > (0));
var state_14353__$1 = state_14353;
if(cljs.core.truth_(inst_14326)){
var statearr_14362_14386 = state_14353__$1;
(statearr_14362_14386[(1)] = (4));

} else {
var statearr_14363_14387 = state_14353__$1;
(statearr_14363_14387[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14354 === (11))){
var inst_14323 = (state_14353[(10)]);
var inst_14342 = (state_14353[(2)]);
var tmp14361 = inst_14323;
var inst_14323__$1 = tmp14361;
var state_14353__$1 = (function (){var statearr_14364 = state_14353;
(statearr_14364[(10)] = inst_14323__$1);

(statearr_14364[(11)] = inst_14342);

return statearr_14364;
})();
var statearr_14365_14388 = state_14353__$1;
(statearr_14365_14388[(2)] = null);

(statearr_14365_14388[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14354 === (9))){
var inst_14333 = (state_14353[(7)]);
var state_14353__$1 = state_14353;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14353__$1,(11),out,inst_14333);
} else {
if((state_val_14354 === (5))){
var inst_14347 = cljs.core.async.close_BANG_.call(null,out);
var state_14353__$1 = state_14353;
var statearr_14366_14389 = state_14353__$1;
(statearr_14366_14389[(2)] = inst_14347);

(statearr_14366_14389[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14354 === (10))){
var inst_14345 = (state_14353[(2)]);
var state_14353__$1 = state_14353;
var statearr_14367_14390 = state_14353__$1;
(statearr_14367_14390[(2)] = inst_14345);

(statearr_14367_14390[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14354 === (8))){
var inst_14333 = (state_14353[(7)]);
var inst_14332 = (state_14353[(8)]);
var inst_14323 = (state_14353[(10)]);
var inst_14334 = (state_14353[(9)]);
var inst_14337 = (function (){var cs = inst_14323;
var vec__14328 = inst_14332;
var v = inst_14333;
var c = inst_14334;
return ((function (cs,vec__14328,v,c,inst_14333,inst_14332,inst_14323,inst_14334,state_val_14354,c__12231__auto___14381,out){
return (function (p1__14318_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__14318_SHARP_);
});
;})(cs,vec__14328,v,c,inst_14333,inst_14332,inst_14323,inst_14334,state_val_14354,c__12231__auto___14381,out))
})();
var inst_14338 = cljs.core.filterv.call(null,inst_14337,inst_14323);
var inst_14323__$1 = inst_14338;
var state_14353__$1 = (function (){var statearr_14368 = state_14353;
(statearr_14368[(10)] = inst_14323__$1);

return statearr_14368;
})();
var statearr_14369_14391 = state_14353__$1;
(statearr_14369_14391[(2)] = null);

(statearr_14369_14391[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__12231__auto___14381,out))
;
return ((function (switch__12119__auto__,c__12231__auto___14381,out){
return (function() {
var cljs$core$async$state_machine__12120__auto__ = null;
var cljs$core$async$state_machine__12120__auto____0 = (function (){
var statearr_14373 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14373[(0)] = cljs$core$async$state_machine__12120__auto__);

(statearr_14373[(1)] = (1));

return statearr_14373;
});
var cljs$core$async$state_machine__12120__auto____1 = (function (state_14353){
while(true){
var ret_value__12121__auto__ = (function (){try{while(true){
var result__12122__auto__ = switch__12119__auto__.call(null,state_14353);
if(cljs.core.keyword_identical_QMARK_.call(null,result__12122__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12122__auto__;
}
break;
}
}catch (e14374){if((e14374 instanceof Object)){
var ex__12123__auto__ = e14374;
var statearr_14375_14392 = state_14353;
(statearr_14375_14392[(5)] = ex__12123__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14353);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14374;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__12121__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14393 = state_14353;
state_14353 = G__14393;
continue;
} else {
return ret_value__12121__auto__;
}
break;
}
});
cljs$core$async$state_machine__12120__auto__ = function(state_14353){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12120__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12120__auto____1.call(this,state_14353);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12120__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12120__auto____0;
cljs$core$async$state_machine__12120__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12120__auto____1;
return cljs$core$async$state_machine__12120__auto__;
})()
;})(switch__12119__auto__,c__12231__auto___14381,out))
})();
var state__12233__auto__ = (function (){var statearr_14376 = f__12232__auto__.call(null);
(statearr_14376[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12231__auto___14381);

return statearr_14376;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__12233__auto__);
});})(c__12231__auto___14381,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args14394 = [];
var len__7484__auto___14443 = arguments.length;
var i__7485__auto___14444 = (0);
while(true){
if((i__7485__auto___14444 < len__7484__auto___14443)){
args14394.push((arguments[i__7485__auto___14444]));

var G__14445 = (i__7485__auto___14444 + (1));
i__7485__auto___14444 = G__14445;
continue;
} else {
}
break;
}

var G__14396 = args14394.length;
switch (G__14396) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14394.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__12231__auto___14447 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__12231__auto___14447,out){
return (function (){
var f__12232__auto__ = (function (){var switch__12119__auto__ = ((function (c__12231__auto___14447,out){
return (function (state_14420){
var state_val_14421 = (state_14420[(1)]);
if((state_val_14421 === (7))){
var inst_14402 = (state_14420[(7)]);
var inst_14402__$1 = (state_14420[(2)]);
var inst_14403 = (inst_14402__$1 == null);
var inst_14404 = cljs.core.not.call(null,inst_14403);
var state_14420__$1 = (function (){var statearr_14422 = state_14420;
(statearr_14422[(7)] = inst_14402__$1);

return statearr_14422;
})();
if(inst_14404){
var statearr_14423_14448 = state_14420__$1;
(statearr_14423_14448[(1)] = (8));

} else {
var statearr_14424_14449 = state_14420__$1;
(statearr_14424_14449[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14421 === (1))){
var inst_14397 = (0);
var state_14420__$1 = (function (){var statearr_14425 = state_14420;
(statearr_14425[(8)] = inst_14397);

return statearr_14425;
})();
var statearr_14426_14450 = state_14420__$1;
(statearr_14426_14450[(2)] = null);

(statearr_14426_14450[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14421 === (4))){
var state_14420__$1 = state_14420;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14420__$1,(7),ch);
} else {
if((state_val_14421 === (6))){
var inst_14415 = (state_14420[(2)]);
var state_14420__$1 = state_14420;
var statearr_14427_14451 = state_14420__$1;
(statearr_14427_14451[(2)] = inst_14415);

(statearr_14427_14451[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14421 === (3))){
var inst_14417 = (state_14420[(2)]);
var inst_14418 = cljs.core.async.close_BANG_.call(null,out);
var state_14420__$1 = (function (){var statearr_14428 = state_14420;
(statearr_14428[(9)] = inst_14417);

return statearr_14428;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14420__$1,inst_14418);
} else {
if((state_val_14421 === (2))){
var inst_14397 = (state_14420[(8)]);
var inst_14399 = (inst_14397 < n);
var state_14420__$1 = state_14420;
if(cljs.core.truth_(inst_14399)){
var statearr_14429_14452 = state_14420__$1;
(statearr_14429_14452[(1)] = (4));

} else {
var statearr_14430_14453 = state_14420__$1;
(statearr_14430_14453[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14421 === (11))){
var inst_14397 = (state_14420[(8)]);
var inst_14407 = (state_14420[(2)]);
var inst_14408 = (inst_14397 + (1));
var inst_14397__$1 = inst_14408;
var state_14420__$1 = (function (){var statearr_14431 = state_14420;
(statearr_14431[(8)] = inst_14397__$1);

(statearr_14431[(10)] = inst_14407);

return statearr_14431;
})();
var statearr_14432_14454 = state_14420__$1;
(statearr_14432_14454[(2)] = null);

(statearr_14432_14454[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14421 === (9))){
var state_14420__$1 = state_14420;
var statearr_14433_14455 = state_14420__$1;
(statearr_14433_14455[(2)] = null);

(statearr_14433_14455[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14421 === (5))){
var state_14420__$1 = state_14420;
var statearr_14434_14456 = state_14420__$1;
(statearr_14434_14456[(2)] = null);

(statearr_14434_14456[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14421 === (10))){
var inst_14412 = (state_14420[(2)]);
var state_14420__$1 = state_14420;
var statearr_14435_14457 = state_14420__$1;
(statearr_14435_14457[(2)] = inst_14412);

(statearr_14435_14457[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14421 === (8))){
var inst_14402 = (state_14420[(7)]);
var state_14420__$1 = state_14420;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14420__$1,(11),out,inst_14402);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__12231__auto___14447,out))
;
return ((function (switch__12119__auto__,c__12231__auto___14447,out){
return (function() {
var cljs$core$async$state_machine__12120__auto__ = null;
var cljs$core$async$state_machine__12120__auto____0 = (function (){
var statearr_14439 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_14439[(0)] = cljs$core$async$state_machine__12120__auto__);

(statearr_14439[(1)] = (1));

return statearr_14439;
});
var cljs$core$async$state_machine__12120__auto____1 = (function (state_14420){
while(true){
var ret_value__12121__auto__ = (function (){try{while(true){
var result__12122__auto__ = switch__12119__auto__.call(null,state_14420);
if(cljs.core.keyword_identical_QMARK_.call(null,result__12122__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12122__auto__;
}
break;
}
}catch (e14440){if((e14440 instanceof Object)){
var ex__12123__auto__ = e14440;
var statearr_14441_14458 = state_14420;
(statearr_14441_14458[(5)] = ex__12123__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14420);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14440;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__12121__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14459 = state_14420;
state_14420 = G__14459;
continue;
} else {
return ret_value__12121__auto__;
}
break;
}
});
cljs$core$async$state_machine__12120__auto__ = function(state_14420){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12120__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12120__auto____1.call(this,state_14420);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12120__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12120__auto____0;
cljs$core$async$state_machine__12120__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12120__auto____1;
return cljs$core$async$state_machine__12120__auto__;
})()
;})(switch__12119__auto__,c__12231__auto___14447,out))
})();
var state__12233__auto__ = (function (){var statearr_14442 = f__12232__auto__.call(null);
(statearr_14442[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12231__auto___14447);

return statearr_14442;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__12233__auto__);
});})(c__12231__auto___14447,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async14467 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async14467 = (function (map_LT_,f,ch,meta14468){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta14468 = meta14468;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async14467.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_14469,meta14468__$1){
var self__ = this;
var _14469__$1 = this;
return (new cljs.core.async.t_cljs$core$async14467(self__.map_LT_,self__.f,self__.ch,meta14468__$1));
});

cljs.core.async.t_cljs$core$async14467.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_14469){
var self__ = this;
var _14469__$1 = this;
return self__.meta14468;
});

cljs.core.async.t_cljs$core$async14467.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async14467.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async14467.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async14467.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async14467.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async14470 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async14470 = (function (map_LT_,f,ch,meta14468,_,fn1,meta14471){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta14468 = meta14468;
this._ = _;
this.fn1 = fn1;
this.meta14471 = meta14471;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async14470.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_14472,meta14471__$1){
var self__ = this;
var _14472__$1 = this;
return (new cljs.core.async.t_cljs$core$async14470(self__.map_LT_,self__.f,self__.ch,self__.meta14468,self__._,self__.fn1,meta14471__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async14470.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_14472){
var self__ = this;
var _14472__$1 = this;
return self__.meta14471;
});})(___$1))
;

cljs.core.async.t_cljs$core$async14470.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async14470.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async14470.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async14470.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__14460_SHARP_){
return f1.call(null,(((p1__14460_SHARP_ == null))?null:self__.f.call(null,p1__14460_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async14470.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta14468","meta14468",-801628180,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async14467","cljs.core.async/t_cljs$core$async14467",1843537080,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta14471","meta14471",-1649413984,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async14470.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async14470.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async14470";

cljs.core.async.t_cljs$core$async14470.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"cljs.core.async/t_cljs$core$async14470");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async14470 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async14470(map_LT___$1,f__$1,ch__$1,meta14468__$1,___$2,fn1__$1,meta14471){
return (new cljs.core.async.t_cljs$core$async14470(map_LT___$1,f__$1,ch__$1,meta14468__$1,___$2,fn1__$1,meta14471));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async14470(self__.map_LT_,self__.f,self__.ch,self__.meta14468,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__6397__auto__ = ret;
if(cljs.core.truth_(and__6397__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__6397__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async14467.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async14467.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async14467.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta14468","meta14468",-801628180,null)], null);
});

cljs.core.async.t_cljs$core$async14467.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async14467.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async14467";

cljs.core.async.t_cljs$core$async14467.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"cljs.core.async/t_cljs$core$async14467");
});

cljs.core.async.__GT_t_cljs$core$async14467 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async14467(map_LT___$1,f__$1,ch__$1,meta14468){
return (new cljs.core.async.t_cljs$core$async14467(map_LT___$1,f__$1,ch__$1,meta14468));
});

}

return (new cljs.core.async.t_cljs$core$async14467(cljs$core$async$map_LT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async14476 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async14476 = (function (map_GT_,f,ch,meta14477){
this.map_GT_ = map_GT_;
this.f = f;
this.ch = ch;
this.meta14477 = meta14477;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async14476.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_14478,meta14477__$1){
var self__ = this;
var _14478__$1 = this;
return (new cljs.core.async.t_cljs$core$async14476(self__.map_GT_,self__.f,self__.ch,meta14477__$1));
});

cljs.core.async.t_cljs$core$async14476.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_14478){
var self__ = this;
var _14478__$1 = this;
return self__.meta14477;
});

cljs.core.async.t_cljs$core$async14476.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async14476.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async14476.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async14476.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async14476.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async14476.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async14476.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map>","map>",1676369295,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta14477","meta14477",-991228450,null)], null);
});

cljs.core.async.t_cljs$core$async14476.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async14476.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async14476";

cljs.core.async.t_cljs$core$async14476.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"cljs.core.async/t_cljs$core$async14476");
});

cljs.core.async.__GT_t_cljs$core$async14476 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async14476(map_GT___$1,f__$1,ch__$1,meta14477){
return (new cljs.core.async.t_cljs$core$async14476(map_GT___$1,f__$1,ch__$1,meta14477));
});

}

return (new cljs.core.async.t_cljs$core$async14476(cljs$core$async$map_GT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async14482 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async14482 = (function (filter_GT_,p,ch,meta14483){
this.filter_GT_ = filter_GT_;
this.p = p;
this.ch = ch;
this.meta14483 = meta14483;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async14482.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_14484,meta14483__$1){
var self__ = this;
var _14484__$1 = this;
return (new cljs.core.async.t_cljs$core$async14482(self__.filter_GT_,self__.p,self__.ch,meta14483__$1));
});

cljs.core.async.t_cljs$core$async14482.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_14484){
var self__ = this;
var _14484__$1 = this;
return self__.meta14483;
});

cljs.core.async.t_cljs$core$async14482.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async14482.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async14482.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async14482.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async14482.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async14482.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async14482.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async14482.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"filter>","filter>",-37644455,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta14483","meta14483",-8428960,null)], null);
});

cljs.core.async.t_cljs$core$async14482.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async14482.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async14482";

cljs.core.async.t_cljs$core$async14482.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"cljs.core.async/t_cljs$core$async14482");
});

cljs.core.async.__GT_t_cljs$core$async14482 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async14482(filter_GT___$1,p__$1,ch__$1,meta14483){
return (new cljs.core.async.t_cljs$core$async14482(filter_GT___$1,p__$1,ch__$1,meta14483));
});

}

return (new cljs.core.async.t_cljs$core$async14482(cljs$core$async$filter_GT_,p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args14485 = [];
var len__7484__auto___14529 = arguments.length;
var i__7485__auto___14530 = (0);
while(true){
if((i__7485__auto___14530 < len__7484__auto___14529)){
args14485.push((arguments[i__7485__auto___14530]));

var G__14531 = (i__7485__auto___14530 + (1));
i__7485__auto___14530 = G__14531;
continue;
} else {
}
break;
}

var G__14487 = args14485.length;
switch (G__14487) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14485.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__12231__auto___14533 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__12231__auto___14533,out){
return (function (){
var f__12232__auto__ = (function (){var switch__12119__auto__ = ((function (c__12231__auto___14533,out){
return (function (state_14508){
var state_val_14509 = (state_14508[(1)]);
if((state_val_14509 === (7))){
var inst_14504 = (state_14508[(2)]);
var state_14508__$1 = state_14508;
var statearr_14510_14534 = state_14508__$1;
(statearr_14510_14534[(2)] = inst_14504);

(statearr_14510_14534[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14509 === (1))){
var state_14508__$1 = state_14508;
var statearr_14511_14535 = state_14508__$1;
(statearr_14511_14535[(2)] = null);

(statearr_14511_14535[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14509 === (4))){
var inst_14490 = (state_14508[(7)]);
var inst_14490__$1 = (state_14508[(2)]);
var inst_14491 = (inst_14490__$1 == null);
var state_14508__$1 = (function (){var statearr_14512 = state_14508;
(statearr_14512[(7)] = inst_14490__$1);

return statearr_14512;
})();
if(cljs.core.truth_(inst_14491)){
var statearr_14513_14536 = state_14508__$1;
(statearr_14513_14536[(1)] = (5));

} else {
var statearr_14514_14537 = state_14508__$1;
(statearr_14514_14537[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14509 === (6))){
var inst_14490 = (state_14508[(7)]);
var inst_14495 = p.call(null,inst_14490);
var state_14508__$1 = state_14508;
if(cljs.core.truth_(inst_14495)){
var statearr_14515_14538 = state_14508__$1;
(statearr_14515_14538[(1)] = (8));

} else {
var statearr_14516_14539 = state_14508__$1;
(statearr_14516_14539[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14509 === (3))){
var inst_14506 = (state_14508[(2)]);
var state_14508__$1 = state_14508;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14508__$1,inst_14506);
} else {
if((state_val_14509 === (2))){
var state_14508__$1 = state_14508;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14508__$1,(4),ch);
} else {
if((state_val_14509 === (11))){
var inst_14498 = (state_14508[(2)]);
var state_14508__$1 = state_14508;
var statearr_14517_14540 = state_14508__$1;
(statearr_14517_14540[(2)] = inst_14498);

(statearr_14517_14540[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14509 === (9))){
var state_14508__$1 = state_14508;
var statearr_14518_14541 = state_14508__$1;
(statearr_14518_14541[(2)] = null);

(statearr_14518_14541[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14509 === (5))){
var inst_14493 = cljs.core.async.close_BANG_.call(null,out);
var state_14508__$1 = state_14508;
var statearr_14519_14542 = state_14508__$1;
(statearr_14519_14542[(2)] = inst_14493);

(statearr_14519_14542[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14509 === (10))){
var inst_14501 = (state_14508[(2)]);
var state_14508__$1 = (function (){var statearr_14520 = state_14508;
(statearr_14520[(8)] = inst_14501);

return statearr_14520;
})();
var statearr_14521_14543 = state_14508__$1;
(statearr_14521_14543[(2)] = null);

(statearr_14521_14543[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14509 === (8))){
var inst_14490 = (state_14508[(7)]);
var state_14508__$1 = state_14508;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14508__$1,(11),out,inst_14490);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__12231__auto___14533,out))
;
return ((function (switch__12119__auto__,c__12231__auto___14533,out){
return (function() {
var cljs$core$async$state_machine__12120__auto__ = null;
var cljs$core$async$state_machine__12120__auto____0 = (function (){
var statearr_14525 = [null,null,null,null,null,null,null,null,null];
(statearr_14525[(0)] = cljs$core$async$state_machine__12120__auto__);

(statearr_14525[(1)] = (1));

return statearr_14525;
});
var cljs$core$async$state_machine__12120__auto____1 = (function (state_14508){
while(true){
var ret_value__12121__auto__ = (function (){try{while(true){
var result__12122__auto__ = switch__12119__auto__.call(null,state_14508);
if(cljs.core.keyword_identical_QMARK_.call(null,result__12122__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12122__auto__;
}
break;
}
}catch (e14526){if((e14526 instanceof Object)){
var ex__12123__auto__ = e14526;
var statearr_14527_14544 = state_14508;
(statearr_14527_14544[(5)] = ex__12123__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14508);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14526;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__12121__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14545 = state_14508;
state_14508 = G__14545;
continue;
} else {
return ret_value__12121__auto__;
}
break;
}
});
cljs$core$async$state_machine__12120__auto__ = function(state_14508){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12120__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12120__auto____1.call(this,state_14508);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12120__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12120__auto____0;
cljs$core$async$state_machine__12120__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12120__auto____1;
return cljs$core$async$state_machine__12120__auto__;
})()
;})(switch__12119__auto__,c__12231__auto___14533,out))
})();
var state__12233__auto__ = (function (){var statearr_14528 = f__12232__auto__.call(null);
(statearr_14528[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12231__auto___14533);

return statearr_14528;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__12233__auto__);
});})(c__12231__auto___14533,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args14546 = [];
var len__7484__auto___14549 = arguments.length;
var i__7485__auto___14550 = (0);
while(true){
if((i__7485__auto___14550 < len__7484__auto___14549)){
args14546.push((arguments[i__7485__auto___14550]));

var G__14551 = (i__7485__auto___14550 + (1));
i__7485__auto___14550 = G__14551;
continue;
} else {
}
break;
}

var G__14548 = args14546.length;
switch (G__14548) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14546.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__12231__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__12231__auto__){
return (function (){
var f__12232__auto__ = (function (){var switch__12119__auto__ = ((function (c__12231__auto__){
return (function (state_14718){
var state_val_14719 = (state_14718[(1)]);
if((state_val_14719 === (7))){
var inst_14714 = (state_14718[(2)]);
var state_14718__$1 = state_14718;
var statearr_14720_14761 = state_14718__$1;
(statearr_14720_14761[(2)] = inst_14714);

(statearr_14720_14761[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14719 === (20))){
var inst_14684 = (state_14718[(7)]);
var inst_14695 = (state_14718[(2)]);
var inst_14696 = cljs.core.next.call(null,inst_14684);
var inst_14670 = inst_14696;
var inst_14671 = null;
var inst_14672 = (0);
var inst_14673 = (0);
var state_14718__$1 = (function (){var statearr_14721 = state_14718;
(statearr_14721[(8)] = inst_14695);

(statearr_14721[(9)] = inst_14670);

(statearr_14721[(10)] = inst_14672);

(statearr_14721[(11)] = inst_14673);

(statearr_14721[(12)] = inst_14671);

return statearr_14721;
})();
var statearr_14722_14762 = state_14718__$1;
(statearr_14722_14762[(2)] = null);

(statearr_14722_14762[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14719 === (1))){
var state_14718__$1 = state_14718;
var statearr_14723_14763 = state_14718__$1;
(statearr_14723_14763[(2)] = null);

(statearr_14723_14763[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14719 === (4))){
var inst_14659 = (state_14718[(13)]);
var inst_14659__$1 = (state_14718[(2)]);
var inst_14660 = (inst_14659__$1 == null);
var state_14718__$1 = (function (){var statearr_14724 = state_14718;
(statearr_14724[(13)] = inst_14659__$1);

return statearr_14724;
})();
if(cljs.core.truth_(inst_14660)){
var statearr_14725_14764 = state_14718__$1;
(statearr_14725_14764[(1)] = (5));

} else {
var statearr_14726_14765 = state_14718__$1;
(statearr_14726_14765[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14719 === (15))){
var state_14718__$1 = state_14718;
var statearr_14730_14766 = state_14718__$1;
(statearr_14730_14766[(2)] = null);

(statearr_14730_14766[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14719 === (21))){
var state_14718__$1 = state_14718;
var statearr_14731_14767 = state_14718__$1;
(statearr_14731_14767[(2)] = null);

(statearr_14731_14767[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14719 === (13))){
var inst_14670 = (state_14718[(9)]);
var inst_14672 = (state_14718[(10)]);
var inst_14673 = (state_14718[(11)]);
var inst_14671 = (state_14718[(12)]);
var inst_14680 = (state_14718[(2)]);
var inst_14681 = (inst_14673 + (1));
var tmp14727 = inst_14670;
var tmp14728 = inst_14672;
var tmp14729 = inst_14671;
var inst_14670__$1 = tmp14727;
var inst_14671__$1 = tmp14729;
var inst_14672__$1 = tmp14728;
var inst_14673__$1 = inst_14681;
var state_14718__$1 = (function (){var statearr_14732 = state_14718;
(statearr_14732[(9)] = inst_14670__$1);

(statearr_14732[(10)] = inst_14672__$1);

(statearr_14732[(14)] = inst_14680);

(statearr_14732[(11)] = inst_14673__$1);

(statearr_14732[(12)] = inst_14671__$1);

return statearr_14732;
})();
var statearr_14733_14768 = state_14718__$1;
(statearr_14733_14768[(2)] = null);

(statearr_14733_14768[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14719 === (22))){
var state_14718__$1 = state_14718;
var statearr_14734_14769 = state_14718__$1;
(statearr_14734_14769[(2)] = null);

(statearr_14734_14769[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14719 === (6))){
var inst_14659 = (state_14718[(13)]);
var inst_14668 = f.call(null,inst_14659);
var inst_14669 = cljs.core.seq.call(null,inst_14668);
var inst_14670 = inst_14669;
var inst_14671 = null;
var inst_14672 = (0);
var inst_14673 = (0);
var state_14718__$1 = (function (){var statearr_14735 = state_14718;
(statearr_14735[(9)] = inst_14670);

(statearr_14735[(10)] = inst_14672);

(statearr_14735[(11)] = inst_14673);

(statearr_14735[(12)] = inst_14671);

return statearr_14735;
})();
var statearr_14736_14770 = state_14718__$1;
(statearr_14736_14770[(2)] = null);

(statearr_14736_14770[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14719 === (17))){
var inst_14684 = (state_14718[(7)]);
var inst_14688 = cljs.core.chunk_first.call(null,inst_14684);
var inst_14689 = cljs.core.chunk_rest.call(null,inst_14684);
var inst_14690 = cljs.core.count.call(null,inst_14688);
var inst_14670 = inst_14689;
var inst_14671 = inst_14688;
var inst_14672 = inst_14690;
var inst_14673 = (0);
var state_14718__$1 = (function (){var statearr_14737 = state_14718;
(statearr_14737[(9)] = inst_14670);

(statearr_14737[(10)] = inst_14672);

(statearr_14737[(11)] = inst_14673);

(statearr_14737[(12)] = inst_14671);

return statearr_14737;
})();
var statearr_14738_14771 = state_14718__$1;
(statearr_14738_14771[(2)] = null);

(statearr_14738_14771[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14719 === (3))){
var inst_14716 = (state_14718[(2)]);
var state_14718__$1 = state_14718;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14718__$1,inst_14716);
} else {
if((state_val_14719 === (12))){
var inst_14704 = (state_14718[(2)]);
var state_14718__$1 = state_14718;
var statearr_14739_14772 = state_14718__$1;
(statearr_14739_14772[(2)] = inst_14704);

(statearr_14739_14772[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14719 === (2))){
var state_14718__$1 = state_14718;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14718__$1,(4),in$);
} else {
if((state_val_14719 === (23))){
var inst_14712 = (state_14718[(2)]);
var state_14718__$1 = state_14718;
var statearr_14740_14773 = state_14718__$1;
(statearr_14740_14773[(2)] = inst_14712);

(statearr_14740_14773[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14719 === (19))){
var inst_14699 = (state_14718[(2)]);
var state_14718__$1 = state_14718;
var statearr_14741_14774 = state_14718__$1;
(statearr_14741_14774[(2)] = inst_14699);

(statearr_14741_14774[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14719 === (11))){
var inst_14684 = (state_14718[(7)]);
var inst_14670 = (state_14718[(9)]);
var inst_14684__$1 = cljs.core.seq.call(null,inst_14670);
var state_14718__$1 = (function (){var statearr_14742 = state_14718;
(statearr_14742[(7)] = inst_14684__$1);

return statearr_14742;
})();
if(inst_14684__$1){
var statearr_14743_14775 = state_14718__$1;
(statearr_14743_14775[(1)] = (14));

} else {
var statearr_14744_14776 = state_14718__$1;
(statearr_14744_14776[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14719 === (9))){
var inst_14706 = (state_14718[(2)]);
var inst_14707 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_14718__$1 = (function (){var statearr_14745 = state_14718;
(statearr_14745[(15)] = inst_14706);

return statearr_14745;
})();
if(cljs.core.truth_(inst_14707)){
var statearr_14746_14777 = state_14718__$1;
(statearr_14746_14777[(1)] = (21));

} else {
var statearr_14747_14778 = state_14718__$1;
(statearr_14747_14778[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14719 === (5))){
var inst_14662 = cljs.core.async.close_BANG_.call(null,out);
var state_14718__$1 = state_14718;
var statearr_14748_14779 = state_14718__$1;
(statearr_14748_14779[(2)] = inst_14662);

(statearr_14748_14779[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14719 === (14))){
var inst_14684 = (state_14718[(7)]);
var inst_14686 = cljs.core.chunked_seq_QMARK_.call(null,inst_14684);
var state_14718__$1 = state_14718;
if(inst_14686){
var statearr_14749_14780 = state_14718__$1;
(statearr_14749_14780[(1)] = (17));

} else {
var statearr_14750_14781 = state_14718__$1;
(statearr_14750_14781[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14719 === (16))){
var inst_14702 = (state_14718[(2)]);
var state_14718__$1 = state_14718;
var statearr_14751_14782 = state_14718__$1;
(statearr_14751_14782[(2)] = inst_14702);

(statearr_14751_14782[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14719 === (10))){
var inst_14673 = (state_14718[(11)]);
var inst_14671 = (state_14718[(12)]);
var inst_14678 = cljs.core._nth.call(null,inst_14671,inst_14673);
var state_14718__$1 = state_14718;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14718__$1,(13),out,inst_14678);
} else {
if((state_val_14719 === (18))){
var inst_14684 = (state_14718[(7)]);
var inst_14693 = cljs.core.first.call(null,inst_14684);
var state_14718__$1 = state_14718;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14718__$1,(20),out,inst_14693);
} else {
if((state_val_14719 === (8))){
var inst_14672 = (state_14718[(10)]);
var inst_14673 = (state_14718[(11)]);
var inst_14675 = (inst_14673 < inst_14672);
var inst_14676 = inst_14675;
var state_14718__$1 = state_14718;
if(cljs.core.truth_(inst_14676)){
var statearr_14752_14783 = state_14718__$1;
(statearr_14752_14783[(1)] = (10));

} else {
var statearr_14753_14784 = state_14718__$1;
(statearr_14753_14784[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12231__auto__))
;
return ((function (switch__12119__auto__,c__12231__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__12120__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__12120__auto____0 = (function (){
var statearr_14757 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14757[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__12120__auto__);

(statearr_14757[(1)] = (1));

return statearr_14757;
});
var cljs$core$async$mapcat_STAR__$_state_machine__12120__auto____1 = (function (state_14718){
while(true){
var ret_value__12121__auto__ = (function (){try{while(true){
var result__12122__auto__ = switch__12119__auto__.call(null,state_14718);
if(cljs.core.keyword_identical_QMARK_.call(null,result__12122__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12122__auto__;
}
break;
}
}catch (e14758){if((e14758 instanceof Object)){
var ex__12123__auto__ = e14758;
var statearr_14759_14785 = state_14718;
(statearr_14759_14785[(5)] = ex__12123__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14718);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14758;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__12121__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14786 = state_14718;
state_14718 = G__14786;
continue;
} else {
return ret_value__12121__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__12120__auto__ = function(state_14718){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__12120__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__12120__auto____1.call(this,state_14718);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__12120__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__12120__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__12120__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__12120__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__12120__auto__;
})()
;})(switch__12119__auto__,c__12231__auto__))
})();
var state__12233__auto__ = (function (){var statearr_14760 = f__12232__auto__.call(null);
(statearr_14760[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12231__auto__);

return statearr_14760;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__12233__auto__);
});})(c__12231__auto__))
);

return c__12231__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args14787 = [];
var len__7484__auto___14790 = arguments.length;
var i__7485__auto___14791 = (0);
while(true){
if((i__7485__auto___14791 < len__7484__auto___14790)){
args14787.push((arguments[i__7485__auto___14791]));

var G__14792 = (i__7485__auto___14791 + (1));
i__7485__auto___14791 = G__14792;
continue;
} else {
}
break;
}

var G__14789 = args14787.length;
switch (G__14789) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14787.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args14794 = [];
var len__7484__auto___14797 = arguments.length;
var i__7485__auto___14798 = (0);
while(true){
if((i__7485__auto___14798 < len__7484__auto___14797)){
args14794.push((arguments[i__7485__auto___14798]));

var G__14799 = (i__7485__auto___14798 + (1));
i__7485__auto___14798 = G__14799;
continue;
} else {
}
break;
}

var G__14796 = args14794.length;
switch (G__14796) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14794.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args14801 = [];
var len__7484__auto___14852 = arguments.length;
var i__7485__auto___14853 = (0);
while(true){
if((i__7485__auto___14853 < len__7484__auto___14852)){
args14801.push((arguments[i__7485__auto___14853]));

var G__14854 = (i__7485__auto___14853 + (1));
i__7485__auto___14853 = G__14854;
continue;
} else {
}
break;
}

var G__14803 = args14801.length;
switch (G__14803) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14801.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__12231__auto___14856 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__12231__auto___14856,out){
return (function (){
var f__12232__auto__ = (function (){var switch__12119__auto__ = ((function (c__12231__auto___14856,out){
return (function (state_14827){
var state_val_14828 = (state_14827[(1)]);
if((state_val_14828 === (7))){
var inst_14822 = (state_14827[(2)]);
var state_14827__$1 = state_14827;
var statearr_14829_14857 = state_14827__$1;
(statearr_14829_14857[(2)] = inst_14822);

(statearr_14829_14857[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14828 === (1))){
var inst_14804 = null;
var state_14827__$1 = (function (){var statearr_14830 = state_14827;
(statearr_14830[(7)] = inst_14804);

return statearr_14830;
})();
var statearr_14831_14858 = state_14827__$1;
(statearr_14831_14858[(2)] = null);

(statearr_14831_14858[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14828 === (4))){
var inst_14807 = (state_14827[(8)]);
var inst_14807__$1 = (state_14827[(2)]);
var inst_14808 = (inst_14807__$1 == null);
var inst_14809 = cljs.core.not.call(null,inst_14808);
var state_14827__$1 = (function (){var statearr_14832 = state_14827;
(statearr_14832[(8)] = inst_14807__$1);

return statearr_14832;
})();
if(inst_14809){
var statearr_14833_14859 = state_14827__$1;
(statearr_14833_14859[(1)] = (5));

} else {
var statearr_14834_14860 = state_14827__$1;
(statearr_14834_14860[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14828 === (6))){
var state_14827__$1 = state_14827;
var statearr_14835_14861 = state_14827__$1;
(statearr_14835_14861[(2)] = null);

(statearr_14835_14861[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14828 === (3))){
var inst_14824 = (state_14827[(2)]);
var inst_14825 = cljs.core.async.close_BANG_.call(null,out);
var state_14827__$1 = (function (){var statearr_14836 = state_14827;
(statearr_14836[(9)] = inst_14824);

return statearr_14836;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14827__$1,inst_14825);
} else {
if((state_val_14828 === (2))){
var state_14827__$1 = state_14827;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14827__$1,(4),ch);
} else {
if((state_val_14828 === (11))){
var inst_14807 = (state_14827[(8)]);
var inst_14816 = (state_14827[(2)]);
var inst_14804 = inst_14807;
var state_14827__$1 = (function (){var statearr_14837 = state_14827;
(statearr_14837[(7)] = inst_14804);

(statearr_14837[(10)] = inst_14816);

return statearr_14837;
})();
var statearr_14838_14862 = state_14827__$1;
(statearr_14838_14862[(2)] = null);

(statearr_14838_14862[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14828 === (9))){
var inst_14807 = (state_14827[(8)]);
var state_14827__$1 = state_14827;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14827__$1,(11),out,inst_14807);
} else {
if((state_val_14828 === (5))){
var inst_14804 = (state_14827[(7)]);
var inst_14807 = (state_14827[(8)]);
var inst_14811 = cljs.core._EQ_.call(null,inst_14807,inst_14804);
var state_14827__$1 = state_14827;
if(inst_14811){
var statearr_14840_14863 = state_14827__$1;
(statearr_14840_14863[(1)] = (8));

} else {
var statearr_14841_14864 = state_14827__$1;
(statearr_14841_14864[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14828 === (10))){
var inst_14819 = (state_14827[(2)]);
var state_14827__$1 = state_14827;
var statearr_14842_14865 = state_14827__$1;
(statearr_14842_14865[(2)] = inst_14819);

(statearr_14842_14865[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14828 === (8))){
var inst_14804 = (state_14827[(7)]);
var tmp14839 = inst_14804;
var inst_14804__$1 = tmp14839;
var state_14827__$1 = (function (){var statearr_14843 = state_14827;
(statearr_14843[(7)] = inst_14804__$1);

return statearr_14843;
})();
var statearr_14844_14866 = state_14827__$1;
(statearr_14844_14866[(2)] = null);

(statearr_14844_14866[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__12231__auto___14856,out))
;
return ((function (switch__12119__auto__,c__12231__auto___14856,out){
return (function() {
var cljs$core$async$state_machine__12120__auto__ = null;
var cljs$core$async$state_machine__12120__auto____0 = (function (){
var statearr_14848 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_14848[(0)] = cljs$core$async$state_machine__12120__auto__);

(statearr_14848[(1)] = (1));

return statearr_14848;
});
var cljs$core$async$state_machine__12120__auto____1 = (function (state_14827){
while(true){
var ret_value__12121__auto__ = (function (){try{while(true){
var result__12122__auto__ = switch__12119__auto__.call(null,state_14827);
if(cljs.core.keyword_identical_QMARK_.call(null,result__12122__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12122__auto__;
}
break;
}
}catch (e14849){if((e14849 instanceof Object)){
var ex__12123__auto__ = e14849;
var statearr_14850_14867 = state_14827;
(statearr_14850_14867[(5)] = ex__12123__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14827);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14849;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__12121__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14868 = state_14827;
state_14827 = G__14868;
continue;
} else {
return ret_value__12121__auto__;
}
break;
}
});
cljs$core$async$state_machine__12120__auto__ = function(state_14827){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12120__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12120__auto____1.call(this,state_14827);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12120__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12120__auto____0;
cljs$core$async$state_machine__12120__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12120__auto____1;
return cljs$core$async$state_machine__12120__auto__;
})()
;})(switch__12119__auto__,c__12231__auto___14856,out))
})();
var state__12233__auto__ = (function (){var statearr_14851 = f__12232__auto__.call(null);
(statearr_14851[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12231__auto___14856);

return statearr_14851;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__12233__auto__);
});})(c__12231__auto___14856,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args14869 = [];
var len__7484__auto___14939 = arguments.length;
var i__7485__auto___14940 = (0);
while(true){
if((i__7485__auto___14940 < len__7484__auto___14939)){
args14869.push((arguments[i__7485__auto___14940]));

var G__14941 = (i__7485__auto___14940 + (1));
i__7485__auto___14940 = G__14941;
continue;
} else {
}
break;
}

var G__14871 = args14869.length;
switch (G__14871) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14869.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__12231__auto___14943 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__12231__auto___14943,out){
return (function (){
var f__12232__auto__ = (function (){var switch__12119__auto__ = ((function (c__12231__auto___14943,out){
return (function (state_14909){
var state_val_14910 = (state_14909[(1)]);
if((state_val_14910 === (7))){
var inst_14905 = (state_14909[(2)]);
var state_14909__$1 = state_14909;
var statearr_14911_14944 = state_14909__$1;
(statearr_14911_14944[(2)] = inst_14905);

(statearr_14911_14944[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14910 === (1))){
var inst_14872 = (new Array(n));
var inst_14873 = inst_14872;
var inst_14874 = (0);
var state_14909__$1 = (function (){var statearr_14912 = state_14909;
(statearr_14912[(7)] = inst_14873);

(statearr_14912[(8)] = inst_14874);

return statearr_14912;
})();
var statearr_14913_14945 = state_14909__$1;
(statearr_14913_14945[(2)] = null);

(statearr_14913_14945[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14910 === (4))){
var inst_14877 = (state_14909[(9)]);
var inst_14877__$1 = (state_14909[(2)]);
var inst_14878 = (inst_14877__$1 == null);
var inst_14879 = cljs.core.not.call(null,inst_14878);
var state_14909__$1 = (function (){var statearr_14914 = state_14909;
(statearr_14914[(9)] = inst_14877__$1);

return statearr_14914;
})();
if(inst_14879){
var statearr_14915_14946 = state_14909__$1;
(statearr_14915_14946[(1)] = (5));

} else {
var statearr_14916_14947 = state_14909__$1;
(statearr_14916_14947[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14910 === (15))){
var inst_14899 = (state_14909[(2)]);
var state_14909__$1 = state_14909;
var statearr_14917_14948 = state_14909__$1;
(statearr_14917_14948[(2)] = inst_14899);

(statearr_14917_14948[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14910 === (13))){
var state_14909__$1 = state_14909;
var statearr_14918_14949 = state_14909__$1;
(statearr_14918_14949[(2)] = null);

(statearr_14918_14949[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14910 === (6))){
var inst_14874 = (state_14909[(8)]);
var inst_14895 = (inst_14874 > (0));
var state_14909__$1 = state_14909;
if(cljs.core.truth_(inst_14895)){
var statearr_14919_14950 = state_14909__$1;
(statearr_14919_14950[(1)] = (12));

} else {
var statearr_14920_14951 = state_14909__$1;
(statearr_14920_14951[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14910 === (3))){
var inst_14907 = (state_14909[(2)]);
var state_14909__$1 = state_14909;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14909__$1,inst_14907);
} else {
if((state_val_14910 === (12))){
var inst_14873 = (state_14909[(7)]);
var inst_14897 = cljs.core.vec.call(null,inst_14873);
var state_14909__$1 = state_14909;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14909__$1,(15),out,inst_14897);
} else {
if((state_val_14910 === (2))){
var state_14909__$1 = state_14909;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14909__$1,(4),ch);
} else {
if((state_val_14910 === (11))){
var inst_14889 = (state_14909[(2)]);
var inst_14890 = (new Array(n));
var inst_14873 = inst_14890;
var inst_14874 = (0);
var state_14909__$1 = (function (){var statearr_14921 = state_14909;
(statearr_14921[(10)] = inst_14889);

(statearr_14921[(7)] = inst_14873);

(statearr_14921[(8)] = inst_14874);

return statearr_14921;
})();
var statearr_14922_14952 = state_14909__$1;
(statearr_14922_14952[(2)] = null);

(statearr_14922_14952[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14910 === (9))){
var inst_14873 = (state_14909[(7)]);
var inst_14887 = cljs.core.vec.call(null,inst_14873);
var state_14909__$1 = state_14909;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14909__$1,(11),out,inst_14887);
} else {
if((state_val_14910 === (5))){
var inst_14882 = (state_14909[(11)]);
var inst_14873 = (state_14909[(7)]);
var inst_14874 = (state_14909[(8)]);
var inst_14877 = (state_14909[(9)]);
var inst_14881 = (inst_14873[inst_14874] = inst_14877);
var inst_14882__$1 = (inst_14874 + (1));
var inst_14883 = (inst_14882__$1 < n);
var state_14909__$1 = (function (){var statearr_14923 = state_14909;
(statearr_14923[(11)] = inst_14882__$1);

(statearr_14923[(12)] = inst_14881);

return statearr_14923;
})();
if(cljs.core.truth_(inst_14883)){
var statearr_14924_14953 = state_14909__$1;
(statearr_14924_14953[(1)] = (8));

} else {
var statearr_14925_14954 = state_14909__$1;
(statearr_14925_14954[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14910 === (14))){
var inst_14902 = (state_14909[(2)]);
var inst_14903 = cljs.core.async.close_BANG_.call(null,out);
var state_14909__$1 = (function (){var statearr_14927 = state_14909;
(statearr_14927[(13)] = inst_14902);

return statearr_14927;
})();
var statearr_14928_14955 = state_14909__$1;
(statearr_14928_14955[(2)] = inst_14903);

(statearr_14928_14955[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14910 === (10))){
var inst_14893 = (state_14909[(2)]);
var state_14909__$1 = state_14909;
var statearr_14929_14956 = state_14909__$1;
(statearr_14929_14956[(2)] = inst_14893);

(statearr_14929_14956[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14910 === (8))){
var inst_14882 = (state_14909[(11)]);
var inst_14873 = (state_14909[(7)]);
var tmp14926 = inst_14873;
var inst_14873__$1 = tmp14926;
var inst_14874 = inst_14882;
var state_14909__$1 = (function (){var statearr_14930 = state_14909;
(statearr_14930[(7)] = inst_14873__$1);

(statearr_14930[(8)] = inst_14874);

return statearr_14930;
})();
var statearr_14931_14957 = state_14909__$1;
(statearr_14931_14957[(2)] = null);

(statearr_14931_14957[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12231__auto___14943,out))
;
return ((function (switch__12119__auto__,c__12231__auto___14943,out){
return (function() {
var cljs$core$async$state_machine__12120__auto__ = null;
var cljs$core$async$state_machine__12120__auto____0 = (function (){
var statearr_14935 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14935[(0)] = cljs$core$async$state_machine__12120__auto__);

(statearr_14935[(1)] = (1));

return statearr_14935;
});
var cljs$core$async$state_machine__12120__auto____1 = (function (state_14909){
while(true){
var ret_value__12121__auto__ = (function (){try{while(true){
var result__12122__auto__ = switch__12119__auto__.call(null,state_14909);
if(cljs.core.keyword_identical_QMARK_.call(null,result__12122__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12122__auto__;
}
break;
}
}catch (e14936){if((e14936 instanceof Object)){
var ex__12123__auto__ = e14936;
var statearr_14937_14958 = state_14909;
(statearr_14937_14958[(5)] = ex__12123__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14909);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14936;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__12121__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14959 = state_14909;
state_14909 = G__14959;
continue;
} else {
return ret_value__12121__auto__;
}
break;
}
});
cljs$core$async$state_machine__12120__auto__ = function(state_14909){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12120__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12120__auto____1.call(this,state_14909);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12120__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12120__auto____0;
cljs$core$async$state_machine__12120__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12120__auto____1;
return cljs$core$async$state_machine__12120__auto__;
})()
;})(switch__12119__auto__,c__12231__auto___14943,out))
})();
var state__12233__auto__ = (function (){var statearr_14938 = f__12232__auto__.call(null);
(statearr_14938[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12231__auto___14943);

return statearr_14938;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__12233__auto__);
});})(c__12231__auto___14943,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args14960 = [];
var len__7484__auto___15034 = arguments.length;
var i__7485__auto___15035 = (0);
while(true){
if((i__7485__auto___15035 < len__7484__auto___15034)){
args14960.push((arguments[i__7485__auto___15035]));

var G__15036 = (i__7485__auto___15035 + (1));
i__7485__auto___15035 = G__15036;
continue;
} else {
}
break;
}

var G__14962 = args14960.length;
switch (G__14962) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14960.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__12231__auto___15038 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__12231__auto___15038,out){
return (function (){
var f__12232__auto__ = (function (){var switch__12119__auto__ = ((function (c__12231__auto___15038,out){
return (function (state_15004){
var state_val_15005 = (state_15004[(1)]);
if((state_val_15005 === (7))){
var inst_15000 = (state_15004[(2)]);
var state_15004__$1 = state_15004;
var statearr_15006_15039 = state_15004__$1;
(statearr_15006_15039[(2)] = inst_15000);

(statearr_15006_15039[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15005 === (1))){
var inst_14963 = [];
var inst_14964 = inst_14963;
var inst_14965 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_15004__$1 = (function (){var statearr_15007 = state_15004;
(statearr_15007[(7)] = inst_14964);

(statearr_15007[(8)] = inst_14965);

return statearr_15007;
})();
var statearr_15008_15040 = state_15004__$1;
(statearr_15008_15040[(2)] = null);

(statearr_15008_15040[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15005 === (4))){
var inst_14968 = (state_15004[(9)]);
var inst_14968__$1 = (state_15004[(2)]);
var inst_14969 = (inst_14968__$1 == null);
var inst_14970 = cljs.core.not.call(null,inst_14969);
var state_15004__$1 = (function (){var statearr_15009 = state_15004;
(statearr_15009[(9)] = inst_14968__$1);

return statearr_15009;
})();
if(inst_14970){
var statearr_15010_15041 = state_15004__$1;
(statearr_15010_15041[(1)] = (5));

} else {
var statearr_15011_15042 = state_15004__$1;
(statearr_15011_15042[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15005 === (15))){
var inst_14994 = (state_15004[(2)]);
var state_15004__$1 = state_15004;
var statearr_15012_15043 = state_15004__$1;
(statearr_15012_15043[(2)] = inst_14994);

(statearr_15012_15043[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15005 === (13))){
var state_15004__$1 = state_15004;
var statearr_15013_15044 = state_15004__$1;
(statearr_15013_15044[(2)] = null);

(statearr_15013_15044[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15005 === (6))){
var inst_14964 = (state_15004[(7)]);
var inst_14989 = inst_14964.length;
var inst_14990 = (inst_14989 > (0));
var state_15004__$1 = state_15004;
if(cljs.core.truth_(inst_14990)){
var statearr_15014_15045 = state_15004__$1;
(statearr_15014_15045[(1)] = (12));

} else {
var statearr_15015_15046 = state_15004__$1;
(statearr_15015_15046[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15005 === (3))){
var inst_15002 = (state_15004[(2)]);
var state_15004__$1 = state_15004;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15004__$1,inst_15002);
} else {
if((state_val_15005 === (12))){
var inst_14964 = (state_15004[(7)]);
var inst_14992 = cljs.core.vec.call(null,inst_14964);
var state_15004__$1 = state_15004;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_15004__$1,(15),out,inst_14992);
} else {
if((state_val_15005 === (2))){
var state_15004__$1 = state_15004;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15004__$1,(4),ch);
} else {
if((state_val_15005 === (11))){
var inst_14968 = (state_15004[(9)]);
var inst_14972 = (state_15004[(10)]);
var inst_14982 = (state_15004[(2)]);
var inst_14983 = [];
var inst_14984 = inst_14983.push(inst_14968);
var inst_14964 = inst_14983;
var inst_14965 = inst_14972;
var state_15004__$1 = (function (){var statearr_15016 = state_15004;
(statearr_15016[(11)] = inst_14982);

(statearr_15016[(7)] = inst_14964);

(statearr_15016[(12)] = inst_14984);

(statearr_15016[(8)] = inst_14965);

return statearr_15016;
})();
var statearr_15017_15047 = state_15004__$1;
(statearr_15017_15047[(2)] = null);

(statearr_15017_15047[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15005 === (9))){
var inst_14964 = (state_15004[(7)]);
var inst_14980 = cljs.core.vec.call(null,inst_14964);
var state_15004__$1 = state_15004;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_15004__$1,(11),out,inst_14980);
} else {
if((state_val_15005 === (5))){
var inst_14968 = (state_15004[(9)]);
var inst_14972 = (state_15004[(10)]);
var inst_14965 = (state_15004[(8)]);
var inst_14972__$1 = f.call(null,inst_14968);
var inst_14973 = cljs.core._EQ_.call(null,inst_14972__$1,inst_14965);
var inst_14974 = cljs.core.keyword_identical_QMARK_.call(null,inst_14965,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_14975 = (inst_14973) || (inst_14974);
var state_15004__$1 = (function (){var statearr_15018 = state_15004;
(statearr_15018[(10)] = inst_14972__$1);

return statearr_15018;
})();
if(cljs.core.truth_(inst_14975)){
var statearr_15019_15048 = state_15004__$1;
(statearr_15019_15048[(1)] = (8));

} else {
var statearr_15020_15049 = state_15004__$1;
(statearr_15020_15049[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15005 === (14))){
var inst_14997 = (state_15004[(2)]);
var inst_14998 = cljs.core.async.close_BANG_.call(null,out);
var state_15004__$1 = (function (){var statearr_15022 = state_15004;
(statearr_15022[(13)] = inst_14997);

return statearr_15022;
})();
var statearr_15023_15050 = state_15004__$1;
(statearr_15023_15050[(2)] = inst_14998);

(statearr_15023_15050[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15005 === (10))){
var inst_14987 = (state_15004[(2)]);
var state_15004__$1 = state_15004;
var statearr_15024_15051 = state_15004__$1;
(statearr_15024_15051[(2)] = inst_14987);

(statearr_15024_15051[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15005 === (8))){
var inst_14968 = (state_15004[(9)]);
var inst_14972 = (state_15004[(10)]);
var inst_14964 = (state_15004[(7)]);
var inst_14977 = inst_14964.push(inst_14968);
var tmp15021 = inst_14964;
var inst_14964__$1 = tmp15021;
var inst_14965 = inst_14972;
var state_15004__$1 = (function (){var statearr_15025 = state_15004;
(statearr_15025[(14)] = inst_14977);

(statearr_15025[(7)] = inst_14964__$1);

(statearr_15025[(8)] = inst_14965);

return statearr_15025;
})();
var statearr_15026_15052 = state_15004__$1;
(statearr_15026_15052[(2)] = null);

(statearr_15026_15052[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12231__auto___15038,out))
;
return ((function (switch__12119__auto__,c__12231__auto___15038,out){
return (function() {
var cljs$core$async$state_machine__12120__auto__ = null;
var cljs$core$async$state_machine__12120__auto____0 = (function (){
var statearr_15030 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15030[(0)] = cljs$core$async$state_machine__12120__auto__);

(statearr_15030[(1)] = (1));

return statearr_15030;
});
var cljs$core$async$state_machine__12120__auto____1 = (function (state_15004){
while(true){
var ret_value__12121__auto__ = (function (){try{while(true){
var result__12122__auto__ = switch__12119__auto__.call(null,state_15004);
if(cljs.core.keyword_identical_QMARK_.call(null,result__12122__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12122__auto__;
}
break;
}
}catch (e15031){if((e15031 instanceof Object)){
var ex__12123__auto__ = e15031;
var statearr_15032_15053 = state_15004;
(statearr_15032_15053[(5)] = ex__12123__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_15004);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e15031;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__12121__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15054 = state_15004;
state_15004 = G__15054;
continue;
} else {
return ret_value__12121__auto__;
}
break;
}
});
cljs$core$async$state_machine__12120__auto__ = function(state_15004){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12120__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12120__auto____1.call(this,state_15004);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12120__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12120__auto____0;
cljs$core$async$state_machine__12120__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12120__auto____1;
return cljs$core$async$state_machine__12120__auto__;
})()
;})(switch__12119__auto__,c__12231__auto___15038,out))
})();
var state__12233__auto__ = (function (){var statearr_15033 = f__12232__auto__.call(null);
(statearr_15033[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12231__auto___15038);

return statearr_15033;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__12233__auto__);
});})(c__12231__auto___15038,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;

