// Compiled by ClojureScript 1.9.229 {}
goog.provide('hatti.ona.post_process');
goog.require('cljs.core');
goog.require('chimera.js_interop');
goog.require('chimera.om.state');
goog.require('hatti.ona.forms');
goog.require('hatti.ona.urls');
goog.require('hatti.constants');
goog.require('chimera.urls');
goog.require('clojure.string');
/**
 * Given some data in Ona format, builds a data structure that we will use
 * to link osm data to Ona data.
 */
hatti.ona.post_process.ona_osm_link = (function hatti$ona$post_process$ona_osm_link(data,form){
var osmfields = cljs.core.filter.call(null,hatti.ona.forms.osm_QMARK_,form);
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.flatten.call(null,(function (){var iter__7189__auto__ = ((function (osmfields){
return (function hatti$ona$post_process$ona_osm_link_$_iter__20681(s__20682){
return (new cljs.core.LazySeq(null,((function (osmfields){
return (function (){
var s__20682__$1 = s__20682;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__20682__$1);
if(temp__4657__auto__){
var s__20682__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__20682__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__20682__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__20684 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__20683 = (0);
while(true){
if((i__20683 < size__7188__auto__)){
var datum = cljs.core._nth.call(null,c__7187__auto__,i__20683);
cljs.core.chunk_append.call(null,b__20684,(function (){var iter__7189__auto__ = ((function (i__20683,datum,c__7187__auto__,size__7188__auto__,b__20684,s__20682__$2,temp__4657__auto__,osmfields){
return (function hatti$ona$post_process$ona_osm_link_$_iter__20681_$_iter__20693(s__20694){
return (new cljs.core.LazySeq(null,((function (i__20683,datum,c__7187__auto__,size__7188__auto__,b__20684,s__20682__$2,temp__4657__auto__,osmfields){
return (function (){
var s__20694__$1 = s__20694;
while(true){
var temp__4657__auto____$1 = cljs.core.seq.call(null,s__20694__$1);
if(temp__4657__auto____$1){
var s__20694__$2 = temp__4657__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__20694__$2)){
var c__7187__auto____$1 = cljs.core.chunk_first.call(null,s__20694__$2);
var size__7188__auto____$1 = cljs.core.count.call(null,c__7187__auto____$1);
var b__20696 = cljs.core.chunk_buffer.call(null,size__7188__auto____$1);
if((function (){var i__20695 = (0);
while(true){
if((i__20695 < size__7188__auto____$1)){
var field = cljs.core._nth.call(null,c__7187__auto____$1,i__20695);
cljs.core.chunk_append.call(null,b__20696,(function (){var osmkey = new cljs.core.Keyword(null,"full-name","full-name",408178550).cljs$core$IFn$_invoke$arity$1(field);
var osmdatum = cljs.core.get.call(null,datum,osmkey);
var osmid = (function (){var and__6397__auto__ = osmdatum;
if(cljs.core.truth_(and__6397__auto__)){
return cljs.core.re_find.call(null,/[0-9]+/,osmdatum);
} else {
return and__6397__auto__;
}
})();
if(cljs.core.truth_(osmid)){
return cljs.core.PersistentArrayMap.fromArray([osmid,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"field","field",-1302436500),field], null),cljs.core.select_keys.call(null,datum,cljs.core.PersistentHashSet.fromArray([hatti.constants._rank,hatti.constants._id], true)))], true, false);
} else {
return null;
}
})());

var G__20701 = (i__20695 + (1));
i__20695 = G__20701;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20696),hatti$ona$post_process$ona_osm_link_$_iter__20681_$_iter__20693.call(null,cljs.core.chunk_rest.call(null,s__20694__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20696),null);
}
} else {
var field = cljs.core.first.call(null,s__20694__$2);
return cljs.core.cons.call(null,(function (){var osmkey = new cljs.core.Keyword(null,"full-name","full-name",408178550).cljs$core$IFn$_invoke$arity$1(field);
var osmdatum = cljs.core.get.call(null,datum,osmkey);
var osmid = (function (){var and__6397__auto__ = osmdatum;
if(cljs.core.truth_(and__6397__auto__)){
return cljs.core.re_find.call(null,/[0-9]+/,osmdatum);
} else {
return and__6397__auto__;
}
})();
if(cljs.core.truth_(osmid)){
return cljs.core.PersistentArrayMap.fromArray([osmid,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"field","field",-1302436500),field], null),cljs.core.select_keys.call(null,datum,cljs.core.PersistentHashSet.fromArray([hatti.constants._rank,hatti.constants._id], true)))], true, false);
} else {
return null;
}
})(),hatti$ona$post_process$ona_osm_link_$_iter__20681_$_iter__20693.call(null,cljs.core.rest.call(null,s__20694__$2)));
}
} else {
return null;
}
break;
}
});})(i__20683,datum,c__7187__auto__,size__7188__auto__,b__20684,s__20682__$2,temp__4657__auto__,osmfields))
,null,null));
});})(i__20683,datum,c__7187__auto__,size__7188__auto__,b__20684,s__20682__$2,temp__4657__auto__,osmfields))
;
return iter__7189__auto__.call(null,osmfields);
})());

var G__20702 = (i__20683 + (1));
i__20683 = G__20702;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20684),hatti$ona$post_process$ona_osm_link_$_iter__20681.call(null,cljs.core.chunk_rest.call(null,s__20682__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20684),null);
}
} else {
var datum = cljs.core.first.call(null,s__20682__$2);
return cljs.core.cons.call(null,(function (){var iter__7189__auto__ = ((function (datum,s__20682__$2,temp__4657__auto__,osmfields){
return (function hatti$ona$post_process$ona_osm_link_$_iter__20681_$_iter__20697(s__20698){
return (new cljs.core.LazySeq(null,((function (datum,s__20682__$2,temp__4657__auto__,osmfields){
return (function (){
var s__20698__$1 = s__20698;
while(true){
var temp__4657__auto____$1 = cljs.core.seq.call(null,s__20698__$1);
if(temp__4657__auto____$1){
var s__20698__$2 = temp__4657__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__20698__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__20698__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__20700 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__20699 = (0);
while(true){
if((i__20699 < size__7188__auto__)){
var field = cljs.core._nth.call(null,c__7187__auto__,i__20699);
cljs.core.chunk_append.call(null,b__20700,(function (){var osmkey = new cljs.core.Keyword(null,"full-name","full-name",408178550).cljs$core$IFn$_invoke$arity$1(field);
var osmdatum = cljs.core.get.call(null,datum,osmkey);
var osmid = (function (){var and__6397__auto__ = osmdatum;
if(cljs.core.truth_(and__6397__auto__)){
return cljs.core.re_find.call(null,/[0-9]+/,osmdatum);
} else {
return and__6397__auto__;
}
})();
if(cljs.core.truth_(osmid)){
return cljs.core.PersistentArrayMap.fromArray([osmid,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"field","field",-1302436500),field], null),cljs.core.select_keys.call(null,datum,cljs.core.PersistentHashSet.fromArray([hatti.constants._rank,hatti.constants._id], true)))], true, false);
} else {
return null;
}
})());

var G__20703 = (i__20699 + (1));
i__20699 = G__20703;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20700),hatti$ona$post_process$ona_osm_link_$_iter__20681_$_iter__20697.call(null,cljs.core.chunk_rest.call(null,s__20698__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20700),null);
}
} else {
var field = cljs.core.first.call(null,s__20698__$2);
return cljs.core.cons.call(null,(function (){var osmkey = new cljs.core.Keyword(null,"full-name","full-name",408178550).cljs$core$IFn$_invoke$arity$1(field);
var osmdatum = cljs.core.get.call(null,datum,osmkey);
var osmid = (function (){var and__6397__auto__ = osmdatum;
if(cljs.core.truth_(and__6397__auto__)){
return cljs.core.re_find.call(null,/[0-9]+/,osmdatum);
} else {
return and__6397__auto__;
}
})();
if(cljs.core.truth_(osmid)){
return cljs.core.PersistentArrayMap.fromArray([osmid,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"field","field",-1302436500),field], null),cljs.core.select_keys.call(null,datum,cljs.core.PersistentHashSet.fromArray([hatti.constants._rank,hatti.constants._id], true)))], true, false);
} else {
return null;
}
})(),hatti$ona$post_process$ona_osm_link_$_iter__20681_$_iter__20697.call(null,cljs.core.rest.call(null,s__20698__$2)));
}
} else {
return null;
}
break;
}
});})(datum,s__20682__$2,temp__4657__auto__,osmfields))
,null,null));
});})(datum,s__20682__$2,temp__4657__auto__,osmfields))
;
return iter__7189__auto__.call(null,osmfields);
})(),hatti$ona$post_process$ona_osm_link_$_iter__20681.call(null,cljs.core.rest.call(null,s__20682__$2)));
}
} else {
return null;
}
break;
}
});})(osmfields))
,null,null));
});})(osmfields))
;
return iter__7189__auto__.call(null,data);
})()));
});
/**
 * Takes OSM XML in string form, and returns cljs geojson.
 */
hatti.ona.post_process.osm_xml__GT_geojson = (function hatti$ona$post_process$osm_xml__GT_geojson(osm_xml_string){
return cljs.core.js__GT_clj.call(null,osmtogeojson(jQuery.parseXML(osm_xml_string)),new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
});
/**
 * Given some data in OSM format, an Ona Form, and osm xml string,
 * return a map from OSM ID to each osm feature. The map contains:
 * :osm-id, :name, :tags from osm xml,
 * :type, :geom from osm feature's geojson equivalent.
 */
hatti.ona.post_process.osm_id__GT_osm_data = (function hatti$ona$post_process$osm_id__GT_osm_data(data,form,osm_xml){
var ona_osm_link = hatti.ona.post_process.ona_osm_link.call(null,data,form);
var osmgeo = hatti.ona.post_process.osm_xml__GT_geojson.call(null,osm_xml);
var featureset = osmgeo.call(null,new cljs.core.Keyword(null,"features","features",-1146962336));
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__7189__auto__ = ((function (ona_osm_link,osmgeo,featureset){
return (function hatti$ona$post_process$osm_id__GT_osm_data_$_iter__20724(s__20725){
return (new cljs.core.LazySeq(null,((function (ona_osm_link,osmgeo,featureset){
return (function (){
var s__20725__$1 = s__20725;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__20725__$1);
if(temp__4657__auto__){
var s__20725__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__20725__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__20725__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__20727 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__20726 = (0);
while(true){
if((i__20726 < size__7188__auto__)){
var map__20736 = cljs.core._nth.call(null,c__7187__auto__,i__20726);
var map__20736__$1 = ((((!((map__20736 == null)))?((((map__20736.cljs$lang$protocol_mask$partition0$ & (64))) || (map__20736.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__20736):map__20736);
var feature = map__20736__$1;
var type = cljs.core.get.call(null,map__20736__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var properties = cljs.core.get.call(null,map__20736__$1,new cljs.core.Keyword(null,"properties","properties",685819552));
var geometry = cljs.core.get.call(null,map__20736__$1,new cljs.core.Keyword(null,"geometry","geometry",-405034994));
cljs.core.chunk_append.call(null,b__20727,(function (){var map__20738 = properties;
var map__20738__$1 = ((((!((map__20738 == null)))?((((map__20738.cljs$lang$protocol_mask$partition0$ & (64))) || (map__20738.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__20738):map__20738);
var type__$1 = cljs.core.get.call(null,map__20738__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var id = cljs.core.get.call(null,map__20738__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var tags = cljs.core.get.call(null,map__20738__$1,new cljs.core.Keyword(null,"tags","tags",1771418977));
return cljs.core.PersistentArrayMap.fromArray([id,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"osm-id","osm-id",-1125866420),id,new cljs.core.Keyword(null,"type","type",1174270348),type__$1,new cljs.core.Keyword(null,"geom","geom",1207084371),geometry,new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(tags),new cljs.core.Keyword(null,"tags","tags",1771418977),tags], null)], true, false);
})());

var G__20744 = (i__20726 + (1));
i__20726 = G__20744;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20727),hatti$ona$post_process$osm_id__GT_osm_data_$_iter__20724.call(null,cljs.core.chunk_rest.call(null,s__20725__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20727),null);
}
} else {
var map__20740 = cljs.core.first.call(null,s__20725__$2);
var map__20740__$1 = ((((!((map__20740 == null)))?((((map__20740.cljs$lang$protocol_mask$partition0$ & (64))) || (map__20740.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__20740):map__20740);
var feature = map__20740__$1;
var type = cljs.core.get.call(null,map__20740__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var properties = cljs.core.get.call(null,map__20740__$1,new cljs.core.Keyword(null,"properties","properties",685819552));
var geometry = cljs.core.get.call(null,map__20740__$1,new cljs.core.Keyword(null,"geometry","geometry",-405034994));
return cljs.core.cons.call(null,(function (){var map__20742 = properties;
var map__20742__$1 = ((((!((map__20742 == null)))?((((map__20742.cljs$lang$protocol_mask$partition0$ & (64))) || (map__20742.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__20742):map__20742);
var type__$1 = cljs.core.get.call(null,map__20742__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var id = cljs.core.get.call(null,map__20742__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var tags = cljs.core.get.call(null,map__20742__$1,new cljs.core.Keyword(null,"tags","tags",1771418977));
return cljs.core.PersistentArrayMap.fromArray([id,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"osm-id","osm-id",-1125866420),id,new cljs.core.Keyword(null,"type","type",1174270348),type__$1,new cljs.core.Keyword(null,"geom","geom",1207084371),geometry,new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(tags),new cljs.core.Keyword(null,"tags","tags",1771418977),tags], null)], true, false);
})(),hatti$ona$post_process$osm_id__GT_osm_data_$_iter__20724.call(null,cljs.core.rest.call(null,s__20725__$2)));
}
} else {
return null;
}
break;
}
});})(ona_osm_link,osmgeo,featureset))
,null,null));
});})(ona_osm_link,osmgeo,featureset))
;
return iter__7189__auto__.call(null,featureset);
})());
});
/**
 * Given some data post-processed from the ona server
 * (ie, containing _id, _rank), and a string of osm-xml, produce a version with
 * relevant osm data injected in.
 */
hatti.ona.post_process.integrate_osm_data_BANG_ = (function hatti$ona$post_process$integrate_osm_data_BANG_(app_state,form,osm_xml,app_state_keys){
var osm_fields = cljs.core.filter.call(null,hatti.ona.forms.osm_QMARK_,form);
if(cljs.core.seq.call(null,osm_fields)){
var data = cljs.core.get_in.call(null,app_state,app_state_keys);
var osm_data = hatti.ona.post_process.osm_id__GT_osm_data.call(null,data,form,osm_xml);
var osm_val__GT_osm_id = ((function (data,osm_data,osm_fields){
return (function (p1__20745_SHARP_){
return cljs.core.re_find.call(null,/[-]?[0-9]+/,p1__20745_SHARP_);
});})(data,osm_data,osm_fields))
;
var osm_val__GT_osm_data = ((function (data,osm_data,osm_val__GT_osm_id,osm_fields){
return (function (osm_val,osm_id){
if(typeof osm_val === 'string'){
var temp__4655__auto__ = osm_data.call(null,osm_id);
if(cljs.core.truth_(temp__4655__auto__)){
var osm_submission_data = temp__4655__auto__;
return osm_submission_data;
} else {
return osm_val;
}
} else {
return osm_val;
}
});})(data,osm_data,osm_val__GT_osm_id,osm_fields))
;
var updater = ((function (data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields){
return (function (osm_key){
return ((function (data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields){
return (function (data__$1){
var iter__7189__auto__ = ((function (data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields){
return (function hatti$ona$post_process$integrate_osm_data_BANG__$_iter__20755(s__20756){
return (new cljs.core.LazySeq(null,((function (data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields){
return (function (){
var s__20756__$1 = s__20756;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__20756__$1);
if(temp__4657__auto__){
var s__20756__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__20756__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__20756__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__20758 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__20757 = (0);
while(true){
if((i__20757 < size__7188__auto__)){
var datum = cljs.core._nth.call(null,c__7187__auto__,i__20757);
cljs.core.chunk_append.call(null,b__20758,(function (){var osm_id = (function (){var or__6409__auto__ = cljs.core.get_in.call(null,datum,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [[cljs.core.str(osm_key),cljs.core.str(":way:id")].join('')], null));
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return cljs.core.get_in.call(null,datum,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [[cljs.core.str(osm_key),cljs.core.str(":node:id")].join('')], null));
}
})();
return cljs.core.update_in.call(null,datum,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [osm_key], null),((function (i__20757,osm_id,datum,c__7187__auto__,size__7188__auto__,b__20758,s__20756__$2,temp__4657__auto__,data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields){
return (function (p1__20746_SHARP_){
return osm_val__GT_osm_data.call(null,p1__20746_SHARP_,osm_id);
});})(i__20757,osm_id,datum,c__7187__auto__,size__7188__auto__,b__20758,s__20756__$2,temp__4657__auto__,data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields))
);
})());

var G__20763 = (i__20757 + (1));
i__20757 = G__20763;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20758),hatti$ona$post_process$integrate_osm_data_BANG__$_iter__20755.call(null,cljs.core.chunk_rest.call(null,s__20756__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20758),null);
}
} else {
var datum = cljs.core.first.call(null,s__20756__$2);
return cljs.core.cons.call(null,(function (){var osm_id = (function (){var or__6409__auto__ = cljs.core.get_in.call(null,datum,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [[cljs.core.str(osm_key),cljs.core.str(":way:id")].join('')], null));
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return cljs.core.get_in.call(null,datum,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [[cljs.core.str(osm_key),cljs.core.str(":node:id")].join('')], null));
}
})();
return cljs.core.update_in.call(null,datum,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [osm_key], null),((function (osm_id,datum,s__20756__$2,temp__4657__auto__,data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields){
return (function (p1__20746_SHARP_){
return osm_val__GT_osm_data.call(null,p1__20746_SHARP_,osm_id);
});})(osm_id,datum,s__20756__$2,temp__4657__auto__,data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields))
);
})(),hatti$ona$post_process$integrate_osm_data_BANG__$_iter__20755.call(null,cljs.core.rest.call(null,s__20756__$2)));
}
} else {
return null;
}
break;
}
});})(data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields))
,null,null));
});})(data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields))
;
return iter__7189__auto__.call(null,data__$1);
});
;})(data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields))
});})(data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields))
;
var seq__20759 = cljs.core.seq.call(null,osm_fields);
var chunk__20760 = null;
var count__20761 = (0);
var i__20762 = (0);
while(true){
if((i__20762 < count__20761)){
var osm_field = cljs.core._nth.call(null,chunk__20760,i__20762);
chimera.om.state.transact_BANG_.call(null,app_state,app_state_keys,updater.call(null,new cljs.core.Keyword(null,"full-name","full-name",408178550).cljs$core$IFn$_invoke$arity$1(osm_field)));

var G__20764 = seq__20759;
var G__20765 = chunk__20760;
var G__20766 = count__20761;
var G__20767 = (i__20762 + (1));
seq__20759 = G__20764;
chunk__20760 = G__20765;
count__20761 = G__20766;
i__20762 = G__20767;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__20759);
if(temp__4657__auto__){
var seq__20759__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__20759__$1)){
var c__7220__auto__ = cljs.core.chunk_first.call(null,seq__20759__$1);
var G__20768 = cljs.core.chunk_rest.call(null,seq__20759__$1);
var G__20769 = c__7220__auto__;
var G__20770 = cljs.core.count.call(null,c__7220__auto__);
var G__20771 = (0);
seq__20759 = G__20768;
chunk__20760 = G__20769;
count__20761 = G__20770;
i__20762 = G__20771;
continue;
} else {
var osm_field = cljs.core.first.call(null,seq__20759__$1);
chimera.om.state.transact_BANG_.call(null,app_state,app_state_keys,updater.call(null,new cljs.core.Keyword(null,"full-name","full-name",408178550).cljs$core$IFn$_invoke$arity$1(osm_field)));

var G__20772 = cljs.core.next.call(null,seq__20759__$1);
var G__20773 = null;
var G__20774 = (0);
var G__20775 = (0);
seq__20759 = G__20772;
chunk__20760 = G__20773;
count__20761 = G__20774;
i__20762 = G__20775;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return null;
}
});
/**
 * Calculate full image and thumbnail urls given attachment information.
 */
hatti.ona.post_process.url_obj = (function hatti$ona$post_process$url_obj(media_obj){
var media_id = cljs.core.get.call(null,media_obj,"id");
var fname = cljs.core.get.call(null,media_obj,"filename");
var file_url = hatti.ona.urls.media_url.call(null,media_id,fname);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"filename","filename",-1428840783),fname,new cljs.core.Keyword(null,"download_url","download_url",-2115471203),file_url,new cljs.core.Keyword(null,"small_download_url","small_download_url",1654303565),[cljs.core.str(file_url),cljs.core.str("&suffix=small")].join('')], null);
});
/**
 * Helper function for integrate attachments; returns a function from
 * a filename to a `url-obj` (see specs in `url-obj` function).
 */
hatti.ona.post_process.get_attach_map = (function hatti$ona$post_process$get_attach_map(record,attachments){
var attachments__$1 = (function (){var or__6409__auto__ = attachments;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return cljs.core.get.call(null,record,hatti.constants._attachments);
}
})();
var fnames = cljs.core.map.call(null,((function (attachments__$1){
return (function (p1__20776_SHARP_){
return chimera.urls.last_url_param.call(null,cljs.core.get.call(null,p1__20776_SHARP_,"filename"));
});})(attachments__$1))
,attachments__$1);
var fname__GT_urlobj = cljs.core.zipmap.call(null,fnames,cljs.core.map.call(null,hatti.ona.post_process.url_obj,attachments__$1));
return ((function (attachments__$1,fnames,fname__GT_urlobj){
return (function (fname){
return cljs.core.get.call(null,fname__GT_urlobj,fname,fname);
});
;})(attachments__$1,fnames,fname__GT_urlobj))
});
/**
 * Inlines media data from within _attachments into each record.
 */
hatti.ona.post_process.integrate_attachments = (function hatti$ona$post_process$integrate_attachments(var_args){
var args__7491__auto__ = [];
var len__7484__auto___20787 = arguments.length;
var i__7485__auto___20788 = (0);
while(true){
if((i__7485__auto___20788 < len__7484__auto___20787)){
args__7491__auto__.push((arguments[i__7485__auto___20788]));

var G__20789 = (i__7485__auto___20788 + (1));
i__7485__auto___20788 = G__20789;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((2) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((2)),(0),null)):null);
return hatti.ona.post_process.integrate_attachments.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7492__auto__);
});

hatti.ona.post_process.integrate_attachments.cljs$core$IFn$_invoke$arity$variadic = (function (flat_form,data,p__20780){
var map__20781 = p__20780;
var map__20781__$1 = ((((!((map__20781 == null)))?((((map__20781.cljs$lang$protocol_mask$partition0$ & (64))) || (map__20781.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__20781):map__20781);
var attachments = cljs.core.get.call(null,map__20781__$1,new cljs.core.Keyword(null,"attachments","attachments",-1535547830));
var image_fields = cljs.core.filter.call(null,hatti.ona.forms.image_QMARK_,flat_form);
var iter__7189__auto__ = ((function (image_fields,map__20781,map__20781__$1,attachments){
return (function hatti$ona$post_process$iter__20783(s__20784){
return (new cljs.core.LazySeq(null,((function (image_fields,map__20781,map__20781__$1,attachments){
return (function (){
var s__20784__$1 = s__20784;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__20784__$1);
if(temp__4657__auto__){
var s__20784__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__20784__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__20784__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__20786 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__20785 = (0);
while(true){
if((i__20785 < size__7188__auto__)){
var record = cljs.core._nth.call(null,c__7187__auto__,i__20785);
cljs.core.chunk_append.call(null,b__20786,(function (){var attach_map = hatti.ona.post_process.get_attach_map.call(null,record,attachments);
return cljs.core.reduce.call(null,((function (i__20785,attach_map,record,c__7187__auto__,size__7188__auto__,b__20786,s__20784__$2,temp__4657__auto__,image_fields,map__20781,map__20781__$1,attachments){
return (function (record__$1,img_field){
return cljs.core.update_in.call(null,record__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"full-name","full-name",408178550).cljs$core$IFn$_invoke$arity$1(img_field)], null),attach_map);
});})(i__20785,attach_map,record,c__7187__auto__,size__7188__auto__,b__20786,s__20784__$2,temp__4657__auto__,image_fields,map__20781,map__20781__$1,attachments))
,record,image_fields);
})());

var G__20790 = (i__20785 + (1));
i__20785 = G__20790;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20786),hatti$ona$post_process$iter__20783.call(null,cljs.core.chunk_rest.call(null,s__20784__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20786),null);
}
} else {
var record = cljs.core.first.call(null,s__20784__$2);
return cljs.core.cons.call(null,(function (){var attach_map = hatti.ona.post_process.get_attach_map.call(null,record,attachments);
return cljs.core.reduce.call(null,((function (attach_map,record,s__20784__$2,temp__4657__auto__,image_fields,map__20781,map__20781__$1,attachments){
return (function (record__$1,img_field){
return cljs.core.update_in.call(null,record__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"full-name","full-name",408178550).cljs$core$IFn$_invoke$arity$1(img_field)], null),attach_map);
});})(attach_map,record,s__20784__$2,temp__4657__auto__,image_fields,map__20781,map__20781__$1,attachments))
,record,image_fields);
})(),hatti$ona$post_process$iter__20783.call(null,cljs.core.rest.call(null,s__20784__$2)));
}
} else {
return null;
}
break;
}
});})(image_fields,map__20781,map__20781__$1,attachments))
,null,null));
});})(image_fields,map__20781,map__20781__$1,attachments))
;
return iter__7189__auto__.call(null,data);
});

hatti.ona.post_process.integrate_attachments.cljs$lang$maxFixedArity = (2);

hatti.ona.post_process.integrate_attachments.cljs$lang$applyTo = (function (seq20777){
var G__20778 = cljs.core.first.call(null,seq20777);
var seq20777__$1 = cljs.core.next.call(null,seq20777);
var G__20779 = cljs.core.first.call(null,seq20777__$1);
var seq20777__$2 = cljs.core.next.call(null,seq20777__$1);
return hatti.ona.post_process.integrate_attachments.cljs$core$IFn$_invoke$arity$variadic(G__20778,G__20779,seq20777__$2);
});

/**
 * Inlines data from within _attachments into each datapoint within repeats.
 */
hatti.ona.post_process.integrate_attachments_in_repeats = (function hatti$ona$post_process$integrate_attachments_in_repeats(flat_form,data){
var repeat_fields = cljs.core.filter.call(null,hatti.ona.forms.repeat_QMARK_,flat_form);
var integrate = ((function (repeat_fields){
return (function (record,rpt_field){
var key = new cljs.core.Keyword(null,"full-name","full-name",408178550).cljs$core$IFn$_invoke$arity$1(rpt_field);
return cljs.core.assoc.call(null,record,key,hatti.ona.post_process.integrate_attachments.call(null,new cljs.core.Keyword(null,"children","children",-940561982).cljs$core$IFn$_invoke$arity$1(rpt_field),cljs.core.get.call(null,record,key),new cljs.core.Keyword(null,"attachments","attachments",-1535547830),cljs.core.get.call(null,record,hatti.constants._attachments)));
});})(repeat_fields))
;
var iter__7189__auto__ = ((function (repeat_fields,integrate){
return (function hatti$ona$post_process$integrate_attachments_in_repeats_$_iter__20795(s__20796){
return (new cljs.core.LazySeq(null,((function (repeat_fields,integrate){
return (function (){
var s__20796__$1 = s__20796;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__20796__$1);
if(temp__4657__auto__){
var s__20796__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__20796__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__20796__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__20798 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__20797 = (0);
while(true){
if((i__20797 < size__7188__auto__)){
var record = cljs.core._nth.call(null,c__7187__auto__,i__20797);
cljs.core.chunk_append.call(null,b__20798,cljs.core.reduce.call(null,integrate,record,repeat_fields));

var G__20799 = (i__20797 + (1));
i__20797 = G__20799;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20798),hatti$ona$post_process$integrate_attachments_in_repeats_$_iter__20795.call(null,cljs.core.chunk_rest.call(null,s__20796__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20798),null);
}
} else {
var record = cljs.core.first.call(null,s__20796__$2);
return cljs.core.cons.call(null,cljs.core.reduce.call(null,integrate,record,repeat_fields),hatti$ona$post_process$integrate_attachments_in_repeats_$_iter__20795.call(null,cljs.core.rest.call(null,s__20796__$2)));
}
} else {
return null;
}
break;
}
});})(repeat_fields,integrate))
,null,null));
});})(repeat_fields,integrate))
;
return iter__7189__auto__.call(null,data);
});
/**
 * Inlines data from within _attachments into each record within app-state.
 */
hatti.ona.post_process.integrate_attachments_BANG_ = (function hatti$ona$post_process$integrate_attachments_BANG_(var_args){
var args__7491__auto__ = [];
var len__7484__auto___20807 = arguments.length;
var i__7485__auto___20808 = (0);
while(true){
if((i__7485__auto___20808 < len__7484__auto___20807)){
args__7491__auto__.push((arguments[i__7485__auto___20808]));

var G__20809 = (i__7485__auto___20808 + (1));
i__7485__auto___20808 = G__20809;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((2) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((2)),(0),null)):null);
return hatti.ona.post_process.integrate_attachments_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7492__auto__);
});

hatti.ona.post_process.integrate_attachments_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (app_state,flat_form,p__20804){
var map__20805 = p__20804;
var map__20805__$1 = ((((!((map__20805 == null)))?((((map__20805.cljs$lang$protocol_mask$partition0$ & (64))) || (map__20805.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__20805):map__20805);
var app_data_keys = cljs.core.get.call(null,map__20805__$1,new cljs.core.Keyword(null,"app-data-keys","app-data-keys",-662378404),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377)], null));
return chimera.om.state.transact_BANG_.call(null,app_state,app_data_keys,((function (map__20805,map__20805__$1,app_data_keys){
return (function (p1__20800_SHARP_){
return hatti.ona.post_process.integrate_attachments_in_repeats.call(null,flat_form,hatti.ona.post_process.integrate_attachments.call(null,flat_form,p1__20800_SHARP_));
});})(map__20805,map__20805__$1,app_data_keys))
);
});

hatti.ona.post_process.integrate_attachments_BANG_.cljs$lang$maxFixedArity = (2);

hatti.ona.post_process.integrate_attachments_BANG_.cljs$lang$applyTo = (function (seq20801){
var G__20802 = cljs.core.first.call(null,seq20801);
var seq20801__$1 = cljs.core.next.call(null,seq20801);
var G__20803 = cljs.core.first.call(null,seq20801__$1);
var seq20801__$2 = cljs.core.next.call(null,seq20801__$1);
return hatti.ona.post_process.integrate_attachments_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__20802,G__20803,seq20801__$2);
});

