// Compiled by ClojureScript 1.9.229 {:static-fns true, :optimize-constants true}
goog.provide('hatti.shared');
goog.require('cljs.core');
goog.require('chimera.js_interop');
goog.require('chimera.om.state');
goog.require('cljs.core.async');
goog.require('sablono.core');
goog.require('hatti.ona.forms');
goog.require('hatti.constants');
goog.require('om.core');
goog.require('hatti.utils.om.state');
goog.require('chimera.urls');
hatti.shared.event_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
hatti.shared.event_multi_chan = cljs.core.async.mult(hatti.shared.event_chan);
hatti.shared.event_tap = (function hatti$shared$event_tap(){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_multi_chan,cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0());
});
hatti.shared.external_event_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
hatti.shared.external_event_multi_chan = cljs.core.async.mult(hatti.shared.external_event_chan);
hatti.shared.external_event_tap = (function hatti$shared$external_event_tap(){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2(hatti.shared.external_event_multi_chan,cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0());
});
hatti.shared.default_fields = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$full_DASH_name,"_submission_time",cljs.core.cst$kw$label,"Submission Time",cljs.core.cst$kw$name,"_submission_time",cljs.core.cst$kw$type,"datetime"], null)], null);
/**
 * An initial, empty, app-state, which can be modified to change dataviews.
 */
hatti.shared.empty_app_state = (function hatti$shared$empty_app_state(){
var G__31233 = cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$api_DASH_url,cljs.core.cst$kw$table_DASH_page,cljs.core.cst$kw$status,cljs.core.cst$kw$dataset_DASH_info,cljs.core.cst$kw$chart_DASH_page,cljs.core.cst$kw$languages,cljs.core.cst$kw$map_DASH_page,cljs.core.cst$kw$views,cljs.core.cst$kw$data],["//api.ona.io/api/v1/",new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$submission_DASH_clicked,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$data,null], null)], null),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$total_DASH_records,(0),cljs.core.cst$kw$loading_QMARK_,true], null),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$visible_DASH_charts,hatti.shared.default_fields,cljs.core.cst$kw$chart_DASH_data,cljs.core.PersistentArrayMap.EMPTY], null),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$current,null,cljs.core.cst$kw$all,cljs.core.PersistentVector.EMPTY], null),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$submission_DASH_clicked,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$data,null], null),cljs.core.cst$kw$geofield,cljs.core.PersistentArrayMap.EMPTY], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$all,new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$overview,cljs.core.cst$kw$map,cljs.core.cst$kw$table,cljs.core.cst$kw$photos,cljs.core.cst$kw$chart,cljs.core.cst$kw$saved_DASH_charts,cljs.core.cst$kw$settings], null),cljs.core.cst$kw$selected,cljs.core.cst$kw$overview,cljs.core.cst$kw$settings,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$all,new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$form_DASH_info,cljs.core.cst$kw$settings,cljs.core.cst$kw$basemaps,cljs.core.cst$kw$integrated_DASH_apps,cljs.core.cst$kw$media_DASH_files,cljs.core.cst$kw$xls_DASH_reports,cljs.core.cst$kw$service_DASH_configuration], null),cljs.core.cst$kw$active_DASH_tab,cljs.core.cst$kw$form_DASH_info,cljs.core.cst$kw$integrated_DASH_apps,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$active_DASH_section,cljs.core.cst$kw$apps_DASH_list,cljs.core.cst$kw$add_QMARK_,false], null)], null)], null),cljs.core.PersistentVector.EMPTY]);
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__31233) : cljs.core.atom.call(null,G__31233));
});
hatti.shared.app_state = hatti.shared.empty_app_state();
/**
 * Given a function over data, run a transact on data inside app-state.
 */
hatti.shared.transact_app_data_BANG_ = (function hatti$shared$transact_app_data_BANG_(app_state,transact_fn){
return chimera.om.state.transact_BANG_.cljs$core$IFn$_invoke$arity$3(app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data], null),transact_fn);
});
/**
 * Given `data` received from the server, update the app-state.
 * Sorts by submission time, and adds rank to the data, for table + map views.
 */
hatti.shared.update_app_data_BANG_ = (function hatti$shared$update_app_data_BANG_(var_args){
var args__7491__auto__ = [];
var len__7484__auto___31241 = arguments.length;
var i__7485__auto___31242 = (0);
while(true){
if((i__7485__auto___31242 < len__7484__auto___31241)){
args__7491__auto__.push((arguments[i__7485__auto___31242]));

var G__31243 = (i__7485__auto___31242 + (1));
i__7485__auto___31242 = G__31243;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((2) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((2)),(0),null)):null);
return hatti.shared.update_app_data_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7492__auto__);
});

hatti.shared.update_app_data_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (app_state,data,p__31238){
var map__31239 = p__31238;
var map__31239__$1 = ((((!((map__31239 == null)))?((((map__31239.cljs$lang$protocol_mask$partition0$ & (64))) || (map__31239.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__31239):map__31239);
var rerank_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31239__$1,cljs.core.cst$kw$rerank_QMARK_);
var completed_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31239__$1,cljs.core.cst$kw$completed_QMARK_);
var sort_field = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31239__$1,cljs.core.cst$kw$sort_DASH_field);
var current_start_index = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__31239__$1,cljs.core.cst$kw$current_DASH_start_DASH_index,(0));
var add_rank = ((function (map__31239,map__31239__$1,rerank_QMARK_,completed_QMARK_,sort_field,current_start_index){
return (function (i,v){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(v,hatti.constants._rank,(current_start_index + (i + (1))));
});})(map__31239,map__31239__$1,rerank_QMARK_,completed_QMARK_,sort_field,current_start_index))
;
var data__$1 = (cljs.core.truth_((function (){var and__6397__auto__ = rerank_QMARK_;
if(cljs.core.truth_(and__6397__auto__)){
return cljs.core.seq(data);
} else {
return and__6397__auto__;
}
})())?cljs.core.vec(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(add_rank,cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2(((function (add_rank,map__31239,map__31239__$1,rerank_QMARK_,completed_QMARK_,sort_field,current_start_index){
return (function (p1__31234_SHARP_){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__31234_SHARP_,(function (){var or__6409__auto__ = sort_field;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return hatti.constants._submission_time;
}
})());
});})(add_rank,map__31239,map__31239__$1,rerank_QMARK_,completed_QMARK_,sort_field,current_start_index))
,data))):cljs.core.vec(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(add_rank,data)));
var total_records = cljs.core.count(data__$1);
hatti.shared.transact_app_data_BANG_(app_state,((function (add_rank,data__$1,total_records,map__31239,map__31239__$1,rerank_QMARK_,completed_QMARK_,sort_field,current_start_index){
return (function (_){
return data__$1;
});})(add_rank,data__$1,total_records,map__31239,map__31239__$1,rerank_QMARK_,completed_QMARK_,sort_field,current_start_index))
);

return chimera.om.state.merge_into_app_state_BANG_.cljs$core$IFn$_invoke$arity$3(app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$status], null),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$total_DASH_records,total_records,cljs.core.cst$kw$loading_QMARK_,cljs.core.not(completed_QMARK_)], null));
});

hatti.shared.update_app_data_BANG_.cljs$lang$maxFixedArity = (2);

hatti.shared.update_app_data_BANG_.cljs$lang$applyTo = (function (seq31235){
var G__31236 = cljs.core.first(seq31235);
var seq31235__$1 = cljs.core.next(seq31235);
var G__31237 = cljs.core.first(seq31235__$1);
var seq31235__$2 = cljs.core.next(seq31235__$1);
return hatti.shared.update_app_data_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__31236,G__31237,seq31235__$2);
});

/**
 * Add to app data.
 */
hatti.shared.add_to_app_data_BANG_ = (function hatti$shared$add_to_app_data_BANG_(var_args){
var args__7491__auto__ = [];
var len__7484__auto___31250 = arguments.length;
var i__7485__auto___31251 = (0);
while(true){
if((i__7485__auto___31251 < len__7484__auto___31250)){
args__7491__auto__.push((arguments[i__7485__auto___31251]));

var G__31252 = (i__7485__auto___31251 + (1));
i__7485__auto___31251 = G__31252;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((2) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((2)),(0),null)):null);
return hatti.shared.add_to_app_data_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7492__auto__);
});

hatti.shared.add_to_app_data_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (app_state,data,p__31247){
var map__31248 = p__31247;
var map__31248__$1 = ((((!((map__31248 == null)))?((((map__31248.cljs$lang$protocol_mask$partition0$ & (64))) || (map__31248.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__31248):map__31248);
var completed_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31248__$1,cljs.core.cst$kw$completed_QMARK_);
var old_data = cljs.core.cst$kw$data.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(app_state) : cljs.core.deref.call(null,app_state)));
hatti.shared.update_app_data_BANG_.cljs$core$IFn$_invoke$arity$variadic(app_state,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(old_data,data),cljs.core.array_seq([cljs.core.cst$kw$rerank_QMARK_,completed_QMARK_], 0));

return hatti.utils.om.state.update_app_state_BANG_.cljs$core$IFn$_invoke$arity$3(app_state,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$status,cljs.core.cst$kw$loading_QMARK_], null),cljs.core.not(completed_QMARK_));
});

hatti.shared.add_to_app_data_BANG_.cljs$lang$maxFixedArity = (2);

hatti.shared.add_to_app_data_BANG_.cljs$lang$applyTo = (function (seq31244){
var G__31245 = cljs.core.first(seq31244);
var seq31244__$1 = cljs.core.next(seq31244);
var G__31246 = cljs.core.first(seq31244__$1);
var seq31244__$2 = cljs.core.next(seq31244__$1);
return hatti.shared.add_to_app_data_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__31245,G__31246,seq31244__$2);
});

hatti.shared.language_cursor = (function hatti$shared$language_cursor(){
return om.core.ref_cursor(cljs.core.cst$kw$languages.cljs$core$IFn$_invoke$arity$1(om.core.root_cursor(hatti.shared.app_state)));
});
/**
 * A language selector and a following divider.
 */
hatti.shared.language_selector = (function hatti$shared$language_selector(_,owner){
if(typeof hatti.shared.t_hatti$shared31301 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.shared.t_hatti$shared31301 = (function (language_selector,_,owner,meta31302){
this.language_selector = language_selector;
this._ = _;
this.owner = owner;
this.meta31302 = meta31302;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.shared.t_hatti$shared31301.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_31303,meta31302__$1){
var self__ = this;
var _31303__$1 = this;
return (new hatti.shared.t_hatti$shared31301(self__.language_selector,self__._,self__.owner,meta31302__$1));
});

hatti.shared.t_hatti$shared31301.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_31303){
var self__ = this;
var _31303__$1 = this;
return self__.meta31302;
});

hatti.shared.t_hatti$shared31301.prototype.om$core$IRender$ = true;

hatti.shared.t_hatti$shared31301.prototype.om$core$IRender$render$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
var map__31304 = om.core.observe(self__.owner,hatti.shared.language_cursor());
var map__31304__$1 = ((((!((map__31304 == null)))?((((map__31304.cljs$lang$protocol_mask$partition0$ & (64))) || (map__31304.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__31304):map__31304);
var ls = map__31304__$1;
var current = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31304__$1,cljs.core.cst$kw$current);
var all = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31304__$1,cljs.core.cst$kw$all);
var get_update_handler = ((function (map__31304,map__31304__$1,ls,current,all,___$2){
return (function (language){
return ((function (map__31304,map__31304__$1,ls,current,all,___$2){
return (function (event){
om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(ls,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$current], null),language);

return event.preventDefault();
});
;})(map__31304,map__31304__$1,ls,current,all,___$2))
});})(map__31304,map__31304__$1,ls,current,all,___$2))
;
var stringify = ((function (map__31304,map__31304__$1,ls,current,all,get_update_handler,___$2){
return (function (p1__31253_SHARP_){
if((p1__31253_SHARP_ instanceof cljs.core.Keyword)){
return cljs.core.name(p1__31253_SHARP_);
} else {
return [cljs.core.str(p1__31253_SHARP_)].join('');
}
});})(map__31304,map__31304__$1,ls,current,all,get_update_handler,___$2))
;
var G__31313 = ({"className": "language-selector-inner"});
var G__31314 = (function (){var G__31316 = ({"className": "dropdown drop-hover"});
var G__31317 = (function (){var G__31321 = ({"style": ({"marginRight": ".2em"}), "className": "fa fa-globe"});
return React.DOM.i(G__31321);
})();
var G__31318 = (function (){var attrs31308 = (cljs.core.truth_(hatti.ona.forms.english_QMARK_(current))?"EN":stringify(current));
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(React.DOM.span,((cljs.core.map_QMARK_(attrs31308))?sablono.interpreter.attributes(attrs31308):null),cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,((cljs.core.map_QMARK_(attrs31308))?cljs.core.PersistentVector.EMPTY:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret(attrs31308)], null))));
})();
var G__31319 = (function (){var G__31322 = ({"style": ({"marginLeft": ".5em"}), "className": "fa fa-angle-down"});
return React.DOM.i(G__31322);
})();
var G__31320 = (function (){var G__31323 = ({"className": "submenu"});
var G__31324 = cljs.core.into_array.cljs$core$IFn$_invoke$arity$1((function (){var iter__7189__auto__ = ((function (G__31323,G__31316,G__31317,G__31318,G__31319,G__31313,map__31304,map__31304__$1,ls,current,all,get_update_handler,stringify,___$2){
return (function hatti$shared$language_selector_$_iter__31325(s__31326){
return (new cljs.core.LazySeq(null,((function (G__31323,G__31316,G__31317,G__31318,G__31319,G__31313,map__31304,map__31304__$1,ls,current,all,get_update_handler,stringify,___$2){
return (function (){
var s__31326__$1 = s__31326;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__31326__$1);
if(temp__4657__auto__){
var s__31326__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__31326__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__31326__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__31328 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__31327 = (0);
while(true){
if((i__31327 < size__7188__auto__)){
var language = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__31327);
cljs.core.chunk_append(b__31328,(function (){var G__31339 = null;
var G__31340 = (function (){var G__31341 = ({"href": "#", "onClick": get_update_handler(language)});
var G__31342 = sablono.interpreter.interpret(stringify(language));
return React.DOM.a(G__31341,G__31342);
})();
return React.DOM.li(G__31339,G__31340);
})());

var G__31348 = (i__31327 + (1));
i__31327 = G__31348;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__31328),hatti$shared$language_selector_$_iter__31325(cljs.core.chunk_rest(s__31326__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__31328),null);
}
} else {
var language = cljs.core.first(s__31326__$2);
return cljs.core.cons((function (){var G__31343 = null;
var G__31344 = (function (){var G__31345 = ({"href": "#", "onClick": get_update_handler(language)});
var G__31346 = sablono.interpreter.interpret(stringify(language));
return React.DOM.a(G__31345,G__31346);
})();
return React.DOM.li(G__31343,G__31344);
})(),hatti$shared$language_selector_$_iter__31325(cljs.core.rest(s__31326__$2)));
}
} else {
return null;
}
break;
}
});})(G__31323,G__31316,G__31317,G__31318,G__31319,G__31313,map__31304,map__31304__$1,ls,current,all,get_update_handler,stringify,___$2))
,null,null));
});})(G__31323,G__31316,G__31317,G__31318,G__31319,G__31313,map__31304,map__31304__$1,ls,current,all,get_update_handler,stringify,___$2))
;
return iter__7189__auto__(all);
})());
return React.DOM.ul(G__31323,G__31324);
})();
return React.DOM.span(G__31316,G__31317,G__31318,G__31319,G__31320);
})();
var G__31315 = (function (){var G__31347 = ({"className": "divider"});
return React.DOM.div(G__31347);
})();
return React.DOM.div(G__31313,G__31314,G__31315);
});

hatti.shared.t_hatti$shared31301.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$language_DASH_selector,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_,cljs.core.cst$sym$owner], null))),cljs.core.cst$kw$doc,"A language selector and a following divider."], null)),cljs.core.cst$sym$_,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta31302], null);
});

hatti.shared.t_hatti$shared31301.cljs$lang$type = true;

hatti.shared.t_hatti$shared31301.cljs$lang$ctorStr = "hatti.shared/t_hatti$shared31301";

hatti.shared.t_hatti$shared31301.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"hatti.shared/t_hatti$shared31301");
});

hatti.shared.__GT_t_hatti$shared31301 = (function hatti$shared$language_selector_$___GT_t_hatti$shared31301(language_selector__$1,___$1,owner__$1,meta31302){
return (new hatti.shared.t_hatti$shared31301(language_selector__$1,___$1,owner__$1,meta31302));
});

}

return (new hatti.shared.t_hatti$shared31301(hatti$shared$language_selector,_,owner,cljs.core.PersistentArrayMap.EMPTY));
});
