// Compiled by ClojureScript 1.9.229 {}
goog.provide('hatti.views.record');
goog.require('cljs.core');
goog.require('chimera.js_interop');
goog.require('sablono.core');
goog.require('cljs.core.async');
goog.require('hatti.shared');
goog.require('hatti.ona.forms');
goog.require('hatti.constants');
goog.require('clojure.string');
goog.require('hatti.views');
goog.require('om.core');
goog.require('hatti.utils');
goog.require('chimera.urls');
/**
 * Wrap-with produces a partial to wrap a set of children.
 * ((wrap-with :div) 1 2 3) => [:div [1 2 3]]
 * ((wrap-with [:div {:class 0}]) 1 2 3) => [:div {:class 0} [1 2 3]]
 */
hatti.views.record.wrap_with = (function hatti$views$record$wrap_with(root){
return (function() { 
var G__20564__delegate = function (children){
if((root instanceof cljs.core.Keyword)){
return cljs.core.conj.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [root], null),children);
} else {
return cljs.core.conj.call(null,root,children);
}
};
var G__20564 = function (var_args){
var children = null;
if (arguments.length > 0) {
var G__20565__i = 0, G__20565__a = new Array(arguments.length -  0);
while (G__20565__i < G__20565__a.length) {G__20565__a[G__20565__i] = arguments[G__20565__i + 0]; ++G__20565__i;}
  children = new cljs.core.IndexedSeq(G__20565__a,0);
} 
return G__20564__delegate.call(this,children);};
G__20564.cljs$lang$maxFixedArity = 0;
G__20564.cljs$lang$applyTo = (function (arglist__20566){
var children = cljs.core.seq(arglist__20566);
return G__20564__delegate(children);
});
G__20564.cljs$core$IFn$_invoke$arity$variadic = G__20564__delegate;
return G__20564;
})()
;
});
hatti.views.record.submission_arrow = (function hatti$views$record$submission_arrow(dir,cur_rank,view){
var icon = [cljs.core.str("fa fa-arrow-"),cljs.core.str(cljs.core.name.call(null,dir))].join('');
var new_rank = (function (){var G__20571 = (((dir instanceof cljs.core.Keyword))?dir.fqn:null);
switch (G__20571) {
case "left":
return cljs.core.dec;

break;
case "right":
return cljs.core.inc;

break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(dir)].join('')));

}
})().call(null,cur_rank);
var event_key = (function (){var pred__20572 = cljs.core._EQ_;
var expr__20573 = view;
if(cljs.core.truth_(pred__20572.call(null,new cljs.core.Keyword(null,"map","map",1371690461),expr__20573))){
return new cljs.core.Keyword(null,"mapped-submission-to-rank","mapped-submission-to-rank",-1281314361);
} else {
if(cljs.core.truth_(pred__20572.call(null,new cljs.core.Keyword(null,"table","table",-564943036),expr__20573))){
return new cljs.core.Keyword(null,"submission-to-rank","submission-to-rank",1214938797);
} else {
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(expr__20573)].join('')));
}
}
})();
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"on-click","on-click",1632826543),hatti.utils.click_fn.call(null,((function (icon,new_rank,event_key){
return (function (){
return cljs.core.async.put_BANG_.call(null,hatti.shared.event_chan,cljs.core.PersistentArrayMap.fromArray([event_key,new_rank], true, false));
});})(icon,new_rank,event_key))
),new cljs.core.Keyword(null,"class","class",-2030961996),"pure-button btn-default",new cljs.core.Keyword(null,"href","href",-793805698),"#"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"i","i",-1386841315),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),icon], null)], null)], null);
});
hatti.views.record.submission_closer = (function hatti$views$record$submission_closer(){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"on-click","on-click",1632826543),hatti.utils.click_fn.call(null,(function (){
return cljs.core.async.put_BANG_.call(null,hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"submission-unclicked","submission-unclicked",-2099539520),true], null));
})),new cljs.core.Keyword(null,"class","class",-2030961996),"btn-close right",new cljs.core.Keyword(null,"href","href",-793805698),"#"], null),"\u00D7"], null);
});
cljs.core._add_method.call(null,hatti.views.print_xls_report_btn,new cljs.core.Keyword(null,"default","default",-1987822328),(function (cursor,owner){
if(typeof hatti.views.record.t_hatti$views$record20576 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.record.t_hatti$views$record20576 = (function (cursor,owner,meta20577){
this.cursor = cursor;
this.owner = owner;
this.meta20577 = meta20577;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.record.t_hatti$views$record20576.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_20578,meta20577__$1){
var self__ = this;
var _20578__$1 = this;
return (new hatti.views.record.t_hatti$views$record20576(self__.cursor,self__.owner,meta20577__$1));
});

hatti.views.record.t_hatti$views$record20576.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_20578){
var self__ = this;
var _20578__$1 = this;
return self__.meta20577;
});

hatti.views.record.t_hatti$views$record20576.prototype.om$core$IRender$ = true;

hatti.views.record.t_hatti$views$record20576.prototype.om$core$IRender$render$arity$1 = (function (this__16392__auto__){
var self__ = this;
var this__16392__auto____$1 = this;
return React.DOM.div(({"id": "print-xls-report"}));
});

hatti.views.record.t_hatti$views$record20576.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"cursor","cursor",-1642498285,null),new cljs.core.Symbol(null,"owner","owner",1247919588,null),new cljs.core.Symbol(null,"meta20577","meta20577",1580638354,null)], null);
});

hatti.views.record.t_hatti$views$record20576.cljs$lang$type = true;

hatti.views.record.t_hatti$views$record20576.cljs$lang$ctorStr = "hatti.views.record/t_hatti$views$record20576";

hatti.views.record.t_hatti$views$record20576.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"hatti.views.record/t_hatti$views$record20576");
});

hatti.views.record.__GT_t_hatti$views$record20576 = (function hatti$views$record$__GT_t_hatti$views$record20576(cursor__$1,owner__$1,meta20577){
return (new hatti.views.record.t_hatti$views$record20576(cursor__$1,owner__$1,meta20577));
});

}

return (new hatti.views.record.t_hatti$views$record20576(cursor,owner,null));
}));
hatti.views.record.qa_elements = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"map","map",1371690461),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"row-el","row-el",-1433801362),new cljs.core.Keyword(null,"div.question-answer","div.question-answer",370303396),new cljs.core.Keyword(null,"question-el","question-el",-572061899),new cljs.core.Keyword(null,"span.question","span.question",826624133),new cljs.core.Keyword(null,"answer-el","answer-el",-306379371),new cljs.core.Keyword(null,"span.answer","span.answer",1128039098)], null),new cljs.core.Keyword(null,"table","table",-564943036),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"row-el","row-el",-1433801362),new cljs.core.Keyword(null,"tr.question-answer","tr.question-answer",1117674171),new cljs.core.Keyword(null,"question-el","question-el",-572061899),new cljs.core.Keyword(null,"td.question","td.question",-381922608),new cljs.core.Keyword(null,"answer-el","answer-el",-306379371),new cljs.core.Keyword(null,"td.answer","td.answer",1235375692)], null)], null);
hatti.views.record.format_as_question_answer = (function hatti$views$record$format_as_question_answer(view,field,data,lang){
var fname = new cljs.core.Keyword(null,"full-name","full-name",408178550).cljs$core$IFn$_invoke$arity$1(field);
var flabel = hatti.ona.forms.get_label.call(null,field,lang);
var answer = cljs.core.get.call(null,data,fname);
var alabel = hatti.ona.forms.format_answer.call(null,field,answer,lang);
var map__20583 = hatti.views.record.qa_elements.call(null,view);
var map__20583__$1 = ((((!((map__20583 == null)))?((((map__20583.cljs$lang$protocol_mask$partition0$ & (64))) || (map__20583.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__20583):map__20583);
var row_el = cljs.core.get.call(null,map__20583__$1,new cljs.core.Keyword(null,"row-el","row-el",-1433801362));
var question_el = cljs.core.get.call(null,map__20583__$1,new cljs.core.Keyword(null,"question-el","question-el",-572061899));
var answer_el = cljs.core.get.call(null,map__20583__$1,new cljs.core.Keyword(null,"answer-el","answer-el",-306379371));
if(cljs.core.truth_((function (){var and__6397__auto__ = alabel;
if(cljs.core.truth_(and__6397__auto__)){
return cljs.core.not_EQ_.call(null,alabel,hatti.ona.forms.no_answer);
} else {
return and__6397__auto__;
}
})())){
if(cljs.core.truth_(hatti.ona.forms.repeat_QMARK_.call(null,field))){
return om.core.build.call(null,hatti.views.repeat_view,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"data","data",-232669377),answer,new cljs.core.Keyword(null,"repeat-field","repeat-field",-2099292535),field,new cljs.core.Keyword(null,"lang","lang",-1819677104),lang], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"view","view",1247994814),view], null)], null));
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [row_el,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [question_el,flabel], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [answer_el,alabel], null)], null);
}
} else {
return null;
}
});
hatti.views.record.submission_elements = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"map","map",1371690461),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"top-level-wrap","top-level-wrap",366303456),hatti.views.record.wrap_with.call(null,new cljs.core.Keyword(null,"div.legend.infobar.submission.top.right","div.legend.infobar.submission.top.right",726433654)),new cljs.core.Keyword(null,"topbar-wrap","topbar-wrap",1084926998),hatti.views.record.wrap_with.call(null,new cljs.core.Keyword(null,"div.border-bottom.legend-topbar","div.border-bottom.legend-topbar",-1940089808)),new cljs.core.Keyword(null,"header-wrap","header-wrap",517152474),hatti.views.record.wrap_with.call(null,new cljs.core.Keyword(null,"div.border-bottom.submission-header","div.border-bottom.submission-header",1572822310)),new cljs.core.Keyword(null,"submission-info-wrap","submission-info-wrap",-1360099904),hatti.views.record.wrap_with.call(null,new cljs.core.Keyword(null,"div.submission.info-scroll","div.submission.info-scroll",1628305488)),new cljs.core.Keyword(null,"section-wrap","section-wrap",28486716),hatti.views.record.wrap_with.call(null,new cljs.core.Keyword(null,"div.border-bottom","div.border-bottom",1472282167)),new cljs.core.Keyword(null,"h4-cls","h4-cls",-1006591520),"t-red"], null),new cljs.core.Keyword(null,"table","table",-564943036),new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"top-level-wrap","top-level-wrap",366303456),hatti.views.record.wrap_with.call(null,new cljs.core.Keyword(null,"div.widget-info#single-submission-info","div.widget-info#single-submission-info",-714613242)),new cljs.core.Keyword(null,"topbar-wrap","topbar-wrap",1084926998),hatti.views.record.wrap_with.call(null,new cljs.core.Keyword(null,"div.topbar","div.topbar",1355117265)),new cljs.core.Keyword(null,"header-wrap","header-wrap",517152474),hatti.views.record.wrap_with.call(null,new cljs.core.Keyword(null,"div.header","div.header",1964513620)),new cljs.core.Keyword(null,"submission-info-wrap","submission-info-wrap",-1360099904),(function() { 
var G__20585__delegate = function (tbody){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.submission","div.submission",1371621120),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"table.pure-table.pure-table-bordered","table.pure-table.pure-table-bordered",-1577425751),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"thead","thead",-291875296),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"tr","tr",-1424774646),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"th","th",-545608566),"Question"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"th","th",-545608566),"Response"], null)], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"tbody","tbody",-80678300),tbody], null)], null)], null);
};
var G__20585 = function (var_args){
var tbody = null;
if (arguments.length > 0) {
var G__20586__i = 0, G__20586__a = new Array(arguments.length -  0);
while (G__20586__i < G__20586__a.length) {G__20586__a[G__20586__i] = arguments[G__20586__i + 0]; ++G__20586__i;}
  tbody = new cljs.core.IndexedSeq(G__20586__a,0);
} 
return G__20585__delegate.call(this,tbody);};
G__20585.cljs$lang$maxFixedArity = 0;
G__20585.cljs$lang$applyTo = (function (arglist__20587){
var tbody = cljs.core.seq(arglist__20587);
return G__20585__delegate(tbody);
});
G__20585.cljs$core$IFn$_invoke$arity$variadic = G__20585__delegate;
return G__20585;
})()
,new cljs.core.Keyword(null,"section-wrap","section-wrap",28486716),cljs.core.identity,new cljs.core.Keyword(null,"show-instance-id","show-instance-id",-2119784356),true,new cljs.core.Keyword(null,"h4-cls","h4-cls",-1006591520),""], null)], null);
cljs.core._add_method.call(null,hatti.views.repeat_view,new cljs.core.Keyword(null,"default","default",-1987822328),(function (p__20589,owner,p__20590){
var map__20591 = p__20589;
var map__20591__$1 = ((((!((map__20591 == null)))?((((map__20591.cljs$lang$protocol_mask$partition0$ & (64))) || (map__20591.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__20591):map__20591);
var data = cljs.core.get.call(null,map__20591__$1,new cljs.core.Keyword(null,"data","data",-232669377));
var repeat_field = cljs.core.get.call(null,map__20591__$1,new cljs.core.Keyword(null,"repeat-field","repeat-field",-2099292535));
var lang = cljs.core.get.call(null,map__20591__$1,new cljs.core.Keyword(null,"lang","lang",-1819677104));
var map__20592 = p__20590;
var map__20592__$1 = ((((!((map__20592 == null)))?((((map__20592.cljs$lang$protocol_mask$partition0$ & (64))) || (map__20592.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__20592):map__20592);
var view = cljs.core.get.call(null,map__20592__$1,new cljs.core.Keyword(null,"view","view",1247994814));

if(typeof hatti.views.record.t_hatti$views$record20595 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRenderState}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IInitState}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.record.t_hatti$views$record20595 = (function (p__20589,owner,p__20590,map__20591,data,repeat_field,lang,map__20592,view,meta20596){
this.p__20589 = p__20589;
this.owner = owner;
this.p__20590 = p__20590;
this.map__20591 = map__20591;
this.data = data;
this.repeat_field = repeat_field;
this.lang = lang;
this.map__20592 = map__20592;
this.view = view;
this.meta20596 = meta20596;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.record.t_hatti$views$record20595.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (map__20591,map__20591__$1,data,repeat_field,lang,map__20592,map__20592__$1,view){
return (function (_20597,meta20596__$1){
var self__ = this;
var _20597__$1 = this;
return (new hatti.views.record.t_hatti$views$record20595(self__.p__20589,self__.owner,self__.p__20590,self__.map__20591,self__.data,self__.repeat_field,self__.lang,self__.map__20592,self__.view,meta20596__$1));
});})(map__20591,map__20591__$1,data,repeat_field,lang,map__20592,map__20592__$1,view))
;

hatti.views.record.t_hatti$views$record20595.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (map__20591,map__20591__$1,data,repeat_field,lang,map__20592,map__20592__$1,view){
return (function (_20597){
var self__ = this;
var _20597__$1 = this;
return self__.meta20596;
});})(map__20591,map__20591__$1,data,repeat_field,lang,map__20592,map__20592__$1,view))
;

hatti.views.record.t_hatti$views$record20595.prototype.om$core$IInitState$ = true;

hatti.views.record.t_hatti$views$record20595.prototype.om$core$IInitState$init_state$arity$1 = ((function (map__20591,map__20591__$1,data,repeat_field,lang,map__20592,map__20592__$1,view){
return (function (_){
var self__ = this;
var ___$1 = this;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"collapsed?","collapsed?",-1661420674),true], null);
});})(map__20591,map__20591__$1,data,repeat_field,lang,map__20592,map__20592__$1,view))
;

hatti.views.record.t_hatti$views$record20595.prototype.om$core$IRenderState$ = true;

hatti.views.record.t_hatti$views$record20595.prototype.om$core$IRenderState$render_state$arity$2 = ((function (map__20591,map__20591__$1,data,repeat_field,lang,map__20592,map__20592__$1,view){
return (function (_,p__20598){
var self__ = this;
var map__20599 = p__20598;
var map__20599__$1 = ((((!((map__20599 == null)))?((((map__20599.cljs$lang$protocol_mask$partition0$ & (64))) || (map__20599.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__20599):map__20599);
var collapsed_QMARK_ = cljs.core.get.call(null,map__20599__$1,new cljs.core.Keyword(null,"collapsed?","collapsed?",-1661420674));
var ___$1 = this;
if(cljs.core.seq.call(null,self__.data)){
var collapse_BANG_ = ((function (___$1,map__20599,map__20599__$1,collapsed_QMARK_,map__20591,map__20591__$1,data,repeat_field,lang,map__20592,map__20592__$1,view){
return (function (p1__20588_SHARP_){
return om.core.set_state_BANG_.call(null,self__.owner,new cljs.core.Keyword(null,"collapsed?","collapsed?",-1661420674),p1__20588_SHARP_);
});})(___$1,map__20599,map__20599__$1,collapsed_QMARK_,map__20591,map__20591__$1,data,repeat_field,lang,map__20592,map__20592__$1,view))
;
var map__20601 = hatti.views.record.qa_elements.call(null,self__.view);
var map__20601__$1 = ((((!((map__20601 == null)))?((((map__20601.cljs$lang$protocol_mask$partition0$ & (64))) || (map__20601.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__20601):map__20601);
var row_el = cljs.core.get.call(null,map__20601__$1,new cljs.core.Keyword(null,"row-el","row-el",-1433801362));
var question_el = cljs.core.get.call(null,map__20601__$1,new cljs.core.Keyword(null,"question-el","question-el",-572061899));
var answer_el = cljs.core.get.call(null,map__20601__$1,new cljs.core.Keyword(null,"answer-el","answer-el",-306379371));
var header = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [row_el,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [question_el,hatti.ona.forms.get_label.call(null,self__.repeat_field,self__.lang)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [answer_el,[cljs.core.str(hatti.utils.pluralize_number.call(null,cljs.core.count.call(null,self__.data)," Repeat")),cljs.core.str(" - ")].join(''),(cljs.core.truth_(collapsed_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"on-click","on-click",1632826543),hatti.utils.click_fn.call(null,((function (collapse_BANG_,map__20601,map__20601__$1,row_el,question_el,answer_el,___$1,map__20599,map__20599__$1,collapsed_QMARK_,map__20591,map__20591__$1,data,repeat_field,lang,map__20592,map__20592__$1,view){
return (function (){
return collapse_BANG_.call(null,false);
});})(collapse_BANG_,map__20601,map__20601__$1,row_el,question_el,answer_el,___$1,map__20599,map__20599__$1,collapsed_QMARK_,map__20591,map__20591__$1,data,repeat_field,lang,map__20592,map__20592__$1,view))
),new cljs.core.Keyword(null,"href","href",-793805698),"#"], null),"Show Repeats"], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"on-click","on-click",1632826543),hatti.utils.click_fn.call(null,((function (collapse_BANG_,map__20601,map__20601__$1,row_el,question_el,answer_el,___$1,map__20599,map__20599__$1,collapsed_QMARK_,map__20591,map__20591__$1,data,repeat_field,lang,map__20592,map__20592__$1,view){
return (function (){
return collapse_BANG_.call(null,true);
});})(collapse_BANG_,map__20601,map__20601__$1,row_el,question_el,answer_el,___$1,map__20599,map__20599__$1,collapsed_QMARK_,map__20591,map__20591__$1,data,repeat_field,lang,map__20592,map__20592__$1,view))
),new cljs.core.Keyword(null,"href","href",-793805698),"#"], null),"Hide Repeats"], null))], null)], null);
var fname = new cljs.core.Keyword(null,"full-name","full-name",408178550).cljs$core$IFn$_invoke$arity$1(self__.repeat_field);
var render_child = ((function (collapse_BANG_,map__20601,map__20601__$1,row_el,question_el,answer_el,header,fname,___$1,map__20599,map__20599__$1,collapsed_QMARK_,map__20591,map__20591__$1,data,repeat_field,lang,map__20592,map__20592__$1,view){
return (function (d){
var iter__7189__auto__ = ((function (collapse_BANG_,map__20601,map__20601__$1,row_el,question_el,answer_el,header,fname,___$1,map__20599,map__20599__$1,collapsed_QMARK_,map__20591,map__20591__$1,data,repeat_field,lang,map__20592,map__20592__$1,view){
return (function hatti$views$record$iter__20603(s__20604){
return (new cljs.core.LazySeq(null,((function (collapse_BANG_,map__20601,map__20601__$1,row_el,question_el,answer_el,header,fname,___$1,map__20599,map__20599__$1,collapsed_QMARK_,map__20591,map__20591__$1,data,repeat_field,lang,map__20592,map__20592__$1,view){
return (function (){
var s__20604__$1 = s__20604;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__20604__$1);
if(temp__4657__auto__){
var s__20604__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__20604__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__20604__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__20606 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__20605 = (0);
while(true){
if((i__20605 < size__7188__auto__)){
var field = cljs.core._nth.call(null,c__7187__auto__,i__20605);
cljs.core.chunk_append.call(null,b__20606,hatti.views.record.format_as_question_answer.call(null,self__.view,field,d,self__.lang));

var G__20616 = (i__20605 + (1));
i__20605 = G__20616;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20606),hatti$views$record$iter__20603.call(null,cljs.core.chunk_rest.call(null,s__20604__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20606),null);
}
} else {
var field = cljs.core.first.call(null,s__20604__$2);
return cljs.core.cons.call(null,hatti.views.record.format_as_question_answer.call(null,self__.view,field,d,self__.lang),hatti$views$record$iter__20603.call(null,cljs.core.rest.call(null,s__20604__$2)));
}
} else {
return null;
}
break;
}
});})(collapse_BANG_,map__20601,map__20601__$1,row_el,question_el,answer_el,header,fname,___$1,map__20599,map__20599__$1,collapsed_QMARK_,map__20591,map__20591__$1,data,repeat_field,lang,map__20592,map__20592__$1,view))
,null,null));
});})(collapse_BANG_,map__20601,map__20601__$1,row_el,question_el,answer_el,header,fname,___$1,map__20599,map__20599__$1,collapsed_QMARK_,map__20591,map__20591__$1,data,repeat_field,lang,map__20592,map__20592__$1,view))
;
return iter__7189__auto__.call(null,new cljs.core.Keyword(null,"children","children",-940561982).cljs$core$IFn$_invoke$arity$1(self__.repeat_field));
});})(collapse_BANG_,map__20601,map__20601__$1,row_el,question_el,answer_el,header,fname,___$1,map__20599,map__20599__$1,collapsed_QMARK_,map__20591,map__20591__$1,data,repeat_field,lang,map__20592,map__20592__$1,view))
;
var tbl = ((function (collapse_BANG_,map__20601,map__20601__$1,row_el,question_el,answer_el,header,fname,render_child,___$1,map__20599,map__20599__$1,collapsed_QMARK_,map__20591,map__20591__$1,data,repeat_field,lang,map__20592,map__20592__$1,view){
return (function() { 
var G__20617__delegate = function (cls,body){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"tr","tr",-1424774646),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),cls], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"td.no-pad","td.no-pad",1626503288),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"col-span","col-span",-232603210),(2)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"table","table",-564943036),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),cls], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"tbody","tbody",-80678300),body], null)], null)], null)], null);
};
var G__20617 = function (cls,var_args){
var body = null;
if (arguments.length > 1) {
var G__20618__i = 0, G__20618__a = new Array(arguments.length -  1);
while (G__20618__i < G__20618__a.length) {G__20618__a[G__20618__i] = arguments[G__20618__i + 1]; ++G__20618__i;}
  body = new cljs.core.IndexedSeq(G__20618__a,0);
} 
return G__20617__delegate.call(this,cls,body);};
G__20617.cljs$lang$maxFixedArity = 1;
G__20617.cljs$lang$applyTo = (function (arglist__20619){
var cls = cljs.core.first(arglist__20619);
var body = cljs.core.rest(arglist__20619);
return G__20617__delegate(cls,body);
});
G__20617.cljs$core$IFn$_invoke$arity$variadic = G__20617__delegate;
return G__20617;
})()
;})(collapse_BANG_,map__20601,map__20601__$1,row_el,question_el,answer_el,header,fname,render_child,___$1,map__20599,map__20599__$1,collapsed_QMARK_,map__20591,map__20591__$1,data,repeat_field,lang,map__20592,map__20592__$1,view))
;
if(cljs.core.truth_(collapsed_QMARK_)){
return sablono.interpreter.interpret.call(null,header);
} else {
return sablono.interpreter.interpret.call(null,(function (){var G__20607 = (((self__.view instanceof cljs.core.Keyword))?self__.view.fqn:null);
switch (G__20607) {
case "map":
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.repeat-block","div.repeat-block",500963170),header,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ol.repeat","ol.repeat",-1422933218),(function (){var iter__7189__auto__ = ((function (G__20607,collapse_BANG_,map__20601,map__20601__$1,row_el,question_el,answer_el,header,fname,render_child,tbl,___$1,map__20599,map__20599__$1,collapsed_QMARK_,map__20591,map__20591__$1,data,repeat_field,lang,map__20592,map__20592__$1,view){
return (function hatti$views$record$iter__20608(s__20609){
return (new cljs.core.LazySeq(null,((function (G__20607,collapse_BANG_,map__20601,map__20601__$1,row_el,question_el,answer_el,header,fname,render_child,tbl,___$1,map__20599,map__20599__$1,collapsed_QMARK_,map__20591,map__20591__$1,data,repeat_field,lang,map__20592,map__20592__$1,view){
return (function (){
var s__20609__$1 = s__20609;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__20609__$1);
if(temp__4657__auto__){
var s__20609__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__20609__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__20609__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__20611 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__20610 = (0);
while(true){
if((i__20610 < size__7188__auto__)){
var d = cljs.core._nth.call(null,c__7187__auto__,i__20610);
cljs.core.chunk_append.call(null,b__20611,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),render_child.call(null,d)], null));

var G__20621 = (i__20610 + (1));
i__20610 = G__20621;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20611),hatti$views$record$iter__20608.call(null,cljs.core.chunk_rest.call(null,s__20609__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20611),null);
}
} else {
var d = cljs.core.first.call(null,s__20609__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),render_child.call(null,d)], null),hatti$views$record$iter__20608.call(null,cljs.core.rest.call(null,s__20609__$2)));
}
} else {
return null;
}
break;
}
});})(G__20607,collapse_BANG_,map__20601,map__20601__$1,row_el,question_el,answer_el,header,fname,render_child,tbl,___$1,map__20599,map__20599__$1,collapsed_QMARK_,map__20591,map__20591__$1,data,repeat_field,lang,map__20592,map__20592__$1,view))
,null,null));
});})(G__20607,collapse_BANG_,map__20601,map__20601__$1,row_el,question_el,answer_el,header,fname,render_child,tbl,___$1,map__20599,map__20599__$1,collapsed_QMARK_,map__20591,map__20591__$1,data,repeat_field,lang,map__20592,map__20592__$1,view))
;
return iter__7189__auto__.call(null,self__.data);
})()], null)], null);

break;
case "table":
return tbl.call(null,"repeat-block",header,(function (){var iter__7189__auto__ = ((function (G__20607,collapse_BANG_,map__20601,map__20601__$1,row_el,question_el,answer_el,header,fname,render_child,tbl,___$1,map__20599,map__20599__$1,collapsed_QMARK_,map__20591,map__20591__$1,data,repeat_field,lang,map__20592,map__20592__$1,view){
return (function hatti$views$record$iter__20612(s__20613){
return (new cljs.core.LazySeq(null,((function (G__20607,collapse_BANG_,map__20601,map__20601__$1,row_el,question_el,answer_el,header,fname,render_child,tbl,___$1,map__20599,map__20599__$1,collapsed_QMARK_,map__20591,map__20591__$1,data,repeat_field,lang,map__20592,map__20592__$1,view){
return (function (){
var s__20613__$1 = s__20613;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__20613__$1);
if(temp__4657__auto__){
var s__20613__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__20613__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__20613__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__20615 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__20614 = (0);
while(true){
if((i__20614 < size__7188__auto__)){
var d = cljs.core._nth.call(null,c__7187__auto__,i__20614);
cljs.core.chunk_append.call(null,b__20615,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"tbody.repeat","tbody.repeat",575514719),render_child.call(null,d)], null));

var G__20622 = (i__20614 + (1));
i__20614 = G__20622;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20615),hatti$views$record$iter__20612.call(null,cljs.core.chunk_rest.call(null,s__20613__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20615),null);
}
} else {
var d = cljs.core.first.call(null,s__20613__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"tbody.repeat","tbody.repeat",575514719),render_child.call(null,d)], null),hatti$views$record$iter__20612.call(null,cljs.core.rest.call(null,s__20613__$2)));
}
} else {
return null;
}
break;
}
});})(G__20607,collapse_BANG_,map__20601,map__20601__$1,row_el,question_el,answer_el,header,fname,render_child,tbl,___$1,map__20599,map__20599__$1,collapsed_QMARK_,map__20591,map__20591__$1,data,repeat_field,lang,map__20592,map__20592__$1,view))
,null,null));
});})(G__20607,collapse_BANG_,map__20601,map__20601__$1,row_el,question_el,answer_el,header,fname,render_child,tbl,___$1,map__20599,map__20599__$1,collapsed_QMARK_,map__20591,map__20591__$1,data,repeat_field,lang,map__20592,map__20592__$1,view))
;
return iter__7189__auto__.call(null,self__.data);
})());

break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(self__.view)].join('')));

}
})());
}
} else {
return null;
}
});})(map__20591,map__20591__$1,data,repeat_field,lang,map__20592,map__20592__$1,view))
;

hatti.views.record.t_hatti$views$record20595.getBasis = ((function (map__20591,map__20591__$1,data,repeat_field,lang,map__20592,map__20592__$1,view){
return (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p__20589","p__20589",1442585717,null),new cljs.core.Symbol(null,"owner","owner",1247919588,null),new cljs.core.Symbol(null,"p__20590","p__20590",218568499,null),new cljs.core.Symbol(null,"map__20591","map__20591",-956334011,null),new cljs.core.Symbol(null,"data","data",1407862150,null),new cljs.core.Symbol(null,"repeat-field","repeat-field",-458761008,null),new cljs.core.Symbol(null,"lang","lang",-179145577,null),new cljs.core.Symbol(null,"map__20592","map__20592",463484011,null),new cljs.core.Symbol(null,"view","view",-1406440955,null),new cljs.core.Symbol(null,"meta20596","meta20596",1447824104,null)], null);
});})(map__20591,map__20591__$1,data,repeat_field,lang,map__20592,map__20592__$1,view))
;

hatti.views.record.t_hatti$views$record20595.cljs$lang$type = true;

hatti.views.record.t_hatti$views$record20595.cljs$lang$ctorStr = "hatti.views.record/t_hatti$views$record20595";

hatti.views.record.t_hatti$views$record20595.cljs$lang$ctorPrWriter = ((function (map__20591,map__20591__$1,data,repeat_field,lang,map__20592,map__20592__$1,view){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"hatti.views.record/t_hatti$views$record20595");
});})(map__20591,map__20591__$1,data,repeat_field,lang,map__20592,map__20592__$1,view))
;

hatti.views.record.__GT_t_hatti$views$record20595 = ((function (map__20591,map__20591__$1,data,repeat_field,lang,map__20592,map__20592__$1,view){
return (function hatti$views$record$__GT_t_hatti$views$record20595(p__20589__$1,owner__$1,p__20590__$1,map__20591__$2,data__$1,repeat_field__$1,lang__$1,map__20592__$2,view__$1,meta20596){
return (new hatti.views.record.t_hatti$views$record20595(p__20589__$1,owner__$1,p__20590__$1,map__20591__$2,data__$1,repeat_field__$1,lang__$1,map__20592__$2,view__$1,meta20596));
});})(map__20591,map__20591__$1,data,repeat_field,lang,map__20592,map__20592__$1,view))
;

}

return (new hatti.views.record.t_hatti$views$record20595(p__20589,owner,p__20590,map__20591__$1,data,repeat_field,lang,map__20592__$1,view,cljs.core.PersistentArrayMap.EMPTY));
}));
hatti.views.record.header_note = (function hatti$views$record$header_note(view,p__20623){
var map__20626 = p__20623;
var map__20626__$1 = ((((!((map__20626 == null)))?((((map__20626.cljs$lang$protocol_mask$partition0$ & (64))) || (map__20626.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__20626):map__20626);
var geofield = cljs.core.get.call(null,map__20626__$1,new cljs.core.Keyword(null,"geofield","geofield",578715548));
var data = cljs.core.get.call(null,map__20626__$1,new cljs.core.Keyword(null,"data","data",-232669377));
if((cljs.core._EQ_.call(null,view,new cljs.core.Keyword(null,"map","map",1371690461))) && (cljs.core.not.call(null,cljs.core.get.call(null,data,new cljs.core.Keyword(null,"full-name","full-name",408178550).cljs$core$IFn$_invoke$arity$1(geofield))))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span.no-geo.t-normal.right","span.no-geo.t-normal.right",-1340634035),"No geodata"], null);
} else {
return null;
}
});
cljs.core._add_method.call(null,hatti.views.edit_delete,new cljs.core.Keyword(null,"default","default",-1987822328),(function (instance_id,owner,p__20628){
var map__20629 = p__20628;
var map__20629__$1 = ((((!((map__20629 == null)))?((((map__20629.cljs$lang$protocol_mask$partition0$ & (64))) || (map__20629.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__20629):map__20629);
var delete_record_BANG_ = cljs.core.get.call(null,map__20629__$1,new cljs.core.Keyword(null,"delete-record!","delete-record!",1411848194));
if(typeof hatti.views.record.t_hatti$views$record20631 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.record.t_hatti$views$record20631 = (function (instance_id,owner,p__20628,map__20629,delete_record_BANG_,meta20632){
this.instance_id = instance_id;
this.owner = owner;
this.p__20628 = p__20628;
this.map__20629 = map__20629;
this.delete_record_BANG_ = delete_record_BANG_;
this.meta20632 = meta20632;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.record.t_hatti$views$record20631.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (map__20629,map__20629__$1,delete_record_BANG_){
return (function (_20633,meta20632__$1){
var self__ = this;
var _20633__$1 = this;
return (new hatti.views.record.t_hatti$views$record20631(self__.instance_id,self__.owner,self__.p__20628,self__.map__20629,self__.delete_record_BANG_,meta20632__$1));
});})(map__20629,map__20629__$1,delete_record_BANG_))
;

hatti.views.record.t_hatti$views$record20631.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (map__20629,map__20629__$1,delete_record_BANG_){
return (function (_20633){
var self__ = this;
var _20633__$1 = this;
return self__.meta20632;
});})(map__20629,map__20629__$1,delete_record_BANG_))
;

hatti.views.record.t_hatti$views$record20631.prototype.om$core$IRender$ = true;

hatti.views.record.t_hatti$views$record20631.prototype.om$core$IRender$render$arity$1 = ((function (map__20629,map__20629__$1,delete_record_BANG_){
return (function (this__16392__auto__){
var self__ = this;
var this__16392__auto____$1 = this;
return null;
});})(map__20629,map__20629__$1,delete_record_BANG_))
;

hatti.views.record.t_hatti$views$record20631.getBasis = ((function (map__20629,map__20629__$1,delete_record_BANG_){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"instance-id","instance-id",-1703074506,null),new cljs.core.Symbol(null,"owner","owner",1247919588,null),new cljs.core.Symbol(null,"p__20628","p__20628",1686019835,null),new cljs.core.Symbol(null,"map__20629","map__20629",-1219967370,null),new cljs.core.Symbol(null,"delete-record!","delete-record!",-1242587575,null),new cljs.core.Symbol(null,"meta20632","meta20632",-2083073414,null)], null);
});})(map__20629,map__20629__$1,delete_record_BANG_))
;

hatti.views.record.t_hatti$views$record20631.cljs$lang$type = true;

hatti.views.record.t_hatti$views$record20631.cljs$lang$ctorStr = "hatti.views.record/t_hatti$views$record20631";

hatti.views.record.t_hatti$views$record20631.cljs$lang$ctorPrWriter = ((function (map__20629,map__20629__$1,delete_record_BANG_){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"hatti.views.record/t_hatti$views$record20631");
});})(map__20629,map__20629__$1,delete_record_BANG_))
;

hatti.views.record.__GT_t_hatti$views$record20631 = ((function (map__20629,map__20629__$1,delete_record_BANG_){
return (function hatti$views$record$__GT_t_hatti$views$record20631(instance_id__$1,owner__$1,p__20628__$1,map__20629__$2,delete_record_BANG___$1,meta20632){
return (new hatti.views.record.t_hatti$views$record20631(instance_id__$1,owner__$1,p__20628__$1,map__20629__$2,delete_record_BANG___$1,meta20632));
});})(map__20629,map__20629__$1,delete_record_BANG_))
;

}

return (new hatti.views.record.t_hatti$views$record20631(instance_id,owner,p__20628,map__20629__$1,delete_record_BANG_,null));
}));
cljs.core._add_method.call(null,hatti.views.submission_view,new cljs.core.Keyword(null,"default","default",-1987822328),(function (cursor,owner,p__20634){
var map__20635 = p__20634;
var map__20635__$1 = ((((!((map__20635 == null)))?((((map__20635.cljs$lang$protocol_mask$partition0$ & (64))) || (map__20635.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__20635):map__20635);
var opts = map__20635__$1;
var view = cljs.core.get.call(null,map__20635__$1,new cljs.core.Keyword(null,"view","view",1247994814));
if(typeof hatti.views.record.t_hatti$views$record20637 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRenderState}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IInitState}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.record.t_hatti$views$record20637 = (function (cursor,owner,p__20634,map__20635,opts,view,meta20638){
this.cursor = cursor;
this.owner = owner;
this.p__20634 = p__20634;
this.map__20635 = map__20635;
this.opts = opts;
this.view = view;
this.meta20638 = meta20638;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.record.t_hatti$views$record20637.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (map__20635,map__20635__$1,opts,view){
return (function (_20639,meta20638__$1){
var self__ = this;
var _20639__$1 = this;
return (new hatti.views.record.t_hatti$views$record20637(self__.cursor,self__.owner,self__.p__20634,self__.map__20635,self__.opts,self__.view,meta20638__$1));
});})(map__20635,map__20635__$1,opts,view))
;

hatti.views.record.t_hatti$views$record20637.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (map__20635,map__20635__$1,opts,view){
return (function (_20639){
var self__ = this;
var _20639__$1 = this;
return self__.meta20638;
});})(map__20635,map__20635__$1,opts,view))
;

hatti.views.record.t_hatti$views$record20637.prototype.om$core$IInitState$ = true;

hatti.views.record.t_hatti$views$record20637.prototype.om$core$IInitState$init_state$arity$1 = ((function (map__20635,map__20635__$1,opts,view){
return (function (_){
var self__ = this;
var ___$1 = this;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"expand-meta?","expand-meta?",-1578417082),false], null);
});})(map__20635,map__20635__$1,opts,view))
;

hatti.views.record.t_hatti$views$record20637.prototype.om$core$IRenderState$ = true;

hatti.views.record.t_hatti$views$record20637.prototype.om$core$IRenderState$render_state$arity$2 = ((function (map__20635,map__20635__$1,opts,view){
return (function (_,p__20640){
var self__ = this;
var map__20641 = p__20640;
var map__20641__$1 = ((((!((map__20641 == null)))?((((map__20641.cljs$lang$protocol_mask$partition0$ & (64))) || (map__20641.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__20641):map__20641);
var expand_meta_QMARK_ = cljs.core.get.call(null,map__20641__$1,new cljs.core.Keyword(null,"expand-meta?","expand-meta?",-1578417082));
var ___$1 = this;
var form = om.core.get_shared.call(null,self__.owner,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"flat-form","flat-form",-468858211)], null));
var language = new cljs.core.Keyword(null,"current","current",-1088038603).cljs$core$IFn$_invoke$arity$1(om.core.observe.call(null,self__.owner,hatti.shared.language_cursor.call(null)));
var map__20643 = self__.cursor;
var map__20643__$1 = ((((!((map__20643 == null)))?((((map__20643.cljs$lang$protocol_mask$partition0$ & (64))) || (map__20643.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__20643):map__20643);
var id = cljs.core.get.call(null,map__20643__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var data = cljs.core.get.call(null,map__20643__$1,new cljs.core.Keyword(null,"data","data",-232669377));
var dataset_info = cljs.core.get.call(null,map__20643__$1,new cljs.core.Keyword(null,"dataset-info","dataset-info",-1196999563));
var cur_rank = cljs.core.get.call(null,data,hatti.constants._rank);
var instance_id = cljs.core.get.call(null,data,"_id");
var sdatetime = moment(cljs.core.get.call(null,data,"_submission_time"));
var map__20644 = hatti.views.record.submission_elements.call(null,self__.view);
var map__20644__$1 = ((((!((map__20644 == null)))?((((map__20644.cljs$lang$protocol_mask$partition0$ & (64))) || (map__20644.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__20644):map__20644);
var top_level_wrap = cljs.core.get.call(null,map__20644__$1,new cljs.core.Keyword(null,"top-level-wrap","top-level-wrap",366303456));
var topbar_wrap = cljs.core.get.call(null,map__20644__$1,new cljs.core.Keyword(null,"topbar-wrap","topbar-wrap",1084926998));
var header_wrap = cljs.core.get.call(null,map__20644__$1,new cljs.core.Keyword(null,"header-wrap","header-wrap",517152474));
var section_wrap = cljs.core.get.call(null,map__20644__$1,new cljs.core.Keyword(null,"section-wrap","section-wrap",28486716));
var submission_info_wrap = cljs.core.get.call(null,map__20644__$1,new cljs.core.Keyword(null,"submission-info-wrap","submission-info-wrap",-1360099904));
var h4_cls = cljs.core.get.call(null,map__20644__$1,new cljs.core.Keyword(null,"h4-cls","h4-cls",-1006591520));
return sablono.interpreter.interpret.call(null,(cljs.core.truth_((function (){var or__6409__auto__ = data;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return id;
}
})())?top_level_wrap.call(null,topbar_wrap.call(null,hatti.views.record.submission_arrow.call(null,new cljs.core.Keyword(null,"left","left",-399115937),cur_rank,self__.view),hatti.views.record.submission_arrow.call(null,new cljs.core.Keyword(null,"right","right",-452581833),cur_rank,self__.view),om.core.build.call(null,hatti.views.print_xls_report_btn,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"instance-id","instance-id",951361263),instance_id,new cljs.core.Keyword(null,"dataset-info","dataset-info",-1196999563),dataset_info], null)),hatti.views.record.submission_closer.call(null)),(cljs.core.truth_(data)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),header_wrap.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"h4","h4",2004862993),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),h4_cls], null),[cljs.core.str("Submission "),cljs.core.str(cur_rank)].join(''),hatti.views.record.header_note.call(null,self__.view,self__.cursor)], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"p","p",151049309),[cljs.core.str("Submitted at "),cljs.core.str(sdatetime.format("LT")),cljs.core.str(" on "),cljs.core.str(sdatetime.format("ll"))].join(''),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"br","br",934104792)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),[cljs.core.str("Record ID: "),cljs.core.str(instance_id)].join('')], null),om.core.build.call(null,hatti.views.edit_delete,instance_id,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"opts","opts",155075701),self__.opts], null)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span.expand-meta.right","span.expand-meta.right",1357089760),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"href","href",-793805698),"#",new cljs.core.Keyword(null,"on-click","on-click",1632826543),hatti.utils.click_fn.call(null,((function (form,language,map__20643,map__20643__$1,id,data,dataset_info,cur_rank,instance_id,sdatetime,map__20644,map__20644__$1,top_level_wrap,topbar_wrap,header_wrap,section_wrap,submission_info_wrap,h4_cls,___$1,map__20641,map__20641__$1,expand_meta_QMARK_,map__20635,map__20635__$1,opts,view){
return (function (){
return om.core.update_state_BANG_.call(null,self__.owner,new cljs.core.Keyword(null,"expand-meta?","expand-meta?",-1578417082),cljs.core.not);
});})(form,language,map__20643,map__20643__$1,id,data,dataset_info,cur_rank,instance_id,sdatetime,map__20644,map__20644__$1,top_level_wrap,topbar_wrap,header_wrap,section_wrap,submission_info_wrap,h4_cls,___$1,map__20641,map__20641__$1,expand_meta_QMARK_,map__20635,map__20635__$1,opts,view))
)], null),(cljs.core.truth_(expand_meta_QMARK_)?"Hide Metadata":"Show Metadata")], null)], null)], null)),submission_info_wrap.call(null,(cljs.core.truth_(expand_meta_QMARK_)?section_wrap.call(null,(function (){var iter__7189__auto__ = ((function (form,language,map__20643,map__20643__$1,id,data,dataset_info,cur_rank,instance_id,sdatetime,map__20644,map__20644__$1,top_level_wrap,topbar_wrap,header_wrap,section_wrap,submission_info_wrap,h4_cls,___$1,map__20641,map__20641__$1,expand_meta_QMARK_,map__20635,map__20635__$1,opts,view){
return (function hatti$views$record$iter__20647(s__20648){
return (new cljs.core.LazySeq(null,((function (form,language,map__20643,map__20643__$1,id,data,dataset_info,cur_rank,instance_id,sdatetime,map__20644,map__20644__$1,top_level_wrap,topbar_wrap,header_wrap,section_wrap,submission_info_wrap,h4_cls,___$1,map__20641,map__20641__$1,expand_meta_QMARK_,map__20635,map__20635__$1,opts,view){
return (function (){
var s__20648__$1 = s__20648;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__20648__$1);
if(temp__4657__auto__){
var s__20648__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__20648__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__20648__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__20650 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__20649 = (0);
while(true){
if((i__20649 < size__7188__auto__)){
var q = cljs.core._nth.call(null,c__7187__auto__,i__20649);
cljs.core.chunk_append.call(null,b__20650,hatti.views.record.format_as_question_answer.call(null,self__.view,q,data,language));

var G__20655 = (i__20649 + (1));
i__20649 = G__20655;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20650),hatti$views$record$iter__20647.call(null,cljs.core.chunk_rest.call(null,s__20648__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20650),null);
}
} else {
var q = cljs.core.first.call(null,s__20648__$2);
return cljs.core.cons.call(null,hatti.views.record.format_as_question_answer.call(null,self__.view,q,data,language),hatti$views$record$iter__20647.call(null,cljs.core.rest.call(null,s__20648__$2)));
}
} else {
return null;
}
break;
}
});})(form,language,map__20643,map__20643__$1,id,data,dataset_info,cur_rank,instance_id,sdatetime,map__20644,map__20644__$1,top_level_wrap,topbar_wrap,header_wrap,section_wrap,submission_info_wrap,h4_cls,___$1,map__20641,map__20641__$1,expand_meta_QMARK_,map__20635,map__20635__$1,opts,view))
,null,null));
});})(form,language,map__20643,map__20643__$1,id,data,dataset_info,cur_rank,instance_id,sdatetime,map__20644,map__20644__$1,top_level_wrap,topbar_wrap,header_wrap,section_wrap,submission_info_wrap,h4_cls,___$1,map__20641,map__20641__$1,expand_meta_QMARK_,map__20635,map__20635__$1,opts,view))
;
return iter__7189__auto__.call(null,hatti.ona.forms.meta_fields.call(null,form,new cljs.core.Keyword(null,"with-submission-details?","with-submission-details?",524960549),true));
})()):null),section_wrap.call(null,(function (){var iter__7189__auto__ = ((function (form,language,map__20643,map__20643__$1,id,data,dataset_info,cur_rank,instance_id,sdatetime,map__20644,map__20644__$1,top_level_wrap,topbar_wrap,header_wrap,section_wrap,submission_info_wrap,h4_cls,___$1,map__20641,map__20641__$1,expand_meta_QMARK_,map__20635,map__20635__$1,opts,view){
return (function hatti$views$record$iter__20651(s__20652){
return (new cljs.core.LazySeq(null,((function (form,language,map__20643,map__20643__$1,id,data,dataset_info,cur_rank,instance_id,sdatetime,map__20644,map__20644__$1,top_level_wrap,topbar_wrap,header_wrap,section_wrap,submission_info_wrap,h4_cls,___$1,map__20641,map__20641__$1,expand_meta_QMARK_,map__20635,map__20635__$1,opts,view){
return (function (){
var s__20652__$1 = s__20652;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__20652__$1);
if(temp__4657__auto__){
var s__20652__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__20652__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__20652__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__20654 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__20653 = (0);
while(true){
if((i__20653 < size__7188__auto__)){
var q = cljs.core._nth.call(null,c__7187__auto__,i__20653);
cljs.core.chunk_append.call(null,b__20654,hatti.views.record.format_as_question_answer.call(null,self__.view,q,data,language));

var G__20656 = (i__20653 + (1));
i__20653 = G__20656;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20654),hatti$views$record$iter__20651.call(null,cljs.core.chunk_rest.call(null,s__20652__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20654),null);
}
} else {
var q = cljs.core.first.call(null,s__20652__$2);
return cljs.core.cons.call(null,hatti.views.record.format_as_question_answer.call(null,self__.view,q,data,language),hatti$views$record$iter__20651.call(null,cljs.core.rest.call(null,s__20652__$2)));
}
} else {
return null;
}
break;
}
});})(form,language,map__20643,map__20643__$1,id,data,dataset_info,cur_rank,instance_id,sdatetime,map__20644,map__20644__$1,top_level_wrap,topbar_wrap,header_wrap,section_wrap,submission_info_wrap,h4_cls,___$1,map__20641,map__20641__$1,expand_meta_QMARK_,map__20635,map__20635__$1,opts,view))
,null,null));
});})(form,language,map__20643,map__20643__$1,id,data,dataset_info,cur_rank,instance_id,sdatetime,map__20644,map__20644__$1,top_level_wrap,topbar_wrap,header_wrap,section_wrap,submission_info_wrap,h4_cls,___$1,map__20641,map__20641__$1,expand_meta_QMARK_,map__20635,map__20635__$1,opts,view))
;
return iter__7189__auto__.call(null,hatti.ona.forms.non_meta_fields.call(null,form));
})()))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.t-center","div.t-center",150921790),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"i.fa.fa-spinner.fa-pulse","i.fa.fa-spinner.fa-pulse",869871146)], null),"Loading data..."], null)], null))):null));
});})(map__20635,map__20635__$1,opts,view))
;

hatti.views.record.t_hatti$views$record20637.getBasis = ((function (map__20635,map__20635__$1,opts,view){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"cursor","cursor",-1642498285,null),new cljs.core.Symbol(null,"owner","owner",1247919588,null),new cljs.core.Symbol(null,"p__20634","p__20634",554945440,null),new cljs.core.Symbol(null,"map__20635","map__20635",1760515891,null),new cljs.core.Symbol(null,"opts","opts",1795607228,null),new cljs.core.Symbol(null,"view","view",-1406440955,null),new cljs.core.Symbol(null,"meta20638","meta20638",-1843373817,null)], null);
});})(map__20635,map__20635__$1,opts,view))
;

hatti.views.record.t_hatti$views$record20637.cljs$lang$type = true;

hatti.views.record.t_hatti$views$record20637.cljs$lang$ctorStr = "hatti.views.record/t_hatti$views$record20637";

hatti.views.record.t_hatti$views$record20637.cljs$lang$ctorPrWriter = ((function (map__20635,map__20635__$1,opts,view){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"hatti.views.record/t_hatti$views$record20637");
});})(map__20635,map__20635__$1,opts,view))
;

hatti.views.record.__GT_t_hatti$views$record20637 = ((function (map__20635,map__20635__$1,opts,view){
return (function hatti$views$record$__GT_t_hatti$views$record20637(cursor__$1,owner__$1,p__20634__$1,map__20635__$2,opts__$1,view__$1,meta20638){
return (new hatti.views.record.t_hatti$views$record20637(cursor__$1,owner__$1,p__20634__$1,map__20635__$2,opts__$1,view__$1,meta20638));
});})(map__20635,map__20635__$1,opts,view))
;

}

return (new hatti.views.record.t_hatti$views$record20637(cursor,owner,p__20634,map__20635__$1,opts,view,cljs.core.PersistentArrayMap.EMPTY));
}));
