// Compiled by ClojureScript 1.9.229 {:static-fns true, :optimize-constants true}
goog.provide('hatti.views.table');
goog.require('cljs.core');
goog.require('hatti.views.record');
goog.require('chimera.js_interop');
goog.require('om.dom');
goog.require('hatti.ona.forms');
goog.require('sablono.core');
goog.require('cljs.core.async');
goog.require('chimera.seq');
goog.require('hatti.shared');
goog.require('hatti.constants');
goog.require('hatti.views');
goog.require('om.core');
goog.require('hatti.utils');
goog.require('chimera.core');
goog.require('chimera.urls');
hatti.views.table.default_num_displayed_records = (25);
hatti.views.table.table_id = "submission-grid";
hatti.views.table.pager_id = "pager";
/**
 * Extra fields that will be displayed on the table.
 */
hatti.views.table.get_extra_fields = (function hatti$views$table$get_extra_fields(is_filtered_dataview_QMARK_){
var extra_field = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$full_DASH_name,hatti.constants._id,cljs.core.cst$kw$label,"id",cljs.core.cst$kw$name,hatti.constants._id,cljs.core.cst$kw$type,"integer"], null)], null);
if(cljs.core.truth_(is_filtered_dataview_QMARK_)){
return extra_field;
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(extra_field,hatti.ona.forms.submission_time_field);
}
});
/**
 * Given a (flat-)form, returns fields for table display.
 * Puts extra fields in the beginning, metadata at the end of the table,
 * and drops fields that have no data (eg. group/note).
 */
hatti.views.table.all_fields = (function hatti$views$table$all_fields(var_args){
var args__7491__auto__ = [];
var len__7484__auto___34397 = arguments.length;
var i__7485__auto___34398 = (0);
while(true){
if((i__7485__auto___34398 < len__7484__auto___34397)){
args__7491__auto__.push((arguments[i__7485__auto___34398]));

var G__34399 = (i__7485__auto___34398 + (1));
i__7485__auto___34398 = G__34399;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return hatti.views.table.all_fields.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

hatti.views.table.all_fields.cljs$core$IFn$_invoke$arity$variadic = (function (form,p__34394){
var map__34395 = p__34394;
var map__34395__$1 = ((((!((map__34395 == null)))?((((map__34395.cljs$lang$protocol_mask$partition0$ & (64))) || (map__34395.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__34395):map__34395);
var is_filtered_dataview_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34395__$1,cljs.core.cst$kw$is_DASH_filtered_DASH_dataview_QMARK_);
return cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.has_data_QMARK_,cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic(hatti.views.table.get_extra_fields(is_filtered_dataview_QMARK_),hatti.ona.forms.non_meta_fields(form),cljs.core.array_seq([hatti.ona.forms.meta_fields.cljs$core$IFn$_invoke$arity$variadic(form,cljs.core.array_seq([cljs.core.cst$kw$with_DASH_submission_DASH_details_QMARK_,cljs.core.not(is_filtered_dataview_QMARK_)], 0))], 0))));
});

hatti.views.table.all_fields.cljs$lang$maxFixedArity = (1);

hatti.views.table.all_fields.cljs$lang$applyTo = (function (seq34392){
var G__34393 = cljs.core.first(seq34392);
var seq34392__$1 = cljs.core.next(seq34392);
return hatti.views.table.all_fields.cljs$core$IFn$_invoke$arity$variadic(G__34393,seq34392__$1);
});

/**
 * Comparator function for the slickgrid dataview.
 * args.sortCol is the column being sorted, a and b are rows to compare.
 * Claims a is bigger (return 1) if value for a > b, or a is null / empty.
 */
hatti.views.table.compfn = (function hatti$views$table$compfn(args){
return (function (a,b){
var col = (args["sortCol"]);
var lower = ((function (col){
return (function (p1__34400_SHARP_){
if(typeof p1__34400_SHARP_ === 'string'){
return clojure.string.lower_case(p1__34400_SHARP_);
} else {
return p1__34400_SHARP_;
}
});})(col))
;
var aval = lower((a[(col["field"])]));
var bval = lower((b[(col["field"])]));
if(((aval == null)) || ((aval > bval))){
return (1);
} else {
return (-1);
}
});
});
/**
 * Filter function for the slickgrid dataview, use as (partial filterfn form)
 * item is the row, args contains query.
 * Return value of false corresponds with exclusion, true with inclusion.
 */
hatti.views.table.filterfn = (function hatti$views$table$filterfn(form,item,args){
if(cljs.core.not(args)){
return true;
} else {
var indexed_form = cljs.core.zipmap(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$full_DASH_name,form),form);
var query = (args["query"]);
var fmt_subitem = ((function (indexed_form,query){
return (function (p__34406){
var vec__34407 = p__34406;
var fname = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34407,(0),null);
var answer = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34407,(1),null);
return hatti.ona.forms.format_answer.cljs$core$IFn$_invoke$arity$4(cljs.core.get.cljs$core$IFn$_invoke$arity$2(indexed_form,fname),answer,null,true);
});})(indexed_form,query))
;
var filtered = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (indexed_form,query,fmt_subitem){
return (function (p1__34401_SHARP_){
return cljs.core.re_find(chimera.js_interop.safe_regex(query),[cljs.core.str(p1__34401_SHARP_)].join(''));
});})(indexed_form,query,fmt_subitem))
,cljs.core.map.cljs$core$IFn$_invoke$arity$2(fmt_subitem,cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$1(item))));
return cljs.core.seq(filtered);
}
});
/**
 * Formatter for slickgrid columns takes row,cell,value,columnDef,dataContext.
 * Get one with (partial formatter field language).
 */
hatti.views.table.formatter = (function hatti$views$table$formatter(field,language,row,cell,value,columnDef,dataContext){
var clj_value = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(value,cljs.core.array_seq([cljs.core.cst$kw$keywordize_DASH_keys,true], 0));
return hatti.ona.forms.format_answer.cljs$core$IFn$_invoke$arity$4(field,clj_value,language,true);
});
hatti.views.action_buttons.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (owner){
return (function (row,cell,value,columnDef,dataContext){
var map__34410 = cljs.core.cst$kw$dataset_DASH_info.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.shared.app_state) : cljs.core.deref.call(null,hatti.shared.app_state)));
var map__34410__$1 = ((((!((map__34410 == null)))?((((map__34410.cljs$lang$protocol_mask$partition0$ & (64))) || (map__34410.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__34410):map__34410);
var owner__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34410__$1,cljs.core.cst$kw$owner);
var project = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34410__$1,cljs.core.cst$kw$project);
var formid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34410__$1,cljs.core.cst$kw$formid);
var form_owner = chimera.urls.last_url_param(owner__$1);
var project_id = chimera.urls.last_url_param(project);
var edit_link = chimera.urls.url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([form_owner,project_id,formid,[cljs.core.str("webform?instance-id="),cljs.core.str(value)].join('')], 0));
return hatti.utils.generate_html.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([(cljs.core.truth_(value)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$ul,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li$tooltip,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$tip_DASH_info$right,"View"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a$view_DASH_record,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$i$fa$fa_DASH_clone,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$data_DASH_id,value], null)], null)], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li$tooltip,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$tip_DASH_info$right,"Edit"], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a$edit_DASH_record,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$data_DASH_id,value,cljs.core.cst$kw$target,"_blank",cljs.core.cst$kw$href,edit_link], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$i$fa$fa_DASH_pencil_DASH_square_DASH_o], null)], null)], null)], null):null)], 0));
});
}));
/**
 * The html needed for a column name as a string.
 * String, String, Bool -> String
 */
hatti.views.table.column_name_html_string = (function hatti$views$table$column_name_html_string(column_class,label,hxl){
return [cljs.core.str("<div class=\""),cljs.core.str(column_class),cljs.core.str("\">"),cljs.core.str(label),cljs.core.str("</div>"),cljs.core.str((cljs.core.truth_(hxl)?[cljs.core.str("<div class=\"hxl-row\">"),cljs.core.str(hxl),cljs.core.str("</div>")].join(''):null))].join('');
});
hatti.views.table.actions_column = (function hatti$views$table$actions_column(owner,has_hxl_QMARK_){
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$headerCssClass,cljs.core.cst$kw$maxWidth,cljs.core.cst$kw$name,cljs.core.cst$kw$formatter,cljs.core.cst$kw$field,cljs.core.cst$kw$type,cljs.core.cst$kw$id,cljs.core.cst$kw$sortable,cljs.core.cst$kw$cssClass,cljs.core.cst$kw$toolTip],[[cljs.core.str((cljs.core.truth_(has_hxl_QMARK_)?"hxl-min-height ":null)),cljs.core.str("record-actions header")].join(''),(70),"",(hatti.views.action_buttons.cljs$core$IFn$_invoke$arity$1 ? hatti.views.action_buttons.cljs$core$IFn$_invoke$arity$1(owner) : hatti.views.action_buttons.call(null,owner)),hatti.constants._id,"text","actions",false,"record-actions",""]);
});
/**
 * Get a set of slick grid column objects when given a flat form.
 */
hatti.views.table.flat_form__GT_sg_columns = (function hatti$views$table$flat_form__GT_sg_columns(var_args){
var args34413 = [];
var len__7484__auto___34447 = arguments.length;
var i__7485__auto___34448 = (0);
while(true){
if((i__7485__auto___34448 < len__7484__auto___34447)){
args34413.push((arguments[i__7485__auto___34448]));

var G__34449 = (i__7485__auto___34448 + (1));
i__7485__auto___34448 = G__34449;
continue;
} else {
}
break;
}

var G__34419 = args34413.length;
switch (G__34419) {
case 1:
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__7503__auto__ = (new cljs.core.IndexedSeq(args34413.slice((3)),(0),null));
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7503__auto__);

}
});

hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$1 = (function (form){
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$2(form,true);
});

hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$2 = (function (form,get_label_QMARK_){
return hatti.views.table.flat_form__GT_sg_columns(form,get_label_QMARK_,null);
});

hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic = (function (form,get_label_QMARK_,language,p__34420){
var map__34421 = p__34420;
var map__34421__$1 = ((((!((map__34421 == null)))?((((map__34421.cljs$lang$protocol_mask$partition0$ & (64))) || (map__34421.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__34421):map__34421);
var is_filtered_dataview_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34421__$1,cljs.core.cst$kw$is_DASH_filtered_DASH_dataview_QMARK_);
var owner = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34421__$1,cljs.core.cst$kw$owner);
var has_hxl_QMARK_ = (function (){var G__34423 = cljs.core.false_QMARK_;
var G__34424 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (G__34423,map__34421,map__34421__$1,is_filtered_dataview_QMARK_,owner){
return (function (p1__34412_SHARP_){
return (cljs.core.cst$kw$hxl.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$instance.cljs$core$IFn$_invoke$arity$1(p1__34412_SHARP_)) == null);
});})(G__34423,map__34421,map__34421__$1,is_filtered_dataview_QMARK_,owner))
,form);
return (chimera.core.any_QMARK_.cljs$core$IFn$_invoke$arity$2 ? chimera.core.any_QMARK_.cljs$core$IFn$_invoke$arity$2(G__34423,G__34424) : chimera.core.any_QMARK_.call(null,G__34423,G__34424));
})();
var columns = (function (){var iter__7189__auto__ = ((function (has_hxl_QMARK_,map__34421,map__34421__$1,is_filtered_dataview_QMARK_,owner){
return (function hatti$views$table$iter__34425(s__34426){
return (new cljs.core.LazySeq(null,((function (has_hxl_QMARK_,map__34421,map__34421__$1,is_filtered_dataview_QMARK_,owner){
return (function (){
var s__34426__$1 = s__34426;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__34426__$1);
if(temp__4657__auto__){
var s__34426__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__34426__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__34426__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__34428 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__34427 = (0);
while(true){
if((i__34427 < size__7188__auto__)){
var field = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__34427);
cljs.core.chunk_append(b__34428,(function (){var map__34439 = field;
var map__34439__$1 = ((((!((map__34439 == null)))?((((map__34439.cljs$lang$protocol_mask$partition0$ & (64))) || (map__34439.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__34439):map__34439);
var map__34440 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34439__$1,cljs.core.cst$kw$instance);
var map__34440__$1 = ((((!((map__34440 == null)))?((((map__34440.cljs$lang$protocol_mask$partition0$ & (64))) || (map__34440.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__34440):map__34440);
var hxl = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34440__$1,cljs.core.cst$kw$hxl);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34439__$1,cljs.core.cst$kw$name);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34439__$1,cljs.core.cst$kw$type);
var full_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34439__$1,cljs.core.cst$kw$full_DASH_name);
var label = (cljs.core.truth_(get_label_QMARK_)?hatti.ona.forms.get_label.cljs$core$IFn$_invoke$arity$variadic(field,cljs.core.array_seq([language], 0)):name);
var column_class = hatti.ona.forms.get_column_class(field);
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$hxl,cljs.core.cst$kw$headerCssClass,cljs.core.cst$kw$name,cljs.core.cst$kw$formatter,cljs.core.cst$kw$minWidth,cljs.core.cst$kw$field,cljs.core.cst$kw$type,cljs.core.cst$kw$id,cljs.core.cst$kw$sortable,cljs.core.cst$kw$cssClass,cljs.core.cst$kw$toolTip],[hxl,(cljs.core.truth_(has_hxl_QMARK_)?"hxl-min-height":null),hatti.views.table.column_name_html_string(column_class,label,hxl),cljs.core.partial.cljs$core$IFn$_invoke$arity$3(hatti.views.table.formatter,field,language),(50),full_name,type,name,true,column_class,label]);
})());

var G__34451 = (i__34427 + (1));
i__34427 = G__34451;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__34428),hatti$views$table$iter__34425(cljs.core.chunk_rest(s__34426__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__34428),null);
}
} else {
var field = cljs.core.first(s__34426__$2);
return cljs.core.cons((function (){var map__34443 = field;
var map__34443__$1 = ((((!((map__34443 == null)))?((((map__34443.cljs$lang$protocol_mask$partition0$ & (64))) || (map__34443.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__34443):map__34443);
var map__34444 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34443__$1,cljs.core.cst$kw$instance);
var map__34444__$1 = ((((!((map__34444 == null)))?((((map__34444.cljs$lang$protocol_mask$partition0$ & (64))) || (map__34444.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__34444):map__34444);
var hxl = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34444__$1,cljs.core.cst$kw$hxl);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34443__$1,cljs.core.cst$kw$name);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34443__$1,cljs.core.cst$kw$type);
var full_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34443__$1,cljs.core.cst$kw$full_DASH_name);
var label = (cljs.core.truth_(get_label_QMARK_)?hatti.ona.forms.get_label.cljs$core$IFn$_invoke$arity$variadic(field,cljs.core.array_seq([language], 0)):name);
var column_class = hatti.ona.forms.get_column_class(field);
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$hxl,cljs.core.cst$kw$headerCssClass,cljs.core.cst$kw$name,cljs.core.cst$kw$formatter,cljs.core.cst$kw$minWidth,cljs.core.cst$kw$field,cljs.core.cst$kw$type,cljs.core.cst$kw$id,cljs.core.cst$kw$sortable,cljs.core.cst$kw$cssClass,cljs.core.cst$kw$toolTip],[hxl,(cljs.core.truth_(has_hxl_QMARK_)?"hxl-min-height":null),hatti.views.table.column_name_html_string(column_class,label,hxl),cljs.core.partial.cljs$core$IFn$_invoke$arity$3(hatti.views.table.formatter,field,language),(50),full_name,type,name,true,column_class,label]);
})(),hatti$views$table$iter__34425(cljs.core.rest(s__34426__$2)));
}
} else {
return null;
}
break;
}
});})(has_hxl_QMARK_,map__34421,map__34421__$1,is_filtered_dataview_QMARK_,owner))
,null,null));
});})(has_hxl_QMARK_,map__34421,map__34421__$1,is_filtered_dataview_QMARK_,owner))
;
return iter__7189__auto__(hatti.views.table.all_fields.cljs$core$IFn$_invoke$arity$variadic(form,cljs.core.array_seq([cljs.core.cst$kw$is_DASH_filtered_DASH_dataview_QMARK_,is_filtered_dataview_QMARK_], 0)));
})();
return cljs.core.clj__GT_js(cljs.core.conj.cljs$core$IFn$_invoke$arity$2(columns,hatti.views.table.actions_column(owner,has_hxl_QMARK_)));
});

hatti.views.table.flat_form__GT_sg_columns.cljs$lang$applyTo = (function (seq34414){
var G__34415 = cljs.core.first(seq34414);
var seq34414__$1 = cljs.core.next(seq34414);
var G__34416 = cljs.core.first(seq34414__$1);
var seq34414__$2 = cljs.core.next(seq34414__$1);
var G__34417 = cljs.core.first(seq34414__$2);
var seq34414__$3 = cljs.core.next(seq34414__$2);
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic(G__34415,G__34416,G__34417,seq34414__$3);
});

hatti.views.table.flat_form__GT_sg_columns.cljs$lang$maxFixedArity = (3);

hatti.views.table.init_sg_pager = (function hatti$views$table$init_sg_pager(grid,dataview){
var Pager = Slick.Controls.Pager;
return (new Pager(dataview,grid,(function (){var G__34453 = [cljs.core.str("#"),cljs.core.str(hatti.views.table.pager_id)].join('');
return jQuery(G__34453);
})()));
});
hatti.views.table.resizeColumns = (function hatti$views$table$resizeColumns(grid){
return grid.registerPlugin(Slick.AutoColumnSize());
});
/**
 * Options to feed the slickgrid constructor.
 */
hatti.views.table.sg_options = ({"autoHeight": true, "enableColumnReorder": false, "enableTextSelectionOnCells": true, "rowHeight": (40), "syncColumnCellResize": false});
/**
 * Fixes the first column on slick table on horizontal scroll
 */
hatti.views.table.freeze_action_column_BANG_ = (function hatti$views$table$freeze_action_column_BANG_(){
var actions = document.getElementsByClassName("record-actions");
var sg_viewport = cljs.core.first(document.getElementsByClassName("slick-viewport"));
var seq__34461 = cljs.core.seq(actions);
var chunk__34462 = null;
var count__34463 = (0);
var i__34464 = (0);
while(true){
if((i__34464 < count__34463)){
var action = chunk__34462.cljs$core$IIndexed$_nth$arity$2(null,i__34464);
var leftOffset_34467 = (function (){var G__34465 = action.offsetLeft;
return parseInt(G__34465);
})();
sg_viewport.addEventListener("scroll",((function (seq__34461,chunk__34462,count__34463,i__34464,leftOffset_34467,action,actions,sg_viewport){
return (function (){
var sl = sg_viewport.scrollLeft;
var set_border_BANG_ = ((function (seq__34461,chunk__34462,count__34463,i__34464,sl,leftOffset_34467,action,actions,sg_viewport){
return (function (p1__34454_SHARP_){
return action.style.borderRight = p1__34454_SHARP_;
});})(seq__34461,chunk__34462,count__34463,i__34464,sl,leftOffset_34467,action,actions,sg_viewport))
;
if((sl === (0))){
set_border_BANG_("1px dotted #ededed");
} else {
set_border_BANG_("1px solid silver");
}

return action.style.left = [cljs.core.str((sl + leftOffset_34467)),cljs.core.str("px")].join('');
});})(seq__34461,chunk__34462,count__34463,i__34464,leftOffset_34467,action,actions,sg_viewport))
);

var G__34468 = seq__34461;
var G__34469 = chunk__34462;
var G__34470 = count__34463;
var G__34471 = (i__34464 + (1));
seq__34461 = G__34468;
chunk__34462 = G__34469;
count__34463 = G__34470;
i__34464 = G__34471;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq(seq__34461);
if(temp__4657__auto__){
var seq__34461__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__34461__$1)){
var c__7220__auto__ = cljs.core.chunk_first(seq__34461__$1);
var G__34472 = cljs.core.chunk_rest(seq__34461__$1);
var G__34473 = c__7220__auto__;
var G__34474 = cljs.core.count(c__7220__auto__);
var G__34475 = (0);
seq__34461 = G__34472;
chunk__34462 = G__34473;
count__34463 = G__34474;
i__34464 = G__34475;
continue;
} else {
var action = cljs.core.first(seq__34461__$1);
var leftOffset_34476 = (function (){var G__34466 = action.offsetLeft;
return parseInt(G__34466);
})();
sg_viewport.addEventListener("scroll",((function (seq__34461,chunk__34462,count__34463,i__34464,leftOffset_34476,action,seq__34461__$1,temp__4657__auto__,actions,sg_viewport){
return (function (){
var sl = sg_viewport.scrollLeft;
var set_border_BANG_ = ((function (seq__34461,chunk__34462,count__34463,i__34464,sl,leftOffset_34476,action,seq__34461__$1,temp__4657__auto__,actions,sg_viewport){
return (function (p1__34454_SHARP_){
return action.style.borderRight = p1__34454_SHARP_;
});})(seq__34461,chunk__34462,count__34463,i__34464,sl,leftOffset_34476,action,seq__34461__$1,temp__4657__auto__,actions,sg_viewport))
;
if((sl === (0))){
set_border_BANG_("1px dotted #ededed");
} else {
set_border_BANG_("1px solid silver");
}

return action.style.left = [cljs.core.str((sl + leftOffset_34476)),cljs.core.str("px")].join('');
});})(seq__34461,chunk__34462,count__34463,i__34464,leftOffset_34476,action,seq__34461__$1,temp__4657__auto__,actions,sg_viewport))
);

var G__34477 = cljs.core.next(seq__34461__$1);
var G__34478 = null;
var G__34479 = (0);
var G__34480 = (0);
seq__34461 = G__34477;
chunk__34462 = G__34478;
count__34463 = G__34479;
i__34464 = G__34480;
continue;
}
} else {
return null;
}
}
break;
}
});
hatti.views.table.bind_external_sg_grid_event_handlers = (function hatti$views$table$bind_external_sg_grid_event_handlers(grid,event_handlers){
return cljs.core.doall.cljs$core$IFn$_invoke$arity$1((function (){var iter__7189__auto__ = (function hatti$views$table$bind_external_sg_grid_event_handlers_$_iter__34499(s__34500){
return (new cljs.core.LazySeq(null,(function (){
var s__34500__$1 = s__34500;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__34500__$1);
if(temp__4657__auto__){
var s__34500__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__34500__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__34500__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__34502 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__34501 = (0);
while(true){
if((i__34501 < size__7188__auto__)){
var vec__34511 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__34501);
var handler_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34511,(0),null);
var handler_function = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34511,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case(cljs.core.name(handler_key));
var event = (grid[handler_name]);
cljs.core.chunk_append(b__34502,event.subscribe(handler_function));

var G__34517 = (i__34501 + (1));
i__34501 = G__34517;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__34502),hatti$views$table$bind_external_sg_grid_event_handlers_$_iter__34499(cljs.core.chunk_rest(s__34500__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__34502),null);
}
} else {
var vec__34514 = cljs.core.first(s__34500__$2);
var handler_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34514,(0),null);
var handler_function = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34514,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case(cljs.core.name(handler_key));
var event = (grid[handler_name]);
return cljs.core.cons(event.subscribe(handler_function),hatti$views$table$bind_external_sg_grid_event_handlers_$_iter__34499(cljs.core.rest(s__34500__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__(event_handlers);
})());
});
hatti.views.table.bind_external_sg_grid_dataview_handlers = (function hatti$views$table$bind_external_sg_grid_dataview_handlers(dataview,event_handlers){
return cljs.core.doall.cljs$core$IFn$_invoke$arity$1((function (){var iter__7189__auto__ = (function hatti$views$table$bind_external_sg_grid_dataview_handlers_$_iter__34536(s__34537){
return (new cljs.core.LazySeq(null,(function (){
var s__34537__$1 = s__34537;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__34537__$1);
if(temp__4657__auto__){
var s__34537__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__34537__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__34537__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__34539 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__34538 = (0);
while(true){
if((i__34538 < size__7188__auto__)){
var vec__34548 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__34538);
var handler_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34548,(0),null);
var handler_function = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34548,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case(cljs.core.name(handler_key));
var event = (dataview[handler_name]);
cljs.core.chunk_append(b__34539,event.subscribe(handler_function));

var G__34554 = (i__34538 + (1));
i__34538 = G__34554;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__34539),hatti$views$table$bind_external_sg_grid_dataview_handlers_$_iter__34536(cljs.core.chunk_rest(s__34537__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__34539),null);
}
} else {
var vec__34551 = cljs.core.first(s__34537__$2);
var handler_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34551,(0),null);
var handler_function = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34551,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case(cljs.core.name(handler_key));
var event = (dataview[handler_name]);
return cljs.core.cons(event.subscribe(handler_function),hatti$views$table$bind_external_sg_grid_dataview_handlers_$_iter__34536(cljs.core.rest(s__34537__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__(event_handlers);
})());
});
/**
 * Creates a Slick.Grid backed by Slick.Data.DataView from data and fields.
 * Most events are handled by slickgrid. On double-click, event is put on chan.
 * Returns [grid dataview].
 */
hatti.views.table.sg_init = (function hatti$views$table$sg_init(data,form,current_language,is_filtered_dataview_QMARK_,owner,p__34555){
var map__34565 = p__34555;
var map__34565__$1 = ((((!((map__34565 == null)))?((((map__34565.cljs$lang$protocol_mask$partition0$ & (64))) || (map__34565.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__34565):map__34565);
var grid_event_handlers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34565__$1,cljs.core.cst$kw$grid_DASH_event_DASH_handlers);
var dataview_event_handlers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34565__$1,cljs.core.cst$kw$dataview_DASH_event_DASH_handlers);
var columns = hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic(form,true,current_language,cljs.core.array_seq([cljs.core.cst$kw$is_DASH_filtered_DASH_dataview_QMARK_,is_filtered_dataview_QMARK_,cljs.core.cst$kw$owner,owner], 0));
var SlickGrid = Slick.Grid;
var DataView = Slick.Data.DataView;
var dataview = (new DataView());
var grid = (new SlickGrid([cljs.core.str("#"),cljs.core.str(hatti.views.table.table_id)].join(''),dataview,columns,hatti.views.table.sg_options));
var map__34567 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.shared.app_state) : cljs.core.deref.call(null,hatti.shared.app_state));
var map__34567__$1 = ((((!((map__34567 == null)))?((((map__34567.cljs$lang$protocol_mask$partition0$ & (64))) || (map__34567.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__34567):map__34567);
var map__34568 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34567__$1,cljs.core.cst$kw$table_DASH_page);
var map__34568__$1 = ((((!((map__34568 == null)))?((((map__34568.cljs$lang$protocol_mask$partition0$ & (64))) || (map__34568.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__34568):map__34568);
var map__34569 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34568__$1,cljs.core.cst$kw$paging);
var map__34569__$1 = ((((!((map__34569 == null)))?((((map__34569.cljs$lang$protocol_mask$partition0$ & (64))) || (map__34569.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__34569):map__34569);
var num_displayed_records = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34569__$1,cljs.core.cst$kw$num_DASH_displayed_DASH_records);
var total_page_count = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34569__$1,cljs.core.cst$kw$total_DASH_page_DASH_count);
hatti.views.table.bind_external_sg_grid_event_handlers(grid,grid_event_handlers);

hatti.views.table.bind_external_sg_grid_dataview_handlers(dataview,dataview_event_handlers);

dataview.onRowCountChanged.subscribe(((function (columns,SlickGrid,DataView,dataview,grid,map__34567,map__34567__$1,map__34568,map__34568__$1,map__34569,map__34569__$1,num_displayed_records,total_page_count,map__34565,map__34565__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
grid.updateRowCount();

return grid.render();
});})(columns,SlickGrid,DataView,dataview,grid,map__34567,map__34567__$1,map__34568,map__34568__$1,map__34569,map__34569__$1,num_displayed_records,total_page_count,map__34565,map__34565__$1,grid_event_handlers,dataview_event_handlers))
);

dataview.onRowsChanged.subscribe(((function (columns,SlickGrid,DataView,dataview,grid,map__34567,map__34567__$1,map__34568,map__34568__$1,map__34569,map__34569__$1,num_displayed_records,total_page_count,map__34565,map__34565__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
grid.invalidateRows((args["rows"]));

return grid.render();
});})(columns,SlickGrid,DataView,dataview,grid,map__34567,map__34567__$1,map__34568,map__34568__$1,map__34569,map__34569__$1,num_displayed_records,total_page_count,map__34565,map__34565__$1,grid_event_handlers,dataview_event_handlers))
);

grid.onDblClick.subscribe(((function (columns,SlickGrid,DataView,dataview,grid,map__34567,map__34567__$1,map__34568,map__34568__$1,map__34569,map__34569__$1,num_displayed_records,total_page_count,map__34565,map__34565__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
var rank = (dataview.getItem((args["row"]))[hatti.constants._rank]);
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$submission_DASH_to_DASH_rank,rank], null));
});})(columns,SlickGrid,DataView,dataview,grid,map__34567,map__34567__$1,map__34568,map__34568__$1,map__34569,map__34569__$1,num_displayed_records,total_page_count,map__34565,map__34565__$1,grid_event_handlers,dataview_event_handlers))
);

grid.onClick.subscribe(((function (columns,SlickGrid,DataView,dataview,grid,map__34567,map__34567__$1,map__34568,map__34568__$1,map__34569,map__34569__$1,num_displayed_records,total_page_count,map__34565,map__34565__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
var elem = e.target;
var row = dataview.getItem((args["row"]));
var elem_data_id = elem.getAttribute("data-id");
var data_id = (cljs.core.truth_(elem_data_id)?(function (){var G__34573 = elem.getAttribute("data-id");
return parseInt(G__34573);
})():null);
var id = (row[hatti.constants._id]);
var rank = (row[hatti.constants._rank]);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(id,data_id)){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$submission_DASH_to_DASH_rank,rank], null));
} else {
return null;
}
});})(columns,SlickGrid,DataView,dataview,grid,map__34567,map__34567__$1,map__34568,map__34568__$1,map__34569,map__34569__$1,num_displayed_records,total_page_count,map__34565,map__34565__$1,grid_event_handlers,dataview_event_handlers))
);

hatti.views.table.init_sg_pager(grid,dataview);

dataview.setPagingOptions(({"pageSize": (function (){var or__6409__auto__ = num_displayed_records;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return hatti.views.table.default_num_displayed_records;
}
})(), "totalPages": total_page_count}));

dataview.setFilter(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(hatti.views.table.filterfn,form));

dataview.setItems(cljs.core.clj__GT_js(data),hatti.constants._id);

hatti.views.table.resizeColumns(grid);

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [grid,dataview], null);
});
/**
 * Event loop for the table view. Processes a tap of share/event-chan,
 * and updates app-state/dataview/grid as needed.
 */
hatti.views.table.handle_table_events = (function hatti$views$table$handle_table_events(app_state,grid,dataview){
var event_chan = hatti.shared.event_tap();
var c__12231__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12231__auto__,event_chan){
return (function (){
var f__12232__auto__ = (function (){var switch__12119__auto__ = ((function (c__12231__auto__,event_chan){
return (function (state_34835){
var state_val_34836 = (state_34835[(1)]);
if((state_val_34836 === (7))){
var inst_34744 = (state_34835[(7)]);
var inst_34744__$1 = (state_34835[(2)]);
var inst_34746 = (inst_34744__$1 == null);
var inst_34747 = cljs.core.not(inst_34746);
var state_34835__$1 = (function (){var statearr_34837 = state_34835;
(statearr_34837[(7)] = inst_34744__$1);

return statearr_34837;
})();
if(inst_34747){
var statearr_34838_34905 = state_34835__$1;
(statearr_34838_34905[(1)] = (8));

} else {
var statearr_34839_34906 = state_34835__$1;
(statearr_34839_34906[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34836 === (20))){
var inst_34774 = (state_34835[(8)]);
var inst_34766 = (state_34835[(9)]);
var inst_34783 = (inst_34774.cljs$core$IFn$_invoke$arity$1 ? inst_34774.cljs$core$IFn$_invoke$arity$1(inst_34766) : inst_34774.call(null,inst_34766));
var state_34835__$1 = state_34835;
var statearr_34840_34907 = state_34835__$1;
(statearr_34840_34907[(2)] = inst_34783);

(statearr_34840_34907[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34836 === (27))){
var state_34835__$1 = state_34835;
var statearr_34841_34908 = state_34835__$1;
(statearr_34841_34908[(2)] = null);

(statearr_34841_34908[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34836 === (1))){
var state_34835__$1 = state_34835;
var statearr_34842_34909 = state_34835__$1;
(statearr_34842_34909[(2)] = null);

(statearr_34842_34909[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34836 === (24))){
var state_34835__$1 = state_34835;
var statearr_34843_34910 = state_34835__$1;
(statearr_34843_34910[(2)] = null);

(statearr_34843_34910[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34836 === (4))){
var state_34835__$1 = state_34835;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34835__$1,(7),event_chan);
} else {
if((state_val_34836 === (15))){
var inst_34744 = (state_34835[(7)]);
var state_34835__$1 = state_34835;
var statearr_34844_34911 = state_34835__$1;
(statearr_34844_34911[(2)] = inst_34744);

(statearr_34844_34911[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34836 === (21))){
var state_34835__$1 = state_34835;
var statearr_34845_34912 = state_34835__$1;
(statearr_34845_34912[(2)] = null);

(statearr_34845_34912[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34836 === (31))){
var inst_34770 = (state_34835[(10)]);
var inst_34808 = (state_34835[(2)]);
var inst_34809 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_34770,cljs.core.cst$kw$table);
var state_34835__$1 = (function (){var statearr_34846 = state_34835;
(statearr_34846[(11)] = inst_34808);

return statearr_34846;
})();
if(inst_34809){
var statearr_34847_34913 = state_34835__$1;
(statearr_34847_34913[(1)] = (32));

} else {
var statearr_34848_34914 = state_34835__$1;
(statearr_34848_34914[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34836 === (32))){
var inst_34768 = (state_34835[(12)]);
var inst_34775 = (state_34835[(13)]);
var inst_34769 = (state_34835[(14)]);
var inst_34767 = (state_34835[(15)]);
var inst_34774 = (state_34835[(8)]);
var inst_34770 = (state_34835[(10)]);
var inst_34765 = (state_34835[(16)]);
var inst_34764 = (state_34835[(17)]);
var inst_34766 = (state_34835[(9)]);
var inst_34744 = (state_34835[(7)]);
var inst_34822 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_34823 = (function (){var new_columns = inst_34769;
var submission_clicked = inst_34766;
var submission_unclicked = inst_34767;
var get_submission_data = inst_34775;
var c__12231__auto____$1 = inst_34822;
var re_render = inst_34770;
var update_data_BANG_ = inst_34774;
var submission_to_rank = inst_34765;
var e = inst_34744;
var map__34742 = inst_34764;
var filter_by = inst_34768;
return ((function (new_columns,submission_clicked,submission_unclicked,get_submission_data,c__12231__auto____$1,re_render,update_data_BANG_,submission_to_rank,e,map__34742,filter_by,inst_34768,inst_34775,inst_34769,inst_34767,inst_34774,inst_34770,inst_34765,inst_34764,inst_34766,inst_34744,inst_34822,state_val_34836,c__12231__auto__,event_chan){
return (function (){
var f__12232__auto__ = (function (){var switch__12119__auto__ = ((function (new_columns,submission_clicked,submission_unclicked,get_submission_data,c__12231__auto____$1,re_render,update_data_BANG_,submission_to_rank,e,map__34742,filter_by,inst_34768,inst_34775,inst_34769,inst_34767,inst_34774,inst_34770,inst_34765,inst_34764,inst_34766,inst_34744,inst_34822,state_val_34836,c__12231__auto__,event_chan){
return (function (state_34820){
var state_val_34821 = (state_34820[(1)]);
if((state_val_34821 === (1))){
var inst_34811 = cljs.core.async.timeout((20));
var state_34820__$1 = state_34820;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34820__$1,(2),inst_34811);
} else {
if((state_val_34821 === (2))){
var inst_34813 = (state_34820[(2)]);
var inst_34814 = grid.resizeCanvas();
var inst_34815 = grid.invalidateAllRows();
var inst_34816 = hatti.views.table.resizeColumns(grid);
var inst_34817 = grid.render();
var inst_34818 = hatti.views.table.init_sg_pager(grid,dataview);
var state_34820__$1 = (function (){var statearr_34849 = state_34820;
(statearr_34849[(7)] = inst_34813);

(statearr_34849[(8)] = inst_34816);

(statearr_34849[(9)] = inst_34814);

(statearr_34849[(10)] = inst_34817);

(statearr_34849[(11)] = inst_34815);

return statearr_34849;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_34820__$1,inst_34818);
} else {
return null;
}
}
});})(new_columns,submission_clicked,submission_unclicked,get_submission_data,c__12231__auto____$1,re_render,update_data_BANG_,submission_to_rank,e,map__34742,filter_by,inst_34768,inst_34775,inst_34769,inst_34767,inst_34774,inst_34770,inst_34765,inst_34764,inst_34766,inst_34744,inst_34822,state_val_34836,c__12231__auto__,event_chan))
;
return ((function (switch__12119__auto__,new_columns,submission_clicked,submission_unclicked,get_submission_data,c__12231__auto____$1,re_render,update_data_BANG_,submission_to_rank,e,map__34742,filter_by,inst_34768,inst_34775,inst_34769,inst_34767,inst_34774,inst_34770,inst_34765,inst_34764,inst_34766,inst_34744,inst_34822,state_val_34836,c__12231__auto__,event_chan){
return (function() {
var hatti$views$table$handle_table_events_$_state_machine__12120__auto__ = null;
var hatti$views$table$handle_table_events_$_state_machine__12120__auto____0 = (function (){
var statearr_34853 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_34853[(0)] = hatti$views$table$handle_table_events_$_state_machine__12120__auto__);

(statearr_34853[(1)] = (1));

return statearr_34853;
});
var hatti$views$table$handle_table_events_$_state_machine__12120__auto____1 = (function (state_34820){
while(true){
var ret_value__12121__auto__ = (function (){try{while(true){
var result__12122__auto__ = switch__12119__auto__(state_34820);
if(cljs.core.keyword_identical_QMARK_(result__12122__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12122__auto__;
}
break;
}
}catch (e34854){if((e34854 instanceof Object)){
var ex__12123__auto__ = e34854;
var statearr_34855_34915 = state_34820;
(statearr_34855_34915[(5)] = ex__12123__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_34820);

return cljs.core.cst$kw$recur;
} else {
throw e34854;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12121__auto__,cljs.core.cst$kw$recur)){
var G__34916 = state_34820;
state_34820 = G__34916;
continue;
} else {
return ret_value__12121__auto__;
}
break;
}
});
hatti$views$table$handle_table_events_$_state_machine__12120__auto__ = function(state_34820){
switch(arguments.length){
case 0:
return hatti$views$table$handle_table_events_$_state_machine__12120__auto____0.call(this);
case 1:
return hatti$views$table$handle_table_events_$_state_machine__12120__auto____1.call(this,state_34820);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$handle_table_events_$_state_machine__12120__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$handle_table_events_$_state_machine__12120__auto____0;
hatti$views$table$handle_table_events_$_state_machine__12120__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$handle_table_events_$_state_machine__12120__auto____1;
return hatti$views$table$handle_table_events_$_state_machine__12120__auto__;
})()
;})(switch__12119__auto__,new_columns,submission_clicked,submission_unclicked,get_submission_data,c__12231__auto____$1,re_render,update_data_BANG_,submission_to_rank,e,map__34742,filter_by,inst_34768,inst_34775,inst_34769,inst_34767,inst_34774,inst_34770,inst_34765,inst_34764,inst_34766,inst_34744,inst_34822,state_val_34836,c__12231__auto__,event_chan))
})();
var state__12233__auto__ = (function (){var statearr_34856 = (f__12232__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12232__auto__.cljs$core$IFn$_invoke$arity$0() : f__12232__auto__.call(null));
(statearr_34856[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12231__auto____$1);

return statearr_34856;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12233__auto__);
});
;})(new_columns,submission_clicked,submission_unclicked,get_submission_data,c__12231__auto____$1,re_render,update_data_BANG_,submission_to_rank,e,map__34742,filter_by,inst_34768,inst_34775,inst_34769,inst_34767,inst_34774,inst_34770,inst_34765,inst_34764,inst_34766,inst_34744,inst_34822,state_val_34836,c__12231__auto__,event_chan))
})();
var inst_34824 = cljs.core.async.impl.dispatch.run(inst_34823);
var state_34835__$1 = (function (){var statearr_34857 = state_34835;
(statearr_34857[(18)] = inst_34824);

return statearr_34857;
})();
var statearr_34858_34917 = state_34835__$1;
(statearr_34858_34917[(2)] = inst_34822);

(statearr_34858_34917[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34836 === (33))){
var state_34835__$1 = state_34835;
var statearr_34859_34918 = state_34835__$1;
(statearr_34859_34918[(2)] = null);

(statearr_34859_34918[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34836 === (13))){
var inst_34756 = (state_34835[(2)]);
var state_34835__$1 = state_34835;
var statearr_34860_34919 = state_34835__$1;
(statearr_34860_34919[(2)] = inst_34756);

(statearr_34860_34919[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34836 === (22))){
var inst_34767 = (state_34835[(15)]);
var inst_34786 = (state_34835[(2)]);
var state_34835__$1 = (function (){var statearr_34861 = state_34835;
(statearr_34861[(19)] = inst_34786);

return statearr_34861;
})();
if(cljs.core.truth_(inst_34767)){
var statearr_34862_34920 = state_34835__$1;
(statearr_34862_34920[(1)] = (23));

} else {
var statearr_34863_34921 = state_34835__$1;
(statearr_34863_34921[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34836 === (29))){
var inst_34768 = (state_34835[(12)]);
var inst_34800 = [cljs.core.cst$kw$query];
var inst_34801 = [inst_34768];
var inst_34802 = cljs.core.PersistentHashMap.fromArrays(inst_34800,inst_34801);
var inst_34803 = cljs.core.clj__GT_js(inst_34802);
var inst_34804 = dataview.setFilterArgs(inst_34803);
var inst_34805 = dataview.refresh();
var state_34835__$1 = (function (){var statearr_34864 = state_34835;
(statearr_34864[(20)] = inst_34804);

return statearr_34864;
})();
var statearr_34865_34922 = state_34835__$1;
(statearr_34865_34922[(2)] = inst_34805);

(statearr_34865_34922[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34836 === (6))){
var inst_34831 = (state_34835[(2)]);
var state_34835__$1 = state_34835;
var statearr_34866_34923 = state_34835__$1;
(statearr_34866_34923[(2)] = inst_34831);

(statearr_34866_34923[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34836 === (28))){
var inst_34768 = (state_34835[(12)]);
var inst_34798 = (state_34835[(2)]);
var state_34835__$1 = (function (){var statearr_34867 = state_34835;
(statearr_34867[(21)] = inst_34798);

return statearr_34867;
})();
if(cljs.core.truth_(inst_34768)){
var statearr_34868_34924 = state_34835__$1;
(statearr_34868_34924[(1)] = (29));

} else {
var statearr_34869_34925 = state_34835__$1;
(statearr_34869_34925[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34836 === (25))){
var inst_34769 = (state_34835[(14)]);
var inst_34791 = (state_34835[(2)]);
var state_34835__$1 = (function (){var statearr_34870 = state_34835;
(statearr_34870[(22)] = inst_34791);

return statearr_34870;
})();
if(cljs.core.truth_(inst_34769)){
var statearr_34871_34926 = state_34835__$1;
(statearr_34871_34926[(1)] = (26));

} else {
var statearr_34872_34927 = state_34835__$1;
(statearr_34872_34927[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34836 === (34))){
var inst_34827 = (state_34835[(2)]);
var state_34835__$1 = (function (){var statearr_34873 = state_34835;
(statearr_34873[(23)] = inst_34827);

return statearr_34873;
})();
var statearr_34874_34928 = state_34835__$1;
(statearr_34874_34928[(2)] = null);

(statearr_34874_34928[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34836 === (17))){
var inst_34775 = (state_34835[(13)]);
var inst_34774 = (state_34835[(8)]);
var inst_34765 = (state_34835[(16)]);
var inst_34777 = (inst_34775.cljs$core$IFn$_invoke$arity$2 ? inst_34775.cljs$core$IFn$_invoke$arity$2(hatti.constants._rank,inst_34765) : inst_34775.call(null,hatti.constants._rank,inst_34765));
var inst_34778 = (inst_34774.cljs$core$IFn$_invoke$arity$1 ? inst_34774.cljs$core$IFn$_invoke$arity$1(inst_34777) : inst_34774.call(null,inst_34777));
var state_34835__$1 = state_34835;
var statearr_34875_34929 = state_34835__$1;
(statearr_34875_34929[(2)] = inst_34778);

(statearr_34875_34929[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34836 === (3))){
var inst_34833 = (state_34835[(2)]);
var state_34835__$1 = state_34835;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34835__$1,inst_34833);
} else {
if((state_val_34836 === (12))){
var state_34835__$1 = state_34835;
var statearr_34876_34930 = state_34835__$1;
(statearr_34876_34930[(2)] = false);

(statearr_34876_34930[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34836 === (2))){
var state_34835__$1 = state_34835;
var statearr_34877_34931 = state_34835__$1;
(statearr_34877_34931[(1)] = (4));



return cljs.core.cst$kw$recur;
} else {
if((state_val_34836 === (23))){
var inst_34774 = (state_34835[(8)]);
var inst_34788 = (inst_34774.cljs$core$IFn$_invoke$arity$1 ? inst_34774.cljs$core$IFn$_invoke$arity$1(null) : inst_34774.call(null,null));
var state_34835__$1 = state_34835;
var statearr_34879_34932 = state_34835__$1;
(statearr_34879_34932[(2)] = inst_34788);

(statearr_34879_34932[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34836 === (19))){
var inst_34766 = (state_34835[(9)]);
var inst_34781 = (state_34835[(2)]);
var state_34835__$1 = (function (){var statearr_34880 = state_34835;
(statearr_34880[(24)] = inst_34781);

return statearr_34880;
})();
if(cljs.core.truth_(inst_34766)){
var statearr_34881_34933 = state_34835__$1;
(statearr_34881_34933[(1)] = (20));

} else {
var statearr_34882_34934 = state_34835__$1;
(statearr_34882_34934[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34836 === (11))){
var state_34835__$1 = state_34835;
var statearr_34883_34935 = state_34835__$1;
(statearr_34883_34935[(2)] = true);

(statearr_34883_34935[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34836 === (9))){
var state_34835__$1 = state_34835;
var statearr_34884_34936 = state_34835__$1;
(statearr_34884_34936[(2)] = false);

(statearr_34884_34936[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34836 === (5))){
var state_34835__$1 = state_34835;
var statearr_34885_34937 = state_34835__$1;
(statearr_34885_34937[(2)] = null);

(statearr_34885_34937[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34836 === (14))){
var inst_34744 = (state_34835[(7)]);
var inst_34761 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_34744);
var state_34835__$1 = state_34835;
var statearr_34886_34938 = state_34835__$1;
(statearr_34886_34938[(2)] = inst_34761);

(statearr_34886_34938[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34836 === (26))){
var inst_34769 = (state_34835[(14)]);
var inst_34793 = grid.setColumns(inst_34769);
var inst_34794 = hatti.views.table.resizeColumns(grid);
var inst_34795 = grid.render();
var state_34835__$1 = (function (){var statearr_34887 = state_34835;
(statearr_34887[(25)] = inst_34793);

(statearr_34887[(26)] = inst_34794);

return statearr_34887;
})();
var statearr_34888_34939 = state_34835__$1;
(statearr_34888_34939[(2)] = inst_34795);

(statearr_34888_34939[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34836 === (16))){
var inst_34768 = (state_34835[(12)]);
var inst_34769 = (state_34835[(14)]);
var inst_34767 = (state_34835[(15)]);
var inst_34774 = (state_34835[(8)]);
var inst_34770 = (state_34835[(10)]);
var inst_34765 = (state_34835[(16)]);
var inst_34764 = (state_34835[(17)]);
var inst_34766 = (state_34835[(9)]);
var inst_34744 = (state_34835[(7)]);
var inst_34764__$1 = (state_34835[(2)]);
var inst_34765__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_34764__$1,cljs.core.cst$kw$submission_DASH_to_DASH_rank);
var inst_34766__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_34764__$1,cljs.core.cst$kw$submission_DASH_clicked);
var inst_34767__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_34764__$1,cljs.core.cst$kw$submission_DASH_unclicked);
var inst_34768__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_34764__$1,cljs.core.cst$kw$filter_DASH_by);
var inst_34769__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_34764__$1,cljs.core.cst$kw$new_DASH_columns);
var inst_34770__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_34764__$1,cljs.core.cst$kw$re_DASH_render);
var inst_34771 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34772 = [cljs.core.cst$kw$table_DASH_page,cljs.core.cst$kw$submission_DASH_clicked,cljs.core.cst$kw$data];
var inst_34773 = (new cljs.core.PersistentVector(null,3,(5),inst_34771,inst_34772,null));
var inst_34774__$1 = cljs.core.partial.cljs$core$IFn$_invoke$arity$3(om.core.update_BANG_,app_state,inst_34773);
var inst_34775 = (function (){var e = inst_34744;
var map__34742 = inst_34764__$1;
var submission_to_rank = inst_34765__$1;
var submission_clicked = inst_34766__$1;
var submission_unclicked = inst_34767__$1;
var filter_by = inst_34768__$1;
var new_columns = inst_34769__$1;
var re_render = inst_34770__$1;
var update_data_BANG_ = inst_34774__$1;
return ((function (e,map__34742,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_34768,inst_34769,inst_34767,inst_34774,inst_34770,inst_34765,inst_34764,inst_34766,inst_34744,inst_34764__$1,inst_34765__$1,inst_34766__$1,inst_34767__$1,inst_34768__$1,inst_34769__$1,inst_34770__$1,inst_34771,inst_34772,inst_34773,inst_34774__$1,state_val_34836,c__12231__auto__,event_chan){
return (function (field,value){
return cljs.core.first(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (e,map__34742,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_34768,inst_34769,inst_34767,inst_34774,inst_34770,inst_34765,inst_34764,inst_34766,inst_34744,inst_34764__$1,inst_34765__$1,inst_34766__$1,inst_34767__$1,inst_34768__$1,inst_34769__$1,inst_34770__$1,inst_34771,inst_34772,inst_34773,inst_34774__$1,state_val_34836,c__12231__auto__,event_chan){
return (function (p1__34574_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(value,cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__34574_SHARP_,field));
});})(e,map__34742,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_34768,inst_34769,inst_34767,inst_34774,inst_34770,inst_34765,inst_34764,inst_34766,inst_34744,inst_34764__$1,inst_34765__$1,inst_34766__$1,inst_34767__$1,inst_34768__$1,inst_34769__$1,inst_34770__$1,inst_34771,inst_34772,inst_34773,inst_34774__$1,state_val_34836,c__12231__auto__,event_chan))
,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(app_state) : cljs.core.deref.call(null,app_state)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data], null))));
});
;})(e,map__34742,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_34768,inst_34769,inst_34767,inst_34774,inst_34770,inst_34765,inst_34764,inst_34766,inst_34744,inst_34764__$1,inst_34765__$1,inst_34766__$1,inst_34767__$1,inst_34768__$1,inst_34769__$1,inst_34770__$1,inst_34771,inst_34772,inst_34773,inst_34774__$1,state_val_34836,c__12231__auto__,event_chan))
})();
var state_34835__$1 = (function (){var statearr_34889 = state_34835;
(statearr_34889[(12)] = inst_34768__$1);

(statearr_34889[(13)] = inst_34775);

(statearr_34889[(14)] = inst_34769__$1);

(statearr_34889[(15)] = inst_34767__$1);

(statearr_34889[(8)] = inst_34774__$1);

(statearr_34889[(10)] = inst_34770__$1);

(statearr_34889[(16)] = inst_34765__$1);

(statearr_34889[(17)] = inst_34764__$1);

(statearr_34889[(9)] = inst_34766__$1);

return statearr_34889;
})();
if(cljs.core.truth_(inst_34765__$1)){
var statearr_34890_34940 = state_34835__$1;
(statearr_34890_34940[(1)] = (17));

} else {
var statearr_34891_34941 = state_34835__$1;
(statearr_34891_34941[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34836 === (30))){
var state_34835__$1 = state_34835;
var statearr_34892_34942 = state_34835__$1;
(statearr_34892_34942[(2)] = null);

(statearr_34892_34942[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34836 === (10))){
var inst_34759 = (state_34835[(2)]);
var state_34835__$1 = state_34835;
if(cljs.core.truth_(inst_34759)){
var statearr_34893_34943 = state_34835__$1;
(statearr_34893_34943[(1)] = (14));

} else {
var statearr_34894_34944 = state_34835__$1;
(statearr_34894_34944[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34836 === (18))){
var state_34835__$1 = state_34835;
var statearr_34895_34945 = state_34835__$1;
(statearr_34895_34945[(2)] = null);

(statearr_34895_34945[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34836 === (8))){
var inst_34744 = (state_34835[(7)]);
var inst_34749 = inst_34744.cljs$lang$protocol_mask$partition0$;
var inst_34750 = (inst_34749 & (64));
var inst_34751 = inst_34744.cljs$core$ISeq$;
var inst_34752 = (inst_34750) || (inst_34751);
var state_34835__$1 = state_34835;
if(cljs.core.truth_(inst_34752)){
var statearr_34896_34946 = state_34835__$1;
(statearr_34896_34946[(1)] = (11));

} else {
var statearr_34897_34947 = state_34835__$1;
(statearr_34897_34947[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12231__auto__,event_chan))
;
return ((function (switch__12119__auto__,c__12231__auto__,event_chan){
return (function() {
var hatti$views$table$handle_table_events_$_state_machine__12120__auto__ = null;
var hatti$views$table$handle_table_events_$_state_machine__12120__auto____0 = (function (){
var statearr_34901 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_34901[(0)] = hatti$views$table$handle_table_events_$_state_machine__12120__auto__);

(statearr_34901[(1)] = (1));

return statearr_34901;
});
var hatti$views$table$handle_table_events_$_state_machine__12120__auto____1 = (function (state_34835){
while(true){
var ret_value__12121__auto__ = (function (){try{while(true){
var result__12122__auto__ = switch__12119__auto__(state_34835);
if(cljs.core.keyword_identical_QMARK_(result__12122__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12122__auto__;
}
break;
}
}catch (e34902){if((e34902 instanceof Object)){
var ex__12123__auto__ = e34902;
var statearr_34903_34948 = state_34835;
(statearr_34903_34948[(5)] = ex__12123__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_34835);

return cljs.core.cst$kw$recur;
} else {
throw e34902;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12121__auto__,cljs.core.cst$kw$recur)){
var G__34949 = state_34835;
state_34835 = G__34949;
continue;
} else {
return ret_value__12121__auto__;
}
break;
}
});
hatti$views$table$handle_table_events_$_state_machine__12120__auto__ = function(state_34835){
switch(arguments.length){
case 0:
return hatti$views$table$handle_table_events_$_state_machine__12120__auto____0.call(this);
case 1:
return hatti$views$table$handle_table_events_$_state_machine__12120__auto____1.call(this,state_34835);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$handle_table_events_$_state_machine__12120__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$handle_table_events_$_state_machine__12120__auto____0;
hatti$views$table$handle_table_events_$_state_machine__12120__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$handle_table_events_$_state_machine__12120__auto____1;
return hatti$views$table$handle_table_events_$_state_machine__12120__auto__;
})()
;})(switch__12119__auto__,c__12231__auto__,event_chan))
})();
var state__12233__auto__ = (function (){var statearr_34904 = (f__12232__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12232__auto__.cljs$core$IFn$_invoke$arity$0() : f__12232__auto__.call(null));
(statearr_34904[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12231__auto__);

return statearr_34904;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12233__auto__);
});})(c__12231__auto__,event_chan))
);

return c__12231__auto__;
});
hatti.views.table.render_options = (function hatti$views$table$render_options(options,owner,colset_BANG_){
var choose_display_key = (function (k){
om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$name_DASH_or_DASH_label,k);

return (colset_BANG_.cljs$core$IFn$_invoke$arity$1 ? colset_BANG_.cljs$core$IFn$_invoke$arity$1(k) : colset_BANG_.call(null,k));
});
var iter__7189__auto__ = ((function (choose_display_key){
return (function hatti$views$table$render_options_$_iter__34968(s__34969){
return (new cljs.core.LazySeq(null,((function (choose_display_key){
return (function (){
var s__34969__$1 = s__34969;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__34969__$1);
if(temp__4657__auto__){
var s__34969__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__34969__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__34969__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__34971 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__34970 = (0);
while(true){
if((i__34970 < size__7188__auto__)){
var vec__34980 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__34970);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34980,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34980,(1),null);
cljs.core.chunk_append(b__34971,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$on_DASH_click,hatti.utils.click_fn(((function (i__34970,vec__34980,k,v,c__7187__auto__,size__7188__auto__,b__34971,s__34969__$2,temp__4657__auto__,choose_display_key){
return (function (){
return choose_display_key(k);
});})(i__34970,vec__34980,k,v,c__7187__auto__,size__7188__auto__,b__34971,s__34969__$2,temp__4657__auto__,choose_display_key))
),cljs.core.cst$kw$href,"#"], null),v], null)], null));

var G__34986 = (i__34970 + (1));
i__34970 = G__34986;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__34971),hatti$views$table$render_options_$_iter__34968(cljs.core.chunk_rest(s__34969__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__34971),null);
}
} else {
var vec__34983 = cljs.core.first(s__34969__$2);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34983,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34983,(1),null);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$on_DASH_click,hatti.utils.click_fn(((function (vec__34983,k,v,s__34969__$2,temp__4657__auto__,choose_display_key){
return (function (){
return choose_display_key(k);
});})(vec__34983,k,v,s__34969__$2,temp__4657__auto__,choose_display_key))
),cljs.core.cst$kw$href,"#"], null),v], null)], null),hatti$views$table$render_options_$_iter__34968(cljs.core.rest(s__34969__$2)));
}
} else {
return null;
}
break;
}
});})(choose_display_key))
,null,null));
});})(choose_display_key))
;
return iter__7189__auto__(options);
});
hatti.views.label_changer.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (_,owner){
if(typeof hatti.views.table.t_hatti$views$table34988 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRenderState}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IInitState}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table34988 = (function (_,owner,meta34989){
this._ = _;
this.owner = owner;
this.meta34989 = meta34989;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table34988.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34990,meta34989__$1){
var self__ = this;
var _34990__$1 = this;
return (new hatti.views.table.t_hatti$views$table34988(self__._,self__.owner,meta34989__$1));
});

hatti.views.table.t_hatti$views$table34988.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34990){
var self__ = this;
var _34990__$1 = this;
return self__.meta34989;
});

hatti.views.table.t_hatti$views$table34988.prototype.om$core$IInitState$ = true;

hatti.views.table.t_hatti$views$table34988.prototype.om$core$IInitState$init_state$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$name_DASH_or_DASH_label,cljs.core.cst$kw$label], null);
});

hatti.views.table.t_hatti$views$table34988.prototype.om$core$IRenderState$ = true;

hatti.views.table.t_hatti$views$table34988.prototype.om$core$IRenderState$render_state$arity$2 = (function (___$1,p__34991){
var self__ = this;
var map__34992 = p__34991;
var map__34992__$1 = ((((!((map__34992 == null)))?((((map__34992.cljs$lang$protocol_mask$partition0$ & (64))) || (map__34992.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__34992):map__34992);
var name_or_label = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34992__$1,cljs.core.cst$kw$name_DASH_or_DASH_label);
var language = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34992__$1,cljs.core.cst$kw$language);
var ___$2 = this;
var options = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$label,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$strong,"Label"], null),cljs.core.cst$kw$name,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$strong,"Name"], null)], null);
var map__34994 = om.core.get_shared.cljs$core$IFn$_invoke$arity$1(self__.owner);
var map__34994__$1 = ((((!((map__34994 == null)))?((((map__34994.cljs$lang$protocol_mask$partition0$ & (64))) || (map__34994.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__34994):map__34994);
var flat_form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34994__$1,cljs.core.cst$kw$flat_DASH_form);
var new_language = cljs.core.cst$kw$current.cljs$core$IFn$_invoke$arity$1(om.core.observe(self__.owner,hatti.shared.language_cursor()));
var colset_BANG_ = ((function (options,map__34994,map__34994__$1,flat_form,new_language,___$2,map__34992,map__34992__$1,name_or_label,language){
return (function (p1__34987_SHARP_){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$new_DASH_columns,hatti.views.table.flat_form__GT_sg_columns(flat_form,cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$label,p1__34987_SHARP_),new_language)], null));
});})(options,map__34994,map__34994__$1,flat_form,new_language,___$2,map__34992,map__34992__$1,name_or_label,language))
;
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(new_language,language)){
om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(self__.owner,cljs.core.cst$kw$language,new_language);

colset_BANG_(name_or_label);
} else {
}

var G__35003 = ({"className": "label-changer"});
var G__35004 = (function (){var G__35006 = ({"className": "label-changer-label"});
var G__35007 = "Show:";
return React.DOM.span(G__35006,G__35007);
})();
var G__35005 = (function (){var G__35008 = ({"id": "header-display-dropdown", "className": "drop-hover"});
var G__35009 = (function (){var attrs34998 = (options.cljs$core$IFn$_invoke$arity$1 ? options.cljs$core$IFn$_invoke$arity$1(name_or_label) : options.call(null,name_or_label));
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(React.DOM.span,((cljs.core.map_QMARK_(attrs34998))?sablono.interpreter.attributes(attrs34998):null),cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,((cljs.core.map_QMARK_(attrs34998))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__35011 = ({"className": "fa fa-angle-down"});
return React.DOM.i(G__35011);
})()], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret(attrs34998),(function (){var G__35012 = ({"className": "fa fa-angle-down"});
return React.DOM.i(G__35012);
})()], null))));
})();
var G__35010 = (function (){var G__35013 = ({"className": "submenu no-dot"});
var G__35014 = sablono.interpreter.interpret(hatti.views.table.render_options(options,self__.owner,colset_BANG_));
return React.DOM.ul(G__35013,G__35014);
})();
return React.DOM.div(G__35008,G__35009,G__35010);
})();
return React.DOM.div(G__35003,G__35004,G__35005);
});

hatti.views.table.t_hatti$views$table34988.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta34989], null);
});

hatti.views.table.t_hatti$views$table34988.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table34988.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table34988";

hatti.views.table.t_hatti$views$table34988.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"hatti.views.table/t_hatti$views$table34988");
});

hatti.views.table.__GT_t_hatti$views$table34988 = (function hatti$views$table$__GT_t_hatti$views$table34988(___$1,owner__$1,meta34989){
return (new hatti.views.table.t_hatti$views$table34988(___$1,owner__$1,meta34989));
});

}

return (new hatti.views.table.t_hatti$views$table34988(_,owner,cljs.core.PersistentArrayMap.EMPTY));
}));
/**
 * Delayed search fires a query-event on event-chan if the value of the input
 * doesn't change within 150 ms (ie, user is still typing).
 * Call on-change or on-key-up, with (.-target event) as first argument.
 */
hatti.views.table.delayed_search = (function hatti$views$table$delayed_search(input,query_event_key){
var query = input.value;
var c__12231__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12231__auto__,query){
return (function (){
var f__12232__auto__ = (function (){var switch__12119__auto__ = ((function (c__12231__auto__,query){
return (function (state_35057){
var state_val_35058 = (state_35057[(1)]);
if((state_val_35058 === (1))){
var inst_35043 = cljs.core.async.timeout((150));
var state_35057__$1 = state_35057;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35057__$1,(2),inst_35043);
} else {
if((state_val_35058 === (2))){
var inst_35045 = (state_35057[(2)]);
var inst_35046 = input.value;
var inst_35047 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(query,inst_35046);
var state_35057__$1 = (function (){var statearr_35059 = state_35057;
(statearr_35059[(7)] = inst_35045);

return statearr_35059;
})();
if(inst_35047){
var statearr_35060_35071 = state_35057__$1;
(statearr_35060_35071[(1)] = (3));

} else {
var statearr_35061_35072 = state_35057__$1;
(statearr_35061_35072[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35058 === (3))){
var inst_35049 = [query_event_key];
var inst_35050 = [query];
var inst_35051 = cljs.core.PersistentHashMap.fromArrays(inst_35049,inst_35050);
var inst_35052 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_chan,inst_35051);
var state_35057__$1 = state_35057;
var statearr_35062_35073 = state_35057__$1;
(statearr_35062_35073[(2)] = inst_35052);

(statearr_35062_35073[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35058 === (4))){
var state_35057__$1 = state_35057;
var statearr_35063_35074 = state_35057__$1;
(statearr_35063_35074[(2)] = null);

(statearr_35063_35074[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35058 === (5))){
var inst_35055 = (state_35057[(2)]);
var state_35057__$1 = state_35057;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35057__$1,inst_35055);
} else {
return null;
}
}
}
}
}
});})(c__12231__auto__,query))
;
return ((function (switch__12119__auto__,c__12231__auto__,query){
return (function() {
var hatti$views$table$delayed_search_$_state_machine__12120__auto__ = null;
var hatti$views$table$delayed_search_$_state_machine__12120__auto____0 = (function (){
var statearr_35067 = [null,null,null,null,null,null,null,null];
(statearr_35067[(0)] = hatti$views$table$delayed_search_$_state_machine__12120__auto__);

(statearr_35067[(1)] = (1));

return statearr_35067;
});
var hatti$views$table$delayed_search_$_state_machine__12120__auto____1 = (function (state_35057){
while(true){
var ret_value__12121__auto__ = (function (){try{while(true){
var result__12122__auto__ = switch__12119__auto__(state_35057);
if(cljs.core.keyword_identical_QMARK_(result__12122__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12122__auto__;
}
break;
}
}catch (e35068){if((e35068 instanceof Object)){
var ex__12123__auto__ = e35068;
var statearr_35069_35075 = state_35057;
(statearr_35069_35075[(5)] = ex__12123__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_35057);

return cljs.core.cst$kw$recur;
} else {
throw e35068;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12121__auto__,cljs.core.cst$kw$recur)){
var G__35076 = state_35057;
state_35057 = G__35076;
continue;
} else {
return ret_value__12121__auto__;
}
break;
}
});
hatti$views$table$delayed_search_$_state_machine__12120__auto__ = function(state_35057){
switch(arguments.length){
case 0:
return hatti$views$table$delayed_search_$_state_machine__12120__auto____0.call(this);
case 1:
return hatti$views$table$delayed_search_$_state_machine__12120__auto____1.call(this,state_35057);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$delayed_search_$_state_machine__12120__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$delayed_search_$_state_machine__12120__auto____0;
hatti$views$table$delayed_search_$_state_machine__12120__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$delayed_search_$_state_machine__12120__auto____1;
return hatti$views$table$delayed_search_$_state_machine__12120__auto__;
})()
;})(switch__12119__auto__,c__12231__auto__,query))
})();
var state__12233__auto__ = (function (){var statearr_35070 = (f__12232__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12232__auto__.cljs$core$IFn$_invoke$arity$0() : f__12232__auto__.call(null));
(statearr_35070[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12231__auto__);

return statearr_35070;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12233__auto__);
});})(c__12231__auto__,query))
);

return c__12231__auto__;
});
hatti.views.table_search.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (_,owner){
if(typeof hatti.views.table.t_hatti$views$table35078 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table35078 = (function (_,owner,meta35079){
this._ = _;
this.owner = owner;
this.meta35079 = meta35079;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table35078.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_35080,meta35079__$1){
var self__ = this;
var _35080__$1 = this;
return (new hatti.views.table.t_hatti$views$table35078(self__._,self__.owner,meta35079__$1));
});

hatti.views.table.t_hatti$views$table35078.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_35080){
var self__ = this;
var _35080__$1 = this;
return self__.meta35079;
});

hatti.views.table.t_hatti$views$table35078.prototype.om$core$IRender$ = true;

hatti.views.table.t_hatti$views$table35078.prototype.om$core$IRender$render$arity$1 = (function (this__16392__auto__){
var self__ = this;
var this__16392__auto____$1 = this;
var G__35083 = ({"className": "table-search"});
var G__35084 = (function (){var G__35086 = ({"className": "fa fa-search"});
return React.DOM.i(G__35086);
})();
var G__35085 = (function (){var G__35087 = ({"type": "text", "placeholder": "Search", "onChange": ((function (G__35083,G__35084,this__16392__auto____$1){
return (function (p1__35077_SHARP_){
return hatti.views.table.delayed_search(p1__35077_SHARP_.target,cljs.core.cst$kw$filter_DASH_by);
});})(G__35083,G__35084,this__16392__auto____$1))
});
return (sablono.interpreter.input.cljs$core$IFn$_invoke$arity$1 ? sablono.interpreter.input.cljs$core$IFn$_invoke$arity$1(G__35087) : sablono.interpreter.input.call(null,G__35087));
})();
return React.DOM.div(G__35083,G__35084,G__35085);
});

hatti.views.table.t_hatti$views$table35078.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta35079], null);
});

hatti.views.table.t_hatti$views$table35078.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table35078.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table35078";

hatti.views.table.t_hatti$views$table35078.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"hatti.views.table/t_hatti$views$table35078");
});

hatti.views.table.__GT_t_hatti$views$table35078 = (function hatti$views$table$__GT_t_hatti$views$table35078(___$1,owner__$1,meta35079){
return (new hatti.views.table.t_hatti$views$table35078(___$1,owner__$1,meta35079));
});

}

return (new hatti.views.table.t_hatti$views$table35078(_,owner,null));
}));
hatti.views.table_header.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (app_state,owner){
if(typeof hatti.views.table.t_hatti$views$table35088 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table35088 = (function (app_state,owner,meta35089){
this.app_state = app_state;
this.owner = owner;
this.meta35089 = meta35089;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table35088.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_35090,meta35089__$1){
var self__ = this;
var _35090__$1 = this;
return (new hatti.views.table.t_hatti$views$table35088(self__.app_state,self__.owner,meta35089__$1));
});

hatti.views.table.t_hatti$views$table35088.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_35090){
var self__ = this;
var _35090__$1 = this;
return self__.meta35089;
});

hatti.views.table.t_hatti$views$table35088.prototype.om$core$IRender$ = true;

hatti.views.table.t_hatti$views$table35088.prototype.om$core$IRender$render$arity$1 = (function (this__16392__auto__){
var self__ = this;
var this__16392__auto____$1 = this;
var G__35093 = ({"className": "topbar"});
var G__35094 = (function (){var G__35098 = ({"id": hatti.views.table.pager_id});
return React.DOM.div(G__35098);
})();
var G__35095 = sablono.interpreter.interpret(om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.views.label_changer,null));
var G__35096 = sablono.interpreter.interpret(om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.views.table_search,self__.app_state));
var G__35097 = (function (){var G__35099 = ({"style": ({"clear": "both"})});
return React.DOM.div(G__35099);
})();
return React.DOM.div(G__35093,G__35094,G__35095,G__35096,G__35097);
});

hatti.views.table.t_hatti$views$table35088.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$app_DASH_state,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta35089], null);
});

hatti.views.table.t_hatti$views$table35088.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table35088.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table35088";

hatti.views.table.t_hatti$views$table35088.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"hatti.views.table/t_hatti$views$table35088");
});

hatti.views.table.__GT_t_hatti$views$table35088 = (function hatti$views$table$__GT_t_hatti$views$table35088(app_state__$1,owner__$1,meta35089){
return (new hatti.views.table.t_hatti$views$table35088(app_state__$1,owner__$1,meta35089));
});

}

return (new hatti.views.table.t_hatti$views$table35088(app_state,owner,null));
}));
hatti.views.table.init_grid_BANG_ = (function hatti$views$table$init_grid_BANG_(data,owner,slick_grid_event_handlers){

if(cljs.core.seq(data)){
var map__35105 = om.core.get_shared.cljs$core$IFn$_invoke$arity$1(owner);
var map__35105__$1 = ((((!((map__35105 == null)))?((((map__35105.cljs$lang$protocol_mask$partition0$ & (64))) || (map__35105.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35105):map__35105);
var flat_form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35105__$1,cljs.core.cst$kw$flat_DASH_form);
var is_filtered_dataview_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35105__$1,cljs.core.cst$kw$is_DASH_filtered_DASH_dataview_QMARK_);
var current_language = cljs.core.cst$kw$current.cljs$core$IFn$_invoke$arity$1(om.core.observe(owner,hatti.shared.language_cursor()));
var vec__35106 = hatti.views.table.sg_init(data,flat_form,current_language,is_filtered_dataview_QMARK_,owner,slick_grid_event_handlers);
var grid = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35106,(0),null);
var dataview = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35106,(1),null);
om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$grid,grid);

om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$dataview,dataview);

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [grid,dataview], null);
} else {
return null;
}
});
hatti.views.table_page.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (p__35111,owner,p__35112){
var map__35113 = p__35111;
var map__35113__$1 = ((((!((map__35113 == null)))?((((map__35113.cljs$lang$protocol_mask$partition0$ & (64))) || (map__35113.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35113):map__35113);
var app_state = map__35113__$1;
var map__35114 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35113__$1,cljs.core.cst$kw$views);
var map__35114__$1 = ((((!((map__35114 == null)))?((((map__35114.cljs$lang$protocol_mask$partition0$ & (64))) || (map__35114.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35114):map__35114);
var active = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35114__$1,cljs.core.cst$kw$active);
var map__35115 = p__35112;
var map__35115__$1 = ((((!((map__35115 == null)))?((((map__35115.cljs$lang$protocol_mask$partition0$ & (64))) || (map__35115.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35115):map__35115);
var opts = map__35115__$1;
var slick_grid_event_handlers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35115__$1,cljs.core.cst$kw$slick_DASH_grid_DASH_event_DASH_handlers);

var active_QMARK_ = chimera.seq.in_QMARK_(active,cljs.core.cst$kw$table);
if(typeof hatti.views.table.t_hatti$views$table35119 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {om.core.IWillReceiveProps}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IDidMount}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table35119 = (function (p__35112,p__35111,owner,map__35113,map__35115,active_QMARK_,slick_grid_event_handlers,map__35114,app_state,active,opts,meta35120){
this.p__35112 = p__35112;
this.p__35111 = p__35111;
this.owner = owner;
this.map__35113 = map__35113;
this.map__35115 = map__35115;
this.active_QMARK_ = active_QMARK_;
this.slick_grid_event_handlers = slick_grid_event_handlers;
this.map__35114 = map__35114;
this.app_state = app_state;
this.active = active;
this.opts = opts;
this.meta35120 = meta35120;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table35119.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (active_QMARK_,map__35113,map__35113__$1,app_state,map__35114,map__35114__$1,active,map__35115,map__35115__$1,opts,slick_grid_event_handlers){
return (function (_35121,meta35120__$1){
var self__ = this;
var _35121__$1 = this;
return (new hatti.views.table.t_hatti$views$table35119(self__.p__35112,self__.p__35111,self__.owner,self__.map__35113,self__.map__35115,self__.active_QMARK_,self__.slick_grid_event_handlers,self__.map__35114,self__.app_state,self__.active,self__.opts,meta35120__$1));
});})(active_QMARK_,map__35113,map__35113__$1,app_state,map__35114,map__35114__$1,active,map__35115,map__35115__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table35119.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (active_QMARK_,map__35113,map__35113__$1,app_state,map__35114,map__35114__$1,active,map__35115,map__35115__$1,opts,slick_grid_event_handlers){
return (function (_35121){
var self__ = this;
var _35121__$1 = this;
return self__.meta35120;
});})(active_QMARK_,map__35113,map__35113__$1,app_state,map__35114,map__35114__$1,active,map__35115,map__35115__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table35119.prototype.om$core$IRender$ = true;

hatti.views.table.t_hatti$views$table35119.prototype.om$core$IRender$render$arity$1 = ((function (active_QMARK_,map__35113,map__35113__$1,app_state,map__35114,map__35114__$1,active,map__35115,map__35115__$1,opts,slick_grid_event_handlers){
return (function (_){
var self__ = this;
var ___$1 = this;
var no_data_QMARK_ = cljs.core.empty_QMARK_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data], null)));
var map__35122 = cljs.core.cst$kw$dataset_DASH_info.cljs$core$IFn$_invoke$arity$1(self__.app_state);
var map__35122__$1 = ((((!((map__35122 == null)))?((((map__35122.cljs$lang$protocol_mask$partition0$ & (64))) || (map__35122.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35122):map__35122);
var dataset_info = map__35122__$1;
var num_of_submissions = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35122__$1,cljs.core.cst$kw$num_of_submissions);
var with_info = ((function (no_data_QMARK_,map__35122,map__35122__$1,dataset_info,num_of_submissions,___$1,active_QMARK_,map__35113,map__35113__$1,app_state,map__35114,map__35114__$1,active,map__35115,map__35115__$1,opts,slick_grid_event_handlers){
return (function (p1__35110_SHARP_){
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([p1__35110_SHARP_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$dataset_DASH_info,dataset_info], null)], 0));
});})(no_data_QMARK_,map__35122,map__35122__$1,dataset_info,num_of_submissions,___$1,active_QMARK_,map__35113,map__35113__$1,app_state,map__35114,map__35114__$1,active,map__35115,map__35115__$1,opts,slick_grid_event_handlers))
;
if(cljs.core.truth_(self__.active_QMARK_)){
var attrs35124 = om.core.build.cljs$core$IFn$_invoke$arity$3(hatti.views.submission_view,with_info(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.app_state,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$table_DASH_page,cljs.core.cst$kw$submission_DASH_clicked], null))),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$opts,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.select_keys(self__.opts,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$role,null,cljs.core.cst$kw$delete_DASH_record_BANG_,null], null), null)),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$view,cljs.core.cst$kw$table], null)], 0))], null));
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(React.DOM.div,((cljs.core.map_QMARK_(attrs35124))?sablono.interpreter.attributes(sablono.util.merge_with_class.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["table-view"], null)], null),attrs35124], 0))):({"className": "table-view"})),cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,((cljs.core.map_QMARK_(attrs35124))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret(om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.views.table_header,self__.app_state)),(function (){var G__35125 = ({"id": hatti.views.table.table_id, "className": "slickgrid"});
var G__35126 = (((no_data_QMARK_) && ((num_of_submissions === (0))))?(function (){var G__35131 = ({"className": "alert alert-warning"});
var G__35132 = "No data";
return React.DOM.p(G__35131,G__35132);
})():(function (){var G__35133 = null;
var G__35134 = (function (){var G__35136 = ({"className": "fa fa-spinner fa-pulse"});
return React.DOM.i(G__35136);
})();
var G__35135 = "Loading...";
return React.DOM.span(G__35133,G__35134,G__35135);
})());
return React.DOM.div(G__35125,G__35126);
})()], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret(attrs35124),sablono.interpreter.interpret(om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.views.table_header,self__.app_state)),(function (){var G__35137 = ({"id": hatti.views.table.table_id, "className": "slickgrid"});
var G__35138 = (((no_data_QMARK_) && ((num_of_submissions === (0))))?(function (){var G__35143 = ({"className": "alert alert-warning"});
var G__35144 = "No data";
return React.DOM.p(G__35143,G__35144);
})():(function (){var G__35145 = null;
var G__35146 = (function (){var G__35148 = ({"className": "fa fa-spinner fa-pulse"});
return React.DOM.i(G__35148);
})();
var G__35147 = "Loading...";
return React.DOM.span(G__35145,G__35146,G__35147);
})());
return React.DOM.div(G__35137,G__35138);
})()], null))));
} else {
return null;
}
});})(active_QMARK_,map__35113,map__35113__$1,app_state,map__35114,map__35114__$1,active,map__35115,map__35115__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table35119.prototype.om$core$IDidMount$ = true;

hatti.views.table.t_hatti$views$table35119.prototype.om$core$IDidMount$did_mount$arity$1 = ((function (active_QMARK_,map__35113,map__35113__$1,app_state,map__35114,map__35114__$1,active,map__35115,map__35115__$1,opts,slick_grid_event_handlers){
return (function (_){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.active_QMARK_)){
var data = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data], null));
var temp__4657__auto__ = hatti.views.table.init_grid_BANG_(data,self__.owner,self__.slick_grid_event_handlers);
if(cljs.core.truth_(temp__4657__auto__)){
var vec__35149 = temp__4657__auto__;
var grid = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35149,(0),null);
var dataview = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35149,(1),null);
return hatti.views.table.handle_table_events(self__.app_state,grid,dataview);
} else {
return null;
}
} else {
return null;
}
});})(active_QMARK_,map__35113,map__35113__$1,app_state,map__35114,map__35114__$1,active,map__35115,map__35115__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table35119.prototype.om$core$IWillReceiveProps$ = true;

hatti.views.table.t_hatti$views$table35119.prototype.om$core$IWillReceiveProps$will_receive_props$arity$2 = ((function (active_QMARK_,map__35113,map__35113__$1,app_state,map__35114,map__35114__$1,active,map__35115,map__35115__$1,opts,slick_grid_event_handlers){
return (function (_,next_props){
var self__ = this;
var ___$1 = this;

if(cljs.core.truth_(self__.active_QMARK_)){
var old_data = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(om.core.get_props.cljs$core$IFn$_invoke$arity$1(self__.owner),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data], null));
var new_data = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(next_props,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data], null));
var map__35152 = om.core.get_state.cljs$core$IFn$_invoke$arity$1(self__.owner);
var map__35152__$1 = ((((!((map__35152 == null)))?((((map__35152.cljs$lang$protocol_mask$partition0$ & (64))) || (map__35152.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35152):map__35152);
var grid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35152__$1,cljs.core.cst$kw$grid);
var dataview = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35152__$1,cljs.core.cst$kw$dataview);
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(old_data,new_data)){
if(cljs.core.empty_QMARK_(old_data)){
var temp__4657__auto__ = hatti.views.table.init_grid_BANG_(new_data,self__.owner,self__.slick_grid_event_handlers);
if(cljs.core.truth_(temp__4657__auto__)){
var vec__35154 = temp__4657__auto__;
var grid__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35154,(0),null);
var dataview__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35154,(1),null);
return hatti.views.table.handle_table_events(self__.app_state,grid__$1,dataview__$1);
} else {
return null;
}
} else {
grid.invalidateAllRows();

dataview.setItems(cljs.core.clj__GT_js(new_data),hatti.constants._id);

return grid.render();
}
} else {
return null;
}
} else {
return null;
}
});})(active_QMARK_,map__35113,map__35113__$1,app_state,map__35114,map__35114__$1,active,map__35115,map__35115__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table35119.getBasis = ((function (active_QMARK_,map__35113,map__35113__$1,app_state,map__35114,map__35114__$1,active,map__35115,map__35115__$1,opts,slick_grid_event_handlers){
return (function (){
return new cljs.core.PersistentVector(null, 12, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p__35112,cljs.core.cst$sym$p__35111,cljs.core.cst$sym$owner,cljs.core.cst$sym$map__35113,cljs.core.cst$sym$map__35115,cljs.core.cst$sym$active_QMARK_,cljs.core.cst$sym$slick_DASH_grid_DASH_event_DASH_handlers,cljs.core.cst$sym$map__35114,cljs.core.cst$sym$app_DASH_state,cljs.core.cst$sym$active,cljs.core.cst$sym$opts,cljs.core.cst$sym$meta35120], null);
});})(active_QMARK_,map__35113,map__35113__$1,app_state,map__35114,map__35114__$1,active,map__35115,map__35115__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table35119.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table35119.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table35119";

hatti.views.table.t_hatti$views$table35119.cljs$lang$ctorPrWriter = ((function (active_QMARK_,map__35113,map__35113__$1,app_state,map__35114,map__35114__$1,active,map__35115,map__35115__$1,opts,slick_grid_event_handlers){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"hatti.views.table/t_hatti$views$table35119");
});})(active_QMARK_,map__35113,map__35113__$1,app_state,map__35114,map__35114__$1,active,map__35115,map__35115__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.__GT_t_hatti$views$table35119 = ((function (active_QMARK_,map__35113,map__35113__$1,app_state,map__35114,map__35114__$1,active,map__35115,map__35115__$1,opts,slick_grid_event_handlers){
return (function hatti$views$table$__GT_t_hatti$views$table35119(p__35112__$1,p__35111__$1,owner__$1,map__35113__$2,map__35115__$2,active_QMARK___$1,slick_grid_event_handlers__$1,map__35114__$2,app_state__$1,active__$1,opts__$1,meta35120){
return (new hatti.views.table.t_hatti$views$table35119(p__35112__$1,p__35111__$1,owner__$1,map__35113__$2,map__35115__$2,active_QMARK___$1,slick_grid_event_handlers__$1,map__35114__$2,app_state__$1,active__$1,opts__$1,meta35120));
});})(active_QMARK_,map__35113,map__35113__$1,app_state,map__35114,map__35114__$1,active,map__35115,map__35115__$1,opts,slick_grid_event_handlers))
;

}

return (new hatti.views.table.t_hatti$views$table35119(p__35112,p__35111,owner,map__35113__$1,map__35115__$1,active_QMARK_,slick_grid_event_handlers,map__35114__$1,app_state,active,opts,cljs.core.PersistentArrayMap.EMPTY));
}));
