// Compiled by ClojureScript 1.9.229 {}
goog.provide('hatti.views.table');
goog.require('cljs.core');
goog.require('hatti.views.record');
goog.require('chimera.js_interop');
goog.require('om.dom');
goog.require('hatti.ona.forms');
goog.require('sablono.core');
goog.require('cljs.core.async');
goog.require('chimera.seq');
goog.require('hatti.shared');
goog.require('hatti.constants');
goog.require('hatti.views');
goog.require('om.core');
goog.require('hatti.utils');
goog.require('chimera.core');
goog.require('chimera.urls');
hatti.views.table.default_num_displayed_records = (25);
hatti.views.table.table_id = "submission-grid";
hatti.views.table.pager_id = "pager";
/**
 * Extra fields that will be displayed on the table.
 */
hatti.views.table.get_extra_fields = (function hatti$views$table$get_extra_fields(is_filtered_dataview_QMARK_){
var extra_field = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"full-name","full-name",408178550),hatti.constants._id,new cljs.core.Keyword(null,"label","label",1718410804),"id",new cljs.core.Keyword(null,"name","name",1843675177),hatti.constants._id,new cljs.core.Keyword(null,"type","type",1174270348),"integer"], null)], null);
if(cljs.core.truth_(is_filtered_dataview_QMARK_)){
return extra_field;
} else {
return cljs.core.conj.call(null,extra_field,hatti.ona.forms.submission_time_field);
}
});
/**
 * Given a (flat-)form, returns fields for table display.
 * Puts extra fields in the beginning, metadata at the end of the table,
 * and drops fields that have no data (eg. group/note).
 */
hatti.views.table.all_fields = (function hatti$views$table$all_fields(var_args){
var args__7491__auto__ = [];
var len__7484__auto___23139 = arguments.length;
var i__7485__auto___23140 = (0);
while(true){
if((i__7485__auto___23140 < len__7484__auto___23139)){
args__7491__auto__.push((arguments[i__7485__auto___23140]));

var G__23141 = (i__7485__auto___23140 + (1));
i__7485__auto___23140 = G__23141;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return hatti.views.table.all_fields.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

hatti.views.table.all_fields.cljs$core$IFn$_invoke$arity$variadic = (function (form,p__23136){
var map__23137 = p__23136;
var map__23137__$1 = ((((!((map__23137 == null)))?((((map__23137.cljs$lang$protocol_mask$partition0$ & (64))) || (map__23137.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23137):map__23137);
var is_filtered_dataview_QMARK_ = cljs.core.get.call(null,map__23137__$1,new cljs.core.Keyword(null,"is-filtered-dataview?","is-filtered-dataview?",456678746));
return cljs.core.distinct.call(null,cljs.core.filter.call(null,hatti.ona.forms.has_data_QMARK_,cljs.core.concat.call(null,hatti.views.table.get_extra_fields.call(null,is_filtered_dataview_QMARK_),hatti.ona.forms.non_meta_fields.call(null,form),hatti.ona.forms.meta_fields.call(null,form,new cljs.core.Keyword(null,"with-submission-details?","with-submission-details?",524960549),cljs.core.not.call(null,is_filtered_dataview_QMARK_)))));
});

hatti.views.table.all_fields.cljs$lang$maxFixedArity = (1);

hatti.views.table.all_fields.cljs$lang$applyTo = (function (seq23134){
var G__23135 = cljs.core.first.call(null,seq23134);
var seq23134__$1 = cljs.core.next.call(null,seq23134);
return hatti.views.table.all_fields.cljs$core$IFn$_invoke$arity$variadic(G__23135,seq23134__$1);
});

/**
 * Comparator function for the slickgrid dataview.
 * args.sortCol is the column being sorted, a and b are rows to compare.
 * Claims a is bigger (return 1) if value for a > b, or a is null / empty.
 */
hatti.views.table.compfn = (function hatti$views$table$compfn(args){
return (function (a,b){
var col = (args["sortCol"]);
var lower = ((function (col){
return (function (p1__23142_SHARP_){
if(typeof p1__23142_SHARP_ === 'string'){
return clojure.string.lower_case.call(null,p1__23142_SHARP_);
} else {
return p1__23142_SHARP_;
}
});})(col))
;
var aval = lower.call(null,(a[(col["field"])]));
var bval = lower.call(null,(b[(col["field"])]));
if(((aval == null)) || ((aval > bval))){
return (1);
} else {
return (-1);
}
});
});
/**
 * Filter function for the slickgrid dataview, use as (partial filterfn form)
 * item is the row, args contains query.
 * Return value of false corresponds with exclusion, true with inclusion.
 */
hatti.views.table.filterfn = (function hatti$views$table$filterfn(form,item,args){
if(cljs.core.not.call(null,args)){
return true;
} else {
var indexed_form = cljs.core.zipmap.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"full-name","full-name",408178550),form),form);
var query = (args["query"]);
var fmt_subitem = ((function (indexed_form,query){
return (function (p__23148){
var vec__23149 = p__23148;
var fname = cljs.core.nth.call(null,vec__23149,(0),null);
var answer = cljs.core.nth.call(null,vec__23149,(1),null);
return hatti.ona.forms.format_answer.call(null,cljs.core.get.call(null,indexed_form,fname),answer,null,true);
});})(indexed_form,query))
;
var filtered = cljs.core.remove.call(null,cljs.core.nil_QMARK_,cljs.core.map.call(null,((function (indexed_form,query,fmt_subitem){
return (function (p1__23143_SHARP_){
return cljs.core.re_find.call(null,chimera.js_interop.safe_regex.call(null,query),[cljs.core.str(p1__23143_SHARP_)].join(''));
});})(indexed_form,query,fmt_subitem))
,cljs.core.map.call(null,fmt_subitem,cljs.core.js__GT_clj.call(null,item))));
return cljs.core.seq.call(null,filtered);
}
});
/**
 * Formatter for slickgrid columns takes row,cell,value,columnDef,dataContext.
 * Get one with (partial formatter field language).
 */
hatti.views.table.formatter = (function hatti$views$table$formatter(field,language,row,cell,value,columnDef,dataContext){
var clj_value = cljs.core.js__GT_clj.call(null,value,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
return hatti.ona.forms.format_answer.call(null,field,clj_value,language,true);
});
cljs.core._add_method.call(null,hatti.views.action_buttons,new cljs.core.Keyword(null,"default","default",-1987822328),(function (owner){
return (function (row,cell,value,columnDef,dataContext){
var map__23152 = new cljs.core.Keyword(null,"dataset-info","dataset-info",-1196999563).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,hatti.shared.app_state));
var map__23152__$1 = ((((!((map__23152 == null)))?((((map__23152.cljs$lang$protocol_mask$partition0$ & (64))) || (map__23152.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23152):map__23152);
var owner__$1 = cljs.core.get.call(null,map__23152__$1,new cljs.core.Keyword(null,"owner","owner",-392611939));
var project = cljs.core.get.call(null,map__23152__$1,new cljs.core.Keyword(null,"project","project",1124394579));
var formid = cljs.core.get.call(null,map__23152__$1,new cljs.core.Keyword(null,"formid","formid",-2121398991));
var form_owner = chimera.urls.last_url_param.call(null,owner__$1);
var project_id = chimera.urls.last_url_param.call(null,project);
var edit_link = chimera.urls.url.call(null,form_owner,project_id,formid,[cljs.core.str("webform?instance-id="),cljs.core.str(value)].join(''));
return hatti.utils.generate_html.call(null,(cljs.core.truth_(value)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ul","ul",-1349521403),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li.tooltip","li.tooltip",-1420587330),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span.tip-info.right","span.tip-info.right",-1208244295),"View"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a.view-record","a.view-record",235834372),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"i.fa.fa-clone","i.fa.fa-clone",1946695810),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"data-id","data-id",1023855591),value], null)], null)], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li.tooltip","li.tooltip",-1420587330),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span.tip-info.right","span.tip-info.right",-1208244295),"Edit"], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a.edit-record","a.edit-record",698797771),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"data-id","data-id",1023855591),value,new cljs.core.Keyword(null,"target","target",253001721),"_blank",new cljs.core.Keyword(null,"href","href",-793805698),edit_link], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"i.fa.fa-pencil-square-o","i.fa.fa-pencil-square-o",1550650091)], null)], null)], null)], null):null));
});
}));
/**
 * The html needed for a column name as a string.
 * String, String, Bool -> String
 */
hatti.views.table.column_name_html_string = (function hatti$views$table$column_name_html_string(column_class,label,hxl){
return [cljs.core.str("<div class=\""),cljs.core.str(column_class),cljs.core.str("\">"),cljs.core.str(label),cljs.core.str("</div>"),cljs.core.str((cljs.core.truth_(hxl)?[cljs.core.str("<div class=\"hxl-row\">"),cljs.core.str(hxl),cljs.core.str("</div>")].join(''):null))].join('');
});
hatti.views.table.actions_column = (function hatti$views$table$actions_column(owner,has_hxl_QMARK_){
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"headerCssClass","headerCssClass",-1721145883),new cljs.core.Keyword(null,"maxWidth","maxWidth",-1375124795),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"formatter","formatter",-483008823),new cljs.core.Keyword(null,"field","field",-1302436500),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"sortable","sortable",2109633621),new cljs.core.Keyword(null,"cssClass","cssClass",264048890),new cljs.core.Keyword(null,"toolTip","toolTip",-228608737)],[[cljs.core.str((cljs.core.truth_(has_hxl_QMARK_)?"hxl-min-height ":null)),cljs.core.str("record-actions header")].join(''),(70),"",hatti.views.action_buttons.call(null,owner),hatti.constants._id,"text","actions",false,"record-actions",""]);
});
/**
 * Get a set of slick grid column objects when given a flat form.
 */
hatti.views.table.flat_form__GT_sg_columns = (function hatti$views$table$flat_form__GT_sg_columns(var_args){
var args23155 = [];
var len__7484__auto___23185 = arguments.length;
var i__7485__auto___23186 = (0);
while(true){
if((i__7485__auto___23186 < len__7484__auto___23185)){
args23155.push((arguments[i__7485__auto___23186]));

var G__23187 = (i__7485__auto___23186 + (1));
i__7485__auto___23186 = G__23187;
continue;
} else {
}
break;
}

var G__23161 = args23155.length;
switch (G__23161) {
case 1:
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__7503__auto__ = (new cljs.core.IndexedSeq(args23155.slice((3)),(0),null));
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7503__auto__);

}
});

hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$1 = (function (form){
return hatti.views.table.flat_form__GT_sg_columns.call(null,form,true);
});

hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$2 = (function (form,get_label_QMARK_){
return hatti.views.table.flat_form__GT_sg_columns.call(null,form,get_label_QMARK_,null);
});

hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic = (function (form,get_label_QMARK_,language,p__23162){
var map__23163 = p__23162;
var map__23163__$1 = ((((!((map__23163 == null)))?((((map__23163.cljs$lang$protocol_mask$partition0$ & (64))) || (map__23163.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23163):map__23163);
var is_filtered_dataview_QMARK_ = cljs.core.get.call(null,map__23163__$1,new cljs.core.Keyword(null,"is-filtered-dataview?","is-filtered-dataview?",456678746));
var owner = cljs.core.get.call(null,map__23163__$1,new cljs.core.Keyword(null,"owner","owner",-392611939));
var has_hxl_QMARK_ = chimera.core.any_QMARK_.call(null,cljs.core.false_QMARK_,cljs.core.map.call(null,((function (map__23163,map__23163__$1,is_filtered_dataview_QMARK_,owner){
return (function (p1__23154_SHARP_){
return (new cljs.core.Keyword(null,"hxl","hxl",-849576989).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"instance","instance",-2121349050).cljs$core$IFn$_invoke$arity$1(p1__23154_SHARP_)) == null);
});})(map__23163,map__23163__$1,is_filtered_dataview_QMARK_,owner))
,form));
var columns = (function (){var iter__7189__auto__ = ((function (has_hxl_QMARK_,map__23163,map__23163__$1,is_filtered_dataview_QMARK_,owner){
return (function hatti$views$table$iter__23165(s__23166){
return (new cljs.core.LazySeq(null,((function (has_hxl_QMARK_,map__23163,map__23163__$1,is_filtered_dataview_QMARK_,owner){
return (function (){
var s__23166__$1 = s__23166;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__23166__$1);
if(temp__4657__auto__){
var s__23166__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__23166__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__23166__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__23168 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__23167 = (0);
while(true){
if((i__23167 < size__7188__auto__)){
var field = cljs.core._nth.call(null,c__7187__auto__,i__23167);
cljs.core.chunk_append.call(null,b__23168,(function (){var map__23177 = field;
var map__23177__$1 = ((((!((map__23177 == null)))?((((map__23177.cljs$lang$protocol_mask$partition0$ & (64))) || (map__23177.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23177):map__23177);
var map__23178 = cljs.core.get.call(null,map__23177__$1,new cljs.core.Keyword(null,"instance","instance",-2121349050));
var map__23178__$1 = ((((!((map__23178 == null)))?((((map__23178.cljs$lang$protocol_mask$partition0$ & (64))) || (map__23178.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23178):map__23178);
var hxl = cljs.core.get.call(null,map__23178__$1,new cljs.core.Keyword(null,"hxl","hxl",-849576989));
var name = cljs.core.get.call(null,map__23177__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var type = cljs.core.get.call(null,map__23177__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var full_name = cljs.core.get.call(null,map__23177__$1,new cljs.core.Keyword(null,"full-name","full-name",408178550));
var label = (cljs.core.truth_(get_label_QMARK_)?hatti.ona.forms.get_label.call(null,field,language):name);
var column_class = hatti.ona.forms.get_column_class.call(null,field);
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"hxl","hxl",-849576989),new cljs.core.Keyword(null,"headerCssClass","headerCssClass",-1721145883),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"formatter","formatter",-483008823),new cljs.core.Keyword(null,"minWidth","minWidth",-204293526),new cljs.core.Keyword(null,"field","field",-1302436500),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"sortable","sortable",2109633621),new cljs.core.Keyword(null,"cssClass","cssClass",264048890),new cljs.core.Keyword(null,"toolTip","toolTip",-228608737)],[hxl,(cljs.core.truth_(has_hxl_QMARK_)?"hxl-min-height":null),hatti.views.table.column_name_html_string.call(null,column_class,label,hxl),cljs.core.partial.call(null,hatti.views.table.formatter,field,language),(50),full_name,type,name,true,column_class,label]);
})());

var G__23189 = (i__23167 + (1));
i__23167 = G__23189;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__23168),hatti$views$table$iter__23165.call(null,cljs.core.chunk_rest.call(null,s__23166__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__23168),null);
}
} else {
var field = cljs.core.first.call(null,s__23166__$2);
return cljs.core.cons.call(null,(function (){var map__23181 = field;
var map__23181__$1 = ((((!((map__23181 == null)))?((((map__23181.cljs$lang$protocol_mask$partition0$ & (64))) || (map__23181.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23181):map__23181);
var map__23182 = cljs.core.get.call(null,map__23181__$1,new cljs.core.Keyword(null,"instance","instance",-2121349050));
var map__23182__$1 = ((((!((map__23182 == null)))?((((map__23182.cljs$lang$protocol_mask$partition0$ & (64))) || (map__23182.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23182):map__23182);
var hxl = cljs.core.get.call(null,map__23182__$1,new cljs.core.Keyword(null,"hxl","hxl",-849576989));
var name = cljs.core.get.call(null,map__23181__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var type = cljs.core.get.call(null,map__23181__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var full_name = cljs.core.get.call(null,map__23181__$1,new cljs.core.Keyword(null,"full-name","full-name",408178550));
var label = (cljs.core.truth_(get_label_QMARK_)?hatti.ona.forms.get_label.call(null,field,language):name);
var column_class = hatti.ona.forms.get_column_class.call(null,field);
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"hxl","hxl",-849576989),new cljs.core.Keyword(null,"headerCssClass","headerCssClass",-1721145883),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"formatter","formatter",-483008823),new cljs.core.Keyword(null,"minWidth","minWidth",-204293526),new cljs.core.Keyword(null,"field","field",-1302436500),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"sortable","sortable",2109633621),new cljs.core.Keyword(null,"cssClass","cssClass",264048890),new cljs.core.Keyword(null,"toolTip","toolTip",-228608737)],[hxl,(cljs.core.truth_(has_hxl_QMARK_)?"hxl-min-height":null),hatti.views.table.column_name_html_string.call(null,column_class,label,hxl),cljs.core.partial.call(null,hatti.views.table.formatter,field,language),(50),full_name,type,name,true,column_class,label]);
})(),hatti$views$table$iter__23165.call(null,cljs.core.rest.call(null,s__23166__$2)));
}
} else {
return null;
}
break;
}
});})(has_hxl_QMARK_,map__23163,map__23163__$1,is_filtered_dataview_QMARK_,owner))
,null,null));
});})(has_hxl_QMARK_,map__23163,map__23163__$1,is_filtered_dataview_QMARK_,owner))
;
return iter__7189__auto__.call(null,hatti.views.table.all_fields.call(null,form,new cljs.core.Keyword(null,"is-filtered-dataview?","is-filtered-dataview?",456678746),is_filtered_dataview_QMARK_));
})();
return cljs.core.clj__GT_js.call(null,cljs.core.conj.call(null,columns,hatti.views.table.actions_column.call(null,owner,has_hxl_QMARK_)));
});

hatti.views.table.flat_form__GT_sg_columns.cljs$lang$applyTo = (function (seq23156){
var G__23157 = cljs.core.first.call(null,seq23156);
var seq23156__$1 = cljs.core.next.call(null,seq23156);
var G__23158 = cljs.core.first.call(null,seq23156__$1);
var seq23156__$2 = cljs.core.next.call(null,seq23156__$1);
var G__23159 = cljs.core.first.call(null,seq23156__$2);
var seq23156__$3 = cljs.core.next.call(null,seq23156__$2);
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic(G__23157,G__23158,G__23159,seq23156__$3);
});

hatti.views.table.flat_form__GT_sg_columns.cljs$lang$maxFixedArity = (3);

hatti.views.table.init_sg_pager = (function hatti$views$table$init_sg_pager(grid,dataview){
var Pager = Slick.Controls.Pager;
return (new Pager(dataview,grid,jQuery([cljs.core.str("#"),cljs.core.str(hatti.views.table.pager_id)].join(''))));
});
hatti.views.table.resizeColumns = (function hatti$views$table$resizeColumns(grid){
return grid.registerPlugin(Slick.AutoColumnSize());
});
/**
 * Options to feed the slickgrid constructor.
 */
hatti.views.table.sg_options = ({"autoHeight": true, "enableColumnReorder": false, "enableTextSelectionOnCells": true, "rowHeight": (40), "syncColumnCellResize": false});
/**
 * Fixes the first column on slick table on horizontal scroll
 */
hatti.views.table.freeze_action_column_BANG_ = (function hatti$views$table$freeze_action_column_BANG_(){
var actions = document.getElementsByClassName("record-actions");
var sg_viewport = cljs.core.first.call(null,document.getElementsByClassName("slick-viewport"));
var seq__23195 = cljs.core.seq.call(null,actions);
var chunk__23196 = null;
var count__23197 = (0);
var i__23198 = (0);
while(true){
if((i__23198 < count__23197)){
var action = cljs.core._nth.call(null,chunk__23196,i__23198);
var leftOffset_23199 = parseInt(action.offsetLeft);
sg_viewport.addEventListener("scroll",((function (seq__23195,chunk__23196,count__23197,i__23198,leftOffset_23199,action,actions,sg_viewport){
return (function (){
var sl = sg_viewport.scrollLeft;
var set_border_BANG_ = ((function (seq__23195,chunk__23196,count__23197,i__23198,sl,leftOffset_23199,action,actions,sg_viewport){
return (function (p1__23190_SHARP_){
return action.style.borderRight = p1__23190_SHARP_;
});})(seq__23195,chunk__23196,count__23197,i__23198,sl,leftOffset_23199,action,actions,sg_viewport))
;
if((sl === (0))){
set_border_BANG_.call(null,"1px dotted #ededed");
} else {
set_border_BANG_.call(null,"1px solid silver");
}

return action.style.left = [cljs.core.str((sl + leftOffset_23199)),cljs.core.str("px")].join('');
});})(seq__23195,chunk__23196,count__23197,i__23198,leftOffset_23199,action,actions,sg_viewport))
);

var G__23200 = seq__23195;
var G__23201 = chunk__23196;
var G__23202 = count__23197;
var G__23203 = (i__23198 + (1));
seq__23195 = G__23200;
chunk__23196 = G__23201;
count__23197 = G__23202;
i__23198 = G__23203;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__23195);
if(temp__4657__auto__){
var seq__23195__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__23195__$1)){
var c__7220__auto__ = cljs.core.chunk_first.call(null,seq__23195__$1);
var G__23204 = cljs.core.chunk_rest.call(null,seq__23195__$1);
var G__23205 = c__7220__auto__;
var G__23206 = cljs.core.count.call(null,c__7220__auto__);
var G__23207 = (0);
seq__23195 = G__23204;
chunk__23196 = G__23205;
count__23197 = G__23206;
i__23198 = G__23207;
continue;
} else {
var action = cljs.core.first.call(null,seq__23195__$1);
var leftOffset_23208 = parseInt(action.offsetLeft);
sg_viewport.addEventListener("scroll",((function (seq__23195,chunk__23196,count__23197,i__23198,leftOffset_23208,action,seq__23195__$1,temp__4657__auto__,actions,sg_viewport){
return (function (){
var sl = sg_viewport.scrollLeft;
var set_border_BANG_ = ((function (seq__23195,chunk__23196,count__23197,i__23198,sl,leftOffset_23208,action,seq__23195__$1,temp__4657__auto__,actions,sg_viewport){
return (function (p1__23190_SHARP_){
return action.style.borderRight = p1__23190_SHARP_;
});})(seq__23195,chunk__23196,count__23197,i__23198,sl,leftOffset_23208,action,seq__23195__$1,temp__4657__auto__,actions,sg_viewport))
;
if((sl === (0))){
set_border_BANG_.call(null,"1px dotted #ededed");
} else {
set_border_BANG_.call(null,"1px solid silver");
}

return action.style.left = [cljs.core.str((sl + leftOffset_23208)),cljs.core.str("px")].join('');
});})(seq__23195,chunk__23196,count__23197,i__23198,leftOffset_23208,action,seq__23195__$1,temp__4657__auto__,actions,sg_viewport))
);

var G__23209 = cljs.core.next.call(null,seq__23195__$1);
var G__23210 = null;
var G__23211 = (0);
var G__23212 = (0);
seq__23195 = G__23209;
chunk__23196 = G__23210;
count__23197 = G__23211;
i__23198 = G__23212;
continue;
}
} else {
return null;
}
}
break;
}
});
hatti.views.table.bind_external_sg_grid_event_handlers = (function hatti$views$table$bind_external_sg_grid_event_handlers(grid,event_handlers){
return cljs.core.doall.call(null,(function (){var iter__7189__auto__ = (function hatti$views$table$bind_external_sg_grid_event_handlers_$_iter__23229(s__23230){
return (new cljs.core.LazySeq(null,(function (){
var s__23230__$1 = s__23230;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__23230__$1);
if(temp__4657__auto__){
var s__23230__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__23230__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__23230__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__23232 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__23231 = (0);
while(true){
if((i__23231 < size__7188__auto__)){
var vec__23239 = cljs.core._nth.call(null,c__7187__auto__,i__23231);
var handler_key = cljs.core.nth.call(null,vec__23239,(0),null);
var handler_function = cljs.core.nth.call(null,vec__23239,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case.call(null,cljs.core.name.call(null,handler_key));
var event = (grid[handler_name]);
cljs.core.chunk_append.call(null,b__23232,event.subscribe(handler_function));

var G__23245 = (i__23231 + (1));
i__23231 = G__23245;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__23232),hatti$views$table$bind_external_sg_grid_event_handlers_$_iter__23229.call(null,cljs.core.chunk_rest.call(null,s__23230__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__23232),null);
}
} else {
var vec__23242 = cljs.core.first.call(null,s__23230__$2);
var handler_key = cljs.core.nth.call(null,vec__23242,(0),null);
var handler_function = cljs.core.nth.call(null,vec__23242,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case.call(null,cljs.core.name.call(null,handler_key));
var event = (grid[handler_name]);
return cljs.core.cons.call(null,event.subscribe(handler_function),hatti$views$table$bind_external_sg_grid_event_handlers_$_iter__23229.call(null,cljs.core.rest.call(null,s__23230__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__.call(null,event_handlers);
})());
});
hatti.views.table.bind_external_sg_grid_dataview_handlers = (function hatti$views$table$bind_external_sg_grid_dataview_handlers(dataview,event_handlers){
return cljs.core.doall.call(null,(function (){var iter__7189__auto__ = (function hatti$views$table$bind_external_sg_grid_dataview_handlers_$_iter__23262(s__23263){
return (new cljs.core.LazySeq(null,(function (){
var s__23263__$1 = s__23263;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__23263__$1);
if(temp__4657__auto__){
var s__23263__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__23263__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__23263__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__23265 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__23264 = (0);
while(true){
if((i__23264 < size__7188__auto__)){
var vec__23272 = cljs.core._nth.call(null,c__7187__auto__,i__23264);
var handler_key = cljs.core.nth.call(null,vec__23272,(0),null);
var handler_function = cljs.core.nth.call(null,vec__23272,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case.call(null,cljs.core.name.call(null,handler_key));
var event = (dataview[handler_name]);
cljs.core.chunk_append.call(null,b__23265,event.subscribe(handler_function));

var G__23278 = (i__23264 + (1));
i__23264 = G__23278;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__23265),hatti$views$table$bind_external_sg_grid_dataview_handlers_$_iter__23262.call(null,cljs.core.chunk_rest.call(null,s__23263__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__23265),null);
}
} else {
var vec__23275 = cljs.core.first.call(null,s__23263__$2);
var handler_key = cljs.core.nth.call(null,vec__23275,(0),null);
var handler_function = cljs.core.nth.call(null,vec__23275,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case.call(null,cljs.core.name.call(null,handler_key));
var event = (dataview[handler_name]);
return cljs.core.cons.call(null,event.subscribe(handler_function),hatti$views$table$bind_external_sg_grid_dataview_handlers_$_iter__23262.call(null,cljs.core.rest.call(null,s__23263__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__.call(null,event_handlers);
})());
});
/**
 * Creates a Slick.Grid backed by Slick.Data.DataView from data and fields.
 * Most events are handled by slickgrid. On double-click, event is put on chan.
 * Returns [grid dataview].
 */
hatti.views.table.sg_init = (function hatti$views$table$sg_init(data,form,current_language,is_filtered_dataview_QMARK_,owner,p__23279){
var map__23288 = p__23279;
var map__23288__$1 = ((((!((map__23288 == null)))?((((map__23288.cljs$lang$protocol_mask$partition0$ & (64))) || (map__23288.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23288):map__23288);
var grid_event_handlers = cljs.core.get.call(null,map__23288__$1,new cljs.core.Keyword(null,"grid-event-handlers","grid-event-handlers",1413592355));
var dataview_event_handlers = cljs.core.get.call(null,map__23288__$1,new cljs.core.Keyword(null,"dataview-event-handlers","dataview-event-handlers",-916375885));
var columns = hatti.views.table.flat_form__GT_sg_columns.call(null,form,true,current_language,new cljs.core.Keyword(null,"is-filtered-dataview?","is-filtered-dataview?",456678746),is_filtered_dataview_QMARK_,new cljs.core.Keyword(null,"owner","owner",-392611939),owner);
var SlickGrid = Slick.Grid;
var DataView = Slick.Data.DataView;
var dataview = (new DataView());
var grid = (new SlickGrid([cljs.core.str("#"),cljs.core.str(hatti.views.table.table_id)].join(''),dataview,columns,hatti.views.table.sg_options));
var map__23290 = cljs.core.deref.call(null,hatti.shared.app_state);
var map__23290__$1 = ((((!((map__23290 == null)))?((((map__23290.cljs$lang$protocol_mask$partition0$ & (64))) || (map__23290.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23290):map__23290);
var map__23291 = cljs.core.get.call(null,map__23290__$1,new cljs.core.Keyword(null,"table-page","table-page",1974969102));
var map__23291__$1 = ((((!((map__23291 == null)))?((((map__23291.cljs$lang$protocol_mask$partition0$ & (64))) || (map__23291.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23291):map__23291);
var map__23292 = cljs.core.get.call(null,map__23291__$1,new cljs.core.Keyword(null,"paging","paging",1716279728));
var map__23292__$1 = ((((!((map__23292 == null)))?((((map__23292.cljs$lang$protocol_mask$partition0$ & (64))) || (map__23292.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23292):map__23292);
var num_displayed_records = cljs.core.get.call(null,map__23292__$1,new cljs.core.Keyword(null,"num-displayed-records","num-displayed-records",213046400));
var total_page_count = cljs.core.get.call(null,map__23292__$1,new cljs.core.Keyword(null,"total-page-count","total-page-count",582341740));
hatti.views.table.bind_external_sg_grid_event_handlers.call(null,grid,grid_event_handlers);

hatti.views.table.bind_external_sg_grid_dataview_handlers.call(null,dataview,dataview_event_handlers);

dataview.onRowCountChanged.subscribe(((function (columns,SlickGrid,DataView,dataview,grid,map__23290,map__23290__$1,map__23291,map__23291__$1,map__23292,map__23292__$1,num_displayed_records,total_page_count,map__23288,map__23288__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
grid.updateRowCount();

return grid.render();
});})(columns,SlickGrid,DataView,dataview,grid,map__23290,map__23290__$1,map__23291,map__23291__$1,map__23292,map__23292__$1,num_displayed_records,total_page_count,map__23288,map__23288__$1,grid_event_handlers,dataview_event_handlers))
);

dataview.onRowsChanged.subscribe(((function (columns,SlickGrid,DataView,dataview,grid,map__23290,map__23290__$1,map__23291,map__23291__$1,map__23292,map__23292__$1,num_displayed_records,total_page_count,map__23288,map__23288__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
grid.invalidateRows((args["rows"]));

return grid.render();
});})(columns,SlickGrid,DataView,dataview,grid,map__23290,map__23290__$1,map__23291,map__23291__$1,map__23292,map__23292__$1,num_displayed_records,total_page_count,map__23288,map__23288__$1,grid_event_handlers,dataview_event_handlers))
);

grid.onDblClick.subscribe(((function (columns,SlickGrid,DataView,dataview,grid,map__23290,map__23290__$1,map__23291,map__23291__$1,map__23292,map__23292__$1,num_displayed_records,total_page_count,map__23288,map__23288__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
var rank = (dataview.getItem((args["row"]))[hatti.constants._rank]);
return cljs.core.async.put_BANG_.call(null,hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"submission-to-rank","submission-to-rank",1214938797),rank], null));
});})(columns,SlickGrid,DataView,dataview,grid,map__23290,map__23290__$1,map__23291,map__23291__$1,map__23292,map__23292__$1,num_displayed_records,total_page_count,map__23288,map__23288__$1,grid_event_handlers,dataview_event_handlers))
);

grid.onClick.subscribe(((function (columns,SlickGrid,DataView,dataview,grid,map__23290,map__23290__$1,map__23291,map__23291__$1,map__23292,map__23292__$1,num_displayed_records,total_page_count,map__23288,map__23288__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
var elem = e.target;
var row = dataview.getItem((args["row"]));
var elem_data_id = elem.getAttribute("data-id");
var data_id = (cljs.core.truth_(elem_data_id)?parseInt(elem.getAttribute("data-id")):null);
var id = (row[hatti.constants._id]);
var rank = (row[hatti.constants._rank]);
if(cljs.core._EQ_.call(null,id,data_id)){
return cljs.core.async.put_BANG_.call(null,hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"submission-to-rank","submission-to-rank",1214938797),rank], null));
} else {
return null;
}
});})(columns,SlickGrid,DataView,dataview,grid,map__23290,map__23290__$1,map__23291,map__23291__$1,map__23292,map__23292__$1,num_displayed_records,total_page_count,map__23288,map__23288__$1,grid_event_handlers,dataview_event_handlers))
);

hatti.views.table.init_sg_pager.call(null,grid,dataview);

dataview.setPagingOptions(({"pageSize": (function (){var or__6409__auto__ = num_displayed_records;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return hatti.views.table.default_num_displayed_records;
}
})(), "totalPages": total_page_count}));

dataview.setFilter(cljs.core.partial.call(null,hatti.views.table.filterfn,form));

dataview.setItems(cljs.core.clj__GT_js.call(null,data),hatti.constants._id);

hatti.views.table.resizeColumns.call(null,grid);

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [grid,dataview], null);
});
/**
 * Event loop for the table view. Processes a tap of share/event-chan,
 * and updates app-state/dataview/grid as needed.
 */
hatti.views.table.handle_table_events = (function hatti$views$table$handle_table_events(app_state,grid,dataview){
var event_chan = hatti.shared.event_tap.call(null);
var c__12231__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__12231__auto__,event_chan){
return (function (){
var f__12232__auto__ = (function (){var switch__12119__auto__ = ((function (c__12231__auto__,event_chan){
return (function (state_23557){
var state_val_23558 = (state_23557[(1)]);
if((state_val_23558 === (7))){
var inst_23466 = (state_23557[(7)]);
var inst_23466__$1 = (state_23557[(2)]);
var inst_23468 = (inst_23466__$1 == null);
var inst_23469 = cljs.core.not.call(null,inst_23468);
var state_23557__$1 = (function (){var statearr_23559 = state_23557;
(statearr_23559[(7)] = inst_23466__$1);

return statearr_23559;
})();
if(inst_23469){
var statearr_23560_23627 = state_23557__$1;
(statearr_23560_23627[(1)] = (8));

} else {
var statearr_23561_23628 = state_23557__$1;
(statearr_23561_23628[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23558 === (20))){
var inst_23488 = (state_23557[(8)]);
var inst_23496 = (state_23557[(9)]);
var inst_23505 = inst_23496.call(null,inst_23488);
var state_23557__$1 = state_23557;
var statearr_23562_23629 = state_23557__$1;
(statearr_23562_23629[(2)] = inst_23505);

(statearr_23562_23629[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23558 === (27))){
var state_23557__$1 = state_23557;
var statearr_23563_23630 = state_23557__$1;
(statearr_23563_23630[(2)] = null);

(statearr_23563_23630[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23558 === (1))){
var state_23557__$1 = state_23557;
var statearr_23564_23631 = state_23557__$1;
(statearr_23564_23631[(2)] = null);

(statearr_23564_23631[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23558 === (24))){
var state_23557__$1 = state_23557;
var statearr_23565_23632 = state_23557__$1;
(statearr_23565_23632[(2)] = null);

(statearr_23565_23632[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23558 === (4))){
var state_23557__$1 = state_23557;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23557__$1,(7),event_chan);
} else {
if((state_val_23558 === (15))){
var inst_23466 = (state_23557[(7)]);
var state_23557__$1 = state_23557;
var statearr_23566_23633 = state_23557__$1;
(statearr_23566_23633[(2)] = inst_23466);

(statearr_23566_23633[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23558 === (21))){
var state_23557__$1 = state_23557;
var statearr_23567_23634 = state_23557__$1;
(statearr_23567_23634[(2)] = null);

(statearr_23567_23634[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23558 === (31))){
var inst_23492 = (state_23557[(10)]);
var inst_23530 = (state_23557[(2)]);
var inst_23531 = cljs.core._EQ_.call(null,inst_23492,new cljs.core.Keyword(null,"table","table",-564943036));
var state_23557__$1 = (function (){var statearr_23568 = state_23557;
(statearr_23568[(11)] = inst_23530);

return statearr_23568;
})();
if(inst_23531){
var statearr_23569_23635 = state_23557__$1;
(statearr_23569_23635[(1)] = (32));

} else {
var statearr_23570_23636 = state_23557__$1;
(statearr_23570_23636[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23558 === (32))){
var inst_23491 = (state_23557[(12)]);
var inst_23497 = (state_23557[(13)]);
var inst_23489 = (state_23557[(14)]);
var inst_23492 = (state_23557[(10)]);
var inst_23488 = (state_23557[(8)]);
var inst_23496 = (state_23557[(9)]);
var inst_23486 = (state_23557[(15)]);
var inst_23466 = (state_23557[(7)]);
var inst_23490 = (state_23557[(16)]);
var inst_23487 = (state_23557[(17)]);
var inst_23544 = cljs.core.async.chan.call(null,(1));
var inst_23545 = (function (){var new_columns = inst_23491;
var submission_clicked = inst_23488;
var submission_unclicked = inst_23489;
var get_submission_data = inst_23497;
var map__23464 = inst_23486;
var c__12231__auto____$1 = inst_23544;
var re_render = inst_23492;
var update_data_BANG_ = inst_23496;
var submission_to_rank = inst_23487;
var e = inst_23466;
var filter_by = inst_23490;
return ((function (new_columns,submission_clicked,submission_unclicked,get_submission_data,map__23464,c__12231__auto____$1,re_render,update_data_BANG_,submission_to_rank,e,filter_by,inst_23491,inst_23497,inst_23489,inst_23492,inst_23488,inst_23496,inst_23486,inst_23466,inst_23490,inst_23487,inst_23544,state_val_23558,c__12231__auto__,event_chan){
return (function (){
var f__12232__auto__ = (function (){var switch__12119__auto__ = ((function (new_columns,submission_clicked,submission_unclicked,get_submission_data,map__23464,c__12231__auto____$1,re_render,update_data_BANG_,submission_to_rank,e,filter_by,inst_23491,inst_23497,inst_23489,inst_23492,inst_23488,inst_23496,inst_23486,inst_23466,inst_23490,inst_23487,inst_23544,state_val_23558,c__12231__auto__,event_chan){
return (function (state_23542){
var state_val_23543 = (state_23542[(1)]);
if((state_val_23543 === (1))){
var inst_23533 = cljs.core.async.timeout.call(null,(20));
var state_23542__$1 = state_23542;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23542__$1,(2),inst_23533);
} else {
if((state_val_23543 === (2))){
var inst_23535 = (state_23542[(2)]);
var inst_23536 = grid.resizeCanvas();
var inst_23537 = grid.invalidateAllRows();
var inst_23538 = hatti.views.table.resizeColumns.call(null,grid);
var inst_23539 = grid.render();
var inst_23540 = hatti.views.table.init_sg_pager.call(null,grid,dataview);
var state_23542__$1 = (function (){var statearr_23571 = state_23542;
(statearr_23571[(7)] = inst_23537);

(statearr_23571[(8)] = inst_23538);

(statearr_23571[(9)] = inst_23535);

(statearr_23571[(10)] = inst_23539);

(statearr_23571[(11)] = inst_23536);

return statearr_23571;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23542__$1,inst_23540);
} else {
return null;
}
}
});})(new_columns,submission_clicked,submission_unclicked,get_submission_data,map__23464,c__12231__auto____$1,re_render,update_data_BANG_,submission_to_rank,e,filter_by,inst_23491,inst_23497,inst_23489,inst_23492,inst_23488,inst_23496,inst_23486,inst_23466,inst_23490,inst_23487,inst_23544,state_val_23558,c__12231__auto__,event_chan))
;
return ((function (switch__12119__auto__,new_columns,submission_clicked,submission_unclicked,get_submission_data,map__23464,c__12231__auto____$1,re_render,update_data_BANG_,submission_to_rank,e,filter_by,inst_23491,inst_23497,inst_23489,inst_23492,inst_23488,inst_23496,inst_23486,inst_23466,inst_23490,inst_23487,inst_23544,state_val_23558,c__12231__auto__,event_chan){
return (function() {
var hatti$views$table$handle_table_events_$_state_machine__12120__auto__ = null;
var hatti$views$table$handle_table_events_$_state_machine__12120__auto____0 = (function (){
var statearr_23575 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23575[(0)] = hatti$views$table$handle_table_events_$_state_machine__12120__auto__);

(statearr_23575[(1)] = (1));

return statearr_23575;
});
var hatti$views$table$handle_table_events_$_state_machine__12120__auto____1 = (function (state_23542){
while(true){
var ret_value__12121__auto__ = (function (){try{while(true){
var result__12122__auto__ = switch__12119__auto__.call(null,state_23542);
if(cljs.core.keyword_identical_QMARK_.call(null,result__12122__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12122__auto__;
}
break;
}
}catch (e23576){if((e23576 instanceof Object)){
var ex__12123__auto__ = e23576;
var statearr_23577_23637 = state_23542;
(statearr_23577_23637[(5)] = ex__12123__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_23542);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e23576;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__12121__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23638 = state_23542;
state_23542 = G__23638;
continue;
} else {
return ret_value__12121__auto__;
}
break;
}
});
hatti$views$table$handle_table_events_$_state_machine__12120__auto__ = function(state_23542){
switch(arguments.length){
case 0:
return hatti$views$table$handle_table_events_$_state_machine__12120__auto____0.call(this);
case 1:
return hatti$views$table$handle_table_events_$_state_machine__12120__auto____1.call(this,state_23542);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$handle_table_events_$_state_machine__12120__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$handle_table_events_$_state_machine__12120__auto____0;
hatti$views$table$handle_table_events_$_state_machine__12120__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$handle_table_events_$_state_machine__12120__auto____1;
return hatti$views$table$handle_table_events_$_state_machine__12120__auto__;
})()
;})(switch__12119__auto__,new_columns,submission_clicked,submission_unclicked,get_submission_data,map__23464,c__12231__auto____$1,re_render,update_data_BANG_,submission_to_rank,e,filter_by,inst_23491,inst_23497,inst_23489,inst_23492,inst_23488,inst_23496,inst_23486,inst_23466,inst_23490,inst_23487,inst_23544,state_val_23558,c__12231__auto__,event_chan))
})();
var state__12233__auto__ = (function (){var statearr_23578 = f__12232__auto__.call(null);
(statearr_23578[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12231__auto____$1);

return statearr_23578;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__12233__auto__);
});
;})(new_columns,submission_clicked,submission_unclicked,get_submission_data,map__23464,c__12231__auto____$1,re_render,update_data_BANG_,submission_to_rank,e,filter_by,inst_23491,inst_23497,inst_23489,inst_23492,inst_23488,inst_23496,inst_23486,inst_23466,inst_23490,inst_23487,inst_23544,state_val_23558,c__12231__auto__,event_chan))
})();
var inst_23546 = cljs.core.async.impl.dispatch.run.call(null,inst_23545);
var state_23557__$1 = (function (){var statearr_23579 = state_23557;
(statearr_23579[(18)] = inst_23546);

return statearr_23579;
})();
var statearr_23580_23639 = state_23557__$1;
(statearr_23580_23639[(2)] = inst_23544);

(statearr_23580_23639[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23558 === (33))){
var state_23557__$1 = state_23557;
var statearr_23581_23640 = state_23557__$1;
(statearr_23581_23640[(2)] = null);

(statearr_23581_23640[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23558 === (13))){
var inst_23478 = (state_23557[(2)]);
var state_23557__$1 = state_23557;
var statearr_23582_23641 = state_23557__$1;
(statearr_23582_23641[(2)] = inst_23478);

(statearr_23582_23641[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23558 === (22))){
var inst_23489 = (state_23557[(14)]);
var inst_23508 = (state_23557[(2)]);
var state_23557__$1 = (function (){var statearr_23583 = state_23557;
(statearr_23583[(19)] = inst_23508);

return statearr_23583;
})();
if(cljs.core.truth_(inst_23489)){
var statearr_23584_23642 = state_23557__$1;
(statearr_23584_23642[(1)] = (23));

} else {
var statearr_23585_23643 = state_23557__$1;
(statearr_23585_23643[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23558 === (29))){
var inst_23490 = (state_23557[(16)]);
var inst_23522 = [new cljs.core.Keyword(null,"query","query",-1288509510)];
var inst_23523 = [inst_23490];
var inst_23524 = cljs.core.PersistentHashMap.fromArrays(inst_23522,inst_23523);
var inst_23525 = cljs.core.clj__GT_js.call(null,inst_23524);
var inst_23526 = dataview.setFilterArgs(inst_23525);
var inst_23527 = dataview.refresh();
var state_23557__$1 = (function (){var statearr_23586 = state_23557;
(statearr_23586[(20)] = inst_23526);

return statearr_23586;
})();
var statearr_23587_23644 = state_23557__$1;
(statearr_23587_23644[(2)] = inst_23527);

(statearr_23587_23644[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23558 === (6))){
var inst_23553 = (state_23557[(2)]);
var state_23557__$1 = state_23557;
var statearr_23588_23645 = state_23557__$1;
(statearr_23588_23645[(2)] = inst_23553);

(statearr_23588_23645[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23558 === (28))){
var inst_23490 = (state_23557[(16)]);
var inst_23520 = (state_23557[(2)]);
var state_23557__$1 = (function (){var statearr_23589 = state_23557;
(statearr_23589[(21)] = inst_23520);

return statearr_23589;
})();
if(cljs.core.truth_(inst_23490)){
var statearr_23590_23646 = state_23557__$1;
(statearr_23590_23646[(1)] = (29));

} else {
var statearr_23591_23647 = state_23557__$1;
(statearr_23591_23647[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23558 === (25))){
var inst_23491 = (state_23557[(12)]);
var inst_23513 = (state_23557[(2)]);
var state_23557__$1 = (function (){var statearr_23592 = state_23557;
(statearr_23592[(22)] = inst_23513);

return statearr_23592;
})();
if(cljs.core.truth_(inst_23491)){
var statearr_23593_23648 = state_23557__$1;
(statearr_23593_23648[(1)] = (26));

} else {
var statearr_23594_23649 = state_23557__$1;
(statearr_23594_23649[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23558 === (34))){
var inst_23549 = (state_23557[(2)]);
var state_23557__$1 = (function (){var statearr_23595 = state_23557;
(statearr_23595[(23)] = inst_23549);

return statearr_23595;
})();
var statearr_23596_23650 = state_23557__$1;
(statearr_23596_23650[(2)] = null);

(statearr_23596_23650[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23558 === (17))){
var inst_23497 = (state_23557[(13)]);
var inst_23496 = (state_23557[(9)]);
var inst_23487 = (state_23557[(17)]);
var inst_23499 = inst_23497.call(null,hatti.constants._rank,inst_23487);
var inst_23500 = inst_23496.call(null,inst_23499);
var state_23557__$1 = state_23557;
var statearr_23597_23651 = state_23557__$1;
(statearr_23597_23651[(2)] = inst_23500);

(statearr_23597_23651[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23558 === (3))){
var inst_23555 = (state_23557[(2)]);
var state_23557__$1 = state_23557;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23557__$1,inst_23555);
} else {
if((state_val_23558 === (12))){
var state_23557__$1 = state_23557;
var statearr_23598_23652 = state_23557__$1;
(statearr_23598_23652[(2)] = false);

(statearr_23598_23652[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23558 === (2))){
var state_23557__$1 = state_23557;
var statearr_23599_23653 = state_23557__$1;
(statearr_23599_23653[(1)] = (4));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23558 === (23))){
var inst_23496 = (state_23557[(9)]);
var inst_23510 = inst_23496.call(null,null);
var state_23557__$1 = state_23557;
var statearr_23601_23654 = state_23557__$1;
(statearr_23601_23654[(2)] = inst_23510);

(statearr_23601_23654[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23558 === (19))){
var inst_23488 = (state_23557[(8)]);
var inst_23503 = (state_23557[(2)]);
var state_23557__$1 = (function (){var statearr_23602 = state_23557;
(statearr_23602[(24)] = inst_23503);

return statearr_23602;
})();
if(cljs.core.truth_(inst_23488)){
var statearr_23603_23655 = state_23557__$1;
(statearr_23603_23655[(1)] = (20));

} else {
var statearr_23604_23656 = state_23557__$1;
(statearr_23604_23656[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23558 === (11))){
var state_23557__$1 = state_23557;
var statearr_23605_23657 = state_23557__$1;
(statearr_23605_23657[(2)] = true);

(statearr_23605_23657[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23558 === (9))){
var state_23557__$1 = state_23557;
var statearr_23606_23658 = state_23557__$1;
(statearr_23606_23658[(2)] = false);

(statearr_23606_23658[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23558 === (5))){
var state_23557__$1 = state_23557;
var statearr_23607_23659 = state_23557__$1;
(statearr_23607_23659[(2)] = null);

(statearr_23607_23659[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23558 === (14))){
var inst_23466 = (state_23557[(7)]);
var inst_23483 = cljs.core.apply.call(null,cljs.core.hash_map,inst_23466);
var state_23557__$1 = state_23557;
var statearr_23608_23660 = state_23557__$1;
(statearr_23608_23660[(2)] = inst_23483);

(statearr_23608_23660[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23558 === (26))){
var inst_23491 = (state_23557[(12)]);
var inst_23515 = grid.setColumns(inst_23491);
var inst_23516 = hatti.views.table.resizeColumns.call(null,grid);
var inst_23517 = grid.render();
var state_23557__$1 = (function (){var statearr_23609 = state_23557;
(statearr_23609[(25)] = inst_23516);

(statearr_23609[(26)] = inst_23515);

return statearr_23609;
})();
var statearr_23610_23661 = state_23557__$1;
(statearr_23610_23661[(2)] = inst_23517);

(statearr_23610_23661[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23558 === (16))){
var inst_23491 = (state_23557[(12)]);
var inst_23489 = (state_23557[(14)]);
var inst_23492 = (state_23557[(10)]);
var inst_23488 = (state_23557[(8)]);
var inst_23496 = (state_23557[(9)]);
var inst_23486 = (state_23557[(15)]);
var inst_23466 = (state_23557[(7)]);
var inst_23490 = (state_23557[(16)]);
var inst_23487 = (state_23557[(17)]);
var inst_23486__$1 = (state_23557[(2)]);
var inst_23487__$1 = cljs.core.get.call(null,inst_23486__$1,new cljs.core.Keyword(null,"submission-to-rank","submission-to-rank",1214938797));
var inst_23488__$1 = cljs.core.get.call(null,inst_23486__$1,new cljs.core.Keyword(null,"submission-clicked","submission-clicked",1228953855));
var inst_23489__$1 = cljs.core.get.call(null,inst_23486__$1,new cljs.core.Keyword(null,"submission-unclicked","submission-unclicked",-2099539520));
var inst_23490__$1 = cljs.core.get.call(null,inst_23486__$1,new cljs.core.Keyword(null,"filter-by","filter-by",-1855851983));
var inst_23491__$1 = cljs.core.get.call(null,inst_23486__$1,new cljs.core.Keyword(null,"new-columns","new-columns",-887765797));
var inst_23492__$1 = cljs.core.get.call(null,inst_23486__$1,new cljs.core.Keyword(null,"re-render","re-render",1133553258));
var inst_23493 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23494 = [new cljs.core.Keyword(null,"table-page","table-page",1974969102),new cljs.core.Keyword(null,"submission-clicked","submission-clicked",1228953855),new cljs.core.Keyword(null,"data","data",-232669377)];
var inst_23495 = (new cljs.core.PersistentVector(null,3,(5),inst_23493,inst_23494,null));
var inst_23496__$1 = cljs.core.partial.call(null,om.core.update_BANG_,app_state,inst_23495);
var inst_23497 = (function (){var e = inst_23466;
var map__23464 = inst_23486__$1;
var submission_to_rank = inst_23487__$1;
var submission_clicked = inst_23488__$1;
var submission_unclicked = inst_23489__$1;
var filter_by = inst_23490__$1;
var new_columns = inst_23491__$1;
var re_render = inst_23492__$1;
var update_data_BANG_ = inst_23496__$1;
return ((function (e,map__23464,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_23491,inst_23489,inst_23492,inst_23488,inst_23496,inst_23486,inst_23466,inst_23490,inst_23487,inst_23486__$1,inst_23487__$1,inst_23488__$1,inst_23489__$1,inst_23490__$1,inst_23491__$1,inst_23492__$1,inst_23493,inst_23494,inst_23495,inst_23496__$1,state_val_23558,c__12231__auto__,event_chan){
return (function (field,value){
return cljs.core.first.call(null,cljs.core.filter.call(null,((function (e,map__23464,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_23491,inst_23489,inst_23492,inst_23488,inst_23496,inst_23486,inst_23466,inst_23490,inst_23487,inst_23486__$1,inst_23487__$1,inst_23488__$1,inst_23489__$1,inst_23490__$1,inst_23491__$1,inst_23492__$1,inst_23493,inst_23494,inst_23495,inst_23496__$1,state_val_23558,c__12231__auto__,event_chan){
return (function (p1__23296_SHARP_){
return cljs.core._EQ_.call(null,value,cljs.core.get.call(null,p1__23296_SHARP_,field));
});})(e,map__23464,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_23491,inst_23489,inst_23492,inst_23488,inst_23496,inst_23486,inst_23466,inst_23490,inst_23487,inst_23486__$1,inst_23487__$1,inst_23488__$1,inst_23489__$1,inst_23490__$1,inst_23491__$1,inst_23492__$1,inst_23493,inst_23494,inst_23495,inst_23496__$1,state_val_23558,c__12231__auto__,event_chan))
,cljs.core.get_in.call(null,cljs.core.deref.call(null,app_state),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377)], null))));
});
;})(e,map__23464,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_23491,inst_23489,inst_23492,inst_23488,inst_23496,inst_23486,inst_23466,inst_23490,inst_23487,inst_23486__$1,inst_23487__$1,inst_23488__$1,inst_23489__$1,inst_23490__$1,inst_23491__$1,inst_23492__$1,inst_23493,inst_23494,inst_23495,inst_23496__$1,state_val_23558,c__12231__auto__,event_chan))
})();
var state_23557__$1 = (function (){var statearr_23611 = state_23557;
(statearr_23611[(12)] = inst_23491__$1);

(statearr_23611[(13)] = inst_23497);

(statearr_23611[(14)] = inst_23489__$1);

(statearr_23611[(10)] = inst_23492__$1);

(statearr_23611[(8)] = inst_23488__$1);

(statearr_23611[(9)] = inst_23496__$1);

(statearr_23611[(15)] = inst_23486__$1);

(statearr_23611[(16)] = inst_23490__$1);

(statearr_23611[(17)] = inst_23487__$1);

return statearr_23611;
})();
if(cljs.core.truth_(inst_23487__$1)){
var statearr_23612_23662 = state_23557__$1;
(statearr_23612_23662[(1)] = (17));

} else {
var statearr_23613_23663 = state_23557__$1;
(statearr_23613_23663[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23558 === (30))){
var state_23557__$1 = state_23557;
var statearr_23614_23664 = state_23557__$1;
(statearr_23614_23664[(2)] = null);

(statearr_23614_23664[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23558 === (10))){
var inst_23481 = (state_23557[(2)]);
var state_23557__$1 = state_23557;
if(cljs.core.truth_(inst_23481)){
var statearr_23615_23665 = state_23557__$1;
(statearr_23615_23665[(1)] = (14));

} else {
var statearr_23616_23666 = state_23557__$1;
(statearr_23616_23666[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23558 === (18))){
var state_23557__$1 = state_23557;
var statearr_23617_23667 = state_23557__$1;
(statearr_23617_23667[(2)] = null);

(statearr_23617_23667[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23558 === (8))){
var inst_23466 = (state_23557[(7)]);
var inst_23471 = inst_23466.cljs$lang$protocol_mask$partition0$;
var inst_23472 = (inst_23471 & (64));
var inst_23473 = inst_23466.cljs$core$ISeq$;
var inst_23474 = (inst_23472) || (inst_23473);
var state_23557__$1 = state_23557;
if(cljs.core.truth_(inst_23474)){
var statearr_23618_23668 = state_23557__$1;
(statearr_23618_23668[(1)] = (11));

} else {
var statearr_23619_23669 = state_23557__$1;
(statearr_23619_23669[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12231__auto__,event_chan))
;
return ((function (switch__12119__auto__,c__12231__auto__,event_chan){
return (function() {
var hatti$views$table$handle_table_events_$_state_machine__12120__auto__ = null;
var hatti$views$table$handle_table_events_$_state_machine__12120__auto____0 = (function (){
var statearr_23623 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23623[(0)] = hatti$views$table$handle_table_events_$_state_machine__12120__auto__);

(statearr_23623[(1)] = (1));

return statearr_23623;
});
var hatti$views$table$handle_table_events_$_state_machine__12120__auto____1 = (function (state_23557){
while(true){
var ret_value__12121__auto__ = (function (){try{while(true){
var result__12122__auto__ = switch__12119__auto__.call(null,state_23557);
if(cljs.core.keyword_identical_QMARK_.call(null,result__12122__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12122__auto__;
}
break;
}
}catch (e23624){if((e23624 instanceof Object)){
var ex__12123__auto__ = e23624;
var statearr_23625_23670 = state_23557;
(statearr_23625_23670[(5)] = ex__12123__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_23557);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e23624;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__12121__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23671 = state_23557;
state_23557 = G__23671;
continue;
} else {
return ret_value__12121__auto__;
}
break;
}
});
hatti$views$table$handle_table_events_$_state_machine__12120__auto__ = function(state_23557){
switch(arguments.length){
case 0:
return hatti$views$table$handle_table_events_$_state_machine__12120__auto____0.call(this);
case 1:
return hatti$views$table$handle_table_events_$_state_machine__12120__auto____1.call(this,state_23557);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$handle_table_events_$_state_machine__12120__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$handle_table_events_$_state_machine__12120__auto____0;
hatti$views$table$handle_table_events_$_state_machine__12120__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$handle_table_events_$_state_machine__12120__auto____1;
return hatti$views$table$handle_table_events_$_state_machine__12120__auto__;
})()
;})(switch__12119__auto__,c__12231__auto__,event_chan))
})();
var state__12233__auto__ = (function (){var statearr_23626 = f__12232__auto__.call(null);
(statearr_23626[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12231__auto__);

return statearr_23626;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__12233__auto__);
});})(c__12231__auto__,event_chan))
);

return c__12231__auto__;
});
hatti.views.table.render_options = (function hatti$views$table$render_options(options,owner,colset_BANG_){
var choose_display_key = (function (k){
om.core.set_state_BANG_.call(null,owner,new cljs.core.Keyword(null,"name-or-label","name-or-label",-520034208),k);

return colset_BANG_.call(null,k);
});
var iter__7189__auto__ = ((function (choose_display_key){
return (function hatti$views$table$render_options_$_iter__23688(s__23689){
return (new cljs.core.LazySeq(null,((function (choose_display_key){
return (function (){
var s__23689__$1 = s__23689;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__23689__$1);
if(temp__4657__auto__){
var s__23689__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__23689__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__23689__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__23691 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__23690 = (0);
while(true){
if((i__23690 < size__7188__auto__)){
var vec__23698 = cljs.core._nth.call(null,c__7187__auto__,i__23690);
var k = cljs.core.nth.call(null,vec__23698,(0),null);
var v = cljs.core.nth.call(null,vec__23698,(1),null);
cljs.core.chunk_append.call(null,b__23691,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"on-click","on-click",1632826543),hatti.utils.click_fn.call(null,((function (i__23690,vec__23698,k,v,c__7187__auto__,size__7188__auto__,b__23691,s__23689__$2,temp__4657__auto__,choose_display_key){
return (function (){
return choose_display_key.call(null,k);
});})(i__23690,vec__23698,k,v,c__7187__auto__,size__7188__auto__,b__23691,s__23689__$2,temp__4657__auto__,choose_display_key))
),new cljs.core.Keyword(null,"href","href",-793805698),"#"], null),v], null)], null));

var G__23704 = (i__23690 + (1));
i__23690 = G__23704;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__23691),hatti$views$table$render_options_$_iter__23688.call(null,cljs.core.chunk_rest.call(null,s__23689__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__23691),null);
}
} else {
var vec__23701 = cljs.core.first.call(null,s__23689__$2);
var k = cljs.core.nth.call(null,vec__23701,(0),null);
var v = cljs.core.nth.call(null,vec__23701,(1),null);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"on-click","on-click",1632826543),hatti.utils.click_fn.call(null,((function (vec__23701,k,v,s__23689__$2,temp__4657__auto__,choose_display_key){
return (function (){
return choose_display_key.call(null,k);
});})(vec__23701,k,v,s__23689__$2,temp__4657__auto__,choose_display_key))
),new cljs.core.Keyword(null,"href","href",-793805698),"#"], null),v], null)], null),hatti$views$table$render_options_$_iter__23688.call(null,cljs.core.rest.call(null,s__23689__$2)));
}
} else {
return null;
}
break;
}
});})(choose_display_key))
,null,null));
});})(choose_display_key))
;
return iter__7189__auto__.call(null,options);
});
cljs.core._add_method.call(null,hatti.views.label_changer,new cljs.core.Keyword(null,"default","default",-1987822328),(function (_,owner){
if(typeof hatti.views.table.t_hatti$views$table23706 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRenderState}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IInitState}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table23706 = (function (_,owner,meta23707){
this._ = _;
this.owner = owner;
this.meta23707 = meta23707;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table23706.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_23708,meta23707__$1){
var self__ = this;
var _23708__$1 = this;
return (new hatti.views.table.t_hatti$views$table23706(self__._,self__.owner,meta23707__$1));
});

hatti.views.table.t_hatti$views$table23706.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_23708){
var self__ = this;
var _23708__$1 = this;
return self__.meta23707;
});

hatti.views.table.t_hatti$views$table23706.prototype.om$core$IInitState$ = true;

hatti.views.table.t_hatti$views$table23706.prototype.om$core$IInitState$init_state$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"name-or-label","name-or-label",-520034208),new cljs.core.Keyword(null,"label","label",1718410804)], null);
});

hatti.views.table.t_hatti$views$table23706.prototype.om$core$IRenderState$ = true;

hatti.views.table.t_hatti$views$table23706.prototype.om$core$IRenderState$render_state$arity$2 = (function (___$1,p__23709){
var self__ = this;
var map__23710 = p__23709;
var map__23710__$1 = ((((!((map__23710 == null)))?((((map__23710.cljs$lang$protocol_mask$partition0$ & (64))) || (map__23710.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23710):map__23710);
var name_or_label = cljs.core.get.call(null,map__23710__$1,new cljs.core.Keyword(null,"name-or-label","name-or-label",-520034208));
var language = cljs.core.get.call(null,map__23710__$1,new cljs.core.Keyword(null,"language","language",-1591107564));
var ___$2 = this;
var options = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"label","label",1718410804),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"strong","strong",269529000),"Label"], null),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"strong","strong",269529000),"Name"], null)], null);
var map__23712 = om.core.get_shared.call(null,self__.owner);
var map__23712__$1 = ((((!((map__23712 == null)))?((((map__23712.cljs$lang$protocol_mask$partition0$ & (64))) || (map__23712.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23712):map__23712);
var flat_form = cljs.core.get.call(null,map__23712__$1,new cljs.core.Keyword(null,"flat-form","flat-form",-468858211));
var new_language = new cljs.core.Keyword(null,"current","current",-1088038603).cljs$core$IFn$_invoke$arity$1(om.core.observe.call(null,self__.owner,hatti.shared.language_cursor.call(null)));
var colset_BANG_ = ((function (options,map__23712,map__23712__$1,flat_form,new_language,___$2,map__23710,map__23710__$1,name_or_label,language){
return (function (p1__23705_SHARP_){
return cljs.core.async.put_BANG_.call(null,hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"new-columns","new-columns",-887765797),hatti.views.table.flat_form__GT_sg_columns.call(null,flat_form,cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"label","label",1718410804),p1__23705_SHARP_),new_language)], null));
});})(options,map__23712,map__23712__$1,flat_form,new_language,___$2,map__23710,map__23710__$1,name_or_label,language))
;
if(cljs.core.not_EQ_.call(null,new_language,language)){
om.core.set_state_BANG_.call(null,self__.owner,new cljs.core.Keyword(null,"language","language",-1591107564),new_language);

colset_BANG_.call(null,name_or_label);
} else {
}

return React.DOM.div(({"className": "label-changer"}),React.DOM.span(({"className": "label-changer-label"}),"Show:"),React.DOM.div(({"id": "header-display-dropdown", "className": "drop-hover"}),(function (){var attrs23716 = options.call(null,name_or_label);
return cljs.core.apply.call(null,React.DOM.span,((cljs.core.map_QMARK_.call(null,attrs23716))?sablono.interpreter.attributes.call(null,attrs23716):null),cljs.core.remove.call(null,cljs.core.nil_QMARK_,((cljs.core.map_QMARK_.call(null,attrs23716))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [React.DOM.i(({"className": "fa fa-angle-down"}))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret.call(null,attrs23716),React.DOM.i(({"className": "fa fa-angle-down"}))], null))));
})(),React.DOM.ul(({"className": "submenu no-dot"}),sablono.interpreter.interpret.call(null,hatti.views.table.render_options.call(null,options,self__.owner,colset_BANG_)))));
});

hatti.views.table.t_hatti$views$table23706.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.Symbol(null,"owner","owner",1247919588,null),new cljs.core.Symbol(null,"meta23707","meta23707",-483610491,null)], null);
});

hatti.views.table.t_hatti$views$table23706.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table23706.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table23706";

hatti.views.table.t_hatti$views$table23706.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"hatti.views.table/t_hatti$views$table23706");
});

hatti.views.table.__GT_t_hatti$views$table23706 = (function hatti$views$table$__GT_t_hatti$views$table23706(___$1,owner__$1,meta23707){
return (new hatti.views.table.t_hatti$views$table23706(___$1,owner__$1,meta23707));
});

}

return (new hatti.views.table.t_hatti$views$table23706(_,owner,cljs.core.PersistentArrayMap.EMPTY));
}));
/**
 * Delayed search fires a query-event on event-chan if the value of the input
 * doesn't change within 150 ms (ie, user is still typing).
 * Call on-change or on-key-up, with (.-target event) as first argument.
 */
hatti.views.table.delayed_search = (function hatti$views$table$delayed_search(input,query_event_key){
var query = input.value;
var c__12231__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__12231__auto__,query){
return (function (){
var f__12232__auto__ = (function (){var switch__12119__auto__ = ((function (c__12231__auto__,query){
return (function (state_23763){
var state_val_23764 = (state_23763[(1)]);
if((state_val_23764 === (1))){
var inst_23749 = cljs.core.async.timeout.call(null,(150));
var state_23763__$1 = state_23763;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23763__$1,(2),inst_23749);
} else {
if((state_val_23764 === (2))){
var inst_23751 = (state_23763[(2)]);
var inst_23752 = input.value;
var inst_23753 = cljs.core._EQ_.call(null,query,inst_23752);
var state_23763__$1 = (function (){var statearr_23765 = state_23763;
(statearr_23765[(7)] = inst_23751);

return statearr_23765;
})();
if(inst_23753){
var statearr_23766_23777 = state_23763__$1;
(statearr_23766_23777[(1)] = (3));

} else {
var statearr_23767_23778 = state_23763__$1;
(statearr_23767_23778[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23764 === (3))){
var inst_23755 = [query_event_key];
var inst_23756 = [query];
var inst_23757 = cljs.core.PersistentHashMap.fromArrays(inst_23755,inst_23756);
var inst_23758 = cljs.core.async.put_BANG_.call(null,hatti.shared.event_chan,inst_23757);
var state_23763__$1 = state_23763;
var statearr_23768_23779 = state_23763__$1;
(statearr_23768_23779[(2)] = inst_23758);

(statearr_23768_23779[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23764 === (4))){
var state_23763__$1 = state_23763;
var statearr_23769_23780 = state_23763__$1;
(statearr_23769_23780[(2)] = null);

(statearr_23769_23780[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23764 === (5))){
var inst_23761 = (state_23763[(2)]);
var state_23763__$1 = state_23763;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23763__$1,inst_23761);
} else {
return null;
}
}
}
}
}
});})(c__12231__auto__,query))
;
return ((function (switch__12119__auto__,c__12231__auto__,query){
return (function() {
var hatti$views$table$delayed_search_$_state_machine__12120__auto__ = null;
var hatti$views$table$delayed_search_$_state_machine__12120__auto____0 = (function (){
var statearr_23773 = [null,null,null,null,null,null,null,null];
(statearr_23773[(0)] = hatti$views$table$delayed_search_$_state_machine__12120__auto__);

(statearr_23773[(1)] = (1));

return statearr_23773;
});
var hatti$views$table$delayed_search_$_state_machine__12120__auto____1 = (function (state_23763){
while(true){
var ret_value__12121__auto__ = (function (){try{while(true){
var result__12122__auto__ = switch__12119__auto__.call(null,state_23763);
if(cljs.core.keyword_identical_QMARK_.call(null,result__12122__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12122__auto__;
}
break;
}
}catch (e23774){if((e23774 instanceof Object)){
var ex__12123__auto__ = e23774;
var statearr_23775_23781 = state_23763;
(statearr_23775_23781[(5)] = ex__12123__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_23763);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e23774;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__12121__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23782 = state_23763;
state_23763 = G__23782;
continue;
} else {
return ret_value__12121__auto__;
}
break;
}
});
hatti$views$table$delayed_search_$_state_machine__12120__auto__ = function(state_23763){
switch(arguments.length){
case 0:
return hatti$views$table$delayed_search_$_state_machine__12120__auto____0.call(this);
case 1:
return hatti$views$table$delayed_search_$_state_machine__12120__auto____1.call(this,state_23763);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$delayed_search_$_state_machine__12120__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$delayed_search_$_state_machine__12120__auto____0;
hatti$views$table$delayed_search_$_state_machine__12120__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$delayed_search_$_state_machine__12120__auto____1;
return hatti$views$table$delayed_search_$_state_machine__12120__auto__;
})()
;})(switch__12119__auto__,c__12231__auto__,query))
})();
var state__12233__auto__ = (function (){var statearr_23776 = f__12232__auto__.call(null);
(statearr_23776[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12231__auto__);

return statearr_23776;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__12233__auto__);
});})(c__12231__auto__,query))
);

return c__12231__auto__;
});
cljs.core._add_method.call(null,hatti.views.table_search,new cljs.core.Keyword(null,"default","default",-1987822328),(function (_,owner){
if(typeof hatti.views.table.t_hatti$views$table23784 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table23784 = (function (_,owner,meta23785){
this._ = _;
this.owner = owner;
this.meta23785 = meta23785;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table23784.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_23786,meta23785__$1){
var self__ = this;
var _23786__$1 = this;
return (new hatti.views.table.t_hatti$views$table23784(self__._,self__.owner,meta23785__$1));
});

hatti.views.table.t_hatti$views$table23784.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_23786){
var self__ = this;
var _23786__$1 = this;
return self__.meta23785;
});

hatti.views.table.t_hatti$views$table23784.prototype.om$core$IRender$ = true;

hatti.views.table.t_hatti$views$table23784.prototype.om$core$IRender$render$arity$1 = (function (this__16392__auto__){
var self__ = this;
var this__16392__auto____$1 = this;
return React.DOM.div(({"className": "table-search"}),React.DOM.i(({"className": "fa fa-search"})),sablono.interpreter.input.call(null,({"type": "text", "placeholder": "Search", "onChange": ((function (this__16392__auto____$1){
return (function (p1__23783_SHARP_){
return hatti.views.table.delayed_search.call(null,p1__23783_SHARP_.target,new cljs.core.Keyword(null,"filter-by","filter-by",-1855851983));
});})(this__16392__auto____$1))
})));
});

hatti.views.table.t_hatti$views$table23784.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.Symbol(null,"owner","owner",1247919588,null),new cljs.core.Symbol(null,"meta23785","meta23785",-432858738,null)], null);
});

hatti.views.table.t_hatti$views$table23784.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table23784.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table23784";

hatti.views.table.t_hatti$views$table23784.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"hatti.views.table/t_hatti$views$table23784");
});

hatti.views.table.__GT_t_hatti$views$table23784 = (function hatti$views$table$__GT_t_hatti$views$table23784(___$1,owner__$1,meta23785){
return (new hatti.views.table.t_hatti$views$table23784(___$1,owner__$1,meta23785));
});

}

return (new hatti.views.table.t_hatti$views$table23784(_,owner,null));
}));
cljs.core._add_method.call(null,hatti.views.table_header,new cljs.core.Keyword(null,"default","default",-1987822328),(function (app_state,owner){
if(typeof hatti.views.table.t_hatti$views$table23789 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table23789 = (function (app_state,owner,meta23790){
this.app_state = app_state;
this.owner = owner;
this.meta23790 = meta23790;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table23789.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_23791,meta23790__$1){
var self__ = this;
var _23791__$1 = this;
return (new hatti.views.table.t_hatti$views$table23789(self__.app_state,self__.owner,meta23790__$1));
});

hatti.views.table.t_hatti$views$table23789.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_23791){
var self__ = this;
var _23791__$1 = this;
return self__.meta23790;
});

hatti.views.table.t_hatti$views$table23789.prototype.om$core$IRender$ = true;

hatti.views.table.t_hatti$views$table23789.prototype.om$core$IRender$render$arity$1 = (function (this__16392__auto__){
var self__ = this;
var this__16392__auto____$1 = this;
return React.DOM.div(({"className": "topbar"}),React.DOM.div(({"id": hatti.views.table.pager_id})),sablono.interpreter.interpret.call(null,om.core.build.call(null,hatti.views.label_changer,null)),sablono.interpreter.interpret.call(null,om.core.build.call(null,hatti.views.table_search,self__.app_state)),React.DOM.div(({"style": ({"clear": "both"})})));
});

hatti.views.table.t_hatti$views$table23789.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"app-state","app-state",130568249,null),new cljs.core.Symbol(null,"owner","owner",1247919588,null),new cljs.core.Symbol(null,"meta23790","meta23790",816345506,null)], null);
});

hatti.views.table.t_hatti$views$table23789.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table23789.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table23789";

hatti.views.table.t_hatti$views$table23789.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"hatti.views.table/t_hatti$views$table23789");
});

hatti.views.table.__GT_t_hatti$views$table23789 = (function hatti$views$table$__GT_t_hatti$views$table23789(app_state__$1,owner__$1,meta23790){
return (new hatti.views.table.t_hatti$views$table23789(app_state__$1,owner__$1,meta23790));
});

}

return (new hatti.views.table.t_hatti$views$table23789(app_state,owner,null));
}));
hatti.views.table.init_grid_BANG_ = (function hatti$views$table$init_grid_BANG_(data,owner,slick_grid_event_handlers){

if(cljs.core.seq.call(null,data)){
var map__23799 = om.core.get_shared.call(null,owner);
var map__23799__$1 = ((((!((map__23799 == null)))?((((map__23799.cljs$lang$protocol_mask$partition0$ & (64))) || (map__23799.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23799):map__23799);
var flat_form = cljs.core.get.call(null,map__23799__$1,new cljs.core.Keyword(null,"flat-form","flat-form",-468858211));
var is_filtered_dataview_QMARK_ = cljs.core.get.call(null,map__23799__$1,new cljs.core.Keyword(null,"is-filtered-dataview?","is-filtered-dataview?",456678746));
var current_language = new cljs.core.Keyword(null,"current","current",-1088038603).cljs$core$IFn$_invoke$arity$1(om.core.observe.call(null,owner,hatti.shared.language_cursor.call(null)));
var vec__23800 = hatti.views.table.sg_init.call(null,data,flat_form,current_language,is_filtered_dataview_QMARK_,owner,slick_grid_event_handlers);
var grid = cljs.core.nth.call(null,vec__23800,(0),null);
var dataview = cljs.core.nth.call(null,vec__23800,(1),null);
om.core.set_state_BANG_.call(null,owner,new cljs.core.Keyword(null,"grid","grid",402978600),grid);

om.core.set_state_BANG_.call(null,owner,new cljs.core.Keyword(null,"dataview","dataview",91765671),dataview);

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [grid,dataview], null);
} else {
return null;
}
});
cljs.core._add_method.call(null,hatti.views.table_page,new cljs.core.Keyword(null,"default","default",-1987822328),(function (p__23805,owner,p__23806){
var map__23807 = p__23805;
var map__23807__$1 = ((((!((map__23807 == null)))?((((map__23807.cljs$lang$protocol_mask$partition0$ & (64))) || (map__23807.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23807):map__23807);
var app_state = map__23807__$1;
var map__23808 = cljs.core.get.call(null,map__23807__$1,new cljs.core.Keyword(null,"views","views",1450155487));
var map__23808__$1 = ((((!((map__23808 == null)))?((((map__23808.cljs$lang$protocol_mask$partition0$ & (64))) || (map__23808.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23808):map__23808);
var active = cljs.core.get.call(null,map__23808__$1,new cljs.core.Keyword(null,"active","active",1895962068));
var map__23809 = p__23806;
var map__23809__$1 = ((((!((map__23809 == null)))?((((map__23809.cljs$lang$protocol_mask$partition0$ & (64))) || (map__23809.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23809):map__23809);
var opts = map__23809__$1;
var slick_grid_event_handlers = cljs.core.get.call(null,map__23809__$1,new cljs.core.Keyword(null,"slick-grid-event-handlers","slick-grid-event-handlers",1990034724));

var active_QMARK_ = chimera.seq.in_QMARK_.call(null,active,new cljs.core.Keyword(null,"table","table",-564943036));
if(typeof hatti.views.table.t_hatti$views$table23813 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {om.core.IWillReceiveProps}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IDidMount}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table23813 = (function (map__23807,owner,active_QMARK_,slick_grid_event_handlers,p__23805,p__23806,map__23809,app_state,map__23808,active,opts,meta23814){
this.map__23807 = map__23807;
this.owner = owner;
this.active_QMARK_ = active_QMARK_;
this.slick_grid_event_handlers = slick_grid_event_handlers;
this.p__23805 = p__23805;
this.p__23806 = p__23806;
this.map__23809 = map__23809;
this.app_state = app_state;
this.map__23808 = map__23808;
this.active = active;
this.opts = opts;
this.meta23814 = meta23814;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table23813.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (active_QMARK_,map__23807,map__23807__$1,app_state,map__23808,map__23808__$1,active,map__23809,map__23809__$1,opts,slick_grid_event_handlers){
return (function (_23815,meta23814__$1){
var self__ = this;
var _23815__$1 = this;
return (new hatti.views.table.t_hatti$views$table23813(self__.map__23807,self__.owner,self__.active_QMARK_,self__.slick_grid_event_handlers,self__.p__23805,self__.p__23806,self__.map__23809,self__.app_state,self__.map__23808,self__.active,self__.opts,meta23814__$1));
});})(active_QMARK_,map__23807,map__23807__$1,app_state,map__23808,map__23808__$1,active,map__23809,map__23809__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table23813.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (active_QMARK_,map__23807,map__23807__$1,app_state,map__23808,map__23808__$1,active,map__23809,map__23809__$1,opts,slick_grid_event_handlers){
return (function (_23815){
var self__ = this;
var _23815__$1 = this;
return self__.meta23814;
});})(active_QMARK_,map__23807,map__23807__$1,app_state,map__23808,map__23808__$1,active,map__23809,map__23809__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table23813.prototype.om$core$IRender$ = true;

hatti.views.table.t_hatti$views$table23813.prototype.om$core$IRender$render$arity$1 = ((function (active_QMARK_,map__23807,map__23807__$1,app_state,map__23808,map__23808__$1,active,map__23809,map__23809__$1,opts,slick_grid_event_handlers){
return (function (_){
var self__ = this;
var ___$1 = this;
var no_data_QMARK_ = cljs.core.empty_QMARK_.call(null,cljs.core.get_in.call(null,self__.app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377)], null)));
var map__23816 = new cljs.core.Keyword(null,"dataset-info","dataset-info",-1196999563).cljs$core$IFn$_invoke$arity$1(self__.app_state);
var map__23816__$1 = ((((!((map__23816 == null)))?((((map__23816.cljs$lang$protocol_mask$partition0$ & (64))) || (map__23816.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23816):map__23816);
var dataset_info = map__23816__$1;
var num_of_submissions = cljs.core.get.call(null,map__23816__$1,new cljs.core.Keyword(null,"num_of_submissions","num_of_submissions",-1720943091));
var with_info = ((function (no_data_QMARK_,map__23816,map__23816__$1,dataset_info,num_of_submissions,___$1,active_QMARK_,map__23807,map__23807__$1,app_state,map__23808,map__23808__$1,active,map__23809,map__23809__$1,opts,slick_grid_event_handlers){
return (function (p1__23804_SHARP_){
return cljs.core.merge.call(null,p1__23804_SHARP_,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"dataset-info","dataset-info",-1196999563),dataset_info], null));
});})(no_data_QMARK_,map__23816,map__23816__$1,dataset_info,num_of_submissions,___$1,active_QMARK_,map__23807,map__23807__$1,app_state,map__23808,map__23808__$1,active,map__23809,map__23809__$1,opts,slick_grid_event_handlers))
;
if(cljs.core.truth_(self__.active_QMARK_)){
var attrs23818 = om.core.build.call(null,hatti.views.submission_view,with_info.call(null,cljs.core.get_in.call(null,self__.app_state,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"table-page","table-page",1974969102),new cljs.core.Keyword(null,"submission-clicked","submission-clicked",1228953855)], null))),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"opts","opts",155075701),cljs.core.merge.call(null,cljs.core.select_keys.call(null,self__.opts,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"role","role",-736691072),null,new cljs.core.Keyword(null,"delete-record!","delete-record!",1411848194),null], null), null)),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"view","view",1247994814),new cljs.core.Keyword(null,"table","table",-564943036)], null))], null));
return cljs.core.apply.call(null,React.DOM.div,((cljs.core.map_QMARK_.call(null,attrs23818))?sablono.interpreter.attributes.call(null,sablono.util.merge_with_class.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["table-view"], null)], null),attrs23818)):({"className": "table-view"})),cljs.core.remove.call(null,cljs.core.nil_QMARK_,((cljs.core.map_QMARK_.call(null,attrs23818))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret.call(null,om.core.build.call(null,hatti.views.table_header,self__.app_state)),React.DOM.div(({"id": hatti.views.table.table_id, "className": "slickgrid"}),(((no_data_QMARK_) && ((num_of_submissions === (0))))?React.DOM.p(({"className": "alert alert-warning"}),"No data"):React.DOM.span(null,React.DOM.i(({"className": "fa fa-spinner fa-pulse"})),"Loading...")))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret.call(null,attrs23818),sablono.interpreter.interpret.call(null,om.core.build.call(null,hatti.views.table_header,self__.app_state)),React.DOM.div(({"id": hatti.views.table.table_id, "className": "slickgrid"}),(((no_data_QMARK_) && ((num_of_submissions === (0))))?React.DOM.p(({"className": "alert alert-warning"}),"No data"):React.DOM.span(null,React.DOM.i(({"className": "fa fa-spinner fa-pulse"})),"Loading...")))], null))));
} else {
return null;
}
});})(active_QMARK_,map__23807,map__23807__$1,app_state,map__23808,map__23808__$1,active,map__23809,map__23809__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table23813.prototype.om$core$IDidMount$ = true;

hatti.views.table.t_hatti$views$table23813.prototype.om$core$IDidMount$did_mount$arity$1 = ((function (active_QMARK_,map__23807,map__23807__$1,app_state,map__23808,map__23808__$1,active,map__23809,map__23809__$1,opts,slick_grid_event_handlers){
return (function (_){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.active_QMARK_)){
var data = cljs.core.get_in.call(null,self__.app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377)], null));
var temp__4657__auto__ = hatti.views.table.init_grid_BANG_.call(null,data,self__.owner,self__.slick_grid_event_handlers);
if(cljs.core.truth_(temp__4657__auto__)){
var vec__23827 = temp__4657__auto__;
var grid = cljs.core.nth.call(null,vec__23827,(0),null);
var dataview = cljs.core.nth.call(null,vec__23827,(1),null);
return hatti.views.table.handle_table_events.call(null,self__.app_state,grid,dataview);
} else {
return null;
}
} else {
return null;
}
});})(active_QMARK_,map__23807,map__23807__$1,app_state,map__23808,map__23808__$1,active,map__23809,map__23809__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table23813.prototype.om$core$IWillReceiveProps$ = true;

hatti.views.table.t_hatti$views$table23813.prototype.om$core$IWillReceiveProps$will_receive_props$arity$2 = ((function (active_QMARK_,map__23807,map__23807__$1,app_state,map__23808,map__23808__$1,active,map__23809,map__23809__$1,opts,slick_grid_event_handlers){
return (function (_,next_props){
var self__ = this;
var ___$1 = this;

if(cljs.core.truth_(self__.active_QMARK_)){
var old_data = cljs.core.get_in.call(null,om.core.get_props.call(null,self__.owner),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377)], null));
var new_data = cljs.core.get_in.call(null,next_props,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377)], null));
var map__23830 = om.core.get_state.call(null,self__.owner);
var map__23830__$1 = ((((!((map__23830 == null)))?((((map__23830.cljs$lang$protocol_mask$partition0$ & (64))) || (map__23830.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23830):map__23830);
var grid = cljs.core.get.call(null,map__23830__$1,new cljs.core.Keyword(null,"grid","grid",402978600));
var dataview = cljs.core.get.call(null,map__23830__$1,new cljs.core.Keyword(null,"dataview","dataview",91765671));
if(cljs.core.not_EQ_.call(null,old_data,new_data)){
if(cljs.core.empty_QMARK_.call(null,old_data)){
var temp__4657__auto__ = hatti.views.table.init_grid_BANG_.call(null,new_data,self__.owner,self__.slick_grid_event_handlers);
if(cljs.core.truth_(temp__4657__auto__)){
var vec__23832 = temp__4657__auto__;
var grid__$1 = cljs.core.nth.call(null,vec__23832,(0),null);
var dataview__$1 = cljs.core.nth.call(null,vec__23832,(1),null);
return hatti.views.table.handle_table_events.call(null,self__.app_state,grid__$1,dataview__$1);
} else {
return null;
}
} else {
grid.invalidateAllRows();

dataview.setItems(cljs.core.clj__GT_js.call(null,new_data),hatti.constants._id);

return grid.render();
}
} else {
return null;
}
} else {
return null;
}
});})(active_QMARK_,map__23807,map__23807__$1,app_state,map__23808,map__23808__$1,active,map__23809,map__23809__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table23813.getBasis = ((function (active_QMARK_,map__23807,map__23807__$1,app_state,map__23808,map__23808__$1,active,map__23809,map__23809__$1,opts,slick_grid_event_handlers){
return (function (){
return new cljs.core.PersistentVector(null, 12, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"map__23807","map__23807",-137579261,null),new cljs.core.Symbol(null,"owner","owner",1247919588,null),new cljs.core.Symbol(null,"active?","active?",2100031303,null),new cljs.core.Symbol(null,"slick-grid-event-handlers","slick-grid-event-handlers",-664401045,null),new cljs.core.Symbol(null,"p__23805","p__23805",-25257105,null),new cljs.core.Symbol(null,"p__23806","p__23806",-1370562797,null),new cljs.core.Symbol(null,"map__23809","map__23809",1487083256,null),new cljs.core.Symbol(null,"app-state","app-state",130568249,null),new cljs.core.Symbol(null,"map__23808","map__23808",559772666,null),new cljs.core.Symbol(null,"active","active",-758473701,null),new cljs.core.Symbol(null,"opts","opts",1795607228,null),new cljs.core.Symbol(null,"meta23814","meta23814",315535709,null)], null);
});})(active_QMARK_,map__23807,map__23807__$1,app_state,map__23808,map__23808__$1,active,map__23809,map__23809__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table23813.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table23813.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table23813";

hatti.views.table.t_hatti$views$table23813.cljs$lang$ctorPrWriter = ((function (active_QMARK_,map__23807,map__23807__$1,app_state,map__23808,map__23808__$1,active,map__23809,map__23809__$1,opts,slick_grid_event_handlers){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"hatti.views.table/t_hatti$views$table23813");
});})(active_QMARK_,map__23807,map__23807__$1,app_state,map__23808,map__23808__$1,active,map__23809,map__23809__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.__GT_t_hatti$views$table23813 = ((function (active_QMARK_,map__23807,map__23807__$1,app_state,map__23808,map__23808__$1,active,map__23809,map__23809__$1,opts,slick_grid_event_handlers){
return (function hatti$views$table$__GT_t_hatti$views$table23813(map__23807__$2,owner__$1,active_QMARK___$1,slick_grid_event_handlers__$1,p__23805__$1,p__23806__$1,map__23809__$2,app_state__$1,map__23808__$2,active__$1,opts__$1,meta23814){
return (new hatti.views.table.t_hatti$views$table23813(map__23807__$2,owner__$1,active_QMARK___$1,slick_grid_event_handlers__$1,p__23805__$1,p__23806__$1,map__23809__$2,app_state__$1,map__23808__$2,active__$1,opts__$1,meta23814));
});})(active_QMARK_,map__23807,map__23807__$1,app_state,map__23808,map__23808__$1,active,map__23809,map__23809__$1,opts,slick_grid_event_handlers))
;

}

return (new hatti.views.table.t_hatti$views$table23813(map__23807__$1,owner,active_QMARK_,slick_grid_event_handlers,p__23805,p__23806,map__23809__$1,app_state,map__23808__$1,active,opts,cljs.core.PersistentArrayMap.EMPTY));
}));
