// Compiled by ClojureScript 1.7.145 {}
goog.provide('hatti.utils');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('goog.string.format');
goog.require('goog.string');
goog.require('inflections.core');
goog.require('sablono.core');
hatti.utils.url = (function hatti$utils$url(var_args){
var args__5634__auto__ = [];
var len__5627__auto___7841 = arguments.length;
var i__5628__auto___7842 = (0);
while(true){
if((i__5628__auto___7842 < len__5627__auto___7841)){
args__5634__auto__.push((arguments[i__5628__auto___7842]));

var G__7843 = (i__5628__auto___7842 + (1));
i__5628__auto___7842 = G__7843;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((0) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((0)),(0))):null);
return hatti.utils.url.cljs$core$IFn$_invoke$arity$variadic(argseq__5635__auto__);
});

hatti.utils.url.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return [cljs.core.str("/"),cljs.core.str(clojure.string.join.call(null,"/",cljs.core.remove.call(null,cljs.core.nil_QMARK_,args)))].join('');
});

hatti.utils.url.cljs$lang$maxFixedArity = (0);

hatti.utils.url.cljs$lang$applyTo = (function (seq7840){
return hatti.utils.url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq7840));
});
/**
 * Get last parameter form url
 */
hatti.utils.last_url_param = (function hatti$utils$last_url_param(url){
var last_param = cljs.core.last.call(null,clojure.string.split.call(null,[cljs.core.str(url)].join(''),/\//));
return cljs.core.first.call(null,clojure.string.split.call(null,[cljs.core.str(last_param)].join(''),/.json/));
});
/**
 * Convert json to js using JSON.parse
 */
hatti.utils.json__GT_js = (function hatti$utils$json__GT_js(s){
return JSON.parse(s);
});
/**
 * Convert json string to cljs object.
 * Fast, but doesn't preserve keywords.
 */
hatti.utils.json__GT_cljs = (function hatti$utils$json__GT_cljs(s){
return cljs.core.js__GT_clj.call(null,hatti.utils.json__GT_js.call(null,s));
});
/**
 * Convert json string to cljs via js.
 * Slow method, but preserves keywords, and appropriate for small json.
 */
hatti.utils.json__GT_js__GT_cljs = (function hatti$utils$json__GT_js__GT_cljs(s){
return cljs.core.js__GT_clj.call(null,hatti.utils.json__GT_js.call(null,s),new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
});
/**
 * Formats a string using goog.string.format, so we can use format in cljx.
 */
hatti.utils.format = (function hatti$utils$format(var_args){
var args__5634__auto__ = [];
var len__5627__auto___7846 = arguments.length;
var i__5628__auto___7847 = (0);
while(true){
if((i__5628__auto___7847 < len__5627__auto___7846)){
args__5634__auto__.push((arguments[i__5628__auto___7847]));

var G__7848 = (i__5628__auto___7847 + (1));
i__5628__auto___7847 = G__7848;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((1) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((1)),(0))):null);
return hatti.utils.format.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5635__auto__);
});

hatti.utils.format.cljs$core$IFn$_invoke$arity$variadic = (function (fmt,args){
return cljs.core.apply.call(null,goog.string.format,fmt,args);
});

hatti.utils.format.cljs$lang$maxFixedArity = (1);

hatti.utils.format.cljs$lang$applyTo = (function (seq7844){
var G__7845 = cljs.core.first.call(null,seq7844);
var seq7844__$1 = cljs.core.next.call(null,seq7844);
return hatti.utils.format.cljs$core$IFn$_invoke$arity$variadic(G__7845,seq7844__$1);
});
/**
 * Create a safe (escaped) js regex out of a string.
 * By default, creates regex with ignore case option.
 */
hatti.utils.safe_regex = (function hatti$utils$safe_regex(var_args){
var args__5634__auto__ = [];
var len__5627__auto___7854 = arguments.length;
var i__5628__auto___7855 = (0);
while(true){
if((i__5628__auto___7855 < len__5627__auto___7854)){
args__5634__auto__.push((arguments[i__5628__auto___7855]));

var G__7856 = (i__5628__auto___7855 + (1));
i__5628__auto___7855 = G__7856;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((1) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((1)),(0))):null);
return hatti.utils.safe_regex.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5635__auto__);
});

hatti.utils.safe_regex.cljs$core$IFn$_invoke$arity$variadic = (function (s,p__7851){
var map__7852 = p__7851;
var map__7852__$1 = ((((!((map__7852 == null)))?((((map__7852.cljs$lang$protocol_mask$partition0$ & (64))) || (map__7852.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__7852):map__7852);
var ignore_case_QMARK_ = cljs.core.get.call(null,map__7852__$1,new cljs.core.Keyword(null,"ignore-case?","ignore-case?",-956106212),true);
var s__$1 = s.replace(/\/[\-\[\]\\/\{\}\(\)\*\+\?\.\\\^\$\|]\//,"\\$&");
return (new RegExp(s__$1,"i"));

});

hatti.utils.safe_regex.cljs$lang$maxFixedArity = (1);

hatti.utils.safe_regex.cljs$lang$applyTo = (function (seq7849){
var G__7850 = cljs.core.first.call(null,seq7849);
var seq7849__$1 = cljs.core.next.call(null,seq7849);
return hatti.utils.safe_regex.cljs$core$IFn$_invoke$arity$variadic(G__7850,seq7849__$1);
});
/**
 * Given a seq, produces a two-el seq. [a b c] => [[0 a] [1 b] [2 c]].
 */
hatti.utils.indexed = (function hatti$utils$indexed(coll){
return cljs.core.map_indexed.call(null,cljs.core.vector,coll);
});
/**
 * Helper function to create a click function that prevents default
 */
hatti.utils.click_fn = (function hatti$utils$click_fn(f){
return (function (event){
event.preventDefault();

return f.call(null);
});
});
/**
 * Create an appropriately pluralized string prefix by number.
 */
hatti.utils.pluralize_number = (function hatti$utils$pluralize_number(number,kind){
return clojure.string.join.call(null," ",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [number,((cljs.core._EQ_.call(null,(1),number))?kind:inflections.core.plural.call(null,kind))], null));
});
/**
 * True if substring is a substring of string
 */
hatti.utils.substring_QMARK_ = (function hatti$utils$substring_QMARK_(var_args){
var args7857 = [];
var len__5627__auto___7866 = arguments.length;
var i__5628__auto___7867 = (0);
while(true){
if((i__5628__auto___7867 < len__5627__auto___7866)){
args7857.push((arguments[i__5628__auto___7867]));

var G__7868 = (i__5628__auto___7867 + (1));
i__5628__auto___7867 = G__7868;
continue;
} else {
}
break;
}

var G__7862 = args7857.length;
switch (G__7862) {
case 2:
return hatti.utils.substring_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__5646__auto__ = (new cljs.core.IndexedSeq(args7857.slice((2)),(0)));
return hatti.utils.substring_QMARK_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5646__auto__);

}
});

hatti.utils.substring_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (substring,string){
return cljs.core.complement.call(null,cljs.core.nil_QMARK_).call(null,cljs.core.re_find.call(null,cljs.core.re_pattern.call(null,substring),string));
});

hatti.utils.substring_QMARK_.cljs$core$IFn$_invoke$arity$variadic = (function (substring,string,p__7863){
var map__7864 = p__7863;
var map__7864__$1 = ((((!((map__7864 == null)))?((((map__7864.cljs$lang$protocol_mask$partition0$ & (64))) || (map__7864.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__7864):map__7864);
var case_sensitive_QMARK_ = cljs.core.get.call(null,map__7864__$1,new cljs.core.Keyword(null,"case-sensitive?","case-sensitive?",-2133754107));
if(cljs.core.truth_(case_sensitive_QMARK_)){
return hatti.utils.substring_QMARK_.call(null,substring,string);
} else {
return hatti.utils.substring_QMARK_.call(null,clojure.string.lower_case.call(null,substring),clojure.string.lower_case.call(null,string));
}
});

hatti.utils.substring_QMARK_.cljs$lang$applyTo = (function (seq7858){
var G__7859 = cljs.core.first.call(null,seq7858);
var seq7858__$1 = cljs.core.next.call(null,seq7858);
var G__7860 = cljs.core.first.call(null,seq7858__$1);
var seq7858__$2 = cljs.core.next.call(null,seq7858__$1);
return hatti.utils.substring_QMARK_.cljs$core$IFn$_invoke$arity$variadic(G__7859,G__7860,seq7858__$2);
});

hatti.utils.substring_QMARK_.cljs$lang$maxFixedArity = (2);
hatti.utils.hyphen__GT_camel_case = (function hatti$utils$hyphen__GT_camel_case(source_string){
return clojure.string.replace.call(null,source_string,/(-)(.)/,(function (p1__7870_SHARP_){
var vec__7872 = p1__7870_SHARP_;
var _ = cljs.core.nth.call(null,vec__7872,(0),null);
var ___$1 = cljs.core.nth.call(null,vec__7872,(1),null);
var letter_to_uppercase = cljs.core.nth.call(null,vec__7872,(2),null);
return clojure.string.upper_case.call(null,letter_to_uppercase);
}));
});
hatti.utils.generate_component = (function hatti$utils$generate_component(element_definition_vector){
return sablono.interpreter.interpret.call(null,element_definition_vector);
});
/**
 * This function generates HTML from hiccup-style vectors, and concatenates
 *   the resulting markup. Strings are returned unaffected.
 */
hatti.utils.generate_html = (function hatti$utils$generate_html(var_args){
var args__5634__auto__ = [];
var len__5627__auto___7874 = arguments.length;
var i__5628__auto___7875 = (0);
while(true){
if((i__5628__auto___7875 < len__5627__auto___7874)){
args__5634__auto__.push((arguments[i__5628__auto___7875]));

var G__7876 = (i__5628__auto___7875 + (1));
i__5628__auto___7875 = G__7876;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((0) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((0)),(0))):null);
return hatti.utils.generate_html.cljs$core$IFn$_invoke$arity$variadic(argseq__5635__auto__);
});

hatti.utils.generate_html.cljs$core$IFn$_invoke$arity$variadic = (function (element_definition_vectors){
var components = cljs.core.map.call(null,hatti.utils.generate_component,element_definition_vectors);
var components_as_static_markup = cljs.core.map.call(null,((function (components){
return (function (component){
if(typeof component === 'string'){
return component;
} else {
return sablono.core.render_static.call(null,component);
}
});})(components))
,components);
return clojure.string.join.call(null,components_as_static_markup);
});

hatti.utils.generate_html.cljs$lang$maxFixedArity = (0);

hatti.utils.generate_html.cljs$lang$applyTo = (function (seq7873){
return hatti.utils.generate_html.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq7873));
});
