// Compiled by ClojureScript 1.7.145 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(f){
if(typeof cljs.core.async.t_cljs$core$async17624 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async17624 = (function (fn_handler,f,meta17625){
this.fn_handler = fn_handler;
this.f = f;
this.meta17625 = meta17625;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async17624.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_17626,meta17625__$1){
var self__ = this;
var _17626__$1 = this;
return (new cljs.core.async.t_cljs$core$async17624(self__.fn_handler,self__.f,meta17625__$1));
});

cljs.core.async.t_cljs$core$async17624.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_17626){
var self__ = this;
var _17626__$1 = this;
return self__.meta17625;
});

cljs.core.async.t_cljs$core$async17624.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async17624.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async17624.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async17624.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"fn-handler","fn-handler",648785851,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null)], null)))], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"meta17625","meta17625",850401517,null)], null);
});

cljs.core.async.t_cljs$core$async17624.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async17624.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async17624";

cljs.core.async.t_cljs$core$async17624.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write.call(null,writer__5168__auto__,"cljs.core.async/t_cljs$core$async17624");
});

cljs.core.async.__GT_t_cljs$core$async17624 = (function cljs$core$async$fn_handler_$___GT_t_cljs$core$async17624(fn_handler__$1,f__$1,meta17625){
return (new cljs.core.async.t_cljs$core$async17624(fn_handler__$1,f__$1,meta17625));
});

}

return (new cljs.core.async.t_cljs$core$async17624(cljs$core$async$fn_handler,f,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || (buff.cljs$core$async$impl$protocols$UnblockingBuffer$)){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args17629 = [];
var len__5627__auto___17632 = arguments.length;
var i__5628__auto___17633 = (0);
while(true){
if((i__5628__auto___17633 < len__5627__auto___17632)){
args17629.push((arguments[i__5628__auto___17633]));

var G__17634 = (i__5628__auto___17633 + (1));
i__5628__auto___17633 = G__17634;
continue;
} else {
}
break;
}

var G__17631 = args17629.length;
switch (G__17631) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17629.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.Symbol(null,"buf-or-n","buf-or-n",-1646815050,null)))].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;
/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args17636 = [];
var len__5627__auto___17639 = arguments.length;
var i__5628__auto___17640 = (0);
while(true){
if((i__5628__auto___17640 < len__5627__auto___17639)){
args17636.push((arguments[i__5628__auto___17640]));

var G__17641 = (i__5628__auto___17640 + (1));
i__5628__auto___17640 = G__17641;
continue;
} else {
}
break;
}

var G__17638 = args17636.length;
switch (G__17638) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17636.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_17643 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_17643);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_17643,ret){
return (function (){
return fn1.call(null,val_17643);
});})(val_17643,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;
cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args17644 = [];
var len__5627__auto___17647 = arguments.length;
var i__5628__auto___17648 = (0);
while(true){
if((i__5628__auto___17648 < len__5627__auto___17647)){
args17644.push((arguments[i__5628__auto___17648]));

var G__17649 = (i__5628__auto___17648 + (1));
i__5628__auto___17648 = G__17649;
continue;
} else {
}
break;
}

var G__17646 = args17644.length;
switch (G__17646) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17644.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4423__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4423__auto__)){
var ret = temp__4423__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4423__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__4423__auto__)){
var retb = temp__4423__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__4423__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__4423__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;
cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__5472__auto___17651 = n;
var x_17652 = (0);
while(true){
if((x_17652 < n__5472__auto___17651)){
(a[x_17652] = (0));

var G__17653 = (x_17652 + (1));
x_17652 = G__17653;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__17654 = (i + (1));
i = G__17654;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async17658 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async17658 = (function (alt_flag,flag,meta17659){
this.alt_flag = alt_flag;
this.flag = flag;
this.meta17659 = meta17659;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async17658.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_17660,meta17659__$1){
var self__ = this;
var _17660__$1 = this;
return (new cljs.core.async.t_cljs$core$async17658(self__.alt_flag,self__.flag,meta17659__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async17658.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_17660){
var self__ = this;
var _17660__$1 = this;
return self__.meta17659;
});})(flag))
;

cljs.core.async.t_cljs$core$async17658.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async17658.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async17658.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async17658.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-flag","alt-flag",-1794972754,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(cljs.core.PersistentVector.EMPTY))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta17659","meta17659",955307409,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async17658.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async17658.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async17658";

cljs.core.async.t_cljs$core$async17658.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write.call(null,writer__5168__auto__,"cljs.core.async/t_cljs$core$async17658");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async17658 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async17658(alt_flag__$1,flag__$1,meta17659){
return (new cljs.core.async.t_cljs$core$async17658(alt_flag__$1,flag__$1,meta17659));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async17658(cljs$core$async$alt_flag,flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async17664 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async17664 = (function (alt_handler,flag,cb,meta17665){
this.alt_handler = alt_handler;
this.flag = flag;
this.cb = cb;
this.meta17665 = meta17665;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async17664.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_17666,meta17665__$1){
var self__ = this;
var _17666__$1 = this;
return (new cljs.core.async.t_cljs$core$async17664(self__.alt_handler,self__.flag,self__.cb,meta17665__$1));
});

cljs.core.async.t_cljs$core$async17664.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_17666){
var self__ = this;
var _17666__$1 = this;
return self__.meta17665;
});

cljs.core.async.t_cljs$core$async17664.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async17664.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async17664.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async17664.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-handler","alt-handler",963786170,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null)], null)))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta17665","meta17665",-1915181800,null)], null);
});

cljs.core.async.t_cljs$core$async17664.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async17664.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async17664";

cljs.core.async.t_cljs$core$async17664.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write.call(null,writer__5168__auto__,"cljs.core.async/t_cljs$core$async17664");
});

cljs.core.async.__GT_t_cljs$core$async17664 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async17664(alt_handler__$1,flag__$1,cb__$1,meta17665){
return (new cljs.core.async.t_cljs$core$async17664(alt_handler__$1,flag__$1,cb__$1,meta17665));
});

}

return (new cljs.core.async.t_cljs$core$async17664(cljs$core$async$alt_handler,flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__17667_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__17667_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__17668_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__17668_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__4569__auto__ = wport;
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
return port;
}
})()], null));
} else {
var G__17669 = (i + (1));
i = G__17669;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4569__auto__ = ret;
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__4425__auto__ = (function (){var and__4557__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__4557__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__4557__auto__;
}
})();
if(cljs.core.truth_(temp__4425__auto__)){
var got = temp__4425__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__5634__auto__ = [];
var len__5627__auto___17675 = arguments.length;
var i__5628__auto___17676 = (0);
while(true){
if((i__5628__auto___17676 < len__5627__auto___17675)){
args__5634__auto__.push((arguments[i__5628__auto___17676]));

var G__17677 = (i__5628__auto___17676 + (1));
i__5628__auto___17676 = G__17677;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((1) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((1)),(0))):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5635__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__17672){
var map__17673 = p__17672;
var map__17673__$1 = ((((!((map__17673 == null)))?((((map__17673.cljs$lang$protocol_mask$partition0$ & (64))) || (map__17673.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__17673):map__17673);
var opts = map__17673__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq17670){
var G__17671 = cljs.core.first.call(null,seq17670);
var seq17670__$1 = cljs.core.next.call(null,seq17670);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__17671,seq17670__$1);
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args17678 = [];
var len__5627__auto___17728 = arguments.length;
var i__5628__auto___17729 = (0);
while(true){
if((i__5628__auto___17729 < len__5627__auto___17728)){
args17678.push((arguments[i__5628__auto___17729]));

var G__17730 = (i__5628__auto___17729 + (1));
i__5628__auto___17729 = G__17730;
continue;
} else {
}
break;
}

var G__17680 = args17678.length;
switch (G__17680) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17678.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__9230__auto___17732 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__9230__auto___17732){
return (function (){
var f__9231__auto__ = (function (){var switch__9165__auto__ = ((function (c__9230__auto___17732){
return (function (state_17704){
var state_val_17705 = (state_17704[(1)]);
if((state_val_17705 === (7))){
var inst_17700 = (state_17704[(2)]);
var state_17704__$1 = state_17704;
var statearr_17706_17733 = state_17704__$1;
(statearr_17706_17733[(2)] = inst_17700);

(statearr_17706_17733[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17705 === (1))){
var state_17704__$1 = state_17704;
var statearr_17707_17734 = state_17704__$1;
(statearr_17707_17734[(2)] = null);

(statearr_17707_17734[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17705 === (4))){
var inst_17683 = (state_17704[(7)]);
var inst_17683__$1 = (state_17704[(2)]);
var inst_17684 = (inst_17683__$1 == null);
var state_17704__$1 = (function (){var statearr_17708 = state_17704;
(statearr_17708[(7)] = inst_17683__$1);

return statearr_17708;
})();
if(cljs.core.truth_(inst_17684)){
var statearr_17709_17735 = state_17704__$1;
(statearr_17709_17735[(1)] = (5));

} else {
var statearr_17710_17736 = state_17704__$1;
(statearr_17710_17736[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17705 === (13))){
var state_17704__$1 = state_17704;
var statearr_17711_17737 = state_17704__$1;
(statearr_17711_17737[(2)] = null);

(statearr_17711_17737[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17705 === (6))){
var inst_17683 = (state_17704[(7)]);
var state_17704__$1 = state_17704;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17704__$1,(11),to,inst_17683);
} else {
if((state_val_17705 === (3))){
var inst_17702 = (state_17704[(2)]);
var state_17704__$1 = state_17704;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17704__$1,inst_17702);
} else {
if((state_val_17705 === (12))){
var state_17704__$1 = state_17704;
var statearr_17712_17738 = state_17704__$1;
(statearr_17712_17738[(2)] = null);

(statearr_17712_17738[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17705 === (2))){
var state_17704__$1 = state_17704;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17704__$1,(4),from);
} else {
if((state_val_17705 === (11))){
var inst_17693 = (state_17704[(2)]);
var state_17704__$1 = state_17704;
if(cljs.core.truth_(inst_17693)){
var statearr_17713_17739 = state_17704__$1;
(statearr_17713_17739[(1)] = (12));

} else {
var statearr_17714_17740 = state_17704__$1;
(statearr_17714_17740[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17705 === (9))){
var state_17704__$1 = state_17704;
var statearr_17715_17741 = state_17704__$1;
(statearr_17715_17741[(2)] = null);

(statearr_17715_17741[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17705 === (5))){
var state_17704__$1 = state_17704;
if(cljs.core.truth_(close_QMARK_)){
var statearr_17716_17742 = state_17704__$1;
(statearr_17716_17742[(1)] = (8));

} else {
var statearr_17717_17743 = state_17704__$1;
(statearr_17717_17743[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17705 === (14))){
var inst_17698 = (state_17704[(2)]);
var state_17704__$1 = state_17704;
var statearr_17718_17744 = state_17704__$1;
(statearr_17718_17744[(2)] = inst_17698);

(statearr_17718_17744[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17705 === (10))){
var inst_17690 = (state_17704[(2)]);
var state_17704__$1 = state_17704;
var statearr_17719_17745 = state_17704__$1;
(statearr_17719_17745[(2)] = inst_17690);

(statearr_17719_17745[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17705 === (8))){
var inst_17687 = cljs.core.async.close_BANG_.call(null,to);
var state_17704__$1 = state_17704;
var statearr_17720_17746 = state_17704__$1;
(statearr_17720_17746[(2)] = inst_17687);

(statearr_17720_17746[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__9230__auto___17732))
;
return ((function (switch__9165__auto__,c__9230__auto___17732){
return (function() {
var cljs$core$async$state_machine__9166__auto__ = null;
var cljs$core$async$state_machine__9166__auto____0 = (function (){
var statearr_17724 = [null,null,null,null,null,null,null,null];
(statearr_17724[(0)] = cljs$core$async$state_machine__9166__auto__);

(statearr_17724[(1)] = (1));

return statearr_17724;
});
var cljs$core$async$state_machine__9166__auto____1 = (function (state_17704){
while(true){
var ret_value__9167__auto__ = (function (){try{while(true){
var result__9168__auto__ = switch__9165__auto__.call(null,state_17704);
if(cljs.core.keyword_identical_QMARK_.call(null,result__9168__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__9168__auto__;
}
break;
}
}catch (e17725){if((e17725 instanceof Object)){
var ex__9169__auto__ = e17725;
var statearr_17726_17747 = state_17704;
(statearr_17726_17747[(5)] = ex__9169__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17704);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17725;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__9167__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17748 = state_17704;
state_17704 = G__17748;
continue;
} else {
return ret_value__9167__auto__;
}
break;
}
});
cljs$core$async$state_machine__9166__auto__ = function(state_17704){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__9166__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__9166__auto____1.call(this,state_17704);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__9166__auto____0;
cljs$core$async$state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__9166__auto____1;
return cljs$core$async$state_machine__9166__auto__;
})()
;})(switch__9165__auto__,c__9230__auto___17732))
})();
var state__9232__auto__ = (function (){var statearr_17727 = f__9231__auto__.call(null);
(statearr_17727[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__9230__auto___17732);

return statearr_17727;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__9232__auto__);
});})(c__9230__auto___17732))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;
cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"pos?","pos?",-244377722,null),new cljs.core.Symbol(null,"n","n",-2092305744,null))))].join('')));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__17932){
var vec__17933 = p__17932;
var v = cljs.core.nth.call(null,vec__17933,(0),null);
var p = cljs.core.nth.call(null,vec__17933,(1),null);
var job = vec__17933;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__9230__auto___18115 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__9230__auto___18115,res,vec__17933,v,p,job,jobs,results){
return (function (){
var f__9231__auto__ = (function (){var switch__9165__auto__ = ((function (c__9230__auto___18115,res,vec__17933,v,p,job,jobs,results){
return (function (state_17938){
var state_val_17939 = (state_17938[(1)]);
if((state_val_17939 === (1))){
var state_17938__$1 = state_17938;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17938__$1,(2),res,v);
} else {
if((state_val_17939 === (2))){
var inst_17935 = (state_17938[(2)]);
var inst_17936 = cljs.core.async.close_BANG_.call(null,res);
var state_17938__$1 = (function (){var statearr_17940 = state_17938;
(statearr_17940[(7)] = inst_17935);

return statearr_17940;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17938__$1,inst_17936);
} else {
return null;
}
}
});})(c__9230__auto___18115,res,vec__17933,v,p,job,jobs,results))
;
return ((function (switch__9165__auto__,c__9230__auto___18115,res,vec__17933,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__9166__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__9166__auto____0 = (function (){
var statearr_17944 = [null,null,null,null,null,null,null,null];
(statearr_17944[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__9166__auto__);

(statearr_17944[(1)] = (1));

return statearr_17944;
});
var cljs$core$async$pipeline_STAR__$_state_machine__9166__auto____1 = (function (state_17938){
while(true){
var ret_value__9167__auto__ = (function (){try{while(true){
var result__9168__auto__ = switch__9165__auto__.call(null,state_17938);
if(cljs.core.keyword_identical_QMARK_.call(null,result__9168__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__9168__auto__;
}
break;
}
}catch (e17945){if((e17945 instanceof Object)){
var ex__9169__auto__ = e17945;
var statearr_17946_18116 = state_17938;
(statearr_17946_18116[(5)] = ex__9169__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17938);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17945;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__9167__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18117 = state_17938;
state_17938 = G__18117;
continue;
} else {
return ret_value__9167__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__9166__auto__ = function(state_17938){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__9166__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__9166__auto____1.call(this,state_17938);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__9166__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__9166__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__9166__auto__;
})()
;})(switch__9165__auto__,c__9230__auto___18115,res,vec__17933,v,p,job,jobs,results))
})();
var state__9232__auto__ = (function (){var statearr_17947 = f__9231__auto__.call(null);
(statearr_17947[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__9230__auto___18115);

return statearr_17947;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__9232__auto__);
});})(c__9230__auto___18115,res,vec__17933,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__17948){
var vec__17949 = p__17948;
var v = cljs.core.nth.call(null,vec__17949,(0),null);
var p = cljs.core.nth.call(null,vec__17949,(1),null);
var job = vec__17949;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__5472__auto___18118 = n;
var __18119 = (0);
while(true){
if((__18119 < n__5472__auto___18118)){
var G__17950_18120 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__17950_18120) {
case "compute":
var c__9230__auto___18122 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__18119,c__9230__auto___18122,G__17950_18120,n__5472__auto___18118,jobs,results,process,async){
return (function (){
var f__9231__auto__ = (function (){var switch__9165__auto__ = ((function (__18119,c__9230__auto___18122,G__17950_18120,n__5472__auto___18118,jobs,results,process,async){
return (function (state_17963){
var state_val_17964 = (state_17963[(1)]);
if((state_val_17964 === (1))){
var state_17963__$1 = state_17963;
var statearr_17965_18123 = state_17963__$1;
(statearr_17965_18123[(2)] = null);

(statearr_17965_18123[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17964 === (2))){
var state_17963__$1 = state_17963;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17963__$1,(4),jobs);
} else {
if((state_val_17964 === (3))){
var inst_17961 = (state_17963[(2)]);
var state_17963__$1 = state_17963;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17963__$1,inst_17961);
} else {
if((state_val_17964 === (4))){
var inst_17953 = (state_17963[(2)]);
var inst_17954 = process.call(null,inst_17953);
var state_17963__$1 = state_17963;
if(cljs.core.truth_(inst_17954)){
var statearr_17966_18124 = state_17963__$1;
(statearr_17966_18124[(1)] = (5));

} else {
var statearr_17967_18125 = state_17963__$1;
(statearr_17967_18125[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17964 === (5))){
var state_17963__$1 = state_17963;
var statearr_17968_18126 = state_17963__$1;
(statearr_17968_18126[(2)] = null);

(statearr_17968_18126[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17964 === (6))){
var state_17963__$1 = state_17963;
var statearr_17969_18127 = state_17963__$1;
(statearr_17969_18127[(2)] = null);

(statearr_17969_18127[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17964 === (7))){
var inst_17959 = (state_17963[(2)]);
var state_17963__$1 = state_17963;
var statearr_17970_18128 = state_17963__$1;
(statearr_17970_18128[(2)] = inst_17959);

(statearr_17970_18128[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__18119,c__9230__auto___18122,G__17950_18120,n__5472__auto___18118,jobs,results,process,async))
;
return ((function (__18119,switch__9165__auto__,c__9230__auto___18122,G__17950_18120,n__5472__auto___18118,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__9166__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__9166__auto____0 = (function (){
var statearr_17974 = [null,null,null,null,null,null,null];
(statearr_17974[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__9166__auto__);

(statearr_17974[(1)] = (1));

return statearr_17974;
});
var cljs$core$async$pipeline_STAR__$_state_machine__9166__auto____1 = (function (state_17963){
while(true){
var ret_value__9167__auto__ = (function (){try{while(true){
var result__9168__auto__ = switch__9165__auto__.call(null,state_17963);
if(cljs.core.keyword_identical_QMARK_.call(null,result__9168__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__9168__auto__;
}
break;
}
}catch (e17975){if((e17975 instanceof Object)){
var ex__9169__auto__ = e17975;
var statearr_17976_18129 = state_17963;
(statearr_17976_18129[(5)] = ex__9169__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17963);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17975;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__9167__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18130 = state_17963;
state_17963 = G__18130;
continue;
} else {
return ret_value__9167__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__9166__auto__ = function(state_17963){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__9166__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__9166__auto____1.call(this,state_17963);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__9166__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__9166__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__9166__auto__;
})()
;})(__18119,switch__9165__auto__,c__9230__auto___18122,G__17950_18120,n__5472__auto___18118,jobs,results,process,async))
})();
var state__9232__auto__ = (function (){var statearr_17977 = f__9231__auto__.call(null);
(statearr_17977[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__9230__auto___18122);

return statearr_17977;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__9232__auto__);
});})(__18119,c__9230__auto___18122,G__17950_18120,n__5472__auto___18118,jobs,results,process,async))
);


break;
case "async":
var c__9230__auto___18131 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__18119,c__9230__auto___18131,G__17950_18120,n__5472__auto___18118,jobs,results,process,async){
return (function (){
var f__9231__auto__ = (function (){var switch__9165__auto__ = ((function (__18119,c__9230__auto___18131,G__17950_18120,n__5472__auto___18118,jobs,results,process,async){
return (function (state_17990){
var state_val_17991 = (state_17990[(1)]);
if((state_val_17991 === (1))){
var state_17990__$1 = state_17990;
var statearr_17992_18132 = state_17990__$1;
(statearr_17992_18132[(2)] = null);

(statearr_17992_18132[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17991 === (2))){
var state_17990__$1 = state_17990;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17990__$1,(4),jobs);
} else {
if((state_val_17991 === (3))){
var inst_17988 = (state_17990[(2)]);
var state_17990__$1 = state_17990;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17990__$1,inst_17988);
} else {
if((state_val_17991 === (4))){
var inst_17980 = (state_17990[(2)]);
var inst_17981 = async.call(null,inst_17980);
var state_17990__$1 = state_17990;
if(cljs.core.truth_(inst_17981)){
var statearr_17993_18133 = state_17990__$1;
(statearr_17993_18133[(1)] = (5));

} else {
var statearr_17994_18134 = state_17990__$1;
(statearr_17994_18134[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17991 === (5))){
var state_17990__$1 = state_17990;
var statearr_17995_18135 = state_17990__$1;
(statearr_17995_18135[(2)] = null);

(statearr_17995_18135[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17991 === (6))){
var state_17990__$1 = state_17990;
var statearr_17996_18136 = state_17990__$1;
(statearr_17996_18136[(2)] = null);

(statearr_17996_18136[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17991 === (7))){
var inst_17986 = (state_17990[(2)]);
var state_17990__$1 = state_17990;
var statearr_17997_18137 = state_17990__$1;
(statearr_17997_18137[(2)] = inst_17986);

(statearr_17997_18137[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__18119,c__9230__auto___18131,G__17950_18120,n__5472__auto___18118,jobs,results,process,async))
;
return ((function (__18119,switch__9165__auto__,c__9230__auto___18131,G__17950_18120,n__5472__auto___18118,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__9166__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__9166__auto____0 = (function (){
var statearr_18001 = [null,null,null,null,null,null,null];
(statearr_18001[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__9166__auto__);

(statearr_18001[(1)] = (1));

return statearr_18001;
});
var cljs$core$async$pipeline_STAR__$_state_machine__9166__auto____1 = (function (state_17990){
while(true){
var ret_value__9167__auto__ = (function (){try{while(true){
var result__9168__auto__ = switch__9165__auto__.call(null,state_17990);
if(cljs.core.keyword_identical_QMARK_.call(null,result__9168__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__9168__auto__;
}
break;
}
}catch (e18002){if((e18002 instanceof Object)){
var ex__9169__auto__ = e18002;
var statearr_18003_18138 = state_17990;
(statearr_18003_18138[(5)] = ex__9169__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17990);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e18002;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__9167__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18139 = state_17990;
state_17990 = G__18139;
continue;
} else {
return ret_value__9167__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__9166__auto__ = function(state_17990){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__9166__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__9166__auto____1.call(this,state_17990);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__9166__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__9166__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__9166__auto__;
})()
;})(__18119,switch__9165__auto__,c__9230__auto___18131,G__17950_18120,n__5472__auto___18118,jobs,results,process,async))
})();
var state__9232__auto__ = (function (){var statearr_18004 = f__9231__auto__.call(null);
(statearr_18004[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__9230__auto___18131);

return statearr_18004;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__9232__auto__);
});})(__18119,c__9230__auto___18131,G__17950_18120,n__5472__auto___18118,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__18140 = (__18119 + (1));
__18119 = G__18140;
continue;
} else {
}
break;
}

var c__9230__auto___18141 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__9230__auto___18141,jobs,results,process,async){
return (function (){
var f__9231__auto__ = (function (){var switch__9165__auto__ = ((function (c__9230__auto___18141,jobs,results,process,async){
return (function (state_18026){
var state_val_18027 = (state_18026[(1)]);
if((state_val_18027 === (1))){
var state_18026__$1 = state_18026;
var statearr_18028_18142 = state_18026__$1;
(statearr_18028_18142[(2)] = null);

(statearr_18028_18142[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18027 === (2))){
var state_18026__$1 = state_18026;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18026__$1,(4),from);
} else {
if((state_val_18027 === (3))){
var inst_18024 = (state_18026[(2)]);
var state_18026__$1 = state_18026;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18026__$1,inst_18024);
} else {
if((state_val_18027 === (4))){
var inst_18007 = (state_18026[(7)]);
var inst_18007__$1 = (state_18026[(2)]);
var inst_18008 = (inst_18007__$1 == null);
var state_18026__$1 = (function (){var statearr_18029 = state_18026;
(statearr_18029[(7)] = inst_18007__$1);

return statearr_18029;
})();
if(cljs.core.truth_(inst_18008)){
var statearr_18030_18143 = state_18026__$1;
(statearr_18030_18143[(1)] = (5));

} else {
var statearr_18031_18144 = state_18026__$1;
(statearr_18031_18144[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18027 === (5))){
var inst_18010 = cljs.core.async.close_BANG_.call(null,jobs);
var state_18026__$1 = state_18026;
var statearr_18032_18145 = state_18026__$1;
(statearr_18032_18145[(2)] = inst_18010);

(statearr_18032_18145[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18027 === (6))){
var inst_18012 = (state_18026[(8)]);
var inst_18007 = (state_18026[(7)]);
var inst_18012__$1 = cljs.core.async.chan.call(null,(1));
var inst_18013 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18014 = [inst_18007,inst_18012__$1];
var inst_18015 = (new cljs.core.PersistentVector(null,2,(5),inst_18013,inst_18014,null));
var state_18026__$1 = (function (){var statearr_18033 = state_18026;
(statearr_18033[(8)] = inst_18012__$1);

return statearr_18033;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_18026__$1,(8),jobs,inst_18015);
} else {
if((state_val_18027 === (7))){
var inst_18022 = (state_18026[(2)]);
var state_18026__$1 = state_18026;
var statearr_18034_18146 = state_18026__$1;
(statearr_18034_18146[(2)] = inst_18022);

(statearr_18034_18146[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18027 === (8))){
var inst_18012 = (state_18026[(8)]);
var inst_18017 = (state_18026[(2)]);
var state_18026__$1 = (function (){var statearr_18035 = state_18026;
(statearr_18035[(9)] = inst_18017);

return statearr_18035;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_18026__$1,(9),results,inst_18012);
} else {
if((state_val_18027 === (9))){
var inst_18019 = (state_18026[(2)]);
var state_18026__$1 = (function (){var statearr_18036 = state_18026;
(statearr_18036[(10)] = inst_18019);

return statearr_18036;
})();
var statearr_18037_18147 = state_18026__$1;
(statearr_18037_18147[(2)] = null);

(statearr_18037_18147[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__9230__auto___18141,jobs,results,process,async))
;
return ((function (switch__9165__auto__,c__9230__auto___18141,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__9166__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__9166__auto____0 = (function (){
var statearr_18041 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_18041[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__9166__auto__);

(statearr_18041[(1)] = (1));

return statearr_18041;
});
var cljs$core$async$pipeline_STAR__$_state_machine__9166__auto____1 = (function (state_18026){
while(true){
var ret_value__9167__auto__ = (function (){try{while(true){
var result__9168__auto__ = switch__9165__auto__.call(null,state_18026);
if(cljs.core.keyword_identical_QMARK_.call(null,result__9168__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__9168__auto__;
}
break;
}
}catch (e18042){if((e18042 instanceof Object)){
var ex__9169__auto__ = e18042;
var statearr_18043_18148 = state_18026;
(statearr_18043_18148[(5)] = ex__9169__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18026);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e18042;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__9167__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18149 = state_18026;
state_18026 = G__18149;
continue;
} else {
return ret_value__9167__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__9166__auto__ = function(state_18026){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__9166__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__9166__auto____1.call(this,state_18026);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__9166__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__9166__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__9166__auto__;
})()
;})(switch__9165__auto__,c__9230__auto___18141,jobs,results,process,async))
})();
var state__9232__auto__ = (function (){var statearr_18044 = f__9231__auto__.call(null);
(statearr_18044[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__9230__auto___18141);

return statearr_18044;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__9232__auto__);
});})(c__9230__auto___18141,jobs,results,process,async))
);


var c__9230__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__9230__auto__,jobs,results,process,async){
return (function (){
var f__9231__auto__ = (function (){var switch__9165__auto__ = ((function (c__9230__auto__,jobs,results,process,async){
return (function (state_18082){
var state_val_18083 = (state_18082[(1)]);
if((state_val_18083 === (7))){
var inst_18078 = (state_18082[(2)]);
var state_18082__$1 = state_18082;
var statearr_18084_18150 = state_18082__$1;
(statearr_18084_18150[(2)] = inst_18078);

(statearr_18084_18150[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18083 === (20))){
var state_18082__$1 = state_18082;
var statearr_18085_18151 = state_18082__$1;
(statearr_18085_18151[(2)] = null);

(statearr_18085_18151[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18083 === (1))){
var state_18082__$1 = state_18082;
var statearr_18086_18152 = state_18082__$1;
(statearr_18086_18152[(2)] = null);

(statearr_18086_18152[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18083 === (4))){
var inst_18047 = (state_18082[(7)]);
var inst_18047__$1 = (state_18082[(2)]);
var inst_18048 = (inst_18047__$1 == null);
var state_18082__$1 = (function (){var statearr_18087 = state_18082;
(statearr_18087[(7)] = inst_18047__$1);

return statearr_18087;
})();
if(cljs.core.truth_(inst_18048)){
var statearr_18088_18153 = state_18082__$1;
(statearr_18088_18153[(1)] = (5));

} else {
var statearr_18089_18154 = state_18082__$1;
(statearr_18089_18154[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18083 === (15))){
var inst_18060 = (state_18082[(8)]);
var state_18082__$1 = state_18082;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_18082__$1,(18),to,inst_18060);
} else {
if((state_val_18083 === (21))){
var inst_18073 = (state_18082[(2)]);
var state_18082__$1 = state_18082;
var statearr_18090_18155 = state_18082__$1;
(statearr_18090_18155[(2)] = inst_18073);

(statearr_18090_18155[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18083 === (13))){
var inst_18075 = (state_18082[(2)]);
var state_18082__$1 = (function (){var statearr_18091 = state_18082;
(statearr_18091[(9)] = inst_18075);

return statearr_18091;
})();
var statearr_18092_18156 = state_18082__$1;
(statearr_18092_18156[(2)] = null);

(statearr_18092_18156[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18083 === (6))){
var inst_18047 = (state_18082[(7)]);
var state_18082__$1 = state_18082;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18082__$1,(11),inst_18047);
} else {
if((state_val_18083 === (17))){
var inst_18068 = (state_18082[(2)]);
var state_18082__$1 = state_18082;
if(cljs.core.truth_(inst_18068)){
var statearr_18093_18157 = state_18082__$1;
(statearr_18093_18157[(1)] = (19));

} else {
var statearr_18094_18158 = state_18082__$1;
(statearr_18094_18158[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18083 === (3))){
var inst_18080 = (state_18082[(2)]);
var state_18082__$1 = state_18082;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18082__$1,inst_18080);
} else {
if((state_val_18083 === (12))){
var inst_18057 = (state_18082[(10)]);
var state_18082__$1 = state_18082;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18082__$1,(14),inst_18057);
} else {
if((state_val_18083 === (2))){
var state_18082__$1 = state_18082;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18082__$1,(4),results);
} else {
if((state_val_18083 === (19))){
var state_18082__$1 = state_18082;
var statearr_18095_18159 = state_18082__$1;
(statearr_18095_18159[(2)] = null);

(statearr_18095_18159[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18083 === (11))){
var inst_18057 = (state_18082[(2)]);
var state_18082__$1 = (function (){var statearr_18096 = state_18082;
(statearr_18096[(10)] = inst_18057);

return statearr_18096;
})();
var statearr_18097_18160 = state_18082__$1;
(statearr_18097_18160[(2)] = null);

(statearr_18097_18160[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18083 === (9))){
var state_18082__$1 = state_18082;
var statearr_18098_18161 = state_18082__$1;
(statearr_18098_18161[(2)] = null);

(statearr_18098_18161[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18083 === (5))){
var state_18082__$1 = state_18082;
if(cljs.core.truth_(close_QMARK_)){
var statearr_18099_18162 = state_18082__$1;
(statearr_18099_18162[(1)] = (8));

} else {
var statearr_18100_18163 = state_18082__$1;
(statearr_18100_18163[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18083 === (14))){
var inst_18062 = (state_18082[(11)]);
var inst_18060 = (state_18082[(8)]);
var inst_18060__$1 = (state_18082[(2)]);
var inst_18061 = (inst_18060__$1 == null);
var inst_18062__$1 = cljs.core.not.call(null,inst_18061);
var state_18082__$1 = (function (){var statearr_18101 = state_18082;
(statearr_18101[(11)] = inst_18062__$1);

(statearr_18101[(8)] = inst_18060__$1);

return statearr_18101;
})();
if(inst_18062__$1){
var statearr_18102_18164 = state_18082__$1;
(statearr_18102_18164[(1)] = (15));

} else {
var statearr_18103_18165 = state_18082__$1;
(statearr_18103_18165[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18083 === (16))){
var inst_18062 = (state_18082[(11)]);
var state_18082__$1 = state_18082;
var statearr_18104_18166 = state_18082__$1;
(statearr_18104_18166[(2)] = inst_18062);

(statearr_18104_18166[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18083 === (10))){
var inst_18054 = (state_18082[(2)]);
var state_18082__$1 = state_18082;
var statearr_18105_18167 = state_18082__$1;
(statearr_18105_18167[(2)] = inst_18054);

(statearr_18105_18167[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18083 === (18))){
var inst_18065 = (state_18082[(2)]);
var state_18082__$1 = state_18082;
var statearr_18106_18168 = state_18082__$1;
(statearr_18106_18168[(2)] = inst_18065);

(statearr_18106_18168[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18083 === (8))){
var inst_18051 = cljs.core.async.close_BANG_.call(null,to);
var state_18082__$1 = state_18082;
var statearr_18107_18169 = state_18082__$1;
(statearr_18107_18169[(2)] = inst_18051);

(statearr_18107_18169[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__9230__auto__,jobs,results,process,async))
;
return ((function (switch__9165__auto__,c__9230__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__9166__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__9166__auto____0 = (function (){
var statearr_18111 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18111[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__9166__auto__);

(statearr_18111[(1)] = (1));

return statearr_18111;
});
var cljs$core$async$pipeline_STAR__$_state_machine__9166__auto____1 = (function (state_18082){
while(true){
var ret_value__9167__auto__ = (function (){try{while(true){
var result__9168__auto__ = switch__9165__auto__.call(null,state_18082);
if(cljs.core.keyword_identical_QMARK_.call(null,result__9168__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__9168__auto__;
}
break;
}
}catch (e18112){if((e18112 instanceof Object)){
var ex__9169__auto__ = e18112;
var statearr_18113_18170 = state_18082;
(statearr_18113_18170[(5)] = ex__9169__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18082);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e18112;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__9167__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18171 = state_18082;
state_18082 = G__18171;
continue;
} else {
return ret_value__9167__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__9166__auto__ = function(state_18082){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__9166__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__9166__auto____1.call(this,state_18082);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__9166__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__9166__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__9166__auto__;
})()
;})(switch__9165__auto__,c__9230__auto__,jobs,results,process,async))
})();
var state__9232__auto__ = (function (){var statearr_18114 = f__9231__auto__.call(null);
(statearr_18114[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__9230__auto__);

return statearr_18114;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__9232__auto__);
});})(c__9230__auto__,jobs,results,process,async))
);

return c__9230__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args18172 = [];
var len__5627__auto___18175 = arguments.length;
var i__5628__auto___18176 = (0);
while(true){
if((i__5628__auto___18176 < len__5627__auto___18175)){
args18172.push((arguments[i__5628__auto___18176]));

var G__18177 = (i__5628__auto___18176 + (1));
i__5628__auto___18176 = G__18177;
continue;
} else {
}
break;
}

var G__18174 = args18172.length;
switch (G__18174) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18172.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args18179 = [];
var len__5627__auto___18182 = arguments.length;
var i__5628__auto___18183 = (0);
while(true){
if((i__5628__auto___18183 < len__5627__auto___18182)){
args18179.push((arguments[i__5628__auto___18183]));

var G__18184 = (i__5628__auto___18183 + (1));
i__5628__auto___18183 = G__18184;
continue;
} else {
}
break;
}

var G__18181 = args18179.length;
switch (G__18181) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18179.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;
/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args18186 = [];
var len__5627__auto___18239 = arguments.length;
var i__5628__auto___18240 = (0);
while(true){
if((i__5628__auto___18240 < len__5627__auto___18239)){
args18186.push((arguments[i__5628__auto___18240]));

var G__18241 = (i__5628__auto___18240 + (1));
i__5628__auto___18240 = G__18241;
continue;
} else {
}
break;
}

var G__18188 = args18186.length;
switch (G__18188) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18186.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__9230__auto___18243 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__9230__auto___18243,tc,fc){
return (function (){
var f__9231__auto__ = (function (){var switch__9165__auto__ = ((function (c__9230__auto___18243,tc,fc){
return (function (state_18214){
var state_val_18215 = (state_18214[(1)]);
if((state_val_18215 === (7))){
var inst_18210 = (state_18214[(2)]);
var state_18214__$1 = state_18214;
var statearr_18216_18244 = state_18214__$1;
(statearr_18216_18244[(2)] = inst_18210);

(statearr_18216_18244[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18215 === (1))){
var state_18214__$1 = state_18214;
var statearr_18217_18245 = state_18214__$1;
(statearr_18217_18245[(2)] = null);

(statearr_18217_18245[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18215 === (4))){
var inst_18191 = (state_18214[(7)]);
var inst_18191__$1 = (state_18214[(2)]);
var inst_18192 = (inst_18191__$1 == null);
var state_18214__$1 = (function (){var statearr_18218 = state_18214;
(statearr_18218[(7)] = inst_18191__$1);

return statearr_18218;
})();
if(cljs.core.truth_(inst_18192)){
var statearr_18219_18246 = state_18214__$1;
(statearr_18219_18246[(1)] = (5));

} else {
var statearr_18220_18247 = state_18214__$1;
(statearr_18220_18247[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18215 === (13))){
var state_18214__$1 = state_18214;
var statearr_18221_18248 = state_18214__$1;
(statearr_18221_18248[(2)] = null);

(statearr_18221_18248[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18215 === (6))){
var inst_18191 = (state_18214[(7)]);
var inst_18197 = p.call(null,inst_18191);
var state_18214__$1 = state_18214;
if(cljs.core.truth_(inst_18197)){
var statearr_18222_18249 = state_18214__$1;
(statearr_18222_18249[(1)] = (9));

} else {
var statearr_18223_18250 = state_18214__$1;
(statearr_18223_18250[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18215 === (3))){
var inst_18212 = (state_18214[(2)]);
var state_18214__$1 = state_18214;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18214__$1,inst_18212);
} else {
if((state_val_18215 === (12))){
var state_18214__$1 = state_18214;
var statearr_18224_18251 = state_18214__$1;
(statearr_18224_18251[(2)] = null);

(statearr_18224_18251[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18215 === (2))){
var state_18214__$1 = state_18214;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18214__$1,(4),ch);
} else {
if((state_val_18215 === (11))){
var inst_18191 = (state_18214[(7)]);
var inst_18201 = (state_18214[(2)]);
var state_18214__$1 = state_18214;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_18214__$1,(8),inst_18201,inst_18191);
} else {
if((state_val_18215 === (9))){
var state_18214__$1 = state_18214;
var statearr_18225_18252 = state_18214__$1;
(statearr_18225_18252[(2)] = tc);

(statearr_18225_18252[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18215 === (5))){
var inst_18194 = cljs.core.async.close_BANG_.call(null,tc);
var inst_18195 = cljs.core.async.close_BANG_.call(null,fc);
var state_18214__$1 = (function (){var statearr_18226 = state_18214;
(statearr_18226[(8)] = inst_18194);

return statearr_18226;
})();
var statearr_18227_18253 = state_18214__$1;
(statearr_18227_18253[(2)] = inst_18195);

(statearr_18227_18253[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18215 === (14))){
var inst_18208 = (state_18214[(2)]);
var state_18214__$1 = state_18214;
var statearr_18228_18254 = state_18214__$1;
(statearr_18228_18254[(2)] = inst_18208);

(statearr_18228_18254[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18215 === (10))){
var state_18214__$1 = state_18214;
var statearr_18229_18255 = state_18214__$1;
(statearr_18229_18255[(2)] = fc);

(statearr_18229_18255[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18215 === (8))){
var inst_18203 = (state_18214[(2)]);
var state_18214__$1 = state_18214;
if(cljs.core.truth_(inst_18203)){
var statearr_18230_18256 = state_18214__$1;
(statearr_18230_18256[(1)] = (12));

} else {
var statearr_18231_18257 = state_18214__$1;
(statearr_18231_18257[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__9230__auto___18243,tc,fc))
;
return ((function (switch__9165__auto__,c__9230__auto___18243,tc,fc){
return (function() {
var cljs$core$async$state_machine__9166__auto__ = null;
var cljs$core$async$state_machine__9166__auto____0 = (function (){
var statearr_18235 = [null,null,null,null,null,null,null,null,null];
(statearr_18235[(0)] = cljs$core$async$state_machine__9166__auto__);

(statearr_18235[(1)] = (1));

return statearr_18235;
});
var cljs$core$async$state_machine__9166__auto____1 = (function (state_18214){
while(true){
var ret_value__9167__auto__ = (function (){try{while(true){
var result__9168__auto__ = switch__9165__auto__.call(null,state_18214);
if(cljs.core.keyword_identical_QMARK_.call(null,result__9168__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__9168__auto__;
}
break;
}
}catch (e18236){if((e18236 instanceof Object)){
var ex__9169__auto__ = e18236;
var statearr_18237_18258 = state_18214;
(statearr_18237_18258[(5)] = ex__9169__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18214);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e18236;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__9167__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18259 = state_18214;
state_18214 = G__18259;
continue;
} else {
return ret_value__9167__auto__;
}
break;
}
});
cljs$core$async$state_machine__9166__auto__ = function(state_18214){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__9166__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__9166__auto____1.call(this,state_18214);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__9166__auto____0;
cljs$core$async$state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__9166__auto____1;
return cljs$core$async$state_machine__9166__auto__;
})()
;})(switch__9165__auto__,c__9230__auto___18243,tc,fc))
})();
var state__9232__auto__ = (function (){var statearr_18238 = f__9231__auto__.call(null);
(statearr_18238[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__9230__auto___18243);

return statearr_18238;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__9232__auto__);
});})(c__9230__auto___18243,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;
/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__9230__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__9230__auto__){
return (function (){
var f__9231__auto__ = (function (){var switch__9165__auto__ = ((function (c__9230__auto__){
return (function (state_18306){
var state_val_18307 = (state_18306[(1)]);
if((state_val_18307 === (1))){
var inst_18292 = init;
var state_18306__$1 = (function (){var statearr_18308 = state_18306;
(statearr_18308[(7)] = inst_18292);

return statearr_18308;
})();
var statearr_18309_18324 = state_18306__$1;
(statearr_18309_18324[(2)] = null);

(statearr_18309_18324[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18307 === (2))){
var state_18306__$1 = state_18306;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18306__$1,(4),ch);
} else {
if((state_val_18307 === (3))){
var inst_18304 = (state_18306[(2)]);
var state_18306__$1 = state_18306;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18306__$1,inst_18304);
} else {
if((state_val_18307 === (4))){
var inst_18295 = (state_18306[(8)]);
var inst_18295__$1 = (state_18306[(2)]);
var inst_18296 = (inst_18295__$1 == null);
var state_18306__$1 = (function (){var statearr_18310 = state_18306;
(statearr_18310[(8)] = inst_18295__$1);

return statearr_18310;
})();
if(cljs.core.truth_(inst_18296)){
var statearr_18311_18325 = state_18306__$1;
(statearr_18311_18325[(1)] = (5));

} else {
var statearr_18312_18326 = state_18306__$1;
(statearr_18312_18326[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18307 === (5))){
var inst_18292 = (state_18306[(7)]);
var state_18306__$1 = state_18306;
var statearr_18313_18327 = state_18306__$1;
(statearr_18313_18327[(2)] = inst_18292);

(statearr_18313_18327[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18307 === (6))){
var inst_18292 = (state_18306[(7)]);
var inst_18295 = (state_18306[(8)]);
var inst_18299 = f.call(null,inst_18292,inst_18295);
var inst_18292__$1 = inst_18299;
var state_18306__$1 = (function (){var statearr_18314 = state_18306;
(statearr_18314[(7)] = inst_18292__$1);

return statearr_18314;
})();
var statearr_18315_18328 = state_18306__$1;
(statearr_18315_18328[(2)] = null);

(statearr_18315_18328[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18307 === (7))){
var inst_18302 = (state_18306[(2)]);
var state_18306__$1 = state_18306;
var statearr_18316_18329 = state_18306__$1;
(statearr_18316_18329[(2)] = inst_18302);

(statearr_18316_18329[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(c__9230__auto__))
;
return ((function (switch__9165__auto__,c__9230__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__9166__auto__ = null;
var cljs$core$async$reduce_$_state_machine__9166__auto____0 = (function (){
var statearr_18320 = [null,null,null,null,null,null,null,null,null];
(statearr_18320[(0)] = cljs$core$async$reduce_$_state_machine__9166__auto__);

(statearr_18320[(1)] = (1));

return statearr_18320;
});
var cljs$core$async$reduce_$_state_machine__9166__auto____1 = (function (state_18306){
while(true){
var ret_value__9167__auto__ = (function (){try{while(true){
var result__9168__auto__ = switch__9165__auto__.call(null,state_18306);
if(cljs.core.keyword_identical_QMARK_.call(null,result__9168__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__9168__auto__;
}
break;
}
}catch (e18321){if((e18321 instanceof Object)){
var ex__9169__auto__ = e18321;
var statearr_18322_18330 = state_18306;
(statearr_18322_18330[(5)] = ex__9169__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18306);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e18321;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__9167__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18331 = state_18306;
state_18306 = G__18331;
continue;
} else {
return ret_value__9167__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__9166__auto__ = function(state_18306){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__9166__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__9166__auto____1.call(this,state_18306);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__9166__auto____0;
cljs$core$async$reduce_$_state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__9166__auto____1;
return cljs$core$async$reduce_$_state_machine__9166__auto__;
})()
;})(switch__9165__auto__,c__9230__auto__))
})();
var state__9232__auto__ = (function (){var statearr_18323 = f__9231__auto__.call(null);
(statearr_18323[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__9230__auto__);

return statearr_18323;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__9232__auto__);
});})(c__9230__auto__))
);

return c__9230__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args18332 = [];
var len__5627__auto___18384 = arguments.length;
var i__5628__auto___18385 = (0);
while(true){
if((i__5628__auto___18385 < len__5627__auto___18384)){
args18332.push((arguments[i__5628__auto___18385]));

var G__18386 = (i__5628__auto___18385 + (1));
i__5628__auto___18385 = G__18386;
continue;
} else {
}
break;
}

var G__18334 = args18332.length;
switch (G__18334) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18332.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__9230__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__9230__auto__){
return (function (){
var f__9231__auto__ = (function (){var switch__9165__auto__ = ((function (c__9230__auto__){
return (function (state_18359){
var state_val_18360 = (state_18359[(1)]);
if((state_val_18360 === (7))){
var inst_18341 = (state_18359[(2)]);
var state_18359__$1 = state_18359;
var statearr_18361_18388 = state_18359__$1;
(statearr_18361_18388[(2)] = inst_18341);

(statearr_18361_18388[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18360 === (1))){
var inst_18335 = cljs.core.seq.call(null,coll);
var inst_18336 = inst_18335;
var state_18359__$1 = (function (){var statearr_18362 = state_18359;
(statearr_18362[(7)] = inst_18336);

return statearr_18362;
})();
var statearr_18363_18389 = state_18359__$1;
(statearr_18363_18389[(2)] = null);

(statearr_18363_18389[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18360 === (4))){
var inst_18336 = (state_18359[(7)]);
var inst_18339 = cljs.core.first.call(null,inst_18336);
var state_18359__$1 = state_18359;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_18359__$1,(7),ch,inst_18339);
} else {
if((state_val_18360 === (13))){
var inst_18353 = (state_18359[(2)]);
var state_18359__$1 = state_18359;
var statearr_18364_18390 = state_18359__$1;
(statearr_18364_18390[(2)] = inst_18353);

(statearr_18364_18390[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18360 === (6))){
var inst_18344 = (state_18359[(2)]);
var state_18359__$1 = state_18359;
if(cljs.core.truth_(inst_18344)){
var statearr_18365_18391 = state_18359__$1;
(statearr_18365_18391[(1)] = (8));

} else {
var statearr_18366_18392 = state_18359__$1;
(statearr_18366_18392[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18360 === (3))){
var inst_18357 = (state_18359[(2)]);
var state_18359__$1 = state_18359;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18359__$1,inst_18357);
} else {
if((state_val_18360 === (12))){
var state_18359__$1 = state_18359;
var statearr_18367_18393 = state_18359__$1;
(statearr_18367_18393[(2)] = null);

(statearr_18367_18393[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18360 === (2))){
var inst_18336 = (state_18359[(7)]);
var state_18359__$1 = state_18359;
if(cljs.core.truth_(inst_18336)){
var statearr_18368_18394 = state_18359__$1;
(statearr_18368_18394[(1)] = (4));

} else {
var statearr_18369_18395 = state_18359__$1;
(statearr_18369_18395[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18360 === (11))){
var inst_18350 = cljs.core.async.close_BANG_.call(null,ch);
var state_18359__$1 = state_18359;
var statearr_18370_18396 = state_18359__$1;
(statearr_18370_18396[(2)] = inst_18350);

(statearr_18370_18396[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18360 === (9))){
var state_18359__$1 = state_18359;
if(cljs.core.truth_(close_QMARK_)){
var statearr_18371_18397 = state_18359__$1;
(statearr_18371_18397[(1)] = (11));

} else {
var statearr_18372_18398 = state_18359__$1;
(statearr_18372_18398[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18360 === (5))){
var inst_18336 = (state_18359[(7)]);
var state_18359__$1 = state_18359;
var statearr_18373_18399 = state_18359__$1;
(statearr_18373_18399[(2)] = inst_18336);

(statearr_18373_18399[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18360 === (10))){
var inst_18355 = (state_18359[(2)]);
var state_18359__$1 = state_18359;
var statearr_18374_18400 = state_18359__$1;
(statearr_18374_18400[(2)] = inst_18355);

(statearr_18374_18400[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18360 === (8))){
var inst_18336 = (state_18359[(7)]);
var inst_18346 = cljs.core.next.call(null,inst_18336);
var inst_18336__$1 = inst_18346;
var state_18359__$1 = (function (){var statearr_18375 = state_18359;
(statearr_18375[(7)] = inst_18336__$1);

return statearr_18375;
})();
var statearr_18376_18401 = state_18359__$1;
(statearr_18376_18401[(2)] = null);

(statearr_18376_18401[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__9230__auto__))
;
return ((function (switch__9165__auto__,c__9230__auto__){
return (function() {
var cljs$core$async$state_machine__9166__auto__ = null;
var cljs$core$async$state_machine__9166__auto____0 = (function (){
var statearr_18380 = [null,null,null,null,null,null,null,null];
(statearr_18380[(0)] = cljs$core$async$state_machine__9166__auto__);

(statearr_18380[(1)] = (1));

return statearr_18380;
});
var cljs$core$async$state_machine__9166__auto____1 = (function (state_18359){
while(true){
var ret_value__9167__auto__ = (function (){try{while(true){
var result__9168__auto__ = switch__9165__auto__.call(null,state_18359);
if(cljs.core.keyword_identical_QMARK_.call(null,result__9168__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__9168__auto__;
}
break;
}
}catch (e18381){if((e18381 instanceof Object)){
var ex__9169__auto__ = e18381;
var statearr_18382_18402 = state_18359;
(statearr_18382_18402[(5)] = ex__9169__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18359);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e18381;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__9167__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18403 = state_18359;
state_18359 = G__18403;
continue;
} else {
return ret_value__9167__auto__;
}
break;
}
});
cljs$core$async$state_machine__9166__auto__ = function(state_18359){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__9166__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__9166__auto____1.call(this,state_18359);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__9166__auto____0;
cljs$core$async$state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__9166__auto____1;
return cljs$core$async$state_machine__9166__auto__;
})()
;})(switch__9165__auto__,c__9230__auto__))
})();
var state__9232__auto__ = (function (){var statearr_18383 = f__9231__auto__.call(null);
(statearr_18383[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__9230__auto__);

return statearr_18383;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__9232__auto__);
});})(c__9230__auto__))
);

return c__9230__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__5224__auto__ = (((_ == null))?null:_);
var m__5225__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return m__5225__auto__.call(null,_);
} else {
var m__5225__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return m__5225__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__5224__auto__ = (((m == null))?null:m);
var m__5225__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return m__5225__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__5225__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return m__5225__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__5224__auto__ = (((m == null))?null:m);
var m__5225__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return m__5225__auto__.call(null,m,ch);
} else {
var m__5225__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return m__5225__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__5224__auto__ = (((m == null))?null:m);
var m__5225__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return m__5225__auto__.call(null,m);
} else {
var m__5225__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return m__5225__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async18625 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async18625 = (function (mult,ch,cs,meta18626){
this.mult = mult;
this.ch = ch;
this.cs = cs;
this.meta18626 = meta18626;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async18625.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_18627,meta18626__$1){
var self__ = this;
var _18627__$1 = this;
return (new cljs.core.async.t_cljs$core$async18625(self__.mult,self__.ch,self__.cs,meta18626__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async18625.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_18627){
var self__ = this;
var _18627__$1 = this;
return self__.meta18626;
});})(cs))
;

cljs.core.async.t_cljs$core$async18625.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async18625.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async18625.prototype.cljs$core$async$Mult$ = true;

cljs.core.async.t_cljs$core$async18625.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async18625.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async18625.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async18625.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"mult","mult",-1187640995,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mult(iple) of the supplied channel. Channels\n  containing copies of the channel can be created with 'tap', and\n  detached with 'untap'.\n\n  Each item is distributed to all taps in parallel and synchronously,\n  i.e. each tap must accept before the next item is distributed. Use\n  buffering/windowing to prevent slow taps from holding up the mult.\n\n  Items received when there are no taps get dropped.\n\n  If a tap puts to a closed channel, it will be removed from the mult."], null)),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta18626","meta18626",-589186422,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async18625.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async18625.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async18625";

cljs.core.async.t_cljs$core$async18625.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write.call(null,writer__5168__auto__,"cljs.core.async/t_cljs$core$async18625");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async18625 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async18625(mult__$1,ch__$1,cs__$1,meta18626){
return (new cljs.core.async.t_cljs$core$async18625(mult__$1,ch__$1,cs__$1,meta18626));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async18625(cljs$core$async$mult,ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__9230__auto___18846 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__9230__auto___18846,cs,m,dchan,dctr,done){
return (function (){
var f__9231__auto__ = (function (){var switch__9165__auto__ = ((function (c__9230__auto___18846,cs,m,dchan,dctr,done){
return (function (state_18758){
var state_val_18759 = (state_18758[(1)]);
if((state_val_18759 === (7))){
var inst_18754 = (state_18758[(2)]);
var state_18758__$1 = state_18758;
var statearr_18760_18847 = state_18758__$1;
(statearr_18760_18847[(2)] = inst_18754);

(statearr_18760_18847[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18759 === (20))){
var inst_18659 = (state_18758[(7)]);
var inst_18669 = cljs.core.first.call(null,inst_18659);
var inst_18670 = cljs.core.nth.call(null,inst_18669,(0),null);
var inst_18671 = cljs.core.nth.call(null,inst_18669,(1),null);
var state_18758__$1 = (function (){var statearr_18761 = state_18758;
(statearr_18761[(8)] = inst_18670);

return statearr_18761;
})();
if(cljs.core.truth_(inst_18671)){
var statearr_18762_18848 = state_18758__$1;
(statearr_18762_18848[(1)] = (22));

} else {
var statearr_18763_18849 = state_18758__$1;
(statearr_18763_18849[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18759 === (27))){
var inst_18701 = (state_18758[(9)]);
var inst_18706 = (state_18758[(10)]);
var inst_18699 = (state_18758[(11)]);
var inst_18630 = (state_18758[(12)]);
var inst_18706__$1 = cljs.core._nth.call(null,inst_18699,inst_18701);
var inst_18707 = cljs.core.async.put_BANG_.call(null,inst_18706__$1,inst_18630,done);
var state_18758__$1 = (function (){var statearr_18764 = state_18758;
(statearr_18764[(10)] = inst_18706__$1);

return statearr_18764;
})();
if(cljs.core.truth_(inst_18707)){
var statearr_18765_18850 = state_18758__$1;
(statearr_18765_18850[(1)] = (30));

} else {
var statearr_18766_18851 = state_18758__$1;
(statearr_18766_18851[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18759 === (1))){
var state_18758__$1 = state_18758;
var statearr_18767_18852 = state_18758__$1;
(statearr_18767_18852[(2)] = null);

(statearr_18767_18852[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18759 === (24))){
var inst_18659 = (state_18758[(7)]);
var inst_18676 = (state_18758[(2)]);
var inst_18677 = cljs.core.next.call(null,inst_18659);
var inst_18639 = inst_18677;
var inst_18640 = null;
var inst_18641 = (0);
var inst_18642 = (0);
var state_18758__$1 = (function (){var statearr_18768 = state_18758;
(statearr_18768[(13)] = inst_18641);

(statearr_18768[(14)] = inst_18639);

(statearr_18768[(15)] = inst_18640);

(statearr_18768[(16)] = inst_18642);

(statearr_18768[(17)] = inst_18676);

return statearr_18768;
})();
var statearr_18769_18853 = state_18758__$1;
(statearr_18769_18853[(2)] = null);

(statearr_18769_18853[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18759 === (39))){
var state_18758__$1 = state_18758;
var statearr_18773_18854 = state_18758__$1;
(statearr_18773_18854[(2)] = null);

(statearr_18773_18854[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18759 === (4))){
var inst_18630 = (state_18758[(12)]);
var inst_18630__$1 = (state_18758[(2)]);
var inst_18631 = (inst_18630__$1 == null);
var state_18758__$1 = (function (){var statearr_18774 = state_18758;
(statearr_18774[(12)] = inst_18630__$1);

return statearr_18774;
})();
if(cljs.core.truth_(inst_18631)){
var statearr_18775_18855 = state_18758__$1;
(statearr_18775_18855[(1)] = (5));

} else {
var statearr_18776_18856 = state_18758__$1;
(statearr_18776_18856[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18759 === (15))){
var inst_18641 = (state_18758[(13)]);
var inst_18639 = (state_18758[(14)]);
var inst_18640 = (state_18758[(15)]);
var inst_18642 = (state_18758[(16)]);
var inst_18655 = (state_18758[(2)]);
var inst_18656 = (inst_18642 + (1));
var tmp18770 = inst_18641;
var tmp18771 = inst_18639;
var tmp18772 = inst_18640;
var inst_18639__$1 = tmp18771;
var inst_18640__$1 = tmp18772;
var inst_18641__$1 = tmp18770;
var inst_18642__$1 = inst_18656;
var state_18758__$1 = (function (){var statearr_18777 = state_18758;
(statearr_18777[(13)] = inst_18641__$1);

(statearr_18777[(14)] = inst_18639__$1);

(statearr_18777[(18)] = inst_18655);

(statearr_18777[(15)] = inst_18640__$1);

(statearr_18777[(16)] = inst_18642__$1);

return statearr_18777;
})();
var statearr_18778_18857 = state_18758__$1;
(statearr_18778_18857[(2)] = null);

(statearr_18778_18857[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18759 === (21))){
var inst_18680 = (state_18758[(2)]);
var state_18758__$1 = state_18758;
var statearr_18782_18858 = state_18758__$1;
(statearr_18782_18858[(2)] = inst_18680);

(statearr_18782_18858[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18759 === (31))){
var inst_18706 = (state_18758[(10)]);
var inst_18710 = done.call(null,null);
var inst_18711 = cljs.core.async.untap_STAR_.call(null,m,inst_18706);
var state_18758__$1 = (function (){var statearr_18783 = state_18758;
(statearr_18783[(19)] = inst_18710);

return statearr_18783;
})();
var statearr_18784_18859 = state_18758__$1;
(statearr_18784_18859[(2)] = inst_18711);

(statearr_18784_18859[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18759 === (32))){
var inst_18701 = (state_18758[(9)]);
var inst_18698 = (state_18758[(20)]);
var inst_18699 = (state_18758[(11)]);
var inst_18700 = (state_18758[(21)]);
var inst_18713 = (state_18758[(2)]);
var inst_18714 = (inst_18701 + (1));
var tmp18779 = inst_18698;
var tmp18780 = inst_18699;
var tmp18781 = inst_18700;
var inst_18698__$1 = tmp18779;
var inst_18699__$1 = tmp18780;
var inst_18700__$1 = tmp18781;
var inst_18701__$1 = inst_18714;
var state_18758__$1 = (function (){var statearr_18785 = state_18758;
(statearr_18785[(9)] = inst_18701__$1);

(statearr_18785[(22)] = inst_18713);

(statearr_18785[(20)] = inst_18698__$1);

(statearr_18785[(11)] = inst_18699__$1);

(statearr_18785[(21)] = inst_18700__$1);

return statearr_18785;
})();
var statearr_18786_18860 = state_18758__$1;
(statearr_18786_18860[(2)] = null);

(statearr_18786_18860[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18759 === (40))){
var inst_18726 = (state_18758[(23)]);
var inst_18730 = done.call(null,null);
var inst_18731 = cljs.core.async.untap_STAR_.call(null,m,inst_18726);
var state_18758__$1 = (function (){var statearr_18787 = state_18758;
(statearr_18787[(24)] = inst_18730);

return statearr_18787;
})();
var statearr_18788_18861 = state_18758__$1;
(statearr_18788_18861[(2)] = inst_18731);

(statearr_18788_18861[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18759 === (33))){
var inst_18717 = (state_18758[(25)]);
var inst_18719 = cljs.core.chunked_seq_QMARK_.call(null,inst_18717);
var state_18758__$1 = state_18758;
if(inst_18719){
var statearr_18789_18862 = state_18758__$1;
(statearr_18789_18862[(1)] = (36));

} else {
var statearr_18790_18863 = state_18758__$1;
(statearr_18790_18863[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18759 === (13))){
var inst_18649 = (state_18758[(26)]);
var inst_18652 = cljs.core.async.close_BANG_.call(null,inst_18649);
var state_18758__$1 = state_18758;
var statearr_18791_18864 = state_18758__$1;
(statearr_18791_18864[(2)] = inst_18652);

(statearr_18791_18864[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18759 === (22))){
var inst_18670 = (state_18758[(8)]);
var inst_18673 = cljs.core.async.close_BANG_.call(null,inst_18670);
var state_18758__$1 = state_18758;
var statearr_18792_18865 = state_18758__$1;
(statearr_18792_18865[(2)] = inst_18673);

(statearr_18792_18865[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18759 === (36))){
var inst_18717 = (state_18758[(25)]);
var inst_18721 = cljs.core.chunk_first.call(null,inst_18717);
var inst_18722 = cljs.core.chunk_rest.call(null,inst_18717);
var inst_18723 = cljs.core.count.call(null,inst_18721);
var inst_18698 = inst_18722;
var inst_18699 = inst_18721;
var inst_18700 = inst_18723;
var inst_18701 = (0);
var state_18758__$1 = (function (){var statearr_18793 = state_18758;
(statearr_18793[(9)] = inst_18701);

(statearr_18793[(20)] = inst_18698);

(statearr_18793[(11)] = inst_18699);

(statearr_18793[(21)] = inst_18700);

return statearr_18793;
})();
var statearr_18794_18866 = state_18758__$1;
(statearr_18794_18866[(2)] = null);

(statearr_18794_18866[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18759 === (41))){
var inst_18717 = (state_18758[(25)]);
var inst_18733 = (state_18758[(2)]);
var inst_18734 = cljs.core.next.call(null,inst_18717);
var inst_18698 = inst_18734;
var inst_18699 = null;
var inst_18700 = (0);
var inst_18701 = (0);
var state_18758__$1 = (function (){var statearr_18795 = state_18758;
(statearr_18795[(9)] = inst_18701);

(statearr_18795[(27)] = inst_18733);

(statearr_18795[(20)] = inst_18698);

(statearr_18795[(11)] = inst_18699);

(statearr_18795[(21)] = inst_18700);

return statearr_18795;
})();
var statearr_18796_18867 = state_18758__$1;
(statearr_18796_18867[(2)] = null);

(statearr_18796_18867[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18759 === (43))){
var state_18758__$1 = state_18758;
var statearr_18797_18868 = state_18758__$1;
(statearr_18797_18868[(2)] = null);

(statearr_18797_18868[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18759 === (29))){
var inst_18742 = (state_18758[(2)]);
var state_18758__$1 = state_18758;
var statearr_18798_18869 = state_18758__$1;
(statearr_18798_18869[(2)] = inst_18742);

(statearr_18798_18869[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18759 === (44))){
var inst_18751 = (state_18758[(2)]);
var state_18758__$1 = (function (){var statearr_18799 = state_18758;
(statearr_18799[(28)] = inst_18751);

return statearr_18799;
})();
var statearr_18800_18870 = state_18758__$1;
(statearr_18800_18870[(2)] = null);

(statearr_18800_18870[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18759 === (6))){
var inst_18690 = (state_18758[(29)]);
var inst_18689 = cljs.core.deref.call(null,cs);
var inst_18690__$1 = cljs.core.keys.call(null,inst_18689);
var inst_18691 = cljs.core.count.call(null,inst_18690__$1);
var inst_18692 = cljs.core.reset_BANG_.call(null,dctr,inst_18691);
var inst_18697 = cljs.core.seq.call(null,inst_18690__$1);
var inst_18698 = inst_18697;
var inst_18699 = null;
var inst_18700 = (0);
var inst_18701 = (0);
var state_18758__$1 = (function (){var statearr_18801 = state_18758;
(statearr_18801[(9)] = inst_18701);

(statearr_18801[(20)] = inst_18698);

(statearr_18801[(30)] = inst_18692);

(statearr_18801[(11)] = inst_18699);

(statearr_18801[(29)] = inst_18690__$1);

(statearr_18801[(21)] = inst_18700);

return statearr_18801;
})();
var statearr_18802_18871 = state_18758__$1;
(statearr_18802_18871[(2)] = null);

(statearr_18802_18871[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18759 === (28))){
var inst_18698 = (state_18758[(20)]);
var inst_18717 = (state_18758[(25)]);
var inst_18717__$1 = cljs.core.seq.call(null,inst_18698);
var state_18758__$1 = (function (){var statearr_18803 = state_18758;
(statearr_18803[(25)] = inst_18717__$1);

return statearr_18803;
})();
if(inst_18717__$1){
var statearr_18804_18872 = state_18758__$1;
(statearr_18804_18872[(1)] = (33));

} else {
var statearr_18805_18873 = state_18758__$1;
(statearr_18805_18873[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18759 === (25))){
var inst_18701 = (state_18758[(9)]);
var inst_18700 = (state_18758[(21)]);
var inst_18703 = (inst_18701 < inst_18700);
var inst_18704 = inst_18703;
var state_18758__$1 = state_18758;
if(cljs.core.truth_(inst_18704)){
var statearr_18806_18874 = state_18758__$1;
(statearr_18806_18874[(1)] = (27));

} else {
var statearr_18807_18875 = state_18758__$1;
(statearr_18807_18875[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18759 === (34))){
var state_18758__$1 = state_18758;
var statearr_18808_18876 = state_18758__$1;
(statearr_18808_18876[(2)] = null);

(statearr_18808_18876[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18759 === (17))){
var state_18758__$1 = state_18758;
var statearr_18809_18877 = state_18758__$1;
(statearr_18809_18877[(2)] = null);

(statearr_18809_18877[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18759 === (3))){
var inst_18756 = (state_18758[(2)]);
var state_18758__$1 = state_18758;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18758__$1,inst_18756);
} else {
if((state_val_18759 === (12))){
var inst_18685 = (state_18758[(2)]);
var state_18758__$1 = state_18758;
var statearr_18810_18878 = state_18758__$1;
(statearr_18810_18878[(2)] = inst_18685);

(statearr_18810_18878[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18759 === (2))){
var state_18758__$1 = state_18758;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18758__$1,(4),ch);
} else {
if((state_val_18759 === (23))){
var state_18758__$1 = state_18758;
var statearr_18811_18879 = state_18758__$1;
(statearr_18811_18879[(2)] = null);

(statearr_18811_18879[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18759 === (35))){
var inst_18740 = (state_18758[(2)]);
var state_18758__$1 = state_18758;
var statearr_18812_18880 = state_18758__$1;
(statearr_18812_18880[(2)] = inst_18740);

(statearr_18812_18880[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18759 === (19))){
var inst_18659 = (state_18758[(7)]);
var inst_18663 = cljs.core.chunk_first.call(null,inst_18659);
var inst_18664 = cljs.core.chunk_rest.call(null,inst_18659);
var inst_18665 = cljs.core.count.call(null,inst_18663);
var inst_18639 = inst_18664;
var inst_18640 = inst_18663;
var inst_18641 = inst_18665;
var inst_18642 = (0);
var state_18758__$1 = (function (){var statearr_18813 = state_18758;
(statearr_18813[(13)] = inst_18641);

(statearr_18813[(14)] = inst_18639);

(statearr_18813[(15)] = inst_18640);

(statearr_18813[(16)] = inst_18642);

return statearr_18813;
})();
var statearr_18814_18881 = state_18758__$1;
(statearr_18814_18881[(2)] = null);

(statearr_18814_18881[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18759 === (11))){
var inst_18639 = (state_18758[(14)]);
var inst_18659 = (state_18758[(7)]);
var inst_18659__$1 = cljs.core.seq.call(null,inst_18639);
var state_18758__$1 = (function (){var statearr_18815 = state_18758;
(statearr_18815[(7)] = inst_18659__$1);

return statearr_18815;
})();
if(inst_18659__$1){
var statearr_18816_18882 = state_18758__$1;
(statearr_18816_18882[(1)] = (16));

} else {
var statearr_18817_18883 = state_18758__$1;
(statearr_18817_18883[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18759 === (9))){
var inst_18687 = (state_18758[(2)]);
var state_18758__$1 = state_18758;
var statearr_18818_18884 = state_18758__$1;
(statearr_18818_18884[(2)] = inst_18687);

(statearr_18818_18884[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18759 === (5))){
var inst_18637 = cljs.core.deref.call(null,cs);
var inst_18638 = cljs.core.seq.call(null,inst_18637);
var inst_18639 = inst_18638;
var inst_18640 = null;
var inst_18641 = (0);
var inst_18642 = (0);
var state_18758__$1 = (function (){var statearr_18819 = state_18758;
(statearr_18819[(13)] = inst_18641);

(statearr_18819[(14)] = inst_18639);

(statearr_18819[(15)] = inst_18640);

(statearr_18819[(16)] = inst_18642);

return statearr_18819;
})();
var statearr_18820_18885 = state_18758__$1;
(statearr_18820_18885[(2)] = null);

(statearr_18820_18885[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18759 === (14))){
var state_18758__$1 = state_18758;
var statearr_18821_18886 = state_18758__$1;
(statearr_18821_18886[(2)] = null);

(statearr_18821_18886[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18759 === (45))){
var inst_18748 = (state_18758[(2)]);
var state_18758__$1 = state_18758;
var statearr_18822_18887 = state_18758__$1;
(statearr_18822_18887[(2)] = inst_18748);

(statearr_18822_18887[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18759 === (26))){
var inst_18690 = (state_18758[(29)]);
var inst_18744 = (state_18758[(2)]);
var inst_18745 = cljs.core.seq.call(null,inst_18690);
var state_18758__$1 = (function (){var statearr_18823 = state_18758;
(statearr_18823[(31)] = inst_18744);

return statearr_18823;
})();
if(inst_18745){
var statearr_18824_18888 = state_18758__$1;
(statearr_18824_18888[(1)] = (42));

} else {
var statearr_18825_18889 = state_18758__$1;
(statearr_18825_18889[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18759 === (16))){
var inst_18659 = (state_18758[(7)]);
var inst_18661 = cljs.core.chunked_seq_QMARK_.call(null,inst_18659);
var state_18758__$1 = state_18758;
if(inst_18661){
var statearr_18826_18890 = state_18758__$1;
(statearr_18826_18890[(1)] = (19));

} else {
var statearr_18827_18891 = state_18758__$1;
(statearr_18827_18891[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18759 === (38))){
var inst_18737 = (state_18758[(2)]);
var state_18758__$1 = state_18758;
var statearr_18828_18892 = state_18758__$1;
(statearr_18828_18892[(2)] = inst_18737);

(statearr_18828_18892[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18759 === (30))){
var state_18758__$1 = state_18758;
var statearr_18829_18893 = state_18758__$1;
(statearr_18829_18893[(2)] = null);

(statearr_18829_18893[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18759 === (10))){
var inst_18640 = (state_18758[(15)]);
var inst_18642 = (state_18758[(16)]);
var inst_18648 = cljs.core._nth.call(null,inst_18640,inst_18642);
var inst_18649 = cljs.core.nth.call(null,inst_18648,(0),null);
var inst_18650 = cljs.core.nth.call(null,inst_18648,(1),null);
var state_18758__$1 = (function (){var statearr_18830 = state_18758;
(statearr_18830[(26)] = inst_18649);

return statearr_18830;
})();
if(cljs.core.truth_(inst_18650)){
var statearr_18831_18894 = state_18758__$1;
(statearr_18831_18894[(1)] = (13));

} else {
var statearr_18832_18895 = state_18758__$1;
(statearr_18832_18895[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18759 === (18))){
var inst_18683 = (state_18758[(2)]);
var state_18758__$1 = state_18758;
var statearr_18833_18896 = state_18758__$1;
(statearr_18833_18896[(2)] = inst_18683);

(statearr_18833_18896[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18759 === (42))){
var state_18758__$1 = state_18758;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18758__$1,(45),dchan);
} else {
if((state_val_18759 === (37))){
var inst_18630 = (state_18758[(12)]);
var inst_18726 = (state_18758[(23)]);
var inst_18717 = (state_18758[(25)]);
var inst_18726__$1 = cljs.core.first.call(null,inst_18717);
var inst_18727 = cljs.core.async.put_BANG_.call(null,inst_18726__$1,inst_18630,done);
var state_18758__$1 = (function (){var statearr_18834 = state_18758;
(statearr_18834[(23)] = inst_18726__$1);

return statearr_18834;
})();
if(cljs.core.truth_(inst_18727)){
var statearr_18835_18897 = state_18758__$1;
(statearr_18835_18897[(1)] = (39));

} else {
var statearr_18836_18898 = state_18758__$1;
(statearr_18836_18898[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18759 === (8))){
var inst_18641 = (state_18758[(13)]);
var inst_18642 = (state_18758[(16)]);
var inst_18644 = (inst_18642 < inst_18641);
var inst_18645 = inst_18644;
var state_18758__$1 = state_18758;
if(cljs.core.truth_(inst_18645)){
var statearr_18837_18899 = state_18758__$1;
(statearr_18837_18899[(1)] = (10));

} else {
var statearr_18838_18900 = state_18758__$1;
(statearr_18838_18900[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__9230__auto___18846,cs,m,dchan,dctr,done))
;
return ((function (switch__9165__auto__,c__9230__auto___18846,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__9166__auto__ = null;
var cljs$core$async$mult_$_state_machine__9166__auto____0 = (function (){
var statearr_18842 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18842[(0)] = cljs$core$async$mult_$_state_machine__9166__auto__);

(statearr_18842[(1)] = (1));

return statearr_18842;
});
var cljs$core$async$mult_$_state_machine__9166__auto____1 = (function (state_18758){
while(true){
var ret_value__9167__auto__ = (function (){try{while(true){
var result__9168__auto__ = switch__9165__auto__.call(null,state_18758);
if(cljs.core.keyword_identical_QMARK_.call(null,result__9168__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__9168__auto__;
}
break;
}
}catch (e18843){if((e18843 instanceof Object)){
var ex__9169__auto__ = e18843;
var statearr_18844_18901 = state_18758;
(statearr_18844_18901[(5)] = ex__9169__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18758);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e18843;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__9167__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18902 = state_18758;
state_18758 = G__18902;
continue;
} else {
return ret_value__9167__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__9166__auto__ = function(state_18758){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__9166__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__9166__auto____1.call(this,state_18758);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__9166__auto____0;
cljs$core$async$mult_$_state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__9166__auto____1;
return cljs$core$async$mult_$_state_machine__9166__auto__;
})()
;})(switch__9165__auto__,c__9230__auto___18846,cs,m,dchan,dctr,done))
})();
var state__9232__auto__ = (function (){var statearr_18845 = f__9231__auto__.call(null);
(statearr_18845[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__9230__auto___18846);

return statearr_18845;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__9232__auto__);
});})(c__9230__auto___18846,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args18903 = [];
var len__5627__auto___18906 = arguments.length;
var i__5628__auto___18907 = (0);
while(true){
if((i__5628__auto___18907 < len__5627__auto___18906)){
args18903.push((arguments[i__5628__auto___18907]));

var G__18908 = (i__5628__auto___18907 + (1));
i__5628__auto___18907 = G__18908;
continue;
} else {
}
break;
}

var G__18905 = args18903.length;
switch (G__18905) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18903.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;
/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__5224__auto__ = (((m == null))?null:m);
var m__5225__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return m__5225__auto__.call(null,m,ch);
} else {
var m__5225__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return m__5225__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__5224__auto__ = (((m == null))?null:m);
var m__5225__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return m__5225__auto__.call(null,m,ch);
} else {
var m__5225__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return m__5225__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__5224__auto__ = (((m == null))?null:m);
var m__5225__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return m__5225__auto__.call(null,m);
} else {
var m__5225__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return m__5225__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__5224__auto__ = (((m == null))?null:m);
var m__5225__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return m__5225__auto__.call(null,m,state_map);
} else {
var m__5225__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return m__5225__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__5224__auto__ = (((m == null))?null:m);
var m__5225__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return m__5225__auto__.call(null,m,mode);
} else {
var m__5225__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return m__5225__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__5634__auto__ = [];
var len__5627__auto___18920 = arguments.length;
var i__5628__auto___18921 = (0);
while(true){
if((i__5628__auto___18921 < len__5627__auto___18920)){
args__5634__auto__.push((arguments[i__5628__auto___18921]));

var G__18922 = (i__5628__auto___18921 + (1));
i__5628__auto___18921 = G__18922;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((3) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((3)),(0))):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5635__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__18914){
var map__18915 = p__18914;
var map__18915__$1 = ((((!((map__18915 == null)))?((((map__18915.cljs$lang$protocol_mask$partition0$ & (64))) || (map__18915.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__18915):map__18915);
var opts = map__18915__$1;
var statearr_18917_18923 = state;
(statearr_18917_18923[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__4425__auto__ = cljs.core.async.do_alts.call(null,((function (map__18915,map__18915__$1,opts){
return (function (val){
var statearr_18918_18924 = state;
(statearr_18918_18924[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__18915,map__18915__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4425__auto__)){
var cb = temp__4425__auto__;
var statearr_18919_18925 = state;
(statearr_18919_18925[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq18910){
var G__18911 = cljs.core.first.call(null,seq18910);
var seq18910__$1 = cljs.core.next.call(null,seq18910);
var G__18912 = cljs.core.first.call(null,seq18910__$1);
var seq18910__$2 = cljs.core.next.call(null,seq18910__$1);
var G__18913 = cljs.core.first.call(null,seq18910__$2);
var seq18910__$3 = cljs.core.next.call(null,seq18910__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__18911,G__18912,G__18913,seq18910__$3);
});
/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async19089 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19089 = (function (change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta19090){
this.change = change;
this.mix = mix;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta19090 = meta19090;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async19089.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_19091,meta19090__$1){
var self__ = this;
var _19091__$1 = this;
return (new cljs.core.async.t_cljs$core$async19089(self__.change,self__.mix,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta19090__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async19089.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_19091){
var self__ = this;
var _19091__$1 = this;
return self__.meta19090;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async19089.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async19089.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async19089.prototype.cljs$core$async$Mix$ = true;

cljs.core.async.t_cljs$core$async19089.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async19089.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async19089.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async19089.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async19089.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"mode","mode",-2000032078,null))))].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async19089.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),cljs.core.with_meta(new cljs.core.Symbol(null,"mix","mix",2121373763,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mix of one or more input channels which will\n  be put on the supplied out channel. Input sources can be added to\n  the mix with 'admix', and removed with 'unmix'. A mix supports\n  soloing, muting and pausing multiple inputs atomically using\n  'toggle', and can solo using either muting or pausing as determined\n  by 'solo-mode'.\n\n  Each channel can have zero or more boolean modes set via 'toggle':\n\n  :solo - when true, only this (ond other soloed) channel(s) will appear\n          in the mix output channel. :mute and :pause states of soloed\n          channels are ignored. If solo-mode is :mute, non-soloed\n          channels are muted, if :pause, non-soloed channels are\n          paused.\n\n  :mute - muted channels will have their contents consumed but not included in the mix\n  :pause - paused channels will not have their contents consumed (and thus also not included in the mix)\n"], null)),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta19090","meta19090",-1842416825,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async19089.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19089.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19089";

cljs.core.async.t_cljs$core$async19089.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write.call(null,writer__5168__auto__,"cljs.core.async/t_cljs$core$async19089");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async19089 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async19089(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta19090){
return (new cljs.core.async.t_cljs$core$async19089(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta19090));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async19089(change,cljs$core$async$mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__9230__auto___19252 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__9230__auto___19252,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__9231__auto__ = (function (){var switch__9165__auto__ = ((function (c__9230__auto___19252,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_19189){
var state_val_19190 = (state_19189[(1)]);
if((state_val_19190 === (7))){
var inst_19107 = (state_19189[(2)]);
var state_19189__$1 = state_19189;
var statearr_19191_19253 = state_19189__$1;
(statearr_19191_19253[(2)] = inst_19107);

(statearr_19191_19253[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19190 === (20))){
var inst_19119 = (state_19189[(7)]);
var state_19189__$1 = state_19189;
var statearr_19192_19254 = state_19189__$1;
(statearr_19192_19254[(2)] = inst_19119);

(statearr_19192_19254[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19190 === (27))){
var state_19189__$1 = state_19189;
var statearr_19193_19255 = state_19189__$1;
(statearr_19193_19255[(2)] = null);

(statearr_19193_19255[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19190 === (1))){
var inst_19095 = (state_19189[(8)]);
var inst_19095__$1 = calc_state.call(null);
var inst_19097 = (inst_19095__$1 == null);
var inst_19098 = cljs.core.not.call(null,inst_19097);
var state_19189__$1 = (function (){var statearr_19194 = state_19189;
(statearr_19194[(8)] = inst_19095__$1);

return statearr_19194;
})();
if(inst_19098){
var statearr_19195_19256 = state_19189__$1;
(statearr_19195_19256[(1)] = (2));

} else {
var statearr_19196_19257 = state_19189__$1;
(statearr_19196_19257[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19190 === (24))){
var inst_19149 = (state_19189[(9)]);
var inst_19163 = (state_19189[(10)]);
var inst_19142 = (state_19189[(11)]);
var inst_19163__$1 = inst_19142.call(null,inst_19149);
var state_19189__$1 = (function (){var statearr_19197 = state_19189;
(statearr_19197[(10)] = inst_19163__$1);

return statearr_19197;
})();
if(cljs.core.truth_(inst_19163__$1)){
var statearr_19198_19258 = state_19189__$1;
(statearr_19198_19258[(1)] = (29));

} else {
var statearr_19199_19259 = state_19189__$1;
(statearr_19199_19259[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19190 === (4))){
var inst_19110 = (state_19189[(2)]);
var state_19189__$1 = state_19189;
if(cljs.core.truth_(inst_19110)){
var statearr_19200_19260 = state_19189__$1;
(statearr_19200_19260[(1)] = (8));

} else {
var statearr_19201_19261 = state_19189__$1;
(statearr_19201_19261[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19190 === (15))){
var inst_19136 = (state_19189[(2)]);
var state_19189__$1 = state_19189;
if(cljs.core.truth_(inst_19136)){
var statearr_19202_19262 = state_19189__$1;
(statearr_19202_19262[(1)] = (19));

} else {
var statearr_19203_19263 = state_19189__$1;
(statearr_19203_19263[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19190 === (21))){
var inst_19141 = (state_19189[(12)]);
var inst_19141__$1 = (state_19189[(2)]);
var inst_19142 = cljs.core.get.call(null,inst_19141__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_19143 = cljs.core.get.call(null,inst_19141__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_19144 = cljs.core.get.call(null,inst_19141__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_19189__$1 = (function (){var statearr_19204 = state_19189;
(statearr_19204[(12)] = inst_19141__$1);

(statearr_19204[(13)] = inst_19143);

(statearr_19204[(11)] = inst_19142);

return statearr_19204;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_19189__$1,(22),inst_19144);
} else {
if((state_val_19190 === (31))){
var inst_19171 = (state_19189[(2)]);
var state_19189__$1 = state_19189;
if(cljs.core.truth_(inst_19171)){
var statearr_19205_19264 = state_19189__$1;
(statearr_19205_19264[(1)] = (32));

} else {
var statearr_19206_19265 = state_19189__$1;
(statearr_19206_19265[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19190 === (32))){
var inst_19148 = (state_19189[(14)]);
var state_19189__$1 = state_19189;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19189__$1,(35),out,inst_19148);
} else {
if((state_val_19190 === (33))){
var inst_19141 = (state_19189[(12)]);
var inst_19119 = inst_19141;
var state_19189__$1 = (function (){var statearr_19207 = state_19189;
(statearr_19207[(7)] = inst_19119);

return statearr_19207;
})();
var statearr_19208_19266 = state_19189__$1;
(statearr_19208_19266[(2)] = null);

(statearr_19208_19266[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19190 === (13))){
var inst_19119 = (state_19189[(7)]);
var inst_19126 = inst_19119.cljs$lang$protocol_mask$partition0$;
var inst_19127 = (inst_19126 & (64));
var inst_19128 = inst_19119.cljs$core$ISeq$;
var inst_19129 = (inst_19127) || (inst_19128);
var state_19189__$1 = state_19189;
if(cljs.core.truth_(inst_19129)){
var statearr_19209_19267 = state_19189__$1;
(statearr_19209_19267[(1)] = (16));

} else {
var statearr_19210_19268 = state_19189__$1;
(statearr_19210_19268[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19190 === (22))){
var inst_19148 = (state_19189[(14)]);
var inst_19149 = (state_19189[(9)]);
var inst_19147 = (state_19189[(2)]);
var inst_19148__$1 = cljs.core.nth.call(null,inst_19147,(0),null);
var inst_19149__$1 = cljs.core.nth.call(null,inst_19147,(1),null);
var inst_19150 = (inst_19148__$1 == null);
var inst_19151 = cljs.core._EQ_.call(null,inst_19149__$1,change);
var inst_19152 = (inst_19150) || (inst_19151);
var state_19189__$1 = (function (){var statearr_19211 = state_19189;
(statearr_19211[(14)] = inst_19148__$1);

(statearr_19211[(9)] = inst_19149__$1);

return statearr_19211;
})();
if(cljs.core.truth_(inst_19152)){
var statearr_19212_19269 = state_19189__$1;
(statearr_19212_19269[(1)] = (23));

} else {
var statearr_19213_19270 = state_19189__$1;
(statearr_19213_19270[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19190 === (36))){
var inst_19141 = (state_19189[(12)]);
var inst_19119 = inst_19141;
var state_19189__$1 = (function (){var statearr_19214 = state_19189;
(statearr_19214[(7)] = inst_19119);

return statearr_19214;
})();
var statearr_19215_19271 = state_19189__$1;
(statearr_19215_19271[(2)] = null);

(statearr_19215_19271[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19190 === (29))){
var inst_19163 = (state_19189[(10)]);
var state_19189__$1 = state_19189;
var statearr_19216_19272 = state_19189__$1;
(statearr_19216_19272[(2)] = inst_19163);

(statearr_19216_19272[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19190 === (6))){
var state_19189__$1 = state_19189;
var statearr_19217_19273 = state_19189__$1;
(statearr_19217_19273[(2)] = false);

(statearr_19217_19273[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19190 === (28))){
var inst_19159 = (state_19189[(2)]);
var inst_19160 = calc_state.call(null);
var inst_19119 = inst_19160;
var state_19189__$1 = (function (){var statearr_19218 = state_19189;
(statearr_19218[(15)] = inst_19159);

(statearr_19218[(7)] = inst_19119);

return statearr_19218;
})();
var statearr_19219_19274 = state_19189__$1;
(statearr_19219_19274[(2)] = null);

(statearr_19219_19274[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19190 === (25))){
var inst_19185 = (state_19189[(2)]);
var state_19189__$1 = state_19189;
var statearr_19220_19275 = state_19189__$1;
(statearr_19220_19275[(2)] = inst_19185);

(statearr_19220_19275[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19190 === (34))){
var inst_19183 = (state_19189[(2)]);
var state_19189__$1 = state_19189;
var statearr_19221_19276 = state_19189__$1;
(statearr_19221_19276[(2)] = inst_19183);

(statearr_19221_19276[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19190 === (17))){
var state_19189__$1 = state_19189;
var statearr_19222_19277 = state_19189__$1;
(statearr_19222_19277[(2)] = false);

(statearr_19222_19277[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19190 === (3))){
var state_19189__$1 = state_19189;
var statearr_19223_19278 = state_19189__$1;
(statearr_19223_19278[(2)] = false);

(statearr_19223_19278[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19190 === (12))){
var inst_19187 = (state_19189[(2)]);
var state_19189__$1 = state_19189;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19189__$1,inst_19187);
} else {
if((state_val_19190 === (2))){
var inst_19095 = (state_19189[(8)]);
var inst_19100 = inst_19095.cljs$lang$protocol_mask$partition0$;
var inst_19101 = (inst_19100 & (64));
var inst_19102 = inst_19095.cljs$core$ISeq$;
var inst_19103 = (inst_19101) || (inst_19102);
var state_19189__$1 = state_19189;
if(cljs.core.truth_(inst_19103)){
var statearr_19224_19279 = state_19189__$1;
(statearr_19224_19279[(1)] = (5));

} else {
var statearr_19225_19280 = state_19189__$1;
(statearr_19225_19280[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19190 === (23))){
var inst_19148 = (state_19189[(14)]);
var inst_19154 = (inst_19148 == null);
var state_19189__$1 = state_19189;
if(cljs.core.truth_(inst_19154)){
var statearr_19226_19281 = state_19189__$1;
(statearr_19226_19281[(1)] = (26));

} else {
var statearr_19227_19282 = state_19189__$1;
(statearr_19227_19282[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19190 === (35))){
var inst_19174 = (state_19189[(2)]);
var state_19189__$1 = state_19189;
if(cljs.core.truth_(inst_19174)){
var statearr_19228_19283 = state_19189__$1;
(statearr_19228_19283[(1)] = (36));

} else {
var statearr_19229_19284 = state_19189__$1;
(statearr_19229_19284[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19190 === (19))){
var inst_19119 = (state_19189[(7)]);
var inst_19138 = cljs.core.apply.call(null,cljs.core.hash_map,inst_19119);
var state_19189__$1 = state_19189;
var statearr_19230_19285 = state_19189__$1;
(statearr_19230_19285[(2)] = inst_19138);

(statearr_19230_19285[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19190 === (11))){
var inst_19119 = (state_19189[(7)]);
var inst_19123 = (inst_19119 == null);
var inst_19124 = cljs.core.not.call(null,inst_19123);
var state_19189__$1 = state_19189;
if(inst_19124){
var statearr_19231_19286 = state_19189__$1;
(statearr_19231_19286[(1)] = (13));

} else {
var statearr_19232_19287 = state_19189__$1;
(statearr_19232_19287[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19190 === (9))){
var inst_19095 = (state_19189[(8)]);
var state_19189__$1 = state_19189;
var statearr_19233_19288 = state_19189__$1;
(statearr_19233_19288[(2)] = inst_19095);

(statearr_19233_19288[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19190 === (5))){
var state_19189__$1 = state_19189;
var statearr_19234_19289 = state_19189__$1;
(statearr_19234_19289[(2)] = true);

(statearr_19234_19289[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19190 === (14))){
var state_19189__$1 = state_19189;
var statearr_19235_19290 = state_19189__$1;
(statearr_19235_19290[(2)] = false);

(statearr_19235_19290[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19190 === (26))){
var inst_19149 = (state_19189[(9)]);
var inst_19156 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_19149);
var state_19189__$1 = state_19189;
var statearr_19236_19291 = state_19189__$1;
(statearr_19236_19291[(2)] = inst_19156);

(statearr_19236_19291[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19190 === (16))){
var state_19189__$1 = state_19189;
var statearr_19237_19292 = state_19189__$1;
(statearr_19237_19292[(2)] = true);

(statearr_19237_19292[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19190 === (38))){
var inst_19179 = (state_19189[(2)]);
var state_19189__$1 = state_19189;
var statearr_19238_19293 = state_19189__$1;
(statearr_19238_19293[(2)] = inst_19179);

(statearr_19238_19293[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19190 === (30))){
var inst_19143 = (state_19189[(13)]);
var inst_19149 = (state_19189[(9)]);
var inst_19142 = (state_19189[(11)]);
var inst_19166 = cljs.core.empty_QMARK_.call(null,inst_19142);
var inst_19167 = inst_19143.call(null,inst_19149);
var inst_19168 = cljs.core.not.call(null,inst_19167);
var inst_19169 = (inst_19166) && (inst_19168);
var state_19189__$1 = state_19189;
var statearr_19239_19294 = state_19189__$1;
(statearr_19239_19294[(2)] = inst_19169);

(statearr_19239_19294[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19190 === (10))){
var inst_19095 = (state_19189[(8)]);
var inst_19115 = (state_19189[(2)]);
var inst_19116 = cljs.core.get.call(null,inst_19115,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_19117 = cljs.core.get.call(null,inst_19115,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_19118 = cljs.core.get.call(null,inst_19115,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_19119 = inst_19095;
var state_19189__$1 = (function (){var statearr_19240 = state_19189;
(statearr_19240[(16)] = inst_19118);

(statearr_19240[(17)] = inst_19116);

(statearr_19240[(7)] = inst_19119);

(statearr_19240[(18)] = inst_19117);

return statearr_19240;
})();
var statearr_19241_19295 = state_19189__$1;
(statearr_19241_19295[(2)] = null);

(statearr_19241_19295[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19190 === (18))){
var inst_19133 = (state_19189[(2)]);
var state_19189__$1 = state_19189;
var statearr_19242_19296 = state_19189__$1;
(statearr_19242_19296[(2)] = inst_19133);

(statearr_19242_19296[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19190 === (37))){
var state_19189__$1 = state_19189;
var statearr_19243_19297 = state_19189__$1;
(statearr_19243_19297[(2)] = null);

(statearr_19243_19297[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19190 === (8))){
var inst_19095 = (state_19189[(8)]);
var inst_19112 = cljs.core.apply.call(null,cljs.core.hash_map,inst_19095);
var state_19189__$1 = state_19189;
var statearr_19244_19298 = state_19189__$1;
(statearr_19244_19298[(2)] = inst_19112);

(statearr_19244_19298[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__9230__auto___19252,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__9165__auto__,c__9230__auto___19252,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__9166__auto__ = null;
var cljs$core$async$mix_$_state_machine__9166__auto____0 = (function (){
var statearr_19248 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19248[(0)] = cljs$core$async$mix_$_state_machine__9166__auto__);

(statearr_19248[(1)] = (1));

return statearr_19248;
});
var cljs$core$async$mix_$_state_machine__9166__auto____1 = (function (state_19189){
while(true){
var ret_value__9167__auto__ = (function (){try{while(true){
var result__9168__auto__ = switch__9165__auto__.call(null,state_19189);
if(cljs.core.keyword_identical_QMARK_.call(null,result__9168__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__9168__auto__;
}
break;
}
}catch (e19249){if((e19249 instanceof Object)){
var ex__9169__auto__ = e19249;
var statearr_19250_19299 = state_19189;
(statearr_19250_19299[(5)] = ex__9169__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19189);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19249;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__9167__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19300 = state_19189;
state_19189 = G__19300;
continue;
} else {
return ret_value__9167__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__9166__auto__ = function(state_19189){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__9166__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__9166__auto____1.call(this,state_19189);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__9166__auto____0;
cljs$core$async$mix_$_state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__9166__auto____1;
return cljs$core$async$mix_$_state_machine__9166__auto__;
})()
;})(switch__9165__auto__,c__9230__auto___19252,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__9232__auto__ = (function (){var statearr_19251 = f__9231__auto__.call(null);
(statearr_19251[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__9230__auto___19252);

return statearr_19251;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__9232__auto__);
});})(c__9230__auto___19252,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__5224__auto__ = (((p == null))?null:p);
var m__5225__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return m__5225__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__5225__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return m__5225__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__5224__auto__ = (((p == null))?null:p);
var m__5225__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return m__5225__auto__.call(null,p,v,ch);
} else {
var m__5225__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return m__5225__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args19301 = [];
var len__5627__auto___19304 = arguments.length;
var i__5628__auto___19305 = (0);
while(true){
if((i__5628__auto___19305 < len__5627__auto___19304)){
args19301.push((arguments[i__5628__auto___19305]));

var G__19306 = (i__5628__auto___19305 + (1));
i__5628__auto___19305 = G__19306;
continue;
} else {
}
break;
}

var G__19303 = args19301.length;
switch (G__19303) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19301.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__5224__auto__ = (((p == null))?null:p);
var m__5225__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return m__5225__auto__.call(null,p);
} else {
var m__5225__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return m__5225__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__5224__auto__ = (((p == null))?null:p);
var m__5225__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return m__5225__auto__.call(null,p,v);
} else {
var m__5225__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__5225__auto____$1 == null))){
return m__5225__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;

/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args19309 = [];
var len__5627__auto___19434 = arguments.length;
var i__5628__auto___19435 = (0);
while(true){
if((i__5628__auto___19435 < len__5627__auto___19434)){
args19309.push((arguments[i__5628__auto___19435]));

var G__19436 = (i__5628__auto___19435 + (1));
i__5628__auto___19435 = G__19436;
continue;
} else {
}
break;
}

var G__19311 = args19309.length;
switch (G__19311) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19309.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__4569__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__4569__auto__,mults){
return (function (p1__19308_SHARP_){
if(cljs.core.truth_(p1__19308_SHARP_.call(null,topic))){
return p1__19308_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__19308_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__4569__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async19312 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19312 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta19313){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta19313 = meta19313;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async19312.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_19314,meta19313__$1){
var self__ = this;
var _19314__$1 = this;
return (new cljs.core.async.t_cljs$core$async19312(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta19313__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19312.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_19314){
var self__ = this;
var _19314__$1 = this;
return self__.meta19313;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19312.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async19312.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19312.prototype.cljs$core$async$Pub$ = true;

cljs.core.async.t_cljs$core$async19312.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19312.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4425__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__4425__auto__)){
var m = temp__4425__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19312.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19312.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19312.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta19313","meta19313",1345773417,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19312.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19312.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19312";

cljs.core.async.t_cljs$core$async19312.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write.call(null,writer__5168__auto__,"cljs.core.async/t_cljs$core$async19312");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async19312 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async19312(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta19313){
return (new cljs.core.async.t_cljs$core$async19312(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta19313));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async19312(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__9230__auto___19438 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__9230__auto___19438,mults,ensure_mult,p){
return (function (){
var f__9231__auto__ = (function (){var switch__9165__auto__ = ((function (c__9230__auto___19438,mults,ensure_mult,p){
return (function (state_19386){
var state_val_19387 = (state_19386[(1)]);
if((state_val_19387 === (7))){
var inst_19382 = (state_19386[(2)]);
var state_19386__$1 = state_19386;
var statearr_19388_19439 = state_19386__$1;
(statearr_19388_19439[(2)] = inst_19382);

(statearr_19388_19439[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19387 === (20))){
var state_19386__$1 = state_19386;
var statearr_19389_19440 = state_19386__$1;
(statearr_19389_19440[(2)] = null);

(statearr_19389_19440[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19387 === (1))){
var state_19386__$1 = state_19386;
var statearr_19390_19441 = state_19386__$1;
(statearr_19390_19441[(2)] = null);

(statearr_19390_19441[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19387 === (24))){
var inst_19365 = (state_19386[(7)]);
var inst_19374 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_19365);
var state_19386__$1 = state_19386;
var statearr_19391_19442 = state_19386__$1;
(statearr_19391_19442[(2)] = inst_19374);

(statearr_19391_19442[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19387 === (4))){
var inst_19317 = (state_19386[(8)]);
var inst_19317__$1 = (state_19386[(2)]);
var inst_19318 = (inst_19317__$1 == null);
var state_19386__$1 = (function (){var statearr_19392 = state_19386;
(statearr_19392[(8)] = inst_19317__$1);

return statearr_19392;
})();
if(cljs.core.truth_(inst_19318)){
var statearr_19393_19443 = state_19386__$1;
(statearr_19393_19443[(1)] = (5));

} else {
var statearr_19394_19444 = state_19386__$1;
(statearr_19394_19444[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19387 === (15))){
var inst_19359 = (state_19386[(2)]);
var state_19386__$1 = state_19386;
var statearr_19395_19445 = state_19386__$1;
(statearr_19395_19445[(2)] = inst_19359);

(statearr_19395_19445[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19387 === (21))){
var inst_19379 = (state_19386[(2)]);
var state_19386__$1 = (function (){var statearr_19396 = state_19386;
(statearr_19396[(9)] = inst_19379);

return statearr_19396;
})();
var statearr_19397_19446 = state_19386__$1;
(statearr_19397_19446[(2)] = null);

(statearr_19397_19446[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19387 === (13))){
var inst_19341 = (state_19386[(10)]);
var inst_19343 = cljs.core.chunked_seq_QMARK_.call(null,inst_19341);
var state_19386__$1 = state_19386;
if(inst_19343){
var statearr_19398_19447 = state_19386__$1;
(statearr_19398_19447[(1)] = (16));

} else {
var statearr_19399_19448 = state_19386__$1;
(statearr_19399_19448[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19387 === (22))){
var inst_19371 = (state_19386[(2)]);
var state_19386__$1 = state_19386;
if(cljs.core.truth_(inst_19371)){
var statearr_19400_19449 = state_19386__$1;
(statearr_19400_19449[(1)] = (23));

} else {
var statearr_19401_19450 = state_19386__$1;
(statearr_19401_19450[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19387 === (6))){
var inst_19317 = (state_19386[(8)]);
var inst_19365 = (state_19386[(7)]);
var inst_19367 = (state_19386[(11)]);
var inst_19365__$1 = topic_fn.call(null,inst_19317);
var inst_19366 = cljs.core.deref.call(null,mults);
var inst_19367__$1 = cljs.core.get.call(null,inst_19366,inst_19365__$1);
var state_19386__$1 = (function (){var statearr_19402 = state_19386;
(statearr_19402[(7)] = inst_19365__$1);

(statearr_19402[(11)] = inst_19367__$1);

return statearr_19402;
})();
if(cljs.core.truth_(inst_19367__$1)){
var statearr_19403_19451 = state_19386__$1;
(statearr_19403_19451[(1)] = (19));

} else {
var statearr_19404_19452 = state_19386__$1;
(statearr_19404_19452[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19387 === (25))){
var inst_19376 = (state_19386[(2)]);
var state_19386__$1 = state_19386;
var statearr_19405_19453 = state_19386__$1;
(statearr_19405_19453[(2)] = inst_19376);

(statearr_19405_19453[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19387 === (17))){
var inst_19341 = (state_19386[(10)]);
var inst_19350 = cljs.core.first.call(null,inst_19341);
var inst_19351 = cljs.core.async.muxch_STAR_.call(null,inst_19350);
var inst_19352 = cljs.core.async.close_BANG_.call(null,inst_19351);
var inst_19353 = cljs.core.next.call(null,inst_19341);
var inst_19327 = inst_19353;
var inst_19328 = null;
var inst_19329 = (0);
var inst_19330 = (0);
var state_19386__$1 = (function (){var statearr_19406 = state_19386;
(statearr_19406[(12)] = inst_19329);

(statearr_19406[(13)] = inst_19330);

(statearr_19406[(14)] = inst_19328);

(statearr_19406[(15)] = inst_19352);

(statearr_19406[(16)] = inst_19327);

return statearr_19406;
})();
var statearr_19407_19454 = state_19386__$1;
(statearr_19407_19454[(2)] = null);

(statearr_19407_19454[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19387 === (3))){
var inst_19384 = (state_19386[(2)]);
var state_19386__$1 = state_19386;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19386__$1,inst_19384);
} else {
if((state_val_19387 === (12))){
var inst_19361 = (state_19386[(2)]);
var state_19386__$1 = state_19386;
var statearr_19408_19455 = state_19386__$1;
(statearr_19408_19455[(2)] = inst_19361);

(statearr_19408_19455[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19387 === (2))){
var state_19386__$1 = state_19386;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19386__$1,(4),ch);
} else {
if((state_val_19387 === (23))){
var state_19386__$1 = state_19386;
var statearr_19409_19456 = state_19386__$1;
(statearr_19409_19456[(2)] = null);

(statearr_19409_19456[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19387 === (19))){
var inst_19317 = (state_19386[(8)]);
var inst_19367 = (state_19386[(11)]);
var inst_19369 = cljs.core.async.muxch_STAR_.call(null,inst_19367);
var state_19386__$1 = state_19386;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19386__$1,(22),inst_19369,inst_19317);
} else {
if((state_val_19387 === (11))){
var inst_19341 = (state_19386[(10)]);
var inst_19327 = (state_19386[(16)]);
var inst_19341__$1 = cljs.core.seq.call(null,inst_19327);
var state_19386__$1 = (function (){var statearr_19410 = state_19386;
(statearr_19410[(10)] = inst_19341__$1);

return statearr_19410;
})();
if(inst_19341__$1){
var statearr_19411_19457 = state_19386__$1;
(statearr_19411_19457[(1)] = (13));

} else {
var statearr_19412_19458 = state_19386__$1;
(statearr_19412_19458[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19387 === (9))){
var inst_19363 = (state_19386[(2)]);
var state_19386__$1 = state_19386;
var statearr_19413_19459 = state_19386__$1;
(statearr_19413_19459[(2)] = inst_19363);

(statearr_19413_19459[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19387 === (5))){
var inst_19324 = cljs.core.deref.call(null,mults);
var inst_19325 = cljs.core.vals.call(null,inst_19324);
var inst_19326 = cljs.core.seq.call(null,inst_19325);
var inst_19327 = inst_19326;
var inst_19328 = null;
var inst_19329 = (0);
var inst_19330 = (0);
var state_19386__$1 = (function (){var statearr_19414 = state_19386;
(statearr_19414[(12)] = inst_19329);

(statearr_19414[(13)] = inst_19330);

(statearr_19414[(14)] = inst_19328);

(statearr_19414[(16)] = inst_19327);

return statearr_19414;
})();
var statearr_19415_19460 = state_19386__$1;
(statearr_19415_19460[(2)] = null);

(statearr_19415_19460[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19387 === (14))){
var state_19386__$1 = state_19386;
var statearr_19419_19461 = state_19386__$1;
(statearr_19419_19461[(2)] = null);

(statearr_19419_19461[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19387 === (16))){
var inst_19341 = (state_19386[(10)]);
var inst_19345 = cljs.core.chunk_first.call(null,inst_19341);
var inst_19346 = cljs.core.chunk_rest.call(null,inst_19341);
var inst_19347 = cljs.core.count.call(null,inst_19345);
var inst_19327 = inst_19346;
var inst_19328 = inst_19345;
var inst_19329 = inst_19347;
var inst_19330 = (0);
var state_19386__$1 = (function (){var statearr_19420 = state_19386;
(statearr_19420[(12)] = inst_19329);

(statearr_19420[(13)] = inst_19330);

(statearr_19420[(14)] = inst_19328);

(statearr_19420[(16)] = inst_19327);

return statearr_19420;
})();
var statearr_19421_19462 = state_19386__$1;
(statearr_19421_19462[(2)] = null);

(statearr_19421_19462[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19387 === (10))){
var inst_19329 = (state_19386[(12)]);
var inst_19330 = (state_19386[(13)]);
var inst_19328 = (state_19386[(14)]);
var inst_19327 = (state_19386[(16)]);
var inst_19335 = cljs.core._nth.call(null,inst_19328,inst_19330);
var inst_19336 = cljs.core.async.muxch_STAR_.call(null,inst_19335);
var inst_19337 = cljs.core.async.close_BANG_.call(null,inst_19336);
var inst_19338 = (inst_19330 + (1));
var tmp19416 = inst_19329;
var tmp19417 = inst_19328;
var tmp19418 = inst_19327;
var inst_19327__$1 = tmp19418;
var inst_19328__$1 = tmp19417;
var inst_19329__$1 = tmp19416;
var inst_19330__$1 = inst_19338;
var state_19386__$1 = (function (){var statearr_19422 = state_19386;
(statearr_19422[(12)] = inst_19329__$1);

(statearr_19422[(13)] = inst_19330__$1);

(statearr_19422[(14)] = inst_19328__$1);

(statearr_19422[(17)] = inst_19337);

(statearr_19422[(16)] = inst_19327__$1);

return statearr_19422;
})();
var statearr_19423_19463 = state_19386__$1;
(statearr_19423_19463[(2)] = null);

(statearr_19423_19463[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19387 === (18))){
var inst_19356 = (state_19386[(2)]);
var state_19386__$1 = state_19386;
var statearr_19424_19464 = state_19386__$1;
(statearr_19424_19464[(2)] = inst_19356);

(statearr_19424_19464[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19387 === (8))){
var inst_19329 = (state_19386[(12)]);
var inst_19330 = (state_19386[(13)]);
var inst_19332 = (inst_19330 < inst_19329);
var inst_19333 = inst_19332;
var state_19386__$1 = state_19386;
if(cljs.core.truth_(inst_19333)){
var statearr_19425_19465 = state_19386__$1;
(statearr_19425_19465[(1)] = (10));

} else {
var statearr_19426_19466 = state_19386__$1;
(statearr_19426_19466[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__9230__auto___19438,mults,ensure_mult,p))
;
return ((function (switch__9165__auto__,c__9230__auto___19438,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__9166__auto__ = null;
var cljs$core$async$state_machine__9166__auto____0 = (function (){
var statearr_19430 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19430[(0)] = cljs$core$async$state_machine__9166__auto__);

(statearr_19430[(1)] = (1));

return statearr_19430;
});
var cljs$core$async$state_machine__9166__auto____1 = (function (state_19386){
while(true){
var ret_value__9167__auto__ = (function (){try{while(true){
var result__9168__auto__ = switch__9165__auto__.call(null,state_19386);
if(cljs.core.keyword_identical_QMARK_.call(null,result__9168__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__9168__auto__;
}
break;
}
}catch (e19431){if((e19431 instanceof Object)){
var ex__9169__auto__ = e19431;
var statearr_19432_19467 = state_19386;
(statearr_19432_19467[(5)] = ex__9169__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19386);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19431;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__9167__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19468 = state_19386;
state_19386 = G__19468;
continue;
} else {
return ret_value__9167__auto__;
}
break;
}
});
cljs$core$async$state_machine__9166__auto__ = function(state_19386){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__9166__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__9166__auto____1.call(this,state_19386);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__9166__auto____0;
cljs$core$async$state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__9166__auto____1;
return cljs$core$async$state_machine__9166__auto__;
})()
;})(switch__9165__auto__,c__9230__auto___19438,mults,ensure_mult,p))
})();
var state__9232__auto__ = (function (){var statearr_19433 = f__9231__auto__.call(null);
(statearr_19433[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__9230__auto___19438);

return statearr_19433;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__9232__auto__);
});})(c__9230__auto___19438,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;
/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args19469 = [];
var len__5627__auto___19472 = arguments.length;
var i__5628__auto___19473 = (0);
while(true){
if((i__5628__auto___19473 < len__5627__auto___19472)){
args19469.push((arguments[i__5628__auto___19473]));

var G__19474 = (i__5628__auto___19473 + (1));
i__5628__auto___19473 = G__19474;
continue;
} else {
}
break;
}

var G__19471 = args19469.length;
switch (G__19471) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19469.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;
/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args19476 = [];
var len__5627__auto___19479 = arguments.length;
var i__5628__auto___19480 = (0);
while(true){
if((i__5628__auto___19480 < len__5627__auto___19479)){
args19476.push((arguments[i__5628__auto___19480]));

var G__19481 = (i__5628__auto___19480 + (1));
i__5628__auto___19480 = G__19481;
continue;
} else {
}
break;
}

var G__19478 = args19476.length;
switch (G__19478) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19476.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;
/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args19483 = [];
var len__5627__auto___19554 = arguments.length;
var i__5628__auto___19555 = (0);
while(true){
if((i__5628__auto___19555 < len__5627__auto___19554)){
args19483.push((arguments[i__5628__auto___19555]));

var G__19556 = (i__5628__auto___19555 + (1));
i__5628__auto___19555 = G__19556;
continue;
} else {
}
break;
}

var G__19485 = args19483.length;
switch (G__19485) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19483.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__9230__auto___19558 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__9230__auto___19558,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__9231__auto__ = (function (){var switch__9165__auto__ = ((function (c__9230__auto___19558,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_19524){
var state_val_19525 = (state_19524[(1)]);
if((state_val_19525 === (7))){
var state_19524__$1 = state_19524;
var statearr_19526_19559 = state_19524__$1;
(statearr_19526_19559[(2)] = null);

(statearr_19526_19559[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19525 === (1))){
var state_19524__$1 = state_19524;
var statearr_19527_19560 = state_19524__$1;
(statearr_19527_19560[(2)] = null);

(statearr_19527_19560[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19525 === (4))){
var inst_19488 = (state_19524[(7)]);
var inst_19490 = (inst_19488 < cnt);
var state_19524__$1 = state_19524;
if(cljs.core.truth_(inst_19490)){
var statearr_19528_19561 = state_19524__$1;
(statearr_19528_19561[(1)] = (6));

} else {
var statearr_19529_19562 = state_19524__$1;
(statearr_19529_19562[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19525 === (15))){
var inst_19520 = (state_19524[(2)]);
var state_19524__$1 = state_19524;
var statearr_19530_19563 = state_19524__$1;
(statearr_19530_19563[(2)] = inst_19520);

(statearr_19530_19563[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19525 === (13))){
var inst_19513 = cljs.core.async.close_BANG_.call(null,out);
var state_19524__$1 = state_19524;
var statearr_19531_19564 = state_19524__$1;
(statearr_19531_19564[(2)] = inst_19513);

(statearr_19531_19564[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19525 === (6))){
var state_19524__$1 = state_19524;
var statearr_19532_19565 = state_19524__$1;
(statearr_19532_19565[(2)] = null);

(statearr_19532_19565[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19525 === (3))){
var inst_19522 = (state_19524[(2)]);
var state_19524__$1 = state_19524;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19524__$1,inst_19522);
} else {
if((state_val_19525 === (12))){
var inst_19510 = (state_19524[(8)]);
var inst_19510__$1 = (state_19524[(2)]);
var inst_19511 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_19510__$1);
var state_19524__$1 = (function (){var statearr_19533 = state_19524;
(statearr_19533[(8)] = inst_19510__$1);

return statearr_19533;
})();
if(cljs.core.truth_(inst_19511)){
var statearr_19534_19566 = state_19524__$1;
(statearr_19534_19566[(1)] = (13));

} else {
var statearr_19535_19567 = state_19524__$1;
(statearr_19535_19567[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19525 === (2))){
var inst_19487 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_19488 = (0);
var state_19524__$1 = (function (){var statearr_19536 = state_19524;
(statearr_19536[(7)] = inst_19488);

(statearr_19536[(9)] = inst_19487);

return statearr_19536;
})();
var statearr_19537_19568 = state_19524__$1;
(statearr_19537_19568[(2)] = null);

(statearr_19537_19568[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19525 === (11))){
var inst_19488 = (state_19524[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_19524,(10),Object,null,(9));
var inst_19497 = chs__$1.call(null,inst_19488);
var inst_19498 = done.call(null,inst_19488);
var inst_19499 = cljs.core.async.take_BANG_.call(null,inst_19497,inst_19498);
var state_19524__$1 = state_19524;
var statearr_19538_19569 = state_19524__$1;
(statearr_19538_19569[(2)] = inst_19499);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19524__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19525 === (9))){
var inst_19488 = (state_19524[(7)]);
var inst_19501 = (state_19524[(2)]);
var inst_19502 = (inst_19488 + (1));
var inst_19488__$1 = inst_19502;
var state_19524__$1 = (function (){var statearr_19539 = state_19524;
(statearr_19539[(10)] = inst_19501);

(statearr_19539[(7)] = inst_19488__$1);

return statearr_19539;
})();
var statearr_19540_19570 = state_19524__$1;
(statearr_19540_19570[(2)] = null);

(statearr_19540_19570[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19525 === (5))){
var inst_19508 = (state_19524[(2)]);
var state_19524__$1 = (function (){var statearr_19541 = state_19524;
(statearr_19541[(11)] = inst_19508);

return statearr_19541;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19524__$1,(12),dchan);
} else {
if((state_val_19525 === (14))){
var inst_19510 = (state_19524[(8)]);
var inst_19515 = cljs.core.apply.call(null,f,inst_19510);
var state_19524__$1 = state_19524;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19524__$1,(16),out,inst_19515);
} else {
if((state_val_19525 === (16))){
var inst_19517 = (state_19524[(2)]);
var state_19524__$1 = (function (){var statearr_19542 = state_19524;
(statearr_19542[(12)] = inst_19517);

return statearr_19542;
})();
var statearr_19543_19571 = state_19524__$1;
(statearr_19543_19571[(2)] = null);

(statearr_19543_19571[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19525 === (10))){
var inst_19492 = (state_19524[(2)]);
var inst_19493 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_19524__$1 = (function (){var statearr_19544 = state_19524;
(statearr_19544[(13)] = inst_19492);

return statearr_19544;
})();
var statearr_19545_19572 = state_19524__$1;
(statearr_19545_19572[(2)] = inst_19493);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19524__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19525 === (8))){
var inst_19506 = (state_19524[(2)]);
var state_19524__$1 = state_19524;
var statearr_19546_19573 = state_19524__$1;
(statearr_19546_19573[(2)] = inst_19506);

(statearr_19546_19573[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__9230__auto___19558,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__9165__auto__,c__9230__auto___19558,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__9166__auto__ = null;
var cljs$core$async$state_machine__9166__auto____0 = (function (){
var statearr_19550 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19550[(0)] = cljs$core$async$state_machine__9166__auto__);

(statearr_19550[(1)] = (1));

return statearr_19550;
});
var cljs$core$async$state_machine__9166__auto____1 = (function (state_19524){
while(true){
var ret_value__9167__auto__ = (function (){try{while(true){
var result__9168__auto__ = switch__9165__auto__.call(null,state_19524);
if(cljs.core.keyword_identical_QMARK_.call(null,result__9168__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__9168__auto__;
}
break;
}
}catch (e19551){if((e19551 instanceof Object)){
var ex__9169__auto__ = e19551;
var statearr_19552_19574 = state_19524;
(statearr_19552_19574[(5)] = ex__9169__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19524);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19551;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__9167__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19575 = state_19524;
state_19524 = G__19575;
continue;
} else {
return ret_value__9167__auto__;
}
break;
}
});
cljs$core$async$state_machine__9166__auto__ = function(state_19524){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__9166__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__9166__auto____1.call(this,state_19524);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__9166__auto____0;
cljs$core$async$state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__9166__auto____1;
return cljs$core$async$state_machine__9166__auto__;
})()
;})(switch__9165__auto__,c__9230__auto___19558,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__9232__auto__ = (function (){var statearr_19553 = f__9231__auto__.call(null);
(statearr_19553[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__9230__auto___19558);

return statearr_19553;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__9232__auto__);
});})(c__9230__auto___19558,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;
/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args19577 = [];
var len__5627__auto___19633 = arguments.length;
var i__5628__auto___19634 = (0);
while(true){
if((i__5628__auto___19634 < len__5627__auto___19633)){
args19577.push((arguments[i__5628__auto___19634]));

var G__19635 = (i__5628__auto___19634 + (1));
i__5628__auto___19634 = G__19635;
continue;
} else {
}
break;
}

var G__19579 = args19577.length;
switch (G__19579) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19577.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__9230__auto___19637 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__9230__auto___19637,out){
return (function (){
var f__9231__auto__ = (function (){var switch__9165__auto__ = ((function (c__9230__auto___19637,out){
return (function (state_19609){
var state_val_19610 = (state_19609[(1)]);
if((state_val_19610 === (7))){
var inst_19589 = (state_19609[(7)]);
var inst_19588 = (state_19609[(8)]);
var inst_19588__$1 = (state_19609[(2)]);
var inst_19589__$1 = cljs.core.nth.call(null,inst_19588__$1,(0),null);
var inst_19590 = cljs.core.nth.call(null,inst_19588__$1,(1),null);
var inst_19591 = (inst_19589__$1 == null);
var state_19609__$1 = (function (){var statearr_19611 = state_19609;
(statearr_19611[(9)] = inst_19590);

(statearr_19611[(7)] = inst_19589__$1);

(statearr_19611[(8)] = inst_19588__$1);

return statearr_19611;
})();
if(cljs.core.truth_(inst_19591)){
var statearr_19612_19638 = state_19609__$1;
(statearr_19612_19638[(1)] = (8));

} else {
var statearr_19613_19639 = state_19609__$1;
(statearr_19613_19639[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19610 === (1))){
var inst_19580 = cljs.core.vec.call(null,chs);
var inst_19581 = inst_19580;
var state_19609__$1 = (function (){var statearr_19614 = state_19609;
(statearr_19614[(10)] = inst_19581);

return statearr_19614;
})();
var statearr_19615_19640 = state_19609__$1;
(statearr_19615_19640[(2)] = null);

(statearr_19615_19640[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19610 === (4))){
var inst_19581 = (state_19609[(10)]);
var state_19609__$1 = state_19609;
return cljs.core.async.ioc_alts_BANG_.call(null,state_19609__$1,(7),inst_19581);
} else {
if((state_val_19610 === (6))){
var inst_19605 = (state_19609[(2)]);
var state_19609__$1 = state_19609;
var statearr_19616_19641 = state_19609__$1;
(statearr_19616_19641[(2)] = inst_19605);

(statearr_19616_19641[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19610 === (3))){
var inst_19607 = (state_19609[(2)]);
var state_19609__$1 = state_19609;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19609__$1,inst_19607);
} else {
if((state_val_19610 === (2))){
var inst_19581 = (state_19609[(10)]);
var inst_19583 = cljs.core.count.call(null,inst_19581);
var inst_19584 = (inst_19583 > (0));
var state_19609__$1 = state_19609;
if(cljs.core.truth_(inst_19584)){
var statearr_19618_19642 = state_19609__$1;
(statearr_19618_19642[(1)] = (4));

} else {
var statearr_19619_19643 = state_19609__$1;
(statearr_19619_19643[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19610 === (11))){
var inst_19581 = (state_19609[(10)]);
var inst_19598 = (state_19609[(2)]);
var tmp19617 = inst_19581;
var inst_19581__$1 = tmp19617;
var state_19609__$1 = (function (){var statearr_19620 = state_19609;
(statearr_19620[(10)] = inst_19581__$1);

(statearr_19620[(11)] = inst_19598);

return statearr_19620;
})();
var statearr_19621_19644 = state_19609__$1;
(statearr_19621_19644[(2)] = null);

(statearr_19621_19644[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19610 === (9))){
var inst_19589 = (state_19609[(7)]);
var state_19609__$1 = state_19609;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19609__$1,(11),out,inst_19589);
} else {
if((state_val_19610 === (5))){
var inst_19603 = cljs.core.async.close_BANG_.call(null,out);
var state_19609__$1 = state_19609;
var statearr_19622_19645 = state_19609__$1;
(statearr_19622_19645[(2)] = inst_19603);

(statearr_19622_19645[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19610 === (10))){
var inst_19601 = (state_19609[(2)]);
var state_19609__$1 = state_19609;
var statearr_19623_19646 = state_19609__$1;
(statearr_19623_19646[(2)] = inst_19601);

(statearr_19623_19646[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19610 === (8))){
var inst_19590 = (state_19609[(9)]);
var inst_19581 = (state_19609[(10)]);
var inst_19589 = (state_19609[(7)]);
var inst_19588 = (state_19609[(8)]);
var inst_19593 = (function (){var cs = inst_19581;
var vec__19586 = inst_19588;
var v = inst_19589;
var c = inst_19590;
return ((function (cs,vec__19586,v,c,inst_19590,inst_19581,inst_19589,inst_19588,state_val_19610,c__9230__auto___19637,out){
return (function (p1__19576_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__19576_SHARP_);
});
;})(cs,vec__19586,v,c,inst_19590,inst_19581,inst_19589,inst_19588,state_val_19610,c__9230__auto___19637,out))
})();
var inst_19594 = cljs.core.filterv.call(null,inst_19593,inst_19581);
var inst_19581__$1 = inst_19594;
var state_19609__$1 = (function (){var statearr_19624 = state_19609;
(statearr_19624[(10)] = inst_19581__$1);

return statearr_19624;
})();
var statearr_19625_19647 = state_19609__$1;
(statearr_19625_19647[(2)] = null);

(statearr_19625_19647[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__9230__auto___19637,out))
;
return ((function (switch__9165__auto__,c__9230__auto___19637,out){
return (function() {
var cljs$core$async$state_machine__9166__auto__ = null;
var cljs$core$async$state_machine__9166__auto____0 = (function (){
var statearr_19629 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19629[(0)] = cljs$core$async$state_machine__9166__auto__);

(statearr_19629[(1)] = (1));

return statearr_19629;
});
var cljs$core$async$state_machine__9166__auto____1 = (function (state_19609){
while(true){
var ret_value__9167__auto__ = (function (){try{while(true){
var result__9168__auto__ = switch__9165__auto__.call(null,state_19609);
if(cljs.core.keyword_identical_QMARK_.call(null,result__9168__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__9168__auto__;
}
break;
}
}catch (e19630){if((e19630 instanceof Object)){
var ex__9169__auto__ = e19630;
var statearr_19631_19648 = state_19609;
(statearr_19631_19648[(5)] = ex__9169__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19609);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19630;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__9167__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19649 = state_19609;
state_19609 = G__19649;
continue;
} else {
return ret_value__9167__auto__;
}
break;
}
});
cljs$core$async$state_machine__9166__auto__ = function(state_19609){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__9166__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__9166__auto____1.call(this,state_19609);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__9166__auto____0;
cljs$core$async$state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__9166__auto____1;
return cljs$core$async$state_machine__9166__auto__;
})()
;})(switch__9165__auto__,c__9230__auto___19637,out))
})();
var state__9232__auto__ = (function (){var statearr_19632 = f__9231__auto__.call(null);
(statearr_19632[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__9230__auto___19637);

return statearr_19632;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__9232__auto__);
});})(c__9230__auto___19637,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args19650 = [];
var len__5627__auto___19699 = arguments.length;
var i__5628__auto___19700 = (0);
while(true){
if((i__5628__auto___19700 < len__5627__auto___19699)){
args19650.push((arguments[i__5628__auto___19700]));

var G__19701 = (i__5628__auto___19700 + (1));
i__5628__auto___19700 = G__19701;
continue;
} else {
}
break;
}

var G__19652 = args19650.length;
switch (G__19652) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19650.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__9230__auto___19703 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__9230__auto___19703,out){
return (function (){
var f__9231__auto__ = (function (){var switch__9165__auto__ = ((function (c__9230__auto___19703,out){
return (function (state_19676){
var state_val_19677 = (state_19676[(1)]);
if((state_val_19677 === (7))){
var inst_19658 = (state_19676[(7)]);
var inst_19658__$1 = (state_19676[(2)]);
var inst_19659 = (inst_19658__$1 == null);
var inst_19660 = cljs.core.not.call(null,inst_19659);
var state_19676__$1 = (function (){var statearr_19678 = state_19676;
(statearr_19678[(7)] = inst_19658__$1);

return statearr_19678;
})();
if(inst_19660){
var statearr_19679_19704 = state_19676__$1;
(statearr_19679_19704[(1)] = (8));

} else {
var statearr_19680_19705 = state_19676__$1;
(statearr_19680_19705[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19677 === (1))){
var inst_19653 = (0);
var state_19676__$1 = (function (){var statearr_19681 = state_19676;
(statearr_19681[(8)] = inst_19653);

return statearr_19681;
})();
var statearr_19682_19706 = state_19676__$1;
(statearr_19682_19706[(2)] = null);

(statearr_19682_19706[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19677 === (4))){
var state_19676__$1 = state_19676;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19676__$1,(7),ch);
} else {
if((state_val_19677 === (6))){
var inst_19671 = (state_19676[(2)]);
var state_19676__$1 = state_19676;
var statearr_19683_19707 = state_19676__$1;
(statearr_19683_19707[(2)] = inst_19671);

(statearr_19683_19707[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19677 === (3))){
var inst_19673 = (state_19676[(2)]);
var inst_19674 = cljs.core.async.close_BANG_.call(null,out);
var state_19676__$1 = (function (){var statearr_19684 = state_19676;
(statearr_19684[(9)] = inst_19673);

return statearr_19684;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19676__$1,inst_19674);
} else {
if((state_val_19677 === (2))){
var inst_19653 = (state_19676[(8)]);
var inst_19655 = (inst_19653 < n);
var state_19676__$1 = state_19676;
if(cljs.core.truth_(inst_19655)){
var statearr_19685_19708 = state_19676__$1;
(statearr_19685_19708[(1)] = (4));

} else {
var statearr_19686_19709 = state_19676__$1;
(statearr_19686_19709[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19677 === (11))){
var inst_19653 = (state_19676[(8)]);
var inst_19663 = (state_19676[(2)]);
var inst_19664 = (inst_19653 + (1));
var inst_19653__$1 = inst_19664;
var state_19676__$1 = (function (){var statearr_19687 = state_19676;
(statearr_19687[(8)] = inst_19653__$1);

(statearr_19687[(10)] = inst_19663);

return statearr_19687;
})();
var statearr_19688_19710 = state_19676__$1;
(statearr_19688_19710[(2)] = null);

(statearr_19688_19710[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19677 === (9))){
var state_19676__$1 = state_19676;
var statearr_19689_19711 = state_19676__$1;
(statearr_19689_19711[(2)] = null);

(statearr_19689_19711[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19677 === (5))){
var state_19676__$1 = state_19676;
var statearr_19690_19712 = state_19676__$1;
(statearr_19690_19712[(2)] = null);

(statearr_19690_19712[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19677 === (10))){
var inst_19668 = (state_19676[(2)]);
var state_19676__$1 = state_19676;
var statearr_19691_19713 = state_19676__$1;
(statearr_19691_19713[(2)] = inst_19668);

(statearr_19691_19713[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19677 === (8))){
var inst_19658 = (state_19676[(7)]);
var state_19676__$1 = state_19676;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19676__$1,(11),out,inst_19658);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__9230__auto___19703,out))
;
return ((function (switch__9165__auto__,c__9230__auto___19703,out){
return (function() {
var cljs$core$async$state_machine__9166__auto__ = null;
var cljs$core$async$state_machine__9166__auto____0 = (function (){
var statearr_19695 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_19695[(0)] = cljs$core$async$state_machine__9166__auto__);

(statearr_19695[(1)] = (1));

return statearr_19695;
});
var cljs$core$async$state_machine__9166__auto____1 = (function (state_19676){
while(true){
var ret_value__9167__auto__ = (function (){try{while(true){
var result__9168__auto__ = switch__9165__auto__.call(null,state_19676);
if(cljs.core.keyword_identical_QMARK_.call(null,result__9168__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__9168__auto__;
}
break;
}
}catch (e19696){if((e19696 instanceof Object)){
var ex__9169__auto__ = e19696;
var statearr_19697_19714 = state_19676;
(statearr_19697_19714[(5)] = ex__9169__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19676);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19696;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__9167__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19715 = state_19676;
state_19676 = G__19715;
continue;
} else {
return ret_value__9167__auto__;
}
break;
}
});
cljs$core$async$state_machine__9166__auto__ = function(state_19676){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__9166__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__9166__auto____1.call(this,state_19676);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__9166__auto____0;
cljs$core$async$state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__9166__auto____1;
return cljs$core$async$state_machine__9166__auto__;
})()
;})(switch__9165__auto__,c__9230__auto___19703,out))
})();
var state__9232__auto__ = (function (){var statearr_19698 = f__9231__auto__.call(null);
(statearr_19698[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__9230__auto___19703);

return statearr_19698;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__9232__auto__);
});})(c__9230__auto___19703,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async19723 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19723 = (function (map_LT_,f,ch,meta19724){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta19724 = meta19724;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async19723.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_19725,meta19724__$1){
var self__ = this;
var _19725__$1 = this;
return (new cljs.core.async.t_cljs$core$async19723(self__.map_LT_,self__.f,self__.ch,meta19724__$1));
});

cljs.core.async.t_cljs$core$async19723.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_19725){
var self__ = this;
var _19725__$1 = this;
return self__.meta19724;
});

cljs.core.async.t_cljs$core$async19723.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async19723.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async19723.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async19723.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async19723.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async19726 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19726 = (function (map_LT_,f,ch,meta19724,_,fn1,meta19727){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta19724 = meta19724;
this._ = _;
this.fn1 = fn1;
this.meta19727 = meta19727;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async19726.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_19728,meta19727__$1){
var self__ = this;
var _19728__$1 = this;
return (new cljs.core.async.t_cljs$core$async19726(self__.map_LT_,self__.f,self__.ch,self__.meta19724,self__._,self__.fn1,meta19727__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async19726.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_19728){
var self__ = this;
var _19728__$1 = this;
return self__.meta19727;
});})(___$1))
;

cljs.core.async.t_cljs$core$async19726.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async19726.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async19726.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__19716_SHARP_){
return f1.call(null,(((p1__19716_SHARP_ == null))?null:self__.f.call(null,p1__19716_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async19726.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta19724","meta19724",-2083315182,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async19723","cljs.core.async/t_cljs$core$async19723",292872849,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta19727","meta19727",-1553488837,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async19726.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19726.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19726";

cljs.core.async.t_cljs$core$async19726.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write.call(null,writer__5168__auto__,"cljs.core.async/t_cljs$core$async19726");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async19726 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async19726(map_LT___$1,f__$1,ch__$1,meta19724__$1,___$2,fn1__$1,meta19727){
return (new cljs.core.async.t_cljs$core$async19726(map_LT___$1,f__$1,ch__$1,meta19724__$1,___$2,fn1__$1,meta19727));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async19726(self__.map_LT_,self__.f,self__.ch,self__.meta19724,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4557__auto__ = ret;
if(cljs.core.truth_(and__4557__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__4557__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async19723.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async19723.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async19723.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta19724","meta19724",-2083315182,null)], null);
});

cljs.core.async.t_cljs$core$async19723.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19723.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19723";

cljs.core.async.t_cljs$core$async19723.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write.call(null,writer__5168__auto__,"cljs.core.async/t_cljs$core$async19723");
});

cljs.core.async.__GT_t_cljs$core$async19723 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async19723(map_LT___$1,f__$1,ch__$1,meta19724){
return (new cljs.core.async.t_cljs$core$async19723(map_LT___$1,f__$1,ch__$1,meta19724));
});

}

return (new cljs.core.async.t_cljs$core$async19723(cljs$core$async$map_LT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async19732 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19732 = (function (map_GT_,f,ch,meta19733){
this.map_GT_ = map_GT_;
this.f = f;
this.ch = ch;
this.meta19733 = meta19733;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async19732.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_19734,meta19733__$1){
var self__ = this;
var _19734__$1 = this;
return (new cljs.core.async.t_cljs$core$async19732(self__.map_GT_,self__.f,self__.ch,meta19733__$1));
});

cljs.core.async.t_cljs$core$async19732.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_19734){
var self__ = this;
var _19734__$1 = this;
return self__.meta19733;
});

cljs.core.async.t_cljs$core$async19732.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async19732.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async19732.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async19732.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async19732.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async19732.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async19732.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map>","map>",1676369295,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta19733","meta19733",-435811580,null)], null);
});

cljs.core.async.t_cljs$core$async19732.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19732.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19732";

cljs.core.async.t_cljs$core$async19732.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write.call(null,writer__5168__auto__,"cljs.core.async/t_cljs$core$async19732");
});

cljs.core.async.__GT_t_cljs$core$async19732 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async19732(map_GT___$1,f__$1,ch__$1,meta19733){
return (new cljs.core.async.t_cljs$core$async19732(map_GT___$1,f__$1,ch__$1,meta19733));
});

}

return (new cljs.core.async.t_cljs$core$async19732(cljs$core$async$map_GT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async19738 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19738 = (function (filter_GT_,p,ch,meta19739){
this.filter_GT_ = filter_GT_;
this.p = p;
this.ch = ch;
this.meta19739 = meta19739;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async19738.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_19740,meta19739__$1){
var self__ = this;
var _19740__$1 = this;
return (new cljs.core.async.t_cljs$core$async19738(self__.filter_GT_,self__.p,self__.ch,meta19739__$1));
});

cljs.core.async.t_cljs$core$async19738.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_19740){
var self__ = this;
var _19740__$1 = this;
return self__.meta19739;
});

cljs.core.async.t_cljs$core$async19738.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async19738.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async19738.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async19738.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async19738.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async19738.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async19738.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async19738.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"filter>","filter>",-37644455,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta19739","meta19739",1586411003,null)], null);
});

cljs.core.async.t_cljs$core$async19738.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19738.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19738";

cljs.core.async.t_cljs$core$async19738.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write.call(null,writer__5168__auto__,"cljs.core.async/t_cljs$core$async19738");
});

cljs.core.async.__GT_t_cljs$core$async19738 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async19738(filter_GT___$1,p__$1,ch__$1,meta19739){
return (new cljs.core.async.t_cljs$core$async19738(filter_GT___$1,p__$1,ch__$1,meta19739));
});

}

return (new cljs.core.async.t_cljs$core$async19738(cljs$core$async$filter_GT_,p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args19741 = [];
var len__5627__auto___19785 = arguments.length;
var i__5628__auto___19786 = (0);
while(true){
if((i__5628__auto___19786 < len__5627__auto___19785)){
args19741.push((arguments[i__5628__auto___19786]));

var G__19787 = (i__5628__auto___19786 + (1));
i__5628__auto___19786 = G__19787;
continue;
} else {
}
break;
}

var G__19743 = args19741.length;
switch (G__19743) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19741.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__9230__auto___19789 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__9230__auto___19789,out){
return (function (){
var f__9231__auto__ = (function (){var switch__9165__auto__ = ((function (c__9230__auto___19789,out){
return (function (state_19764){
var state_val_19765 = (state_19764[(1)]);
if((state_val_19765 === (7))){
var inst_19760 = (state_19764[(2)]);
var state_19764__$1 = state_19764;
var statearr_19766_19790 = state_19764__$1;
(statearr_19766_19790[(2)] = inst_19760);

(statearr_19766_19790[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19765 === (1))){
var state_19764__$1 = state_19764;
var statearr_19767_19791 = state_19764__$1;
(statearr_19767_19791[(2)] = null);

(statearr_19767_19791[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19765 === (4))){
var inst_19746 = (state_19764[(7)]);
var inst_19746__$1 = (state_19764[(2)]);
var inst_19747 = (inst_19746__$1 == null);
var state_19764__$1 = (function (){var statearr_19768 = state_19764;
(statearr_19768[(7)] = inst_19746__$1);

return statearr_19768;
})();
if(cljs.core.truth_(inst_19747)){
var statearr_19769_19792 = state_19764__$1;
(statearr_19769_19792[(1)] = (5));

} else {
var statearr_19770_19793 = state_19764__$1;
(statearr_19770_19793[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19765 === (6))){
var inst_19746 = (state_19764[(7)]);
var inst_19751 = p.call(null,inst_19746);
var state_19764__$1 = state_19764;
if(cljs.core.truth_(inst_19751)){
var statearr_19771_19794 = state_19764__$1;
(statearr_19771_19794[(1)] = (8));

} else {
var statearr_19772_19795 = state_19764__$1;
(statearr_19772_19795[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19765 === (3))){
var inst_19762 = (state_19764[(2)]);
var state_19764__$1 = state_19764;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19764__$1,inst_19762);
} else {
if((state_val_19765 === (2))){
var state_19764__$1 = state_19764;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19764__$1,(4),ch);
} else {
if((state_val_19765 === (11))){
var inst_19754 = (state_19764[(2)]);
var state_19764__$1 = state_19764;
var statearr_19773_19796 = state_19764__$1;
(statearr_19773_19796[(2)] = inst_19754);

(statearr_19773_19796[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19765 === (9))){
var state_19764__$1 = state_19764;
var statearr_19774_19797 = state_19764__$1;
(statearr_19774_19797[(2)] = null);

(statearr_19774_19797[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19765 === (5))){
var inst_19749 = cljs.core.async.close_BANG_.call(null,out);
var state_19764__$1 = state_19764;
var statearr_19775_19798 = state_19764__$1;
(statearr_19775_19798[(2)] = inst_19749);

(statearr_19775_19798[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19765 === (10))){
var inst_19757 = (state_19764[(2)]);
var state_19764__$1 = (function (){var statearr_19776 = state_19764;
(statearr_19776[(8)] = inst_19757);

return statearr_19776;
})();
var statearr_19777_19799 = state_19764__$1;
(statearr_19777_19799[(2)] = null);

(statearr_19777_19799[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19765 === (8))){
var inst_19746 = (state_19764[(7)]);
var state_19764__$1 = state_19764;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19764__$1,(11),out,inst_19746);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__9230__auto___19789,out))
;
return ((function (switch__9165__auto__,c__9230__auto___19789,out){
return (function() {
var cljs$core$async$state_machine__9166__auto__ = null;
var cljs$core$async$state_machine__9166__auto____0 = (function (){
var statearr_19781 = [null,null,null,null,null,null,null,null,null];
(statearr_19781[(0)] = cljs$core$async$state_machine__9166__auto__);

(statearr_19781[(1)] = (1));

return statearr_19781;
});
var cljs$core$async$state_machine__9166__auto____1 = (function (state_19764){
while(true){
var ret_value__9167__auto__ = (function (){try{while(true){
var result__9168__auto__ = switch__9165__auto__.call(null,state_19764);
if(cljs.core.keyword_identical_QMARK_.call(null,result__9168__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__9168__auto__;
}
break;
}
}catch (e19782){if((e19782 instanceof Object)){
var ex__9169__auto__ = e19782;
var statearr_19783_19800 = state_19764;
(statearr_19783_19800[(5)] = ex__9169__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19764);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19782;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__9167__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19801 = state_19764;
state_19764 = G__19801;
continue;
} else {
return ret_value__9167__auto__;
}
break;
}
});
cljs$core$async$state_machine__9166__auto__ = function(state_19764){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__9166__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__9166__auto____1.call(this,state_19764);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__9166__auto____0;
cljs$core$async$state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__9166__auto____1;
return cljs$core$async$state_machine__9166__auto__;
})()
;})(switch__9165__auto__,c__9230__auto___19789,out))
})();
var state__9232__auto__ = (function (){var statearr_19784 = f__9231__auto__.call(null);
(statearr_19784[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__9230__auto___19789);

return statearr_19784;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__9232__auto__);
});})(c__9230__auto___19789,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args19802 = [];
var len__5627__auto___19805 = arguments.length;
var i__5628__auto___19806 = (0);
while(true){
if((i__5628__auto___19806 < len__5627__auto___19805)){
args19802.push((arguments[i__5628__auto___19806]));

var G__19807 = (i__5628__auto___19806 + (1));
i__5628__auto___19806 = G__19807;
continue;
} else {
}
break;
}

var G__19804 = args19802.length;
switch (G__19804) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19802.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;
cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__9230__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__9230__auto__){
return (function (){
var f__9231__auto__ = (function (){var switch__9165__auto__ = ((function (c__9230__auto__){
return (function (state_19974){
var state_val_19975 = (state_19974[(1)]);
if((state_val_19975 === (7))){
var inst_19970 = (state_19974[(2)]);
var state_19974__$1 = state_19974;
var statearr_19976_20017 = state_19974__$1;
(statearr_19976_20017[(2)] = inst_19970);

(statearr_19976_20017[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19975 === (20))){
var inst_19940 = (state_19974[(7)]);
var inst_19951 = (state_19974[(2)]);
var inst_19952 = cljs.core.next.call(null,inst_19940);
var inst_19926 = inst_19952;
var inst_19927 = null;
var inst_19928 = (0);
var inst_19929 = (0);
var state_19974__$1 = (function (){var statearr_19977 = state_19974;
(statearr_19977[(8)] = inst_19927);

(statearr_19977[(9)] = inst_19926);

(statearr_19977[(10)] = inst_19929);

(statearr_19977[(11)] = inst_19928);

(statearr_19977[(12)] = inst_19951);

return statearr_19977;
})();
var statearr_19978_20018 = state_19974__$1;
(statearr_19978_20018[(2)] = null);

(statearr_19978_20018[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19975 === (1))){
var state_19974__$1 = state_19974;
var statearr_19979_20019 = state_19974__$1;
(statearr_19979_20019[(2)] = null);

(statearr_19979_20019[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19975 === (4))){
var inst_19915 = (state_19974[(13)]);
var inst_19915__$1 = (state_19974[(2)]);
var inst_19916 = (inst_19915__$1 == null);
var state_19974__$1 = (function (){var statearr_19980 = state_19974;
(statearr_19980[(13)] = inst_19915__$1);

return statearr_19980;
})();
if(cljs.core.truth_(inst_19916)){
var statearr_19981_20020 = state_19974__$1;
(statearr_19981_20020[(1)] = (5));

} else {
var statearr_19982_20021 = state_19974__$1;
(statearr_19982_20021[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19975 === (15))){
var state_19974__$1 = state_19974;
var statearr_19986_20022 = state_19974__$1;
(statearr_19986_20022[(2)] = null);

(statearr_19986_20022[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19975 === (21))){
var state_19974__$1 = state_19974;
var statearr_19987_20023 = state_19974__$1;
(statearr_19987_20023[(2)] = null);

(statearr_19987_20023[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19975 === (13))){
var inst_19927 = (state_19974[(8)]);
var inst_19926 = (state_19974[(9)]);
var inst_19929 = (state_19974[(10)]);
var inst_19928 = (state_19974[(11)]);
var inst_19936 = (state_19974[(2)]);
var inst_19937 = (inst_19929 + (1));
var tmp19983 = inst_19927;
var tmp19984 = inst_19926;
var tmp19985 = inst_19928;
var inst_19926__$1 = tmp19984;
var inst_19927__$1 = tmp19983;
var inst_19928__$1 = tmp19985;
var inst_19929__$1 = inst_19937;
var state_19974__$1 = (function (){var statearr_19988 = state_19974;
(statearr_19988[(14)] = inst_19936);

(statearr_19988[(8)] = inst_19927__$1);

(statearr_19988[(9)] = inst_19926__$1);

(statearr_19988[(10)] = inst_19929__$1);

(statearr_19988[(11)] = inst_19928__$1);

return statearr_19988;
})();
var statearr_19989_20024 = state_19974__$1;
(statearr_19989_20024[(2)] = null);

(statearr_19989_20024[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19975 === (22))){
var state_19974__$1 = state_19974;
var statearr_19990_20025 = state_19974__$1;
(statearr_19990_20025[(2)] = null);

(statearr_19990_20025[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19975 === (6))){
var inst_19915 = (state_19974[(13)]);
var inst_19924 = f.call(null,inst_19915);
var inst_19925 = cljs.core.seq.call(null,inst_19924);
var inst_19926 = inst_19925;
var inst_19927 = null;
var inst_19928 = (0);
var inst_19929 = (0);
var state_19974__$1 = (function (){var statearr_19991 = state_19974;
(statearr_19991[(8)] = inst_19927);

(statearr_19991[(9)] = inst_19926);

(statearr_19991[(10)] = inst_19929);

(statearr_19991[(11)] = inst_19928);

return statearr_19991;
})();
var statearr_19992_20026 = state_19974__$1;
(statearr_19992_20026[(2)] = null);

(statearr_19992_20026[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19975 === (17))){
var inst_19940 = (state_19974[(7)]);
var inst_19944 = cljs.core.chunk_first.call(null,inst_19940);
var inst_19945 = cljs.core.chunk_rest.call(null,inst_19940);
var inst_19946 = cljs.core.count.call(null,inst_19944);
var inst_19926 = inst_19945;
var inst_19927 = inst_19944;
var inst_19928 = inst_19946;
var inst_19929 = (0);
var state_19974__$1 = (function (){var statearr_19993 = state_19974;
(statearr_19993[(8)] = inst_19927);

(statearr_19993[(9)] = inst_19926);

(statearr_19993[(10)] = inst_19929);

(statearr_19993[(11)] = inst_19928);

return statearr_19993;
})();
var statearr_19994_20027 = state_19974__$1;
(statearr_19994_20027[(2)] = null);

(statearr_19994_20027[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19975 === (3))){
var inst_19972 = (state_19974[(2)]);
var state_19974__$1 = state_19974;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19974__$1,inst_19972);
} else {
if((state_val_19975 === (12))){
var inst_19960 = (state_19974[(2)]);
var state_19974__$1 = state_19974;
var statearr_19995_20028 = state_19974__$1;
(statearr_19995_20028[(2)] = inst_19960);

(statearr_19995_20028[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19975 === (2))){
var state_19974__$1 = state_19974;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19974__$1,(4),in$);
} else {
if((state_val_19975 === (23))){
var inst_19968 = (state_19974[(2)]);
var state_19974__$1 = state_19974;
var statearr_19996_20029 = state_19974__$1;
(statearr_19996_20029[(2)] = inst_19968);

(statearr_19996_20029[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19975 === (19))){
var inst_19955 = (state_19974[(2)]);
var state_19974__$1 = state_19974;
var statearr_19997_20030 = state_19974__$1;
(statearr_19997_20030[(2)] = inst_19955);

(statearr_19997_20030[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19975 === (11))){
var inst_19940 = (state_19974[(7)]);
var inst_19926 = (state_19974[(9)]);
var inst_19940__$1 = cljs.core.seq.call(null,inst_19926);
var state_19974__$1 = (function (){var statearr_19998 = state_19974;
(statearr_19998[(7)] = inst_19940__$1);

return statearr_19998;
})();
if(inst_19940__$1){
var statearr_19999_20031 = state_19974__$1;
(statearr_19999_20031[(1)] = (14));

} else {
var statearr_20000_20032 = state_19974__$1;
(statearr_20000_20032[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19975 === (9))){
var inst_19962 = (state_19974[(2)]);
var inst_19963 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_19974__$1 = (function (){var statearr_20001 = state_19974;
(statearr_20001[(15)] = inst_19962);

return statearr_20001;
})();
if(cljs.core.truth_(inst_19963)){
var statearr_20002_20033 = state_19974__$1;
(statearr_20002_20033[(1)] = (21));

} else {
var statearr_20003_20034 = state_19974__$1;
(statearr_20003_20034[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19975 === (5))){
var inst_19918 = cljs.core.async.close_BANG_.call(null,out);
var state_19974__$1 = state_19974;
var statearr_20004_20035 = state_19974__$1;
(statearr_20004_20035[(2)] = inst_19918);

(statearr_20004_20035[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19975 === (14))){
var inst_19940 = (state_19974[(7)]);
var inst_19942 = cljs.core.chunked_seq_QMARK_.call(null,inst_19940);
var state_19974__$1 = state_19974;
if(inst_19942){
var statearr_20005_20036 = state_19974__$1;
(statearr_20005_20036[(1)] = (17));

} else {
var statearr_20006_20037 = state_19974__$1;
(statearr_20006_20037[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19975 === (16))){
var inst_19958 = (state_19974[(2)]);
var state_19974__$1 = state_19974;
var statearr_20007_20038 = state_19974__$1;
(statearr_20007_20038[(2)] = inst_19958);

(statearr_20007_20038[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19975 === (10))){
var inst_19927 = (state_19974[(8)]);
var inst_19929 = (state_19974[(10)]);
var inst_19934 = cljs.core._nth.call(null,inst_19927,inst_19929);
var state_19974__$1 = state_19974;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19974__$1,(13),out,inst_19934);
} else {
if((state_val_19975 === (18))){
var inst_19940 = (state_19974[(7)]);
var inst_19949 = cljs.core.first.call(null,inst_19940);
var state_19974__$1 = state_19974;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19974__$1,(20),out,inst_19949);
} else {
if((state_val_19975 === (8))){
var inst_19929 = (state_19974[(10)]);
var inst_19928 = (state_19974[(11)]);
var inst_19931 = (inst_19929 < inst_19928);
var inst_19932 = inst_19931;
var state_19974__$1 = state_19974;
if(cljs.core.truth_(inst_19932)){
var statearr_20008_20039 = state_19974__$1;
(statearr_20008_20039[(1)] = (10));

} else {
var statearr_20009_20040 = state_19974__$1;
(statearr_20009_20040[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__9230__auto__))
;
return ((function (switch__9165__auto__,c__9230__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__9166__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__9166__auto____0 = (function (){
var statearr_20013 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20013[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__9166__auto__);

(statearr_20013[(1)] = (1));

return statearr_20013;
});
var cljs$core$async$mapcat_STAR__$_state_machine__9166__auto____1 = (function (state_19974){
while(true){
var ret_value__9167__auto__ = (function (){try{while(true){
var result__9168__auto__ = switch__9165__auto__.call(null,state_19974);
if(cljs.core.keyword_identical_QMARK_.call(null,result__9168__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__9168__auto__;
}
break;
}
}catch (e20014){if((e20014 instanceof Object)){
var ex__9169__auto__ = e20014;
var statearr_20015_20041 = state_19974;
(statearr_20015_20041[(5)] = ex__9169__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19974);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20014;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__9167__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20042 = state_19974;
state_19974 = G__20042;
continue;
} else {
return ret_value__9167__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__9166__auto__ = function(state_19974){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__9166__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__9166__auto____1.call(this,state_19974);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__9166__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__9166__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__9166__auto__;
})()
;})(switch__9165__auto__,c__9230__auto__))
})();
var state__9232__auto__ = (function (){var statearr_20016 = f__9231__auto__.call(null);
(statearr_20016[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__9230__auto__);

return statearr_20016;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__9232__auto__);
});})(c__9230__auto__))
);

return c__9230__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args20043 = [];
var len__5627__auto___20046 = arguments.length;
var i__5628__auto___20047 = (0);
while(true){
if((i__5628__auto___20047 < len__5627__auto___20046)){
args20043.push((arguments[i__5628__auto___20047]));

var G__20048 = (i__5628__auto___20047 + (1));
i__5628__auto___20047 = G__20048;
continue;
} else {
}
break;
}

var G__20045 = args20043.length;
switch (G__20045) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20043.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args20050 = [];
var len__5627__auto___20053 = arguments.length;
var i__5628__auto___20054 = (0);
while(true){
if((i__5628__auto___20054 < len__5627__auto___20053)){
args20050.push((arguments[i__5628__auto___20054]));

var G__20055 = (i__5628__auto___20054 + (1));
i__5628__auto___20054 = G__20055;
continue;
} else {
}
break;
}

var G__20052 = args20050.length;
switch (G__20052) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20050.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args20057 = [];
var len__5627__auto___20108 = arguments.length;
var i__5628__auto___20109 = (0);
while(true){
if((i__5628__auto___20109 < len__5627__auto___20108)){
args20057.push((arguments[i__5628__auto___20109]));

var G__20110 = (i__5628__auto___20109 + (1));
i__5628__auto___20109 = G__20110;
continue;
} else {
}
break;
}

var G__20059 = args20057.length;
switch (G__20059) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20057.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__9230__auto___20112 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__9230__auto___20112,out){
return (function (){
var f__9231__auto__ = (function (){var switch__9165__auto__ = ((function (c__9230__auto___20112,out){
return (function (state_20083){
var state_val_20084 = (state_20083[(1)]);
if((state_val_20084 === (7))){
var inst_20078 = (state_20083[(2)]);
var state_20083__$1 = state_20083;
var statearr_20085_20113 = state_20083__$1;
(statearr_20085_20113[(2)] = inst_20078);

(statearr_20085_20113[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20084 === (1))){
var inst_20060 = null;
var state_20083__$1 = (function (){var statearr_20086 = state_20083;
(statearr_20086[(7)] = inst_20060);

return statearr_20086;
})();
var statearr_20087_20114 = state_20083__$1;
(statearr_20087_20114[(2)] = null);

(statearr_20087_20114[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20084 === (4))){
var inst_20063 = (state_20083[(8)]);
var inst_20063__$1 = (state_20083[(2)]);
var inst_20064 = (inst_20063__$1 == null);
var inst_20065 = cljs.core.not.call(null,inst_20064);
var state_20083__$1 = (function (){var statearr_20088 = state_20083;
(statearr_20088[(8)] = inst_20063__$1);

return statearr_20088;
})();
if(inst_20065){
var statearr_20089_20115 = state_20083__$1;
(statearr_20089_20115[(1)] = (5));

} else {
var statearr_20090_20116 = state_20083__$1;
(statearr_20090_20116[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20084 === (6))){
var state_20083__$1 = state_20083;
var statearr_20091_20117 = state_20083__$1;
(statearr_20091_20117[(2)] = null);

(statearr_20091_20117[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20084 === (3))){
var inst_20080 = (state_20083[(2)]);
var inst_20081 = cljs.core.async.close_BANG_.call(null,out);
var state_20083__$1 = (function (){var statearr_20092 = state_20083;
(statearr_20092[(9)] = inst_20080);

return statearr_20092;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20083__$1,inst_20081);
} else {
if((state_val_20084 === (2))){
var state_20083__$1 = state_20083;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20083__$1,(4),ch);
} else {
if((state_val_20084 === (11))){
var inst_20063 = (state_20083[(8)]);
var inst_20072 = (state_20083[(2)]);
var inst_20060 = inst_20063;
var state_20083__$1 = (function (){var statearr_20093 = state_20083;
(statearr_20093[(10)] = inst_20072);

(statearr_20093[(7)] = inst_20060);

return statearr_20093;
})();
var statearr_20094_20118 = state_20083__$1;
(statearr_20094_20118[(2)] = null);

(statearr_20094_20118[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20084 === (9))){
var inst_20063 = (state_20083[(8)]);
var state_20083__$1 = state_20083;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20083__$1,(11),out,inst_20063);
} else {
if((state_val_20084 === (5))){
var inst_20063 = (state_20083[(8)]);
var inst_20060 = (state_20083[(7)]);
var inst_20067 = cljs.core._EQ_.call(null,inst_20063,inst_20060);
var state_20083__$1 = state_20083;
if(inst_20067){
var statearr_20096_20119 = state_20083__$1;
(statearr_20096_20119[(1)] = (8));

} else {
var statearr_20097_20120 = state_20083__$1;
(statearr_20097_20120[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20084 === (10))){
var inst_20075 = (state_20083[(2)]);
var state_20083__$1 = state_20083;
var statearr_20098_20121 = state_20083__$1;
(statearr_20098_20121[(2)] = inst_20075);

(statearr_20098_20121[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20084 === (8))){
var inst_20060 = (state_20083[(7)]);
var tmp20095 = inst_20060;
var inst_20060__$1 = tmp20095;
var state_20083__$1 = (function (){var statearr_20099 = state_20083;
(statearr_20099[(7)] = inst_20060__$1);

return statearr_20099;
})();
var statearr_20100_20122 = state_20083__$1;
(statearr_20100_20122[(2)] = null);

(statearr_20100_20122[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__9230__auto___20112,out))
;
return ((function (switch__9165__auto__,c__9230__auto___20112,out){
return (function() {
var cljs$core$async$state_machine__9166__auto__ = null;
var cljs$core$async$state_machine__9166__auto____0 = (function (){
var statearr_20104 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_20104[(0)] = cljs$core$async$state_machine__9166__auto__);

(statearr_20104[(1)] = (1));

return statearr_20104;
});
var cljs$core$async$state_machine__9166__auto____1 = (function (state_20083){
while(true){
var ret_value__9167__auto__ = (function (){try{while(true){
var result__9168__auto__ = switch__9165__auto__.call(null,state_20083);
if(cljs.core.keyword_identical_QMARK_.call(null,result__9168__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__9168__auto__;
}
break;
}
}catch (e20105){if((e20105 instanceof Object)){
var ex__9169__auto__ = e20105;
var statearr_20106_20123 = state_20083;
(statearr_20106_20123[(5)] = ex__9169__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20083);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20105;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__9167__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20124 = state_20083;
state_20083 = G__20124;
continue;
} else {
return ret_value__9167__auto__;
}
break;
}
});
cljs$core$async$state_machine__9166__auto__ = function(state_20083){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__9166__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__9166__auto____1.call(this,state_20083);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__9166__auto____0;
cljs$core$async$state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__9166__auto____1;
return cljs$core$async$state_machine__9166__auto__;
})()
;})(switch__9165__auto__,c__9230__auto___20112,out))
})();
var state__9232__auto__ = (function (){var statearr_20107 = f__9231__auto__.call(null);
(statearr_20107[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__9230__auto___20112);

return statearr_20107;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__9232__auto__);
});})(c__9230__auto___20112,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args20125 = [];
var len__5627__auto___20195 = arguments.length;
var i__5628__auto___20196 = (0);
while(true){
if((i__5628__auto___20196 < len__5627__auto___20195)){
args20125.push((arguments[i__5628__auto___20196]));

var G__20197 = (i__5628__auto___20196 + (1));
i__5628__auto___20196 = G__20197;
continue;
} else {
}
break;
}

var G__20127 = args20125.length;
switch (G__20127) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20125.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__9230__auto___20199 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__9230__auto___20199,out){
return (function (){
var f__9231__auto__ = (function (){var switch__9165__auto__ = ((function (c__9230__auto___20199,out){
return (function (state_20165){
var state_val_20166 = (state_20165[(1)]);
if((state_val_20166 === (7))){
var inst_20161 = (state_20165[(2)]);
var state_20165__$1 = state_20165;
var statearr_20167_20200 = state_20165__$1;
(statearr_20167_20200[(2)] = inst_20161);

(statearr_20167_20200[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20166 === (1))){
var inst_20128 = (new Array(n));
var inst_20129 = inst_20128;
var inst_20130 = (0);
var state_20165__$1 = (function (){var statearr_20168 = state_20165;
(statearr_20168[(7)] = inst_20129);

(statearr_20168[(8)] = inst_20130);

return statearr_20168;
})();
var statearr_20169_20201 = state_20165__$1;
(statearr_20169_20201[(2)] = null);

(statearr_20169_20201[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20166 === (4))){
var inst_20133 = (state_20165[(9)]);
var inst_20133__$1 = (state_20165[(2)]);
var inst_20134 = (inst_20133__$1 == null);
var inst_20135 = cljs.core.not.call(null,inst_20134);
var state_20165__$1 = (function (){var statearr_20170 = state_20165;
(statearr_20170[(9)] = inst_20133__$1);

return statearr_20170;
})();
if(inst_20135){
var statearr_20171_20202 = state_20165__$1;
(statearr_20171_20202[(1)] = (5));

} else {
var statearr_20172_20203 = state_20165__$1;
(statearr_20172_20203[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20166 === (15))){
var inst_20155 = (state_20165[(2)]);
var state_20165__$1 = state_20165;
var statearr_20173_20204 = state_20165__$1;
(statearr_20173_20204[(2)] = inst_20155);

(statearr_20173_20204[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20166 === (13))){
var state_20165__$1 = state_20165;
var statearr_20174_20205 = state_20165__$1;
(statearr_20174_20205[(2)] = null);

(statearr_20174_20205[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20166 === (6))){
var inst_20130 = (state_20165[(8)]);
var inst_20151 = (inst_20130 > (0));
var state_20165__$1 = state_20165;
if(cljs.core.truth_(inst_20151)){
var statearr_20175_20206 = state_20165__$1;
(statearr_20175_20206[(1)] = (12));

} else {
var statearr_20176_20207 = state_20165__$1;
(statearr_20176_20207[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20166 === (3))){
var inst_20163 = (state_20165[(2)]);
var state_20165__$1 = state_20165;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20165__$1,inst_20163);
} else {
if((state_val_20166 === (12))){
var inst_20129 = (state_20165[(7)]);
var inst_20153 = cljs.core.vec.call(null,inst_20129);
var state_20165__$1 = state_20165;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20165__$1,(15),out,inst_20153);
} else {
if((state_val_20166 === (2))){
var state_20165__$1 = state_20165;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20165__$1,(4),ch);
} else {
if((state_val_20166 === (11))){
var inst_20145 = (state_20165[(2)]);
var inst_20146 = (new Array(n));
var inst_20129 = inst_20146;
var inst_20130 = (0);
var state_20165__$1 = (function (){var statearr_20177 = state_20165;
(statearr_20177[(7)] = inst_20129);

(statearr_20177[(8)] = inst_20130);

(statearr_20177[(10)] = inst_20145);

return statearr_20177;
})();
var statearr_20178_20208 = state_20165__$1;
(statearr_20178_20208[(2)] = null);

(statearr_20178_20208[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20166 === (9))){
var inst_20129 = (state_20165[(7)]);
var inst_20143 = cljs.core.vec.call(null,inst_20129);
var state_20165__$1 = state_20165;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20165__$1,(11),out,inst_20143);
} else {
if((state_val_20166 === (5))){
var inst_20133 = (state_20165[(9)]);
var inst_20138 = (state_20165[(11)]);
var inst_20129 = (state_20165[(7)]);
var inst_20130 = (state_20165[(8)]);
var inst_20137 = (inst_20129[inst_20130] = inst_20133);
var inst_20138__$1 = (inst_20130 + (1));
var inst_20139 = (inst_20138__$1 < n);
var state_20165__$1 = (function (){var statearr_20179 = state_20165;
(statearr_20179[(11)] = inst_20138__$1);

(statearr_20179[(12)] = inst_20137);

return statearr_20179;
})();
if(cljs.core.truth_(inst_20139)){
var statearr_20180_20209 = state_20165__$1;
(statearr_20180_20209[(1)] = (8));

} else {
var statearr_20181_20210 = state_20165__$1;
(statearr_20181_20210[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20166 === (14))){
var inst_20158 = (state_20165[(2)]);
var inst_20159 = cljs.core.async.close_BANG_.call(null,out);
var state_20165__$1 = (function (){var statearr_20183 = state_20165;
(statearr_20183[(13)] = inst_20158);

return statearr_20183;
})();
var statearr_20184_20211 = state_20165__$1;
(statearr_20184_20211[(2)] = inst_20159);

(statearr_20184_20211[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20166 === (10))){
var inst_20149 = (state_20165[(2)]);
var state_20165__$1 = state_20165;
var statearr_20185_20212 = state_20165__$1;
(statearr_20185_20212[(2)] = inst_20149);

(statearr_20185_20212[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20166 === (8))){
var inst_20138 = (state_20165[(11)]);
var inst_20129 = (state_20165[(7)]);
var tmp20182 = inst_20129;
var inst_20129__$1 = tmp20182;
var inst_20130 = inst_20138;
var state_20165__$1 = (function (){var statearr_20186 = state_20165;
(statearr_20186[(7)] = inst_20129__$1);

(statearr_20186[(8)] = inst_20130);

return statearr_20186;
})();
var statearr_20187_20213 = state_20165__$1;
(statearr_20187_20213[(2)] = null);

(statearr_20187_20213[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__9230__auto___20199,out))
;
return ((function (switch__9165__auto__,c__9230__auto___20199,out){
return (function() {
var cljs$core$async$state_machine__9166__auto__ = null;
var cljs$core$async$state_machine__9166__auto____0 = (function (){
var statearr_20191 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20191[(0)] = cljs$core$async$state_machine__9166__auto__);

(statearr_20191[(1)] = (1));

return statearr_20191;
});
var cljs$core$async$state_machine__9166__auto____1 = (function (state_20165){
while(true){
var ret_value__9167__auto__ = (function (){try{while(true){
var result__9168__auto__ = switch__9165__auto__.call(null,state_20165);
if(cljs.core.keyword_identical_QMARK_.call(null,result__9168__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__9168__auto__;
}
break;
}
}catch (e20192){if((e20192 instanceof Object)){
var ex__9169__auto__ = e20192;
var statearr_20193_20214 = state_20165;
(statearr_20193_20214[(5)] = ex__9169__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20165);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20192;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__9167__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20215 = state_20165;
state_20165 = G__20215;
continue;
} else {
return ret_value__9167__auto__;
}
break;
}
});
cljs$core$async$state_machine__9166__auto__ = function(state_20165){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__9166__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__9166__auto____1.call(this,state_20165);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__9166__auto____0;
cljs$core$async$state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__9166__auto____1;
return cljs$core$async$state_machine__9166__auto__;
})()
;})(switch__9165__auto__,c__9230__auto___20199,out))
})();
var state__9232__auto__ = (function (){var statearr_20194 = f__9231__auto__.call(null);
(statearr_20194[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__9230__auto___20199);

return statearr_20194;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__9232__auto__);
});})(c__9230__auto___20199,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args20216 = [];
var len__5627__auto___20290 = arguments.length;
var i__5628__auto___20291 = (0);
while(true){
if((i__5628__auto___20291 < len__5627__auto___20290)){
args20216.push((arguments[i__5628__auto___20291]));

var G__20292 = (i__5628__auto___20291 + (1));
i__5628__auto___20291 = G__20292;
continue;
} else {
}
break;
}

var G__20218 = args20216.length;
switch (G__20218) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20216.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__9230__auto___20294 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__9230__auto___20294,out){
return (function (){
var f__9231__auto__ = (function (){var switch__9165__auto__ = ((function (c__9230__auto___20294,out){
return (function (state_20260){
var state_val_20261 = (state_20260[(1)]);
if((state_val_20261 === (7))){
var inst_20256 = (state_20260[(2)]);
var state_20260__$1 = state_20260;
var statearr_20262_20295 = state_20260__$1;
(statearr_20262_20295[(2)] = inst_20256);

(statearr_20262_20295[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20261 === (1))){
var inst_20219 = [];
var inst_20220 = inst_20219;
var inst_20221 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_20260__$1 = (function (){var statearr_20263 = state_20260;
(statearr_20263[(7)] = inst_20221);

(statearr_20263[(8)] = inst_20220);

return statearr_20263;
})();
var statearr_20264_20296 = state_20260__$1;
(statearr_20264_20296[(2)] = null);

(statearr_20264_20296[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20261 === (4))){
var inst_20224 = (state_20260[(9)]);
var inst_20224__$1 = (state_20260[(2)]);
var inst_20225 = (inst_20224__$1 == null);
var inst_20226 = cljs.core.not.call(null,inst_20225);
var state_20260__$1 = (function (){var statearr_20265 = state_20260;
(statearr_20265[(9)] = inst_20224__$1);

return statearr_20265;
})();
if(inst_20226){
var statearr_20266_20297 = state_20260__$1;
(statearr_20266_20297[(1)] = (5));

} else {
var statearr_20267_20298 = state_20260__$1;
(statearr_20267_20298[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20261 === (15))){
var inst_20250 = (state_20260[(2)]);
var state_20260__$1 = state_20260;
var statearr_20268_20299 = state_20260__$1;
(statearr_20268_20299[(2)] = inst_20250);

(statearr_20268_20299[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20261 === (13))){
var state_20260__$1 = state_20260;
var statearr_20269_20300 = state_20260__$1;
(statearr_20269_20300[(2)] = null);

(statearr_20269_20300[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20261 === (6))){
var inst_20220 = (state_20260[(8)]);
var inst_20245 = inst_20220.length;
var inst_20246 = (inst_20245 > (0));
var state_20260__$1 = state_20260;
if(cljs.core.truth_(inst_20246)){
var statearr_20270_20301 = state_20260__$1;
(statearr_20270_20301[(1)] = (12));

} else {
var statearr_20271_20302 = state_20260__$1;
(statearr_20271_20302[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20261 === (3))){
var inst_20258 = (state_20260[(2)]);
var state_20260__$1 = state_20260;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20260__$1,inst_20258);
} else {
if((state_val_20261 === (12))){
var inst_20220 = (state_20260[(8)]);
var inst_20248 = cljs.core.vec.call(null,inst_20220);
var state_20260__$1 = state_20260;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20260__$1,(15),out,inst_20248);
} else {
if((state_val_20261 === (2))){
var state_20260__$1 = state_20260;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20260__$1,(4),ch);
} else {
if((state_val_20261 === (11))){
var inst_20224 = (state_20260[(9)]);
var inst_20228 = (state_20260[(10)]);
var inst_20238 = (state_20260[(2)]);
var inst_20239 = [];
var inst_20240 = inst_20239.push(inst_20224);
var inst_20220 = inst_20239;
var inst_20221 = inst_20228;
var state_20260__$1 = (function (){var statearr_20272 = state_20260;
(statearr_20272[(7)] = inst_20221);

(statearr_20272[(8)] = inst_20220);

(statearr_20272[(11)] = inst_20238);

(statearr_20272[(12)] = inst_20240);

return statearr_20272;
})();
var statearr_20273_20303 = state_20260__$1;
(statearr_20273_20303[(2)] = null);

(statearr_20273_20303[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20261 === (9))){
var inst_20220 = (state_20260[(8)]);
var inst_20236 = cljs.core.vec.call(null,inst_20220);
var state_20260__$1 = state_20260;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20260__$1,(11),out,inst_20236);
} else {
if((state_val_20261 === (5))){
var inst_20221 = (state_20260[(7)]);
var inst_20224 = (state_20260[(9)]);
var inst_20228 = (state_20260[(10)]);
var inst_20228__$1 = f.call(null,inst_20224);
var inst_20229 = cljs.core._EQ_.call(null,inst_20228__$1,inst_20221);
var inst_20230 = cljs.core.keyword_identical_QMARK_.call(null,inst_20221,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_20231 = (inst_20229) || (inst_20230);
var state_20260__$1 = (function (){var statearr_20274 = state_20260;
(statearr_20274[(10)] = inst_20228__$1);

return statearr_20274;
})();
if(cljs.core.truth_(inst_20231)){
var statearr_20275_20304 = state_20260__$1;
(statearr_20275_20304[(1)] = (8));

} else {
var statearr_20276_20305 = state_20260__$1;
(statearr_20276_20305[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20261 === (14))){
var inst_20253 = (state_20260[(2)]);
var inst_20254 = cljs.core.async.close_BANG_.call(null,out);
var state_20260__$1 = (function (){var statearr_20278 = state_20260;
(statearr_20278[(13)] = inst_20253);

return statearr_20278;
})();
var statearr_20279_20306 = state_20260__$1;
(statearr_20279_20306[(2)] = inst_20254);

(statearr_20279_20306[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20261 === (10))){
var inst_20243 = (state_20260[(2)]);
var state_20260__$1 = state_20260;
var statearr_20280_20307 = state_20260__$1;
(statearr_20280_20307[(2)] = inst_20243);

(statearr_20280_20307[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20261 === (8))){
var inst_20220 = (state_20260[(8)]);
var inst_20224 = (state_20260[(9)]);
var inst_20228 = (state_20260[(10)]);
var inst_20233 = inst_20220.push(inst_20224);
var tmp20277 = inst_20220;
var inst_20220__$1 = tmp20277;
var inst_20221 = inst_20228;
var state_20260__$1 = (function (){var statearr_20281 = state_20260;
(statearr_20281[(7)] = inst_20221);

(statearr_20281[(8)] = inst_20220__$1);

(statearr_20281[(14)] = inst_20233);

return statearr_20281;
})();
var statearr_20282_20308 = state_20260__$1;
(statearr_20282_20308[(2)] = null);

(statearr_20282_20308[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__9230__auto___20294,out))
;
return ((function (switch__9165__auto__,c__9230__auto___20294,out){
return (function() {
var cljs$core$async$state_machine__9166__auto__ = null;
var cljs$core$async$state_machine__9166__auto____0 = (function (){
var statearr_20286 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20286[(0)] = cljs$core$async$state_machine__9166__auto__);

(statearr_20286[(1)] = (1));

return statearr_20286;
});
var cljs$core$async$state_machine__9166__auto____1 = (function (state_20260){
while(true){
var ret_value__9167__auto__ = (function (){try{while(true){
var result__9168__auto__ = switch__9165__auto__.call(null,state_20260);
if(cljs.core.keyword_identical_QMARK_.call(null,result__9168__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__9168__auto__;
}
break;
}
}catch (e20287){if((e20287 instanceof Object)){
var ex__9169__auto__ = e20287;
var statearr_20288_20309 = state_20260;
(statearr_20288_20309[(5)] = ex__9169__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20260);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20287;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__9167__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20310 = state_20260;
state_20260 = G__20310;
continue;
} else {
return ret_value__9167__auto__;
}
break;
}
});
cljs$core$async$state_machine__9166__auto__ = function(state_20260){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__9166__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__9166__auto____1.call(this,state_20260);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__9166__auto____0;
cljs$core$async$state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__9166__auto____1;
return cljs$core$async$state_machine__9166__auto__;
})()
;})(switch__9165__auto__,c__9230__auto___20294,out))
})();
var state__9232__auto__ = (function (){var statearr_20289 = f__9231__auto__.call(null);
(statearr_20289[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__9230__auto___20294);

return statearr_20289;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__9232__auto__);
});})(c__9230__auto___20294,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;
