// Compiled by ClojureScript 1.7.145 {}
goog.provide('hatti.ona.post_process');
goog.require('cljs.core');
goog.require('hatti.ona.forms');
goog.require('hatti.ona.urls');
goog.require('hatti.shared');
goog.require('hatti.constants');
goog.require('hatti.utils');
goog.require('hatti.utils.om.state');
/**
 * Given some data in Ona format, builds a data structure that we will use
 * to link osm data to Ona data.
 */
hatti.ona.post_process.ona_osm_link = (function hatti$ona$post_process$ona_osm_link(data,form){
var osmfields = cljs.core.filter.call(null,hatti.ona.forms.osm_QMARK_,form);
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.flatten.call(null,(function (){var iter__5341__auto__ = ((function (osmfields){
return (function hatti$ona$post_process$ona_osm_link_$_iter__12871(s__12872){
return (new cljs.core.LazySeq(null,((function (osmfields){
return (function (){
var s__12872__$1 = s__12872;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__12872__$1);
if(temp__4425__auto__){
var s__12872__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__12872__$2)){
var c__5339__auto__ = cljs.core.chunk_first.call(null,s__12872__$2);
var size__5340__auto__ = cljs.core.count.call(null,c__5339__auto__);
var b__12874 = cljs.core.chunk_buffer.call(null,size__5340__auto__);
if((function (){var i__12873 = (0);
while(true){
if((i__12873 < size__5340__auto__)){
var datum = cljs.core._nth.call(null,c__5339__auto__,i__12873);
cljs.core.chunk_append.call(null,b__12874,(function (){var iter__5341__auto__ = ((function (i__12873,datum,c__5339__auto__,size__5340__auto__,b__12874,s__12872__$2,temp__4425__auto__,osmfields){
return (function hatti$ona$post_process$ona_osm_link_$_iter__12871_$_iter__12883(s__12884){
return (new cljs.core.LazySeq(null,((function (i__12873,datum,c__5339__auto__,size__5340__auto__,b__12874,s__12872__$2,temp__4425__auto__,osmfields){
return (function (){
var s__12884__$1 = s__12884;
while(true){
var temp__4425__auto____$1 = cljs.core.seq.call(null,s__12884__$1);
if(temp__4425__auto____$1){
var s__12884__$2 = temp__4425__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__12884__$2)){
var c__5339__auto____$1 = cljs.core.chunk_first.call(null,s__12884__$2);
var size__5340__auto____$1 = cljs.core.count.call(null,c__5339__auto____$1);
var b__12886 = cljs.core.chunk_buffer.call(null,size__5340__auto____$1);
if((function (){var i__12885 = (0);
while(true){
if((i__12885 < size__5340__auto____$1)){
var field = cljs.core._nth.call(null,c__5339__auto____$1,i__12885);
cljs.core.chunk_append.call(null,b__12886,(function (){var osmkey = new cljs.core.Keyword(null,"full-name","full-name",408178550).cljs$core$IFn$_invoke$arity$1(field);
var osmdatum = cljs.core.get.call(null,datum,osmkey);
var osmid = (function (){var and__4557__auto__ = osmdatum;
if(cljs.core.truth_(and__4557__auto__)){
return cljs.core.re_find.call(null,/[0-9]+/,osmdatum);
} else {
return and__4557__auto__;
}
})();
if(cljs.core.truth_(osmid)){
return cljs.core.PersistentArrayMap.fromArray([osmid,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"field","field",-1302436500),field], null),cljs.core.select_keys.call(null,datum,cljs.core.PersistentHashSet.fromArray([hatti.constants._rank,hatti.constants._id], true)))], true, false);
} else {
return null;
}
})());

var G__12891 = (i__12885 + (1));
i__12885 = G__12891;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__12886),hatti$ona$post_process$ona_osm_link_$_iter__12871_$_iter__12883.call(null,cljs.core.chunk_rest.call(null,s__12884__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__12886),null);
}
} else {
var field = cljs.core.first.call(null,s__12884__$2);
return cljs.core.cons.call(null,(function (){var osmkey = new cljs.core.Keyword(null,"full-name","full-name",408178550).cljs$core$IFn$_invoke$arity$1(field);
var osmdatum = cljs.core.get.call(null,datum,osmkey);
var osmid = (function (){var and__4557__auto__ = osmdatum;
if(cljs.core.truth_(and__4557__auto__)){
return cljs.core.re_find.call(null,/[0-9]+/,osmdatum);
} else {
return and__4557__auto__;
}
})();
if(cljs.core.truth_(osmid)){
return cljs.core.PersistentArrayMap.fromArray([osmid,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"field","field",-1302436500),field], null),cljs.core.select_keys.call(null,datum,cljs.core.PersistentHashSet.fromArray([hatti.constants._rank,hatti.constants._id], true)))], true, false);
} else {
return null;
}
})(),hatti$ona$post_process$ona_osm_link_$_iter__12871_$_iter__12883.call(null,cljs.core.rest.call(null,s__12884__$2)));
}
} else {
return null;
}
break;
}
});})(i__12873,datum,c__5339__auto__,size__5340__auto__,b__12874,s__12872__$2,temp__4425__auto__,osmfields))
,null,null));
});})(i__12873,datum,c__5339__auto__,size__5340__auto__,b__12874,s__12872__$2,temp__4425__auto__,osmfields))
;
return iter__5341__auto__.call(null,osmfields);
})());

var G__12892 = (i__12873 + (1));
i__12873 = G__12892;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__12874),hatti$ona$post_process$ona_osm_link_$_iter__12871.call(null,cljs.core.chunk_rest.call(null,s__12872__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__12874),null);
}
} else {
var datum = cljs.core.first.call(null,s__12872__$2);
return cljs.core.cons.call(null,(function (){var iter__5341__auto__ = ((function (datum,s__12872__$2,temp__4425__auto__,osmfields){
return (function hatti$ona$post_process$ona_osm_link_$_iter__12871_$_iter__12887(s__12888){
return (new cljs.core.LazySeq(null,((function (datum,s__12872__$2,temp__4425__auto__,osmfields){
return (function (){
var s__12888__$1 = s__12888;
while(true){
var temp__4425__auto____$1 = cljs.core.seq.call(null,s__12888__$1);
if(temp__4425__auto____$1){
var s__12888__$2 = temp__4425__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__12888__$2)){
var c__5339__auto__ = cljs.core.chunk_first.call(null,s__12888__$2);
var size__5340__auto__ = cljs.core.count.call(null,c__5339__auto__);
var b__12890 = cljs.core.chunk_buffer.call(null,size__5340__auto__);
if((function (){var i__12889 = (0);
while(true){
if((i__12889 < size__5340__auto__)){
var field = cljs.core._nth.call(null,c__5339__auto__,i__12889);
cljs.core.chunk_append.call(null,b__12890,(function (){var osmkey = new cljs.core.Keyword(null,"full-name","full-name",408178550).cljs$core$IFn$_invoke$arity$1(field);
var osmdatum = cljs.core.get.call(null,datum,osmkey);
var osmid = (function (){var and__4557__auto__ = osmdatum;
if(cljs.core.truth_(and__4557__auto__)){
return cljs.core.re_find.call(null,/[0-9]+/,osmdatum);
} else {
return and__4557__auto__;
}
})();
if(cljs.core.truth_(osmid)){
return cljs.core.PersistentArrayMap.fromArray([osmid,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"field","field",-1302436500),field], null),cljs.core.select_keys.call(null,datum,cljs.core.PersistentHashSet.fromArray([hatti.constants._rank,hatti.constants._id], true)))], true, false);
} else {
return null;
}
})());

var G__12893 = (i__12889 + (1));
i__12889 = G__12893;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__12890),hatti$ona$post_process$ona_osm_link_$_iter__12871_$_iter__12887.call(null,cljs.core.chunk_rest.call(null,s__12888__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__12890),null);
}
} else {
var field = cljs.core.first.call(null,s__12888__$2);
return cljs.core.cons.call(null,(function (){var osmkey = new cljs.core.Keyword(null,"full-name","full-name",408178550).cljs$core$IFn$_invoke$arity$1(field);
var osmdatum = cljs.core.get.call(null,datum,osmkey);
var osmid = (function (){var and__4557__auto__ = osmdatum;
if(cljs.core.truth_(and__4557__auto__)){
return cljs.core.re_find.call(null,/[0-9]+/,osmdatum);
} else {
return and__4557__auto__;
}
})();
if(cljs.core.truth_(osmid)){
return cljs.core.PersistentArrayMap.fromArray([osmid,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"field","field",-1302436500),field], null),cljs.core.select_keys.call(null,datum,cljs.core.PersistentHashSet.fromArray([hatti.constants._rank,hatti.constants._id], true)))], true, false);
} else {
return null;
}
})(),hatti$ona$post_process$ona_osm_link_$_iter__12871_$_iter__12887.call(null,cljs.core.rest.call(null,s__12888__$2)));
}
} else {
return null;
}
break;
}
});})(datum,s__12872__$2,temp__4425__auto__,osmfields))
,null,null));
});})(datum,s__12872__$2,temp__4425__auto__,osmfields))
;
return iter__5341__auto__.call(null,osmfields);
})(),hatti$ona$post_process$ona_osm_link_$_iter__12871.call(null,cljs.core.rest.call(null,s__12872__$2)));
}
} else {
return null;
}
break;
}
});})(osmfields))
,null,null));
});})(osmfields))
;
return iter__5341__auto__.call(null,data);
})()));
});
/**
 * Takes OSM XML in string form, and returns cljs geojson.
 */
hatti.ona.post_process.osm_xml__GT_geojson = (function hatti$ona$post_process$osm_xml__GT_geojson(osm_xml_string){
return cljs.core.js__GT_clj.call(null,osmtogeojson(jQuery.parseXML(osm_xml_string)),new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
});
/**
 * Given some data in OSM format, an Ona Form, and osm xml string,
 * return a map from OSM ID to each osm feature. The map contains:
 * :osm-id, :name, :tags from osm xml,
 * :type, :geom from osm feature's geojson equivalent.
 */
hatti.ona.post_process.osm_id__GT_osm_data = (function hatti$ona$post_process$osm_id__GT_osm_data(data,form,osm_xml){
var ona_osm_link = hatti.ona.post_process.ona_osm_link.call(null,data,form);
var osmgeo = hatti.ona.post_process.osm_xml__GT_geojson.call(null,osm_xml);
var featureset = osmgeo.call(null,new cljs.core.Keyword(null,"features","features",-1146962336));
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__5341__auto__ = ((function (ona_osm_link,osmgeo,featureset){
return (function hatti$ona$post_process$osm_id__GT_osm_data_$_iter__12914(s__12915){
return (new cljs.core.LazySeq(null,((function (ona_osm_link,osmgeo,featureset){
return (function (){
var s__12915__$1 = s__12915;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__12915__$1);
if(temp__4425__auto__){
var s__12915__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__12915__$2)){
var c__5339__auto__ = cljs.core.chunk_first.call(null,s__12915__$2);
var size__5340__auto__ = cljs.core.count.call(null,c__5339__auto__);
var b__12917 = cljs.core.chunk_buffer.call(null,size__5340__auto__);
if((function (){var i__12916 = (0);
while(true){
if((i__12916 < size__5340__auto__)){
var map__12926 = cljs.core._nth.call(null,c__5339__auto__,i__12916);
var map__12926__$1 = ((((!((map__12926 == null)))?((((map__12926.cljs$lang$protocol_mask$partition0$ & (64))) || (map__12926.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__12926):map__12926);
var feature = map__12926__$1;
var type = cljs.core.get.call(null,map__12926__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var properties = cljs.core.get.call(null,map__12926__$1,new cljs.core.Keyword(null,"properties","properties",685819552));
var geometry = cljs.core.get.call(null,map__12926__$1,new cljs.core.Keyword(null,"geometry","geometry",-405034994));
cljs.core.chunk_append.call(null,b__12917,(function (){var map__12928 = properties;
var map__12928__$1 = ((((!((map__12928 == null)))?((((map__12928.cljs$lang$protocol_mask$partition0$ & (64))) || (map__12928.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__12928):map__12928);
var type__$1 = cljs.core.get.call(null,map__12928__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var id = cljs.core.get.call(null,map__12928__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var tags = cljs.core.get.call(null,map__12928__$1,new cljs.core.Keyword(null,"tags","tags",1771418977));
return cljs.core.PersistentArrayMap.fromArray([id,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"osm-id","osm-id",-1125866420),id,new cljs.core.Keyword(null,"type","type",1174270348),type__$1,new cljs.core.Keyword(null,"geom","geom",1207084371),geometry,new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(tags),new cljs.core.Keyword(null,"tags","tags",1771418977),tags], null)], true, false);
})());

var G__12934 = (i__12916 + (1));
i__12916 = G__12934;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__12917),hatti$ona$post_process$osm_id__GT_osm_data_$_iter__12914.call(null,cljs.core.chunk_rest.call(null,s__12915__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__12917),null);
}
} else {
var map__12930 = cljs.core.first.call(null,s__12915__$2);
var map__12930__$1 = ((((!((map__12930 == null)))?((((map__12930.cljs$lang$protocol_mask$partition0$ & (64))) || (map__12930.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__12930):map__12930);
var feature = map__12930__$1;
var type = cljs.core.get.call(null,map__12930__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var properties = cljs.core.get.call(null,map__12930__$1,new cljs.core.Keyword(null,"properties","properties",685819552));
var geometry = cljs.core.get.call(null,map__12930__$1,new cljs.core.Keyword(null,"geometry","geometry",-405034994));
return cljs.core.cons.call(null,(function (){var map__12932 = properties;
var map__12932__$1 = ((((!((map__12932 == null)))?((((map__12932.cljs$lang$protocol_mask$partition0$ & (64))) || (map__12932.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__12932):map__12932);
var type__$1 = cljs.core.get.call(null,map__12932__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var id = cljs.core.get.call(null,map__12932__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var tags = cljs.core.get.call(null,map__12932__$1,new cljs.core.Keyword(null,"tags","tags",1771418977));
return cljs.core.PersistentArrayMap.fromArray([id,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"osm-id","osm-id",-1125866420),id,new cljs.core.Keyword(null,"type","type",1174270348),type__$1,new cljs.core.Keyword(null,"geom","geom",1207084371),geometry,new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(tags),new cljs.core.Keyword(null,"tags","tags",1771418977),tags], null)], true, false);
})(),hatti$ona$post_process$osm_id__GT_osm_data_$_iter__12914.call(null,cljs.core.rest.call(null,s__12915__$2)));
}
} else {
return null;
}
break;
}
});})(ona_osm_link,osmgeo,featureset))
,null,null));
});})(ona_osm_link,osmgeo,featureset))
;
return iter__5341__auto__.call(null,featureset);
})());
});
/**
 * Given some data post-processed from the ona server
 * (ie, containing _id, _rank), and a string of osm-xml, produce a version with
 * relevant osm data injected in.
 */
hatti.ona.post_process.integrate_osm_data_BANG_ = (function hatti$ona$post_process$integrate_osm_data_BANG_(app_state,form,osm_xml,app_state_keys){
var osm_fields = cljs.core.filter.call(null,hatti.ona.forms.osm_QMARK_,form);
if(cljs.core.seq.call(null,osm_fields)){
var data = cljs.core.get_in.call(null,app_state,app_state_keys);
var osm_data = hatti.ona.post_process.osm_id__GT_osm_data.call(null,data,form,osm_xml);
var osm_val__GT_osm_id = ((function (data,osm_data,osm_fields){
return (function (p1__12935_SHARP_){
return cljs.core.re_find.call(null,/[-]?[0-9]+/,p1__12935_SHARP_);
});})(data,osm_data,osm_fields))
;
var osm_val__GT_osm_data = ((function (data,osm_data,osm_val__GT_osm_id,osm_fields){
return (function (osm_val){
if(typeof osm_val === 'string'){
var temp__4423__auto__ = osm_data.call(null,osm_val__GT_osm_id.call(null,osm_val));
if(cljs.core.truth_(temp__4423__auto__)){
var osm_submission_data = temp__4423__auto__;
return osm_submission_data;
} else {
return osm_val;
}
} else {
return osm_val;
}
});})(data,osm_data,osm_val__GT_osm_id,osm_fields))
;
var updater = ((function (data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields){
return (function (osm_key){
return ((function (data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields){
return (function (data__$1){
var iter__5341__auto__ = ((function (data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields){
return (function hatti$ona$post_process$integrate_osm_data_BANG__$_iter__12944(s__12945){
return (new cljs.core.LazySeq(null,((function (data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields){
return (function (){
var s__12945__$1 = s__12945;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__12945__$1);
if(temp__4425__auto__){
var s__12945__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__12945__$2)){
var c__5339__auto__ = cljs.core.chunk_first.call(null,s__12945__$2);
var size__5340__auto__ = cljs.core.count.call(null,c__5339__auto__);
var b__12947 = cljs.core.chunk_buffer.call(null,size__5340__auto__);
if((function (){var i__12946 = (0);
while(true){
if((i__12946 < size__5340__auto__)){
var datum = cljs.core._nth.call(null,c__5339__auto__,i__12946);
cljs.core.chunk_append.call(null,b__12947,cljs.core.update_in.call(null,datum,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [osm_key], null),osm_val__GT_osm_data));

var G__12952 = (i__12946 + (1));
i__12946 = G__12952;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__12947),hatti$ona$post_process$integrate_osm_data_BANG__$_iter__12944.call(null,cljs.core.chunk_rest.call(null,s__12945__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__12947),null);
}
} else {
var datum = cljs.core.first.call(null,s__12945__$2);
return cljs.core.cons.call(null,cljs.core.update_in.call(null,datum,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [osm_key], null),osm_val__GT_osm_data),hatti$ona$post_process$integrate_osm_data_BANG__$_iter__12944.call(null,cljs.core.rest.call(null,s__12945__$2)));
}
} else {
return null;
}
break;
}
});})(data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields))
,null,null));
});})(data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields))
;
return iter__5341__auto__.call(null,data__$1);
});
;})(data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields))
});})(data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields))
;
var seq__12948 = cljs.core.seq.call(null,osm_fields);
var chunk__12949 = null;
var count__12950 = (0);
var i__12951 = (0);
while(true){
if((i__12951 < count__12950)){
var osm_field = cljs.core._nth.call(null,chunk__12949,i__12951);
hatti.utils.om.state.transact_app_state_BANG_.call(null,app_state,app_state_keys,updater.call(null,new cljs.core.Keyword(null,"full-name","full-name",408178550).cljs$core$IFn$_invoke$arity$1(osm_field)));

var G__12953 = seq__12948;
var G__12954 = chunk__12949;
var G__12955 = count__12950;
var G__12956 = (i__12951 + (1));
seq__12948 = G__12953;
chunk__12949 = G__12954;
count__12950 = G__12955;
i__12951 = G__12956;
continue;
} else {
var temp__4425__auto__ = cljs.core.seq.call(null,seq__12948);
if(temp__4425__auto__){
var seq__12948__$1 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__12948__$1)){
var c__5372__auto__ = cljs.core.chunk_first.call(null,seq__12948__$1);
var G__12957 = cljs.core.chunk_rest.call(null,seq__12948__$1);
var G__12958 = c__5372__auto__;
var G__12959 = cljs.core.count.call(null,c__5372__auto__);
var G__12960 = (0);
seq__12948 = G__12957;
chunk__12949 = G__12958;
count__12950 = G__12959;
i__12951 = G__12960;
continue;
} else {
var osm_field = cljs.core.first.call(null,seq__12948__$1);
hatti.utils.om.state.transact_app_state_BANG_.call(null,app_state,app_state_keys,updater.call(null,new cljs.core.Keyword(null,"full-name","full-name",408178550).cljs$core$IFn$_invoke$arity$1(osm_field)));

var G__12961 = cljs.core.next.call(null,seq__12948__$1);
var G__12962 = null;
var G__12963 = (0);
var G__12964 = (0);
seq__12948 = G__12961;
chunk__12949 = G__12962;
count__12950 = G__12963;
i__12951 = G__12964;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return null;
}
});
/**
 * Calculate full image and thumbnail urls given attachment information.
 */
hatti.ona.post_process.url_obj = (function hatti$ona$post_process$url_obj(media_obj){
var media_id = cljs.core.get.call(null,media_obj,"id");
var fname = cljs.core.get.call(null,media_obj,"filename");
var file_url = hatti.ona.urls.media_url.call(null,media_id,fname);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"filename","filename",-1428840783),fname,new cljs.core.Keyword(null,"download_url","download_url",-2115471203),file_url,new cljs.core.Keyword(null,"small_download_url","small_download_url",1654303565),[cljs.core.str(file_url),cljs.core.str("&suffix=small")].join('')], null);
});
/**
 * Helper function for integrate attachments; returns a function from
 * a filename to a `url-obj` (see specs in `url-obj` function).
 */
hatti.ona.post_process.get_attach_map = (function hatti$ona$post_process$get_attach_map(record,attachments){
var attachments__$1 = (function (){var or__4569__auto__ = attachments;
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
return cljs.core.get.call(null,record,"_attachments");
}
})();
var fnames = cljs.core.map.call(null,((function (attachments__$1){
return (function (p1__12965_SHARP_){
return hatti.utils.last_url_param.call(null,cljs.core.get.call(null,p1__12965_SHARP_,"filename"));
});})(attachments__$1))
,attachments__$1);
var fname__GT_urlobj = cljs.core.zipmap.call(null,fnames,cljs.core.map.call(null,hatti.ona.post_process.url_obj,attachments__$1));
return ((function (attachments__$1,fnames,fname__GT_urlobj){
return (function (fname){
return cljs.core.get.call(null,fname__GT_urlobj,fname,fname);
});
;})(attachments__$1,fnames,fname__GT_urlobj))
});
/**
 * Inlines media data from within _attachments into each record.
 */
hatti.ona.post_process.integrate_attachments = (function hatti$ona$post_process$integrate_attachments(var_args){
var args__5634__auto__ = [];
var len__5627__auto___12976 = arguments.length;
var i__5628__auto___12977 = (0);
while(true){
if((i__5628__auto___12977 < len__5627__auto___12976)){
args__5634__auto__.push((arguments[i__5628__auto___12977]));

var G__12978 = (i__5628__auto___12977 + (1));
i__5628__auto___12977 = G__12978;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((2) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((2)),(0))):null);
return hatti.ona.post_process.integrate_attachments.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5635__auto__);
});

hatti.ona.post_process.integrate_attachments.cljs$core$IFn$_invoke$arity$variadic = (function (flat_form,data,p__12969){
var map__12970 = p__12969;
var map__12970__$1 = ((((!((map__12970 == null)))?((((map__12970.cljs$lang$protocol_mask$partition0$ & (64))) || (map__12970.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__12970):map__12970);
var attachments = cljs.core.get.call(null,map__12970__$1,new cljs.core.Keyword(null,"attachments","attachments",-1535547830));
var image_fields = cljs.core.filter.call(null,hatti.ona.forms.image_QMARK_,flat_form);
var iter__5341__auto__ = ((function (image_fields,map__12970,map__12970__$1,attachments){
return (function hatti$ona$post_process$iter__12972(s__12973){
return (new cljs.core.LazySeq(null,((function (image_fields,map__12970,map__12970__$1,attachments){
return (function (){
var s__12973__$1 = s__12973;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__12973__$1);
if(temp__4425__auto__){
var s__12973__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__12973__$2)){
var c__5339__auto__ = cljs.core.chunk_first.call(null,s__12973__$2);
var size__5340__auto__ = cljs.core.count.call(null,c__5339__auto__);
var b__12975 = cljs.core.chunk_buffer.call(null,size__5340__auto__);
if((function (){var i__12974 = (0);
while(true){
if((i__12974 < size__5340__auto__)){
var record = cljs.core._nth.call(null,c__5339__auto__,i__12974);
cljs.core.chunk_append.call(null,b__12975,(function (){var attach_map = hatti.ona.post_process.get_attach_map.call(null,record,attachments);
return cljs.core.reduce.call(null,((function (i__12974,attach_map,record,c__5339__auto__,size__5340__auto__,b__12975,s__12973__$2,temp__4425__auto__,image_fields,map__12970,map__12970__$1,attachments){
return (function (record__$1,img_field){
return cljs.core.update_in.call(null,record__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"full-name","full-name",408178550).cljs$core$IFn$_invoke$arity$1(img_field)], null),attach_map);
});})(i__12974,attach_map,record,c__5339__auto__,size__5340__auto__,b__12975,s__12973__$2,temp__4425__auto__,image_fields,map__12970,map__12970__$1,attachments))
,record,image_fields);
})());

var G__12979 = (i__12974 + (1));
i__12974 = G__12979;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__12975),hatti$ona$post_process$iter__12972.call(null,cljs.core.chunk_rest.call(null,s__12973__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__12975),null);
}
} else {
var record = cljs.core.first.call(null,s__12973__$2);
return cljs.core.cons.call(null,(function (){var attach_map = hatti.ona.post_process.get_attach_map.call(null,record,attachments);
return cljs.core.reduce.call(null,((function (attach_map,record,s__12973__$2,temp__4425__auto__,image_fields,map__12970,map__12970__$1,attachments){
return (function (record__$1,img_field){
return cljs.core.update_in.call(null,record__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"full-name","full-name",408178550).cljs$core$IFn$_invoke$arity$1(img_field)], null),attach_map);
});})(attach_map,record,s__12973__$2,temp__4425__auto__,image_fields,map__12970,map__12970__$1,attachments))
,record,image_fields);
})(),hatti$ona$post_process$iter__12972.call(null,cljs.core.rest.call(null,s__12973__$2)));
}
} else {
return null;
}
break;
}
});})(image_fields,map__12970,map__12970__$1,attachments))
,null,null));
});})(image_fields,map__12970,map__12970__$1,attachments))
;
return iter__5341__auto__.call(null,data);
});

hatti.ona.post_process.integrate_attachments.cljs$lang$maxFixedArity = (2);

hatti.ona.post_process.integrate_attachments.cljs$lang$applyTo = (function (seq12966){
var G__12967 = cljs.core.first.call(null,seq12966);
var seq12966__$1 = cljs.core.next.call(null,seq12966);
var G__12968 = cljs.core.first.call(null,seq12966__$1);
var seq12966__$2 = cljs.core.next.call(null,seq12966__$1);
return hatti.ona.post_process.integrate_attachments.cljs$core$IFn$_invoke$arity$variadic(G__12967,G__12968,seq12966__$2);
});
/**
 * Inlines data from within _attachments into each datapoint within repeats.
 */
hatti.ona.post_process.integrate_attachments_in_repeats = (function hatti$ona$post_process$integrate_attachments_in_repeats(flat_form,data){
var repeat_fields = cljs.core.filter.call(null,hatti.ona.forms.repeat_QMARK_,flat_form);
var integrate = ((function (repeat_fields){
return (function (record,rpt_field){
var key = new cljs.core.Keyword(null,"full-name","full-name",408178550).cljs$core$IFn$_invoke$arity$1(rpt_field);
return cljs.core.assoc.call(null,record,key,hatti.ona.post_process.integrate_attachments.call(null,new cljs.core.Keyword(null,"children","children",-940561982).cljs$core$IFn$_invoke$arity$1(rpt_field),cljs.core.get.call(null,record,key),new cljs.core.Keyword(null,"attachments","attachments",-1535547830),cljs.core.get.call(null,record,"_attachments")));
});})(repeat_fields))
;
var iter__5341__auto__ = ((function (repeat_fields,integrate){
return (function hatti$ona$post_process$integrate_attachments_in_repeats_$_iter__12984(s__12985){
return (new cljs.core.LazySeq(null,((function (repeat_fields,integrate){
return (function (){
var s__12985__$1 = s__12985;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__12985__$1);
if(temp__4425__auto__){
var s__12985__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__12985__$2)){
var c__5339__auto__ = cljs.core.chunk_first.call(null,s__12985__$2);
var size__5340__auto__ = cljs.core.count.call(null,c__5339__auto__);
var b__12987 = cljs.core.chunk_buffer.call(null,size__5340__auto__);
if((function (){var i__12986 = (0);
while(true){
if((i__12986 < size__5340__auto__)){
var record = cljs.core._nth.call(null,c__5339__auto__,i__12986);
cljs.core.chunk_append.call(null,b__12987,cljs.core.reduce.call(null,integrate,record,repeat_fields));

var G__12988 = (i__12986 + (1));
i__12986 = G__12988;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__12987),hatti$ona$post_process$integrate_attachments_in_repeats_$_iter__12984.call(null,cljs.core.chunk_rest.call(null,s__12985__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__12987),null);
}
} else {
var record = cljs.core.first.call(null,s__12985__$2);
return cljs.core.cons.call(null,cljs.core.reduce.call(null,integrate,record,repeat_fields),hatti$ona$post_process$integrate_attachments_in_repeats_$_iter__12984.call(null,cljs.core.rest.call(null,s__12985__$2)));
}
} else {
return null;
}
break;
}
});})(repeat_fields,integrate))
,null,null));
});})(repeat_fields,integrate))
;
return iter__5341__auto__.call(null,data);
});
/**
 * Inlines data from within _atatchments into each record within app-state.
 */
hatti.ona.post_process.integrate_attachments_BANG_ = (function hatti$ona$post_process$integrate_attachments_BANG_(var_args){
var args__5634__auto__ = [];
var len__5627__auto___12996 = arguments.length;
var i__5628__auto___12997 = (0);
while(true){
if((i__5628__auto___12997 < len__5627__auto___12996)){
args__5634__auto__.push((arguments[i__5628__auto___12997]));

var G__12998 = (i__5628__auto___12997 + (1));
i__5628__auto___12997 = G__12998;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((2) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((2)),(0))):null);
return hatti.ona.post_process.integrate_attachments_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5635__auto__);
});

hatti.ona.post_process.integrate_attachments_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (app_state,flat_form,p__12993){
var map__12994 = p__12993;
var map__12994__$1 = ((((!((map__12994 == null)))?((((map__12994.cljs$lang$protocol_mask$partition0$ & (64))) || (map__12994.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__12994):map__12994);
var app_data_keys = cljs.core.get.call(null,map__12994__$1,new cljs.core.Keyword(null,"app-data-keys","app-data-keys",-662378404),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377)], null));
return hatti.utils.om.state.transact_app_state_BANG_.call(null,app_state,app_data_keys,((function (map__12994,map__12994__$1,app_data_keys){
return (function (p1__12989_SHARP_){
return hatti.ona.post_process.integrate_attachments_in_repeats.call(null,flat_form,hatti.ona.post_process.integrate_attachments.call(null,flat_form,p1__12989_SHARP_));
});})(map__12994,map__12994__$1,app_data_keys))
);
});

hatti.ona.post_process.integrate_attachments_BANG_.cljs$lang$maxFixedArity = (2);

hatti.ona.post_process.integrate_attachments_BANG_.cljs$lang$applyTo = (function (seq12990){
var G__12991 = cljs.core.first.call(null,seq12990);
var seq12990__$1 = cljs.core.next.call(null,seq12990);
var G__12992 = cljs.core.first.call(null,seq12990__$1);
var seq12990__$2 = cljs.core.next.call(null,seq12990__$1);
return hatti.ona.post_process.integrate_attachments_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__12991,G__12992,seq12990__$2);
});
