// Compiled by ClojureScript 1.7.145 {}
goog.provide('hatti.views.table');
goog.require('cljs.core');
goog.require('hatti.views.record');
goog.require('om.dom');
goog.require('hatti.ona.forms');
goog.require('sablono.core');
goog.require('cljs.core.async');
goog.require('hatti.shared');
goog.require('hatti.constants');
goog.require('hatti.views');
goog.require('om.core');
goog.require('hatti.utils');
hatti.views.table.default_num_displayed_records = (25);
hatti.views.table.table_id = "submission-grid";
hatti.views.table.pager_id = "pager";
/**
 * Extra fields that will be displayed on the table.
 */
hatti.views.table.get_extra_fields = (function hatti$views$table$get_extra_fields(is_filtered_dataview_QMARK_){
var extra_field = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"full-name","full-name",408178550),hatti.constants._id,new cljs.core.Keyword(null,"label","label",1718410804),"id",new cljs.core.Keyword(null,"name","name",1843675177),hatti.constants._id,new cljs.core.Keyword(null,"type","type",1174270348),"integer"], null)], null);
if(cljs.core.truth_(is_filtered_dataview_QMARK_)){
return extra_field;
} else {
return cljs.core.conj.call(null,extra_field,hatti.ona.forms.submission_time_field);
}
});
/**
 * Given a (flat-)form, returns fields for table display.
 * Puts extra fields in the beginning, metadata at the end of the table,
 * and drops fields that have no data (eg. group/note).
 */
hatti.views.table.all_fields = (function hatti$views$table$all_fields(var_args){
var args__5634__auto__ = [];
var len__5627__auto___14557 = arguments.length;
var i__5628__auto___14558 = (0);
while(true){
if((i__5628__auto___14558 < len__5627__auto___14557)){
args__5634__auto__.push((arguments[i__5628__auto___14558]));

var G__14559 = (i__5628__auto___14558 + (1));
i__5628__auto___14558 = G__14559;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((1) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((1)),(0))):null);
return hatti.views.table.all_fields.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5635__auto__);
});

hatti.views.table.all_fields.cljs$core$IFn$_invoke$arity$variadic = (function (form,p__14554){
var map__14555 = p__14554;
var map__14555__$1 = ((((!((map__14555 == null)))?((((map__14555.cljs$lang$protocol_mask$partition0$ & (64))) || (map__14555.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__14555):map__14555);
var is_filtered_dataview_QMARK_ = cljs.core.get.call(null,map__14555__$1,new cljs.core.Keyword(null,"is-filtered-dataview?","is-filtered-dataview?",456678746));
return cljs.core.distinct.call(null,cljs.core.filter.call(null,hatti.ona.forms.has_data_QMARK_,cljs.core.concat.call(null,hatti.views.table.get_extra_fields.call(null,is_filtered_dataview_QMARK_),hatti.ona.forms.non_meta_fields.call(null,form),hatti.ona.forms.meta_fields.call(null,form,new cljs.core.Keyword(null,"with-submission-details?","with-submission-details?",524960549),cljs.core.not.call(null,is_filtered_dataview_QMARK_)))));
});

hatti.views.table.all_fields.cljs$lang$maxFixedArity = (1);

hatti.views.table.all_fields.cljs$lang$applyTo = (function (seq14552){
var G__14553 = cljs.core.first.call(null,seq14552);
var seq14552__$1 = cljs.core.next.call(null,seq14552);
return hatti.views.table.all_fields.cljs$core$IFn$_invoke$arity$variadic(G__14553,seq14552__$1);
});
/**
 * Comparator function for the slickgrid dataview.
 * args.sortCol is the column being sorted, a and b are rows to compare.
 * Claims a is bigger (return 1) if value for a > b, or a is null / empty.
 */
hatti.views.table.compfn = (function hatti$views$table$compfn(args){
return (function (a,b){
var col = (args["sortCol"]);
var lower = ((function (col){
return (function (p1__14560_SHARP_){
if(typeof p1__14560_SHARP_ === 'string'){
return clojure.string.lower_case.call(null,p1__14560_SHARP_);
} else {
return p1__14560_SHARP_;
}
});})(col))
;
var aval = lower.call(null,(a[(col["field"])]));
var bval = lower.call(null,(b[(col["field"])]));
if(((aval == null)) || ((aval > bval))){
return (1);
} else {
return (-1);
}
});
});
/**
 * Filter function for the slickgrid dataview, use as (partial filterfn form)
 * item is the row, args contains query.
 * Return value of false corresponds with exclusion, true with inclusion.
 */
hatti.views.table.filterfn = (function hatti$views$table$filterfn(form,item,args){
if(cljs.core.not.call(null,args)){
return true;
} else {
var indexed_form = cljs.core.zipmap.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"full-name","full-name",408178550),form),form);
var query = (args["query"]);
var fmt_subitem = ((function (indexed_form,query){
return (function (p__14564){
var vec__14565 = p__14564;
var fname = cljs.core.nth.call(null,vec__14565,(0),null);
var answer = cljs.core.nth.call(null,vec__14565,(1),null);
return hatti.ona.forms.format_answer.call(null,cljs.core.get.call(null,indexed_form,fname),answer,null,true);
});})(indexed_form,query))
;
var filtered = cljs.core.remove.call(null,cljs.core.nil_QMARK_,cljs.core.map.call(null,((function (indexed_form,query,fmt_subitem){
return (function (p1__14561_SHARP_){
return cljs.core.re_find.call(null,hatti.utils.safe_regex.call(null,query),[cljs.core.str(p1__14561_SHARP_)].join(''));
});})(indexed_form,query,fmt_subitem))
,cljs.core.map.call(null,fmt_subitem,cljs.core.js__GT_clj.call(null,item))));
return cljs.core.seq.call(null,filtered);
}
});
/**
 * Formatter for slickgrid columns takes row,cell,value,columnDef,dataContext.
 * Get one with (partial formatter field language).
 */
hatti.views.table.formatter = (function hatti$views$table$formatter(field,language,row,cell,value,columnDef,dataContext){
var clj_value = cljs.core.js__GT_clj.call(null,value,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
return hatti.ona.forms.format_answer.call(null,field,clj_value,language,true);
});
cljs.core._add_method.call(null,hatti.views.action_buttons,new cljs.core.Keyword(null,"default","default",-1987822328),(function (owner){
return (function (row,cell,value,columnDef,dataContext){
var map__14566 = new cljs.core.Keyword(null,"dataset-info","dataset-info",-1196999563).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,hatti.shared.app_state));
var map__14566__$1 = ((((!((map__14566 == null)))?((((map__14566.cljs$lang$protocol_mask$partition0$ & (64))) || (map__14566.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__14566):map__14566);
var owner__$1 = cljs.core.get.call(null,map__14566__$1,new cljs.core.Keyword(null,"owner","owner",-392611939));
var project = cljs.core.get.call(null,map__14566__$1,new cljs.core.Keyword(null,"project","project",1124394579));
var formid = cljs.core.get.call(null,map__14566__$1,new cljs.core.Keyword(null,"formid","formid",-2121398991));
var form_owner = hatti.utils.last_url_param.call(null,owner__$1);
var project_id = hatti.utils.last_url_param.call(null,project);
var edit_link = hatti.utils.url.call(null,form_owner,project_id,formid,[cljs.core.str("webform?instance-id="),cljs.core.str(value)].join(''));
return hatti.utils.generate_html.call(null,(cljs.core.truth_(value)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ul","ul",-1349521403),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li.tooltip","li.tooltip",-1420587330),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span.tip-info","span.tip-info",147552832),"View"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a.view-record","a.view-record",235834372),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"i.fa.fa-clone","i.fa.fa-clone",1946695810),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"data-id","data-id",1023855591),value], null)], null)], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li.tooltip","li.tooltip",-1420587330),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span.tip-info","span.tip-info",147552832),"Edit"], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a.edit-record","a.edit-record",698797771),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"data-id","data-id",1023855591),value,new cljs.core.Keyword(null,"target","target",253001721),"_blank",new cljs.core.Keyword(null,"href","href",-793805698),edit_link], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"i.fa.fa-pencil-square-o","i.fa.fa-pencil-square-o",1550650091)], null)], null)], null)], null):null));
});
}));
hatti.views.table.actions_column = (function hatti$views$table$actions_column(owner){
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"headerCssClass","headerCssClass",-1721145883),new cljs.core.Keyword(null,"maxWidth","maxWidth",-1375124795),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"formatter","formatter",-483008823),new cljs.core.Keyword(null,"field","field",-1302436500),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"sortable","sortable",2109633621),new cljs.core.Keyword(null,"cssClass","cssClass",264048890),new cljs.core.Keyword(null,"toolTip","toolTip",-228608737)],["record-actions header",(70),"",hatti.views.action_buttons.call(null,owner),hatti.constants._id,"text","actions",false,"record-actions",""]);
});
/**
 * Get a set of slick grid column objects when given a flat form.
 */
hatti.views.table.flat_form__GT_sg_columns = (function hatti$views$table$flat_form__GT_sg_columns(var_args){
var args14568 = [];
var len__5627__auto___14590 = arguments.length;
var i__5628__auto___14591 = (0);
while(true){
if((i__5628__auto___14591 < len__5627__auto___14590)){
args14568.push((arguments[i__5628__auto___14591]));

var G__14592 = (i__5628__auto___14591 + (1));
i__5628__auto___14591 = G__14592;
continue;
} else {
}
break;
}

var G__14574 = args14568.length;
switch (G__14574) {
case 1:
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__5646__auto__ = (new cljs.core.IndexedSeq(args14568.slice((3)),(0)));
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5646__auto__);

}
});

hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$1 = (function (form){
return hatti.views.table.flat_form__GT_sg_columns.call(null,form,true);
});

hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$2 = (function (form,get_label_QMARK_){
return hatti.views.table.flat_form__GT_sg_columns.call(null,form,get_label_QMARK_,null);
});

hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic = (function (form,get_label_QMARK_,language,p__14575){
var map__14576 = p__14575;
var map__14576__$1 = ((((!((map__14576 == null)))?((((map__14576.cljs$lang$protocol_mask$partition0$ & (64))) || (map__14576.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__14576):map__14576);
var is_filtered_dataview_QMARK_ = cljs.core.get.call(null,map__14576__$1,new cljs.core.Keyword(null,"is-filtered-dataview?","is-filtered-dataview?",456678746));
var owner = cljs.core.get.call(null,map__14576__$1,new cljs.core.Keyword(null,"owner","owner",-392611939));
var columns = (function (){var iter__5341__auto__ = ((function (map__14576,map__14576__$1,is_filtered_dataview_QMARK_,owner){
return (function hatti$views$table$iter__14578(s__14579){
return (new cljs.core.LazySeq(null,((function (map__14576,map__14576__$1,is_filtered_dataview_QMARK_,owner){
return (function (){
var s__14579__$1 = s__14579;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__14579__$1);
if(temp__4425__auto__){
var s__14579__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__14579__$2)){
var c__5339__auto__ = cljs.core.chunk_first.call(null,s__14579__$2);
var size__5340__auto__ = cljs.core.count.call(null,c__5339__auto__);
var b__14581 = cljs.core.chunk_buffer.call(null,size__5340__auto__);
if((function (){var i__14580 = (0);
while(true){
if((i__14580 < size__5340__auto__)){
var field = cljs.core._nth.call(null,c__5339__auto__,i__14580);
cljs.core.chunk_append.call(null,b__14581,(function (){var map__14586 = field;
var map__14586__$1 = ((((!((map__14586 == null)))?((((map__14586.cljs$lang$protocol_mask$partition0$ & (64))) || (map__14586.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__14586):map__14586);
var name = cljs.core.get.call(null,map__14586__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var type = cljs.core.get.call(null,map__14586__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var full_name = cljs.core.get.call(null,map__14586__$1,new cljs.core.Keyword(null,"full-name","full-name",408178550));
var label = (cljs.core.truth_(get_label_QMARK_)?hatti.ona.forms.get_label.call(null,field,language):name);
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"headerCssClass","headerCssClass",-1721145883),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"formatter","formatter",-483008823),new cljs.core.Keyword(null,"minWidth","minWidth",-204293526),new cljs.core.Keyword(null,"field","field",-1302436500),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"sortable","sortable",2109633621),new cljs.core.Keyword(null,"cssClass","cssClass",264048890),new cljs.core.Keyword(null,"toolTip","toolTip",-228608737)],[hatti.ona.forms.get_column_class.call(null,field),label,cljs.core.partial.call(null,hatti.views.table.formatter,field,language),(50),full_name,type,name,true,hatti.ona.forms.get_column_class.call(null,field),label]);
})());

var G__14594 = (i__14580 + (1));
i__14580 = G__14594;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__14581),hatti$views$table$iter__14578.call(null,cljs.core.chunk_rest.call(null,s__14579__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__14581),null);
}
} else {
var field = cljs.core.first.call(null,s__14579__$2);
return cljs.core.cons.call(null,(function (){var map__14588 = field;
var map__14588__$1 = ((((!((map__14588 == null)))?((((map__14588.cljs$lang$protocol_mask$partition0$ & (64))) || (map__14588.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__14588):map__14588);
var name = cljs.core.get.call(null,map__14588__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var type = cljs.core.get.call(null,map__14588__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var full_name = cljs.core.get.call(null,map__14588__$1,new cljs.core.Keyword(null,"full-name","full-name",408178550));
var label = (cljs.core.truth_(get_label_QMARK_)?hatti.ona.forms.get_label.call(null,field,language):name);
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"headerCssClass","headerCssClass",-1721145883),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"formatter","formatter",-483008823),new cljs.core.Keyword(null,"minWidth","minWidth",-204293526),new cljs.core.Keyword(null,"field","field",-1302436500),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"sortable","sortable",2109633621),new cljs.core.Keyword(null,"cssClass","cssClass",264048890),new cljs.core.Keyword(null,"toolTip","toolTip",-228608737)],[hatti.ona.forms.get_column_class.call(null,field),label,cljs.core.partial.call(null,hatti.views.table.formatter,field,language),(50),full_name,type,name,true,hatti.ona.forms.get_column_class.call(null,field),label]);
})(),hatti$views$table$iter__14578.call(null,cljs.core.rest.call(null,s__14579__$2)));
}
} else {
return null;
}
break;
}
});})(map__14576,map__14576__$1,is_filtered_dataview_QMARK_,owner))
,null,null));
});})(map__14576,map__14576__$1,is_filtered_dataview_QMARK_,owner))
;
return iter__5341__auto__.call(null,hatti.views.table.all_fields.call(null,form,new cljs.core.Keyword(null,"is-filtered-dataview?","is-filtered-dataview?",456678746),is_filtered_dataview_QMARK_));
})();
return cljs.core.clj__GT_js.call(null,cljs.core.conj.call(null,columns,hatti.views.table.actions_column.call(null,owner)));
});

hatti.views.table.flat_form__GT_sg_columns.cljs$lang$applyTo = (function (seq14569){
var G__14570 = cljs.core.first.call(null,seq14569);
var seq14569__$1 = cljs.core.next.call(null,seq14569);
var G__14571 = cljs.core.first.call(null,seq14569__$1);
var seq14569__$2 = cljs.core.next.call(null,seq14569__$1);
var G__14572 = cljs.core.first.call(null,seq14569__$2);
var seq14569__$3 = cljs.core.next.call(null,seq14569__$2);
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic(G__14570,G__14571,G__14572,seq14569__$3);
});

hatti.views.table.flat_form__GT_sg_columns.cljs$lang$maxFixedArity = (3);
hatti.views.table.init_sg_pager = (function hatti$views$table$init_sg_pager(grid,dataview){
var Pager = Slick.Controls.Pager;
return (new Pager(dataview,grid,jQuery([cljs.core.str("#"),cljs.core.str(hatti.views.table.pager_id)].join(''))));
});
hatti.views.table.resizeColumns = (function hatti$views$table$resizeColumns(grid){
return grid.registerPlugin(Slick.AutoColumnSize());
});
/**
 * Options to feed the slickgrid constructor.
 */
hatti.views.table.sg_options = {"autoHeight": true, "enableColumnReorder": false, "enableTextSelectionOnCells": true, "rowHeight": (40), "syncColumnCellResize": false};
/**
 * Fixes the first column on slick table on horizontal scroll
 */
hatti.views.table.freeze_action_column_BANG_ = (function hatti$views$table$freeze_action_column_BANG_(){
var actions = document.getElementsByClassName("record-actions");
var sg_viewport = cljs.core.first.call(null,document.getElementsByClassName("slick-viewport"));
var seq__14600 = cljs.core.seq.call(null,actions);
var chunk__14601 = null;
var count__14602 = (0);
var i__14603 = (0);
while(true){
if((i__14603 < count__14602)){
var action = cljs.core._nth.call(null,chunk__14601,i__14603);
var leftOffset_14604 = parseInt(action.offsetLeft);
sg_viewport.addEventListener("scroll",((function (seq__14600,chunk__14601,count__14602,i__14603,leftOffset_14604,action,actions,sg_viewport){
return (function (){
var sl = sg_viewport.scrollLeft;
var set_border_BANG_ = ((function (seq__14600,chunk__14601,count__14602,i__14603,sl,leftOffset_14604,action,actions,sg_viewport){
return (function (p1__14595_SHARP_){
return action.style.borderRight = p1__14595_SHARP_;
});})(seq__14600,chunk__14601,count__14602,i__14603,sl,leftOffset_14604,action,actions,sg_viewport))
;
if((sl === (0))){
set_border_BANG_.call(null,"1px dotted #ededed");
} else {
set_border_BANG_.call(null,"1px solid silver");
}

return action.style.left = [cljs.core.str((sl + leftOffset_14604)),cljs.core.str("px")].join('');
});})(seq__14600,chunk__14601,count__14602,i__14603,leftOffset_14604,action,actions,sg_viewport))
);

var G__14605 = seq__14600;
var G__14606 = chunk__14601;
var G__14607 = count__14602;
var G__14608 = (i__14603 + (1));
seq__14600 = G__14605;
chunk__14601 = G__14606;
count__14602 = G__14607;
i__14603 = G__14608;
continue;
} else {
var temp__4425__auto__ = cljs.core.seq.call(null,seq__14600);
if(temp__4425__auto__){
var seq__14600__$1 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__14600__$1)){
var c__5372__auto__ = cljs.core.chunk_first.call(null,seq__14600__$1);
var G__14609 = cljs.core.chunk_rest.call(null,seq__14600__$1);
var G__14610 = c__5372__auto__;
var G__14611 = cljs.core.count.call(null,c__5372__auto__);
var G__14612 = (0);
seq__14600 = G__14609;
chunk__14601 = G__14610;
count__14602 = G__14611;
i__14603 = G__14612;
continue;
} else {
var action = cljs.core.first.call(null,seq__14600__$1);
var leftOffset_14613 = parseInt(action.offsetLeft);
sg_viewport.addEventListener("scroll",((function (seq__14600,chunk__14601,count__14602,i__14603,leftOffset_14613,action,seq__14600__$1,temp__4425__auto__,actions,sg_viewport){
return (function (){
var sl = sg_viewport.scrollLeft;
var set_border_BANG_ = ((function (seq__14600,chunk__14601,count__14602,i__14603,sl,leftOffset_14613,action,seq__14600__$1,temp__4425__auto__,actions,sg_viewport){
return (function (p1__14595_SHARP_){
return action.style.borderRight = p1__14595_SHARP_;
});})(seq__14600,chunk__14601,count__14602,i__14603,sl,leftOffset_14613,action,seq__14600__$1,temp__4425__auto__,actions,sg_viewport))
;
if((sl === (0))){
set_border_BANG_.call(null,"1px dotted #ededed");
} else {
set_border_BANG_.call(null,"1px solid silver");
}

return action.style.left = [cljs.core.str((sl + leftOffset_14613)),cljs.core.str("px")].join('');
});})(seq__14600,chunk__14601,count__14602,i__14603,leftOffset_14613,action,seq__14600__$1,temp__4425__auto__,actions,sg_viewport))
);

var G__14614 = cljs.core.next.call(null,seq__14600__$1);
var G__14615 = null;
var G__14616 = (0);
var G__14617 = (0);
seq__14600 = G__14614;
chunk__14601 = G__14615;
count__14602 = G__14616;
i__14603 = G__14617;
continue;
}
} else {
return null;
}
}
break;
}
});
hatti.views.table.bind_external_sg_grid_event_handlers = (function hatti$views$table$bind_external_sg_grid_event_handlers(grid,event_handlers){
return cljs.core.doall.call(null,(function (){var iter__5341__auto__ = (function hatti$views$table$bind_external_sg_grid_event_handlers_$_iter__14626(s__14627){
return (new cljs.core.LazySeq(null,(function (){
var s__14627__$1 = s__14627;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__14627__$1);
if(temp__4425__auto__){
var s__14627__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__14627__$2)){
var c__5339__auto__ = cljs.core.chunk_first.call(null,s__14627__$2);
var size__5340__auto__ = cljs.core.count.call(null,c__5339__auto__);
var b__14629 = cljs.core.chunk_buffer.call(null,size__5340__auto__);
if((function (){var i__14628 = (0);
while(true){
if((i__14628 < size__5340__auto__)){
var vec__14632 = cljs.core._nth.call(null,c__5339__auto__,i__14628);
var handler_key = cljs.core.nth.call(null,vec__14632,(0),null);
var handler_function = cljs.core.nth.call(null,vec__14632,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case.call(null,cljs.core.name.call(null,handler_key));
var event = (grid[handler_name]);
cljs.core.chunk_append.call(null,b__14629,event.subscribe(handler_function));

var G__14634 = (i__14628 + (1));
i__14628 = G__14634;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__14629),hatti$views$table$bind_external_sg_grid_event_handlers_$_iter__14626.call(null,cljs.core.chunk_rest.call(null,s__14627__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__14629),null);
}
} else {
var vec__14633 = cljs.core.first.call(null,s__14627__$2);
var handler_key = cljs.core.nth.call(null,vec__14633,(0),null);
var handler_function = cljs.core.nth.call(null,vec__14633,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case.call(null,cljs.core.name.call(null,handler_key));
var event = (grid[handler_name]);
return cljs.core.cons.call(null,event.subscribe(handler_function),hatti$views$table$bind_external_sg_grid_event_handlers_$_iter__14626.call(null,cljs.core.rest.call(null,s__14627__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5341__auto__.call(null,event_handlers);
})());
});
hatti.views.table.bind_external_sg_grid_dataview_handlers = (function hatti$views$table$bind_external_sg_grid_dataview_handlers(dataview,event_handlers){
return cljs.core.doall.call(null,(function (){var iter__5341__auto__ = (function hatti$views$table$bind_external_sg_grid_dataview_handlers_$_iter__14643(s__14644){
return (new cljs.core.LazySeq(null,(function (){
var s__14644__$1 = s__14644;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__14644__$1);
if(temp__4425__auto__){
var s__14644__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__14644__$2)){
var c__5339__auto__ = cljs.core.chunk_first.call(null,s__14644__$2);
var size__5340__auto__ = cljs.core.count.call(null,c__5339__auto__);
var b__14646 = cljs.core.chunk_buffer.call(null,size__5340__auto__);
if((function (){var i__14645 = (0);
while(true){
if((i__14645 < size__5340__auto__)){
var vec__14649 = cljs.core._nth.call(null,c__5339__auto__,i__14645);
var handler_key = cljs.core.nth.call(null,vec__14649,(0),null);
var handler_function = cljs.core.nth.call(null,vec__14649,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case.call(null,cljs.core.name.call(null,handler_key));
var event = (dataview[handler_name]);
cljs.core.chunk_append.call(null,b__14646,event.subscribe(handler_function));

var G__14651 = (i__14645 + (1));
i__14645 = G__14651;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__14646),hatti$views$table$bind_external_sg_grid_dataview_handlers_$_iter__14643.call(null,cljs.core.chunk_rest.call(null,s__14644__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__14646),null);
}
} else {
var vec__14650 = cljs.core.first.call(null,s__14644__$2);
var handler_key = cljs.core.nth.call(null,vec__14650,(0),null);
var handler_function = cljs.core.nth.call(null,vec__14650,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case.call(null,cljs.core.name.call(null,handler_key));
var event = (dataview[handler_name]);
return cljs.core.cons.call(null,event.subscribe(handler_function),hatti$views$table$bind_external_sg_grid_dataview_handlers_$_iter__14643.call(null,cljs.core.rest.call(null,s__14644__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5341__auto__.call(null,event_handlers);
})());
});
/**
 * Creates a Slick.Grid backed by Slick.Data.DataView from data and fields.
 * Most events are handled by slickgrid. On double-click, event is put on chan.
 * Returns [grid dataview].
 */
hatti.views.table.sg_init = (function hatti$views$table$sg_init(data,form,current_language,is_filtered_dataview_QMARK_,owner,p__14652){
var map__14661 = p__14652;
var map__14661__$1 = ((((!((map__14661 == null)))?((((map__14661.cljs$lang$protocol_mask$partition0$ & (64))) || (map__14661.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__14661):map__14661);
var grid_event_handlers = cljs.core.get.call(null,map__14661__$1,new cljs.core.Keyword(null,"grid-event-handlers","grid-event-handlers",1413592355));
var dataview_event_handlers = cljs.core.get.call(null,map__14661__$1,new cljs.core.Keyword(null,"dataview-event-handlers","dataview-event-handlers",-916375885));
var columns = hatti.views.table.flat_form__GT_sg_columns.call(null,form,true,current_language,new cljs.core.Keyword(null,"is-filtered-dataview?","is-filtered-dataview?",456678746),is_filtered_dataview_QMARK_,new cljs.core.Keyword(null,"owner","owner",-392611939),owner);
var SlickGrid = Slick.Grid;
var DataView = Slick.Data.DataView;
var dataview = (new DataView());
var grid = (new SlickGrid([cljs.core.str("#"),cljs.core.str(hatti.views.table.table_id)].join(''),dataview,columns,hatti.views.table.sg_options));
var map__14663 = cljs.core.deref.call(null,hatti.shared.app_state);
var map__14663__$1 = ((((!((map__14663 == null)))?((((map__14663.cljs$lang$protocol_mask$partition0$ & (64))) || (map__14663.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__14663):map__14663);
var map__14664 = cljs.core.get.call(null,map__14663__$1,new cljs.core.Keyword(null,"table-page","table-page",1974969102));
var map__14664__$1 = ((((!((map__14664 == null)))?((((map__14664.cljs$lang$protocol_mask$partition0$ & (64))) || (map__14664.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__14664):map__14664);
var map__14665 = cljs.core.get.call(null,map__14664__$1,new cljs.core.Keyword(null,"paging","paging",1716279728));
var map__14665__$1 = ((((!((map__14665 == null)))?((((map__14665.cljs$lang$protocol_mask$partition0$ & (64))) || (map__14665.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__14665):map__14665);
var num_displayed_records = cljs.core.get.call(null,map__14665__$1,new cljs.core.Keyword(null,"num-displayed-records","num-displayed-records",213046400));
var total_page_count = cljs.core.get.call(null,map__14665__$1,new cljs.core.Keyword(null,"total-page-count","total-page-count",582341740));
hatti.views.table.bind_external_sg_grid_event_handlers.call(null,grid,grid_event_handlers);

hatti.views.table.bind_external_sg_grid_dataview_handlers.call(null,dataview,dataview_event_handlers);

dataview.onRowCountChanged.subscribe(((function (columns,SlickGrid,DataView,dataview,grid,map__14663,map__14663__$1,map__14664,map__14664__$1,map__14665,map__14665__$1,num_displayed_records,total_page_count,map__14661,map__14661__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
grid.updateRowCount();

return grid.render();
});})(columns,SlickGrid,DataView,dataview,grid,map__14663,map__14663__$1,map__14664,map__14664__$1,map__14665,map__14665__$1,num_displayed_records,total_page_count,map__14661,map__14661__$1,grid_event_handlers,dataview_event_handlers))
);

dataview.onRowsChanged.subscribe(((function (columns,SlickGrid,DataView,dataview,grid,map__14663,map__14663__$1,map__14664,map__14664__$1,map__14665,map__14665__$1,num_displayed_records,total_page_count,map__14661,map__14661__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
grid.invalidateRows((args["rows"]));

return grid.render();
});})(columns,SlickGrid,DataView,dataview,grid,map__14663,map__14663__$1,map__14664,map__14664__$1,map__14665,map__14665__$1,num_displayed_records,total_page_count,map__14661,map__14661__$1,grid_event_handlers,dataview_event_handlers))
);

grid.onDblClick.subscribe(((function (columns,SlickGrid,DataView,dataview,grid,map__14663,map__14663__$1,map__14664,map__14664__$1,map__14665,map__14665__$1,num_displayed_records,total_page_count,map__14661,map__14661__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
var rank = (dataview.getItem((args["row"]))[hatti.constants._rank]);
return cljs.core.async.put_BANG_.call(null,hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"submission-to-rank","submission-to-rank",1214938797),rank], null));
});})(columns,SlickGrid,DataView,dataview,grid,map__14663,map__14663__$1,map__14664,map__14664__$1,map__14665,map__14665__$1,num_displayed_records,total_page_count,map__14661,map__14661__$1,grid_event_handlers,dataview_event_handlers))
);

grid.onClick.subscribe(((function (columns,SlickGrid,DataView,dataview,grid,map__14663,map__14663__$1,map__14664,map__14664__$1,map__14665,map__14665__$1,num_displayed_records,total_page_count,map__14661,map__14661__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
var elem = e.target;
var row = dataview.getItem((args["row"]));
var elem_data_id = elem.getAttribute("data-id");
var data_id = (cljs.core.truth_(elem_data_id)?parseInt(elem.getAttribute("data-id")):null);
var id = (row[hatti.constants._id]);
var rank = (row[hatti.constants._rank]);
if(cljs.core._EQ_.call(null,id,data_id)){
return cljs.core.async.put_BANG_.call(null,hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"submission-to-rank","submission-to-rank",1214938797),rank], null));
} else {
return null;
}
});})(columns,SlickGrid,DataView,dataview,grid,map__14663,map__14663__$1,map__14664,map__14664__$1,map__14665,map__14665__$1,num_displayed_records,total_page_count,map__14661,map__14661__$1,grid_event_handlers,dataview_event_handlers))
);

grid.onColumnsResized.subscribe(((function (columns,SlickGrid,DataView,dataview,grid,map__14663,map__14663__$1,map__14664,map__14664__$1,map__14665,map__14665__$1,num_displayed_records,total_page_count,map__14661,map__14661__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
return hatti.views.table.freeze_action_column_BANG_.call(null);
});})(columns,SlickGrid,DataView,dataview,grid,map__14663,map__14663__$1,map__14664,map__14664__$1,map__14665,map__14665__$1,num_displayed_records,total_page_count,map__14661,map__14661__$1,grid_event_handlers,dataview_event_handlers))
);

hatti.views.table.init_sg_pager.call(null,grid,dataview);

dataview.setPagingOptions({"pageSize": (function (){var or__4569__auto__ = num_displayed_records;
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
return hatti.views.table.default_num_displayed_records;
}
})(), "totalPages": total_page_count});

dataview.setFilter(cljs.core.partial.call(null,hatti.views.table.filterfn,form));

dataview.setItems(cljs.core.clj__GT_js.call(null,data),hatti.constants._id);

hatti.views.table.resizeColumns.call(null,grid);

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [grid,dataview], null);
});
/**
 * Event loop for the table view. Processes a tap of share/event-chan,
 * and updates app-state/dataview/grid as needed.
 */
hatti.views.table.handle_table_events = (function hatti$views$table$handle_table_events(app_state,grid,dataview){
var event_chan = hatti.shared.event_tap.call(null);
var c__9230__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__9230__auto__,event_chan){
return (function (){
var f__9231__auto__ = (function (){var switch__9165__auto__ = ((function (c__9230__auto__,event_chan){
return (function (state_14930){
var state_val_14931 = (state_14930[(1)]);
if((state_val_14931 === (7))){
var inst_14839 = (state_14930[(7)]);
var inst_14839__$1 = (state_14930[(2)]);
var inst_14841 = (inst_14839__$1 == null);
var inst_14842 = cljs.core.not.call(null,inst_14841);
var state_14930__$1 = (function (){var statearr_14932 = state_14930;
(statearr_14932[(7)] = inst_14839__$1);

return statearr_14932;
})();
if(inst_14842){
var statearr_14933_15000 = state_14930__$1;
(statearr_14933_15000[(1)] = (8));

} else {
var statearr_14934_15001 = state_14930__$1;
(statearr_14934_15001[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14931 === (20))){
var inst_14861 = (state_14930[(8)]);
var inst_14869 = (state_14930[(9)]);
var inst_14878 = inst_14869.call(null,inst_14861);
var state_14930__$1 = state_14930;
var statearr_14935_15002 = state_14930__$1;
(statearr_14935_15002[(2)] = inst_14878);

(statearr_14935_15002[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14931 === (27))){
var state_14930__$1 = state_14930;
var statearr_14936_15003 = state_14930__$1;
(statearr_14936_15003[(2)] = null);

(statearr_14936_15003[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14931 === (1))){
var state_14930__$1 = state_14930;
var statearr_14937_15004 = state_14930__$1;
(statearr_14937_15004[(2)] = null);

(statearr_14937_15004[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14931 === (24))){
var state_14930__$1 = state_14930;
var statearr_14938_15005 = state_14930__$1;
(statearr_14938_15005[(2)] = null);

(statearr_14938_15005[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14931 === (4))){
var state_14930__$1 = state_14930;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14930__$1,(7),event_chan);
} else {
if((state_val_14931 === (15))){
var inst_14839 = (state_14930[(7)]);
var state_14930__$1 = state_14930;
var statearr_14939_15006 = state_14930__$1;
(statearr_14939_15006[(2)] = inst_14839);

(statearr_14939_15006[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14931 === (21))){
var state_14930__$1 = state_14930;
var statearr_14940_15007 = state_14930__$1;
(statearr_14940_15007[(2)] = null);

(statearr_14940_15007[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14931 === (31))){
var inst_14865 = (state_14930[(10)]);
var inst_14903 = (state_14930[(2)]);
var inst_14904 = cljs.core._EQ_.call(null,inst_14865,new cljs.core.Keyword(null,"table","table",-564943036));
var state_14930__$1 = (function (){var statearr_14941 = state_14930;
(statearr_14941[(11)] = inst_14903);

return statearr_14941;
})();
if(inst_14904){
var statearr_14942_15008 = state_14930__$1;
(statearr_14942_15008[(1)] = (32));

} else {
var statearr_14943_15009 = state_14930__$1;
(statearr_14943_15009[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14931 === (32))){
var inst_14839 = (state_14930[(7)]);
var inst_14864 = (state_14930[(12)]);
var inst_14862 = (state_14930[(13)]);
var inst_14865 = (state_14930[(10)]);
var inst_14861 = (state_14930[(8)]);
var inst_14860 = (state_14930[(14)]);
var inst_14863 = (state_14930[(15)]);
var inst_14869 = (state_14930[(9)]);
var inst_14870 = (state_14930[(16)]);
var inst_14859 = (state_14930[(17)]);
var inst_14917 = cljs.core.async.chan.call(null,(1));
var inst_14918 = (function (){var new_columns = inst_14864;
var c__9230__auto____$1 = inst_14917;
var submission_clicked = inst_14861;
var submission_unclicked = inst_14862;
var get_submission_data = inst_14870;
var re_render = inst_14865;
var update_data_BANG_ = inst_14869;
var submission_to_rank = inst_14860;
var e = inst_14839;
var filter_by = inst_14863;
var map__14837 = inst_14859;
return ((function (new_columns,c__9230__auto____$1,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,e,filter_by,map__14837,inst_14839,inst_14864,inst_14862,inst_14865,inst_14861,inst_14860,inst_14863,inst_14869,inst_14870,inst_14859,inst_14917,state_val_14931,c__9230__auto__,event_chan){
return (function (){
var f__9231__auto__ = (function (){var switch__9165__auto__ = ((function (new_columns,c__9230__auto____$1,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,e,filter_by,map__14837,inst_14839,inst_14864,inst_14862,inst_14865,inst_14861,inst_14860,inst_14863,inst_14869,inst_14870,inst_14859,inst_14917,state_val_14931,c__9230__auto__,event_chan){
return (function (state_14915){
var state_val_14916 = (state_14915[(1)]);
if((state_val_14916 === (1))){
var inst_14906 = cljs.core.async.timeout.call(null,(20));
var state_14915__$1 = state_14915;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14915__$1,(2),inst_14906);
} else {
if((state_val_14916 === (2))){
var inst_14908 = (state_14915[(2)]);
var inst_14909 = grid.resizeCanvas();
var inst_14910 = grid.invalidateAllRows();
var inst_14911 = hatti.views.table.resizeColumns.call(null,grid);
var inst_14912 = grid.render();
var inst_14913 = hatti.views.table.init_sg_pager.call(null,grid,dataview);
var state_14915__$1 = (function (){var statearr_14944 = state_14915;
(statearr_14944[(7)] = inst_14911);

(statearr_14944[(8)] = inst_14908);

(statearr_14944[(9)] = inst_14912);

(statearr_14944[(10)] = inst_14910);

(statearr_14944[(11)] = inst_14909);

return statearr_14944;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14915__$1,inst_14913);
} else {
return null;
}
}
});})(new_columns,c__9230__auto____$1,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,e,filter_by,map__14837,inst_14839,inst_14864,inst_14862,inst_14865,inst_14861,inst_14860,inst_14863,inst_14869,inst_14870,inst_14859,inst_14917,state_val_14931,c__9230__auto__,event_chan))
;
return ((function (switch__9165__auto__,new_columns,c__9230__auto____$1,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,e,filter_by,map__14837,inst_14839,inst_14864,inst_14862,inst_14865,inst_14861,inst_14860,inst_14863,inst_14869,inst_14870,inst_14859,inst_14917,state_val_14931,c__9230__auto__,event_chan){
return (function() {
var hatti$views$table$handle_table_events_$_state_machine__9166__auto__ = null;
var hatti$views$table$handle_table_events_$_state_machine__9166__auto____0 = (function (){
var statearr_14948 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14948[(0)] = hatti$views$table$handle_table_events_$_state_machine__9166__auto__);

(statearr_14948[(1)] = (1));

return statearr_14948;
});
var hatti$views$table$handle_table_events_$_state_machine__9166__auto____1 = (function (state_14915){
while(true){
var ret_value__9167__auto__ = (function (){try{while(true){
var result__9168__auto__ = switch__9165__auto__.call(null,state_14915);
if(cljs.core.keyword_identical_QMARK_.call(null,result__9168__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__9168__auto__;
}
break;
}
}catch (e14949){if((e14949 instanceof Object)){
var ex__9169__auto__ = e14949;
var statearr_14950_15010 = state_14915;
(statearr_14950_15010[(5)] = ex__9169__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14915);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14949;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__9167__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15011 = state_14915;
state_14915 = G__15011;
continue;
} else {
return ret_value__9167__auto__;
}
break;
}
});
hatti$views$table$handle_table_events_$_state_machine__9166__auto__ = function(state_14915){
switch(arguments.length){
case 0:
return hatti$views$table$handle_table_events_$_state_machine__9166__auto____0.call(this);
case 1:
return hatti$views$table$handle_table_events_$_state_machine__9166__auto____1.call(this,state_14915);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$handle_table_events_$_state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$handle_table_events_$_state_machine__9166__auto____0;
hatti$views$table$handle_table_events_$_state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$handle_table_events_$_state_machine__9166__auto____1;
return hatti$views$table$handle_table_events_$_state_machine__9166__auto__;
})()
;})(switch__9165__auto__,new_columns,c__9230__auto____$1,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,e,filter_by,map__14837,inst_14839,inst_14864,inst_14862,inst_14865,inst_14861,inst_14860,inst_14863,inst_14869,inst_14870,inst_14859,inst_14917,state_val_14931,c__9230__auto__,event_chan))
})();
var state__9232__auto__ = (function (){var statearr_14951 = f__9231__auto__.call(null);
(statearr_14951[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__9230__auto____$1);

return statearr_14951;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__9232__auto__);
});
;})(new_columns,c__9230__auto____$1,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,e,filter_by,map__14837,inst_14839,inst_14864,inst_14862,inst_14865,inst_14861,inst_14860,inst_14863,inst_14869,inst_14870,inst_14859,inst_14917,state_val_14931,c__9230__auto__,event_chan))
})();
var inst_14919 = cljs.core.async.impl.dispatch.run.call(null,inst_14918);
var state_14930__$1 = (function (){var statearr_14952 = state_14930;
(statearr_14952[(18)] = inst_14919);

return statearr_14952;
})();
var statearr_14953_15012 = state_14930__$1;
(statearr_14953_15012[(2)] = inst_14917);

(statearr_14953_15012[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14931 === (33))){
var state_14930__$1 = state_14930;
var statearr_14954_15013 = state_14930__$1;
(statearr_14954_15013[(2)] = null);

(statearr_14954_15013[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14931 === (13))){
var inst_14851 = (state_14930[(2)]);
var state_14930__$1 = state_14930;
var statearr_14955_15014 = state_14930__$1;
(statearr_14955_15014[(2)] = inst_14851);

(statearr_14955_15014[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14931 === (22))){
var inst_14862 = (state_14930[(13)]);
var inst_14881 = (state_14930[(2)]);
var state_14930__$1 = (function (){var statearr_14956 = state_14930;
(statearr_14956[(19)] = inst_14881);

return statearr_14956;
})();
if(cljs.core.truth_(inst_14862)){
var statearr_14957_15015 = state_14930__$1;
(statearr_14957_15015[(1)] = (23));

} else {
var statearr_14958_15016 = state_14930__$1;
(statearr_14958_15016[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14931 === (29))){
var inst_14863 = (state_14930[(15)]);
var inst_14895 = [new cljs.core.Keyword(null,"query","query",-1288509510)];
var inst_14896 = [inst_14863];
var inst_14897 = cljs.core.PersistentHashMap.fromArrays(inst_14895,inst_14896);
var inst_14898 = cljs.core.clj__GT_js.call(null,inst_14897);
var inst_14899 = dataview.setFilterArgs(inst_14898);
var inst_14900 = dataview.refresh();
var state_14930__$1 = (function (){var statearr_14959 = state_14930;
(statearr_14959[(20)] = inst_14899);

return statearr_14959;
})();
var statearr_14960_15017 = state_14930__$1;
(statearr_14960_15017[(2)] = inst_14900);

(statearr_14960_15017[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14931 === (6))){
var inst_14926 = (state_14930[(2)]);
var state_14930__$1 = state_14930;
var statearr_14961_15018 = state_14930__$1;
(statearr_14961_15018[(2)] = inst_14926);

(statearr_14961_15018[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14931 === (28))){
var inst_14863 = (state_14930[(15)]);
var inst_14893 = (state_14930[(2)]);
var state_14930__$1 = (function (){var statearr_14962 = state_14930;
(statearr_14962[(21)] = inst_14893);

return statearr_14962;
})();
if(cljs.core.truth_(inst_14863)){
var statearr_14963_15019 = state_14930__$1;
(statearr_14963_15019[(1)] = (29));

} else {
var statearr_14964_15020 = state_14930__$1;
(statearr_14964_15020[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14931 === (25))){
var inst_14864 = (state_14930[(12)]);
var inst_14886 = (state_14930[(2)]);
var state_14930__$1 = (function (){var statearr_14965 = state_14930;
(statearr_14965[(22)] = inst_14886);

return statearr_14965;
})();
if(cljs.core.truth_(inst_14864)){
var statearr_14966_15021 = state_14930__$1;
(statearr_14966_15021[(1)] = (26));

} else {
var statearr_14967_15022 = state_14930__$1;
(statearr_14967_15022[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14931 === (34))){
var inst_14922 = (state_14930[(2)]);
var state_14930__$1 = (function (){var statearr_14968 = state_14930;
(statearr_14968[(23)] = inst_14922);

return statearr_14968;
})();
var statearr_14969_15023 = state_14930__$1;
(statearr_14969_15023[(2)] = null);

(statearr_14969_15023[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14931 === (17))){
var inst_14860 = (state_14930[(14)]);
var inst_14869 = (state_14930[(9)]);
var inst_14870 = (state_14930[(16)]);
var inst_14872 = inst_14870.call(null,hatti.constants._rank,inst_14860);
var inst_14873 = inst_14869.call(null,inst_14872);
var state_14930__$1 = state_14930;
var statearr_14970_15024 = state_14930__$1;
(statearr_14970_15024[(2)] = inst_14873);

(statearr_14970_15024[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14931 === (3))){
var inst_14928 = (state_14930[(2)]);
var state_14930__$1 = state_14930;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14930__$1,inst_14928);
} else {
if((state_val_14931 === (12))){
var state_14930__$1 = state_14930;
var statearr_14971_15025 = state_14930__$1;
(statearr_14971_15025[(2)] = false);

(statearr_14971_15025[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14931 === (2))){
var state_14930__$1 = state_14930;
var statearr_14972_15026 = state_14930__$1;
(statearr_14972_15026[(1)] = (4));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14931 === (23))){
var inst_14869 = (state_14930[(9)]);
var inst_14883 = inst_14869.call(null,null);
var state_14930__$1 = state_14930;
var statearr_14974_15027 = state_14930__$1;
(statearr_14974_15027[(2)] = inst_14883);

(statearr_14974_15027[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14931 === (19))){
var inst_14861 = (state_14930[(8)]);
var inst_14876 = (state_14930[(2)]);
var state_14930__$1 = (function (){var statearr_14975 = state_14930;
(statearr_14975[(24)] = inst_14876);

return statearr_14975;
})();
if(cljs.core.truth_(inst_14861)){
var statearr_14976_15028 = state_14930__$1;
(statearr_14976_15028[(1)] = (20));

} else {
var statearr_14977_15029 = state_14930__$1;
(statearr_14977_15029[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14931 === (11))){
var state_14930__$1 = state_14930;
var statearr_14978_15030 = state_14930__$1;
(statearr_14978_15030[(2)] = true);

(statearr_14978_15030[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14931 === (9))){
var state_14930__$1 = state_14930;
var statearr_14979_15031 = state_14930__$1;
(statearr_14979_15031[(2)] = false);

(statearr_14979_15031[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14931 === (5))){
var state_14930__$1 = state_14930;
var statearr_14980_15032 = state_14930__$1;
(statearr_14980_15032[(2)] = null);

(statearr_14980_15032[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14931 === (14))){
var inst_14839 = (state_14930[(7)]);
var inst_14856 = cljs.core.apply.call(null,cljs.core.hash_map,inst_14839);
var state_14930__$1 = state_14930;
var statearr_14981_15033 = state_14930__$1;
(statearr_14981_15033[(2)] = inst_14856);

(statearr_14981_15033[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14931 === (26))){
var inst_14864 = (state_14930[(12)]);
var inst_14888 = grid.setColumns(inst_14864);
var inst_14889 = hatti.views.table.resizeColumns.call(null,grid);
var inst_14890 = grid.render();
var state_14930__$1 = (function (){var statearr_14982 = state_14930;
(statearr_14982[(25)] = inst_14889);

(statearr_14982[(26)] = inst_14888);

return statearr_14982;
})();
var statearr_14983_15034 = state_14930__$1;
(statearr_14983_15034[(2)] = inst_14890);

(statearr_14983_15034[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14931 === (16))){
var inst_14839 = (state_14930[(7)]);
var inst_14864 = (state_14930[(12)]);
var inst_14862 = (state_14930[(13)]);
var inst_14865 = (state_14930[(10)]);
var inst_14861 = (state_14930[(8)]);
var inst_14860 = (state_14930[(14)]);
var inst_14863 = (state_14930[(15)]);
var inst_14869 = (state_14930[(9)]);
var inst_14859 = (state_14930[(17)]);
var inst_14859__$1 = (state_14930[(2)]);
var inst_14860__$1 = cljs.core.get.call(null,inst_14859__$1,new cljs.core.Keyword(null,"submission-to-rank","submission-to-rank",1214938797));
var inst_14861__$1 = cljs.core.get.call(null,inst_14859__$1,new cljs.core.Keyword(null,"submission-clicked","submission-clicked",1228953855));
var inst_14862__$1 = cljs.core.get.call(null,inst_14859__$1,new cljs.core.Keyword(null,"submission-unclicked","submission-unclicked",-2099539520));
var inst_14863__$1 = cljs.core.get.call(null,inst_14859__$1,new cljs.core.Keyword(null,"filter-by","filter-by",-1855851983));
var inst_14864__$1 = cljs.core.get.call(null,inst_14859__$1,new cljs.core.Keyword(null,"new-columns","new-columns",-887765797));
var inst_14865__$1 = cljs.core.get.call(null,inst_14859__$1,new cljs.core.Keyword(null,"re-render","re-render",1133553258));
var inst_14866 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14867 = [new cljs.core.Keyword(null,"table-page","table-page",1974969102),new cljs.core.Keyword(null,"submission-clicked","submission-clicked",1228953855),new cljs.core.Keyword(null,"data","data",-232669377)];
var inst_14868 = (new cljs.core.PersistentVector(null,3,(5),inst_14866,inst_14867,null));
var inst_14869__$1 = cljs.core.partial.call(null,om.core.update_BANG_,app_state,inst_14868);
var inst_14870 = (function (){var e = inst_14839;
var map__14837 = inst_14859__$1;
var submission_to_rank = inst_14860__$1;
var submission_clicked = inst_14861__$1;
var submission_unclicked = inst_14862__$1;
var filter_by = inst_14863__$1;
var new_columns = inst_14864__$1;
var re_render = inst_14865__$1;
var update_data_BANG_ = inst_14869__$1;
return ((function (e,map__14837,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_14839,inst_14864,inst_14862,inst_14865,inst_14861,inst_14860,inst_14863,inst_14869,inst_14859,inst_14859__$1,inst_14860__$1,inst_14861__$1,inst_14862__$1,inst_14863__$1,inst_14864__$1,inst_14865__$1,inst_14866,inst_14867,inst_14868,inst_14869__$1,state_val_14931,c__9230__auto__,event_chan){
return (function (field,value){
return cljs.core.first.call(null,cljs.core.filter.call(null,((function (e,map__14837,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_14839,inst_14864,inst_14862,inst_14865,inst_14861,inst_14860,inst_14863,inst_14869,inst_14859,inst_14859__$1,inst_14860__$1,inst_14861__$1,inst_14862__$1,inst_14863__$1,inst_14864__$1,inst_14865__$1,inst_14866,inst_14867,inst_14868,inst_14869__$1,state_val_14931,c__9230__auto__,event_chan){
return (function (p1__14669_SHARP_){
return cljs.core._EQ_.call(null,value,cljs.core.get.call(null,p1__14669_SHARP_,field));
});})(e,map__14837,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_14839,inst_14864,inst_14862,inst_14865,inst_14861,inst_14860,inst_14863,inst_14869,inst_14859,inst_14859__$1,inst_14860__$1,inst_14861__$1,inst_14862__$1,inst_14863__$1,inst_14864__$1,inst_14865__$1,inst_14866,inst_14867,inst_14868,inst_14869__$1,state_val_14931,c__9230__auto__,event_chan))
,cljs.core.get_in.call(null,cljs.core.deref.call(null,app_state),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377)], null))));
});
;})(e,map__14837,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_14839,inst_14864,inst_14862,inst_14865,inst_14861,inst_14860,inst_14863,inst_14869,inst_14859,inst_14859__$1,inst_14860__$1,inst_14861__$1,inst_14862__$1,inst_14863__$1,inst_14864__$1,inst_14865__$1,inst_14866,inst_14867,inst_14868,inst_14869__$1,state_val_14931,c__9230__auto__,event_chan))
})();
var state_14930__$1 = (function (){var statearr_14984 = state_14930;
(statearr_14984[(12)] = inst_14864__$1);

(statearr_14984[(13)] = inst_14862__$1);

(statearr_14984[(10)] = inst_14865__$1);

(statearr_14984[(8)] = inst_14861__$1);

(statearr_14984[(14)] = inst_14860__$1);

(statearr_14984[(15)] = inst_14863__$1);

(statearr_14984[(9)] = inst_14869__$1);

(statearr_14984[(16)] = inst_14870);

(statearr_14984[(17)] = inst_14859__$1);

return statearr_14984;
})();
if(cljs.core.truth_(inst_14860__$1)){
var statearr_14985_15035 = state_14930__$1;
(statearr_14985_15035[(1)] = (17));

} else {
var statearr_14986_15036 = state_14930__$1;
(statearr_14986_15036[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14931 === (30))){
var state_14930__$1 = state_14930;
var statearr_14987_15037 = state_14930__$1;
(statearr_14987_15037[(2)] = null);

(statearr_14987_15037[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14931 === (10))){
var inst_14854 = (state_14930[(2)]);
var state_14930__$1 = state_14930;
if(cljs.core.truth_(inst_14854)){
var statearr_14988_15038 = state_14930__$1;
(statearr_14988_15038[(1)] = (14));

} else {
var statearr_14989_15039 = state_14930__$1;
(statearr_14989_15039[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14931 === (18))){
var state_14930__$1 = state_14930;
var statearr_14990_15040 = state_14930__$1;
(statearr_14990_15040[(2)] = null);

(statearr_14990_15040[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14931 === (8))){
var inst_14839 = (state_14930[(7)]);
var inst_14844 = inst_14839.cljs$lang$protocol_mask$partition0$;
var inst_14845 = (inst_14844 & (64));
var inst_14846 = inst_14839.cljs$core$ISeq$;
var inst_14847 = (inst_14845) || (inst_14846);
var state_14930__$1 = state_14930;
if(cljs.core.truth_(inst_14847)){
var statearr_14991_15041 = state_14930__$1;
(statearr_14991_15041[(1)] = (11));

} else {
var statearr_14992_15042 = state_14930__$1;
(statearr_14992_15042[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__9230__auto__,event_chan))
;
return ((function (switch__9165__auto__,c__9230__auto__,event_chan){
return (function() {
var hatti$views$table$handle_table_events_$_state_machine__9166__auto__ = null;
var hatti$views$table$handle_table_events_$_state_machine__9166__auto____0 = (function (){
var statearr_14996 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14996[(0)] = hatti$views$table$handle_table_events_$_state_machine__9166__auto__);

(statearr_14996[(1)] = (1));

return statearr_14996;
});
var hatti$views$table$handle_table_events_$_state_machine__9166__auto____1 = (function (state_14930){
while(true){
var ret_value__9167__auto__ = (function (){try{while(true){
var result__9168__auto__ = switch__9165__auto__.call(null,state_14930);
if(cljs.core.keyword_identical_QMARK_.call(null,result__9168__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__9168__auto__;
}
break;
}
}catch (e14997){if((e14997 instanceof Object)){
var ex__9169__auto__ = e14997;
var statearr_14998_15043 = state_14930;
(statearr_14998_15043[(5)] = ex__9169__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14930);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14997;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__9167__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15044 = state_14930;
state_14930 = G__15044;
continue;
} else {
return ret_value__9167__auto__;
}
break;
}
});
hatti$views$table$handle_table_events_$_state_machine__9166__auto__ = function(state_14930){
switch(arguments.length){
case 0:
return hatti$views$table$handle_table_events_$_state_machine__9166__auto____0.call(this);
case 1:
return hatti$views$table$handle_table_events_$_state_machine__9166__auto____1.call(this,state_14930);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$handle_table_events_$_state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$handle_table_events_$_state_machine__9166__auto____0;
hatti$views$table$handle_table_events_$_state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$handle_table_events_$_state_machine__9166__auto____1;
return hatti$views$table$handle_table_events_$_state_machine__9166__auto__;
})()
;})(switch__9165__auto__,c__9230__auto__,event_chan))
})();
var state__9232__auto__ = (function (){var statearr_14999 = f__9231__auto__.call(null);
(statearr_14999[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__9230__auto__);

return statearr_14999;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__9232__auto__);
});})(c__9230__auto__,event_chan))
);

return c__9230__auto__;
});
hatti.views.table.render_options = (function hatti$views$table$render_options(options,owner,colset_BANG_){
var choose_display_key = (function (k){
om.core.set_state_BANG_.call(null,owner,new cljs.core.Keyword(null,"name-or-label","name-or-label",-520034208),k);

return colset_BANG_.call(null,k);
});
var iter__5341__auto__ = ((function (choose_display_key){
return (function hatti$views$table$render_options_$_iter__15053(s__15054){
return (new cljs.core.LazySeq(null,((function (choose_display_key){
return (function (){
var s__15054__$1 = s__15054;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__15054__$1);
if(temp__4425__auto__){
var s__15054__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__15054__$2)){
var c__5339__auto__ = cljs.core.chunk_first.call(null,s__15054__$2);
var size__5340__auto__ = cljs.core.count.call(null,c__5339__auto__);
var b__15056 = cljs.core.chunk_buffer.call(null,size__5340__auto__);
if((function (){var i__15055 = (0);
while(true){
if((i__15055 < size__5340__auto__)){
var vec__15059 = cljs.core._nth.call(null,c__5339__auto__,i__15055);
var k = cljs.core.nth.call(null,vec__15059,(0),null);
var v = cljs.core.nth.call(null,vec__15059,(1),null);
cljs.core.chunk_append.call(null,b__15056,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"on-click","on-click",1632826543),hatti.utils.click_fn.call(null,((function (i__15055,vec__15059,k,v,c__5339__auto__,size__5340__auto__,b__15056,s__15054__$2,temp__4425__auto__,choose_display_key){
return (function (){
return choose_display_key.call(null,k);
});})(i__15055,vec__15059,k,v,c__5339__auto__,size__5340__auto__,b__15056,s__15054__$2,temp__4425__auto__,choose_display_key))
),new cljs.core.Keyword(null,"href","href",-793805698),"#"], null),v], null)], null));

var G__15061 = (i__15055 + (1));
i__15055 = G__15061;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__15056),hatti$views$table$render_options_$_iter__15053.call(null,cljs.core.chunk_rest.call(null,s__15054__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__15056),null);
}
} else {
var vec__15060 = cljs.core.first.call(null,s__15054__$2);
var k = cljs.core.nth.call(null,vec__15060,(0),null);
var v = cljs.core.nth.call(null,vec__15060,(1),null);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"on-click","on-click",1632826543),hatti.utils.click_fn.call(null,((function (vec__15060,k,v,s__15054__$2,temp__4425__auto__,choose_display_key){
return (function (){
return choose_display_key.call(null,k);
});})(vec__15060,k,v,s__15054__$2,temp__4425__auto__,choose_display_key))
),new cljs.core.Keyword(null,"href","href",-793805698),"#"], null),v], null)], null),hatti$views$table$render_options_$_iter__15053.call(null,cljs.core.rest.call(null,s__15054__$2)));
}
} else {
return null;
}
break;
}
});})(choose_display_key))
,null,null));
});})(choose_display_key))
;
return iter__5341__auto__.call(null,options);
});
cljs.core._add_method.call(null,hatti.views.label_changer,new cljs.core.Keyword(null,"default","default",-1987822328),(function (_,owner){
if(typeof hatti.views.table.t_hatti$views$table15063 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRenderState}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IInitState}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table15063 = (function (_,owner,meta15064){
this._ = _;
this.owner = owner;
this.meta15064 = meta15064;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table15063.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_15065,meta15064__$1){
var self__ = this;
var _15065__$1 = this;
return (new hatti.views.table.t_hatti$views$table15063(self__._,self__.owner,meta15064__$1));
});

hatti.views.table.t_hatti$views$table15063.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_15065){
var self__ = this;
var _15065__$1 = this;
return self__.meta15064;
});

hatti.views.table.t_hatti$views$table15063.prototype.om$core$IInitState$ = true;

hatti.views.table.t_hatti$views$table15063.prototype.om$core$IInitState$init_state$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"name-or-label","name-or-label",-520034208),new cljs.core.Keyword(null,"label","label",1718410804)], null);
});

hatti.views.table.t_hatti$views$table15063.prototype.om$core$IRenderState$ = true;

hatti.views.table.t_hatti$views$table15063.prototype.om$core$IRenderState$render_state$arity$2 = (function (___$1,p__15066){
var self__ = this;
var map__15067 = p__15066;
var map__15067__$1 = ((((!((map__15067 == null)))?((((map__15067.cljs$lang$protocol_mask$partition0$ & (64))) || (map__15067.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__15067):map__15067);
var name_or_label = cljs.core.get.call(null,map__15067__$1,new cljs.core.Keyword(null,"name-or-label","name-or-label",-520034208));
var language = cljs.core.get.call(null,map__15067__$1,new cljs.core.Keyword(null,"language","language",-1591107564));
var ___$2 = this;
var options = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"label","label",1718410804),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"strong","strong",269529000),"Label"], null),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"strong","strong",269529000),"Name"], null)], null);
var map__15069 = om.core.get_shared.call(null,self__.owner);
var map__15069__$1 = ((((!((map__15069 == null)))?((((map__15069.cljs$lang$protocol_mask$partition0$ & (64))) || (map__15069.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__15069):map__15069);
var flat_form = cljs.core.get.call(null,map__15069__$1,new cljs.core.Keyword(null,"flat-form","flat-form",-468858211));
var new_language = new cljs.core.Keyword(null,"current","current",-1088038603).cljs$core$IFn$_invoke$arity$1(om.core.observe.call(null,self__.owner,hatti.shared.language_cursor.call(null)));
var colset_BANG_ = ((function (options,map__15069,map__15069__$1,flat_form,new_language,___$2,map__15067,map__15067__$1,name_or_label,language){
return (function (p1__15062_SHARP_){
return cljs.core.async.put_BANG_.call(null,hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"new-columns","new-columns",-887765797),hatti.views.table.flat_form__GT_sg_columns.call(null,flat_form,cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"label","label",1718410804),p1__15062_SHARP_),new_language)], null));
});})(options,map__15069,map__15069__$1,flat_form,new_language,___$2,map__15067,map__15067__$1,name_or_label,language))
;
if(cljs.core.not_EQ_.call(null,new_language,language)){
om.core.set_state_BANG_.call(null,self__.owner,new cljs.core.Keyword(null,"language","language",-1591107564),new_language);

colset_BANG_.call(null,name_or_label);
} else {
}

return React.DOM.div({"className": "label-changer"},React.DOM.span({"className": "label-changer-label"},"Show:"),React.DOM.div({"id": "header-display-dropdown", "className": "drop-hover"},(function (){var attrs15073 = options.call(null,name_or_label);
return cljs.core.apply.call(null,React.DOM.span,((cljs.core.map_QMARK_.call(null,attrs15073))?sablono.interpreter.attributes.call(null,attrs15073):null),cljs.core.remove.call(null,cljs.core.nil_QMARK_,((cljs.core.map_QMARK_.call(null,attrs15073))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [React.DOM.i({"className": "fa fa-angle-down"})], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret.call(null,attrs15073),React.DOM.i({"className": "fa fa-angle-down"})], null))));
})(),React.DOM.ul({"className": "submenu no-dot"},sablono.interpreter.interpret.call(null,hatti.views.table.render_options.call(null,options,self__.owner,colset_BANG_)))));
});

hatti.views.table.t_hatti$views$table15063.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.Symbol(null,"owner","owner",1247919588,null),new cljs.core.Symbol(null,"meta15064","meta15064",1587801964,null)], null);
});

hatti.views.table.t_hatti$views$table15063.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table15063.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table15063";

hatti.views.table.t_hatti$views$table15063.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write.call(null,writer__5168__auto__,"hatti.views.table/t_hatti$views$table15063");
});

hatti.views.table.__GT_t_hatti$views$table15063 = (function hatti$views$table$__GT_t_hatti$views$table15063(___$1,owner__$1,meta15064){
return (new hatti.views.table.t_hatti$views$table15063(___$1,owner__$1,meta15064));
});

}

return (new hatti.views.table.t_hatti$views$table15063(_,owner,cljs.core.PersistentArrayMap.EMPTY));
}));
/**
 * Delayed search fires a query-event on event-chan if the value of the input
 * doesn't change within 150 ms (ie, user is still typing).
 * Call on-change or on-key-up, with (.-target event) as first argument.
 */
hatti.views.table.delayed_search = (function hatti$views$table$delayed_search(input,query_event_key){
var query = input.value;
var c__9230__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__9230__auto__,query){
return (function (){
var f__9231__auto__ = (function (){var switch__9165__auto__ = ((function (c__9230__auto__,query){
return (function (state_15120){
var state_val_15121 = (state_15120[(1)]);
if((state_val_15121 === (1))){
var inst_15106 = cljs.core.async.timeout.call(null,(150));
var state_15120__$1 = state_15120;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15120__$1,(2),inst_15106);
} else {
if((state_val_15121 === (2))){
var inst_15108 = (state_15120[(2)]);
var inst_15109 = input.value;
var inst_15110 = cljs.core._EQ_.call(null,query,inst_15109);
var state_15120__$1 = (function (){var statearr_15122 = state_15120;
(statearr_15122[(7)] = inst_15108);

return statearr_15122;
})();
if(inst_15110){
var statearr_15123_15134 = state_15120__$1;
(statearr_15123_15134[(1)] = (3));

} else {
var statearr_15124_15135 = state_15120__$1;
(statearr_15124_15135[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15121 === (3))){
var inst_15112 = [query_event_key];
var inst_15113 = [query];
var inst_15114 = cljs.core.PersistentHashMap.fromArrays(inst_15112,inst_15113);
var inst_15115 = cljs.core.async.put_BANG_.call(null,hatti.shared.event_chan,inst_15114);
var state_15120__$1 = state_15120;
var statearr_15125_15136 = state_15120__$1;
(statearr_15125_15136[(2)] = inst_15115);

(statearr_15125_15136[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15121 === (4))){
var state_15120__$1 = state_15120;
var statearr_15126_15137 = state_15120__$1;
(statearr_15126_15137[(2)] = null);

(statearr_15126_15137[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15121 === (5))){
var inst_15118 = (state_15120[(2)]);
var state_15120__$1 = state_15120;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15120__$1,inst_15118);
} else {
return null;
}
}
}
}
}
});})(c__9230__auto__,query))
;
return ((function (switch__9165__auto__,c__9230__auto__,query){
return (function() {
var hatti$views$table$delayed_search_$_state_machine__9166__auto__ = null;
var hatti$views$table$delayed_search_$_state_machine__9166__auto____0 = (function (){
var statearr_15130 = [null,null,null,null,null,null,null,null];
(statearr_15130[(0)] = hatti$views$table$delayed_search_$_state_machine__9166__auto__);

(statearr_15130[(1)] = (1));

return statearr_15130;
});
var hatti$views$table$delayed_search_$_state_machine__9166__auto____1 = (function (state_15120){
while(true){
var ret_value__9167__auto__ = (function (){try{while(true){
var result__9168__auto__ = switch__9165__auto__.call(null,state_15120);
if(cljs.core.keyword_identical_QMARK_.call(null,result__9168__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__9168__auto__;
}
break;
}
}catch (e15131){if((e15131 instanceof Object)){
var ex__9169__auto__ = e15131;
var statearr_15132_15138 = state_15120;
(statearr_15132_15138[(5)] = ex__9169__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_15120);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e15131;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__9167__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15139 = state_15120;
state_15120 = G__15139;
continue;
} else {
return ret_value__9167__auto__;
}
break;
}
});
hatti$views$table$delayed_search_$_state_machine__9166__auto__ = function(state_15120){
switch(arguments.length){
case 0:
return hatti$views$table$delayed_search_$_state_machine__9166__auto____0.call(this);
case 1:
return hatti$views$table$delayed_search_$_state_machine__9166__auto____1.call(this,state_15120);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$delayed_search_$_state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$delayed_search_$_state_machine__9166__auto____0;
hatti$views$table$delayed_search_$_state_machine__9166__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$delayed_search_$_state_machine__9166__auto____1;
return hatti$views$table$delayed_search_$_state_machine__9166__auto__;
})()
;})(switch__9165__auto__,c__9230__auto__,query))
})();
var state__9232__auto__ = (function (){var statearr_15133 = f__9231__auto__.call(null);
(statearr_15133[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__9230__auto__);

return statearr_15133;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__9232__auto__);
});})(c__9230__auto__,query))
);

return c__9230__auto__;
});
cljs.core._add_method.call(null,hatti.views.table_search,new cljs.core.Keyword(null,"default","default",-1987822328),(function (_,owner){
if(typeof hatti.views.table.t_hatti$views$table15141 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table15141 = (function (_,owner,meta15142){
this._ = _;
this.owner = owner;
this.meta15142 = meta15142;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table15141.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_15143,meta15142__$1){
var self__ = this;
var _15143__$1 = this;
return (new hatti.views.table.t_hatti$views$table15141(self__._,self__.owner,meta15142__$1));
});

hatti.views.table.t_hatti$views$table15141.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_15143){
var self__ = this;
var _15143__$1 = this;
return self__.meta15142;
});

hatti.views.table.t_hatti$views$table15141.prototype.om$core$IRender$ = true;

hatti.views.table.t_hatti$views$table15141.prototype.om$core$IRender$render$arity$1 = (function (this__6567__auto__){
var self__ = this;
var this__6567__auto____$1 = this;
return React.DOM.div({"className": "table-search"},React.DOM.i({"className": "fa fa-search"}),sablono.interpreter.input.call(null,{"type": "text", "placeholder": "Search", "onChange": ((function (this__6567__auto____$1){
return (function (p1__15140_SHARP_){
return hatti.views.table.delayed_search.call(null,p1__15140_SHARP_.target,new cljs.core.Keyword(null,"filter-by","filter-by",-1855851983));
});})(this__6567__auto____$1))
}));
});

hatti.views.table.t_hatti$views$table15141.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.Symbol(null,"owner","owner",1247919588,null),new cljs.core.Symbol(null,"meta15142","meta15142",-243190489,null)], null);
});

hatti.views.table.t_hatti$views$table15141.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table15141.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table15141";

hatti.views.table.t_hatti$views$table15141.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write.call(null,writer__5168__auto__,"hatti.views.table/t_hatti$views$table15141");
});

hatti.views.table.__GT_t_hatti$views$table15141 = (function hatti$views$table$__GT_t_hatti$views$table15141(___$1,owner__$1,meta15142){
return (new hatti.views.table.t_hatti$views$table15141(___$1,owner__$1,meta15142));
});

}

return (new hatti.views.table.t_hatti$views$table15141(_,owner,null));
}));
cljs.core._add_method.call(null,hatti.views.table_header,new cljs.core.Keyword(null,"default","default",-1987822328),(function (app_state,owner){
if(typeof hatti.views.table.t_hatti$views$table15146 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table15146 = (function (app_state,owner,meta15147){
this.app_state = app_state;
this.owner = owner;
this.meta15147 = meta15147;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table15146.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_15148,meta15147__$1){
var self__ = this;
var _15148__$1 = this;
return (new hatti.views.table.t_hatti$views$table15146(self__.app_state,self__.owner,meta15147__$1));
});

hatti.views.table.t_hatti$views$table15146.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_15148){
var self__ = this;
var _15148__$1 = this;
return self__.meta15147;
});

hatti.views.table.t_hatti$views$table15146.prototype.om$core$IRender$ = true;

hatti.views.table.t_hatti$views$table15146.prototype.om$core$IRender$render$arity$1 = (function (this__6567__auto__){
var self__ = this;
var this__6567__auto____$1 = this;
return React.DOM.div({"className": "topbar"},React.DOM.div({"id": hatti.views.table.pager_id}),sablono.interpreter.interpret.call(null,om.core.build.call(null,hatti.views.label_changer,null)),sablono.interpreter.interpret.call(null,om.core.build.call(null,hatti.views.table_search,self__.app_state)),React.DOM.div({"style": {"clear": "both"}}));
});

hatti.views.table.t_hatti$views$table15146.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"app-state","app-state",130568249,null),new cljs.core.Symbol(null,"owner","owner",1247919588,null),new cljs.core.Symbol(null,"meta15147","meta15147",-457222655,null)], null);
});

hatti.views.table.t_hatti$views$table15146.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table15146.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table15146";

hatti.views.table.t_hatti$views$table15146.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write.call(null,writer__5168__auto__,"hatti.views.table/t_hatti$views$table15146");
});

hatti.views.table.__GT_t_hatti$views$table15146 = (function hatti$views$table$__GT_t_hatti$views$table15146(app_state__$1,owner__$1,meta15147){
return (new hatti.views.table.t_hatti$views$table15146(app_state__$1,owner__$1,meta15147));
});

}

return (new hatti.views.table.t_hatti$views$table15146(app_state,owner,null));
}));
hatti.views.table.init_grid_BANG_ = (function hatti$views$table$init_grid_BANG_(data,owner,slick_grid_event_handlers){

if(cljs.core.seq.call(null,data)){
var map__15154 = om.core.get_shared.call(null,owner);
var map__15154__$1 = ((((!((map__15154 == null)))?((((map__15154.cljs$lang$protocol_mask$partition0$ & (64))) || (map__15154.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__15154):map__15154);
var flat_form = cljs.core.get.call(null,map__15154__$1,new cljs.core.Keyword(null,"flat-form","flat-form",-468858211));
var is_filtered_dataview_QMARK_ = cljs.core.get.call(null,map__15154__$1,new cljs.core.Keyword(null,"is-filtered-dataview?","is-filtered-dataview?",456678746));
var current_language = new cljs.core.Keyword(null,"current","current",-1088038603).cljs$core$IFn$_invoke$arity$1(om.core.observe.call(null,owner,hatti.shared.language_cursor.call(null)));
var vec__15155 = hatti.views.table.sg_init.call(null,data,flat_form,current_language,is_filtered_dataview_QMARK_,owner,slick_grid_event_handlers);
var grid = cljs.core.nth.call(null,vec__15155,(0),null);
var dataview = cljs.core.nth.call(null,vec__15155,(1),null);
om.core.set_state_BANG_.call(null,owner,new cljs.core.Keyword(null,"grid","grid",402978600),grid);

om.core.set_state_BANG_.call(null,owner,new cljs.core.Keyword(null,"dataview","dataview",91765671),dataview);

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [grid,dataview], null);
} else {
return null;
}
});
cljs.core._add_method.call(null,hatti.views.table_page,new cljs.core.Keyword(null,"default","default",-1987822328),(function (app_state,owner,p__15158){
var map__15159 = p__15158;
var map__15159__$1 = ((((!((map__15159 == null)))?((((map__15159.cljs$lang$protocol_mask$partition0$ & (64))) || (map__15159.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__15159):map__15159);
var opts = map__15159__$1;
var slick_grid_event_handlers = cljs.core.get.call(null,map__15159__$1,new cljs.core.Keyword(null,"slick-grid-event-handlers","slick-grid-event-handlers",1990034724));

if(typeof hatti.views.table.t_hatti$views$table15161 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRenderState}
 * @implements {om.core.IWillReceiveProps}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IDidMount}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table15161 = (function (app_state,owner,p__15158,map__15159,opts,slick_grid_event_handlers,meta15162){
this.app_state = app_state;
this.owner = owner;
this.p__15158 = p__15158;
this.map__15159 = map__15159;
this.opts = opts;
this.slick_grid_event_handlers = slick_grid_event_handlers;
this.meta15162 = meta15162;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table15161.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (map__15159,map__15159__$1,opts,slick_grid_event_handlers){
return (function (_15163,meta15162__$1){
var self__ = this;
var _15163__$1 = this;
return (new hatti.views.table.t_hatti$views$table15161(self__.app_state,self__.owner,self__.p__15158,self__.map__15159,self__.opts,self__.slick_grid_event_handlers,meta15162__$1));
});})(map__15159,map__15159__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table15161.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (map__15159,map__15159__$1,opts,slick_grid_event_handlers){
return (function (_15163){
var self__ = this;
var _15163__$1 = this;
return self__.meta15162;
});})(map__15159,map__15159__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table15161.prototype.om$core$IRenderState$ = true;

hatti.views.table.t_hatti$views$table15161.prototype.om$core$IRenderState$render_state$arity$2 = ((function (map__15159,map__15159__$1,opts,slick_grid_event_handlers){
return (function (_,___$1){
var self__ = this;
var ___$2 = this;
var no_data_QMARK_ = cljs.core.empty_QMARK_.call(null,cljs.core.get_in.call(null,self__.app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377)], null)));
var map__15164 = new cljs.core.Keyword(null,"dataset-info","dataset-info",-1196999563).cljs$core$IFn$_invoke$arity$1(self__.app_state);
var map__15164__$1 = ((((!((map__15164 == null)))?((((map__15164.cljs$lang$protocol_mask$partition0$ & (64))) || (map__15164.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__15164):map__15164);
var dataset_info = map__15164__$1;
var num_of_submissions = cljs.core.get.call(null,map__15164__$1,new cljs.core.Keyword(null,"num_of_submissions","num_of_submissions",-1720943091));
var with_info = ((function (no_data_QMARK_,map__15164,map__15164__$1,dataset_info,num_of_submissions,___$2,map__15159,map__15159__$1,opts,slick_grid_event_handlers){
return (function (p1__15157_SHARP_){
return cljs.core.merge.call(null,p1__15157_SHARP_,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"dataset-info","dataset-info",-1196999563),dataset_info], null));
});})(no_data_QMARK_,map__15164,map__15164__$1,dataset_info,num_of_submissions,___$2,map__15159,map__15159__$1,opts,slick_grid_event_handlers))
;
var attrs15166 = om.core.build.call(null,hatti.views.submission_view,with_info.call(null,cljs.core.get_in.call(null,self__.app_state,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"table-page","table-page",1974969102),new cljs.core.Keyword(null,"submission-clicked","submission-clicked",1228953855)], null))),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"opts","opts",155075701),cljs.core.merge.call(null,cljs.core.select_keys.call(null,self__.opts,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"role","role",-736691072),null,new cljs.core.Keyword(null,"delete-record!","delete-record!",1411848194),null], null), null)),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"view","view",1247994814),new cljs.core.Keyword(null,"table","table",-564943036)], null))], null));
return cljs.core.apply.call(null,React.DOM.div,((cljs.core.map_QMARK_.call(null,attrs15166))?sablono.interpreter.attributes.call(null,sablono.util.merge_with_class.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["table-view"], null)], null),attrs15166)):{"className": "table-view"}),cljs.core.remove.call(null,cljs.core.nil_QMARK_,((cljs.core.map_QMARK_.call(null,attrs15166))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret.call(null,om.core.build.call(null,hatti.views.table_header,self__.app_state)),React.DOM.div({"id": hatti.views.table.table_id, "className": "slickgrid"},(((no_data_QMARK_) && ((num_of_submissions === (0))))?React.DOM.span({"className": "empty-state"},"No data"):React.DOM.span(null,React.DOM.i({"className": "fa fa-spinner fa-pulse"}),"Loading...")))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret.call(null,attrs15166),sablono.interpreter.interpret.call(null,om.core.build.call(null,hatti.views.table_header,self__.app_state)),React.DOM.div({"id": hatti.views.table.table_id, "className": "slickgrid"},(((no_data_QMARK_) && ((num_of_submissions === (0))))?React.DOM.span({"className": "empty-state"},"No data"):React.DOM.span(null,React.DOM.i({"className": "fa fa-spinner fa-pulse"}),"Loading...")))], null))));
});})(map__15159,map__15159__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table15161.prototype.om$core$IDidMount$ = true;

hatti.views.table.t_hatti$views$table15161.prototype.om$core$IDidMount$did_mount$arity$1 = ((function (map__15159,map__15159__$1,opts,slick_grid_event_handlers){
return (function (_){
var self__ = this;
var ___$1 = this;
var data = cljs.core.get_in.call(null,self__.app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377)], null));
var temp__4425__auto__ = hatti.views.table.init_grid_BANG_.call(null,data,self__.owner,self__.slick_grid_event_handlers);
if(cljs.core.truth_(temp__4425__auto__)){
var vec__15175 = temp__4425__auto__;
var grid = cljs.core.nth.call(null,vec__15175,(0),null);
var dataview = cljs.core.nth.call(null,vec__15175,(1),null);
return hatti.views.table.handle_table_events.call(null,self__.app_state,grid,dataview);
} else {
return null;
}
});})(map__15159,map__15159__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table15161.prototype.om$core$IWillReceiveProps$ = true;

hatti.views.table.t_hatti$views$table15161.prototype.om$core$IWillReceiveProps$will_receive_props$arity$2 = ((function (map__15159,map__15159__$1,opts,slick_grid_event_handlers){
return (function (_,next_props){
var self__ = this;
var ___$1 = this;

var old_data = cljs.core.get_in.call(null,om.core.get_props.call(null,self__.owner),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377)], null));
var new_data = cljs.core.get_in.call(null,next_props,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377)], null));
var map__15176 = om.core.get_state.call(null,self__.owner);
var map__15176__$1 = ((((!((map__15176 == null)))?((((map__15176.cljs$lang$protocol_mask$partition0$ & (64))) || (map__15176.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__15176):map__15176);
var grid = cljs.core.get.call(null,map__15176__$1,new cljs.core.Keyword(null,"grid","grid",402978600));
var dataview = cljs.core.get.call(null,map__15176__$1,new cljs.core.Keyword(null,"dataview","dataview",91765671));
if(cljs.core.not_EQ_.call(null,old_data,new_data)){
if(cljs.core.empty_QMARK_.call(null,old_data)){
var temp__4425__auto___15179 = hatti.views.table.init_grid_BANG_.call(null,new_data,self__.owner,self__.slick_grid_event_handlers);
if(cljs.core.truth_(temp__4425__auto___15179)){
var vec__15178_15180 = temp__4425__auto___15179;
var grid_15181__$1 = cljs.core.nth.call(null,vec__15178_15180,(0),null);
var dataview_15182__$1 = cljs.core.nth.call(null,vec__15178_15180,(1),null);
hatti.views.table.handle_table_events.call(null,self__.app_state,grid_15181__$1,dataview_15182__$1);
} else {
}
} else {
grid.invalidateAllRows();

dataview.setItems(cljs.core.clj__GT_js.call(null,new_data),hatti.constants._id);

grid.render();
}
} else {
}

return hatti.views.table.freeze_action_column_BANG_.call(null);
});})(map__15159,map__15159__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table15161.getBasis = ((function (map__15159,map__15159__$1,opts,slick_grid_event_handlers){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"app-state","app-state",130568249,null),new cljs.core.Symbol(null,"owner","owner",1247919588,null),new cljs.core.Symbol(null,"p__15158","p__15158",-544951310,null),new cljs.core.Symbol(null,"map__15159","map__15159",-53840470,null),new cljs.core.Symbol(null,"opts","opts",1795607228,null),new cljs.core.Symbol(null,"slick-grid-event-handlers","slick-grid-event-handlers",-664401045,null),new cljs.core.Symbol(null,"meta15162","meta15162",876635064,null)], null);
});})(map__15159,map__15159__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table15161.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table15161.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table15161";

hatti.views.table.t_hatti$views$table15161.cljs$lang$ctorPrWriter = ((function (map__15159,map__15159__$1,opts,slick_grid_event_handlers){
return (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write.call(null,writer__5168__auto__,"hatti.views.table/t_hatti$views$table15161");
});})(map__15159,map__15159__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.__GT_t_hatti$views$table15161 = ((function (map__15159,map__15159__$1,opts,slick_grid_event_handlers){
return (function hatti$views$table$__GT_t_hatti$views$table15161(app_state__$1,owner__$1,p__15158__$1,map__15159__$2,opts__$1,slick_grid_event_handlers__$1,meta15162){
return (new hatti.views.table.t_hatti$views$table15161(app_state__$1,owner__$1,p__15158__$1,map__15159__$2,opts__$1,slick_grid_event_handlers__$1,meta15162));
});})(map__15159,map__15159__$1,opts,slick_grid_event_handlers))
;

}

return (new hatti.views.table.t_hatti$views$table15161(app_state,owner,p__15158,map__15159__$1,opts,slick_grid_event_handlers,cljs.core.PersistentArrayMap.EMPTY));
}));
