// Compiled by ClojureScript 1.9.229 {}
goog.provide('c2.maths');
goog.require('cljs.core');
c2.maths.Pi = Math.PI;
c2.maths.Tau = ((2) * c2.maths.Pi);
c2.maths.e = Math.E;
c2.maths.radians_per_degree = (c2.maths.Pi / (180));
c2.maths.rad = (function c2$maths$rad(x){
return (c2.maths.radians_per_degree * x);
});
c2.maths.deg = (function c2$maths$deg(x){
return (x / c2.maths.radians_per_degree);
});
c2.maths.sin = (function c2$maths$sin(x){
return Math.sin(x);
});
c2.maths.asin = (function c2$maths$asin(x){
return Math.asin(x);
});
c2.maths.cos = (function c2$maths$cos(x){
return Math.cos(x);
});
c2.maths.acos = (function c2$maths$acos(x){
return Math.acos(x);
});
c2.maths.tan = (function c2$maths$tan(x){
return Math.tan(x);
});
c2.maths.atan = (function c2$maths$atan(x){
return Math.atan(x);
});
c2.maths.expt = (function c2$maths$expt(var_args){
var args18804 = [];
var len__7484__auto___18807 = arguments.length;
var i__7485__auto___18808 = (0);
while(true){
if((i__7485__auto___18808 < len__7484__auto___18807)){
args18804.push((arguments[i__7485__auto___18808]));

var G__18809 = (i__7485__auto___18808 + (1));
i__7485__auto___18808 = G__18809;
continue;
} else {
}
break;
}

var G__18806 = args18804.length;
switch (G__18806) {
case 1:
return c2.maths.expt.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.maths.expt.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18804.length)].join('')));

}
});

c2.maths.expt.cljs$core$IFn$_invoke$arity$1 = (function (x){
return Math.exp(x);
});

c2.maths.expt.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return Math.pow(x,y);
});

c2.maths.expt.cljs$lang$maxFixedArity = 2;

c2.maths.sq = (function c2$maths$sq(x){
return c2.maths.expt.call(null,x,(2));
});
c2.maths.sqrt = (function c2$maths$sqrt(x){
return Math.sqrt(x);
});
c2.maths.floor = (function c2$maths$floor(x){
return Math.floor(x);
});
c2.maths.ceil = (function c2$maths$ceil(x){
return Math.ceil(x);
});
c2.maths.abs = (function c2$maths$abs(x){
return Math.abs(x);
});
c2.maths.log = (function c2$maths$log(var_args){
var args18811 = [];
var len__7484__auto___18814 = arguments.length;
var i__7485__auto___18815 = (0);
while(true){
if((i__7485__auto___18815 < len__7484__auto___18814)){
args18811.push((arguments[i__7485__auto___18815]));

var G__18816 = (i__7485__auto___18815 + (1));
i__7485__auto___18815 = G__18816;
continue;
} else {
}
break;
}

var G__18813 = args18811.length;
switch (G__18813) {
case 1:
return c2.maths.log.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.maths.log.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18811.length)].join('')));

}
});

c2.maths.log.cljs$core$IFn$_invoke$arity$1 = (function (x){
return Math.log(x);
});

c2.maths.log.cljs$core$IFn$_invoke$arity$2 = (function (base,x){
return (Math.log(x) / Math.log(base));
});

c2.maths.log.cljs$lang$maxFixedArity = 2;

c2.maths.log10 = (function c2$maths$log10(x){
return (Math.log(x) / Math.LN10);
});
/**
 * Returns 2-vector of min and max elements in xs.
 */
c2.maths.extent = (function c2$maths$extent(xs){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.apply.call(null,cljs.core.min,xs),cljs.core.apply.call(null,cljs.core.max,xs)], null);
});
/**
 * Arithemetic mean of collection
 */
c2.maths.mean = (function c2$maths$mean(xs){
return (cljs.core.reduce.call(null,cljs.core._PLUS_,xs) / cljs.core.count.call(null,xs));
});
/**
 * Median of a collection.
 */
c2.maths.median = (function c2$maths$median(xs){
var sorted = cljs.core.sort.call(null,xs);
var n = cljs.core.count.call(null,xs);
if(cljs.core._EQ_.call(null,n,(1))){
return cljs.core.first.call(null,sorted);
} else {
if(cljs.core.odd_QMARK_.call(null,n)){
return cljs.core.nth.call(null,sorted,((n + (1)) / (2)));
} else {
var mid = (n / (2));
return c2.maths.mean.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.nth.call(null,sorted,c2.maths.floor.call(null,mid)),cljs.core.nth.call(null,sorted,c2.maths.ceil.call(null,mid))], null));

}
}
});
/**
 * Inclusive range; same as core/range, but includes the end.
 */
c2.maths.irange = (function c2$maths$irange(var_args){
var args18818 = [];
var len__7484__auto___18821 = arguments.length;
var i__7485__auto___18822 = (0);
while(true){
if((i__7485__auto___18822 < len__7484__auto___18821)){
args18818.push((arguments[i__7485__auto___18822]));

var G__18823 = (i__7485__auto___18822 + (1));
i__7485__auto___18822 = G__18823;
continue;
} else {
}
break;
}

var G__18820 = args18818.length;
switch (G__18820) {
case 1:
return c2.maths.irange.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.maths.irange.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return c2.maths.irange.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18818.length)].join('')));

}
});

c2.maths.irange.cljs$core$IFn$_invoke$arity$1 = (function (start){
return cljs.core.range.call(null,start);
});

c2.maths.irange.cljs$core$IFn$_invoke$arity$2 = (function (start,end){
return cljs.core.concat.call(null,cljs.core.range.call(null,start,end),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [end], null));
});

c2.maths.irange.cljs$core$IFn$_invoke$arity$3 = (function (start,end,step){
var r = cljs.core.range.call(null,start,end,step);
if((cljs.core.mod.call(null,cljs.core.first.call(null,r),step) === cljs.core.mod.call(null,end,step))){
return cljs.core.concat.call(null,r,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [end], null));
} else {
return r;
}
});

c2.maths.irange.cljs$lang$maxFixedArity = 3;

/**
 * Checks if bottom <= x <= top.
 */
c2.maths.within_QMARK_ = (function c2$maths$within_QMARK_(x,p__18825){
var vec__18829 = p__18825;
var bottom = cljs.core.nth.call(null,vec__18829,(0),null);
var top = cljs.core.nth.call(null,vec__18829,(1),null);
return ((bottom <= x)) && ((x <= top));
});
c2.maths.add = (function c2$maths$add(var_args){
var args__7491__auto__ = [];
var len__7484__auto___18833 = arguments.length;
var i__7485__auto___18834 = (0);
while(true){
if((i__7485__auto___18834 < len__7484__auto___18833)){
args__7491__auto__.push((arguments[i__7485__auto___18834]));

var G__18835 = (i__7485__auto___18834 + (1));
i__7485__auto___18834 = G__18835;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((0) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((0)),(0),null)):null);
return c2.maths.add.cljs$core$IFn$_invoke$arity$variadic(argseq__7492__auto__);
});

c2.maths.add.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return cljs.core.reduce.call(null,(function (A,B){
if((typeof A === 'number') && (typeof B === 'number')){
return (A + B);
} else {
if((cljs.core.coll_QMARK_.call(null,A)) && (cljs.core.coll_QMARK_.call(null,B))){
return cljs.core.map.call(null,cljs.core._PLUS_,A,B);
} else {
if((typeof A === 'number') && (cljs.core.coll_QMARK_.call(null,B))){
return cljs.core.map.call(null,cljs.core._PLUS_,cljs.core.replicate.call(null,cljs.core.count.call(null,B),A),B);
} else {
if((cljs.core.coll_QMARK_.call(null,A)) && (typeof B === 'number')){
return cljs.core.map.call(null,cljs.core._PLUS_,A,cljs.core.replicate.call(null,cljs.core.count.call(null,A),B));
} else {
return null;
}
}
}
}
}),args);
});

c2.maths.add.cljs$lang$maxFixedArity = (0);

c2.maths.add.cljs$lang$applyTo = (function (seq18832){
return c2.maths.add.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq18832));
});

c2.maths.sub = (function c2$maths$sub(var_args){
var args__7491__auto__ = [];
var len__7484__auto___18837 = arguments.length;
var i__7485__auto___18838 = (0);
while(true){
if((i__7485__auto___18838 < len__7484__auto___18837)){
args__7491__auto__.push((arguments[i__7485__auto___18838]));

var G__18839 = (i__7485__auto___18838 + (1));
i__7485__auto___18838 = G__18839;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((0) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((0)),(0),null)):null);
return c2.maths.sub.cljs$core$IFn$_invoke$arity$variadic(argseq__7492__auto__);
});

c2.maths.sub.cljs$core$IFn$_invoke$arity$variadic = (function (args){
if(cljs.core._EQ_.call(null,cljs.core.count.call(null,args),(1))){
if((typeof (0) === 'number') && (typeof cljs.core.first.call(null,args) === 'number')){
return ((0) - cljs.core.first.call(null,args));
} else {
if((cljs.core.coll_QMARK_.call(null,(0))) && (cljs.core.coll_QMARK_.call(null,cljs.core.first.call(null,args)))){
return cljs.core.map.call(null,cljs.core._,(0),cljs.core.first.call(null,args));
} else {
if((typeof (0) === 'number') && (cljs.core.coll_QMARK_.call(null,cljs.core.first.call(null,args)))){
return cljs.core.map.call(null,cljs.core._,cljs.core.replicate.call(null,cljs.core.count.call(null,cljs.core.first.call(null,args)),(0)),cljs.core.first.call(null,args));
} else {
if((cljs.core.coll_QMARK_.call(null,(0))) && (typeof cljs.core.first.call(null,args) === 'number')){
return cljs.core.map.call(null,cljs.core._,(0),cljs.core.replicate.call(null,cljs.core.count.call(null,(0)),cljs.core.first.call(null,args)));
} else {
return null;
}
}
}
}
} else {
return cljs.core.reduce.call(null,(function (A,B){
if((typeof A === 'number') && (typeof B === 'number')){
return (A - B);
} else {
if((cljs.core.coll_QMARK_.call(null,A)) && (cljs.core.coll_QMARK_.call(null,B))){
return cljs.core.map.call(null,cljs.core._,A,B);
} else {
if((typeof A === 'number') && (cljs.core.coll_QMARK_.call(null,B))){
return cljs.core.map.call(null,cljs.core._,cljs.core.replicate.call(null,cljs.core.count.call(null,B),A),B);
} else {
if((cljs.core.coll_QMARK_.call(null,A)) && (typeof B === 'number')){
return cljs.core.map.call(null,cljs.core._,A,cljs.core.replicate.call(null,cljs.core.count.call(null,A),B));
} else {
return null;
}
}
}
}
}),args);
}
});

c2.maths.sub.cljs$lang$maxFixedArity = (0);

c2.maths.sub.cljs$lang$applyTo = (function (seq18836){
return c2.maths.sub.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq18836));
});

c2.maths.mul = (function c2$maths$mul(var_args){
var args__7491__auto__ = [];
var len__7484__auto___18841 = arguments.length;
var i__7485__auto___18842 = (0);
while(true){
if((i__7485__auto___18842 < len__7484__auto___18841)){
args__7491__auto__.push((arguments[i__7485__auto___18842]));

var G__18843 = (i__7485__auto___18842 + (1));
i__7485__auto___18842 = G__18843;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((0) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((0)),(0),null)):null);
return c2.maths.mul.cljs$core$IFn$_invoke$arity$variadic(argseq__7492__auto__);
});

c2.maths.mul.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return cljs.core.reduce.call(null,(function (A,B){
if((typeof A === 'number') && (typeof B === 'number')){
return (A * B);
} else {
if((cljs.core.coll_QMARK_.call(null,A)) && (cljs.core.coll_QMARK_.call(null,B))){
return cljs.core.map.call(null,cljs.core._STAR_,A,B);
} else {
if((typeof A === 'number') && (cljs.core.coll_QMARK_.call(null,B))){
return cljs.core.map.call(null,cljs.core._STAR_,cljs.core.replicate.call(null,cljs.core.count.call(null,B),A),B);
} else {
if((cljs.core.coll_QMARK_.call(null,A)) && (typeof B === 'number')){
return cljs.core.map.call(null,cljs.core._STAR_,A,cljs.core.replicate.call(null,cljs.core.count.call(null,A),B));
} else {
return null;
}
}
}
}
}),args);
});

c2.maths.mul.cljs$lang$maxFixedArity = (0);

c2.maths.mul.cljs$lang$applyTo = (function (seq18840){
return c2.maths.mul.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq18840));
});

c2.maths.div = (function c2$maths$div(var_args){
var args__7491__auto__ = [];
var len__7484__auto___18845 = arguments.length;
var i__7485__auto___18846 = (0);
while(true){
if((i__7485__auto___18846 < len__7484__auto___18845)){
args__7491__auto__.push((arguments[i__7485__auto___18846]));

var G__18847 = (i__7485__auto___18846 + (1));
i__7485__auto___18846 = G__18847;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((0) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((0)),(0),null)):null);
return c2.maths.div.cljs$core$IFn$_invoke$arity$variadic(argseq__7492__auto__);
});

c2.maths.div.cljs$core$IFn$_invoke$arity$variadic = (function (args){
if(cljs.core._EQ_.call(null,cljs.core.count.call(null,args),(1))){
if((typeof (1) === 'number') && (typeof cljs.core.first.call(null,args) === 'number')){
return ((1) / cljs.core.first.call(null,args));
} else {
if((cljs.core.coll_QMARK_.call(null,(1))) && (cljs.core.coll_QMARK_.call(null,cljs.core.first.call(null,args)))){
return cljs.core.map.call(null,cljs.core._SLASH_,(1),cljs.core.first.call(null,args));
} else {
if((typeof (1) === 'number') && (cljs.core.coll_QMARK_.call(null,cljs.core.first.call(null,args)))){
return cljs.core.map.call(null,cljs.core._SLASH_,cljs.core.replicate.call(null,cljs.core.count.call(null,cljs.core.first.call(null,args)),(1)),cljs.core.first.call(null,args));
} else {
if((cljs.core.coll_QMARK_.call(null,(1))) && (typeof cljs.core.first.call(null,args) === 'number')){
return cljs.core.map.call(null,cljs.core._SLASH_,(1),cljs.core.replicate.call(null,cljs.core.count.call(null,(1)),cljs.core.first.call(null,args)));
} else {
return null;
}
}
}
}
} else {
return cljs.core.reduce.call(null,(function (A,B){
if((typeof A === 'number') && (typeof B === 'number')){
return (A / B);
} else {
if((cljs.core.coll_QMARK_.call(null,A)) && (cljs.core.coll_QMARK_.call(null,B))){
return cljs.core.map.call(null,cljs.core._SLASH_,A,B);
} else {
if((typeof A === 'number') && (cljs.core.coll_QMARK_.call(null,B))){
return cljs.core.map.call(null,cljs.core._SLASH_,cljs.core.replicate.call(null,cljs.core.count.call(null,B),A),B);
} else {
if((cljs.core.coll_QMARK_.call(null,A)) && (typeof B === 'number')){
return cljs.core.map.call(null,cljs.core._SLASH_,A,cljs.core.replicate.call(null,cljs.core.count.call(null,A),B));
} else {
return null;
}
}
}
}
}),args);
}
});

c2.maths.div.cljs$lang$maxFixedArity = (0);

c2.maths.div.cljs$lang$applyTo = (function (seq18844){
return c2.maths.div.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq18844));
});

/**
 * Returns the quantiles of a dataset.
 * 
 * Kwargs:
 * 
 *   > *:probs*: ntiles of the data to return, defaults to `[0 0.25 0.5 0.75 1]`
 * 
 *   Algorithm is the same as R's quantile type=7.
 *   Transcribed from Jason Davies; https://github.com/jasondavies/science.js/blob/master/src/stats/quantiles.js
 */
c2.maths.quantile = (function c2$maths$quantile(var_args){
var args__7491__auto__ = [];
var len__7484__auto___18857 = arguments.length;
var i__7485__auto___18858 = (0);
while(true){
if((i__7485__auto___18858 < len__7484__auto___18857)){
args__7491__auto__.push((arguments[i__7485__auto___18858]));

var G__18859 = (i__7485__auto___18858 + (1));
i__7485__auto___18858 = G__18859;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return c2.maths.quantile.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

c2.maths.quantile.cljs$core$IFn$_invoke$arity$variadic = (function (data,p__18850){
var map__18851 = p__18850;
var map__18851__$1 = ((((!((map__18851 == null)))?((((map__18851.cljs$lang$protocol_mask$partition0$ & (64))) || (map__18851.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__18851):map__18851);
var probs = cljs.core.get.call(null,map__18851__$1,new cljs.core.Keyword(null,"probs","probs",-1201894224),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),0.25,0.5,0.75,(1)], null));
var xs = cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,cljs.core.sort.call(null,data));
var n_1 = (cljs.core.count.call(null,xs) - (1));
var iter__7189__auto__ = ((function (xs,n_1,map__18851,map__18851__$1,probs){
return (function c2$maths$iter__18853(s__18854){
return (new cljs.core.LazySeq(null,((function (xs,n_1,map__18851,map__18851__$1,probs){
return (function (){
var s__18854__$1 = s__18854;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__18854__$1);
if(temp__4657__auto__){
var s__18854__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__18854__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__18854__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__18856 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__18855 = (0);
while(true){
if((i__18855 < size__7188__auto__)){
var q = cljs.core._nth.call(null,c__7187__auto__,i__18855);
cljs.core.chunk_append.call(null,b__18856,(function (){var index = ((q * n_1) + (1));
var lo = (c2.maths.floor.call(null,index) | (0));
var h = (index - lo);
var a = xs.call(null,(lo - (1)));
if(cljs.core._EQ_.call(null,h,(0))){
return a;
} else {
return (a + (h * (xs.call(null,lo) - a)));
}
})());

var G__18860 = (i__18855 + (1));
i__18855 = G__18860;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__18856),c2$maths$iter__18853.call(null,cljs.core.chunk_rest.call(null,s__18854__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__18856),null);
}
} else {
var q = cljs.core.first.call(null,s__18854__$2);
return cljs.core.cons.call(null,(function (){var index = ((q * n_1) + (1));
var lo = (c2.maths.floor.call(null,index) | (0));
var h = (index - lo);
var a = xs.call(null,(lo - (1)));
if(cljs.core._EQ_.call(null,h,(0))){
return a;
} else {
return (a + (h * (xs.call(null,lo) - a)));
}
})(),c2$maths$iter__18853.call(null,cljs.core.rest.call(null,s__18854__$2)));
}
} else {
return null;
}
break;
}
});})(xs,n_1,map__18851,map__18851__$1,probs))
,null,null));
});})(xs,n_1,map__18851,map__18851__$1,probs))
;
return iter__7189__auto__.call(null,probs);
});

c2.maths.quantile.cljs$lang$maxFixedArity = (1);

c2.maths.quantile.cljs$lang$applyTo = (function (seq18848){
var G__18849 = cljs.core.first.call(null,seq18848);
var seq18848__$1 = cljs.core.next.call(null,seq18848);
return c2.maths.quantile.cljs$core$IFn$_invoke$arity$variadic(G__18849,seq18848__$1);
});

