// Compiled by ClojureScript 1.9.229 {:static-fns true, :optimize-constants true}
goog.provide('sablono.core');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('clojure.walk');
goog.require('sablono.util');
goog.require('sablono.interpreter');
goog.require('goog.dom');
/**
 * Add an optional attribute argument to a function that returns a element vector.
 */
sablono.core.wrap_attrs = (function sablono$core$wrap_attrs(func){
return (function() { 
var G__33261__delegate = function (args){
if(cljs.core.map_QMARK_(cljs.core.first(args))){
var vec__33258 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(func,cljs.core.rest(args));
var seq__33259 = cljs.core.seq(vec__33258);
var first__33260 = cljs.core.first(seq__33259);
var seq__33259__$1 = cljs.core.next(seq__33259);
var tag = first__33260;
var body = seq__33259__$1;
if(cljs.core.map_QMARK_(cljs.core.first(body))){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$4(cljs.core.vector,tag,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.first(body),cljs.core.first(args)], 0)),cljs.core.rest(body));
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$4(cljs.core.vector,tag,cljs.core.first(args),body);
}
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(func,args);
}
};
var G__33261 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__33262__i = 0, G__33262__a = new Array(arguments.length -  0);
while (G__33262__i < G__33262__a.length) {G__33262__a[G__33262__i] = arguments[G__33262__i + 0]; ++G__33262__i;}
  args = new cljs.core.IndexedSeq(G__33262__a,0);
} 
return G__33261__delegate.call(this,args);};
G__33261.cljs$lang$maxFixedArity = 0;
G__33261.cljs$lang$applyTo = (function (arglist__33263){
var args = cljs.core.seq(arglist__33263);
return G__33261__delegate(args);
});
G__33261.cljs$core$IFn$_invoke$arity$variadic = G__33261__delegate;
return G__33261;
})()
;
});
sablono.core.update_arglists = (function sablono$core$update_arglists(arglists){
var iter__7189__auto__ = (function sablono$core$update_arglists_$_iter__33270(s__33271){
return (new cljs.core.LazySeq(null,(function (){
var s__33271__$1 = s__33271;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__33271__$1);
if(temp__4657__auto__){
var s__33271__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__33271__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__33271__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__33273 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__33272 = (0);
while(true){
if((i__33272 < size__7188__auto__)){
var args = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__33272);
cljs.core.chunk_append(b__33273,cljs.core.vec(cljs.core.cons(cljs.core.cst$sym$attr_DASH_map_QMARK_,args)));

var G__33276 = (i__33272 + (1));
i__33272 = G__33276;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__33273),sablono$core$update_arglists_$_iter__33270(cljs.core.chunk_rest(s__33271__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__33273),null);
}
} else {
var args = cljs.core.first(s__33271__$2);
return cljs.core.cons(cljs.core.vec(cljs.core.cons(cljs.core.cst$sym$attr_DASH_map_QMARK_,args)),sablono$core$update_arglists_$_iter__33270(cljs.core.rest(s__33271__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__(arglists);
});
/**
 * Render `element` as HTML string.
 */
sablono.core.render = (function sablono$core$render(element){
if(cljs.core.truth_(element)){
return React.renderToString(element);
} else {
return null;
}
});
/**
 * Render `element` as HTML string, without React internal attributes.
 */
sablono.core.render_static = (function sablono$core$render_static(element){
if(cljs.core.truth_(element)){
return React.renderToStaticMarkup(element);
} else {
return null;
}
});
/**
 * Include a list of external stylesheet files.
 */
sablono.core.include_css = (function sablono$core$include_css(var_args){
var args__7491__auto__ = [];
var len__7484__auto___33284 = arguments.length;
var i__7485__auto___33285 = (0);
while(true){
if((i__7485__auto___33285 < len__7484__auto___33284)){
args__7491__auto__.push((arguments[i__7485__auto___33285]));

var G__33286 = (i__7485__auto___33285 + (1));
i__7485__auto___33285 = G__33286;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((0) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((0)),(0),null)):null);
return sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic(argseq__7492__auto__);
});

sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic = (function (styles){
var iter__7189__auto__ = (function sablono$core$iter__33278(s__33279){
return (new cljs.core.LazySeq(null,(function (){
var s__33279__$1 = s__33279;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__33279__$1);
if(temp__4657__auto__){
var s__33279__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__33279__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__33279__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__33281 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__33280 = (0);
while(true){
if((i__33280 < size__7188__auto__)){
var style = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__33280);
cljs.core.chunk_append(b__33281,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$link,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$type,"text/css",cljs.core.cst$kw$href,sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([style], 0)),cljs.core.cst$kw$rel,"stylesheet"], null)], null));

var G__33287 = (i__33280 + (1));
i__33280 = G__33287;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__33281),sablono$core$iter__33278(cljs.core.chunk_rest(s__33279__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__33281),null);
}
} else {
var style = cljs.core.first(s__33279__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$link,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$type,"text/css",cljs.core.cst$kw$href,sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([style], 0)),cljs.core.cst$kw$rel,"stylesheet"], null)], null),sablono$core$iter__33278(cljs.core.rest(s__33279__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__(styles);
});

sablono.core.include_css.cljs$lang$maxFixedArity = (0);

sablono.core.include_css.cljs$lang$applyTo = (function (seq33277){
return sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq33277));
});

/**
 * Include the JavaScript library at `src`.
 */
sablono.core.include_js = (function sablono$core$include_js(src){
var G__33292 = goog.dom.getDocument().body;
var G__33293 = (function (){var G__33294 = "script";
var G__33295 = ({"src": src});
return goog.dom.createDom(G__33294,G__33295);
})();
return goog.dom.appendChild(G__33292,G__33293);
});
/**
 * Include Facebook's React JavaScript library.
 */
sablono.core.include_react = (function sablono$core$include_react(){
return sablono.core.include_js("http://fb.me/react-0.12.2.js");
});
/**
 * Wraps some content in a HTML hyperlink with the supplied URL.
 */
sablono.core.link_to33296 = (function sablono$core$link_to33296(var_args){
var args__7491__auto__ = [];
var len__7484__auto___33299 = arguments.length;
var i__7485__auto___33300 = (0);
while(true){
if((i__7485__auto___33300 < len__7484__auto___33299)){
args__7491__auto__.push((arguments[i__7485__auto___33300]));

var G__33301 = (i__7485__auto___33300 + (1));
i__7485__auto___33300 = G__33301;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return sablono.core.link_to33296.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

sablono.core.link_to33296.cljs$core$IFn$_invoke$arity$variadic = (function (url,content){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$href,sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([url], 0))], null),content], null);
});

sablono.core.link_to33296.cljs$lang$maxFixedArity = (1);

sablono.core.link_to33296.cljs$lang$applyTo = (function (seq33297){
var G__33298 = cljs.core.first(seq33297);
var seq33297__$1 = cljs.core.next(seq33297);
return sablono.core.link_to33296.cljs$core$IFn$_invoke$arity$variadic(G__33298,seq33297__$1);
});


sablono.core.link_to = sablono.core.wrap_attrs(sablono.core.link_to33296);
/**
 * Wraps some content in a HTML hyperlink with the supplied e-mail
 *   address. If no content provided use the e-mail address as content.
 */
sablono.core.mail_to33302 = (function sablono$core$mail_to33302(var_args){
var args__7491__auto__ = [];
var len__7484__auto___33309 = arguments.length;
var i__7485__auto___33310 = (0);
while(true){
if((i__7485__auto___33310 < len__7484__auto___33309)){
args__7491__auto__.push((arguments[i__7485__auto___33310]));

var G__33311 = (i__7485__auto___33310 + (1));
i__7485__auto___33310 = G__33311;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return sablono.core.mail_to33302.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

sablono.core.mail_to33302.cljs$core$IFn$_invoke$arity$variadic = (function (e_mail,p__33305){
var vec__33306 = p__33305;
var content = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33306,(0),null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$href,[cljs.core.str("mailto:"),cljs.core.str(e_mail)].join('')], null),(function (){var or__6409__auto__ = content;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return e_mail;
}
})()], null);
});

sablono.core.mail_to33302.cljs$lang$maxFixedArity = (1);

sablono.core.mail_to33302.cljs$lang$applyTo = (function (seq33303){
var G__33304 = cljs.core.first(seq33303);
var seq33303__$1 = cljs.core.next(seq33303);
return sablono.core.mail_to33302.cljs$core$IFn$_invoke$arity$variadic(G__33304,seq33303__$1);
});


sablono.core.mail_to = sablono.core.wrap_attrs(sablono.core.mail_to33302);
/**
 * Wrap a collection in an unordered list.
 */
sablono.core.unordered_list33312 = (function sablono$core$unordered_list33312(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$ul,(function (){var iter__7189__auto__ = (function sablono$core$unordered_list33312_$_iter__33319(s__33320){
return (new cljs.core.LazySeq(null,(function (){
var s__33320__$1 = s__33320;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__33320__$1);
if(temp__4657__auto__){
var s__33320__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__33320__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__33320__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__33322 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__33321 = (0);
while(true){
if((i__33321 < size__7188__auto__)){
var x = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__33321);
cljs.core.chunk_append(b__33322,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,x], null));

var G__33325 = (i__33321 + (1));
i__33321 = G__33325;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__33322),sablono$core$unordered_list33312_$_iter__33319(cljs.core.chunk_rest(s__33320__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__33322),null);
}
} else {
var x = cljs.core.first(s__33320__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,x], null),sablono$core$unordered_list33312_$_iter__33319(cljs.core.rest(s__33320__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__(coll);
})()], null);
});

sablono.core.unordered_list = sablono.core.wrap_attrs(sablono.core.unordered_list33312);
/**
 * Wrap a collection in an ordered list.
 */
sablono.core.ordered_list33326 = (function sablono$core$ordered_list33326(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$ol,(function (){var iter__7189__auto__ = (function sablono$core$ordered_list33326_$_iter__33333(s__33334){
return (new cljs.core.LazySeq(null,(function (){
var s__33334__$1 = s__33334;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__33334__$1);
if(temp__4657__auto__){
var s__33334__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__33334__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__33334__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__33336 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__33335 = (0);
while(true){
if((i__33335 < size__7188__auto__)){
var x = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__33335);
cljs.core.chunk_append(b__33336,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,x], null));

var G__33339 = (i__33335 + (1));
i__33335 = G__33339;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__33336),sablono$core$ordered_list33326_$_iter__33333(cljs.core.chunk_rest(s__33334__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__33336),null);
}
} else {
var x = cljs.core.first(s__33334__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,x], null),sablono$core$ordered_list33326_$_iter__33333(cljs.core.rest(s__33334__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__(coll);
})()], null);
});

sablono.core.ordered_list = sablono.core.wrap_attrs(sablono.core.ordered_list33326);
/**
 * Create an image element.
 */
sablono.core.image33340 = (function sablono$core$image33340(var_args){
var args33341 = [];
var len__7484__auto___33344 = arguments.length;
var i__7485__auto___33345 = (0);
while(true){
if((i__7485__auto___33345 < len__7484__auto___33344)){
args33341.push((arguments[i__7485__auto___33345]));

var G__33346 = (i__7485__auto___33345 + (1));
i__7485__auto___33345 = G__33346;
continue;
} else {
}
break;
}

var G__33343 = args33341.length;
switch (G__33343) {
case 1:
return sablono.core.image33340.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.image33340.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33341.length)].join('')));

}
});

sablono.core.image33340.cljs$core$IFn$_invoke$arity$1 = (function (src){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$img,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$src,sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([src], 0))], null)], null);
});

sablono.core.image33340.cljs$core$IFn$_invoke$arity$2 = (function (src,alt){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$img,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$src,sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([src], 0)),cljs.core.cst$kw$alt,alt], null)], null);
});

sablono.core.image33340.cljs$lang$maxFixedArity = 2;


sablono.core.image = sablono.core.wrap_attrs(sablono.core.image33340);
sablono.core._STAR_group_STAR_ = cljs.core.PersistentVector.EMPTY;
/**
 * Create a field name from the supplied argument the current field group.
 */
sablono.core.make_name = (function sablono$core$make_name(name){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2((function (p1__33348_SHARP_,p2__33349_SHARP_){
return [cljs.core.str(p1__33348_SHARP_),cljs.core.str("["),cljs.core.str(p2__33349_SHARP_),cljs.core.str("]")].join('');
}),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(sablono.core._STAR_group_STAR_,sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([name], 0))));
});
/**
 * Create a field id from the supplied argument and current field group.
 */
sablono.core.make_id = (function sablono$core$make_id(name){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2((function (p1__33350_SHARP_,p2__33351_SHARP_){
return [cljs.core.str(p1__33350_SHARP_),cljs.core.str("-"),cljs.core.str(p2__33351_SHARP_)].join('');
}),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(sablono.core._STAR_group_STAR_,sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([name], 0))));
});
/**
 * Creates a new <input> element.
 */
sablono.core.input_field_STAR_ = (function sablono$core$input_field_STAR_(type,name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$input,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$type,type,cljs.core.cst$kw$name,sablono.core.make_name(name),cljs.core.cst$kw$id,sablono.core.make_id(name),cljs.core.cst$kw$value,value], null)], null);
});
/**
 * Creates a color input field.
 */
sablono.core.color_field33352 = (function sablono$core$color_field33352(var_args){
var args33353 = [];
var len__7484__auto___33420 = arguments.length;
var i__7485__auto___33421 = (0);
while(true){
if((i__7485__auto___33421 < len__7484__auto___33420)){
args33353.push((arguments[i__7485__auto___33421]));

var G__33422 = (i__7485__auto___33421 + (1));
i__7485__auto___33421 = G__33422;
continue;
} else {
}
break;
}

var G__33355 = args33353.length;
switch (G__33355) {
case 1:
return sablono.core.color_field33352.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.color_field33352.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33353.length)].join('')));

}
});

sablono.core.color_field33352.cljs$core$IFn$_invoke$arity$1 = (function (name__15679__auto__){
return sablono.core.color_field33352.cljs$core$IFn$_invoke$arity$2(name__15679__auto__,null);
});

sablono.core.color_field33352.cljs$core$IFn$_invoke$arity$2 = (function (name__15679__auto__,value__15680__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$color)].join(''),name__15679__auto__,value__15680__auto__);
});

sablono.core.color_field33352.cljs$lang$maxFixedArity = 2;


sablono.core.color_field = sablono.core.wrap_attrs(sablono.core.color_field33352);

/**
 * Creates a date input field.
 */
sablono.core.date_field33356 = (function sablono$core$date_field33356(var_args){
var args33357 = [];
var len__7484__auto___33424 = arguments.length;
var i__7485__auto___33425 = (0);
while(true){
if((i__7485__auto___33425 < len__7484__auto___33424)){
args33357.push((arguments[i__7485__auto___33425]));

var G__33426 = (i__7485__auto___33425 + (1));
i__7485__auto___33425 = G__33426;
continue;
} else {
}
break;
}

var G__33359 = args33357.length;
switch (G__33359) {
case 1:
return sablono.core.date_field33356.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.date_field33356.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33357.length)].join('')));

}
});

sablono.core.date_field33356.cljs$core$IFn$_invoke$arity$1 = (function (name__15679__auto__){
return sablono.core.date_field33356.cljs$core$IFn$_invoke$arity$2(name__15679__auto__,null);
});

sablono.core.date_field33356.cljs$core$IFn$_invoke$arity$2 = (function (name__15679__auto__,value__15680__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$date)].join(''),name__15679__auto__,value__15680__auto__);
});

sablono.core.date_field33356.cljs$lang$maxFixedArity = 2;


sablono.core.date_field = sablono.core.wrap_attrs(sablono.core.date_field33356);

/**
 * Creates a datetime input field.
 */
sablono.core.datetime_field33360 = (function sablono$core$datetime_field33360(var_args){
var args33361 = [];
var len__7484__auto___33428 = arguments.length;
var i__7485__auto___33429 = (0);
while(true){
if((i__7485__auto___33429 < len__7484__auto___33428)){
args33361.push((arguments[i__7485__auto___33429]));

var G__33430 = (i__7485__auto___33429 + (1));
i__7485__auto___33429 = G__33430;
continue;
} else {
}
break;
}

var G__33363 = args33361.length;
switch (G__33363) {
case 1:
return sablono.core.datetime_field33360.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_field33360.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33361.length)].join('')));

}
});

sablono.core.datetime_field33360.cljs$core$IFn$_invoke$arity$1 = (function (name__15679__auto__){
return sablono.core.datetime_field33360.cljs$core$IFn$_invoke$arity$2(name__15679__auto__,null);
});

sablono.core.datetime_field33360.cljs$core$IFn$_invoke$arity$2 = (function (name__15679__auto__,value__15680__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$datetime)].join(''),name__15679__auto__,value__15680__auto__);
});

sablono.core.datetime_field33360.cljs$lang$maxFixedArity = 2;


sablono.core.datetime_field = sablono.core.wrap_attrs(sablono.core.datetime_field33360);

/**
 * Creates a datetime-local input field.
 */
sablono.core.datetime_local_field33364 = (function sablono$core$datetime_local_field33364(var_args){
var args33365 = [];
var len__7484__auto___33432 = arguments.length;
var i__7485__auto___33433 = (0);
while(true){
if((i__7485__auto___33433 < len__7484__auto___33432)){
args33365.push((arguments[i__7485__auto___33433]));

var G__33434 = (i__7485__auto___33433 + (1));
i__7485__auto___33433 = G__33434;
continue;
} else {
}
break;
}

var G__33367 = args33365.length;
switch (G__33367) {
case 1:
return sablono.core.datetime_local_field33364.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_local_field33364.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33365.length)].join('')));

}
});

sablono.core.datetime_local_field33364.cljs$core$IFn$_invoke$arity$1 = (function (name__15679__auto__){
return sablono.core.datetime_local_field33364.cljs$core$IFn$_invoke$arity$2(name__15679__auto__,null);
});

sablono.core.datetime_local_field33364.cljs$core$IFn$_invoke$arity$2 = (function (name__15679__auto__,value__15680__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$datetime_DASH_local)].join(''),name__15679__auto__,value__15680__auto__);
});

sablono.core.datetime_local_field33364.cljs$lang$maxFixedArity = 2;


sablono.core.datetime_local_field = sablono.core.wrap_attrs(sablono.core.datetime_local_field33364);

/**
 * Creates a email input field.
 */
sablono.core.email_field33368 = (function sablono$core$email_field33368(var_args){
var args33369 = [];
var len__7484__auto___33436 = arguments.length;
var i__7485__auto___33437 = (0);
while(true){
if((i__7485__auto___33437 < len__7484__auto___33436)){
args33369.push((arguments[i__7485__auto___33437]));

var G__33438 = (i__7485__auto___33437 + (1));
i__7485__auto___33437 = G__33438;
continue;
} else {
}
break;
}

var G__33371 = args33369.length;
switch (G__33371) {
case 1:
return sablono.core.email_field33368.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.email_field33368.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33369.length)].join('')));

}
});

sablono.core.email_field33368.cljs$core$IFn$_invoke$arity$1 = (function (name__15679__auto__){
return sablono.core.email_field33368.cljs$core$IFn$_invoke$arity$2(name__15679__auto__,null);
});

sablono.core.email_field33368.cljs$core$IFn$_invoke$arity$2 = (function (name__15679__auto__,value__15680__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$email)].join(''),name__15679__auto__,value__15680__auto__);
});

sablono.core.email_field33368.cljs$lang$maxFixedArity = 2;


sablono.core.email_field = sablono.core.wrap_attrs(sablono.core.email_field33368);

/**
 * Creates a file input field.
 */
sablono.core.file_field33372 = (function sablono$core$file_field33372(var_args){
var args33373 = [];
var len__7484__auto___33440 = arguments.length;
var i__7485__auto___33441 = (0);
while(true){
if((i__7485__auto___33441 < len__7484__auto___33440)){
args33373.push((arguments[i__7485__auto___33441]));

var G__33442 = (i__7485__auto___33441 + (1));
i__7485__auto___33441 = G__33442;
continue;
} else {
}
break;
}

var G__33375 = args33373.length;
switch (G__33375) {
case 1:
return sablono.core.file_field33372.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.file_field33372.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33373.length)].join('')));

}
});

sablono.core.file_field33372.cljs$core$IFn$_invoke$arity$1 = (function (name__15679__auto__){
return sablono.core.file_field33372.cljs$core$IFn$_invoke$arity$2(name__15679__auto__,null);
});

sablono.core.file_field33372.cljs$core$IFn$_invoke$arity$2 = (function (name__15679__auto__,value__15680__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$file)].join(''),name__15679__auto__,value__15680__auto__);
});

sablono.core.file_field33372.cljs$lang$maxFixedArity = 2;


sablono.core.file_field = sablono.core.wrap_attrs(sablono.core.file_field33372);

/**
 * Creates a hidden input field.
 */
sablono.core.hidden_field33376 = (function sablono$core$hidden_field33376(var_args){
var args33377 = [];
var len__7484__auto___33444 = arguments.length;
var i__7485__auto___33445 = (0);
while(true){
if((i__7485__auto___33445 < len__7484__auto___33444)){
args33377.push((arguments[i__7485__auto___33445]));

var G__33446 = (i__7485__auto___33445 + (1));
i__7485__auto___33445 = G__33446;
continue;
} else {
}
break;
}

var G__33379 = args33377.length;
switch (G__33379) {
case 1:
return sablono.core.hidden_field33376.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.hidden_field33376.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33377.length)].join('')));

}
});

sablono.core.hidden_field33376.cljs$core$IFn$_invoke$arity$1 = (function (name__15679__auto__){
return sablono.core.hidden_field33376.cljs$core$IFn$_invoke$arity$2(name__15679__auto__,null);
});

sablono.core.hidden_field33376.cljs$core$IFn$_invoke$arity$2 = (function (name__15679__auto__,value__15680__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$hidden)].join(''),name__15679__auto__,value__15680__auto__);
});

sablono.core.hidden_field33376.cljs$lang$maxFixedArity = 2;


sablono.core.hidden_field = sablono.core.wrap_attrs(sablono.core.hidden_field33376);

/**
 * Creates a month input field.
 */
sablono.core.month_field33380 = (function sablono$core$month_field33380(var_args){
var args33381 = [];
var len__7484__auto___33448 = arguments.length;
var i__7485__auto___33449 = (0);
while(true){
if((i__7485__auto___33449 < len__7484__auto___33448)){
args33381.push((arguments[i__7485__auto___33449]));

var G__33450 = (i__7485__auto___33449 + (1));
i__7485__auto___33449 = G__33450;
continue;
} else {
}
break;
}

var G__33383 = args33381.length;
switch (G__33383) {
case 1:
return sablono.core.month_field33380.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.month_field33380.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33381.length)].join('')));

}
});

sablono.core.month_field33380.cljs$core$IFn$_invoke$arity$1 = (function (name__15679__auto__){
return sablono.core.month_field33380.cljs$core$IFn$_invoke$arity$2(name__15679__auto__,null);
});

sablono.core.month_field33380.cljs$core$IFn$_invoke$arity$2 = (function (name__15679__auto__,value__15680__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$month)].join(''),name__15679__auto__,value__15680__auto__);
});

sablono.core.month_field33380.cljs$lang$maxFixedArity = 2;


sablono.core.month_field = sablono.core.wrap_attrs(sablono.core.month_field33380);

/**
 * Creates a number input field.
 */
sablono.core.number_field33384 = (function sablono$core$number_field33384(var_args){
var args33385 = [];
var len__7484__auto___33452 = arguments.length;
var i__7485__auto___33453 = (0);
while(true){
if((i__7485__auto___33453 < len__7484__auto___33452)){
args33385.push((arguments[i__7485__auto___33453]));

var G__33454 = (i__7485__auto___33453 + (1));
i__7485__auto___33453 = G__33454;
continue;
} else {
}
break;
}

var G__33387 = args33385.length;
switch (G__33387) {
case 1:
return sablono.core.number_field33384.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.number_field33384.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33385.length)].join('')));

}
});

sablono.core.number_field33384.cljs$core$IFn$_invoke$arity$1 = (function (name__15679__auto__){
return sablono.core.number_field33384.cljs$core$IFn$_invoke$arity$2(name__15679__auto__,null);
});

sablono.core.number_field33384.cljs$core$IFn$_invoke$arity$2 = (function (name__15679__auto__,value__15680__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$number)].join(''),name__15679__auto__,value__15680__auto__);
});

sablono.core.number_field33384.cljs$lang$maxFixedArity = 2;


sablono.core.number_field = sablono.core.wrap_attrs(sablono.core.number_field33384);

/**
 * Creates a password input field.
 */
sablono.core.password_field33388 = (function sablono$core$password_field33388(var_args){
var args33389 = [];
var len__7484__auto___33456 = arguments.length;
var i__7485__auto___33457 = (0);
while(true){
if((i__7485__auto___33457 < len__7484__auto___33456)){
args33389.push((arguments[i__7485__auto___33457]));

var G__33458 = (i__7485__auto___33457 + (1));
i__7485__auto___33457 = G__33458;
continue;
} else {
}
break;
}

var G__33391 = args33389.length;
switch (G__33391) {
case 1:
return sablono.core.password_field33388.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.password_field33388.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33389.length)].join('')));

}
});

sablono.core.password_field33388.cljs$core$IFn$_invoke$arity$1 = (function (name__15679__auto__){
return sablono.core.password_field33388.cljs$core$IFn$_invoke$arity$2(name__15679__auto__,null);
});

sablono.core.password_field33388.cljs$core$IFn$_invoke$arity$2 = (function (name__15679__auto__,value__15680__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$password)].join(''),name__15679__auto__,value__15680__auto__);
});

sablono.core.password_field33388.cljs$lang$maxFixedArity = 2;


sablono.core.password_field = sablono.core.wrap_attrs(sablono.core.password_field33388);

/**
 * Creates a range input field.
 */
sablono.core.range_field33392 = (function sablono$core$range_field33392(var_args){
var args33393 = [];
var len__7484__auto___33460 = arguments.length;
var i__7485__auto___33461 = (0);
while(true){
if((i__7485__auto___33461 < len__7484__auto___33460)){
args33393.push((arguments[i__7485__auto___33461]));

var G__33462 = (i__7485__auto___33461 + (1));
i__7485__auto___33461 = G__33462;
continue;
} else {
}
break;
}

var G__33395 = args33393.length;
switch (G__33395) {
case 1:
return sablono.core.range_field33392.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.range_field33392.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33393.length)].join('')));

}
});

sablono.core.range_field33392.cljs$core$IFn$_invoke$arity$1 = (function (name__15679__auto__){
return sablono.core.range_field33392.cljs$core$IFn$_invoke$arity$2(name__15679__auto__,null);
});

sablono.core.range_field33392.cljs$core$IFn$_invoke$arity$2 = (function (name__15679__auto__,value__15680__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$range)].join(''),name__15679__auto__,value__15680__auto__);
});

sablono.core.range_field33392.cljs$lang$maxFixedArity = 2;


sablono.core.range_field = sablono.core.wrap_attrs(sablono.core.range_field33392);

/**
 * Creates a search input field.
 */
sablono.core.search_field33396 = (function sablono$core$search_field33396(var_args){
var args33397 = [];
var len__7484__auto___33464 = arguments.length;
var i__7485__auto___33465 = (0);
while(true){
if((i__7485__auto___33465 < len__7484__auto___33464)){
args33397.push((arguments[i__7485__auto___33465]));

var G__33466 = (i__7485__auto___33465 + (1));
i__7485__auto___33465 = G__33466;
continue;
} else {
}
break;
}

var G__33399 = args33397.length;
switch (G__33399) {
case 1:
return sablono.core.search_field33396.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.search_field33396.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33397.length)].join('')));

}
});

sablono.core.search_field33396.cljs$core$IFn$_invoke$arity$1 = (function (name__15679__auto__){
return sablono.core.search_field33396.cljs$core$IFn$_invoke$arity$2(name__15679__auto__,null);
});

sablono.core.search_field33396.cljs$core$IFn$_invoke$arity$2 = (function (name__15679__auto__,value__15680__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$search)].join(''),name__15679__auto__,value__15680__auto__);
});

sablono.core.search_field33396.cljs$lang$maxFixedArity = 2;


sablono.core.search_field = sablono.core.wrap_attrs(sablono.core.search_field33396);

/**
 * Creates a tel input field.
 */
sablono.core.tel_field33400 = (function sablono$core$tel_field33400(var_args){
var args33401 = [];
var len__7484__auto___33468 = arguments.length;
var i__7485__auto___33469 = (0);
while(true){
if((i__7485__auto___33469 < len__7484__auto___33468)){
args33401.push((arguments[i__7485__auto___33469]));

var G__33470 = (i__7485__auto___33469 + (1));
i__7485__auto___33469 = G__33470;
continue;
} else {
}
break;
}

var G__33403 = args33401.length;
switch (G__33403) {
case 1:
return sablono.core.tel_field33400.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.tel_field33400.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33401.length)].join('')));

}
});

sablono.core.tel_field33400.cljs$core$IFn$_invoke$arity$1 = (function (name__15679__auto__){
return sablono.core.tel_field33400.cljs$core$IFn$_invoke$arity$2(name__15679__auto__,null);
});

sablono.core.tel_field33400.cljs$core$IFn$_invoke$arity$2 = (function (name__15679__auto__,value__15680__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$tel)].join(''),name__15679__auto__,value__15680__auto__);
});

sablono.core.tel_field33400.cljs$lang$maxFixedArity = 2;


sablono.core.tel_field = sablono.core.wrap_attrs(sablono.core.tel_field33400);

/**
 * Creates a text input field.
 */
sablono.core.text_field33404 = (function sablono$core$text_field33404(var_args){
var args33405 = [];
var len__7484__auto___33472 = arguments.length;
var i__7485__auto___33473 = (0);
while(true){
if((i__7485__auto___33473 < len__7484__auto___33472)){
args33405.push((arguments[i__7485__auto___33473]));

var G__33474 = (i__7485__auto___33473 + (1));
i__7485__auto___33473 = G__33474;
continue;
} else {
}
break;
}

var G__33407 = args33405.length;
switch (G__33407) {
case 1:
return sablono.core.text_field33404.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_field33404.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33405.length)].join('')));

}
});

sablono.core.text_field33404.cljs$core$IFn$_invoke$arity$1 = (function (name__15679__auto__){
return sablono.core.text_field33404.cljs$core$IFn$_invoke$arity$2(name__15679__auto__,null);
});

sablono.core.text_field33404.cljs$core$IFn$_invoke$arity$2 = (function (name__15679__auto__,value__15680__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$text)].join(''),name__15679__auto__,value__15680__auto__);
});

sablono.core.text_field33404.cljs$lang$maxFixedArity = 2;


sablono.core.text_field = sablono.core.wrap_attrs(sablono.core.text_field33404);

/**
 * Creates a time input field.
 */
sablono.core.time_field33408 = (function sablono$core$time_field33408(var_args){
var args33409 = [];
var len__7484__auto___33476 = arguments.length;
var i__7485__auto___33477 = (0);
while(true){
if((i__7485__auto___33477 < len__7484__auto___33476)){
args33409.push((arguments[i__7485__auto___33477]));

var G__33478 = (i__7485__auto___33477 + (1));
i__7485__auto___33477 = G__33478;
continue;
} else {
}
break;
}

var G__33411 = args33409.length;
switch (G__33411) {
case 1:
return sablono.core.time_field33408.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.time_field33408.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33409.length)].join('')));

}
});

sablono.core.time_field33408.cljs$core$IFn$_invoke$arity$1 = (function (name__15679__auto__){
return sablono.core.time_field33408.cljs$core$IFn$_invoke$arity$2(name__15679__auto__,null);
});

sablono.core.time_field33408.cljs$core$IFn$_invoke$arity$2 = (function (name__15679__auto__,value__15680__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$time)].join(''),name__15679__auto__,value__15680__auto__);
});

sablono.core.time_field33408.cljs$lang$maxFixedArity = 2;


sablono.core.time_field = sablono.core.wrap_attrs(sablono.core.time_field33408);

/**
 * Creates a url input field.
 */
sablono.core.url_field33412 = (function sablono$core$url_field33412(var_args){
var args33413 = [];
var len__7484__auto___33480 = arguments.length;
var i__7485__auto___33481 = (0);
while(true){
if((i__7485__auto___33481 < len__7484__auto___33480)){
args33413.push((arguments[i__7485__auto___33481]));

var G__33482 = (i__7485__auto___33481 + (1));
i__7485__auto___33481 = G__33482;
continue;
} else {
}
break;
}

var G__33415 = args33413.length;
switch (G__33415) {
case 1:
return sablono.core.url_field33412.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.url_field33412.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33413.length)].join('')));

}
});

sablono.core.url_field33412.cljs$core$IFn$_invoke$arity$1 = (function (name__15679__auto__){
return sablono.core.url_field33412.cljs$core$IFn$_invoke$arity$2(name__15679__auto__,null);
});

sablono.core.url_field33412.cljs$core$IFn$_invoke$arity$2 = (function (name__15679__auto__,value__15680__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$url)].join(''),name__15679__auto__,value__15680__auto__);
});

sablono.core.url_field33412.cljs$lang$maxFixedArity = 2;


sablono.core.url_field = sablono.core.wrap_attrs(sablono.core.url_field33412);

/**
 * Creates a week input field.
 */
sablono.core.week_field33416 = (function sablono$core$week_field33416(var_args){
var args33417 = [];
var len__7484__auto___33484 = arguments.length;
var i__7485__auto___33485 = (0);
while(true){
if((i__7485__auto___33485 < len__7484__auto___33484)){
args33417.push((arguments[i__7485__auto___33485]));

var G__33486 = (i__7485__auto___33485 + (1));
i__7485__auto___33485 = G__33486;
continue;
} else {
}
break;
}

var G__33419 = args33417.length;
switch (G__33419) {
case 1:
return sablono.core.week_field33416.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.week_field33416.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33417.length)].join('')));

}
});

sablono.core.week_field33416.cljs$core$IFn$_invoke$arity$1 = (function (name__15679__auto__){
return sablono.core.week_field33416.cljs$core$IFn$_invoke$arity$2(name__15679__auto__,null);
});

sablono.core.week_field33416.cljs$core$IFn$_invoke$arity$2 = (function (name__15679__auto__,value__15680__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$week)].join(''),name__15679__auto__,value__15680__auto__);
});

sablono.core.week_field33416.cljs$lang$maxFixedArity = 2;


sablono.core.week_field = sablono.core.wrap_attrs(sablono.core.week_field33416);
sablono.core.file_upload = sablono.core.file_field;
/**
 * Creates a check box.
 */
sablono.core.check_box33488 = (function sablono$core$check_box33488(var_args){
var args33489 = [];
var len__7484__auto___33492 = arguments.length;
var i__7485__auto___33493 = (0);
while(true){
if((i__7485__auto___33493 < len__7484__auto___33492)){
args33489.push((arguments[i__7485__auto___33493]));

var G__33494 = (i__7485__auto___33493 + (1));
i__7485__auto___33493 = G__33494;
continue;
} else {
}
break;
}

var G__33491 = args33489.length;
switch (G__33491) {
case 1:
return sablono.core.check_box33488.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.check_box33488.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.check_box33488.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33489.length)].join('')));

}
});

sablono.core.check_box33488.cljs$core$IFn$_invoke$arity$1 = (function (name){
return sablono.core.check_box33488.cljs$core$IFn$_invoke$arity$2(name,null);
});

sablono.core.check_box33488.cljs$core$IFn$_invoke$arity$2 = (function (name,checked_QMARK_){
return sablono.core.check_box33488.cljs$core$IFn$_invoke$arity$3(name,checked_QMARK_,"true");
});

sablono.core.check_box33488.cljs$core$IFn$_invoke$arity$3 = (function (name,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$input,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$type,"checkbox",cljs.core.cst$kw$name,sablono.core.make_name(name),cljs.core.cst$kw$id,sablono.core.make_id(name),cljs.core.cst$kw$value,value,cljs.core.cst$kw$checked,checked_QMARK_], null)], null);
});

sablono.core.check_box33488.cljs$lang$maxFixedArity = 3;


sablono.core.check_box = sablono.core.wrap_attrs(sablono.core.check_box33488);
/**
 * Creates a radio button.
 */
sablono.core.radio_button33496 = (function sablono$core$radio_button33496(var_args){
var args33497 = [];
var len__7484__auto___33500 = arguments.length;
var i__7485__auto___33501 = (0);
while(true){
if((i__7485__auto___33501 < len__7484__auto___33500)){
args33497.push((arguments[i__7485__auto___33501]));

var G__33502 = (i__7485__auto___33501 + (1));
i__7485__auto___33501 = G__33502;
continue;
} else {
}
break;
}

var G__33499 = args33497.length;
switch (G__33499) {
case 1:
return sablono.core.radio_button33496.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.radio_button33496.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.radio_button33496.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33497.length)].join('')));

}
});

sablono.core.radio_button33496.cljs$core$IFn$_invoke$arity$1 = (function (group){
return sablono.core.radio_button33496.cljs$core$IFn$_invoke$arity$2(group,null);
});

sablono.core.radio_button33496.cljs$core$IFn$_invoke$arity$2 = (function (group,checked_QMARK_){
return sablono.core.radio_button33496.cljs$core$IFn$_invoke$arity$3(group,checked_QMARK_,"true");
});

sablono.core.radio_button33496.cljs$core$IFn$_invoke$arity$3 = (function (group,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$input,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$type,"radio",cljs.core.cst$kw$name,sablono.core.make_name(group),cljs.core.cst$kw$id,sablono.core.make_id([cljs.core.str(sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([group], 0))),cljs.core.str("-"),cljs.core.str(sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([value], 0)))].join('')),cljs.core.cst$kw$value,value,cljs.core.cst$kw$checked,checked_QMARK_], null)], null);
});

sablono.core.radio_button33496.cljs$lang$maxFixedArity = 3;


sablono.core.radio_button = sablono.core.wrap_attrs(sablono.core.radio_button33496);
/**
 * Creates a seq of option tags from a collection.
 */
sablono.core.select_options33504 = (function sablono$core$select_options33504(var_args){
var args33505 = [];
var len__7484__auto___33526 = arguments.length;
var i__7485__auto___33527 = (0);
while(true){
if((i__7485__auto___33527 < len__7484__auto___33526)){
args33505.push((arguments[i__7485__auto___33527]));

var G__33528 = (i__7485__auto___33527 + (1));
i__7485__auto___33527 = G__33528;
continue;
} else {
}
break;
}

var G__33507 = args33505.length;
switch (G__33507) {
case 1:
return sablono.core.select_options33504.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.select_options33504.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33505.length)].join('')));

}
});

sablono.core.select_options33504.cljs$core$IFn$_invoke$arity$1 = (function (coll){
return sablono.core.select_options33504.cljs$core$IFn$_invoke$arity$2(coll,null);
});

sablono.core.select_options33504.cljs$core$IFn$_invoke$arity$2 = (function (coll,selected){
var iter__7189__auto__ = (function sablono$core$iter__33508(s__33509){
return (new cljs.core.LazySeq(null,(function (){
var s__33509__$1 = s__33509;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__33509__$1);
if(temp__4657__auto__){
var s__33509__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__33509__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__33509__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__33511 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__33510 = (0);
while(true){
if((i__33510 < size__7188__auto__)){
var x = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__33510);
cljs.core.chunk_append(b__33511,((cljs.core.sequential_QMARK_(x))?(function (){var vec__33520 = x;
var text = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33520,(0),null);
var val = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33520,(1),null);
var disabled_QMARK_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33520,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$(disabled_QMARK_);
if(cljs.core.sequential_QMARK_(val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$optgroup,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$label,text], null),sablono.core.select_options33504.cljs$core$IFn$_invoke$arity$2(val,selected)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$option,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$value,val,cljs.core.cst$kw$selected,cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(val,selected),cljs.core.cst$kw$disabled,disabled_QMARK___$1], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$option,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$selected,cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,selected)], null),x], null)));

var G__33530 = (i__33510 + (1));
i__33510 = G__33530;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__33511),sablono$core$iter__33508(cljs.core.chunk_rest(s__33509__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__33511),null);
}
} else {
var x = cljs.core.first(s__33509__$2);
return cljs.core.cons(((cljs.core.sequential_QMARK_(x))?(function (){var vec__33523 = x;
var text = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33523,(0),null);
var val = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33523,(1),null);
var disabled_QMARK_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33523,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$(disabled_QMARK_);
if(cljs.core.sequential_QMARK_(val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$optgroup,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$label,text], null),sablono.core.select_options33504.cljs$core$IFn$_invoke$arity$2(val,selected)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$option,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$value,val,cljs.core.cst$kw$selected,cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(val,selected),cljs.core.cst$kw$disabled,disabled_QMARK___$1], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$option,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$selected,cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,selected)], null),x], null)),sablono$core$iter__33508(cljs.core.rest(s__33509__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__(coll);
});

sablono.core.select_options33504.cljs$lang$maxFixedArity = 2;


sablono.core.select_options = sablono.core.wrap_attrs(sablono.core.select_options33504);
/**
 * Creates a drop-down box using the <select> tag.
 */
sablono.core.drop_down33531 = (function sablono$core$drop_down33531(var_args){
var args33532 = [];
var len__7484__auto___33535 = arguments.length;
var i__7485__auto___33536 = (0);
while(true){
if((i__7485__auto___33536 < len__7484__auto___33535)){
args33532.push((arguments[i__7485__auto___33536]));

var G__33537 = (i__7485__auto___33536 + (1));
i__7485__auto___33536 = G__33537;
continue;
} else {
}
break;
}

var G__33534 = args33532.length;
switch (G__33534) {
case 2:
return sablono.core.drop_down33531.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.drop_down33531.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33532.length)].join('')));

}
});

sablono.core.drop_down33531.cljs$core$IFn$_invoke$arity$2 = (function (name,options){
return sablono.core.drop_down33531.cljs$core$IFn$_invoke$arity$3(name,options,null);
});

sablono.core.drop_down33531.cljs$core$IFn$_invoke$arity$3 = (function (name,options,selected){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$name,sablono.core.make_name(name),cljs.core.cst$kw$id,sablono.core.make_id(name)], null),(sablono.core.select_options.cljs$core$IFn$_invoke$arity$2 ? sablono.core.select_options.cljs$core$IFn$_invoke$arity$2(options,selected) : sablono.core.select_options.call(null,options,selected))], null);
});

sablono.core.drop_down33531.cljs$lang$maxFixedArity = 3;


sablono.core.drop_down = sablono.core.wrap_attrs(sablono.core.drop_down33531);
/**
 * Creates a text area element.
 */
sablono.core.text_area33539 = (function sablono$core$text_area33539(var_args){
var args33540 = [];
var len__7484__auto___33543 = arguments.length;
var i__7485__auto___33544 = (0);
while(true){
if((i__7485__auto___33544 < len__7484__auto___33543)){
args33540.push((arguments[i__7485__auto___33544]));

var G__33545 = (i__7485__auto___33544 + (1));
i__7485__auto___33544 = G__33545;
continue;
} else {
}
break;
}

var G__33542 = args33540.length;
switch (G__33542) {
case 1:
return sablono.core.text_area33539.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_area33539.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33540.length)].join('')));

}
});

sablono.core.text_area33539.cljs$core$IFn$_invoke$arity$1 = (function (name){
return sablono.core.text_area33539.cljs$core$IFn$_invoke$arity$2(name,null);
});

sablono.core.text_area33539.cljs$core$IFn$_invoke$arity$2 = (function (name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$textarea,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$name,sablono.core.make_name(name),cljs.core.cst$kw$id,sablono.core.make_id(name),cljs.core.cst$kw$value,value], null)], null);
});

sablono.core.text_area33539.cljs$lang$maxFixedArity = 2;


sablono.core.text_area = sablono.core.wrap_attrs(sablono.core.text_area33539);
/**
 * Creates a label for an input field with the supplied name.
 */
sablono.core.label33547 = (function sablono$core$label33547(name,text){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$label,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$htmlFor,sablono.core.make_id(name)], null),text], null);
});

sablono.core.label = sablono.core.wrap_attrs(sablono.core.label33547);
/**
 * Creates a submit button.
 */
sablono.core.submit_button33548 = (function sablono$core$submit_button33548(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$input,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$type,"submit",cljs.core.cst$kw$value,text], null)], null);
});

sablono.core.submit_button = sablono.core.wrap_attrs(sablono.core.submit_button33548);
/**
 * Creates a form reset button.
 */
sablono.core.reset_button33549 = (function sablono$core$reset_button33549(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$input,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$type,"reset",cljs.core.cst$kw$value,text], null)], null);
});

sablono.core.reset_button = sablono.core.wrap_attrs(sablono.core.reset_button33549);
/**
 * Create a form that points to a particular method and route.
 *   e.g. (form-to [:put "/post"]
 *       ...)
 */
sablono.core.form_to33550 = (function sablono$core$form_to33550(var_args){
var args__7491__auto__ = [];
var len__7484__auto___33557 = arguments.length;
var i__7485__auto___33558 = (0);
while(true){
if((i__7485__auto___33558 < len__7484__auto___33557)){
args__7491__auto__.push((arguments[i__7485__auto___33558]));

var G__33559 = (i__7485__auto___33558 + (1));
i__7485__auto___33558 = G__33559;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return sablono.core.form_to33550.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

sablono.core.form_to33550.cljs$core$IFn$_invoke$arity$variadic = (function (p__33553,body){
var vec__33554 = p__33553;
var method = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33554,(0),null);
var action = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33554,(1),null);
var method_str = clojure.string.upper_case(cljs.core.name(method));
var action_uri = sablono.util.to_uri(action);
return cljs.core.vec(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(((cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$get,null,cljs.core.cst$kw$post,null], null), null),method))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$form,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$method,method_str,cljs.core.cst$kw$action,action_uri], null)], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$form,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$method,"POST",cljs.core.cst$kw$action,action_uri], null),(sablono.core.hidden_field.cljs$core$IFn$_invoke$arity$2 ? sablono.core.hidden_field.cljs$core$IFn$_invoke$arity$2("_method",method_str) : sablono.core.hidden_field.call(null,"_method",method_str))], null)),body));
});

sablono.core.form_to33550.cljs$lang$maxFixedArity = (1);

sablono.core.form_to33550.cljs$lang$applyTo = (function (seq33551){
var G__33552 = cljs.core.first(seq33551);
var seq33551__$1 = cljs.core.next(seq33551);
return sablono.core.form_to33550.cljs$core$IFn$_invoke$arity$variadic(G__33552,seq33551__$1);
});


sablono.core.form_to = sablono.core.wrap_attrs(sablono.core.form_to33550);
