// Compiled by ClojureScript 1.9.229 {:static-fns true, :optimize-constants true}
goog.provide('hatti.map.utils');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('hatti.ona.forms');
goog.require('hatti.constants');
goog.require('clojure.string');
goog.require('om.core');
goog.require('hatti.utils');
goog.require('cljs.reader');
hatti.map.utils.ona_styles = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$point,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$normal,({"radius": (6), "fillColor": "#f30", "reset": ({"fillColor": "#f30"}), "color": "#fff", "border": (8), "opacity": 0.5, "fillOpacity": 0.9}),cljs.core.cst$kw$hover,({"fillColor": "#631400"}),cljs.core.cst$kw$clicked,({"fillColor": "#ad2300"})], null),cljs.core.cst$kw$shape,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$normal,({"fillColor": "#f30", "color": "#666", "weight": (3), "dashArray": "3", "fillOpacity": 0.7, "opacity": 0.8}),cljs.core.cst$kw$hover,({"fillColor": "#631400", "color": "#222"}),cljs.core.cst$kw$clicked,({"fillColor": "#ad2300", "color": "#222"})], null),cljs.core.cst$kw$line,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$normal,({"color": "#f30", "opacity": (1), "weight": (6), "reset": ({"color": "#f30"})}),cljs.core.cst$kw$hover,({"color": "#631400"}),cljs.core.cst$kw$clicked,({"color": "#ad2300"})], null)], null);
/**
 * Returns geotype (:point :line or :shape) based on marker.
 */
hatti.map.utils.marker__GT_geotype = (function hatti$map$utils$marker__GT_geotype(marker){
return new cljs.core.PersistentArrayMap(null, 3, ["Point",cljs.core.cst$kw$point,"Polygon",cljs.core.cst$kw$shape,"LineString",cljs.core.cst$kw$line], null).call(null,(((marker["feature"])["geometry"])["type"]));
});
/**
 * Appropriate style given style-type (:normal, :clicked, :hover), and
 * either a leaflet marker or clojurescript keyword (one of :point or :shape).
 */
hatti.map.utils.get_ona_style = (function hatti$map$utils$get_ona_style(marker_or_keyword,style_type){
var kw = (((marker_or_keyword instanceof cljs.core.Keyword))?marker_or_keyword:hatti.map.utils.marker__GT_geotype(marker_or_keyword));
var G__29387 = (kw.cljs$core$IFn$_invoke$arity$1 ? kw.cljs$core$IFn$_invoke$arity$1(hatti.map.utils.ona_styles) : kw.call(null,hatti.map.utils.ona_styles));
return (style_type.cljs$core$IFn$_invoke$arity$1 ? style_type.cljs$core$IFn$_invoke$arity$1(G__29387) : style_type.call(null,G__29387));
});
hatti.map.utils.equivalent_style = (function hatti$map$utils$equivalent_style(s,t){

var sc = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$1(s);
var tc = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$1(t);
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.select_keys(sc,cljs.core.keys(tc)),cljs.core.select_keys(tc,cljs.core.keys(sc)));
});
hatti.map.utils.get_id = (function hatti$map$utils$get_id(marker){
return (((marker["feature"])["properties"])[hatti.constants._id]);
});
hatti.map.utils.get_rank = (function hatti$map$utils$get_rank(marker){
return (((marker["feature"])["properties"])[hatti.constants._rank]);
});
/**
 * Get the style of a marker. Second arg specifies style attribute to get.
 * eg. For marker m1, call like: (get-style m1) or (get-style m1 :fillColor)
 */
hatti.map.utils.get_style = (function hatti$map$utils$get_style(var_args){
var args29388 = [];
var len__7484__auto___29392 = arguments.length;
var i__7485__auto___29393 = (0);
while(true){
if((i__7485__auto___29393 < len__7484__auto___29392)){
args29388.push((arguments[i__7485__auto___29393]));

var G__29394 = (i__7485__auto___29393 + (1));
i__7485__auto___29393 = G__29394;
continue;
} else {
}
break;
}

var G__29390 = args29388.length;
switch (G__29390) {
case 1:
return hatti.map.utils.get_style.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return hatti.map.utils.get_style.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args29388.length)].join('')));

}
});

hatti.map.utils.get_style.cljs$core$IFn$_invoke$arity$1 = (function (marker){
return (marker["options"]);
});

hatti.map.utils.get_style.cljs$core$IFn$_invoke$arity$2 = (function (marker,kw){
var G__29391 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$1(hatti.map.utils.get_style.cljs$core$IFn$_invoke$arity$1(marker));
return (kw.cljs$core$IFn$_invoke$arity$1 ? kw.cljs$core$IFn$_invoke$arity$1(G__29391) : kw.call(null,G__29391));
});

hatti.map.utils.get_style.cljs$lang$maxFixedArity = 2;

/**
 * Check whether a marker is clicked, so it's style can be preserved.
 */
hatti.map.utils.is_clicked_QMARK_ = (function hatti$map$utils$is_clicked_QMARK_(marker){
return hatti.map.utils.equivalent_style(hatti.map.utils.get_style.cljs$core$IFn$_invoke$arity$1(marker),hatti.map.utils.get_ona_style(marker,cljs.core.cst$kw$clicked));
});
/**
 * Apply a style to a marker. Style comes from a function that takes marker.
 */
hatti.map.utils.re_style_marker = (function hatti$map$utils$re_style_marker(marker__GT_style,marker){
var style = (marker__GT_style.cljs$core$IFn$_invoke$arity$1 ? marker__GT_style.cljs$core$IFn$_invoke$arity$1(marker) : marker__GT_style.call(null,marker));
if(cljs.core.truth_(hatti.map.utils.is_clicked_QMARK_(marker))){
return marker.setStyle(cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$reset,style], null)));
} else {
return marker.setStyle(cljs.core.clj__GT_js(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(style,cljs.core.cst$kw$reset,style)));
}
});
/**
 * Reset styles pulls the 'reset' property from within a markers options,
 * clearing styles to default if nothing found.
 */
hatti.map.utils.reset_style = (function hatti$map$utils$reset_style(marker){
var temp__4655__auto__ = ((marker["options"])["reset"]);
if(cljs.core.truth_(temp__4655__auto__)){
var rstyle = temp__4655__auto__;
return marker.setStyle(rstyle);
} else {
return marker.setStyle(hatti.map.utils.get_ona_style(marker,cljs.core.cst$kw$normal));
}
});
/**
 * Looks at the _id in marker, and brings to top if (1) marker clicked or
 * (2) marker's id is selected (via id-selected?)
 */
hatti.map.utils.bring_to_top_if_selected = (function hatti$map$utils$bring_to_top_if_selected(id_selected_QMARK_,marker){
if(cljs.core.truth_((function (){var or__6409__auto__ = hatti.map.utils.is_clicked_QMARK_(marker);
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
var G__29397 = hatti.map.utils.get_id(marker);
return (id_selected_QMARK_.cljs$core$IFn$_invoke$arity$1 ? id_selected_QMARK_.cljs$core$IFn$_invoke$arity$1(G__29397) : id_selected_QMARK_.call(null,G__29397));
}
})())){
return marker.bringToFront();
} else {
return null;
}
});
hatti.map.utils.apply_click_style = (function hatti$map$utils$apply_click_style(marker){
if(cljs.core.truth_(marker)){
marker.bringToFront();

return marker.setStyle(hatti.map.utils.get_ona_style(marker,cljs.core.cst$kw$clicked));
} else {
return null;
}
});
hatti.map.utils.apply_unclick_style = (function hatti$map$utils$apply_unclick_style(marker){
if(cljs.core.truth_(marker)){
return hatti.map.utils.reset_style(marker);
} else {
return null;
}
});
hatti.map.utils.apply_hover_style = (function hatti$map$utils$apply_hover_style(marker){
if(cljs.core.truth_(marker)){
marker.bringToFront();

return marker.setStyle(hatti.map.utils.get_ona_style(marker,cljs.core.cst$kw$hover));
} else {
return null;
}
});
/**
 * Sets the default style on a marker.
 */
hatti.map.utils.clear_all_styles = (function hatti$map$utils$clear_all_styles(var_args){
var args__7491__auto__ = [];
var len__7484__auto___29407 = arguments.length;
var i__7485__auto___29408 = (0);
while(true){
if((i__7485__auto___29408 < len__7484__auto___29407)){
args__7491__auto__.push((arguments[i__7485__auto___29408]));

var G__29409 = (i__7485__auto___29408 + (1));
i__7485__auto___29408 = G__29409;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return hatti.map.utils.clear_all_styles.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

hatti.map.utils.clear_all_styles.cljs$core$IFn$_invoke$arity$variadic = (function (markers,p__29400){
var map__29401 = p__29400;
var map__29401__$1 = ((((!((map__29401 == null)))?((((map__29401.cljs$lang$protocol_mask$partition0$ & (64))) || (map__29401.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29401):map__29401);
var preserve_clicked_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__29401__$1,cljs.core.cst$kw$preserve_DASH_clicked_QMARK_,true);
var seq__29403 = cljs.core.seq(markers);
var chunk__29404 = null;
var count__29405 = (0);
var i__29406 = (0);
while(true){
if((i__29406 < count__29405)){
var marker = chunk__29404.cljs$core$IIndexed$_nth$arity$2(null,i__29406);
if(cljs.core.not((function (){var and__6397__auto__ = preserve_clicked_QMARK_;
if(cljs.core.truth_(and__6397__auto__)){
return hatti.map.utils.is_clicked_QMARK_(marker);
} else {
return and__6397__auto__;
}
})())){
marker.setStyle(hatti.map.utils.get_ona_style(marker,cljs.core.cst$kw$normal));
} else {
}

var G__29410 = seq__29403;
var G__29411 = chunk__29404;
var G__29412 = count__29405;
var G__29413 = (i__29406 + (1));
seq__29403 = G__29410;
chunk__29404 = G__29411;
count__29405 = G__29412;
i__29406 = G__29413;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq(seq__29403);
if(temp__4657__auto__){
var seq__29403__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__29403__$1)){
var c__7220__auto__ = cljs.core.chunk_first(seq__29403__$1);
var G__29414 = cljs.core.chunk_rest(seq__29403__$1);
var G__29415 = c__7220__auto__;
var G__29416 = cljs.core.count(c__7220__auto__);
var G__29417 = (0);
seq__29403 = G__29414;
chunk__29404 = G__29415;
count__29405 = G__29416;
i__29406 = G__29417;
continue;
} else {
var marker = cljs.core.first(seq__29403__$1);
if(cljs.core.not((function (){var and__6397__auto__ = preserve_clicked_QMARK_;
if(cljs.core.truth_(and__6397__auto__)){
return hatti.map.utils.is_clicked_QMARK_(marker);
} else {
return and__6397__auto__;
}
})())){
marker.setStyle(hatti.map.utils.get_ona_style(marker,cljs.core.cst$kw$normal));
} else {
}

var G__29418 = cljs.core.next(seq__29403__$1);
var G__29419 = null;
var G__29420 = (0);
var G__29421 = (0);
seq__29403 = G__29418;
chunk__29404 = G__29419;
count__29405 = G__29420;
i__29406 = G__29421;
continue;
}
} else {
return null;
}
}
break;
}
});

hatti.map.utils.clear_all_styles.cljs$lang$maxFixedArity = (1);

hatti.map.utils.clear_all_styles.cljs$lang$applyTo = (function (seq29398){
var G__29399 = cljs.core.first(seq29398);
var seq29398__$1 = cljs.core.next(seq29398);
return hatti.map.utils.clear_all_styles.cljs$core$IFn$_invoke$arity$variadic(G__29399,seq29398__$1);
});

hatti.map.utils.read_string_or_number = (function hatti$map$utils$read_string_or_number(maybe_s){
if(typeof maybe_s === 'string'){
return cljs.reader.read_string(maybe_s);
} else {
return maybe_s;
}
});
hatti.map.utils.make_feature = (function hatti$map$utils$make_feature(geometry,record_id,index){
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$type,"Feature",cljs.core.cst$kw$properties,cljs.core.PersistentArrayMap.fromArray([cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(hatti.constants._rank),(index + (1)),cljs.core.cst$kw$id,record_id,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(hatti.constants._id),record_id], true, false),cljs.core.cst$kw$geometry,geometry], null);
});
if(typeof hatti.map.utils.get_as_geom !== 'undefined'){
} else {
hatti.map.utils.get_as_geom = (function (){var method_table__7334__auto__ = (function (){var G__29422 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__29422) : cljs.core.atom.call(null,G__29422));
})();
var prefer_table__7335__auto__ = (function (){var G__29423 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__29423) : cljs.core.atom.call(null,G__29423));
})();
var method_cache__7336__auto__ = (function (){var G__29424 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__29424) : cljs.core.atom.call(null,G__29424));
})();
var cached_hierarchy__7337__auto__ = (function (){var G__29425 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__29425) : cljs.core.atom.call(null,G__29425));
})();
var hierarchy__7338__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$hierarchy,cljs.core.get_global_hierarchy());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("hatti.map.utils","get-as-geom"),((function (method_table__7334__auto__,prefer_table__7335__auto__,method_cache__7336__auto__,cached_hierarchy__7337__auto__,hierarchy__7338__auto__){
return (function() { 
var G__29430__delegate = function (record,field,p__29426){
var vec__29427 = p__29426;
var repeat_child_index = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29427,(0),null);
if(cljs.core.truth_(hatti.ona.forms.repeat_QMARK_(field))){
return cljs.core.cst$kw$repeat;
} else {
return cljs.core.cst$kw$default;

}
};
var G__29430 = function (record,field,var_args){
var p__29426 = null;
if (arguments.length > 2) {
var G__29431__i = 0, G__29431__a = new Array(arguments.length -  2);
while (G__29431__i < G__29431__a.length) {G__29431__a[G__29431__i] = arguments[G__29431__i + 2]; ++G__29431__i;}
  p__29426 = new cljs.core.IndexedSeq(G__29431__a,0);
} 
return G__29430__delegate.call(this,record,field,p__29426);};
G__29430.cljs$lang$maxFixedArity = 2;
G__29430.cljs$lang$applyTo = (function (arglist__29432){
var record = cljs.core.first(arglist__29432);
arglist__29432 = cljs.core.next(arglist__29432);
var field = cljs.core.first(arglist__29432);
var p__29426 = cljs.core.rest(arglist__29432);
return G__29430__delegate(record,field,p__29426);
});
G__29430.cljs$core$IFn$_invoke$arity$variadic = G__29430__delegate;
return G__29430;
})()
;})(method_table__7334__auto__,prefer_table__7335__auto__,method_cache__7336__auto__,cached_hierarchy__7337__auto__,hierarchy__7338__auto__))
,cljs.core.cst$kw$default,hierarchy__7338__auto__,method_table__7334__auto__,prefer_table__7335__auto__,method_cache__7336__auto__,cached_hierarchy__7337__auto__));
})();
}
hatti.map.utils.get_as_geom.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$repeat,(function (record,p__29433){
var map__29434 = p__29433;
var map__29434__$1 = ((((!((map__29434 == null)))?((((map__29434.cljs$lang$protocol_mask$partition0$ & (64))) || (map__29434.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29434):map__29434);
var field = map__29434__$1;
var children = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29434__$1,cljs.core.cst$kw$children);
var full_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29434__$1,cljs.core.cst$kw$full_DASH_name);
var iter__7189__auto__ = ((function (map__29434,map__29434__$1,field,children,full_name){
return (function hatti$map$utils$iter__29436(s__29437){
return (new cljs.core.LazySeq(null,((function (map__29434,map__29434__$1,field,children,full_name){
return (function (){
var s__29437__$1 = s__29437;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__29437__$1);
if(temp__4657__auto__){
var s__29437__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__29437__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__29437__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__29439 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__29438 = (0);
while(true){
if((i__29438 < size__7188__auto__)){
var child_record = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__29438);
cljs.core.chunk_append(b__29439,(function (){var iter__7189__auto__ = ((function (i__29438,child_record,c__7187__auto__,size__7188__auto__,b__29439,s__29437__$2,temp__4657__auto__,map__29434,map__29434__$1,field,children,full_name){
return (function hatti$map$utils$iter__29436_$_iter__29454(s__29455){
return (new cljs.core.LazySeq(null,((function (i__29438,child_record,c__7187__auto__,size__7188__auto__,b__29439,s__29437__$2,temp__4657__auto__,map__29434,map__29434__$1,field,children,full_name){
return (function (){
var s__29455__$1 = s__29455;
while(true){
var temp__4657__auto____$1 = cljs.core.seq(s__29455__$1);
if(temp__4657__auto____$1){
var s__29455__$2 = temp__4657__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__29455__$2)){
var c__7187__auto____$1 = cljs.core.chunk_first(s__29455__$2);
var size__7188__auto____$1 = cljs.core.count(c__7187__auto____$1);
var b__29457 = cljs.core.chunk_buffer(size__7188__auto____$1);
if((function (){var i__29456 = (0);
while(true){
if((i__29456 < size__7188__auto____$1)){
var child = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto____$1,i__29456);
cljs.core.chunk_append(b__29457,(hatti.map.utils.get_as_geom.cljs$core$IFn$_invoke$arity$2 ? hatti.map.utils.get_as_geom.cljs$core$IFn$_invoke$arity$2(child_record,child) : hatti.map.utils.get_as_geom.call(null,child_record,child)));

var G__29466 = (i__29456 + (1));
i__29456 = G__29466;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__29457),hatti$map$utils$iter__29436_$_iter__29454(cljs.core.chunk_rest(s__29455__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__29457),null);
}
} else {
var child = cljs.core.first(s__29455__$2);
return cljs.core.cons((hatti.map.utils.get_as_geom.cljs$core$IFn$_invoke$arity$2 ? hatti.map.utils.get_as_geom.cljs$core$IFn$_invoke$arity$2(child_record,child) : hatti.map.utils.get_as_geom.call(null,child_record,child)),hatti$map$utils$iter__29436_$_iter__29454(cljs.core.rest(s__29455__$2)));
}
} else {
return null;
}
break;
}
});})(i__29438,child_record,c__7187__auto__,size__7188__auto__,b__29439,s__29437__$2,temp__4657__auto__,map__29434,map__29434__$1,field,children,full_name))
,null,null));
});})(i__29438,child_record,c__7187__auto__,size__7188__auto__,b__29439,s__29437__$2,temp__4657__auto__,map__29434,map__29434__$1,field,children,full_name))
;
return iter__7189__auto__(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.geofield_QMARK_,children));
})());

var G__29467 = (i__29438 + (1));
i__29438 = G__29467;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__29439),hatti$map$utils$iter__29436(cljs.core.chunk_rest(s__29437__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__29439),null);
}
} else {
var child_record = cljs.core.first(s__29437__$2);
return cljs.core.cons((function (){var iter__7189__auto__ = ((function (child_record,s__29437__$2,temp__4657__auto__,map__29434,map__29434__$1,field,children,full_name){
return (function hatti$map$utils$iter__29436_$_iter__29460(s__29461){
return (new cljs.core.LazySeq(null,((function (child_record,s__29437__$2,temp__4657__auto__,map__29434,map__29434__$1,field,children,full_name){
return (function (){
var s__29461__$1 = s__29461;
while(true){
var temp__4657__auto____$1 = cljs.core.seq(s__29461__$1);
if(temp__4657__auto____$1){
var s__29461__$2 = temp__4657__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__29461__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__29461__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__29463 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__29462 = (0);
while(true){
if((i__29462 < size__7188__auto__)){
var child = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__29462);
cljs.core.chunk_append(b__29463,(hatti.map.utils.get_as_geom.cljs$core$IFn$_invoke$arity$2 ? hatti.map.utils.get_as_geom.cljs$core$IFn$_invoke$arity$2(child_record,child) : hatti.map.utils.get_as_geom.call(null,child_record,child)));

var G__29468 = (i__29462 + (1));
i__29462 = G__29468;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__29463),hatti$map$utils$iter__29436_$_iter__29460(cljs.core.chunk_rest(s__29461__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__29463),null);
}
} else {
var child = cljs.core.first(s__29461__$2);
return cljs.core.cons((hatti.map.utils.get_as_geom.cljs$core$IFn$_invoke$arity$2 ? hatti.map.utils.get_as_geom.cljs$core$IFn$_invoke$arity$2(child_record,child) : hatti.map.utils.get_as_geom.call(null,child_record,child)),hatti$map$utils$iter__29436_$_iter__29460(cljs.core.rest(s__29461__$2)));
}
} else {
return null;
}
break;
}
});})(child_record,s__29437__$2,temp__4657__auto__,map__29434,map__29434__$1,field,children,full_name))
,null,null));
});})(child_record,s__29437__$2,temp__4657__auto__,map__29434,map__29434__$1,field,children,full_name))
;
return iter__7189__auto__(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.geofield_QMARK_,children));
})(),hatti$map$utils$iter__29436(cljs.core.rest(s__29437__$2)));
}
} else {
return null;
}
break;
}
});})(map__29434,map__29434__$1,field,children,full_name))
,null,null));
});})(map__29434,map__29434__$1,field,children,full_name))
;
return iter__7189__auto__(cljs.core.get.cljs$core$IFn$_invoke$arity$2(record,full_name));
}));
hatti.map.utils.get_as_geom.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (record,geofield){
var geotype = new cljs.core.PersistentArrayMap(null, 4, ["geopoint","Point","gps","Point","geoshape","Polygon","geotrace","LineString"], null).call(null,cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(geofield));
var parse = ((function (geotype){
return (function (s){
if((cljs.core.seq(s)) && (cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(s,"n/a"))){
var iter__7189__auto__ = ((function (geotype){
return (function hatti$map$utils$iter__29471(s__29472){
return (new cljs.core.LazySeq(null,((function (geotype){
return (function (){
var s__29472__$1 = s__29472;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__29472__$1);
if(temp__4657__auto__){
var s__29472__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__29472__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__29472__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__29474 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__29473 = (0);
while(true){
if((i__29473 < size__7188__auto__)){
var coord_string = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__29473);
cljs.core.chunk_append(b__29474,(function (){var vec__29483 = clojure.string.split.cljs$core$IFn$_invoke$arity$2(coord_string,/ /);
var lat = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29483,(0),null);
var lng = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29483,(1),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29483,(2),null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29483,(3),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.reader.read_string(lng),cljs.reader.read_string(lat)], null);
})());

var G__29490 = (i__29473 + (1));
i__29473 = G__29490;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__29474),hatti$map$utils$iter__29471(cljs.core.chunk_rest(s__29472__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__29474),null);
}
} else {
var coord_string = cljs.core.first(s__29472__$2);
return cljs.core.cons((function (){var vec__29486 = clojure.string.split.cljs$core$IFn$_invoke$arity$2(coord_string,/ /);
var lat = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29486,(0),null);
var lng = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29486,(1),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29486,(2),null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29486,(3),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.reader.read_string(lng),cljs.reader.read_string(lat)], null);
})(),hatti$map$utils$iter__29471(cljs.core.rest(s__29472__$2)));
}
} else {
return null;
}
break;
}
});})(geotype))
,null,null));
});})(geotype))
;
return iter__7189__auto__(clojure.string.split.cljs$core$IFn$_invoke$arity$2(s,/;/));
} else {
return null;
}
});})(geotype))
;
var coordfn = (function (){var G__29489 = geotype;
switch (G__29489) {
case "Point":
return ((function (G__29489,geotype,parse){
return (function (p1__29469_SHARP_){
return cljs.core.first(parse(p1__29469_SHARP_));
});
;})(G__29489,geotype,parse))

break;
case "LineString":
return parse;

break;
case "Polygon":
return ((function (G__29489,geotype,parse){
return (function (p1__29470_SHARP_){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[parse(p1__29470_SHARP_)],null));
});
;})(G__29489,geotype,parse))

break;
default:
return cljs.core.identity;

}
})();
var value = cljs.core.get.cljs$core$IFn$_invoke$arity$2(record,cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(geofield));
var coords = (coordfn.cljs$core$IFn$_invoke$arity$1 ? coordfn.cljs$core$IFn$_invoke$arity$1(value) : coordfn.call(null,value));
if(cljs.core.truth_(hatti.ona.forms.osm_QMARK_(geofield))){
return cljs.core.cst$kw$geom.cljs$core$IFn$_invoke$arity$1(value);
} else {
if(cljs.core.truth_((function (){var or__6409__auto__ = (coords == null);
if(or__6409__auto__){
return or__6409__auto__;
} else {
return cljs.core.some(cljs.core.nil_QMARK_,coords);
}
})())){
return null;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$type,geotype,cljs.core.cst$kw$coordinates,coords], null);
}
}
}));
/**
 * Given the dataset, and the form schema, get out geojson.
 * Optional specification of field will map that field data to the geom.
 */
hatti.map.utils.as_geojson = (function hatti$map$utils$as_geojson(var_args){
var args29493 = [];
var len__7484__auto___29514 = arguments.length;
var i__7485__auto___29515 = (0);
while(true){
if((i__7485__auto___29515 < len__7484__auto___29514)){
args29493.push((arguments[i__7485__auto___29515]));

var G__29516 = (i__7485__auto___29515 + (1));
i__7485__auto___29515 = G__29516;
continue;
} else {
}
break;
}

var G__29495 = args29493.length;
switch (G__29495) {
case 2:
return hatti.map.utils.as_geojson.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return hatti.map.utils.as_geojson.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args29493.length)].join('')));

}
});

hatti.map.utils.as_geojson.cljs$core$IFn$_invoke$arity$2 = (function (dataset,form){
return hatti.map.utils.as_geojson.cljs$core$IFn$_invoke$arity$3(dataset,form,hatti.ona.forms.default_geofield(form));
});

hatti.map.utils.as_geojson.cljs$core$IFn$_invoke$arity$3 = (function (dataset,form,geofield){
if(cljs.core.truth_(geofield)){
var features = (function (){var iter__7189__auto__ = (function hatti$map$utils$iter__29496(s__29497){
return (new cljs.core.LazySeq(null,(function (){
var s__29497__$1 = s__29497;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__29497__$1);
if(temp__4657__auto__){
var s__29497__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__29497__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__29497__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__29499 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__29498 = (0);
while(true){
if((i__29498 < size__7188__auto__)){
var vec__29508 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__29498);
var idx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29508,(0),null);
var record = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29508,(1),null);
var geom_or_geoms = (hatti.map.utils.get_as_geom.cljs$core$IFn$_invoke$arity$2 ? hatti.map.utils.get_as_geom.cljs$core$IFn$_invoke$arity$2(record,geofield) : hatti.map.utils.get_as_geom.call(null,record,geofield));
if(cljs.core.truth_(geom_or_geoms)){
cljs.core.chunk_append(b__29499,((cljs.core.map_QMARK_(geom_or_geoms))?hatti.map.utils.make_feature(geom_or_geoms,(record.cljs$core$IFn$_invoke$arity$1 ? record.cljs$core$IFn$_invoke$arity$1(hatti.constants._id) : record.call(null,hatti.constants._id)),idx):cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (i__29498,s__29497__$1,geom_or_geoms,vec__29508,idx,record,c__7187__auto__,size__7188__auto__,b__29499,s__29497__$2,temp__4657__auto__){
return (function (p1__29492_SHARP_){
return hatti.map.utils.make_feature(p1__29492_SHARP_,(record.cljs$core$IFn$_invoke$arity$1 ? record.cljs$core$IFn$_invoke$arity$1(hatti.constants._id) : record.call(null,hatti.constants._id)),idx);
});})(i__29498,s__29497__$1,geom_or_geoms,vec__29508,idx,record,c__7187__auto__,size__7188__auto__,b__29499,s__29497__$2,temp__4657__auto__))
,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,cljs.core.flatten(geom_or_geoms)))));

var G__29518 = (i__29498 + (1));
i__29498 = G__29518;
continue;
} else {
var G__29519 = (i__29498 + (1));
i__29498 = G__29519;
continue;
}
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__29499),hatti$map$utils$iter__29496(cljs.core.chunk_rest(s__29497__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__29499),null);
}
} else {
var vec__29511 = cljs.core.first(s__29497__$2);
var idx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29511,(0),null);
var record = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29511,(1),null);
var geom_or_geoms = (hatti.map.utils.get_as_geom.cljs$core$IFn$_invoke$arity$2 ? hatti.map.utils.get_as_geom.cljs$core$IFn$_invoke$arity$2(record,geofield) : hatti.map.utils.get_as_geom.call(null,record,geofield));
if(cljs.core.truth_(geom_or_geoms)){
return cljs.core.cons(((cljs.core.map_QMARK_(geom_or_geoms))?hatti.map.utils.make_feature(geom_or_geoms,(record.cljs$core$IFn$_invoke$arity$1 ? record.cljs$core$IFn$_invoke$arity$1(hatti.constants._id) : record.call(null,hatti.constants._id)),idx):cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (s__29497__$1,geom_or_geoms,vec__29511,idx,record,s__29497__$2,temp__4657__auto__){
return (function (p1__29492_SHARP_){
return hatti.map.utils.make_feature(p1__29492_SHARP_,(record.cljs$core$IFn$_invoke$arity$1 ? record.cljs$core$IFn$_invoke$arity$1(hatti.constants._id) : record.call(null,hatti.constants._id)),idx);
});})(s__29497__$1,geom_or_geoms,vec__29511,idx,record,s__29497__$2,temp__4657__auto__))
,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,cljs.core.flatten(geom_or_geoms)))),hatti$map$utils$iter__29496(cljs.core.rest(s__29497__$2)));
} else {
var G__29520 = cljs.core.rest(s__29497__$2);
s__29497__$1 = G__29520;
continue;
}
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__(hatti.utils.indexed(dataset));
})();
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$type,"FeatureCollection",cljs.core.cst$kw$features,cljs.core.flatten(features)], null);
} else {
return null;
}
});

hatti.map.utils.as_geojson.cljs$lang$maxFixedArity = 3;

/**
 * Creates a leaflet map, rendering it to the dom element with given id.
 */
hatti.map.utils.create_map = (function hatti$map$utils$create_map(id,p__29522){
var map__29525 = p__29522;
var map__29525__$1 = ((((!((map__29525 == null)))?((((map__29525.cljs$lang$protocol_mask$partition0$ & (64))) || (map__29525.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29525):map__29525);
var mapbox_tiles = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29525__$1,cljs.core.cst$kw$mapbox_DASH_tiles);
var include_google_maps_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29525__$1,cljs.core.cst$kw$include_DASH_google_DASH_maps_QMARK_);
var layers = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (map__29525,map__29525__$1,mapbox_tiles,include_google_maps_QMARK_){
return (function (p1__29521_SHARP_){
return L.tileLayer(cljs.core.cst$kw$url.cljs$core$IFn$_invoke$arity$1(p1__29521_SHARP_));
});})(map__29525,map__29525__$1,mapbox_tiles,include_google_maps_QMARK_))
,mapbox_tiles);
var nlayers = cljs.core.zipmap(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$name,mapbox_tiles),layers);
var named_layers = (cljs.core.truth_(include_google_maps_QMARK_)?cljs.core.clj__GT_js(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(nlayers,"Google Satellite",new L.Google)):cljs.core.clj__GT_js(nlayers));
var m = L.map(id,({"layers": cljs.core.first(layers), "zoomControl": false}));
var z = L.control.zoom.call(null,({"position": "bottomleft"}));
z.addTo(m);

L.control.layers.call(null,named_layers,null,({"position": "bottomleft"})).addTo(m);

m.setView([(0),(0)],(1));

return m;
});
/**
 * Mouse events for markers.
 *   On click or arrow, mapped-submission-to-rank events are generated.
 *   On hover, marker is brought to the front and color changed.
 */
hatti.map.utils.register_mouse_events = (function hatti$map$utils$register_mouse_events(feature,marker,event_chan){
marker.on("click",(function (){
if(cljs.core.truth_(hatti.map.utils.is_clicked_QMARK_(marker))){
return null;
} else {
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mapped_DASH_submission_DASH_to_DASH_rank,((feature["properties"])[hatti.constants._rank])], null));
}
}));

marker.on("mouseover",(function (){
if(cljs.core.truth_(hatti.map.utils.is_clicked_QMARK_(marker))){
return null;
} else {
return hatti.map.utils.apply_hover_style(marker);
}
}));

return marker.on("mouseout",(function (){
if(cljs.core.truth_(hatti.map.utils.is_clicked_QMARK_(marker))){
return null;
} else {
return hatti.map.utils.apply_unclick_style(marker);
}
}));
});
/**
 * Re-renders map by invalidating leaflet size.
 * If map is zoomed out beyond layer-bounds, re-zooms to layer.
 */
hatti.map.utils.re_render_map_BANG_ = (function hatti$map$utils$re_render_map_BANG_(leaflet_map,feature_layer){
var map_bounds = leaflet_map.getBounds();
var layer_bounds = feature_layer.getBounds();
leaflet_map.invalidateSize(false);

if(((leaflet_map.getZoom() === (0))) || (cljs.core.not(layer_bounds.contains(map_bounds)))){
return leaflet_map.fitBounds(layer_bounds);
} else {
return null;
}
});
/**
 * Create a map with the given GeoJSON data.
 * Adds mouse events and centers on the geojson features.
 */
hatti.map.utils.load_geo_json = (function hatti$map$utils$load_geo_json(var_args){
var args__7491__auto__ = [];
var len__7484__auto___29539 = arguments.length;
var i__7485__auto___29540 = (0);
while(true){
if((i__7485__auto___29540 < len__7484__auto___29539)){
args__7491__auto__.push((arguments[i__7485__auto___29540]));

var G__29541 = (i__7485__auto___29540 + (1));
i__7485__auto___29540 = G__29541;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((3) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((3)),(0),null)):null);
return hatti.map.utils.load_geo_json.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7492__auto__);
});

hatti.map.utils.load_geo_json.cljs$core$IFn$_invoke$arity$variadic = (function (m,geojson,event_chan,p__29536){
var map__29537 = p__29536;
var map__29537__$1 = ((((!((map__29537 == null)))?((((map__29537.cljs$lang$protocol_mask$partition0$ & (64))) || (map__29537.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29537):map__29537);
var rezoom_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29537__$1,cljs.core.cst$kw$rezoom_QMARK_);
var on_events = ((function (map__29537,map__29537__$1,rezoom_QMARK_){
return (function (p1__29527_SHARP_,p2__29528_SHARP_){
return hatti.map.utils.register_mouse_events(p1__29527_SHARP_,p2__29528_SHARP_,event_chan);
});})(map__29537,map__29537__$1,rezoom_QMARK_))
;
var geometry_type = new cljs.core.PersistentArrayMap(null, 3, ["Point",cljs.core.cst$kw$point,"Polygon",cljs.core.cst$kw$shape,"LineString",cljs.core.cst$kw$line], null).call(null,cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$geometry.cljs$core$IFn$_invoke$arity$1(cljs.core.first(cljs.core.cst$kw$features.cljs$core$IFn$_invoke$arity$1(geojson)))));
var stylefn = ((function (on_events,geometry_type,map__29537,map__29537__$1,rezoom_QMARK_){
return (function (){
return hatti.map.utils.get_ona_style(geometry_type,cljs.core.cst$kw$normal);
});})(on_events,geometry_type,map__29537,map__29537__$1,rezoom_QMARK_))
;
var point__GT_marker = ((function (on_events,geometry_type,stylefn,map__29537,map__29537__$1,rezoom_QMARK_){
return (function (p1__29530_SHARP_,p2__29529_SHARP_){
return L.circleMarker(p2__29529_SHARP_);
});})(on_events,geometry_type,stylefn,map__29537,map__29537__$1,rezoom_QMARK_))
;
var feature_layer = L.geoJson(cljs.core.clj__GT_js(geojson),({"onEachFeature": on_events, "pointToLayer": point__GT_marker, "style": stylefn}));
var ids = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (on_events,geometry_type,stylefn,point__GT_marker,feature_layer,map__29537,map__29537__$1,rezoom_QMARK_){
return (function (p1__29531_SHARP_){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(p1__29531_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$properties,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(hatti.constants._id)], null));
});})(on_events,geometry_type,stylefn,point__GT_marker,feature_layer,map__29537,map__29537__$1,rezoom_QMARK_))
,cljs.core.cst$kw$features.cljs$core$IFn$_invoke$arity$1(geojson));
var markers = feature_layer.getLayers();
if(cljs.core.seq(cljs.core.cst$kw$features.cljs$core$IFn$_invoke$arity$1(geojson))){
if(cljs.core.truth_(rezoom_QMARK_)){
m.fitBounds(feature_layer.getBounds());
} else {
}

feature_layer.addTo(m);
} else {
}

return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$feature_DASH_layer,feature_layer,cljs.core.cst$kw$markers,markers,cljs.core.cst$kw$id_DASH__GT_marker,cljs.core.zipmap(ids,markers)], null);
});

hatti.map.utils.load_geo_json.cljs$lang$maxFixedArity = (3);

hatti.map.utils.load_geo_json.cljs$lang$applyTo = (function (seq29532){
var G__29533 = cljs.core.first(seq29532);
var seq29532__$1 = cljs.core.next(seq29532);
var G__29534 = cljs.core.first(seq29532__$1);
var seq29532__$2 = cljs.core.next(seq29532__$1);
var G__29535 = cljs.core.first(seq29532__$2);
var seq29532__$3 = cljs.core.next(seq29532__$2);
return hatti.map.utils.load_geo_json.cljs$core$IFn$_invoke$arity$variadic(G__29533,G__29534,G__29535,seq29532__$3);
});

/**
 * Creates a mapboxgl map, rendering it to the dom element with given id.
 */
hatti.map.utils.create_mapboxgl_map = (function hatti$map$utils$create_mapboxgl_map(id){
mapboxgl.accessToken = hatti.constants.mapboxgl_access_token;

var Map = mapboxgl.Map;
var Navigation = mapboxgl.Navigation;
var m = (new Map(({"container": id, "style": "mapbox://styles/mapbox/streets-v9"})));
return m.addControl((new Navigation(({"position": "bottom-left"}))));
});
/**
 * Gets query filter and returns filters based on field type
 */
hatti.map.utils.get_filter = (function hatti$map$utils$get_filter(p__29542,flat_form){
var map__29548 = p__29542;
var map__29548__$1 = ((((!((map__29548 == null)))?((((map__29548.cljs$lang$protocol_mask$partition0$ & (64))) || (map__29548.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29548):map__29548);
var column = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29548__$1,cljs.core.cst$kw$column);
var filter = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29548__$1,cljs.core.cst$kw$filter);
var value = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29548__$1,cljs.core.cst$kw$value);
var field = cljs.core.first(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (map__29548,map__29548__$1,column,filter,value){
return (function (p__29550){
var map__29551 = p__29550;
var map__29551__$1 = ((((!((map__29551 == null)))?((((map__29551.cljs$lang$protocol_mask$partition0$ & (64))) || (map__29551.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29551):map__29551);
var full_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29551__$1,cljs.core.cst$kw$full_DASH_name);
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(full_name,column);
});})(map__29548,map__29548__$1,column,filter,value))
,flat_form));
if(cljs.core.truth_(hatti.ona.forms.numeric_QMARK_(field))){
return [cljs.core.str("CAST(json->>'"),cljs.core.str(column),cljs.core.str("' AS INT) "),cljs.core.str(filter),cljs.core.str(" '"),cljs.core.str(value),cljs.core.str("'")].join('');
} else {
if(cljs.core.truth_(hatti.ona.forms.time_based_QMARK_(field))){
return [cljs.core.str("CAST(json->>'"),cljs.core.str(column),cljs.core.str("' AS AS TIMESTAMP) "),cljs.core.str(filter),cljs.core.str(" '"),cljs.core.str(value),cljs.core.str("'")].join('');
} else {
return [cljs.core.str("json->>'"),cljs.core.str(column),cljs.core.str("' "),cljs.core.str(filter),cljs.core.str(" '"),cljs.core.str(value),cljs.core.str("'")].join('');

}
}
});
/**
 * Generates query params filters for filtered datasets 
 */
hatti.map.utils.generate_filter_string = (function hatti$map$utils$generate_filter_string(query,flat_form){
if(cljs.core.truth_(cljs.core.not_empty(query))){
return [cljs.core.str(" and "),cljs.core.str(clojure.string.join.cljs$core$IFn$_invoke$arity$2(" and ",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__29553_SHARP_){
return hatti.map.utils.get_filter(p1__29553_SHARP_,flat_form);
}),query)))].join('');
} else {
return null;
}
});
/**
 * Generates tiles url with appropriate filters as query params
 */
hatti.map.utils.get_tiles_endpoint = (function hatti$map$utils$get_tiles_endpoint(var_args){
var args__7491__auto__ = [];
var len__7484__auto___29563 = arguments.length;
var i__7485__auto___29564 = (0);
while(true){
if((i__7485__auto___29564 < len__7484__auto___29563)){
args__7491__auto__.push((arguments[i__7485__auto___29564]));

var G__29565 = (i__7485__auto___29564 + (1));
i__7485__auto___29564 = G__29565;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((4) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((4)),(0),null)):null);
return hatti.map.utils.get_tiles_endpoint.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__7492__auto__);
});

hatti.map.utils.get_tiles_endpoint.cljs$core$IFn$_invoke$arity$variadic = (function (tiles_server,formid,fields,flat_form,p__29559){
var vec__29560 = p__29559;
var query = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29560,(0),null);
return [cljs.core.str(tiles_server),cljs.core.str(hatti.constants.tiles_endpoint),cljs.core.str("?where=deleted_at is null and xform_id ="),cljs.core.str(formid),cljs.core.str(hatti.map.utils.generate_filter_string(query,flat_form)),cljs.core.str("&fields="),cljs.core.str(clojure.string.join.cljs$core$IFn$_invoke$arity$2(",",fields))].join('');
});

hatti.map.utils.get_tiles_endpoint.cljs$lang$maxFixedArity = (4);

hatti.map.utils.get_tiles_endpoint.cljs$lang$applyTo = (function (seq29554){
var G__29555 = cljs.core.first(seq29554);
var seq29554__$1 = cljs.core.next(seq29554);
var G__29556 = cljs.core.first(seq29554__$1);
var seq29554__$2 = cljs.core.next(seq29554__$1);
var G__29557 = cljs.core.first(seq29554__$2);
var seq29554__$3 = cljs.core.next(seq29554__$2);
var G__29558 = cljs.core.first(seq29554__$3);
var seq29554__$4 = cljs.core.next(seq29554__$3);
return hatti.map.utils.get_tiles_endpoint.cljs$core$IFn$_invoke$arity$variadic(G__29555,G__29556,G__29557,G__29558,seq29554__$4);
});

/**
 * Add map source. This is called with either tiles-url or geoson which
 *   determins the source type (Vector or  GeosJSON). 
 */
hatti.map.utils.add_mapboxgl_source = (function hatti$map$utils$add_mapboxgl_source(map,id_string,p__29566){
var map__29569 = p__29566;
var map__29569__$1 = ((((!((map__29569 == null)))?((((map__29569.cljs$lang$protocol_mask$partition0$ & (64))) || (map__29569.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29569):map__29569);
var tiles_url = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29569__$1,cljs.core.cst$kw$tiles_DASH_url);
var geojson = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29569__$1,cljs.core.cst$kw$geojson);
var tiles = [tiles_url];
var source = (cljs.core.truth_(geojson)?cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$type,"geojson",cljs.core.cst$kw$data,geojson], null)):(cljs.core.truth_(tiles)?({"type": "vector", "tiles": tiles}):null));
if(cljs.core.truth_(map.getSource(id_string))){
return null;
} else {
return map.addSource(id_string,source);
}
});
/**
 * Add map layer from available sources.
 */
hatti.map.utils.add_mapboxgl_layer = (function hatti$map$utils$add_mapboxgl_layer(var_args){
var args__7491__auto__ = [];
var len__7484__auto___29579 = arguments.length;
var i__7485__auto___29580 = (0);
while(true){
if((i__7485__auto___29580 < len__7484__auto___29579)){
args__7491__auto__.push((arguments[i__7485__auto___29580]));

var G__29581 = (i__7485__auto___29580 + (1));
i__7485__auto___29580 = G__29581;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((3) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((3)),(0),null)):null);
return hatti.map.utils.add_mapboxgl_layer.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7492__auto__);
});

hatti.map.utils.add_mapboxgl_layer.cljs$core$IFn$_invoke$arity$variadic = (function (map,id_string,layer_type,p__29575){
var map__29576 = p__29575;
var map__29576__$1 = ((((!((map__29576 == null)))?((((map__29576.cljs$lang$protocol_mask$partition0$ & (64))) || (map__29576.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29576):map__29576);
var layer_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29576__$1,cljs.core.cst$kw$layer_DASH_id);
var layout = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29576__$1,cljs.core.cst$kw$layout);
var paint = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29576__$1,cljs.core.cst$kw$paint);
var l_id = (function (){var or__6409__auto__ = layer_id;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return id_string;
}
})();
var layer_def = new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$id,l_id,cljs.core.cst$kw$type,layer_type,cljs.core.cst$kw$source,id_string,cljs.core.cst$kw$source_DASH_layer,"logger_instance_geom"], null);
var layer = cljs.core.clj__GT_js((function (){var G__29578 = layer_def;
var G__29578__$1 = (cljs.core.truth_(paint)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__29578,cljs.core.cst$kw$paint,paint):G__29578);
if(cljs.core.truth_(layout)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__29578__$1,cljs.core.cst$kw$layout,layout);
} else {
return G__29578__$1;
}
})());
if(cljs.core.truth_(map.getLayer(l_id))){
return null;
} else {
return map.addLayer(layer,id_string);
}
});

hatti.map.utils.add_mapboxgl_layer.cljs$lang$maxFixedArity = (3);

hatti.map.utils.add_mapboxgl_layer.cljs$lang$applyTo = (function (seq29571){
var G__29572 = cljs.core.first(seq29571);
var seq29571__$1 = cljs.core.next(seq29571);
var G__29573 = cljs.core.first(seq29571__$1);
var seq29571__$2 = cljs.core.next(seq29571__$1);
var G__29574 = cljs.core.first(seq29571__$2);
var seq29571__$3 = cljs.core.next(seq29571__$2);
return hatti.map.utils.add_mapboxgl_layer.cljs$core$IFn$_invoke$arity$variadic(G__29572,G__29573,G__29574,seq29571__$3);
});

/**
 * Generates a collection of input - output value pairs known
 * as stops. These stops are used by get-styles function to decide the style
 * output based on an input vaue from the dataset. e.g. _id. By defauly this
 *  function purely generates color stops.
 */
hatti.map.utils.generate_stops = (function hatti$map$utils$generate_stops(selected_id,selected_color){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),"#f30"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [selected_id,selected_color], null)], null);
});
/**
 * Generates cirlce size property stops base on values from dataset.
 */
hatti.map.utils.generate_size_stops = (function hatti$map$utils$generate_size_stops(selected_id,selected_color){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(4)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [selected_id,selected_color], null)], null);
});
/**
 * Gets predefined styles for diffent layer types and states.
 */
hatti.map.utils.get_styles = (function hatti$map$utils$get_styles(var_args){
var args__7491__auto__ = [];
var len__7484__auto___29587 = arguments.length;
var i__7485__auto___29588 = (0);
while(true){
if((i__7485__auto___29588 < len__7484__auto___29587)){
args__7491__auto__.push((arguments[i__7485__auto___29588]));

var G__29589 = (i__7485__auto___29588 + (1));
i__7485__auto___29588 = G__29589;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((0) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((0)),(0),null)):null);
return hatti.map.utils.get_styles.cljs$core$IFn$_invoke$arity$variadic(argseq__7492__auto__);
});

hatti.map.utils.get_styles.cljs$core$IFn$_invoke$arity$variadic = (function (p__29583){
var vec__29584 = p__29583;
var selected_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29584,(0),null);
var stops = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29584,(1),null);
var size_stops = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29584,(2),null);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$point,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$normal,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["circle-color",cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$property,"id",cljs.core.cst$kw$type,"categorical",cljs.core.cst$kw$stops,(cljs.core.truth_(stops)?stops:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),"#f30"], null)], null))], null))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["circle-radius",(4)], null)], null),cljs.core.cst$kw$hover,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["circle-color",cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$property,"id",cljs.core.cst$kw$type,"categorical",cljs.core.cst$kw$stops,hatti.map.utils.generate_stops(selected_id,"#631400")], null))], null)], null),cljs.core.cst$kw$clicked,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["circle-color",cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$property,"id",cljs.core.cst$kw$type,"categorical",cljs.core.cst$kw$stops,hatti.map.utils.generate_stops(selected_id,"#ad2300")], null))], null)], null),cljs.core.cst$kw$sized,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["circle-radius",cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$property,"id",cljs.core.cst$kw$type,"categorical",cljs.core.cst$kw$stops,(cljs.core.truth_(size_stops)?size_stops:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(6)], null)], null))], null))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["circle-opacity",cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$stops,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(3),0.2], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(15),0.8], null)], null)], null))], null)], null)], null),cljs.core.cst$kw$fill,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$normal,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["fill-color",cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$property,"_id",cljs.core.cst$kw$type,"categorical",cljs.core.cst$kw$stops,(cljs.core.truth_(stops)?stops:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),"#f30"], null)], null))], null))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["fill-opacity",0.7], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["fill-outline-color","#666"], null)], null),cljs.core.cst$kw$hover,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["fill-color",cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$property,"_id",cljs.core.cst$kw$type,"categorical",cljs.core.cst$kw$stops,hatti.map.utils.generate_stops(selected_id,"#631400")], null))], null)], null),cljs.core.cst$kw$clicked,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["fill-color",cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$property,"_id",cljs.core.cst$kw$type,"categorical",cljs.core.cst$kw$stops,hatti.map.utils.generate_stops(selected_id,"#ad2300")], null))], null)], null)], null),cljs.core.cst$kw$line,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$normal,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["line-color",cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$property,"_id",cljs.core.cst$kw$type,"categorical",cljs.core.cst$kw$stops,(cljs.core.truth_(stops)?stops:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),"#f30"], null)], null))], null))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["line-opacity",0.8], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["line-width",(7)], null)], null),cljs.core.cst$kw$hover,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["line-color",cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$property,"_id",cljs.core.cst$kw$type,"categorical",cljs.core.cst$kw$stops,hatti.map.utils.generate_stops(selected_id,"#631400")], null))], null)], null),cljs.core.cst$kw$clicked,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["line-color",cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$property,"_id",cljs.core.cst$kw$type,"categorical",cljs.core.cst$kw$stops,hatti.map.utils.generate_stops(selected_id,"#ad2300")], null))], null)], null)], null)], null);
});

hatti.map.utils.get_styles.cljs$lang$maxFixedArity = (0);

hatti.map.utils.get_styles.cljs$lang$applyTo = (function (seq29582){
return hatti.map.utils.get_styles.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq29582));
});

/**
 * Get style properties for layer.
 */
hatti.map.utils.get_style_properties = (function hatti$map$utils$get_style_properties(var_args){
var args__7491__auto__ = [];
var len__7484__auto___29598 = arguments.length;
var i__7485__auto___29599 = (0);
while(true){
if((i__7485__auto___29599 < len__7484__auto___29598)){
args__7491__auto__.push((arguments[i__7485__auto___29599]));

var G__29600 = (i__7485__auto___29599 + (1));
i__7485__auto___29599 = G__29600;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((2) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((2)),(0),null)):null);
return hatti.map.utils.get_style_properties.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7492__auto__);
});

hatti.map.utils.get_style_properties.cljs$core$IFn$_invoke$arity$variadic = (function (style_type,style_state,p__29593){
var map__29594 = p__29593;
var map__29594__$1 = ((((!((map__29594 == null)))?((((map__29594.cljs$lang$protocol_mask$partition0$ & (64))) || (map__29594.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29594):map__29594);
var selected_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29594__$1,cljs.core.cst$kw$selected_DASH_id);
var stops = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29594__$1,cljs.core.cst$kw$stops);
var G__29596 = (function (){var G__29597 = hatti.map.utils.get_styles.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([selected_id,stops], 0));
return (style_type.cljs$core$IFn$_invoke$arity$1 ? style_type.cljs$core$IFn$_invoke$arity$1(G__29597) : style_type.call(null,G__29597));
})();
return (style_state.cljs$core$IFn$_invoke$arity$1 ? style_state.cljs$core$IFn$_invoke$arity$1(G__29596) : style_state.call(null,G__29596));
});

hatti.map.utils.get_style_properties.cljs$lang$maxFixedArity = (2);

hatti.map.utils.get_style_properties.cljs$lang$applyTo = (function (seq29590){
var G__29591 = cljs.core.first(seq29590);
var seq29590__$1 = cljs.core.next(seq29590);
var G__29592 = cljs.core.first(seq29590__$1);
var seq29590__$2 = cljs.core.next(seq29590__$1);
return hatti.map.utils.get_style_properties.cljs$core$IFn$_invoke$arity$variadic(G__29591,G__29592,seq29590__$2);
});

/**
 * Sets maps paint properties given layer-id and list of properties to set.
 *   properties should be a list of properties that contains the propery name
 *   and value in a vector. e.g. [[property1 value1] [property2 value2]
 */
hatti.map.utils.set_mapboxgl_paint_property = (function hatti$map$utils$set_mapboxgl_paint_property(map,layer_id,properties){
var seq__29611 = cljs.core.seq(properties);
var chunk__29612 = null;
var count__29613 = (0);
var i__29614 = (0);
while(true){
if((i__29614 < count__29613)){
var vec__29615 = chunk__29612.cljs$core$IIndexed$_nth$arity$2(null,i__29614);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29615,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29615,(1),null);
map.setPaintProperty(layer_id,p,v);

var G__29621 = seq__29611;
var G__29622 = chunk__29612;
var G__29623 = count__29613;
var G__29624 = (i__29614 + (1));
seq__29611 = G__29621;
chunk__29612 = G__29622;
count__29613 = G__29623;
i__29614 = G__29624;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq(seq__29611);
if(temp__4657__auto__){
var seq__29611__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__29611__$1)){
var c__7220__auto__ = cljs.core.chunk_first(seq__29611__$1);
var G__29625 = cljs.core.chunk_rest(seq__29611__$1);
var G__29626 = c__7220__auto__;
var G__29627 = cljs.core.count(c__7220__auto__);
var G__29628 = (0);
seq__29611 = G__29625;
chunk__29612 = G__29626;
count__29613 = G__29627;
i__29614 = G__29628;
continue;
} else {
var vec__29618 = cljs.core.first(seq__29611__$1);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29618,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29618,(1),null);
map.setPaintProperty(layer_id,p,v);

var G__29629 = cljs.core.next(seq__29611__$1);
var G__29630 = null;
var G__29631 = (0);
var G__29632 = (0);
seq__29611 = G__29629;
chunk__29612 = G__29630;
count__29613 = G__29631;
i__29614 = G__29632;
continue;
}
} else {
return null;
}
}
break;
}
});
hatti.map.utils.get_id_property = (function hatti$map$utils$get_id_property(features){
var properties = (cljs.core.first(features)["properties"]);
var or__6409__auto__ = (properties["id"]);
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return (properties[hatti.constants._id]);
}
});
/**
 * Register map mouse events.
 */
hatti.map.utils.register_mapboxgl_mouse_events = (function hatti$map$utils$register_mapboxgl_mouse_events(owner,map,event_chan,id_string,style){
map.off("mousemove");

map.off("click");

map.on("mousemove",(function (e){
var layer_id = id_string;
var features = map.queryRenderedFeatures(e.point,cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$layers,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [layer_id], null)], null)));
var no_of_features = features.length;
var view_by = om.core.get_props.cljs$core$IFn$_invoke$arity$2(owner,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$map_DASH_page,cljs.core.cst$kw$view_DASH_by], null));
var selected_id = om.core.get_props.cljs$core$IFn$_invoke$arity$2(owner,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$map_DASH_page,cljs.core.cst$kw$submission_DASH_clicked,cljs.core.cst$kw$id], null));
map.getCanvas().style.cursor = (((features.length > (0)))?"pointer":"");

if(cljs.core.truth_(view_by)){
return null;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(no_of_features,(1))){
return hatti.map.utils.set_mapboxgl_paint_property(map,layer_id,hatti.map.utils.get_style_properties.cljs$core$IFn$_invoke$arity$variadic(style,cljs.core.cst$kw$hover,cljs.core.array_seq([cljs.core.cst$kw$selected_DASH_id,hatti.map.utils.get_id_property(features)], 0)));
} else {
hatti.map.utils.set_mapboxgl_paint_property(map,layer_id,hatti.map.utils.get_style_properties(style,cljs.core.cst$kw$normal));

if(cljs.core.truth_(selected_id)){
return hatti.map.utils.set_mapboxgl_paint_property(map,layer_id,hatti.map.utils.get_style_properties.cljs$core$IFn$_invoke$arity$variadic(style,cljs.core.cst$kw$clicked,cljs.core.array_seq([cljs.core.cst$kw$selected_DASH_id,selected_id], 0)));
} else {
return null;
}
}
}
}));

return map.on("click",(function (e){
var layer_id = id_string;
var features = map.queryRenderedFeatures(e.point,cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$layers,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [layer_id], null)], null)));
var no_of_features = features.length;
var view_by = om.core.get_props.cljs$core$IFn$_invoke$arity$2(owner,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$map_DASH_page,cljs.core.cst$kw$view_DASH_by], null));
if((no_of_features > (0))){
var feature_id = hatti.map.utils.get_id_property(features);
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mapped_DASH_submission_DASH_to_DASH_id,feature_id], null));

if(cljs.core.truth_(view_by)){
return null;
} else {
return hatti.map.utils.set_mapboxgl_paint_property(map,layer_id,hatti.map.utils.get_style_properties.cljs$core$IFn$_invoke$arity$variadic(style,cljs.core.cst$kw$clicked,cljs.core.array_seq([cljs.core.cst$kw$selected_DASH_id,feature_id], 0)));
}
} else {
return null;
}
}));
});
/**
 * Fits map boundaries on rendered features.
 */
hatti.map.utils.fitMapBounds = (function hatti$map$utils$fitMapBounds(var_args){
var args__7491__auto__ = [];
var len__7484__auto___29640 = arguments.length;
var i__7485__auto___29641 = (0);
while(true){
if((i__7485__auto___29641 < len__7484__auto___29640)){
args__7491__auto__.push((arguments[i__7485__auto___29641]));

var G__29642 = (i__7485__auto___29641 + (1));
i__7485__auto___29641 = G__29642;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((2) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((2)),(0),null)):null);
return hatti.map.utils.fitMapBounds.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7492__auto__);
});

hatti.map.utils.fitMapBounds.cljs$core$IFn$_invoke$arity$variadic = (function (map,layer_id,p__29636){
var vec__29637 = p__29636;
var geojson = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29637,(0),null);
var features = (function (){var or__6409__auto__ = cljs.core.cst$kw$features.cljs$core$IFn$_invoke$arity$1(geojson);
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return map.queryRenderedFeatures(cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$layers,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [layer_id], null)], null)));
}
})();
var layer_data = (function (){var or__6409__auto__ = geojson;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$type,"FeatureCollection",cljs.core.cst$kw$features,features], null));
}
})();
var bbox = turf.bbox(cljs.core.clj__GT_js(layer_data));
if((cljs.core.count(features) > (0))){
return map.fitBounds(bbox,({"padding": "15", "linear": true}));
} else {
return null;
}
});

hatti.map.utils.fitMapBounds.cljs$lang$maxFixedArity = (2);

hatti.map.utils.fitMapBounds.cljs$lang$applyTo = (function (seq29633){
var G__29634 = cljs.core.first(seq29633);
var seq29633__$1 = cljs.core.next(seq29633);
var G__29635 = cljs.core.first(seq29633__$1);
var seq29633__$2 = cljs.core.next(seq29633__$1);
return hatti.map.utils.fitMapBounds.cljs$core$IFn$_invoke$arity$variadic(G__29634,G__29635,seq29633__$2);
});

/**
 * Get marker style for field type.
 */
hatti.map.utils.geotype__GT_marker_style = (function hatti$map$utils$geotype__GT_marker_style(field){
if(cljs.core.truth_(hatti.ona.forms.geoshape_QMARK_(field))){
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$layer_DASH_type,"fill",cljs.core.cst$kw$style,cljs.core.cst$kw$fill], null);
} else {
if(cljs.core.truth_(hatti.ona.forms.osm_QMARK_(field))){
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$layer_DASH_type,"fill",cljs.core.cst$kw$style,cljs.core.cst$kw$fill], null);
} else {
if(cljs.core.truth_(hatti.ona.forms.geotrace_QMARK_(field))){
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$layer_DASH_type,"line",cljs.core.cst$kw$style,cljs.core.cst$kw$line,cljs.core.cst$kw$layout,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$line_DASH_join,"round",cljs.core.cst$kw$line_DASH_cap,"round"], null)], null);
} else {
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$layer_DASH_type,"circle",cljs.core.cst$kw$style,cljs.core.cst$kw$point], null);

}
}
}
});
/**
 * Functions that are called after map is loaded in DOM.
 */
hatti.map.utils.map_on_load = (function hatti$map$utils$map_on_load(var_args){
var args__7491__auto__ = [];
var len__7484__auto___29652 = arguments.length;
var i__7485__auto___29653 = (0);
while(true){
if((i__7485__auto___29653 < len__7484__auto___29652)){
args__7491__auto__.push((arguments[i__7485__auto___29653]));

var G__29654 = (i__7485__auto___29653 + (1));
i__7485__auto___29653 = G__29654;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((3) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((3)),(0),null)):null);
return hatti.map.utils.map_on_load.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7492__auto__);
});

hatti.map.utils.map_on_load.cljs$core$IFn$_invoke$arity$variadic = (function (map,event_chan,id_string,p__29647){
var map__29648 = p__29647;
var map__29648__$1 = ((((!((map__29648 == null)))?((((map__29648.cljs$lang$protocol_mask$partition0$ & (64))) || (map__29648.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29648):map__29648);
var map_data = map__29648__$1;
var geofield = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29648__$1,cljs.core.cst$kw$geofield);
var owner = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29648__$1,cljs.core.cst$kw$owner);
var tiles_url = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29648__$1,cljs.core.cst$kw$tiles_DASH_url);
var geojson = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29648__$1,cljs.core.cst$kw$geojson);
var map__29650 = hatti.map.utils.geotype__GT_marker_style(geofield);
var map__29650__$1 = ((((!((map__29650 == null)))?((((map__29650.cljs$lang$protocol_mask$partition0$ & (64))) || (map__29650.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29650):map__29650);
var layer_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29650__$1,cljs.core.cst$kw$layer_DASH_type);
var layout = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29650__$1,cljs.core.cst$kw$layout);
var style = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29650__$1,cljs.core.cst$kw$style);
var stops = om.core.get_state.cljs$core$IFn$_invoke$arity$2(owner,cljs.core.cst$kw$stops);
var circle_border = "point-casting";
if(cljs.core.truth_((function (){var or__6409__auto__ = (cljs.core.count(cljs.core.cst$kw$features.cljs$core$IFn$_invoke$arity$1(geojson)) > (0));
if(or__6409__auto__){
return or__6409__auto__;
} else {
return tiles_url;
}
})())){
hatti.map.utils.add_mapboxgl_source(map,id_string,map_data);

hatti.map.utils.add_mapboxgl_layer.cljs$core$IFn$_invoke$arity$variadic(map,id_string,layer_type,cljs.core.array_seq([cljs.core.cst$kw$layout,layout], 0));

hatti.map.utils.register_mapboxgl_mouse_events(owner,map,event_chan,id_string,style);

hatti.map.utils.set_mapboxgl_paint_property(map,id_string,hatti.map.utils.get_style_properties.cljs$core$IFn$_invoke$arity$variadic(style,cljs.core.cst$kw$normal,cljs.core.array_seq([cljs.core.cst$kw$stops,stops], 0)));

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$point,style)){
hatti.map.utils.add_mapboxgl_layer.cljs$core$IFn$_invoke$arity$variadic(map,id_string,layer_type,cljs.core.array_seq([cljs.core.cst$kw$layer_DASH_id,circle_border,cljs.core.cst$kw$paint,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$circle_DASH_color,"#fff",cljs.core.cst$kw$circle_DASH_radius,(6)], null)], 0));
} else {
if(cljs.core.truth_(map.getLayer(circle_border))){
map.removeLayer(circle_border);
} else {
}
}

om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$style,style);

return om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$loaded_QMARK_,true);
} else {
return null;
}
});

hatti.map.utils.map_on_load.cljs$lang$maxFixedArity = (3);

hatti.map.utils.map_on_load.cljs$lang$applyTo = (function (seq29643){
var G__29644 = cljs.core.first(seq29643);
var seq29643__$1 = cljs.core.next(seq29643);
var G__29645 = cljs.core.first(seq29643__$1);
var seq29643__$2 = cljs.core.next(seq29643__$1);
var G__29646 = cljs.core.first(seq29643__$2);
var seq29643__$3 = cljs.core.next(seq29643__$2);
return hatti.map.utils.map_on_load.cljs$core$IFn$_invoke$arity$variadic(G__29644,G__29645,G__29646,seq29643__$3);
});

/**
 * Set default style
 */
hatti.map.utils.clear_map_styles = (function hatti$map$utils$clear_map_styles(owner){
return hatti.map.utils.set_mapboxgl_paint_property(om.core.get_state.cljs$core$IFn$_invoke$arity$2(owner,cljs.core.cst$kw$mapboxgl_DASH_map),om.core.get_state.cljs$core$IFn$_invoke$arity$2(owner,cljs.core.cst$kw$layer_DASH_id),hatti.map.utils.get_style_properties(om.core.get_state.cljs$core$IFn$_invoke$arity$2(owner,cljs.core.cst$kw$style),cljs.core.cst$kw$normal));
});
