// Compiled by ClojureScript 1.9.229 {:static-fns true, :optimize-constants true}
goog.provide('hatti.map.utils');
goog.require('cljs.core');
goog.require('hatti.constants');
goog.require('cljs.core.async');
goog.require('chimera.seq');
goog.require('hatti.ona.forms');
goog.require('clojure.string');
goog.require('om.core');
goog.require('hatti.utils');
goog.require('cljs.reader');
hatti.map.utils.ona_styles = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$point,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$normal,({"radius": (6), "fillColor": "#f30", "reset": ({"fillColor": "#f30"}), "color": "#fff", "border": (8), "opacity": 0.5, "fillOpacity": 0.9}),cljs.core.cst$kw$hover,({"fillColor": "#631400"}),cljs.core.cst$kw$clicked,({"fillColor": "#ad2300"})], null),cljs.core.cst$kw$shape,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$normal,({"fillColor": "#f30", "color": "#666", "weight": (3), "dashArray": "3", "fillOpacity": 0.7, "opacity": 0.8}),cljs.core.cst$kw$hover,({"fillColor": "#631400", "color": "#222"}),cljs.core.cst$kw$clicked,({"fillColor": "#ad2300", "color": "#222"})], null),cljs.core.cst$kw$line,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$normal,({"color": "#f30", "opacity": (1), "weight": (6), "reset": ({"color": "#f30"})}),cljs.core.cst$kw$hover,({"color": "#631400"}),cljs.core.cst$kw$clicked,({"color": "#ad2300"})], null)], null);
/**
 * Returns geotype (:point :line or :shape) based on marker.
 */
hatti.map.utils.marker__GT_geotype = (function hatti$map$utils$marker__GT_geotype(marker){
return new cljs.core.PersistentArrayMap(null, 3, ["Point",cljs.core.cst$kw$point,"Polygon",cljs.core.cst$kw$shape,"LineString",cljs.core.cst$kw$line], null).call(null,(((marker["feature"])["geometry"])["type"]));
});
/**
 * Appropriate style given style-type (:normal, :clicked, :hover), and
 * either a leaflet marker or clojurescript keyword (one of :point or :shape).
 */
hatti.map.utils.get_ona_style = (function hatti$map$utils$get_ona_style(var_args){
var args__7491__auto__ = [];
var len__7484__auto___38129 = arguments.length;
var i__7485__auto___38130 = (0);
while(true){
if((i__7485__auto___38130 < len__7484__auto___38129)){
args__7491__auto__.push((arguments[i__7485__auto___38130]));

var G__38131 = (i__7485__auto___38130 + (1));
i__7485__auto___38130 = G__38131;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((2) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((2)),(0),null)):null);
return hatti.map.utils.get_ona_style.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7492__auto__);
});

hatti.map.utils.get_ona_style.cljs$core$IFn$_invoke$arity$variadic = (function (marker_or_keyword,style_type,p__38125){
var map__38126 = p__38125;
var map__38126__$1 = ((((!((map__38126 == null)))?((((map__38126.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38126.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38126):map__38126);
var custom_styles = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__38126__$1,cljs.core.cst$kw$custom_DASH_styles,hatti.map.utils.ona_styles);
var kw = (((marker_or_keyword instanceof cljs.core.Keyword))?marker_or_keyword:hatti.map.utils.marker__GT_geotype(marker_or_keyword));
var G__38128 = (kw.cljs$core$IFn$_invoke$arity$1 ? kw.cljs$core$IFn$_invoke$arity$1(custom_styles) : kw.call(null,custom_styles));
return (style_type.cljs$core$IFn$_invoke$arity$1 ? style_type.cljs$core$IFn$_invoke$arity$1(G__38128) : style_type.call(null,G__38128));
});

hatti.map.utils.get_ona_style.cljs$lang$maxFixedArity = (2);

hatti.map.utils.get_ona_style.cljs$lang$applyTo = (function (seq38122){
var G__38123 = cljs.core.first(seq38122);
var seq38122__$1 = cljs.core.next(seq38122);
var G__38124 = cljs.core.first(seq38122__$1);
var seq38122__$2 = cljs.core.next(seq38122__$1);
return hatti.map.utils.get_ona_style.cljs$core$IFn$_invoke$arity$variadic(G__38123,G__38124,seq38122__$2);
});

hatti.map.utils.equivalent_style = (function hatti$map$utils$equivalent_style(s,t){

var sc = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$1(s);
var tc = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$1(t);
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.select_keys(sc,cljs.core.keys(tc)),cljs.core.select_keys(tc,cljs.core.keys(sc)));
});
hatti.map.utils.get_id = (function hatti$map$utils$get_id(marker){
return (((marker["feature"])["properties"])[hatti.constants._id]);
});
hatti.map.utils.get_rank = (function hatti$map$utils$get_rank(marker){
return (((marker["feature"])["properties"])[hatti.constants._rank]);
});
/**
 * Get the style of a marker. Second arg specifies style attribute to get.
 * eg. For marker m1, call like: (get-style m1) or (get-style m1 :fillColor)
 */
hatti.map.utils.get_style = (function hatti$map$utils$get_style(var_args){
var args38132 = [];
var len__7484__auto___38136 = arguments.length;
var i__7485__auto___38137 = (0);
while(true){
if((i__7485__auto___38137 < len__7484__auto___38136)){
args38132.push((arguments[i__7485__auto___38137]));

var G__38138 = (i__7485__auto___38137 + (1));
i__7485__auto___38137 = G__38138;
continue;
} else {
}
break;
}

var G__38134 = args38132.length;
switch (G__38134) {
case 1:
return hatti.map.utils.get_style.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return hatti.map.utils.get_style.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args38132.length)].join('')));

}
});

hatti.map.utils.get_style.cljs$core$IFn$_invoke$arity$1 = (function (marker){
return (marker["options"]);
});

hatti.map.utils.get_style.cljs$core$IFn$_invoke$arity$2 = (function (marker,kw){
var G__38135 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$1(hatti.map.utils.get_style.cljs$core$IFn$_invoke$arity$1(marker));
return (kw.cljs$core$IFn$_invoke$arity$1 ? kw.cljs$core$IFn$_invoke$arity$1(G__38135) : kw.call(null,G__38135));
});

hatti.map.utils.get_style.cljs$lang$maxFixedArity = 2;

/**
 * Check whether a marker is clicked, so it's style can be preserved.
 */
hatti.map.utils.is_clicked_QMARK_ = (function hatti$map$utils$is_clicked_QMARK_(marker){
return hatti.map.utils.equivalent_style(hatti.map.utils.get_style.cljs$core$IFn$_invoke$arity$1(marker),hatti.map.utils.get_ona_style(marker,cljs.core.cst$kw$clicked));
});
/**
 * Apply a style to a marker. Style comes from a function that takes marker.
 */
hatti.map.utils.re_style_marker = (function hatti$map$utils$re_style_marker(marker__GT_style,marker){
var style = (marker__GT_style.cljs$core$IFn$_invoke$arity$1 ? marker__GT_style.cljs$core$IFn$_invoke$arity$1(marker) : marker__GT_style.call(null,marker));
if(cljs.core.truth_(hatti.map.utils.is_clicked_QMARK_(marker))){
return marker.setStyle(cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$reset,style], null)));
} else {
return marker.setStyle(cljs.core.clj__GT_js(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(style,cljs.core.cst$kw$reset,style)));
}
});
/**
 * Reset styles pulls the 'reset' property from within a markers options,
 * clearing styles to default if nothing found.
 */
hatti.map.utils.reset_style = (function hatti$map$utils$reset_style(marker){
var temp__4655__auto__ = ((marker["options"])["reset"]);
if(cljs.core.truth_(temp__4655__auto__)){
var rstyle = temp__4655__auto__;
return marker.setStyle(rstyle);
} else {
return marker.setStyle(hatti.map.utils.get_ona_style(marker,cljs.core.cst$kw$normal));
}
});
/**
 * Looks at the _id in marker, and brings to top if (1) marker clicked or
 * (2) marker's id is selected (via id-selected?)
 */
hatti.map.utils.bring_to_top_if_selected = (function hatti$map$utils$bring_to_top_if_selected(id_selected_QMARK_,marker){
if(cljs.core.truth_((function (){var or__6409__auto__ = hatti.map.utils.is_clicked_QMARK_(marker);
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
var G__38141 = hatti.map.utils.get_id(marker);
return (id_selected_QMARK_.cljs$core$IFn$_invoke$arity$1 ? id_selected_QMARK_.cljs$core$IFn$_invoke$arity$1(G__38141) : id_selected_QMARK_.call(null,G__38141));
}
})())){
return marker.bringToFront();
} else {
return null;
}
});
hatti.map.utils.apply_click_style = (function hatti$map$utils$apply_click_style(marker){
if(cljs.core.truth_(marker)){
marker.bringToFront();

return marker.setStyle(hatti.map.utils.get_ona_style(marker,cljs.core.cst$kw$clicked));
} else {
return null;
}
});
hatti.map.utils.apply_unclick_style = (function hatti$map$utils$apply_unclick_style(marker){
if(cljs.core.truth_(marker)){
return hatti.map.utils.reset_style(marker);
} else {
return null;
}
});
hatti.map.utils.apply_hover_style = (function hatti$map$utils$apply_hover_style(marker){
if(cljs.core.truth_(marker)){
marker.bringToFront();

return marker.setStyle(hatti.map.utils.get_ona_style(marker,cljs.core.cst$kw$hover));
} else {
return null;
}
});
/**
 * Sets the default style on a marker.
 */
hatti.map.utils.clear_all_styles = (function hatti$map$utils$clear_all_styles(var_args){
var args__7491__auto__ = [];
var len__7484__auto___38151 = arguments.length;
var i__7485__auto___38152 = (0);
while(true){
if((i__7485__auto___38152 < len__7484__auto___38151)){
args__7491__auto__.push((arguments[i__7485__auto___38152]));

var G__38153 = (i__7485__auto___38152 + (1));
i__7485__auto___38152 = G__38153;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return hatti.map.utils.clear_all_styles.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

hatti.map.utils.clear_all_styles.cljs$core$IFn$_invoke$arity$variadic = (function (markers,p__38144){
var map__38145 = p__38144;
var map__38145__$1 = ((((!((map__38145 == null)))?((((map__38145.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38145.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38145):map__38145);
var preserve_clicked_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__38145__$1,cljs.core.cst$kw$preserve_DASH_clicked_QMARK_,true);
var seq__38147 = cljs.core.seq(markers);
var chunk__38148 = null;
var count__38149 = (0);
var i__38150 = (0);
while(true){
if((i__38150 < count__38149)){
var marker = chunk__38148.cljs$core$IIndexed$_nth$arity$2(null,i__38150);
if(cljs.core.not((function (){var and__6397__auto__ = preserve_clicked_QMARK_;
if(cljs.core.truth_(and__6397__auto__)){
return hatti.map.utils.is_clicked_QMARK_(marker);
} else {
return and__6397__auto__;
}
})())){
marker.setStyle(hatti.map.utils.get_ona_style(marker,cljs.core.cst$kw$normal));
} else {
}

var G__38154 = seq__38147;
var G__38155 = chunk__38148;
var G__38156 = count__38149;
var G__38157 = (i__38150 + (1));
seq__38147 = G__38154;
chunk__38148 = G__38155;
count__38149 = G__38156;
i__38150 = G__38157;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq(seq__38147);
if(temp__4657__auto__){
var seq__38147__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__38147__$1)){
var c__7220__auto__ = cljs.core.chunk_first(seq__38147__$1);
var G__38158 = cljs.core.chunk_rest(seq__38147__$1);
var G__38159 = c__7220__auto__;
var G__38160 = cljs.core.count(c__7220__auto__);
var G__38161 = (0);
seq__38147 = G__38158;
chunk__38148 = G__38159;
count__38149 = G__38160;
i__38150 = G__38161;
continue;
} else {
var marker = cljs.core.first(seq__38147__$1);
if(cljs.core.not((function (){var and__6397__auto__ = preserve_clicked_QMARK_;
if(cljs.core.truth_(and__6397__auto__)){
return hatti.map.utils.is_clicked_QMARK_(marker);
} else {
return and__6397__auto__;
}
})())){
marker.setStyle(hatti.map.utils.get_ona_style(marker,cljs.core.cst$kw$normal));
} else {
}

var G__38162 = cljs.core.next(seq__38147__$1);
var G__38163 = null;
var G__38164 = (0);
var G__38165 = (0);
seq__38147 = G__38162;
chunk__38148 = G__38163;
count__38149 = G__38164;
i__38150 = G__38165;
continue;
}
} else {
return null;
}
}
break;
}
});

hatti.map.utils.clear_all_styles.cljs$lang$maxFixedArity = (1);

hatti.map.utils.clear_all_styles.cljs$lang$applyTo = (function (seq38142){
var G__38143 = cljs.core.first(seq38142);
var seq38142__$1 = cljs.core.next(seq38142);
return hatti.map.utils.clear_all_styles.cljs$core$IFn$_invoke$arity$variadic(G__38143,seq38142__$1);
});

hatti.map.utils.read_string_or_number = (function hatti$map$utils$read_string_or_number(maybe_s){
if(typeof maybe_s === 'string'){
return cljs.reader.read_string(maybe_s);
} else {
return maybe_s;
}
});
hatti.map.utils.make_feature = (function hatti$map$utils$make_feature(geometry,record_id,index){
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$type,"Feature",cljs.core.cst$kw$properties,cljs.core.PersistentArrayMap.fromArray([cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(hatti.constants._rank),(index + (1)),cljs.core.cst$kw$id,record_id,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(hatti.constants._id),record_id], true, false),cljs.core.cst$kw$geometry,geometry], null);
});
if(typeof hatti.map.utils.get_as_geom !== 'undefined'){
} else {
hatti.map.utils.get_as_geom = (function (){var method_table__7334__auto__ = (function (){var G__38166 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__38166) : cljs.core.atom.call(null,G__38166));
})();
var prefer_table__7335__auto__ = (function (){var G__38167 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__38167) : cljs.core.atom.call(null,G__38167));
})();
var method_cache__7336__auto__ = (function (){var G__38168 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__38168) : cljs.core.atom.call(null,G__38168));
})();
var cached_hierarchy__7337__auto__ = (function (){var G__38169 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__38169) : cljs.core.atom.call(null,G__38169));
})();
var hierarchy__7338__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$hierarchy,cljs.core.get_global_hierarchy());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("hatti.map.utils","get-as-geom"),((function (method_table__7334__auto__,prefer_table__7335__auto__,method_cache__7336__auto__,cached_hierarchy__7337__auto__,hierarchy__7338__auto__){
return (function() { 
var G__38174__delegate = function (record,field,p__38170){
var vec__38171 = p__38170;
var repeat_child_index = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38171,(0),null);
if(cljs.core.truth_(hatti.ona.forms.repeat_QMARK_(field))){
return cljs.core.cst$kw$repeat;
} else {
return cljs.core.cst$kw$default;

}
};
var G__38174 = function (record,field,var_args){
var p__38170 = null;
if (arguments.length > 2) {
var G__38175__i = 0, G__38175__a = new Array(arguments.length -  2);
while (G__38175__i < G__38175__a.length) {G__38175__a[G__38175__i] = arguments[G__38175__i + 2]; ++G__38175__i;}
  p__38170 = new cljs.core.IndexedSeq(G__38175__a,0);
} 
return G__38174__delegate.call(this,record,field,p__38170);};
G__38174.cljs$lang$maxFixedArity = 2;
G__38174.cljs$lang$applyTo = (function (arglist__38176){
var record = cljs.core.first(arglist__38176);
arglist__38176 = cljs.core.next(arglist__38176);
var field = cljs.core.first(arglist__38176);
var p__38170 = cljs.core.rest(arglist__38176);
return G__38174__delegate(record,field,p__38170);
});
G__38174.cljs$core$IFn$_invoke$arity$variadic = G__38174__delegate;
return G__38174;
})()
;})(method_table__7334__auto__,prefer_table__7335__auto__,method_cache__7336__auto__,cached_hierarchy__7337__auto__,hierarchy__7338__auto__))
,cljs.core.cst$kw$default,hierarchy__7338__auto__,method_table__7334__auto__,prefer_table__7335__auto__,method_cache__7336__auto__,cached_hierarchy__7337__auto__));
})();
}
hatti.map.utils.get_as_geom.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$repeat,(function (record,p__38177){
var map__38178 = p__38177;
var map__38178__$1 = ((((!((map__38178 == null)))?((((map__38178.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38178.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38178):map__38178);
var field = map__38178__$1;
var children = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38178__$1,cljs.core.cst$kw$children);
var full_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38178__$1,cljs.core.cst$kw$full_DASH_name);
var iter__7189__auto__ = ((function (map__38178,map__38178__$1,field,children,full_name){
return (function hatti$map$utils$iter__38180(s__38181){
return (new cljs.core.LazySeq(null,((function (map__38178,map__38178__$1,field,children,full_name){
return (function (){
var s__38181__$1 = s__38181;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__38181__$1);
if(temp__4657__auto__){
var s__38181__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__38181__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__38181__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__38183 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__38182 = (0);
while(true){
if((i__38182 < size__7188__auto__)){
var child_record = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__38182);
cljs.core.chunk_append(b__38183,(function (){var iter__7189__auto__ = ((function (i__38182,child_record,c__7187__auto__,size__7188__auto__,b__38183,s__38181__$2,temp__4657__auto__,map__38178,map__38178__$1,field,children,full_name){
return (function hatti$map$utils$iter__38180_$_iter__38198(s__38199){
return (new cljs.core.LazySeq(null,((function (i__38182,child_record,c__7187__auto__,size__7188__auto__,b__38183,s__38181__$2,temp__4657__auto__,map__38178,map__38178__$1,field,children,full_name){
return (function (){
var s__38199__$1 = s__38199;
while(true){
var temp__4657__auto____$1 = cljs.core.seq(s__38199__$1);
if(temp__4657__auto____$1){
var s__38199__$2 = temp__4657__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__38199__$2)){
var c__7187__auto____$1 = cljs.core.chunk_first(s__38199__$2);
var size__7188__auto____$1 = cljs.core.count(c__7187__auto____$1);
var b__38201 = cljs.core.chunk_buffer(size__7188__auto____$1);
if((function (){var i__38200 = (0);
while(true){
if((i__38200 < size__7188__auto____$1)){
var child = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto____$1,i__38200);
cljs.core.chunk_append(b__38201,(hatti.map.utils.get_as_geom.cljs$core$IFn$_invoke$arity$2 ? hatti.map.utils.get_as_geom.cljs$core$IFn$_invoke$arity$2(child_record,child) : hatti.map.utils.get_as_geom.call(null,child_record,child)));

var G__38210 = (i__38200 + (1));
i__38200 = G__38210;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__38201),hatti$map$utils$iter__38180_$_iter__38198(cljs.core.chunk_rest(s__38199__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__38201),null);
}
} else {
var child = cljs.core.first(s__38199__$2);
return cljs.core.cons((hatti.map.utils.get_as_geom.cljs$core$IFn$_invoke$arity$2 ? hatti.map.utils.get_as_geom.cljs$core$IFn$_invoke$arity$2(child_record,child) : hatti.map.utils.get_as_geom.call(null,child_record,child)),hatti$map$utils$iter__38180_$_iter__38198(cljs.core.rest(s__38199__$2)));
}
} else {
return null;
}
break;
}
});})(i__38182,child_record,c__7187__auto__,size__7188__auto__,b__38183,s__38181__$2,temp__4657__auto__,map__38178,map__38178__$1,field,children,full_name))
,null,null));
});})(i__38182,child_record,c__7187__auto__,size__7188__auto__,b__38183,s__38181__$2,temp__4657__auto__,map__38178,map__38178__$1,field,children,full_name))
;
return iter__7189__auto__(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.geofield_QMARK_,children));
})());

var G__38211 = (i__38182 + (1));
i__38182 = G__38211;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__38183),hatti$map$utils$iter__38180(cljs.core.chunk_rest(s__38181__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__38183),null);
}
} else {
var child_record = cljs.core.first(s__38181__$2);
return cljs.core.cons((function (){var iter__7189__auto__ = ((function (child_record,s__38181__$2,temp__4657__auto__,map__38178,map__38178__$1,field,children,full_name){
return (function hatti$map$utils$iter__38180_$_iter__38204(s__38205){
return (new cljs.core.LazySeq(null,((function (child_record,s__38181__$2,temp__4657__auto__,map__38178,map__38178__$1,field,children,full_name){
return (function (){
var s__38205__$1 = s__38205;
while(true){
var temp__4657__auto____$1 = cljs.core.seq(s__38205__$1);
if(temp__4657__auto____$1){
var s__38205__$2 = temp__4657__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__38205__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__38205__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__38207 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__38206 = (0);
while(true){
if((i__38206 < size__7188__auto__)){
var child = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__38206);
cljs.core.chunk_append(b__38207,(hatti.map.utils.get_as_geom.cljs$core$IFn$_invoke$arity$2 ? hatti.map.utils.get_as_geom.cljs$core$IFn$_invoke$arity$2(child_record,child) : hatti.map.utils.get_as_geom.call(null,child_record,child)));

var G__38212 = (i__38206 + (1));
i__38206 = G__38212;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__38207),hatti$map$utils$iter__38180_$_iter__38204(cljs.core.chunk_rest(s__38205__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__38207),null);
}
} else {
var child = cljs.core.first(s__38205__$2);
return cljs.core.cons((hatti.map.utils.get_as_geom.cljs$core$IFn$_invoke$arity$2 ? hatti.map.utils.get_as_geom.cljs$core$IFn$_invoke$arity$2(child_record,child) : hatti.map.utils.get_as_geom.call(null,child_record,child)),hatti$map$utils$iter__38180_$_iter__38204(cljs.core.rest(s__38205__$2)));
}
} else {
return null;
}
break;
}
});})(child_record,s__38181__$2,temp__4657__auto__,map__38178,map__38178__$1,field,children,full_name))
,null,null));
});})(child_record,s__38181__$2,temp__4657__auto__,map__38178,map__38178__$1,field,children,full_name))
;
return iter__7189__auto__(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.geofield_QMARK_,children));
})(),hatti$map$utils$iter__38180(cljs.core.rest(s__38181__$2)));
}
} else {
return null;
}
break;
}
});})(map__38178,map__38178__$1,field,children,full_name))
,null,null));
});})(map__38178,map__38178__$1,field,children,full_name))
;
return iter__7189__auto__(cljs.core.get.cljs$core$IFn$_invoke$arity$2(record,full_name));
}));
hatti.map.utils.get_as_geom.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (record,geofield){
var geotype = new cljs.core.PersistentArrayMap(null, 4, ["geopoint","Point","gps","Point","geoshape","Polygon","geotrace","LineString"], null).call(null,cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(geofield));
var parse = ((function (geotype){
return (function (s){
if((cljs.core.seq(s)) && (cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(s,"n/a"))){
var iter__7189__auto__ = ((function (geotype){
return (function hatti$map$utils$iter__38215(s__38216){
return (new cljs.core.LazySeq(null,((function (geotype){
return (function (){
var s__38216__$1 = s__38216;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__38216__$1);
if(temp__4657__auto__){
var s__38216__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__38216__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__38216__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__38218 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__38217 = (0);
while(true){
if((i__38217 < size__7188__auto__)){
var coord_string = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__38217);
cljs.core.chunk_append(b__38218,(function (){var vec__38227 = clojure.string.split.cljs$core$IFn$_invoke$arity$2(coord_string,/ /);
var lat = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38227,(0),null);
var lng = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38227,(1),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38227,(2),null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38227,(3),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.reader.read_string(lng),cljs.reader.read_string(lat)], null);
})());

var G__38234 = (i__38217 + (1));
i__38217 = G__38234;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__38218),hatti$map$utils$iter__38215(cljs.core.chunk_rest(s__38216__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__38218),null);
}
} else {
var coord_string = cljs.core.first(s__38216__$2);
return cljs.core.cons((function (){var vec__38230 = clojure.string.split.cljs$core$IFn$_invoke$arity$2(coord_string,/ /);
var lat = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38230,(0),null);
var lng = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38230,(1),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38230,(2),null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38230,(3),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.reader.read_string(lng),cljs.reader.read_string(lat)], null);
})(),hatti$map$utils$iter__38215(cljs.core.rest(s__38216__$2)));
}
} else {
return null;
}
break;
}
});})(geotype))
,null,null));
});})(geotype))
;
return iter__7189__auto__(clojure.string.split.cljs$core$IFn$_invoke$arity$2(s,/;/));
} else {
return null;
}
});})(geotype))
;
var coordfn = (function (){var G__38233 = geotype;
switch (G__38233) {
case "Point":
return ((function (G__38233,geotype,parse){
return (function (p1__38213_SHARP_){
return cljs.core.first(parse(p1__38213_SHARP_));
});
;})(G__38233,geotype,parse))

break;
case "LineString":
return parse;

break;
case "Polygon":
return ((function (G__38233,geotype,parse){
return (function (p1__38214_SHARP_){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[parse(p1__38214_SHARP_)],null));
});
;})(G__38233,geotype,parse))

break;
default:
return cljs.core.identity;

}
})();
var value = cljs.core.get.cljs$core$IFn$_invoke$arity$2(record,cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(geofield));
var coords = (coordfn.cljs$core$IFn$_invoke$arity$1 ? coordfn.cljs$core$IFn$_invoke$arity$1(value) : coordfn.call(null,value));
if(cljs.core.truth_(hatti.ona.forms.osm_QMARK_(geofield))){
return cljs.core.cst$kw$geom.cljs$core$IFn$_invoke$arity$1(value);
} else {
if(cljs.core.truth_((function (){var or__6409__auto__ = (coords == null);
if(or__6409__auto__){
return or__6409__auto__;
} else {
return cljs.core.some(cljs.core.nil_QMARK_,coords);
}
})())){
return null;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$type,geotype,cljs.core.cst$kw$coordinates,coords], null);
}
}
}));
/**
 * Given the dataset, and the form schema, get out geojson.
 * Optional specification of field will map that field data to the geom.
 */
hatti.map.utils.as_geojson = (function hatti$map$utils$as_geojson(var_args){
var args38237 = [];
var len__7484__auto___38258 = arguments.length;
var i__7485__auto___38259 = (0);
while(true){
if((i__7485__auto___38259 < len__7484__auto___38258)){
args38237.push((arguments[i__7485__auto___38259]));

var G__38260 = (i__7485__auto___38259 + (1));
i__7485__auto___38259 = G__38260;
continue;
} else {
}
break;
}

var G__38239 = args38237.length;
switch (G__38239) {
case 2:
return hatti.map.utils.as_geojson.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return hatti.map.utils.as_geojson.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args38237.length)].join('')));

}
});

hatti.map.utils.as_geojson.cljs$core$IFn$_invoke$arity$2 = (function (dataset,form){
return hatti.map.utils.as_geojson.cljs$core$IFn$_invoke$arity$3(dataset,form,hatti.ona.forms.default_geofield(form));
});

hatti.map.utils.as_geojson.cljs$core$IFn$_invoke$arity$3 = (function (dataset,form,geofield){
if(cljs.core.truth_(geofield)){
var features = (function (){var iter__7189__auto__ = (function hatti$map$utils$iter__38240(s__38241){
return (new cljs.core.LazySeq(null,(function (){
var s__38241__$1 = s__38241;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__38241__$1);
if(temp__4657__auto__){
var s__38241__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__38241__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__38241__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__38243 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__38242 = (0);
while(true){
if((i__38242 < size__7188__auto__)){
var vec__38252 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__38242);
var idx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38252,(0),null);
var record = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38252,(1),null);
var geom_or_geoms = (hatti.map.utils.get_as_geom.cljs$core$IFn$_invoke$arity$2 ? hatti.map.utils.get_as_geom.cljs$core$IFn$_invoke$arity$2(record,geofield) : hatti.map.utils.get_as_geom.call(null,record,geofield));
if(cljs.core.truth_(geom_or_geoms)){
cljs.core.chunk_append(b__38243,((cljs.core.map_QMARK_(geom_or_geoms))?hatti.map.utils.make_feature(geom_or_geoms,(record.cljs$core$IFn$_invoke$arity$1 ? record.cljs$core$IFn$_invoke$arity$1(hatti.constants._id) : record.call(null,hatti.constants._id)),idx):cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (i__38242,s__38241__$1,geom_or_geoms,vec__38252,idx,record,c__7187__auto__,size__7188__auto__,b__38243,s__38241__$2,temp__4657__auto__){
return (function (p1__38236_SHARP_){
return hatti.map.utils.make_feature(p1__38236_SHARP_,(record.cljs$core$IFn$_invoke$arity$1 ? record.cljs$core$IFn$_invoke$arity$1(hatti.constants._id) : record.call(null,hatti.constants._id)),idx);
});})(i__38242,s__38241__$1,geom_or_geoms,vec__38252,idx,record,c__7187__auto__,size__7188__auto__,b__38243,s__38241__$2,temp__4657__auto__))
,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,cljs.core.flatten(geom_or_geoms)))));

var G__38262 = (i__38242 + (1));
i__38242 = G__38262;
continue;
} else {
var G__38263 = (i__38242 + (1));
i__38242 = G__38263;
continue;
}
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__38243),hatti$map$utils$iter__38240(cljs.core.chunk_rest(s__38241__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__38243),null);
}
} else {
var vec__38255 = cljs.core.first(s__38241__$2);
var idx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38255,(0),null);
var record = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38255,(1),null);
var geom_or_geoms = (hatti.map.utils.get_as_geom.cljs$core$IFn$_invoke$arity$2 ? hatti.map.utils.get_as_geom.cljs$core$IFn$_invoke$arity$2(record,geofield) : hatti.map.utils.get_as_geom.call(null,record,geofield));
if(cljs.core.truth_(geom_or_geoms)){
return cljs.core.cons(((cljs.core.map_QMARK_(geom_or_geoms))?hatti.map.utils.make_feature(geom_or_geoms,(record.cljs$core$IFn$_invoke$arity$1 ? record.cljs$core$IFn$_invoke$arity$1(hatti.constants._id) : record.call(null,hatti.constants._id)),idx):cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (s__38241__$1,geom_or_geoms,vec__38255,idx,record,s__38241__$2,temp__4657__auto__){
return (function (p1__38236_SHARP_){
return hatti.map.utils.make_feature(p1__38236_SHARP_,(record.cljs$core$IFn$_invoke$arity$1 ? record.cljs$core$IFn$_invoke$arity$1(hatti.constants._id) : record.call(null,hatti.constants._id)),idx);
});})(s__38241__$1,geom_or_geoms,vec__38255,idx,record,s__38241__$2,temp__4657__auto__))
,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,cljs.core.flatten(geom_or_geoms)))),hatti$map$utils$iter__38240(cljs.core.rest(s__38241__$2)));
} else {
var G__38264 = cljs.core.rest(s__38241__$2);
s__38241__$1 = G__38264;
continue;
}
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__(hatti.utils.indexed(dataset));
})();
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$type,"FeatureCollection",cljs.core.cst$kw$features,cljs.core.flatten(features)], null);
} else {
return null;
}
});

hatti.map.utils.as_geojson.cljs$lang$maxFixedArity = 3;

/**
 * Creates a leaflet map, rendering it to the dom element with given id.
 */
hatti.map.utils.create_map = (function hatti$map$utils$create_map(id,p__38266){
var map__38269 = p__38266;
var map__38269__$1 = ((((!((map__38269 == null)))?((((map__38269.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38269.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38269):map__38269);
var mapbox_tiles = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38269__$1,cljs.core.cst$kw$mapbox_DASH_tiles);
var include_google_maps_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38269__$1,cljs.core.cst$kw$include_DASH_google_DASH_maps_QMARK_);
var layers = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (map__38269,map__38269__$1,mapbox_tiles,include_google_maps_QMARK_){
return (function (p1__38265_SHARP_){
return L.tileLayer(cljs.core.cst$kw$url.cljs$core$IFn$_invoke$arity$1(p1__38265_SHARP_));
});})(map__38269,map__38269__$1,mapbox_tiles,include_google_maps_QMARK_))
,mapbox_tiles);
var nlayers = cljs.core.zipmap(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$name,mapbox_tiles),layers);
var named_layers = (cljs.core.truth_(include_google_maps_QMARK_)?cljs.core.clj__GT_js(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(nlayers,"Google Satellite",new L.Google)):cljs.core.clj__GT_js(nlayers));
var m = L.map(id,({"layers": cljs.core.first(layers), "zoomControl": false}));
var z = L.control.zoom.call(null,({"position": "bottomleft"}));
z.addTo(m);

L.control.layers.call(null,named_layers,null,({"position": "bottomleft"})).addTo(m);

m.setView([(0),(0)],(1));

return m;
});
/**
 * Mouse events for markers.
 *   On click or arrow, mapped-submission-to-rank events are generated.
 *   On hover, marker is brought to the front and color changed.
 */
hatti.map.utils.register_mouse_events = (function hatti$map$utils$register_mouse_events(feature,marker,event_chan){
marker.on("click",(function (){
if(cljs.core.truth_(hatti.map.utils.is_clicked_QMARK_(marker))){
return null;
} else {
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mapped_DASH_submission_DASH_to_DASH_rank,((feature["properties"])[hatti.constants._rank])], null));
}
}));

marker.on("mouseover",(function (){
if(cljs.core.truth_(hatti.map.utils.is_clicked_QMARK_(marker))){
return null;
} else {
return hatti.map.utils.apply_hover_style(marker);
}
}));

return marker.on("mouseout",(function (){
if(cljs.core.truth_(hatti.map.utils.is_clicked_QMARK_(marker))){
return null;
} else {
return hatti.map.utils.apply_unclick_style(marker);
}
}));
});
/**
 * Re-renders map by invalidating leaflet size.
 * If map is zoomed out beyond layer-bounds, re-zooms to layer.
 */
hatti.map.utils.re_render_map_BANG_ = (function hatti$map$utils$re_render_map_BANG_(leaflet_map,feature_layer){
var map_bounds = leaflet_map.getBounds();
var layer_bounds = feature_layer.getBounds();
leaflet_map.invalidateSize(false);

if(((leaflet_map.getZoom() === (0))) || (cljs.core.not(layer_bounds.contains(map_bounds)))){
return leaflet_map.fitBounds(layer_bounds);
} else {
return null;
}
});
/**
 * Create a map with the given GeoJSON data.
 * Adds mouse events and centers on the geojson features.
 */
hatti.map.utils.load_geo_json = (function hatti$map$utils$load_geo_json(var_args){
var args__7491__auto__ = [];
var len__7484__auto___38283 = arguments.length;
var i__7485__auto___38284 = (0);
while(true){
if((i__7485__auto___38284 < len__7484__auto___38283)){
args__7491__auto__.push((arguments[i__7485__auto___38284]));

var G__38285 = (i__7485__auto___38284 + (1));
i__7485__auto___38284 = G__38285;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((3) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((3)),(0),null)):null);
return hatti.map.utils.load_geo_json.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7492__auto__);
});

hatti.map.utils.load_geo_json.cljs$core$IFn$_invoke$arity$variadic = (function (m,geojson,event_chan,p__38280){
var map__38281 = p__38280;
var map__38281__$1 = ((((!((map__38281 == null)))?((((map__38281.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38281.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38281):map__38281);
var rezoom_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38281__$1,cljs.core.cst$kw$rezoom_QMARK_);
var on_events = ((function (map__38281,map__38281__$1,rezoom_QMARK_){
return (function (p1__38271_SHARP_,p2__38272_SHARP_){
return hatti.map.utils.register_mouse_events(p1__38271_SHARP_,p2__38272_SHARP_,event_chan);
});})(map__38281,map__38281__$1,rezoom_QMARK_))
;
var geometry_type = new cljs.core.PersistentArrayMap(null, 3, ["Point",cljs.core.cst$kw$point,"Polygon",cljs.core.cst$kw$shape,"LineString",cljs.core.cst$kw$line], null).call(null,cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$geometry.cljs$core$IFn$_invoke$arity$1(cljs.core.first(cljs.core.cst$kw$features.cljs$core$IFn$_invoke$arity$1(geojson)))));
var stylefn = ((function (on_events,geometry_type,map__38281,map__38281__$1,rezoom_QMARK_){
return (function (){
return hatti.map.utils.get_ona_style(geometry_type,cljs.core.cst$kw$normal);
});})(on_events,geometry_type,map__38281,map__38281__$1,rezoom_QMARK_))
;
var point__GT_marker = ((function (on_events,geometry_type,stylefn,map__38281,map__38281__$1,rezoom_QMARK_){
return (function (p1__38274_SHARP_,p2__38273_SHARP_){
return L.circleMarker(p2__38273_SHARP_);
});})(on_events,geometry_type,stylefn,map__38281,map__38281__$1,rezoom_QMARK_))
;
var feature_layer = L.geoJson(cljs.core.clj__GT_js(geojson),({"onEachFeature": on_events, "pointToLayer": point__GT_marker, "style": stylefn}));
var ids = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (on_events,geometry_type,stylefn,point__GT_marker,feature_layer,map__38281,map__38281__$1,rezoom_QMARK_){
return (function (p1__38275_SHARP_){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(p1__38275_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$properties,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(hatti.constants._id)], null));
});})(on_events,geometry_type,stylefn,point__GT_marker,feature_layer,map__38281,map__38281__$1,rezoom_QMARK_))
,cljs.core.cst$kw$features.cljs$core$IFn$_invoke$arity$1(geojson));
var markers = feature_layer.getLayers();
if(cljs.core.seq(cljs.core.cst$kw$features.cljs$core$IFn$_invoke$arity$1(geojson))){
if(cljs.core.truth_(rezoom_QMARK_)){
m.fitBounds(feature_layer.getBounds());
} else {
}

feature_layer.addTo(m);
} else {
}

return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$feature_DASH_layer,feature_layer,cljs.core.cst$kw$markers,markers,cljs.core.cst$kw$id_DASH__GT_marker,cljs.core.zipmap(ids,markers)], null);
});

hatti.map.utils.load_geo_json.cljs$lang$maxFixedArity = (3);

hatti.map.utils.load_geo_json.cljs$lang$applyTo = (function (seq38276){
var G__38277 = cljs.core.first(seq38276);
var seq38276__$1 = cljs.core.next(seq38276);
var G__38278 = cljs.core.first(seq38276__$1);
var seq38276__$2 = cljs.core.next(seq38276__$1);
var G__38279 = cljs.core.first(seq38276__$2);
var seq38276__$3 = cljs.core.next(seq38276__$2);
return hatti.map.utils.load_geo_json.cljs$core$IFn$_invoke$arity$variadic(G__38277,G__38278,G__38279,seq38276__$3);
});

/**
 * Creates a mapboxgl map, rendering it to the dom element with given id.
 */
hatti.map.utils.create_mapboxgl_map = (function hatti$map$utils$create_mapboxgl_map(id){
mapboxgl.accessToken = hatti.constants.mapboxgl_access_token;

var Map = mapboxgl.Map;
var NavigationControl = mapboxgl.NavigationControl;
var ScaleControl = mapboxgl.ScaleControl;
var m = (new Map(({"container": id, "style": "mapbox://styles/mapbox/streets-v9"})));
m.addControl((new ScaleControl(({"maxWidth": (100), "unit": "metric"}))),"bottom-left");

return m.addControl((new NavigationControl()),"bottom-left");
});
/**
 * Gets query filter and returns filters based on field type
 */
hatti.map.utils.get_filter = (function hatti$map$utils$get_filter(p__38286,flat_form){
var map__38292 = p__38286;
var map__38292__$1 = ((((!((map__38292 == null)))?((((map__38292.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38292.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38292):map__38292);
var column = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38292__$1,cljs.core.cst$kw$column);
var filter = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38292__$1,cljs.core.cst$kw$filter);
var value = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38292__$1,cljs.core.cst$kw$value);
var field = cljs.core.first(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (map__38292,map__38292__$1,column,filter,value){
return (function (p__38294){
var map__38295 = p__38294;
var map__38295__$1 = ((((!((map__38295 == null)))?((((map__38295.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38295.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38295):map__38295);
var full_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38295__$1,cljs.core.cst$kw$full_DASH_name);
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(full_name,column);
});})(map__38292,map__38292__$1,column,filter,value))
,flat_form));
if(cljs.core.truth_(hatti.ona.forms.numeric_QMARK_(field))){
return [cljs.core.str("CAST(json->>'"),cljs.core.str(column),cljs.core.str("' AS INT) "),cljs.core.str(filter),cljs.core.str(" '"),cljs.core.str(value),cljs.core.str("'")].join('');
} else {
if(cljs.core.truth_(hatti.ona.forms.time_based_QMARK_(field))){
return [cljs.core.str("CAST(json->>'"),cljs.core.str(column),cljs.core.str("' AS AS TIMESTAMP) "),cljs.core.str(filter),cljs.core.str(" '"),cljs.core.str(value),cljs.core.str("'")].join('');
} else {
return [cljs.core.str("json->>'"),cljs.core.str(column),cljs.core.str("' "),cljs.core.str(filter),cljs.core.str(" '"),cljs.core.str(value),cljs.core.str("'")].join('');

}
}
});
/**
 * Generates query params filters for filtered datasets 
 */
hatti.map.utils.generate_filter_string = (function hatti$map$utils$generate_filter_string(query,flat_form){
if(cljs.core.truth_(cljs.core.not_empty(query))){
return [cljs.core.str(" and "),cljs.core.str(clojure.string.join.cljs$core$IFn$_invoke$arity$2(" and ",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__38297_SHARP_){
return hatti.map.utils.get_filter(p1__38297_SHARP_,flat_form);
}),query)))].join('');
} else {
return null;
}
});
/**
 * Generates tiles url with appropriate filters as query params
 */
hatti.map.utils.get_tiles_endpoint = (function hatti$map$utils$get_tiles_endpoint(var_args){
var args__7491__auto__ = [];
var len__7484__auto___38307 = arguments.length;
var i__7485__auto___38308 = (0);
while(true){
if((i__7485__auto___38308 < len__7484__auto___38307)){
args__7491__auto__.push((arguments[i__7485__auto___38308]));

var G__38309 = (i__7485__auto___38308 + (1));
i__7485__auto___38308 = G__38309;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((4) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((4)),(0),null)):null);
return hatti.map.utils.get_tiles_endpoint.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__7492__auto__);
});

hatti.map.utils.get_tiles_endpoint.cljs$core$IFn$_invoke$arity$variadic = (function (tiles_server,formid,fields,flat_form,p__38303){
var vec__38304 = p__38303;
var query = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38304,(0),null);
return [cljs.core.str(tiles_server),cljs.core.str(hatti.constants.tiles_endpoint),cljs.core.str("?where=deleted_at is null and xform_id ="),cljs.core.str(formid),cljs.core.str(hatti.map.utils.generate_filter_string(query,flat_form)),cljs.core.str("&fields="),cljs.core.str(clojure.string.join.cljs$core$IFn$_invoke$arity$2(",",fields))].join('');
});

hatti.map.utils.get_tiles_endpoint.cljs$lang$maxFixedArity = (4);

hatti.map.utils.get_tiles_endpoint.cljs$lang$applyTo = (function (seq38298){
var G__38299 = cljs.core.first(seq38298);
var seq38298__$1 = cljs.core.next(seq38298);
var G__38300 = cljs.core.first(seq38298__$1);
var seq38298__$2 = cljs.core.next(seq38298__$1);
var G__38301 = cljs.core.first(seq38298__$2);
var seq38298__$3 = cljs.core.next(seq38298__$2);
var G__38302 = cljs.core.first(seq38298__$3);
var seq38298__$4 = cljs.core.next(seq38298__$3);
return hatti.map.utils.get_tiles_endpoint.cljs$core$IFn$_invoke$arity$variadic(G__38299,G__38300,G__38301,G__38302,seq38298__$4);
});

/**
 * Add map source. This is called with either tiles-url or geoson which
 *   determins the source type (Vector or  GeosJSON). 
 */
hatti.map.utils.add_mapboxgl_source = (function hatti$map$utils$add_mapboxgl_source(map,id_string,p__38310){
var map__38314 = p__38310;
var map__38314__$1 = ((((!((map__38314 == null)))?((((map__38314.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38314.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38314):map__38314);
var tiles_url = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38314__$1,cljs.core.cst$kw$tiles_DASH_url);
var geojson = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38314__$1,cljs.core.cst$kw$geojson);
var cluster = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__38314__$1,cljs.core.cst$kw$cluster,false);
var clusterRadius = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38314__$1,cljs.core.cst$kw$clusterRadius);
var clusterMaxZoom = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38314__$1,cljs.core.cst$kw$clusterMaxZoom);
var geojson_source_defn = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$type,"geojson",cljs.core.cst$kw$data,geojson,cljs.core.cst$kw$cluster,cluster], null);
var source = (cljs.core.truth_(geojson)?cljs.core.clj__GT_js((function (){var G__38316 = geojson_source_defn;
var G__38316__$1 = (cljs.core.truth_(clusterRadius)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__38316,cljs.core.cst$kw$clusterRadius,clusterRadius):G__38316);
if(cljs.core.truth_(clusterMaxZoom)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__38316__$1,cljs.core.cst$kw$clusterMaxZoom,clusterMaxZoom);
} else {
return G__38316__$1;
}
})()):(cljs.core.truth_(tiles_url)?cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$type,"vector",cljs.core.cst$kw$tiles,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [tiles_url], null)], null)):null));
if(cljs.core.truth_(map.getSource(id_string))){
return null;
} else {
return map.addSource(id_string,source);
}
});
/**
 * Add map layer from available sources.
 */
hatti.map.utils.add_mapboxgl_layer = (function hatti$map$utils$add_mapboxgl_layer(var_args){
var args__7491__auto__ = [];
var len__7484__auto___38325 = arguments.length;
var i__7485__auto___38326 = (0);
while(true){
if((i__7485__auto___38326 < len__7484__auto___38325)){
args__7491__auto__.push((arguments[i__7485__auto___38326]));

var G__38327 = (i__7485__auto___38326 + (1));
i__7485__auto___38326 = G__38327;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((3) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((3)),(0),null)):null);
return hatti.map.utils.add_mapboxgl_layer.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7492__auto__);
});

hatti.map.utils.add_mapboxgl_layer.cljs$core$IFn$_invoke$arity$variadic = (function (map,id_string,layer_type,p__38321){
var map__38322 = p__38321;
var map__38322__$1 = ((((!((map__38322 == null)))?((((map__38322.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38322.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38322):map__38322);
var layer_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38322__$1,cljs.core.cst$kw$layer_DASH_id);
var layout = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38322__$1,cljs.core.cst$kw$layout);
var paint = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38322__$1,cljs.core.cst$kw$paint);
var filter = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38322__$1,cljs.core.cst$kw$filter);
var tiles_url = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38322__$1,cljs.core.cst$kw$tiles_DASH_url);
var l_id = (function (){var or__6409__auto__ = layer_id;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return id_string;
}
})();
var layer_def = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$id,l_id,cljs.core.cst$kw$type,layer_type,cljs.core.cst$kw$source,id_string], null);
var layer = cljs.core.clj__GT_js((function (){var G__38324 = layer_def;
var G__38324__$1 = (cljs.core.truth_(tiles_url)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__38324,cljs.core.cst$kw$source_DASH_layer,hatti.constants.vector_source_layer):G__38324);
var G__38324__$2 = (cljs.core.truth_(paint)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__38324__$1,cljs.core.cst$kw$paint,paint):G__38324__$1);
var G__38324__$3 = (cljs.core.truth_(layout)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__38324__$2,cljs.core.cst$kw$layout,layout):G__38324__$2);
if(cljs.core.truth_(filter)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__38324__$3,cljs.core.cst$kw$filter,filter);
} else {
return G__38324__$3;
}
})());
if(cljs.core.truth_(map.getLayer(l_id))){
return null;
} else {
return map.addLayer(layer,id_string);
}
});

hatti.map.utils.add_mapboxgl_layer.cljs$lang$maxFixedArity = (3);

hatti.map.utils.add_mapboxgl_layer.cljs$lang$applyTo = (function (seq38317){
var G__38318 = cljs.core.first(seq38317);
var seq38317__$1 = cljs.core.next(seq38317);
var G__38319 = cljs.core.first(seq38317__$1);
var seq38317__$2 = cljs.core.next(seq38317__$1);
var G__38320 = cljs.core.first(seq38317__$2);
var seq38317__$3 = cljs.core.next(seq38317__$2);
return hatti.map.utils.add_mapboxgl_layer.cljs$core$IFn$_invoke$arity$variadic(G__38318,G__38319,G__38320,seq38317__$3);
});

/**
 * Generates a collection of input - output value pairs known
 * as stops. These stops are used by get-styles function to decide the style
 * output based on an input vaue from the dataset. e.g. _id. By defauly this
 *  function purely generates color stops.
 */
hatti.map.utils.generate_stops = (function hatti$map$utils$generate_stops(selected_id,selected_color){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),"#f30"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [selected_id,selected_color], null)], null);
});
/**
 * Generates cirlce size property stops base on values from dataset.
 */
hatti.map.utils.generate_size_stops = (function hatti$map$utils$generate_size_stops(selected_id,selected_color){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(4)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [selected_id,selected_color], null)], null);
});
/**
 * Gets predefined styles for diffent layer types and states.
 */
hatti.map.utils.get_styles = (function hatti$map$utils$get_styles(var_args){
var args__7491__auto__ = [];
var len__7484__auto___38333 = arguments.length;
var i__7485__auto___38334 = (0);
while(true){
if((i__7485__auto___38334 < len__7484__auto___38333)){
args__7491__auto__.push((arguments[i__7485__auto___38334]));

var G__38335 = (i__7485__auto___38334 + (1));
i__7485__auto___38334 = G__38335;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((0) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((0)),(0),null)):null);
return hatti.map.utils.get_styles.cljs$core$IFn$_invoke$arity$variadic(argseq__7492__auto__);
});

hatti.map.utils.get_styles.cljs$core$IFn$_invoke$arity$variadic = (function (p__38329){
var vec__38330 = p__38329;
var selected_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38330,(0),null);
var stops = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38330,(1),null);
var size_stops = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38330,(2),null);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$point,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$normal,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["circle-color",cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$property,"id",cljs.core.cst$kw$type,"categorical",cljs.core.cst$kw$stops,(cljs.core.truth_(stops)?stops:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),"#f30"], null)], null))], null))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["circle-radius",(4)], null)], null),cljs.core.cst$kw$hover,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["circle-color",cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$property,"id",cljs.core.cst$kw$type,"categorical",cljs.core.cst$kw$stops,hatti.map.utils.generate_stops(selected_id,"#631400")], null))], null)], null),cljs.core.cst$kw$clicked,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["circle-color",cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$property,"id",cljs.core.cst$kw$type,"categorical",cljs.core.cst$kw$stops,hatti.map.utils.generate_stops(selected_id,"#ad2300")], null))], null)], null),cljs.core.cst$kw$sized,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["circle-radius",cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$property,"id",cljs.core.cst$kw$type,"categorical",cljs.core.cst$kw$stops,(cljs.core.truth_(size_stops)?size_stops:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(6)], null)], null))], null))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["circle-opacity",cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$stops,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(3),0.2], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(15),0.8], null)], null)], null))], null)], null)], null),cljs.core.cst$kw$fill,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$normal,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["fill-color",cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$property,"_id",cljs.core.cst$kw$type,"categorical",cljs.core.cst$kw$stops,(cljs.core.truth_(stops)?stops:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),"#f30"], null)], null))], null))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["fill-opacity",0.7], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["fill-outline-color","#666"], null)], null),cljs.core.cst$kw$hover,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["fill-color",cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$property,"_id",cljs.core.cst$kw$type,"categorical",cljs.core.cst$kw$stops,hatti.map.utils.generate_stops(selected_id,"#631400")], null))], null)], null),cljs.core.cst$kw$clicked,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["fill-color",cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$property,"_id",cljs.core.cst$kw$type,"categorical",cljs.core.cst$kw$stops,hatti.map.utils.generate_stops(selected_id,"#ad2300")], null))], null)], null)], null),cljs.core.cst$kw$line,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$normal,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["line-color",cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$property,"_id",cljs.core.cst$kw$type,"categorical",cljs.core.cst$kw$stops,(cljs.core.truth_(stops)?stops:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),"#f30"], null)], null))], null))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["line-opacity",0.8], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["line-width",(7)], null)], null),cljs.core.cst$kw$hover,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["line-color",cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$property,"_id",cljs.core.cst$kw$type,"categorical",cljs.core.cst$kw$stops,hatti.map.utils.generate_stops(selected_id,"#631400")], null))], null)], null),cljs.core.cst$kw$clicked,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["line-color",cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$property,"_id",cljs.core.cst$kw$type,"categorical",cljs.core.cst$kw$stops,hatti.map.utils.generate_stops(selected_id,"#ad2300")], null))], null)], null)], null)], null);
});

hatti.map.utils.get_styles.cljs$lang$maxFixedArity = (0);

hatti.map.utils.get_styles.cljs$lang$applyTo = (function (seq38328){
return hatti.map.utils.get_styles.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq38328));
});

/**
 * Get style properties for layer.
 */
hatti.map.utils.get_style_properties = (function hatti$map$utils$get_style_properties(var_args){
var args__7491__auto__ = [];
var len__7484__auto___38344 = arguments.length;
var i__7485__auto___38345 = (0);
while(true){
if((i__7485__auto___38345 < len__7484__auto___38344)){
args__7491__auto__.push((arguments[i__7485__auto___38345]));

var G__38346 = (i__7485__auto___38345 + (1));
i__7485__auto___38345 = G__38346;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((2) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((2)),(0),null)):null);
return hatti.map.utils.get_style_properties.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7492__auto__);
});

hatti.map.utils.get_style_properties.cljs$core$IFn$_invoke$arity$variadic = (function (style_type,style_state,p__38339){
var map__38340 = p__38339;
var map__38340__$1 = ((((!((map__38340 == null)))?((((map__38340.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38340.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38340):map__38340);
var selected_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38340__$1,cljs.core.cst$kw$selected_DASH_id);
var stops = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38340__$1,cljs.core.cst$kw$stops);
var G__38342 = (function (){var G__38343 = hatti.map.utils.get_styles.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([selected_id,stops], 0));
return (style_type.cljs$core$IFn$_invoke$arity$1 ? style_type.cljs$core$IFn$_invoke$arity$1(G__38343) : style_type.call(null,G__38343));
})();
return (style_state.cljs$core$IFn$_invoke$arity$1 ? style_state.cljs$core$IFn$_invoke$arity$1(G__38342) : style_state.call(null,G__38342));
});

hatti.map.utils.get_style_properties.cljs$lang$maxFixedArity = (2);

hatti.map.utils.get_style_properties.cljs$lang$applyTo = (function (seq38336){
var G__38337 = cljs.core.first(seq38336);
var seq38336__$1 = cljs.core.next(seq38336);
var G__38338 = cljs.core.first(seq38336__$1);
var seq38336__$2 = cljs.core.next(seq38336__$1);
return hatti.map.utils.get_style_properties.cljs$core$IFn$_invoke$arity$variadic(G__38337,G__38338,seq38336__$2);
});

/**
 * Sets maps paint properties given layer-id and list of properties to set.
 *   properties should be a list of properties that contains the propery name
 *   and value in a vector. e.g. [[property1 value1] [property2 value2]
 */
hatti.map.utils.set_mapboxgl_paint_property = (function hatti$map$utils$set_mapboxgl_paint_property(map,layer_id,properties){
var seq__38357 = cljs.core.seq(properties);
var chunk__38358 = null;
var count__38359 = (0);
var i__38360 = (0);
while(true){
if((i__38360 < count__38359)){
var vec__38361 = chunk__38358.cljs$core$IIndexed$_nth$arity$2(null,i__38360);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38361,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38361,(1),null);
map.setPaintProperty(layer_id,p,v);

var G__38367 = seq__38357;
var G__38368 = chunk__38358;
var G__38369 = count__38359;
var G__38370 = (i__38360 + (1));
seq__38357 = G__38367;
chunk__38358 = G__38368;
count__38359 = G__38369;
i__38360 = G__38370;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq(seq__38357);
if(temp__4657__auto__){
var seq__38357__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__38357__$1)){
var c__7220__auto__ = cljs.core.chunk_first(seq__38357__$1);
var G__38371 = cljs.core.chunk_rest(seq__38357__$1);
var G__38372 = c__7220__auto__;
var G__38373 = cljs.core.count(c__7220__auto__);
var G__38374 = (0);
seq__38357 = G__38371;
chunk__38358 = G__38372;
count__38359 = G__38373;
i__38360 = G__38374;
continue;
} else {
var vec__38364 = cljs.core.first(seq__38357__$1);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38364,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38364,(1),null);
map.setPaintProperty(layer_id,p,v);

var G__38375 = cljs.core.next(seq__38357__$1);
var G__38376 = null;
var G__38377 = (0);
var G__38378 = (0);
seq__38357 = G__38375;
chunk__38358 = G__38376;
count__38359 = G__38377;
i__38360 = G__38378;
continue;
}
} else {
return null;
}
}
break;
}
});
hatti.map.utils.get_id_property = (function hatti$map$utils$get_id_property(features){
var properties = (cljs.core.first(features)["properties"]);
var or__6409__auto__ = (properties["id"]);
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return (properties[hatti.constants._id]);
}
});
/**
 * Register map mouse events.
 */
hatti.map.utils.register_mapboxgl_mouse_events = (function hatti$map$utils$register_mapboxgl_mouse_events(owner,map,event_chan,id_string,style){
map.off("mousemove");

map.off("click");

map.on("mousemove",(function (e){
var layer_id = id_string;
var features = map.queryRenderedFeatures(e.point,cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$layers,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [layer_id], null)], null)));
var no_of_features = features.length;
var view_by = om.core.get_props.cljs$core$IFn$_invoke$arity$2(owner,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$map_DASH_page,cljs.core.cst$kw$view_DASH_by], null));
var selected_id = om.core.get_props.cljs$core$IFn$_invoke$arity$2(owner,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$map_DASH_page,cljs.core.cst$kw$submission_DASH_clicked,cljs.core.cst$kw$id], null));
map.getCanvas().style.cursor = (((features.length > (0)))?"pointer":"");

if(cljs.core.truth_(view_by)){
return null;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(no_of_features,(1))){
return hatti.map.utils.set_mapboxgl_paint_property(map,layer_id,hatti.map.utils.get_style_properties.cljs$core$IFn$_invoke$arity$variadic(style,cljs.core.cst$kw$hover,cljs.core.array_seq([cljs.core.cst$kw$selected_DASH_id,hatti.map.utils.get_id_property(features)], 0)));
} else {
hatti.map.utils.set_mapboxgl_paint_property(map,layer_id,hatti.map.utils.get_style_properties(style,cljs.core.cst$kw$normal));

if(cljs.core.truth_(selected_id)){
return hatti.map.utils.set_mapboxgl_paint_property(map,layer_id,hatti.map.utils.get_style_properties.cljs$core$IFn$_invoke$arity$variadic(style,cljs.core.cst$kw$clicked,cljs.core.array_seq([cljs.core.cst$kw$selected_DASH_id,selected_id], 0)));
} else {
return null;
}
}
}
}));

return map.on("click",(function (e){
var layer_id = id_string;
var features = map.queryRenderedFeatures(e.point,cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$layers,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [layer_id], null)], null)));
var no_of_features = features.length;
var view_by = om.core.get_props.cljs$core$IFn$_invoke$arity$2(owner,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$map_DASH_page,cljs.core.cst$kw$view_DASH_by], null));
if((no_of_features > (0))){
var feature_id = hatti.map.utils.get_id_property(features);
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mapped_DASH_submission_DASH_to_DASH_id,feature_id], null));

if(cljs.core.truth_(view_by)){
return null;
} else {
return hatti.map.utils.set_mapboxgl_paint_property(map,layer_id,hatti.map.utils.get_style_properties.cljs$core$IFn$_invoke$arity$variadic(style,cljs.core.cst$kw$clicked,cljs.core.array_seq([cljs.core.cst$kw$selected_DASH_id,feature_id], 0)));
}
} else {
return null;
}
}));
});
/**
 * Fits map boundaries on rendered features.
 */
hatti.map.utils.fitMapBounds = (function hatti$map$utils$fitMapBounds(var_args){
var args__7491__auto__ = [];
var len__7484__auto___38386 = arguments.length;
var i__7485__auto___38387 = (0);
while(true){
if((i__7485__auto___38387 < len__7484__auto___38386)){
args__7491__auto__.push((arguments[i__7485__auto___38387]));

var G__38388 = (i__7485__auto___38387 + (1));
i__7485__auto___38387 = G__38388;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((2) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((2)),(0),null)):null);
return hatti.map.utils.fitMapBounds.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7492__auto__);
});

hatti.map.utils.fitMapBounds.cljs$core$IFn$_invoke$arity$variadic = (function (map,layer_id,p__38382){
var vec__38383 = p__38382;
var geojson = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38383,(0),null);
var features = (function (){var or__6409__auto__ = cljs.core.cst$kw$features.cljs$core$IFn$_invoke$arity$1(geojson);
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return map.queryRenderedFeatures(cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$layers,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [layer_id], null)], null)));
}
})();
var layer_data = (function (){var or__6409__auto__ = geojson;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$type,"FeatureCollection",cljs.core.cst$kw$features,features], null));
}
})();
var bbox = turf.bbox(cljs.core.clj__GT_js(layer_data));
if((cljs.core.count(features) > (0))){
return map.fitBounds(bbox,({"padding": "15", "linear": true}));
} else {
return null;
}
});

hatti.map.utils.fitMapBounds.cljs$lang$maxFixedArity = (2);

hatti.map.utils.fitMapBounds.cljs$lang$applyTo = (function (seq38379){
var G__38380 = cljs.core.first(seq38379);
var seq38379__$1 = cljs.core.next(seq38379);
var G__38381 = cljs.core.first(seq38379__$1);
var seq38379__$2 = cljs.core.next(seq38379__$1);
return hatti.map.utils.fitMapBounds.cljs$core$IFn$_invoke$arity$variadic(G__38380,G__38381,seq38379__$2);
});

/**
 * Get marker style for field type.
 */
hatti.map.utils.geotype__GT_marker_style = (function hatti$map$utils$geotype__GT_marker_style(field){
if(cljs.core.truth_(hatti.ona.forms.geoshape_QMARK_(field))){
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$layer_DASH_type,"fill",cljs.core.cst$kw$style,cljs.core.cst$kw$fill], null);
} else {
if(cljs.core.truth_(hatti.ona.forms.osm_QMARK_(field))){
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$layer_DASH_type,"fill",cljs.core.cst$kw$style,cljs.core.cst$kw$fill], null);
} else {
if(cljs.core.truth_(hatti.ona.forms.geotrace_QMARK_(field))){
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$layer_DASH_type,"line",cljs.core.cst$kw$style,cljs.core.cst$kw$line,cljs.core.cst$kw$layout,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$line_DASH_join,"round",cljs.core.cst$kw$line_DASH_cap,"round"], null)], null);
} else {
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$layer_DASH_type,"circle",cljs.core.cst$kw$style,cljs.core.cst$kw$point], null);

}
}
}
});
/**
 * Filter features and return only selected features. Returns all features
 *   features if selected-ids is nil. 
 */
hatti.map.utils.filter_selected_features = (function hatti$map$utils$filter_selected_features(features,selected_ids){
var G__38395 = features;
if(cljs.core.truth_(selected_ids)){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (G__38395){
return (function (p__38396){
var map__38397 = p__38396;
var map__38397__$1 = ((((!((map__38397 == null)))?((((map__38397.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38397.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38397):map__38397);
var map__38398 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38397__$1,cljs.core.cst$kw$properties);
var map__38398__$1 = ((((!((map__38398 == null)))?((((map__38398.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38398.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38398):map__38398);
var _id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38398__$1,cljs.core.cst$kw$_id);
return chimera.seq.in_QMARK_(selected_ids,_id);
});})(G__38395))
,G__38395);
} else {
return G__38395;
}
});
/**
 * Counts points collected into hexbins.
 */
hatti.map.utils.count_hexbin_points = (function hatti$map$utils$count_hexbin_points(hexbins){
var iter__7189__auto__ = (function hatti$map$utils$count_hexbin_points_$_iter__38423(s__38424){
return (new cljs.core.LazySeq(null,(function (){
var s__38424__$1 = s__38424;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__38424__$1);
if(temp__4657__auto__){
var s__38424__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__38424__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__38424__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__38426 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__38425 = (0);
while(true){
if((i__38425 < size__7188__auto__)){
var map__38437 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__38425);
var map__38437__$1 = ((((!((map__38437 == null)))?((((map__38437.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38437.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38437):map__38437);
var feature = map__38437__$1;
var map__38438 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38437__$1,cljs.core.cst$kw$properties);
var map__38438__$1 = ((((!((map__38438 == null)))?((((map__38438.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38438.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38438):map__38438);
var points = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38438__$1,cljs.core.cst$kw$points);
var point_count = cljs.core.count(points);
cljs.core.chunk_append(b__38426,(((point_count > (0)))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(feature,cljs.core.cst$kw$properties,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$point_DASH_count,point_count], null)):null));

var G__38445 = (i__38425 + (1));
i__38425 = G__38445;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__38426),hatti$map$utils$count_hexbin_points_$_iter__38423(cljs.core.chunk_rest(s__38424__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__38426),null);
}
} else {
var map__38441 = cljs.core.first(s__38424__$2);
var map__38441__$1 = ((((!((map__38441 == null)))?((((map__38441.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38441.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38441):map__38441);
var feature = map__38441__$1;
var map__38442 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38441__$1,cljs.core.cst$kw$properties);
var map__38442__$1 = ((((!((map__38442 == null)))?((((map__38442.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38442.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38442):map__38442);
var points = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38442__$1,cljs.core.cst$kw$points);
var point_count = cljs.core.count(points);
return cljs.core.cons((((point_count > (0)))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(feature,cljs.core.cst$kw$properties,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$point_DASH_count,point_count], null)):null),hatti$map$utils$count_hexbin_points_$_iter__38423(cljs.core.rest(s__38424__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__(cljs.core.cst$kw$features.cljs$core$IFn$_invoke$arity$1(hexbins));
});
hatti.map.utils.get_rendered_features = (function hatti$map$utils$get_rendered_features(var_args){
var args__7491__auto__ = [];
var len__7484__auto___38453 = arguments.length;
var i__7485__auto___38454 = (0);
while(true){
if((i__7485__auto___38454 < len__7484__auto___38453)){
args__7491__auto__.push((arguments[i__7485__auto___38454]));

var G__38455 = (i__7485__auto___38454 + (1));
i__7485__auto___38454 = G__38455;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((2) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((2)),(0),null)):null);
return hatti.map.utils.get_rendered_features.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7492__auto__);
});

hatti.map.utils.get_rendered_features.cljs$core$IFn$_invoke$arity$variadic = (function (map,layer_id,p__38450){
var map__38451 = p__38450;
var map__38451__$1 = ((((!((map__38451 == null)))?((((map__38451.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38451.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38451):map__38451);
var geojson = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38451__$1,cljs.core.cst$kw$geojson);
var selected_ids = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38451__$1,cljs.core.cst$kw$selected_DASH_ids);

var get_rendered_features = ((function (map__38451,map__38451__$1,geojson,selected_ids){
return (function (){
return map.queryRenderedFeatures(cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$layers,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [layer_id], null)], null)));
});})(map__38451,map__38451__$1,geojson,selected_ids))
;
var rendered_features = (function (){var or__6409__auto__ = geojson;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$type,"FeatureCollection",cljs.core.cst$kw$features,get_rendered_features()], null);
}
})();
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(rendered_features,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$features], null),((function (get_rendered_features,rendered_features,map__38451,map__38451__$1,geojson,selected_ids){
return (function (p1__38446_SHARP_){
return hatti.map.utils.filter_selected_features(p1__38446_SHARP_,selected_ids);
});})(get_rendered_features,rendered_features,map__38451,map__38451__$1,geojson,selected_ids))
);
});

hatti.map.utils.get_rendered_features.cljs$lang$maxFixedArity = (2);

hatti.map.utils.get_rendered_features.cljs$lang$applyTo = (function (seq38447){
var G__38448 = cljs.core.first(seq38447);
var seq38447__$1 = cljs.core.next(seq38447);
var G__38449 = cljs.core.first(seq38447__$1);
var seq38447__$2 = cljs.core.next(seq38447__$1);
return hatti.map.utils.get_rendered_features.cljs$core$IFn$_invoke$arity$variadic(G__38448,G__38449,seq38447__$2);
});

/**
 * Generates hexbins with point count aggregation given rendered
 *   layer-id or geojson.
 */
hatti.map.utils.generate_hexgrid = (function hatti$map$utils$generate_hexgrid(map,layer_id,geojson,p__38456){
var map__38465 = p__38456;
var map__38465__$1 = ((((!((map__38465 == null)))?((((map__38465.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38465.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38465):map__38465);
var cell_width = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38465__$1,cljs.core.cst$kw$cell_DASH_width);
var selected_ids = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38465__$1,cljs.core.cst$kw$selected_DASH_ids);
var rendered_features = hatti.map.utils.get_rendered_features.cljs$core$IFn$_invoke$arity$variadic(map,layer_id,cljs.core.array_seq([cljs.core.cst$kw$geojson,geojson,cljs.core.cst$kw$selected_DASH_ids,selected_ids], 0));
var js_rendered_features = cljs.core.clj__GT_js(rendered_features);
var bbox = turf.bbox(js_rendered_features);
var cellWidth = (function (){var or__6409__auto__ = cell_width;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return hatti.constants.hexbin_cell_width;
}
})();
var units = "kilometers";
var hexgrid = turf.hexGrid(bbox,cellWidth,units);
var hex_collection = turf.collect(hexgrid,js_rendered_features,"_id","points");
var hexbins = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(hex_collection,cljs.core.array_seq([cljs.core.cst$kw$keywordize_DASH_keys,true], 0));
var features_w_count = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,hatti.map.utils.count_hexbin_points(hexbins));
var point_counts = (function (){var iter__7189__auto__ = ((function (rendered_features,js_rendered_features,bbox,cellWidth,units,hexgrid,hex_collection,hexbins,features_w_count,map__38465,map__38465__$1,cell_width,selected_ids){
return (function hatti$map$utils$generate_hexgrid_$_iter__38467(s__38468){
return (new cljs.core.LazySeq(null,((function (rendered_features,js_rendered_features,bbox,cellWidth,units,hexgrid,hex_collection,hexbins,features_w_count,map__38465,map__38465__$1,cell_width,selected_ids){
return (function (){
var s__38468__$1 = s__38468;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__38468__$1);
if(temp__4657__auto__){
var s__38468__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__38468__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__38468__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__38470 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__38469 = (0);
while(true){
if((i__38469 < size__7188__auto__)){
var f = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__38469);
cljs.core.chunk_append(b__38470,cljs.core.cst$kw$point_DASH_count.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$properties.cljs$core$IFn$_invoke$arity$1(f)));

var G__38473 = (i__38469 + (1));
i__38469 = G__38473;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__38470),hatti$map$utils$generate_hexgrid_$_iter__38467(cljs.core.chunk_rest(s__38468__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__38470),null);
}
} else {
var f = cljs.core.first(s__38468__$2);
return cljs.core.cons(cljs.core.cst$kw$point_DASH_count.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$properties.cljs$core$IFn$_invoke$arity$1(f)),hatti$map$utils$generate_hexgrid_$_iter__38467(cljs.core.rest(s__38468__$2)));
}
} else {
return null;
}
break;
}
});})(rendered_features,js_rendered_features,bbox,cellWidth,units,hexgrid,hex_collection,hexbins,features_w_count,map__38465,map__38465__$1,cell_width,selected_ids))
,null,null));
});})(rendered_features,js_rendered_features,bbox,cellWidth,units,hexgrid,hex_collection,hexbins,features_w_count,map__38465,map__38465__$1,cell_width,selected_ids))
;
return iter__7189__auto__(features_w_count);
})();
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(hexbins,cljs.core.cst$kw$features,features_w_count,cljs.core.array_seq([cljs.core.cst$kw$properties,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$min_DASH_count,cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.min,point_counts),cljs.core.cst$kw$max_DASH_count,cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.max,point_counts)], null)], 0));
});
/**
 * Show/or hide geopoints. Hide geopoints if hide-points is true.
 */
hatti.map.utils.show_hide_points = (function hatti$map$utils$show_hide_points(var_args){
var args__7491__auto__ = [];
var len__7484__auto___38481 = arguments.length;
var i__7485__auto___38482 = (0);
while(true){
if((i__7485__auto___38482 < len__7484__auto___38481)){
args__7491__auto__.push((arguments[i__7485__auto___38482]));

var G__38483 = (i__7485__auto___38482 + (1));
i__7485__auto___38482 = G__38483;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((2) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((2)),(0),null)):null);
return hatti.map.utils.show_hide_points.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7492__auto__);
});

hatti.map.utils.show_hide_points.cljs$core$IFn$_invoke$arity$variadic = (function (map,layer_id,p__38477){
var vec__38478 = p__38477;
var hide_points_QMARK_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38478,(0),null);
var visibility = (cljs.core.truth_(hide_points_QMARK_)?"none":"visible");
map.setLayoutProperty(layer_id,"visibility",visibility);

return map.setLayoutProperty("point-casting","visibility",visibility);
});

hatti.map.utils.show_hide_points.cljs$lang$maxFixedArity = (2);

hatti.map.utils.show_hide_points.cljs$lang$applyTo = (function (seq38474){
var G__38475 = cljs.core.first(seq38474);
var seq38474__$1 = cljs.core.next(seq38474);
var G__38476 = cljs.core.first(seq38474__$1);
var seq38474__$2 = cljs.core.next(seq38474__$1);
return hatti.map.utils.show_hide_points.cljs$core$IFn$_invoke$arity$variadic(G__38475,G__38476,seq38474__$2);
});

/**
 * Remove layer from map and it's source from map.
 */
hatti.map.utils.remove_layer = (function hatti$map$utils$remove_layer(var_args){
var args__7491__auto__ = [];
var len__7484__auto___38490 = arguments.length;
var i__7485__auto___38491 = (0);
while(true){
if((i__7485__auto___38491 < len__7484__auto___38490)){
args__7491__auto__.push((arguments[i__7485__auto___38491]));

var G__38492 = (i__7485__auto___38491 + (1));
i__7485__auto___38491 = G__38492;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((2) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((2)),(0),null)):null);
return hatti.map.utils.remove_layer.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7492__auto__);
});

hatti.map.utils.remove_layer.cljs$core$IFn$_invoke$arity$variadic = (function (map,id,p__38487){
var map__38488 = p__38487;
var map__38488__$1 = ((((!((map__38488 == null)))?((((map__38488.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38488.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38488):map__38488);
var keep_source_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38488__$1,cljs.core.cst$kw$keep_DASH_source_QMARK_);
if(cljs.core.truth_(map.getLayer(id))){
map.removeLayer(id);
} else {
}

if(cljs.core.truth_((function (){var and__6397__auto__ = map.getSource(id);
if(cljs.core.truth_(and__6397__auto__)){
return cljs.core.not(keep_source_QMARK_);
} else {
return and__6397__auto__;
}
})())){
return map.removeSource(id);
} else {
return null;
}
});

hatti.map.utils.remove_layer.cljs$lang$maxFixedArity = (2);

hatti.map.utils.remove_layer.cljs$lang$applyTo = (function (seq38484){
var G__38485 = cljs.core.first(seq38484);
var seq38484__$1 = cljs.core.next(seq38484);
var G__38486 = cljs.core.first(seq38484__$1);
var seq38484__$2 = cljs.core.next(seq38484__$1);
return hatti.map.utils.remove_layer.cljs$core$IFn$_invoke$arity$variadic(G__38485,G__38486,seq38484__$2);
});

/**
 * Renders hexbin layer on map.
 */
hatti.map.utils.show_hexbins = (function hatti$map$utils$show_hexbins(owner,map,id_string,geojson,p__38493){
var map__38498 = p__38493;
var map__38498__$1 = ((((!((map__38498 == null)))?((((map__38498.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38498.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38498):map__38498);
var opts = map__38498__$1;
var cell_color = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38498__$1,cljs.core.cst$kw$cell_DASH_color);
var extrusion_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38498__$1,cljs.core.cst$kw$extrusion_QMARK_);
var hide_points_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38498__$1,cljs.core.cst$kw$hide_DASH_points_QMARK_);
var hexgrid = hatti.map.utils.generate_hexgrid(map,id_string,geojson,opts);
var map__38500 = cljs.core.cst$kw$properties.cljs$core$IFn$_invoke$arity$1(hexgrid);
var map__38500__$1 = ((((!((map__38500 == null)))?((((map__38500.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38500.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38500):map__38500);
var min_count = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38500__$1,cljs.core.cst$kw$min_DASH_count);
var max_count = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38500__$1,cljs.core.cst$kw$max_DASH_count);
var max_color = (function (){var or__6409__auto__ = cell_color;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return hatti.constants.max_count_color;
}
})();
var min_color = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(min_count,max_count))?max_color:hatti.constants.min_count_color);
var property = "point-count";
var fill_color = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$property,"point-count",cljs.core.cst$kw$stops,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),"transparent"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [min_count,min_color], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [max_count,max_color], null)], null)], null);
var fill_opacity = 0.6;
var paint = (cljs.core.truth_(extrusion_QMARK_)?new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fill_DASH_extrusion_DASH_color,fill_color,cljs.core.cst$kw$fill_DASH_extrusion_DASH_opacity,fill_opacity,cljs.core.cst$kw$fill_DASH_extrusion_DASH_height,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$property,property,cljs.core.cst$kw$stops,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [min_count,(10)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [max_count,(25000)], null)], null),cljs.core.cst$kw$base,(1)], null)], null):new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fill_DASH_outline_DASH_color,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$property,property,cljs.core.cst$kw$stops,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),"transparent"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [max_count,"white"], null)], null)], null),cljs.core.cst$kw$fill_DASH_color,fill_color,cljs.core.cst$kw$fill_DASH_opacity,fill_opacity], null));
var layer_type = (cljs.core.truth_(extrusion_QMARK_)?"fill-extrusion":"fill");
var extrusion_layer_id = [cljs.core.str(hatti.constants.hexgrid_id),cljs.core.str("-extrusion")].join('');
if(cljs.core.truth_((function (){var and__6397__auto__ = min_count;
if(cljs.core.truth_(and__6397__auto__)){
return max_count;
} else {
return and__6397__auto__;
}
})())){
hatti.map.utils.add_mapboxgl_source(map,hatti.constants.hexgrid_id,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$geojson,hexgrid], null));

hatti.map.utils.add_mapboxgl_layer.cljs$core$IFn$_invoke$arity$variadic(map,hatti.constants.hexgrid_id,layer_type,cljs.core.array_seq([cljs.core.cst$kw$paint,paint], 0));

if(cljs.core.truth_(extrusion_QMARK_)){
hatti.map.utils.add_mapboxgl_layer.cljs$core$IFn$_invoke$arity$variadic(map,hatti.constants.hexgrid_id,layer_type,cljs.core.array_seq([cljs.core.cst$kw$paint,paint,cljs.core.cst$kw$layer_DASH_id,extrusion_layer_id], 0));

map.setLayoutProperty(hatti.constants.hexgrid_id,"visibility","none");
} else {
map.setLayoutProperty(hatti.constants.hexgrid_id,"visibility","visible");

hatti.map.utils.remove_layer.cljs$core$IFn$_invoke$arity$variadic(map,extrusion_layer_id,cljs.core.array_seq([cljs.core.cst$kw$keep_DASH_source_QMARK_,true], 0));
}

map.setPitch((cljs.core.truth_(extrusion_QMARK_)?(50):(0)));

hatti.map.utils.show_hide_points.cljs$core$IFn$_invoke$arity$variadic(map,id_string,cljs.core.array_seq([hide_points_QMARK_], 0));

return om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$show_DASH_hexbins_QMARK_,true);
} else {
return null;
}
});
/**
 * Renders heatmap layer on map.
 */
hatti.map.utils.show_heatmap = (function hatti$map$utils$show_heatmap(owner,map,id_string,geojson,p__38502){
var map__38521 = p__38502;
var map__38521__$1 = ((((!((map__38521 == null)))?((((map__38521.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38521.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38521):map__38521);
var selected_ids = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38521__$1,cljs.core.cst$kw$selected_DASH_ids);
var rendered_features = hatti.map.utils.get_rendered_features.cljs$core$IFn$_invoke$arity$variadic(map,id_string,cljs.core.array_seq([cljs.core.cst$kw$geojson,geojson,cljs.core.cst$kw$selected_DASH_ids,selected_ids], 0));
var layers = cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(((function (rendered_features,map__38521,map__38521__$1,selected_ids){
return (function (idx,item){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [idx,item], null);
});})(rendered_features,map__38521,map__38521__$1,selected_ids))
,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),"green"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(30),"#ffeda0"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(80),"orange"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(200),"red"], null)], null));
var layer_count = cljs.core.count(layers);
hatti.map.utils.add_mapboxgl_source(map,"heatmap",new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$geojson,rendered_features,cljs.core.cst$kw$cluster,true,cljs.core.cst$kw$clusterRadius,(20),cljs.core.cst$kw$clusterMaxZoom,(15)], null));

var seq__38523_38539 = cljs.core.seq(layers);
var chunk__38524_38540 = null;
var count__38525_38541 = (0);
var i__38526_38542 = (0);
while(true){
if((i__38526_38542 < count__38525_38541)){
var vec__38527_38543 = chunk__38524_38540.cljs$core$IIndexed$_nth$arity$2(null,i__38526_38542);
var i_38544 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38527_38543,(0),null);
var vec__38530_38545 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38527_38543,(1),null);
var point_count_38546 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38530_38545,(0),null);
var color_38547 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38530_38545,(1),null);
hatti.map.utils.add_mapboxgl_layer.cljs$core$IFn$_invoke$arity$variadic(map,"heatmap","circle",cljs.core.array_seq([cljs.core.cst$kw$layer_DASH_id,[cljs.core.str("cluster-"),cljs.core.str(i_38544)].join(''),cljs.core.cst$kw$paint,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$circle_DASH_color,color_38547,cljs.core.cst$kw$circle_DASH_radius,(70),cljs.core.cst$kw$circle_DASH_blur,(1),cljs.core.cst$kw$circle_DASH_opacity,0.7], null),cljs.core.cst$kw$filter,((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(i_38544,(layer_count - (1))))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [">=","point_count",point_count_38546], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["all",new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [">=","point_count",point_count_38546], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["<","point_count",cljs.core.first(cljs.core.second(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(layers,(i_38544 + (1)))))], null)], null))], 0));

var G__38548 = seq__38523_38539;
var G__38549 = chunk__38524_38540;
var G__38550 = count__38525_38541;
var G__38551 = (i__38526_38542 + (1));
seq__38523_38539 = G__38548;
chunk__38524_38540 = G__38549;
count__38525_38541 = G__38550;
i__38526_38542 = G__38551;
continue;
} else {
var temp__4657__auto___38552 = cljs.core.seq(seq__38523_38539);
if(temp__4657__auto___38552){
var seq__38523_38553__$1 = temp__4657__auto___38552;
if(cljs.core.chunked_seq_QMARK_(seq__38523_38553__$1)){
var c__7220__auto___38554 = cljs.core.chunk_first(seq__38523_38553__$1);
var G__38555 = cljs.core.chunk_rest(seq__38523_38553__$1);
var G__38556 = c__7220__auto___38554;
var G__38557 = cljs.core.count(c__7220__auto___38554);
var G__38558 = (0);
seq__38523_38539 = G__38555;
chunk__38524_38540 = G__38556;
count__38525_38541 = G__38557;
i__38526_38542 = G__38558;
continue;
} else {
var vec__38533_38559 = cljs.core.first(seq__38523_38553__$1);
var i_38560 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38533_38559,(0),null);
var vec__38536_38561 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38533_38559,(1),null);
var point_count_38562 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38536_38561,(0),null);
var color_38563 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38536_38561,(1),null);
hatti.map.utils.add_mapboxgl_layer.cljs$core$IFn$_invoke$arity$variadic(map,"heatmap","circle",cljs.core.array_seq([cljs.core.cst$kw$layer_DASH_id,[cljs.core.str("cluster-"),cljs.core.str(i_38560)].join(''),cljs.core.cst$kw$paint,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$circle_DASH_color,color_38563,cljs.core.cst$kw$circle_DASH_radius,(70),cljs.core.cst$kw$circle_DASH_blur,(1),cljs.core.cst$kw$circle_DASH_opacity,0.7], null),cljs.core.cst$kw$filter,((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(i_38560,(layer_count - (1))))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [">=","point_count",point_count_38562], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["all",new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [">=","point_count",point_count_38562], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["<","point_count",cljs.core.first(cljs.core.second(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(layers,(i_38560 + (1)))))], null)], null))], 0));

var G__38564 = cljs.core.next(seq__38523_38553__$1);
var G__38565 = null;
var G__38566 = (0);
var G__38567 = (0);
seq__38523_38539 = G__38564;
chunk__38524_38540 = G__38565;
count__38525_38541 = G__38566;
i__38526_38542 = G__38567;
continue;
}
} else {
}
}
break;
}

hatti.map.utils.show_hide_points.cljs$core$IFn$_invoke$arity$variadic(map,id_string,cljs.core.array_seq([true], 0));

return om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$show_DASH_heatmap_QMARK_,true);
});
/**
 * Functions that are called after map is loaded in DOM.
 */
hatti.map.utils.map_on_load = (function hatti$map$utils$map_on_load(var_args){
var args__7491__auto__ = [];
var len__7484__auto___38579 = arguments.length;
var i__7485__auto___38580 = (0);
while(true){
if((i__7485__auto___38580 < len__7484__auto___38579)){
args__7491__auto__.push((arguments[i__7485__auto___38580]));

var G__38581 = (i__7485__auto___38580 + (1));
i__7485__auto___38580 = G__38581;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((3) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((3)),(0),null)):null);
return hatti.map.utils.map_on_load.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7492__auto__);
});

hatti.map.utils.map_on_load.cljs$core$IFn$_invoke$arity$variadic = (function (map,event_chan,id_string,p__38572){
var map__38573 = p__38572;
var map__38573__$1 = ((((!((map__38573 == null)))?((((map__38573.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38573.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38573):map__38573);
var map_data = map__38573__$1;
var geofield = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38573__$1,cljs.core.cst$kw$geofield);
var owner = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38573__$1,cljs.core.cst$kw$owner);
var tiles_url = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38573__$1,cljs.core.cst$kw$tiles_DASH_url);
var geojson = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38573__$1,cljs.core.cst$kw$geojson);
var map__38575 = hatti.map.utils.geotype__GT_marker_style(geofield);
var map__38575__$1 = ((((!((map__38575 == null)))?((((map__38575.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38575.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38575):map__38575);
var layer_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38575__$1,cljs.core.cst$kw$layer_DASH_type);
var layout = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38575__$1,cljs.core.cst$kw$layout);
var style = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38575__$1,cljs.core.cst$kw$style);
var map__38576 = om.core.get_state.cljs$core$IFn$_invoke$arity$1(owner);
var map__38576__$1 = ((((!((map__38576 == null)))?((((map__38576.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38576.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38576):map__38576);
var stops = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38576__$1,cljs.core.cst$kw$stops);
var layer_opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38576__$1,cljs.core.cst$kw$layer_DASH_opts);
var show_hexbins_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38576__$1,cljs.core.cst$kw$show_DASH_hexbins_QMARK_);
var show_heatmap_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38576__$1,cljs.core.cst$kw$show_DASH_heatmap_QMARK_);
var circle_border = "point-casting";
if(cljs.core.truth_((function (){var or__6409__auto__ = (cljs.core.count(cljs.core.cst$kw$features.cljs$core$IFn$_invoke$arity$1(geojson)) > (0));
if(or__6409__auto__){
return or__6409__auto__;
} else {
return tiles_url;
}
})())){
om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$loaded_QMARK_,false);

hatti.map.utils.add_mapboxgl_source(map,id_string,map_data);

hatti.map.utils.add_mapboxgl_layer.cljs$core$IFn$_invoke$arity$variadic(map,id_string,layer_type,cljs.core.array_seq([cljs.core.cst$kw$layout,layout,cljs.core.cst$kw$tiles_DASH_url,tiles_url], 0));

hatti.map.utils.register_mapboxgl_mouse_events(owner,map,event_chan,id_string,style);

hatti.map.utils.set_mapboxgl_paint_property(map,id_string,hatti.map.utils.get_style_properties.cljs$core$IFn$_invoke$arity$variadic(style,cljs.core.cst$kw$normal,cljs.core.array_seq([cljs.core.cst$kw$stops,stops], 0)));

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$point,style)){
hatti.map.utils.add_mapboxgl_layer.cljs$core$IFn$_invoke$arity$variadic(map,id_string,layer_type,cljs.core.array_seq([cljs.core.cst$kw$layer_DASH_id,circle_border,cljs.core.cst$kw$tiles_DASH_url,tiles_url,cljs.core.cst$kw$paint,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$circle_DASH_color,"#fff",cljs.core.cst$kw$circle_DASH_radius,(6)], null)], 0));
} else {
if(cljs.core.truth_(map.getLayer(circle_border))){
map.removeLayer(circle_border);
} else {
}
}

if(cljs.core.truth_(show_hexbins_QMARK_)){
hatti.map.utils.show_hexbins(owner,map,id_string,geojson,layer_opts);
} else {
}

if(cljs.core.truth_(show_heatmap_QMARK_)){
hatti.map.utils.show_heatmap(owner,map,id_string,geojson,layer_opts);
} else {
}

om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$style,style);

return om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$loaded_QMARK_,true);
} else {
return null;
}
});

hatti.map.utils.map_on_load.cljs$lang$maxFixedArity = (3);

hatti.map.utils.map_on_load.cljs$lang$applyTo = (function (seq38568){
var G__38569 = cljs.core.first(seq38568);
var seq38568__$1 = cljs.core.next(seq38568);
var G__38570 = cljs.core.first(seq38568__$1);
var seq38568__$2 = cljs.core.next(seq38568__$1);
var G__38571 = cljs.core.first(seq38568__$2);
var seq38568__$3 = cljs.core.next(seq38568__$2);
return hatti.map.utils.map_on_load.cljs$core$IFn$_invoke$arity$variadic(G__38569,G__38570,G__38571,seq38568__$3);
});

/**
 * Set default style
 */
hatti.map.utils.clear_map_styles = (function hatti$map$utils$clear_map_styles(owner){
return hatti.map.utils.set_mapboxgl_paint_property(om.core.get_state.cljs$core$IFn$_invoke$arity$2(owner,cljs.core.cst$kw$mapboxgl_DASH_map),om.core.get_state.cljs$core$IFn$_invoke$arity$2(owner,cljs.core.cst$kw$layer_DASH_id),hatti.map.utils.get_style_properties(om.core.get_state.cljs$core$IFn$_invoke$arity$2(owner,cljs.core.cst$kw$style),cljs.core.cst$kw$normal));
});
/**
 * Update map zoom level in local component state on zoom event.
 */
hatti.map.utils.set_zoom_level = (function hatti$map$utils$set_zoom_level(owner){
var map__38584 = om.core.get_state.cljs$core$IFn$_invoke$arity$1(owner);
var map__38584__$1 = ((((!((map__38584 == null)))?((((map__38584.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38584.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38584):map__38584);
var mapboxgl_map = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38584__$1,cljs.core.cst$kw$mapboxgl_DASH_map);
var zoom = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38584__$1,cljs.core.cst$kw$zoom);
var next_zoom = mapboxgl_map.getZoom();
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(zoom,next_zoom)){
return om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$zoom,next_zoom);
} else {
return null;
}
});
