// Compiled by ClojureScript 1.9.229 {:static-fns true, :optimize-constants true}
goog.provide('hatti.views.table');
goog.require('cljs.core');
goog.require('hatti.views.record');
goog.require('chimera.js_interop');
goog.require('om.dom');
goog.require('hatti.ona.forms');
goog.require('sablono.core');
goog.require('cljs.core.async');
goog.require('chimera.seq');
goog.require('hatti.shared');
goog.require('hatti.constants');
goog.require('hatti.views');
goog.require('om.core');
goog.require('hatti.utils');
goog.require('chimera.core');
goog.require('chimera.urls');
hatti.views.table.default_num_displayed_records = (25);
hatti.views.table.table_id = "submission-grid";
hatti.views.table.pager_id = "pager";
/**
 * Extra fields that will be displayed on the table.
 */
hatti.views.table.get_extra_fields = (function hatti$views$table$get_extra_fields(is_filtered_dataview_QMARK_){
var id_field = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$full_DASH_name,hatti.constants._id,cljs.core.cst$kw$label,"ID",cljs.core.cst$kw$name,hatti.constants._id,cljs.core.cst$kw$type,"integer"], null)], null);
var G__43937 = id_field;
if(cljs.core.not(is_filtered_dataview_QMARK_)){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(G__43937,hatti.ona.forms.submission_time_field);
} else {
return G__43937;
}
});
/**
 * Given a (flat-)form, returns fields for table display.
 * Puts extra fields in the beginning, metadata at the end of the table,
 * and drops fields that have no data (eg. group/note).
 */
hatti.views.table.all_fields = (function hatti$views$table$all_fields(var_args){
var args__7491__auto__ = [];
var len__7484__auto___43943 = arguments.length;
var i__7485__auto___43944 = (0);
while(true){
if((i__7485__auto___43944 < len__7484__auto___43943)){
args__7491__auto__.push((arguments[i__7485__auto___43944]));

var G__43945 = (i__7485__auto___43944 + (1));
i__7485__auto___43944 = G__43945;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return hatti.views.table.all_fields.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

hatti.views.table.all_fields.cljs$core$IFn$_invoke$arity$variadic = (function (form,p__43940){
var map__43941 = p__43940;
var map__43941__$1 = ((((!((map__43941 == null)))?((((map__43941.cljs$lang$protocol_mask$partition0$ & (64))) || (map__43941.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__43941):map__43941);
var is_filtered_dataview_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43941__$1,cljs.core.cst$kw$is_DASH_filtered_DASH_dataview_QMARK_);
return cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.has_data_QMARK_,cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic(hatti.views.table.get_extra_fields(is_filtered_dataview_QMARK_),hatti.ona.forms.non_meta_fields(form),cljs.core.array_seq([hatti.ona.forms.meta_fields.cljs$core$IFn$_invoke$arity$variadic(form,cljs.core.array_seq([cljs.core.cst$kw$with_DASH_submission_DASH_details_QMARK_,cljs.core.not(is_filtered_dataview_QMARK_)], 0))], 0))));
});

hatti.views.table.all_fields.cljs$lang$maxFixedArity = (1);

hatti.views.table.all_fields.cljs$lang$applyTo = (function (seq43938){
var G__43939 = cljs.core.first(seq43938);
var seq43938__$1 = cljs.core.next(seq43938);
return hatti.views.table.all_fields.cljs$core$IFn$_invoke$arity$variadic(G__43939,seq43938__$1);
});

/**
 * Comparator function for the slickgrid dataview.
 * args.sortCol is the column being sorted, a and b are rows to compare.
 * Claims a is bigger (return 1) if value for a > b, or a is null / empty.
 */
hatti.views.table.compfn = (function hatti$views$table$compfn(args){
return (function (a,b){
var col = (args["sortCol"]);
var lower = ((function (col){
return (function (p1__43946_SHARP_){
if(typeof p1__43946_SHARP_ === 'string'){
return clojure.string.lower_case(p1__43946_SHARP_);
} else {
return p1__43946_SHARP_;
}
});})(col))
;
var aval = lower((a[(col["field"])]));
var bval = lower((b[(col["field"])]));
if(((aval == null)) || ((aval > bval))){
return (1);
} else {
return (-1);
}
});
});
/**
 * Filter function for the slickgrid dataview, use as (partial filterfn form)
 * item is the row, args contains query.
 * Return value of false corresponds with exclusion, true with inclusion.
 */
hatti.views.table.filterfn = (function hatti$views$table$filterfn(form,item,args){
if(cljs.core.not(args)){
return true;
} else {
var indexed_form = cljs.core.zipmap(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$full_DASH_name,form),form);
var query = (args["query"]);
var fmt_subitem = ((function (indexed_form,query){
return (function (p__43952){
var vec__43953 = p__43952;
var fname = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43953,(0),null);
var answer = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43953,(1),null);
return hatti.ona.forms.format_answer.cljs$core$IFn$_invoke$arity$variadic(cljs.core.get.cljs$core$IFn$_invoke$arity$2(indexed_form,fname),answer,cljs.core.array_seq([cljs.core.cst$kw$compact_QMARK_,true], 0));
});})(indexed_form,query))
;
var filtered = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (indexed_form,query,fmt_subitem){
return (function (p1__43947_SHARP_){
return cljs.core.re_find(chimera.js_interop.safe_regex(query),[cljs.core.str(p1__43947_SHARP_)].join(''));
});})(indexed_form,query,fmt_subitem))
,cljs.core.map.cljs$core$IFn$_invoke$arity$2(fmt_subitem,cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$1(item))));
return cljs.core.seq(filtered);
}
});
/**
 * Formatter for slickgrid columns takes row,cell,value,columnDef,dataContext.
 * Get one with (partial formatter field language).
 */
hatti.views.table.formatter = (function hatti$views$table$formatter(field,language,row,cell,value,columnDef,dataContext){
var clj_value = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(value,cljs.core.array_seq([cljs.core.cst$kw$keywordize_DASH_keys,true], 0));
return hatti.ona.forms.format_answer.cljs$core$IFn$_invoke$arity$variadic(field,clj_value,cljs.core.array_seq([cljs.core.cst$kw$language,language,cljs.core.cst$kw$compact_QMARK_,true], 0));
});
hatti.views.action_buttons.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (owner){
return (function (row,cell,value,columnDef,dataContext){
var map__43956 = cljs.core.cst$kw$dataset_DASH_info.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.shared.app_state) : cljs.core.deref.call(null,hatti.shared.app_state)));
var map__43956__$1 = ((((!((map__43956 == null)))?((((map__43956.cljs$lang$protocol_mask$partition0$ & (64))) || (map__43956.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__43956):map__43956);
var owner__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43956__$1,cljs.core.cst$kw$owner);
var project = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43956__$1,cljs.core.cst$kw$project);
var formid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43956__$1,cljs.core.cst$kw$formid);
var form_owner = chimera.urls.last_url_param(owner__$1);
var project_id = chimera.urls.last_url_param(project);
var edit_link = chimera.urls.url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([form_owner,project_id,formid,[cljs.core.str("webform?instance-id="),cljs.core.str(value)].join('')], 0));
return hatti.utils.generate_html.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([(cljs.core.truth_(value)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$ul,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li$tooltip$middle_DASH_right,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$tip_DASH_info,"View"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a$view_DASH_record,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$i$fa$fa_DASH_clone,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$data_DASH_id,value], null)], null)], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li$tooltip,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$tip_DASH_info,"Edit"], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a$edit_DASH_record,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$data_DASH_id,value,cljs.core.cst$kw$target,"_blank",cljs.core.cst$kw$href,edit_link], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$i$fa$fa_DASH_pencil_DASH_square_DASH_o], null)], null)], null)], null):null)], 0));
});
}));
/**
 * The html needed for a column name as a string.
 * String, String, Bool -> String
 */
hatti.views.table.column_name_html_string = (function hatti$views$table$column_name_html_string(column_class,label,hxl){
return [cljs.core.str("<div class=\""),cljs.core.str(column_class),cljs.core.str("\">"),cljs.core.str(label),cljs.core.str("</div>"),cljs.core.str((cljs.core.truth_(hxl)?[cljs.core.str("<div class=\"hxl-row\">"),cljs.core.str(hxl),cljs.core.str("</div>")].join(''):null))].join('');
});
hatti.views.table.actions_column = (function hatti$views$table$actions_column(owner,has_hxl_QMARK_){
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$headerCssClass,cljs.core.cst$kw$maxWidth,cljs.core.cst$kw$name,cljs.core.cst$kw$formatter,cljs.core.cst$kw$field,cljs.core.cst$kw$type,cljs.core.cst$kw$id,cljs.core.cst$kw$sortable,cljs.core.cst$kw$cssClass,cljs.core.cst$kw$toolTip],[[cljs.core.str((cljs.core.truth_(has_hxl_QMARK_)?"hxl-min-height ":null)),cljs.core.str("record-actions header")].join(''),(70),"",(hatti.views.action_buttons.cljs$core$IFn$_invoke$arity$1 ? hatti.views.action_buttons.cljs$core$IFn$_invoke$arity$1(owner) : hatti.views.action_buttons.call(null,owner)),hatti.constants._id,"text","actions",false,"record-actions",""]);
});
/**
 * Get a set of slick grid column objects when given a flat form.
 */
hatti.views.table.flat_form__GT_sg_columns = (function hatti$views$table$flat_form__GT_sg_columns(var_args){
var args__7491__auto__ = [];
var len__7484__auto___43989 = arguments.length;
var i__7485__auto___43990 = (0);
while(true){
if((i__7485__auto___43990 < len__7484__auto___43989)){
args__7491__auto__.push((arguments[i__7485__auto___43990]));

var G__43991 = (i__7485__auto___43990 + (1));
i__7485__auto___43990 = G__43991;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic = (function (form,p__43961){
var map__43962 = p__43961;
var map__43962__$1 = ((((!((map__43962 == null)))?((((map__43962.cljs$lang$protocol_mask$partition0$ & (64))) || (map__43962.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__43962):map__43962);
var hide_actions_column_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43962__$1,cljs.core.cst$kw$hide_DASH_actions_DASH_column_QMARK_);
var is_filtered_dataview_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43962__$1,cljs.core.cst$kw$is_DASH_filtered_DASH_dataview_QMARK_);
var get_label_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__43962__$1,cljs.core.cst$kw$get_DASH_label_QMARK_,true);
var language = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43962__$1,cljs.core.cst$kw$language);
var owner = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43962__$1,cljs.core.cst$kw$owner);
var has_hxl_QMARK_ = (function (){var G__43964 = cljs.core.false_QMARK_;
var G__43965 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (G__43964,map__43962,map__43962__$1,hide_actions_column_QMARK_,is_filtered_dataview_QMARK_,get_label_QMARK_,language,owner){
return (function (p1__43958_SHARP_){
return (cljs.core.cst$kw$hxl.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$instance.cljs$core$IFn$_invoke$arity$1(p1__43958_SHARP_)) == null);
});})(G__43964,map__43962,map__43962__$1,hide_actions_column_QMARK_,is_filtered_dataview_QMARK_,get_label_QMARK_,language,owner))
,form);
return (chimera.core.any_QMARK_.cljs$core$IFn$_invoke$arity$2 ? chimera.core.any_QMARK_.cljs$core$IFn$_invoke$arity$2(G__43964,G__43965) : chimera.core.any_QMARK_.call(null,G__43964,G__43965));
})();
var columns = (function (){var iter__7189__auto__ = ((function (has_hxl_QMARK_,map__43962,map__43962__$1,hide_actions_column_QMARK_,is_filtered_dataview_QMARK_,get_label_QMARK_,language,owner){
return (function hatti$views$table$iter__43966(s__43967){
return (new cljs.core.LazySeq(null,((function (has_hxl_QMARK_,map__43962,map__43962__$1,hide_actions_column_QMARK_,is_filtered_dataview_QMARK_,get_label_QMARK_,language,owner){
return (function (){
var s__43967__$1 = s__43967;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__43967__$1);
if(temp__4657__auto__){
var s__43967__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__43967__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__43967__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__43969 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__43968 = (0);
while(true){
if((i__43968 < size__7188__auto__)){
var field = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__43968);
cljs.core.chunk_append(b__43969,(function (){var map__43980 = field;
var map__43980__$1 = ((((!((map__43980 == null)))?((((map__43980.cljs$lang$protocol_mask$partition0$ & (64))) || (map__43980.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__43980):map__43980);
var map__43981 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43980__$1,cljs.core.cst$kw$instance);
var map__43981__$1 = ((((!((map__43981 == null)))?((((map__43981.cljs$lang$protocol_mask$partition0$ & (64))) || (map__43981.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__43981):map__43981);
var hxl = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43981__$1,cljs.core.cst$kw$hxl);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43980__$1,cljs.core.cst$kw$name);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43980__$1,cljs.core.cst$kw$type);
var full_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43980__$1,cljs.core.cst$kw$full_DASH_name);
var label = (cljs.core.truth_(get_label_QMARK_)?hatti.ona.forms.get_label.cljs$core$IFn$_invoke$arity$variadic(field,cljs.core.array_seq([language], 0)):name);
var column_class = hatti.ona.forms.get_column_class(field);
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$hxl,cljs.core.cst$kw$headerCssClass,cljs.core.cst$kw$name,cljs.core.cst$kw$formatter,cljs.core.cst$kw$minWidth,cljs.core.cst$kw$field,cljs.core.cst$kw$type,cljs.core.cst$kw$id,cljs.core.cst$kw$sortable,cljs.core.cst$kw$cssClass,cljs.core.cst$kw$toolTip],[hxl,(cljs.core.truth_(has_hxl_QMARK_)?"hxl-min-height":null),hatti.views.table.column_name_html_string(column_class,label,hxl),cljs.core.partial.cljs$core$IFn$_invoke$arity$3(hatti.views.table.formatter,field,language),(50),full_name,type,name,true,column_class,label]);
})());

var G__43992 = (i__43968 + (1));
i__43968 = G__43992;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__43969),hatti$views$table$iter__43966(cljs.core.chunk_rest(s__43967__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__43969),null);
}
} else {
var field = cljs.core.first(s__43967__$2);
return cljs.core.cons((function (){var map__43984 = field;
var map__43984__$1 = ((((!((map__43984 == null)))?((((map__43984.cljs$lang$protocol_mask$partition0$ & (64))) || (map__43984.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__43984):map__43984);
var map__43985 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43984__$1,cljs.core.cst$kw$instance);
var map__43985__$1 = ((((!((map__43985 == null)))?((((map__43985.cljs$lang$protocol_mask$partition0$ & (64))) || (map__43985.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__43985):map__43985);
var hxl = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43985__$1,cljs.core.cst$kw$hxl);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43984__$1,cljs.core.cst$kw$name);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43984__$1,cljs.core.cst$kw$type);
var full_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43984__$1,cljs.core.cst$kw$full_DASH_name);
var label = (cljs.core.truth_(get_label_QMARK_)?hatti.ona.forms.get_label.cljs$core$IFn$_invoke$arity$variadic(field,cljs.core.array_seq([language], 0)):name);
var column_class = hatti.ona.forms.get_column_class(field);
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$hxl,cljs.core.cst$kw$headerCssClass,cljs.core.cst$kw$name,cljs.core.cst$kw$formatter,cljs.core.cst$kw$minWidth,cljs.core.cst$kw$field,cljs.core.cst$kw$type,cljs.core.cst$kw$id,cljs.core.cst$kw$sortable,cljs.core.cst$kw$cssClass,cljs.core.cst$kw$toolTip],[hxl,(cljs.core.truth_(has_hxl_QMARK_)?"hxl-min-height":null),hatti.views.table.column_name_html_string(column_class,label,hxl),cljs.core.partial.cljs$core$IFn$_invoke$arity$3(hatti.views.table.formatter,field,language),(50),full_name,type,name,true,column_class,label]);
})(),hatti$views$table$iter__43966(cljs.core.rest(s__43967__$2)));
}
} else {
return null;
}
break;
}
});})(has_hxl_QMARK_,map__43962,map__43962__$1,hide_actions_column_QMARK_,is_filtered_dataview_QMARK_,get_label_QMARK_,language,owner))
,null,null));
});})(has_hxl_QMARK_,map__43962,map__43962__$1,hide_actions_column_QMARK_,is_filtered_dataview_QMARK_,get_label_QMARK_,language,owner))
;
return iter__7189__auto__(hatti.views.table.all_fields.cljs$core$IFn$_invoke$arity$variadic(form,cljs.core.array_seq([cljs.core.cst$kw$is_DASH_filtered_DASH_dataview_QMARK_,is_filtered_dataview_QMARK_], 0)));
})();
return cljs.core.clj__GT_js((function (){var G__43988 = columns;
if(cljs.core.not(hide_actions_column_QMARK_)){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(G__43988,hatti.views.table.actions_column(owner,has_hxl_QMARK_));
} else {
return G__43988;
}
})());
});

hatti.views.table.flat_form__GT_sg_columns.cljs$lang$maxFixedArity = (1);

hatti.views.table.flat_form__GT_sg_columns.cljs$lang$applyTo = (function (seq43959){
var G__43960 = cljs.core.first(seq43959);
var seq43959__$1 = cljs.core.next(seq43959);
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic(G__43960,seq43959__$1);
});

hatti.views.table.init_sg_pager = (function hatti$views$table$init_sg_pager(grid,dataview){
var Pager = Slick.Controls.Pager;
return (new Pager(dataview,grid,(function (){var G__43994 = [cljs.core.str("#"),cljs.core.str(hatti.views.table.pager_id)].join('');
return jQuery(G__43994);
})()));
});
hatti.views.table.resizeColumns = (function hatti$views$table$resizeColumns(grid){
return grid.registerPlugin(Slick.AutoColumnSize());
});
/**
 * Options to feed the slickgrid constructor.
 */
hatti.views.table.sg_options = ({"autoHeight": true, "enableColumnReorder": false, "enableTextSelectionOnCells": true, "rowHeight": (40), "syncColumnCellResize": false});
hatti.views.table.bind_external_sg_grid_event_handlers = (function hatti$views$table$bind_external_sg_grid_event_handlers(grid,event_handlers){
return cljs.core.doall.cljs$core$IFn$_invoke$arity$1((function (){var iter__7189__auto__ = (function hatti$views$table$bind_external_sg_grid_event_handlers_$_iter__44013(s__44014){
return (new cljs.core.LazySeq(null,(function (){
var s__44014__$1 = s__44014;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__44014__$1);
if(temp__4657__auto__){
var s__44014__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__44014__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__44014__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__44016 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__44015 = (0);
while(true){
if((i__44015 < size__7188__auto__)){
var vec__44025 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__44015);
var handler_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44025,(0),null);
var handler_function = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44025,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case(cljs.core.name(handler_key));
var event = (grid[handler_name]);
cljs.core.chunk_append(b__44016,event.subscribe(handler_function));

var G__44031 = (i__44015 + (1));
i__44015 = G__44031;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__44016),hatti$views$table$bind_external_sg_grid_event_handlers_$_iter__44013(cljs.core.chunk_rest(s__44014__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__44016),null);
}
} else {
var vec__44028 = cljs.core.first(s__44014__$2);
var handler_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44028,(0),null);
var handler_function = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44028,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case(cljs.core.name(handler_key));
var event = (grid[handler_name]);
return cljs.core.cons(event.subscribe(handler_function),hatti$views$table$bind_external_sg_grid_event_handlers_$_iter__44013(cljs.core.rest(s__44014__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__(event_handlers);
})());
});
hatti.views.table.bind_external_sg_grid_dataview_handlers = (function hatti$views$table$bind_external_sg_grid_dataview_handlers(dataview,event_handlers){
return cljs.core.doall.cljs$core$IFn$_invoke$arity$1((function (){var iter__7189__auto__ = (function hatti$views$table$bind_external_sg_grid_dataview_handlers_$_iter__44050(s__44051){
return (new cljs.core.LazySeq(null,(function (){
var s__44051__$1 = s__44051;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__44051__$1);
if(temp__4657__auto__){
var s__44051__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__44051__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__44051__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__44053 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__44052 = (0);
while(true){
if((i__44052 < size__7188__auto__)){
var vec__44062 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__44052);
var handler_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44062,(0),null);
var handler_function = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44062,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case(cljs.core.name(handler_key));
var event = (dataview[handler_name]);
cljs.core.chunk_append(b__44053,event.subscribe(handler_function));

var G__44068 = (i__44052 + (1));
i__44052 = G__44068;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__44053),hatti$views$table$bind_external_sg_grid_dataview_handlers_$_iter__44050(cljs.core.chunk_rest(s__44051__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__44053),null);
}
} else {
var vec__44065 = cljs.core.first(s__44051__$2);
var handler_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44065,(0),null);
var handler_function = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44065,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case(cljs.core.name(handler_key));
var event = (dataview[handler_name]);
return cljs.core.cons(event.subscribe(handler_function),hatti$views$table$bind_external_sg_grid_dataview_handlers_$_iter__44050(cljs.core.rest(s__44051__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__(event_handlers);
})());
});
/**
 * Creates a Slick.Grid backed by Slick.Data.DataView from data and fields.
 * Most events are handled by slickgrid. On double-click, event is put on chan.
 * Returns [grid dataview].
 */
hatti.views.table.sg_init = (function hatti$views$table$sg_init(data,form,current_language,is_filtered_dataview_QMARK_,owner,p__44069){
var map__44079 = p__44069;
var map__44079__$1 = ((((!((map__44079 == null)))?((((map__44079.cljs$lang$protocol_mask$partition0$ & (64))) || (map__44079.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__44079):map__44079);
var grid_event_handlers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44079__$1,cljs.core.cst$kw$grid_DASH_event_DASH_handlers);
var dataview_event_handlers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44079__$1,cljs.core.cst$kw$dataview_DASH_event_DASH_handlers);
var map__44081 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.shared.app_state) : cljs.core.deref.call(null,hatti.shared.app_state));
var map__44081__$1 = ((((!((map__44081 == null)))?((((map__44081.cljs$lang$protocol_mask$partition0$ & (64))) || (map__44081.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__44081):map__44081);
var map__44082 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44081__$1,cljs.core.cst$kw$table_DASH_page);
var map__44082__$1 = ((((!((map__44082 == null)))?((((map__44082.cljs$lang$protocol_mask$partition0$ & (64))) || (map__44082.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__44082):map__44082);
var map__44083 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44082__$1,cljs.core.cst$kw$paging);
var map__44083__$1 = ((((!((map__44083 == null)))?((((map__44083.cljs$lang$protocol_mask$partition0$ & (64))) || (map__44083.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__44083):map__44083);
var num_displayed_records = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44083__$1,cljs.core.cst$kw$num_DASH_displayed_DASH_records);
var total_page_count = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44083__$1,cljs.core.cst$kw$total_DASH_page_DASH_count);
var hide_actions_column_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44082__$1,cljs.core.cst$kw$hide_DASH_actions_DASH_column_QMARK_);
var columns = hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic(form,cljs.core.array_seq([cljs.core.cst$kw$language,current_language,cljs.core.cst$kw$hide_DASH_actions_DASH_column_QMARK_,hide_actions_column_QMARK_,cljs.core.cst$kw$is_DASH_filtered_DASH_dataview_QMARK_,is_filtered_dataview_QMARK_,cljs.core.cst$kw$owner,owner], 0));
var SlickGrid = Slick.Grid;
var DataView = Slick.Data.DataView;
var dataview = (new DataView());
var grid = (new SlickGrid([cljs.core.str("#"),cljs.core.str(hatti.views.table.table_id)].join(''),dataview,columns,hatti.views.table.sg_options));
hatti.views.table.bind_external_sg_grid_event_handlers(grid,grid_event_handlers);

hatti.views.table.bind_external_sg_grid_dataview_handlers(dataview,dataview_event_handlers);

dataview.onRowCountChanged.subscribe(((function (map__44081,map__44081__$1,map__44082,map__44082__$1,map__44083,map__44083__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__44079,map__44079__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
grid.updateRowCount();

return grid.render();
});})(map__44081,map__44081__$1,map__44082,map__44082__$1,map__44083,map__44083__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__44079,map__44079__$1,grid_event_handlers,dataview_event_handlers))
);

dataview.onRowsChanged.subscribe(((function (map__44081,map__44081__$1,map__44082,map__44082__$1,map__44083,map__44083__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__44079,map__44079__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
grid.invalidateRows((args["rows"]));

return grid.render();
});})(map__44081,map__44081__$1,map__44082,map__44082__$1,map__44083,map__44083__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__44079,map__44079__$1,grid_event_handlers,dataview_event_handlers))
);

grid.onDblClick.subscribe(((function (map__44081,map__44081__$1,map__44082,map__44082__$1,map__44083,map__44083__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__44079,map__44079__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
var rank = (dataview.getItem((args["row"]))[hatti.constants._rank]);
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$submission_DASH_to_DASH_rank,rank], null));
});})(map__44081,map__44081__$1,map__44082,map__44082__$1,map__44083,map__44083__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__44079,map__44079__$1,grid_event_handlers,dataview_event_handlers))
);

grid.onClick.subscribe(((function (map__44081,map__44081__$1,map__44082,map__44082__$1,map__44083,map__44083__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__44079,map__44079__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
var elem = e.target;
var row = dataview.getItem((args["row"]));
var elem_data_id = elem.getAttribute("data-id");
var data_id = (cljs.core.truth_(elem_data_id)?(function (){var G__44087 = elem.getAttribute("data-id");
return parseInt(G__44087);
})():null);
var id = (row[hatti.constants._id]);
var rank = (row[hatti.constants._rank]);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(id,data_id)){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$submission_DASH_to_DASH_rank,rank], null));
} else {
return null;
}
});})(map__44081,map__44081__$1,map__44082,map__44082__$1,map__44083,map__44083__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__44079,map__44079__$1,grid_event_handlers,dataview_event_handlers))
);

hatti.views.table.init_sg_pager(grid,dataview);

dataview.setPagingOptions(({"pageSize": (function (){var or__6409__auto__ = num_displayed_records;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return hatti.views.table.default_num_displayed_records;
}
})(), "totalPages": total_page_count}));

dataview.setFilter(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(hatti.views.table.filterfn,form));

dataview.setItems(cljs.core.clj__GT_js(data),hatti.constants._id);

hatti.views.table.resizeColumns(grid);

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [grid,dataview], null);
});
/**
 * Event loop for the table view. Processes a tap of share/event-chan,
 * and updates app-state/dataview/grid as needed.
 */
hatti.views.table.handle_table_events = (function hatti$views$table$handle_table_events(app_state,grid,dataview){
var event_chan = hatti.shared.event_tap();
var c__12139__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12139__auto__,event_chan){
return (function (){
var f__12140__auto__ = (function (){var switch__12027__auto__ = ((function (c__12139__auto__,event_chan){
return (function (state_44349){
var state_val_44350 = (state_44349[(1)]);
if((state_val_44350 === (7))){
var inst_44258 = (state_44349[(7)]);
var inst_44258__$1 = (state_44349[(2)]);
var inst_44260 = (inst_44258__$1 == null);
var inst_44261 = cljs.core.not(inst_44260);
var state_44349__$1 = (function (){var statearr_44351 = state_44349;
(statearr_44351[(7)] = inst_44258__$1);

return statearr_44351;
})();
if(inst_44261){
var statearr_44352_44419 = state_44349__$1;
(statearr_44352_44419[(1)] = (8));

} else {
var statearr_44353_44420 = state_44349__$1;
(statearr_44353_44420[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_44350 === (20))){
var inst_44288 = (state_44349[(8)]);
var inst_44280 = (state_44349[(9)]);
var inst_44297 = (inst_44288.cljs$core$IFn$_invoke$arity$1 ? inst_44288.cljs$core$IFn$_invoke$arity$1(inst_44280) : inst_44288.call(null,inst_44280));
var state_44349__$1 = state_44349;
var statearr_44354_44421 = state_44349__$1;
(statearr_44354_44421[(2)] = inst_44297);

(statearr_44354_44421[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44350 === (27))){
var state_44349__$1 = state_44349;
var statearr_44355_44422 = state_44349__$1;
(statearr_44355_44422[(2)] = null);

(statearr_44355_44422[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44350 === (1))){
var state_44349__$1 = state_44349;
var statearr_44356_44423 = state_44349__$1;
(statearr_44356_44423[(2)] = null);

(statearr_44356_44423[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44350 === (24))){
var state_44349__$1 = state_44349;
var statearr_44357_44424 = state_44349__$1;
(statearr_44357_44424[(2)] = null);

(statearr_44357_44424[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44350 === (4))){
var state_44349__$1 = state_44349;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44349__$1,(7),event_chan);
} else {
if((state_val_44350 === (15))){
var inst_44258 = (state_44349[(7)]);
var state_44349__$1 = state_44349;
var statearr_44358_44425 = state_44349__$1;
(statearr_44358_44425[(2)] = inst_44258);

(statearr_44358_44425[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44350 === (21))){
var state_44349__$1 = state_44349;
var statearr_44359_44426 = state_44349__$1;
(statearr_44359_44426[(2)] = null);

(statearr_44359_44426[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44350 === (31))){
var inst_44284 = (state_44349[(10)]);
var inst_44322 = (state_44349[(2)]);
var inst_44323 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_44284,cljs.core.cst$kw$table);
var state_44349__$1 = (function (){var statearr_44360 = state_44349;
(statearr_44360[(11)] = inst_44322);

return statearr_44360;
})();
if(inst_44323){
var statearr_44361_44427 = state_44349__$1;
(statearr_44361_44427[(1)] = (32));

} else {
var statearr_44362_44428 = state_44349__$1;
(statearr_44362_44428[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_44350 === (32))){
var inst_44288 = (state_44349[(8)]);
var inst_44289 = (state_44349[(12)]);
var inst_44281 = (state_44349[(13)]);
var inst_44280 = (state_44349[(9)]);
var inst_44282 = (state_44349[(14)]);
var inst_44278 = (state_44349[(15)]);
var inst_44279 = (state_44349[(16)]);
var inst_44284 = (state_44349[(10)]);
var inst_44283 = (state_44349[(17)]);
var inst_44336 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_44337 = (function (){var map__44256 = inst_44278;
var new_columns = inst_44283;
var submission_clicked = inst_44280;
var submission_unclicked = inst_44281;
var get_submission_data = inst_44289;
var re_render = inst_44284;
var update_data_BANG_ = inst_44288;
var c__12139__auto____$1 = inst_44336;
var submission_to_rank = inst_44279;
var filter_by = inst_44282;
return ((function (map__44256,new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,c__12139__auto____$1,submission_to_rank,filter_by,inst_44288,inst_44289,inst_44281,inst_44280,inst_44282,inst_44278,inst_44279,inst_44284,inst_44283,inst_44336,state_val_44350,c__12139__auto__,event_chan){
return (function (){
var f__12140__auto__ = (function (){var switch__12027__auto__ = ((function (map__44256,new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,c__12139__auto____$1,submission_to_rank,filter_by,inst_44288,inst_44289,inst_44281,inst_44280,inst_44282,inst_44278,inst_44279,inst_44284,inst_44283,inst_44336,state_val_44350,c__12139__auto__,event_chan){
return (function (state_44334){
var state_val_44335 = (state_44334[(1)]);
if((state_val_44335 === (1))){
var inst_44325 = cljs.core.async.timeout((20));
var state_44334__$1 = state_44334;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44334__$1,(2),inst_44325);
} else {
if((state_val_44335 === (2))){
var inst_44327 = (state_44334[(2)]);
var inst_44328 = grid.resizeCanvas();
var inst_44329 = grid.invalidateAllRows();
var inst_44330 = hatti.views.table.resizeColumns(grid);
var inst_44331 = grid.render();
var inst_44332 = hatti.views.table.init_sg_pager(grid,dataview);
var state_44334__$1 = (function (){var statearr_44363 = state_44334;
(statearr_44363[(7)] = inst_44330);

(statearr_44363[(8)] = inst_44327);

(statearr_44363[(9)] = inst_44328);

(statearr_44363[(10)] = inst_44331);

(statearr_44363[(11)] = inst_44329);

return statearr_44363;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_44334__$1,inst_44332);
} else {
return null;
}
}
});})(map__44256,new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,c__12139__auto____$1,submission_to_rank,filter_by,inst_44288,inst_44289,inst_44281,inst_44280,inst_44282,inst_44278,inst_44279,inst_44284,inst_44283,inst_44336,state_val_44350,c__12139__auto__,event_chan))
;
return ((function (switch__12027__auto__,map__44256,new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,c__12139__auto____$1,submission_to_rank,filter_by,inst_44288,inst_44289,inst_44281,inst_44280,inst_44282,inst_44278,inst_44279,inst_44284,inst_44283,inst_44336,state_val_44350,c__12139__auto__,event_chan){
return (function() {
var hatti$views$table$handle_table_events_$_state_machine__12028__auto__ = null;
var hatti$views$table$handle_table_events_$_state_machine__12028__auto____0 = (function (){
var statearr_44367 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_44367[(0)] = hatti$views$table$handle_table_events_$_state_machine__12028__auto__);

(statearr_44367[(1)] = (1));

return statearr_44367;
});
var hatti$views$table$handle_table_events_$_state_machine__12028__auto____1 = (function (state_44334){
while(true){
var ret_value__12029__auto__ = (function (){try{while(true){
var result__12030__auto__ = switch__12027__auto__(state_44334);
if(cljs.core.keyword_identical_QMARK_(result__12030__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12030__auto__;
}
break;
}
}catch (e44368){if((e44368 instanceof Object)){
var ex__12031__auto__ = e44368;
var statearr_44369_44429 = state_44334;
(statearr_44369_44429[(5)] = ex__12031__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_44334);

return cljs.core.cst$kw$recur;
} else {
throw e44368;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12029__auto__,cljs.core.cst$kw$recur)){
var G__44430 = state_44334;
state_44334 = G__44430;
continue;
} else {
return ret_value__12029__auto__;
}
break;
}
});
hatti$views$table$handle_table_events_$_state_machine__12028__auto__ = function(state_44334){
switch(arguments.length){
case 0:
return hatti$views$table$handle_table_events_$_state_machine__12028__auto____0.call(this);
case 1:
return hatti$views$table$handle_table_events_$_state_machine__12028__auto____1.call(this,state_44334);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$handle_table_events_$_state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$handle_table_events_$_state_machine__12028__auto____0;
hatti$views$table$handle_table_events_$_state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$handle_table_events_$_state_machine__12028__auto____1;
return hatti$views$table$handle_table_events_$_state_machine__12028__auto__;
})()
;})(switch__12027__auto__,map__44256,new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,c__12139__auto____$1,submission_to_rank,filter_by,inst_44288,inst_44289,inst_44281,inst_44280,inst_44282,inst_44278,inst_44279,inst_44284,inst_44283,inst_44336,state_val_44350,c__12139__auto__,event_chan))
})();
var state__12141__auto__ = (function (){var statearr_44370 = (f__12140__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12140__auto__.cljs$core$IFn$_invoke$arity$0() : f__12140__auto__.call(null));
(statearr_44370[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12139__auto____$1);

return statearr_44370;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12141__auto__);
});
;})(map__44256,new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,c__12139__auto____$1,submission_to_rank,filter_by,inst_44288,inst_44289,inst_44281,inst_44280,inst_44282,inst_44278,inst_44279,inst_44284,inst_44283,inst_44336,state_val_44350,c__12139__auto__,event_chan))
})();
var inst_44338 = cljs.core.async.impl.dispatch.run(inst_44337);
var state_44349__$1 = (function (){var statearr_44371 = state_44349;
(statearr_44371[(18)] = inst_44338);

return statearr_44371;
})();
var statearr_44372_44431 = state_44349__$1;
(statearr_44372_44431[(2)] = inst_44336);

(statearr_44372_44431[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44350 === (33))){
var state_44349__$1 = state_44349;
var statearr_44373_44432 = state_44349__$1;
(statearr_44373_44432[(2)] = null);

(statearr_44373_44432[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44350 === (13))){
var inst_44270 = (state_44349[(2)]);
var state_44349__$1 = state_44349;
var statearr_44374_44433 = state_44349__$1;
(statearr_44374_44433[(2)] = inst_44270);

(statearr_44374_44433[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44350 === (22))){
var inst_44281 = (state_44349[(13)]);
var inst_44300 = (state_44349[(2)]);
var state_44349__$1 = (function (){var statearr_44375 = state_44349;
(statearr_44375[(19)] = inst_44300);

return statearr_44375;
})();
if(cljs.core.truth_(inst_44281)){
var statearr_44376_44434 = state_44349__$1;
(statearr_44376_44434[(1)] = (23));

} else {
var statearr_44377_44435 = state_44349__$1;
(statearr_44377_44435[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_44350 === (29))){
var inst_44282 = (state_44349[(14)]);
var inst_44314 = [cljs.core.cst$kw$query];
var inst_44315 = [inst_44282];
var inst_44316 = cljs.core.PersistentHashMap.fromArrays(inst_44314,inst_44315);
var inst_44317 = cljs.core.clj__GT_js(inst_44316);
var inst_44318 = dataview.setFilterArgs(inst_44317);
var inst_44319 = dataview.refresh();
var state_44349__$1 = (function (){var statearr_44378 = state_44349;
(statearr_44378[(20)] = inst_44318);

return statearr_44378;
})();
var statearr_44379_44436 = state_44349__$1;
(statearr_44379_44436[(2)] = inst_44319);

(statearr_44379_44436[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44350 === (6))){
var inst_44345 = (state_44349[(2)]);
var state_44349__$1 = state_44349;
var statearr_44380_44437 = state_44349__$1;
(statearr_44380_44437[(2)] = inst_44345);

(statearr_44380_44437[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44350 === (28))){
var inst_44282 = (state_44349[(14)]);
var inst_44312 = (state_44349[(2)]);
var state_44349__$1 = (function (){var statearr_44381 = state_44349;
(statearr_44381[(21)] = inst_44312);

return statearr_44381;
})();
if(cljs.core.truth_(inst_44282)){
var statearr_44382_44438 = state_44349__$1;
(statearr_44382_44438[(1)] = (29));

} else {
var statearr_44383_44439 = state_44349__$1;
(statearr_44383_44439[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_44350 === (25))){
var inst_44283 = (state_44349[(17)]);
var inst_44305 = (state_44349[(2)]);
var state_44349__$1 = (function (){var statearr_44384 = state_44349;
(statearr_44384[(22)] = inst_44305);

return statearr_44384;
})();
if(cljs.core.truth_(inst_44283)){
var statearr_44385_44440 = state_44349__$1;
(statearr_44385_44440[(1)] = (26));

} else {
var statearr_44386_44441 = state_44349__$1;
(statearr_44386_44441[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_44350 === (34))){
var inst_44341 = (state_44349[(2)]);
var state_44349__$1 = (function (){var statearr_44387 = state_44349;
(statearr_44387[(23)] = inst_44341);

return statearr_44387;
})();
var statearr_44388_44442 = state_44349__$1;
(statearr_44388_44442[(2)] = null);

(statearr_44388_44442[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44350 === (17))){
var inst_44288 = (state_44349[(8)]);
var inst_44289 = (state_44349[(12)]);
var inst_44279 = (state_44349[(16)]);
var inst_44291 = (inst_44289.cljs$core$IFn$_invoke$arity$2 ? inst_44289.cljs$core$IFn$_invoke$arity$2(hatti.constants._rank,inst_44279) : inst_44289.call(null,hatti.constants._rank,inst_44279));
var inst_44292 = (inst_44288.cljs$core$IFn$_invoke$arity$1 ? inst_44288.cljs$core$IFn$_invoke$arity$1(inst_44291) : inst_44288.call(null,inst_44291));
var state_44349__$1 = state_44349;
var statearr_44389_44443 = state_44349__$1;
(statearr_44389_44443[(2)] = inst_44292);

(statearr_44389_44443[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44350 === (3))){
var inst_44347 = (state_44349[(2)]);
var state_44349__$1 = state_44349;
return cljs.core.async.impl.ioc_helpers.return_chan(state_44349__$1,inst_44347);
} else {
if((state_val_44350 === (12))){
var state_44349__$1 = state_44349;
var statearr_44390_44444 = state_44349__$1;
(statearr_44390_44444[(2)] = false);

(statearr_44390_44444[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44350 === (2))){
var state_44349__$1 = state_44349;
var statearr_44391_44445 = state_44349__$1;
(statearr_44391_44445[(1)] = (4));



return cljs.core.cst$kw$recur;
} else {
if((state_val_44350 === (23))){
var inst_44288 = (state_44349[(8)]);
var inst_44302 = (inst_44288.cljs$core$IFn$_invoke$arity$1 ? inst_44288.cljs$core$IFn$_invoke$arity$1(null) : inst_44288.call(null,null));
var state_44349__$1 = state_44349;
var statearr_44393_44446 = state_44349__$1;
(statearr_44393_44446[(2)] = inst_44302);

(statearr_44393_44446[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44350 === (19))){
var inst_44280 = (state_44349[(9)]);
var inst_44295 = (state_44349[(2)]);
var state_44349__$1 = (function (){var statearr_44394 = state_44349;
(statearr_44394[(24)] = inst_44295);

return statearr_44394;
})();
if(cljs.core.truth_(inst_44280)){
var statearr_44395_44447 = state_44349__$1;
(statearr_44395_44447[(1)] = (20));

} else {
var statearr_44396_44448 = state_44349__$1;
(statearr_44396_44448[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_44350 === (11))){
var state_44349__$1 = state_44349;
var statearr_44397_44449 = state_44349__$1;
(statearr_44397_44449[(2)] = true);

(statearr_44397_44449[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44350 === (9))){
var state_44349__$1 = state_44349;
var statearr_44398_44450 = state_44349__$1;
(statearr_44398_44450[(2)] = false);

(statearr_44398_44450[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44350 === (5))){
var state_44349__$1 = state_44349;
var statearr_44399_44451 = state_44349__$1;
(statearr_44399_44451[(2)] = null);

(statearr_44399_44451[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44350 === (14))){
var inst_44258 = (state_44349[(7)]);
var inst_44275 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_44258);
var state_44349__$1 = state_44349;
var statearr_44400_44452 = state_44349__$1;
(statearr_44400_44452[(2)] = inst_44275);

(statearr_44400_44452[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44350 === (26))){
var inst_44283 = (state_44349[(17)]);
var inst_44307 = grid.setColumns(inst_44283);
var inst_44308 = hatti.views.table.resizeColumns(grid);
var inst_44309 = grid.render();
var state_44349__$1 = (function (){var statearr_44401 = state_44349;
(statearr_44401[(25)] = inst_44307);

(statearr_44401[(26)] = inst_44308);

return statearr_44401;
})();
var statearr_44402_44453 = state_44349__$1;
(statearr_44402_44453[(2)] = inst_44309);

(statearr_44402_44453[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44350 === (16))){
var inst_44288 = (state_44349[(8)]);
var inst_44281 = (state_44349[(13)]);
var inst_44280 = (state_44349[(9)]);
var inst_44282 = (state_44349[(14)]);
var inst_44278 = (state_44349[(15)]);
var inst_44279 = (state_44349[(16)]);
var inst_44284 = (state_44349[(10)]);
var inst_44283 = (state_44349[(17)]);
var inst_44278__$1 = (state_44349[(2)]);
var inst_44279__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_44278__$1,cljs.core.cst$kw$submission_DASH_to_DASH_rank);
var inst_44280__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_44278__$1,cljs.core.cst$kw$submission_DASH_clicked);
var inst_44281__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_44278__$1,cljs.core.cst$kw$submission_DASH_unclicked);
var inst_44282__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_44278__$1,cljs.core.cst$kw$filter_DASH_by);
var inst_44283__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_44278__$1,cljs.core.cst$kw$new_DASH_columns);
var inst_44284__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_44278__$1,cljs.core.cst$kw$re_DASH_render);
var inst_44285 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_44286 = [cljs.core.cst$kw$table_DASH_page,cljs.core.cst$kw$submission_DASH_clicked,cljs.core.cst$kw$data];
var inst_44287 = (new cljs.core.PersistentVector(null,3,(5),inst_44285,inst_44286,null));
var inst_44288__$1 = cljs.core.partial.cljs$core$IFn$_invoke$arity$3(om.core.update_BANG_,app_state,inst_44287);
var inst_44289 = (function (){var map__44256 = inst_44278__$1;
var submission_to_rank = inst_44279__$1;
var submission_clicked = inst_44280__$1;
var submission_unclicked = inst_44281__$1;
var filter_by = inst_44282__$1;
var new_columns = inst_44283__$1;
var re_render = inst_44284__$1;
var update_data_BANG_ = inst_44288__$1;
return ((function (map__44256,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_44288,inst_44281,inst_44280,inst_44282,inst_44278,inst_44279,inst_44284,inst_44283,inst_44278__$1,inst_44279__$1,inst_44280__$1,inst_44281__$1,inst_44282__$1,inst_44283__$1,inst_44284__$1,inst_44285,inst_44286,inst_44287,inst_44288__$1,state_val_44350,c__12139__auto__,event_chan){
return (function (field,value){
return cljs.core.first(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (map__44256,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_44288,inst_44281,inst_44280,inst_44282,inst_44278,inst_44279,inst_44284,inst_44283,inst_44278__$1,inst_44279__$1,inst_44280__$1,inst_44281__$1,inst_44282__$1,inst_44283__$1,inst_44284__$1,inst_44285,inst_44286,inst_44287,inst_44288__$1,state_val_44350,c__12139__auto__,event_chan){
return (function (p1__44088_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(value,cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__44088_SHARP_,field));
});})(map__44256,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_44288,inst_44281,inst_44280,inst_44282,inst_44278,inst_44279,inst_44284,inst_44283,inst_44278__$1,inst_44279__$1,inst_44280__$1,inst_44281__$1,inst_44282__$1,inst_44283__$1,inst_44284__$1,inst_44285,inst_44286,inst_44287,inst_44288__$1,state_val_44350,c__12139__auto__,event_chan))
,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(app_state) : cljs.core.deref.call(null,app_state)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data], null))));
});
;})(map__44256,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_44288,inst_44281,inst_44280,inst_44282,inst_44278,inst_44279,inst_44284,inst_44283,inst_44278__$1,inst_44279__$1,inst_44280__$1,inst_44281__$1,inst_44282__$1,inst_44283__$1,inst_44284__$1,inst_44285,inst_44286,inst_44287,inst_44288__$1,state_val_44350,c__12139__auto__,event_chan))
})();
var state_44349__$1 = (function (){var statearr_44403 = state_44349;
(statearr_44403[(8)] = inst_44288__$1);

(statearr_44403[(12)] = inst_44289);

(statearr_44403[(13)] = inst_44281__$1);

(statearr_44403[(9)] = inst_44280__$1);

(statearr_44403[(14)] = inst_44282__$1);

(statearr_44403[(15)] = inst_44278__$1);

(statearr_44403[(16)] = inst_44279__$1);

(statearr_44403[(10)] = inst_44284__$1);

(statearr_44403[(17)] = inst_44283__$1);

return statearr_44403;
})();
if(cljs.core.truth_(inst_44279__$1)){
var statearr_44404_44454 = state_44349__$1;
(statearr_44404_44454[(1)] = (17));

} else {
var statearr_44405_44455 = state_44349__$1;
(statearr_44405_44455[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_44350 === (30))){
var state_44349__$1 = state_44349;
var statearr_44406_44456 = state_44349__$1;
(statearr_44406_44456[(2)] = null);

(statearr_44406_44456[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44350 === (10))){
var inst_44273 = (state_44349[(2)]);
var state_44349__$1 = state_44349;
if(cljs.core.truth_(inst_44273)){
var statearr_44407_44457 = state_44349__$1;
(statearr_44407_44457[(1)] = (14));

} else {
var statearr_44408_44458 = state_44349__$1;
(statearr_44408_44458[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_44350 === (18))){
var state_44349__$1 = state_44349;
var statearr_44409_44459 = state_44349__$1;
(statearr_44409_44459[(2)] = null);

(statearr_44409_44459[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44350 === (8))){
var inst_44258 = (state_44349[(7)]);
var inst_44263 = inst_44258.cljs$lang$protocol_mask$partition0$;
var inst_44264 = (inst_44263 & (64));
var inst_44265 = inst_44258.cljs$core$ISeq$;
var inst_44266 = (inst_44264) || (inst_44265);
var state_44349__$1 = state_44349;
if(cljs.core.truth_(inst_44266)){
var statearr_44410_44460 = state_44349__$1;
(statearr_44410_44460[(1)] = (11));

} else {
var statearr_44411_44461 = state_44349__$1;
(statearr_44411_44461[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12139__auto__,event_chan))
;
return ((function (switch__12027__auto__,c__12139__auto__,event_chan){
return (function() {
var hatti$views$table$handle_table_events_$_state_machine__12028__auto__ = null;
var hatti$views$table$handle_table_events_$_state_machine__12028__auto____0 = (function (){
var statearr_44415 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_44415[(0)] = hatti$views$table$handle_table_events_$_state_machine__12028__auto__);

(statearr_44415[(1)] = (1));

return statearr_44415;
});
var hatti$views$table$handle_table_events_$_state_machine__12028__auto____1 = (function (state_44349){
while(true){
var ret_value__12029__auto__ = (function (){try{while(true){
var result__12030__auto__ = switch__12027__auto__(state_44349);
if(cljs.core.keyword_identical_QMARK_(result__12030__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12030__auto__;
}
break;
}
}catch (e44416){if((e44416 instanceof Object)){
var ex__12031__auto__ = e44416;
var statearr_44417_44462 = state_44349;
(statearr_44417_44462[(5)] = ex__12031__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_44349);

return cljs.core.cst$kw$recur;
} else {
throw e44416;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12029__auto__,cljs.core.cst$kw$recur)){
var G__44463 = state_44349;
state_44349 = G__44463;
continue;
} else {
return ret_value__12029__auto__;
}
break;
}
});
hatti$views$table$handle_table_events_$_state_machine__12028__auto__ = function(state_44349){
switch(arguments.length){
case 0:
return hatti$views$table$handle_table_events_$_state_machine__12028__auto____0.call(this);
case 1:
return hatti$views$table$handle_table_events_$_state_machine__12028__auto____1.call(this,state_44349);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$handle_table_events_$_state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$handle_table_events_$_state_machine__12028__auto____0;
hatti$views$table$handle_table_events_$_state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$handle_table_events_$_state_machine__12028__auto____1;
return hatti$views$table$handle_table_events_$_state_machine__12028__auto__;
})()
;})(switch__12027__auto__,c__12139__auto__,event_chan))
})();
var state__12141__auto__ = (function (){var statearr_44418 = (f__12140__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12140__auto__.cljs$core$IFn$_invoke$arity$0() : f__12140__auto__.call(null));
(statearr_44418[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12139__auto__);

return statearr_44418;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12141__auto__);
});})(c__12139__auto__,event_chan))
);

return c__12139__auto__;
});
hatti.views.table.render_options = (function hatti$views$table$render_options(options,owner,colset_BANG_){
var choose_display_key = (function (k){
om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$name_DASH_or_DASH_label,k);

return (colset_BANG_.cljs$core$IFn$_invoke$arity$1 ? colset_BANG_.cljs$core$IFn$_invoke$arity$1(k) : colset_BANG_.call(null,k));
});
var iter__7189__auto__ = ((function (choose_display_key){
return (function hatti$views$table$render_options_$_iter__44482(s__44483){
return (new cljs.core.LazySeq(null,((function (choose_display_key){
return (function (){
var s__44483__$1 = s__44483;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__44483__$1);
if(temp__4657__auto__){
var s__44483__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__44483__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__44483__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__44485 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__44484 = (0);
while(true){
if((i__44484 < size__7188__auto__)){
var vec__44494 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__44484);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44494,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44494,(1),null);
cljs.core.chunk_append(b__44485,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$on_DASH_click,hatti.utils.click_fn(((function (i__44484,vec__44494,k,v,c__7187__auto__,size__7188__auto__,b__44485,s__44483__$2,temp__4657__auto__,choose_display_key){
return (function (){
return choose_display_key(k);
});})(i__44484,vec__44494,k,v,c__7187__auto__,size__7188__auto__,b__44485,s__44483__$2,temp__4657__auto__,choose_display_key))
),cljs.core.cst$kw$href,"#"], null),v], null)], null));

var G__44500 = (i__44484 + (1));
i__44484 = G__44500;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__44485),hatti$views$table$render_options_$_iter__44482(cljs.core.chunk_rest(s__44483__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__44485),null);
}
} else {
var vec__44497 = cljs.core.first(s__44483__$2);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44497,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44497,(1),null);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$on_DASH_click,hatti.utils.click_fn(((function (vec__44497,k,v,s__44483__$2,temp__4657__auto__,choose_display_key){
return (function (){
return choose_display_key(k);
});})(vec__44497,k,v,s__44483__$2,temp__4657__auto__,choose_display_key))
),cljs.core.cst$kw$href,"#"], null),v], null)], null),hatti$views$table$render_options_$_iter__44482(cljs.core.rest(s__44483__$2)));
}
} else {
return null;
}
break;
}
});})(choose_display_key))
,null,null));
});})(choose_display_key))
;
return iter__7189__auto__(options);
});
hatti.views.label_changer.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (p__44502,owner){
var map__44503 = p__44502;
var map__44503__$1 = ((((!((map__44503 == null)))?((((map__44503.cljs$lang$protocol_mask$partition0$ & (64))) || (map__44503.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__44503):map__44503);
var cursor = map__44503__$1;
var map__44504 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44503__$1,cljs.core.cst$kw$table_DASH_page);
var map__44504__$1 = ((((!((map__44504 == null)))?((((map__44504.cljs$lang$protocol_mask$partition0$ & (64))) || (map__44504.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__44504):map__44504);
var hide_actions_column_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44504__$1,cljs.core.cst$kw$hide_DASH_actions_DASH_column_QMARK_);
if(typeof hatti.views.table.t_hatti$views$table44507 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRenderState}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IInitState}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table44507 = (function (p__44502,owner,map__44503,cursor,map__44504,hide_actions_column_QMARK_,meta44508){
this.p__44502 = p__44502;
this.owner = owner;
this.map__44503 = map__44503;
this.cursor = cursor;
this.map__44504 = map__44504;
this.hide_actions_column_QMARK_ = hide_actions_column_QMARK_;
this.meta44508 = meta44508;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table44507.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (map__44503,map__44503__$1,cursor,map__44504,map__44504__$1,hide_actions_column_QMARK_){
return (function (_44509,meta44508__$1){
var self__ = this;
var _44509__$1 = this;
return (new hatti.views.table.t_hatti$views$table44507(self__.p__44502,self__.owner,self__.map__44503,self__.cursor,self__.map__44504,self__.hide_actions_column_QMARK_,meta44508__$1));
});})(map__44503,map__44503__$1,cursor,map__44504,map__44504__$1,hide_actions_column_QMARK_))
;

hatti.views.table.t_hatti$views$table44507.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (map__44503,map__44503__$1,cursor,map__44504,map__44504__$1,hide_actions_column_QMARK_){
return (function (_44509){
var self__ = this;
var _44509__$1 = this;
return self__.meta44508;
});})(map__44503,map__44503__$1,cursor,map__44504,map__44504__$1,hide_actions_column_QMARK_))
;

hatti.views.table.t_hatti$views$table44507.prototype.om$core$IInitState$ = true;

hatti.views.table.t_hatti$views$table44507.prototype.om$core$IInitState$init_state$arity$1 = ((function (map__44503,map__44503__$1,cursor,map__44504,map__44504__$1,hide_actions_column_QMARK_){
return (function (_){
var self__ = this;
var ___$1 = this;
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$name_DASH_or_DASH_label,cljs.core.cst$kw$label], null);
});})(map__44503,map__44503__$1,cursor,map__44504,map__44504__$1,hide_actions_column_QMARK_))
;

hatti.views.table.t_hatti$views$table44507.prototype.om$core$IRenderState$ = true;

hatti.views.table.t_hatti$views$table44507.prototype.om$core$IRenderState$render_state$arity$2 = ((function (map__44503,map__44503__$1,cursor,map__44504,map__44504__$1,hide_actions_column_QMARK_){
return (function (_,p__44510){
var self__ = this;
var map__44511 = p__44510;
var map__44511__$1 = ((((!((map__44511 == null)))?((((map__44511.cljs$lang$protocol_mask$partition0$ & (64))) || (map__44511.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__44511):map__44511);
var name_or_label = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44511__$1,cljs.core.cst$kw$name_DASH_or_DASH_label);
var language = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44511__$1,cljs.core.cst$kw$language);
var ___$1 = this;
var options = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$label,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$strong,"Label"], null),cljs.core.cst$kw$name,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$strong,"Name"], null)], null);
var map__44513 = om.core.get_shared.cljs$core$IFn$_invoke$arity$1(self__.owner);
var map__44513__$1 = ((((!((map__44513 == null)))?((((map__44513.cljs$lang$protocol_mask$partition0$ & (64))) || (map__44513.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__44513):map__44513);
var flat_form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44513__$1,cljs.core.cst$kw$flat_DASH_form);
var new_language = cljs.core.cst$kw$current.cljs$core$IFn$_invoke$arity$1(om.core.observe(self__.owner,hatti.shared.language_cursor()));
var colset_BANG_ = ((function (options,map__44513,map__44513__$1,flat_form,new_language,___$1,map__44511,map__44511__$1,name_or_label,language,map__44503,map__44503__$1,cursor,map__44504,map__44504__$1,hide_actions_column_QMARK_){
return (function (p1__44501_SHARP_){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$new_DASH_columns,hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic(flat_form,cljs.core.array_seq([cljs.core.cst$kw$get_DASH_label_QMARK_,cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$label,p1__44501_SHARP_),cljs.core.cst$kw$hide_DASH_actions_DASH_column_QMARK_,self__.hide_actions_column_QMARK_,cljs.core.cst$kw$language,new_language], 0))], null));
});})(options,map__44513,map__44513__$1,flat_form,new_language,___$1,map__44511,map__44511__$1,name_or_label,language,map__44503,map__44503__$1,cursor,map__44504,map__44504__$1,hide_actions_column_QMARK_))
;
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(new_language,language)){
om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(self__.owner,cljs.core.cst$kw$language,new_language);

colset_BANG_(name_or_label);
} else {
}

var G__44522 = ({"className": "label-changer"});
var G__44523 = (function (){var G__44525 = ({"className": "label-changer-label"});
var G__44526 = "Show:";
return React.DOM.span(G__44525,G__44526);
})();
var G__44524 = (function (){var G__44527 = ({"id": "header-display-dropdown", "className": "drop-hover"});
var G__44528 = (function (){var attrs44517 = (options.cljs$core$IFn$_invoke$arity$1 ? options.cljs$core$IFn$_invoke$arity$1(name_or_label) : options.call(null,name_or_label));
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(React.DOM.span,((cljs.core.map_QMARK_(attrs44517))?sablono.interpreter.attributes(attrs44517):null),cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,((cljs.core.map_QMARK_(attrs44517))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__44530 = ({"className": "fa fa-angle-down"});
return React.DOM.i(G__44530);
})()], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret(attrs44517),(function (){var G__44531 = ({"className": "fa fa-angle-down"});
return React.DOM.i(G__44531);
})()], null))));
})();
var G__44529 = (function (){var G__44532 = ({"className": "submenu no-dot"});
var G__44533 = sablono.interpreter.interpret(hatti.views.table.render_options(options,self__.owner,colset_BANG_));
return React.DOM.ul(G__44532,G__44533);
})();
return React.DOM.div(G__44527,G__44528,G__44529);
})();
return React.DOM.div(G__44522,G__44523,G__44524);
});})(map__44503,map__44503__$1,cursor,map__44504,map__44504__$1,hide_actions_column_QMARK_))
;

hatti.views.table.t_hatti$views$table44507.getBasis = ((function (map__44503,map__44503__$1,cursor,map__44504,map__44504__$1,hide_actions_column_QMARK_){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p__44502,cljs.core.cst$sym$owner,cljs.core.cst$sym$map__44503,cljs.core.cst$sym$cursor,cljs.core.cst$sym$map__44504,cljs.core.cst$sym$hide_DASH_actions_DASH_column_QMARK_,cljs.core.cst$sym$meta44508], null);
});})(map__44503,map__44503__$1,cursor,map__44504,map__44504__$1,hide_actions_column_QMARK_))
;

hatti.views.table.t_hatti$views$table44507.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table44507.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table44507";

hatti.views.table.t_hatti$views$table44507.cljs$lang$ctorPrWriter = ((function (map__44503,map__44503__$1,cursor,map__44504,map__44504__$1,hide_actions_column_QMARK_){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"hatti.views.table/t_hatti$views$table44507");
});})(map__44503,map__44503__$1,cursor,map__44504,map__44504__$1,hide_actions_column_QMARK_))
;

hatti.views.table.__GT_t_hatti$views$table44507 = ((function (map__44503,map__44503__$1,cursor,map__44504,map__44504__$1,hide_actions_column_QMARK_){
return (function hatti$views$table$__GT_t_hatti$views$table44507(p__44502__$1,owner__$1,map__44503__$2,cursor__$1,map__44504__$2,hide_actions_column_QMARK___$1,meta44508){
return (new hatti.views.table.t_hatti$views$table44507(p__44502__$1,owner__$1,map__44503__$2,cursor__$1,map__44504__$2,hide_actions_column_QMARK___$1,meta44508));
});})(map__44503,map__44503__$1,cursor,map__44504,map__44504__$1,hide_actions_column_QMARK_))
;

}

return (new hatti.views.table.t_hatti$views$table44507(p__44502,owner,map__44503__$1,cursor,map__44504__$1,hide_actions_column_QMARK_,cljs.core.PersistentArrayMap.EMPTY));
}));
/**
 * Delayed search fires a query-event on event-chan if the value of the input
 * doesn't change within 150 ms (ie, user is still typing).
 * Call on-change or on-key-up, with (.-target event) as first argument.
 */
hatti.views.table.delayed_search = (function hatti$views$table$delayed_search(input,query_event_key){
var query = input.value;
var c__12139__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12139__auto__,query){
return (function (){
var f__12140__auto__ = (function (){var switch__12027__auto__ = ((function (c__12139__auto__,query){
return (function (state_44576){
var state_val_44577 = (state_44576[(1)]);
if((state_val_44577 === (1))){
var inst_44562 = cljs.core.async.timeout((150));
var state_44576__$1 = state_44576;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44576__$1,(2),inst_44562);
} else {
if((state_val_44577 === (2))){
var inst_44564 = (state_44576[(2)]);
var inst_44565 = input.value;
var inst_44566 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(query,inst_44565);
var state_44576__$1 = (function (){var statearr_44578 = state_44576;
(statearr_44578[(7)] = inst_44564);

return statearr_44578;
})();
if(inst_44566){
var statearr_44579_44590 = state_44576__$1;
(statearr_44579_44590[(1)] = (3));

} else {
var statearr_44580_44591 = state_44576__$1;
(statearr_44580_44591[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_44577 === (3))){
var inst_44568 = [query_event_key];
var inst_44569 = [query];
var inst_44570 = cljs.core.PersistentHashMap.fromArrays(inst_44568,inst_44569);
var inst_44571 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_chan,inst_44570);
var state_44576__$1 = state_44576;
var statearr_44581_44592 = state_44576__$1;
(statearr_44581_44592[(2)] = inst_44571);

(statearr_44581_44592[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44577 === (4))){
var state_44576__$1 = state_44576;
var statearr_44582_44593 = state_44576__$1;
(statearr_44582_44593[(2)] = null);

(statearr_44582_44593[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44577 === (5))){
var inst_44574 = (state_44576[(2)]);
var state_44576__$1 = state_44576;
return cljs.core.async.impl.ioc_helpers.return_chan(state_44576__$1,inst_44574);
} else {
return null;
}
}
}
}
}
});})(c__12139__auto__,query))
;
return ((function (switch__12027__auto__,c__12139__auto__,query){
return (function() {
var hatti$views$table$delayed_search_$_state_machine__12028__auto__ = null;
var hatti$views$table$delayed_search_$_state_machine__12028__auto____0 = (function (){
var statearr_44586 = [null,null,null,null,null,null,null,null];
(statearr_44586[(0)] = hatti$views$table$delayed_search_$_state_machine__12028__auto__);

(statearr_44586[(1)] = (1));

return statearr_44586;
});
var hatti$views$table$delayed_search_$_state_machine__12028__auto____1 = (function (state_44576){
while(true){
var ret_value__12029__auto__ = (function (){try{while(true){
var result__12030__auto__ = switch__12027__auto__(state_44576);
if(cljs.core.keyword_identical_QMARK_(result__12030__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12030__auto__;
}
break;
}
}catch (e44587){if((e44587 instanceof Object)){
var ex__12031__auto__ = e44587;
var statearr_44588_44594 = state_44576;
(statearr_44588_44594[(5)] = ex__12031__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_44576);

return cljs.core.cst$kw$recur;
} else {
throw e44587;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12029__auto__,cljs.core.cst$kw$recur)){
var G__44595 = state_44576;
state_44576 = G__44595;
continue;
} else {
return ret_value__12029__auto__;
}
break;
}
});
hatti$views$table$delayed_search_$_state_machine__12028__auto__ = function(state_44576){
switch(arguments.length){
case 0:
return hatti$views$table$delayed_search_$_state_machine__12028__auto____0.call(this);
case 1:
return hatti$views$table$delayed_search_$_state_machine__12028__auto____1.call(this,state_44576);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$delayed_search_$_state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$delayed_search_$_state_machine__12028__auto____0;
hatti$views$table$delayed_search_$_state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$delayed_search_$_state_machine__12028__auto____1;
return hatti$views$table$delayed_search_$_state_machine__12028__auto__;
})()
;})(switch__12027__auto__,c__12139__auto__,query))
})();
var state__12141__auto__ = (function (){var statearr_44589 = (f__12140__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12140__auto__.cljs$core$IFn$_invoke$arity$0() : f__12140__auto__.call(null));
(statearr_44589[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12139__auto__);

return statearr_44589;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12141__auto__);
});})(c__12139__auto__,query))
);

return c__12139__auto__;
});
hatti.views.table_search.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (_,owner){
if(typeof hatti.views.table.t_hatti$views$table44597 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table44597 = (function (_,owner,meta44598){
this._ = _;
this.owner = owner;
this.meta44598 = meta44598;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table44597.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_44599,meta44598__$1){
var self__ = this;
var _44599__$1 = this;
return (new hatti.views.table.t_hatti$views$table44597(self__._,self__.owner,meta44598__$1));
});

hatti.views.table.t_hatti$views$table44597.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_44599){
var self__ = this;
var _44599__$1 = this;
return self__.meta44598;
});

hatti.views.table.t_hatti$views$table44597.prototype.om$core$IRender$ = true;

hatti.views.table.t_hatti$views$table44597.prototype.om$core$IRender$render$arity$1 = (function (this__18114__auto__){
var self__ = this;
var this__18114__auto____$1 = this;
var G__44602 = ({"className": "table-search"});
var G__44603 = (function (){var G__44605 = ({"className": "fa fa-search"});
return React.DOM.i(G__44605);
})();
var G__44604 = (function (){var G__44606 = ({"type": "text", "placeholder": "Search", "onChange": ((function (G__44602,G__44603,this__18114__auto____$1){
return (function (p1__44596_SHARP_){
return hatti.views.table.delayed_search(p1__44596_SHARP_.target,cljs.core.cst$kw$filter_DASH_by);
});})(G__44602,G__44603,this__18114__auto____$1))
});
return (sablono.interpreter.input.cljs$core$IFn$_invoke$arity$1 ? sablono.interpreter.input.cljs$core$IFn$_invoke$arity$1(G__44606) : sablono.interpreter.input.call(null,G__44606));
})();
return React.DOM.div(G__44602,G__44603,G__44604);
});

hatti.views.table.t_hatti$views$table44597.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta44598], null);
});

hatti.views.table.t_hatti$views$table44597.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table44597.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table44597";

hatti.views.table.t_hatti$views$table44597.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"hatti.views.table/t_hatti$views$table44597");
});

hatti.views.table.__GT_t_hatti$views$table44597 = (function hatti$views$table$__GT_t_hatti$views$table44597(___$1,owner__$1,meta44598){
return (new hatti.views.table.t_hatti$views$table44597(___$1,owner__$1,meta44598));
});

}

return (new hatti.views.table.t_hatti$views$table44597(_,owner,null));
}));
hatti.views.table_header.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (cursor,owner){
if(typeof hatti.views.table.t_hatti$views$table44607 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table44607 = (function (cursor,owner,meta44608){
this.cursor = cursor;
this.owner = owner;
this.meta44608 = meta44608;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table44607.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_44609,meta44608__$1){
var self__ = this;
var _44609__$1 = this;
return (new hatti.views.table.t_hatti$views$table44607(self__.cursor,self__.owner,meta44608__$1));
});

hatti.views.table.t_hatti$views$table44607.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_44609){
var self__ = this;
var _44609__$1 = this;
return self__.meta44608;
});

hatti.views.table.t_hatti$views$table44607.prototype.om$core$IRender$ = true;

hatti.views.table.t_hatti$views$table44607.prototype.om$core$IRender$render$arity$1 = (function (this__18114__auto__){
var self__ = this;
var this__18114__auto____$1 = this;
var G__44612 = ({"className": "topbar"});
var G__44613 = (function (){var G__44617 = ({"id": hatti.views.table.pager_id});
return React.DOM.div(G__44617);
})();
var G__44614 = sablono.interpreter.interpret(om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.views.label_changer,self__.cursor));
var G__44615 = sablono.interpreter.interpret(om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.views.table_search,self__.cursor));
var G__44616 = (function (){var G__44618 = ({"style": ({"clear": "both"})});
return React.DOM.div(G__44618);
})();
return React.DOM.div(G__44612,G__44613,G__44614,G__44615,G__44616);
});

hatti.views.table.t_hatti$views$table44607.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$cursor,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta44608], null);
});

hatti.views.table.t_hatti$views$table44607.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table44607.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table44607";

hatti.views.table.t_hatti$views$table44607.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"hatti.views.table/t_hatti$views$table44607");
});

hatti.views.table.__GT_t_hatti$views$table44607 = (function hatti$views$table$__GT_t_hatti$views$table44607(cursor__$1,owner__$1,meta44608){
return (new hatti.views.table.t_hatti$views$table44607(cursor__$1,owner__$1,meta44608));
});

}

return (new hatti.views.table.t_hatti$views$table44607(cursor,owner,null));
}));
/**
 * Initializes grid + dataview, and stores them in owner's state.
 */
hatti.views.table.init_grid_BANG_ = (function hatti$views$table$init_grid_BANG_(data,owner,slick_grid_event_handlers){
if(cljs.core.seq(data)){
var map__44624 = om.core.get_shared.cljs$core$IFn$_invoke$arity$1(owner);
var map__44624__$1 = ((((!((map__44624 == null)))?((((map__44624.cljs$lang$protocol_mask$partition0$ & (64))) || (map__44624.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__44624):map__44624);
var flat_form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44624__$1,cljs.core.cst$kw$flat_DASH_form);
var is_filtered_dataview_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44624__$1,cljs.core.cst$kw$is_DASH_filtered_DASH_dataview_QMARK_);
var current_language = cljs.core.cst$kw$current.cljs$core$IFn$_invoke$arity$1(om.core.observe(owner,hatti.shared.language_cursor()));
var vec__44625 = hatti.views.table.sg_init(data,flat_form,current_language,is_filtered_dataview_QMARK_,owner,slick_grid_event_handlers);
var grid = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44625,(0),null);
var dataview = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44625,(1),null);
om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$grid,grid);

om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$dataview,dataview);

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [grid,dataview], null);
} else {
return null;
}
});
hatti.views.table.get_table_view_height = (function hatti$views$table$get_table_view_height(){
return (document.querySelector("body").clientHeight - document.querySelector(".tab-page").getBoundingClientRect().top);
});
hatti.views.table.set_window_resize_handler = (function hatti$views$table$set_window_resize_handler(owner){
var resize_handler = (function (event){
return om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$table_DASH_view_DASH_height,hatti.views.table.get_table_view_height());
});
window.addEventListener("resize",resize_handler);

return om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$resize_DASH_handler,resize_handler);
});
hatti.views.table_page.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (p__44630,owner,p__44631){
var map__44632 = p__44630;
var map__44632__$1 = ((((!((map__44632 == null)))?((((map__44632.cljs$lang$protocol_mask$partition0$ & (64))) || (map__44632.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__44632):map__44632);
var cursor = map__44632__$1;
var map__44633 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44632__$1,cljs.core.cst$kw$views);
var map__44633__$1 = ((((!((map__44633 == null)))?((((map__44633.cljs$lang$protocol_mask$partition0$ & (64))) || (map__44633.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__44633):map__44633);
var active = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44633__$1,cljs.core.cst$kw$active);
var map__44634 = p__44631;
var map__44634__$1 = ((((!((map__44634 == null)))?((((map__44634.cljs$lang$protocol_mask$partition0$ & (64))) || (map__44634.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__44634):map__44634);
var opts = map__44634__$1;
var slick_grid_event_handlers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44634__$1,cljs.core.cst$kw$slick_DASH_grid_DASH_event_DASH_handlers);

var active_QMARK_ = chimera.seq.in_QMARK_(active,cljs.core.cst$kw$table);
if(typeof hatti.views.table.t_hatti$views$table44638 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IWillUnmount}
 * @implements {om.core.IRenderState}
 * @implements {om.core.IWillReceiveProps}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IDidMount}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table44638 = (function (p__44631,owner,active_QMARK_,slick_grid_event_handlers,map__44632,p__44630,map__44633,cursor,map__44634,active,opts,meta44639){
this.p__44631 = p__44631;
this.owner = owner;
this.active_QMARK_ = active_QMARK_;
this.slick_grid_event_handlers = slick_grid_event_handlers;
this.map__44632 = map__44632;
this.p__44630 = p__44630;
this.map__44633 = map__44633;
this.cursor = cursor;
this.map__44634 = map__44634;
this.active = active;
this.opts = opts;
this.meta44639 = meta44639;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table44638.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (active_QMARK_,map__44632,map__44632__$1,cursor,map__44633,map__44633__$1,active,map__44634,map__44634__$1,opts,slick_grid_event_handlers){
return (function (_44640,meta44639__$1){
var self__ = this;
var _44640__$1 = this;
return (new hatti.views.table.t_hatti$views$table44638(self__.p__44631,self__.owner,self__.active_QMARK_,self__.slick_grid_event_handlers,self__.map__44632,self__.p__44630,self__.map__44633,self__.cursor,self__.map__44634,self__.active,self__.opts,meta44639__$1));
});})(active_QMARK_,map__44632,map__44632__$1,cursor,map__44633,map__44633__$1,active,map__44634,map__44634__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table44638.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (active_QMARK_,map__44632,map__44632__$1,cursor,map__44633,map__44633__$1,active,map__44634,map__44634__$1,opts,slick_grid_event_handlers){
return (function (_44640){
var self__ = this;
var _44640__$1 = this;
return self__.meta44639;
});})(active_QMARK_,map__44632,map__44632__$1,cursor,map__44633,map__44633__$1,active,map__44634,map__44634__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table44638.prototype.om$core$IRenderState$ = true;

hatti.views.table.t_hatti$views$table44638.prototype.om$core$IRenderState$render_state$arity$2 = ((function (active_QMARK_,map__44632,map__44632__$1,cursor,map__44633,map__44633__$1,active,map__44634,map__44634__$1,opts,slick_grid_event_handlers){
return (function (_,p__44641){
var self__ = this;
var map__44642 = p__44641;
var map__44642__$1 = ((((!((map__44642 == null)))?((((map__44642.cljs$lang$protocol_mask$partition0$ & (64))) || (map__44642.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__44642):map__44642);
var table_view_height = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44642__$1,cljs.core.cst$kw$table_DASH_view_DASH_height);
var ___$1 = this;
var map__44644 = self__.cursor;
var map__44644__$1 = ((((!((map__44644 == null)))?((((map__44644.cljs$lang$protocol_mask$partition0$ & (64))) || (map__44644.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__44644):map__44644);
var map__44645 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44644__$1,cljs.core.cst$kw$table_DASH_page);
var map__44645__$1 = ((((!((map__44645 == null)))?((((map__44645.cljs$lang$protocol_mask$partition0$ & (64))) || (map__44645.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__44645):map__44645);
var prevent_scrolling_in_table_view_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44645__$1,cljs.core.cst$kw$prevent_DASH_scrolling_DASH_in_DASH_table_DASH_view_QMARK_);
var submission_clicked = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44645__$1,cljs.core.cst$kw$submission_DASH_clicked);
var data = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44644__$1,cljs.core.cst$kw$data);
var dataset_info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44644__$1,cljs.core.cst$kw$dataset_DASH_info);
var map__44646 = dataset_info;
var map__44646__$1 = ((((!((map__44646 == null)))?((((map__44646.cljs$lang$protocol_mask$partition0$ & (64))) || (map__44646.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__44646):map__44646);
var num_of_submissions = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44646__$1,cljs.core.cst$kw$num_of_submissions);
var no_data_QMARK_ = cljs.core.empty_QMARK_(data);
var with_info = ((function (map__44644,map__44644__$1,map__44645,map__44645__$1,prevent_scrolling_in_table_view_QMARK_,submission_clicked,data,dataset_info,map__44646,map__44646__$1,num_of_submissions,no_data_QMARK_,___$1,map__44642,map__44642__$1,table_view_height,active_QMARK_,map__44632,map__44632__$1,cursor,map__44633,map__44633__$1,active,map__44634,map__44634__$1,opts,slick_grid_event_handlers){
return (function (p1__44629_SHARP_){
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([self__.cursor,p1__44629_SHARP_], 0));
});})(map__44644,map__44644__$1,map__44645,map__44645__$1,prevent_scrolling_in_table_view_QMARK_,submission_clicked,data,dataset_info,map__44646,map__44646__$1,num_of_submissions,no_data_QMARK_,___$1,map__44642,map__44642__$1,table_view_height,active_QMARK_,map__44632,map__44632__$1,cursor,map__44633,map__44633__$1,active,map__44634,map__44634__$1,opts,slick_grid_event_handlers))
;
if(cljs.core.truth_(self__.active_QMARK_)){
var G__44650 = ({"style": cljs.core.clj__GT_js((cljs.core.truth_(prevent_scrolling_in_table_view_QMARK_)?new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$height,(function (){var or__6409__auto__ = table_view_height;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return hatti.views.table.get_table_view_height();
}
})(),cljs.core.cst$kw$overflow,"hidden"], null):null)), "className": "table-view"});
var G__44651 = sablono.interpreter.interpret((cljs.core.truth_(cljs.core.cst$kw$data.cljs$core$IFn$_invoke$arity$1(submission_clicked))?om.core.build.cljs$core$IFn$_invoke$arity$3(hatti.views.submission_view,with_info(submission_clicked),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$opts,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.select_keys(self__.opts,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$role,null,cljs.core.cst$kw$delete_DASH_record_BANG_,null], null), null)),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$view,cljs.core.cst$kw$table], null)], 0))], null)):null));
var G__44652 = sablono.interpreter.interpret(om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.views.table_header,self__.cursor));
var G__44653 = (function (){var G__44654 = ({"id": hatti.views.table.table_id, "className": "slickgrid"});
var G__44655 = (((no_data_QMARK_) && ((num_of_submissions === (0))))?(function (){var G__44660 = ({"className": "alert alert-warning"});
var G__44661 = "No data";
return React.DOM.p(G__44660,G__44661);
})():(function (){var G__44662 = null;
var G__44663 = (function (){var G__44665 = ({"className": "fa fa-spinner fa-pulse"});
return React.DOM.i(G__44665);
})();
var G__44664 = "Loading...";
return React.DOM.span(G__44662,G__44663,G__44664);
})());
return React.DOM.div(G__44654,G__44655);
})();
return React.DOM.div(G__44650,G__44651,G__44652,G__44653);
} else {
return null;
}
});})(active_QMARK_,map__44632,map__44632__$1,cursor,map__44633,map__44633__$1,active,map__44634,map__44634__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table44638.prototype.om$core$IDidMount$ = true;

hatti.views.table.t_hatti$views$table44638.prototype.om$core$IDidMount$did_mount$arity$1 = ((function (active_QMARK_,map__44632,map__44632__$1,cursor,map__44633,map__44633__$1,active,map__44634,map__44634__$1,opts,slick_grid_event_handlers){
return (function (_){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.active_QMARK_)){
hatti.views.table.set_window_resize_handler(self__.owner);

var data = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.cursor,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data], null));
var temp__4657__auto__ = hatti.views.table.init_grid_BANG_(data,self__.owner,self__.slick_grid_event_handlers);
if(cljs.core.truth_(temp__4657__auto__)){
var vec__44666 = temp__4657__auto__;
var grid = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44666,(0),null);
var dataview = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44666,(1),null);
return hatti.views.table.handle_table_events(self__.cursor,grid,dataview);
} else {
return null;
}
} else {
return null;
}
});})(active_QMARK_,map__44632,map__44632__$1,cursor,map__44633,map__44633__$1,active,map__44634,map__44634__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table44638.prototype.om$core$IWillUnmount$ = true;

hatti.views.table.t_hatti$views$table44638.prototype.om$core$IWillUnmount$will_unmount$arity$1 = ((function (active_QMARK_,map__44632,map__44632__$1,cursor,map__44633,map__44633__$1,active,map__44634,map__44634__$1,opts,slick_grid_event_handlers){
return (function (_){
var self__ = this;
var ___$1 = this;
return window.removeEventListener("resize",om.core.get_state.cljs$core$IFn$_invoke$arity$2(self__.owner,cljs.core.cst$kw$resize_DASH_handler));
});})(active_QMARK_,map__44632,map__44632__$1,cursor,map__44633,map__44633__$1,active,map__44634,map__44634__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table44638.prototype.om$core$IWillReceiveProps$ = true;

hatti.views.table.t_hatti$views$table44638.prototype.om$core$IWillReceiveProps$will_receive_props$arity$2 = ((function (active_QMARK_,map__44632,map__44632__$1,cursor,map__44633,map__44633__$1,active,map__44634,map__44634__$1,opts,slick_grid_event_handlers){
return (function (_,next_props){
var self__ = this;
var ___$1 = this;

if(cljs.core.truth_(self__.active_QMARK_)){
var old_data = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(om.core.get_props.cljs$core$IFn$_invoke$arity$1(self__.owner),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data], null));
var new_data = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(next_props,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data], null));
var map__44669 = om.core.get_state.cljs$core$IFn$_invoke$arity$1(self__.owner);
var map__44669__$1 = ((((!((map__44669 == null)))?((((map__44669.cljs$lang$protocol_mask$partition0$ & (64))) || (map__44669.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__44669):map__44669);
var grid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44669__$1,cljs.core.cst$kw$grid);
var dataview = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44669__$1,cljs.core.cst$kw$dataview);
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(old_data,new_data)){
if(cljs.core.empty_QMARK_(old_data)){
var temp__4657__auto__ = hatti.views.table.init_grid_BANG_(new_data,self__.owner,self__.slick_grid_event_handlers);
if(cljs.core.truth_(temp__4657__auto__)){
var vec__44671 = temp__4657__auto__;
var grid__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44671,(0),null);
var dataview__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44671,(1),null);
return hatti.views.table.handle_table_events(self__.cursor,grid__$1,dataview__$1);
} else {
return null;
}
} else {
grid.invalidateAllRows();

dataview.setItems(cljs.core.clj__GT_js(new_data),hatti.constants._id);

return grid.render();
}
} else {
return null;
}
} else {
return null;
}
});})(active_QMARK_,map__44632,map__44632__$1,cursor,map__44633,map__44633__$1,active,map__44634,map__44634__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table44638.getBasis = ((function (active_QMARK_,map__44632,map__44632__$1,cursor,map__44633,map__44633__$1,active,map__44634,map__44634__$1,opts,slick_grid_event_handlers){
return (function (){
return new cljs.core.PersistentVector(null, 12, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p__44631,cljs.core.cst$sym$owner,cljs.core.cst$sym$active_QMARK_,cljs.core.cst$sym$slick_DASH_grid_DASH_event_DASH_handlers,cljs.core.cst$sym$map__44632,cljs.core.cst$sym$p__44630,cljs.core.cst$sym$map__44633,cljs.core.cst$sym$cursor,cljs.core.cst$sym$map__44634,cljs.core.cst$sym$active,cljs.core.cst$sym$opts,cljs.core.cst$sym$meta44639], null);
});})(active_QMARK_,map__44632,map__44632__$1,cursor,map__44633,map__44633__$1,active,map__44634,map__44634__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table44638.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table44638.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table44638";

hatti.views.table.t_hatti$views$table44638.cljs$lang$ctorPrWriter = ((function (active_QMARK_,map__44632,map__44632__$1,cursor,map__44633,map__44633__$1,active,map__44634,map__44634__$1,opts,slick_grid_event_handlers){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"hatti.views.table/t_hatti$views$table44638");
});})(active_QMARK_,map__44632,map__44632__$1,cursor,map__44633,map__44633__$1,active,map__44634,map__44634__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.__GT_t_hatti$views$table44638 = ((function (active_QMARK_,map__44632,map__44632__$1,cursor,map__44633,map__44633__$1,active,map__44634,map__44634__$1,opts,slick_grid_event_handlers){
return (function hatti$views$table$__GT_t_hatti$views$table44638(p__44631__$1,owner__$1,active_QMARK___$1,slick_grid_event_handlers__$1,map__44632__$2,p__44630__$1,map__44633__$2,cursor__$1,map__44634__$2,active__$1,opts__$1,meta44639){
return (new hatti.views.table.t_hatti$views$table44638(p__44631__$1,owner__$1,active_QMARK___$1,slick_grid_event_handlers__$1,map__44632__$2,p__44630__$1,map__44633__$2,cursor__$1,map__44634__$2,active__$1,opts__$1,meta44639));
});})(active_QMARK_,map__44632,map__44632__$1,cursor,map__44633,map__44633__$1,active,map__44634,map__44634__$1,opts,slick_grid_event_handlers))
;

}

return (new hatti.views.table.t_hatti$views$table44638(p__44631,owner,active_QMARK_,slick_grid_event_handlers,map__44632__$1,p__44630,map__44633__$1,cursor,map__44634__$1,active,opts,cljs.core.PersistentArrayMap.EMPTY));
}));
