// Compiled by ClojureScript 1.9.229 {:static-fns true, :optimize-constants true}
goog.provide('sablono.core');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('clojure.walk');
goog.require('sablono.util');
goog.require('sablono.interpreter');
goog.require('goog.dom');
/**
 * Add an optional attribute argument to a function that returns a element vector.
 */
sablono.core.wrap_attrs = (function sablono$core$wrap_attrs(func){
return (function() { 
var G__37438__delegate = function (args){
if(cljs.core.map_QMARK_(cljs.core.first(args))){
var vec__37435 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(func,cljs.core.rest(args));
var seq__37436 = cljs.core.seq(vec__37435);
var first__37437 = cljs.core.first(seq__37436);
var seq__37436__$1 = cljs.core.next(seq__37436);
var tag = first__37437;
var body = seq__37436__$1;
if(cljs.core.map_QMARK_(cljs.core.first(body))){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$4(cljs.core.vector,tag,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.first(body),cljs.core.first(args)], 0)),cljs.core.rest(body));
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$4(cljs.core.vector,tag,cljs.core.first(args),body);
}
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(func,args);
}
};
var G__37438 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__37439__i = 0, G__37439__a = new Array(arguments.length -  0);
while (G__37439__i < G__37439__a.length) {G__37439__a[G__37439__i] = arguments[G__37439__i + 0]; ++G__37439__i;}
  args = new cljs.core.IndexedSeq(G__37439__a,0);
} 
return G__37438__delegate.call(this,args);};
G__37438.cljs$lang$maxFixedArity = 0;
G__37438.cljs$lang$applyTo = (function (arglist__37440){
var args = cljs.core.seq(arglist__37440);
return G__37438__delegate(args);
});
G__37438.cljs$core$IFn$_invoke$arity$variadic = G__37438__delegate;
return G__37438;
})()
;
});
sablono.core.update_arglists = (function sablono$core$update_arglists(arglists){
var iter__7189__auto__ = (function sablono$core$update_arglists_$_iter__37447(s__37448){
return (new cljs.core.LazySeq(null,(function (){
var s__37448__$1 = s__37448;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__37448__$1);
if(temp__4657__auto__){
var s__37448__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__37448__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__37448__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__37450 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__37449 = (0);
while(true){
if((i__37449 < size__7188__auto__)){
var args = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__37449);
cljs.core.chunk_append(b__37450,cljs.core.vec(cljs.core.cons(cljs.core.cst$sym$attr_DASH_map_QMARK_,args)));

var G__37453 = (i__37449 + (1));
i__37449 = G__37453;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__37450),sablono$core$update_arglists_$_iter__37447(cljs.core.chunk_rest(s__37448__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__37450),null);
}
} else {
var args = cljs.core.first(s__37448__$2);
return cljs.core.cons(cljs.core.vec(cljs.core.cons(cljs.core.cst$sym$attr_DASH_map_QMARK_,args)),sablono$core$update_arglists_$_iter__37447(cljs.core.rest(s__37448__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__(arglists);
});
/**
 * Render `element` as HTML string.
 */
sablono.core.render = (function sablono$core$render(element){
if(cljs.core.truth_(element)){
return React.renderToString(element);
} else {
return null;
}
});
/**
 * Render `element` as HTML string, without React internal attributes.
 */
sablono.core.render_static = (function sablono$core$render_static(element){
if(cljs.core.truth_(element)){
return React.renderToStaticMarkup(element);
} else {
return null;
}
});
/**
 * Include a list of external stylesheet files.
 */
sablono.core.include_css = (function sablono$core$include_css(var_args){
var args__7491__auto__ = [];
var len__7484__auto___37461 = arguments.length;
var i__7485__auto___37462 = (0);
while(true){
if((i__7485__auto___37462 < len__7484__auto___37461)){
args__7491__auto__.push((arguments[i__7485__auto___37462]));

var G__37463 = (i__7485__auto___37462 + (1));
i__7485__auto___37462 = G__37463;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((0) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((0)),(0),null)):null);
return sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic(argseq__7492__auto__);
});

sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic = (function (styles){
var iter__7189__auto__ = (function sablono$core$iter__37455(s__37456){
return (new cljs.core.LazySeq(null,(function (){
var s__37456__$1 = s__37456;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__37456__$1);
if(temp__4657__auto__){
var s__37456__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__37456__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__37456__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__37458 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__37457 = (0);
while(true){
if((i__37457 < size__7188__auto__)){
var style = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__37457);
cljs.core.chunk_append(b__37458,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$link,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$type,"text/css",cljs.core.cst$kw$href,sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([style], 0)),cljs.core.cst$kw$rel,"stylesheet"], null)], null));

var G__37464 = (i__37457 + (1));
i__37457 = G__37464;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__37458),sablono$core$iter__37455(cljs.core.chunk_rest(s__37456__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__37458),null);
}
} else {
var style = cljs.core.first(s__37456__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$link,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$type,"text/css",cljs.core.cst$kw$href,sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([style], 0)),cljs.core.cst$kw$rel,"stylesheet"], null)], null),sablono$core$iter__37455(cljs.core.rest(s__37456__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__(styles);
});

sablono.core.include_css.cljs$lang$maxFixedArity = (0);

sablono.core.include_css.cljs$lang$applyTo = (function (seq37454){
return sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq37454));
});

/**
 * Include the JavaScript library at `src`.
 */
sablono.core.include_js = (function sablono$core$include_js(src){
var G__37469 = goog.dom.getDocument().body;
var G__37470 = (function (){var G__37471 = "script";
var G__37472 = ({"src": src});
return goog.dom.createDom(G__37471,G__37472);
})();
return goog.dom.appendChild(G__37469,G__37470);
});
/**
 * Include Facebook's React JavaScript library.
 */
sablono.core.include_react = (function sablono$core$include_react(){
return sablono.core.include_js("http://fb.me/react-0.12.2.js");
});
/**
 * Wraps some content in a HTML hyperlink with the supplied URL.
 */
sablono.core.link_to37473 = (function sablono$core$link_to37473(var_args){
var args__7491__auto__ = [];
var len__7484__auto___37476 = arguments.length;
var i__7485__auto___37477 = (0);
while(true){
if((i__7485__auto___37477 < len__7484__auto___37476)){
args__7491__auto__.push((arguments[i__7485__auto___37477]));

var G__37478 = (i__7485__auto___37477 + (1));
i__7485__auto___37477 = G__37478;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return sablono.core.link_to37473.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

sablono.core.link_to37473.cljs$core$IFn$_invoke$arity$variadic = (function (url,content){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$href,sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([url], 0))], null),content], null);
});

sablono.core.link_to37473.cljs$lang$maxFixedArity = (1);

sablono.core.link_to37473.cljs$lang$applyTo = (function (seq37474){
var G__37475 = cljs.core.first(seq37474);
var seq37474__$1 = cljs.core.next(seq37474);
return sablono.core.link_to37473.cljs$core$IFn$_invoke$arity$variadic(G__37475,seq37474__$1);
});


sablono.core.link_to = sablono.core.wrap_attrs(sablono.core.link_to37473);
/**
 * Wraps some content in a HTML hyperlink with the supplied e-mail
 *   address. If no content provided use the e-mail address as content.
 */
sablono.core.mail_to37479 = (function sablono$core$mail_to37479(var_args){
var args__7491__auto__ = [];
var len__7484__auto___37486 = arguments.length;
var i__7485__auto___37487 = (0);
while(true){
if((i__7485__auto___37487 < len__7484__auto___37486)){
args__7491__auto__.push((arguments[i__7485__auto___37487]));

var G__37488 = (i__7485__auto___37487 + (1));
i__7485__auto___37487 = G__37488;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return sablono.core.mail_to37479.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

sablono.core.mail_to37479.cljs$core$IFn$_invoke$arity$variadic = (function (e_mail,p__37482){
var vec__37483 = p__37482;
var content = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37483,(0),null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$href,[cljs.core.str("mailto:"),cljs.core.str(e_mail)].join('')], null),(function (){var or__6409__auto__ = content;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return e_mail;
}
})()], null);
});

sablono.core.mail_to37479.cljs$lang$maxFixedArity = (1);

sablono.core.mail_to37479.cljs$lang$applyTo = (function (seq37480){
var G__37481 = cljs.core.first(seq37480);
var seq37480__$1 = cljs.core.next(seq37480);
return sablono.core.mail_to37479.cljs$core$IFn$_invoke$arity$variadic(G__37481,seq37480__$1);
});


sablono.core.mail_to = sablono.core.wrap_attrs(sablono.core.mail_to37479);
/**
 * Wrap a collection in an unordered list.
 */
sablono.core.unordered_list37489 = (function sablono$core$unordered_list37489(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$ul,(function (){var iter__7189__auto__ = (function sablono$core$unordered_list37489_$_iter__37496(s__37497){
return (new cljs.core.LazySeq(null,(function (){
var s__37497__$1 = s__37497;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__37497__$1);
if(temp__4657__auto__){
var s__37497__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__37497__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__37497__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__37499 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__37498 = (0);
while(true){
if((i__37498 < size__7188__auto__)){
var x = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__37498);
cljs.core.chunk_append(b__37499,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,x], null));

var G__37502 = (i__37498 + (1));
i__37498 = G__37502;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__37499),sablono$core$unordered_list37489_$_iter__37496(cljs.core.chunk_rest(s__37497__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__37499),null);
}
} else {
var x = cljs.core.first(s__37497__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,x], null),sablono$core$unordered_list37489_$_iter__37496(cljs.core.rest(s__37497__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__(coll);
})()], null);
});

sablono.core.unordered_list = sablono.core.wrap_attrs(sablono.core.unordered_list37489);
/**
 * Wrap a collection in an ordered list.
 */
sablono.core.ordered_list37503 = (function sablono$core$ordered_list37503(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$ol,(function (){var iter__7189__auto__ = (function sablono$core$ordered_list37503_$_iter__37510(s__37511){
return (new cljs.core.LazySeq(null,(function (){
var s__37511__$1 = s__37511;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__37511__$1);
if(temp__4657__auto__){
var s__37511__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__37511__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__37511__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__37513 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__37512 = (0);
while(true){
if((i__37512 < size__7188__auto__)){
var x = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__37512);
cljs.core.chunk_append(b__37513,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,x], null));

var G__37516 = (i__37512 + (1));
i__37512 = G__37516;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__37513),sablono$core$ordered_list37503_$_iter__37510(cljs.core.chunk_rest(s__37511__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__37513),null);
}
} else {
var x = cljs.core.first(s__37511__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,x], null),sablono$core$ordered_list37503_$_iter__37510(cljs.core.rest(s__37511__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__(coll);
})()], null);
});

sablono.core.ordered_list = sablono.core.wrap_attrs(sablono.core.ordered_list37503);
/**
 * Create an image element.
 */
sablono.core.image37517 = (function sablono$core$image37517(var_args){
var args37518 = [];
var len__7484__auto___37521 = arguments.length;
var i__7485__auto___37522 = (0);
while(true){
if((i__7485__auto___37522 < len__7484__auto___37521)){
args37518.push((arguments[i__7485__auto___37522]));

var G__37523 = (i__7485__auto___37522 + (1));
i__7485__auto___37522 = G__37523;
continue;
} else {
}
break;
}

var G__37520 = args37518.length;
switch (G__37520) {
case 1:
return sablono.core.image37517.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.image37517.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37518.length)].join('')));

}
});

sablono.core.image37517.cljs$core$IFn$_invoke$arity$1 = (function (src){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$img,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$src,sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([src], 0))], null)], null);
});

sablono.core.image37517.cljs$core$IFn$_invoke$arity$2 = (function (src,alt){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$img,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$src,sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([src], 0)),cljs.core.cst$kw$alt,alt], null)], null);
});

sablono.core.image37517.cljs$lang$maxFixedArity = 2;


sablono.core.image = sablono.core.wrap_attrs(sablono.core.image37517);
sablono.core._STAR_group_STAR_ = cljs.core.PersistentVector.EMPTY;
/**
 * Create a field name from the supplied argument the current field group.
 */
sablono.core.make_name = (function sablono$core$make_name(name){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2((function (p1__37525_SHARP_,p2__37526_SHARP_){
return [cljs.core.str(p1__37525_SHARP_),cljs.core.str("["),cljs.core.str(p2__37526_SHARP_),cljs.core.str("]")].join('');
}),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(sablono.core._STAR_group_STAR_,sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([name], 0))));
});
/**
 * Create a field id from the supplied argument and current field group.
 */
sablono.core.make_id = (function sablono$core$make_id(name){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2((function (p1__37527_SHARP_,p2__37528_SHARP_){
return [cljs.core.str(p1__37527_SHARP_),cljs.core.str("-"),cljs.core.str(p2__37528_SHARP_)].join('');
}),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(sablono.core._STAR_group_STAR_,sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([name], 0))));
});
/**
 * Creates a new <input> element.
 */
sablono.core.input_field_STAR_ = (function sablono$core$input_field_STAR_(type,name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$input,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$type,type,cljs.core.cst$kw$name,sablono.core.make_name(name),cljs.core.cst$kw$id,sablono.core.make_id(name),cljs.core.cst$kw$value,value], null)], null);
});
/**
 * Creates a color input field.
 */
sablono.core.color_field37529 = (function sablono$core$color_field37529(var_args){
var args37530 = [];
var len__7484__auto___37597 = arguments.length;
var i__7485__auto___37598 = (0);
while(true){
if((i__7485__auto___37598 < len__7484__auto___37597)){
args37530.push((arguments[i__7485__auto___37598]));

var G__37599 = (i__7485__auto___37598 + (1));
i__7485__auto___37598 = G__37599;
continue;
} else {
}
break;
}

var G__37532 = args37530.length;
switch (G__37532) {
case 1:
return sablono.core.color_field37529.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.color_field37529.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37530.length)].join('')));

}
});

sablono.core.color_field37529.cljs$core$IFn$_invoke$arity$1 = (function (name__19359__auto__){
return sablono.core.color_field37529.cljs$core$IFn$_invoke$arity$2(name__19359__auto__,null);
});

sablono.core.color_field37529.cljs$core$IFn$_invoke$arity$2 = (function (name__19359__auto__,value__19360__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$color)].join(''),name__19359__auto__,value__19360__auto__);
});

sablono.core.color_field37529.cljs$lang$maxFixedArity = 2;


sablono.core.color_field = sablono.core.wrap_attrs(sablono.core.color_field37529);

/**
 * Creates a date input field.
 */
sablono.core.date_field37533 = (function sablono$core$date_field37533(var_args){
var args37534 = [];
var len__7484__auto___37601 = arguments.length;
var i__7485__auto___37602 = (0);
while(true){
if((i__7485__auto___37602 < len__7484__auto___37601)){
args37534.push((arguments[i__7485__auto___37602]));

var G__37603 = (i__7485__auto___37602 + (1));
i__7485__auto___37602 = G__37603;
continue;
} else {
}
break;
}

var G__37536 = args37534.length;
switch (G__37536) {
case 1:
return sablono.core.date_field37533.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.date_field37533.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37534.length)].join('')));

}
});

sablono.core.date_field37533.cljs$core$IFn$_invoke$arity$1 = (function (name__19359__auto__){
return sablono.core.date_field37533.cljs$core$IFn$_invoke$arity$2(name__19359__auto__,null);
});

sablono.core.date_field37533.cljs$core$IFn$_invoke$arity$2 = (function (name__19359__auto__,value__19360__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$date)].join(''),name__19359__auto__,value__19360__auto__);
});

sablono.core.date_field37533.cljs$lang$maxFixedArity = 2;


sablono.core.date_field = sablono.core.wrap_attrs(sablono.core.date_field37533);

/**
 * Creates a datetime input field.
 */
sablono.core.datetime_field37537 = (function sablono$core$datetime_field37537(var_args){
var args37538 = [];
var len__7484__auto___37605 = arguments.length;
var i__7485__auto___37606 = (0);
while(true){
if((i__7485__auto___37606 < len__7484__auto___37605)){
args37538.push((arguments[i__7485__auto___37606]));

var G__37607 = (i__7485__auto___37606 + (1));
i__7485__auto___37606 = G__37607;
continue;
} else {
}
break;
}

var G__37540 = args37538.length;
switch (G__37540) {
case 1:
return sablono.core.datetime_field37537.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_field37537.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37538.length)].join('')));

}
});

sablono.core.datetime_field37537.cljs$core$IFn$_invoke$arity$1 = (function (name__19359__auto__){
return sablono.core.datetime_field37537.cljs$core$IFn$_invoke$arity$2(name__19359__auto__,null);
});

sablono.core.datetime_field37537.cljs$core$IFn$_invoke$arity$2 = (function (name__19359__auto__,value__19360__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$datetime)].join(''),name__19359__auto__,value__19360__auto__);
});

sablono.core.datetime_field37537.cljs$lang$maxFixedArity = 2;


sablono.core.datetime_field = sablono.core.wrap_attrs(sablono.core.datetime_field37537);

/**
 * Creates a datetime-local input field.
 */
sablono.core.datetime_local_field37541 = (function sablono$core$datetime_local_field37541(var_args){
var args37542 = [];
var len__7484__auto___37609 = arguments.length;
var i__7485__auto___37610 = (0);
while(true){
if((i__7485__auto___37610 < len__7484__auto___37609)){
args37542.push((arguments[i__7485__auto___37610]));

var G__37611 = (i__7485__auto___37610 + (1));
i__7485__auto___37610 = G__37611;
continue;
} else {
}
break;
}

var G__37544 = args37542.length;
switch (G__37544) {
case 1:
return sablono.core.datetime_local_field37541.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_local_field37541.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37542.length)].join('')));

}
});

sablono.core.datetime_local_field37541.cljs$core$IFn$_invoke$arity$1 = (function (name__19359__auto__){
return sablono.core.datetime_local_field37541.cljs$core$IFn$_invoke$arity$2(name__19359__auto__,null);
});

sablono.core.datetime_local_field37541.cljs$core$IFn$_invoke$arity$2 = (function (name__19359__auto__,value__19360__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$datetime_DASH_local)].join(''),name__19359__auto__,value__19360__auto__);
});

sablono.core.datetime_local_field37541.cljs$lang$maxFixedArity = 2;


sablono.core.datetime_local_field = sablono.core.wrap_attrs(sablono.core.datetime_local_field37541);

/**
 * Creates a email input field.
 */
sablono.core.email_field37545 = (function sablono$core$email_field37545(var_args){
var args37546 = [];
var len__7484__auto___37613 = arguments.length;
var i__7485__auto___37614 = (0);
while(true){
if((i__7485__auto___37614 < len__7484__auto___37613)){
args37546.push((arguments[i__7485__auto___37614]));

var G__37615 = (i__7485__auto___37614 + (1));
i__7485__auto___37614 = G__37615;
continue;
} else {
}
break;
}

var G__37548 = args37546.length;
switch (G__37548) {
case 1:
return sablono.core.email_field37545.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.email_field37545.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37546.length)].join('')));

}
});

sablono.core.email_field37545.cljs$core$IFn$_invoke$arity$1 = (function (name__19359__auto__){
return sablono.core.email_field37545.cljs$core$IFn$_invoke$arity$2(name__19359__auto__,null);
});

sablono.core.email_field37545.cljs$core$IFn$_invoke$arity$2 = (function (name__19359__auto__,value__19360__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$email)].join(''),name__19359__auto__,value__19360__auto__);
});

sablono.core.email_field37545.cljs$lang$maxFixedArity = 2;


sablono.core.email_field = sablono.core.wrap_attrs(sablono.core.email_field37545);

/**
 * Creates a file input field.
 */
sablono.core.file_field37549 = (function sablono$core$file_field37549(var_args){
var args37550 = [];
var len__7484__auto___37617 = arguments.length;
var i__7485__auto___37618 = (0);
while(true){
if((i__7485__auto___37618 < len__7484__auto___37617)){
args37550.push((arguments[i__7485__auto___37618]));

var G__37619 = (i__7485__auto___37618 + (1));
i__7485__auto___37618 = G__37619;
continue;
} else {
}
break;
}

var G__37552 = args37550.length;
switch (G__37552) {
case 1:
return sablono.core.file_field37549.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.file_field37549.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37550.length)].join('')));

}
});

sablono.core.file_field37549.cljs$core$IFn$_invoke$arity$1 = (function (name__19359__auto__){
return sablono.core.file_field37549.cljs$core$IFn$_invoke$arity$2(name__19359__auto__,null);
});

sablono.core.file_field37549.cljs$core$IFn$_invoke$arity$2 = (function (name__19359__auto__,value__19360__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$file)].join(''),name__19359__auto__,value__19360__auto__);
});

sablono.core.file_field37549.cljs$lang$maxFixedArity = 2;


sablono.core.file_field = sablono.core.wrap_attrs(sablono.core.file_field37549);

/**
 * Creates a hidden input field.
 */
sablono.core.hidden_field37553 = (function sablono$core$hidden_field37553(var_args){
var args37554 = [];
var len__7484__auto___37621 = arguments.length;
var i__7485__auto___37622 = (0);
while(true){
if((i__7485__auto___37622 < len__7484__auto___37621)){
args37554.push((arguments[i__7485__auto___37622]));

var G__37623 = (i__7485__auto___37622 + (1));
i__7485__auto___37622 = G__37623;
continue;
} else {
}
break;
}

var G__37556 = args37554.length;
switch (G__37556) {
case 1:
return sablono.core.hidden_field37553.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.hidden_field37553.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37554.length)].join('')));

}
});

sablono.core.hidden_field37553.cljs$core$IFn$_invoke$arity$1 = (function (name__19359__auto__){
return sablono.core.hidden_field37553.cljs$core$IFn$_invoke$arity$2(name__19359__auto__,null);
});

sablono.core.hidden_field37553.cljs$core$IFn$_invoke$arity$2 = (function (name__19359__auto__,value__19360__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$hidden)].join(''),name__19359__auto__,value__19360__auto__);
});

sablono.core.hidden_field37553.cljs$lang$maxFixedArity = 2;


sablono.core.hidden_field = sablono.core.wrap_attrs(sablono.core.hidden_field37553);

/**
 * Creates a month input field.
 */
sablono.core.month_field37557 = (function sablono$core$month_field37557(var_args){
var args37558 = [];
var len__7484__auto___37625 = arguments.length;
var i__7485__auto___37626 = (0);
while(true){
if((i__7485__auto___37626 < len__7484__auto___37625)){
args37558.push((arguments[i__7485__auto___37626]));

var G__37627 = (i__7485__auto___37626 + (1));
i__7485__auto___37626 = G__37627;
continue;
} else {
}
break;
}

var G__37560 = args37558.length;
switch (G__37560) {
case 1:
return sablono.core.month_field37557.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.month_field37557.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37558.length)].join('')));

}
});

sablono.core.month_field37557.cljs$core$IFn$_invoke$arity$1 = (function (name__19359__auto__){
return sablono.core.month_field37557.cljs$core$IFn$_invoke$arity$2(name__19359__auto__,null);
});

sablono.core.month_field37557.cljs$core$IFn$_invoke$arity$2 = (function (name__19359__auto__,value__19360__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$month)].join(''),name__19359__auto__,value__19360__auto__);
});

sablono.core.month_field37557.cljs$lang$maxFixedArity = 2;


sablono.core.month_field = sablono.core.wrap_attrs(sablono.core.month_field37557);

/**
 * Creates a number input field.
 */
sablono.core.number_field37561 = (function sablono$core$number_field37561(var_args){
var args37562 = [];
var len__7484__auto___37629 = arguments.length;
var i__7485__auto___37630 = (0);
while(true){
if((i__7485__auto___37630 < len__7484__auto___37629)){
args37562.push((arguments[i__7485__auto___37630]));

var G__37631 = (i__7485__auto___37630 + (1));
i__7485__auto___37630 = G__37631;
continue;
} else {
}
break;
}

var G__37564 = args37562.length;
switch (G__37564) {
case 1:
return sablono.core.number_field37561.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.number_field37561.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37562.length)].join('')));

}
});

sablono.core.number_field37561.cljs$core$IFn$_invoke$arity$1 = (function (name__19359__auto__){
return sablono.core.number_field37561.cljs$core$IFn$_invoke$arity$2(name__19359__auto__,null);
});

sablono.core.number_field37561.cljs$core$IFn$_invoke$arity$2 = (function (name__19359__auto__,value__19360__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$number)].join(''),name__19359__auto__,value__19360__auto__);
});

sablono.core.number_field37561.cljs$lang$maxFixedArity = 2;


sablono.core.number_field = sablono.core.wrap_attrs(sablono.core.number_field37561);

/**
 * Creates a password input field.
 */
sablono.core.password_field37565 = (function sablono$core$password_field37565(var_args){
var args37566 = [];
var len__7484__auto___37633 = arguments.length;
var i__7485__auto___37634 = (0);
while(true){
if((i__7485__auto___37634 < len__7484__auto___37633)){
args37566.push((arguments[i__7485__auto___37634]));

var G__37635 = (i__7485__auto___37634 + (1));
i__7485__auto___37634 = G__37635;
continue;
} else {
}
break;
}

var G__37568 = args37566.length;
switch (G__37568) {
case 1:
return sablono.core.password_field37565.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.password_field37565.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37566.length)].join('')));

}
});

sablono.core.password_field37565.cljs$core$IFn$_invoke$arity$1 = (function (name__19359__auto__){
return sablono.core.password_field37565.cljs$core$IFn$_invoke$arity$2(name__19359__auto__,null);
});

sablono.core.password_field37565.cljs$core$IFn$_invoke$arity$2 = (function (name__19359__auto__,value__19360__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$password)].join(''),name__19359__auto__,value__19360__auto__);
});

sablono.core.password_field37565.cljs$lang$maxFixedArity = 2;


sablono.core.password_field = sablono.core.wrap_attrs(sablono.core.password_field37565);

/**
 * Creates a range input field.
 */
sablono.core.range_field37569 = (function sablono$core$range_field37569(var_args){
var args37570 = [];
var len__7484__auto___37637 = arguments.length;
var i__7485__auto___37638 = (0);
while(true){
if((i__7485__auto___37638 < len__7484__auto___37637)){
args37570.push((arguments[i__7485__auto___37638]));

var G__37639 = (i__7485__auto___37638 + (1));
i__7485__auto___37638 = G__37639;
continue;
} else {
}
break;
}

var G__37572 = args37570.length;
switch (G__37572) {
case 1:
return sablono.core.range_field37569.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.range_field37569.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37570.length)].join('')));

}
});

sablono.core.range_field37569.cljs$core$IFn$_invoke$arity$1 = (function (name__19359__auto__){
return sablono.core.range_field37569.cljs$core$IFn$_invoke$arity$2(name__19359__auto__,null);
});

sablono.core.range_field37569.cljs$core$IFn$_invoke$arity$2 = (function (name__19359__auto__,value__19360__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$range)].join(''),name__19359__auto__,value__19360__auto__);
});

sablono.core.range_field37569.cljs$lang$maxFixedArity = 2;


sablono.core.range_field = sablono.core.wrap_attrs(sablono.core.range_field37569);

/**
 * Creates a search input field.
 */
sablono.core.search_field37573 = (function sablono$core$search_field37573(var_args){
var args37574 = [];
var len__7484__auto___37641 = arguments.length;
var i__7485__auto___37642 = (0);
while(true){
if((i__7485__auto___37642 < len__7484__auto___37641)){
args37574.push((arguments[i__7485__auto___37642]));

var G__37643 = (i__7485__auto___37642 + (1));
i__7485__auto___37642 = G__37643;
continue;
} else {
}
break;
}

var G__37576 = args37574.length;
switch (G__37576) {
case 1:
return sablono.core.search_field37573.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.search_field37573.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37574.length)].join('')));

}
});

sablono.core.search_field37573.cljs$core$IFn$_invoke$arity$1 = (function (name__19359__auto__){
return sablono.core.search_field37573.cljs$core$IFn$_invoke$arity$2(name__19359__auto__,null);
});

sablono.core.search_field37573.cljs$core$IFn$_invoke$arity$2 = (function (name__19359__auto__,value__19360__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$search)].join(''),name__19359__auto__,value__19360__auto__);
});

sablono.core.search_field37573.cljs$lang$maxFixedArity = 2;


sablono.core.search_field = sablono.core.wrap_attrs(sablono.core.search_field37573);

/**
 * Creates a tel input field.
 */
sablono.core.tel_field37577 = (function sablono$core$tel_field37577(var_args){
var args37578 = [];
var len__7484__auto___37645 = arguments.length;
var i__7485__auto___37646 = (0);
while(true){
if((i__7485__auto___37646 < len__7484__auto___37645)){
args37578.push((arguments[i__7485__auto___37646]));

var G__37647 = (i__7485__auto___37646 + (1));
i__7485__auto___37646 = G__37647;
continue;
} else {
}
break;
}

var G__37580 = args37578.length;
switch (G__37580) {
case 1:
return sablono.core.tel_field37577.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.tel_field37577.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37578.length)].join('')));

}
});

sablono.core.tel_field37577.cljs$core$IFn$_invoke$arity$1 = (function (name__19359__auto__){
return sablono.core.tel_field37577.cljs$core$IFn$_invoke$arity$2(name__19359__auto__,null);
});

sablono.core.tel_field37577.cljs$core$IFn$_invoke$arity$2 = (function (name__19359__auto__,value__19360__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$tel)].join(''),name__19359__auto__,value__19360__auto__);
});

sablono.core.tel_field37577.cljs$lang$maxFixedArity = 2;


sablono.core.tel_field = sablono.core.wrap_attrs(sablono.core.tel_field37577);

/**
 * Creates a text input field.
 */
sablono.core.text_field37581 = (function sablono$core$text_field37581(var_args){
var args37582 = [];
var len__7484__auto___37649 = arguments.length;
var i__7485__auto___37650 = (0);
while(true){
if((i__7485__auto___37650 < len__7484__auto___37649)){
args37582.push((arguments[i__7485__auto___37650]));

var G__37651 = (i__7485__auto___37650 + (1));
i__7485__auto___37650 = G__37651;
continue;
} else {
}
break;
}

var G__37584 = args37582.length;
switch (G__37584) {
case 1:
return sablono.core.text_field37581.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_field37581.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37582.length)].join('')));

}
});

sablono.core.text_field37581.cljs$core$IFn$_invoke$arity$1 = (function (name__19359__auto__){
return sablono.core.text_field37581.cljs$core$IFn$_invoke$arity$2(name__19359__auto__,null);
});

sablono.core.text_field37581.cljs$core$IFn$_invoke$arity$2 = (function (name__19359__auto__,value__19360__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$text)].join(''),name__19359__auto__,value__19360__auto__);
});

sablono.core.text_field37581.cljs$lang$maxFixedArity = 2;


sablono.core.text_field = sablono.core.wrap_attrs(sablono.core.text_field37581);

/**
 * Creates a time input field.
 */
sablono.core.time_field37585 = (function sablono$core$time_field37585(var_args){
var args37586 = [];
var len__7484__auto___37653 = arguments.length;
var i__7485__auto___37654 = (0);
while(true){
if((i__7485__auto___37654 < len__7484__auto___37653)){
args37586.push((arguments[i__7485__auto___37654]));

var G__37655 = (i__7485__auto___37654 + (1));
i__7485__auto___37654 = G__37655;
continue;
} else {
}
break;
}

var G__37588 = args37586.length;
switch (G__37588) {
case 1:
return sablono.core.time_field37585.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.time_field37585.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37586.length)].join('')));

}
});

sablono.core.time_field37585.cljs$core$IFn$_invoke$arity$1 = (function (name__19359__auto__){
return sablono.core.time_field37585.cljs$core$IFn$_invoke$arity$2(name__19359__auto__,null);
});

sablono.core.time_field37585.cljs$core$IFn$_invoke$arity$2 = (function (name__19359__auto__,value__19360__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$time)].join(''),name__19359__auto__,value__19360__auto__);
});

sablono.core.time_field37585.cljs$lang$maxFixedArity = 2;


sablono.core.time_field = sablono.core.wrap_attrs(sablono.core.time_field37585);

/**
 * Creates a url input field.
 */
sablono.core.url_field37589 = (function sablono$core$url_field37589(var_args){
var args37590 = [];
var len__7484__auto___37657 = arguments.length;
var i__7485__auto___37658 = (0);
while(true){
if((i__7485__auto___37658 < len__7484__auto___37657)){
args37590.push((arguments[i__7485__auto___37658]));

var G__37659 = (i__7485__auto___37658 + (1));
i__7485__auto___37658 = G__37659;
continue;
} else {
}
break;
}

var G__37592 = args37590.length;
switch (G__37592) {
case 1:
return sablono.core.url_field37589.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.url_field37589.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37590.length)].join('')));

}
});

sablono.core.url_field37589.cljs$core$IFn$_invoke$arity$1 = (function (name__19359__auto__){
return sablono.core.url_field37589.cljs$core$IFn$_invoke$arity$2(name__19359__auto__,null);
});

sablono.core.url_field37589.cljs$core$IFn$_invoke$arity$2 = (function (name__19359__auto__,value__19360__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$url)].join(''),name__19359__auto__,value__19360__auto__);
});

sablono.core.url_field37589.cljs$lang$maxFixedArity = 2;


sablono.core.url_field = sablono.core.wrap_attrs(sablono.core.url_field37589);

/**
 * Creates a week input field.
 */
sablono.core.week_field37593 = (function sablono$core$week_field37593(var_args){
var args37594 = [];
var len__7484__auto___37661 = arguments.length;
var i__7485__auto___37662 = (0);
while(true){
if((i__7485__auto___37662 < len__7484__auto___37661)){
args37594.push((arguments[i__7485__auto___37662]));

var G__37663 = (i__7485__auto___37662 + (1));
i__7485__auto___37662 = G__37663;
continue;
} else {
}
break;
}

var G__37596 = args37594.length;
switch (G__37596) {
case 1:
return sablono.core.week_field37593.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.week_field37593.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37594.length)].join('')));

}
});

sablono.core.week_field37593.cljs$core$IFn$_invoke$arity$1 = (function (name__19359__auto__){
return sablono.core.week_field37593.cljs$core$IFn$_invoke$arity$2(name__19359__auto__,null);
});

sablono.core.week_field37593.cljs$core$IFn$_invoke$arity$2 = (function (name__19359__auto__,value__19360__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$week)].join(''),name__19359__auto__,value__19360__auto__);
});

sablono.core.week_field37593.cljs$lang$maxFixedArity = 2;


sablono.core.week_field = sablono.core.wrap_attrs(sablono.core.week_field37593);
sablono.core.file_upload = sablono.core.file_field;
/**
 * Creates a check box.
 */
sablono.core.check_box37665 = (function sablono$core$check_box37665(var_args){
var args37666 = [];
var len__7484__auto___37669 = arguments.length;
var i__7485__auto___37670 = (0);
while(true){
if((i__7485__auto___37670 < len__7484__auto___37669)){
args37666.push((arguments[i__7485__auto___37670]));

var G__37671 = (i__7485__auto___37670 + (1));
i__7485__auto___37670 = G__37671;
continue;
} else {
}
break;
}

var G__37668 = args37666.length;
switch (G__37668) {
case 1:
return sablono.core.check_box37665.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.check_box37665.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.check_box37665.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37666.length)].join('')));

}
});

sablono.core.check_box37665.cljs$core$IFn$_invoke$arity$1 = (function (name){
return sablono.core.check_box37665.cljs$core$IFn$_invoke$arity$2(name,null);
});

sablono.core.check_box37665.cljs$core$IFn$_invoke$arity$2 = (function (name,checked_QMARK_){
return sablono.core.check_box37665.cljs$core$IFn$_invoke$arity$3(name,checked_QMARK_,"true");
});

sablono.core.check_box37665.cljs$core$IFn$_invoke$arity$3 = (function (name,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$input,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$type,"checkbox",cljs.core.cst$kw$name,sablono.core.make_name(name),cljs.core.cst$kw$id,sablono.core.make_id(name),cljs.core.cst$kw$value,value,cljs.core.cst$kw$checked,checked_QMARK_], null)], null);
});

sablono.core.check_box37665.cljs$lang$maxFixedArity = 3;


sablono.core.check_box = sablono.core.wrap_attrs(sablono.core.check_box37665);
/**
 * Creates a radio button.
 */
sablono.core.radio_button37673 = (function sablono$core$radio_button37673(var_args){
var args37674 = [];
var len__7484__auto___37677 = arguments.length;
var i__7485__auto___37678 = (0);
while(true){
if((i__7485__auto___37678 < len__7484__auto___37677)){
args37674.push((arguments[i__7485__auto___37678]));

var G__37679 = (i__7485__auto___37678 + (1));
i__7485__auto___37678 = G__37679;
continue;
} else {
}
break;
}

var G__37676 = args37674.length;
switch (G__37676) {
case 1:
return sablono.core.radio_button37673.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.radio_button37673.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.radio_button37673.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37674.length)].join('')));

}
});

sablono.core.radio_button37673.cljs$core$IFn$_invoke$arity$1 = (function (group){
return sablono.core.radio_button37673.cljs$core$IFn$_invoke$arity$2(group,null);
});

sablono.core.radio_button37673.cljs$core$IFn$_invoke$arity$2 = (function (group,checked_QMARK_){
return sablono.core.radio_button37673.cljs$core$IFn$_invoke$arity$3(group,checked_QMARK_,"true");
});

sablono.core.radio_button37673.cljs$core$IFn$_invoke$arity$3 = (function (group,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$input,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$type,"radio",cljs.core.cst$kw$name,sablono.core.make_name(group),cljs.core.cst$kw$id,sablono.core.make_id([cljs.core.str(sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([group], 0))),cljs.core.str("-"),cljs.core.str(sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([value], 0)))].join('')),cljs.core.cst$kw$value,value,cljs.core.cst$kw$checked,checked_QMARK_], null)], null);
});

sablono.core.radio_button37673.cljs$lang$maxFixedArity = 3;


sablono.core.radio_button = sablono.core.wrap_attrs(sablono.core.radio_button37673);
/**
 * Creates a seq of option tags from a collection.
 */
sablono.core.select_options37681 = (function sablono$core$select_options37681(var_args){
var args37682 = [];
var len__7484__auto___37703 = arguments.length;
var i__7485__auto___37704 = (0);
while(true){
if((i__7485__auto___37704 < len__7484__auto___37703)){
args37682.push((arguments[i__7485__auto___37704]));

var G__37705 = (i__7485__auto___37704 + (1));
i__7485__auto___37704 = G__37705;
continue;
} else {
}
break;
}

var G__37684 = args37682.length;
switch (G__37684) {
case 1:
return sablono.core.select_options37681.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.select_options37681.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37682.length)].join('')));

}
});

sablono.core.select_options37681.cljs$core$IFn$_invoke$arity$1 = (function (coll){
return sablono.core.select_options37681.cljs$core$IFn$_invoke$arity$2(coll,null);
});

sablono.core.select_options37681.cljs$core$IFn$_invoke$arity$2 = (function (coll,selected){
var iter__7189__auto__ = (function sablono$core$iter__37685(s__37686){
return (new cljs.core.LazySeq(null,(function (){
var s__37686__$1 = s__37686;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__37686__$1);
if(temp__4657__auto__){
var s__37686__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__37686__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__37686__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__37688 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__37687 = (0);
while(true){
if((i__37687 < size__7188__auto__)){
var x = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__37687);
cljs.core.chunk_append(b__37688,((cljs.core.sequential_QMARK_(x))?(function (){var vec__37697 = x;
var text = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37697,(0),null);
var val = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37697,(1),null);
var disabled_QMARK_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37697,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$(disabled_QMARK_);
if(cljs.core.sequential_QMARK_(val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$optgroup,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$label,text], null),sablono.core.select_options37681.cljs$core$IFn$_invoke$arity$2(val,selected)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$option,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$value,val,cljs.core.cst$kw$selected,cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(val,selected),cljs.core.cst$kw$disabled,disabled_QMARK___$1], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$option,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$selected,cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,selected)], null),x], null)));

var G__37707 = (i__37687 + (1));
i__37687 = G__37707;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__37688),sablono$core$iter__37685(cljs.core.chunk_rest(s__37686__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__37688),null);
}
} else {
var x = cljs.core.first(s__37686__$2);
return cljs.core.cons(((cljs.core.sequential_QMARK_(x))?(function (){var vec__37700 = x;
var text = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37700,(0),null);
var val = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37700,(1),null);
var disabled_QMARK_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37700,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$(disabled_QMARK_);
if(cljs.core.sequential_QMARK_(val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$optgroup,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$label,text], null),sablono.core.select_options37681.cljs$core$IFn$_invoke$arity$2(val,selected)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$option,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$value,val,cljs.core.cst$kw$selected,cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(val,selected),cljs.core.cst$kw$disabled,disabled_QMARK___$1], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$option,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$selected,cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,selected)], null),x], null)),sablono$core$iter__37685(cljs.core.rest(s__37686__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__(coll);
});

sablono.core.select_options37681.cljs$lang$maxFixedArity = 2;


sablono.core.select_options = sablono.core.wrap_attrs(sablono.core.select_options37681);
/**
 * Creates a drop-down box using the <select> tag.
 */
sablono.core.drop_down37708 = (function sablono$core$drop_down37708(var_args){
var args37709 = [];
var len__7484__auto___37712 = arguments.length;
var i__7485__auto___37713 = (0);
while(true){
if((i__7485__auto___37713 < len__7484__auto___37712)){
args37709.push((arguments[i__7485__auto___37713]));

var G__37714 = (i__7485__auto___37713 + (1));
i__7485__auto___37713 = G__37714;
continue;
} else {
}
break;
}

var G__37711 = args37709.length;
switch (G__37711) {
case 2:
return sablono.core.drop_down37708.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.drop_down37708.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37709.length)].join('')));

}
});

sablono.core.drop_down37708.cljs$core$IFn$_invoke$arity$2 = (function (name,options){
return sablono.core.drop_down37708.cljs$core$IFn$_invoke$arity$3(name,options,null);
});

sablono.core.drop_down37708.cljs$core$IFn$_invoke$arity$3 = (function (name,options,selected){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$name,sablono.core.make_name(name),cljs.core.cst$kw$id,sablono.core.make_id(name)], null),(sablono.core.select_options.cljs$core$IFn$_invoke$arity$2 ? sablono.core.select_options.cljs$core$IFn$_invoke$arity$2(options,selected) : sablono.core.select_options.call(null,options,selected))], null);
});

sablono.core.drop_down37708.cljs$lang$maxFixedArity = 3;


sablono.core.drop_down = sablono.core.wrap_attrs(sablono.core.drop_down37708);
/**
 * Creates a text area element.
 */
sablono.core.text_area37716 = (function sablono$core$text_area37716(var_args){
var args37717 = [];
var len__7484__auto___37720 = arguments.length;
var i__7485__auto___37721 = (0);
while(true){
if((i__7485__auto___37721 < len__7484__auto___37720)){
args37717.push((arguments[i__7485__auto___37721]));

var G__37722 = (i__7485__auto___37721 + (1));
i__7485__auto___37721 = G__37722;
continue;
} else {
}
break;
}

var G__37719 = args37717.length;
switch (G__37719) {
case 1:
return sablono.core.text_area37716.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_area37716.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37717.length)].join('')));

}
});

sablono.core.text_area37716.cljs$core$IFn$_invoke$arity$1 = (function (name){
return sablono.core.text_area37716.cljs$core$IFn$_invoke$arity$2(name,null);
});

sablono.core.text_area37716.cljs$core$IFn$_invoke$arity$2 = (function (name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$textarea,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$name,sablono.core.make_name(name),cljs.core.cst$kw$id,sablono.core.make_id(name),cljs.core.cst$kw$value,value], null)], null);
});

sablono.core.text_area37716.cljs$lang$maxFixedArity = 2;


sablono.core.text_area = sablono.core.wrap_attrs(sablono.core.text_area37716);
/**
 * Creates a label for an input field with the supplied name.
 */
sablono.core.label37724 = (function sablono$core$label37724(name,text){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$label,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$htmlFor,sablono.core.make_id(name)], null),text], null);
});

sablono.core.label = sablono.core.wrap_attrs(sablono.core.label37724);
/**
 * Creates a submit button.
 */
sablono.core.submit_button37725 = (function sablono$core$submit_button37725(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$input,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$type,"submit",cljs.core.cst$kw$value,text], null)], null);
});

sablono.core.submit_button = sablono.core.wrap_attrs(sablono.core.submit_button37725);
/**
 * Creates a form reset button.
 */
sablono.core.reset_button37726 = (function sablono$core$reset_button37726(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$input,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$type,"reset",cljs.core.cst$kw$value,text], null)], null);
});

sablono.core.reset_button = sablono.core.wrap_attrs(sablono.core.reset_button37726);
/**
 * Create a form that points to a particular method and route.
 *   e.g. (form-to [:put "/post"]
 *       ...)
 */
sablono.core.form_to37727 = (function sablono$core$form_to37727(var_args){
var args__7491__auto__ = [];
var len__7484__auto___37734 = arguments.length;
var i__7485__auto___37735 = (0);
while(true){
if((i__7485__auto___37735 < len__7484__auto___37734)){
args__7491__auto__.push((arguments[i__7485__auto___37735]));

var G__37736 = (i__7485__auto___37735 + (1));
i__7485__auto___37735 = G__37736;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return sablono.core.form_to37727.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

sablono.core.form_to37727.cljs$core$IFn$_invoke$arity$variadic = (function (p__37730,body){
var vec__37731 = p__37730;
var method = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37731,(0),null);
var action = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37731,(1),null);
var method_str = clojure.string.upper_case(cljs.core.name(method));
var action_uri = sablono.util.to_uri(action);
return cljs.core.vec(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(((cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$get,null,cljs.core.cst$kw$post,null], null), null),method))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$form,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$method,method_str,cljs.core.cst$kw$action,action_uri], null)], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$form,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$method,"POST",cljs.core.cst$kw$action,action_uri], null),(sablono.core.hidden_field.cljs$core$IFn$_invoke$arity$2 ? sablono.core.hidden_field.cljs$core$IFn$_invoke$arity$2("_method",method_str) : sablono.core.hidden_field.call(null,"_method",method_str))], null)),body));
});

sablono.core.form_to37727.cljs$lang$maxFixedArity = (1);

sablono.core.form_to37727.cljs$lang$applyTo = (function (seq37728){
var G__37729 = cljs.core.first(seq37728);
var seq37728__$1 = cljs.core.next(seq37728);
return sablono.core.form_to37727.cljs$core$IFn$_invoke$arity$variadic(G__37729,seq37728__$1);
});


sablono.core.form_to = sablono.core.wrap_attrs(sablono.core.form_to37727);
