// Compiled by ClojureScript 1.9.229 {}
goog.provide('cljs_time.coerce');
goog.require('cljs.core');
goog.require('cljs_time.core');
goog.require('cljs_time.format');
goog.require('goog.date.UtcDateTime');

/**
 * @interface
 */
cljs_time.coerce.ICoerce = function(){};

/**
 * Convert `obj` to a goog.date.DateTime instance.
 */
cljs_time.coerce.to_date_time = (function cljs_time$coerce$to_date_time(obj){
if((!((obj == null))) && (!((obj.cljs_time$coerce$ICoerce$to_date_time$arity$1 == null)))){
return obj.cljs_time$coerce$ICoerce$to_date_time$arity$1(obj);
} else {
var x__7072__auto__ = (((obj == null))?null:obj);
var m__7073__auto__ = (cljs_time.coerce.to_date_time[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return m__7073__auto__.call(null,obj);
} else {
var m__7073__auto____$1 = (cljs_time.coerce.to_date_time["_"]);
if(!((m__7073__auto____$1 == null))){
return m__7073__auto____$1.call(null,obj);
} else {
throw cljs.core.missing_protocol.call(null,"ICoerce.to-date-time",obj);
}
}
}
});

/**
 * Returns a DateTime instance in the UTC time zone corresponding to the given
 *   number of milliseconds after the Unix epoch.
 */
cljs_time.coerce.from_long = (function cljs_time$coerce$from_long(millis){
var G__21313 = millis;
if((G__21313 == null)){
return null;
} else {
return goog.date.UtcDateTime.fromTimestamp.call(null,G__21313);
}
});
/**
 * Returns DateTime instance from string using formatters in cljs-time.format,
 *   returning first which parses
 */
cljs_time.coerce.from_string = (function cljs_time$coerce$from_string(s){
if(cljs.core.truth_(s)){
return cljs.core.first.call(null,(function (){var iter__7189__auto__ = (function cljs_time$coerce$from_string_$_iter__21322(s__21323){
return (new cljs.core.LazySeq(null,(function (){
var s__21323__$1 = s__21323;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__21323__$1);
if(temp__4657__auto__){
var s__21323__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__21323__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__21323__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__21325 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__21324 = (0);
while(true){
if((i__21324 < size__7188__auto__)){
var f = cljs.core._nth.call(null,c__7187__auto__,i__21324);
var d = (function (){try{return cljs_time.format.parse.call(null,f,s);
}catch (e21328){if((e21328 instanceof Error)){
var _ = e21328;
return null;
} else {
throw e21328;

}
}})();
if(cljs.core.truth_(d)){
cljs.core.chunk_append.call(null,b__21325,d);

var G__21330 = (i__21324 + (1));
i__21324 = G__21330;
continue;
} else {
var G__21331 = (i__21324 + (1));
i__21324 = G__21331;
continue;
}
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__21325),cljs_time$coerce$from_string_$_iter__21322.call(null,cljs.core.chunk_rest.call(null,s__21323__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__21325),null);
}
} else {
var f = cljs.core.first.call(null,s__21323__$2);
var d = (function (){try{return cljs_time.format.parse.call(null,f,s);
}catch (e21329){if((e21329 instanceof Error)){
var _ = e21329;
return null;
} else {
throw e21329;

}
}})();
if(cljs.core.truth_(d)){
return cljs.core.cons.call(null,d,cljs_time$coerce$from_string_$_iter__21322.call(null,cljs.core.rest.call(null,s__21323__$2)));
} else {
var G__21332 = cljs.core.rest.call(null,s__21323__$2);
s__21323__$1 = G__21332;
continue;
}
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__.call(null,cljs.core.vals.call(null,cljs_time.format.formatters));
})());
} else {
return null;
}
});
/**
 * Returns a DateTime instance in the UTC time zone corresponding to the given
 *   js Date object.
 */
cljs_time.coerce.from_date = (function cljs_time$coerce$from_date(date){
var G__21334 = date;
var G__21334__$1 = (((G__21334 == null))?null:G__21334.getTime());
if((G__21334__$1 == null)){
return null;
} else {
return cljs_time.coerce.from_long.call(null,G__21334__$1);
}
});
/**
 * Convert `obj` to the number of milliseconds after the Unix epoch.
 */
cljs_time.coerce.to_long = (function cljs_time$coerce$to_long(obj){
var G__21336 = obj;
var G__21336__$1 = (((G__21336 == null))?null:cljs_time.coerce.to_date_time.call(null,G__21336));
if((G__21336__$1 == null)){
return null;
} else {
return G__21336__$1.getTime();
}
});
/**
 * Convert `obj` to Unix epoch.
 */
cljs_time.coerce.to_epoch = (function cljs_time$coerce$to_epoch(obj){
var G__21338 = obj;
var G__21338__$1 = (((G__21338 == null))?null:cljs_time.coerce.to_long.call(null,G__21338));
if((G__21338__$1 == null)){
return null;
} else {
return (G__21338__$1 / (1000));
}
});
/**
 * Convert `obj` to a JavaScript Date instance.
 */
cljs_time.coerce.to_date = (function cljs_time$coerce$to_date(obj){
var G__21340 = obj;
var G__21340__$1 = (((G__21340 == null))?null:cljs_time.coerce.to_date_time.call(null,G__21340));
var G__21340__$2 = (((G__21340__$1 == null))?null:G__21340__$1.getTime());
if((G__21340__$2 == null)){
return null;
} else {
return (new Date(G__21340__$2));
}
});
/**
 * Returns a string representation of obj in UTC time-zone
 *   using "yyyy-MM-dd'T'HH:mm:ss.SSSZZ" date-time representation.
 */
cljs_time.coerce.to_string = (function cljs_time$coerce$to_string(obj){
var G__21342 = obj;
var G__21342__$1 = (((G__21342 == null))?null:cljs_time.coerce.to_date_time.call(null,G__21342));
if((G__21342__$1 == null)){
return null;
} else {
return cljs_time.format.unparse.call(null,new cljs.core.Keyword(null,"date-time","date-time",177938180).cljs$core$IFn$_invoke$arity$1(cljs_time.format.formatters),G__21342__$1);
}
});
/**
 * Convert `obj` to a goog.date.Date instance
 */
cljs_time.coerce.to_local_date = (function cljs_time$coerce$to_local_date(obj){
if(cljs.core.truth_(obj)){
var temp__4655__auto__ = cljs_time.coerce.to_date_time.call(null,obj);
if(cljs.core.truth_(temp__4655__auto__)){
var dt = temp__4655__auto__;
return (new goog.date.Date(dt.getYear(),dt.getMonth(),dt.getDate()));
} else {
return null;
}
} else {
return null;
}
});
/**
 * Convert `obj` to a goog.date.DateTime instance
 */
cljs_time.coerce.to_local_date_time = (function cljs_time$coerce$to_local_date_time(obj){
if(cljs.core.truth_(obj)){
var temp__4655__auto__ = cljs_time.coerce.to_date_time.call(null,obj);
if(cljs.core.truth_(temp__4655__auto__)){
var dt = temp__4655__auto__;
var G__21344 = (new goog.date.DateTime(dt.getYear(),dt.getMonth(),dt.getDate()));
G__21344.setHours(dt.getHours());

G__21344.setMinutes(dt.getMinutes());

G__21344.setSeconds(dt.getSeconds());

G__21344.setMilliseconds(dt.getMilliseconds());

return G__21344;
} else {
return null;
}
} else {
return null;
}
});
(cljs_time.coerce.ICoerce["null"] = true);

(cljs_time.coerce.to_date_time["null"] = (function (_){
return null;
}));

Date.prototype.cljs_time$coerce$ICoerce$ = true;

Date.prototype.cljs_time$coerce$ICoerce$to_date_time$arity$1 = (function (date){
var date__$1 = this;
return cljs_time.coerce.from_date.call(null,date__$1);
});

goog.date.Date.prototype.cljs_time$coerce$ICoerce$ = true;

goog.date.Date.prototype.cljs_time$coerce$ICoerce$to_date_time$arity$1 = (function (local_date){
var local_date__$1 = this;
if(cljs.core.truth_(local_date__$1)){
var G__21345 = (new goog.date.UtcDateTime());
G__21345.set(local_date__$1);

return G__21345;
} else {
return null;
}
});

goog.date.DateTime.prototype.cljs_time$coerce$ICoerce$ = true;

goog.date.DateTime.prototype.cljs_time$coerce$ICoerce$to_date_time$arity$1 = (function (local_date_time){
var local_date_time__$1 = this;
if(cljs.core.truth_(local_date_time__$1)){
var G__21346 = (new goog.date.UtcDateTime());
G__21346.setTime(local_date_time__$1.getTime());

return G__21346;
} else {
return null;
}
});

goog.date.UtcDateTime.prototype.cljs_time$coerce$ICoerce$ = true;

goog.date.UtcDateTime.prototype.cljs_time$coerce$ICoerce$to_date_time$arity$1 = (function (date_time){
var date_time__$1 = this;
return date_time__$1;
});

(cljs_time.coerce.ICoerce["number"] = true);

(cljs_time.coerce.to_date_time["number"] = (function (long$){
return cljs_time.coerce.from_long.call(null,long$);
}));

(cljs_time.coerce.ICoerce["string"] = true);

(cljs_time.coerce.to_date_time["string"] = (function (string){
return cljs_time.coerce.from_string.call(null,string);
}));
