// Compiled by ClojureScript 1.9.229 {}
goog.provide('hatti.ona.stream');
goog.require('cljs.core');
goog.require('cljs.core.async');
hatti.ona.stream.small_delay = (10);
/**
 * Calls callback on aggregated data that come via messages in channel.
 * Callback accepts two arguments: data (cljs list), and completed? (bool)
 *   If there is a parser in message, resume it after a timeout.
 */
hatti.ona.stream.process_aggregated_data_BANG_ = (function hatti$ona$stream$process_aggregated_data_BANG_(agg_data_channel,callback){
var c__12139__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__12139__auto__){
return (function (){
var f__12140__auto__ = (function (){var switch__12027__auto__ = ((function (c__12139__auto__){
return (function (state_22238){
var state_val_22239 = (state_22238[(1)]);
if((state_val_22239 === (7))){
var inst_22195 = (state_22238[(7)]);
var inst_22195__$1 = (state_22238[(2)]);
var inst_22197 = (inst_22195__$1 == null);
var inst_22198 = cljs.core.not.call(null,inst_22197);
var state_22238__$1 = (function (){var statearr_22240 = state_22238;
(statearr_22240[(7)] = inst_22195__$1);

return statearr_22240;
})();
if(inst_22198){
var statearr_22241_22278 = state_22238__$1;
(statearr_22241_22278[(1)] = (8));

} else {
var statearr_22242_22279 = state_22238__$1;
(statearr_22242_22279[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22239 === (20))){
var inst_22217 = (state_22238[(8)]);
var inst_22225 = (state_22238[(2)]);
var state_22238__$1 = (function (){var statearr_22243 = state_22238;
(statearr_22243[(9)] = inst_22225);

return statearr_22243;
})();
if(cljs.core.truth_(inst_22217)){
var statearr_22244_22280 = state_22238__$1;
(statearr_22244_22280[(1)] = (21));

} else {
var statearr_22245_22281 = state_22238__$1;
(statearr_22245_22281[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22239 === (1))){
var state_22238__$1 = state_22238;
var statearr_22246_22282 = state_22238__$1;
(statearr_22246_22282[(2)] = null);

(statearr_22246_22282[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22239 === (4))){
var state_22238__$1 = state_22238;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22238__$1,(7),agg_data_channel);
} else {
if((state_val_22239 === (15))){
var inst_22195 = (state_22238[(7)]);
var state_22238__$1 = state_22238;
var statearr_22247_22283 = state_22238__$1;
(statearr_22247_22283[(2)] = inst_22195);

(statearr_22247_22283[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22239 === (21))){
var inst_22227 = cljs.core.async.close_BANG_.call(null,agg_data_channel);
var state_22238__$1 = state_22238;
var statearr_22248_22284 = state_22238__$1;
(statearr_22248_22284[(2)] = inst_22227);

(statearr_22248_22284[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22239 === (13))){
var inst_22207 = (state_22238[(2)]);
var state_22238__$1 = state_22238;
var statearr_22249_22285 = state_22238__$1;
(statearr_22249_22285[(2)] = inst_22207);

(statearr_22249_22285[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22239 === (22))){
var state_22238__$1 = state_22238;
var statearr_22250_22286 = state_22238__$1;
(statearr_22250_22286[(2)] = null);

(statearr_22250_22286[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22239 === (6))){
var inst_22234 = (state_22238[(2)]);
var state_22238__$1 = state_22238;
var statearr_22251_22287 = state_22238__$1;
(statearr_22251_22287[(2)] = inst_22234);

(statearr_22251_22287[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22239 === (17))){
var inst_22216 = (state_22238[(10)]);
var inst_22217 = (state_22238[(8)]);
var inst_22219 = callback.call(null,inst_22216,inst_22217);
var state_22238__$1 = state_22238;
var statearr_22252_22288 = state_22238__$1;
(statearr_22252_22288[(2)] = inst_22219);

(statearr_22252_22288[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22239 === (3))){
var inst_22236 = (state_22238[(2)]);
var state_22238__$1 = state_22238;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22238__$1,inst_22236);
} else {
if((state_val_22239 === (12))){
var state_22238__$1 = state_22238;
var statearr_22253_22289 = state_22238__$1;
(statearr_22253_22289[(2)] = false);

(statearr_22253_22289[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22239 === (2))){
var state_22238__$1 = state_22238;
var statearr_22254_22290 = state_22238__$1;
(statearr_22254_22290[(1)] = (4));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22239 === (23))){
var inst_22230 = (state_22238[(2)]);
var state_22238__$1 = (function (){var statearr_22256 = state_22238;
(statearr_22256[(11)] = inst_22230);

return statearr_22256;
})();
var statearr_22257_22291 = state_22238__$1;
(statearr_22257_22291[(2)] = null);

(statearr_22257_22291[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22239 === (19))){
var inst_22222 = (state_22238[(2)]);
var inst_22223 = cljs.core.async.timeout.call(null,hatti.ona.stream.small_delay);
var state_22238__$1 = (function (){var statearr_22258 = state_22238;
(statearr_22258[(12)] = inst_22222);

return statearr_22258;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22238__$1,(20),inst_22223);
} else {
if((state_val_22239 === (11))){
var state_22238__$1 = state_22238;
var statearr_22259_22292 = state_22238__$1;
(statearr_22259_22292[(2)] = true);

(statearr_22259_22292[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22239 === (9))){
var state_22238__$1 = state_22238;
var statearr_22260_22293 = state_22238__$1;
(statearr_22260_22293[(2)] = false);

(statearr_22260_22293[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22239 === (5))){
var state_22238__$1 = state_22238;
var statearr_22261_22294 = state_22238__$1;
(statearr_22261_22294[(2)] = null);

(statearr_22261_22294[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22239 === (14))){
var inst_22195 = (state_22238[(7)]);
var inst_22212 = cljs.core.apply.call(null,cljs.core.hash_map,inst_22195);
var state_22238__$1 = state_22238;
var statearr_22262_22295 = state_22238__$1;
(statearr_22262_22295[(2)] = inst_22212);

(statearr_22262_22295[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22239 === (16))){
var inst_22216 = (state_22238[(10)]);
var inst_22215 = (state_22238[(2)]);
var inst_22216__$1 = cljs.core.get.call(null,inst_22215,new cljs.core.Keyword(null,"data","data",-232669377));
var inst_22217 = cljs.core.get.call(null,inst_22215,new cljs.core.Keyword(null,"completed?","completed?",946828354));
var state_22238__$1 = (function (){var statearr_22263 = state_22238;
(statearr_22263[(10)] = inst_22216__$1);

(statearr_22263[(8)] = inst_22217);

return statearr_22263;
})();
if(cljs.core.truth_(inst_22216__$1)){
var statearr_22264_22296 = state_22238__$1;
(statearr_22264_22296[(1)] = (17));

} else {
var statearr_22265_22297 = state_22238__$1;
(statearr_22265_22297[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22239 === (10))){
var inst_22210 = (state_22238[(2)]);
var state_22238__$1 = state_22238;
if(cljs.core.truth_(inst_22210)){
var statearr_22266_22298 = state_22238__$1;
(statearr_22266_22298[(1)] = (14));

} else {
var statearr_22267_22299 = state_22238__$1;
(statearr_22267_22299[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22239 === (18))){
var state_22238__$1 = state_22238;
var statearr_22268_22300 = state_22238__$1;
(statearr_22268_22300[(2)] = null);

(statearr_22268_22300[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22239 === (8))){
var inst_22195 = (state_22238[(7)]);
var inst_22200 = inst_22195.cljs$lang$protocol_mask$partition0$;
var inst_22201 = (inst_22200 & (64));
var inst_22202 = inst_22195.cljs$core$ISeq$;
var inst_22203 = (inst_22201) || (inst_22202);
var state_22238__$1 = state_22238;
if(cljs.core.truth_(inst_22203)){
var statearr_22269_22301 = state_22238__$1;
(statearr_22269_22301[(1)] = (11));

} else {
var statearr_22270_22302 = state_22238__$1;
(statearr_22270_22302[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12139__auto__))
;
return ((function (switch__12027__auto__,c__12139__auto__){
return (function() {
var hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__12028__auto__ = null;
var hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__12028__auto____0 = (function (){
var statearr_22274 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_22274[(0)] = hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__12028__auto__);

(statearr_22274[(1)] = (1));

return statearr_22274;
});
var hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__12028__auto____1 = (function (state_22238){
while(true){
var ret_value__12029__auto__ = (function (){try{while(true){
var result__12030__auto__ = switch__12027__auto__.call(null,state_22238);
if(cljs.core.keyword_identical_QMARK_.call(null,result__12030__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12030__auto__;
}
break;
}
}catch (e22275){if((e22275 instanceof Object)){
var ex__12031__auto__ = e22275;
var statearr_22276_22303 = state_22238;
(statearr_22276_22303[(5)] = ex__12031__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_22238);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e22275;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__12029__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22304 = state_22238;
state_22238 = G__22304;
continue;
} else {
return ret_value__12029__auto__;
}
break;
}
});
hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__12028__auto__ = function(state_22238){
switch(arguments.length){
case 0:
return hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__12028__auto____0.call(this);
case 1:
return hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__12028__auto____1.call(this,state_22238);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__12028__auto____0;
hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__12028__auto____1;
return hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__12028__auto__;
})()
;})(switch__12027__auto__,c__12139__auto__))
})();
var state__12141__auto__ = (function (){var statearr_22277 = f__12140__auto__.call(null);
(statearr_22277[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12139__auto__);

return statearr_22277;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__12141__auto__);
});})(c__12139__auto__))
);

return c__12139__auto__;
});
/**
 * On each step of data, increment read-count atom, and put data in a list agg.
 * After a exponentially increasing # of steps have been processed,
 * the aggregated data gets flushed into a channel, and parser is paused.
 * The channel reader should resume the parser after processing the data.
 */
hatti.ona.stream.read_next_chunk_BANG_ = (function hatti$ona$stream$read_next_chunk_BANG_(data_chunk,read_count,agg,channel){
cljs.core.swap_BANG_.call(null,read_count,cljs.core.inc);

cljs.core.swap_BANG_.call(null,agg,cljs.core.conj,data_chunk);

if(((cljs.core.deref.call(null,read_count) >= (100))) && (cljs.core.integer_QMARK_.call(null,Math.log10(cljs.core.deref.call(null,read_count))))){
cljs.core.async.put_BANG_.call(null,channel,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"data","data",-232669377),cljs.core.deref.call(null,agg)], null));

cljs.core.reset_BANG_.call(null,agg,cljs.core.PersistentVector.EMPTY);

return oboe.drop();
} else {
return null;
}
});
/**
 * Given url, a node pattern matcher, and a callback, streaming-read json.
 */
hatti.ona.stream.streamingly_read_json_BANG_ = (function hatti$ona$stream$streamingly_read_json_BANG_(var_args){
var args__7491__auto__ = [];
var len__7484__auto___22311 = arguments.length;
var i__7485__auto___22312 = (0);
while(true){
if((i__7485__auto___22312 < len__7484__auto___22311)){
args__7491__auto__.push((arguments[i__7485__auto___22312]));

var G__22313 = (i__7485__auto___22312 + (1));
i__7485__auto___22312 = G__22313;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((2) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((2)),(0),null)):null);
return hatti.ona.stream.streamingly_read_json_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7492__auto__);
});

hatti.ona.stream.streamingly_read_json_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (url,stepfn,p__22308){
var map__22309 = p__22308;
var map__22309__$1 = ((((!((map__22309 == null)))?((((map__22309.cljs$lang$protocol_mask$partition0$ & (64))) || (map__22309.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22309):map__22309);
var oboe_headers = cljs.core.get.call(null,map__22309__$1,new cljs.core.Keyword(null,"oboe-headers","oboe-headers",-764778163));
var read_count = cljs.core.atom.call(null,(0));
var agg = cljs.core.atom.call(null,cljs.core.PersistentVector.EMPTY);
var channel = cljs.core.async.chan.call(null);
var return_channel = cljs.core.async.chan.call(null);
var oboe_params = cljs.core.clj__GT_js.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"url","url",276297046),url,new cljs.core.Keyword(null,"headers","headers",-835030129),oboe_headers,new cljs.core.Keyword(null,"withCredentials","withCredentials",1719959454),true], null));
var step = ((function (read_count,agg,channel,return_channel,oboe_params,map__22309,map__22309__$1,oboe_headers){
return (function (line){
return hatti.ona.stream.read_next_chunk_BANG_.call(null,cljs.core.js__GT_clj.call(null,line),read_count,agg,channel);
});})(read_count,agg,channel,return_channel,oboe_params,map__22309,map__22309__$1,oboe_headers))
;
var done = ((function (read_count,agg,channel,return_channel,oboe_params,step,map__22309,map__22309__$1,oboe_headers){
return (function (){
cljs.core.async.put_BANG_.call(null,channel,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"data","data",-232669377),cljs.core.deref.call(null,agg),new cljs.core.Keyword(null,"completed?","completed?",946828354),true], null));

return cljs.core.async.close_BANG_.call(null,return_channel);
});})(read_count,agg,channel,return_channel,oboe_params,step,map__22309,map__22309__$1,oboe_headers))
;
hatti.ona.stream.process_aggregated_data_BANG_.call(null,channel,stepfn);

window.oboe(oboe_params).node("!.*",step).done(done);

return return_channel;
});

hatti.ona.stream.streamingly_read_json_BANG_.cljs$lang$maxFixedArity = (2);

hatti.ona.stream.streamingly_read_json_BANG_.cljs$lang$applyTo = (function (seq22305){
var G__22306 = cljs.core.first.call(null,seq22305);
var seq22305__$1 = cljs.core.next.call(null,seq22305);
var G__22307 = cljs.core.first.call(null,seq22305__$1);
var seq22305__$2 = cljs.core.next.call(null,seq22305__$1);
return hatti.ona.stream.streamingly_read_json_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__22306,G__22307,seq22305__$2);
});

