// Compiled by ClojureScript 1.9.229 {}
goog.provide('hatti.utils');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('goog.string.format');
goog.require('goog.string');
goog.require('inflections.core');
goog.require('sablono.core');
/**
 * Convert json to js using JSON.parse
 */
hatti.utils.json__GT_js = (function hatti$utils$json__GT_js(s){
return JSON.parse(s);
});
/**
 * Given a seq, produces a two-el seq. [a b c] => [[0 a] [1 b] [2 c]].
 */
hatti.utils.indexed = (function hatti$utils$indexed(coll){
return cljs.core.map_indexed.call(null,cljs.core.vector,coll);
});
/**
 * Helper function to create a click function that prevents default
 */
hatti.utils.click_fn = (function hatti$utils$click_fn(f){
return (function (event){
event.preventDefault();

return f.call(null);
});
});
/**
 * Create an appropriately pluralized string prefix by number.
 */
hatti.utils.pluralize_number = (function hatti$utils$pluralize_number(number,kind){
return clojure.string.join.call(null," ",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [number,((cljs.core._EQ_.call(null,(1),number))?kind:inflections.core.plural.call(null,kind))], null));
});
/**
 * True if substring is a substring of string
 */
hatti.utils.substring_QMARK_ = (function hatti$utils$substring_QMARK_(var_args){
var args20033 = [];
var len__7484__auto___20042 = arguments.length;
var i__7485__auto___20043 = (0);
while(true){
if((i__7485__auto___20043 < len__7484__auto___20042)){
args20033.push((arguments[i__7485__auto___20043]));

var G__20044 = (i__7485__auto___20043 + (1));
i__7485__auto___20043 = G__20044;
continue;
} else {
}
break;
}

var G__20038 = args20033.length;
switch (G__20038) {
case 2:
return hatti.utils.substring_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__7503__auto__ = (new cljs.core.IndexedSeq(args20033.slice((2)),(0),null));
return hatti.utils.substring_QMARK_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7503__auto__);

}
});

hatti.utils.substring_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (substring,string){
return cljs.core.complement.call(null,cljs.core.nil_QMARK_).call(null,cljs.core.re_find.call(null,cljs.core.re_pattern.call(null,substring),string));
});

hatti.utils.substring_QMARK_.cljs$core$IFn$_invoke$arity$variadic = (function (substring,string,p__20039){
var map__20040 = p__20039;
var map__20040__$1 = ((((!((map__20040 == null)))?((((map__20040.cljs$lang$protocol_mask$partition0$ & (64))) || (map__20040.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__20040):map__20040);
var case_sensitive_QMARK_ = cljs.core.get.call(null,map__20040__$1,new cljs.core.Keyword(null,"case-sensitive?","case-sensitive?",-2133754107));
if(cljs.core.truth_(case_sensitive_QMARK_)){
return hatti.utils.substring_QMARK_.call(null,substring,string);
} else {
return hatti.utils.substring_QMARK_.call(null,clojure.string.lower_case.call(null,substring),clojure.string.lower_case.call(null,string));
}
});

hatti.utils.substring_QMARK_.cljs$lang$applyTo = (function (seq20034){
var G__20035 = cljs.core.first.call(null,seq20034);
var seq20034__$1 = cljs.core.next.call(null,seq20034);
var G__20036 = cljs.core.first.call(null,seq20034__$1);
var seq20034__$2 = cljs.core.next.call(null,seq20034__$1);
return hatti.utils.substring_QMARK_.cljs$core$IFn$_invoke$arity$variadic(G__20035,G__20036,seq20034__$2);
});

hatti.utils.substring_QMARK_.cljs$lang$maxFixedArity = (2);

hatti.utils.hyphen__GT_camel_case = (function hatti$utils$hyphen__GT_camel_case(source_string){
return clojure.string.replace.call(null,source_string,/(-)(.)/,(function (p1__20046_SHARP_){
var vec__20050 = p1__20046_SHARP_;
var _ = cljs.core.nth.call(null,vec__20050,(0),null);
var ___$1 = cljs.core.nth.call(null,vec__20050,(1),null);
var letter_to_uppercase = cljs.core.nth.call(null,vec__20050,(2),null);
return clojure.string.upper_case.call(null,letter_to_uppercase);
}));
});
hatti.utils.generate_component = (function hatti$utils$generate_component(element_definition_vector){
return sablono.interpreter.interpret.call(null,element_definition_vector);
});
/**
 * This function generates HTML from hiccup-style vectors, and concatenates
 *   the resulting markup. Strings are returned unaffected.
 */
hatti.utils.generate_html = (function hatti$utils$generate_html(var_args){
var args__7491__auto__ = [];
var len__7484__auto___20054 = arguments.length;
var i__7485__auto___20055 = (0);
while(true){
if((i__7485__auto___20055 < len__7484__auto___20054)){
args__7491__auto__.push((arguments[i__7485__auto___20055]));

var G__20056 = (i__7485__auto___20055 + (1));
i__7485__auto___20055 = G__20056;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((0) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((0)),(0),null)):null);
return hatti.utils.generate_html.cljs$core$IFn$_invoke$arity$variadic(argseq__7492__auto__);
});

hatti.utils.generate_html.cljs$core$IFn$_invoke$arity$variadic = (function (element_definition_vectors){
var components = cljs.core.map.call(null,hatti.utils.generate_component,element_definition_vectors);
var components_as_static_markup = cljs.core.map.call(null,((function (components){
return (function (component){
if(typeof component === 'string'){
return component;
} else {
return sablono.core.render_static.call(null,component);
}
});})(components))
,components);
return clojure.string.join.call(null,components_as_static_markup);
});

hatti.utils.generate_html.cljs$lang$maxFixedArity = (0);

hatti.utils.generate_html.cljs$lang$applyTo = (function (seq20053){
return hatti.utils.generate_html.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq20053));
});

