// Compiled by ClojureScript 1.9.229 {}
goog.provide('hatti.views.table');
goog.require('cljs.core');
goog.require('hatti.views.record');
goog.require('chimera.js_interop');
goog.require('om.dom');
goog.require('hatti.ona.forms');
goog.require('sablono.core');
goog.require('cljs.core.async');
goog.require('chimera.seq');
goog.require('hatti.shared');
goog.require('hatti.constants');
goog.require('hatti.views');
goog.require('om.core');
goog.require('hatti.utils');
goog.require('chimera.core');
goog.require('chimera.urls');
hatti.views.table.default_num_displayed_records = (25);
hatti.views.table.table_id = "submission-grid";
hatti.views.table.pager_id = "pager";
/**
 * Extra fields that will be displayed on the table.
 */
hatti.views.table.get_extra_fields = (function hatti$views$table$get_extra_fields(is_filtered_dataview_QMARK_){
var id_field = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"full-name","full-name",408178550),hatti.constants._id,new cljs.core.Keyword(null,"label","label",1718410804),"ID",new cljs.core.Keyword(null,"name","name",1843675177),hatti.constants._id,new cljs.core.Keyword(null,"type","type",1174270348),"integer"], null)], null);
var G__25189 = id_field;
if(cljs.core.not.call(null,is_filtered_dataview_QMARK_)){
return cljs.core.conj.call(null,G__25189,hatti.ona.forms.submission_time_field);
} else {
return G__25189;
}
});
/**
 * Given a (flat-)form, returns fields for table display.
 * Puts extra fields in the beginning, metadata at the end of the table,
 * and drops fields that have no data (eg. group/note).
 */
hatti.views.table.all_fields = (function hatti$views$table$all_fields(var_args){
var args__7491__auto__ = [];
var len__7484__auto___25195 = arguments.length;
var i__7485__auto___25196 = (0);
while(true){
if((i__7485__auto___25196 < len__7484__auto___25195)){
args__7491__auto__.push((arguments[i__7485__auto___25196]));

var G__25197 = (i__7485__auto___25196 + (1));
i__7485__auto___25196 = G__25197;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return hatti.views.table.all_fields.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

hatti.views.table.all_fields.cljs$core$IFn$_invoke$arity$variadic = (function (form,p__25192){
var map__25193 = p__25192;
var map__25193__$1 = ((((!((map__25193 == null)))?((((map__25193.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25193.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25193):map__25193);
var is_filtered_dataview_QMARK_ = cljs.core.get.call(null,map__25193__$1,new cljs.core.Keyword(null,"is-filtered-dataview?","is-filtered-dataview?",456678746));
return cljs.core.distinct.call(null,cljs.core.filter.call(null,hatti.ona.forms.has_data_QMARK_,cljs.core.concat.call(null,hatti.views.table.get_extra_fields.call(null,is_filtered_dataview_QMARK_),hatti.ona.forms.non_meta_fields.call(null,form),hatti.ona.forms.meta_fields.call(null,form,new cljs.core.Keyword(null,"with-submission-details?","with-submission-details?",524960549),cljs.core.not.call(null,is_filtered_dataview_QMARK_)))));
});

hatti.views.table.all_fields.cljs$lang$maxFixedArity = (1);

hatti.views.table.all_fields.cljs$lang$applyTo = (function (seq25190){
var G__25191 = cljs.core.first.call(null,seq25190);
var seq25190__$1 = cljs.core.next.call(null,seq25190);
return hatti.views.table.all_fields.cljs$core$IFn$_invoke$arity$variadic(G__25191,seq25190__$1);
});

/**
 * Comparator function for the slickgrid dataview.
 * args.sortCol is the column being sorted, a and b are rows to compare.
 * Claims a is bigger (return 1) if value for a > b, or a is null / empty.
 */
hatti.views.table.compfn = (function hatti$views$table$compfn(args){
return (function (a,b){
var col = (args["sortCol"]);
var lower = ((function (col){
return (function (p1__25198_SHARP_){
if(typeof p1__25198_SHARP_ === 'string'){
return clojure.string.lower_case.call(null,p1__25198_SHARP_);
} else {
return p1__25198_SHARP_;
}
});})(col))
;
var aval = lower.call(null,(a[(col["field"])]));
var bval = lower.call(null,(b[(col["field"])]));
if(((aval == null)) || ((aval > bval))){
return (1);
} else {
return (-1);
}
});
});
/**
 * Filter function for the slickgrid dataview, use as (partial filterfn form)
 * item is the row, args contains query.
 * Return value of false corresponds with exclusion, true with inclusion.
 */
hatti.views.table.filterfn = (function hatti$views$table$filterfn(form,item,args){
if(cljs.core.not.call(null,args)){
return true;
} else {
var indexed_form = cljs.core.zipmap.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"full-name","full-name",408178550),form),form);
var query = (args["query"]);
var fmt_subitem = ((function (indexed_form,query){
return (function (p__25204){
var vec__25205 = p__25204;
var fname = cljs.core.nth.call(null,vec__25205,(0),null);
var answer = cljs.core.nth.call(null,vec__25205,(1),null);
return hatti.ona.forms.format_answer.call(null,cljs.core.get.call(null,indexed_form,fname),answer,new cljs.core.Keyword(null,"compact?","compact?",1216893298),true);
});})(indexed_form,query))
;
var filtered = cljs.core.remove.call(null,cljs.core.nil_QMARK_,cljs.core.map.call(null,((function (indexed_form,query,fmt_subitem){
return (function (p1__25199_SHARP_){
return cljs.core.re_find.call(null,chimera.js_interop.safe_regex.call(null,query),[cljs.core.str(p1__25199_SHARP_)].join(''));
});})(indexed_form,query,fmt_subitem))
,cljs.core.map.call(null,fmt_subitem,cljs.core.js__GT_clj.call(null,item))));
return cljs.core.seq.call(null,filtered);
}
});
/**
 * Formatter for slickgrid columns takes row,cell,value,columnDef,dataContext.
 * Get one with (partial formatter field language).
 */
hatti.views.table.formatter = (function hatti$views$table$formatter(field,language,row,cell,value,columnDef,dataContext){
var clj_value = cljs.core.js__GT_clj.call(null,value,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
return hatti.ona.forms.format_answer.call(null,field,clj_value,new cljs.core.Keyword(null,"language","language",-1591107564),language,new cljs.core.Keyword(null,"compact?","compact?",1216893298),true);
});
cljs.core._add_method.call(null,hatti.views.action_buttons,new cljs.core.Keyword(null,"default","default",-1987822328),(function (owner){
return (function (row,cell,value,columnDef,dataContext){
var map__25208 = new cljs.core.Keyword(null,"dataset-info","dataset-info",-1196999563).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,hatti.shared.app_state));
var map__25208__$1 = ((((!((map__25208 == null)))?((((map__25208.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25208.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25208):map__25208);
var owner__$1 = cljs.core.get.call(null,map__25208__$1,new cljs.core.Keyword(null,"owner","owner",-392611939));
var project = cljs.core.get.call(null,map__25208__$1,new cljs.core.Keyword(null,"project","project",1124394579));
var formid = cljs.core.get.call(null,map__25208__$1,new cljs.core.Keyword(null,"formid","formid",-2121398991));
var form_owner = chimera.urls.last_url_param.call(null,owner__$1);
var project_id = chimera.urls.last_url_param.call(null,project);
var edit_link = chimera.urls.url.call(null,form_owner,project_id,formid,[cljs.core.str("webform?instance-id="),cljs.core.str(value)].join(''));
return hatti.utils.generate_html.call(null,(cljs.core.truth_(value)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ul","ul",-1349521403),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li.tooltip.middle-right","li.tooltip.middle-right",-548323211),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span.tip-info","span.tip-info",147552832),"View"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a.view-record","a.view-record",235834372),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"i.fa.fa-clone","i.fa.fa-clone",1946695810),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"data-id","data-id",1023855591),value], null)], null)], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li.tooltip","li.tooltip",-1420587330),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span.tip-info","span.tip-info",147552832),"Edit"], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a.edit-record","a.edit-record",698797771),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"data-id","data-id",1023855591),value,new cljs.core.Keyword(null,"target","target",253001721),"_blank",new cljs.core.Keyword(null,"href","href",-793805698),edit_link], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"i.fa.fa-pencil-square-o","i.fa.fa-pencil-square-o",1550650091)], null)], null)], null)], null):null));
});
}));
/**
 * The html needed for a column name as a string.
 * String, String, Bool -> String
 */
hatti.views.table.column_name_html_string = (function hatti$views$table$column_name_html_string(column_class,label,hxl){
return [cljs.core.str("<div class=\""),cljs.core.str(column_class),cljs.core.str("\">"),cljs.core.str(label),cljs.core.str("</div>"),cljs.core.str((cljs.core.truth_(hxl)?[cljs.core.str("<div class=\"hxl-row\">"),cljs.core.str(hxl),cljs.core.str("</div>")].join(''):null))].join('');
});
hatti.views.table.actions_column = (function hatti$views$table$actions_column(owner,has_hxl_QMARK_){
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"headerCssClass","headerCssClass",-1721145883),new cljs.core.Keyword(null,"maxWidth","maxWidth",-1375124795),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"formatter","formatter",-483008823),new cljs.core.Keyword(null,"field","field",-1302436500),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"sortable","sortable",2109633621),new cljs.core.Keyword(null,"cssClass","cssClass",264048890),new cljs.core.Keyword(null,"toolTip","toolTip",-228608737)],[[cljs.core.str((cljs.core.truth_(has_hxl_QMARK_)?"hxl-min-height ":null)),cljs.core.str("record-actions header")].join(''),(70),"",hatti.views.action_buttons.call(null,owner),hatti.constants._id,"text","actions",false,"record-actions",""]);
});
/**
 * Get a set of slick grid column objects when given a flat form.
 */
hatti.views.table.flat_form__GT_sg_columns = (function hatti$views$table$flat_form__GT_sg_columns(var_args){
var args__7491__auto__ = [];
var len__7484__auto___25237 = arguments.length;
var i__7485__auto___25238 = (0);
while(true){
if((i__7485__auto___25238 < len__7484__auto___25237)){
args__7491__auto__.push((arguments[i__7485__auto___25238]));

var G__25239 = (i__7485__auto___25238 + (1));
i__7485__auto___25238 = G__25239;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic = (function (form,p__25213){
var map__25214 = p__25213;
var map__25214__$1 = ((((!((map__25214 == null)))?((((map__25214.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25214.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25214):map__25214);
var hide_actions_column_QMARK_ = cljs.core.get.call(null,map__25214__$1,new cljs.core.Keyword(null,"hide-actions-column?","hide-actions-column?",-30644754));
var is_filtered_dataview_QMARK_ = cljs.core.get.call(null,map__25214__$1,new cljs.core.Keyword(null,"is-filtered-dataview?","is-filtered-dataview?",456678746));
var get_label_QMARK_ = cljs.core.get.call(null,map__25214__$1,new cljs.core.Keyword(null,"get-label?","get-label?",617123530),true);
var language = cljs.core.get.call(null,map__25214__$1,new cljs.core.Keyword(null,"language","language",-1591107564));
var owner = cljs.core.get.call(null,map__25214__$1,new cljs.core.Keyword(null,"owner","owner",-392611939));
var has_hxl_QMARK_ = chimera.core.any_QMARK_.call(null,cljs.core.false_QMARK_,cljs.core.map.call(null,((function (map__25214,map__25214__$1,hide_actions_column_QMARK_,is_filtered_dataview_QMARK_,get_label_QMARK_,language,owner){
return (function (p1__25210_SHARP_){
return (new cljs.core.Keyword(null,"hxl","hxl",-849576989).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"instance","instance",-2121349050).cljs$core$IFn$_invoke$arity$1(p1__25210_SHARP_)) == null);
});})(map__25214,map__25214__$1,hide_actions_column_QMARK_,is_filtered_dataview_QMARK_,get_label_QMARK_,language,owner))
,form));
var columns = (function (){var iter__7189__auto__ = ((function (has_hxl_QMARK_,map__25214,map__25214__$1,hide_actions_column_QMARK_,is_filtered_dataview_QMARK_,get_label_QMARK_,language,owner){
return (function hatti$views$table$iter__25216(s__25217){
return (new cljs.core.LazySeq(null,((function (has_hxl_QMARK_,map__25214,map__25214__$1,hide_actions_column_QMARK_,is_filtered_dataview_QMARK_,get_label_QMARK_,language,owner){
return (function (){
var s__25217__$1 = s__25217;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__25217__$1);
if(temp__4657__auto__){
var s__25217__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__25217__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__25217__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__25219 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__25218 = (0);
while(true){
if((i__25218 < size__7188__auto__)){
var field = cljs.core._nth.call(null,c__7187__auto__,i__25218);
cljs.core.chunk_append.call(null,b__25219,(function (){var map__25228 = field;
var map__25228__$1 = ((((!((map__25228 == null)))?((((map__25228.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25228.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25228):map__25228);
var map__25229 = cljs.core.get.call(null,map__25228__$1,new cljs.core.Keyword(null,"instance","instance",-2121349050));
var map__25229__$1 = ((((!((map__25229 == null)))?((((map__25229.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25229.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25229):map__25229);
var hxl = cljs.core.get.call(null,map__25229__$1,new cljs.core.Keyword(null,"hxl","hxl",-849576989));
var name = cljs.core.get.call(null,map__25228__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var type = cljs.core.get.call(null,map__25228__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var full_name = cljs.core.get.call(null,map__25228__$1,new cljs.core.Keyword(null,"full-name","full-name",408178550));
var label = (cljs.core.truth_(get_label_QMARK_)?hatti.ona.forms.get_label.call(null,field,language):name);
var column_class = hatti.ona.forms.get_column_class.call(null,field);
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"hxl","hxl",-849576989),new cljs.core.Keyword(null,"headerCssClass","headerCssClass",-1721145883),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"formatter","formatter",-483008823),new cljs.core.Keyword(null,"minWidth","minWidth",-204293526),new cljs.core.Keyword(null,"field","field",-1302436500),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"sortable","sortable",2109633621),new cljs.core.Keyword(null,"cssClass","cssClass",264048890),new cljs.core.Keyword(null,"toolTip","toolTip",-228608737)],[hxl,(cljs.core.truth_(has_hxl_QMARK_)?"hxl-min-height":null),hatti.views.table.column_name_html_string.call(null,column_class,label,hxl),cljs.core.partial.call(null,hatti.views.table.formatter,field,language),(50),full_name,type,name,true,column_class,label]);
})());

var G__25240 = (i__25218 + (1));
i__25218 = G__25240;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__25219),hatti$views$table$iter__25216.call(null,cljs.core.chunk_rest.call(null,s__25217__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__25219),null);
}
} else {
var field = cljs.core.first.call(null,s__25217__$2);
return cljs.core.cons.call(null,(function (){var map__25232 = field;
var map__25232__$1 = ((((!((map__25232 == null)))?((((map__25232.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25232.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25232):map__25232);
var map__25233 = cljs.core.get.call(null,map__25232__$1,new cljs.core.Keyword(null,"instance","instance",-2121349050));
var map__25233__$1 = ((((!((map__25233 == null)))?((((map__25233.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25233.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25233):map__25233);
var hxl = cljs.core.get.call(null,map__25233__$1,new cljs.core.Keyword(null,"hxl","hxl",-849576989));
var name = cljs.core.get.call(null,map__25232__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var type = cljs.core.get.call(null,map__25232__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var full_name = cljs.core.get.call(null,map__25232__$1,new cljs.core.Keyword(null,"full-name","full-name",408178550));
var label = (cljs.core.truth_(get_label_QMARK_)?hatti.ona.forms.get_label.call(null,field,language):name);
var column_class = hatti.ona.forms.get_column_class.call(null,field);
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"hxl","hxl",-849576989),new cljs.core.Keyword(null,"headerCssClass","headerCssClass",-1721145883),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"formatter","formatter",-483008823),new cljs.core.Keyword(null,"minWidth","minWidth",-204293526),new cljs.core.Keyword(null,"field","field",-1302436500),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"sortable","sortable",2109633621),new cljs.core.Keyword(null,"cssClass","cssClass",264048890),new cljs.core.Keyword(null,"toolTip","toolTip",-228608737)],[hxl,(cljs.core.truth_(has_hxl_QMARK_)?"hxl-min-height":null),hatti.views.table.column_name_html_string.call(null,column_class,label,hxl),cljs.core.partial.call(null,hatti.views.table.formatter,field,language),(50),full_name,type,name,true,column_class,label]);
})(),hatti$views$table$iter__25216.call(null,cljs.core.rest.call(null,s__25217__$2)));
}
} else {
return null;
}
break;
}
});})(has_hxl_QMARK_,map__25214,map__25214__$1,hide_actions_column_QMARK_,is_filtered_dataview_QMARK_,get_label_QMARK_,language,owner))
,null,null));
});})(has_hxl_QMARK_,map__25214,map__25214__$1,hide_actions_column_QMARK_,is_filtered_dataview_QMARK_,get_label_QMARK_,language,owner))
;
return iter__7189__auto__.call(null,hatti.views.table.all_fields.call(null,form,new cljs.core.Keyword(null,"is-filtered-dataview?","is-filtered-dataview?",456678746),is_filtered_dataview_QMARK_));
})();
return cljs.core.clj__GT_js.call(null,(function (){var G__25236 = columns;
if(cljs.core.not.call(null,hide_actions_column_QMARK_)){
return cljs.core.conj.call(null,G__25236,hatti.views.table.actions_column.call(null,owner,has_hxl_QMARK_));
} else {
return G__25236;
}
})());
});

hatti.views.table.flat_form__GT_sg_columns.cljs$lang$maxFixedArity = (1);

hatti.views.table.flat_form__GT_sg_columns.cljs$lang$applyTo = (function (seq25211){
var G__25212 = cljs.core.first.call(null,seq25211);
var seq25211__$1 = cljs.core.next.call(null,seq25211);
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic(G__25212,seq25211__$1);
});

hatti.views.table.init_sg_pager = (function hatti$views$table$init_sg_pager(grid,dataview){
var Pager = Slick.Controls.Pager;
return (new Pager(dataview,grid,jQuery([cljs.core.str("#"),cljs.core.str(hatti.views.table.pager_id)].join(''))));
});
hatti.views.table.resizeColumns = (function hatti$views$table$resizeColumns(grid){
return grid.registerPlugin(Slick.AutoColumnSize());
});
/**
 * Options to feed the slickgrid constructor.
 */
hatti.views.table.sg_options = ({"autoHeight": true, "enableColumnReorder": false, "enableTextSelectionOnCells": true, "rowHeight": (40), "syncColumnCellResize": false});
hatti.views.table.bind_external_sg_grid_event_handlers = (function hatti$views$table$bind_external_sg_grid_event_handlers(grid,event_handlers){
return cljs.core.doall.call(null,(function (){var iter__7189__auto__ = (function hatti$views$table$bind_external_sg_grid_event_handlers_$_iter__25257(s__25258){
return (new cljs.core.LazySeq(null,(function (){
var s__25258__$1 = s__25258;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__25258__$1);
if(temp__4657__auto__){
var s__25258__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__25258__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__25258__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__25260 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__25259 = (0);
while(true){
if((i__25259 < size__7188__auto__)){
var vec__25267 = cljs.core._nth.call(null,c__7187__auto__,i__25259);
var handler_key = cljs.core.nth.call(null,vec__25267,(0),null);
var handler_function = cljs.core.nth.call(null,vec__25267,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case.call(null,cljs.core.name.call(null,handler_key));
var event = (grid[handler_name]);
cljs.core.chunk_append.call(null,b__25260,event.subscribe(handler_function));

var G__25273 = (i__25259 + (1));
i__25259 = G__25273;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__25260),hatti$views$table$bind_external_sg_grid_event_handlers_$_iter__25257.call(null,cljs.core.chunk_rest.call(null,s__25258__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__25260),null);
}
} else {
var vec__25270 = cljs.core.first.call(null,s__25258__$2);
var handler_key = cljs.core.nth.call(null,vec__25270,(0),null);
var handler_function = cljs.core.nth.call(null,vec__25270,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case.call(null,cljs.core.name.call(null,handler_key));
var event = (grid[handler_name]);
return cljs.core.cons.call(null,event.subscribe(handler_function),hatti$views$table$bind_external_sg_grid_event_handlers_$_iter__25257.call(null,cljs.core.rest.call(null,s__25258__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__.call(null,event_handlers);
})());
});
hatti.views.table.bind_external_sg_grid_dataview_handlers = (function hatti$views$table$bind_external_sg_grid_dataview_handlers(dataview,event_handlers){
return cljs.core.doall.call(null,(function (){var iter__7189__auto__ = (function hatti$views$table$bind_external_sg_grid_dataview_handlers_$_iter__25290(s__25291){
return (new cljs.core.LazySeq(null,(function (){
var s__25291__$1 = s__25291;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__25291__$1);
if(temp__4657__auto__){
var s__25291__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__25291__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__25291__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__25293 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__25292 = (0);
while(true){
if((i__25292 < size__7188__auto__)){
var vec__25300 = cljs.core._nth.call(null,c__7187__auto__,i__25292);
var handler_key = cljs.core.nth.call(null,vec__25300,(0),null);
var handler_function = cljs.core.nth.call(null,vec__25300,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case.call(null,cljs.core.name.call(null,handler_key));
var event = (dataview[handler_name]);
cljs.core.chunk_append.call(null,b__25293,event.subscribe(handler_function));

var G__25306 = (i__25292 + (1));
i__25292 = G__25306;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__25293),hatti$views$table$bind_external_sg_grid_dataview_handlers_$_iter__25290.call(null,cljs.core.chunk_rest.call(null,s__25291__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__25293),null);
}
} else {
var vec__25303 = cljs.core.first.call(null,s__25291__$2);
var handler_key = cljs.core.nth.call(null,vec__25303,(0),null);
var handler_function = cljs.core.nth.call(null,vec__25303,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case.call(null,cljs.core.name.call(null,handler_key));
var event = (dataview[handler_name]);
return cljs.core.cons.call(null,event.subscribe(handler_function),hatti$views$table$bind_external_sg_grid_dataview_handlers_$_iter__25290.call(null,cljs.core.rest.call(null,s__25291__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__.call(null,event_handlers);
})());
});
/**
 * Creates a Slick.Grid backed by Slick.Data.DataView from data and fields.
 * Most events are handled by slickgrid. On double-click, event is put on chan.
 * Returns [grid dataview].
 */
hatti.views.table.sg_init = (function hatti$views$table$sg_init(data,form,current_language,is_filtered_dataview_QMARK_,owner,p__25307){
var map__25316 = p__25307;
var map__25316__$1 = ((((!((map__25316 == null)))?((((map__25316.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25316.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25316):map__25316);
var grid_event_handlers = cljs.core.get.call(null,map__25316__$1,new cljs.core.Keyword(null,"grid-event-handlers","grid-event-handlers",1413592355));
var dataview_event_handlers = cljs.core.get.call(null,map__25316__$1,new cljs.core.Keyword(null,"dataview-event-handlers","dataview-event-handlers",-916375885));
var map__25318 = cljs.core.deref.call(null,hatti.shared.app_state);
var map__25318__$1 = ((((!((map__25318 == null)))?((((map__25318.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25318.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25318):map__25318);
var map__25319 = cljs.core.get.call(null,map__25318__$1,new cljs.core.Keyword(null,"table-page","table-page",1974969102));
var map__25319__$1 = ((((!((map__25319 == null)))?((((map__25319.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25319.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25319):map__25319);
var map__25320 = cljs.core.get.call(null,map__25319__$1,new cljs.core.Keyword(null,"paging","paging",1716279728));
var map__25320__$1 = ((((!((map__25320 == null)))?((((map__25320.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25320.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25320):map__25320);
var num_displayed_records = cljs.core.get.call(null,map__25320__$1,new cljs.core.Keyword(null,"num-displayed-records","num-displayed-records",213046400));
var total_page_count = cljs.core.get.call(null,map__25320__$1,new cljs.core.Keyword(null,"total-page-count","total-page-count",582341740));
var hide_actions_column_QMARK_ = cljs.core.get.call(null,map__25319__$1,new cljs.core.Keyword(null,"hide-actions-column?","hide-actions-column?",-30644754));
var columns = hatti.views.table.flat_form__GT_sg_columns.call(null,form,new cljs.core.Keyword(null,"language","language",-1591107564),current_language,new cljs.core.Keyword(null,"hide-actions-column?","hide-actions-column?",-30644754),hide_actions_column_QMARK_,new cljs.core.Keyword(null,"is-filtered-dataview?","is-filtered-dataview?",456678746),is_filtered_dataview_QMARK_,new cljs.core.Keyword(null,"owner","owner",-392611939),owner);
var SlickGrid = Slick.Grid;
var DataView = Slick.Data.DataView;
var dataview = (new DataView());
var grid = (new SlickGrid([cljs.core.str("#"),cljs.core.str(hatti.views.table.table_id)].join(''),dataview,columns,hatti.views.table.sg_options));
hatti.views.table.bind_external_sg_grid_event_handlers.call(null,grid,grid_event_handlers);

hatti.views.table.bind_external_sg_grid_dataview_handlers.call(null,dataview,dataview_event_handlers);

dataview.onRowCountChanged.subscribe(((function (map__25318,map__25318__$1,map__25319,map__25319__$1,map__25320,map__25320__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__25316,map__25316__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
grid.updateRowCount();

return grid.render();
});})(map__25318,map__25318__$1,map__25319,map__25319__$1,map__25320,map__25320__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__25316,map__25316__$1,grid_event_handlers,dataview_event_handlers))
);

dataview.onRowsChanged.subscribe(((function (map__25318,map__25318__$1,map__25319,map__25319__$1,map__25320,map__25320__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__25316,map__25316__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
grid.invalidateRows((args["rows"]));

return grid.render();
});})(map__25318,map__25318__$1,map__25319,map__25319__$1,map__25320,map__25320__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__25316,map__25316__$1,grid_event_handlers,dataview_event_handlers))
);

grid.onDblClick.subscribe(((function (map__25318,map__25318__$1,map__25319,map__25319__$1,map__25320,map__25320__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__25316,map__25316__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
var rank = (dataview.getItem((args["row"]))[hatti.constants._rank]);
return cljs.core.async.put_BANG_.call(null,hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"submission-to-rank","submission-to-rank",1214938797),rank], null));
});})(map__25318,map__25318__$1,map__25319,map__25319__$1,map__25320,map__25320__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__25316,map__25316__$1,grid_event_handlers,dataview_event_handlers))
);

grid.onClick.subscribe(((function (map__25318,map__25318__$1,map__25319,map__25319__$1,map__25320,map__25320__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__25316,map__25316__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
var elem = e.target;
var row = dataview.getItem((args["row"]));
var elem_data_id = elem.getAttribute("data-id");
var data_id = (cljs.core.truth_(elem_data_id)?parseInt(elem.getAttribute("data-id")):null);
var id = (row[hatti.constants._id]);
var rank = (row[hatti.constants._rank]);
if(cljs.core._EQ_.call(null,id,data_id)){
return cljs.core.async.put_BANG_.call(null,hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"submission-to-rank","submission-to-rank",1214938797),rank], null));
} else {
return null;
}
});})(map__25318,map__25318__$1,map__25319,map__25319__$1,map__25320,map__25320__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__25316,map__25316__$1,grid_event_handlers,dataview_event_handlers))
);

hatti.views.table.init_sg_pager.call(null,grid,dataview);

dataview.setPagingOptions(({"pageSize": (function (){var or__6409__auto__ = num_displayed_records;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return hatti.views.table.default_num_displayed_records;
}
})(), "totalPages": total_page_count}));

dataview.setFilter(cljs.core.partial.call(null,hatti.views.table.filterfn,form));

dataview.setItems(cljs.core.clj__GT_js.call(null,data),hatti.constants._id);

hatti.views.table.resizeColumns.call(null,grid);

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [grid,dataview], null);
});
/**
 * Event loop for the table view. Processes a tap of share/event-chan,
 * and updates app-state/dataview/grid as needed.
 */
hatti.views.table.handle_table_events = (function hatti$views$table$handle_table_events(app_state,grid,dataview){
var event_chan = hatti.shared.event_tap.call(null);
var c__12139__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__12139__auto__,event_chan){
return (function (){
var f__12140__auto__ = (function (){var switch__12027__auto__ = ((function (c__12139__auto__,event_chan){
return (function (state_25585){
var state_val_25586 = (state_25585[(1)]);
if((state_val_25586 === (7))){
var inst_25494 = (state_25585[(7)]);
var inst_25494__$1 = (state_25585[(2)]);
var inst_25496 = (inst_25494__$1 == null);
var inst_25497 = cljs.core.not.call(null,inst_25496);
var state_25585__$1 = (function (){var statearr_25587 = state_25585;
(statearr_25587[(7)] = inst_25494__$1);

return statearr_25587;
})();
if(inst_25497){
var statearr_25588_25655 = state_25585__$1;
(statearr_25588_25655[(1)] = (8));

} else {
var statearr_25589_25656 = state_25585__$1;
(statearr_25589_25656[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25586 === (20))){
var inst_25516 = (state_25585[(8)]);
var inst_25524 = (state_25585[(9)]);
var inst_25533 = inst_25524.call(null,inst_25516);
var state_25585__$1 = state_25585;
var statearr_25590_25657 = state_25585__$1;
(statearr_25590_25657[(2)] = inst_25533);

(statearr_25590_25657[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25586 === (27))){
var state_25585__$1 = state_25585;
var statearr_25591_25658 = state_25585__$1;
(statearr_25591_25658[(2)] = null);

(statearr_25591_25658[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25586 === (1))){
var state_25585__$1 = state_25585;
var statearr_25592_25659 = state_25585__$1;
(statearr_25592_25659[(2)] = null);

(statearr_25592_25659[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25586 === (24))){
var state_25585__$1 = state_25585;
var statearr_25593_25660 = state_25585__$1;
(statearr_25593_25660[(2)] = null);

(statearr_25593_25660[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25586 === (4))){
var state_25585__$1 = state_25585;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25585__$1,(7),event_chan);
} else {
if((state_val_25586 === (15))){
var inst_25494 = (state_25585[(7)]);
var state_25585__$1 = state_25585;
var statearr_25594_25661 = state_25585__$1;
(statearr_25594_25661[(2)] = inst_25494);

(statearr_25594_25661[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25586 === (21))){
var state_25585__$1 = state_25585;
var statearr_25595_25662 = state_25585__$1;
(statearr_25595_25662[(2)] = null);

(statearr_25595_25662[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25586 === (31))){
var inst_25520 = (state_25585[(10)]);
var inst_25558 = (state_25585[(2)]);
var inst_25559 = cljs.core._EQ_.call(null,inst_25520,new cljs.core.Keyword(null,"table","table",-564943036));
var state_25585__$1 = (function (){var statearr_25596 = state_25585;
(statearr_25596[(11)] = inst_25558);

return statearr_25596;
})();
if(inst_25559){
var statearr_25597_25663 = state_25585__$1;
(statearr_25597_25663[(1)] = (32));

} else {
var statearr_25598_25664 = state_25585__$1;
(statearr_25598_25664[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25586 === (32))){
var inst_25516 = (state_25585[(8)]);
var inst_25525 = (state_25585[(12)]);
var inst_25518 = (state_25585[(13)]);
var inst_25520 = (state_25585[(10)]);
var inst_25524 = (state_25585[(9)]);
var inst_25519 = (state_25585[(14)]);
var inst_25514 = (state_25585[(15)]);
var inst_25515 = (state_25585[(16)]);
var inst_25517 = (state_25585[(17)]);
var inst_25572 = cljs.core.async.chan.call(null,(1));
var inst_25573 = (function (){var new_columns = inst_25519;
var map__25492 = inst_25514;
var submission_clicked = inst_25516;
var submission_unclicked = inst_25517;
var get_submission_data = inst_25525;
var re_render = inst_25520;
var update_data_BANG_ = inst_25524;
var c__12139__auto____$1 = inst_25572;
var submission_to_rank = inst_25515;
var filter_by = inst_25518;
return ((function (new_columns,map__25492,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,c__12139__auto____$1,submission_to_rank,filter_by,inst_25516,inst_25525,inst_25518,inst_25520,inst_25524,inst_25519,inst_25514,inst_25515,inst_25517,inst_25572,state_val_25586,c__12139__auto__,event_chan){
return (function (){
var f__12140__auto__ = (function (){var switch__12027__auto__ = ((function (new_columns,map__25492,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,c__12139__auto____$1,submission_to_rank,filter_by,inst_25516,inst_25525,inst_25518,inst_25520,inst_25524,inst_25519,inst_25514,inst_25515,inst_25517,inst_25572,state_val_25586,c__12139__auto__,event_chan){
return (function (state_25570){
var state_val_25571 = (state_25570[(1)]);
if((state_val_25571 === (1))){
var inst_25561 = cljs.core.async.timeout.call(null,(20));
var state_25570__$1 = state_25570;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25570__$1,(2),inst_25561);
} else {
if((state_val_25571 === (2))){
var inst_25563 = (state_25570[(2)]);
var inst_25564 = grid.resizeCanvas();
var inst_25565 = grid.invalidateAllRows();
var inst_25566 = hatti.views.table.resizeColumns.call(null,grid);
var inst_25567 = grid.render();
var inst_25568 = hatti.views.table.init_sg_pager.call(null,grid,dataview);
var state_25570__$1 = (function (){var statearr_25599 = state_25570;
(statearr_25599[(7)] = inst_25567);

(statearr_25599[(8)] = inst_25564);

(statearr_25599[(9)] = inst_25566);

(statearr_25599[(10)] = inst_25565);

(statearr_25599[(11)] = inst_25563);

return statearr_25599;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25570__$1,inst_25568);
} else {
return null;
}
}
});})(new_columns,map__25492,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,c__12139__auto____$1,submission_to_rank,filter_by,inst_25516,inst_25525,inst_25518,inst_25520,inst_25524,inst_25519,inst_25514,inst_25515,inst_25517,inst_25572,state_val_25586,c__12139__auto__,event_chan))
;
return ((function (switch__12027__auto__,new_columns,map__25492,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,c__12139__auto____$1,submission_to_rank,filter_by,inst_25516,inst_25525,inst_25518,inst_25520,inst_25524,inst_25519,inst_25514,inst_25515,inst_25517,inst_25572,state_val_25586,c__12139__auto__,event_chan){
return (function() {
var hatti$views$table$handle_table_events_$_state_machine__12028__auto__ = null;
var hatti$views$table$handle_table_events_$_state_machine__12028__auto____0 = (function (){
var statearr_25603 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25603[(0)] = hatti$views$table$handle_table_events_$_state_machine__12028__auto__);

(statearr_25603[(1)] = (1));

return statearr_25603;
});
var hatti$views$table$handle_table_events_$_state_machine__12028__auto____1 = (function (state_25570){
while(true){
var ret_value__12029__auto__ = (function (){try{while(true){
var result__12030__auto__ = switch__12027__auto__.call(null,state_25570);
if(cljs.core.keyword_identical_QMARK_.call(null,result__12030__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12030__auto__;
}
break;
}
}catch (e25604){if((e25604 instanceof Object)){
var ex__12031__auto__ = e25604;
var statearr_25605_25665 = state_25570;
(statearr_25605_25665[(5)] = ex__12031__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25570);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25604;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__12029__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25666 = state_25570;
state_25570 = G__25666;
continue;
} else {
return ret_value__12029__auto__;
}
break;
}
});
hatti$views$table$handle_table_events_$_state_machine__12028__auto__ = function(state_25570){
switch(arguments.length){
case 0:
return hatti$views$table$handle_table_events_$_state_machine__12028__auto____0.call(this);
case 1:
return hatti$views$table$handle_table_events_$_state_machine__12028__auto____1.call(this,state_25570);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$handle_table_events_$_state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$handle_table_events_$_state_machine__12028__auto____0;
hatti$views$table$handle_table_events_$_state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$handle_table_events_$_state_machine__12028__auto____1;
return hatti$views$table$handle_table_events_$_state_machine__12028__auto__;
})()
;})(switch__12027__auto__,new_columns,map__25492,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,c__12139__auto____$1,submission_to_rank,filter_by,inst_25516,inst_25525,inst_25518,inst_25520,inst_25524,inst_25519,inst_25514,inst_25515,inst_25517,inst_25572,state_val_25586,c__12139__auto__,event_chan))
})();
var state__12141__auto__ = (function (){var statearr_25606 = f__12140__auto__.call(null);
(statearr_25606[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12139__auto____$1);

return statearr_25606;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__12141__auto__);
});
;})(new_columns,map__25492,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,c__12139__auto____$1,submission_to_rank,filter_by,inst_25516,inst_25525,inst_25518,inst_25520,inst_25524,inst_25519,inst_25514,inst_25515,inst_25517,inst_25572,state_val_25586,c__12139__auto__,event_chan))
})();
var inst_25574 = cljs.core.async.impl.dispatch.run.call(null,inst_25573);
var state_25585__$1 = (function (){var statearr_25607 = state_25585;
(statearr_25607[(18)] = inst_25574);

return statearr_25607;
})();
var statearr_25608_25667 = state_25585__$1;
(statearr_25608_25667[(2)] = inst_25572);

(statearr_25608_25667[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25586 === (33))){
var state_25585__$1 = state_25585;
var statearr_25609_25668 = state_25585__$1;
(statearr_25609_25668[(2)] = null);

(statearr_25609_25668[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25586 === (13))){
var inst_25506 = (state_25585[(2)]);
var state_25585__$1 = state_25585;
var statearr_25610_25669 = state_25585__$1;
(statearr_25610_25669[(2)] = inst_25506);

(statearr_25610_25669[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25586 === (22))){
var inst_25517 = (state_25585[(17)]);
var inst_25536 = (state_25585[(2)]);
var state_25585__$1 = (function (){var statearr_25611 = state_25585;
(statearr_25611[(19)] = inst_25536);

return statearr_25611;
})();
if(cljs.core.truth_(inst_25517)){
var statearr_25612_25670 = state_25585__$1;
(statearr_25612_25670[(1)] = (23));

} else {
var statearr_25613_25671 = state_25585__$1;
(statearr_25613_25671[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25586 === (29))){
var inst_25518 = (state_25585[(13)]);
var inst_25550 = [new cljs.core.Keyword(null,"query","query",-1288509510)];
var inst_25551 = [inst_25518];
var inst_25552 = cljs.core.PersistentHashMap.fromArrays(inst_25550,inst_25551);
var inst_25553 = cljs.core.clj__GT_js.call(null,inst_25552);
var inst_25554 = dataview.setFilterArgs(inst_25553);
var inst_25555 = dataview.refresh();
var state_25585__$1 = (function (){var statearr_25614 = state_25585;
(statearr_25614[(20)] = inst_25554);

return statearr_25614;
})();
var statearr_25615_25672 = state_25585__$1;
(statearr_25615_25672[(2)] = inst_25555);

(statearr_25615_25672[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25586 === (6))){
var inst_25581 = (state_25585[(2)]);
var state_25585__$1 = state_25585;
var statearr_25616_25673 = state_25585__$1;
(statearr_25616_25673[(2)] = inst_25581);

(statearr_25616_25673[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25586 === (28))){
var inst_25518 = (state_25585[(13)]);
var inst_25548 = (state_25585[(2)]);
var state_25585__$1 = (function (){var statearr_25617 = state_25585;
(statearr_25617[(21)] = inst_25548);

return statearr_25617;
})();
if(cljs.core.truth_(inst_25518)){
var statearr_25618_25674 = state_25585__$1;
(statearr_25618_25674[(1)] = (29));

} else {
var statearr_25619_25675 = state_25585__$1;
(statearr_25619_25675[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25586 === (25))){
var inst_25519 = (state_25585[(14)]);
var inst_25541 = (state_25585[(2)]);
var state_25585__$1 = (function (){var statearr_25620 = state_25585;
(statearr_25620[(22)] = inst_25541);

return statearr_25620;
})();
if(cljs.core.truth_(inst_25519)){
var statearr_25621_25676 = state_25585__$1;
(statearr_25621_25676[(1)] = (26));

} else {
var statearr_25622_25677 = state_25585__$1;
(statearr_25622_25677[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25586 === (34))){
var inst_25577 = (state_25585[(2)]);
var state_25585__$1 = (function (){var statearr_25623 = state_25585;
(statearr_25623[(23)] = inst_25577);

return statearr_25623;
})();
var statearr_25624_25678 = state_25585__$1;
(statearr_25624_25678[(2)] = null);

(statearr_25624_25678[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25586 === (17))){
var inst_25525 = (state_25585[(12)]);
var inst_25524 = (state_25585[(9)]);
var inst_25515 = (state_25585[(16)]);
var inst_25527 = inst_25525.call(null,hatti.constants._rank,inst_25515);
var inst_25528 = inst_25524.call(null,inst_25527);
var state_25585__$1 = state_25585;
var statearr_25625_25679 = state_25585__$1;
(statearr_25625_25679[(2)] = inst_25528);

(statearr_25625_25679[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25586 === (3))){
var inst_25583 = (state_25585[(2)]);
var state_25585__$1 = state_25585;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25585__$1,inst_25583);
} else {
if((state_val_25586 === (12))){
var state_25585__$1 = state_25585;
var statearr_25626_25680 = state_25585__$1;
(statearr_25626_25680[(2)] = false);

(statearr_25626_25680[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25586 === (2))){
var state_25585__$1 = state_25585;
var statearr_25627_25681 = state_25585__$1;
(statearr_25627_25681[(1)] = (4));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25586 === (23))){
var inst_25524 = (state_25585[(9)]);
var inst_25538 = inst_25524.call(null,null);
var state_25585__$1 = state_25585;
var statearr_25629_25682 = state_25585__$1;
(statearr_25629_25682[(2)] = inst_25538);

(statearr_25629_25682[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25586 === (19))){
var inst_25516 = (state_25585[(8)]);
var inst_25531 = (state_25585[(2)]);
var state_25585__$1 = (function (){var statearr_25630 = state_25585;
(statearr_25630[(24)] = inst_25531);

return statearr_25630;
})();
if(cljs.core.truth_(inst_25516)){
var statearr_25631_25683 = state_25585__$1;
(statearr_25631_25683[(1)] = (20));

} else {
var statearr_25632_25684 = state_25585__$1;
(statearr_25632_25684[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25586 === (11))){
var state_25585__$1 = state_25585;
var statearr_25633_25685 = state_25585__$1;
(statearr_25633_25685[(2)] = true);

(statearr_25633_25685[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25586 === (9))){
var state_25585__$1 = state_25585;
var statearr_25634_25686 = state_25585__$1;
(statearr_25634_25686[(2)] = false);

(statearr_25634_25686[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25586 === (5))){
var state_25585__$1 = state_25585;
var statearr_25635_25687 = state_25585__$1;
(statearr_25635_25687[(2)] = null);

(statearr_25635_25687[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25586 === (14))){
var inst_25494 = (state_25585[(7)]);
var inst_25511 = cljs.core.apply.call(null,cljs.core.hash_map,inst_25494);
var state_25585__$1 = state_25585;
var statearr_25636_25688 = state_25585__$1;
(statearr_25636_25688[(2)] = inst_25511);

(statearr_25636_25688[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25586 === (26))){
var inst_25519 = (state_25585[(14)]);
var inst_25543 = grid.setColumns(inst_25519);
var inst_25544 = hatti.views.table.resizeColumns.call(null,grid);
var inst_25545 = grid.render();
var state_25585__$1 = (function (){var statearr_25637 = state_25585;
(statearr_25637[(25)] = inst_25544);

(statearr_25637[(26)] = inst_25543);

return statearr_25637;
})();
var statearr_25638_25689 = state_25585__$1;
(statearr_25638_25689[(2)] = inst_25545);

(statearr_25638_25689[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25586 === (16))){
var inst_25516 = (state_25585[(8)]);
var inst_25518 = (state_25585[(13)]);
var inst_25520 = (state_25585[(10)]);
var inst_25524 = (state_25585[(9)]);
var inst_25519 = (state_25585[(14)]);
var inst_25514 = (state_25585[(15)]);
var inst_25515 = (state_25585[(16)]);
var inst_25517 = (state_25585[(17)]);
var inst_25514__$1 = (state_25585[(2)]);
var inst_25515__$1 = cljs.core.get.call(null,inst_25514__$1,new cljs.core.Keyword(null,"submission-to-rank","submission-to-rank",1214938797));
var inst_25516__$1 = cljs.core.get.call(null,inst_25514__$1,new cljs.core.Keyword(null,"submission-clicked","submission-clicked",1228953855));
var inst_25517__$1 = cljs.core.get.call(null,inst_25514__$1,new cljs.core.Keyword(null,"submission-unclicked","submission-unclicked",-2099539520));
var inst_25518__$1 = cljs.core.get.call(null,inst_25514__$1,new cljs.core.Keyword(null,"filter-by","filter-by",-1855851983));
var inst_25519__$1 = cljs.core.get.call(null,inst_25514__$1,new cljs.core.Keyword(null,"new-columns","new-columns",-887765797));
var inst_25520__$1 = cljs.core.get.call(null,inst_25514__$1,new cljs.core.Keyword(null,"re-render","re-render",1133553258));
var inst_25521 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25522 = [new cljs.core.Keyword(null,"table-page","table-page",1974969102),new cljs.core.Keyword(null,"submission-clicked","submission-clicked",1228953855),new cljs.core.Keyword(null,"data","data",-232669377)];
var inst_25523 = (new cljs.core.PersistentVector(null,3,(5),inst_25521,inst_25522,null));
var inst_25524__$1 = cljs.core.partial.call(null,om.core.update_BANG_,app_state,inst_25523);
var inst_25525 = (function (){var map__25492 = inst_25514__$1;
var submission_to_rank = inst_25515__$1;
var submission_clicked = inst_25516__$1;
var submission_unclicked = inst_25517__$1;
var filter_by = inst_25518__$1;
var new_columns = inst_25519__$1;
var re_render = inst_25520__$1;
var update_data_BANG_ = inst_25524__$1;
return ((function (map__25492,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_25516,inst_25518,inst_25520,inst_25524,inst_25519,inst_25514,inst_25515,inst_25517,inst_25514__$1,inst_25515__$1,inst_25516__$1,inst_25517__$1,inst_25518__$1,inst_25519__$1,inst_25520__$1,inst_25521,inst_25522,inst_25523,inst_25524__$1,state_val_25586,c__12139__auto__,event_chan){
return (function (field,value){
return cljs.core.first.call(null,cljs.core.filter.call(null,((function (map__25492,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_25516,inst_25518,inst_25520,inst_25524,inst_25519,inst_25514,inst_25515,inst_25517,inst_25514__$1,inst_25515__$1,inst_25516__$1,inst_25517__$1,inst_25518__$1,inst_25519__$1,inst_25520__$1,inst_25521,inst_25522,inst_25523,inst_25524__$1,state_val_25586,c__12139__auto__,event_chan){
return (function (p1__25324_SHARP_){
return cljs.core._EQ_.call(null,value,cljs.core.get.call(null,p1__25324_SHARP_,field));
});})(map__25492,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_25516,inst_25518,inst_25520,inst_25524,inst_25519,inst_25514,inst_25515,inst_25517,inst_25514__$1,inst_25515__$1,inst_25516__$1,inst_25517__$1,inst_25518__$1,inst_25519__$1,inst_25520__$1,inst_25521,inst_25522,inst_25523,inst_25524__$1,state_val_25586,c__12139__auto__,event_chan))
,cljs.core.get_in.call(null,cljs.core.deref.call(null,app_state),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377)], null))));
});
;})(map__25492,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_25516,inst_25518,inst_25520,inst_25524,inst_25519,inst_25514,inst_25515,inst_25517,inst_25514__$1,inst_25515__$1,inst_25516__$1,inst_25517__$1,inst_25518__$1,inst_25519__$1,inst_25520__$1,inst_25521,inst_25522,inst_25523,inst_25524__$1,state_val_25586,c__12139__auto__,event_chan))
})();
var state_25585__$1 = (function (){var statearr_25639 = state_25585;
(statearr_25639[(8)] = inst_25516__$1);

(statearr_25639[(12)] = inst_25525);

(statearr_25639[(13)] = inst_25518__$1);

(statearr_25639[(10)] = inst_25520__$1);

(statearr_25639[(9)] = inst_25524__$1);

(statearr_25639[(14)] = inst_25519__$1);

(statearr_25639[(15)] = inst_25514__$1);

(statearr_25639[(16)] = inst_25515__$1);

(statearr_25639[(17)] = inst_25517__$1);

return statearr_25639;
})();
if(cljs.core.truth_(inst_25515__$1)){
var statearr_25640_25690 = state_25585__$1;
(statearr_25640_25690[(1)] = (17));

} else {
var statearr_25641_25691 = state_25585__$1;
(statearr_25641_25691[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25586 === (30))){
var state_25585__$1 = state_25585;
var statearr_25642_25692 = state_25585__$1;
(statearr_25642_25692[(2)] = null);

(statearr_25642_25692[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25586 === (10))){
var inst_25509 = (state_25585[(2)]);
var state_25585__$1 = state_25585;
if(cljs.core.truth_(inst_25509)){
var statearr_25643_25693 = state_25585__$1;
(statearr_25643_25693[(1)] = (14));

} else {
var statearr_25644_25694 = state_25585__$1;
(statearr_25644_25694[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25586 === (18))){
var state_25585__$1 = state_25585;
var statearr_25645_25695 = state_25585__$1;
(statearr_25645_25695[(2)] = null);

(statearr_25645_25695[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25586 === (8))){
var inst_25494 = (state_25585[(7)]);
var inst_25499 = inst_25494.cljs$lang$protocol_mask$partition0$;
var inst_25500 = (inst_25499 & (64));
var inst_25501 = inst_25494.cljs$core$ISeq$;
var inst_25502 = (inst_25500) || (inst_25501);
var state_25585__$1 = state_25585;
if(cljs.core.truth_(inst_25502)){
var statearr_25646_25696 = state_25585__$1;
(statearr_25646_25696[(1)] = (11));

} else {
var statearr_25647_25697 = state_25585__$1;
(statearr_25647_25697[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12139__auto__,event_chan))
;
return ((function (switch__12027__auto__,c__12139__auto__,event_chan){
return (function() {
var hatti$views$table$handle_table_events_$_state_machine__12028__auto__ = null;
var hatti$views$table$handle_table_events_$_state_machine__12028__auto____0 = (function (){
var statearr_25651 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25651[(0)] = hatti$views$table$handle_table_events_$_state_machine__12028__auto__);

(statearr_25651[(1)] = (1));

return statearr_25651;
});
var hatti$views$table$handle_table_events_$_state_machine__12028__auto____1 = (function (state_25585){
while(true){
var ret_value__12029__auto__ = (function (){try{while(true){
var result__12030__auto__ = switch__12027__auto__.call(null,state_25585);
if(cljs.core.keyword_identical_QMARK_.call(null,result__12030__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12030__auto__;
}
break;
}
}catch (e25652){if((e25652 instanceof Object)){
var ex__12031__auto__ = e25652;
var statearr_25653_25698 = state_25585;
(statearr_25653_25698[(5)] = ex__12031__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25585);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25652;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__12029__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25699 = state_25585;
state_25585 = G__25699;
continue;
} else {
return ret_value__12029__auto__;
}
break;
}
});
hatti$views$table$handle_table_events_$_state_machine__12028__auto__ = function(state_25585){
switch(arguments.length){
case 0:
return hatti$views$table$handle_table_events_$_state_machine__12028__auto____0.call(this);
case 1:
return hatti$views$table$handle_table_events_$_state_machine__12028__auto____1.call(this,state_25585);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$handle_table_events_$_state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$handle_table_events_$_state_machine__12028__auto____0;
hatti$views$table$handle_table_events_$_state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$handle_table_events_$_state_machine__12028__auto____1;
return hatti$views$table$handle_table_events_$_state_machine__12028__auto__;
})()
;})(switch__12027__auto__,c__12139__auto__,event_chan))
})();
var state__12141__auto__ = (function (){var statearr_25654 = f__12140__auto__.call(null);
(statearr_25654[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12139__auto__);

return statearr_25654;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__12141__auto__);
});})(c__12139__auto__,event_chan))
);

return c__12139__auto__;
});
hatti.views.table.render_options = (function hatti$views$table$render_options(options,owner,colset_BANG_){
var choose_display_key = (function (k){
om.core.set_state_BANG_.call(null,owner,new cljs.core.Keyword(null,"name-or-label","name-or-label",-520034208),k);

return colset_BANG_.call(null,k);
});
var iter__7189__auto__ = ((function (choose_display_key){
return (function hatti$views$table$render_options_$_iter__25716(s__25717){
return (new cljs.core.LazySeq(null,((function (choose_display_key){
return (function (){
var s__25717__$1 = s__25717;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__25717__$1);
if(temp__4657__auto__){
var s__25717__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__25717__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__25717__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__25719 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__25718 = (0);
while(true){
if((i__25718 < size__7188__auto__)){
var vec__25726 = cljs.core._nth.call(null,c__7187__auto__,i__25718);
var k = cljs.core.nth.call(null,vec__25726,(0),null);
var v = cljs.core.nth.call(null,vec__25726,(1),null);
cljs.core.chunk_append.call(null,b__25719,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"on-click","on-click",1632826543),hatti.utils.click_fn.call(null,((function (i__25718,vec__25726,k,v,c__7187__auto__,size__7188__auto__,b__25719,s__25717__$2,temp__4657__auto__,choose_display_key){
return (function (){
return choose_display_key.call(null,k);
});})(i__25718,vec__25726,k,v,c__7187__auto__,size__7188__auto__,b__25719,s__25717__$2,temp__4657__auto__,choose_display_key))
),new cljs.core.Keyword(null,"href","href",-793805698),"#"], null),v], null)], null));

var G__25732 = (i__25718 + (1));
i__25718 = G__25732;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__25719),hatti$views$table$render_options_$_iter__25716.call(null,cljs.core.chunk_rest.call(null,s__25717__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__25719),null);
}
} else {
var vec__25729 = cljs.core.first.call(null,s__25717__$2);
var k = cljs.core.nth.call(null,vec__25729,(0),null);
var v = cljs.core.nth.call(null,vec__25729,(1),null);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"on-click","on-click",1632826543),hatti.utils.click_fn.call(null,((function (vec__25729,k,v,s__25717__$2,temp__4657__auto__,choose_display_key){
return (function (){
return choose_display_key.call(null,k);
});})(vec__25729,k,v,s__25717__$2,temp__4657__auto__,choose_display_key))
),new cljs.core.Keyword(null,"href","href",-793805698),"#"], null),v], null)], null),hatti$views$table$render_options_$_iter__25716.call(null,cljs.core.rest.call(null,s__25717__$2)));
}
} else {
return null;
}
break;
}
});})(choose_display_key))
,null,null));
});})(choose_display_key))
;
return iter__7189__auto__.call(null,options);
});
cljs.core._add_method.call(null,hatti.views.label_changer,new cljs.core.Keyword(null,"default","default",-1987822328),(function (p__25734,owner){
var map__25735 = p__25734;
var map__25735__$1 = ((((!((map__25735 == null)))?((((map__25735.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25735.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25735):map__25735);
var cursor = map__25735__$1;
var map__25736 = cljs.core.get.call(null,map__25735__$1,new cljs.core.Keyword(null,"table-page","table-page",1974969102));
var map__25736__$1 = ((((!((map__25736 == null)))?((((map__25736.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25736.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25736):map__25736);
var hide_actions_column_QMARK_ = cljs.core.get.call(null,map__25736__$1,new cljs.core.Keyword(null,"hide-actions-column?","hide-actions-column?",-30644754));
if(typeof hatti.views.table.t_hatti$views$table25739 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRenderState}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IInitState}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table25739 = (function (p__25734,owner,map__25735,cursor,map__25736,hide_actions_column_QMARK_,meta25740){
this.p__25734 = p__25734;
this.owner = owner;
this.map__25735 = map__25735;
this.cursor = cursor;
this.map__25736 = map__25736;
this.hide_actions_column_QMARK_ = hide_actions_column_QMARK_;
this.meta25740 = meta25740;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table25739.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (map__25735,map__25735__$1,cursor,map__25736,map__25736__$1,hide_actions_column_QMARK_){
return (function (_25741,meta25740__$1){
var self__ = this;
var _25741__$1 = this;
return (new hatti.views.table.t_hatti$views$table25739(self__.p__25734,self__.owner,self__.map__25735,self__.cursor,self__.map__25736,self__.hide_actions_column_QMARK_,meta25740__$1));
});})(map__25735,map__25735__$1,cursor,map__25736,map__25736__$1,hide_actions_column_QMARK_))
;

hatti.views.table.t_hatti$views$table25739.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (map__25735,map__25735__$1,cursor,map__25736,map__25736__$1,hide_actions_column_QMARK_){
return (function (_25741){
var self__ = this;
var _25741__$1 = this;
return self__.meta25740;
});})(map__25735,map__25735__$1,cursor,map__25736,map__25736__$1,hide_actions_column_QMARK_))
;

hatti.views.table.t_hatti$views$table25739.prototype.om$core$IInitState$ = true;

hatti.views.table.t_hatti$views$table25739.prototype.om$core$IInitState$init_state$arity$1 = ((function (map__25735,map__25735__$1,cursor,map__25736,map__25736__$1,hide_actions_column_QMARK_){
return (function (_){
var self__ = this;
var ___$1 = this;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"name-or-label","name-or-label",-520034208),new cljs.core.Keyword(null,"label","label",1718410804)], null);
});})(map__25735,map__25735__$1,cursor,map__25736,map__25736__$1,hide_actions_column_QMARK_))
;

hatti.views.table.t_hatti$views$table25739.prototype.om$core$IRenderState$ = true;

hatti.views.table.t_hatti$views$table25739.prototype.om$core$IRenderState$render_state$arity$2 = ((function (map__25735,map__25735__$1,cursor,map__25736,map__25736__$1,hide_actions_column_QMARK_){
return (function (_,p__25742){
var self__ = this;
var map__25743 = p__25742;
var map__25743__$1 = ((((!((map__25743 == null)))?((((map__25743.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25743.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25743):map__25743);
var name_or_label = cljs.core.get.call(null,map__25743__$1,new cljs.core.Keyword(null,"name-or-label","name-or-label",-520034208));
var language = cljs.core.get.call(null,map__25743__$1,new cljs.core.Keyword(null,"language","language",-1591107564));
var ___$1 = this;
var options = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"label","label",1718410804),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"strong","strong",269529000),"Label"], null),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"strong","strong",269529000),"Name"], null)], null);
var map__25745 = om.core.get_shared.call(null,self__.owner);
var map__25745__$1 = ((((!((map__25745 == null)))?((((map__25745.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25745.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25745):map__25745);
var flat_form = cljs.core.get.call(null,map__25745__$1,new cljs.core.Keyword(null,"flat-form","flat-form",-468858211));
var new_language = new cljs.core.Keyword(null,"current","current",-1088038603).cljs$core$IFn$_invoke$arity$1(om.core.observe.call(null,self__.owner,hatti.shared.language_cursor.call(null)));
var colset_BANG_ = ((function (options,map__25745,map__25745__$1,flat_form,new_language,___$1,map__25743,map__25743__$1,name_or_label,language,map__25735,map__25735__$1,cursor,map__25736,map__25736__$1,hide_actions_column_QMARK_){
return (function (p1__25733_SHARP_){
return cljs.core.async.put_BANG_.call(null,hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"new-columns","new-columns",-887765797),hatti.views.table.flat_form__GT_sg_columns.call(null,flat_form,new cljs.core.Keyword(null,"get-label?","get-label?",617123530),cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"label","label",1718410804),p1__25733_SHARP_),new cljs.core.Keyword(null,"hide-actions-column?","hide-actions-column?",-30644754),self__.hide_actions_column_QMARK_,new cljs.core.Keyword(null,"language","language",-1591107564),new_language)], null));
});})(options,map__25745,map__25745__$1,flat_form,new_language,___$1,map__25743,map__25743__$1,name_or_label,language,map__25735,map__25735__$1,cursor,map__25736,map__25736__$1,hide_actions_column_QMARK_))
;
if(cljs.core.not_EQ_.call(null,new_language,language)){
om.core.set_state_BANG_.call(null,self__.owner,new cljs.core.Keyword(null,"language","language",-1591107564),new_language);

colset_BANG_.call(null,name_or_label);
} else {
}

return React.DOM.div(({"className": "label-changer"}),React.DOM.span(({"className": "label-changer-label"}),"Show:"),React.DOM.div(({"id": "header-display-dropdown", "className": "drop-hover"}),(function (){var attrs25749 = options.call(null,name_or_label);
return cljs.core.apply.call(null,React.DOM.span,((cljs.core.map_QMARK_.call(null,attrs25749))?sablono.interpreter.attributes.call(null,attrs25749):null),cljs.core.remove.call(null,cljs.core.nil_QMARK_,((cljs.core.map_QMARK_.call(null,attrs25749))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [React.DOM.i(({"className": "fa fa-angle-down"}))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret.call(null,attrs25749),React.DOM.i(({"className": "fa fa-angle-down"}))], null))));
})(),React.DOM.ul(({"className": "submenu no-dot"}),sablono.interpreter.interpret.call(null,hatti.views.table.render_options.call(null,options,self__.owner,colset_BANG_)))));
});})(map__25735,map__25735__$1,cursor,map__25736,map__25736__$1,hide_actions_column_QMARK_))
;

hatti.views.table.t_hatti$views$table25739.getBasis = ((function (map__25735,map__25735__$1,cursor,map__25736,map__25736__$1,hide_actions_column_QMARK_){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p__25734","p__25734",-1084348546,null),new cljs.core.Symbol(null,"owner","owner",1247919588,null),new cljs.core.Symbol(null,"map__25735","map__25735",498571275,null),new cljs.core.Symbol(null,"cursor","cursor",-1642498285,null),new cljs.core.Symbol(null,"map__25736","map__25736",399544981,null),new cljs.core.Symbol(null,"hide-actions-column?","hide-actions-column?",1609886773,null),new cljs.core.Symbol(null,"meta25740","meta25740",-821421401,null)], null);
});})(map__25735,map__25735__$1,cursor,map__25736,map__25736__$1,hide_actions_column_QMARK_))
;

hatti.views.table.t_hatti$views$table25739.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table25739.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table25739";

hatti.views.table.t_hatti$views$table25739.cljs$lang$ctorPrWriter = ((function (map__25735,map__25735__$1,cursor,map__25736,map__25736__$1,hide_actions_column_QMARK_){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"hatti.views.table/t_hatti$views$table25739");
});})(map__25735,map__25735__$1,cursor,map__25736,map__25736__$1,hide_actions_column_QMARK_))
;

hatti.views.table.__GT_t_hatti$views$table25739 = ((function (map__25735,map__25735__$1,cursor,map__25736,map__25736__$1,hide_actions_column_QMARK_){
return (function hatti$views$table$__GT_t_hatti$views$table25739(p__25734__$1,owner__$1,map__25735__$2,cursor__$1,map__25736__$2,hide_actions_column_QMARK___$1,meta25740){
return (new hatti.views.table.t_hatti$views$table25739(p__25734__$1,owner__$1,map__25735__$2,cursor__$1,map__25736__$2,hide_actions_column_QMARK___$1,meta25740));
});})(map__25735,map__25735__$1,cursor,map__25736,map__25736__$1,hide_actions_column_QMARK_))
;

}

return (new hatti.views.table.t_hatti$views$table25739(p__25734,owner,map__25735__$1,cursor,map__25736__$1,hide_actions_column_QMARK_,cljs.core.PersistentArrayMap.EMPTY));
}));
/**
 * Delayed search fires a query-event on event-chan if the value of the input
 * doesn't change within 150 ms (ie, user is still typing).
 * Call on-change or on-key-up, with (.-target event) as first argument.
 */
hatti.views.table.delayed_search = (function hatti$views$table$delayed_search(input,query_event_key){
var query = input.value;
var c__12139__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__12139__auto__,query){
return (function (){
var f__12140__auto__ = (function (){var switch__12027__auto__ = ((function (c__12139__auto__,query){
return (function (state_25796){
var state_val_25797 = (state_25796[(1)]);
if((state_val_25797 === (1))){
var inst_25782 = cljs.core.async.timeout.call(null,(150));
var state_25796__$1 = state_25796;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25796__$1,(2),inst_25782);
} else {
if((state_val_25797 === (2))){
var inst_25784 = (state_25796[(2)]);
var inst_25785 = input.value;
var inst_25786 = cljs.core._EQ_.call(null,query,inst_25785);
var state_25796__$1 = (function (){var statearr_25798 = state_25796;
(statearr_25798[(7)] = inst_25784);

return statearr_25798;
})();
if(inst_25786){
var statearr_25799_25810 = state_25796__$1;
(statearr_25799_25810[(1)] = (3));

} else {
var statearr_25800_25811 = state_25796__$1;
(statearr_25800_25811[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25797 === (3))){
var inst_25788 = [query_event_key];
var inst_25789 = [query];
var inst_25790 = cljs.core.PersistentHashMap.fromArrays(inst_25788,inst_25789);
var inst_25791 = cljs.core.async.put_BANG_.call(null,hatti.shared.event_chan,inst_25790);
var state_25796__$1 = state_25796;
var statearr_25801_25812 = state_25796__$1;
(statearr_25801_25812[(2)] = inst_25791);

(statearr_25801_25812[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25797 === (4))){
var state_25796__$1 = state_25796;
var statearr_25802_25813 = state_25796__$1;
(statearr_25802_25813[(2)] = null);

(statearr_25802_25813[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25797 === (5))){
var inst_25794 = (state_25796[(2)]);
var state_25796__$1 = state_25796;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25796__$1,inst_25794);
} else {
return null;
}
}
}
}
}
});})(c__12139__auto__,query))
;
return ((function (switch__12027__auto__,c__12139__auto__,query){
return (function() {
var hatti$views$table$delayed_search_$_state_machine__12028__auto__ = null;
var hatti$views$table$delayed_search_$_state_machine__12028__auto____0 = (function (){
var statearr_25806 = [null,null,null,null,null,null,null,null];
(statearr_25806[(0)] = hatti$views$table$delayed_search_$_state_machine__12028__auto__);

(statearr_25806[(1)] = (1));

return statearr_25806;
});
var hatti$views$table$delayed_search_$_state_machine__12028__auto____1 = (function (state_25796){
while(true){
var ret_value__12029__auto__ = (function (){try{while(true){
var result__12030__auto__ = switch__12027__auto__.call(null,state_25796);
if(cljs.core.keyword_identical_QMARK_.call(null,result__12030__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12030__auto__;
}
break;
}
}catch (e25807){if((e25807 instanceof Object)){
var ex__12031__auto__ = e25807;
var statearr_25808_25814 = state_25796;
(statearr_25808_25814[(5)] = ex__12031__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25796);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25807;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__12029__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25815 = state_25796;
state_25796 = G__25815;
continue;
} else {
return ret_value__12029__auto__;
}
break;
}
});
hatti$views$table$delayed_search_$_state_machine__12028__auto__ = function(state_25796){
switch(arguments.length){
case 0:
return hatti$views$table$delayed_search_$_state_machine__12028__auto____0.call(this);
case 1:
return hatti$views$table$delayed_search_$_state_machine__12028__auto____1.call(this,state_25796);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$delayed_search_$_state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$delayed_search_$_state_machine__12028__auto____0;
hatti$views$table$delayed_search_$_state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$delayed_search_$_state_machine__12028__auto____1;
return hatti$views$table$delayed_search_$_state_machine__12028__auto__;
})()
;})(switch__12027__auto__,c__12139__auto__,query))
})();
var state__12141__auto__ = (function (){var statearr_25809 = f__12140__auto__.call(null);
(statearr_25809[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12139__auto__);

return statearr_25809;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__12141__auto__);
});})(c__12139__auto__,query))
);

return c__12139__auto__;
});
cljs.core._add_method.call(null,hatti.views.table_search,new cljs.core.Keyword(null,"default","default",-1987822328),(function (_,owner){
if(typeof hatti.views.table.t_hatti$views$table25817 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table25817 = (function (_,owner,meta25818){
this._ = _;
this.owner = owner;
this.meta25818 = meta25818;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table25817.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_25819,meta25818__$1){
var self__ = this;
var _25819__$1 = this;
return (new hatti.views.table.t_hatti$views$table25817(self__._,self__.owner,meta25818__$1));
});

hatti.views.table.t_hatti$views$table25817.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_25819){
var self__ = this;
var _25819__$1 = this;
return self__.meta25818;
});

hatti.views.table.t_hatti$views$table25817.prototype.om$core$IRender$ = true;

hatti.views.table.t_hatti$views$table25817.prototype.om$core$IRender$render$arity$1 = (function (this__18114__auto__){
var self__ = this;
var this__18114__auto____$1 = this;
return React.DOM.div(({"className": "table-search"}),React.DOM.i(({"className": "fa fa-search"})),sablono.interpreter.input.call(null,({"type": "text", "placeholder": "Search", "onChange": ((function (this__18114__auto____$1){
return (function (p1__25816_SHARP_){
return hatti.views.table.delayed_search.call(null,p1__25816_SHARP_.target,new cljs.core.Keyword(null,"filter-by","filter-by",-1855851983));
});})(this__18114__auto____$1))
})));
});

hatti.views.table.t_hatti$views$table25817.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.Symbol(null,"owner","owner",1247919588,null),new cljs.core.Symbol(null,"meta25818","meta25818",1195374519,null)], null);
});

hatti.views.table.t_hatti$views$table25817.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table25817.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table25817";

hatti.views.table.t_hatti$views$table25817.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"hatti.views.table/t_hatti$views$table25817");
});

hatti.views.table.__GT_t_hatti$views$table25817 = (function hatti$views$table$__GT_t_hatti$views$table25817(___$1,owner__$1,meta25818){
return (new hatti.views.table.t_hatti$views$table25817(___$1,owner__$1,meta25818));
});

}

return (new hatti.views.table.t_hatti$views$table25817(_,owner,null));
}));
cljs.core._add_method.call(null,hatti.views.table_header,new cljs.core.Keyword(null,"default","default",-1987822328),(function (cursor,owner){
if(typeof hatti.views.table.t_hatti$views$table25822 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table25822 = (function (cursor,owner,meta25823){
this.cursor = cursor;
this.owner = owner;
this.meta25823 = meta25823;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table25822.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_25824,meta25823__$1){
var self__ = this;
var _25824__$1 = this;
return (new hatti.views.table.t_hatti$views$table25822(self__.cursor,self__.owner,meta25823__$1));
});

hatti.views.table.t_hatti$views$table25822.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_25824){
var self__ = this;
var _25824__$1 = this;
return self__.meta25823;
});

hatti.views.table.t_hatti$views$table25822.prototype.om$core$IRender$ = true;

hatti.views.table.t_hatti$views$table25822.prototype.om$core$IRender$render$arity$1 = (function (this__18114__auto__){
var self__ = this;
var this__18114__auto____$1 = this;
return React.DOM.div(({"className": "topbar"}),React.DOM.div(({"id": hatti.views.table.pager_id})),sablono.interpreter.interpret.call(null,om.core.build.call(null,hatti.views.label_changer,self__.cursor)),sablono.interpreter.interpret.call(null,om.core.build.call(null,hatti.views.table_search,self__.cursor)),React.DOM.div(({"style": ({"clear": "both"})})));
});

hatti.views.table.t_hatti$views$table25822.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"cursor","cursor",-1642498285,null),new cljs.core.Symbol(null,"owner","owner",1247919588,null),new cljs.core.Symbol(null,"meta25823","meta25823",1034714563,null)], null);
});

hatti.views.table.t_hatti$views$table25822.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table25822.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table25822";

hatti.views.table.t_hatti$views$table25822.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"hatti.views.table/t_hatti$views$table25822");
});

hatti.views.table.__GT_t_hatti$views$table25822 = (function hatti$views$table$__GT_t_hatti$views$table25822(cursor__$1,owner__$1,meta25823){
return (new hatti.views.table.t_hatti$views$table25822(cursor__$1,owner__$1,meta25823));
});

}

return (new hatti.views.table.t_hatti$views$table25822(cursor,owner,null));
}));
/**
 * Initializes grid + dataview, and stores them in owner's state.
 */
hatti.views.table.init_grid_BANG_ = (function hatti$views$table$init_grid_BANG_(data,owner,slick_grid_event_handlers){
if(cljs.core.seq.call(null,data)){
var map__25832 = om.core.get_shared.call(null,owner);
var map__25832__$1 = ((((!((map__25832 == null)))?((((map__25832.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25832.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25832):map__25832);
var flat_form = cljs.core.get.call(null,map__25832__$1,new cljs.core.Keyword(null,"flat-form","flat-form",-468858211));
var is_filtered_dataview_QMARK_ = cljs.core.get.call(null,map__25832__$1,new cljs.core.Keyword(null,"is-filtered-dataview?","is-filtered-dataview?",456678746));
var current_language = new cljs.core.Keyword(null,"current","current",-1088038603).cljs$core$IFn$_invoke$arity$1(om.core.observe.call(null,owner,hatti.shared.language_cursor.call(null)));
var vec__25833 = hatti.views.table.sg_init.call(null,data,flat_form,current_language,is_filtered_dataview_QMARK_,owner,slick_grid_event_handlers);
var grid = cljs.core.nth.call(null,vec__25833,(0),null);
var dataview = cljs.core.nth.call(null,vec__25833,(1),null);
om.core.set_state_BANG_.call(null,owner,new cljs.core.Keyword(null,"grid","grid",402978600),grid);

om.core.set_state_BANG_.call(null,owner,new cljs.core.Keyword(null,"dataview","dataview",91765671),dataview);

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [grid,dataview], null);
} else {
return null;
}
});
hatti.views.table.get_table_view_height = (function hatti$views$table$get_table_view_height(){
return (document.querySelector("body").clientHeight - document.querySelector(".tab-page").getBoundingClientRect().top);
});
hatti.views.table.set_window_resize_handler = (function hatti$views$table$set_window_resize_handler(owner){
var resize_handler = (function (event){
return om.core.set_state_BANG_.call(null,owner,new cljs.core.Keyword(null,"table-view-height","table-view-height",-951800901),hatti.views.table.get_table_view_height.call(null));
});
window.addEventListener("resize",resize_handler);

return om.core.set_state_BANG_.call(null,owner,new cljs.core.Keyword(null,"resize-handler","resize-handler",-169459881),resize_handler);
});
cljs.core._add_method.call(null,hatti.views.table_page,new cljs.core.Keyword(null,"default","default",-1987822328),(function (p__25838,owner,p__25839){
var map__25840 = p__25838;
var map__25840__$1 = ((((!((map__25840 == null)))?((((map__25840.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25840.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25840):map__25840);
var cursor = map__25840__$1;
var map__25841 = cljs.core.get.call(null,map__25840__$1,new cljs.core.Keyword(null,"views","views",1450155487));
var map__25841__$1 = ((((!((map__25841 == null)))?((((map__25841.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25841.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25841):map__25841);
var active = cljs.core.get.call(null,map__25841__$1,new cljs.core.Keyword(null,"active","active",1895962068));
var map__25842 = p__25839;
var map__25842__$1 = ((((!((map__25842 == null)))?((((map__25842.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25842.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25842):map__25842);
var opts = map__25842__$1;
var slick_grid_event_handlers = cljs.core.get.call(null,map__25842__$1,new cljs.core.Keyword(null,"slick-grid-event-handlers","slick-grid-event-handlers",1990034724));

var active_QMARK_ = chimera.seq.in_QMARK_.call(null,active,new cljs.core.Keyword(null,"table","table",-564943036));
if(typeof hatti.views.table.t_hatti$views$table25846 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IWillUnmount}
 * @implements {om.core.IRenderState}
 * @implements {om.core.IWillReceiveProps}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IDidMount}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table25846 = (function (map__25842,map__25841,owner,active_QMARK_,slick_grid_event_handlers,map__25840,cursor,active,p__25838,opts,p__25839,meta25847){
this.map__25842 = map__25842;
this.map__25841 = map__25841;
this.owner = owner;
this.active_QMARK_ = active_QMARK_;
this.slick_grid_event_handlers = slick_grid_event_handlers;
this.map__25840 = map__25840;
this.cursor = cursor;
this.active = active;
this.p__25838 = p__25838;
this.opts = opts;
this.p__25839 = p__25839;
this.meta25847 = meta25847;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table25846.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (active_QMARK_,map__25840,map__25840__$1,cursor,map__25841,map__25841__$1,active,map__25842,map__25842__$1,opts,slick_grid_event_handlers){
return (function (_25848,meta25847__$1){
var self__ = this;
var _25848__$1 = this;
return (new hatti.views.table.t_hatti$views$table25846(self__.map__25842,self__.map__25841,self__.owner,self__.active_QMARK_,self__.slick_grid_event_handlers,self__.map__25840,self__.cursor,self__.active,self__.p__25838,self__.opts,self__.p__25839,meta25847__$1));
});})(active_QMARK_,map__25840,map__25840__$1,cursor,map__25841,map__25841__$1,active,map__25842,map__25842__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table25846.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (active_QMARK_,map__25840,map__25840__$1,cursor,map__25841,map__25841__$1,active,map__25842,map__25842__$1,opts,slick_grid_event_handlers){
return (function (_25848){
var self__ = this;
var _25848__$1 = this;
return self__.meta25847;
});})(active_QMARK_,map__25840,map__25840__$1,cursor,map__25841,map__25841__$1,active,map__25842,map__25842__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table25846.prototype.om$core$IRenderState$ = true;

hatti.views.table.t_hatti$views$table25846.prototype.om$core$IRenderState$render_state$arity$2 = ((function (active_QMARK_,map__25840,map__25840__$1,cursor,map__25841,map__25841__$1,active,map__25842,map__25842__$1,opts,slick_grid_event_handlers){
return (function (_,p__25849){
var self__ = this;
var map__25850 = p__25849;
var map__25850__$1 = ((((!((map__25850 == null)))?((((map__25850.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25850.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25850):map__25850);
var table_view_height = cljs.core.get.call(null,map__25850__$1,new cljs.core.Keyword(null,"table-view-height","table-view-height",-951800901));
var ___$1 = this;
var map__25852 = self__.cursor;
var map__25852__$1 = ((((!((map__25852 == null)))?((((map__25852.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25852.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25852):map__25852);
var map__25853 = cljs.core.get.call(null,map__25852__$1,new cljs.core.Keyword(null,"table-page","table-page",1974969102));
var map__25853__$1 = ((((!((map__25853 == null)))?((((map__25853.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25853.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25853):map__25853);
var prevent_scrolling_in_table_view_QMARK_ = cljs.core.get.call(null,map__25853__$1,new cljs.core.Keyword(null,"prevent-scrolling-in-table-view?","prevent-scrolling-in-table-view?",2053296532));
var submission_clicked = cljs.core.get.call(null,map__25853__$1,new cljs.core.Keyword(null,"submission-clicked","submission-clicked",1228953855));
var data = cljs.core.get.call(null,map__25852__$1,new cljs.core.Keyword(null,"data","data",-232669377));
var dataset_info = cljs.core.get.call(null,map__25852__$1,new cljs.core.Keyword(null,"dataset-info","dataset-info",-1196999563));
var map__25854 = dataset_info;
var map__25854__$1 = ((((!((map__25854 == null)))?((((map__25854.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25854.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25854):map__25854);
var num_of_submissions = cljs.core.get.call(null,map__25854__$1,new cljs.core.Keyword(null,"num_of_submissions","num_of_submissions",-1720943091));
var no_data_QMARK_ = cljs.core.empty_QMARK_.call(null,data);
var with_info = ((function (map__25852,map__25852__$1,map__25853,map__25853__$1,prevent_scrolling_in_table_view_QMARK_,submission_clicked,data,dataset_info,map__25854,map__25854__$1,num_of_submissions,no_data_QMARK_,___$1,map__25850,map__25850__$1,table_view_height,active_QMARK_,map__25840,map__25840__$1,cursor,map__25841,map__25841__$1,active,map__25842,map__25842__$1,opts,slick_grid_event_handlers){
return (function (p1__25837_SHARP_){
return cljs.core.merge.call(null,self__.cursor,p1__25837_SHARP_);
});})(map__25852,map__25852__$1,map__25853,map__25853__$1,prevent_scrolling_in_table_view_QMARK_,submission_clicked,data,dataset_info,map__25854,map__25854__$1,num_of_submissions,no_data_QMARK_,___$1,map__25850,map__25850__$1,table_view_height,active_QMARK_,map__25840,map__25840__$1,cursor,map__25841,map__25841__$1,active,map__25842,map__25842__$1,opts,slick_grid_event_handlers))
;
if(cljs.core.truth_(self__.active_QMARK_)){
return React.DOM.div(({"style": cljs.core.clj__GT_js.call(null,(cljs.core.truth_(prevent_scrolling_in_table_view_QMARK_)?new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"height","height",1025178622),(function (){var or__6409__auto__ = table_view_height;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return hatti.views.table.get_table_view_height.call(null);
}
})(),new cljs.core.Keyword(null,"overflow","overflow",2058931880),"hidden"], null):null)), "className": "table-view"}),sablono.interpreter.interpret.call(null,(cljs.core.truth_(new cljs.core.Keyword(null,"data","data",-232669377).cljs$core$IFn$_invoke$arity$1(submission_clicked))?om.core.build.call(null,hatti.views.submission_view,with_info.call(null,submission_clicked),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"opts","opts",155075701),cljs.core.merge.call(null,cljs.core.select_keys.call(null,self__.opts,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"role","role",-736691072),null,new cljs.core.Keyword(null,"delete-record!","delete-record!",1411848194),null], null), null)),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"view","view",1247994814),new cljs.core.Keyword(null,"table","table",-564943036)], null))], null)):null)),sablono.interpreter.interpret.call(null,om.core.build.call(null,hatti.views.table_header,self__.cursor)),React.DOM.div(({"id": hatti.views.table.table_id, "className": "slickgrid"}),(((no_data_QMARK_) && ((num_of_submissions === (0))))?React.DOM.p(({"className": "alert alert-warning"}),"No data"):React.DOM.span(null,React.DOM.i(({"className": "fa fa-spinner fa-pulse"})),"Loading..."))));
} else {
return null;
}
});})(active_QMARK_,map__25840,map__25840__$1,cursor,map__25841,map__25841__$1,active,map__25842,map__25842__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table25846.prototype.om$core$IDidMount$ = true;

hatti.views.table.t_hatti$views$table25846.prototype.om$core$IDidMount$did_mount$arity$1 = ((function (active_QMARK_,map__25840,map__25840__$1,cursor,map__25841,map__25841__$1,active,map__25842,map__25842__$1,opts,slick_grid_event_handlers){
return (function (_){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.active_QMARK_)){
hatti.views.table.set_window_resize_handler.call(null,self__.owner);

var data = cljs.core.get_in.call(null,self__.cursor,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377)], null));
var temp__4657__auto__ = hatti.views.table.init_grid_BANG_.call(null,data,self__.owner,self__.slick_grid_event_handlers);
if(cljs.core.truth_(temp__4657__auto__)){
var vec__25862 = temp__4657__auto__;
var grid = cljs.core.nth.call(null,vec__25862,(0),null);
var dataview = cljs.core.nth.call(null,vec__25862,(1),null);
return hatti.views.table.handle_table_events.call(null,self__.cursor,grid,dataview);
} else {
return null;
}
} else {
return null;
}
});})(active_QMARK_,map__25840,map__25840__$1,cursor,map__25841,map__25841__$1,active,map__25842,map__25842__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table25846.prototype.om$core$IWillUnmount$ = true;

hatti.views.table.t_hatti$views$table25846.prototype.om$core$IWillUnmount$will_unmount$arity$1 = ((function (active_QMARK_,map__25840,map__25840__$1,cursor,map__25841,map__25841__$1,active,map__25842,map__25842__$1,opts,slick_grid_event_handlers){
return (function (_){
var self__ = this;
var ___$1 = this;
return window.removeEventListener("resize",om.core.get_state.call(null,self__.owner,new cljs.core.Keyword(null,"resize-handler","resize-handler",-169459881)));
});})(active_QMARK_,map__25840,map__25840__$1,cursor,map__25841,map__25841__$1,active,map__25842,map__25842__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table25846.prototype.om$core$IWillReceiveProps$ = true;

hatti.views.table.t_hatti$views$table25846.prototype.om$core$IWillReceiveProps$will_receive_props$arity$2 = ((function (active_QMARK_,map__25840,map__25840__$1,cursor,map__25841,map__25841__$1,active,map__25842,map__25842__$1,opts,slick_grid_event_handlers){
return (function (_,next_props){
var self__ = this;
var ___$1 = this;

if(cljs.core.truth_(self__.active_QMARK_)){
var old_data = cljs.core.get_in.call(null,om.core.get_props.call(null,self__.owner),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377)], null));
var new_data = cljs.core.get_in.call(null,next_props,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377)], null));
var map__25865 = om.core.get_state.call(null,self__.owner);
var map__25865__$1 = ((((!((map__25865 == null)))?((((map__25865.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25865.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25865):map__25865);
var grid = cljs.core.get.call(null,map__25865__$1,new cljs.core.Keyword(null,"grid","grid",402978600));
var dataview = cljs.core.get.call(null,map__25865__$1,new cljs.core.Keyword(null,"dataview","dataview",91765671));
if(cljs.core.not_EQ_.call(null,old_data,new_data)){
if(cljs.core.empty_QMARK_.call(null,old_data)){
var temp__4657__auto__ = hatti.views.table.init_grid_BANG_.call(null,new_data,self__.owner,self__.slick_grid_event_handlers);
if(cljs.core.truth_(temp__4657__auto__)){
var vec__25867 = temp__4657__auto__;
var grid__$1 = cljs.core.nth.call(null,vec__25867,(0),null);
var dataview__$1 = cljs.core.nth.call(null,vec__25867,(1),null);
return hatti.views.table.handle_table_events.call(null,self__.cursor,grid__$1,dataview__$1);
} else {
return null;
}
} else {
grid.invalidateAllRows();

dataview.setItems(cljs.core.clj__GT_js.call(null,new_data),hatti.constants._id);

return grid.render();
}
} else {
return null;
}
} else {
return null;
}
});})(active_QMARK_,map__25840,map__25840__$1,cursor,map__25841,map__25841__$1,active,map__25842,map__25842__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table25846.getBasis = ((function (active_QMARK_,map__25840,map__25840__$1,cursor,map__25841,map__25841__$1,active,map__25842,map__25842__$1,opts,slick_grid_event_handlers){
return (function (){
return new cljs.core.PersistentVector(null, 12, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"map__25842","map__25842",1463074722,null),new cljs.core.Symbol(null,"map__25841","map__25841",1450863586,null),new cljs.core.Symbol(null,"owner","owner",1247919588,null),new cljs.core.Symbol(null,"active?","active?",2100031303,null),new cljs.core.Symbol(null,"slick-grid-event-handlers","slick-grid-event-handlers",-664401045,null),new cljs.core.Symbol(null,"map__25840","map__25840",-1205999630,null),new cljs.core.Symbol(null,"cursor","cursor",-1642498285,null),new cljs.core.Symbol(null,"active","active",-758473701,null),new cljs.core.Symbol(null,"p__25838","p__25838",1554569692,null),new cljs.core.Symbol(null,"opts","opts",1795607228,null),new cljs.core.Symbol(null,"p__25839","p__25839",1453302495,null),new cljs.core.Symbol(null,"meta25847","meta25847",420713292,null)], null);
});})(active_QMARK_,map__25840,map__25840__$1,cursor,map__25841,map__25841__$1,active,map__25842,map__25842__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table25846.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table25846.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table25846";

hatti.views.table.t_hatti$views$table25846.cljs$lang$ctorPrWriter = ((function (active_QMARK_,map__25840,map__25840__$1,cursor,map__25841,map__25841__$1,active,map__25842,map__25842__$1,opts,slick_grid_event_handlers){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"hatti.views.table/t_hatti$views$table25846");
});})(active_QMARK_,map__25840,map__25840__$1,cursor,map__25841,map__25841__$1,active,map__25842,map__25842__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.__GT_t_hatti$views$table25846 = ((function (active_QMARK_,map__25840,map__25840__$1,cursor,map__25841,map__25841__$1,active,map__25842,map__25842__$1,opts,slick_grid_event_handlers){
return (function hatti$views$table$__GT_t_hatti$views$table25846(map__25842__$2,map__25841__$2,owner__$1,active_QMARK___$1,slick_grid_event_handlers__$1,map__25840__$2,cursor__$1,active__$1,p__25838__$1,opts__$1,p__25839__$1,meta25847){
return (new hatti.views.table.t_hatti$views$table25846(map__25842__$2,map__25841__$2,owner__$1,active_QMARK___$1,slick_grid_event_handlers__$1,map__25840__$2,cursor__$1,active__$1,p__25838__$1,opts__$1,p__25839__$1,meta25847));
});})(active_QMARK_,map__25840,map__25840__$1,cursor,map__25841,map__25841__$1,active,map__25842,map__25842__$1,opts,slick_grid_event_handlers))
;

}

return (new hatti.views.table.t_hatti$views$table25846(map__25842__$1,map__25841__$1,owner,active_QMARK_,slick_grid_event_handlers,map__25840__$1,cursor,active,p__25838,opts,p__25839,cljs.core.PersistentArrayMap.EMPTY));
}));
