// Compiled by ClojureScript 1.9.229 {}
goog.provide('milia.utils.remote');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('chimera.urls');
/**
 * Store credentials used to authenticate API requests.
 * Based on existence in this atom credentials will be tried in top down order.
 */
milia.utils.remote._STAR_credentials_STAR_ = new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"temp-token","temp-token",2129400071),null,new cljs.core.Keyword(null,"token","token",-1211463215),null,new cljs.core.Keyword(null,"username","username",1605666410),null,new cljs.core.Keyword(null,"password","password",417022471),null], null);
milia.utils.remote.invalid_token_msg = "Invalid token";
milia.utils.remote.token_expired_msg = "Token expired";
milia.utils.remote.bad_token_msgs = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [milia.utils.remote.invalid_token_msg,milia.utils.remote.token_expired_msg], null);
/**
 * Store remote hosts that requests are made to.
 */
milia.utils.remote.hosts = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"client","client",-1323448117),"zebra.ona.io",new cljs.core.Keyword(null,"data","data",-232669377),"stage-api.ona.io",new cljs.core.Keyword(null,"j2x","j2x",2112415912),"j2x.ona.io",new cljs.core.Keyword(null,"request-protocol","request-protocol",1273151787),"https"], null));
/**
 * Store customizable timeouts to use in the http libraries. In milliseconds.
 */
milia.utils.remote.timeouts = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"conn-timeout","conn-timeout",2119298951),(30000),new cljs.core.Keyword(null,"socket-timeout","socket-timeout",-877740564),(30000)], null));
/**
 * Swap values into hosts atom, requires data-host, other args are option but
 * must be provided in order. If an option arg is nil it is ignored, and not
 * swapped into hosts.
 * 
 * Built to support setting hosts from JavaScript.
 */
milia.utils.remote.set_hosts = (function milia$utils$remote$set_hosts(var_args){
var args__7491__auto__ = [];
var len__7484__auto___22710 = arguments.length;
var i__7485__auto___22711 = (0);
while(true){
if((i__7485__auto___22711 < len__7484__auto___22710)){
args__7491__auto__.push((arguments[i__7485__auto___22711]));

var G__22712 = (i__7485__auto___22711 + (1));
i__7485__auto___22711 = G__22712;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return milia.utils.remote.set_hosts.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});
goog.exportSymbol('milia.utils.remote.set_hosts', milia.utils.remote.set_hosts);

milia.utils.remote.set_hosts.cljs$core$IFn$_invoke$arity$variadic = (function (data_host,p__22705){
var vec__22706 = p__22705;
var client_host = cljs.core.nth.call(null,vec__22706,(0),null);
var j2x_host = cljs.core.nth.call(null,vec__22706,(1),null);
var request_protocol = cljs.core.nth.call(null,vec__22706,(2),null);
return cljs.core.swap_BANG_.call(null,milia.utils.remote.hosts,cljs.core.merge,(function (){var G__22709 = new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"data","data",-232669377),data_host], null);
var G__22709__$1 = ((cljs.core.some_QMARK_.call(null,client_host))?cljs.core.assoc.call(null,G__22709,new cljs.core.Keyword(null,"client","client",-1323448117),client_host):G__22709);
var G__22709__$2 = ((cljs.core.some_QMARK_.call(null,j2x_host))?cljs.core.assoc.call(null,G__22709__$1,new cljs.core.Keyword(null,"j2x","j2x",2112415912),j2x_host):G__22709__$1);
if(cljs.core.some_QMARK_.call(null,request_protocol)){
return cljs.core.assoc.call(null,G__22709__$2,new cljs.core.Keyword(null,"request-protocol","request-protocol",1273151787),request_protocol);
} else {
return G__22709__$2;
}
})());
});

milia.utils.remote.set_hosts.cljs$lang$maxFixedArity = (1);

milia.utils.remote.set_hosts.cljs$lang$applyTo = (function (seq22703){
var G__22704 = cljs.core.first.call(null,seq22703);
var seq22703__$1 = cljs.core.next.call(null,seq22703);
return milia.utils.remote.set_hosts.cljs$core$IFn$_invoke$arity$variadic(G__22704,seq22703__$1);
});

/**
 * Set the dynamic credentials to include the username and optionally
 * any other arguments that are passed. If an argument is nil or not passed
 * it will be set to nil in the credentials.
 * 
 * Calling this from Clojure will break if not done from within a previous
 * binding of the *credentials* variable.
 * 
 * Built to support setting hosts from JavaScript.
 */
milia.utils.remote.set_credentials = (function milia$utils$remote$set_credentials(var_args){
var args__7491__auto__ = [];
var len__7484__auto___22719 = arguments.length;
var i__7485__auto___22720 = (0);
while(true){
if((i__7485__auto___22720 < len__7484__auto___22719)){
args__7491__auto__.push((arguments[i__7485__auto___22720]));

var G__22721 = (i__7485__auto___22720 + (1));
i__7485__auto___22720 = G__22721;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return milia.utils.remote.set_credentials.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});
goog.exportSymbol('milia.utils.remote.set_credentials', milia.utils.remote.set_credentials);

milia.utils.remote.set_credentials.cljs$core$IFn$_invoke$arity$variadic = (function (username,p__22715){
var vec__22716 = p__22715;
var password = cljs.core.nth.call(null,vec__22716,(0),null);
var temp_token = cljs.core.nth.call(null,vec__22716,(1),null);
var token = cljs.core.nth.call(null,vec__22716,(2),null);
return milia.utils.remote._STAR_credentials_STAR_ = new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"username","username",1605666410),username,new cljs.core.Keyword(null,"password","password",417022471),password,new cljs.core.Keyword(null,"temp-token","temp-token",2129400071),temp_token,new cljs.core.Keyword(null,"token","token",-1211463215),token], null);
});

milia.utils.remote.set_credentials.cljs$lang$maxFixedArity = (1);

milia.utils.remote.set_credentials.cljs$lang$applyTo = (function (seq22713){
var G__22714 = cljs.core.first.call(null,seq22713);
var seq22713__$1 = cljs.core.next.call(null,seq22713);
return milia.utils.remote.set_credentials.cljs$core$IFn$_invoke$arity$variadic(G__22714,seq22713__$1);
});

/**
 * Prefix the resources with the protocol and format strings.
 */
milia.utils.remote.protocol_prefixed = (function milia$utils$remote$protocol_prefixed(resources){
return clojure.string.join.call(null,cljs.core.flatten.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"request-protocol","request-protocol",1273151787).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,milia.utils.remote.hosts)),"://",resources], null)));
});
milia.utils.remote.thumbor_host = "images.ona.io";
milia.utils.remote.thumbor_server = milia.utils.remote.protocol_prefixed.call(null,milia.utils.remote.thumbor_host);
milia.utils.remote.url_join = (function milia$utils$remote$url_join(host,args){
return clojure.string.join.call(null,cljs.core.conj.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [host], null),cljs.core.apply.call(null,chimera.urls.url,args)));
});
/**
 * Build an API url.
 */
milia.utils.remote.make_url = (function milia$utils$remote$make_url(var_args){
var args__7491__auto__ = [];
var len__7484__auto___22723 = arguments.length;
var i__7485__auto___22724 = (0);
while(true){
if((i__7485__auto___22724 < len__7484__auto___22723)){
args__7491__auto__.push((arguments[i__7485__auto___22724]));

var G__22725 = (i__7485__auto___22724 + (1));
i__7485__auto___22724 = G__22725;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((0) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((0)),(0),null)):null);
return milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(argseq__7492__auto__);
});

milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic = (function (postfix){
return milia.utils.remote.url_join.call(null,[cljs.core.str(milia.utils.remote.protocol_prefixed.call(null,new cljs.core.Keyword(null,"data","data",-232669377).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,milia.utils.remote.hosts)))),cljs.core.str("/api/v1")].join(''),postfix);
});

milia.utils.remote.make_url.cljs$lang$maxFixedArity = (0);

milia.utils.remote.make_url.cljs$lang$applyTo = (function (seq22722){
return milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq22722));
});

/**
 * Build a URL pointing to the client.
 */
milia.utils.remote.make_client_url = (function milia$utils$remote$make_client_url(var_args){
var args__7491__auto__ = [];
var len__7484__auto___22727 = arguments.length;
var i__7485__auto___22728 = (0);
while(true){
if((i__7485__auto___22728 < len__7484__auto___22727)){
args__7491__auto__.push((arguments[i__7485__auto___22728]));

var G__22729 = (i__7485__auto___22728 + (1));
i__7485__auto___22728 = G__22729;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((0) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((0)),(0),null)):null);
return milia.utils.remote.make_client_url.cljs$core$IFn$_invoke$arity$variadic(argseq__7492__auto__);
});

milia.utils.remote.make_client_url.cljs$core$IFn$_invoke$arity$variadic = (function (postfix){
var client_host = ((window["location"])["origin"]);
return milia.utils.remote.url_join.call(null,client_host,postfix);
});

milia.utils.remote.make_client_url.cljs$lang$maxFixedArity = (0);

milia.utils.remote.make_client_url.cljs$lang$applyTo = (function (seq22726){
return milia.utils.remote.make_client_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq22726));
});

/**
 * Like make-url, but ensures an ending in .json
 */
milia.utils.remote.make_json_url = (function milia$utils$remote$make_json_url(var_args){
var args__7491__auto__ = [];
var len__7484__auto___22731 = arguments.length;
var i__7485__auto___22732 = (0);
while(true){
if((i__7485__auto___22732 < len__7484__auto___22731)){
args__7491__auto__.push((arguments[i__7485__auto___22732]));

var G__22733 = (i__7485__auto___22732 + (1));
i__7485__auto___22732 = G__22733;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((0) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((0)),(0),null)):null);
return milia.utils.remote.make_json_url.cljs$core$IFn$_invoke$arity$variadic(argseq__7492__auto__);
});

milia.utils.remote.make_json_url.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return [cljs.core.str(cljs.core.apply.call(null,milia.utils.remote.make_url,args)),cljs.core.str(".json")].join('');
});

milia.utils.remote.make_json_url.cljs$lang$maxFixedArity = (0);

milia.utils.remote.make_json_url.cljs$lang$applyTo = (function (seq22730){
return milia.utils.remote.make_json_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq22730));
});

/**
 * Build an API url.
 */
milia.utils.remote.make_j2x_url = (function milia$utils$remote$make_j2x_url(var_args){
var args__7491__auto__ = [];
var len__7484__auto___22735 = arguments.length;
var i__7485__auto___22736 = (0);
while(true){
if((i__7485__auto___22736 < len__7484__auto___22735)){
args__7491__auto__.push((arguments[i__7485__auto___22736]));

var G__22737 = (i__7485__auto___22736 + (1));
i__7485__auto___22736 = G__22737;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((0) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((0)),(0),null)):null);
return milia.utils.remote.make_j2x_url.cljs$core$IFn$_invoke$arity$variadic(argseq__7492__auto__);
});

milia.utils.remote.make_j2x_url.cljs$core$IFn$_invoke$arity$variadic = (function (postfix){
return milia.utils.remote.url_join.call(null,milia.utils.remote.protocol_prefixed.call(null,new cljs.core.Keyword(null,"j2x","j2x",2112415912).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,milia.utils.remote.hosts))),postfix);
});

milia.utils.remote.make_j2x_url.cljs$lang$maxFixedArity = (0);

milia.utils.remote.make_j2x_url.cljs$lang$applyTo = (function (seq22734){
return milia.utils.remote.make_j2x_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq22734));
});

