// Compiled by ClojureScript 1.9.229 {}
goog.provide('sablono.core');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('clojure.walk');
goog.require('sablono.util');
goog.require('sablono.interpreter');
goog.require('goog.dom');
/**
 * Add an optional attribute argument to a function that returns a element vector.
 */
sablono.core.wrap_attrs = (function sablono$core$wrap_attrs(func){
return (function() { 
var G__19445__delegate = function (args){
if(cljs.core.map_QMARK_.call(null,cljs.core.first.call(null,args))){
var vec__19442 = cljs.core.apply.call(null,func,cljs.core.rest.call(null,args));
var seq__19443 = cljs.core.seq.call(null,vec__19442);
var first__19444 = cljs.core.first.call(null,seq__19443);
var seq__19443__$1 = cljs.core.next.call(null,seq__19443);
var tag = first__19444;
var body = seq__19443__$1;
if(cljs.core.map_QMARK_.call(null,cljs.core.first.call(null,body))){
return cljs.core.apply.call(null,cljs.core.vector,tag,cljs.core.merge.call(null,cljs.core.first.call(null,body),cljs.core.first.call(null,args)),cljs.core.rest.call(null,body));
} else {
return cljs.core.apply.call(null,cljs.core.vector,tag,cljs.core.first.call(null,args),body);
}
} else {
return cljs.core.apply.call(null,func,args);
}
};
var G__19445 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__19446__i = 0, G__19446__a = new Array(arguments.length -  0);
while (G__19446__i < G__19446__a.length) {G__19446__a[G__19446__i] = arguments[G__19446__i + 0]; ++G__19446__i;}
  args = new cljs.core.IndexedSeq(G__19446__a,0);
} 
return G__19445__delegate.call(this,args);};
G__19445.cljs$lang$maxFixedArity = 0;
G__19445.cljs$lang$applyTo = (function (arglist__19447){
var args = cljs.core.seq(arglist__19447);
return G__19445__delegate(args);
});
G__19445.cljs$core$IFn$_invoke$arity$variadic = G__19445__delegate;
return G__19445;
})()
;
});
sablono.core.update_arglists = (function sablono$core$update_arglists(arglists){
var iter__7189__auto__ = (function sablono$core$update_arglists_$_iter__19452(s__19453){
return (new cljs.core.LazySeq(null,(function (){
var s__19453__$1 = s__19453;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__19453__$1);
if(temp__4657__auto__){
var s__19453__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__19453__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__19453__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__19455 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__19454 = (0);
while(true){
if((i__19454 < size__7188__auto__)){
var args = cljs.core._nth.call(null,c__7187__auto__,i__19454);
cljs.core.chunk_append.call(null,b__19455,cljs.core.vec.call(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"attr-map?","attr-map?",116307443,null),args)));

var G__19456 = (i__19454 + (1));
i__19454 = G__19456;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__19455),sablono$core$update_arglists_$_iter__19452.call(null,cljs.core.chunk_rest.call(null,s__19453__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__19455),null);
}
} else {
var args = cljs.core.first.call(null,s__19453__$2);
return cljs.core.cons.call(null,cljs.core.vec.call(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"attr-map?","attr-map?",116307443,null),args)),sablono$core$update_arglists_$_iter__19452.call(null,cljs.core.rest.call(null,s__19453__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__.call(null,arglists);
});
/**
 * Render `element` as HTML string.
 */
sablono.core.render = (function sablono$core$render(element){
if(cljs.core.truth_(element)){
return React.renderToString(element);
} else {
return null;
}
});
/**
 * Render `element` as HTML string, without React internal attributes.
 */
sablono.core.render_static = (function sablono$core$render_static(element){
if(cljs.core.truth_(element)){
return React.renderToStaticMarkup(element);
} else {
return null;
}
});
/**
 * Include a list of external stylesheet files.
 */
sablono.core.include_css = (function sablono$core$include_css(var_args){
var args__7491__auto__ = [];
var len__7484__auto___19462 = arguments.length;
var i__7485__auto___19463 = (0);
while(true){
if((i__7485__auto___19463 < len__7484__auto___19462)){
args__7491__auto__.push((arguments[i__7485__auto___19463]));

var G__19464 = (i__7485__auto___19463 + (1));
i__7485__auto___19463 = G__19464;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((0) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((0)),(0),null)):null);
return sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic(argseq__7492__auto__);
});

sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic = (function (styles){
var iter__7189__auto__ = (function sablono$core$iter__19458(s__19459){
return (new cljs.core.LazySeq(null,(function (){
var s__19459__$1 = s__19459;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__19459__$1);
if(temp__4657__auto__){
var s__19459__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__19459__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__19459__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__19461 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__19460 = (0);
while(true){
if((i__19460 < size__7188__auto__)){
var style = cljs.core._nth.call(null,c__7187__auto__,i__19460);
cljs.core.chunk_append.call(null,b__19461,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"link","link",-1769163468),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"text/css",new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,style),new cljs.core.Keyword(null,"rel","rel",1378823488),"stylesheet"], null)], null));

var G__19465 = (i__19460 + (1));
i__19460 = G__19465;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__19461),sablono$core$iter__19458.call(null,cljs.core.chunk_rest.call(null,s__19459__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__19461),null);
}
} else {
var style = cljs.core.first.call(null,s__19459__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"link","link",-1769163468),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"text/css",new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,style),new cljs.core.Keyword(null,"rel","rel",1378823488),"stylesheet"], null)], null),sablono$core$iter__19458.call(null,cljs.core.rest.call(null,s__19459__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__.call(null,styles);
});

sablono.core.include_css.cljs$lang$maxFixedArity = (0);

sablono.core.include_css.cljs$lang$applyTo = (function (seq19457){
return sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq19457));
});

/**
 * Include the JavaScript library at `src`.
 */
sablono.core.include_js = (function sablono$core$include_js(src){
return goog.dom.appendChild(goog.dom.getDocument().body,goog.dom.createDom("script",({"src": src})));
});
/**
 * Include Facebook's React JavaScript library.
 */
sablono.core.include_react = (function sablono$core$include_react(){
return sablono.core.include_js.call(null,"http://fb.me/react-0.12.2.js");
});
/**
 * Wraps some content in a HTML hyperlink with the supplied URL.
 */
sablono.core.link_to19466 = (function sablono$core$link_to19466(var_args){
var args__7491__auto__ = [];
var len__7484__auto___19469 = arguments.length;
var i__7485__auto___19470 = (0);
while(true){
if((i__7485__auto___19470 < len__7484__auto___19469)){
args__7491__auto__.push((arguments[i__7485__auto___19470]));

var G__19471 = (i__7485__auto___19470 + (1));
i__7485__auto___19470 = G__19471;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return sablono.core.link_to19466.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

sablono.core.link_to19466.cljs$core$IFn$_invoke$arity$variadic = (function (url,content){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,url)], null),content], null);
});

sablono.core.link_to19466.cljs$lang$maxFixedArity = (1);

sablono.core.link_to19466.cljs$lang$applyTo = (function (seq19467){
var G__19468 = cljs.core.first.call(null,seq19467);
var seq19467__$1 = cljs.core.next.call(null,seq19467);
return sablono.core.link_to19466.cljs$core$IFn$_invoke$arity$variadic(G__19468,seq19467__$1);
});


sablono.core.link_to = sablono.core.wrap_attrs.call(null,sablono.core.link_to19466);
/**
 * Wraps some content in a HTML hyperlink with the supplied e-mail
 *   address. If no content provided use the e-mail address as content.
 */
sablono.core.mail_to19472 = (function sablono$core$mail_to19472(var_args){
var args__7491__auto__ = [];
var len__7484__auto___19479 = arguments.length;
var i__7485__auto___19480 = (0);
while(true){
if((i__7485__auto___19480 < len__7484__auto___19479)){
args__7491__auto__.push((arguments[i__7485__auto___19480]));

var G__19481 = (i__7485__auto___19480 + (1));
i__7485__auto___19480 = G__19481;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return sablono.core.mail_to19472.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

sablono.core.mail_to19472.cljs$core$IFn$_invoke$arity$variadic = (function (e_mail,p__19475){
var vec__19476 = p__19475;
var content = cljs.core.nth.call(null,vec__19476,(0),null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",-793805698),[cljs.core.str("mailto:"),cljs.core.str(e_mail)].join('')], null),(function (){var or__6409__auto__ = content;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return e_mail;
}
})()], null);
});

sablono.core.mail_to19472.cljs$lang$maxFixedArity = (1);

sablono.core.mail_to19472.cljs$lang$applyTo = (function (seq19473){
var G__19474 = cljs.core.first.call(null,seq19473);
var seq19473__$1 = cljs.core.next.call(null,seq19473);
return sablono.core.mail_to19472.cljs$core$IFn$_invoke$arity$variadic(G__19474,seq19473__$1);
});


sablono.core.mail_to = sablono.core.wrap_attrs.call(null,sablono.core.mail_to19472);
/**
 * Wrap a collection in an unordered list.
 */
sablono.core.unordered_list19482 = (function sablono$core$unordered_list19482(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ul","ul",-1349521403),(function (){var iter__7189__auto__ = (function sablono$core$unordered_list19482_$_iter__19487(s__19488){
return (new cljs.core.LazySeq(null,(function (){
var s__19488__$1 = s__19488;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__19488__$1);
if(temp__4657__auto__){
var s__19488__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__19488__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__19488__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__19490 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__19489 = (0);
while(true){
if((i__19489 < size__7188__auto__)){
var x = cljs.core._nth.call(null,c__7187__auto__,i__19489);
cljs.core.chunk_append.call(null,b__19490,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null));

var G__19491 = (i__19489 + (1));
i__19489 = G__19491;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__19490),sablono$core$unordered_list19482_$_iter__19487.call(null,cljs.core.chunk_rest.call(null,s__19488__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__19490),null);
}
} else {
var x = cljs.core.first.call(null,s__19488__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null),sablono$core$unordered_list19482_$_iter__19487.call(null,cljs.core.rest.call(null,s__19488__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__.call(null,coll);
})()], null);
});

sablono.core.unordered_list = sablono.core.wrap_attrs.call(null,sablono.core.unordered_list19482);
/**
 * Wrap a collection in an ordered list.
 */
sablono.core.ordered_list19492 = (function sablono$core$ordered_list19492(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ol","ol",932524051),(function (){var iter__7189__auto__ = (function sablono$core$ordered_list19492_$_iter__19497(s__19498){
return (new cljs.core.LazySeq(null,(function (){
var s__19498__$1 = s__19498;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__19498__$1);
if(temp__4657__auto__){
var s__19498__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__19498__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__19498__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__19500 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__19499 = (0);
while(true){
if((i__19499 < size__7188__auto__)){
var x = cljs.core._nth.call(null,c__7187__auto__,i__19499);
cljs.core.chunk_append.call(null,b__19500,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null));

var G__19501 = (i__19499 + (1));
i__19499 = G__19501;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__19500),sablono$core$ordered_list19492_$_iter__19497.call(null,cljs.core.chunk_rest.call(null,s__19498__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__19500),null);
}
} else {
var x = cljs.core.first.call(null,s__19498__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null),sablono$core$ordered_list19492_$_iter__19497.call(null,cljs.core.rest.call(null,s__19498__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__.call(null,coll);
})()], null);
});

sablono.core.ordered_list = sablono.core.wrap_attrs.call(null,sablono.core.ordered_list19492);
/**
 * Create an image element.
 */
sablono.core.image19502 = (function sablono$core$image19502(var_args){
var args19503 = [];
var len__7484__auto___19506 = arguments.length;
var i__7485__auto___19507 = (0);
while(true){
if((i__7485__auto___19507 < len__7484__auto___19506)){
args19503.push((arguments[i__7485__auto___19507]));

var G__19508 = (i__7485__auto___19507 + (1));
i__7485__auto___19507 = G__19508;
continue;
} else {
}
break;
}

var G__19505 = args19503.length;
switch (G__19505) {
case 1:
return sablono.core.image19502.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.image19502.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19503.length)].join('')));

}
});

sablono.core.image19502.cljs$core$IFn$_invoke$arity$1 = (function (src){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"img","img",1442687358),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"src","src",-1651076051),sablono.util.as_str.call(null,src)], null)], null);
});

sablono.core.image19502.cljs$core$IFn$_invoke$arity$2 = (function (src,alt){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"img","img",1442687358),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"src","src",-1651076051),sablono.util.as_str.call(null,src),new cljs.core.Keyword(null,"alt","alt",-3214426),alt], null)], null);
});

sablono.core.image19502.cljs$lang$maxFixedArity = 2;


sablono.core.image = sablono.core.wrap_attrs.call(null,sablono.core.image19502);
sablono.core._STAR_group_STAR_ = cljs.core.PersistentVector.EMPTY;
/**
 * Create a field name from the supplied argument the current field group.
 */
sablono.core.make_name = (function sablono$core$make_name(name){
return cljs.core.reduce.call(null,(function (p1__19510_SHARP_,p2__19511_SHARP_){
return [cljs.core.str(p1__19510_SHARP_),cljs.core.str("["),cljs.core.str(p2__19511_SHARP_),cljs.core.str("]")].join('');
}),cljs.core.conj.call(null,sablono.core._STAR_group_STAR_,sablono.util.as_str.call(null,name)));
});
/**
 * Create a field id from the supplied argument and current field group.
 */
sablono.core.make_id = (function sablono$core$make_id(name){
return cljs.core.reduce.call(null,(function (p1__19512_SHARP_,p2__19513_SHARP_){
return [cljs.core.str(p1__19512_SHARP_),cljs.core.str("-"),cljs.core.str(p2__19513_SHARP_)].join('');
}),cljs.core.conj.call(null,sablono.core._STAR_group_STAR_,sablono.util.as_str.call(null,name)));
});
/**
 * Creates a new <input> element.
 */
sablono.core.input_field_STAR_ = (function sablono$core$input_field_STAR_(type,name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),type,new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),value], null)], null);
});
/**
 * Creates a color input field.
 */
sablono.core.color_field19514 = (function sablono$core$color_field19514(var_args){
var args19515 = [];
var len__7484__auto___19582 = arguments.length;
var i__7485__auto___19583 = (0);
while(true){
if((i__7485__auto___19583 < len__7484__auto___19582)){
args19515.push((arguments[i__7485__auto___19583]));

var G__19584 = (i__7485__auto___19583 + (1));
i__7485__auto___19583 = G__19584;
continue;
} else {
}
break;
}

var G__19517 = args19515.length;
switch (G__19517) {
case 1:
return sablono.core.color_field19514.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.color_field19514.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19515.length)].join('')));

}
});

sablono.core.color_field19514.cljs$core$IFn$_invoke$arity$1 = (function (name__19359__auto__){
return sablono.core.color_field19514.call(null,name__19359__auto__,null);
});

sablono.core.color_field19514.cljs$core$IFn$_invoke$arity$2 = (function (name__19359__auto__,value__19360__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"color","color",-1642760596,null))].join(''),name__19359__auto__,value__19360__auto__);
});

sablono.core.color_field19514.cljs$lang$maxFixedArity = 2;


sablono.core.color_field = sablono.core.wrap_attrs.call(null,sablono.core.color_field19514);

/**
 * Creates a date input field.
 */
sablono.core.date_field19518 = (function sablono$core$date_field19518(var_args){
var args19519 = [];
var len__7484__auto___19586 = arguments.length;
var i__7485__auto___19587 = (0);
while(true){
if((i__7485__auto___19587 < len__7484__auto___19586)){
args19519.push((arguments[i__7485__auto___19587]));

var G__19588 = (i__7485__auto___19587 + (1));
i__7485__auto___19587 = G__19588;
continue;
} else {
}
break;
}

var G__19521 = args19519.length;
switch (G__19521) {
case 1:
return sablono.core.date_field19518.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.date_field19518.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19519.length)].join('')));

}
});

sablono.core.date_field19518.cljs$core$IFn$_invoke$arity$1 = (function (name__19359__auto__){
return sablono.core.date_field19518.call(null,name__19359__auto__,null);
});

sablono.core.date_field19518.cljs$core$IFn$_invoke$arity$2 = (function (name__19359__auto__,value__19360__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"date","date",177097065,null))].join(''),name__19359__auto__,value__19360__auto__);
});

sablono.core.date_field19518.cljs$lang$maxFixedArity = 2;


sablono.core.date_field = sablono.core.wrap_attrs.call(null,sablono.core.date_field19518);

/**
 * Creates a datetime input field.
 */
sablono.core.datetime_field19522 = (function sablono$core$datetime_field19522(var_args){
var args19523 = [];
var len__7484__auto___19590 = arguments.length;
var i__7485__auto___19591 = (0);
while(true){
if((i__7485__auto___19591 < len__7484__auto___19590)){
args19523.push((arguments[i__7485__auto___19591]));

var G__19592 = (i__7485__auto___19591 + (1));
i__7485__auto___19591 = G__19592;
continue;
} else {
}
break;
}

var G__19525 = args19523.length;
switch (G__19525) {
case 1:
return sablono.core.datetime_field19522.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_field19522.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19523.length)].join('')));

}
});

sablono.core.datetime_field19522.cljs$core$IFn$_invoke$arity$1 = (function (name__19359__auto__){
return sablono.core.datetime_field19522.call(null,name__19359__auto__,null);
});

sablono.core.datetime_field19522.cljs$core$IFn$_invoke$arity$2 = (function (name__19359__auto__,value__19360__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"datetime","datetime",2135207229,null))].join(''),name__19359__auto__,value__19360__auto__);
});

sablono.core.datetime_field19522.cljs$lang$maxFixedArity = 2;


sablono.core.datetime_field = sablono.core.wrap_attrs.call(null,sablono.core.datetime_field19522);

/**
 * Creates a datetime-local input field.
 */
sablono.core.datetime_local_field19526 = (function sablono$core$datetime_local_field19526(var_args){
var args19527 = [];
var len__7484__auto___19594 = arguments.length;
var i__7485__auto___19595 = (0);
while(true){
if((i__7485__auto___19595 < len__7484__auto___19594)){
args19527.push((arguments[i__7485__auto___19595]));

var G__19596 = (i__7485__auto___19595 + (1));
i__7485__auto___19595 = G__19596;
continue;
} else {
}
break;
}

var G__19529 = args19527.length;
switch (G__19529) {
case 1:
return sablono.core.datetime_local_field19526.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_local_field19526.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19527.length)].join('')));

}
});

sablono.core.datetime_local_field19526.cljs$core$IFn$_invoke$arity$1 = (function (name__19359__auto__){
return sablono.core.datetime_local_field19526.call(null,name__19359__auto__,null);
});

sablono.core.datetime_local_field19526.cljs$core$IFn$_invoke$arity$2 = (function (name__19359__auto__,value__19360__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"datetime-local","datetime-local",-507312697,null))].join(''),name__19359__auto__,value__19360__auto__);
});

sablono.core.datetime_local_field19526.cljs$lang$maxFixedArity = 2;


sablono.core.datetime_local_field = sablono.core.wrap_attrs.call(null,sablono.core.datetime_local_field19526);

/**
 * Creates a email input field.
 */
sablono.core.email_field19530 = (function sablono$core$email_field19530(var_args){
var args19531 = [];
var len__7484__auto___19598 = arguments.length;
var i__7485__auto___19599 = (0);
while(true){
if((i__7485__auto___19599 < len__7484__auto___19598)){
args19531.push((arguments[i__7485__auto___19599]));

var G__19600 = (i__7485__auto___19599 + (1));
i__7485__auto___19599 = G__19600;
continue;
} else {
}
break;
}

var G__19533 = args19531.length;
switch (G__19533) {
case 1:
return sablono.core.email_field19530.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.email_field19530.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19531.length)].join('')));

}
});

sablono.core.email_field19530.cljs$core$IFn$_invoke$arity$1 = (function (name__19359__auto__){
return sablono.core.email_field19530.call(null,name__19359__auto__,null);
});

sablono.core.email_field19530.cljs$core$IFn$_invoke$arity$2 = (function (name__19359__auto__,value__19360__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"email","email",-1238619063,null))].join(''),name__19359__auto__,value__19360__auto__);
});

sablono.core.email_field19530.cljs$lang$maxFixedArity = 2;


sablono.core.email_field = sablono.core.wrap_attrs.call(null,sablono.core.email_field19530);

/**
 * Creates a file input field.
 */
sablono.core.file_field19534 = (function sablono$core$file_field19534(var_args){
var args19535 = [];
var len__7484__auto___19602 = arguments.length;
var i__7485__auto___19603 = (0);
while(true){
if((i__7485__auto___19603 < len__7484__auto___19602)){
args19535.push((arguments[i__7485__auto___19603]));

var G__19604 = (i__7485__auto___19603 + (1));
i__7485__auto___19603 = G__19604;
continue;
} else {
}
break;
}

var G__19537 = args19535.length;
switch (G__19537) {
case 1:
return sablono.core.file_field19534.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.file_field19534.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19535.length)].join('')));

}
});

sablono.core.file_field19534.cljs$core$IFn$_invoke$arity$1 = (function (name__19359__auto__){
return sablono.core.file_field19534.call(null,name__19359__auto__,null);
});

sablono.core.file_field19534.cljs$core$IFn$_invoke$arity$2 = (function (name__19359__auto__,value__19360__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"file","file",370885649,null))].join(''),name__19359__auto__,value__19360__auto__);
});

sablono.core.file_field19534.cljs$lang$maxFixedArity = 2;


sablono.core.file_field = sablono.core.wrap_attrs.call(null,sablono.core.file_field19534);

/**
 * Creates a hidden input field.
 */
sablono.core.hidden_field19538 = (function sablono$core$hidden_field19538(var_args){
var args19539 = [];
var len__7484__auto___19606 = arguments.length;
var i__7485__auto___19607 = (0);
while(true){
if((i__7485__auto___19607 < len__7484__auto___19606)){
args19539.push((arguments[i__7485__auto___19607]));

var G__19608 = (i__7485__auto___19607 + (1));
i__7485__auto___19607 = G__19608;
continue;
} else {
}
break;
}

var G__19541 = args19539.length;
switch (G__19541) {
case 1:
return sablono.core.hidden_field19538.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.hidden_field19538.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19539.length)].join('')));

}
});

sablono.core.hidden_field19538.cljs$core$IFn$_invoke$arity$1 = (function (name__19359__auto__){
return sablono.core.hidden_field19538.call(null,name__19359__auto__,null);
});

sablono.core.hidden_field19538.cljs$core$IFn$_invoke$arity$2 = (function (name__19359__auto__,value__19360__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"hidden","hidden",1328025435,null))].join(''),name__19359__auto__,value__19360__auto__);
});

sablono.core.hidden_field19538.cljs$lang$maxFixedArity = 2;


sablono.core.hidden_field = sablono.core.wrap_attrs.call(null,sablono.core.hidden_field19538);

/**
 * Creates a month input field.
 */
sablono.core.month_field19542 = (function sablono$core$month_field19542(var_args){
var args19543 = [];
var len__7484__auto___19610 = arguments.length;
var i__7485__auto___19611 = (0);
while(true){
if((i__7485__auto___19611 < len__7484__auto___19610)){
args19543.push((arguments[i__7485__auto___19611]));

var G__19612 = (i__7485__auto___19611 + (1));
i__7485__auto___19611 = G__19612;
continue;
} else {
}
break;
}

var G__19545 = args19543.length;
switch (G__19545) {
case 1:
return sablono.core.month_field19542.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.month_field19542.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19543.length)].join('')));

}
});

sablono.core.month_field19542.cljs$core$IFn$_invoke$arity$1 = (function (name__19359__auto__){
return sablono.core.month_field19542.call(null,name__19359__auto__,null);
});

sablono.core.month_field19542.cljs$core$IFn$_invoke$arity$2 = (function (name__19359__auto__,value__19360__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"month","month",-319717006,null))].join(''),name__19359__auto__,value__19360__auto__);
});

sablono.core.month_field19542.cljs$lang$maxFixedArity = 2;


sablono.core.month_field = sablono.core.wrap_attrs.call(null,sablono.core.month_field19542);

/**
 * Creates a number input field.
 */
sablono.core.number_field19546 = (function sablono$core$number_field19546(var_args){
var args19547 = [];
var len__7484__auto___19614 = arguments.length;
var i__7485__auto___19615 = (0);
while(true){
if((i__7485__auto___19615 < len__7484__auto___19614)){
args19547.push((arguments[i__7485__auto___19615]));

var G__19616 = (i__7485__auto___19615 + (1));
i__7485__auto___19615 = G__19616;
continue;
} else {
}
break;
}

var G__19549 = args19547.length;
switch (G__19549) {
case 1:
return sablono.core.number_field19546.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.number_field19546.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19547.length)].join('')));

}
});

sablono.core.number_field19546.cljs$core$IFn$_invoke$arity$1 = (function (name__19359__auto__){
return sablono.core.number_field19546.call(null,name__19359__auto__,null);
});

sablono.core.number_field19546.cljs$core$IFn$_invoke$arity$2 = (function (name__19359__auto__,value__19360__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"number","number",-1084057331,null))].join(''),name__19359__auto__,value__19360__auto__);
});

sablono.core.number_field19546.cljs$lang$maxFixedArity = 2;


sablono.core.number_field = sablono.core.wrap_attrs.call(null,sablono.core.number_field19546);

/**
 * Creates a password input field.
 */
sablono.core.password_field19550 = (function sablono$core$password_field19550(var_args){
var args19551 = [];
var len__7484__auto___19618 = arguments.length;
var i__7485__auto___19619 = (0);
while(true){
if((i__7485__auto___19619 < len__7484__auto___19618)){
args19551.push((arguments[i__7485__auto___19619]));

var G__19620 = (i__7485__auto___19619 + (1));
i__7485__auto___19619 = G__19620;
continue;
} else {
}
break;
}

var G__19553 = args19551.length;
switch (G__19553) {
case 1:
return sablono.core.password_field19550.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.password_field19550.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19551.length)].join('')));

}
});

sablono.core.password_field19550.cljs$core$IFn$_invoke$arity$1 = (function (name__19359__auto__){
return sablono.core.password_field19550.call(null,name__19359__auto__,null);
});

sablono.core.password_field19550.cljs$core$IFn$_invoke$arity$2 = (function (name__19359__auto__,value__19360__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"password","password",2057553998,null))].join(''),name__19359__auto__,value__19360__auto__);
});

sablono.core.password_field19550.cljs$lang$maxFixedArity = 2;


sablono.core.password_field = sablono.core.wrap_attrs.call(null,sablono.core.password_field19550);

/**
 * Creates a range input field.
 */
sablono.core.range_field19554 = (function sablono$core$range_field19554(var_args){
var args19555 = [];
var len__7484__auto___19622 = arguments.length;
var i__7485__auto___19623 = (0);
while(true){
if((i__7485__auto___19623 < len__7484__auto___19622)){
args19555.push((arguments[i__7485__auto___19623]));

var G__19624 = (i__7485__auto___19623 + (1));
i__7485__auto___19623 = G__19624;
continue;
} else {
}
break;
}

var G__19557 = args19555.length;
switch (G__19557) {
case 1:
return sablono.core.range_field19554.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.range_field19554.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19555.length)].join('')));

}
});

sablono.core.range_field19554.cljs$core$IFn$_invoke$arity$1 = (function (name__19359__auto__){
return sablono.core.range_field19554.call(null,name__19359__auto__,null);
});

sablono.core.range_field19554.cljs$core$IFn$_invoke$arity$2 = (function (name__19359__auto__,value__19360__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"range","range",-1014743483,null))].join(''),name__19359__auto__,value__19360__auto__);
});

sablono.core.range_field19554.cljs$lang$maxFixedArity = 2;


sablono.core.range_field = sablono.core.wrap_attrs.call(null,sablono.core.range_field19554);

/**
 * Creates a search input field.
 */
sablono.core.search_field19558 = (function sablono$core$search_field19558(var_args){
var args19559 = [];
var len__7484__auto___19626 = arguments.length;
var i__7485__auto___19627 = (0);
while(true){
if((i__7485__auto___19627 < len__7484__auto___19626)){
args19559.push((arguments[i__7485__auto___19627]));

var G__19628 = (i__7485__auto___19627 + (1));
i__7485__auto___19627 = G__19628;
continue;
} else {
}
break;
}

var G__19561 = args19559.length;
switch (G__19561) {
case 1:
return sablono.core.search_field19558.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.search_field19558.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19559.length)].join('')));

}
});

sablono.core.search_field19558.cljs$core$IFn$_invoke$arity$1 = (function (name__19359__auto__){
return sablono.core.search_field19558.call(null,name__19359__auto__,null);
});

sablono.core.search_field19558.cljs$core$IFn$_invoke$arity$2 = (function (name__19359__auto__,value__19360__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"search","search",-1089495947,null))].join(''),name__19359__auto__,value__19360__auto__);
});

sablono.core.search_field19558.cljs$lang$maxFixedArity = 2;


sablono.core.search_field = sablono.core.wrap_attrs.call(null,sablono.core.search_field19558);

/**
 * Creates a tel input field.
 */
sablono.core.tel_field19562 = (function sablono$core$tel_field19562(var_args){
var args19563 = [];
var len__7484__auto___19630 = arguments.length;
var i__7485__auto___19631 = (0);
while(true){
if((i__7485__auto___19631 < len__7484__auto___19630)){
args19563.push((arguments[i__7485__auto___19631]));

var G__19632 = (i__7485__auto___19631 + (1));
i__7485__auto___19631 = G__19632;
continue;
} else {
}
break;
}

var G__19565 = args19563.length;
switch (G__19565) {
case 1:
return sablono.core.tel_field19562.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.tel_field19562.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19563.length)].join('')));

}
});

sablono.core.tel_field19562.cljs$core$IFn$_invoke$arity$1 = (function (name__19359__auto__){
return sablono.core.tel_field19562.call(null,name__19359__auto__,null);
});

sablono.core.tel_field19562.cljs$core$IFn$_invoke$arity$2 = (function (name__19359__auto__,value__19360__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"tel","tel",1864669686,null))].join(''),name__19359__auto__,value__19360__auto__);
});

sablono.core.tel_field19562.cljs$lang$maxFixedArity = 2;


sablono.core.tel_field = sablono.core.wrap_attrs.call(null,sablono.core.tel_field19562);

/**
 * Creates a text input field.
 */
sablono.core.text_field19566 = (function sablono$core$text_field19566(var_args){
var args19567 = [];
var len__7484__auto___19634 = arguments.length;
var i__7485__auto___19635 = (0);
while(true){
if((i__7485__auto___19635 < len__7484__auto___19634)){
args19567.push((arguments[i__7485__auto___19635]));

var G__19636 = (i__7485__auto___19635 + (1));
i__7485__auto___19635 = G__19636;
continue;
} else {
}
break;
}

var G__19569 = args19567.length;
switch (G__19569) {
case 1:
return sablono.core.text_field19566.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_field19566.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19567.length)].join('')));

}
});

sablono.core.text_field19566.cljs$core$IFn$_invoke$arity$1 = (function (name__19359__auto__){
return sablono.core.text_field19566.call(null,name__19359__auto__,null);
});

sablono.core.text_field19566.cljs$core$IFn$_invoke$arity$2 = (function (name__19359__auto__,value__19360__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"text","text",-150030170,null))].join(''),name__19359__auto__,value__19360__auto__);
});

sablono.core.text_field19566.cljs$lang$maxFixedArity = 2;


sablono.core.text_field = sablono.core.wrap_attrs.call(null,sablono.core.text_field19566);

/**
 * Creates a time input field.
 */
sablono.core.time_field19570 = (function sablono$core$time_field19570(var_args){
var args19571 = [];
var len__7484__auto___19638 = arguments.length;
var i__7485__auto___19639 = (0);
while(true){
if((i__7485__auto___19639 < len__7484__auto___19638)){
args19571.push((arguments[i__7485__auto___19639]));

var G__19640 = (i__7485__auto___19639 + (1));
i__7485__auto___19639 = G__19640;
continue;
} else {
}
break;
}

var G__19573 = args19571.length;
switch (G__19573) {
case 1:
return sablono.core.time_field19570.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.time_field19570.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19571.length)].join('')));

}
});

sablono.core.time_field19570.cljs$core$IFn$_invoke$arity$1 = (function (name__19359__auto__){
return sablono.core.time_field19570.call(null,name__19359__auto__,null);
});

sablono.core.time_field19570.cljs$core$IFn$_invoke$arity$2 = (function (name__19359__auto__,value__19360__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"time","time",-1268547887,null))].join(''),name__19359__auto__,value__19360__auto__);
});

sablono.core.time_field19570.cljs$lang$maxFixedArity = 2;


sablono.core.time_field = sablono.core.wrap_attrs.call(null,sablono.core.time_field19570);

/**
 * Creates a url input field.
 */
sablono.core.url_field19574 = (function sablono$core$url_field19574(var_args){
var args19575 = [];
var len__7484__auto___19642 = arguments.length;
var i__7485__auto___19643 = (0);
while(true){
if((i__7485__auto___19643 < len__7484__auto___19642)){
args19575.push((arguments[i__7485__auto___19643]));

var G__19644 = (i__7485__auto___19643 + (1));
i__7485__auto___19643 = G__19644;
continue;
} else {
}
break;
}

var G__19577 = args19575.length;
switch (G__19577) {
case 1:
return sablono.core.url_field19574.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.url_field19574.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19575.length)].join('')));

}
});

sablono.core.url_field19574.cljs$core$IFn$_invoke$arity$1 = (function (name__19359__auto__){
return sablono.core.url_field19574.call(null,name__19359__auto__,null);
});

sablono.core.url_field19574.cljs$core$IFn$_invoke$arity$2 = (function (name__19359__auto__,value__19360__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"url","url",1916828573,null))].join(''),name__19359__auto__,value__19360__auto__);
});

sablono.core.url_field19574.cljs$lang$maxFixedArity = 2;


sablono.core.url_field = sablono.core.wrap_attrs.call(null,sablono.core.url_field19574);

/**
 * Creates a week input field.
 */
sablono.core.week_field19578 = (function sablono$core$week_field19578(var_args){
var args19579 = [];
var len__7484__auto___19646 = arguments.length;
var i__7485__auto___19647 = (0);
while(true){
if((i__7485__auto___19647 < len__7484__auto___19646)){
args19579.push((arguments[i__7485__auto___19647]));

var G__19648 = (i__7485__auto___19647 + (1));
i__7485__auto___19647 = G__19648;
continue;
} else {
}
break;
}

var G__19581 = args19579.length;
switch (G__19581) {
case 1:
return sablono.core.week_field19578.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.week_field19578.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19579.length)].join('')));

}
});

sablono.core.week_field19578.cljs$core$IFn$_invoke$arity$1 = (function (name__19359__auto__){
return sablono.core.week_field19578.call(null,name__19359__auto__,null);
});

sablono.core.week_field19578.cljs$core$IFn$_invoke$arity$2 = (function (name__19359__auto__,value__19360__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"week","week",314058249,null))].join(''),name__19359__auto__,value__19360__auto__);
});

sablono.core.week_field19578.cljs$lang$maxFixedArity = 2;


sablono.core.week_field = sablono.core.wrap_attrs.call(null,sablono.core.week_field19578);
sablono.core.file_upload = sablono.core.file_field;
/**
 * Creates a check box.
 */
sablono.core.check_box19650 = (function sablono$core$check_box19650(var_args){
var args19651 = [];
var len__7484__auto___19654 = arguments.length;
var i__7485__auto___19655 = (0);
while(true){
if((i__7485__auto___19655 < len__7484__auto___19654)){
args19651.push((arguments[i__7485__auto___19655]));

var G__19656 = (i__7485__auto___19655 + (1));
i__7485__auto___19655 = G__19656;
continue;
} else {
}
break;
}

var G__19653 = args19651.length;
switch (G__19653) {
case 1:
return sablono.core.check_box19650.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.check_box19650.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.check_box19650.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19651.length)].join('')));

}
});

sablono.core.check_box19650.cljs$core$IFn$_invoke$arity$1 = (function (name){
return sablono.core.check_box19650.call(null,name,null);
});

sablono.core.check_box19650.cljs$core$IFn$_invoke$arity$2 = (function (name,checked_QMARK_){
return sablono.core.check_box19650.call(null,name,checked_QMARK_,"true");
});

sablono.core.check_box19650.cljs$core$IFn$_invoke$arity$3 = (function (name,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),"checkbox",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),value,new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_], null)], null);
});

sablono.core.check_box19650.cljs$lang$maxFixedArity = 3;


sablono.core.check_box = sablono.core.wrap_attrs.call(null,sablono.core.check_box19650);
/**
 * Creates a radio button.
 */
sablono.core.radio_button19658 = (function sablono$core$radio_button19658(var_args){
var args19659 = [];
var len__7484__auto___19662 = arguments.length;
var i__7485__auto___19663 = (0);
while(true){
if((i__7485__auto___19663 < len__7484__auto___19662)){
args19659.push((arguments[i__7485__auto___19663]));

var G__19664 = (i__7485__auto___19663 + (1));
i__7485__auto___19663 = G__19664;
continue;
} else {
}
break;
}

var G__19661 = args19659.length;
switch (G__19661) {
case 1:
return sablono.core.radio_button19658.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.radio_button19658.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.radio_button19658.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19659.length)].join('')));

}
});

sablono.core.radio_button19658.cljs$core$IFn$_invoke$arity$1 = (function (group){
return sablono.core.radio_button19658.call(null,group,null);
});

sablono.core.radio_button19658.cljs$core$IFn$_invoke$arity$2 = (function (group,checked_QMARK_){
return sablono.core.radio_button19658.call(null,group,checked_QMARK_,"true");
});

sablono.core.radio_button19658.cljs$core$IFn$_invoke$arity$3 = (function (group,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),"radio",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,group),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,[cljs.core.str(sablono.util.as_str.call(null,group)),cljs.core.str("-"),cljs.core.str(sablono.util.as_str.call(null,value))].join('')),new cljs.core.Keyword(null,"value","value",305978217),value,new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_], null)], null);
});

sablono.core.radio_button19658.cljs$lang$maxFixedArity = 3;


sablono.core.radio_button = sablono.core.wrap_attrs.call(null,sablono.core.radio_button19658);
/**
 * Creates a seq of option tags from a collection.
 */
sablono.core.select_options19666 = (function sablono$core$select_options19666(var_args){
var args19667 = [];
var len__7484__auto___19686 = arguments.length;
var i__7485__auto___19687 = (0);
while(true){
if((i__7485__auto___19687 < len__7484__auto___19686)){
args19667.push((arguments[i__7485__auto___19687]));

var G__19688 = (i__7485__auto___19687 + (1));
i__7485__auto___19687 = G__19688;
continue;
} else {
}
break;
}

var G__19669 = args19667.length;
switch (G__19669) {
case 1:
return sablono.core.select_options19666.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.select_options19666.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19667.length)].join('')));

}
});

sablono.core.select_options19666.cljs$core$IFn$_invoke$arity$1 = (function (coll){
return sablono.core.select_options19666.call(null,coll,null);
});

sablono.core.select_options19666.cljs$core$IFn$_invoke$arity$2 = (function (coll,selected){
var iter__7189__auto__ = (function sablono$core$iter__19670(s__19671){
return (new cljs.core.LazySeq(null,(function (){
var s__19671__$1 = s__19671;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__19671__$1);
if(temp__4657__auto__){
var s__19671__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__19671__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__19671__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__19673 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__19672 = (0);
while(true){
if((i__19672 < size__7188__auto__)){
var x = cljs.core._nth.call(null,c__7187__auto__,i__19672);
cljs.core.chunk_append.call(null,b__19673,((cljs.core.sequential_QMARK_.call(null,x))?(function (){var vec__19680 = x;
var text = cljs.core.nth.call(null,vec__19680,(0),null);
var val = cljs.core.nth.call(null,vec__19680,(1),null);
var disabled_QMARK_ = cljs.core.nth.call(null,vec__19680,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$.call(null,disabled_QMARK_);
if(cljs.core.sequential_QMARK_.call(null,val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"optgroup","optgroup",1738282218),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"label","label",1718410804),text], null),sablono.core.select_options19666.call(null,val,selected)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"value","value",305978217),val,new cljs.core.Keyword(null,"selected","selected",574897764),cljs.core._EQ_.call(null,val,selected),new cljs.core.Keyword(null,"disabled","disabled",-1529784218),disabled_QMARK___$1], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"selected","selected",574897764),cljs.core._EQ_.call(null,x,selected)], null),x], null)));

var G__19690 = (i__19672 + (1));
i__19672 = G__19690;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__19673),sablono$core$iter__19670.call(null,cljs.core.chunk_rest.call(null,s__19671__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__19673),null);
}
} else {
var x = cljs.core.first.call(null,s__19671__$2);
return cljs.core.cons.call(null,((cljs.core.sequential_QMARK_.call(null,x))?(function (){var vec__19683 = x;
var text = cljs.core.nth.call(null,vec__19683,(0),null);
var val = cljs.core.nth.call(null,vec__19683,(1),null);
var disabled_QMARK_ = cljs.core.nth.call(null,vec__19683,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$.call(null,disabled_QMARK_);
if(cljs.core.sequential_QMARK_.call(null,val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"optgroup","optgroup",1738282218),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"label","label",1718410804),text], null),sablono.core.select_options19666.call(null,val,selected)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"value","value",305978217),val,new cljs.core.Keyword(null,"selected","selected",574897764),cljs.core._EQ_.call(null,val,selected),new cljs.core.Keyword(null,"disabled","disabled",-1529784218),disabled_QMARK___$1], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"selected","selected",574897764),cljs.core._EQ_.call(null,x,selected)], null),x], null)),sablono$core$iter__19670.call(null,cljs.core.rest.call(null,s__19671__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__.call(null,coll);
});

sablono.core.select_options19666.cljs$lang$maxFixedArity = 2;


sablono.core.select_options = sablono.core.wrap_attrs.call(null,sablono.core.select_options19666);
/**
 * Creates a drop-down box using the <select> tag.
 */
sablono.core.drop_down19691 = (function sablono$core$drop_down19691(var_args){
var args19692 = [];
var len__7484__auto___19695 = arguments.length;
var i__7485__auto___19696 = (0);
while(true){
if((i__7485__auto___19696 < len__7484__auto___19695)){
args19692.push((arguments[i__7485__auto___19696]));

var G__19697 = (i__7485__auto___19696 + (1));
i__7485__auto___19696 = G__19697;
continue;
} else {
}
break;
}

var G__19694 = args19692.length;
switch (G__19694) {
case 2:
return sablono.core.drop_down19691.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.drop_down19691.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19692.length)].join('')));

}
});

sablono.core.drop_down19691.cljs$core$IFn$_invoke$arity$2 = (function (name,options){
return sablono.core.drop_down19691.call(null,name,options,null);
});

sablono.core.drop_down19691.cljs$core$IFn$_invoke$arity$3 = (function (name,options,selected){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name)], null),sablono.core.select_options.call(null,options,selected)], null);
});

sablono.core.drop_down19691.cljs$lang$maxFixedArity = 3;


sablono.core.drop_down = sablono.core.wrap_attrs.call(null,sablono.core.drop_down19691);
/**
 * Creates a text area element.
 */
sablono.core.text_area19699 = (function sablono$core$text_area19699(var_args){
var args19700 = [];
var len__7484__auto___19703 = arguments.length;
var i__7485__auto___19704 = (0);
while(true){
if((i__7485__auto___19704 < len__7484__auto___19703)){
args19700.push((arguments[i__7485__auto___19704]));

var G__19705 = (i__7485__auto___19704 + (1));
i__7485__auto___19704 = G__19705;
continue;
} else {
}
break;
}

var G__19702 = args19700.length;
switch (G__19702) {
case 1:
return sablono.core.text_area19699.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_area19699.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19700.length)].join('')));

}
});

sablono.core.text_area19699.cljs$core$IFn$_invoke$arity$1 = (function (name){
return sablono.core.text_area19699.call(null,name,null);
});

sablono.core.text_area19699.cljs$core$IFn$_invoke$arity$2 = (function (name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"textarea","textarea",-650375824),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),value], null)], null);
});

sablono.core.text_area19699.cljs$lang$maxFixedArity = 2;


sablono.core.text_area = sablono.core.wrap_attrs.call(null,sablono.core.text_area19699);
/**
 * Creates a label for an input field with the supplied name.
 */
sablono.core.label19707 = (function sablono$core$label19707(name,text){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"label","label",1718410804),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"htmlFor","htmlFor",-1050291720),sablono.core.make_id.call(null,name)], null),text], null);
});

sablono.core.label = sablono.core.wrap_attrs.call(null,sablono.core.label19707);
/**
 * Creates a submit button.
 */
sablono.core.submit_button19708 = (function sablono$core$submit_button19708(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"submit",new cljs.core.Keyword(null,"value","value",305978217),text], null)], null);
});

sablono.core.submit_button = sablono.core.wrap_attrs.call(null,sablono.core.submit_button19708);
/**
 * Creates a form reset button.
 */
sablono.core.reset_button19709 = (function sablono$core$reset_button19709(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"reset",new cljs.core.Keyword(null,"value","value",305978217),text], null)], null);
});

sablono.core.reset_button = sablono.core.wrap_attrs.call(null,sablono.core.reset_button19709);
/**
 * Create a form that points to a particular method and route.
 *   e.g. (form-to [:put "/post"]
 *       ...)
 */
sablono.core.form_to19710 = (function sablono$core$form_to19710(var_args){
var args__7491__auto__ = [];
var len__7484__auto___19717 = arguments.length;
var i__7485__auto___19718 = (0);
while(true){
if((i__7485__auto___19718 < len__7484__auto___19717)){
args__7491__auto__.push((arguments[i__7485__auto___19718]));

var G__19719 = (i__7485__auto___19718 + (1));
i__7485__auto___19718 = G__19719;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return sablono.core.form_to19710.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

sablono.core.form_to19710.cljs$core$IFn$_invoke$arity$variadic = (function (p__19713,body){
var vec__19714 = p__19713;
var method = cljs.core.nth.call(null,vec__19714,(0),null);
var action = cljs.core.nth.call(null,vec__19714,(1),null);
var method_str = clojure.string.upper_case.call(null,cljs.core.name.call(null,method));
var action_uri = sablono.util.to_uri.call(null,action);
return cljs.core.vec.call(null,cljs.core.concat.call(null,((cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"get","get",1683182755),null,new cljs.core.Keyword(null,"post","post",269697687),null], null), null),method))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),method_str,new cljs.core.Keyword(null,"action","action",-811238024),action_uri], null)], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),"POST",new cljs.core.Keyword(null,"action","action",-811238024),action_uri], null),sablono.core.hidden_field.call(null,"_method",method_str)], null)),body));
});

sablono.core.form_to19710.cljs$lang$maxFixedArity = (1);

sablono.core.form_to19710.cljs$lang$applyTo = (function (seq19711){
var G__19712 = cljs.core.first.call(null,seq19711);
var seq19711__$1 = cljs.core.next.call(null,seq19711);
return sablono.core.form_to19710.cljs$core$IFn$_invoke$arity$variadic(G__19712,seq19711__$1);
});


sablono.core.form_to = sablono.core.wrap_attrs.call(null,sablono.core.form_to19710);
