// Compiled by ClojureScript 1.9.229 {}
goog.provide('c2.dom');
goog.require('cljs.core');
goog.require('goog.dom.forms');
goog.require('goog.dom');
goog.require('goog.dom.classes');
goog.require('singult.core');
goog.require('goog.style');
goog.require('clojure.string');
Element.prototype.matchesSelector = Element.prototype.webkitMatchesSelector || Element.prototype.mozMatchesSelector || Element.prototype.msMatchesSelector || Element.prototype.oMatchesSelector;
if(cljs.core.truth_(typeof NodeList != "undefined")){
NodeList.prototype.cljs$core$ISeqable$ = true;

NodeList.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (array){
var array__$1 = this;
return cljs.core.array_seq.call(null,array__$1,(0));
});
} else {
}
HTMLCollection.prototype.cljs$core$ISeqable$ = true;

HTMLCollection.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (array){
var array__$1 = this;
return cljs.core.array_seq.call(null,array__$1,(0));
});

/**
 * @interface
 */
c2.dom.IDom = function(){};

/**
 * Converts x to a live DOM node
 */
c2.dom.__GT_dom = (function c2$dom$__GT_dom(x){
if((!((x == null))) && (!((x.c2$dom$IDom$__GT_dom$arity$1 == null)))){
return x.c2$dom$IDom$__GT_dom$arity$1(x);
} else {
var x__7072__auto__ = (((x == null))?null:x);
var m__7073__auto__ = (c2.dom.__GT_dom[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return m__7073__auto__.call(null,x);
} else {
var m__7073__auto____$1 = (c2.dom.__GT_dom["_"]);
if(!((m__7073__auto____$1 == null))){
return m__7073__auto____$1.call(null,x);
} else {
throw cljs.core.missing_protocol.call(null,"IDom.->dom",x);
}
}
}
});

(c2.dom.IDom["string"] = true);

(c2.dom.__GT_dom["string"] = (function (selector){
return c2.dom.select.call(null,selector);
}));

cljs.core.PersistentVector.prototype.c2$dom$IDom$ = true;

cljs.core.PersistentVector.prototype.c2$dom$IDom$__GT_dom$arity$1 = (function (v){
var v__$1 = this;
return singult.core.render.call(null,v__$1);
});
if(cljs.core.truth_(typeof Node != "undefined")){
Node.prototype.c2$dom$IDom$ = true;

Node.prototype.c2$dom$IDom$__GT_dom$arity$1 = (function (node){
var node__$1 = this;
return node__$1;
});
} else {
}
/**
 * Select a single DOM node via CSS selector, optionally scoped by second arg.
 */
c2.dom.select = (function c2$dom$select(var_args){
var args19692 = [];
var len__7484__auto___19695 = arguments.length;
var i__7485__auto___19696 = (0);
while(true){
if((i__7485__auto___19696 < len__7484__auto___19695)){
args19692.push((arguments[i__7485__auto___19696]));

var G__19697 = (i__7485__auto___19696 + (1));
i__7485__auto___19696 = G__19697;
continue;
} else {
}
break;
}

var G__19694 = args19692.length;
switch (G__19694) {
case 1:
return c2.dom.select.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.select.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19692.length)].join('')));

}
});

c2.dom.select.cljs$core$IFn$_invoke$arity$1 = (function (selector){
return document.querySelector(selector);
});

c2.dom.select.cljs$core$IFn$_invoke$arity$2 = (function (selector,container){
return c2.dom.__GT_dom.call(null,container).querySelector(selector);
});

c2.dom.select.cljs$lang$maxFixedArity = 2;

/**
 * Like select, but returns a collection of nodes.
 */
c2.dom.select_all = (function c2$dom$select_all(var_args){
var args19699 = [];
var len__7484__auto___19702 = arguments.length;
var i__7485__auto___19703 = (0);
while(true){
if((i__7485__auto___19703 < len__7484__auto___19702)){
args19699.push((arguments[i__7485__auto___19703]));

var G__19704 = (i__7485__auto___19703 + (1));
i__7485__auto___19703 = G__19704;
continue;
} else {
}
break;
}

var G__19701 = args19699.length;
switch (G__19701) {
case 1:
return c2.dom.select_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.select_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19699.length)].join('')));

}
});

c2.dom.select_all.cljs$core$IFn$_invoke$arity$1 = (function (selector){
return document.querySelectorAll(selector);
});

c2.dom.select_all.cljs$core$IFn$_invoke$arity$2 = (function (selector,container){
return c2.dom.__GT_dom.call(null,container).querySelectorAll(selector);
});

c2.dom.select_all.cljs$lang$maxFixedArity = 2;

/**
 * Does live `node` match CSS `selector`?
 */
c2.dom.matches_selector_QMARK_ = (function c2$dom$matches_selector_QMARK_(node,selector){
if(cljs.core.truth_(node)){
return node.matchesSelector(selector);
} else {
return null;
}
});
/**
 * Return the children of a live DOM element.
 */
c2.dom.children = (function c2$dom$children(node){
if(cljs.core.truth_(node)){
return c2.dom.__GT_dom.call(null,node).children;
} else {
return null;
}
});
/**
 * Return parent of a live DOM node.
 */
c2.dom.parent = (function c2$dom$parent(node){
if(cljs.core.truth_(c2$dom$parent)){
return c2.dom.__GT_dom.call(null,node).parentNode;
} else {
return null;
}
});
/**
 * Make element last child of container.
 * Returns live child.
 */
c2.dom.append_BANG_ = (function c2$dom$append_BANG_(container,el){
var el__$1 = c2.dom.__GT_dom.call(null,el);
goog.dom.appendChild(c2.dom.__GT_dom.call(null,container),el__$1);

return el__$1;
});
/**
 * Make element first child of container.
 * Returns live DOM child.
 */
c2.dom.prepend_BANG_ = (function c2$dom$prepend_BANG_(container,el){
var el__$1 = c2.dom.__GT_dom.call(null,el);
goog.dom.insertChildAt(c2.dom.__GT_dom.call(null,container),el__$1,(0));

return el__$1;
});
/**
 * Remove element from DOM and return it.
 * > *el* CSS selector or live DOM node
 */
c2.dom.remove_BANG_ = (function c2$dom$remove_BANG_(el){
return goog.dom.removeNode(c2.dom.__GT_dom.call(null,el));
});
/**
 * Replace live DOM node with a new one, returning the latter.
 * > *old* CSS selector or live DOM node
 * > *new* CSS selector, live DOM node, or hiccup vector
 */
c2.dom.replace_BANG_ = (function c2$dom$replace_BANG_(old,new$){
var new$__$1 = c2.dom.__GT_dom.call(null,new$);
goog.dom.replaceNode(new$__$1,c2.dom.__GT_dom.call(null,old));

return new$__$1;
});
/**
 * Get or set inline element style.
 * 
 * `(style el)`                map of inline element styles
 * 
 * `(style el :keyword)`       value of style :keyword
 * 
 * `(style el {:keyword val})` sets inline style according to map, returns element
 * 
 * `(style el :keyword val)`   sets single style, returns element
 */
c2.dom.style = (function c2$dom$style(var_args){
var args19706 = [];
var len__7484__auto___19719 = arguments.length;
var i__7485__auto___19720 = (0);
while(true){
if((i__7485__auto___19720 < len__7484__auto___19719)){
args19706.push((arguments[i__7485__auto___19720]));

var G__19721 = (i__7485__auto___19720 + (1));
i__7485__auto___19720 = G__19721;
continue;
} else {
}
break;
}

var G__19708 = args19706.length;
switch (G__19708) {
case 1:
return c2.dom.style.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.style.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return c2.dom.style.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19706.length)].join('')));

}
});

c2.dom.style.cljs$core$IFn$_invoke$arity$1 = (function (el){
throw (new Error("TODO: return map of element styles"));
});

c2.dom.style.cljs$core$IFn$_invoke$arity$2 = (function (el,x){
var el__$1 = c2.dom.__GT_dom.call(null,el);
if((x instanceof cljs.core.Keyword)){
return goog.style.getComputedStyle(el__$1,cljs.core.name.call(null,x));
} else {
if(cljs.core.map_QMARK_.call(null,x)){
var seq__19709_19723 = cljs.core.seq.call(null,x);
var chunk__19710_19724 = null;
var count__19711_19725 = (0);
var i__19712_19726 = (0);
while(true){
if((i__19712_19726 < count__19711_19725)){
var vec__19713_19727 = cljs.core._nth.call(null,chunk__19710_19724,i__19712_19726);
var k_19728 = cljs.core.nth.call(null,vec__19713_19727,(0),null);
var v_19729 = cljs.core.nth.call(null,vec__19713_19727,(1),null);
c2.dom.style.call(null,el__$1,k_19728,v_19729);

var G__19730 = seq__19709_19723;
var G__19731 = chunk__19710_19724;
var G__19732 = count__19711_19725;
var G__19733 = (i__19712_19726 + (1));
seq__19709_19723 = G__19730;
chunk__19710_19724 = G__19731;
count__19711_19725 = G__19732;
i__19712_19726 = G__19733;
continue;
} else {
var temp__4657__auto___19734 = cljs.core.seq.call(null,seq__19709_19723);
if(temp__4657__auto___19734){
var seq__19709_19735__$1 = temp__4657__auto___19734;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__19709_19735__$1)){
var c__7220__auto___19736 = cljs.core.chunk_first.call(null,seq__19709_19735__$1);
var G__19737 = cljs.core.chunk_rest.call(null,seq__19709_19735__$1);
var G__19738 = c__7220__auto___19736;
var G__19739 = cljs.core.count.call(null,c__7220__auto___19736);
var G__19740 = (0);
seq__19709_19723 = G__19737;
chunk__19710_19724 = G__19738;
count__19711_19725 = G__19739;
i__19712_19726 = G__19740;
continue;
} else {
var vec__19716_19741 = cljs.core.first.call(null,seq__19709_19735__$1);
var k_19742 = cljs.core.nth.call(null,vec__19716_19741,(0),null);
var v_19743 = cljs.core.nth.call(null,vec__19716_19741,(1),null);
c2.dom.style.call(null,el__$1,k_19742,v_19743);

var G__19744 = cljs.core.next.call(null,seq__19709_19735__$1);
var G__19745 = null;
var G__19746 = (0);
var G__19747 = (0);
seq__19709_19723 = G__19744;
chunk__19710_19724 = G__19745;
count__19711_19725 = G__19746;
i__19712_19726 = G__19747;
continue;
}
} else {
}
}
break;
}

return el__$1;
} else {
return null;
}
}
});

c2.dom.style.cljs$core$IFn$_invoke$arity$3 = (function (el,k,v){
goog.style.setStyle(c2.dom.__GT_dom.call(null,el),cljs.core.name.call(null,k),((typeof v === 'string')?v:((typeof v === 'number')?(cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"bottom","bottom",-1550509018),null,new cljs.core.Keyword(null,"top","top",-1856271961),null,new cljs.core.Keyword(null,"width","width",-384071477),null,new cljs.core.Keyword(null,"right","right",-452581833),null,new cljs.core.Keyword(null,"height","height",1025178622),null,new cljs.core.Keyword(null,"left","left",-399115937),null], null), null).call(null,cljs.core.keyword.call(null,k)))?[cljs.core.str(v),cljs.core.str("px")].join(''):v):null)));

return el;
});

c2.dom.style.cljs$lang$maxFixedArity = 3;

/**
 * Get or set element attributes.
 * 
 * `(attr el)`                map of element attributes
 * 
 * `(attr el :keyword)`       value of attr :keyword
 * 
 * `(attr el {:keyword val})` sets element attributes according to map, returns element
 * 
 * `(attr el :keyword val)`   sets single attr, returns element
 */
c2.dom.attr = (function c2$dom$attr(var_args){
var args19748 = [];
var len__7484__auto___19765 = arguments.length;
var i__7485__auto___19766 = (0);
while(true){
if((i__7485__auto___19766 < len__7484__auto___19765)){
args19748.push((arguments[i__7485__auto___19766]));

var G__19767 = (i__7485__auto___19766 + (1));
i__7485__auto___19766 = G__19767;
continue;
} else {
}
break;
}

var G__19750 = args19748.length;
switch (G__19750) {
case 1:
return c2.dom.attr.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.attr.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return c2.dom.attr.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19748.length)].join('')));

}
});

c2.dom.attr.cljs$core$IFn$_invoke$arity$1 = (function (el){
var attrs = c2.dom.__GT_dom.call(null,el).attributes;
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__7189__auto__ = ((function (attrs){
return (function c2$dom$iter__19751(s__19752){
return (new cljs.core.LazySeq(null,((function (attrs){
return (function (){
var s__19752__$1 = s__19752;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__19752__$1);
if(temp__4657__auto__){
var s__19752__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__19752__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__19752__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__19754 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__19753 = (0);
while(true){
if((i__19753 < size__7188__auto__)){
var i = cljs.core._nth.call(null,c__7187__auto__,i__19753);
cljs.core.chunk_append.call(null,b__19754,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.keyword.call(null,(attrs[i]).name),(attrs[i]).value], null));

var G__19769 = (i__19753 + (1));
i__19753 = G__19769;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__19754),c2$dom$iter__19751.call(null,cljs.core.chunk_rest.call(null,s__19752__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__19754),null);
}
} else {
var i = cljs.core.first.call(null,s__19752__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.keyword.call(null,(attrs[i]).name),(attrs[i]).value], null),c2$dom$iter__19751.call(null,cljs.core.rest.call(null,s__19752__$2)));
}
} else {
return null;
}
break;
}
});})(attrs))
,null,null));
});})(attrs))
;
return iter__7189__auto__.call(null,cljs.core.range.call(null,attrs.length));
})());
});

c2.dom.attr.cljs$core$IFn$_invoke$arity$2 = (function (el,x){
var el__$1 = c2.dom.__GT_dom.call(null,el);
if((x instanceof cljs.core.Keyword)){
return el__$1.getAttribute(cljs.core.name.call(null,x));
} else {
if(cljs.core.map_QMARK_.call(null,x)){
var seq__19755_19770 = cljs.core.seq.call(null,x);
var chunk__19756_19771 = null;
var count__19757_19772 = (0);
var i__19758_19773 = (0);
while(true){
if((i__19758_19773 < count__19757_19772)){
var vec__19759_19774 = cljs.core._nth.call(null,chunk__19756_19771,i__19758_19773);
var k_19775 = cljs.core.nth.call(null,vec__19759_19774,(0),null);
var v_19776 = cljs.core.nth.call(null,vec__19759_19774,(1),null);
c2.dom.attr.call(null,el__$1,k_19775,v_19776);

var G__19777 = seq__19755_19770;
var G__19778 = chunk__19756_19771;
var G__19779 = count__19757_19772;
var G__19780 = (i__19758_19773 + (1));
seq__19755_19770 = G__19777;
chunk__19756_19771 = G__19778;
count__19757_19772 = G__19779;
i__19758_19773 = G__19780;
continue;
} else {
var temp__4657__auto___19781 = cljs.core.seq.call(null,seq__19755_19770);
if(temp__4657__auto___19781){
var seq__19755_19782__$1 = temp__4657__auto___19781;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__19755_19782__$1)){
var c__7220__auto___19783 = cljs.core.chunk_first.call(null,seq__19755_19782__$1);
var G__19784 = cljs.core.chunk_rest.call(null,seq__19755_19782__$1);
var G__19785 = c__7220__auto___19783;
var G__19786 = cljs.core.count.call(null,c__7220__auto___19783);
var G__19787 = (0);
seq__19755_19770 = G__19784;
chunk__19756_19771 = G__19785;
count__19757_19772 = G__19786;
i__19758_19773 = G__19787;
continue;
} else {
var vec__19762_19788 = cljs.core.first.call(null,seq__19755_19782__$1);
var k_19789 = cljs.core.nth.call(null,vec__19762_19788,(0),null);
var v_19790 = cljs.core.nth.call(null,vec__19762_19788,(1),null);
c2.dom.attr.call(null,el__$1,k_19789,v_19790);

var G__19791 = cljs.core.next.call(null,seq__19755_19782__$1);
var G__19792 = null;
var G__19793 = (0);
var G__19794 = (0);
seq__19755_19770 = G__19791;
chunk__19756_19771 = G__19792;
count__19757_19772 = G__19793;
i__19758_19773 = G__19794;
continue;
}
} else {
}
}
break;
}

return el__$1;
} else {
return null;
}
}
});

c2.dom.attr.cljs$core$IFn$_invoke$arity$3 = (function (el,k,v){
var el__$1 = c2.dom.__GT_dom.call(null,el);
if((v == null)){
el__$1.removeAttribute(cljs.core.name.call(null,k));
} else {
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"style","style",-496642736),k)){
c2.dom.style.call(null,el__$1,v);
} else {
el__$1.setAttribute(cljs.core.name.call(null,k),v);
}
}

return el__$1;
});

c2.dom.attr.cljs$lang$maxFixedArity = 3;

/**
 * Get or set element text, returning element
 */
c2.dom.text = (function c2$dom$text(var_args){
var args19795 = [];
var len__7484__auto___19798 = arguments.length;
var i__7485__auto___19799 = (0);
while(true){
if((i__7485__auto___19799 < len__7484__auto___19798)){
args19795.push((arguments[i__7485__auto___19799]));

var G__19800 = (i__7485__auto___19799 + (1));
i__7485__auto___19799 = G__19800;
continue;
} else {
}
break;
}

var G__19797 = args19795.length;
switch (G__19797) {
case 1:
return c2.dom.text.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.text.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19795.length)].join('')));

}
});

c2.dom.text.cljs$core$IFn$_invoke$arity$1 = (function (el){
return goog.dom.getTextContent(c2.dom.__GT_dom.call(null,el));
});

c2.dom.text.cljs$core$IFn$_invoke$arity$2 = (function (el,v){
var el__$1 = c2.dom.__GT_dom.call(null,el);
goog.dom.setTextContent(el__$1,v);

return el__$1;
});

c2.dom.text.cljs$lang$maxFixedArity = 2;

/**
 * Get or set element value.
 */
c2.dom.val = (function c2$dom$val(var_args){
var args19802 = [];
var len__7484__auto___19805 = arguments.length;
var i__7485__auto___19806 = (0);
while(true){
if((i__7485__auto___19806 < len__7484__auto___19805)){
args19802.push((arguments[i__7485__auto___19806]));

var G__19807 = (i__7485__auto___19806 + (1));
i__7485__auto___19806 = G__19807;
continue;
} else {
}
break;
}

var G__19804 = args19802.length;
switch (G__19804) {
case 1:
return c2.dom.val.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.val.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19802.length)].join('')));

}
});

c2.dom.val.cljs$core$IFn$_invoke$arity$1 = (function (el){
return goog.dom.forms.getValue(c2.dom.__GT_dom.call(null,el));
});

c2.dom.val.cljs$core$IFn$_invoke$arity$2 = (function (el,v){
var el__$1 = c2.dom.__GT_dom.call(null,el);
goog.dom.forms.setValue(el__$1,v);

return el__$1;
});

c2.dom.val.cljs$lang$maxFixedArity = 2;

/**
 * Add or remove `class` to element based on boolean `classed?`, returning element.
 */
c2.dom.classed_BANG_ = (function c2$dom$classed_BANG_(el,class$,classed_QMARK_){
goog.dom.classes.enable(c2.dom.__GT_dom.call(null,el),cljs.core.name.call(null,class$),classed_QMARK_);

return el;
});
c2.dom.add_class_BANG_ = (function c2$dom$add_class_BANG_(el,class$){
return c2.dom.classed_BANG_.call(null,el,class$,true);
});
c2.dom.remove_class_BANG_ = (function c2$dom$remove_class_BANG_(el,class$){
return c2.dom.classed_BANG_.call(null,el,class$,false);
});
c2.dom.request_animation_frame = (function (){var or__6409__auto__ = window.requestAnimationFrame;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
var or__6409__auto____$1 = window.webkitRequestAnimationFrame;
if(cljs.core.truth_(or__6409__auto____$1)){
return or__6409__auto____$1;
} else {
return ((function (or__6409__auto____$1,or__6409__auto__){
return (function (p1__19809_SHARP_){
return setTimeout(((function (or__6409__auto____$1,or__6409__auto__){
return (function (){
return p1__19809_SHARP_.call(null);
});})(or__6409__auto____$1,or__6409__auto__))
,(10));
});
;})(or__6409__auto____$1,or__6409__auto__))
}
}
})();
