// Compiled by ClojureScript 1.9.229 {:static-fns true, :optimize-constants true}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var args28848 = [];
var len__7484__auto___28854 = arguments.length;
var i__7485__auto___28855 = (0);
while(true){
if((i__7485__auto___28855 < len__7484__auto___28854)){
args28848.push((arguments[i__7485__auto___28855]));

var G__28856 = (i__7485__auto___28855 + (1));
i__7485__auto___28855 = G__28856;
continue;
} else {
}
break;
}

var G__28850 = args28848.length;
switch (G__28850) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args28848.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async28851 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async28851 = (function (f,blockable,meta28852){
this.f = f;
this.blockable = blockable;
this.meta28852 = meta28852;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async28851.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_28853,meta28852__$1){
var self__ = this;
var _28853__$1 = this;
return (new cljs.core.async.t_cljs$core$async28851(self__.f,self__.blockable,meta28852__$1));
});

cljs.core.async.t_cljs$core$async28851.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_28853){
var self__ = this;
var _28853__$1 = this;
return self__.meta28852;
});

cljs.core.async.t_cljs$core$async28851.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async28851.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async28851.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async28851.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async28851.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$blockable,cljs.core.cst$sym$meta28852], null);
});

cljs.core.async.t_cljs$core$async28851.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async28851.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async28851";

cljs.core.async.t_cljs$core$async28851.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"cljs.core.async/t_cljs$core$async28851");
});

cljs.core.async.__GT_t_cljs$core$async28851 = (function cljs$core$async$__GT_t_cljs$core$async28851(f__$1,blockable__$1,meta28852){
return (new cljs.core.async.t_cljs$core$async28851(f__$1,blockable__$1,meta28852));
});

}

return (new cljs.core.async.t_cljs$core$async28851(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || (buff.cljs$core$async$impl$protocols$UnblockingBuffer$)){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args28860 = [];
var len__7484__auto___28863 = arguments.length;
var i__7485__auto___28864 = (0);
while(true){
if((i__7485__auto___28864 < len__7484__auto___28863)){
args28860.push((arguments[i__7485__auto___28864]));

var G__28865 = (i__7485__auto___28864 + (1));
i__7485__auto___28864 = G__28865;
continue;
} else {
}
break;
}

var G__28862 = args28860.length;
switch (G__28862) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args28860.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str("buf-or-n")].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var args28867 = [];
var len__7484__auto___28870 = arguments.length;
var i__7485__auto___28871 = (0);
while(true){
if((i__7485__auto___28871 < len__7484__auto___28870)){
args28867.push((arguments[i__7485__auto___28871]));

var G__28872 = (i__7485__auto___28871 + (1));
i__7485__auto___28871 = G__28872;
continue;
} else {
}
break;
}

var G__28869 = args28867.length;
switch (G__28869) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args28867.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args28874 = [];
var len__7484__auto___28877 = arguments.length;
var i__7485__auto___28878 = (0);
while(true){
if((i__7485__auto___28878 < len__7484__auto___28877)){
args28874.push((arguments[i__7485__auto___28878]));

var G__28879 = (i__7485__auto___28878 + (1));
i__7485__auto___28878 = G__28879;
continue;
} else {
}
break;
}

var G__28876 = args28874.length;
switch (G__28876) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args28874.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_28881 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_28881) : fn1.call(null,val_28881));
} else {
cljs.core.async.impl.dispatch.run(((function (val_28881,ret){
return (function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_28881) : fn1.call(null,val_28881));
});})(val_28881,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args28882 = [];
var len__7484__auto___28885 = arguments.length;
var i__7485__auto___28886 = (0);
while(true){
if((i__7485__auto___28886 < len__7484__auto___28885)){
args28882.push((arguments[i__7485__auto___28886]));

var G__28887 = (i__7485__auto___28886 + (1));
i__7485__auto___28886 = G__28887;
continue;
} else {
}
break;
}

var G__28884 = args28882.length;
switch (G__28884) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args28882.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4655__auto__)){
var ret = temp__4655__auto__;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__4655__auto__)){
var retb = temp__4655__auto__;
var ret = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(retb) : cljs.core.deref.call(null,retb));
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run(((function (ret,retb,temp__4655__auto__){
return (function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
});})(ret,retb,temp__4655__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__7324__auto___28889 = n;
var x_28890 = (0);
while(true){
if((x_28890 < n__7324__auto___28889)){
(a[x_28890] = (0));

var G__28891 = (x_28890 + (1));
x_28890 = G__28891;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(i,n)){
return a;
} else {
var j = cljs.core.rand_int(i);
(a[i] = (a[j]));

(a[j] = i);

var G__28892 = (i + (1));
i = G__28892;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true) : cljs.core.atom.call(null,true));
if(typeof cljs.core.async.t_cljs$core$async28896 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async28896 = (function (alt_flag,flag,meta28897){
this.alt_flag = alt_flag;
this.flag = flag;
this.meta28897 = meta28897;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async28896.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_28898,meta28897__$1){
var self__ = this;
var _28898__$1 = this;
return (new cljs.core.async.t_cljs$core$async28896(self__.alt_flag,self__.flag,meta28897__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async28896.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_28898){
var self__ = this;
var _28898__$1 = this;
return self__.meta28897;
});})(flag))
;

cljs.core.async.t_cljs$core$async28896.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async28896.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(self__.flag) : cljs.core.deref.call(null,self__.flag));
});})(flag))
;

cljs.core.async.t_cljs$core$async28896.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async28896.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(self__.flag,null) : cljs.core.reset_BANG_.call(null,self__.flag,null));

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async28896.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$alt_DASH_flag,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(cljs.core.PersistentVector.EMPTY))], null)),cljs.core.cst$sym$flag,cljs.core.cst$sym$meta28897], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async28896.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async28896.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async28896";

cljs.core.async.t_cljs$core$async28896.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"cljs.core.async/t_cljs$core$async28896");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async28896 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async28896(alt_flag__$1,flag__$1,meta28897){
return (new cljs.core.async.t_cljs$core$async28896(alt_flag__$1,flag__$1,meta28897));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async28896(cljs$core$async$alt_flag,flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async28902 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async28902 = (function (alt_handler,flag,cb,meta28903){
this.alt_handler = alt_handler;
this.flag = flag;
this.cb = cb;
this.meta28903 = meta28903;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async28902.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_28904,meta28903__$1){
var self__ = this;
var _28904__$1 = this;
return (new cljs.core.async.t_cljs$core$async28902(self__.alt_handler,self__.flag,self__.cb,meta28903__$1));
});

cljs.core.async.t_cljs$core$async28902.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_28904){
var self__ = this;
var _28904__$1 = this;
return self__.meta28903;
});

cljs.core.async.t_cljs$core$async28902.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async28902.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
});

cljs.core.async.t_cljs$core$async28902.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async28902.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async28902.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$alt_DASH_handler,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$flag,cljs.core.cst$sym$cb], null)))], null)),cljs.core.cst$sym$flag,cljs.core.cst$sym$cb,cljs.core.cst$sym$meta28903], null);
});

cljs.core.async.t_cljs$core$async28902.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async28902.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async28902";

cljs.core.async.t_cljs$core$async28902.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"cljs.core.async/t_cljs$core$async28902");
});

cljs.core.async.__GT_t_cljs$core$async28902 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async28902(alt_handler__$1,flag__$1,cb__$1,meta28903){
return (new cljs.core.async.t_cljs$core$async28902(alt_handler__$1,flag__$1,cb__$1,meta28903));
});

}

return (new cljs.core.async.t_cljs$core$async28902(cljs$core$async$alt_handler,flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = cljs.core.cst$kw$priority.cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__28905_SHARP_){
var G__28909 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__28905_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__28909) : fret.call(null,G__28909));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__28906_SHARP_){
var G__28910 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__28906_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__28910) : fret.call(null,G__28910));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(vbox) : cljs.core.deref.call(null,vbox)),(function (){var or__6409__auto__ = wport;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return port;
}
})()], null));
} else {
var G__28911 = (i + (1));
i = G__28911;
continue;
}
} else {
return null;
}
break;
}
})();
var or__6409__auto__ = ret;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,cljs.core.cst$kw$default)){
var temp__4657__auto__ = (function (){var and__6397__auto__ = cljs.core.async.impl.protocols.active_QMARK_(flag);
if(cljs.core.truth_(and__6397__auto__)){
return cljs.core.async.impl.protocols.commit(flag);
} else {
return and__6397__auto__;
}
})();
if(cljs.core.truth_(temp__4657__auto__)){
var got = temp__4657__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$default.cljs$core$IFn$_invoke$arity$1(opts),cljs.core.cst$kw$default], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__7491__auto__ = [];
var len__7484__auto___28917 = arguments.length;
var i__7485__auto___28918 = (0);
while(true){
if((i__7485__auto___28918 < len__7484__auto___28917)){
args__7491__auto__.push((arguments[i__7485__auto___28918]));

var G__28919 = (i__7485__auto___28918 + (1));
i__7485__auto___28918 = G__28919;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__28914){
var map__28915 = p__28914;
var map__28915__$1 = ((((!((map__28915 == null)))?((((map__28915.cljs$lang$protocol_mask$partition0$ & (64))) || (map__28915.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__28915):map__28915);
var opts = map__28915__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq28912){
var G__28913 = cljs.core.first(seq28912);
var seq28912__$1 = cljs.core.next(seq28912);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__28913,seq28912__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args28920 = [];
var len__7484__auto___28970 = arguments.length;
var i__7485__auto___28971 = (0);
while(true){
if((i__7485__auto___28971 < len__7484__auto___28970)){
args28920.push((arguments[i__7485__auto___28971]));

var G__28972 = (i__7485__auto___28971 + (1));
i__7485__auto___28971 = G__28972;
continue;
} else {
}
break;
}

var G__28922 = args28920.length;
switch (G__28922) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args28920.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__12139__auto___28974 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12139__auto___28974){
return (function (){
var f__12140__auto__ = (function (){var switch__12027__auto__ = ((function (c__12139__auto___28974){
return (function (state_28946){
var state_val_28947 = (state_28946[(1)]);
if((state_val_28947 === (7))){
var inst_28942 = (state_28946[(2)]);
var state_28946__$1 = state_28946;
var statearr_28948_28975 = state_28946__$1;
(statearr_28948_28975[(2)] = inst_28942);

(statearr_28948_28975[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28947 === (1))){
var state_28946__$1 = state_28946;
var statearr_28949_28976 = state_28946__$1;
(statearr_28949_28976[(2)] = null);

(statearr_28949_28976[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28947 === (4))){
var inst_28925 = (state_28946[(7)]);
var inst_28925__$1 = (state_28946[(2)]);
var inst_28926 = (inst_28925__$1 == null);
var state_28946__$1 = (function (){var statearr_28950 = state_28946;
(statearr_28950[(7)] = inst_28925__$1);

return statearr_28950;
})();
if(cljs.core.truth_(inst_28926)){
var statearr_28951_28977 = state_28946__$1;
(statearr_28951_28977[(1)] = (5));

} else {
var statearr_28952_28978 = state_28946__$1;
(statearr_28952_28978[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28947 === (13))){
var state_28946__$1 = state_28946;
var statearr_28953_28979 = state_28946__$1;
(statearr_28953_28979[(2)] = null);

(statearr_28953_28979[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28947 === (6))){
var inst_28925 = (state_28946[(7)]);
var state_28946__$1 = state_28946;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_28946__$1,(11),to,inst_28925);
} else {
if((state_val_28947 === (3))){
var inst_28944 = (state_28946[(2)]);
var state_28946__$1 = state_28946;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28946__$1,inst_28944);
} else {
if((state_val_28947 === (12))){
var state_28946__$1 = state_28946;
var statearr_28954_28980 = state_28946__$1;
(statearr_28954_28980[(2)] = null);

(statearr_28954_28980[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28947 === (2))){
var state_28946__$1 = state_28946;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28946__$1,(4),from);
} else {
if((state_val_28947 === (11))){
var inst_28935 = (state_28946[(2)]);
var state_28946__$1 = state_28946;
if(cljs.core.truth_(inst_28935)){
var statearr_28955_28981 = state_28946__$1;
(statearr_28955_28981[(1)] = (12));

} else {
var statearr_28956_28982 = state_28946__$1;
(statearr_28956_28982[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28947 === (9))){
var state_28946__$1 = state_28946;
var statearr_28957_28983 = state_28946__$1;
(statearr_28957_28983[(2)] = null);

(statearr_28957_28983[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28947 === (5))){
var state_28946__$1 = state_28946;
if(cljs.core.truth_(close_QMARK_)){
var statearr_28958_28984 = state_28946__$1;
(statearr_28958_28984[(1)] = (8));

} else {
var statearr_28959_28985 = state_28946__$1;
(statearr_28959_28985[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28947 === (14))){
var inst_28940 = (state_28946[(2)]);
var state_28946__$1 = state_28946;
var statearr_28960_28986 = state_28946__$1;
(statearr_28960_28986[(2)] = inst_28940);

(statearr_28960_28986[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28947 === (10))){
var inst_28932 = (state_28946[(2)]);
var state_28946__$1 = state_28946;
var statearr_28961_28987 = state_28946__$1;
(statearr_28961_28987[(2)] = inst_28932);

(statearr_28961_28987[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28947 === (8))){
var inst_28929 = cljs.core.async.close_BANG_(to);
var state_28946__$1 = state_28946;
var statearr_28962_28988 = state_28946__$1;
(statearr_28962_28988[(2)] = inst_28929);

(statearr_28962_28988[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12139__auto___28974))
;
return ((function (switch__12027__auto__,c__12139__auto___28974){
return (function() {
var cljs$core$async$state_machine__12028__auto__ = null;
var cljs$core$async$state_machine__12028__auto____0 = (function (){
var statearr_28966 = [null,null,null,null,null,null,null,null];
(statearr_28966[(0)] = cljs$core$async$state_machine__12028__auto__);

(statearr_28966[(1)] = (1));

return statearr_28966;
});
var cljs$core$async$state_machine__12028__auto____1 = (function (state_28946){
while(true){
var ret_value__12029__auto__ = (function (){try{while(true){
var result__12030__auto__ = switch__12027__auto__(state_28946);
if(cljs.core.keyword_identical_QMARK_(result__12030__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12030__auto__;
}
break;
}
}catch (e28967){if((e28967 instanceof Object)){
var ex__12031__auto__ = e28967;
var statearr_28968_28989 = state_28946;
(statearr_28968_28989[(5)] = ex__12031__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_28946);

return cljs.core.cst$kw$recur;
} else {
throw e28967;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12029__auto__,cljs.core.cst$kw$recur)){
var G__28990 = state_28946;
state_28946 = G__28990;
continue;
} else {
return ret_value__12029__auto__;
}
break;
}
});
cljs$core$async$state_machine__12028__auto__ = function(state_28946){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12028__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12028__auto____1.call(this,state_28946);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12028__auto____0;
cljs$core$async$state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12028__auto____1;
return cljs$core$async$state_machine__12028__auto__;
})()
;})(switch__12027__auto__,c__12139__auto___28974))
})();
var state__12141__auto__ = (function (){var statearr_28969 = (f__12140__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12140__auto__.cljs$core$IFn$_invoke$arity$0() : f__12140__auto__.call(null));
(statearr_28969[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12139__auto___28974);

return statearr_28969;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12141__auto__);
});})(c__12139__auto___28974))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process = ((function (jobs,results){
return (function (p__29178){
var vec__29179 = p__29178;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29179,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29179,(1),null);
var job = vec__29179;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__12139__auto___29365 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12139__auto___29365,res,vec__29179,v,p,job,jobs,results){
return (function (){
var f__12140__auto__ = (function (){var switch__12027__auto__ = ((function (c__12139__auto___29365,res,vec__29179,v,p,job,jobs,results){
return (function (state_29186){
var state_val_29187 = (state_29186[(1)]);
if((state_val_29187 === (1))){
var state_29186__$1 = state_29186;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_29186__$1,(2),res,v);
} else {
if((state_val_29187 === (2))){
var inst_29183 = (state_29186[(2)]);
var inst_29184 = cljs.core.async.close_BANG_(res);
var state_29186__$1 = (function (){var statearr_29188 = state_29186;
(statearr_29188[(7)] = inst_29183);

return statearr_29188;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_29186__$1,inst_29184);
} else {
return null;
}
}
});})(c__12139__auto___29365,res,vec__29179,v,p,job,jobs,results))
;
return ((function (switch__12027__auto__,c__12139__auto___29365,res,vec__29179,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__12028__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__12028__auto____0 = (function (){
var statearr_29192 = [null,null,null,null,null,null,null,null];
(statearr_29192[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__12028__auto__);

(statearr_29192[(1)] = (1));

return statearr_29192;
});
var cljs$core$async$pipeline_STAR__$_state_machine__12028__auto____1 = (function (state_29186){
while(true){
var ret_value__12029__auto__ = (function (){try{while(true){
var result__12030__auto__ = switch__12027__auto__(state_29186);
if(cljs.core.keyword_identical_QMARK_(result__12030__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12030__auto__;
}
break;
}
}catch (e29193){if((e29193 instanceof Object)){
var ex__12031__auto__ = e29193;
var statearr_29194_29366 = state_29186;
(statearr_29194_29366[(5)] = ex__12031__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_29186);

return cljs.core.cst$kw$recur;
} else {
throw e29193;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12029__auto__,cljs.core.cst$kw$recur)){
var G__29367 = state_29186;
state_29186 = G__29367;
continue;
} else {
return ret_value__12029__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__12028__auto__ = function(state_29186){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__12028__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__12028__auto____1.call(this,state_29186);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__12028__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__12028__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__12028__auto__;
})()
;})(switch__12027__auto__,c__12139__auto___29365,res,vec__29179,v,p,job,jobs,results))
})();
var state__12141__auto__ = (function (){var statearr_29195 = (f__12140__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12140__auto__.cljs$core$IFn$_invoke$arity$0() : f__12140__auto__.call(null));
(statearr_29195[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12139__auto___29365);

return statearr_29195;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12141__auto__);
});})(c__12139__auto___29365,res,vec__29179,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__29196){
var vec__29197 = p__29196;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29197,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29197,(1),null);
var job = vec__29197;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});})(jobs,results,process))
;
var n__7324__auto___29368 = n;
var __29369 = (0);
while(true){
if((__29369 < n__7324__auto___29368)){
var G__29200_29370 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__29200_29370) {
case "compute":
var c__12139__auto___29372 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__29369,c__12139__auto___29372,G__29200_29370,n__7324__auto___29368,jobs,results,process,async){
return (function (){
var f__12140__auto__ = (function (){var switch__12027__auto__ = ((function (__29369,c__12139__auto___29372,G__29200_29370,n__7324__auto___29368,jobs,results,process,async){
return (function (state_29213){
var state_val_29214 = (state_29213[(1)]);
if((state_val_29214 === (1))){
var state_29213__$1 = state_29213;
var statearr_29215_29373 = state_29213__$1;
(statearr_29215_29373[(2)] = null);

(statearr_29215_29373[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29214 === (2))){
var state_29213__$1 = state_29213;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29213__$1,(4),jobs);
} else {
if((state_val_29214 === (3))){
var inst_29211 = (state_29213[(2)]);
var state_29213__$1 = state_29213;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29213__$1,inst_29211);
} else {
if((state_val_29214 === (4))){
var inst_29203 = (state_29213[(2)]);
var inst_29204 = process(inst_29203);
var state_29213__$1 = state_29213;
if(cljs.core.truth_(inst_29204)){
var statearr_29216_29374 = state_29213__$1;
(statearr_29216_29374[(1)] = (5));

} else {
var statearr_29217_29375 = state_29213__$1;
(statearr_29217_29375[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29214 === (5))){
var state_29213__$1 = state_29213;
var statearr_29218_29376 = state_29213__$1;
(statearr_29218_29376[(2)] = null);

(statearr_29218_29376[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29214 === (6))){
var state_29213__$1 = state_29213;
var statearr_29219_29377 = state_29213__$1;
(statearr_29219_29377[(2)] = null);

(statearr_29219_29377[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29214 === (7))){
var inst_29209 = (state_29213[(2)]);
var state_29213__$1 = state_29213;
var statearr_29220_29378 = state_29213__$1;
(statearr_29220_29378[(2)] = inst_29209);

(statearr_29220_29378[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(__29369,c__12139__auto___29372,G__29200_29370,n__7324__auto___29368,jobs,results,process,async))
;
return ((function (__29369,switch__12027__auto__,c__12139__auto___29372,G__29200_29370,n__7324__auto___29368,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__12028__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__12028__auto____0 = (function (){
var statearr_29224 = [null,null,null,null,null,null,null];
(statearr_29224[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__12028__auto__);

(statearr_29224[(1)] = (1));

return statearr_29224;
});
var cljs$core$async$pipeline_STAR__$_state_machine__12028__auto____1 = (function (state_29213){
while(true){
var ret_value__12029__auto__ = (function (){try{while(true){
var result__12030__auto__ = switch__12027__auto__(state_29213);
if(cljs.core.keyword_identical_QMARK_(result__12030__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12030__auto__;
}
break;
}
}catch (e29225){if((e29225 instanceof Object)){
var ex__12031__auto__ = e29225;
var statearr_29226_29379 = state_29213;
(statearr_29226_29379[(5)] = ex__12031__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_29213);

return cljs.core.cst$kw$recur;
} else {
throw e29225;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12029__auto__,cljs.core.cst$kw$recur)){
var G__29380 = state_29213;
state_29213 = G__29380;
continue;
} else {
return ret_value__12029__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__12028__auto__ = function(state_29213){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__12028__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__12028__auto____1.call(this,state_29213);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__12028__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__12028__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__12028__auto__;
})()
;})(__29369,switch__12027__auto__,c__12139__auto___29372,G__29200_29370,n__7324__auto___29368,jobs,results,process,async))
})();
var state__12141__auto__ = (function (){var statearr_29227 = (f__12140__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12140__auto__.cljs$core$IFn$_invoke$arity$0() : f__12140__auto__.call(null));
(statearr_29227[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12139__auto___29372);

return statearr_29227;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12141__auto__);
});})(__29369,c__12139__auto___29372,G__29200_29370,n__7324__auto___29368,jobs,results,process,async))
);


break;
case "async":
var c__12139__auto___29381 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__29369,c__12139__auto___29381,G__29200_29370,n__7324__auto___29368,jobs,results,process,async){
return (function (){
var f__12140__auto__ = (function (){var switch__12027__auto__ = ((function (__29369,c__12139__auto___29381,G__29200_29370,n__7324__auto___29368,jobs,results,process,async){
return (function (state_29240){
var state_val_29241 = (state_29240[(1)]);
if((state_val_29241 === (1))){
var state_29240__$1 = state_29240;
var statearr_29242_29382 = state_29240__$1;
(statearr_29242_29382[(2)] = null);

(statearr_29242_29382[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29241 === (2))){
var state_29240__$1 = state_29240;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29240__$1,(4),jobs);
} else {
if((state_val_29241 === (3))){
var inst_29238 = (state_29240[(2)]);
var state_29240__$1 = state_29240;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29240__$1,inst_29238);
} else {
if((state_val_29241 === (4))){
var inst_29230 = (state_29240[(2)]);
var inst_29231 = async(inst_29230);
var state_29240__$1 = state_29240;
if(cljs.core.truth_(inst_29231)){
var statearr_29243_29383 = state_29240__$1;
(statearr_29243_29383[(1)] = (5));

} else {
var statearr_29244_29384 = state_29240__$1;
(statearr_29244_29384[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29241 === (5))){
var state_29240__$1 = state_29240;
var statearr_29245_29385 = state_29240__$1;
(statearr_29245_29385[(2)] = null);

(statearr_29245_29385[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29241 === (6))){
var state_29240__$1 = state_29240;
var statearr_29246_29386 = state_29240__$1;
(statearr_29246_29386[(2)] = null);

(statearr_29246_29386[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29241 === (7))){
var inst_29236 = (state_29240[(2)]);
var state_29240__$1 = state_29240;
var statearr_29247_29387 = state_29240__$1;
(statearr_29247_29387[(2)] = inst_29236);

(statearr_29247_29387[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(__29369,c__12139__auto___29381,G__29200_29370,n__7324__auto___29368,jobs,results,process,async))
;
return ((function (__29369,switch__12027__auto__,c__12139__auto___29381,G__29200_29370,n__7324__auto___29368,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__12028__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__12028__auto____0 = (function (){
var statearr_29251 = [null,null,null,null,null,null,null];
(statearr_29251[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__12028__auto__);

(statearr_29251[(1)] = (1));

return statearr_29251;
});
var cljs$core$async$pipeline_STAR__$_state_machine__12028__auto____1 = (function (state_29240){
while(true){
var ret_value__12029__auto__ = (function (){try{while(true){
var result__12030__auto__ = switch__12027__auto__(state_29240);
if(cljs.core.keyword_identical_QMARK_(result__12030__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12030__auto__;
}
break;
}
}catch (e29252){if((e29252 instanceof Object)){
var ex__12031__auto__ = e29252;
var statearr_29253_29388 = state_29240;
(statearr_29253_29388[(5)] = ex__12031__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_29240);

return cljs.core.cst$kw$recur;
} else {
throw e29252;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12029__auto__,cljs.core.cst$kw$recur)){
var G__29389 = state_29240;
state_29240 = G__29389;
continue;
} else {
return ret_value__12029__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__12028__auto__ = function(state_29240){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__12028__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__12028__auto____1.call(this,state_29240);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__12028__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__12028__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__12028__auto__;
})()
;})(__29369,switch__12027__auto__,c__12139__auto___29381,G__29200_29370,n__7324__auto___29368,jobs,results,process,async))
})();
var state__12141__auto__ = (function (){var statearr_29254 = (f__12140__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12140__auto__.cljs$core$IFn$_invoke$arity$0() : f__12140__auto__.call(null));
(statearr_29254[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12139__auto___29381);

return statearr_29254;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12141__auto__);
});})(__29369,c__12139__auto___29381,G__29200_29370,n__7324__auto___29368,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__29390 = (__29369 + (1));
__29369 = G__29390;
continue;
} else {
}
break;
}

var c__12139__auto___29391 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12139__auto___29391,jobs,results,process,async){
return (function (){
var f__12140__auto__ = (function (){var switch__12027__auto__ = ((function (c__12139__auto___29391,jobs,results,process,async){
return (function (state_29276){
var state_val_29277 = (state_29276[(1)]);
if((state_val_29277 === (1))){
var state_29276__$1 = state_29276;
var statearr_29278_29392 = state_29276__$1;
(statearr_29278_29392[(2)] = null);

(statearr_29278_29392[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29277 === (2))){
var state_29276__$1 = state_29276;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29276__$1,(4),from);
} else {
if((state_val_29277 === (3))){
var inst_29274 = (state_29276[(2)]);
var state_29276__$1 = state_29276;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29276__$1,inst_29274);
} else {
if((state_val_29277 === (4))){
var inst_29257 = (state_29276[(7)]);
var inst_29257__$1 = (state_29276[(2)]);
var inst_29258 = (inst_29257__$1 == null);
var state_29276__$1 = (function (){var statearr_29279 = state_29276;
(statearr_29279[(7)] = inst_29257__$1);

return statearr_29279;
})();
if(cljs.core.truth_(inst_29258)){
var statearr_29280_29393 = state_29276__$1;
(statearr_29280_29393[(1)] = (5));

} else {
var statearr_29281_29394 = state_29276__$1;
(statearr_29281_29394[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29277 === (5))){
var inst_29260 = cljs.core.async.close_BANG_(jobs);
var state_29276__$1 = state_29276;
var statearr_29282_29395 = state_29276__$1;
(statearr_29282_29395[(2)] = inst_29260);

(statearr_29282_29395[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29277 === (6))){
var inst_29262 = (state_29276[(8)]);
var inst_29257 = (state_29276[(7)]);
var inst_29262__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_29263 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29264 = [inst_29257,inst_29262__$1];
var inst_29265 = (new cljs.core.PersistentVector(null,2,(5),inst_29263,inst_29264,null));
var state_29276__$1 = (function (){var statearr_29283 = state_29276;
(statearr_29283[(8)] = inst_29262__$1);

return statearr_29283;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_29276__$1,(8),jobs,inst_29265);
} else {
if((state_val_29277 === (7))){
var inst_29272 = (state_29276[(2)]);
var state_29276__$1 = state_29276;
var statearr_29284_29396 = state_29276__$1;
(statearr_29284_29396[(2)] = inst_29272);

(statearr_29284_29396[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29277 === (8))){
var inst_29262 = (state_29276[(8)]);
var inst_29267 = (state_29276[(2)]);
var state_29276__$1 = (function (){var statearr_29285 = state_29276;
(statearr_29285[(9)] = inst_29267);

return statearr_29285;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_29276__$1,(9),results,inst_29262);
} else {
if((state_val_29277 === (9))){
var inst_29269 = (state_29276[(2)]);
var state_29276__$1 = (function (){var statearr_29286 = state_29276;
(statearr_29286[(10)] = inst_29269);

return statearr_29286;
})();
var statearr_29287_29397 = state_29276__$1;
(statearr_29287_29397[(2)] = null);

(statearr_29287_29397[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__12139__auto___29391,jobs,results,process,async))
;
return ((function (switch__12027__auto__,c__12139__auto___29391,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__12028__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__12028__auto____0 = (function (){
var statearr_29291 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_29291[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__12028__auto__);

(statearr_29291[(1)] = (1));

return statearr_29291;
});
var cljs$core$async$pipeline_STAR__$_state_machine__12028__auto____1 = (function (state_29276){
while(true){
var ret_value__12029__auto__ = (function (){try{while(true){
var result__12030__auto__ = switch__12027__auto__(state_29276);
if(cljs.core.keyword_identical_QMARK_(result__12030__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12030__auto__;
}
break;
}
}catch (e29292){if((e29292 instanceof Object)){
var ex__12031__auto__ = e29292;
var statearr_29293_29398 = state_29276;
(statearr_29293_29398[(5)] = ex__12031__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_29276);

return cljs.core.cst$kw$recur;
} else {
throw e29292;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12029__auto__,cljs.core.cst$kw$recur)){
var G__29399 = state_29276;
state_29276 = G__29399;
continue;
} else {
return ret_value__12029__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__12028__auto__ = function(state_29276){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__12028__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__12028__auto____1.call(this,state_29276);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__12028__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__12028__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__12028__auto__;
})()
;})(switch__12027__auto__,c__12139__auto___29391,jobs,results,process,async))
})();
var state__12141__auto__ = (function (){var statearr_29294 = (f__12140__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12140__auto__.cljs$core$IFn$_invoke$arity$0() : f__12140__auto__.call(null));
(statearr_29294[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12139__auto___29391);

return statearr_29294;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12141__auto__);
});})(c__12139__auto___29391,jobs,results,process,async))
);


var c__12139__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12139__auto__,jobs,results,process,async){
return (function (){
var f__12140__auto__ = (function (){var switch__12027__auto__ = ((function (c__12139__auto__,jobs,results,process,async){
return (function (state_29332){
var state_val_29333 = (state_29332[(1)]);
if((state_val_29333 === (7))){
var inst_29328 = (state_29332[(2)]);
var state_29332__$1 = state_29332;
var statearr_29334_29400 = state_29332__$1;
(statearr_29334_29400[(2)] = inst_29328);

(statearr_29334_29400[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29333 === (20))){
var state_29332__$1 = state_29332;
var statearr_29335_29401 = state_29332__$1;
(statearr_29335_29401[(2)] = null);

(statearr_29335_29401[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29333 === (1))){
var state_29332__$1 = state_29332;
var statearr_29336_29402 = state_29332__$1;
(statearr_29336_29402[(2)] = null);

(statearr_29336_29402[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29333 === (4))){
var inst_29297 = (state_29332[(7)]);
var inst_29297__$1 = (state_29332[(2)]);
var inst_29298 = (inst_29297__$1 == null);
var state_29332__$1 = (function (){var statearr_29337 = state_29332;
(statearr_29337[(7)] = inst_29297__$1);

return statearr_29337;
})();
if(cljs.core.truth_(inst_29298)){
var statearr_29338_29403 = state_29332__$1;
(statearr_29338_29403[(1)] = (5));

} else {
var statearr_29339_29404 = state_29332__$1;
(statearr_29339_29404[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29333 === (15))){
var inst_29310 = (state_29332[(8)]);
var state_29332__$1 = state_29332;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_29332__$1,(18),to,inst_29310);
} else {
if((state_val_29333 === (21))){
var inst_29323 = (state_29332[(2)]);
var state_29332__$1 = state_29332;
var statearr_29340_29405 = state_29332__$1;
(statearr_29340_29405[(2)] = inst_29323);

(statearr_29340_29405[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29333 === (13))){
var inst_29325 = (state_29332[(2)]);
var state_29332__$1 = (function (){var statearr_29341 = state_29332;
(statearr_29341[(9)] = inst_29325);

return statearr_29341;
})();
var statearr_29342_29406 = state_29332__$1;
(statearr_29342_29406[(2)] = null);

(statearr_29342_29406[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29333 === (6))){
var inst_29297 = (state_29332[(7)]);
var state_29332__$1 = state_29332;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29332__$1,(11),inst_29297);
} else {
if((state_val_29333 === (17))){
var inst_29318 = (state_29332[(2)]);
var state_29332__$1 = state_29332;
if(cljs.core.truth_(inst_29318)){
var statearr_29343_29407 = state_29332__$1;
(statearr_29343_29407[(1)] = (19));

} else {
var statearr_29344_29408 = state_29332__$1;
(statearr_29344_29408[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29333 === (3))){
var inst_29330 = (state_29332[(2)]);
var state_29332__$1 = state_29332;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29332__$1,inst_29330);
} else {
if((state_val_29333 === (12))){
var inst_29307 = (state_29332[(10)]);
var state_29332__$1 = state_29332;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29332__$1,(14),inst_29307);
} else {
if((state_val_29333 === (2))){
var state_29332__$1 = state_29332;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29332__$1,(4),results);
} else {
if((state_val_29333 === (19))){
var state_29332__$1 = state_29332;
var statearr_29345_29409 = state_29332__$1;
(statearr_29345_29409[(2)] = null);

(statearr_29345_29409[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29333 === (11))){
var inst_29307 = (state_29332[(2)]);
var state_29332__$1 = (function (){var statearr_29346 = state_29332;
(statearr_29346[(10)] = inst_29307);

return statearr_29346;
})();
var statearr_29347_29410 = state_29332__$1;
(statearr_29347_29410[(2)] = null);

(statearr_29347_29410[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29333 === (9))){
var state_29332__$1 = state_29332;
var statearr_29348_29411 = state_29332__$1;
(statearr_29348_29411[(2)] = null);

(statearr_29348_29411[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29333 === (5))){
var state_29332__$1 = state_29332;
if(cljs.core.truth_(close_QMARK_)){
var statearr_29349_29412 = state_29332__$1;
(statearr_29349_29412[(1)] = (8));

} else {
var statearr_29350_29413 = state_29332__$1;
(statearr_29350_29413[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29333 === (14))){
var inst_29310 = (state_29332[(8)]);
var inst_29312 = (state_29332[(11)]);
var inst_29310__$1 = (state_29332[(2)]);
var inst_29311 = (inst_29310__$1 == null);
var inst_29312__$1 = cljs.core.not(inst_29311);
var state_29332__$1 = (function (){var statearr_29351 = state_29332;
(statearr_29351[(8)] = inst_29310__$1);

(statearr_29351[(11)] = inst_29312__$1);

return statearr_29351;
})();
if(inst_29312__$1){
var statearr_29352_29414 = state_29332__$1;
(statearr_29352_29414[(1)] = (15));

} else {
var statearr_29353_29415 = state_29332__$1;
(statearr_29353_29415[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29333 === (16))){
var inst_29312 = (state_29332[(11)]);
var state_29332__$1 = state_29332;
var statearr_29354_29416 = state_29332__$1;
(statearr_29354_29416[(2)] = inst_29312);

(statearr_29354_29416[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29333 === (10))){
var inst_29304 = (state_29332[(2)]);
var state_29332__$1 = state_29332;
var statearr_29355_29417 = state_29332__$1;
(statearr_29355_29417[(2)] = inst_29304);

(statearr_29355_29417[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29333 === (18))){
var inst_29315 = (state_29332[(2)]);
var state_29332__$1 = state_29332;
var statearr_29356_29418 = state_29332__$1;
(statearr_29356_29418[(2)] = inst_29315);

(statearr_29356_29418[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29333 === (8))){
var inst_29301 = cljs.core.async.close_BANG_(to);
var state_29332__$1 = state_29332;
var statearr_29357_29419 = state_29332__$1;
(statearr_29357_29419[(2)] = inst_29301);

(statearr_29357_29419[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12139__auto__,jobs,results,process,async))
;
return ((function (switch__12027__auto__,c__12139__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__12028__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__12028__auto____0 = (function (){
var statearr_29361 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29361[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__12028__auto__);

(statearr_29361[(1)] = (1));

return statearr_29361;
});
var cljs$core$async$pipeline_STAR__$_state_machine__12028__auto____1 = (function (state_29332){
while(true){
var ret_value__12029__auto__ = (function (){try{while(true){
var result__12030__auto__ = switch__12027__auto__(state_29332);
if(cljs.core.keyword_identical_QMARK_(result__12030__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12030__auto__;
}
break;
}
}catch (e29362){if((e29362 instanceof Object)){
var ex__12031__auto__ = e29362;
var statearr_29363_29420 = state_29332;
(statearr_29363_29420[(5)] = ex__12031__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_29332);

return cljs.core.cst$kw$recur;
} else {
throw e29362;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12029__auto__,cljs.core.cst$kw$recur)){
var G__29421 = state_29332;
state_29332 = G__29421;
continue;
} else {
return ret_value__12029__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__12028__auto__ = function(state_29332){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__12028__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__12028__auto____1.call(this,state_29332);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__12028__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__12028__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__12028__auto__;
})()
;})(switch__12027__auto__,c__12139__auto__,jobs,results,process,async))
})();
var state__12141__auto__ = (function (){var statearr_29364 = (f__12140__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12140__auto__.cljs$core$IFn$_invoke$arity$0() : f__12140__auto__.call(null));
(statearr_29364[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12139__auto__);

return statearr_29364;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12141__auto__);
});})(c__12139__auto__,jobs,results,process,async))
);

return c__12139__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args29422 = [];
var len__7484__auto___29425 = arguments.length;
var i__7485__auto___29426 = (0);
while(true){
if((i__7485__auto___29426 < len__7484__auto___29425)){
args29422.push((arguments[i__7485__auto___29426]));

var G__29427 = (i__7485__auto___29426 + (1));
i__7485__auto___29426 = G__29427;
continue;
} else {
}
break;
}

var G__29424 = args29422.length;
switch (G__29424) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args29422.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,cljs.core.cst$kw$async);
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args29429 = [];
var len__7484__auto___29432 = arguments.length;
var i__7485__auto___29433 = (0);
while(true){
if((i__7485__auto___29433 < len__7484__auto___29432)){
args29429.push((arguments[i__7485__auto___29433]));

var G__29434 = (i__7485__auto___29433 + (1));
i__7485__auto___29433 = G__29434;
continue;
} else {
}
break;
}

var G__29431 = args29429.length;
switch (G__29431) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args29429.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,cljs.core.cst$kw$compute);
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args29436 = [];
var len__7484__auto___29489 = arguments.length;
var i__7485__auto___29490 = (0);
while(true){
if((i__7485__auto___29490 < len__7484__auto___29489)){
args29436.push((arguments[i__7485__auto___29490]));

var G__29491 = (i__7485__auto___29490 + (1));
i__7485__auto___29490 = G__29491;
continue;
} else {
}
break;
}

var G__29438 = args29436.length;
switch (G__29438) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args29436.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__12139__auto___29493 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12139__auto___29493,tc,fc){
return (function (){
var f__12140__auto__ = (function (){var switch__12027__auto__ = ((function (c__12139__auto___29493,tc,fc){
return (function (state_29464){
var state_val_29465 = (state_29464[(1)]);
if((state_val_29465 === (7))){
var inst_29460 = (state_29464[(2)]);
var state_29464__$1 = state_29464;
var statearr_29466_29494 = state_29464__$1;
(statearr_29466_29494[(2)] = inst_29460);

(statearr_29466_29494[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29465 === (1))){
var state_29464__$1 = state_29464;
var statearr_29467_29495 = state_29464__$1;
(statearr_29467_29495[(2)] = null);

(statearr_29467_29495[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29465 === (4))){
var inst_29441 = (state_29464[(7)]);
var inst_29441__$1 = (state_29464[(2)]);
var inst_29442 = (inst_29441__$1 == null);
var state_29464__$1 = (function (){var statearr_29468 = state_29464;
(statearr_29468[(7)] = inst_29441__$1);

return statearr_29468;
})();
if(cljs.core.truth_(inst_29442)){
var statearr_29469_29496 = state_29464__$1;
(statearr_29469_29496[(1)] = (5));

} else {
var statearr_29470_29497 = state_29464__$1;
(statearr_29470_29497[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29465 === (13))){
var state_29464__$1 = state_29464;
var statearr_29471_29498 = state_29464__$1;
(statearr_29471_29498[(2)] = null);

(statearr_29471_29498[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29465 === (6))){
var inst_29441 = (state_29464[(7)]);
var inst_29447 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_29441) : p.call(null,inst_29441));
var state_29464__$1 = state_29464;
if(cljs.core.truth_(inst_29447)){
var statearr_29472_29499 = state_29464__$1;
(statearr_29472_29499[(1)] = (9));

} else {
var statearr_29473_29500 = state_29464__$1;
(statearr_29473_29500[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29465 === (3))){
var inst_29462 = (state_29464[(2)]);
var state_29464__$1 = state_29464;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29464__$1,inst_29462);
} else {
if((state_val_29465 === (12))){
var state_29464__$1 = state_29464;
var statearr_29474_29501 = state_29464__$1;
(statearr_29474_29501[(2)] = null);

(statearr_29474_29501[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29465 === (2))){
var state_29464__$1 = state_29464;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29464__$1,(4),ch);
} else {
if((state_val_29465 === (11))){
var inst_29441 = (state_29464[(7)]);
var inst_29451 = (state_29464[(2)]);
var state_29464__$1 = state_29464;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_29464__$1,(8),inst_29451,inst_29441);
} else {
if((state_val_29465 === (9))){
var state_29464__$1 = state_29464;
var statearr_29475_29502 = state_29464__$1;
(statearr_29475_29502[(2)] = tc);

(statearr_29475_29502[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29465 === (5))){
var inst_29444 = cljs.core.async.close_BANG_(tc);
var inst_29445 = cljs.core.async.close_BANG_(fc);
var state_29464__$1 = (function (){var statearr_29476 = state_29464;
(statearr_29476[(8)] = inst_29444);

return statearr_29476;
})();
var statearr_29477_29503 = state_29464__$1;
(statearr_29477_29503[(2)] = inst_29445);

(statearr_29477_29503[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29465 === (14))){
var inst_29458 = (state_29464[(2)]);
var state_29464__$1 = state_29464;
var statearr_29478_29504 = state_29464__$1;
(statearr_29478_29504[(2)] = inst_29458);

(statearr_29478_29504[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29465 === (10))){
var state_29464__$1 = state_29464;
var statearr_29479_29505 = state_29464__$1;
(statearr_29479_29505[(2)] = fc);

(statearr_29479_29505[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29465 === (8))){
var inst_29453 = (state_29464[(2)]);
var state_29464__$1 = state_29464;
if(cljs.core.truth_(inst_29453)){
var statearr_29480_29506 = state_29464__$1;
(statearr_29480_29506[(1)] = (12));

} else {
var statearr_29481_29507 = state_29464__$1;
(statearr_29481_29507[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12139__auto___29493,tc,fc))
;
return ((function (switch__12027__auto__,c__12139__auto___29493,tc,fc){
return (function() {
var cljs$core$async$state_machine__12028__auto__ = null;
var cljs$core$async$state_machine__12028__auto____0 = (function (){
var statearr_29485 = [null,null,null,null,null,null,null,null,null];
(statearr_29485[(0)] = cljs$core$async$state_machine__12028__auto__);

(statearr_29485[(1)] = (1));

return statearr_29485;
});
var cljs$core$async$state_machine__12028__auto____1 = (function (state_29464){
while(true){
var ret_value__12029__auto__ = (function (){try{while(true){
var result__12030__auto__ = switch__12027__auto__(state_29464);
if(cljs.core.keyword_identical_QMARK_(result__12030__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12030__auto__;
}
break;
}
}catch (e29486){if((e29486 instanceof Object)){
var ex__12031__auto__ = e29486;
var statearr_29487_29508 = state_29464;
(statearr_29487_29508[(5)] = ex__12031__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_29464);

return cljs.core.cst$kw$recur;
} else {
throw e29486;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12029__auto__,cljs.core.cst$kw$recur)){
var G__29509 = state_29464;
state_29464 = G__29509;
continue;
} else {
return ret_value__12029__auto__;
}
break;
}
});
cljs$core$async$state_machine__12028__auto__ = function(state_29464){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12028__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12028__auto____1.call(this,state_29464);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12028__auto____0;
cljs$core$async$state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12028__auto____1;
return cljs$core$async$state_machine__12028__auto__;
})()
;})(switch__12027__auto__,c__12139__auto___29493,tc,fc))
})();
var state__12141__auto__ = (function (){var statearr_29488 = (f__12140__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12140__auto__.cljs$core$IFn$_invoke$arity$0() : f__12140__auto__.call(null));
(statearr_29488[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12139__auto___29493);

return statearr_29488;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12141__auto__);
});})(c__12139__auto___29493,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__12139__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12139__auto__){
return (function (){
var f__12140__auto__ = (function (){var switch__12027__auto__ = ((function (c__12139__auto__){
return (function (state_29573){
var state_val_29574 = (state_29573[(1)]);
if((state_val_29574 === (7))){
var inst_29569 = (state_29573[(2)]);
var state_29573__$1 = state_29573;
var statearr_29575_29596 = state_29573__$1;
(statearr_29575_29596[(2)] = inst_29569);

(statearr_29575_29596[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29574 === (1))){
var inst_29553 = init;
var state_29573__$1 = (function (){var statearr_29576 = state_29573;
(statearr_29576[(7)] = inst_29553);

return statearr_29576;
})();
var statearr_29577_29597 = state_29573__$1;
(statearr_29577_29597[(2)] = null);

(statearr_29577_29597[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29574 === (4))){
var inst_29556 = (state_29573[(8)]);
var inst_29556__$1 = (state_29573[(2)]);
var inst_29557 = (inst_29556__$1 == null);
var state_29573__$1 = (function (){var statearr_29578 = state_29573;
(statearr_29578[(8)] = inst_29556__$1);

return statearr_29578;
})();
if(cljs.core.truth_(inst_29557)){
var statearr_29579_29598 = state_29573__$1;
(statearr_29579_29598[(1)] = (5));

} else {
var statearr_29580_29599 = state_29573__$1;
(statearr_29580_29599[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29574 === (6))){
var inst_29560 = (state_29573[(9)]);
var inst_29556 = (state_29573[(8)]);
var inst_29553 = (state_29573[(7)]);
var inst_29560__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_29553,inst_29556) : f.call(null,inst_29553,inst_29556));
var inst_29561 = cljs.core.reduced_QMARK_(inst_29560__$1);
var state_29573__$1 = (function (){var statearr_29581 = state_29573;
(statearr_29581[(9)] = inst_29560__$1);

return statearr_29581;
})();
if(inst_29561){
var statearr_29582_29600 = state_29573__$1;
(statearr_29582_29600[(1)] = (8));

} else {
var statearr_29583_29601 = state_29573__$1;
(statearr_29583_29601[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29574 === (3))){
var inst_29571 = (state_29573[(2)]);
var state_29573__$1 = state_29573;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29573__$1,inst_29571);
} else {
if((state_val_29574 === (2))){
var state_29573__$1 = state_29573;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29573__$1,(4),ch);
} else {
if((state_val_29574 === (9))){
var inst_29560 = (state_29573[(9)]);
var inst_29553 = inst_29560;
var state_29573__$1 = (function (){var statearr_29584 = state_29573;
(statearr_29584[(7)] = inst_29553);

return statearr_29584;
})();
var statearr_29585_29602 = state_29573__$1;
(statearr_29585_29602[(2)] = null);

(statearr_29585_29602[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29574 === (5))){
var inst_29553 = (state_29573[(7)]);
var state_29573__$1 = state_29573;
var statearr_29586_29603 = state_29573__$1;
(statearr_29586_29603[(2)] = inst_29553);

(statearr_29586_29603[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29574 === (10))){
var inst_29567 = (state_29573[(2)]);
var state_29573__$1 = state_29573;
var statearr_29587_29604 = state_29573__$1;
(statearr_29587_29604[(2)] = inst_29567);

(statearr_29587_29604[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29574 === (8))){
var inst_29560 = (state_29573[(9)]);
var inst_29563 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(inst_29560) : cljs.core.deref.call(null,inst_29560));
var state_29573__$1 = state_29573;
var statearr_29588_29605 = state_29573__$1;
(statearr_29588_29605[(2)] = inst_29563);

(statearr_29588_29605[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__12139__auto__))
;
return ((function (switch__12027__auto__,c__12139__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__12028__auto__ = null;
var cljs$core$async$reduce_$_state_machine__12028__auto____0 = (function (){
var statearr_29592 = [null,null,null,null,null,null,null,null,null,null];
(statearr_29592[(0)] = cljs$core$async$reduce_$_state_machine__12028__auto__);

(statearr_29592[(1)] = (1));

return statearr_29592;
});
var cljs$core$async$reduce_$_state_machine__12028__auto____1 = (function (state_29573){
while(true){
var ret_value__12029__auto__ = (function (){try{while(true){
var result__12030__auto__ = switch__12027__auto__(state_29573);
if(cljs.core.keyword_identical_QMARK_(result__12030__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12030__auto__;
}
break;
}
}catch (e29593){if((e29593 instanceof Object)){
var ex__12031__auto__ = e29593;
var statearr_29594_29606 = state_29573;
(statearr_29594_29606[(5)] = ex__12031__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_29573);

return cljs.core.cst$kw$recur;
} else {
throw e29593;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12029__auto__,cljs.core.cst$kw$recur)){
var G__29607 = state_29573;
state_29573 = G__29607;
continue;
} else {
return ret_value__12029__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__12028__auto__ = function(state_29573){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__12028__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__12028__auto____1.call(this,state_29573);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__12028__auto____0;
cljs$core$async$reduce_$_state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__12028__auto____1;
return cljs$core$async$reduce_$_state_machine__12028__auto__;
})()
;})(switch__12027__auto__,c__12139__auto__))
})();
var state__12141__auto__ = (function (){var statearr_29595 = (f__12140__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12140__auto__.cljs$core$IFn$_invoke$arity$0() : f__12140__auto__.call(null));
(statearr_29595[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12139__auto__);

return statearr_29595;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12141__auto__);
});})(c__12139__auto__))
);

return c__12139__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var c__12139__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12139__auto__,f__$1){
return (function (){
var f__12140__auto__ = (function (){var switch__12027__auto__ = ((function (c__12139__auto__,f__$1){
return (function (state_29627){
var state_val_29628 = (state_29627[(1)]);
if((state_val_29628 === (1))){
var inst_29622 = cljs.core.async.reduce(f__$1,init,ch);
var state_29627__$1 = state_29627;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29627__$1,(2),inst_29622);
} else {
if((state_val_29628 === (2))){
var inst_29624 = (state_29627[(2)]);
var inst_29625 = (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(inst_29624) : f__$1.call(null,inst_29624));
var state_29627__$1 = state_29627;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29627__$1,inst_29625);
} else {
return null;
}
}
});})(c__12139__auto__,f__$1))
;
return ((function (switch__12027__auto__,c__12139__auto__,f__$1){
return (function() {
var cljs$core$async$transduce_$_state_machine__12028__auto__ = null;
var cljs$core$async$transduce_$_state_machine__12028__auto____0 = (function (){
var statearr_29632 = [null,null,null,null,null,null,null];
(statearr_29632[(0)] = cljs$core$async$transduce_$_state_machine__12028__auto__);

(statearr_29632[(1)] = (1));

return statearr_29632;
});
var cljs$core$async$transduce_$_state_machine__12028__auto____1 = (function (state_29627){
while(true){
var ret_value__12029__auto__ = (function (){try{while(true){
var result__12030__auto__ = switch__12027__auto__(state_29627);
if(cljs.core.keyword_identical_QMARK_(result__12030__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12030__auto__;
}
break;
}
}catch (e29633){if((e29633 instanceof Object)){
var ex__12031__auto__ = e29633;
var statearr_29634_29636 = state_29627;
(statearr_29634_29636[(5)] = ex__12031__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_29627);

return cljs.core.cst$kw$recur;
} else {
throw e29633;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12029__auto__,cljs.core.cst$kw$recur)){
var G__29637 = state_29627;
state_29627 = G__29637;
continue;
} else {
return ret_value__12029__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__12028__auto__ = function(state_29627){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__12028__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__12028__auto____1.call(this,state_29627);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__12028__auto____0;
cljs$core$async$transduce_$_state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__12028__auto____1;
return cljs$core$async$transduce_$_state_machine__12028__auto__;
})()
;})(switch__12027__auto__,c__12139__auto__,f__$1))
})();
var state__12141__auto__ = (function (){var statearr_29635 = (f__12140__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12140__auto__.cljs$core$IFn$_invoke$arity$0() : f__12140__auto__.call(null));
(statearr_29635[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12139__auto__);

return statearr_29635;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12141__auto__);
});})(c__12139__auto__,f__$1))
);

return c__12139__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args29638 = [];
var len__7484__auto___29690 = arguments.length;
var i__7485__auto___29691 = (0);
while(true){
if((i__7485__auto___29691 < len__7484__auto___29690)){
args29638.push((arguments[i__7485__auto___29691]));

var G__29692 = (i__7485__auto___29691 + (1));
i__7485__auto___29691 = G__29692;
continue;
} else {
}
break;
}

var G__29640 = args29638.length;
switch (G__29640) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args29638.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__12139__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12139__auto__){
return (function (){
var f__12140__auto__ = (function (){var switch__12027__auto__ = ((function (c__12139__auto__){
return (function (state_29665){
var state_val_29666 = (state_29665[(1)]);
if((state_val_29666 === (7))){
var inst_29647 = (state_29665[(2)]);
var state_29665__$1 = state_29665;
var statearr_29667_29694 = state_29665__$1;
(statearr_29667_29694[(2)] = inst_29647);

(statearr_29667_29694[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29666 === (1))){
var inst_29641 = cljs.core.seq(coll);
var inst_29642 = inst_29641;
var state_29665__$1 = (function (){var statearr_29668 = state_29665;
(statearr_29668[(7)] = inst_29642);

return statearr_29668;
})();
var statearr_29669_29695 = state_29665__$1;
(statearr_29669_29695[(2)] = null);

(statearr_29669_29695[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29666 === (4))){
var inst_29642 = (state_29665[(7)]);
var inst_29645 = cljs.core.first(inst_29642);
var state_29665__$1 = state_29665;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_29665__$1,(7),ch,inst_29645);
} else {
if((state_val_29666 === (13))){
var inst_29659 = (state_29665[(2)]);
var state_29665__$1 = state_29665;
var statearr_29670_29696 = state_29665__$1;
(statearr_29670_29696[(2)] = inst_29659);

(statearr_29670_29696[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29666 === (6))){
var inst_29650 = (state_29665[(2)]);
var state_29665__$1 = state_29665;
if(cljs.core.truth_(inst_29650)){
var statearr_29671_29697 = state_29665__$1;
(statearr_29671_29697[(1)] = (8));

} else {
var statearr_29672_29698 = state_29665__$1;
(statearr_29672_29698[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29666 === (3))){
var inst_29663 = (state_29665[(2)]);
var state_29665__$1 = state_29665;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29665__$1,inst_29663);
} else {
if((state_val_29666 === (12))){
var state_29665__$1 = state_29665;
var statearr_29673_29699 = state_29665__$1;
(statearr_29673_29699[(2)] = null);

(statearr_29673_29699[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29666 === (2))){
var inst_29642 = (state_29665[(7)]);
var state_29665__$1 = state_29665;
if(cljs.core.truth_(inst_29642)){
var statearr_29674_29700 = state_29665__$1;
(statearr_29674_29700[(1)] = (4));

} else {
var statearr_29675_29701 = state_29665__$1;
(statearr_29675_29701[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29666 === (11))){
var inst_29656 = cljs.core.async.close_BANG_(ch);
var state_29665__$1 = state_29665;
var statearr_29676_29702 = state_29665__$1;
(statearr_29676_29702[(2)] = inst_29656);

(statearr_29676_29702[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29666 === (9))){
var state_29665__$1 = state_29665;
if(cljs.core.truth_(close_QMARK_)){
var statearr_29677_29703 = state_29665__$1;
(statearr_29677_29703[(1)] = (11));

} else {
var statearr_29678_29704 = state_29665__$1;
(statearr_29678_29704[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29666 === (5))){
var inst_29642 = (state_29665[(7)]);
var state_29665__$1 = state_29665;
var statearr_29679_29705 = state_29665__$1;
(statearr_29679_29705[(2)] = inst_29642);

(statearr_29679_29705[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29666 === (10))){
var inst_29661 = (state_29665[(2)]);
var state_29665__$1 = state_29665;
var statearr_29680_29706 = state_29665__$1;
(statearr_29680_29706[(2)] = inst_29661);

(statearr_29680_29706[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29666 === (8))){
var inst_29642 = (state_29665[(7)]);
var inst_29652 = cljs.core.next(inst_29642);
var inst_29642__$1 = inst_29652;
var state_29665__$1 = (function (){var statearr_29681 = state_29665;
(statearr_29681[(7)] = inst_29642__$1);

return statearr_29681;
})();
var statearr_29682_29707 = state_29665__$1;
(statearr_29682_29707[(2)] = null);

(statearr_29682_29707[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12139__auto__))
;
return ((function (switch__12027__auto__,c__12139__auto__){
return (function() {
var cljs$core$async$state_machine__12028__auto__ = null;
var cljs$core$async$state_machine__12028__auto____0 = (function (){
var statearr_29686 = [null,null,null,null,null,null,null,null];
(statearr_29686[(0)] = cljs$core$async$state_machine__12028__auto__);

(statearr_29686[(1)] = (1));

return statearr_29686;
});
var cljs$core$async$state_machine__12028__auto____1 = (function (state_29665){
while(true){
var ret_value__12029__auto__ = (function (){try{while(true){
var result__12030__auto__ = switch__12027__auto__(state_29665);
if(cljs.core.keyword_identical_QMARK_(result__12030__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12030__auto__;
}
break;
}
}catch (e29687){if((e29687 instanceof Object)){
var ex__12031__auto__ = e29687;
var statearr_29688_29708 = state_29665;
(statearr_29688_29708[(5)] = ex__12031__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_29665);

return cljs.core.cst$kw$recur;
} else {
throw e29687;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12029__auto__,cljs.core.cst$kw$recur)){
var G__29709 = state_29665;
state_29665 = G__29709;
continue;
} else {
return ret_value__12029__auto__;
}
break;
}
});
cljs$core$async$state_machine__12028__auto__ = function(state_29665){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12028__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12028__auto____1.call(this,state_29665);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12028__auto____0;
cljs$core$async$state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12028__auto____1;
return cljs$core$async$state_machine__12028__auto__;
})()
;})(switch__12027__auto__,c__12139__auto__))
})();
var state__12141__auto__ = (function (){var statearr_29689 = (f__12140__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12140__auto__.cljs$core$IFn$_invoke$arity$0() : f__12140__auto__.call(null));
(statearr_29689[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12139__auto__);

return statearr_29689;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12141__auto__);
});})(c__12139__auto__))
);

return c__12139__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__7072__auto__ = (((_ == null))?null:_);
var m__7073__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return (m__7073__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7073__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__7073__auto__.call(null,_));
} else {
var m__7073__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return (m__7073__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7073__auto____$1.cljs$core$IFn$_invoke$arity$1(_) : m__7073__auto____$1.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__7072__auto__ = (((m == null))?null:m);
var m__7073__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return (m__7073__auto__.cljs$core$IFn$_invoke$arity$3 ? m__7073__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__7073__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__7073__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return (m__7073__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__7073__auto____$1.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__7073__auto____$1.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__7072__auto__ = (((m == null))?null:m);
var m__7073__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return (m__7073__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7073__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__7073__auto__.call(null,m,ch));
} else {
var m__7073__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return (m__7073__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7073__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__7073__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__7072__auto__ = (((m == null))?null:m);
var m__7073__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return (m__7073__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7073__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__7073__auto__.call(null,m));
} else {
var m__7073__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return (m__7073__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7073__auto____$1.cljs$core$IFn$_invoke$arity$1(m) : m__7073__auto____$1.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = (function (){var G__29938 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__29938) : cljs.core.atom.call(null,G__29938));
})();
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async29939 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async29939 = (function (mult,ch,cs,meta29940){
this.mult = mult;
this.ch = ch;
this.cs = cs;
this.meta29940 = meta29940;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async29939.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_29941,meta29940__$1){
var self__ = this;
var _29941__$1 = this;
return (new cljs.core.async.t_cljs$core$async29939(self__.mult,self__.ch,self__.cs,meta29940__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async29939.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_29941){
var self__ = this;
var _29941__$1 = this;
return self__.meta29940;
});})(cs))
;

cljs.core.async.t_cljs$core$async29939.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async29939.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async29939.prototype.cljs$core$async$Mult$ = true;

cljs.core.async.t_cljs$core$async29939.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async29939.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async29939.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__29942_30166 = self__.cs;
var G__29943_30167 = cljs.core.PersistentArrayMap.EMPTY;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__29942_30166,G__29943_30167) : cljs.core.reset_BANG_.call(null,G__29942_30166,G__29943_30167));

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async29939.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$mult,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ch], null))),cljs.core.cst$kw$doc,"Creates and returns a mult(iple) of the supplied channel. Channels\n  containing copies of the channel can be created with 'tap', and\n  detached with 'untap'.\n\n  Each item is distributed to all taps in parallel and synchronously,\n  i.e. each tap must accept before the next item is distributed. Use\n  buffering/windowing to prevent slow taps from holding up the mult.\n\n  Items received when there are no taps get dropped.\n\n  If a tap puts to a closed channel, it will be removed from the mult."], null)),cljs.core.cst$sym$ch,cljs.core.cst$sym$cs,cljs.core.cst$sym$meta29940], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async29939.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async29939.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async29939";

cljs.core.async.t_cljs$core$async29939.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"cljs.core.async/t_cljs$core$async29939");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async29939 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async29939(mult__$1,ch__$1,cs__$1,meta29940){
return (new cljs.core.async.t_cljs$core$async29939(mult__$1,ch__$1,cs__$1,meta29940));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async29939(cljs$core$async$mult,ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null) : cljs.core.atom.call(null,null));
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__12139__auto___30168 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12139__auto___30168,cs,m,dchan,dctr,done){
return (function (){
var f__12140__auto__ = (function (){var switch__12027__auto__ = ((function (c__12139__auto___30168,cs,m,dchan,dctr,done){
return (function (state_30078){
var state_val_30079 = (state_30078[(1)]);
if((state_val_30079 === (7))){
var inst_30074 = (state_30078[(2)]);
var state_30078__$1 = state_30078;
var statearr_30080_30169 = state_30078__$1;
(statearr_30080_30169[(2)] = inst_30074);

(statearr_30080_30169[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30079 === (20))){
var inst_29977 = (state_30078[(7)]);
var inst_29989 = cljs.core.first(inst_29977);
var inst_29990 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29989,(0),null);
var inst_29991 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29989,(1),null);
var state_30078__$1 = (function (){var statearr_30081 = state_30078;
(statearr_30081[(8)] = inst_29990);

return statearr_30081;
})();
if(cljs.core.truth_(inst_29991)){
var statearr_30082_30170 = state_30078__$1;
(statearr_30082_30170[(1)] = (22));

} else {
var statearr_30083_30171 = state_30078__$1;
(statearr_30083_30171[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30079 === (27))){
var inst_29946 = (state_30078[(9)]);
var inst_30021 = (state_30078[(10)]);
var inst_30026 = (state_30078[(11)]);
var inst_30019 = (state_30078[(12)]);
var inst_30026__$1 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_30019,inst_30021);
var inst_30027 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_30026__$1,inst_29946,done);
var state_30078__$1 = (function (){var statearr_30084 = state_30078;
(statearr_30084[(11)] = inst_30026__$1);

return statearr_30084;
})();
if(cljs.core.truth_(inst_30027)){
var statearr_30085_30172 = state_30078__$1;
(statearr_30085_30172[(1)] = (30));

} else {
var statearr_30086_30173 = state_30078__$1;
(statearr_30086_30173[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30079 === (1))){
var state_30078__$1 = state_30078;
var statearr_30087_30174 = state_30078__$1;
(statearr_30087_30174[(2)] = null);

(statearr_30087_30174[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30079 === (24))){
var inst_29977 = (state_30078[(7)]);
var inst_29996 = (state_30078[(2)]);
var inst_29997 = cljs.core.next(inst_29977);
var inst_29955 = inst_29997;
var inst_29956 = null;
var inst_29957 = (0);
var inst_29958 = (0);
var state_30078__$1 = (function (){var statearr_30088 = state_30078;
(statearr_30088[(13)] = inst_29955);

(statearr_30088[(14)] = inst_29956);

(statearr_30088[(15)] = inst_29996);

(statearr_30088[(16)] = inst_29958);

(statearr_30088[(17)] = inst_29957);

return statearr_30088;
})();
var statearr_30089_30175 = state_30078__$1;
(statearr_30089_30175[(2)] = null);

(statearr_30089_30175[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30079 === (39))){
var state_30078__$1 = state_30078;
var statearr_30093_30176 = state_30078__$1;
(statearr_30093_30176[(2)] = null);

(statearr_30093_30176[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30079 === (4))){
var inst_29946 = (state_30078[(9)]);
var inst_29946__$1 = (state_30078[(2)]);
var inst_29947 = (inst_29946__$1 == null);
var state_30078__$1 = (function (){var statearr_30094 = state_30078;
(statearr_30094[(9)] = inst_29946__$1);

return statearr_30094;
})();
if(cljs.core.truth_(inst_29947)){
var statearr_30095_30177 = state_30078__$1;
(statearr_30095_30177[(1)] = (5));

} else {
var statearr_30096_30178 = state_30078__$1;
(statearr_30096_30178[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30079 === (15))){
var inst_29955 = (state_30078[(13)]);
var inst_29956 = (state_30078[(14)]);
var inst_29958 = (state_30078[(16)]);
var inst_29957 = (state_30078[(17)]);
var inst_29973 = (state_30078[(2)]);
var inst_29974 = (inst_29958 + (1));
var tmp30090 = inst_29955;
var tmp30091 = inst_29956;
var tmp30092 = inst_29957;
var inst_29955__$1 = tmp30090;
var inst_29956__$1 = tmp30091;
var inst_29957__$1 = tmp30092;
var inst_29958__$1 = inst_29974;
var state_30078__$1 = (function (){var statearr_30097 = state_30078;
(statearr_30097[(13)] = inst_29955__$1);

(statearr_30097[(14)] = inst_29956__$1);

(statearr_30097[(16)] = inst_29958__$1);

(statearr_30097[(17)] = inst_29957__$1);

(statearr_30097[(18)] = inst_29973);

return statearr_30097;
})();
var statearr_30098_30179 = state_30078__$1;
(statearr_30098_30179[(2)] = null);

(statearr_30098_30179[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30079 === (21))){
var inst_30000 = (state_30078[(2)]);
var state_30078__$1 = state_30078;
var statearr_30102_30180 = state_30078__$1;
(statearr_30102_30180[(2)] = inst_30000);

(statearr_30102_30180[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30079 === (31))){
var inst_30026 = (state_30078[(11)]);
var inst_30030 = done(null);
var inst_30031 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_30026);
var state_30078__$1 = (function (){var statearr_30103 = state_30078;
(statearr_30103[(19)] = inst_30030);

return statearr_30103;
})();
var statearr_30104_30181 = state_30078__$1;
(statearr_30104_30181[(2)] = inst_30031);

(statearr_30104_30181[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30079 === (32))){
var inst_30018 = (state_30078[(20)]);
var inst_30021 = (state_30078[(10)]);
var inst_30020 = (state_30078[(21)]);
var inst_30019 = (state_30078[(12)]);
var inst_30033 = (state_30078[(2)]);
var inst_30034 = (inst_30021 + (1));
var tmp30099 = inst_30018;
var tmp30100 = inst_30020;
var tmp30101 = inst_30019;
var inst_30018__$1 = tmp30099;
var inst_30019__$1 = tmp30101;
var inst_30020__$1 = tmp30100;
var inst_30021__$1 = inst_30034;
var state_30078__$1 = (function (){var statearr_30105 = state_30078;
(statearr_30105[(20)] = inst_30018__$1);

(statearr_30105[(10)] = inst_30021__$1);

(statearr_30105[(21)] = inst_30020__$1);

(statearr_30105[(22)] = inst_30033);

(statearr_30105[(12)] = inst_30019__$1);

return statearr_30105;
})();
var statearr_30106_30182 = state_30078__$1;
(statearr_30106_30182[(2)] = null);

(statearr_30106_30182[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30079 === (40))){
var inst_30046 = (state_30078[(23)]);
var inst_30050 = done(null);
var inst_30051 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_30046);
var state_30078__$1 = (function (){var statearr_30107 = state_30078;
(statearr_30107[(24)] = inst_30050);

return statearr_30107;
})();
var statearr_30108_30183 = state_30078__$1;
(statearr_30108_30183[(2)] = inst_30051);

(statearr_30108_30183[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30079 === (33))){
var inst_30037 = (state_30078[(25)]);
var inst_30039 = cljs.core.chunked_seq_QMARK_(inst_30037);
var state_30078__$1 = state_30078;
if(inst_30039){
var statearr_30109_30184 = state_30078__$1;
(statearr_30109_30184[(1)] = (36));

} else {
var statearr_30110_30185 = state_30078__$1;
(statearr_30110_30185[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30079 === (13))){
var inst_29967 = (state_30078[(26)]);
var inst_29970 = cljs.core.async.close_BANG_(inst_29967);
var state_30078__$1 = state_30078;
var statearr_30111_30186 = state_30078__$1;
(statearr_30111_30186[(2)] = inst_29970);

(statearr_30111_30186[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30079 === (22))){
var inst_29990 = (state_30078[(8)]);
var inst_29993 = cljs.core.async.close_BANG_(inst_29990);
var state_30078__$1 = state_30078;
var statearr_30112_30187 = state_30078__$1;
(statearr_30112_30187[(2)] = inst_29993);

(statearr_30112_30187[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30079 === (36))){
var inst_30037 = (state_30078[(25)]);
var inst_30041 = cljs.core.chunk_first(inst_30037);
var inst_30042 = cljs.core.chunk_rest(inst_30037);
var inst_30043 = cljs.core.count(inst_30041);
var inst_30018 = inst_30042;
var inst_30019 = inst_30041;
var inst_30020 = inst_30043;
var inst_30021 = (0);
var state_30078__$1 = (function (){var statearr_30113 = state_30078;
(statearr_30113[(20)] = inst_30018);

(statearr_30113[(10)] = inst_30021);

(statearr_30113[(21)] = inst_30020);

(statearr_30113[(12)] = inst_30019);

return statearr_30113;
})();
var statearr_30114_30188 = state_30078__$1;
(statearr_30114_30188[(2)] = null);

(statearr_30114_30188[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30079 === (41))){
var inst_30037 = (state_30078[(25)]);
var inst_30053 = (state_30078[(2)]);
var inst_30054 = cljs.core.next(inst_30037);
var inst_30018 = inst_30054;
var inst_30019 = null;
var inst_30020 = (0);
var inst_30021 = (0);
var state_30078__$1 = (function (){var statearr_30115 = state_30078;
(statearr_30115[(20)] = inst_30018);

(statearr_30115[(10)] = inst_30021);

(statearr_30115[(21)] = inst_30020);

(statearr_30115[(27)] = inst_30053);

(statearr_30115[(12)] = inst_30019);

return statearr_30115;
})();
var statearr_30116_30189 = state_30078__$1;
(statearr_30116_30189[(2)] = null);

(statearr_30116_30189[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30079 === (43))){
var state_30078__$1 = state_30078;
var statearr_30117_30190 = state_30078__$1;
(statearr_30117_30190[(2)] = null);

(statearr_30117_30190[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30079 === (29))){
var inst_30062 = (state_30078[(2)]);
var state_30078__$1 = state_30078;
var statearr_30118_30191 = state_30078__$1;
(statearr_30118_30191[(2)] = inst_30062);

(statearr_30118_30191[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30079 === (44))){
var inst_30071 = (state_30078[(2)]);
var state_30078__$1 = (function (){var statearr_30119 = state_30078;
(statearr_30119[(28)] = inst_30071);

return statearr_30119;
})();
var statearr_30120_30192 = state_30078__$1;
(statearr_30120_30192[(2)] = null);

(statearr_30120_30192[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30079 === (6))){
var inst_30010 = (state_30078[(29)]);
var inst_30009 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cs) : cljs.core.deref.call(null,cs));
var inst_30010__$1 = cljs.core.keys(inst_30009);
var inst_30011 = cljs.core.count(inst_30010__$1);
var inst_30012 = (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,inst_30011) : cljs.core.reset_BANG_.call(null,dctr,inst_30011));
var inst_30017 = cljs.core.seq(inst_30010__$1);
var inst_30018 = inst_30017;
var inst_30019 = null;
var inst_30020 = (0);
var inst_30021 = (0);
var state_30078__$1 = (function (){var statearr_30121 = state_30078;
(statearr_30121[(20)] = inst_30018);

(statearr_30121[(29)] = inst_30010__$1);

(statearr_30121[(10)] = inst_30021);

(statearr_30121[(21)] = inst_30020);

(statearr_30121[(30)] = inst_30012);

(statearr_30121[(12)] = inst_30019);

return statearr_30121;
})();
var statearr_30122_30193 = state_30078__$1;
(statearr_30122_30193[(2)] = null);

(statearr_30122_30193[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30079 === (28))){
var inst_30018 = (state_30078[(20)]);
var inst_30037 = (state_30078[(25)]);
var inst_30037__$1 = cljs.core.seq(inst_30018);
var state_30078__$1 = (function (){var statearr_30123 = state_30078;
(statearr_30123[(25)] = inst_30037__$1);

return statearr_30123;
})();
if(inst_30037__$1){
var statearr_30124_30194 = state_30078__$1;
(statearr_30124_30194[(1)] = (33));

} else {
var statearr_30125_30195 = state_30078__$1;
(statearr_30125_30195[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30079 === (25))){
var inst_30021 = (state_30078[(10)]);
var inst_30020 = (state_30078[(21)]);
var inst_30023 = (inst_30021 < inst_30020);
var inst_30024 = inst_30023;
var state_30078__$1 = state_30078;
if(cljs.core.truth_(inst_30024)){
var statearr_30126_30196 = state_30078__$1;
(statearr_30126_30196[(1)] = (27));

} else {
var statearr_30127_30197 = state_30078__$1;
(statearr_30127_30197[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30079 === (34))){
var state_30078__$1 = state_30078;
var statearr_30128_30198 = state_30078__$1;
(statearr_30128_30198[(2)] = null);

(statearr_30128_30198[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30079 === (17))){
var state_30078__$1 = state_30078;
var statearr_30129_30199 = state_30078__$1;
(statearr_30129_30199[(2)] = null);

(statearr_30129_30199[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30079 === (3))){
var inst_30076 = (state_30078[(2)]);
var state_30078__$1 = state_30078;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30078__$1,inst_30076);
} else {
if((state_val_30079 === (12))){
var inst_30005 = (state_30078[(2)]);
var state_30078__$1 = state_30078;
var statearr_30130_30200 = state_30078__$1;
(statearr_30130_30200[(2)] = inst_30005);

(statearr_30130_30200[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30079 === (2))){
var state_30078__$1 = state_30078;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30078__$1,(4),ch);
} else {
if((state_val_30079 === (23))){
var state_30078__$1 = state_30078;
var statearr_30131_30201 = state_30078__$1;
(statearr_30131_30201[(2)] = null);

(statearr_30131_30201[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30079 === (35))){
var inst_30060 = (state_30078[(2)]);
var state_30078__$1 = state_30078;
var statearr_30132_30202 = state_30078__$1;
(statearr_30132_30202[(2)] = inst_30060);

(statearr_30132_30202[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30079 === (19))){
var inst_29977 = (state_30078[(7)]);
var inst_29981 = cljs.core.chunk_first(inst_29977);
var inst_29982 = cljs.core.chunk_rest(inst_29977);
var inst_29983 = cljs.core.count(inst_29981);
var inst_29955 = inst_29982;
var inst_29956 = inst_29981;
var inst_29957 = inst_29983;
var inst_29958 = (0);
var state_30078__$1 = (function (){var statearr_30133 = state_30078;
(statearr_30133[(13)] = inst_29955);

(statearr_30133[(14)] = inst_29956);

(statearr_30133[(16)] = inst_29958);

(statearr_30133[(17)] = inst_29957);

return statearr_30133;
})();
var statearr_30134_30203 = state_30078__$1;
(statearr_30134_30203[(2)] = null);

(statearr_30134_30203[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30079 === (11))){
var inst_29955 = (state_30078[(13)]);
var inst_29977 = (state_30078[(7)]);
var inst_29977__$1 = cljs.core.seq(inst_29955);
var state_30078__$1 = (function (){var statearr_30135 = state_30078;
(statearr_30135[(7)] = inst_29977__$1);

return statearr_30135;
})();
if(inst_29977__$1){
var statearr_30136_30204 = state_30078__$1;
(statearr_30136_30204[(1)] = (16));

} else {
var statearr_30137_30205 = state_30078__$1;
(statearr_30137_30205[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30079 === (9))){
var inst_30007 = (state_30078[(2)]);
var state_30078__$1 = state_30078;
var statearr_30138_30206 = state_30078__$1;
(statearr_30138_30206[(2)] = inst_30007);

(statearr_30138_30206[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30079 === (5))){
var inst_29953 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cs) : cljs.core.deref.call(null,cs));
var inst_29954 = cljs.core.seq(inst_29953);
var inst_29955 = inst_29954;
var inst_29956 = null;
var inst_29957 = (0);
var inst_29958 = (0);
var state_30078__$1 = (function (){var statearr_30139 = state_30078;
(statearr_30139[(13)] = inst_29955);

(statearr_30139[(14)] = inst_29956);

(statearr_30139[(16)] = inst_29958);

(statearr_30139[(17)] = inst_29957);

return statearr_30139;
})();
var statearr_30140_30207 = state_30078__$1;
(statearr_30140_30207[(2)] = null);

(statearr_30140_30207[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30079 === (14))){
var state_30078__$1 = state_30078;
var statearr_30141_30208 = state_30078__$1;
(statearr_30141_30208[(2)] = null);

(statearr_30141_30208[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30079 === (45))){
var inst_30068 = (state_30078[(2)]);
var state_30078__$1 = state_30078;
var statearr_30142_30209 = state_30078__$1;
(statearr_30142_30209[(2)] = inst_30068);

(statearr_30142_30209[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30079 === (26))){
var inst_30010 = (state_30078[(29)]);
var inst_30064 = (state_30078[(2)]);
var inst_30065 = cljs.core.seq(inst_30010);
var state_30078__$1 = (function (){var statearr_30143 = state_30078;
(statearr_30143[(31)] = inst_30064);

return statearr_30143;
})();
if(inst_30065){
var statearr_30144_30210 = state_30078__$1;
(statearr_30144_30210[(1)] = (42));

} else {
var statearr_30145_30211 = state_30078__$1;
(statearr_30145_30211[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30079 === (16))){
var inst_29977 = (state_30078[(7)]);
var inst_29979 = cljs.core.chunked_seq_QMARK_(inst_29977);
var state_30078__$1 = state_30078;
if(inst_29979){
var statearr_30146_30212 = state_30078__$1;
(statearr_30146_30212[(1)] = (19));

} else {
var statearr_30147_30213 = state_30078__$1;
(statearr_30147_30213[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30079 === (38))){
var inst_30057 = (state_30078[(2)]);
var state_30078__$1 = state_30078;
var statearr_30148_30214 = state_30078__$1;
(statearr_30148_30214[(2)] = inst_30057);

(statearr_30148_30214[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30079 === (30))){
var state_30078__$1 = state_30078;
var statearr_30149_30215 = state_30078__$1;
(statearr_30149_30215[(2)] = null);

(statearr_30149_30215[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30079 === (10))){
var inst_29956 = (state_30078[(14)]);
var inst_29958 = (state_30078[(16)]);
var inst_29966 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_29956,inst_29958);
var inst_29967 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29966,(0),null);
var inst_29968 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29966,(1),null);
var state_30078__$1 = (function (){var statearr_30150 = state_30078;
(statearr_30150[(26)] = inst_29967);

return statearr_30150;
})();
if(cljs.core.truth_(inst_29968)){
var statearr_30151_30216 = state_30078__$1;
(statearr_30151_30216[(1)] = (13));

} else {
var statearr_30152_30217 = state_30078__$1;
(statearr_30152_30217[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30079 === (18))){
var inst_30003 = (state_30078[(2)]);
var state_30078__$1 = state_30078;
var statearr_30153_30218 = state_30078__$1;
(statearr_30153_30218[(2)] = inst_30003);

(statearr_30153_30218[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30079 === (42))){
var state_30078__$1 = state_30078;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30078__$1,(45),dchan);
} else {
if((state_val_30079 === (37))){
var inst_29946 = (state_30078[(9)]);
var inst_30037 = (state_30078[(25)]);
var inst_30046 = (state_30078[(23)]);
var inst_30046__$1 = cljs.core.first(inst_30037);
var inst_30047 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_30046__$1,inst_29946,done);
var state_30078__$1 = (function (){var statearr_30154 = state_30078;
(statearr_30154[(23)] = inst_30046__$1);

return statearr_30154;
})();
if(cljs.core.truth_(inst_30047)){
var statearr_30155_30219 = state_30078__$1;
(statearr_30155_30219[(1)] = (39));

} else {
var statearr_30156_30220 = state_30078__$1;
(statearr_30156_30220[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30079 === (8))){
var inst_29958 = (state_30078[(16)]);
var inst_29957 = (state_30078[(17)]);
var inst_29960 = (inst_29958 < inst_29957);
var inst_29961 = inst_29960;
var state_30078__$1 = state_30078;
if(cljs.core.truth_(inst_29961)){
var statearr_30157_30221 = state_30078__$1;
(statearr_30157_30221[(1)] = (10));

} else {
var statearr_30158_30222 = state_30078__$1;
(statearr_30158_30222[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12139__auto___30168,cs,m,dchan,dctr,done))
;
return ((function (switch__12027__auto__,c__12139__auto___30168,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__12028__auto__ = null;
var cljs$core$async$mult_$_state_machine__12028__auto____0 = (function (){
var statearr_30162 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30162[(0)] = cljs$core$async$mult_$_state_machine__12028__auto__);

(statearr_30162[(1)] = (1));

return statearr_30162;
});
var cljs$core$async$mult_$_state_machine__12028__auto____1 = (function (state_30078){
while(true){
var ret_value__12029__auto__ = (function (){try{while(true){
var result__12030__auto__ = switch__12027__auto__(state_30078);
if(cljs.core.keyword_identical_QMARK_(result__12030__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12030__auto__;
}
break;
}
}catch (e30163){if((e30163 instanceof Object)){
var ex__12031__auto__ = e30163;
var statearr_30164_30223 = state_30078;
(statearr_30164_30223[(5)] = ex__12031__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_30078);

return cljs.core.cst$kw$recur;
} else {
throw e30163;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12029__auto__,cljs.core.cst$kw$recur)){
var G__30224 = state_30078;
state_30078 = G__30224;
continue;
} else {
return ret_value__12029__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__12028__auto__ = function(state_30078){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__12028__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__12028__auto____1.call(this,state_30078);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__12028__auto____0;
cljs$core$async$mult_$_state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__12028__auto____1;
return cljs$core$async$mult_$_state_machine__12028__auto__;
})()
;})(switch__12027__auto__,c__12139__auto___30168,cs,m,dchan,dctr,done))
})();
var state__12141__auto__ = (function (){var statearr_30165 = (f__12140__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12140__auto__.cljs$core$IFn$_invoke$arity$0() : f__12140__auto__.call(null));
(statearr_30165[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12139__auto___30168);

return statearr_30165;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12141__auto__);
});})(c__12139__auto___30168,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args30225 = [];
var len__7484__auto___30228 = arguments.length;
var i__7485__auto___30229 = (0);
while(true){
if((i__7485__auto___30229 < len__7484__auto___30228)){
args30225.push((arguments[i__7485__auto___30229]));

var G__30230 = (i__7485__auto___30229 + (1));
i__7485__auto___30229 = G__30230;
continue;
} else {
}
break;
}

var G__30227 = args30225.length;
switch (G__30227) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30225.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__7072__auto__ = (((m == null))?null:m);
var m__7073__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return (m__7073__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7073__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__7073__auto__.call(null,m,ch));
} else {
var m__7073__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return (m__7073__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7073__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__7073__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__7072__auto__ = (((m == null))?null:m);
var m__7073__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return (m__7073__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7073__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__7073__auto__.call(null,m,ch));
} else {
var m__7073__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return (m__7073__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7073__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__7073__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__7072__auto__ = (((m == null))?null:m);
var m__7073__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return (m__7073__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7073__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__7073__auto__.call(null,m));
} else {
var m__7073__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return (m__7073__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7073__auto____$1.cljs$core$IFn$_invoke$arity$1(m) : m__7073__auto____$1.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__7072__auto__ = (((m == null))?null:m);
var m__7073__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return (m__7073__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7073__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__7073__auto__.call(null,m,state_map));
} else {
var m__7073__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return (m__7073__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7073__auto____$1.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__7073__auto____$1.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__7072__auto__ = (((m == null))?null:m);
var m__7073__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return (m__7073__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7073__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__7073__auto__.call(null,m,mode));
} else {
var m__7073__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return (m__7073__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7073__auto____$1.cljs$core$IFn$_invoke$arity$2(m,mode) : m__7073__auto____$1.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__7491__auto__ = [];
var len__7484__auto___30242 = arguments.length;
var i__7485__auto___30243 = (0);
while(true){
if((i__7485__auto___30243 < len__7484__auto___30242)){
args__7491__auto__.push((arguments[i__7485__auto___30243]));

var G__30244 = (i__7485__auto___30243 + (1));
i__7485__auto___30243 = G__30244;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((3) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7492__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__30236){
var map__30237 = p__30236;
var map__30237__$1 = ((((!((map__30237 == null)))?((((map__30237.cljs$lang$protocol_mask$partition0$ & (64))) || (map__30237.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__30237):map__30237);
var opts = map__30237__$1;
var statearr_30239_30245 = state;
(statearr_30239_30245[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__4657__auto__ = cljs.core.async.do_alts(((function (map__30237,map__30237__$1,opts){
return (function (val){
var statearr_30240_30246 = state;
(statearr_30240_30246[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
});})(map__30237,map__30237__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4657__auto__)){
var cb = temp__4657__auto__;
var statearr_30241_30247 = state;
(statearr_30241_30247[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cb) : cljs.core.deref.call(null,cb)));


return cljs.core.cst$kw$recur;
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq30232){
var G__30233 = cljs.core.first(seq30232);
var seq30232__$1 = cljs.core.next(seq30232);
var G__30234 = cljs.core.first(seq30232__$1);
var seq30232__$2 = cljs.core.next(seq30232__$1);
var G__30235 = cljs.core.first(seq30232__$2);
var seq30232__$3 = cljs.core.next(seq30232__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__30233,G__30234,G__30235,seq30232__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = (function (){var G__30417 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__30417) : cljs.core.atom.call(null,G__30417));
})();
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$pause,null,cljs.core.cst$kw$mute,null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,cljs.core.cst$kw$solo);
var solo_mode = (function (){var G__30418 = cljs.core.cst$kw$mute;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__30418) : cljs.core.atom.call(null,G__30418));
})();
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv(((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cs) : cljs.core.deref.call(null,cs));
var mode = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(solo_mode) : cljs.core.deref.call(null,solo_mode));
var solos = pick(cljs.core.cst$kw$solo,chs);
var pauses = pick(cljs.core.cst$kw$pause,chs);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$solos,solos,cljs.core.cst$kw$mutes,pick(cljs.core.cst$kw$mute,chs),cljs.core.cst$kw$reads,cljs.core.conj.cljs$core$IFn$_invoke$arity$2((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,cljs.core.cst$kw$pause)) && (!(cljs.core.empty_QMARK_(solos))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async30419 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async30419 = (function (change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta30420){
this.change = change;
this.mix = mix;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta30420 = meta30420;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async30419.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_30421,meta30420__$1){
var self__ = this;
var _30421__$1 = this;
return (new cljs.core.async.t_cljs$core$async30419(self__.change,self__.mix,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta30420__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async30419.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_30421){
var self__ = this;
var _30421__$1 = this;
return self__.meta30420;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async30419.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async30419.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async30419.prototype.cljs$core$async$Mix$ = true;

cljs.core.async.t_cljs$core$async30419.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async30419.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async30419.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__30422_30586 = self__.cs;
var G__30423_30587 = cljs.core.PersistentArrayMap.EMPTY;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__30422_30586,G__30423_30587) : cljs.core.reset_BANG_.call(null,G__30422_30586,G__30423_30587));

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async30419.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async30419.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str("(solo-modes mode)")].join('')));
}

(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(self__.solo_mode,mode) : cljs.core.reset_BANG_.call(null,self__.solo_mode,mode));

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async30419.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$change,cljs.core.with_meta(cljs.core.cst$sym$mix,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$out], null))),cljs.core.cst$kw$doc,"Creates and returns a mix of one or more input channels which will\n  be put on the supplied out channel. Input sources can be added to\n  the mix with 'admix', and removed with 'unmix'. A mix supports\n  soloing, muting and pausing multiple inputs atomically using\n  'toggle', and can solo using either muting or pausing as determined\n  by 'solo-mode'.\n\n  Each channel can have zero or more boolean modes set via 'toggle':\n\n  :solo - when true, only this (ond other soloed) channel(s) will appear\n          in the mix output channel. :mute and :pause states of soloed\n          channels are ignored. If solo-mode is :mute, non-soloed\n          channels are muted, if :pause, non-soloed channels are\n          paused.\n\n  :mute - muted channels will have their contents consumed but not included in the mix\n  :pause - paused channels will not have their contents consumed (and thus also not included in the mix)\n"], null)),cljs.core.cst$sym$solo_DASH_mode,cljs.core.cst$sym$pick,cljs.core.cst$sym$cs,cljs.core.cst$sym$calc_DASH_state,cljs.core.cst$sym$out,cljs.core.cst$sym$changed,cljs.core.cst$sym$solo_DASH_modes,cljs.core.cst$sym$attrs,cljs.core.cst$sym$meta30420], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async30419.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async30419.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async30419";

cljs.core.async.t_cljs$core$async30419.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"cljs.core.async/t_cljs$core$async30419");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async30419 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async30419(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta30420){
return (new cljs.core.async.t_cljs$core$async30419(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta30420));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async30419(change,cljs$core$async$mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__12139__auto___30588 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12139__auto___30588,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__12140__auto__ = (function (){var switch__12027__auto__ = ((function (c__12139__auto___30588,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_30523){
var state_val_30524 = (state_30523[(1)]);
if((state_val_30524 === (7))){
var inst_30439 = (state_30523[(2)]);
var state_30523__$1 = state_30523;
var statearr_30525_30589 = state_30523__$1;
(statearr_30525_30589[(2)] = inst_30439);

(statearr_30525_30589[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30524 === (20))){
var inst_30451 = (state_30523[(7)]);
var state_30523__$1 = state_30523;
var statearr_30526_30590 = state_30523__$1;
(statearr_30526_30590[(2)] = inst_30451);

(statearr_30526_30590[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30524 === (27))){
var state_30523__$1 = state_30523;
var statearr_30527_30591 = state_30523__$1;
(statearr_30527_30591[(2)] = null);

(statearr_30527_30591[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30524 === (1))){
var inst_30427 = (state_30523[(8)]);
var inst_30427__$1 = calc_state();
var inst_30429 = (inst_30427__$1 == null);
var inst_30430 = cljs.core.not(inst_30429);
var state_30523__$1 = (function (){var statearr_30528 = state_30523;
(statearr_30528[(8)] = inst_30427__$1);

return statearr_30528;
})();
if(inst_30430){
var statearr_30529_30592 = state_30523__$1;
(statearr_30529_30592[(1)] = (2));

} else {
var statearr_30530_30593 = state_30523__$1;
(statearr_30530_30593[(1)] = (3));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30524 === (24))){
var inst_30474 = (state_30523[(9)]);
var inst_30483 = (state_30523[(10)]);
var inst_30497 = (state_30523[(11)]);
var inst_30497__$1 = (inst_30474.cljs$core$IFn$_invoke$arity$1 ? inst_30474.cljs$core$IFn$_invoke$arity$1(inst_30483) : inst_30474.call(null,inst_30483));
var state_30523__$1 = (function (){var statearr_30531 = state_30523;
(statearr_30531[(11)] = inst_30497__$1);

return statearr_30531;
})();
if(cljs.core.truth_(inst_30497__$1)){
var statearr_30532_30594 = state_30523__$1;
(statearr_30532_30594[(1)] = (29));

} else {
var statearr_30533_30595 = state_30523__$1;
(statearr_30533_30595[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30524 === (4))){
var inst_30442 = (state_30523[(2)]);
var state_30523__$1 = state_30523;
if(cljs.core.truth_(inst_30442)){
var statearr_30534_30596 = state_30523__$1;
(statearr_30534_30596[(1)] = (8));

} else {
var statearr_30535_30597 = state_30523__$1;
(statearr_30535_30597[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30524 === (15))){
var inst_30468 = (state_30523[(2)]);
var state_30523__$1 = state_30523;
if(cljs.core.truth_(inst_30468)){
var statearr_30536_30598 = state_30523__$1;
(statearr_30536_30598[(1)] = (19));

} else {
var statearr_30537_30599 = state_30523__$1;
(statearr_30537_30599[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30524 === (21))){
var inst_30473 = (state_30523[(12)]);
var inst_30473__$1 = (state_30523[(2)]);
var inst_30474 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_30473__$1,cljs.core.cst$kw$solos);
var inst_30475 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_30473__$1,cljs.core.cst$kw$mutes);
var inst_30476 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_30473__$1,cljs.core.cst$kw$reads);
var state_30523__$1 = (function (){var statearr_30538 = state_30523;
(statearr_30538[(12)] = inst_30473__$1);

(statearr_30538[(9)] = inst_30474);

(statearr_30538[(13)] = inst_30475);

return statearr_30538;
})();
return cljs.core.async.ioc_alts_BANG_(state_30523__$1,(22),inst_30476);
} else {
if((state_val_30524 === (31))){
var inst_30505 = (state_30523[(2)]);
var state_30523__$1 = state_30523;
if(cljs.core.truth_(inst_30505)){
var statearr_30539_30600 = state_30523__$1;
(statearr_30539_30600[(1)] = (32));

} else {
var statearr_30540_30601 = state_30523__$1;
(statearr_30540_30601[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30524 === (32))){
var inst_30482 = (state_30523[(14)]);
var state_30523__$1 = state_30523;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30523__$1,(35),out,inst_30482);
} else {
if((state_val_30524 === (33))){
var inst_30473 = (state_30523[(12)]);
var inst_30451 = inst_30473;
var state_30523__$1 = (function (){var statearr_30541 = state_30523;
(statearr_30541[(7)] = inst_30451);

return statearr_30541;
})();
var statearr_30542_30602 = state_30523__$1;
(statearr_30542_30602[(2)] = null);

(statearr_30542_30602[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30524 === (13))){
var inst_30451 = (state_30523[(7)]);
var inst_30458 = inst_30451.cljs$lang$protocol_mask$partition0$;
var inst_30459 = (inst_30458 & (64));
var inst_30460 = inst_30451.cljs$core$ISeq$;
var inst_30461 = (inst_30459) || (inst_30460);
var state_30523__$1 = state_30523;
if(cljs.core.truth_(inst_30461)){
var statearr_30543_30603 = state_30523__$1;
(statearr_30543_30603[(1)] = (16));

} else {
var statearr_30544_30604 = state_30523__$1;
(statearr_30544_30604[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30524 === (22))){
var inst_30483 = (state_30523[(10)]);
var inst_30482 = (state_30523[(14)]);
var inst_30481 = (state_30523[(2)]);
var inst_30482__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30481,(0),null);
var inst_30483__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30481,(1),null);
var inst_30484 = (inst_30482__$1 == null);
var inst_30485 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_30483__$1,change);
var inst_30486 = (inst_30484) || (inst_30485);
var state_30523__$1 = (function (){var statearr_30545 = state_30523;
(statearr_30545[(10)] = inst_30483__$1);

(statearr_30545[(14)] = inst_30482__$1);

return statearr_30545;
})();
if(cljs.core.truth_(inst_30486)){
var statearr_30546_30605 = state_30523__$1;
(statearr_30546_30605[(1)] = (23));

} else {
var statearr_30547_30606 = state_30523__$1;
(statearr_30547_30606[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30524 === (36))){
var inst_30473 = (state_30523[(12)]);
var inst_30451 = inst_30473;
var state_30523__$1 = (function (){var statearr_30548 = state_30523;
(statearr_30548[(7)] = inst_30451);

return statearr_30548;
})();
var statearr_30549_30607 = state_30523__$1;
(statearr_30549_30607[(2)] = null);

(statearr_30549_30607[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30524 === (29))){
var inst_30497 = (state_30523[(11)]);
var state_30523__$1 = state_30523;
var statearr_30550_30608 = state_30523__$1;
(statearr_30550_30608[(2)] = inst_30497);

(statearr_30550_30608[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30524 === (6))){
var state_30523__$1 = state_30523;
var statearr_30551_30609 = state_30523__$1;
(statearr_30551_30609[(2)] = false);

(statearr_30551_30609[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30524 === (28))){
var inst_30493 = (state_30523[(2)]);
var inst_30494 = calc_state();
var inst_30451 = inst_30494;
var state_30523__$1 = (function (){var statearr_30552 = state_30523;
(statearr_30552[(7)] = inst_30451);

(statearr_30552[(15)] = inst_30493);

return statearr_30552;
})();
var statearr_30553_30610 = state_30523__$1;
(statearr_30553_30610[(2)] = null);

(statearr_30553_30610[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30524 === (25))){
var inst_30519 = (state_30523[(2)]);
var state_30523__$1 = state_30523;
var statearr_30554_30611 = state_30523__$1;
(statearr_30554_30611[(2)] = inst_30519);

(statearr_30554_30611[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30524 === (34))){
var inst_30517 = (state_30523[(2)]);
var state_30523__$1 = state_30523;
var statearr_30555_30612 = state_30523__$1;
(statearr_30555_30612[(2)] = inst_30517);

(statearr_30555_30612[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30524 === (17))){
var state_30523__$1 = state_30523;
var statearr_30556_30613 = state_30523__$1;
(statearr_30556_30613[(2)] = false);

(statearr_30556_30613[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30524 === (3))){
var state_30523__$1 = state_30523;
var statearr_30557_30614 = state_30523__$1;
(statearr_30557_30614[(2)] = false);

(statearr_30557_30614[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30524 === (12))){
var inst_30521 = (state_30523[(2)]);
var state_30523__$1 = state_30523;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30523__$1,inst_30521);
} else {
if((state_val_30524 === (2))){
var inst_30427 = (state_30523[(8)]);
var inst_30432 = inst_30427.cljs$lang$protocol_mask$partition0$;
var inst_30433 = (inst_30432 & (64));
var inst_30434 = inst_30427.cljs$core$ISeq$;
var inst_30435 = (inst_30433) || (inst_30434);
var state_30523__$1 = state_30523;
if(cljs.core.truth_(inst_30435)){
var statearr_30558_30615 = state_30523__$1;
(statearr_30558_30615[(1)] = (5));

} else {
var statearr_30559_30616 = state_30523__$1;
(statearr_30559_30616[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30524 === (23))){
var inst_30482 = (state_30523[(14)]);
var inst_30488 = (inst_30482 == null);
var state_30523__$1 = state_30523;
if(cljs.core.truth_(inst_30488)){
var statearr_30560_30617 = state_30523__$1;
(statearr_30560_30617[(1)] = (26));

} else {
var statearr_30561_30618 = state_30523__$1;
(statearr_30561_30618[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30524 === (35))){
var inst_30508 = (state_30523[(2)]);
var state_30523__$1 = state_30523;
if(cljs.core.truth_(inst_30508)){
var statearr_30562_30619 = state_30523__$1;
(statearr_30562_30619[(1)] = (36));

} else {
var statearr_30563_30620 = state_30523__$1;
(statearr_30563_30620[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30524 === (19))){
var inst_30451 = (state_30523[(7)]);
var inst_30470 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_30451);
var state_30523__$1 = state_30523;
var statearr_30564_30621 = state_30523__$1;
(statearr_30564_30621[(2)] = inst_30470);

(statearr_30564_30621[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30524 === (11))){
var inst_30451 = (state_30523[(7)]);
var inst_30455 = (inst_30451 == null);
var inst_30456 = cljs.core.not(inst_30455);
var state_30523__$1 = state_30523;
if(inst_30456){
var statearr_30565_30622 = state_30523__$1;
(statearr_30565_30622[(1)] = (13));

} else {
var statearr_30566_30623 = state_30523__$1;
(statearr_30566_30623[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30524 === (9))){
var inst_30427 = (state_30523[(8)]);
var state_30523__$1 = state_30523;
var statearr_30567_30624 = state_30523__$1;
(statearr_30567_30624[(2)] = inst_30427);

(statearr_30567_30624[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30524 === (5))){
var state_30523__$1 = state_30523;
var statearr_30568_30625 = state_30523__$1;
(statearr_30568_30625[(2)] = true);

(statearr_30568_30625[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30524 === (14))){
var state_30523__$1 = state_30523;
var statearr_30569_30626 = state_30523__$1;
(statearr_30569_30626[(2)] = false);

(statearr_30569_30626[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30524 === (26))){
var inst_30483 = (state_30523[(10)]);
var inst_30490 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_30483);
var state_30523__$1 = state_30523;
var statearr_30570_30627 = state_30523__$1;
(statearr_30570_30627[(2)] = inst_30490);

(statearr_30570_30627[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30524 === (16))){
var state_30523__$1 = state_30523;
var statearr_30571_30628 = state_30523__$1;
(statearr_30571_30628[(2)] = true);

(statearr_30571_30628[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30524 === (38))){
var inst_30513 = (state_30523[(2)]);
var state_30523__$1 = state_30523;
var statearr_30572_30629 = state_30523__$1;
(statearr_30572_30629[(2)] = inst_30513);

(statearr_30572_30629[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30524 === (30))){
var inst_30474 = (state_30523[(9)]);
var inst_30475 = (state_30523[(13)]);
var inst_30483 = (state_30523[(10)]);
var inst_30500 = cljs.core.empty_QMARK_(inst_30474);
var inst_30501 = (inst_30475.cljs$core$IFn$_invoke$arity$1 ? inst_30475.cljs$core$IFn$_invoke$arity$1(inst_30483) : inst_30475.call(null,inst_30483));
var inst_30502 = cljs.core.not(inst_30501);
var inst_30503 = (inst_30500) && (inst_30502);
var state_30523__$1 = state_30523;
var statearr_30573_30630 = state_30523__$1;
(statearr_30573_30630[(2)] = inst_30503);

(statearr_30573_30630[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30524 === (10))){
var inst_30427 = (state_30523[(8)]);
var inst_30447 = (state_30523[(2)]);
var inst_30448 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_30447,cljs.core.cst$kw$solos);
var inst_30449 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_30447,cljs.core.cst$kw$mutes);
var inst_30450 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_30447,cljs.core.cst$kw$reads);
var inst_30451 = inst_30427;
var state_30523__$1 = (function (){var statearr_30574 = state_30523;
(statearr_30574[(16)] = inst_30449);

(statearr_30574[(7)] = inst_30451);

(statearr_30574[(17)] = inst_30448);

(statearr_30574[(18)] = inst_30450);

return statearr_30574;
})();
var statearr_30575_30631 = state_30523__$1;
(statearr_30575_30631[(2)] = null);

(statearr_30575_30631[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30524 === (18))){
var inst_30465 = (state_30523[(2)]);
var state_30523__$1 = state_30523;
var statearr_30576_30632 = state_30523__$1;
(statearr_30576_30632[(2)] = inst_30465);

(statearr_30576_30632[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30524 === (37))){
var state_30523__$1 = state_30523;
var statearr_30577_30633 = state_30523__$1;
(statearr_30577_30633[(2)] = null);

(statearr_30577_30633[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30524 === (8))){
var inst_30427 = (state_30523[(8)]);
var inst_30444 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_30427);
var state_30523__$1 = state_30523;
var statearr_30578_30634 = state_30523__$1;
(statearr_30578_30634[(2)] = inst_30444);

(statearr_30578_30634[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12139__auto___30588,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__12027__auto__,c__12139__auto___30588,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__12028__auto__ = null;
var cljs$core$async$mix_$_state_machine__12028__auto____0 = (function (){
var statearr_30582 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30582[(0)] = cljs$core$async$mix_$_state_machine__12028__auto__);

(statearr_30582[(1)] = (1));

return statearr_30582;
});
var cljs$core$async$mix_$_state_machine__12028__auto____1 = (function (state_30523){
while(true){
var ret_value__12029__auto__ = (function (){try{while(true){
var result__12030__auto__ = switch__12027__auto__(state_30523);
if(cljs.core.keyword_identical_QMARK_(result__12030__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12030__auto__;
}
break;
}
}catch (e30583){if((e30583 instanceof Object)){
var ex__12031__auto__ = e30583;
var statearr_30584_30635 = state_30523;
(statearr_30584_30635[(5)] = ex__12031__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_30523);

return cljs.core.cst$kw$recur;
} else {
throw e30583;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12029__auto__,cljs.core.cst$kw$recur)){
var G__30636 = state_30523;
state_30523 = G__30636;
continue;
} else {
return ret_value__12029__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__12028__auto__ = function(state_30523){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__12028__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__12028__auto____1.call(this,state_30523);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__12028__auto____0;
cljs$core$async$mix_$_state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__12028__auto____1;
return cljs$core$async$mix_$_state_machine__12028__auto__;
})()
;})(switch__12027__auto__,c__12139__auto___30588,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__12141__auto__ = (function (){var statearr_30585 = (f__12140__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12140__auto__.cljs$core$IFn$_invoke$arity$0() : f__12140__auto__.call(null));
(statearr_30585[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12139__auto___30588);

return statearr_30585;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12141__auto__);
});})(c__12139__auto___30588,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__7072__auto__ = (((p == null))?null:p);
var m__7073__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return (m__7073__auto__.cljs$core$IFn$_invoke$arity$4 ? m__7073__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__7073__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__7073__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return (m__7073__auto____$1.cljs$core$IFn$_invoke$arity$4 ? m__7073__auto____$1.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__7073__auto____$1.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__7072__auto__ = (((p == null))?null:p);
var m__7073__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return (m__7073__auto__.cljs$core$IFn$_invoke$arity$3 ? m__7073__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__7073__auto__.call(null,p,v,ch));
} else {
var m__7073__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return (m__7073__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__7073__auto____$1.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__7073__auto____$1.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args30637 = [];
var len__7484__auto___30640 = arguments.length;
var i__7485__auto___30641 = (0);
while(true){
if((i__7485__auto___30641 < len__7484__auto___30640)){
args30637.push((arguments[i__7485__auto___30641]));

var G__30642 = (i__7485__auto___30641 + (1));
i__7485__auto___30641 = G__30642;
continue;
} else {
}
break;
}

var G__30639 = args30637.length;
switch (G__30639) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30637.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__7072__auto__ = (((p == null))?null:p);
var m__7073__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return (m__7073__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7073__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__7073__auto__.call(null,p));
} else {
var m__7073__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return (m__7073__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7073__auto____$1.cljs$core$IFn$_invoke$arity$1(p) : m__7073__auto____$1.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__7072__auto__ = (((p == null))?null:p);
var m__7073__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return (m__7073__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7073__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__7073__auto__.call(null,p,v));
} else {
var m__7073__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return (m__7073__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7073__auto____$1.cljs$core$IFn$_invoke$arity$2(p,v) : m__7073__auto____$1.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args30645 = [];
var len__7484__auto___30773 = arguments.length;
var i__7485__auto___30774 = (0);
while(true){
if((i__7485__auto___30774 < len__7484__auto___30773)){
args30645.push((arguments[i__7485__auto___30774]));

var G__30775 = (i__7485__auto___30774 + (1));
i__7485__auto___30774 = G__30775;
continue;
} else {
}
break;
}

var G__30647 = args30645.length;
switch (G__30647) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30645.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = (function (){var G__30648 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__30648) : cljs.core.atom.call(null,G__30648));
})();
var ensure_mult = ((function (mults){
return (function (topic){
var or__6409__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(mults) : cljs.core.deref.call(null,mults)),topic);
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,((function (or__6409__auto__,mults){
return (function (p1__30644_SHARP_){
if(cljs.core.truth_((p1__30644_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__30644_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__30644_SHARP_.call(null,topic)))){
return p1__30644_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__30644_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
});})(or__6409__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async30649 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async30649 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta30650){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta30650 = meta30650;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async30649.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_30651,meta30650__$1){
var self__ = this;
var _30651__$1 = this;
return (new cljs.core.async.t_cljs$core$async30649(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta30650__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async30649.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_30651){
var self__ = this;
var _30651__$1 = this;
return self__.meta30650;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async30649.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async30649.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async30649.prototype.cljs$core$async$Pub$ = true;

cljs.core.async.t_cljs$core$async30649.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async30649.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4657__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(self__.mults) : cljs.core.deref.call(null,self__.mults)),topic);
if(cljs.core.truth_(temp__4657__auto__)){
var m = temp__4657__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async30649.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__30652 = self__.mults;
var G__30653 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__30652,G__30653) : cljs.core.reset_BANG_.call(null,G__30652,G__30653));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async30649.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async30649.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ch,cljs.core.cst$sym$topic_DASH_fn,cljs.core.cst$sym$buf_DASH_fn,cljs.core.cst$sym$mults,cljs.core.cst$sym$ensure_DASH_mult,cljs.core.cst$sym$meta30650], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async30649.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async30649.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async30649";

cljs.core.async.t_cljs$core$async30649.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"cljs.core.async/t_cljs$core$async30649");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async30649 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async30649(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta30650){
return (new cljs.core.async.t_cljs$core$async30649(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta30650));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async30649(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__12139__auto___30777 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12139__auto___30777,mults,ensure_mult,p){
return (function (){
var f__12140__auto__ = (function (){var switch__12027__auto__ = ((function (c__12139__auto___30777,mults,ensure_mult,p){
return (function (state_30725){
var state_val_30726 = (state_30725[(1)]);
if((state_val_30726 === (7))){
var inst_30721 = (state_30725[(2)]);
var state_30725__$1 = state_30725;
var statearr_30727_30778 = state_30725__$1;
(statearr_30727_30778[(2)] = inst_30721);

(statearr_30727_30778[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30726 === (20))){
var state_30725__$1 = state_30725;
var statearr_30728_30779 = state_30725__$1;
(statearr_30728_30779[(2)] = null);

(statearr_30728_30779[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30726 === (1))){
var state_30725__$1 = state_30725;
var statearr_30729_30780 = state_30725__$1;
(statearr_30729_30780[(2)] = null);

(statearr_30729_30780[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30726 === (24))){
var inst_30704 = (state_30725[(7)]);
var inst_30713 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_30704);
var state_30725__$1 = state_30725;
var statearr_30730_30781 = state_30725__$1;
(statearr_30730_30781[(2)] = inst_30713);

(statearr_30730_30781[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30726 === (4))){
var inst_30656 = (state_30725[(8)]);
var inst_30656__$1 = (state_30725[(2)]);
var inst_30657 = (inst_30656__$1 == null);
var state_30725__$1 = (function (){var statearr_30731 = state_30725;
(statearr_30731[(8)] = inst_30656__$1);

return statearr_30731;
})();
if(cljs.core.truth_(inst_30657)){
var statearr_30732_30782 = state_30725__$1;
(statearr_30732_30782[(1)] = (5));

} else {
var statearr_30733_30783 = state_30725__$1;
(statearr_30733_30783[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30726 === (15))){
var inst_30698 = (state_30725[(2)]);
var state_30725__$1 = state_30725;
var statearr_30734_30784 = state_30725__$1;
(statearr_30734_30784[(2)] = inst_30698);

(statearr_30734_30784[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30726 === (21))){
var inst_30718 = (state_30725[(2)]);
var state_30725__$1 = (function (){var statearr_30735 = state_30725;
(statearr_30735[(9)] = inst_30718);

return statearr_30735;
})();
var statearr_30736_30785 = state_30725__$1;
(statearr_30736_30785[(2)] = null);

(statearr_30736_30785[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30726 === (13))){
var inst_30680 = (state_30725[(10)]);
var inst_30682 = cljs.core.chunked_seq_QMARK_(inst_30680);
var state_30725__$1 = state_30725;
if(inst_30682){
var statearr_30737_30786 = state_30725__$1;
(statearr_30737_30786[(1)] = (16));

} else {
var statearr_30738_30787 = state_30725__$1;
(statearr_30738_30787[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30726 === (22))){
var inst_30710 = (state_30725[(2)]);
var state_30725__$1 = state_30725;
if(cljs.core.truth_(inst_30710)){
var statearr_30739_30788 = state_30725__$1;
(statearr_30739_30788[(1)] = (23));

} else {
var statearr_30740_30789 = state_30725__$1;
(statearr_30740_30789[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30726 === (6))){
var inst_30706 = (state_30725[(11)]);
var inst_30704 = (state_30725[(7)]);
var inst_30656 = (state_30725[(8)]);
var inst_30704__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_30656) : topic_fn.call(null,inst_30656));
var inst_30705 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(mults) : cljs.core.deref.call(null,mults));
var inst_30706__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_30705,inst_30704__$1);
var state_30725__$1 = (function (){var statearr_30741 = state_30725;
(statearr_30741[(11)] = inst_30706__$1);

(statearr_30741[(7)] = inst_30704__$1);

return statearr_30741;
})();
if(cljs.core.truth_(inst_30706__$1)){
var statearr_30742_30790 = state_30725__$1;
(statearr_30742_30790[(1)] = (19));

} else {
var statearr_30743_30791 = state_30725__$1;
(statearr_30743_30791[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30726 === (25))){
var inst_30715 = (state_30725[(2)]);
var state_30725__$1 = state_30725;
var statearr_30744_30792 = state_30725__$1;
(statearr_30744_30792[(2)] = inst_30715);

(statearr_30744_30792[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30726 === (17))){
var inst_30680 = (state_30725[(10)]);
var inst_30689 = cljs.core.first(inst_30680);
var inst_30690 = cljs.core.async.muxch_STAR_(inst_30689);
var inst_30691 = cljs.core.async.close_BANG_(inst_30690);
var inst_30692 = cljs.core.next(inst_30680);
var inst_30666 = inst_30692;
var inst_30667 = null;
var inst_30668 = (0);
var inst_30669 = (0);
var state_30725__$1 = (function (){var statearr_30745 = state_30725;
(statearr_30745[(12)] = inst_30668);

(statearr_30745[(13)] = inst_30666);

(statearr_30745[(14)] = inst_30691);

(statearr_30745[(15)] = inst_30669);

(statearr_30745[(16)] = inst_30667);

return statearr_30745;
})();
var statearr_30746_30793 = state_30725__$1;
(statearr_30746_30793[(2)] = null);

(statearr_30746_30793[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30726 === (3))){
var inst_30723 = (state_30725[(2)]);
var state_30725__$1 = state_30725;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30725__$1,inst_30723);
} else {
if((state_val_30726 === (12))){
var inst_30700 = (state_30725[(2)]);
var state_30725__$1 = state_30725;
var statearr_30747_30794 = state_30725__$1;
(statearr_30747_30794[(2)] = inst_30700);

(statearr_30747_30794[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30726 === (2))){
var state_30725__$1 = state_30725;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30725__$1,(4),ch);
} else {
if((state_val_30726 === (23))){
var state_30725__$1 = state_30725;
var statearr_30748_30795 = state_30725__$1;
(statearr_30748_30795[(2)] = null);

(statearr_30748_30795[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30726 === (19))){
var inst_30706 = (state_30725[(11)]);
var inst_30656 = (state_30725[(8)]);
var inst_30708 = cljs.core.async.muxch_STAR_(inst_30706);
var state_30725__$1 = state_30725;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30725__$1,(22),inst_30708,inst_30656);
} else {
if((state_val_30726 === (11))){
var inst_30666 = (state_30725[(13)]);
var inst_30680 = (state_30725[(10)]);
var inst_30680__$1 = cljs.core.seq(inst_30666);
var state_30725__$1 = (function (){var statearr_30749 = state_30725;
(statearr_30749[(10)] = inst_30680__$1);

return statearr_30749;
})();
if(inst_30680__$1){
var statearr_30750_30796 = state_30725__$1;
(statearr_30750_30796[(1)] = (13));

} else {
var statearr_30751_30797 = state_30725__$1;
(statearr_30751_30797[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30726 === (9))){
var inst_30702 = (state_30725[(2)]);
var state_30725__$1 = state_30725;
var statearr_30752_30798 = state_30725__$1;
(statearr_30752_30798[(2)] = inst_30702);

(statearr_30752_30798[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30726 === (5))){
var inst_30663 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(mults) : cljs.core.deref.call(null,mults));
var inst_30664 = cljs.core.vals(inst_30663);
var inst_30665 = cljs.core.seq(inst_30664);
var inst_30666 = inst_30665;
var inst_30667 = null;
var inst_30668 = (0);
var inst_30669 = (0);
var state_30725__$1 = (function (){var statearr_30753 = state_30725;
(statearr_30753[(12)] = inst_30668);

(statearr_30753[(13)] = inst_30666);

(statearr_30753[(15)] = inst_30669);

(statearr_30753[(16)] = inst_30667);

return statearr_30753;
})();
var statearr_30754_30799 = state_30725__$1;
(statearr_30754_30799[(2)] = null);

(statearr_30754_30799[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30726 === (14))){
var state_30725__$1 = state_30725;
var statearr_30758_30800 = state_30725__$1;
(statearr_30758_30800[(2)] = null);

(statearr_30758_30800[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30726 === (16))){
var inst_30680 = (state_30725[(10)]);
var inst_30684 = cljs.core.chunk_first(inst_30680);
var inst_30685 = cljs.core.chunk_rest(inst_30680);
var inst_30686 = cljs.core.count(inst_30684);
var inst_30666 = inst_30685;
var inst_30667 = inst_30684;
var inst_30668 = inst_30686;
var inst_30669 = (0);
var state_30725__$1 = (function (){var statearr_30759 = state_30725;
(statearr_30759[(12)] = inst_30668);

(statearr_30759[(13)] = inst_30666);

(statearr_30759[(15)] = inst_30669);

(statearr_30759[(16)] = inst_30667);

return statearr_30759;
})();
var statearr_30760_30801 = state_30725__$1;
(statearr_30760_30801[(2)] = null);

(statearr_30760_30801[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30726 === (10))){
var inst_30668 = (state_30725[(12)]);
var inst_30666 = (state_30725[(13)]);
var inst_30669 = (state_30725[(15)]);
var inst_30667 = (state_30725[(16)]);
var inst_30674 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_30667,inst_30669);
var inst_30675 = cljs.core.async.muxch_STAR_(inst_30674);
var inst_30676 = cljs.core.async.close_BANG_(inst_30675);
var inst_30677 = (inst_30669 + (1));
var tmp30755 = inst_30668;
var tmp30756 = inst_30666;
var tmp30757 = inst_30667;
var inst_30666__$1 = tmp30756;
var inst_30667__$1 = tmp30757;
var inst_30668__$1 = tmp30755;
var inst_30669__$1 = inst_30677;
var state_30725__$1 = (function (){var statearr_30761 = state_30725;
(statearr_30761[(12)] = inst_30668__$1);

(statearr_30761[(13)] = inst_30666__$1);

(statearr_30761[(15)] = inst_30669__$1);

(statearr_30761[(16)] = inst_30667__$1);

(statearr_30761[(17)] = inst_30676);

return statearr_30761;
})();
var statearr_30762_30802 = state_30725__$1;
(statearr_30762_30802[(2)] = null);

(statearr_30762_30802[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30726 === (18))){
var inst_30695 = (state_30725[(2)]);
var state_30725__$1 = state_30725;
var statearr_30763_30803 = state_30725__$1;
(statearr_30763_30803[(2)] = inst_30695);

(statearr_30763_30803[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30726 === (8))){
var inst_30668 = (state_30725[(12)]);
var inst_30669 = (state_30725[(15)]);
var inst_30671 = (inst_30669 < inst_30668);
var inst_30672 = inst_30671;
var state_30725__$1 = state_30725;
if(cljs.core.truth_(inst_30672)){
var statearr_30764_30804 = state_30725__$1;
(statearr_30764_30804[(1)] = (10));

} else {
var statearr_30765_30805 = state_30725__$1;
(statearr_30765_30805[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12139__auto___30777,mults,ensure_mult,p))
;
return ((function (switch__12027__auto__,c__12139__auto___30777,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__12028__auto__ = null;
var cljs$core$async$state_machine__12028__auto____0 = (function (){
var statearr_30769 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30769[(0)] = cljs$core$async$state_machine__12028__auto__);

(statearr_30769[(1)] = (1));

return statearr_30769;
});
var cljs$core$async$state_machine__12028__auto____1 = (function (state_30725){
while(true){
var ret_value__12029__auto__ = (function (){try{while(true){
var result__12030__auto__ = switch__12027__auto__(state_30725);
if(cljs.core.keyword_identical_QMARK_(result__12030__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12030__auto__;
}
break;
}
}catch (e30770){if((e30770 instanceof Object)){
var ex__12031__auto__ = e30770;
var statearr_30771_30806 = state_30725;
(statearr_30771_30806[(5)] = ex__12031__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_30725);

return cljs.core.cst$kw$recur;
} else {
throw e30770;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12029__auto__,cljs.core.cst$kw$recur)){
var G__30807 = state_30725;
state_30725 = G__30807;
continue;
} else {
return ret_value__12029__auto__;
}
break;
}
});
cljs$core$async$state_machine__12028__auto__ = function(state_30725){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12028__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12028__auto____1.call(this,state_30725);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12028__auto____0;
cljs$core$async$state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12028__auto____1;
return cljs$core$async$state_machine__12028__auto__;
})()
;})(switch__12027__auto__,c__12139__auto___30777,mults,ensure_mult,p))
})();
var state__12141__auto__ = (function (){var statearr_30772 = (f__12140__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12140__auto__.cljs$core$IFn$_invoke$arity$0() : f__12140__auto__.call(null));
(statearr_30772[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12139__auto___30777);

return statearr_30772;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12141__auto__);
});})(c__12139__auto___30777,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args30808 = [];
var len__7484__auto___30811 = arguments.length;
var i__7485__auto___30812 = (0);
while(true){
if((i__7485__auto___30812 < len__7484__auto___30811)){
args30808.push((arguments[i__7485__auto___30812]));

var G__30813 = (i__7485__auto___30812 + (1));
i__7485__auto___30812 = G__30813;
continue;
} else {
}
break;
}

var G__30810 = args30808.length;
switch (G__30810) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30808.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args30815 = [];
var len__7484__auto___30818 = arguments.length;
var i__7485__auto___30819 = (0);
while(true){
if((i__7485__auto___30819 < len__7484__auto___30818)){
args30815.push((arguments[i__7485__auto___30819]));

var G__30820 = (i__7485__auto___30819 + (1));
i__7485__auto___30819 = G__30820;
continue;
} else {
}
break;
}

var G__30817 = args30815.length;
switch (G__30817) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30815.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1(p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2(p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args30822 = [];
var len__7484__auto___30893 = arguments.length;
var i__7485__auto___30894 = (0);
while(true){
if((i__7485__auto___30894 < len__7484__auto___30893)){
args30822.push((arguments[i__7485__auto___30894]));

var G__30895 = (i__7485__auto___30894 + (1));
i__7485__auto___30894 = G__30895;
continue;
} else {
}
break;
}

var G__30824 = args30822.length;
switch (G__30824) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30822.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null) : cljs.core.atom.call(null,null));
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
var c__12139__auto___30897 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12139__auto___30897,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__12140__auto__ = (function (){var switch__12027__auto__ = ((function (c__12139__auto___30897,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_30863){
var state_val_30864 = (state_30863[(1)]);
if((state_val_30864 === (7))){
var state_30863__$1 = state_30863;
var statearr_30865_30898 = state_30863__$1;
(statearr_30865_30898[(2)] = null);

(statearr_30865_30898[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30864 === (1))){
var state_30863__$1 = state_30863;
var statearr_30866_30899 = state_30863__$1;
(statearr_30866_30899[(2)] = null);

(statearr_30866_30899[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30864 === (4))){
var inst_30827 = (state_30863[(7)]);
var inst_30829 = (inst_30827 < cnt);
var state_30863__$1 = state_30863;
if(cljs.core.truth_(inst_30829)){
var statearr_30867_30900 = state_30863__$1;
(statearr_30867_30900[(1)] = (6));

} else {
var statearr_30868_30901 = state_30863__$1;
(statearr_30868_30901[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30864 === (15))){
var inst_30859 = (state_30863[(2)]);
var state_30863__$1 = state_30863;
var statearr_30869_30902 = state_30863__$1;
(statearr_30869_30902[(2)] = inst_30859);

(statearr_30869_30902[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30864 === (13))){
var inst_30852 = cljs.core.async.close_BANG_(out);
var state_30863__$1 = state_30863;
var statearr_30870_30903 = state_30863__$1;
(statearr_30870_30903[(2)] = inst_30852);

(statearr_30870_30903[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30864 === (6))){
var state_30863__$1 = state_30863;
var statearr_30871_30904 = state_30863__$1;
(statearr_30871_30904[(2)] = null);

(statearr_30871_30904[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30864 === (3))){
var inst_30861 = (state_30863[(2)]);
var state_30863__$1 = state_30863;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30863__$1,inst_30861);
} else {
if((state_val_30864 === (12))){
var inst_30849 = (state_30863[(8)]);
var inst_30849__$1 = (state_30863[(2)]);
var inst_30850 = cljs.core.some(cljs.core.nil_QMARK_,inst_30849__$1);
var state_30863__$1 = (function (){var statearr_30872 = state_30863;
(statearr_30872[(8)] = inst_30849__$1);

return statearr_30872;
})();
if(cljs.core.truth_(inst_30850)){
var statearr_30873_30905 = state_30863__$1;
(statearr_30873_30905[(1)] = (13));

} else {
var statearr_30874_30906 = state_30863__$1;
(statearr_30874_30906[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30864 === (2))){
var inst_30826 = (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cnt) : cljs.core.reset_BANG_.call(null,dctr,cnt));
var inst_30827 = (0);
var state_30863__$1 = (function (){var statearr_30875 = state_30863;
(statearr_30875[(9)] = inst_30826);

(statearr_30875[(7)] = inst_30827);

return statearr_30875;
})();
var statearr_30876_30907 = state_30863__$1;
(statearr_30876_30907[(2)] = null);

(statearr_30876_30907[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30864 === (11))){
var inst_30827 = (state_30863[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_30863,(10),Object,null,(9));
var inst_30836 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_30827) : chs__$1.call(null,inst_30827));
var inst_30837 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_30827) : done.call(null,inst_30827));
var inst_30838 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_30836,inst_30837);
var state_30863__$1 = state_30863;
var statearr_30877_30908 = state_30863__$1;
(statearr_30877_30908[(2)] = inst_30838);


cljs.core.async.impl.ioc_helpers.process_exception(state_30863__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_30864 === (9))){
var inst_30827 = (state_30863[(7)]);
var inst_30840 = (state_30863[(2)]);
var inst_30841 = (inst_30827 + (1));
var inst_30827__$1 = inst_30841;
var state_30863__$1 = (function (){var statearr_30878 = state_30863;
(statearr_30878[(7)] = inst_30827__$1);

(statearr_30878[(10)] = inst_30840);

return statearr_30878;
})();
var statearr_30879_30909 = state_30863__$1;
(statearr_30879_30909[(2)] = null);

(statearr_30879_30909[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30864 === (5))){
var inst_30847 = (state_30863[(2)]);
var state_30863__$1 = (function (){var statearr_30880 = state_30863;
(statearr_30880[(11)] = inst_30847);

return statearr_30880;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30863__$1,(12),dchan);
} else {
if((state_val_30864 === (14))){
var inst_30849 = (state_30863[(8)]);
var inst_30854 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_30849);
var state_30863__$1 = state_30863;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30863__$1,(16),out,inst_30854);
} else {
if((state_val_30864 === (16))){
var inst_30856 = (state_30863[(2)]);
var state_30863__$1 = (function (){var statearr_30881 = state_30863;
(statearr_30881[(12)] = inst_30856);

return statearr_30881;
})();
var statearr_30882_30910 = state_30863__$1;
(statearr_30882_30910[(2)] = null);

(statearr_30882_30910[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30864 === (10))){
var inst_30831 = (state_30863[(2)]);
var inst_30832 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_30863__$1 = (function (){var statearr_30883 = state_30863;
(statearr_30883[(13)] = inst_30831);

return statearr_30883;
})();
var statearr_30884_30911 = state_30863__$1;
(statearr_30884_30911[(2)] = inst_30832);


cljs.core.async.impl.ioc_helpers.process_exception(state_30863__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_30864 === (8))){
var inst_30845 = (state_30863[(2)]);
var state_30863__$1 = state_30863;
var statearr_30885_30912 = state_30863__$1;
(statearr_30885_30912[(2)] = inst_30845);

(statearr_30885_30912[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12139__auto___30897,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__12027__auto__,c__12139__auto___30897,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__12028__auto__ = null;
var cljs$core$async$state_machine__12028__auto____0 = (function (){
var statearr_30889 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30889[(0)] = cljs$core$async$state_machine__12028__auto__);

(statearr_30889[(1)] = (1));

return statearr_30889;
});
var cljs$core$async$state_machine__12028__auto____1 = (function (state_30863){
while(true){
var ret_value__12029__auto__ = (function (){try{while(true){
var result__12030__auto__ = switch__12027__auto__(state_30863);
if(cljs.core.keyword_identical_QMARK_(result__12030__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12030__auto__;
}
break;
}
}catch (e30890){if((e30890 instanceof Object)){
var ex__12031__auto__ = e30890;
var statearr_30891_30913 = state_30863;
(statearr_30891_30913[(5)] = ex__12031__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_30863);

return cljs.core.cst$kw$recur;
} else {
throw e30890;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12029__auto__,cljs.core.cst$kw$recur)){
var G__30914 = state_30863;
state_30863 = G__30914;
continue;
} else {
return ret_value__12029__auto__;
}
break;
}
});
cljs$core$async$state_machine__12028__auto__ = function(state_30863){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12028__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12028__auto____1.call(this,state_30863);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12028__auto____0;
cljs$core$async$state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12028__auto____1;
return cljs$core$async$state_machine__12028__auto__;
})()
;})(switch__12027__auto__,c__12139__auto___30897,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__12141__auto__ = (function (){var statearr_30892 = (f__12140__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12140__auto__.cljs$core$IFn$_invoke$arity$0() : f__12140__auto__.call(null));
(statearr_30892[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12139__auto___30897);

return statearr_30892;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12141__auto__);
});})(c__12139__auto___30897,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args30916 = [];
var len__7484__auto___30974 = arguments.length;
var i__7485__auto___30975 = (0);
while(true){
if((i__7485__auto___30975 < len__7484__auto___30974)){
args30916.push((arguments[i__7485__auto___30975]));

var G__30976 = (i__7485__auto___30975 + (1));
i__7485__auto___30975 = G__30976;
continue;
} else {
}
break;
}

var G__30918 = args30916.length;
switch (G__30918) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30916.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__12139__auto___30978 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12139__auto___30978,out){
return (function (){
var f__12140__auto__ = (function (){var switch__12027__auto__ = ((function (c__12139__auto___30978,out){
return (function (state_30950){
var state_val_30951 = (state_30950[(1)]);
if((state_val_30951 === (7))){
var inst_30929 = (state_30950[(7)]);
var inst_30930 = (state_30950[(8)]);
var inst_30929__$1 = (state_30950[(2)]);
var inst_30930__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30929__$1,(0),null);
var inst_30931 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30929__$1,(1),null);
var inst_30932 = (inst_30930__$1 == null);
var state_30950__$1 = (function (){var statearr_30952 = state_30950;
(statearr_30952[(9)] = inst_30931);

(statearr_30952[(7)] = inst_30929__$1);

(statearr_30952[(8)] = inst_30930__$1);

return statearr_30952;
})();
if(cljs.core.truth_(inst_30932)){
var statearr_30953_30979 = state_30950__$1;
(statearr_30953_30979[(1)] = (8));

} else {
var statearr_30954_30980 = state_30950__$1;
(statearr_30954_30980[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30951 === (1))){
var inst_30919 = cljs.core.vec(chs);
var inst_30920 = inst_30919;
var state_30950__$1 = (function (){var statearr_30955 = state_30950;
(statearr_30955[(10)] = inst_30920);

return statearr_30955;
})();
var statearr_30956_30981 = state_30950__$1;
(statearr_30956_30981[(2)] = null);

(statearr_30956_30981[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30951 === (4))){
var inst_30920 = (state_30950[(10)]);
var state_30950__$1 = state_30950;
return cljs.core.async.ioc_alts_BANG_(state_30950__$1,(7),inst_30920);
} else {
if((state_val_30951 === (6))){
var inst_30946 = (state_30950[(2)]);
var state_30950__$1 = state_30950;
var statearr_30957_30982 = state_30950__$1;
(statearr_30957_30982[(2)] = inst_30946);

(statearr_30957_30982[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30951 === (3))){
var inst_30948 = (state_30950[(2)]);
var state_30950__$1 = state_30950;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30950__$1,inst_30948);
} else {
if((state_val_30951 === (2))){
var inst_30920 = (state_30950[(10)]);
var inst_30922 = cljs.core.count(inst_30920);
var inst_30923 = (inst_30922 > (0));
var state_30950__$1 = state_30950;
if(cljs.core.truth_(inst_30923)){
var statearr_30959_30983 = state_30950__$1;
(statearr_30959_30983[(1)] = (4));

} else {
var statearr_30960_30984 = state_30950__$1;
(statearr_30960_30984[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30951 === (11))){
var inst_30920 = (state_30950[(10)]);
var inst_30939 = (state_30950[(2)]);
var tmp30958 = inst_30920;
var inst_30920__$1 = tmp30958;
var state_30950__$1 = (function (){var statearr_30961 = state_30950;
(statearr_30961[(10)] = inst_30920__$1);

(statearr_30961[(11)] = inst_30939);

return statearr_30961;
})();
var statearr_30962_30985 = state_30950__$1;
(statearr_30962_30985[(2)] = null);

(statearr_30962_30985[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30951 === (9))){
var inst_30930 = (state_30950[(8)]);
var state_30950__$1 = state_30950;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30950__$1,(11),out,inst_30930);
} else {
if((state_val_30951 === (5))){
var inst_30944 = cljs.core.async.close_BANG_(out);
var state_30950__$1 = state_30950;
var statearr_30963_30986 = state_30950__$1;
(statearr_30963_30986[(2)] = inst_30944);

(statearr_30963_30986[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30951 === (10))){
var inst_30942 = (state_30950[(2)]);
var state_30950__$1 = state_30950;
var statearr_30964_30987 = state_30950__$1;
(statearr_30964_30987[(2)] = inst_30942);

(statearr_30964_30987[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30951 === (8))){
var inst_30931 = (state_30950[(9)]);
var inst_30920 = (state_30950[(10)]);
var inst_30929 = (state_30950[(7)]);
var inst_30930 = (state_30950[(8)]);
var inst_30934 = (function (){var cs = inst_30920;
var vec__30925 = inst_30929;
var v = inst_30930;
var c = inst_30931;
return ((function (cs,vec__30925,v,c,inst_30931,inst_30920,inst_30929,inst_30930,state_val_30951,c__12139__auto___30978,out){
return (function (p1__30915_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__30915_SHARP_);
});
;})(cs,vec__30925,v,c,inst_30931,inst_30920,inst_30929,inst_30930,state_val_30951,c__12139__auto___30978,out))
})();
var inst_30935 = cljs.core.filterv(inst_30934,inst_30920);
var inst_30920__$1 = inst_30935;
var state_30950__$1 = (function (){var statearr_30965 = state_30950;
(statearr_30965[(10)] = inst_30920__$1);

return statearr_30965;
})();
var statearr_30966_30988 = state_30950__$1;
(statearr_30966_30988[(2)] = null);

(statearr_30966_30988[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__12139__auto___30978,out))
;
return ((function (switch__12027__auto__,c__12139__auto___30978,out){
return (function() {
var cljs$core$async$state_machine__12028__auto__ = null;
var cljs$core$async$state_machine__12028__auto____0 = (function (){
var statearr_30970 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30970[(0)] = cljs$core$async$state_machine__12028__auto__);

(statearr_30970[(1)] = (1));

return statearr_30970;
});
var cljs$core$async$state_machine__12028__auto____1 = (function (state_30950){
while(true){
var ret_value__12029__auto__ = (function (){try{while(true){
var result__12030__auto__ = switch__12027__auto__(state_30950);
if(cljs.core.keyword_identical_QMARK_(result__12030__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12030__auto__;
}
break;
}
}catch (e30971){if((e30971 instanceof Object)){
var ex__12031__auto__ = e30971;
var statearr_30972_30989 = state_30950;
(statearr_30972_30989[(5)] = ex__12031__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_30950);

return cljs.core.cst$kw$recur;
} else {
throw e30971;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12029__auto__,cljs.core.cst$kw$recur)){
var G__30990 = state_30950;
state_30950 = G__30990;
continue;
} else {
return ret_value__12029__auto__;
}
break;
}
});
cljs$core$async$state_machine__12028__auto__ = function(state_30950){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12028__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12028__auto____1.call(this,state_30950);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12028__auto____0;
cljs$core$async$state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12028__auto____1;
return cljs$core$async$state_machine__12028__auto__;
})()
;})(switch__12027__auto__,c__12139__auto___30978,out))
})();
var state__12141__auto__ = (function (){var statearr_30973 = (f__12140__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12140__auto__.cljs$core$IFn$_invoke$arity$0() : f__12140__auto__.call(null));
(statearr_30973[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12139__auto___30978);

return statearr_30973;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12141__auto__);
});})(c__12139__auto___30978,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args30991 = [];
var len__7484__auto___31040 = arguments.length;
var i__7485__auto___31041 = (0);
while(true){
if((i__7485__auto___31041 < len__7484__auto___31040)){
args30991.push((arguments[i__7485__auto___31041]));

var G__31042 = (i__7485__auto___31041 + (1));
i__7485__auto___31041 = G__31042;
continue;
} else {
}
break;
}

var G__30993 = args30991.length;
switch (G__30993) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30991.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__12139__auto___31044 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12139__auto___31044,out){
return (function (){
var f__12140__auto__ = (function (){var switch__12027__auto__ = ((function (c__12139__auto___31044,out){
return (function (state_31017){
var state_val_31018 = (state_31017[(1)]);
if((state_val_31018 === (7))){
var inst_30999 = (state_31017[(7)]);
var inst_30999__$1 = (state_31017[(2)]);
var inst_31000 = (inst_30999__$1 == null);
var inst_31001 = cljs.core.not(inst_31000);
var state_31017__$1 = (function (){var statearr_31019 = state_31017;
(statearr_31019[(7)] = inst_30999__$1);

return statearr_31019;
})();
if(inst_31001){
var statearr_31020_31045 = state_31017__$1;
(statearr_31020_31045[(1)] = (8));

} else {
var statearr_31021_31046 = state_31017__$1;
(statearr_31021_31046[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31018 === (1))){
var inst_30994 = (0);
var state_31017__$1 = (function (){var statearr_31022 = state_31017;
(statearr_31022[(8)] = inst_30994);

return statearr_31022;
})();
var statearr_31023_31047 = state_31017__$1;
(statearr_31023_31047[(2)] = null);

(statearr_31023_31047[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31018 === (4))){
var state_31017__$1 = state_31017;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31017__$1,(7),ch);
} else {
if((state_val_31018 === (6))){
var inst_31012 = (state_31017[(2)]);
var state_31017__$1 = state_31017;
var statearr_31024_31048 = state_31017__$1;
(statearr_31024_31048[(2)] = inst_31012);

(statearr_31024_31048[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31018 === (3))){
var inst_31014 = (state_31017[(2)]);
var inst_31015 = cljs.core.async.close_BANG_(out);
var state_31017__$1 = (function (){var statearr_31025 = state_31017;
(statearr_31025[(9)] = inst_31014);

return statearr_31025;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_31017__$1,inst_31015);
} else {
if((state_val_31018 === (2))){
var inst_30994 = (state_31017[(8)]);
var inst_30996 = (inst_30994 < n);
var state_31017__$1 = state_31017;
if(cljs.core.truth_(inst_30996)){
var statearr_31026_31049 = state_31017__$1;
(statearr_31026_31049[(1)] = (4));

} else {
var statearr_31027_31050 = state_31017__$1;
(statearr_31027_31050[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31018 === (11))){
var inst_30994 = (state_31017[(8)]);
var inst_31004 = (state_31017[(2)]);
var inst_31005 = (inst_30994 + (1));
var inst_30994__$1 = inst_31005;
var state_31017__$1 = (function (){var statearr_31028 = state_31017;
(statearr_31028[(10)] = inst_31004);

(statearr_31028[(8)] = inst_30994__$1);

return statearr_31028;
})();
var statearr_31029_31051 = state_31017__$1;
(statearr_31029_31051[(2)] = null);

(statearr_31029_31051[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31018 === (9))){
var state_31017__$1 = state_31017;
var statearr_31030_31052 = state_31017__$1;
(statearr_31030_31052[(2)] = null);

(statearr_31030_31052[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31018 === (5))){
var state_31017__$1 = state_31017;
var statearr_31031_31053 = state_31017__$1;
(statearr_31031_31053[(2)] = null);

(statearr_31031_31053[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31018 === (10))){
var inst_31009 = (state_31017[(2)]);
var state_31017__$1 = state_31017;
var statearr_31032_31054 = state_31017__$1;
(statearr_31032_31054[(2)] = inst_31009);

(statearr_31032_31054[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31018 === (8))){
var inst_30999 = (state_31017[(7)]);
var state_31017__$1 = state_31017;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31017__$1,(11),out,inst_30999);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__12139__auto___31044,out))
;
return ((function (switch__12027__auto__,c__12139__auto___31044,out){
return (function() {
var cljs$core$async$state_machine__12028__auto__ = null;
var cljs$core$async$state_machine__12028__auto____0 = (function (){
var statearr_31036 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_31036[(0)] = cljs$core$async$state_machine__12028__auto__);

(statearr_31036[(1)] = (1));

return statearr_31036;
});
var cljs$core$async$state_machine__12028__auto____1 = (function (state_31017){
while(true){
var ret_value__12029__auto__ = (function (){try{while(true){
var result__12030__auto__ = switch__12027__auto__(state_31017);
if(cljs.core.keyword_identical_QMARK_(result__12030__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12030__auto__;
}
break;
}
}catch (e31037){if((e31037 instanceof Object)){
var ex__12031__auto__ = e31037;
var statearr_31038_31055 = state_31017;
(statearr_31038_31055[(5)] = ex__12031__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_31017);

return cljs.core.cst$kw$recur;
} else {
throw e31037;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12029__auto__,cljs.core.cst$kw$recur)){
var G__31056 = state_31017;
state_31017 = G__31056;
continue;
} else {
return ret_value__12029__auto__;
}
break;
}
});
cljs$core$async$state_machine__12028__auto__ = function(state_31017){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12028__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12028__auto____1.call(this,state_31017);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12028__auto____0;
cljs$core$async$state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12028__auto____1;
return cljs$core$async$state_machine__12028__auto__;
})()
;})(switch__12027__auto__,c__12139__auto___31044,out))
})();
var state__12141__auto__ = (function (){var statearr_31039 = (f__12140__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12140__auto__.cljs$core$IFn$_invoke$arity$0() : f__12140__auto__.call(null));
(statearr_31039[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12139__auto___31044);

return statearr_31039;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12141__auto__);
});})(c__12139__auto___31044,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async31066 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async31066 = (function (map_LT_,f,ch,meta31067){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta31067 = meta31067;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async31066.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_31068,meta31067__$1){
var self__ = this;
var _31068__$1 = this;
return (new cljs.core.async.t_cljs$core$async31066(self__.map_LT_,self__.f,self__.ch,meta31067__$1));
});

cljs.core.async.t_cljs$core$async31066.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_31068){
var self__ = this;
var _31068__$1 = this;
return self__.meta31067;
});

cljs.core.async.t_cljs$core$async31066.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async31066.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async31066.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
});

cljs.core.async.t_cljs$core$async31066.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async31066.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async31069 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async31069 = (function (map_LT_,f,ch,meta31067,_,fn1,meta31070){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta31067 = meta31067;
this._ = _;
this.fn1 = fn1;
this.meta31070 = meta31070;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async31069.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_31071,meta31070__$1){
var self__ = this;
var _31071__$1 = this;
return (new cljs.core.async.t_cljs$core$async31069(self__.map_LT_,self__.f,self__.ch,self__.meta31067,self__._,self__.fn1,meta31070__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async31069.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_31071){
var self__ = this;
var _31071__$1 = this;
return self__.meta31070;
});})(___$1))
;

cljs.core.async.t_cljs$core$async31069.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async31069.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async31069.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async31069.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__31057_SHARP_){
var G__31072 = (((p1__31057_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__31057_SHARP_) : self__.f.call(null,p1__31057_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__31072) : f1.call(null,G__31072));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async31069.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$map_LT_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch], null))),cljs.core.cst$kw$doc,"Deprecated - this function will be removed. Use transducer instead"], null)),cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta31067,cljs.core.with_meta(cljs.core.cst$sym$_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$cljs$core$async_SLASH_t_cljs$core$async31066], null)),cljs.core.cst$sym$fn1,cljs.core.cst$sym$meta31070], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async31069.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async31069.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async31069";

cljs.core.async.t_cljs$core$async31069.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"cljs.core.async/t_cljs$core$async31069");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async31069 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async31069(map_LT___$1,f__$1,ch__$1,meta31067__$1,___$2,fn1__$1,meta31070){
return (new cljs.core.async.t_cljs$core$async31069(map_LT___$1,f__$1,ch__$1,meta31067__$1,___$2,fn1__$1,meta31070));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async31069(self__.map_LT_,self__.f,self__.ch,self__.meta31067,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__6397__auto__ = ret;
if(cljs.core.truth_(and__6397__auto__)){
return !(((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret)) == null));
} else {
return and__6397__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__31073 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__31073) : self__.f.call(null,G__31073));
})());
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async31066.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async31066.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async31066.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$map_LT_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch], null))),cljs.core.cst$kw$doc,"Deprecated - this function will be removed. Use transducer instead"], null)),cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta31067], null);
});

cljs.core.async.t_cljs$core$async31066.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async31066.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async31066";

cljs.core.async.t_cljs$core$async31066.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"cljs.core.async/t_cljs$core$async31066");
});

cljs.core.async.__GT_t_cljs$core$async31066 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async31066(map_LT___$1,f__$1,ch__$1,meta31067){
return (new cljs.core.async.t_cljs$core$async31066(map_LT___$1,f__$1,ch__$1,meta31067));
});

}

return (new cljs.core.async.t_cljs$core$async31066(cljs$core$async$map_LT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async31077 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async31077 = (function (map_GT_,f,ch,meta31078){
this.map_GT_ = map_GT_;
this.f = f;
this.ch = ch;
this.meta31078 = meta31078;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async31077.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_31079,meta31078__$1){
var self__ = this;
var _31079__$1 = this;
return (new cljs.core.async.t_cljs$core$async31077(self__.map_GT_,self__.f,self__.ch,meta31078__$1));
});

cljs.core.async.t_cljs$core$async31077.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_31079){
var self__ = this;
var _31079__$1 = this;
return self__.meta31078;
});

cljs.core.async.t_cljs$core$async31077.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async31077.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async31077.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async31077.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async31077.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async31077.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
});

cljs.core.async.t_cljs$core$async31077.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$map_GT_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch], null))),cljs.core.cst$kw$doc,"Deprecated - this function will be removed. Use transducer instead"], null)),cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta31078], null);
});

cljs.core.async.t_cljs$core$async31077.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async31077.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async31077";

cljs.core.async.t_cljs$core$async31077.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"cljs.core.async/t_cljs$core$async31077");
});

cljs.core.async.__GT_t_cljs$core$async31077 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async31077(map_GT___$1,f__$1,ch__$1,meta31078){
return (new cljs.core.async.t_cljs$core$async31077(map_GT___$1,f__$1,ch__$1,meta31078));
});

}

return (new cljs.core.async.t_cljs$core$async31077(cljs$core$async$map_GT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async31083 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async31083 = (function (filter_GT_,p,ch,meta31084){
this.filter_GT_ = filter_GT_;
this.p = p;
this.ch = ch;
this.meta31084 = meta31084;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async31083.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_31085,meta31084__$1){
var self__ = this;
var _31085__$1 = this;
return (new cljs.core.async.t_cljs$core$async31083(self__.filter_GT_,self__.p,self__.ch,meta31084__$1));
});

cljs.core.async.t_cljs$core$async31083.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_31085){
var self__ = this;
var _31085__$1 = this;
return self__.meta31084;
});

cljs.core.async.t_cljs$core$async31083.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async31083.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async31083.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
});

cljs.core.async.t_cljs$core$async31083.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async31083.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async31083.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async31083.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
});

cljs.core.async.t_cljs$core$async31083.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$filter_GT_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p,cljs.core.cst$sym$ch], null))),cljs.core.cst$kw$doc,"Deprecated - this function will be removed. Use transducer instead"], null)),cljs.core.cst$sym$p,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta31084], null);
});

cljs.core.async.t_cljs$core$async31083.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async31083.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async31083";

cljs.core.async.t_cljs$core$async31083.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"cljs.core.async/t_cljs$core$async31083");
});

cljs.core.async.__GT_t_cljs$core$async31083 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async31083(filter_GT___$1,p__$1,ch__$1,meta31084){
return (new cljs.core.async.t_cljs$core$async31083(filter_GT___$1,p__$1,ch__$1,meta31084));
});

}

return (new cljs.core.async.t_cljs$core$async31083(cljs$core$async$filter_GT_,p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args31086 = [];
var len__7484__auto___31130 = arguments.length;
var i__7485__auto___31131 = (0);
while(true){
if((i__7485__auto___31131 < len__7484__auto___31130)){
args31086.push((arguments[i__7485__auto___31131]));

var G__31132 = (i__7485__auto___31131 + (1));
i__7485__auto___31131 = G__31132;
continue;
} else {
}
break;
}

var G__31088 = args31086.length;
switch (G__31088) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31086.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__12139__auto___31134 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12139__auto___31134,out){
return (function (){
var f__12140__auto__ = (function (){var switch__12027__auto__ = ((function (c__12139__auto___31134,out){
return (function (state_31109){
var state_val_31110 = (state_31109[(1)]);
if((state_val_31110 === (7))){
var inst_31105 = (state_31109[(2)]);
var state_31109__$1 = state_31109;
var statearr_31111_31135 = state_31109__$1;
(statearr_31111_31135[(2)] = inst_31105);

(statearr_31111_31135[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31110 === (1))){
var state_31109__$1 = state_31109;
var statearr_31112_31136 = state_31109__$1;
(statearr_31112_31136[(2)] = null);

(statearr_31112_31136[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31110 === (4))){
var inst_31091 = (state_31109[(7)]);
var inst_31091__$1 = (state_31109[(2)]);
var inst_31092 = (inst_31091__$1 == null);
var state_31109__$1 = (function (){var statearr_31113 = state_31109;
(statearr_31113[(7)] = inst_31091__$1);

return statearr_31113;
})();
if(cljs.core.truth_(inst_31092)){
var statearr_31114_31137 = state_31109__$1;
(statearr_31114_31137[(1)] = (5));

} else {
var statearr_31115_31138 = state_31109__$1;
(statearr_31115_31138[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31110 === (6))){
var inst_31091 = (state_31109[(7)]);
var inst_31096 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_31091) : p.call(null,inst_31091));
var state_31109__$1 = state_31109;
if(cljs.core.truth_(inst_31096)){
var statearr_31116_31139 = state_31109__$1;
(statearr_31116_31139[(1)] = (8));

} else {
var statearr_31117_31140 = state_31109__$1;
(statearr_31117_31140[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31110 === (3))){
var inst_31107 = (state_31109[(2)]);
var state_31109__$1 = state_31109;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31109__$1,inst_31107);
} else {
if((state_val_31110 === (2))){
var state_31109__$1 = state_31109;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31109__$1,(4),ch);
} else {
if((state_val_31110 === (11))){
var inst_31099 = (state_31109[(2)]);
var state_31109__$1 = state_31109;
var statearr_31118_31141 = state_31109__$1;
(statearr_31118_31141[(2)] = inst_31099);

(statearr_31118_31141[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31110 === (9))){
var state_31109__$1 = state_31109;
var statearr_31119_31142 = state_31109__$1;
(statearr_31119_31142[(2)] = null);

(statearr_31119_31142[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31110 === (5))){
var inst_31094 = cljs.core.async.close_BANG_(out);
var state_31109__$1 = state_31109;
var statearr_31120_31143 = state_31109__$1;
(statearr_31120_31143[(2)] = inst_31094);

(statearr_31120_31143[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31110 === (10))){
var inst_31102 = (state_31109[(2)]);
var state_31109__$1 = (function (){var statearr_31121 = state_31109;
(statearr_31121[(8)] = inst_31102);

return statearr_31121;
})();
var statearr_31122_31144 = state_31109__$1;
(statearr_31122_31144[(2)] = null);

(statearr_31122_31144[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31110 === (8))){
var inst_31091 = (state_31109[(7)]);
var state_31109__$1 = state_31109;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31109__$1,(11),out,inst_31091);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__12139__auto___31134,out))
;
return ((function (switch__12027__auto__,c__12139__auto___31134,out){
return (function() {
var cljs$core$async$state_machine__12028__auto__ = null;
var cljs$core$async$state_machine__12028__auto____0 = (function (){
var statearr_31126 = [null,null,null,null,null,null,null,null,null];
(statearr_31126[(0)] = cljs$core$async$state_machine__12028__auto__);

(statearr_31126[(1)] = (1));

return statearr_31126;
});
var cljs$core$async$state_machine__12028__auto____1 = (function (state_31109){
while(true){
var ret_value__12029__auto__ = (function (){try{while(true){
var result__12030__auto__ = switch__12027__auto__(state_31109);
if(cljs.core.keyword_identical_QMARK_(result__12030__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12030__auto__;
}
break;
}
}catch (e31127){if((e31127 instanceof Object)){
var ex__12031__auto__ = e31127;
var statearr_31128_31145 = state_31109;
(statearr_31128_31145[(5)] = ex__12031__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_31109);

return cljs.core.cst$kw$recur;
} else {
throw e31127;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12029__auto__,cljs.core.cst$kw$recur)){
var G__31146 = state_31109;
state_31109 = G__31146;
continue;
} else {
return ret_value__12029__auto__;
}
break;
}
});
cljs$core$async$state_machine__12028__auto__ = function(state_31109){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12028__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12028__auto____1.call(this,state_31109);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12028__auto____0;
cljs$core$async$state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12028__auto____1;
return cljs$core$async$state_machine__12028__auto__;
})()
;})(switch__12027__auto__,c__12139__auto___31134,out))
})();
var state__12141__auto__ = (function (){var statearr_31129 = (f__12140__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12140__auto__.cljs$core$IFn$_invoke$arity$0() : f__12140__auto__.call(null));
(statearr_31129[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12139__auto___31134);

return statearr_31129;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12141__auto__);
});})(c__12139__auto___31134,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args31147 = [];
var len__7484__auto___31150 = arguments.length;
var i__7485__auto___31151 = (0);
while(true){
if((i__7485__auto___31151 < len__7484__auto___31150)){
args31147.push((arguments[i__7485__auto___31151]));

var G__31152 = (i__7485__auto___31151 + (1));
i__7485__auto___31151 = G__31152;
continue;
} else {
}
break;
}

var G__31149 = args31147.length;
switch (G__31149) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31147.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__12139__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12139__auto__){
return (function (){
var f__12140__auto__ = (function (){var switch__12027__auto__ = ((function (c__12139__auto__){
return (function (state_31319){
var state_val_31320 = (state_31319[(1)]);
if((state_val_31320 === (7))){
var inst_31315 = (state_31319[(2)]);
var state_31319__$1 = state_31319;
var statearr_31321_31362 = state_31319__$1;
(statearr_31321_31362[(2)] = inst_31315);

(statearr_31321_31362[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31320 === (20))){
var inst_31285 = (state_31319[(7)]);
var inst_31296 = (state_31319[(2)]);
var inst_31297 = cljs.core.next(inst_31285);
var inst_31271 = inst_31297;
var inst_31272 = null;
var inst_31273 = (0);
var inst_31274 = (0);
var state_31319__$1 = (function (){var statearr_31322 = state_31319;
(statearr_31322[(8)] = inst_31296);

(statearr_31322[(9)] = inst_31271);

(statearr_31322[(10)] = inst_31274);

(statearr_31322[(11)] = inst_31272);

(statearr_31322[(12)] = inst_31273);

return statearr_31322;
})();
var statearr_31323_31363 = state_31319__$1;
(statearr_31323_31363[(2)] = null);

(statearr_31323_31363[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31320 === (1))){
var state_31319__$1 = state_31319;
var statearr_31324_31364 = state_31319__$1;
(statearr_31324_31364[(2)] = null);

(statearr_31324_31364[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31320 === (4))){
var inst_31260 = (state_31319[(13)]);
var inst_31260__$1 = (state_31319[(2)]);
var inst_31261 = (inst_31260__$1 == null);
var state_31319__$1 = (function (){var statearr_31325 = state_31319;
(statearr_31325[(13)] = inst_31260__$1);

return statearr_31325;
})();
if(cljs.core.truth_(inst_31261)){
var statearr_31326_31365 = state_31319__$1;
(statearr_31326_31365[(1)] = (5));

} else {
var statearr_31327_31366 = state_31319__$1;
(statearr_31327_31366[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31320 === (15))){
var state_31319__$1 = state_31319;
var statearr_31331_31367 = state_31319__$1;
(statearr_31331_31367[(2)] = null);

(statearr_31331_31367[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31320 === (21))){
var state_31319__$1 = state_31319;
var statearr_31332_31368 = state_31319__$1;
(statearr_31332_31368[(2)] = null);

(statearr_31332_31368[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31320 === (13))){
var inst_31271 = (state_31319[(9)]);
var inst_31274 = (state_31319[(10)]);
var inst_31272 = (state_31319[(11)]);
var inst_31273 = (state_31319[(12)]);
var inst_31281 = (state_31319[(2)]);
var inst_31282 = (inst_31274 + (1));
var tmp31328 = inst_31271;
var tmp31329 = inst_31272;
var tmp31330 = inst_31273;
var inst_31271__$1 = tmp31328;
var inst_31272__$1 = tmp31329;
var inst_31273__$1 = tmp31330;
var inst_31274__$1 = inst_31282;
var state_31319__$1 = (function (){var statearr_31333 = state_31319;
(statearr_31333[(14)] = inst_31281);

(statearr_31333[(9)] = inst_31271__$1);

(statearr_31333[(10)] = inst_31274__$1);

(statearr_31333[(11)] = inst_31272__$1);

(statearr_31333[(12)] = inst_31273__$1);

return statearr_31333;
})();
var statearr_31334_31369 = state_31319__$1;
(statearr_31334_31369[(2)] = null);

(statearr_31334_31369[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31320 === (22))){
var state_31319__$1 = state_31319;
var statearr_31335_31370 = state_31319__$1;
(statearr_31335_31370[(2)] = null);

(statearr_31335_31370[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31320 === (6))){
var inst_31260 = (state_31319[(13)]);
var inst_31269 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_31260) : f.call(null,inst_31260));
var inst_31270 = cljs.core.seq(inst_31269);
var inst_31271 = inst_31270;
var inst_31272 = null;
var inst_31273 = (0);
var inst_31274 = (0);
var state_31319__$1 = (function (){var statearr_31336 = state_31319;
(statearr_31336[(9)] = inst_31271);

(statearr_31336[(10)] = inst_31274);

(statearr_31336[(11)] = inst_31272);

(statearr_31336[(12)] = inst_31273);

return statearr_31336;
})();
var statearr_31337_31371 = state_31319__$1;
(statearr_31337_31371[(2)] = null);

(statearr_31337_31371[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31320 === (17))){
var inst_31285 = (state_31319[(7)]);
var inst_31289 = cljs.core.chunk_first(inst_31285);
var inst_31290 = cljs.core.chunk_rest(inst_31285);
var inst_31291 = cljs.core.count(inst_31289);
var inst_31271 = inst_31290;
var inst_31272 = inst_31289;
var inst_31273 = inst_31291;
var inst_31274 = (0);
var state_31319__$1 = (function (){var statearr_31338 = state_31319;
(statearr_31338[(9)] = inst_31271);

(statearr_31338[(10)] = inst_31274);

(statearr_31338[(11)] = inst_31272);

(statearr_31338[(12)] = inst_31273);

return statearr_31338;
})();
var statearr_31339_31372 = state_31319__$1;
(statearr_31339_31372[(2)] = null);

(statearr_31339_31372[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31320 === (3))){
var inst_31317 = (state_31319[(2)]);
var state_31319__$1 = state_31319;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31319__$1,inst_31317);
} else {
if((state_val_31320 === (12))){
var inst_31305 = (state_31319[(2)]);
var state_31319__$1 = state_31319;
var statearr_31340_31373 = state_31319__$1;
(statearr_31340_31373[(2)] = inst_31305);

(statearr_31340_31373[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31320 === (2))){
var state_31319__$1 = state_31319;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31319__$1,(4),in$);
} else {
if((state_val_31320 === (23))){
var inst_31313 = (state_31319[(2)]);
var state_31319__$1 = state_31319;
var statearr_31341_31374 = state_31319__$1;
(statearr_31341_31374[(2)] = inst_31313);

(statearr_31341_31374[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31320 === (19))){
var inst_31300 = (state_31319[(2)]);
var state_31319__$1 = state_31319;
var statearr_31342_31375 = state_31319__$1;
(statearr_31342_31375[(2)] = inst_31300);

(statearr_31342_31375[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31320 === (11))){
var inst_31285 = (state_31319[(7)]);
var inst_31271 = (state_31319[(9)]);
var inst_31285__$1 = cljs.core.seq(inst_31271);
var state_31319__$1 = (function (){var statearr_31343 = state_31319;
(statearr_31343[(7)] = inst_31285__$1);

return statearr_31343;
})();
if(inst_31285__$1){
var statearr_31344_31376 = state_31319__$1;
(statearr_31344_31376[(1)] = (14));

} else {
var statearr_31345_31377 = state_31319__$1;
(statearr_31345_31377[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31320 === (9))){
var inst_31307 = (state_31319[(2)]);
var inst_31308 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_31319__$1 = (function (){var statearr_31346 = state_31319;
(statearr_31346[(15)] = inst_31307);

return statearr_31346;
})();
if(cljs.core.truth_(inst_31308)){
var statearr_31347_31378 = state_31319__$1;
(statearr_31347_31378[(1)] = (21));

} else {
var statearr_31348_31379 = state_31319__$1;
(statearr_31348_31379[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31320 === (5))){
var inst_31263 = cljs.core.async.close_BANG_(out);
var state_31319__$1 = state_31319;
var statearr_31349_31380 = state_31319__$1;
(statearr_31349_31380[(2)] = inst_31263);

(statearr_31349_31380[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31320 === (14))){
var inst_31285 = (state_31319[(7)]);
var inst_31287 = cljs.core.chunked_seq_QMARK_(inst_31285);
var state_31319__$1 = state_31319;
if(inst_31287){
var statearr_31350_31381 = state_31319__$1;
(statearr_31350_31381[(1)] = (17));

} else {
var statearr_31351_31382 = state_31319__$1;
(statearr_31351_31382[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31320 === (16))){
var inst_31303 = (state_31319[(2)]);
var state_31319__$1 = state_31319;
var statearr_31352_31383 = state_31319__$1;
(statearr_31352_31383[(2)] = inst_31303);

(statearr_31352_31383[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31320 === (10))){
var inst_31274 = (state_31319[(10)]);
var inst_31272 = (state_31319[(11)]);
var inst_31279 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_31272,inst_31274);
var state_31319__$1 = state_31319;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31319__$1,(13),out,inst_31279);
} else {
if((state_val_31320 === (18))){
var inst_31285 = (state_31319[(7)]);
var inst_31294 = cljs.core.first(inst_31285);
var state_31319__$1 = state_31319;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31319__$1,(20),out,inst_31294);
} else {
if((state_val_31320 === (8))){
var inst_31274 = (state_31319[(10)]);
var inst_31273 = (state_31319[(12)]);
var inst_31276 = (inst_31274 < inst_31273);
var inst_31277 = inst_31276;
var state_31319__$1 = state_31319;
if(cljs.core.truth_(inst_31277)){
var statearr_31353_31384 = state_31319__$1;
(statearr_31353_31384[(1)] = (10));

} else {
var statearr_31354_31385 = state_31319__$1;
(statearr_31354_31385[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12139__auto__))
;
return ((function (switch__12027__auto__,c__12139__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__12028__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__12028__auto____0 = (function (){
var statearr_31358 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31358[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__12028__auto__);

(statearr_31358[(1)] = (1));

return statearr_31358;
});
var cljs$core$async$mapcat_STAR__$_state_machine__12028__auto____1 = (function (state_31319){
while(true){
var ret_value__12029__auto__ = (function (){try{while(true){
var result__12030__auto__ = switch__12027__auto__(state_31319);
if(cljs.core.keyword_identical_QMARK_(result__12030__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12030__auto__;
}
break;
}
}catch (e31359){if((e31359 instanceof Object)){
var ex__12031__auto__ = e31359;
var statearr_31360_31386 = state_31319;
(statearr_31360_31386[(5)] = ex__12031__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_31319);

return cljs.core.cst$kw$recur;
} else {
throw e31359;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12029__auto__,cljs.core.cst$kw$recur)){
var G__31387 = state_31319;
state_31319 = G__31387;
continue;
} else {
return ret_value__12029__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__12028__auto__ = function(state_31319){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__12028__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__12028__auto____1.call(this,state_31319);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__12028__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__12028__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__12028__auto__;
})()
;})(switch__12027__auto__,c__12139__auto__))
})();
var state__12141__auto__ = (function (){var statearr_31361 = (f__12140__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12140__auto__.cljs$core$IFn$_invoke$arity$0() : f__12140__auto__.call(null));
(statearr_31361[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12139__auto__);

return statearr_31361;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12141__auto__);
});})(c__12139__auto__))
);

return c__12139__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args31388 = [];
var len__7484__auto___31391 = arguments.length;
var i__7485__auto___31392 = (0);
while(true){
if((i__7485__auto___31392 < len__7484__auto___31391)){
args31388.push((arguments[i__7485__auto___31392]));

var G__31393 = (i__7485__auto___31392 + (1));
i__7485__auto___31392 = G__31393;
continue;
} else {
}
break;
}

var G__31390 = args31388.length;
switch (G__31390) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31388.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args31395 = [];
var len__7484__auto___31398 = arguments.length;
var i__7485__auto___31399 = (0);
while(true){
if((i__7485__auto___31399 < len__7484__auto___31398)){
args31395.push((arguments[i__7485__auto___31399]));

var G__31400 = (i__7485__auto___31399 + (1));
i__7485__auto___31399 = G__31400;
continue;
} else {
}
break;
}

var G__31397 = args31395.length;
switch (G__31397) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31395.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args31402 = [];
var len__7484__auto___31453 = arguments.length;
var i__7485__auto___31454 = (0);
while(true){
if((i__7485__auto___31454 < len__7484__auto___31453)){
args31402.push((arguments[i__7485__auto___31454]));

var G__31455 = (i__7485__auto___31454 + (1));
i__7485__auto___31454 = G__31455;
continue;
} else {
}
break;
}

var G__31404 = args31402.length;
switch (G__31404) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31402.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__12139__auto___31457 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12139__auto___31457,out){
return (function (){
var f__12140__auto__ = (function (){var switch__12027__auto__ = ((function (c__12139__auto___31457,out){
return (function (state_31428){
var state_val_31429 = (state_31428[(1)]);
if((state_val_31429 === (7))){
var inst_31423 = (state_31428[(2)]);
var state_31428__$1 = state_31428;
var statearr_31430_31458 = state_31428__$1;
(statearr_31430_31458[(2)] = inst_31423);

(statearr_31430_31458[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31429 === (1))){
var inst_31405 = null;
var state_31428__$1 = (function (){var statearr_31431 = state_31428;
(statearr_31431[(7)] = inst_31405);

return statearr_31431;
})();
var statearr_31432_31459 = state_31428__$1;
(statearr_31432_31459[(2)] = null);

(statearr_31432_31459[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31429 === (4))){
var inst_31408 = (state_31428[(8)]);
var inst_31408__$1 = (state_31428[(2)]);
var inst_31409 = (inst_31408__$1 == null);
var inst_31410 = cljs.core.not(inst_31409);
var state_31428__$1 = (function (){var statearr_31433 = state_31428;
(statearr_31433[(8)] = inst_31408__$1);

return statearr_31433;
})();
if(inst_31410){
var statearr_31434_31460 = state_31428__$1;
(statearr_31434_31460[(1)] = (5));

} else {
var statearr_31435_31461 = state_31428__$1;
(statearr_31435_31461[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31429 === (6))){
var state_31428__$1 = state_31428;
var statearr_31436_31462 = state_31428__$1;
(statearr_31436_31462[(2)] = null);

(statearr_31436_31462[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31429 === (3))){
var inst_31425 = (state_31428[(2)]);
var inst_31426 = cljs.core.async.close_BANG_(out);
var state_31428__$1 = (function (){var statearr_31437 = state_31428;
(statearr_31437[(9)] = inst_31425);

return statearr_31437;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_31428__$1,inst_31426);
} else {
if((state_val_31429 === (2))){
var state_31428__$1 = state_31428;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31428__$1,(4),ch);
} else {
if((state_val_31429 === (11))){
var inst_31408 = (state_31428[(8)]);
var inst_31417 = (state_31428[(2)]);
var inst_31405 = inst_31408;
var state_31428__$1 = (function (){var statearr_31438 = state_31428;
(statearr_31438[(10)] = inst_31417);

(statearr_31438[(7)] = inst_31405);

return statearr_31438;
})();
var statearr_31439_31463 = state_31428__$1;
(statearr_31439_31463[(2)] = null);

(statearr_31439_31463[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31429 === (9))){
var inst_31408 = (state_31428[(8)]);
var state_31428__$1 = state_31428;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31428__$1,(11),out,inst_31408);
} else {
if((state_val_31429 === (5))){
var inst_31408 = (state_31428[(8)]);
var inst_31405 = (state_31428[(7)]);
var inst_31412 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_31408,inst_31405);
var state_31428__$1 = state_31428;
if(inst_31412){
var statearr_31441_31464 = state_31428__$1;
(statearr_31441_31464[(1)] = (8));

} else {
var statearr_31442_31465 = state_31428__$1;
(statearr_31442_31465[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31429 === (10))){
var inst_31420 = (state_31428[(2)]);
var state_31428__$1 = state_31428;
var statearr_31443_31466 = state_31428__$1;
(statearr_31443_31466[(2)] = inst_31420);

(statearr_31443_31466[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31429 === (8))){
var inst_31405 = (state_31428[(7)]);
var tmp31440 = inst_31405;
var inst_31405__$1 = tmp31440;
var state_31428__$1 = (function (){var statearr_31444 = state_31428;
(statearr_31444[(7)] = inst_31405__$1);

return statearr_31444;
})();
var statearr_31445_31467 = state_31428__$1;
(statearr_31445_31467[(2)] = null);

(statearr_31445_31467[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__12139__auto___31457,out))
;
return ((function (switch__12027__auto__,c__12139__auto___31457,out){
return (function() {
var cljs$core$async$state_machine__12028__auto__ = null;
var cljs$core$async$state_machine__12028__auto____0 = (function (){
var statearr_31449 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_31449[(0)] = cljs$core$async$state_machine__12028__auto__);

(statearr_31449[(1)] = (1));

return statearr_31449;
});
var cljs$core$async$state_machine__12028__auto____1 = (function (state_31428){
while(true){
var ret_value__12029__auto__ = (function (){try{while(true){
var result__12030__auto__ = switch__12027__auto__(state_31428);
if(cljs.core.keyword_identical_QMARK_(result__12030__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12030__auto__;
}
break;
}
}catch (e31450){if((e31450 instanceof Object)){
var ex__12031__auto__ = e31450;
var statearr_31451_31468 = state_31428;
(statearr_31451_31468[(5)] = ex__12031__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_31428);

return cljs.core.cst$kw$recur;
} else {
throw e31450;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12029__auto__,cljs.core.cst$kw$recur)){
var G__31469 = state_31428;
state_31428 = G__31469;
continue;
} else {
return ret_value__12029__auto__;
}
break;
}
});
cljs$core$async$state_machine__12028__auto__ = function(state_31428){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12028__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12028__auto____1.call(this,state_31428);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12028__auto____0;
cljs$core$async$state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12028__auto____1;
return cljs$core$async$state_machine__12028__auto__;
})()
;})(switch__12027__auto__,c__12139__auto___31457,out))
})();
var state__12141__auto__ = (function (){var statearr_31452 = (f__12140__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12140__auto__.cljs$core$IFn$_invoke$arity$0() : f__12140__auto__.call(null));
(statearr_31452[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12139__auto___31457);

return statearr_31452;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12141__auto__);
});})(c__12139__auto___31457,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args31470 = [];
var len__7484__auto___31540 = arguments.length;
var i__7485__auto___31541 = (0);
while(true){
if((i__7485__auto___31541 < len__7484__auto___31540)){
args31470.push((arguments[i__7485__auto___31541]));

var G__31542 = (i__7485__auto___31541 + (1));
i__7485__auto___31541 = G__31542;
continue;
} else {
}
break;
}

var G__31472 = args31470.length;
switch (G__31472) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31470.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__12139__auto___31544 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12139__auto___31544,out){
return (function (){
var f__12140__auto__ = (function (){var switch__12027__auto__ = ((function (c__12139__auto___31544,out){
return (function (state_31510){
var state_val_31511 = (state_31510[(1)]);
if((state_val_31511 === (7))){
var inst_31506 = (state_31510[(2)]);
var state_31510__$1 = state_31510;
var statearr_31512_31545 = state_31510__$1;
(statearr_31512_31545[(2)] = inst_31506);

(statearr_31512_31545[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31511 === (1))){
var inst_31473 = (new Array(n));
var inst_31474 = inst_31473;
var inst_31475 = (0);
var state_31510__$1 = (function (){var statearr_31513 = state_31510;
(statearr_31513[(7)] = inst_31474);

(statearr_31513[(8)] = inst_31475);

return statearr_31513;
})();
var statearr_31514_31546 = state_31510__$1;
(statearr_31514_31546[(2)] = null);

(statearr_31514_31546[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31511 === (4))){
var inst_31478 = (state_31510[(9)]);
var inst_31478__$1 = (state_31510[(2)]);
var inst_31479 = (inst_31478__$1 == null);
var inst_31480 = cljs.core.not(inst_31479);
var state_31510__$1 = (function (){var statearr_31515 = state_31510;
(statearr_31515[(9)] = inst_31478__$1);

return statearr_31515;
})();
if(inst_31480){
var statearr_31516_31547 = state_31510__$1;
(statearr_31516_31547[(1)] = (5));

} else {
var statearr_31517_31548 = state_31510__$1;
(statearr_31517_31548[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31511 === (15))){
var inst_31500 = (state_31510[(2)]);
var state_31510__$1 = state_31510;
var statearr_31518_31549 = state_31510__$1;
(statearr_31518_31549[(2)] = inst_31500);

(statearr_31518_31549[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31511 === (13))){
var state_31510__$1 = state_31510;
var statearr_31519_31550 = state_31510__$1;
(statearr_31519_31550[(2)] = null);

(statearr_31519_31550[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31511 === (6))){
var inst_31475 = (state_31510[(8)]);
var inst_31496 = (inst_31475 > (0));
var state_31510__$1 = state_31510;
if(cljs.core.truth_(inst_31496)){
var statearr_31520_31551 = state_31510__$1;
(statearr_31520_31551[(1)] = (12));

} else {
var statearr_31521_31552 = state_31510__$1;
(statearr_31521_31552[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31511 === (3))){
var inst_31508 = (state_31510[(2)]);
var state_31510__$1 = state_31510;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31510__$1,inst_31508);
} else {
if((state_val_31511 === (12))){
var inst_31474 = (state_31510[(7)]);
var inst_31498 = cljs.core.vec(inst_31474);
var state_31510__$1 = state_31510;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31510__$1,(15),out,inst_31498);
} else {
if((state_val_31511 === (2))){
var state_31510__$1 = state_31510;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31510__$1,(4),ch);
} else {
if((state_val_31511 === (11))){
var inst_31490 = (state_31510[(2)]);
var inst_31491 = (new Array(n));
var inst_31474 = inst_31491;
var inst_31475 = (0);
var state_31510__$1 = (function (){var statearr_31522 = state_31510;
(statearr_31522[(7)] = inst_31474);

(statearr_31522[(8)] = inst_31475);

(statearr_31522[(10)] = inst_31490);

return statearr_31522;
})();
var statearr_31523_31553 = state_31510__$1;
(statearr_31523_31553[(2)] = null);

(statearr_31523_31553[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31511 === (9))){
var inst_31474 = (state_31510[(7)]);
var inst_31488 = cljs.core.vec(inst_31474);
var state_31510__$1 = state_31510;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31510__$1,(11),out,inst_31488);
} else {
if((state_val_31511 === (5))){
var inst_31474 = (state_31510[(7)]);
var inst_31475 = (state_31510[(8)]);
var inst_31478 = (state_31510[(9)]);
var inst_31483 = (state_31510[(11)]);
var inst_31482 = (inst_31474[inst_31475] = inst_31478);
var inst_31483__$1 = (inst_31475 + (1));
var inst_31484 = (inst_31483__$1 < n);
var state_31510__$1 = (function (){var statearr_31524 = state_31510;
(statearr_31524[(11)] = inst_31483__$1);

(statearr_31524[(12)] = inst_31482);

return statearr_31524;
})();
if(cljs.core.truth_(inst_31484)){
var statearr_31525_31554 = state_31510__$1;
(statearr_31525_31554[(1)] = (8));

} else {
var statearr_31526_31555 = state_31510__$1;
(statearr_31526_31555[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31511 === (14))){
var inst_31503 = (state_31510[(2)]);
var inst_31504 = cljs.core.async.close_BANG_(out);
var state_31510__$1 = (function (){var statearr_31528 = state_31510;
(statearr_31528[(13)] = inst_31503);

return statearr_31528;
})();
var statearr_31529_31556 = state_31510__$1;
(statearr_31529_31556[(2)] = inst_31504);

(statearr_31529_31556[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31511 === (10))){
var inst_31494 = (state_31510[(2)]);
var state_31510__$1 = state_31510;
var statearr_31530_31557 = state_31510__$1;
(statearr_31530_31557[(2)] = inst_31494);

(statearr_31530_31557[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31511 === (8))){
var inst_31474 = (state_31510[(7)]);
var inst_31483 = (state_31510[(11)]);
var tmp31527 = inst_31474;
var inst_31474__$1 = tmp31527;
var inst_31475 = inst_31483;
var state_31510__$1 = (function (){var statearr_31531 = state_31510;
(statearr_31531[(7)] = inst_31474__$1);

(statearr_31531[(8)] = inst_31475);

return statearr_31531;
})();
var statearr_31532_31558 = state_31510__$1;
(statearr_31532_31558[(2)] = null);

(statearr_31532_31558[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12139__auto___31544,out))
;
return ((function (switch__12027__auto__,c__12139__auto___31544,out){
return (function() {
var cljs$core$async$state_machine__12028__auto__ = null;
var cljs$core$async$state_machine__12028__auto____0 = (function (){
var statearr_31536 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31536[(0)] = cljs$core$async$state_machine__12028__auto__);

(statearr_31536[(1)] = (1));

return statearr_31536;
});
var cljs$core$async$state_machine__12028__auto____1 = (function (state_31510){
while(true){
var ret_value__12029__auto__ = (function (){try{while(true){
var result__12030__auto__ = switch__12027__auto__(state_31510);
if(cljs.core.keyword_identical_QMARK_(result__12030__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12030__auto__;
}
break;
}
}catch (e31537){if((e31537 instanceof Object)){
var ex__12031__auto__ = e31537;
var statearr_31538_31559 = state_31510;
(statearr_31538_31559[(5)] = ex__12031__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_31510);

return cljs.core.cst$kw$recur;
} else {
throw e31537;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12029__auto__,cljs.core.cst$kw$recur)){
var G__31560 = state_31510;
state_31510 = G__31560;
continue;
} else {
return ret_value__12029__auto__;
}
break;
}
});
cljs$core$async$state_machine__12028__auto__ = function(state_31510){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12028__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12028__auto____1.call(this,state_31510);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12028__auto____0;
cljs$core$async$state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12028__auto____1;
return cljs$core$async$state_machine__12028__auto__;
})()
;})(switch__12027__auto__,c__12139__auto___31544,out))
})();
var state__12141__auto__ = (function (){var statearr_31539 = (f__12140__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12140__auto__.cljs$core$IFn$_invoke$arity$0() : f__12140__auto__.call(null));
(statearr_31539[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12139__auto___31544);

return statearr_31539;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12141__auto__);
});})(c__12139__auto___31544,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args31561 = [];
var len__7484__auto___31635 = arguments.length;
var i__7485__auto___31636 = (0);
while(true){
if((i__7485__auto___31636 < len__7484__auto___31635)){
args31561.push((arguments[i__7485__auto___31636]));

var G__31637 = (i__7485__auto___31636 + (1));
i__7485__auto___31636 = G__31637;
continue;
} else {
}
break;
}

var G__31563 = args31561.length;
switch (G__31563) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31561.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__12139__auto___31639 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12139__auto___31639,out){
return (function (){
var f__12140__auto__ = (function (){var switch__12027__auto__ = ((function (c__12139__auto___31639,out){
return (function (state_31605){
var state_val_31606 = (state_31605[(1)]);
if((state_val_31606 === (7))){
var inst_31601 = (state_31605[(2)]);
var state_31605__$1 = state_31605;
var statearr_31607_31640 = state_31605__$1;
(statearr_31607_31640[(2)] = inst_31601);

(statearr_31607_31640[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31606 === (1))){
var inst_31564 = [];
var inst_31565 = inst_31564;
var inst_31566 = cljs.core.cst$kw$cljs$core$async_SLASH_nothing;
var state_31605__$1 = (function (){var statearr_31608 = state_31605;
(statearr_31608[(7)] = inst_31565);

(statearr_31608[(8)] = inst_31566);

return statearr_31608;
})();
var statearr_31609_31641 = state_31605__$1;
(statearr_31609_31641[(2)] = null);

(statearr_31609_31641[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31606 === (4))){
var inst_31569 = (state_31605[(9)]);
var inst_31569__$1 = (state_31605[(2)]);
var inst_31570 = (inst_31569__$1 == null);
var inst_31571 = cljs.core.not(inst_31570);
var state_31605__$1 = (function (){var statearr_31610 = state_31605;
(statearr_31610[(9)] = inst_31569__$1);

return statearr_31610;
})();
if(inst_31571){
var statearr_31611_31642 = state_31605__$1;
(statearr_31611_31642[(1)] = (5));

} else {
var statearr_31612_31643 = state_31605__$1;
(statearr_31612_31643[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31606 === (15))){
var inst_31595 = (state_31605[(2)]);
var state_31605__$1 = state_31605;
var statearr_31613_31644 = state_31605__$1;
(statearr_31613_31644[(2)] = inst_31595);

(statearr_31613_31644[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31606 === (13))){
var state_31605__$1 = state_31605;
var statearr_31614_31645 = state_31605__$1;
(statearr_31614_31645[(2)] = null);

(statearr_31614_31645[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31606 === (6))){
var inst_31565 = (state_31605[(7)]);
var inst_31590 = inst_31565.length;
var inst_31591 = (inst_31590 > (0));
var state_31605__$1 = state_31605;
if(cljs.core.truth_(inst_31591)){
var statearr_31615_31646 = state_31605__$1;
(statearr_31615_31646[(1)] = (12));

} else {
var statearr_31616_31647 = state_31605__$1;
(statearr_31616_31647[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31606 === (3))){
var inst_31603 = (state_31605[(2)]);
var state_31605__$1 = state_31605;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31605__$1,inst_31603);
} else {
if((state_val_31606 === (12))){
var inst_31565 = (state_31605[(7)]);
var inst_31593 = cljs.core.vec(inst_31565);
var state_31605__$1 = state_31605;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31605__$1,(15),out,inst_31593);
} else {
if((state_val_31606 === (2))){
var state_31605__$1 = state_31605;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31605__$1,(4),ch);
} else {
if((state_val_31606 === (11))){
var inst_31569 = (state_31605[(9)]);
var inst_31573 = (state_31605[(10)]);
var inst_31583 = (state_31605[(2)]);
var inst_31584 = [];
var inst_31585 = inst_31584.push(inst_31569);
var inst_31565 = inst_31584;
var inst_31566 = inst_31573;
var state_31605__$1 = (function (){var statearr_31617 = state_31605;
(statearr_31617[(7)] = inst_31565);

(statearr_31617[(8)] = inst_31566);

(statearr_31617[(11)] = inst_31585);

(statearr_31617[(12)] = inst_31583);

return statearr_31617;
})();
var statearr_31618_31648 = state_31605__$1;
(statearr_31618_31648[(2)] = null);

(statearr_31618_31648[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31606 === (9))){
var inst_31565 = (state_31605[(7)]);
var inst_31581 = cljs.core.vec(inst_31565);
var state_31605__$1 = state_31605;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31605__$1,(11),out,inst_31581);
} else {
if((state_val_31606 === (5))){
var inst_31569 = (state_31605[(9)]);
var inst_31566 = (state_31605[(8)]);
var inst_31573 = (state_31605[(10)]);
var inst_31573__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_31569) : f.call(null,inst_31569));
var inst_31574 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_31573__$1,inst_31566);
var inst_31575 = cljs.core.keyword_identical_QMARK_(inst_31566,cljs.core.cst$kw$cljs$core$async_SLASH_nothing);
var inst_31576 = (inst_31574) || (inst_31575);
var state_31605__$1 = (function (){var statearr_31619 = state_31605;
(statearr_31619[(10)] = inst_31573__$1);

return statearr_31619;
})();
if(cljs.core.truth_(inst_31576)){
var statearr_31620_31649 = state_31605__$1;
(statearr_31620_31649[(1)] = (8));

} else {
var statearr_31621_31650 = state_31605__$1;
(statearr_31621_31650[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31606 === (14))){
var inst_31598 = (state_31605[(2)]);
var inst_31599 = cljs.core.async.close_BANG_(out);
var state_31605__$1 = (function (){var statearr_31623 = state_31605;
(statearr_31623[(13)] = inst_31598);

return statearr_31623;
})();
var statearr_31624_31651 = state_31605__$1;
(statearr_31624_31651[(2)] = inst_31599);

(statearr_31624_31651[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31606 === (10))){
var inst_31588 = (state_31605[(2)]);
var state_31605__$1 = state_31605;
var statearr_31625_31652 = state_31605__$1;
(statearr_31625_31652[(2)] = inst_31588);

(statearr_31625_31652[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31606 === (8))){
var inst_31569 = (state_31605[(9)]);
var inst_31565 = (state_31605[(7)]);
var inst_31573 = (state_31605[(10)]);
var inst_31578 = inst_31565.push(inst_31569);
var tmp31622 = inst_31565;
var inst_31565__$1 = tmp31622;
var inst_31566 = inst_31573;
var state_31605__$1 = (function (){var statearr_31626 = state_31605;
(statearr_31626[(14)] = inst_31578);

(statearr_31626[(7)] = inst_31565__$1);

(statearr_31626[(8)] = inst_31566);

return statearr_31626;
})();
var statearr_31627_31653 = state_31605__$1;
(statearr_31627_31653[(2)] = null);

(statearr_31627_31653[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12139__auto___31639,out))
;
return ((function (switch__12027__auto__,c__12139__auto___31639,out){
return (function() {
var cljs$core$async$state_machine__12028__auto__ = null;
var cljs$core$async$state_machine__12028__auto____0 = (function (){
var statearr_31631 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31631[(0)] = cljs$core$async$state_machine__12028__auto__);

(statearr_31631[(1)] = (1));

return statearr_31631;
});
var cljs$core$async$state_machine__12028__auto____1 = (function (state_31605){
while(true){
var ret_value__12029__auto__ = (function (){try{while(true){
var result__12030__auto__ = switch__12027__auto__(state_31605);
if(cljs.core.keyword_identical_QMARK_(result__12030__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12030__auto__;
}
break;
}
}catch (e31632){if((e31632 instanceof Object)){
var ex__12031__auto__ = e31632;
var statearr_31633_31654 = state_31605;
(statearr_31633_31654[(5)] = ex__12031__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_31605);

return cljs.core.cst$kw$recur;
} else {
throw e31632;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12029__auto__,cljs.core.cst$kw$recur)){
var G__31655 = state_31605;
state_31605 = G__31655;
continue;
} else {
return ret_value__12029__auto__;
}
break;
}
});
cljs$core$async$state_machine__12028__auto__ = function(state_31605){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12028__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12028__auto____1.call(this,state_31605);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12028__auto____0;
cljs$core$async$state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12028__auto____1;
return cljs$core$async$state_machine__12028__auto__;
})()
;})(switch__12027__auto__,c__12139__auto___31639,out))
})();
var state__12141__auto__ = (function (){var statearr_31634 = (f__12140__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12140__auto__.cljs$core$IFn$_invoke$arity$0() : f__12140__auto__.call(null));
(statearr_31634[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12139__auto___31639);

return statearr_31634;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12141__auto__);
});})(c__12139__auto___31639,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;

