// Compiled by ClojureScript 1.9.229 {}
goog.provide('c2.svg');
goog.require('cljs.core');
goog.require('c2.core');
goog.require('c2.maths');
goog.require('c2.dom');
/**
 * Ensure that coordinates (potentially map of `{:x :y}`) are a seq or vector pair.
 */
c2.svg.__GT_xy = (function c2$svg$__GT_xy(coordinates){
if((cljs.core.sequential_QMARK_.call(null,coordinates)) && (cljs.core._EQ_.call(null,(2),cljs.core.count.call(null,coordinates)))){
return coordinates;
} else {
if(cljs.core.map_QMARK_.call(null,coordinates)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"x","x",2099068185).cljs$core$IFn$_invoke$arity$1(coordinates),new cljs.core.Keyword(null,"y","y",-1757859776).cljs$core$IFn$_invoke$arity$1(coordinates)], null);
} else {
return null;
}
}
});
c2.svg.translate = (function c2$svg$translate(coordinates){
var vec__19935 = c2.svg.__GT_xy.call(null,coordinates);
var x = cljs.core.nth.call(null,vec__19935,(0),null);
var y = cljs.core.nth.call(null,vec__19935,(1),null);
return [cljs.core.str("translate("),cljs.core.str(x),cljs.core.str(","),cljs.core.str(y),cljs.core.str(")")].join('');
});
c2.svg.scale = (function c2$svg$scale(coordinates){
if(typeof coordinates === 'number'){
return [cljs.core.str("scale("),cljs.core.str(coordinates),cljs.core.str(")")].join('');
} else {
var vec__19941 = c2.svg.__GT_xy.call(null,coordinates);
var x = cljs.core.nth.call(null,vec__19941,(0),null);
var y = cljs.core.nth.call(null,vec__19941,(1),null);
return [cljs.core.str("scale("),cljs.core.str(x),cljs.core.str(","),cljs.core.str(y),cljs.core.str(")")].join('');
}
});
c2.svg.rotate = (function c2$svg$rotate(var_args){
var args19944 = [];
var len__7484__auto___19950 = arguments.length;
var i__7485__auto___19951 = (0);
while(true){
if((i__7485__auto___19951 < len__7484__auto___19950)){
args19944.push((arguments[i__7485__auto___19951]));

var G__19952 = (i__7485__auto___19951 + (1));
i__7485__auto___19951 = G__19952;
continue;
} else {
}
break;
}

var G__19946 = args19944.length;
switch (G__19946) {
case 1:
return c2.svg.rotate.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.svg.rotate.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19944.length)].join('')));

}
});

c2.svg.rotate.cljs$core$IFn$_invoke$arity$1 = (function (angle){
return c2.svg.rotate.call(null,angle,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null));
});

c2.svg.rotate.cljs$core$IFn$_invoke$arity$2 = (function (angle,coordinates){
var vec__19947 = c2.svg.__GT_xy.call(null,coordinates);
var x = cljs.core.nth.call(null,vec__19947,(0),null);
var y = cljs.core.nth.call(null,vec__19947,(1),null);
return [cljs.core.str("rotate("),cljs.core.str(angle),cljs.core.str(","),cljs.core.str(x),cljs.core.str(","),cljs.core.str(y),cljs.core.str(")")].join('');
});

c2.svg.rotate.cljs$lang$maxFixedArity = 2;

/**
 * Returns map of `{:x :y :width :height}` containing SVG element bounding box.
 * All coordinates are in userspace. Ref [SVG spec](http://www.w3.org/TR/SVG/types.html#InterfaceSVGLocatable)
 */
c2.svg.get_bounds = (function c2$svg$get_bounds($svg_el){
var b = $svg_el.getBBox();
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"x","x",2099068185),b.x,new cljs.core.Keyword(null,"y","y",-1757859776),b.y,new cljs.core.Keyword(null,"width","width",-384071477),b.width,new cljs.core.Keyword(null,"height","height",1025178622),b.height], null);
});
/**
 * Returns a transform string that will scale and center provided element `{:width :height :x :y}` within container `{:width :height}`.
 */
c2.svg.transform_to_center = (function c2$svg$transform_to_center(element,container){
var map__19958 = element;
var map__19958__$1 = ((((!((map__19958 == null)))?((((map__19958.cljs$lang$protocol_mask$partition0$ & (64))) || (map__19958.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__19958):map__19958);
var ew = cljs.core.get.call(null,map__19958__$1,new cljs.core.Keyword(null,"width","width",-384071477));
var eh = cljs.core.get.call(null,map__19958__$1,new cljs.core.Keyword(null,"height","height",1025178622));
var x = cljs.core.get.call(null,map__19958__$1,new cljs.core.Keyword(null,"x","x",2099068185));
var y = cljs.core.get.call(null,map__19958__$1,new cljs.core.Keyword(null,"y","y",-1757859776));
var map__19959 = container;
var map__19959__$1 = ((((!((map__19959 == null)))?((((map__19959.cljs$lang$protocol_mask$partition0$ & (64))) || (map__19959.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__19959):map__19959);
var w = cljs.core.get.call(null,map__19959__$1,new cljs.core.Keyword(null,"width","width",-384071477));
var h = cljs.core.get.call(null,map__19959__$1,new cljs.core.Keyword(null,"height","height",1025178622));
var s = (function (){var x__6747__auto__ = (h / eh);
var y__6748__auto__ = (w / ew);
return ((x__6747__auto__ < y__6748__auto__) ? x__6747__auto__ : y__6748__auto__);
})();
return [cljs.core.str(c2.svg.translate.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [((w / (2)) - (s * (ew / (2)))),((h / (2)) - (s * (eh / (2))))], null))),cljs.core.str(" "),cljs.core.str(c2.svg.scale.call(null,s)),cljs.core.str(" "),cljs.core.str(c2.svg.translate.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(- x),(- y)], null)))].join('');
});
/**
 * Scales and centers `$svg-el` within its parent SVG container.
 * Uses parent's width and height attributes only.
 */
c2.svg.transform_to_center_BANG_ = (function c2$svg$transform_to_center_BANG_($svg_el){
var $svg = $svg_el.ownerSVGElement;
var t = c2.svg.transform_to_center.call(null,c2.svg.get_bounds.call(null,$svg_el),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"width","width",-384071477),parseFloat(c2.dom.attr.call(null,$svg,new cljs.core.Keyword(null,"width","width",-384071477))),new cljs.core.Keyword(null,"height","height",1025178622),parseFloat(c2.dom.attr.call(null,$svg,new cljs.core.Keyword(null,"height","height",1025178622)))], null));
return c2.dom.attr.call(null,$svg_el,new cljs.core.Keyword(null,"transform","transform",1381301764),t);
});
/**
 * Returns axis <g> hiccup vector for provided input `scale` and collection of `ticks` (numbers).
 * Direction away from the data frame is defined to be positive; use negative margins and widths to render axis inside of data frame.
 * 
 * Kwargs:
 * 
 * > *:orientation* &in; (`:top`, `:bottom`, `:left`, `:right`), where the axis should be relative to the data frame, defaults to `:left`
 * 
 * > *:formatter* fn run on tick values, defaults to `str`
 * 
 * > *:major-tick-width* width of ticks (minor ticks not yet implemented), defaults to 6
 * 
 * > *:text-margin* distance between axis and start of text, defaults to 9
 * 
 * > *:label* axis label, centered on axis; :left and :right orientation labels are rotated by +/- pi/2, respectively
 * 
 * > *:label-margin* distance between axis and label, defaults to 28
 */
c2.svg.axis = (function c2$svg$axis(var_args){
var args__7491__auto__ = [];
var len__7484__auto___19978 = arguments.length;
var i__7485__auto___19979 = (0);
while(true){
if((i__7485__auto___19979 < len__7484__auto___19978)){
args__7491__auto__.push((arguments[i__7485__auto___19979]));

var G__19980 = (i__7485__auto___19979 + (1));
i__7485__auto___19979 = G__19980;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((2) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((2)),(0),null)):null);
return c2.svg.axis.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7492__auto__);
});

c2.svg.axis.cljs$core$IFn$_invoke$arity$variadic = (function (scale,ticks,p__19965){
var map__19966 = p__19965;
var map__19966__$1 = ((((!((map__19966 == null)))?((((map__19966.cljs$lang$protocol_mask$partition0$ & (64))) || (map__19966.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__19966):map__19966);
var orientation = cljs.core.get.call(null,map__19966__$1,new cljs.core.Keyword(null,"orientation","orientation",623557579),new cljs.core.Keyword(null,"left","left",-399115937));
var formatter = cljs.core.get.call(null,map__19966__$1,new cljs.core.Keyword(null,"formatter","formatter",-483008823),cljs.core.str);
var major_tick_width = cljs.core.get.call(null,map__19966__$1,new cljs.core.Keyword(null,"major-tick-width","major-tick-width",-401901043),(6));
var text_margin = cljs.core.get.call(null,map__19966__$1,new cljs.core.Keyword(null,"text-margin","text-margin",1161346978),(9));
var label = cljs.core.get.call(null,map__19966__$1,new cljs.core.Keyword(null,"label","label",1718410804));
var label_margin = cljs.core.get.call(null,map__19966__$1,new cljs.core.Keyword(null,"label-margin","label-margin",-17690670),(28));
var vec__19968 = (function (){var G__19971 = (((orientation instanceof cljs.core.Keyword))?orientation.fqn:null);
switch (G__19971) {
case "left":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"x","x",2099068185),new cljs.core.Keyword(null,"y","y",-1757859776),new cljs.core.Keyword(null,"x1","x1",-1863922247),new cljs.core.Keyword(null,"x2","x2",-1362513475),new cljs.core.Keyword(null,"y1","y1",589123466),new cljs.core.Keyword(null,"y2","y2",-718691301)], null);

break;
case "right":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"x","x",2099068185),new cljs.core.Keyword(null,"y","y",-1757859776),new cljs.core.Keyword(null,"x1","x1",-1863922247),new cljs.core.Keyword(null,"x2","x2",-1362513475),new cljs.core.Keyword(null,"y1","y1",589123466),new cljs.core.Keyword(null,"y2","y2",-718691301)], null);

break;
case "top":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"y","y",-1757859776),new cljs.core.Keyword(null,"x","x",2099068185),new cljs.core.Keyword(null,"y1","y1",589123466),new cljs.core.Keyword(null,"y2","y2",-718691301),new cljs.core.Keyword(null,"x1","x1",-1863922247),new cljs.core.Keyword(null,"x2","x2",-1362513475)], null);

break;
case "bottom":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"y","y",-1757859776),new cljs.core.Keyword(null,"x","x",2099068185),new cljs.core.Keyword(null,"y1","y1",589123466),new cljs.core.Keyword(null,"y2","y2",-718691301),new cljs.core.Keyword(null,"x1","x1",-1863922247),new cljs.core.Keyword(null,"x2","x2",-1362513475)], null);

break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(orientation)].join('')));

}
})();
var x = cljs.core.nth.call(null,vec__19968,(0),null);
var y = cljs.core.nth.call(null,vec__19968,(1),null);
var x1 = cljs.core.nth.call(null,vec__19968,(2),null);
var x2 = cljs.core.nth.call(null,vec__19968,(3),null);
var y1 = cljs.core.nth.call(null,vec__19968,(4),null);
var y2 = cljs.core.nth.call(null,vec__19968,(5),null);
var parity = (function (){var G__19972 = (((orientation instanceof cljs.core.Keyword))?orientation.fqn:null);
switch (G__19972) {
case "left":
return (-1);

break;
case "top":
return (-1);

break;
case "right":
return (1);

break;
case "bottom":
return (1);

break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(orientation)].join('')));

}
})();
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"g","g",1738089905),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),[cljs.core.str("axis "),cljs.core.str(cljs.core.name.call(null,orientation))].join('')], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"line.rule","line.rule",-722114232),cljs.core.apply.call(null,cljs.core.hash_map,cljs.core.interleave.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [y1,y2], null),new cljs.core.Keyword(null,"range","range",1639692286).cljs$core$IFn$_invoke$arity$1(scale)))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"g.ticks","g.ticks",28507493),c2.core.unify.call(null,cljs.core.map.call(null,cljs.core.vector,ticks,cljs.core.repeat.call(null,scale)),((function (vec__19968,x,y,x1,x2,y1,y2,parity,map__19966,map__19966__$1,orientation,formatter,major_tick_width,text_margin,label,label_margin){
return (function (p__19973){
var vec__19974 = p__19973;
var d = cljs.core.nth.call(null,vec__19974,(0),null);
var scale__$1 = cljs.core.nth.call(null,vec__19974,(1),null);
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"g.tick.major-tick","g.tick.major-tick",1467819139),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"transform","transform",1381301764),c2.svg.translate.call(null,cljs.core.PersistentArrayMap.fromArray([x,(0),y,scale__$1.call(null,d)], true, false))], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"text","text",-1790561697),cljs.core.PersistentArrayMap.fromArray([x,(parity * text_margin)], true, false),formatter.call(null,d)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"line","line",212345235),cljs.core.PersistentArrayMap.fromArray([x1,(0),x2,(parity * major_tick_width)], true, false)], null)], null);
});})(vec__19968,x,y,x1,x2,y1,y2,parity,map__19966,map__19966__$1,orientation,formatter,major_tick_width,text_margin,label,label_margin))
)], null),(cljs.core.truth_(label)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"text.label","text.label",210580295),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"transform","transform",1381301764),[cljs.core.str(c2.svg.translate.call(null,cljs.core.PersistentArrayMap.fromArray([x,(parity * label_margin),y,c2.maths.mean.call(null,new cljs.core.Keyword(null,"range","range",1639692286).cljs$core$IFn$_invoke$arity$1(scale))], true, false))),cljs.core.str(" "),cljs.core.str((function (){var G__19977 = (((orientation instanceof cljs.core.Keyword))?orientation.fqn:null);
switch (G__19977) {
case "left":
return c2.svg.rotate.call(null,(-90));

break;
case "right":
return c2.svg.rotate.call(null,(90));

break;
default:
return "";

}
})())].join('')], null),label], null):null)], null);
});

c2.svg.axis.cljs$lang$maxFixedArity = (2);

c2.svg.axis.cljs$lang$applyTo = (function (seq19962){
var G__19963 = cljs.core.first.call(null,seq19962);
var seq19962__$1 = cljs.core.next.call(null,seq19962);
var G__19964 = cljs.core.first.call(null,seq19962__$1);
var seq19962__$2 = cljs.core.next.call(null,seq19962__$1);
return c2.svg.axis.cljs$core$IFn$_invoke$arity$variadic(G__19963,G__19964,seq19962__$2);
});

c2.svg.ArcMax = (c2.maths.Tau - 1.0E-7);
/**
 * Calculate SVG path data for a circle of `radius` starting at 3 o'clock and sweeping in positive y.
 */
c2.svg.circle = (function c2$svg$circle(var_args){
var args19984 = [];
var len__7484__auto___19990 = arguments.length;
var i__7485__auto___19991 = (0);
while(true){
if((i__7485__auto___19991 < len__7484__auto___19990)){
args19984.push((arguments[i__7485__auto___19991]));

var G__19992 = (i__7485__auto___19991 + (1));
i__7485__auto___19991 = G__19992;
continue;
} else {
}
break;
}

var G__19986 = args19984.length;
switch (G__19986) {
case 1:
return c2.svg.circle.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.svg.circle.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19984.length)].join('')));

}
});

c2.svg.circle.cljs$core$IFn$_invoke$arity$1 = (function (radius){
return c2.svg.circle.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null),radius);
});

c2.svg.circle.cljs$core$IFn$_invoke$arity$2 = (function (coordinates,radius){
var vec__19987 = c2.svg.__GT_xy.call(null,coordinates);
var x = cljs.core.nth.call(null,vec__19987,(0),null);
var y = cljs.core.nth.call(null,vec__19987,(1),null);
return [cljs.core.str("M"),cljs.core.str((x + radius)),cljs.core.str(","),cljs.core.str(y),cljs.core.str("A"),cljs.core.str((x + radius)),cljs.core.str(","),cljs.core.str((y + radius)),cljs.core.str(" 0 1,1"),cljs.core.str((- (x + radius))),cljs.core.str(","),cljs.core.str(y),cljs.core.str("A"),cljs.core.str((x + radius)),cljs.core.str(","),cljs.core.str((y + radius)),cljs.core.str(" 0 1,1"),cljs.core.str((x + radius)),cljs.core.str(","),cljs.core.str(y)].join('');
});

c2.svg.circle.cljs$lang$maxFixedArity = 2;

/**
 * Calculate SVG path data for an arc.
 */
c2.svg.arc = (function c2$svg$arc(var_args){
var args__7491__auto__ = [];
var len__7484__auto___20001 = arguments.length;
var i__7485__auto___20002 = (0);
while(true){
if((i__7485__auto___20002 < len__7484__auto___20001)){
args__7491__auto__.push((arguments[i__7485__auto___20002]));

var G__20003 = (i__7485__auto___20002 + (1));
i__7485__auto___20002 = G__20003;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((0) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((0)),(0),null)):null);
return c2.svg.arc.cljs$core$IFn$_invoke$arity$variadic(argseq__7492__auto__);
});

c2.svg.arc.cljs$core$IFn$_invoke$arity$variadic = (function (p__19995){
var map__19996 = p__19995;
var map__19996__$1 = ((((!((map__19996 == null)))?((((map__19996.cljs$lang$protocol_mask$partition0$ & (64))) || (map__19996.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__19996):map__19996);
var inner_radius = cljs.core.get.call(null,map__19996__$1,new cljs.core.Keyword(null,"inner-radius","inner-radius",-681823510),(0));
var outer_radius = cljs.core.get.call(null,map__19996__$1,new cljs.core.Keyword(null,"outer-radius","outer-radius",1715267468),(1));
var start_angle = cljs.core.get.call(null,map__19996__$1,new cljs.core.Keyword(null,"start-angle","start-angle",-1763140493),(0));
var end_angle = cljs.core.get.call(null,map__19996__$1,new cljs.core.Keyword(null,"end-angle","end-angle",1398887581),c2.maths.Pi);
var angle_offset = cljs.core.get.call(null,map__19996__$1,new cljs.core.Keyword(null,"angle-offset","angle-offset",-824819163),(0));
var r0 = inner_radius;
var r1 = outer_radius;
var vec__19998 = cljs.core.sort.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(angle_offset + start_angle),(angle_offset + end_angle)], null));
var a0 = cljs.core.nth.call(null,vec__19998,(0),null);
var a1 = cljs.core.nth.call(null,vec__19998,(1),null);
var da = (a1 - a0);
var large_arc_flag = (((da < c2.maths.Pi))?"0":"1");
var s0 = c2.maths.sin.call(null,a0);
var c0 = c2.maths.cos.call(null,a0);
var s1 = c2.maths.sin.call(null,a1);
var c1 = c2.maths.cos.call(null,a1);
if((da >= c2.svg.ArcMax)){
return [cljs.core.str("M0,"),cljs.core.str(r1),cljs.core.str("A"),cljs.core.str(r1),cljs.core.str(","),cljs.core.str(r1),cljs.core.str(" 0 1,1 0,"),cljs.core.str((- r1)),cljs.core.str("A"),cljs.core.str(r1),cljs.core.str(","),cljs.core.str(r1),cljs.core.str(" 0 1,1 0,"),cljs.core.str(r1),cljs.core.str(((cljs.core.not_EQ_.call(null,(0),r0))?[cljs.core.str("M0,"),cljs.core.str(r0),cljs.core.str("A"),cljs.core.str(r0),cljs.core.str(","),cljs.core.str(r0),cljs.core.str(" 0 1,0 0,"),cljs.core.str((- r0)),cljs.core.str("A"),cljs.core.str(r0),cljs.core.str(","),cljs.core.str(r0),cljs.core.str(" 0 1,0 0,"),cljs.core.str(r0)].join(''):null)),cljs.core.str("Z")].join('');
} else {
return [cljs.core.str("M"),cljs.core.str((r1 * c0)),cljs.core.str(","),cljs.core.str((r1 * s0)),cljs.core.str("A"),cljs.core.str(r1),cljs.core.str(","),cljs.core.str(r1),cljs.core.str(" 0 "),cljs.core.str(large_arc_flag),cljs.core.str(",1 "),cljs.core.str((r1 * c1)),cljs.core.str(","),cljs.core.str((r1 * s1)),cljs.core.str(((cljs.core.not_EQ_.call(null,(0),r0))?[cljs.core.str("L"),cljs.core.str((r0 * c1)),cljs.core.str(","),cljs.core.str((r0 * s1)),cljs.core.str("A"),cljs.core.str(r0),cljs.core.str(","),cljs.core.str(r0),cljs.core.str(" 0 "),cljs.core.str(large_arc_flag),cljs.core.str(",0 "),cljs.core.str((r0 * c0)),cljs.core.str(","),cljs.core.str((r0 * s0))].join(''):"L0,0")),cljs.core.str("Z")].join('');
}
});

c2.svg.arc.cljs$lang$maxFixedArity = (0);

c2.svg.arc.cljs$lang$applyTo = (function (seq19994){
return c2.svg.arc.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq19994));
});

