// Compiled by ClojureScript 1.9.229 {:static-fns true, :optimize-constants true}
goog.provide('c2.dom');
goog.require('cljs.core');
goog.require('goog.dom.forms');
goog.require('goog.dom');
goog.require('goog.dom.classes');
goog.require('singult.core');
goog.require('goog.style');
goog.require('clojure.string');
Element.prototype.matchesSelector = Element.prototype.webkitMatchesSelector || Element.prototype.mozMatchesSelector || Element.prototype.msMatchesSelector || Element.prototype.oMatchesSelector;
if(cljs.core.truth_(typeof NodeList != "undefined")){
NodeList.prototype.cljs$core$ISeqable$ = true;

NodeList.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (array){
var array__$1 = this;
return cljs.core.array_seq.cljs$core$IFn$_invoke$arity$2(array__$1,(0));
});
} else {
}
HTMLCollection.prototype.cljs$core$ISeqable$ = true;

HTMLCollection.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (array){
var array__$1 = this;
return cljs.core.array_seq.cljs$core$IFn$_invoke$arity$2(array__$1,(0));
});

/**
 * @interface
 */
c2.dom.IDom = function(){};

/**
 * Converts x to a live DOM node
 */
c2.dom.__GT_dom = (function c2$dom$__GT_dom(x){
if((!((x == null))) && (!((x.c2$dom$IDom$__GT_dom$arity$1 == null)))){
return x.c2$dom$IDom$__GT_dom$arity$1(x);
} else {
var x__7072__auto__ = (((x == null))?null:x);
var m__7073__auto__ = (c2.dom.__GT_dom[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return (m__7073__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7073__auto__.cljs$core$IFn$_invoke$arity$1(x) : m__7073__auto__.call(null,x));
} else {
var m__7073__auto____$1 = (c2.dom.__GT_dom["_"]);
if(!((m__7073__auto____$1 == null))){
return (m__7073__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7073__auto____$1.cljs$core$IFn$_invoke$arity$1(x) : m__7073__auto____$1.call(null,x));
} else {
throw cljs.core.missing_protocol("IDom.->dom",x);
}
}
}
});

(c2.dom.IDom["string"] = true);

(c2.dom.__GT_dom["string"] = (function (selector){
return (c2.dom.select.cljs$core$IFn$_invoke$arity$1 ? c2.dom.select.cljs$core$IFn$_invoke$arity$1(selector) : c2.dom.select.call(null,selector));
}));

cljs.core.PersistentVector.prototype.c2$dom$IDom$ = true;

cljs.core.PersistentVector.prototype.c2$dom$IDom$__GT_dom$arity$1 = (function (v){
var v__$1 = this;
return singult.core.render(v__$1);
});
if(cljs.core.truth_(typeof Node != "undefined")){
Node.prototype.c2$dom$IDom$ = true;

Node.prototype.c2$dom$IDom$__GT_dom$arity$1 = (function (node){
var node__$1 = this;
return node__$1;
});
} else {
}
/**
 * Select a single DOM node via CSS selector, optionally scoped by second arg.
 */
c2.dom.select = (function c2$dom$select(var_args){
var args39673 = [];
var len__7484__auto___39676 = arguments.length;
var i__7485__auto___39677 = (0);
while(true){
if((i__7485__auto___39677 < len__7484__auto___39676)){
args39673.push((arguments[i__7485__auto___39677]));

var G__39678 = (i__7485__auto___39677 + (1));
i__7485__auto___39677 = G__39678;
continue;
} else {
}
break;
}

var G__39675 = args39673.length;
switch (G__39675) {
case 1:
return c2.dom.select.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.select.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args39673.length)].join('')));

}
});

c2.dom.select.cljs$core$IFn$_invoke$arity$1 = (function (selector){
return document.querySelector(selector);
});

c2.dom.select.cljs$core$IFn$_invoke$arity$2 = (function (selector,container){
return c2.dom.__GT_dom(container).querySelector(selector);
});

c2.dom.select.cljs$lang$maxFixedArity = 2;

/**
 * Like select, but returns a collection of nodes.
 */
c2.dom.select_all = (function c2$dom$select_all(var_args){
var args39680 = [];
var len__7484__auto___39683 = arguments.length;
var i__7485__auto___39684 = (0);
while(true){
if((i__7485__auto___39684 < len__7484__auto___39683)){
args39680.push((arguments[i__7485__auto___39684]));

var G__39685 = (i__7485__auto___39684 + (1));
i__7485__auto___39684 = G__39685;
continue;
} else {
}
break;
}

var G__39682 = args39680.length;
switch (G__39682) {
case 1:
return c2.dom.select_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.select_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args39680.length)].join('')));

}
});

c2.dom.select_all.cljs$core$IFn$_invoke$arity$1 = (function (selector){
return document.querySelectorAll(selector);
});

c2.dom.select_all.cljs$core$IFn$_invoke$arity$2 = (function (selector,container){
return c2.dom.__GT_dom(container).querySelectorAll(selector);
});

c2.dom.select_all.cljs$lang$maxFixedArity = 2;

/**
 * Does live `node` match CSS `selector`?
 */
c2.dom.matches_selector_QMARK_ = (function c2$dom$matches_selector_QMARK_(node,selector){
if(cljs.core.truth_(node)){
return node.matchesSelector(selector);
} else {
return null;
}
});
/**
 * Return the children of a live DOM element.
 */
c2.dom.children = (function c2$dom$children(node){
if(cljs.core.truth_(node)){
return c2.dom.__GT_dom(node).children;
} else {
return null;
}
});
/**
 * Return parent of a live DOM node.
 */
c2.dom.parent = (function c2$dom$parent(node){
if(cljs.core.truth_(c2$dom$parent)){
return c2.dom.__GT_dom(node).parentNode;
} else {
return null;
}
});
/**
 * Make element last child of container.
 * Returns live child.
 */
c2.dom.append_BANG_ = (function c2$dom$append_BANG_(container,el){
var el__$1 = c2.dom.__GT_dom(el);
var G__39689_39691 = c2.dom.__GT_dom(container);
var G__39690_39692 = el__$1;
goog.dom.appendChild(G__39689_39691,G__39690_39692);

return el__$1;
});
/**
 * Make element first child of container.
 * Returns live DOM child.
 */
c2.dom.prepend_BANG_ = (function c2$dom$prepend_BANG_(container,el){
var el__$1 = c2.dom.__GT_dom(el);
var G__39696_39699 = c2.dom.__GT_dom(container);
var G__39697_39700 = el__$1;
var G__39698_39701 = (0);
goog.dom.insertChildAt(G__39696_39699,G__39697_39700,G__39698_39701);

return el__$1;
});
/**
 * Remove element from DOM and return it.
 * > *el* CSS selector or live DOM node
 */
c2.dom.remove_BANG_ = (function c2$dom$remove_BANG_(el){
var G__39703 = c2.dom.__GT_dom(el);
return goog.dom.removeNode(G__39703);
});
/**
 * Replace live DOM node with a new one, returning the latter.
 * > *old* CSS selector or live DOM node
 * > *new* CSS selector, live DOM node, or hiccup vector
 */
c2.dom.replace_BANG_ = (function c2$dom$replace_BANG_(old,new$){
var new$__$1 = c2.dom.__GT_dom(new$);
var G__39706_39708 = new$__$1;
var G__39707_39709 = c2.dom.__GT_dom(old);
goog.dom.replaceNode(G__39706_39708,G__39707_39709);

return new$__$1;
});
/**
 * Get or set inline element style.
 * 
 * `(style el)`                map of inline element styles
 * 
 * `(style el :keyword)`       value of style :keyword
 * 
 * `(style el {:keyword val})` sets inline style according to map, returns element
 * 
 * `(style el :keyword val)`   sets single style, returns element
 */
c2.dom.style = (function c2$dom$style(var_args){
var args39710 = [];
var len__7484__auto___39728 = arguments.length;
var i__7485__auto___39729 = (0);
while(true){
if((i__7485__auto___39729 < len__7484__auto___39728)){
args39710.push((arguments[i__7485__auto___39729]));

var G__39730 = (i__7485__auto___39729 + (1));
i__7485__auto___39729 = G__39730;
continue;
} else {
}
break;
}

var G__39712 = args39710.length;
switch (G__39712) {
case 1:
return c2.dom.style.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.style.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return c2.dom.style.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args39710.length)].join('')));

}
});

c2.dom.style.cljs$core$IFn$_invoke$arity$1 = (function (el){
throw (new Error("TODO: return map of element styles"));
});

c2.dom.style.cljs$core$IFn$_invoke$arity$2 = (function (el,x){
var el__$1 = c2.dom.__GT_dom(el);
if((x instanceof cljs.core.Keyword)){
var G__39713 = el__$1;
var G__39714 = cljs.core.name(x);
return goog.style.getComputedStyle(G__39713,G__39714);
} else {
if(cljs.core.map_QMARK_(x)){
var seq__39715_39732 = cljs.core.seq(x);
var chunk__39716_39733 = null;
var count__39717_39734 = (0);
var i__39718_39735 = (0);
while(true){
if((i__39718_39735 < count__39717_39734)){
var vec__39719_39736 = chunk__39716_39733.cljs$core$IIndexed$_nth$arity$2(null,i__39718_39735);
var k_39737 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39719_39736,(0),null);
var v_39738 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39719_39736,(1),null);
c2.dom.style.cljs$core$IFn$_invoke$arity$3(el__$1,k_39737,v_39738);

var G__39739 = seq__39715_39732;
var G__39740 = chunk__39716_39733;
var G__39741 = count__39717_39734;
var G__39742 = (i__39718_39735 + (1));
seq__39715_39732 = G__39739;
chunk__39716_39733 = G__39740;
count__39717_39734 = G__39741;
i__39718_39735 = G__39742;
continue;
} else {
var temp__4657__auto___39743 = cljs.core.seq(seq__39715_39732);
if(temp__4657__auto___39743){
var seq__39715_39744__$1 = temp__4657__auto___39743;
if(cljs.core.chunked_seq_QMARK_(seq__39715_39744__$1)){
var c__7220__auto___39745 = cljs.core.chunk_first(seq__39715_39744__$1);
var G__39746 = cljs.core.chunk_rest(seq__39715_39744__$1);
var G__39747 = c__7220__auto___39745;
var G__39748 = cljs.core.count(c__7220__auto___39745);
var G__39749 = (0);
seq__39715_39732 = G__39746;
chunk__39716_39733 = G__39747;
count__39717_39734 = G__39748;
i__39718_39735 = G__39749;
continue;
} else {
var vec__39722_39750 = cljs.core.first(seq__39715_39744__$1);
var k_39751 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39722_39750,(0),null);
var v_39752 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39722_39750,(1),null);
c2.dom.style.cljs$core$IFn$_invoke$arity$3(el__$1,k_39751,v_39752);

var G__39753 = cljs.core.next(seq__39715_39744__$1);
var G__39754 = null;
var G__39755 = (0);
var G__39756 = (0);
seq__39715_39732 = G__39753;
chunk__39716_39733 = G__39754;
count__39717_39734 = G__39755;
i__39718_39735 = G__39756;
continue;
}
} else {
}
}
break;
}

return el__$1;
} else {
return null;
}
}
});

c2.dom.style.cljs$core$IFn$_invoke$arity$3 = (function (el,k,v){
var G__39725_39757 = c2.dom.__GT_dom(el);
var G__39726_39758 = cljs.core.name(k);
var G__39727_39759 = ((typeof v === 'string')?v:((typeof v === 'number')?(cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$bottom,null,cljs.core.cst$kw$top,null,cljs.core.cst$kw$width,null,cljs.core.cst$kw$right,null,cljs.core.cst$kw$height,null,cljs.core.cst$kw$left,null], null), null).call(null,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(k)))?[cljs.core.str(v),cljs.core.str("px")].join(''):v):null));
goog.style.setStyle(G__39725_39757,G__39726_39758,G__39727_39759);

return el;
});

c2.dom.style.cljs$lang$maxFixedArity = 3;

/**
 * Get or set element attributes.
 * 
 * `(attr el)`                map of element attributes
 * 
 * `(attr el :keyword)`       value of attr :keyword
 * 
 * `(attr el {:keyword val})` sets element attributes according to map, returns element
 * 
 * `(attr el :keyword val)`   sets single attr, returns element
 */
c2.dom.attr = (function c2$dom$attr(var_args){
var args39760 = [];
var len__7484__auto___39779 = arguments.length;
var i__7485__auto___39780 = (0);
while(true){
if((i__7485__auto___39780 < len__7484__auto___39779)){
args39760.push((arguments[i__7485__auto___39780]));

var G__39781 = (i__7485__auto___39780 + (1));
i__7485__auto___39780 = G__39781;
continue;
} else {
}
break;
}

var G__39762 = args39760.length;
switch (G__39762) {
case 1:
return c2.dom.attr.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.attr.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return c2.dom.attr.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args39760.length)].join('')));

}
});

c2.dom.attr.cljs$core$IFn$_invoke$arity$1 = (function (el){
var attrs = c2.dom.__GT_dom(el).attributes;
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__7189__auto__ = ((function (attrs){
return (function c2$dom$iter__39763(s__39764){
return (new cljs.core.LazySeq(null,((function (attrs){
return (function (){
var s__39764__$1 = s__39764;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__39764__$1);
if(temp__4657__auto__){
var s__39764__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__39764__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__39764__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__39766 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__39765 = (0);
while(true){
if((i__39765 < size__7188__auto__)){
var i = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__39765);
cljs.core.chunk_append(b__39766,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.keyword.cljs$core$IFn$_invoke$arity$1((attrs[i]).name),(attrs[i]).value], null));

var G__39783 = (i__39765 + (1));
i__39765 = G__39783;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__39766),c2$dom$iter__39763(cljs.core.chunk_rest(s__39764__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__39766),null);
}
} else {
var i = cljs.core.first(s__39764__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.keyword.cljs$core$IFn$_invoke$arity$1((attrs[i]).name),(attrs[i]).value], null),c2$dom$iter__39763(cljs.core.rest(s__39764__$2)));
}
} else {
return null;
}
break;
}
});})(attrs))
,null,null));
});})(attrs))
;
return iter__7189__auto__(cljs.core.range.cljs$core$IFn$_invoke$arity$1(attrs.length));
})());
});

c2.dom.attr.cljs$core$IFn$_invoke$arity$2 = (function (el,x){
var el__$1 = c2.dom.__GT_dom(el);
if((x instanceof cljs.core.Keyword)){
return el__$1.getAttribute(cljs.core.name(x));
} else {
if(cljs.core.map_QMARK_(x)){
var seq__39769_39784 = cljs.core.seq(x);
var chunk__39770_39785 = null;
var count__39771_39786 = (0);
var i__39772_39787 = (0);
while(true){
if((i__39772_39787 < count__39771_39786)){
var vec__39773_39788 = chunk__39770_39785.cljs$core$IIndexed$_nth$arity$2(null,i__39772_39787);
var k_39789 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39773_39788,(0),null);
var v_39790 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39773_39788,(1),null);
c2.dom.attr.cljs$core$IFn$_invoke$arity$3(el__$1,k_39789,v_39790);

var G__39791 = seq__39769_39784;
var G__39792 = chunk__39770_39785;
var G__39793 = count__39771_39786;
var G__39794 = (i__39772_39787 + (1));
seq__39769_39784 = G__39791;
chunk__39770_39785 = G__39792;
count__39771_39786 = G__39793;
i__39772_39787 = G__39794;
continue;
} else {
var temp__4657__auto___39795 = cljs.core.seq(seq__39769_39784);
if(temp__4657__auto___39795){
var seq__39769_39796__$1 = temp__4657__auto___39795;
if(cljs.core.chunked_seq_QMARK_(seq__39769_39796__$1)){
var c__7220__auto___39797 = cljs.core.chunk_first(seq__39769_39796__$1);
var G__39798 = cljs.core.chunk_rest(seq__39769_39796__$1);
var G__39799 = c__7220__auto___39797;
var G__39800 = cljs.core.count(c__7220__auto___39797);
var G__39801 = (0);
seq__39769_39784 = G__39798;
chunk__39770_39785 = G__39799;
count__39771_39786 = G__39800;
i__39772_39787 = G__39801;
continue;
} else {
var vec__39776_39802 = cljs.core.first(seq__39769_39796__$1);
var k_39803 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39776_39802,(0),null);
var v_39804 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39776_39802,(1),null);
c2.dom.attr.cljs$core$IFn$_invoke$arity$3(el__$1,k_39803,v_39804);

var G__39805 = cljs.core.next(seq__39769_39796__$1);
var G__39806 = null;
var G__39807 = (0);
var G__39808 = (0);
seq__39769_39784 = G__39805;
chunk__39770_39785 = G__39806;
count__39771_39786 = G__39807;
i__39772_39787 = G__39808;
continue;
}
} else {
}
}
break;
}

return el__$1;
} else {
return null;
}
}
});

c2.dom.attr.cljs$core$IFn$_invoke$arity$3 = (function (el,k,v){
var el__$1 = c2.dom.__GT_dom(el);
if((v == null)){
el__$1.removeAttribute(cljs.core.name(k));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$style,k)){
c2.dom.style.cljs$core$IFn$_invoke$arity$2(el__$1,v);
} else {
el__$1.setAttribute(cljs.core.name(k),v);
}
}

return el__$1;
});

c2.dom.attr.cljs$lang$maxFixedArity = 3;

/**
 * Get or set element text, returning element
 */
c2.dom.text = (function c2$dom$text(var_args){
var args39809 = [];
var len__7484__auto___39813 = arguments.length;
var i__7485__auto___39814 = (0);
while(true){
if((i__7485__auto___39814 < len__7484__auto___39813)){
args39809.push((arguments[i__7485__auto___39814]));

var G__39815 = (i__7485__auto___39814 + (1));
i__7485__auto___39814 = G__39815;
continue;
} else {
}
break;
}

var G__39811 = args39809.length;
switch (G__39811) {
case 1:
return c2.dom.text.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.text.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args39809.length)].join('')));

}
});

c2.dom.text.cljs$core$IFn$_invoke$arity$1 = (function (el){
var G__39812 = c2.dom.__GT_dom(el);
return goog.dom.getTextContent(G__39812);
});

c2.dom.text.cljs$core$IFn$_invoke$arity$2 = (function (el,v){
var el__$1 = c2.dom.__GT_dom(el);
goog.dom.setTextContent(el__$1,v);

return el__$1;
});

c2.dom.text.cljs$lang$maxFixedArity = 2;

/**
 * Get or set element value.
 */
c2.dom.val = (function c2$dom$val(var_args){
var args39817 = [];
var len__7484__auto___39821 = arguments.length;
var i__7485__auto___39822 = (0);
while(true){
if((i__7485__auto___39822 < len__7484__auto___39821)){
args39817.push((arguments[i__7485__auto___39822]));

var G__39823 = (i__7485__auto___39822 + (1));
i__7485__auto___39822 = G__39823;
continue;
} else {
}
break;
}

var G__39819 = args39817.length;
switch (G__39819) {
case 1:
return c2.dom.val.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.val.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args39817.length)].join('')));

}
});

c2.dom.val.cljs$core$IFn$_invoke$arity$1 = (function (el){
var G__39820 = c2.dom.__GT_dom(el);
return goog.dom.forms.getValue(G__39820);
});

c2.dom.val.cljs$core$IFn$_invoke$arity$2 = (function (el,v){
var el__$1 = c2.dom.__GT_dom(el);
goog.dom.forms.setValue(el__$1,v);

return el__$1;
});

c2.dom.val.cljs$lang$maxFixedArity = 2;

/**
 * Add or remove `class` to element based on boolean `classed?`, returning element.
 */
c2.dom.classed_BANG_ = (function c2$dom$classed_BANG_(el,class$,classed_QMARK_){
var G__39828_39831 = c2.dom.__GT_dom(el);
var G__39829_39832 = cljs.core.name(class$);
var G__39830_39833 = classed_QMARK_;
goog.dom.classes.enable(G__39828_39831,G__39829_39832,G__39830_39833);

return el;
});
c2.dom.add_class_BANG_ = (function c2$dom$add_class_BANG_(el,class$){
return c2.dom.classed_BANG_(el,class$,true);
});
c2.dom.remove_class_BANG_ = (function c2$dom$remove_class_BANG_(el,class$){
return c2.dom.classed_BANG_(el,class$,false);
});
c2.dom.request_animation_frame = (function (){var or__6409__auto__ = window.requestAnimationFrame;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
var or__6409__auto____$1 = window.webkitRequestAnimationFrame;
if(cljs.core.truth_(or__6409__auto____$1)){
return or__6409__auto____$1;
} else {
return ((function (or__6409__auto____$1,or__6409__auto__){
return (function (p1__39834_SHARP_){
var G__39835 = ((function (or__6409__auto____$1,or__6409__auto__){
return (function (){
return (p1__39834_SHARP_.cljs$core$IFn$_invoke$arity$0 ? p1__39834_SHARP_.cljs$core$IFn$_invoke$arity$0() : p1__39834_SHARP_.call(null));
});})(or__6409__auto____$1,or__6409__auto__))
;
var G__39836 = (10);
return setTimeout(G__39835,G__39836);
});
;})(or__6409__auto____$1,or__6409__auto__))
}
}
})();
