// Compiled by ClojureScript 1.9.229 {:static-fns true, :optimize-constants true}
goog.provide('chimera.string');
goog.require('cljs.core');
goog.require('chimera.core');
goog.require('clojure.string');
goog.require('cljs.pprint');
chimera.string.email_regex = /^[A-Z0-9._%+-]+@[A-Z0-9.-]+\.[A-Z]{2,6}$/i;
chimera.string.twitter_username_regex = /^[A-Za-z0-9_]*$/;
chimera.string.domain_name_regex = /([a-z0-9|-]+\.)*[a-z0-9|-]+\.[a-z]+/;
chimera.string.truncate_if_longer_than = (50);
chimera.string.ellipsis_start = (36);
chimera.string.ellipsis_stop_from_end = (12);
chimera.string.chars__GT_entities = new cljs.core.PersistentArrayMap(null, 5, ["<","&lt;",">","&gt;","&","&amp;","\"","&quot;","'","&#39;"], null);
chimera.string.vowel_QMARK_ = cljs.core.set("aeiou");
chimera.string.parenthesize_suffix = (function chimera$string$parenthesize_suffix(prefix,suffix){
return [cljs.core.str(prefix),cljs.core.str(" ("),cljs.core.str(suffix),cljs.core.str(")")].join('');
});
/**
 * Shorten a string to a certain length with middle ellipsis.
 */
chimera.string.truncate_with_ellipsis = (function chimera$string$truncate_with_ellipsis(s){
if((cljs.core.count(s) > chimera.string.truncate_if_longer_than)){
var end_start = (cljs.core.count(s) - chimera.string.ellipsis_stop_from_end);
return [cljs.core.str(cljs.core.subs.cljs$core$IFn$_invoke$arity$3(s,(0),chimera.string.ellipsis_start)),cljs.core.str("..."),cljs.core.str(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(s,end_start))].join('');
} else {
return s;
}
});
/**
 * Return the first character of a string capitalized.
 */
chimera.string.first_cap = (function chimera$string$first_cap(s){
return clojure.string.capitalize([cljs.core.str(cljs.core.first(s))].join(''));
});
/**
 * True if `s` is an email address.
 */
chimera.string.is_email_QMARK_ = (function chimera$string$is_email_QMARK_(s){
return cljs.core.first(s.match(chimera.string.email_regex));
});
/**
 * True if `s` is a valid twitter username
 */
chimera.string.is_twitter_username_QMARK_ = (function chimera$string$is_twitter_username_QMARK_(s){
return cljs.core.first(s.match(chimera.string.twitter_username_regex));
});
/**
 * Wrap the count of a collection in parens and postfix.
 */
chimera.string.postfix_paren_count = (function chimera$string$postfix_paren_count(prefix,collection){
return chimera.string.parenthesize_suffix(prefix,cljs.core.count(collection));
});
/**
 * True if `s` ends with the passed suffix.
 */
chimera.string.ends_with_QMARK_ = (function chimera$string$ends_with_QMARK_(s,suffix){
var offset = (cljs.core.count(s) - cljs.core.count(suffix));
return ((offset >= (0))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(suffix,cljs.core.subs.cljs$core$IFn$_invoke$arity$2(s,offset)));
});
/**
 * Serialize a Clojure map to JavaScript string map.
 */
chimera.string.map__GT_js_string_map = (function chimera$string$map__GT_js_string_map(m){
return clojure.string.join.cljs$core$IFn$_invoke$arity$1(cljs.core.flatten(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["{",cljs.core.interpose.cljs$core$IFn$_invoke$arity$2(",",(function (){var iter__7189__auto__ = (function chimera$string$map__GT_js_string_map_$_iter__14579(s__14580){
return (new cljs.core.LazySeq(null,(function (){
var s__14580__$1 = s__14580;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__14580__$1);
if(temp__4657__auto__){
var s__14580__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__14580__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__14580__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__14582 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__14581 = (0);
while(true){
if((i__14581 < size__7188__auto__)){
var vec__14591 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__14581);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14591,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14591,(1),null);
cljs.core.chunk_append(b__14582,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, ["\"",cljs.core.name(k),"\":\"",v,"\""], null));

var G__14597 = (i__14581 + (1));
i__14581 = G__14597;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__14582),chimera$string$map__GT_js_string_map_$_iter__14579(cljs.core.chunk_rest(s__14580__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__14582),null);
}
} else {
var vec__14594 = cljs.core.first(s__14580__$2);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14594,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14594,(1),null);
return cljs.core.cons(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, ["\"",cljs.core.name(k),"\":\"",v,"\""], null),chimera$string$map__GT_js_string_map_$_iter__14579(cljs.core.rest(s__14580__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__(m);
})()),"}"], null)));
});
/**
 * True if the first letter of `s` is a vowel.
 */
chimera.string.begins_with_vowel_QMARK_ = (function chimera$string$begins_with_vowel_QMARK_(s){
var G__14599 = cljs.core.first(clojure.string.lower_case(cljs.core.first(s)));
return (chimera.string.vowel_QMARK_.cljs$core$IFn$_invoke$arity$1 ? chimera.string.vowel_QMARK_.cljs$core$IFn$_invoke$arity$1(G__14599) : chimera.string.vowel_QMARK_.call(null,G__14599));
});
/**
 * If `s` is a string and equal to 'false' in lower case return false,
 * otherwise return `s`.
 */
chimera.string.false_str__GT_false = (function chimera$string$false_str__GT_false(s){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((function (){var and__6397__auto__ = typeof s === 'string';
if(and__6397__auto__){
return clojure.string.lower_case(s);
} else {
return and__6397__auto__;
}
})(),"false")){
return false;
} else {
return s;
}
});
/**
 * Render a JSON error as a string for the user.
 */
chimera.string.error_json__GT_str = (function chimera$string$error_json__GT_str(json){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2("<br/>",(function (){var iter__7189__auto__ = (function chimera$string$error_json__GT_str_$_iter__14622(s__14623){
return (new cljs.core.LazySeq(null,(function (){
var s__14623__$1 = s__14623;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__14623__$1);
if(temp__4657__auto__){
var s__14623__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__14623__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__14623__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__14625 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__14624 = (0);
while(true){
if((i__14624 < size__7188__auto__)){
var vec__14636 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__14624);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14636,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14636,(1),null);
var key = clojure.string.capitalize(cljs.core.name(k));
var value = (function (){var G__14639 = v;
if(cljs.core.vector_QMARK_(v)){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",G__14639);
} else {
return G__14639;
}
})();
cljs.core.chunk_append(b__14625,[cljs.core.str(key),cljs.core.str(": "),cljs.core.str(value)].join(''));

var G__14644 = (i__14624 + (1));
i__14624 = G__14644;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__14625),chimera$string$error_json__GT_str_$_iter__14622(cljs.core.chunk_rest(s__14623__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__14625),null);
}
} else {
var vec__14640 = cljs.core.first(s__14623__$2);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14640,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14640,(1),null);
var key = clojure.string.capitalize(cljs.core.name(k));
var value = (function (){var G__14643 = v;
if(cljs.core.vector_QMARK_(v)){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",G__14643);
} else {
return G__14643;
}
})();
return cljs.core.cons([cljs.core.str(key),cljs.core.str(": "),cljs.core.str(value)].join(''),chimera$string$error_json__GT_str_$_iter__14622(cljs.core.rest(s__14623__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__(json);
})());
});
/**
 * Build an unescaped string.
 */
chimera.string.unescape = (function chimera$string$unescape(s){
if(typeof s === 'string'){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (r,p__14649){
var vec__14650 = p__14649;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14650,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14650,(1),null);
return clojure.string.replace(r,cljs.core.re_pattern(v),[cljs.core.str(k)].join(''));
}),s,chimera.string.chars__GT_entities);
} else {
return s;
}
});
/**
 * Checks if a variable is null
 */
chimera.string.is_null_QMARK_ = (function chimera$string$is_null_QMARK_(s){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("null",s);
});
chimera.string.is_not_null_QMARK_ = cljs.core.complement(chimera.string.is_null_QMARK_);
chimera.string.safe_lower_case = (function chimera$string$safe_lower_case(str){
if(typeof str === 'string'){
return clojure.string.lower_case(str);
} else {
return null;
}
});
/**
 * True if substring is a substring of `s`
 */
chimera.string.substring_QMARK_ = (function chimera$string$substring_QMARK_(var_args){
var args__7491__auto__ = [];
var len__7484__auto___14660 = arguments.length;
var i__7485__auto___14661 = (0);
while(true){
if((i__7485__auto___14661 < len__7484__auto___14660)){
args__7491__auto__.push((arguments[i__7485__auto___14661]));

var G__14662 = (i__7485__auto___14661 + (1));
i__7485__auto___14661 = G__14662;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((2) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((2)),(0),null)):null);
return chimera.string.substring_QMARK_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7492__auto__);
});

chimera.string.substring_QMARK_.cljs$core$IFn$_invoke$arity$variadic = (function (substring,s,p__14656){
var map__14657 = p__14656;
var map__14657__$1 = ((((!((map__14657 == null)))?((((map__14657.cljs$lang$protocol_mask$partition0$ & (64))) || (map__14657.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__14657):map__14657);
var case_sensitive_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__14657__$1,cljs.core.cst$kw$case_DASH_sensitive_QMARK_,true);
if(cljs.core.truth_((function (){var or__6409__auto__ = cljs.core.empty_QMARK_(s);
if(or__6409__auto__){
return or__6409__auto__;
} else {
return chimera.string.is_null_QMARK_(s);
}
})())){
return false;
} else {
var G__14659 = cljs.core.re_find(cljs.core.re_pattern([cljs.core.str((cljs.core.truth_(case_sensitive_QMARK_)?null:"(?i)")),cljs.core.str(substring)].join('')),s);
return (chimera.core.not_nil_QMARK_.cljs$core$IFn$_invoke$arity$1 ? chimera.core.not_nil_QMARK_.cljs$core$IFn$_invoke$arity$1(G__14659) : chimera.core.not_nil_QMARK_.call(null,G__14659));
}
});

chimera.string.substring_QMARK_.cljs$lang$maxFixedArity = (2);

chimera.string.substring_QMARK_.cljs$lang$applyTo = (function (seq14653){
var G__14654 = cljs.core.first(seq14653);
var seq14653__$1 = cljs.core.next(seq14653);
var G__14655 = cljs.core.first(seq14653__$1);
var seq14653__$2 = cljs.core.next(seq14653__$1);
return chimera.string.substring_QMARK_.cljs$core$IFn$_invoke$arity$variadic(G__14654,G__14655,seq14653__$2);
});

/**
 * Insert a comma into numbers in thousands and higher
 */
chimera.string.humanize_number = (function chimera$string$humanize_number(n){
return cljs.pprint.cl_format.cljs$core$IFn$_invoke$arity$variadic(null,"~:d",cljs.core.array_seq([n], 0));
});
/**
 * Escape for types. Replaces characters in the string with this base on
 *   chars->entities map.
 */
chimera.string.escape_for_type = (function chimera$string$escape_for_type(x){
if((x == null)){
return "null";
} else {
if(typeof x === 'string'){
return clojure.string.escape(x,chimera.string.chars__GT_entities);
} else {
return x;

}
}
});
