// Compiled by ClojureScript 1.9.229 {:static-fns true, :optimize-constants true}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var args32954 = [];
var len__7484__auto___32960 = arguments.length;
var i__7485__auto___32961 = (0);
while(true){
if((i__7485__auto___32961 < len__7484__auto___32960)){
args32954.push((arguments[i__7485__auto___32961]));

var G__32962 = (i__7485__auto___32961 + (1));
i__7485__auto___32961 = G__32962;
continue;
} else {
}
break;
}

var G__32956 = args32954.length;
switch (G__32956) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args32954.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async32957 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async32957 = (function (f,blockable,meta32958){
this.f = f;
this.blockable = blockable;
this.meta32958 = meta32958;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async32957.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_32959,meta32958__$1){
var self__ = this;
var _32959__$1 = this;
return (new cljs.core.async.t_cljs$core$async32957(self__.f,self__.blockable,meta32958__$1));
});

cljs.core.async.t_cljs$core$async32957.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_32959){
var self__ = this;
var _32959__$1 = this;
return self__.meta32958;
});

cljs.core.async.t_cljs$core$async32957.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async32957.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async32957.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async32957.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async32957.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$blockable,cljs.core.cst$sym$meta32958], null);
});

cljs.core.async.t_cljs$core$async32957.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async32957.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async32957";

cljs.core.async.t_cljs$core$async32957.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"cljs.core.async/t_cljs$core$async32957");
});

cljs.core.async.__GT_t_cljs$core$async32957 = (function cljs$core$async$__GT_t_cljs$core$async32957(f__$1,blockable__$1,meta32958){
return (new cljs.core.async.t_cljs$core$async32957(f__$1,blockable__$1,meta32958));
});

}

return (new cljs.core.async.t_cljs$core$async32957(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || (buff.cljs$core$async$impl$protocols$UnblockingBuffer$)){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args32966 = [];
var len__7484__auto___32969 = arguments.length;
var i__7485__auto___32970 = (0);
while(true){
if((i__7485__auto___32970 < len__7484__auto___32969)){
args32966.push((arguments[i__7485__auto___32970]));

var G__32971 = (i__7485__auto___32970 + (1));
i__7485__auto___32970 = G__32971;
continue;
} else {
}
break;
}

var G__32968 = args32966.length;
switch (G__32968) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args32966.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str("buf-or-n")].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var args32973 = [];
var len__7484__auto___32976 = arguments.length;
var i__7485__auto___32977 = (0);
while(true){
if((i__7485__auto___32977 < len__7484__auto___32976)){
args32973.push((arguments[i__7485__auto___32977]));

var G__32978 = (i__7485__auto___32977 + (1));
i__7485__auto___32977 = G__32978;
continue;
} else {
}
break;
}

var G__32975 = args32973.length;
switch (G__32975) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args32973.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args32980 = [];
var len__7484__auto___32983 = arguments.length;
var i__7485__auto___32984 = (0);
while(true){
if((i__7485__auto___32984 < len__7484__auto___32983)){
args32980.push((arguments[i__7485__auto___32984]));

var G__32985 = (i__7485__auto___32984 + (1));
i__7485__auto___32984 = G__32985;
continue;
} else {
}
break;
}

var G__32982 = args32980.length;
switch (G__32982) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args32980.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_32987 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_32987) : fn1.call(null,val_32987));
} else {
cljs.core.async.impl.dispatch.run(((function (val_32987,ret){
return (function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_32987) : fn1.call(null,val_32987));
});})(val_32987,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args32988 = [];
var len__7484__auto___32991 = arguments.length;
var i__7485__auto___32992 = (0);
while(true){
if((i__7485__auto___32992 < len__7484__auto___32991)){
args32988.push((arguments[i__7485__auto___32992]));

var G__32993 = (i__7485__auto___32992 + (1));
i__7485__auto___32992 = G__32993;
continue;
} else {
}
break;
}

var G__32990 = args32988.length;
switch (G__32990) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args32988.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4655__auto__)){
var ret = temp__4655__auto__;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__4655__auto__)){
var retb = temp__4655__auto__;
var ret = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(retb) : cljs.core.deref.call(null,retb));
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run(((function (ret,retb,temp__4655__auto__){
return (function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
});})(ret,retb,temp__4655__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__7324__auto___32995 = n;
var x_32996 = (0);
while(true){
if((x_32996 < n__7324__auto___32995)){
(a[x_32996] = (0));

var G__32997 = (x_32996 + (1));
x_32996 = G__32997;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(i,n)){
return a;
} else {
var j = cljs.core.rand_int(i);
(a[i] = (a[j]));

(a[j] = i);

var G__32998 = (i + (1));
i = G__32998;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true) : cljs.core.atom.call(null,true));
if(typeof cljs.core.async.t_cljs$core$async33002 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async33002 = (function (alt_flag,flag,meta33003){
this.alt_flag = alt_flag;
this.flag = flag;
this.meta33003 = meta33003;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async33002.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_33004,meta33003__$1){
var self__ = this;
var _33004__$1 = this;
return (new cljs.core.async.t_cljs$core$async33002(self__.alt_flag,self__.flag,meta33003__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async33002.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_33004){
var self__ = this;
var _33004__$1 = this;
return self__.meta33003;
});})(flag))
;

cljs.core.async.t_cljs$core$async33002.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async33002.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(self__.flag) : cljs.core.deref.call(null,self__.flag));
});})(flag))
;

cljs.core.async.t_cljs$core$async33002.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async33002.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(self__.flag,null) : cljs.core.reset_BANG_.call(null,self__.flag,null));

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async33002.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$alt_DASH_flag,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(cljs.core.PersistentVector.EMPTY))], null)),cljs.core.cst$sym$flag,cljs.core.cst$sym$meta33003], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async33002.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async33002.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async33002";

cljs.core.async.t_cljs$core$async33002.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"cljs.core.async/t_cljs$core$async33002");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async33002 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async33002(alt_flag__$1,flag__$1,meta33003){
return (new cljs.core.async.t_cljs$core$async33002(alt_flag__$1,flag__$1,meta33003));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async33002(cljs$core$async$alt_flag,flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async33008 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async33008 = (function (alt_handler,flag,cb,meta33009){
this.alt_handler = alt_handler;
this.flag = flag;
this.cb = cb;
this.meta33009 = meta33009;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async33008.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_33010,meta33009__$1){
var self__ = this;
var _33010__$1 = this;
return (new cljs.core.async.t_cljs$core$async33008(self__.alt_handler,self__.flag,self__.cb,meta33009__$1));
});

cljs.core.async.t_cljs$core$async33008.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_33010){
var self__ = this;
var _33010__$1 = this;
return self__.meta33009;
});

cljs.core.async.t_cljs$core$async33008.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async33008.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
});

cljs.core.async.t_cljs$core$async33008.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async33008.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async33008.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$alt_DASH_handler,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$flag,cljs.core.cst$sym$cb], null)))], null)),cljs.core.cst$sym$flag,cljs.core.cst$sym$cb,cljs.core.cst$sym$meta33009], null);
});

cljs.core.async.t_cljs$core$async33008.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async33008.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async33008";

cljs.core.async.t_cljs$core$async33008.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"cljs.core.async/t_cljs$core$async33008");
});

cljs.core.async.__GT_t_cljs$core$async33008 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async33008(alt_handler__$1,flag__$1,cb__$1,meta33009){
return (new cljs.core.async.t_cljs$core$async33008(alt_handler__$1,flag__$1,cb__$1,meta33009));
});

}

return (new cljs.core.async.t_cljs$core$async33008(cljs$core$async$alt_handler,flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = cljs.core.cst$kw$priority.cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__33011_SHARP_){
var G__33015 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__33011_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__33015) : fret.call(null,G__33015));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__33012_SHARP_){
var G__33016 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__33012_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__33016) : fret.call(null,G__33016));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(vbox) : cljs.core.deref.call(null,vbox)),(function (){var or__6409__auto__ = wport;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return port;
}
})()], null));
} else {
var G__33017 = (i + (1));
i = G__33017;
continue;
}
} else {
return null;
}
break;
}
})();
var or__6409__auto__ = ret;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,cljs.core.cst$kw$default)){
var temp__4657__auto__ = (function (){var and__6397__auto__ = cljs.core.async.impl.protocols.active_QMARK_(flag);
if(cljs.core.truth_(and__6397__auto__)){
return cljs.core.async.impl.protocols.commit(flag);
} else {
return and__6397__auto__;
}
})();
if(cljs.core.truth_(temp__4657__auto__)){
var got = temp__4657__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$default.cljs$core$IFn$_invoke$arity$1(opts),cljs.core.cst$kw$default], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__7491__auto__ = [];
var len__7484__auto___33023 = arguments.length;
var i__7485__auto___33024 = (0);
while(true){
if((i__7485__auto___33024 < len__7484__auto___33023)){
args__7491__auto__.push((arguments[i__7485__auto___33024]));

var G__33025 = (i__7485__auto___33024 + (1));
i__7485__auto___33024 = G__33025;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__33020){
var map__33021 = p__33020;
var map__33021__$1 = ((((!((map__33021 == null)))?((((map__33021.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33021.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__33021):map__33021);
var opts = map__33021__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq33018){
var G__33019 = cljs.core.first(seq33018);
var seq33018__$1 = cljs.core.next(seq33018);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__33019,seq33018__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args33026 = [];
var len__7484__auto___33076 = arguments.length;
var i__7485__auto___33077 = (0);
while(true){
if((i__7485__auto___33077 < len__7484__auto___33076)){
args33026.push((arguments[i__7485__auto___33077]));

var G__33078 = (i__7485__auto___33077 + (1));
i__7485__auto___33077 = G__33078;
continue;
} else {
}
break;
}

var G__33028 = args33026.length;
switch (G__33028) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33026.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__12309__auto___33080 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12309__auto___33080){
return (function (){
var f__12310__auto__ = (function (){var switch__12197__auto__ = ((function (c__12309__auto___33080){
return (function (state_33052){
var state_val_33053 = (state_33052[(1)]);
if((state_val_33053 === (7))){
var inst_33048 = (state_33052[(2)]);
var state_33052__$1 = state_33052;
var statearr_33054_33081 = state_33052__$1;
(statearr_33054_33081[(2)] = inst_33048);

(statearr_33054_33081[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33053 === (1))){
var state_33052__$1 = state_33052;
var statearr_33055_33082 = state_33052__$1;
(statearr_33055_33082[(2)] = null);

(statearr_33055_33082[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33053 === (4))){
var inst_33031 = (state_33052[(7)]);
var inst_33031__$1 = (state_33052[(2)]);
var inst_33032 = (inst_33031__$1 == null);
var state_33052__$1 = (function (){var statearr_33056 = state_33052;
(statearr_33056[(7)] = inst_33031__$1);

return statearr_33056;
})();
if(cljs.core.truth_(inst_33032)){
var statearr_33057_33083 = state_33052__$1;
(statearr_33057_33083[(1)] = (5));

} else {
var statearr_33058_33084 = state_33052__$1;
(statearr_33058_33084[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33053 === (13))){
var state_33052__$1 = state_33052;
var statearr_33059_33085 = state_33052__$1;
(statearr_33059_33085[(2)] = null);

(statearr_33059_33085[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33053 === (6))){
var inst_33031 = (state_33052[(7)]);
var state_33052__$1 = state_33052;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33052__$1,(11),to,inst_33031);
} else {
if((state_val_33053 === (3))){
var inst_33050 = (state_33052[(2)]);
var state_33052__$1 = state_33052;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33052__$1,inst_33050);
} else {
if((state_val_33053 === (12))){
var state_33052__$1 = state_33052;
var statearr_33060_33086 = state_33052__$1;
(statearr_33060_33086[(2)] = null);

(statearr_33060_33086[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33053 === (2))){
var state_33052__$1 = state_33052;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33052__$1,(4),from);
} else {
if((state_val_33053 === (11))){
var inst_33041 = (state_33052[(2)]);
var state_33052__$1 = state_33052;
if(cljs.core.truth_(inst_33041)){
var statearr_33061_33087 = state_33052__$1;
(statearr_33061_33087[(1)] = (12));

} else {
var statearr_33062_33088 = state_33052__$1;
(statearr_33062_33088[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33053 === (9))){
var state_33052__$1 = state_33052;
var statearr_33063_33089 = state_33052__$1;
(statearr_33063_33089[(2)] = null);

(statearr_33063_33089[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33053 === (5))){
var state_33052__$1 = state_33052;
if(cljs.core.truth_(close_QMARK_)){
var statearr_33064_33090 = state_33052__$1;
(statearr_33064_33090[(1)] = (8));

} else {
var statearr_33065_33091 = state_33052__$1;
(statearr_33065_33091[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33053 === (14))){
var inst_33046 = (state_33052[(2)]);
var state_33052__$1 = state_33052;
var statearr_33066_33092 = state_33052__$1;
(statearr_33066_33092[(2)] = inst_33046);

(statearr_33066_33092[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33053 === (10))){
var inst_33038 = (state_33052[(2)]);
var state_33052__$1 = state_33052;
var statearr_33067_33093 = state_33052__$1;
(statearr_33067_33093[(2)] = inst_33038);

(statearr_33067_33093[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33053 === (8))){
var inst_33035 = cljs.core.async.close_BANG_(to);
var state_33052__$1 = state_33052;
var statearr_33068_33094 = state_33052__$1;
(statearr_33068_33094[(2)] = inst_33035);

(statearr_33068_33094[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12309__auto___33080))
;
return ((function (switch__12197__auto__,c__12309__auto___33080){
return (function() {
var cljs$core$async$state_machine__12198__auto__ = null;
var cljs$core$async$state_machine__12198__auto____0 = (function (){
var statearr_33072 = [null,null,null,null,null,null,null,null];
(statearr_33072[(0)] = cljs$core$async$state_machine__12198__auto__);

(statearr_33072[(1)] = (1));

return statearr_33072;
});
var cljs$core$async$state_machine__12198__auto____1 = (function (state_33052){
while(true){
var ret_value__12199__auto__ = (function (){try{while(true){
var result__12200__auto__ = switch__12197__auto__(state_33052);
if(cljs.core.keyword_identical_QMARK_(result__12200__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12200__auto__;
}
break;
}
}catch (e33073){if((e33073 instanceof Object)){
var ex__12201__auto__ = e33073;
var statearr_33074_33095 = state_33052;
(statearr_33074_33095[(5)] = ex__12201__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_33052);

return cljs.core.cst$kw$recur;
} else {
throw e33073;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12199__auto__,cljs.core.cst$kw$recur)){
var G__33096 = state_33052;
state_33052 = G__33096;
continue;
} else {
return ret_value__12199__auto__;
}
break;
}
});
cljs$core$async$state_machine__12198__auto__ = function(state_33052){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12198__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12198__auto____1.call(this,state_33052);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12198__auto____0;
cljs$core$async$state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12198__auto____1;
return cljs$core$async$state_machine__12198__auto__;
})()
;})(switch__12197__auto__,c__12309__auto___33080))
})();
var state__12311__auto__ = (function (){var statearr_33075 = (f__12310__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12310__auto__.cljs$core$IFn$_invoke$arity$0() : f__12310__auto__.call(null));
(statearr_33075[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12309__auto___33080);

return statearr_33075;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12311__auto__);
});})(c__12309__auto___33080))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process = ((function (jobs,results){
return (function (p__33284){
var vec__33285 = p__33284;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33285,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33285,(1),null);
var job = vec__33285;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__12309__auto___33471 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12309__auto___33471,res,vec__33285,v,p,job,jobs,results){
return (function (){
var f__12310__auto__ = (function (){var switch__12197__auto__ = ((function (c__12309__auto___33471,res,vec__33285,v,p,job,jobs,results){
return (function (state_33292){
var state_val_33293 = (state_33292[(1)]);
if((state_val_33293 === (1))){
var state_33292__$1 = state_33292;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33292__$1,(2),res,v);
} else {
if((state_val_33293 === (2))){
var inst_33289 = (state_33292[(2)]);
var inst_33290 = cljs.core.async.close_BANG_(res);
var state_33292__$1 = (function (){var statearr_33294 = state_33292;
(statearr_33294[(7)] = inst_33289);

return statearr_33294;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_33292__$1,inst_33290);
} else {
return null;
}
}
});})(c__12309__auto___33471,res,vec__33285,v,p,job,jobs,results))
;
return ((function (switch__12197__auto__,c__12309__auto___33471,res,vec__33285,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__12198__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__12198__auto____0 = (function (){
var statearr_33298 = [null,null,null,null,null,null,null,null];
(statearr_33298[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__12198__auto__);

(statearr_33298[(1)] = (1));

return statearr_33298;
});
var cljs$core$async$pipeline_STAR__$_state_machine__12198__auto____1 = (function (state_33292){
while(true){
var ret_value__12199__auto__ = (function (){try{while(true){
var result__12200__auto__ = switch__12197__auto__(state_33292);
if(cljs.core.keyword_identical_QMARK_(result__12200__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12200__auto__;
}
break;
}
}catch (e33299){if((e33299 instanceof Object)){
var ex__12201__auto__ = e33299;
var statearr_33300_33472 = state_33292;
(statearr_33300_33472[(5)] = ex__12201__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_33292);

return cljs.core.cst$kw$recur;
} else {
throw e33299;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12199__auto__,cljs.core.cst$kw$recur)){
var G__33473 = state_33292;
state_33292 = G__33473;
continue;
} else {
return ret_value__12199__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__12198__auto__ = function(state_33292){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__12198__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__12198__auto____1.call(this,state_33292);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__12198__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__12198__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__12198__auto__;
})()
;})(switch__12197__auto__,c__12309__auto___33471,res,vec__33285,v,p,job,jobs,results))
})();
var state__12311__auto__ = (function (){var statearr_33301 = (f__12310__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12310__auto__.cljs$core$IFn$_invoke$arity$0() : f__12310__auto__.call(null));
(statearr_33301[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12309__auto___33471);

return statearr_33301;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12311__auto__);
});})(c__12309__auto___33471,res,vec__33285,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__33302){
var vec__33303 = p__33302;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33303,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33303,(1),null);
var job = vec__33303;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});})(jobs,results,process))
;
var n__7324__auto___33474 = n;
var __33475 = (0);
while(true){
if((__33475 < n__7324__auto___33474)){
var G__33306_33476 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__33306_33476) {
case "compute":
var c__12309__auto___33478 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__33475,c__12309__auto___33478,G__33306_33476,n__7324__auto___33474,jobs,results,process,async){
return (function (){
var f__12310__auto__ = (function (){var switch__12197__auto__ = ((function (__33475,c__12309__auto___33478,G__33306_33476,n__7324__auto___33474,jobs,results,process,async){
return (function (state_33319){
var state_val_33320 = (state_33319[(1)]);
if((state_val_33320 === (1))){
var state_33319__$1 = state_33319;
var statearr_33321_33479 = state_33319__$1;
(statearr_33321_33479[(2)] = null);

(statearr_33321_33479[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33320 === (2))){
var state_33319__$1 = state_33319;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33319__$1,(4),jobs);
} else {
if((state_val_33320 === (3))){
var inst_33317 = (state_33319[(2)]);
var state_33319__$1 = state_33319;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33319__$1,inst_33317);
} else {
if((state_val_33320 === (4))){
var inst_33309 = (state_33319[(2)]);
var inst_33310 = process(inst_33309);
var state_33319__$1 = state_33319;
if(cljs.core.truth_(inst_33310)){
var statearr_33322_33480 = state_33319__$1;
(statearr_33322_33480[(1)] = (5));

} else {
var statearr_33323_33481 = state_33319__$1;
(statearr_33323_33481[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33320 === (5))){
var state_33319__$1 = state_33319;
var statearr_33324_33482 = state_33319__$1;
(statearr_33324_33482[(2)] = null);

(statearr_33324_33482[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33320 === (6))){
var state_33319__$1 = state_33319;
var statearr_33325_33483 = state_33319__$1;
(statearr_33325_33483[(2)] = null);

(statearr_33325_33483[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33320 === (7))){
var inst_33315 = (state_33319[(2)]);
var state_33319__$1 = state_33319;
var statearr_33326_33484 = state_33319__$1;
(statearr_33326_33484[(2)] = inst_33315);

(statearr_33326_33484[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(__33475,c__12309__auto___33478,G__33306_33476,n__7324__auto___33474,jobs,results,process,async))
;
return ((function (__33475,switch__12197__auto__,c__12309__auto___33478,G__33306_33476,n__7324__auto___33474,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__12198__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__12198__auto____0 = (function (){
var statearr_33330 = [null,null,null,null,null,null,null];
(statearr_33330[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__12198__auto__);

(statearr_33330[(1)] = (1));

return statearr_33330;
});
var cljs$core$async$pipeline_STAR__$_state_machine__12198__auto____1 = (function (state_33319){
while(true){
var ret_value__12199__auto__ = (function (){try{while(true){
var result__12200__auto__ = switch__12197__auto__(state_33319);
if(cljs.core.keyword_identical_QMARK_(result__12200__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12200__auto__;
}
break;
}
}catch (e33331){if((e33331 instanceof Object)){
var ex__12201__auto__ = e33331;
var statearr_33332_33485 = state_33319;
(statearr_33332_33485[(5)] = ex__12201__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_33319);

return cljs.core.cst$kw$recur;
} else {
throw e33331;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12199__auto__,cljs.core.cst$kw$recur)){
var G__33486 = state_33319;
state_33319 = G__33486;
continue;
} else {
return ret_value__12199__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__12198__auto__ = function(state_33319){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__12198__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__12198__auto____1.call(this,state_33319);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__12198__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__12198__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__12198__auto__;
})()
;})(__33475,switch__12197__auto__,c__12309__auto___33478,G__33306_33476,n__7324__auto___33474,jobs,results,process,async))
})();
var state__12311__auto__ = (function (){var statearr_33333 = (f__12310__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12310__auto__.cljs$core$IFn$_invoke$arity$0() : f__12310__auto__.call(null));
(statearr_33333[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12309__auto___33478);

return statearr_33333;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12311__auto__);
});})(__33475,c__12309__auto___33478,G__33306_33476,n__7324__auto___33474,jobs,results,process,async))
);


break;
case "async":
var c__12309__auto___33487 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__33475,c__12309__auto___33487,G__33306_33476,n__7324__auto___33474,jobs,results,process,async){
return (function (){
var f__12310__auto__ = (function (){var switch__12197__auto__ = ((function (__33475,c__12309__auto___33487,G__33306_33476,n__7324__auto___33474,jobs,results,process,async){
return (function (state_33346){
var state_val_33347 = (state_33346[(1)]);
if((state_val_33347 === (1))){
var state_33346__$1 = state_33346;
var statearr_33348_33488 = state_33346__$1;
(statearr_33348_33488[(2)] = null);

(statearr_33348_33488[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33347 === (2))){
var state_33346__$1 = state_33346;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33346__$1,(4),jobs);
} else {
if((state_val_33347 === (3))){
var inst_33344 = (state_33346[(2)]);
var state_33346__$1 = state_33346;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33346__$1,inst_33344);
} else {
if((state_val_33347 === (4))){
var inst_33336 = (state_33346[(2)]);
var inst_33337 = async(inst_33336);
var state_33346__$1 = state_33346;
if(cljs.core.truth_(inst_33337)){
var statearr_33349_33489 = state_33346__$1;
(statearr_33349_33489[(1)] = (5));

} else {
var statearr_33350_33490 = state_33346__$1;
(statearr_33350_33490[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33347 === (5))){
var state_33346__$1 = state_33346;
var statearr_33351_33491 = state_33346__$1;
(statearr_33351_33491[(2)] = null);

(statearr_33351_33491[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33347 === (6))){
var state_33346__$1 = state_33346;
var statearr_33352_33492 = state_33346__$1;
(statearr_33352_33492[(2)] = null);

(statearr_33352_33492[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33347 === (7))){
var inst_33342 = (state_33346[(2)]);
var state_33346__$1 = state_33346;
var statearr_33353_33493 = state_33346__$1;
(statearr_33353_33493[(2)] = inst_33342);

(statearr_33353_33493[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(__33475,c__12309__auto___33487,G__33306_33476,n__7324__auto___33474,jobs,results,process,async))
;
return ((function (__33475,switch__12197__auto__,c__12309__auto___33487,G__33306_33476,n__7324__auto___33474,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__12198__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__12198__auto____0 = (function (){
var statearr_33357 = [null,null,null,null,null,null,null];
(statearr_33357[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__12198__auto__);

(statearr_33357[(1)] = (1));

return statearr_33357;
});
var cljs$core$async$pipeline_STAR__$_state_machine__12198__auto____1 = (function (state_33346){
while(true){
var ret_value__12199__auto__ = (function (){try{while(true){
var result__12200__auto__ = switch__12197__auto__(state_33346);
if(cljs.core.keyword_identical_QMARK_(result__12200__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12200__auto__;
}
break;
}
}catch (e33358){if((e33358 instanceof Object)){
var ex__12201__auto__ = e33358;
var statearr_33359_33494 = state_33346;
(statearr_33359_33494[(5)] = ex__12201__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_33346);

return cljs.core.cst$kw$recur;
} else {
throw e33358;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12199__auto__,cljs.core.cst$kw$recur)){
var G__33495 = state_33346;
state_33346 = G__33495;
continue;
} else {
return ret_value__12199__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__12198__auto__ = function(state_33346){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__12198__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__12198__auto____1.call(this,state_33346);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__12198__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__12198__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__12198__auto__;
})()
;})(__33475,switch__12197__auto__,c__12309__auto___33487,G__33306_33476,n__7324__auto___33474,jobs,results,process,async))
})();
var state__12311__auto__ = (function (){var statearr_33360 = (f__12310__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12310__auto__.cljs$core$IFn$_invoke$arity$0() : f__12310__auto__.call(null));
(statearr_33360[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12309__auto___33487);

return statearr_33360;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12311__auto__);
});})(__33475,c__12309__auto___33487,G__33306_33476,n__7324__auto___33474,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__33496 = (__33475 + (1));
__33475 = G__33496;
continue;
} else {
}
break;
}

var c__12309__auto___33497 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12309__auto___33497,jobs,results,process,async){
return (function (){
var f__12310__auto__ = (function (){var switch__12197__auto__ = ((function (c__12309__auto___33497,jobs,results,process,async){
return (function (state_33382){
var state_val_33383 = (state_33382[(1)]);
if((state_val_33383 === (1))){
var state_33382__$1 = state_33382;
var statearr_33384_33498 = state_33382__$1;
(statearr_33384_33498[(2)] = null);

(statearr_33384_33498[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33383 === (2))){
var state_33382__$1 = state_33382;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33382__$1,(4),from);
} else {
if((state_val_33383 === (3))){
var inst_33380 = (state_33382[(2)]);
var state_33382__$1 = state_33382;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33382__$1,inst_33380);
} else {
if((state_val_33383 === (4))){
var inst_33363 = (state_33382[(7)]);
var inst_33363__$1 = (state_33382[(2)]);
var inst_33364 = (inst_33363__$1 == null);
var state_33382__$1 = (function (){var statearr_33385 = state_33382;
(statearr_33385[(7)] = inst_33363__$1);

return statearr_33385;
})();
if(cljs.core.truth_(inst_33364)){
var statearr_33386_33499 = state_33382__$1;
(statearr_33386_33499[(1)] = (5));

} else {
var statearr_33387_33500 = state_33382__$1;
(statearr_33387_33500[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33383 === (5))){
var inst_33366 = cljs.core.async.close_BANG_(jobs);
var state_33382__$1 = state_33382;
var statearr_33388_33501 = state_33382__$1;
(statearr_33388_33501[(2)] = inst_33366);

(statearr_33388_33501[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33383 === (6))){
var inst_33368 = (state_33382[(8)]);
var inst_33363 = (state_33382[(7)]);
var inst_33368__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_33369 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33370 = [inst_33363,inst_33368__$1];
var inst_33371 = (new cljs.core.PersistentVector(null,2,(5),inst_33369,inst_33370,null));
var state_33382__$1 = (function (){var statearr_33389 = state_33382;
(statearr_33389[(8)] = inst_33368__$1);

return statearr_33389;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33382__$1,(8),jobs,inst_33371);
} else {
if((state_val_33383 === (7))){
var inst_33378 = (state_33382[(2)]);
var state_33382__$1 = state_33382;
var statearr_33390_33502 = state_33382__$1;
(statearr_33390_33502[(2)] = inst_33378);

(statearr_33390_33502[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33383 === (8))){
var inst_33368 = (state_33382[(8)]);
var inst_33373 = (state_33382[(2)]);
var state_33382__$1 = (function (){var statearr_33391 = state_33382;
(statearr_33391[(9)] = inst_33373);

return statearr_33391;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33382__$1,(9),results,inst_33368);
} else {
if((state_val_33383 === (9))){
var inst_33375 = (state_33382[(2)]);
var state_33382__$1 = (function (){var statearr_33392 = state_33382;
(statearr_33392[(10)] = inst_33375);

return statearr_33392;
})();
var statearr_33393_33503 = state_33382__$1;
(statearr_33393_33503[(2)] = null);

(statearr_33393_33503[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__12309__auto___33497,jobs,results,process,async))
;
return ((function (switch__12197__auto__,c__12309__auto___33497,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__12198__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__12198__auto____0 = (function (){
var statearr_33397 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_33397[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__12198__auto__);

(statearr_33397[(1)] = (1));

return statearr_33397;
});
var cljs$core$async$pipeline_STAR__$_state_machine__12198__auto____1 = (function (state_33382){
while(true){
var ret_value__12199__auto__ = (function (){try{while(true){
var result__12200__auto__ = switch__12197__auto__(state_33382);
if(cljs.core.keyword_identical_QMARK_(result__12200__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12200__auto__;
}
break;
}
}catch (e33398){if((e33398 instanceof Object)){
var ex__12201__auto__ = e33398;
var statearr_33399_33504 = state_33382;
(statearr_33399_33504[(5)] = ex__12201__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_33382);

return cljs.core.cst$kw$recur;
} else {
throw e33398;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12199__auto__,cljs.core.cst$kw$recur)){
var G__33505 = state_33382;
state_33382 = G__33505;
continue;
} else {
return ret_value__12199__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__12198__auto__ = function(state_33382){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__12198__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__12198__auto____1.call(this,state_33382);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__12198__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__12198__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__12198__auto__;
})()
;})(switch__12197__auto__,c__12309__auto___33497,jobs,results,process,async))
})();
var state__12311__auto__ = (function (){var statearr_33400 = (f__12310__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12310__auto__.cljs$core$IFn$_invoke$arity$0() : f__12310__auto__.call(null));
(statearr_33400[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12309__auto___33497);

return statearr_33400;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12311__auto__);
});})(c__12309__auto___33497,jobs,results,process,async))
);


var c__12309__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12309__auto__,jobs,results,process,async){
return (function (){
var f__12310__auto__ = (function (){var switch__12197__auto__ = ((function (c__12309__auto__,jobs,results,process,async){
return (function (state_33438){
var state_val_33439 = (state_33438[(1)]);
if((state_val_33439 === (7))){
var inst_33434 = (state_33438[(2)]);
var state_33438__$1 = state_33438;
var statearr_33440_33506 = state_33438__$1;
(statearr_33440_33506[(2)] = inst_33434);

(statearr_33440_33506[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33439 === (20))){
var state_33438__$1 = state_33438;
var statearr_33441_33507 = state_33438__$1;
(statearr_33441_33507[(2)] = null);

(statearr_33441_33507[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33439 === (1))){
var state_33438__$1 = state_33438;
var statearr_33442_33508 = state_33438__$1;
(statearr_33442_33508[(2)] = null);

(statearr_33442_33508[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33439 === (4))){
var inst_33403 = (state_33438[(7)]);
var inst_33403__$1 = (state_33438[(2)]);
var inst_33404 = (inst_33403__$1 == null);
var state_33438__$1 = (function (){var statearr_33443 = state_33438;
(statearr_33443[(7)] = inst_33403__$1);

return statearr_33443;
})();
if(cljs.core.truth_(inst_33404)){
var statearr_33444_33509 = state_33438__$1;
(statearr_33444_33509[(1)] = (5));

} else {
var statearr_33445_33510 = state_33438__$1;
(statearr_33445_33510[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33439 === (15))){
var inst_33416 = (state_33438[(8)]);
var state_33438__$1 = state_33438;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33438__$1,(18),to,inst_33416);
} else {
if((state_val_33439 === (21))){
var inst_33429 = (state_33438[(2)]);
var state_33438__$1 = state_33438;
var statearr_33446_33511 = state_33438__$1;
(statearr_33446_33511[(2)] = inst_33429);

(statearr_33446_33511[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33439 === (13))){
var inst_33431 = (state_33438[(2)]);
var state_33438__$1 = (function (){var statearr_33447 = state_33438;
(statearr_33447[(9)] = inst_33431);

return statearr_33447;
})();
var statearr_33448_33512 = state_33438__$1;
(statearr_33448_33512[(2)] = null);

(statearr_33448_33512[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33439 === (6))){
var inst_33403 = (state_33438[(7)]);
var state_33438__$1 = state_33438;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33438__$1,(11),inst_33403);
} else {
if((state_val_33439 === (17))){
var inst_33424 = (state_33438[(2)]);
var state_33438__$1 = state_33438;
if(cljs.core.truth_(inst_33424)){
var statearr_33449_33513 = state_33438__$1;
(statearr_33449_33513[(1)] = (19));

} else {
var statearr_33450_33514 = state_33438__$1;
(statearr_33450_33514[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33439 === (3))){
var inst_33436 = (state_33438[(2)]);
var state_33438__$1 = state_33438;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33438__$1,inst_33436);
} else {
if((state_val_33439 === (12))){
var inst_33413 = (state_33438[(10)]);
var state_33438__$1 = state_33438;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33438__$1,(14),inst_33413);
} else {
if((state_val_33439 === (2))){
var state_33438__$1 = state_33438;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33438__$1,(4),results);
} else {
if((state_val_33439 === (19))){
var state_33438__$1 = state_33438;
var statearr_33451_33515 = state_33438__$1;
(statearr_33451_33515[(2)] = null);

(statearr_33451_33515[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33439 === (11))){
var inst_33413 = (state_33438[(2)]);
var state_33438__$1 = (function (){var statearr_33452 = state_33438;
(statearr_33452[(10)] = inst_33413);

return statearr_33452;
})();
var statearr_33453_33516 = state_33438__$1;
(statearr_33453_33516[(2)] = null);

(statearr_33453_33516[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33439 === (9))){
var state_33438__$1 = state_33438;
var statearr_33454_33517 = state_33438__$1;
(statearr_33454_33517[(2)] = null);

(statearr_33454_33517[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33439 === (5))){
var state_33438__$1 = state_33438;
if(cljs.core.truth_(close_QMARK_)){
var statearr_33455_33518 = state_33438__$1;
(statearr_33455_33518[(1)] = (8));

} else {
var statearr_33456_33519 = state_33438__$1;
(statearr_33456_33519[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33439 === (14))){
var inst_33418 = (state_33438[(11)]);
var inst_33416 = (state_33438[(8)]);
var inst_33416__$1 = (state_33438[(2)]);
var inst_33417 = (inst_33416__$1 == null);
var inst_33418__$1 = cljs.core.not(inst_33417);
var state_33438__$1 = (function (){var statearr_33457 = state_33438;
(statearr_33457[(11)] = inst_33418__$1);

(statearr_33457[(8)] = inst_33416__$1);

return statearr_33457;
})();
if(inst_33418__$1){
var statearr_33458_33520 = state_33438__$1;
(statearr_33458_33520[(1)] = (15));

} else {
var statearr_33459_33521 = state_33438__$1;
(statearr_33459_33521[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33439 === (16))){
var inst_33418 = (state_33438[(11)]);
var state_33438__$1 = state_33438;
var statearr_33460_33522 = state_33438__$1;
(statearr_33460_33522[(2)] = inst_33418);

(statearr_33460_33522[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33439 === (10))){
var inst_33410 = (state_33438[(2)]);
var state_33438__$1 = state_33438;
var statearr_33461_33523 = state_33438__$1;
(statearr_33461_33523[(2)] = inst_33410);

(statearr_33461_33523[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33439 === (18))){
var inst_33421 = (state_33438[(2)]);
var state_33438__$1 = state_33438;
var statearr_33462_33524 = state_33438__$1;
(statearr_33462_33524[(2)] = inst_33421);

(statearr_33462_33524[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33439 === (8))){
var inst_33407 = cljs.core.async.close_BANG_(to);
var state_33438__$1 = state_33438;
var statearr_33463_33525 = state_33438__$1;
(statearr_33463_33525[(2)] = inst_33407);

(statearr_33463_33525[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12309__auto__,jobs,results,process,async))
;
return ((function (switch__12197__auto__,c__12309__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__12198__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__12198__auto____0 = (function (){
var statearr_33467 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33467[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__12198__auto__);

(statearr_33467[(1)] = (1));

return statearr_33467;
});
var cljs$core$async$pipeline_STAR__$_state_machine__12198__auto____1 = (function (state_33438){
while(true){
var ret_value__12199__auto__ = (function (){try{while(true){
var result__12200__auto__ = switch__12197__auto__(state_33438);
if(cljs.core.keyword_identical_QMARK_(result__12200__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12200__auto__;
}
break;
}
}catch (e33468){if((e33468 instanceof Object)){
var ex__12201__auto__ = e33468;
var statearr_33469_33526 = state_33438;
(statearr_33469_33526[(5)] = ex__12201__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_33438);

return cljs.core.cst$kw$recur;
} else {
throw e33468;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12199__auto__,cljs.core.cst$kw$recur)){
var G__33527 = state_33438;
state_33438 = G__33527;
continue;
} else {
return ret_value__12199__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__12198__auto__ = function(state_33438){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__12198__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__12198__auto____1.call(this,state_33438);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__12198__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__12198__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__12198__auto__;
})()
;})(switch__12197__auto__,c__12309__auto__,jobs,results,process,async))
})();
var state__12311__auto__ = (function (){var statearr_33470 = (f__12310__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12310__auto__.cljs$core$IFn$_invoke$arity$0() : f__12310__auto__.call(null));
(statearr_33470[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12309__auto__);

return statearr_33470;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12311__auto__);
});})(c__12309__auto__,jobs,results,process,async))
);

return c__12309__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args33528 = [];
var len__7484__auto___33531 = arguments.length;
var i__7485__auto___33532 = (0);
while(true){
if((i__7485__auto___33532 < len__7484__auto___33531)){
args33528.push((arguments[i__7485__auto___33532]));

var G__33533 = (i__7485__auto___33532 + (1));
i__7485__auto___33532 = G__33533;
continue;
} else {
}
break;
}

var G__33530 = args33528.length;
switch (G__33530) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33528.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,cljs.core.cst$kw$async);
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args33535 = [];
var len__7484__auto___33538 = arguments.length;
var i__7485__auto___33539 = (0);
while(true){
if((i__7485__auto___33539 < len__7484__auto___33538)){
args33535.push((arguments[i__7485__auto___33539]));

var G__33540 = (i__7485__auto___33539 + (1));
i__7485__auto___33539 = G__33540;
continue;
} else {
}
break;
}

var G__33537 = args33535.length;
switch (G__33537) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33535.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,cljs.core.cst$kw$compute);
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args33542 = [];
var len__7484__auto___33595 = arguments.length;
var i__7485__auto___33596 = (0);
while(true){
if((i__7485__auto___33596 < len__7484__auto___33595)){
args33542.push((arguments[i__7485__auto___33596]));

var G__33597 = (i__7485__auto___33596 + (1));
i__7485__auto___33596 = G__33597;
continue;
} else {
}
break;
}

var G__33544 = args33542.length;
switch (G__33544) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33542.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__12309__auto___33599 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12309__auto___33599,tc,fc){
return (function (){
var f__12310__auto__ = (function (){var switch__12197__auto__ = ((function (c__12309__auto___33599,tc,fc){
return (function (state_33570){
var state_val_33571 = (state_33570[(1)]);
if((state_val_33571 === (7))){
var inst_33566 = (state_33570[(2)]);
var state_33570__$1 = state_33570;
var statearr_33572_33600 = state_33570__$1;
(statearr_33572_33600[(2)] = inst_33566);

(statearr_33572_33600[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33571 === (1))){
var state_33570__$1 = state_33570;
var statearr_33573_33601 = state_33570__$1;
(statearr_33573_33601[(2)] = null);

(statearr_33573_33601[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33571 === (4))){
var inst_33547 = (state_33570[(7)]);
var inst_33547__$1 = (state_33570[(2)]);
var inst_33548 = (inst_33547__$1 == null);
var state_33570__$1 = (function (){var statearr_33574 = state_33570;
(statearr_33574[(7)] = inst_33547__$1);

return statearr_33574;
})();
if(cljs.core.truth_(inst_33548)){
var statearr_33575_33602 = state_33570__$1;
(statearr_33575_33602[(1)] = (5));

} else {
var statearr_33576_33603 = state_33570__$1;
(statearr_33576_33603[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33571 === (13))){
var state_33570__$1 = state_33570;
var statearr_33577_33604 = state_33570__$1;
(statearr_33577_33604[(2)] = null);

(statearr_33577_33604[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33571 === (6))){
var inst_33547 = (state_33570[(7)]);
var inst_33553 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_33547) : p.call(null,inst_33547));
var state_33570__$1 = state_33570;
if(cljs.core.truth_(inst_33553)){
var statearr_33578_33605 = state_33570__$1;
(statearr_33578_33605[(1)] = (9));

} else {
var statearr_33579_33606 = state_33570__$1;
(statearr_33579_33606[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33571 === (3))){
var inst_33568 = (state_33570[(2)]);
var state_33570__$1 = state_33570;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33570__$1,inst_33568);
} else {
if((state_val_33571 === (12))){
var state_33570__$1 = state_33570;
var statearr_33580_33607 = state_33570__$1;
(statearr_33580_33607[(2)] = null);

(statearr_33580_33607[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33571 === (2))){
var state_33570__$1 = state_33570;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33570__$1,(4),ch);
} else {
if((state_val_33571 === (11))){
var inst_33547 = (state_33570[(7)]);
var inst_33557 = (state_33570[(2)]);
var state_33570__$1 = state_33570;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33570__$1,(8),inst_33557,inst_33547);
} else {
if((state_val_33571 === (9))){
var state_33570__$1 = state_33570;
var statearr_33581_33608 = state_33570__$1;
(statearr_33581_33608[(2)] = tc);

(statearr_33581_33608[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33571 === (5))){
var inst_33550 = cljs.core.async.close_BANG_(tc);
var inst_33551 = cljs.core.async.close_BANG_(fc);
var state_33570__$1 = (function (){var statearr_33582 = state_33570;
(statearr_33582[(8)] = inst_33550);

return statearr_33582;
})();
var statearr_33583_33609 = state_33570__$1;
(statearr_33583_33609[(2)] = inst_33551);

(statearr_33583_33609[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33571 === (14))){
var inst_33564 = (state_33570[(2)]);
var state_33570__$1 = state_33570;
var statearr_33584_33610 = state_33570__$1;
(statearr_33584_33610[(2)] = inst_33564);

(statearr_33584_33610[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33571 === (10))){
var state_33570__$1 = state_33570;
var statearr_33585_33611 = state_33570__$1;
(statearr_33585_33611[(2)] = fc);

(statearr_33585_33611[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33571 === (8))){
var inst_33559 = (state_33570[(2)]);
var state_33570__$1 = state_33570;
if(cljs.core.truth_(inst_33559)){
var statearr_33586_33612 = state_33570__$1;
(statearr_33586_33612[(1)] = (12));

} else {
var statearr_33587_33613 = state_33570__$1;
(statearr_33587_33613[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12309__auto___33599,tc,fc))
;
return ((function (switch__12197__auto__,c__12309__auto___33599,tc,fc){
return (function() {
var cljs$core$async$state_machine__12198__auto__ = null;
var cljs$core$async$state_machine__12198__auto____0 = (function (){
var statearr_33591 = [null,null,null,null,null,null,null,null,null];
(statearr_33591[(0)] = cljs$core$async$state_machine__12198__auto__);

(statearr_33591[(1)] = (1));

return statearr_33591;
});
var cljs$core$async$state_machine__12198__auto____1 = (function (state_33570){
while(true){
var ret_value__12199__auto__ = (function (){try{while(true){
var result__12200__auto__ = switch__12197__auto__(state_33570);
if(cljs.core.keyword_identical_QMARK_(result__12200__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12200__auto__;
}
break;
}
}catch (e33592){if((e33592 instanceof Object)){
var ex__12201__auto__ = e33592;
var statearr_33593_33614 = state_33570;
(statearr_33593_33614[(5)] = ex__12201__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_33570);

return cljs.core.cst$kw$recur;
} else {
throw e33592;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12199__auto__,cljs.core.cst$kw$recur)){
var G__33615 = state_33570;
state_33570 = G__33615;
continue;
} else {
return ret_value__12199__auto__;
}
break;
}
});
cljs$core$async$state_machine__12198__auto__ = function(state_33570){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12198__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12198__auto____1.call(this,state_33570);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12198__auto____0;
cljs$core$async$state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12198__auto____1;
return cljs$core$async$state_machine__12198__auto__;
})()
;})(switch__12197__auto__,c__12309__auto___33599,tc,fc))
})();
var state__12311__auto__ = (function (){var statearr_33594 = (f__12310__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12310__auto__.cljs$core$IFn$_invoke$arity$0() : f__12310__auto__.call(null));
(statearr_33594[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12309__auto___33599);

return statearr_33594;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12311__auto__);
});})(c__12309__auto___33599,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__12309__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12309__auto__){
return (function (){
var f__12310__auto__ = (function (){var switch__12197__auto__ = ((function (c__12309__auto__){
return (function (state_33679){
var state_val_33680 = (state_33679[(1)]);
if((state_val_33680 === (7))){
var inst_33675 = (state_33679[(2)]);
var state_33679__$1 = state_33679;
var statearr_33681_33702 = state_33679__$1;
(statearr_33681_33702[(2)] = inst_33675);

(statearr_33681_33702[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33680 === (1))){
var inst_33659 = init;
var state_33679__$1 = (function (){var statearr_33682 = state_33679;
(statearr_33682[(7)] = inst_33659);

return statearr_33682;
})();
var statearr_33683_33703 = state_33679__$1;
(statearr_33683_33703[(2)] = null);

(statearr_33683_33703[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33680 === (4))){
var inst_33662 = (state_33679[(8)]);
var inst_33662__$1 = (state_33679[(2)]);
var inst_33663 = (inst_33662__$1 == null);
var state_33679__$1 = (function (){var statearr_33684 = state_33679;
(statearr_33684[(8)] = inst_33662__$1);

return statearr_33684;
})();
if(cljs.core.truth_(inst_33663)){
var statearr_33685_33704 = state_33679__$1;
(statearr_33685_33704[(1)] = (5));

} else {
var statearr_33686_33705 = state_33679__$1;
(statearr_33686_33705[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33680 === (6))){
var inst_33662 = (state_33679[(8)]);
var inst_33666 = (state_33679[(9)]);
var inst_33659 = (state_33679[(7)]);
var inst_33666__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_33659,inst_33662) : f.call(null,inst_33659,inst_33662));
var inst_33667 = cljs.core.reduced_QMARK_(inst_33666__$1);
var state_33679__$1 = (function (){var statearr_33687 = state_33679;
(statearr_33687[(9)] = inst_33666__$1);

return statearr_33687;
})();
if(inst_33667){
var statearr_33688_33706 = state_33679__$1;
(statearr_33688_33706[(1)] = (8));

} else {
var statearr_33689_33707 = state_33679__$1;
(statearr_33689_33707[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33680 === (3))){
var inst_33677 = (state_33679[(2)]);
var state_33679__$1 = state_33679;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33679__$1,inst_33677);
} else {
if((state_val_33680 === (2))){
var state_33679__$1 = state_33679;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33679__$1,(4),ch);
} else {
if((state_val_33680 === (9))){
var inst_33666 = (state_33679[(9)]);
var inst_33659 = inst_33666;
var state_33679__$1 = (function (){var statearr_33690 = state_33679;
(statearr_33690[(7)] = inst_33659);

return statearr_33690;
})();
var statearr_33691_33708 = state_33679__$1;
(statearr_33691_33708[(2)] = null);

(statearr_33691_33708[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33680 === (5))){
var inst_33659 = (state_33679[(7)]);
var state_33679__$1 = state_33679;
var statearr_33692_33709 = state_33679__$1;
(statearr_33692_33709[(2)] = inst_33659);

(statearr_33692_33709[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33680 === (10))){
var inst_33673 = (state_33679[(2)]);
var state_33679__$1 = state_33679;
var statearr_33693_33710 = state_33679__$1;
(statearr_33693_33710[(2)] = inst_33673);

(statearr_33693_33710[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33680 === (8))){
var inst_33666 = (state_33679[(9)]);
var inst_33669 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(inst_33666) : cljs.core.deref.call(null,inst_33666));
var state_33679__$1 = state_33679;
var statearr_33694_33711 = state_33679__$1;
(statearr_33694_33711[(2)] = inst_33669);

(statearr_33694_33711[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__12309__auto__))
;
return ((function (switch__12197__auto__,c__12309__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__12198__auto__ = null;
var cljs$core$async$reduce_$_state_machine__12198__auto____0 = (function (){
var statearr_33698 = [null,null,null,null,null,null,null,null,null,null];
(statearr_33698[(0)] = cljs$core$async$reduce_$_state_machine__12198__auto__);

(statearr_33698[(1)] = (1));

return statearr_33698;
});
var cljs$core$async$reduce_$_state_machine__12198__auto____1 = (function (state_33679){
while(true){
var ret_value__12199__auto__ = (function (){try{while(true){
var result__12200__auto__ = switch__12197__auto__(state_33679);
if(cljs.core.keyword_identical_QMARK_(result__12200__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12200__auto__;
}
break;
}
}catch (e33699){if((e33699 instanceof Object)){
var ex__12201__auto__ = e33699;
var statearr_33700_33712 = state_33679;
(statearr_33700_33712[(5)] = ex__12201__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_33679);

return cljs.core.cst$kw$recur;
} else {
throw e33699;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12199__auto__,cljs.core.cst$kw$recur)){
var G__33713 = state_33679;
state_33679 = G__33713;
continue;
} else {
return ret_value__12199__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__12198__auto__ = function(state_33679){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__12198__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__12198__auto____1.call(this,state_33679);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__12198__auto____0;
cljs$core$async$reduce_$_state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__12198__auto____1;
return cljs$core$async$reduce_$_state_machine__12198__auto__;
})()
;})(switch__12197__auto__,c__12309__auto__))
})();
var state__12311__auto__ = (function (){var statearr_33701 = (f__12310__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12310__auto__.cljs$core$IFn$_invoke$arity$0() : f__12310__auto__.call(null));
(statearr_33701[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12309__auto__);

return statearr_33701;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12311__auto__);
});})(c__12309__auto__))
);

return c__12309__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var c__12309__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12309__auto__,f__$1){
return (function (){
var f__12310__auto__ = (function (){var switch__12197__auto__ = ((function (c__12309__auto__,f__$1){
return (function (state_33733){
var state_val_33734 = (state_33733[(1)]);
if((state_val_33734 === (1))){
var inst_33728 = cljs.core.async.reduce(f__$1,init,ch);
var state_33733__$1 = state_33733;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33733__$1,(2),inst_33728);
} else {
if((state_val_33734 === (2))){
var inst_33730 = (state_33733[(2)]);
var inst_33731 = (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(inst_33730) : f__$1.call(null,inst_33730));
var state_33733__$1 = state_33733;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33733__$1,inst_33731);
} else {
return null;
}
}
});})(c__12309__auto__,f__$1))
;
return ((function (switch__12197__auto__,c__12309__auto__,f__$1){
return (function() {
var cljs$core$async$transduce_$_state_machine__12198__auto__ = null;
var cljs$core$async$transduce_$_state_machine__12198__auto____0 = (function (){
var statearr_33738 = [null,null,null,null,null,null,null];
(statearr_33738[(0)] = cljs$core$async$transduce_$_state_machine__12198__auto__);

(statearr_33738[(1)] = (1));

return statearr_33738;
});
var cljs$core$async$transduce_$_state_machine__12198__auto____1 = (function (state_33733){
while(true){
var ret_value__12199__auto__ = (function (){try{while(true){
var result__12200__auto__ = switch__12197__auto__(state_33733);
if(cljs.core.keyword_identical_QMARK_(result__12200__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12200__auto__;
}
break;
}
}catch (e33739){if((e33739 instanceof Object)){
var ex__12201__auto__ = e33739;
var statearr_33740_33742 = state_33733;
(statearr_33740_33742[(5)] = ex__12201__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_33733);

return cljs.core.cst$kw$recur;
} else {
throw e33739;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12199__auto__,cljs.core.cst$kw$recur)){
var G__33743 = state_33733;
state_33733 = G__33743;
continue;
} else {
return ret_value__12199__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__12198__auto__ = function(state_33733){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__12198__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__12198__auto____1.call(this,state_33733);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__12198__auto____0;
cljs$core$async$transduce_$_state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__12198__auto____1;
return cljs$core$async$transduce_$_state_machine__12198__auto__;
})()
;})(switch__12197__auto__,c__12309__auto__,f__$1))
})();
var state__12311__auto__ = (function (){var statearr_33741 = (f__12310__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12310__auto__.cljs$core$IFn$_invoke$arity$0() : f__12310__auto__.call(null));
(statearr_33741[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12309__auto__);

return statearr_33741;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12311__auto__);
});})(c__12309__auto__,f__$1))
);

return c__12309__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args33744 = [];
var len__7484__auto___33796 = arguments.length;
var i__7485__auto___33797 = (0);
while(true){
if((i__7485__auto___33797 < len__7484__auto___33796)){
args33744.push((arguments[i__7485__auto___33797]));

var G__33798 = (i__7485__auto___33797 + (1));
i__7485__auto___33797 = G__33798;
continue;
} else {
}
break;
}

var G__33746 = args33744.length;
switch (G__33746) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33744.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__12309__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12309__auto__){
return (function (){
var f__12310__auto__ = (function (){var switch__12197__auto__ = ((function (c__12309__auto__){
return (function (state_33771){
var state_val_33772 = (state_33771[(1)]);
if((state_val_33772 === (7))){
var inst_33753 = (state_33771[(2)]);
var state_33771__$1 = state_33771;
var statearr_33773_33800 = state_33771__$1;
(statearr_33773_33800[(2)] = inst_33753);

(statearr_33773_33800[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33772 === (1))){
var inst_33747 = cljs.core.seq(coll);
var inst_33748 = inst_33747;
var state_33771__$1 = (function (){var statearr_33774 = state_33771;
(statearr_33774[(7)] = inst_33748);

return statearr_33774;
})();
var statearr_33775_33801 = state_33771__$1;
(statearr_33775_33801[(2)] = null);

(statearr_33775_33801[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33772 === (4))){
var inst_33748 = (state_33771[(7)]);
var inst_33751 = cljs.core.first(inst_33748);
var state_33771__$1 = state_33771;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33771__$1,(7),ch,inst_33751);
} else {
if((state_val_33772 === (13))){
var inst_33765 = (state_33771[(2)]);
var state_33771__$1 = state_33771;
var statearr_33776_33802 = state_33771__$1;
(statearr_33776_33802[(2)] = inst_33765);

(statearr_33776_33802[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33772 === (6))){
var inst_33756 = (state_33771[(2)]);
var state_33771__$1 = state_33771;
if(cljs.core.truth_(inst_33756)){
var statearr_33777_33803 = state_33771__$1;
(statearr_33777_33803[(1)] = (8));

} else {
var statearr_33778_33804 = state_33771__$1;
(statearr_33778_33804[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33772 === (3))){
var inst_33769 = (state_33771[(2)]);
var state_33771__$1 = state_33771;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33771__$1,inst_33769);
} else {
if((state_val_33772 === (12))){
var state_33771__$1 = state_33771;
var statearr_33779_33805 = state_33771__$1;
(statearr_33779_33805[(2)] = null);

(statearr_33779_33805[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33772 === (2))){
var inst_33748 = (state_33771[(7)]);
var state_33771__$1 = state_33771;
if(cljs.core.truth_(inst_33748)){
var statearr_33780_33806 = state_33771__$1;
(statearr_33780_33806[(1)] = (4));

} else {
var statearr_33781_33807 = state_33771__$1;
(statearr_33781_33807[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33772 === (11))){
var inst_33762 = cljs.core.async.close_BANG_(ch);
var state_33771__$1 = state_33771;
var statearr_33782_33808 = state_33771__$1;
(statearr_33782_33808[(2)] = inst_33762);

(statearr_33782_33808[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33772 === (9))){
var state_33771__$1 = state_33771;
if(cljs.core.truth_(close_QMARK_)){
var statearr_33783_33809 = state_33771__$1;
(statearr_33783_33809[(1)] = (11));

} else {
var statearr_33784_33810 = state_33771__$1;
(statearr_33784_33810[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33772 === (5))){
var inst_33748 = (state_33771[(7)]);
var state_33771__$1 = state_33771;
var statearr_33785_33811 = state_33771__$1;
(statearr_33785_33811[(2)] = inst_33748);

(statearr_33785_33811[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33772 === (10))){
var inst_33767 = (state_33771[(2)]);
var state_33771__$1 = state_33771;
var statearr_33786_33812 = state_33771__$1;
(statearr_33786_33812[(2)] = inst_33767);

(statearr_33786_33812[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33772 === (8))){
var inst_33748 = (state_33771[(7)]);
var inst_33758 = cljs.core.next(inst_33748);
var inst_33748__$1 = inst_33758;
var state_33771__$1 = (function (){var statearr_33787 = state_33771;
(statearr_33787[(7)] = inst_33748__$1);

return statearr_33787;
})();
var statearr_33788_33813 = state_33771__$1;
(statearr_33788_33813[(2)] = null);

(statearr_33788_33813[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12309__auto__))
;
return ((function (switch__12197__auto__,c__12309__auto__){
return (function() {
var cljs$core$async$state_machine__12198__auto__ = null;
var cljs$core$async$state_machine__12198__auto____0 = (function (){
var statearr_33792 = [null,null,null,null,null,null,null,null];
(statearr_33792[(0)] = cljs$core$async$state_machine__12198__auto__);

(statearr_33792[(1)] = (1));

return statearr_33792;
});
var cljs$core$async$state_machine__12198__auto____1 = (function (state_33771){
while(true){
var ret_value__12199__auto__ = (function (){try{while(true){
var result__12200__auto__ = switch__12197__auto__(state_33771);
if(cljs.core.keyword_identical_QMARK_(result__12200__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12200__auto__;
}
break;
}
}catch (e33793){if((e33793 instanceof Object)){
var ex__12201__auto__ = e33793;
var statearr_33794_33814 = state_33771;
(statearr_33794_33814[(5)] = ex__12201__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_33771);

return cljs.core.cst$kw$recur;
} else {
throw e33793;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12199__auto__,cljs.core.cst$kw$recur)){
var G__33815 = state_33771;
state_33771 = G__33815;
continue;
} else {
return ret_value__12199__auto__;
}
break;
}
});
cljs$core$async$state_machine__12198__auto__ = function(state_33771){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12198__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12198__auto____1.call(this,state_33771);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12198__auto____0;
cljs$core$async$state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12198__auto____1;
return cljs$core$async$state_machine__12198__auto__;
})()
;})(switch__12197__auto__,c__12309__auto__))
})();
var state__12311__auto__ = (function (){var statearr_33795 = (f__12310__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12310__auto__.cljs$core$IFn$_invoke$arity$0() : f__12310__auto__.call(null));
(statearr_33795[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12309__auto__);

return statearr_33795;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12311__auto__);
});})(c__12309__auto__))
);

return c__12309__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__7072__auto__ = (((_ == null))?null:_);
var m__7073__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return (m__7073__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7073__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__7073__auto__.call(null,_));
} else {
var m__7073__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return (m__7073__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7073__auto____$1.cljs$core$IFn$_invoke$arity$1(_) : m__7073__auto____$1.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__7072__auto__ = (((m == null))?null:m);
var m__7073__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return (m__7073__auto__.cljs$core$IFn$_invoke$arity$3 ? m__7073__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__7073__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__7073__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return (m__7073__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__7073__auto____$1.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__7073__auto____$1.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__7072__auto__ = (((m == null))?null:m);
var m__7073__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return (m__7073__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7073__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__7073__auto__.call(null,m,ch));
} else {
var m__7073__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return (m__7073__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7073__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__7073__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__7072__auto__ = (((m == null))?null:m);
var m__7073__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return (m__7073__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7073__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__7073__auto__.call(null,m));
} else {
var m__7073__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return (m__7073__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7073__auto____$1.cljs$core$IFn$_invoke$arity$1(m) : m__7073__auto____$1.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = (function (){var G__34044 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__34044) : cljs.core.atom.call(null,G__34044));
})();
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async34045 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async34045 = (function (mult,ch,cs,meta34046){
this.mult = mult;
this.ch = ch;
this.cs = cs;
this.meta34046 = meta34046;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async34045.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_34047,meta34046__$1){
var self__ = this;
var _34047__$1 = this;
return (new cljs.core.async.t_cljs$core$async34045(self__.mult,self__.ch,self__.cs,meta34046__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async34045.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_34047){
var self__ = this;
var _34047__$1 = this;
return self__.meta34046;
});})(cs))
;

cljs.core.async.t_cljs$core$async34045.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async34045.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async34045.prototype.cljs$core$async$Mult$ = true;

cljs.core.async.t_cljs$core$async34045.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async34045.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async34045.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__34048_34272 = self__.cs;
var G__34049_34273 = cljs.core.PersistentArrayMap.EMPTY;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__34048_34272,G__34049_34273) : cljs.core.reset_BANG_.call(null,G__34048_34272,G__34049_34273));

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async34045.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$mult,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ch], null))),cljs.core.cst$kw$doc,"Creates and returns a mult(iple) of the supplied channel. Channels\n  containing copies of the channel can be created with 'tap', and\n  detached with 'untap'.\n\n  Each item is distributed to all taps in parallel and synchronously,\n  i.e. each tap must accept before the next item is distributed. Use\n  buffering/windowing to prevent slow taps from holding up the mult.\n\n  Items received when there are no taps get dropped.\n\n  If a tap puts to a closed channel, it will be removed from the mult."], null)),cljs.core.cst$sym$ch,cljs.core.cst$sym$cs,cljs.core.cst$sym$meta34046], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async34045.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async34045.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async34045";

cljs.core.async.t_cljs$core$async34045.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"cljs.core.async/t_cljs$core$async34045");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async34045 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async34045(mult__$1,ch__$1,cs__$1,meta34046){
return (new cljs.core.async.t_cljs$core$async34045(mult__$1,ch__$1,cs__$1,meta34046));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async34045(cljs$core$async$mult,ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null) : cljs.core.atom.call(null,null));
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__12309__auto___34274 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12309__auto___34274,cs,m,dchan,dctr,done){
return (function (){
var f__12310__auto__ = (function (){var switch__12197__auto__ = ((function (c__12309__auto___34274,cs,m,dchan,dctr,done){
return (function (state_34184){
var state_val_34185 = (state_34184[(1)]);
if((state_val_34185 === (7))){
var inst_34180 = (state_34184[(2)]);
var state_34184__$1 = state_34184;
var statearr_34186_34275 = state_34184__$1;
(statearr_34186_34275[(2)] = inst_34180);

(statearr_34186_34275[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34185 === (20))){
var inst_34083 = (state_34184[(7)]);
var inst_34095 = cljs.core.first(inst_34083);
var inst_34096 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_34095,(0),null);
var inst_34097 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_34095,(1),null);
var state_34184__$1 = (function (){var statearr_34187 = state_34184;
(statearr_34187[(8)] = inst_34096);

return statearr_34187;
})();
if(cljs.core.truth_(inst_34097)){
var statearr_34188_34276 = state_34184__$1;
(statearr_34188_34276[(1)] = (22));

} else {
var statearr_34189_34277 = state_34184__$1;
(statearr_34189_34277[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34185 === (27))){
var inst_34052 = (state_34184[(9)]);
var inst_34132 = (state_34184[(10)]);
var inst_34127 = (state_34184[(11)]);
var inst_34125 = (state_34184[(12)]);
var inst_34132__$1 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_34125,inst_34127);
var inst_34133 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_34132__$1,inst_34052,done);
var state_34184__$1 = (function (){var statearr_34190 = state_34184;
(statearr_34190[(10)] = inst_34132__$1);

return statearr_34190;
})();
if(cljs.core.truth_(inst_34133)){
var statearr_34191_34278 = state_34184__$1;
(statearr_34191_34278[(1)] = (30));

} else {
var statearr_34192_34279 = state_34184__$1;
(statearr_34192_34279[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34185 === (1))){
var state_34184__$1 = state_34184;
var statearr_34193_34280 = state_34184__$1;
(statearr_34193_34280[(2)] = null);

(statearr_34193_34280[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34185 === (24))){
var inst_34083 = (state_34184[(7)]);
var inst_34102 = (state_34184[(2)]);
var inst_34103 = cljs.core.next(inst_34083);
var inst_34061 = inst_34103;
var inst_34062 = null;
var inst_34063 = (0);
var inst_34064 = (0);
var state_34184__$1 = (function (){var statearr_34194 = state_34184;
(statearr_34194[(13)] = inst_34064);

(statearr_34194[(14)] = inst_34063);

(statearr_34194[(15)] = inst_34061);

(statearr_34194[(16)] = inst_34062);

(statearr_34194[(17)] = inst_34102);

return statearr_34194;
})();
var statearr_34195_34281 = state_34184__$1;
(statearr_34195_34281[(2)] = null);

(statearr_34195_34281[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34185 === (39))){
var state_34184__$1 = state_34184;
var statearr_34199_34282 = state_34184__$1;
(statearr_34199_34282[(2)] = null);

(statearr_34199_34282[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34185 === (4))){
var inst_34052 = (state_34184[(9)]);
var inst_34052__$1 = (state_34184[(2)]);
var inst_34053 = (inst_34052__$1 == null);
var state_34184__$1 = (function (){var statearr_34200 = state_34184;
(statearr_34200[(9)] = inst_34052__$1);

return statearr_34200;
})();
if(cljs.core.truth_(inst_34053)){
var statearr_34201_34283 = state_34184__$1;
(statearr_34201_34283[(1)] = (5));

} else {
var statearr_34202_34284 = state_34184__$1;
(statearr_34202_34284[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34185 === (15))){
var inst_34064 = (state_34184[(13)]);
var inst_34063 = (state_34184[(14)]);
var inst_34061 = (state_34184[(15)]);
var inst_34062 = (state_34184[(16)]);
var inst_34079 = (state_34184[(2)]);
var inst_34080 = (inst_34064 + (1));
var tmp34196 = inst_34063;
var tmp34197 = inst_34061;
var tmp34198 = inst_34062;
var inst_34061__$1 = tmp34197;
var inst_34062__$1 = tmp34198;
var inst_34063__$1 = tmp34196;
var inst_34064__$1 = inst_34080;
var state_34184__$1 = (function (){var statearr_34203 = state_34184;
(statearr_34203[(13)] = inst_34064__$1);

(statearr_34203[(18)] = inst_34079);

(statearr_34203[(14)] = inst_34063__$1);

(statearr_34203[(15)] = inst_34061__$1);

(statearr_34203[(16)] = inst_34062__$1);

return statearr_34203;
})();
var statearr_34204_34285 = state_34184__$1;
(statearr_34204_34285[(2)] = null);

(statearr_34204_34285[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34185 === (21))){
var inst_34106 = (state_34184[(2)]);
var state_34184__$1 = state_34184;
var statearr_34208_34286 = state_34184__$1;
(statearr_34208_34286[(2)] = inst_34106);

(statearr_34208_34286[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34185 === (31))){
var inst_34132 = (state_34184[(10)]);
var inst_34136 = done(null);
var inst_34137 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_34132);
var state_34184__$1 = (function (){var statearr_34209 = state_34184;
(statearr_34209[(19)] = inst_34136);

return statearr_34209;
})();
var statearr_34210_34287 = state_34184__$1;
(statearr_34210_34287[(2)] = inst_34137);

(statearr_34210_34287[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34185 === (32))){
var inst_34127 = (state_34184[(11)]);
var inst_34126 = (state_34184[(20)]);
var inst_34124 = (state_34184[(21)]);
var inst_34125 = (state_34184[(12)]);
var inst_34139 = (state_34184[(2)]);
var inst_34140 = (inst_34127 + (1));
var tmp34205 = inst_34126;
var tmp34206 = inst_34124;
var tmp34207 = inst_34125;
var inst_34124__$1 = tmp34206;
var inst_34125__$1 = tmp34207;
var inst_34126__$1 = tmp34205;
var inst_34127__$1 = inst_34140;
var state_34184__$1 = (function (){var statearr_34211 = state_34184;
(statearr_34211[(22)] = inst_34139);

(statearr_34211[(11)] = inst_34127__$1);

(statearr_34211[(20)] = inst_34126__$1);

(statearr_34211[(21)] = inst_34124__$1);

(statearr_34211[(12)] = inst_34125__$1);

return statearr_34211;
})();
var statearr_34212_34288 = state_34184__$1;
(statearr_34212_34288[(2)] = null);

(statearr_34212_34288[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34185 === (40))){
var inst_34152 = (state_34184[(23)]);
var inst_34156 = done(null);
var inst_34157 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_34152);
var state_34184__$1 = (function (){var statearr_34213 = state_34184;
(statearr_34213[(24)] = inst_34156);

return statearr_34213;
})();
var statearr_34214_34289 = state_34184__$1;
(statearr_34214_34289[(2)] = inst_34157);

(statearr_34214_34289[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34185 === (33))){
var inst_34143 = (state_34184[(25)]);
var inst_34145 = cljs.core.chunked_seq_QMARK_(inst_34143);
var state_34184__$1 = state_34184;
if(inst_34145){
var statearr_34215_34290 = state_34184__$1;
(statearr_34215_34290[(1)] = (36));

} else {
var statearr_34216_34291 = state_34184__$1;
(statearr_34216_34291[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34185 === (13))){
var inst_34073 = (state_34184[(26)]);
var inst_34076 = cljs.core.async.close_BANG_(inst_34073);
var state_34184__$1 = state_34184;
var statearr_34217_34292 = state_34184__$1;
(statearr_34217_34292[(2)] = inst_34076);

(statearr_34217_34292[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34185 === (22))){
var inst_34096 = (state_34184[(8)]);
var inst_34099 = cljs.core.async.close_BANG_(inst_34096);
var state_34184__$1 = state_34184;
var statearr_34218_34293 = state_34184__$1;
(statearr_34218_34293[(2)] = inst_34099);

(statearr_34218_34293[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34185 === (36))){
var inst_34143 = (state_34184[(25)]);
var inst_34147 = cljs.core.chunk_first(inst_34143);
var inst_34148 = cljs.core.chunk_rest(inst_34143);
var inst_34149 = cljs.core.count(inst_34147);
var inst_34124 = inst_34148;
var inst_34125 = inst_34147;
var inst_34126 = inst_34149;
var inst_34127 = (0);
var state_34184__$1 = (function (){var statearr_34219 = state_34184;
(statearr_34219[(11)] = inst_34127);

(statearr_34219[(20)] = inst_34126);

(statearr_34219[(21)] = inst_34124);

(statearr_34219[(12)] = inst_34125);

return statearr_34219;
})();
var statearr_34220_34294 = state_34184__$1;
(statearr_34220_34294[(2)] = null);

(statearr_34220_34294[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34185 === (41))){
var inst_34143 = (state_34184[(25)]);
var inst_34159 = (state_34184[(2)]);
var inst_34160 = cljs.core.next(inst_34143);
var inst_34124 = inst_34160;
var inst_34125 = null;
var inst_34126 = (0);
var inst_34127 = (0);
var state_34184__$1 = (function (){var statearr_34221 = state_34184;
(statearr_34221[(11)] = inst_34127);

(statearr_34221[(27)] = inst_34159);

(statearr_34221[(20)] = inst_34126);

(statearr_34221[(21)] = inst_34124);

(statearr_34221[(12)] = inst_34125);

return statearr_34221;
})();
var statearr_34222_34295 = state_34184__$1;
(statearr_34222_34295[(2)] = null);

(statearr_34222_34295[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34185 === (43))){
var state_34184__$1 = state_34184;
var statearr_34223_34296 = state_34184__$1;
(statearr_34223_34296[(2)] = null);

(statearr_34223_34296[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34185 === (29))){
var inst_34168 = (state_34184[(2)]);
var state_34184__$1 = state_34184;
var statearr_34224_34297 = state_34184__$1;
(statearr_34224_34297[(2)] = inst_34168);

(statearr_34224_34297[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34185 === (44))){
var inst_34177 = (state_34184[(2)]);
var state_34184__$1 = (function (){var statearr_34225 = state_34184;
(statearr_34225[(28)] = inst_34177);

return statearr_34225;
})();
var statearr_34226_34298 = state_34184__$1;
(statearr_34226_34298[(2)] = null);

(statearr_34226_34298[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34185 === (6))){
var inst_34116 = (state_34184[(29)]);
var inst_34115 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cs) : cljs.core.deref.call(null,cs));
var inst_34116__$1 = cljs.core.keys(inst_34115);
var inst_34117 = cljs.core.count(inst_34116__$1);
var inst_34118 = (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,inst_34117) : cljs.core.reset_BANG_.call(null,dctr,inst_34117));
var inst_34123 = cljs.core.seq(inst_34116__$1);
var inst_34124 = inst_34123;
var inst_34125 = null;
var inst_34126 = (0);
var inst_34127 = (0);
var state_34184__$1 = (function (){var statearr_34227 = state_34184;
(statearr_34227[(29)] = inst_34116__$1);

(statearr_34227[(11)] = inst_34127);

(statearr_34227[(20)] = inst_34126);

(statearr_34227[(21)] = inst_34124);

(statearr_34227[(30)] = inst_34118);

(statearr_34227[(12)] = inst_34125);

return statearr_34227;
})();
var statearr_34228_34299 = state_34184__$1;
(statearr_34228_34299[(2)] = null);

(statearr_34228_34299[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34185 === (28))){
var inst_34124 = (state_34184[(21)]);
var inst_34143 = (state_34184[(25)]);
var inst_34143__$1 = cljs.core.seq(inst_34124);
var state_34184__$1 = (function (){var statearr_34229 = state_34184;
(statearr_34229[(25)] = inst_34143__$1);

return statearr_34229;
})();
if(inst_34143__$1){
var statearr_34230_34300 = state_34184__$1;
(statearr_34230_34300[(1)] = (33));

} else {
var statearr_34231_34301 = state_34184__$1;
(statearr_34231_34301[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34185 === (25))){
var inst_34127 = (state_34184[(11)]);
var inst_34126 = (state_34184[(20)]);
var inst_34129 = (inst_34127 < inst_34126);
var inst_34130 = inst_34129;
var state_34184__$1 = state_34184;
if(cljs.core.truth_(inst_34130)){
var statearr_34232_34302 = state_34184__$1;
(statearr_34232_34302[(1)] = (27));

} else {
var statearr_34233_34303 = state_34184__$1;
(statearr_34233_34303[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34185 === (34))){
var state_34184__$1 = state_34184;
var statearr_34234_34304 = state_34184__$1;
(statearr_34234_34304[(2)] = null);

(statearr_34234_34304[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34185 === (17))){
var state_34184__$1 = state_34184;
var statearr_34235_34305 = state_34184__$1;
(statearr_34235_34305[(2)] = null);

(statearr_34235_34305[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34185 === (3))){
var inst_34182 = (state_34184[(2)]);
var state_34184__$1 = state_34184;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34184__$1,inst_34182);
} else {
if((state_val_34185 === (12))){
var inst_34111 = (state_34184[(2)]);
var state_34184__$1 = state_34184;
var statearr_34236_34306 = state_34184__$1;
(statearr_34236_34306[(2)] = inst_34111);

(statearr_34236_34306[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34185 === (2))){
var state_34184__$1 = state_34184;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34184__$1,(4),ch);
} else {
if((state_val_34185 === (23))){
var state_34184__$1 = state_34184;
var statearr_34237_34307 = state_34184__$1;
(statearr_34237_34307[(2)] = null);

(statearr_34237_34307[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34185 === (35))){
var inst_34166 = (state_34184[(2)]);
var state_34184__$1 = state_34184;
var statearr_34238_34308 = state_34184__$1;
(statearr_34238_34308[(2)] = inst_34166);

(statearr_34238_34308[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34185 === (19))){
var inst_34083 = (state_34184[(7)]);
var inst_34087 = cljs.core.chunk_first(inst_34083);
var inst_34088 = cljs.core.chunk_rest(inst_34083);
var inst_34089 = cljs.core.count(inst_34087);
var inst_34061 = inst_34088;
var inst_34062 = inst_34087;
var inst_34063 = inst_34089;
var inst_34064 = (0);
var state_34184__$1 = (function (){var statearr_34239 = state_34184;
(statearr_34239[(13)] = inst_34064);

(statearr_34239[(14)] = inst_34063);

(statearr_34239[(15)] = inst_34061);

(statearr_34239[(16)] = inst_34062);

return statearr_34239;
})();
var statearr_34240_34309 = state_34184__$1;
(statearr_34240_34309[(2)] = null);

(statearr_34240_34309[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34185 === (11))){
var inst_34083 = (state_34184[(7)]);
var inst_34061 = (state_34184[(15)]);
var inst_34083__$1 = cljs.core.seq(inst_34061);
var state_34184__$1 = (function (){var statearr_34241 = state_34184;
(statearr_34241[(7)] = inst_34083__$1);

return statearr_34241;
})();
if(inst_34083__$1){
var statearr_34242_34310 = state_34184__$1;
(statearr_34242_34310[(1)] = (16));

} else {
var statearr_34243_34311 = state_34184__$1;
(statearr_34243_34311[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34185 === (9))){
var inst_34113 = (state_34184[(2)]);
var state_34184__$1 = state_34184;
var statearr_34244_34312 = state_34184__$1;
(statearr_34244_34312[(2)] = inst_34113);

(statearr_34244_34312[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34185 === (5))){
var inst_34059 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cs) : cljs.core.deref.call(null,cs));
var inst_34060 = cljs.core.seq(inst_34059);
var inst_34061 = inst_34060;
var inst_34062 = null;
var inst_34063 = (0);
var inst_34064 = (0);
var state_34184__$1 = (function (){var statearr_34245 = state_34184;
(statearr_34245[(13)] = inst_34064);

(statearr_34245[(14)] = inst_34063);

(statearr_34245[(15)] = inst_34061);

(statearr_34245[(16)] = inst_34062);

return statearr_34245;
})();
var statearr_34246_34313 = state_34184__$1;
(statearr_34246_34313[(2)] = null);

(statearr_34246_34313[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34185 === (14))){
var state_34184__$1 = state_34184;
var statearr_34247_34314 = state_34184__$1;
(statearr_34247_34314[(2)] = null);

(statearr_34247_34314[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34185 === (45))){
var inst_34174 = (state_34184[(2)]);
var state_34184__$1 = state_34184;
var statearr_34248_34315 = state_34184__$1;
(statearr_34248_34315[(2)] = inst_34174);

(statearr_34248_34315[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34185 === (26))){
var inst_34116 = (state_34184[(29)]);
var inst_34170 = (state_34184[(2)]);
var inst_34171 = cljs.core.seq(inst_34116);
var state_34184__$1 = (function (){var statearr_34249 = state_34184;
(statearr_34249[(31)] = inst_34170);

return statearr_34249;
})();
if(inst_34171){
var statearr_34250_34316 = state_34184__$1;
(statearr_34250_34316[(1)] = (42));

} else {
var statearr_34251_34317 = state_34184__$1;
(statearr_34251_34317[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34185 === (16))){
var inst_34083 = (state_34184[(7)]);
var inst_34085 = cljs.core.chunked_seq_QMARK_(inst_34083);
var state_34184__$1 = state_34184;
if(inst_34085){
var statearr_34252_34318 = state_34184__$1;
(statearr_34252_34318[(1)] = (19));

} else {
var statearr_34253_34319 = state_34184__$1;
(statearr_34253_34319[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34185 === (38))){
var inst_34163 = (state_34184[(2)]);
var state_34184__$1 = state_34184;
var statearr_34254_34320 = state_34184__$1;
(statearr_34254_34320[(2)] = inst_34163);

(statearr_34254_34320[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34185 === (30))){
var state_34184__$1 = state_34184;
var statearr_34255_34321 = state_34184__$1;
(statearr_34255_34321[(2)] = null);

(statearr_34255_34321[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34185 === (10))){
var inst_34064 = (state_34184[(13)]);
var inst_34062 = (state_34184[(16)]);
var inst_34072 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_34062,inst_34064);
var inst_34073 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_34072,(0),null);
var inst_34074 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_34072,(1),null);
var state_34184__$1 = (function (){var statearr_34256 = state_34184;
(statearr_34256[(26)] = inst_34073);

return statearr_34256;
})();
if(cljs.core.truth_(inst_34074)){
var statearr_34257_34322 = state_34184__$1;
(statearr_34257_34322[(1)] = (13));

} else {
var statearr_34258_34323 = state_34184__$1;
(statearr_34258_34323[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34185 === (18))){
var inst_34109 = (state_34184[(2)]);
var state_34184__$1 = state_34184;
var statearr_34259_34324 = state_34184__$1;
(statearr_34259_34324[(2)] = inst_34109);

(statearr_34259_34324[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34185 === (42))){
var state_34184__$1 = state_34184;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34184__$1,(45),dchan);
} else {
if((state_val_34185 === (37))){
var inst_34052 = (state_34184[(9)]);
var inst_34152 = (state_34184[(23)]);
var inst_34143 = (state_34184[(25)]);
var inst_34152__$1 = cljs.core.first(inst_34143);
var inst_34153 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_34152__$1,inst_34052,done);
var state_34184__$1 = (function (){var statearr_34260 = state_34184;
(statearr_34260[(23)] = inst_34152__$1);

return statearr_34260;
})();
if(cljs.core.truth_(inst_34153)){
var statearr_34261_34325 = state_34184__$1;
(statearr_34261_34325[(1)] = (39));

} else {
var statearr_34262_34326 = state_34184__$1;
(statearr_34262_34326[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34185 === (8))){
var inst_34064 = (state_34184[(13)]);
var inst_34063 = (state_34184[(14)]);
var inst_34066 = (inst_34064 < inst_34063);
var inst_34067 = inst_34066;
var state_34184__$1 = state_34184;
if(cljs.core.truth_(inst_34067)){
var statearr_34263_34327 = state_34184__$1;
(statearr_34263_34327[(1)] = (10));

} else {
var statearr_34264_34328 = state_34184__$1;
(statearr_34264_34328[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12309__auto___34274,cs,m,dchan,dctr,done))
;
return ((function (switch__12197__auto__,c__12309__auto___34274,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__12198__auto__ = null;
var cljs$core$async$mult_$_state_machine__12198__auto____0 = (function (){
var statearr_34268 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_34268[(0)] = cljs$core$async$mult_$_state_machine__12198__auto__);

(statearr_34268[(1)] = (1));

return statearr_34268;
});
var cljs$core$async$mult_$_state_machine__12198__auto____1 = (function (state_34184){
while(true){
var ret_value__12199__auto__ = (function (){try{while(true){
var result__12200__auto__ = switch__12197__auto__(state_34184);
if(cljs.core.keyword_identical_QMARK_(result__12200__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12200__auto__;
}
break;
}
}catch (e34269){if((e34269 instanceof Object)){
var ex__12201__auto__ = e34269;
var statearr_34270_34329 = state_34184;
(statearr_34270_34329[(5)] = ex__12201__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_34184);

return cljs.core.cst$kw$recur;
} else {
throw e34269;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12199__auto__,cljs.core.cst$kw$recur)){
var G__34330 = state_34184;
state_34184 = G__34330;
continue;
} else {
return ret_value__12199__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__12198__auto__ = function(state_34184){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__12198__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__12198__auto____1.call(this,state_34184);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__12198__auto____0;
cljs$core$async$mult_$_state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__12198__auto____1;
return cljs$core$async$mult_$_state_machine__12198__auto__;
})()
;})(switch__12197__auto__,c__12309__auto___34274,cs,m,dchan,dctr,done))
})();
var state__12311__auto__ = (function (){var statearr_34271 = (f__12310__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12310__auto__.cljs$core$IFn$_invoke$arity$0() : f__12310__auto__.call(null));
(statearr_34271[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12309__auto___34274);

return statearr_34271;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12311__auto__);
});})(c__12309__auto___34274,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args34331 = [];
var len__7484__auto___34334 = arguments.length;
var i__7485__auto___34335 = (0);
while(true){
if((i__7485__auto___34335 < len__7484__auto___34334)){
args34331.push((arguments[i__7485__auto___34335]));

var G__34336 = (i__7485__auto___34335 + (1));
i__7485__auto___34335 = G__34336;
continue;
} else {
}
break;
}

var G__34333 = args34331.length;
switch (G__34333) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34331.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__7072__auto__ = (((m == null))?null:m);
var m__7073__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return (m__7073__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7073__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__7073__auto__.call(null,m,ch));
} else {
var m__7073__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return (m__7073__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7073__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__7073__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__7072__auto__ = (((m == null))?null:m);
var m__7073__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return (m__7073__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7073__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__7073__auto__.call(null,m,ch));
} else {
var m__7073__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return (m__7073__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7073__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__7073__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__7072__auto__ = (((m == null))?null:m);
var m__7073__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return (m__7073__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7073__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__7073__auto__.call(null,m));
} else {
var m__7073__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return (m__7073__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7073__auto____$1.cljs$core$IFn$_invoke$arity$1(m) : m__7073__auto____$1.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__7072__auto__ = (((m == null))?null:m);
var m__7073__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return (m__7073__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7073__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__7073__auto__.call(null,m,state_map));
} else {
var m__7073__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return (m__7073__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7073__auto____$1.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__7073__auto____$1.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__7072__auto__ = (((m == null))?null:m);
var m__7073__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return (m__7073__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7073__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__7073__auto__.call(null,m,mode));
} else {
var m__7073__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return (m__7073__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7073__auto____$1.cljs$core$IFn$_invoke$arity$2(m,mode) : m__7073__auto____$1.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__7491__auto__ = [];
var len__7484__auto___34348 = arguments.length;
var i__7485__auto___34349 = (0);
while(true){
if((i__7485__auto___34349 < len__7484__auto___34348)){
args__7491__auto__.push((arguments[i__7485__auto___34349]));

var G__34350 = (i__7485__auto___34349 + (1));
i__7485__auto___34349 = G__34350;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((3) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7492__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__34342){
var map__34343 = p__34342;
var map__34343__$1 = ((((!((map__34343 == null)))?((((map__34343.cljs$lang$protocol_mask$partition0$ & (64))) || (map__34343.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__34343):map__34343);
var opts = map__34343__$1;
var statearr_34345_34351 = state;
(statearr_34345_34351[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__4657__auto__ = cljs.core.async.do_alts(((function (map__34343,map__34343__$1,opts){
return (function (val){
var statearr_34346_34352 = state;
(statearr_34346_34352[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
});})(map__34343,map__34343__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4657__auto__)){
var cb = temp__4657__auto__;
var statearr_34347_34353 = state;
(statearr_34347_34353[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cb) : cljs.core.deref.call(null,cb)));


return cljs.core.cst$kw$recur;
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq34338){
var G__34339 = cljs.core.first(seq34338);
var seq34338__$1 = cljs.core.next(seq34338);
var G__34340 = cljs.core.first(seq34338__$1);
var seq34338__$2 = cljs.core.next(seq34338__$1);
var G__34341 = cljs.core.first(seq34338__$2);
var seq34338__$3 = cljs.core.next(seq34338__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__34339,G__34340,G__34341,seq34338__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = (function (){var G__34523 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__34523) : cljs.core.atom.call(null,G__34523));
})();
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$pause,null,cljs.core.cst$kw$mute,null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,cljs.core.cst$kw$solo);
var solo_mode = (function (){var G__34524 = cljs.core.cst$kw$mute;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__34524) : cljs.core.atom.call(null,G__34524));
})();
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv(((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cs) : cljs.core.deref.call(null,cs));
var mode = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(solo_mode) : cljs.core.deref.call(null,solo_mode));
var solos = pick(cljs.core.cst$kw$solo,chs);
var pauses = pick(cljs.core.cst$kw$pause,chs);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$solos,solos,cljs.core.cst$kw$mutes,pick(cljs.core.cst$kw$mute,chs),cljs.core.cst$kw$reads,cljs.core.conj.cljs$core$IFn$_invoke$arity$2((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,cljs.core.cst$kw$pause)) && (!(cljs.core.empty_QMARK_(solos))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async34525 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async34525 = (function (change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta34526){
this.change = change;
this.mix = mix;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta34526 = meta34526;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async34525.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_34527,meta34526__$1){
var self__ = this;
var _34527__$1 = this;
return (new cljs.core.async.t_cljs$core$async34525(self__.change,self__.mix,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta34526__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async34525.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_34527){
var self__ = this;
var _34527__$1 = this;
return self__.meta34526;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async34525.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async34525.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async34525.prototype.cljs$core$async$Mix$ = true;

cljs.core.async.t_cljs$core$async34525.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async34525.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async34525.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__34528_34692 = self__.cs;
var G__34529_34693 = cljs.core.PersistentArrayMap.EMPTY;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__34528_34692,G__34529_34693) : cljs.core.reset_BANG_.call(null,G__34528_34692,G__34529_34693));

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async34525.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async34525.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str("(solo-modes mode)")].join('')));
}

(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(self__.solo_mode,mode) : cljs.core.reset_BANG_.call(null,self__.solo_mode,mode));

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async34525.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$change,cljs.core.with_meta(cljs.core.cst$sym$mix,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$out], null))),cljs.core.cst$kw$doc,"Creates and returns a mix of one or more input channels which will\n  be put on the supplied out channel. Input sources can be added to\n  the mix with 'admix', and removed with 'unmix'. A mix supports\n  soloing, muting and pausing multiple inputs atomically using\n  'toggle', and can solo using either muting or pausing as determined\n  by 'solo-mode'.\n\n  Each channel can have zero or more boolean modes set via 'toggle':\n\n  :solo - when true, only this (ond other soloed) channel(s) will appear\n          in the mix output channel. :mute and :pause states of soloed\n          channels are ignored. If solo-mode is :mute, non-soloed\n          channels are muted, if :pause, non-soloed channels are\n          paused.\n\n  :mute - muted channels will have their contents consumed but not included in the mix\n  :pause - paused channels will not have their contents consumed (and thus also not included in the mix)\n"], null)),cljs.core.cst$sym$solo_DASH_mode,cljs.core.cst$sym$pick,cljs.core.cst$sym$cs,cljs.core.cst$sym$calc_DASH_state,cljs.core.cst$sym$out,cljs.core.cst$sym$changed,cljs.core.cst$sym$solo_DASH_modes,cljs.core.cst$sym$attrs,cljs.core.cst$sym$meta34526], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async34525.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async34525.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async34525";

cljs.core.async.t_cljs$core$async34525.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"cljs.core.async/t_cljs$core$async34525");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async34525 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async34525(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta34526){
return (new cljs.core.async.t_cljs$core$async34525(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta34526));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async34525(change,cljs$core$async$mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__12309__auto___34694 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12309__auto___34694,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__12310__auto__ = (function (){var switch__12197__auto__ = ((function (c__12309__auto___34694,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_34629){
var state_val_34630 = (state_34629[(1)]);
if((state_val_34630 === (7))){
var inst_34545 = (state_34629[(2)]);
var state_34629__$1 = state_34629;
var statearr_34631_34695 = state_34629__$1;
(statearr_34631_34695[(2)] = inst_34545);

(statearr_34631_34695[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34630 === (20))){
var inst_34557 = (state_34629[(7)]);
var state_34629__$1 = state_34629;
var statearr_34632_34696 = state_34629__$1;
(statearr_34632_34696[(2)] = inst_34557);

(statearr_34632_34696[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34630 === (27))){
var state_34629__$1 = state_34629;
var statearr_34633_34697 = state_34629__$1;
(statearr_34633_34697[(2)] = null);

(statearr_34633_34697[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34630 === (1))){
var inst_34533 = (state_34629[(8)]);
var inst_34533__$1 = calc_state();
var inst_34535 = (inst_34533__$1 == null);
var inst_34536 = cljs.core.not(inst_34535);
var state_34629__$1 = (function (){var statearr_34634 = state_34629;
(statearr_34634[(8)] = inst_34533__$1);

return statearr_34634;
})();
if(inst_34536){
var statearr_34635_34698 = state_34629__$1;
(statearr_34635_34698[(1)] = (2));

} else {
var statearr_34636_34699 = state_34629__$1;
(statearr_34636_34699[(1)] = (3));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34630 === (24))){
var inst_34603 = (state_34629[(9)]);
var inst_34589 = (state_34629[(10)]);
var inst_34580 = (state_34629[(11)]);
var inst_34603__$1 = (inst_34580.cljs$core$IFn$_invoke$arity$1 ? inst_34580.cljs$core$IFn$_invoke$arity$1(inst_34589) : inst_34580.call(null,inst_34589));
var state_34629__$1 = (function (){var statearr_34637 = state_34629;
(statearr_34637[(9)] = inst_34603__$1);

return statearr_34637;
})();
if(cljs.core.truth_(inst_34603__$1)){
var statearr_34638_34700 = state_34629__$1;
(statearr_34638_34700[(1)] = (29));

} else {
var statearr_34639_34701 = state_34629__$1;
(statearr_34639_34701[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34630 === (4))){
var inst_34548 = (state_34629[(2)]);
var state_34629__$1 = state_34629;
if(cljs.core.truth_(inst_34548)){
var statearr_34640_34702 = state_34629__$1;
(statearr_34640_34702[(1)] = (8));

} else {
var statearr_34641_34703 = state_34629__$1;
(statearr_34641_34703[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34630 === (15))){
var inst_34574 = (state_34629[(2)]);
var state_34629__$1 = state_34629;
if(cljs.core.truth_(inst_34574)){
var statearr_34642_34704 = state_34629__$1;
(statearr_34642_34704[(1)] = (19));

} else {
var statearr_34643_34705 = state_34629__$1;
(statearr_34643_34705[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34630 === (21))){
var inst_34579 = (state_34629[(12)]);
var inst_34579__$1 = (state_34629[(2)]);
var inst_34580 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_34579__$1,cljs.core.cst$kw$solos);
var inst_34581 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_34579__$1,cljs.core.cst$kw$mutes);
var inst_34582 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_34579__$1,cljs.core.cst$kw$reads);
var state_34629__$1 = (function (){var statearr_34644 = state_34629;
(statearr_34644[(12)] = inst_34579__$1);

(statearr_34644[(13)] = inst_34581);

(statearr_34644[(11)] = inst_34580);

return statearr_34644;
})();
return cljs.core.async.ioc_alts_BANG_(state_34629__$1,(22),inst_34582);
} else {
if((state_val_34630 === (31))){
var inst_34611 = (state_34629[(2)]);
var state_34629__$1 = state_34629;
if(cljs.core.truth_(inst_34611)){
var statearr_34645_34706 = state_34629__$1;
(statearr_34645_34706[(1)] = (32));

} else {
var statearr_34646_34707 = state_34629__$1;
(statearr_34646_34707[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34630 === (32))){
var inst_34588 = (state_34629[(14)]);
var state_34629__$1 = state_34629;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_34629__$1,(35),out,inst_34588);
} else {
if((state_val_34630 === (33))){
var inst_34579 = (state_34629[(12)]);
var inst_34557 = inst_34579;
var state_34629__$1 = (function (){var statearr_34647 = state_34629;
(statearr_34647[(7)] = inst_34557);

return statearr_34647;
})();
var statearr_34648_34708 = state_34629__$1;
(statearr_34648_34708[(2)] = null);

(statearr_34648_34708[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34630 === (13))){
var inst_34557 = (state_34629[(7)]);
var inst_34564 = inst_34557.cljs$lang$protocol_mask$partition0$;
var inst_34565 = (inst_34564 & (64));
var inst_34566 = inst_34557.cljs$core$ISeq$;
var inst_34567 = (inst_34565) || (inst_34566);
var state_34629__$1 = state_34629;
if(cljs.core.truth_(inst_34567)){
var statearr_34649_34709 = state_34629__$1;
(statearr_34649_34709[(1)] = (16));

} else {
var statearr_34650_34710 = state_34629__$1;
(statearr_34650_34710[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34630 === (22))){
var inst_34588 = (state_34629[(14)]);
var inst_34589 = (state_34629[(10)]);
var inst_34587 = (state_34629[(2)]);
var inst_34588__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_34587,(0),null);
var inst_34589__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_34587,(1),null);
var inst_34590 = (inst_34588__$1 == null);
var inst_34591 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_34589__$1,change);
var inst_34592 = (inst_34590) || (inst_34591);
var state_34629__$1 = (function (){var statearr_34651 = state_34629;
(statearr_34651[(14)] = inst_34588__$1);

(statearr_34651[(10)] = inst_34589__$1);

return statearr_34651;
})();
if(cljs.core.truth_(inst_34592)){
var statearr_34652_34711 = state_34629__$1;
(statearr_34652_34711[(1)] = (23));

} else {
var statearr_34653_34712 = state_34629__$1;
(statearr_34653_34712[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34630 === (36))){
var inst_34579 = (state_34629[(12)]);
var inst_34557 = inst_34579;
var state_34629__$1 = (function (){var statearr_34654 = state_34629;
(statearr_34654[(7)] = inst_34557);

return statearr_34654;
})();
var statearr_34655_34713 = state_34629__$1;
(statearr_34655_34713[(2)] = null);

(statearr_34655_34713[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34630 === (29))){
var inst_34603 = (state_34629[(9)]);
var state_34629__$1 = state_34629;
var statearr_34656_34714 = state_34629__$1;
(statearr_34656_34714[(2)] = inst_34603);

(statearr_34656_34714[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34630 === (6))){
var state_34629__$1 = state_34629;
var statearr_34657_34715 = state_34629__$1;
(statearr_34657_34715[(2)] = false);

(statearr_34657_34715[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34630 === (28))){
var inst_34599 = (state_34629[(2)]);
var inst_34600 = calc_state();
var inst_34557 = inst_34600;
var state_34629__$1 = (function (){var statearr_34658 = state_34629;
(statearr_34658[(15)] = inst_34599);

(statearr_34658[(7)] = inst_34557);

return statearr_34658;
})();
var statearr_34659_34716 = state_34629__$1;
(statearr_34659_34716[(2)] = null);

(statearr_34659_34716[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34630 === (25))){
var inst_34625 = (state_34629[(2)]);
var state_34629__$1 = state_34629;
var statearr_34660_34717 = state_34629__$1;
(statearr_34660_34717[(2)] = inst_34625);

(statearr_34660_34717[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34630 === (34))){
var inst_34623 = (state_34629[(2)]);
var state_34629__$1 = state_34629;
var statearr_34661_34718 = state_34629__$1;
(statearr_34661_34718[(2)] = inst_34623);

(statearr_34661_34718[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34630 === (17))){
var state_34629__$1 = state_34629;
var statearr_34662_34719 = state_34629__$1;
(statearr_34662_34719[(2)] = false);

(statearr_34662_34719[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34630 === (3))){
var state_34629__$1 = state_34629;
var statearr_34663_34720 = state_34629__$1;
(statearr_34663_34720[(2)] = false);

(statearr_34663_34720[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34630 === (12))){
var inst_34627 = (state_34629[(2)]);
var state_34629__$1 = state_34629;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34629__$1,inst_34627);
} else {
if((state_val_34630 === (2))){
var inst_34533 = (state_34629[(8)]);
var inst_34538 = inst_34533.cljs$lang$protocol_mask$partition0$;
var inst_34539 = (inst_34538 & (64));
var inst_34540 = inst_34533.cljs$core$ISeq$;
var inst_34541 = (inst_34539) || (inst_34540);
var state_34629__$1 = state_34629;
if(cljs.core.truth_(inst_34541)){
var statearr_34664_34721 = state_34629__$1;
(statearr_34664_34721[(1)] = (5));

} else {
var statearr_34665_34722 = state_34629__$1;
(statearr_34665_34722[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34630 === (23))){
var inst_34588 = (state_34629[(14)]);
var inst_34594 = (inst_34588 == null);
var state_34629__$1 = state_34629;
if(cljs.core.truth_(inst_34594)){
var statearr_34666_34723 = state_34629__$1;
(statearr_34666_34723[(1)] = (26));

} else {
var statearr_34667_34724 = state_34629__$1;
(statearr_34667_34724[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34630 === (35))){
var inst_34614 = (state_34629[(2)]);
var state_34629__$1 = state_34629;
if(cljs.core.truth_(inst_34614)){
var statearr_34668_34725 = state_34629__$1;
(statearr_34668_34725[(1)] = (36));

} else {
var statearr_34669_34726 = state_34629__$1;
(statearr_34669_34726[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34630 === (19))){
var inst_34557 = (state_34629[(7)]);
var inst_34576 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_34557);
var state_34629__$1 = state_34629;
var statearr_34670_34727 = state_34629__$1;
(statearr_34670_34727[(2)] = inst_34576);

(statearr_34670_34727[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34630 === (11))){
var inst_34557 = (state_34629[(7)]);
var inst_34561 = (inst_34557 == null);
var inst_34562 = cljs.core.not(inst_34561);
var state_34629__$1 = state_34629;
if(inst_34562){
var statearr_34671_34728 = state_34629__$1;
(statearr_34671_34728[(1)] = (13));

} else {
var statearr_34672_34729 = state_34629__$1;
(statearr_34672_34729[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34630 === (9))){
var inst_34533 = (state_34629[(8)]);
var state_34629__$1 = state_34629;
var statearr_34673_34730 = state_34629__$1;
(statearr_34673_34730[(2)] = inst_34533);

(statearr_34673_34730[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34630 === (5))){
var state_34629__$1 = state_34629;
var statearr_34674_34731 = state_34629__$1;
(statearr_34674_34731[(2)] = true);

(statearr_34674_34731[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34630 === (14))){
var state_34629__$1 = state_34629;
var statearr_34675_34732 = state_34629__$1;
(statearr_34675_34732[(2)] = false);

(statearr_34675_34732[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34630 === (26))){
var inst_34589 = (state_34629[(10)]);
var inst_34596 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_34589);
var state_34629__$1 = state_34629;
var statearr_34676_34733 = state_34629__$1;
(statearr_34676_34733[(2)] = inst_34596);

(statearr_34676_34733[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34630 === (16))){
var state_34629__$1 = state_34629;
var statearr_34677_34734 = state_34629__$1;
(statearr_34677_34734[(2)] = true);

(statearr_34677_34734[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34630 === (38))){
var inst_34619 = (state_34629[(2)]);
var state_34629__$1 = state_34629;
var statearr_34678_34735 = state_34629__$1;
(statearr_34678_34735[(2)] = inst_34619);

(statearr_34678_34735[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34630 === (30))){
var inst_34589 = (state_34629[(10)]);
var inst_34581 = (state_34629[(13)]);
var inst_34580 = (state_34629[(11)]);
var inst_34606 = cljs.core.empty_QMARK_(inst_34580);
var inst_34607 = (inst_34581.cljs$core$IFn$_invoke$arity$1 ? inst_34581.cljs$core$IFn$_invoke$arity$1(inst_34589) : inst_34581.call(null,inst_34589));
var inst_34608 = cljs.core.not(inst_34607);
var inst_34609 = (inst_34606) && (inst_34608);
var state_34629__$1 = state_34629;
var statearr_34679_34736 = state_34629__$1;
(statearr_34679_34736[(2)] = inst_34609);

(statearr_34679_34736[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34630 === (10))){
var inst_34533 = (state_34629[(8)]);
var inst_34553 = (state_34629[(2)]);
var inst_34554 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_34553,cljs.core.cst$kw$solos);
var inst_34555 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_34553,cljs.core.cst$kw$mutes);
var inst_34556 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_34553,cljs.core.cst$kw$reads);
var inst_34557 = inst_34533;
var state_34629__$1 = (function (){var statearr_34680 = state_34629;
(statearr_34680[(16)] = inst_34554);

(statearr_34680[(17)] = inst_34555);

(statearr_34680[(18)] = inst_34556);

(statearr_34680[(7)] = inst_34557);

return statearr_34680;
})();
var statearr_34681_34737 = state_34629__$1;
(statearr_34681_34737[(2)] = null);

(statearr_34681_34737[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34630 === (18))){
var inst_34571 = (state_34629[(2)]);
var state_34629__$1 = state_34629;
var statearr_34682_34738 = state_34629__$1;
(statearr_34682_34738[(2)] = inst_34571);

(statearr_34682_34738[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34630 === (37))){
var state_34629__$1 = state_34629;
var statearr_34683_34739 = state_34629__$1;
(statearr_34683_34739[(2)] = null);

(statearr_34683_34739[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34630 === (8))){
var inst_34533 = (state_34629[(8)]);
var inst_34550 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_34533);
var state_34629__$1 = state_34629;
var statearr_34684_34740 = state_34629__$1;
(statearr_34684_34740[(2)] = inst_34550);

(statearr_34684_34740[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12309__auto___34694,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__12197__auto__,c__12309__auto___34694,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__12198__auto__ = null;
var cljs$core$async$mix_$_state_machine__12198__auto____0 = (function (){
var statearr_34688 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_34688[(0)] = cljs$core$async$mix_$_state_machine__12198__auto__);

(statearr_34688[(1)] = (1));

return statearr_34688;
});
var cljs$core$async$mix_$_state_machine__12198__auto____1 = (function (state_34629){
while(true){
var ret_value__12199__auto__ = (function (){try{while(true){
var result__12200__auto__ = switch__12197__auto__(state_34629);
if(cljs.core.keyword_identical_QMARK_(result__12200__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12200__auto__;
}
break;
}
}catch (e34689){if((e34689 instanceof Object)){
var ex__12201__auto__ = e34689;
var statearr_34690_34741 = state_34629;
(statearr_34690_34741[(5)] = ex__12201__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_34629);

return cljs.core.cst$kw$recur;
} else {
throw e34689;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12199__auto__,cljs.core.cst$kw$recur)){
var G__34742 = state_34629;
state_34629 = G__34742;
continue;
} else {
return ret_value__12199__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__12198__auto__ = function(state_34629){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__12198__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__12198__auto____1.call(this,state_34629);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__12198__auto____0;
cljs$core$async$mix_$_state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__12198__auto____1;
return cljs$core$async$mix_$_state_machine__12198__auto__;
})()
;})(switch__12197__auto__,c__12309__auto___34694,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__12311__auto__ = (function (){var statearr_34691 = (f__12310__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12310__auto__.cljs$core$IFn$_invoke$arity$0() : f__12310__auto__.call(null));
(statearr_34691[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12309__auto___34694);

return statearr_34691;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12311__auto__);
});})(c__12309__auto___34694,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__7072__auto__ = (((p == null))?null:p);
var m__7073__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return (m__7073__auto__.cljs$core$IFn$_invoke$arity$4 ? m__7073__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__7073__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__7073__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return (m__7073__auto____$1.cljs$core$IFn$_invoke$arity$4 ? m__7073__auto____$1.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__7073__auto____$1.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__7072__auto__ = (((p == null))?null:p);
var m__7073__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return (m__7073__auto__.cljs$core$IFn$_invoke$arity$3 ? m__7073__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__7073__auto__.call(null,p,v,ch));
} else {
var m__7073__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return (m__7073__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__7073__auto____$1.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__7073__auto____$1.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args34743 = [];
var len__7484__auto___34746 = arguments.length;
var i__7485__auto___34747 = (0);
while(true){
if((i__7485__auto___34747 < len__7484__auto___34746)){
args34743.push((arguments[i__7485__auto___34747]));

var G__34748 = (i__7485__auto___34747 + (1));
i__7485__auto___34747 = G__34748;
continue;
} else {
}
break;
}

var G__34745 = args34743.length;
switch (G__34745) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34743.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__7072__auto__ = (((p == null))?null:p);
var m__7073__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return (m__7073__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7073__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__7073__auto__.call(null,p));
} else {
var m__7073__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return (m__7073__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7073__auto____$1.cljs$core$IFn$_invoke$arity$1(p) : m__7073__auto____$1.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__7072__auto__ = (((p == null))?null:p);
var m__7073__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return (m__7073__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7073__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__7073__auto__.call(null,p,v));
} else {
var m__7073__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return (m__7073__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7073__auto____$1.cljs$core$IFn$_invoke$arity$2(p,v) : m__7073__auto____$1.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args34751 = [];
var len__7484__auto___34879 = arguments.length;
var i__7485__auto___34880 = (0);
while(true){
if((i__7485__auto___34880 < len__7484__auto___34879)){
args34751.push((arguments[i__7485__auto___34880]));

var G__34881 = (i__7485__auto___34880 + (1));
i__7485__auto___34880 = G__34881;
continue;
} else {
}
break;
}

var G__34753 = args34751.length;
switch (G__34753) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34751.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = (function (){var G__34754 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__34754) : cljs.core.atom.call(null,G__34754));
})();
var ensure_mult = ((function (mults){
return (function (topic){
var or__6409__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(mults) : cljs.core.deref.call(null,mults)),topic);
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,((function (or__6409__auto__,mults){
return (function (p1__34750_SHARP_){
if(cljs.core.truth_((p1__34750_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__34750_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__34750_SHARP_.call(null,topic)))){
return p1__34750_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__34750_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
});})(or__6409__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async34755 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async34755 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta34756){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta34756 = meta34756;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async34755.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_34757,meta34756__$1){
var self__ = this;
var _34757__$1 = this;
return (new cljs.core.async.t_cljs$core$async34755(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta34756__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async34755.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_34757){
var self__ = this;
var _34757__$1 = this;
return self__.meta34756;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async34755.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async34755.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async34755.prototype.cljs$core$async$Pub$ = true;

cljs.core.async.t_cljs$core$async34755.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async34755.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4657__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(self__.mults) : cljs.core.deref.call(null,self__.mults)),topic);
if(cljs.core.truth_(temp__4657__auto__)){
var m = temp__4657__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async34755.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__34758 = self__.mults;
var G__34759 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__34758,G__34759) : cljs.core.reset_BANG_.call(null,G__34758,G__34759));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async34755.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async34755.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ch,cljs.core.cst$sym$topic_DASH_fn,cljs.core.cst$sym$buf_DASH_fn,cljs.core.cst$sym$mults,cljs.core.cst$sym$ensure_DASH_mult,cljs.core.cst$sym$meta34756], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async34755.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async34755.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async34755";

cljs.core.async.t_cljs$core$async34755.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"cljs.core.async/t_cljs$core$async34755");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async34755 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async34755(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta34756){
return (new cljs.core.async.t_cljs$core$async34755(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta34756));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async34755(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__12309__auto___34883 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12309__auto___34883,mults,ensure_mult,p){
return (function (){
var f__12310__auto__ = (function (){var switch__12197__auto__ = ((function (c__12309__auto___34883,mults,ensure_mult,p){
return (function (state_34831){
var state_val_34832 = (state_34831[(1)]);
if((state_val_34832 === (7))){
var inst_34827 = (state_34831[(2)]);
var state_34831__$1 = state_34831;
var statearr_34833_34884 = state_34831__$1;
(statearr_34833_34884[(2)] = inst_34827);

(statearr_34833_34884[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34832 === (20))){
var state_34831__$1 = state_34831;
var statearr_34834_34885 = state_34831__$1;
(statearr_34834_34885[(2)] = null);

(statearr_34834_34885[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34832 === (1))){
var state_34831__$1 = state_34831;
var statearr_34835_34886 = state_34831__$1;
(statearr_34835_34886[(2)] = null);

(statearr_34835_34886[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34832 === (24))){
var inst_34810 = (state_34831[(7)]);
var inst_34819 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_34810);
var state_34831__$1 = state_34831;
var statearr_34836_34887 = state_34831__$1;
(statearr_34836_34887[(2)] = inst_34819);

(statearr_34836_34887[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34832 === (4))){
var inst_34762 = (state_34831[(8)]);
var inst_34762__$1 = (state_34831[(2)]);
var inst_34763 = (inst_34762__$1 == null);
var state_34831__$1 = (function (){var statearr_34837 = state_34831;
(statearr_34837[(8)] = inst_34762__$1);

return statearr_34837;
})();
if(cljs.core.truth_(inst_34763)){
var statearr_34838_34888 = state_34831__$1;
(statearr_34838_34888[(1)] = (5));

} else {
var statearr_34839_34889 = state_34831__$1;
(statearr_34839_34889[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34832 === (15))){
var inst_34804 = (state_34831[(2)]);
var state_34831__$1 = state_34831;
var statearr_34840_34890 = state_34831__$1;
(statearr_34840_34890[(2)] = inst_34804);

(statearr_34840_34890[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34832 === (21))){
var inst_34824 = (state_34831[(2)]);
var state_34831__$1 = (function (){var statearr_34841 = state_34831;
(statearr_34841[(9)] = inst_34824);

return statearr_34841;
})();
var statearr_34842_34891 = state_34831__$1;
(statearr_34842_34891[(2)] = null);

(statearr_34842_34891[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34832 === (13))){
var inst_34786 = (state_34831[(10)]);
var inst_34788 = cljs.core.chunked_seq_QMARK_(inst_34786);
var state_34831__$1 = state_34831;
if(inst_34788){
var statearr_34843_34892 = state_34831__$1;
(statearr_34843_34892[(1)] = (16));

} else {
var statearr_34844_34893 = state_34831__$1;
(statearr_34844_34893[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34832 === (22))){
var inst_34816 = (state_34831[(2)]);
var state_34831__$1 = state_34831;
if(cljs.core.truth_(inst_34816)){
var statearr_34845_34894 = state_34831__$1;
(statearr_34845_34894[(1)] = (23));

} else {
var statearr_34846_34895 = state_34831__$1;
(statearr_34846_34895[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34832 === (6))){
var inst_34810 = (state_34831[(7)]);
var inst_34812 = (state_34831[(11)]);
var inst_34762 = (state_34831[(8)]);
var inst_34810__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_34762) : topic_fn.call(null,inst_34762));
var inst_34811 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(mults) : cljs.core.deref.call(null,mults));
var inst_34812__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_34811,inst_34810__$1);
var state_34831__$1 = (function (){var statearr_34847 = state_34831;
(statearr_34847[(7)] = inst_34810__$1);

(statearr_34847[(11)] = inst_34812__$1);

return statearr_34847;
})();
if(cljs.core.truth_(inst_34812__$1)){
var statearr_34848_34896 = state_34831__$1;
(statearr_34848_34896[(1)] = (19));

} else {
var statearr_34849_34897 = state_34831__$1;
(statearr_34849_34897[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34832 === (25))){
var inst_34821 = (state_34831[(2)]);
var state_34831__$1 = state_34831;
var statearr_34850_34898 = state_34831__$1;
(statearr_34850_34898[(2)] = inst_34821);

(statearr_34850_34898[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34832 === (17))){
var inst_34786 = (state_34831[(10)]);
var inst_34795 = cljs.core.first(inst_34786);
var inst_34796 = cljs.core.async.muxch_STAR_(inst_34795);
var inst_34797 = cljs.core.async.close_BANG_(inst_34796);
var inst_34798 = cljs.core.next(inst_34786);
var inst_34772 = inst_34798;
var inst_34773 = null;
var inst_34774 = (0);
var inst_34775 = (0);
var state_34831__$1 = (function (){var statearr_34851 = state_34831;
(statearr_34851[(12)] = inst_34773);

(statearr_34851[(13)] = inst_34775);

(statearr_34851[(14)] = inst_34772);

(statearr_34851[(15)] = inst_34797);

(statearr_34851[(16)] = inst_34774);

return statearr_34851;
})();
var statearr_34852_34899 = state_34831__$1;
(statearr_34852_34899[(2)] = null);

(statearr_34852_34899[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34832 === (3))){
var inst_34829 = (state_34831[(2)]);
var state_34831__$1 = state_34831;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34831__$1,inst_34829);
} else {
if((state_val_34832 === (12))){
var inst_34806 = (state_34831[(2)]);
var state_34831__$1 = state_34831;
var statearr_34853_34900 = state_34831__$1;
(statearr_34853_34900[(2)] = inst_34806);

(statearr_34853_34900[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34832 === (2))){
var state_34831__$1 = state_34831;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34831__$1,(4),ch);
} else {
if((state_val_34832 === (23))){
var state_34831__$1 = state_34831;
var statearr_34854_34901 = state_34831__$1;
(statearr_34854_34901[(2)] = null);

(statearr_34854_34901[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34832 === (19))){
var inst_34812 = (state_34831[(11)]);
var inst_34762 = (state_34831[(8)]);
var inst_34814 = cljs.core.async.muxch_STAR_(inst_34812);
var state_34831__$1 = state_34831;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_34831__$1,(22),inst_34814,inst_34762);
} else {
if((state_val_34832 === (11))){
var inst_34772 = (state_34831[(14)]);
var inst_34786 = (state_34831[(10)]);
var inst_34786__$1 = cljs.core.seq(inst_34772);
var state_34831__$1 = (function (){var statearr_34855 = state_34831;
(statearr_34855[(10)] = inst_34786__$1);

return statearr_34855;
})();
if(inst_34786__$1){
var statearr_34856_34902 = state_34831__$1;
(statearr_34856_34902[(1)] = (13));

} else {
var statearr_34857_34903 = state_34831__$1;
(statearr_34857_34903[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34832 === (9))){
var inst_34808 = (state_34831[(2)]);
var state_34831__$1 = state_34831;
var statearr_34858_34904 = state_34831__$1;
(statearr_34858_34904[(2)] = inst_34808);

(statearr_34858_34904[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34832 === (5))){
var inst_34769 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(mults) : cljs.core.deref.call(null,mults));
var inst_34770 = cljs.core.vals(inst_34769);
var inst_34771 = cljs.core.seq(inst_34770);
var inst_34772 = inst_34771;
var inst_34773 = null;
var inst_34774 = (0);
var inst_34775 = (0);
var state_34831__$1 = (function (){var statearr_34859 = state_34831;
(statearr_34859[(12)] = inst_34773);

(statearr_34859[(13)] = inst_34775);

(statearr_34859[(14)] = inst_34772);

(statearr_34859[(16)] = inst_34774);

return statearr_34859;
})();
var statearr_34860_34905 = state_34831__$1;
(statearr_34860_34905[(2)] = null);

(statearr_34860_34905[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34832 === (14))){
var state_34831__$1 = state_34831;
var statearr_34864_34906 = state_34831__$1;
(statearr_34864_34906[(2)] = null);

(statearr_34864_34906[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34832 === (16))){
var inst_34786 = (state_34831[(10)]);
var inst_34790 = cljs.core.chunk_first(inst_34786);
var inst_34791 = cljs.core.chunk_rest(inst_34786);
var inst_34792 = cljs.core.count(inst_34790);
var inst_34772 = inst_34791;
var inst_34773 = inst_34790;
var inst_34774 = inst_34792;
var inst_34775 = (0);
var state_34831__$1 = (function (){var statearr_34865 = state_34831;
(statearr_34865[(12)] = inst_34773);

(statearr_34865[(13)] = inst_34775);

(statearr_34865[(14)] = inst_34772);

(statearr_34865[(16)] = inst_34774);

return statearr_34865;
})();
var statearr_34866_34907 = state_34831__$1;
(statearr_34866_34907[(2)] = null);

(statearr_34866_34907[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34832 === (10))){
var inst_34773 = (state_34831[(12)]);
var inst_34775 = (state_34831[(13)]);
var inst_34772 = (state_34831[(14)]);
var inst_34774 = (state_34831[(16)]);
var inst_34780 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_34773,inst_34775);
var inst_34781 = cljs.core.async.muxch_STAR_(inst_34780);
var inst_34782 = cljs.core.async.close_BANG_(inst_34781);
var inst_34783 = (inst_34775 + (1));
var tmp34861 = inst_34773;
var tmp34862 = inst_34772;
var tmp34863 = inst_34774;
var inst_34772__$1 = tmp34862;
var inst_34773__$1 = tmp34861;
var inst_34774__$1 = tmp34863;
var inst_34775__$1 = inst_34783;
var state_34831__$1 = (function (){var statearr_34867 = state_34831;
(statearr_34867[(12)] = inst_34773__$1);

(statearr_34867[(13)] = inst_34775__$1);

(statearr_34867[(14)] = inst_34772__$1);

(statearr_34867[(17)] = inst_34782);

(statearr_34867[(16)] = inst_34774__$1);

return statearr_34867;
})();
var statearr_34868_34908 = state_34831__$1;
(statearr_34868_34908[(2)] = null);

(statearr_34868_34908[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34832 === (18))){
var inst_34801 = (state_34831[(2)]);
var state_34831__$1 = state_34831;
var statearr_34869_34909 = state_34831__$1;
(statearr_34869_34909[(2)] = inst_34801);

(statearr_34869_34909[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34832 === (8))){
var inst_34775 = (state_34831[(13)]);
var inst_34774 = (state_34831[(16)]);
var inst_34777 = (inst_34775 < inst_34774);
var inst_34778 = inst_34777;
var state_34831__$1 = state_34831;
if(cljs.core.truth_(inst_34778)){
var statearr_34870_34910 = state_34831__$1;
(statearr_34870_34910[(1)] = (10));

} else {
var statearr_34871_34911 = state_34831__$1;
(statearr_34871_34911[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12309__auto___34883,mults,ensure_mult,p))
;
return ((function (switch__12197__auto__,c__12309__auto___34883,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__12198__auto__ = null;
var cljs$core$async$state_machine__12198__auto____0 = (function (){
var statearr_34875 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_34875[(0)] = cljs$core$async$state_machine__12198__auto__);

(statearr_34875[(1)] = (1));

return statearr_34875;
});
var cljs$core$async$state_machine__12198__auto____1 = (function (state_34831){
while(true){
var ret_value__12199__auto__ = (function (){try{while(true){
var result__12200__auto__ = switch__12197__auto__(state_34831);
if(cljs.core.keyword_identical_QMARK_(result__12200__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12200__auto__;
}
break;
}
}catch (e34876){if((e34876 instanceof Object)){
var ex__12201__auto__ = e34876;
var statearr_34877_34912 = state_34831;
(statearr_34877_34912[(5)] = ex__12201__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_34831);

return cljs.core.cst$kw$recur;
} else {
throw e34876;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12199__auto__,cljs.core.cst$kw$recur)){
var G__34913 = state_34831;
state_34831 = G__34913;
continue;
} else {
return ret_value__12199__auto__;
}
break;
}
});
cljs$core$async$state_machine__12198__auto__ = function(state_34831){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12198__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12198__auto____1.call(this,state_34831);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12198__auto____0;
cljs$core$async$state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12198__auto____1;
return cljs$core$async$state_machine__12198__auto__;
})()
;})(switch__12197__auto__,c__12309__auto___34883,mults,ensure_mult,p))
})();
var state__12311__auto__ = (function (){var statearr_34878 = (f__12310__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12310__auto__.cljs$core$IFn$_invoke$arity$0() : f__12310__auto__.call(null));
(statearr_34878[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12309__auto___34883);

return statearr_34878;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12311__auto__);
});})(c__12309__auto___34883,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args34914 = [];
var len__7484__auto___34917 = arguments.length;
var i__7485__auto___34918 = (0);
while(true){
if((i__7485__auto___34918 < len__7484__auto___34917)){
args34914.push((arguments[i__7485__auto___34918]));

var G__34919 = (i__7485__auto___34918 + (1));
i__7485__auto___34918 = G__34919;
continue;
} else {
}
break;
}

var G__34916 = args34914.length;
switch (G__34916) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34914.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args34921 = [];
var len__7484__auto___34924 = arguments.length;
var i__7485__auto___34925 = (0);
while(true){
if((i__7485__auto___34925 < len__7484__auto___34924)){
args34921.push((arguments[i__7485__auto___34925]));

var G__34926 = (i__7485__auto___34925 + (1));
i__7485__auto___34925 = G__34926;
continue;
} else {
}
break;
}

var G__34923 = args34921.length;
switch (G__34923) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34921.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1(p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2(p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args34928 = [];
var len__7484__auto___34999 = arguments.length;
var i__7485__auto___35000 = (0);
while(true){
if((i__7485__auto___35000 < len__7484__auto___34999)){
args34928.push((arguments[i__7485__auto___35000]));

var G__35001 = (i__7485__auto___35000 + (1));
i__7485__auto___35000 = G__35001;
continue;
} else {
}
break;
}

var G__34930 = args34928.length;
switch (G__34930) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34928.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null) : cljs.core.atom.call(null,null));
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
var c__12309__auto___35003 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12309__auto___35003,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__12310__auto__ = (function (){var switch__12197__auto__ = ((function (c__12309__auto___35003,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_34969){
var state_val_34970 = (state_34969[(1)]);
if((state_val_34970 === (7))){
var state_34969__$1 = state_34969;
var statearr_34971_35004 = state_34969__$1;
(statearr_34971_35004[(2)] = null);

(statearr_34971_35004[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34970 === (1))){
var state_34969__$1 = state_34969;
var statearr_34972_35005 = state_34969__$1;
(statearr_34972_35005[(2)] = null);

(statearr_34972_35005[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34970 === (4))){
var inst_34933 = (state_34969[(7)]);
var inst_34935 = (inst_34933 < cnt);
var state_34969__$1 = state_34969;
if(cljs.core.truth_(inst_34935)){
var statearr_34973_35006 = state_34969__$1;
(statearr_34973_35006[(1)] = (6));

} else {
var statearr_34974_35007 = state_34969__$1;
(statearr_34974_35007[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34970 === (15))){
var inst_34965 = (state_34969[(2)]);
var state_34969__$1 = state_34969;
var statearr_34975_35008 = state_34969__$1;
(statearr_34975_35008[(2)] = inst_34965);

(statearr_34975_35008[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34970 === (13))){
var inst_34958 = cljs.core.async.close_BANG_(out);
var state_34969__$1 = state_34969;
var statearr_34976_35009 = state_34969__$1;
(statearr_34976_35009[(2)] = inst_34958);

(statearr_34976_35009[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34970 === (6))){
var state_34969__$1 = state_34969;
var statearr_34977_35010 = state_34969__$1;
(statearr_34977_35010[(2)] = null);

(statearr_34977_35010[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34970 === (3))){
var inst_34967 = (state_34969[(2)]);
var state_34969__$1 = state_34969;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34969__$1,inst_34967);
} else {
if((state_val_34970 === (12))){
var inst_34955 = (state_34969[(8)]);
var inst_34955__$1 = (state_34969[(2)]);
var inst_34956 = cljs.core.some(cljs.core.nil_QMARK_,inst_34955__$1);
var state_34969__$1 = (function (){var statearr_34978 = state_34969;
(statearr_34978[(8)] = inst_34955__$1);

return statearr_34978;
})();
if(cljs.core.truth_(inst_34956)){
var statearr_34979_35011 = state_34969__$1;
(statearr_34979_35011[(1)] = (13));

} else {
var statearr_34980_35012 = state_34969__$1;
(statearr_34980_35012[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34970 === (2))){
var inst_34932 = (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cnt) : cljs.core.reset_BANG_.call(null,dctr,cnt));
var inst_34933 = (0);
var state_34969__$1 = (function (){var statearr_34981 = state_34969;
(statearr_34981[(7)] = inst_34933);

(statearr_34981[(9)] = inst_34932);

return statearr_34981;
})();
var statearr_34982_35013 = state_34969__$1;
(statearr_34982_35013[(2)] = null);

(statearr_34982_35013[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34970 === (11))){
var inst_34933 = (state_34969[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_34969,(10),Object,null,(9));
var inst_34942 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_34933) : chs__$1.call(null,inst_34933));
var inst_34943 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_34933) : done.call(null,inst_34933));
var inst_34944 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_34942,inst_34943);
var state_34969__$1 = state_34969;
var statearr_34983_35014 = state_34969__$1;
(statearr_34983_35014[(2)] = inst_34944);


cljs.core.async.impl.ioc_helpers.process_exception(state_34969__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_34970 === (9))){
var inst_34933 = (state_34969[(7)]);
var inst_34946 = (state_34969[(2)]);
var inst_34947 = (inst_34933 + (1));
var inst_34933__$1 = inst_34947;
var state_34969__$1 = (function (){var statearr_34984 = state_34969;
(statearr_34984[(10)] = inst_34946);

(statearr_34984[(7)] = inst_34933__$1);

return statearr_34984;
})();
var statearr_34985_35015 = state_34969__$1;
(statearr_34985_35015[(2)] = null);

(statearr_34985_35015[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34970 === (5))){
var inst_34953 = (state_34969[(2)]);
var state_34969__$1 = (function (){var statearr_34986 = state_34969;
(statearr_34986[(11)] = inst_34953);

return statearr_34986;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34969__$1,(12),dchan);
} else {
if((state_val_34970 === (14))){
var inst_34955 = (state_34969[(8)]);
var inst_34960 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_34955);
var state_34969__$1 = state_34969;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_34969__$1,(16),out,inst_34960);
} else {
if((state_val_34970 === (16))){
var inst_34962 = (state_34969[(2)]);
var state_34969__$1 = (function (){var statearr_34987 = state_34969;
(statearr_34987[(12)] = inst_34962);

return statearr_34987;
})();
var statearr_34988_35016 = state_34969__$1;
(statearr_34988_35016[(2)] = null);

(statearr_34988_35016[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34970 === (10))){
var inst_34937 = (state_34969[(2)]);
var inst_34938 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_34969__$1 = (function (){var statearr_34989 = state_34969;
(statearr_34989[(13)] = inst_34937);

return statearr_34989;
})();
var statearr_34990_35017 = state_34969__$1;
(statearr_34990_35017[(2)] = inst_34938);


cljs.core.async.impl.ioc_helpers.process_exception(state_34969__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_34970 === (8))){
var inst_34951 = (state_34969[(2)]);
var state_34969__$1 = state_34969;
var statearr_34991_35018 = state_34969__$1;
(statearr_34991_35018[(2)] = inst_34951);

(statearr_34991_35018[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12309__auto___35003,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__12197__auto__,c__12309__auto___35003,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__12198__auto__ = null;
var cljs$core$async$state_machine__12198__auto____0 = (function (){
var statearr_34995 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_34995[(0)] = cljs$core$async$state_machine__12198__auto__);

(statearr_34995[(1)] = (1));

return statearr_34995;
});
var cljs$core$async$state_machine__12198__auto____1 = (function (state_34969){
while(true){
var ret_value__12199__auto__ = (function (){try{while(true){
var result__12200__auto__ = switch__12197__auto__(state_34969);
if(cljs.core.keyword_identical_QMARK_(result__12200__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12200__auto__;
}
break;
}
}catch (e34996){if((e34996 instanceof Object)){
var ex__12201__auto__ = e34996;
var statearr_34997_35019 = state_34969;
(statearr_34997_35019[(5)] = ex__12201__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_34969);

return cljs.core.cst$kw$recur;
} else {
throw e34996;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12199__auto__,cljs.core.cst$kw$recur)){
var G__35020 = state_34969;
state_34969 = G__35020;
continue;
} else {
return ret_value__12199__auto__;
}
break;
}
});
cljs$core$async$state_machine__12198__auto__ = function(state_34969){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12198__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12198__auto____1.call(this,state_34969);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12198__auto____0;
cljs$core$async$state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12198__auto____1;
return cljs$core$async$state_machine__12198__auto__;
})()
;})(switch__12197__auto__,c__12309__auto___35003,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__12311__auto__ = (function (){var statearr_34998 = (f__12310__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12310__auto__.cljs$core$IFn$_invoke$arity$0() : f__12310__auto__.call(null));
(statearr_34998[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12309__auto___35003);

return statearr_34998;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12311__auto__);
});})(c__12309__auto___35003,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args35022 = [];
var len__7484__auto___35080 = arguments.length;
var i__7485__auto___35081 = (0);
while(true){
if((i__7485__auto___35081 < len__7484__auto___35080)){
args35022.push((arguments[i__7485__auto___35081]));

var G__35082 = (i__7485__auto___35081 + (1));
i__7485__auto___35081 = G__35082;
continue;
} else {
}
break;
}

var G__35024 = args35022.length;
switch (G__35024) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args35022.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__12309__auto___35084 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12309__auto___35084,out){
return (function (){
var f__12310__auto__ = (function (){var switch__12197__auto__ = ((function (c__12309__auto___35084,out){
return (function (state_35056){
var state_val_35057 = (state_35056[(1)]);
if((state_val_35057 === (7))){
var inst_35035 = (state_35056[(7)]);
var inst_35036 = (state_35056[(8)]);
var inst_35035__$1 = (state_35056[(2)]);
var inst_35036__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_35035__$1,(0),null);
var inst_35037 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_35035__$1,(1),null);
var inst_35038 = (inst_35036__$1 == null);
var state_35056__$1 = (function (){var statearr_35058 = state_35056;
(statearr_35058[(9)] = inst_35037);

(statearr_35058[(7)] = inst_35035__$1);

(statearr_35058[(8)] = inst_35036__$1);

return statearr_35058;
})();
if(cljs.core.truth_(inst_35038)){
var statearr_35059_35085 = state_35056__$1;
(statearr_35059_35085[(1)] = (8));

} else {
var statearr_35060_35086 = state_35056__$1;
(statearr_35060_35086[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35057 === (1))){
var inst_35025 = cljs.core.vec(chs);
var inst_35026 = inst_35025;
var state_35056__$1 = (function (){var statearr_35061 = state_35056;
(statearr_35061[(10)] = inst_35026);

return statearr_35061;
})();
var statearr_35062_35087 = state_35056__$1;
(statearr_35062_35087[(2)] = null);

(statearr_35062_35087[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35057 === (4))){
var inst_35026 = (state_35056[(10)]);
var state_35056__$1 = state_35056;
return cljs.core.async.ioc_alts_BANG_(state_35056__$1,(7),inst_35026);
} else {
if((state_val_35057 === (6))){
var inst_35052 = (state_35056[(2)]);
var state_35056__$1 = state_35056;
var statearr_35063_35088 = state_35056__$1;
(statearr_35063_35088[(2)] = inst_35052);

(statearr_35063_35088[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35057 === (3))){
var inst_35054 = (state_35056[(2)]);
var state_35056__$1 = state_35056;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35056__$1,inst_35054);
} else {
if((state_val_35057 === (2))){
var inst_35026 = (state_35056[(10)]);
var inst_35028 = cljs.core.count(inst_35026);
var inst_35029 = (inst_35028 > (0));
var state_35056__$1 = state_35056;
if(cljs.core.truth_(inst_35029)){
var statearr_35065_35089 = state_35056__$1;
(statearr_35065_35089[(1)] = (4));

} else {
var statearr_35066_35090 = state_35056__$1;
(statearr_35066_35090[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35057 === (11))){
var inst_35026 = (state_35056[(10)]);
var inst_35045 = (state_35056[(2)]);
var tmp35064 = inst_35026;
var inst_35026__$1 = tmp35064;
var state_35056__$1 = (function (){var statearr_35067 = state_35056;
(statearr_35067[(10)] = inst_35026__$1);

(statearr_35067[(11)] = inst_35045);

return statearr_35067;
})();
var statearr_35068_35091 = state_35056__$1;
(statearr_35068_35091[(2)] = null);

(statearr_35068_35091[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35057 === (9))){
var inst_35036 = (state_35056[(8)]);
var state_35056__$1 = state_35056;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_35056__$1,(11),out,inst_35036);
} else {
if((state_val_35057 === (5))){
var inst_35050 = cljs.core.async.close_BANG_(out);
var state_35056__$1 = state_35056;
var statearr_35069_35092 = state_35056__$1;
(statearr_35069_35092[(2)] = inst_35050);

(statearr_35069_35092[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35057 === (10))){
var inst_35048 = (state_35056[(2)]);
var state_35056__$1 = state_35056;
var statearr_35070_35093 = state_35056__$1;
(statearr_35070_35093[(2)] = inst_35048);

(statearr_35070_35093[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35057 === (8))){
var inst_35037 = (state_35056[(9)]);
var inst_35026 = (state_35056[(10)]);
var inst_35035 = (state_35056[(7)]);
var inst_35036 = (state_35056[(8)]);
var inst_35040 = (function (){var cs = inst_35026;
var vec__35031 = inst_35035;
var v = inst_35036;
var c = inst_35037;
return ((function (cs,vec__35031,v,c,inst_35037,inst_35026,inst_35035,inst_35036,state_val_35057,c__12309__auto___35084,out){
return (function (p1__35021_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__35021_SHARP_);
});
;})(cs,vec__35031,v,c,inst_35037,inst_35026,inst_35035,inst_35036,state_val_35057,c__12309__auto___35084,out))
})();
var inst_35041 = cljs.core.filterv(inst_35040,inst_35026);
var inst_35026__$1 = inst_35041;
var state_35056__$1 = (function (){var statearr_35071 = state_35056;
(statearr_35071[(10)] = inst_35026__$1);

return statearr_35071;
})();
var statearr_35072_35094 = state_35056__$1;
(statearr_35072_35094[(2)] = null);

(statearr_35072_35094[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__12309__auto___35084,out))
;
return ((function (switch__12197__auto__,c__12309__auto___35084,out){
return (function() {
var cljs$core$async$state_machine__12198__auto__ = null;
var cljs$core$async$state_machine__12198__auto____0 = (function (){
var statearr_35076 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_35076[(0)] = cljs$core$async$state_machine__12198__auto__);

(statearr_35076[(1)] = (1));

return statearr_35076;
});
var cljs$core$async$state_machine__12198__auto____1 = (function (state_35056){
while(true){
var ret_value__12199__auto__ = (function (){try{while(true){
var result__12200__auto__ = switch__12197__auto__(state_35056);
if(cljs.core.keyword_identical_QMARK_(result__12200__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12200__auto__;
}
break;
}
}catch (e35077){if((e35077 instanceof Object)){
var ex__12201__auto__ = e35077;
var statearr_35078_35095 = state_35056;
(statearr_35078_35095[(5)] = ex__12201__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_35056);

return cljs.core.cst$kw$recur;
} else {
throw e35077;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12199__auto__,cljs.core.cst$kw$recur)){
var G__35096 = state_35056;
state_35056 = G__35096;
continue;
} else {
return ret_value__12199__auto__;
}
break;
}
});
cljs$core$async$state_machine__12198__auto__ = function(state_35056){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12198__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12198__auto____1.call(this,state_35056);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12198__auto____0;
cljs$core$async$state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12198__auto____1;
return cljs$core$async$state_machine__12198__auto__;
})()
;})(switch__12197__auto__,c__12309__auto___35084,out))
})();
var state__12311__auto__ = (function (){var statearr_35079 = (f__12310__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12310__auto__.cljs$core$IFn$_invoke$arity$0() : f__12310__auto__.call(null));
(statearr_35079[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12309__auto___35084);

return statearr_35079;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12311__auto__);
});})(c__12309__auto___35084,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args35097 = [];
var len__7484__auto___35146 = arguments.length;
var i__7485__auto___35147 = (0);
while(true){
if((i__7485__auto___35147 < len__7484__auto___35146)){
args35097.push((arguments[i__7485__auto___35147]));

var G__35148 = (i__7485__auto___35147 + (1));
i__7485__auto___35147 = G__35148;
continue;
} else {
}
break;
}

var G__35099 = args35097.length;
switch (G__35099) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args35097.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__12309__auto___35150 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12309__auto___35150,out){
return (function (){
var f__12310__auto__ = (function (){var switch__12197__auto__ = ((function (c__12309__auto___35150,out){
return (function (state_35123){
var state_val_35124 = (state_35123[(1)]);
if((state_val_35124 === (7))){
var inst_35105 = (state_35123[(7)]);
var inst_35105__$1 = (state_35123[(2)]);
var inst_35106 = (inst_35105__$1 == null);
var inst_35107 = cljs.core.not(inst_35106);
var state_35123__$1 = (function (){var statearr_35125 = state_35123;
(statearr_35125[(7)] = inst_35105__$1);

return statearr_35125;
})();
if(inst_35107){
var statearr_35126_35151 = state_35123__$1;
(statearr_35126_35151[(1)] = (8));

} else {
var statearr_35127_35152 = state_35123__$1;
(statearr_35127_35152[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35124 === (1))){
var inst_35100 = (0);
var state_35123__$1 = (function (){var statearr_35128 = state_35123;
(statearr_35128[(8)] = inst_35100);

return statearr_35128;
})();
var statearr_35129_35153 = state_35123__$1;
(statearr_35129_35153[(2)] = null);

(statearr_35129_35153[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35124 === (4))){
var state_35123__$1 = state_35123;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35123__$1,(7),ch);
} else {
if((state_val_35124 === (6))){
var inst_35118 = (state_35123[(2)]);
var state_35123__$1 = state_35123;
var statearr_35130_35154 = state_35123__$1;
(statearr_35130_35154[(2)] = inst_35118);

(statearr_35130_35154[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35124 === (3))){
var inst_35120 = (state_35123[(2)]);
var inst_35121 = cljs.core.async.close_BANG_(out);
var state_35123__$1 = (function (){var statearr_35131 = state_35123;
(statearr_35131[(9)] = inst_35120);

return statearr_35131;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_35123__$1,inst_35121);
} else {
if((state_val_35124 === (2))){
var inst_35100 = (state_35123[(8)]);
var inst_35102 = (inst_35100 < n);
var state_35123__$1 = state_35123;
if(cljs.core.truth_(inst_35102)){
var statearr_35132_35155 = state_35123__$1;
(statearr_35132_35155[(1)] = (4));

} else {
var statearr_35133_35156 = state_35123__$1;
(statearr_35133_35156[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35124 === (11))){
var inst_35100 = (state_35123[(8)]);
var inst_35110 = (state_35123[(2)]);
var inst_35111 = (inst_35100 + (1));
var inst_35100__$1 = inst_35111;
var state_35123__$1 = (function (){var statearr_35134 = state_35123;
(statearr_35134[(10)] = inst_35110);

(statearr_35134[(8)] = inst_35100__$1);

return statearr_35134;
})();
var statearr_35135_35157 = state_35123__$1;
(statearr_35135_35157[(2)] = null);

(statearr_35135_35157[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35124 === (9))){
var state_35123__$1 = state_35123;
var statearr_35136_35158 = state_35123__$1;
(statearr_35136_35158[(2)] = null);

(statearr_35136_35158[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35124 === (5))){
var state_35123__$1 = state_35123;
var statearr_35137_35159 = state_35123__$1;
(statearr_35137_35159[(2)] = null);

(statearr_35137_35159[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35124 === (10))){
var inst_35115 = (state_35123[(2)]);
var state_35123__$1 = state_35123;
var statearr_35138_35160 = state_35123__$1;
(statearr_35138_35160[(2)] = inst_35115);

(statearr_35138_35160[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35124 === (8))){
var inst_35105 = (state_35123[(7)]);
var state_35123__$1 = state_35123;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_35123__$1,(11),out,inst_35105);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__12309__auto___35150,out))
;
return ((function (switch__12197__auto__,c__12309__auto___35150,out){
return (function() {
var cljs$core$async$state_machine__12198__auto__ = null;
var cljs$core$async$state_machine__12198__auto____0 = (function (){
var statearr_35142 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_35142[(0)] = cljs$core$async$state_machine__12198__auto__);

(statearr_35142[(1)] = (1));

return statearr_35142;
});
var cljs$core$async$state_machine__12198__auto____1 = (function (state_35123){
while(true){
var ret_value__12199__auto__ = (function (){try{while(true){
var result__12200__auto__ = switch__12197__auto__(state_35123);
if(cljs.core.keyword_identical_QMARK_(result__12200__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12200__auto__;
}
break;
}
}catch (e35143){if((e35143 instanceof Object)){
var ex__12201__auto__ = e35143;
var statearr_35144_35161 = state_35123;
(statearr_35144_35161[(5)] = ex__12201__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_35123);

return cljs.core.cst$kw$recur;
} else {
throw e35143;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12199__auto__,cljs.core.cst$kw$recur)){
var G__35162 = state_35123;
state_35123 = G__35162;
continue;
} else {
return ret_value__12199__auto__;
}
break;
}
});
cljs$core$async$state_machine__12198__auto__ = function(state_35123){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12198__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12198__auto____1.call(this,state_35123);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12198__auto____0;
cljs$core$async$state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12198__auto____1;
return cljs$core$async$state_machine__12198__auto__;
})()
;})(switch__12197__auto__,c__12309__auto___35150,out))
})();
var state__12311__auto__ = (function (){var statearr_35145 = (f__12310__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12310__auto__.cljs$core$IFn$_invoke$arity$0() : f__12310__auto__.call(null));
(statearr_35145[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12309__auto___35150);

return statearr_35145;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12311__auto__);
});})(c__12309__auto___35150,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async35172 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async35172 = (function (map_LT_,f,ch,meta35173){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta35173 = meta35173;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async35172.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_35174,meta35173__$1){
var self__ = this;
var _35174__$1 = this;
return (new cljs.core.async.t_cljs$core$async35172(self__.map_LT_,self__.f,self__.ch,meta35173__$1));
});

cljs.core.async.t_cljs$core$async35172.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_35174){
var self__ = this;
var _35174__$1 = this;
return self__.meta35173;
});

cljs.core.async.t_cljs$core$async35172.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async35172.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async35172.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
});

cljs.core.async.t_cljs$core$async35172.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async35172.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async35175 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async35175 = (function (map_LT_,f,ch,meta35173,_,fn1,meta35176){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta35173 = meta35173;
this._ = _;
this.fn1 = fn1;
this.meta35176 = meta35176;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async35175.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_35177,meta35176__$1){
var self__ = this;
var _35177__$1 = this;
return (new cljs.core.async.t_cljs$core$async35175(self__.map_LT_,self__.f,self__.ch,self__.meta35173,self__._,self__.fn1,meta35176__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async35175.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_35177){
var self__ = this;
var _35177__$1 = this;
return self__.meta35176;
});})(___$1))
;

cljs.core.async.t_cljs$core$async35175.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async35175.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async35175.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async35175.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__35163_SHARP_){
var G__35178 = (((p1__35163_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__35163_SHARP_) : self__.f.call(null,p1__35163_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__35178) : f1.call(null,G__35178));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async35175.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$map_LT_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch], null))),cljs.core.cst$kw$doc,"Deprecated - this function will be removed. Use transducer instead"], null)),cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta35173,cljs.core.with_meta(cljs.core.cst$sym$_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$cljs$core$async_SLASH_t_cljs$core$async35172], null)),cljs.core.cst$sym$fn1,cljs.core.cst$sym$meta35176], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async35175.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async35175.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async35175";

cljs.core.async.t_cljs$core$async35175.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"cljs.core.async/t_cljs$core$async35175");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async35175 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async35175(map_LT___$1,f__$1,ch__$1,meta35173__$1,___$2,fn1__$1,meta35176){
return (new cljs.core.async.t_cljs$core$async35175(map_LT___$1,f__$1,ch__$1,meta35173__$1,___$2,fn1__$1,meta35176));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async35175(self__.map_LT_,self__.f,self__.ch,self__.meta35173,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__6397__auto__ = ret;
if(cljs.core.truth_(and__6397__auto__)){
return !(((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret)) == null));
} else {
return and__6397__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__35179 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__35179) : self__.f.call(null,G__35179));
})());
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async35172.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async35172.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async35172.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$map_LT_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch], null))),cljs.core.cst$kw$doc,"Deprecated - this function will be removed. Use transducer instead"], null)),cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta35173], null);
});

cljs.core.async.t_cljs$core$async35172.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async35172.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async35172";

cljs.core.async.t_cljs$core$async35172.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"cljs.core.async/t_cljs$core$async35172");
});

cljs.core.async.__GT_t_cljs$core$async35172 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async35172(map_LT___$1,f__$1,ch__$1,meta35173){
return (new cljs.core.async.t_cljs$core$async35172(map_LT___$1,f__$1,ch__$1,meta35173));
});

}

return (new cljs.core.async.t_cljs$core$async35172(cljs$core$async$map_LT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async35183 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async35183 = (function (map_GT_,f,ch,meta35184){
this.map_GT_ = map_GT_;
this.f = f;
this.ch = ch;
this.meta35184 = meta35184;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async35183.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_35185,meta35184__$1){
var self__ = this;
var _35185__$1 = this;
return (new cljs.core.async.t_cljs$core$async35183(self__.map_GT_,self__.f,self__.ch,meta35184__$1));
});

cljs.core.async.t_cljs$core$async35183.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_35185){
var self__ = this;
var _35185__$1 = this;
return self__.meta35184;
});

cljs.core.async.t_cljs$core$async35183.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async35183.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async35183.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async35183.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async35183.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async35183.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
});

cljs.core.async.t_cljs$core$async35183.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$map_GT_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch], null))),cljs.core.cst$kw$doc,"Deprecated - this function will be removed. Use transducer instead"], null)),cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta35184], null);
});

cljs.core.async.t_cljs$core$async35183.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async35183.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async35183";

cljs.core.async.t_cljs$core$async35183.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"cljs.core.async/t_cljs$core$async35183");
});

cljs.core.async.__GT_t_cljs$core$async35183 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async35183(map_GT___$1,f__$1,ch__$1,meta35184){
return (new cljs.core.async.t_cljs$core$async35183(map_GT___$1,f__$1,ch__$1,meta35184));
});

}

return (new cljs.core.async.t_cljs$core$async35183(cljs$core$async$map_GT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async35189 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async35189 = (function (filter_GT_,p,ch,meta35190){
this.filter_GT_ = filter_GT_;
this.p = p;
this.ch = ch;
this.meta35190 = meta35190;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async35189.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_35191,meta35190__$1){
var self__ = this;
var _35191__$1 = this;
return (new cljs.core.async.t_cljs$core$async35189(self__.filter_GT_,self__.p,self__.ch,meta35190__$1));
});

cljs.core.async.t_cljs$core$async35189.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_35191){
var self__ = this;
var _35191__$1 = this;
return self__.meta35190;
});

cljs.core.async.t_cljs$core$async35189.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async35189.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async35189.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
});

cljs.core.async.t_cljs$core$async35189.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async35189.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async35189.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async35189.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
});

cljs.core.async.t_cljs$core$async35189.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$filter_GT_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p,cljs.core.cst$sym$ch], null))),cljs.core.cst$kw$doc,"Deprecated - this function will be removed. Use transducer instead"], null)),cljs.core.cst$sym$p,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta35190], null);
});

cljs.core.async.t_cljs$core$async35189.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async35189.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async35189";

cljs.core.async.t_cljs$core$async35189.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"cljs.core.async/t_cljs$core$async35189");
});

cljs.core.async.__GT_t_cljs$core$async35189 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async35189(filter_GT___$1,p__$1,ch__$1,meta35190){
return (new cljs.core.async.t_cljs$core$async35189(filter_GT___$1,p__$1,ch__$1,meta35190));
});

}

return (new cljs.core.async.t_cljs$core$async35189(cljs$core$async$filter_GT_,p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args35192 = [];
var len__7484__auto___35236 = arguments.length;
var i__7485__auto___35237 = (0);
while(true){
if((i__7485__auto___35237 < len__7484__auto___35236)){
args35192.push((arguments[i__7485__auto___35237]));

var G__35238 = (i__7485__auto___35237 + (1));
i__7485__auto___35237 = G__35238;
continue;
} else {
}
break;
}

var G__35194 = args35192.length;
switch (G__35194) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args35192.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__12309__auto___35240 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12309__auto___35240,out){
return (function (){
var f__12310__auto__ = (function (){var switch__12197__auto__ = ((function (c__12309__auto___35240,out){
return (function (state_35215){
var state_val_35216 = (state_35215[(1)]);
if((state_val_35216 === (7))){
var inst_35211 = (state_35215[(2)]);
var state_35215__$1 = state_35215;
var statearr_35217_35241 = state_35215__$1;
(statearr_35217_35241[(2)] = inst_35211);

(statearr_35217_35241[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35216 === (1))){
var state_35215__$1 = state_35215;
var statearr_35218_35242 = state_35215__$1;
(statearr_35218_35242[(2)] = null);

(statearr_35218_35242[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35216 === (4))){
var inst_35197 = (state_35215[(7)]);
var inst_35197__$1 = (state_35215[(2)]);
var inst_35198 = (inst_35197__$1 == null);
var state_35215__$1 = (function (){var statearr_35219 = state_35215;
(statearr_35219[(7)] = inst_35197__$1);

return statearr_35219;
})();
if(cljs.core.truth_(inst_35198)){
var statearr_35220_35243 = state_35215__$1;
(statearr_35220_35243[(1)] = (5));

} else {
var statearr_35221_35244 = state_35215__$1;
(statearr_35221_35244[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35216 === (6))){
var inst_35197 = (state_35215[(7)]);
var inst_35202 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_35197) : p.call(null,inst_35197));
var state_35215__$1 = state_35215;
if(cljs.core.truth_(inst_35202)){
var statearr_35222_35245 = state_35215__$1;
(statearr_35222_35245[(1)] = (8));

} else {
var statearr_35223_35246 = state_35215__$1;
(statearr_35223_35246[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35216 === (3))){
var inst_35213 = (state_35215[(2)]);
var state_35215__$1 = state_35215;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35215__$1,inst_35213);
} else {
if((state_val_35216 === (2))){
var state_35215__$1 = state_35215;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35215__$1,(4),ch);
} else {
if((state_val_35216 === (11))){
var inst_35205 = (state_35215[(2)]);
var state_35215__$1 = state_35215;
var statearr_35224_35247 = state_35215__$1;
(statearr_35224_35247[(2)] = inst_35205);

(statearr_35224_35247[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35216 === (9))){
var state_35215__$1 = state_35215;
var statearr_35225_35248 = state_35215__$1;
(statearr_35225_35248[(2)] = null);

(statearr_35225_35248[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35216 === (5))){
var inst_35200 = cljs.core.async.close_BANG_(out);
var state_35215__$1 = state_35215;
var statearr_35226_35249 = state_35215__$1;
(statearr_35226_35249[(2)] = inst_35200);

(statearr_35226_35249[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35216 === (10))){
var inst_35208 = (state_35215[(2)]);
var state_35215__$1 = (function (){var statearr_35227 = state_35215;
(statearr_35227[(8)] = inst_35208);

return statearr_35227;
})();
var statearr_35228_35250 = state_35215__$1;
(statearr_35228_35250[(2)] = null);

(statearr_35228_35250[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35216 === (8))){
var inst_35197 = (state_35215[(7)]);
var state_35215__$1 = state_35215;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_35215__$1,(11),out,inst_35197);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__12309__auto___35240,out))
;
return ((function (switch__12197__auto__,c__12309__auto___35240,out){
return (function() {
var cljs$core$async$state_machine__12198__auto__ = null;
var cljs$core$async$state_machine__12198__auto____0 = (function (){
var statearr_35232 = [null,null,null,null,null,null,null,null,null];
(statearr_35232[(0)] = cljs$core$async$state_machine__12198__auto__);

(statearr_35232[(1)] = (1));

return statearr_35232;
});
var cljs$core$async$state_machine__12198__auto____1 = (function (state_35215){
while(true){
var ret_value__12199__auto__ = (function (){try{while(true){
var result__12200__auto__ = switch__12197__auto__(state_35215);
if(cljs.core.keyword_identical_QMARK_(result__12200__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12200__auto__;
}
break;
}
}catch (e35233){if((e35233 instanceof Object)){
var ex__12201__auto__ = e35233;
var statearr_35234_35251 = state_35215;
(statearr_35234_35251[(5)] = ex__12201__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_35215);

return cljs.core.cst$kw$recur;
} else {
throw e35233;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12199__auto__,cljs.core.cst$kw$recur)){
var G__35252 = state_35215;
state_35215 = G__35252;
continue;
} else {
return ret_value__12199__auto__;
}
break;
}
});
cljs$core$async$state_machine__12198__auto__ = function(state_35215){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12198__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12198__auto____1.call(this,state_35215);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12198__auto____0;
cljs$core$async$state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12198__auto____1;
return cljs$core$async$state_machine__12198__auto__;
})()
;})(switch__12197__auto__,c__12309__auto___35240,out))
})();
var state__12311__auto__ = (function (){var statearr_35235 = (f__12310__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12310__auto__.cljs$core$IFn$_invoke$arity$0() : f__12310__auto__.call(null));
(statearr_35235[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12309__auto___35240);

return statearr_35235;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12311__auto__);
});})(c__12309__auto___35240,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args35253 = [];
var len__7484__auto___35256 = arguments.length;
var i__7485__auto___35257 = (0);
while(true){
if((i__7485__auto___35257 < len__7484__auto___35256)){
args35253.push((arguments[i__7485__auto___35257]));

var G__35258 = (i__7485__auto___35257 + (1));
i__7485__auto___35257 = G__35258;
continue;
} else {
}
break;
}

var G__35255 = args35253.length;
switch (G__35255) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args35253.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__12309__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12309__auto__){
return (function (){
var f__12310__auto__ = (function (){var switch__12197__auto__ = ((function (c__12309__auto__){
return (function (state_35425){
var state_val_35426 = (state_35425[(1)]);
if((state_val_35426 === (7))){
var inst_35421 = (state_35425[(2)]);
var state_35425__$1 = state_35425;
var statearr_35427_35468 = state_35425__$1;
(statearr_35427_35468[(2)] = inst_35421);

(statearr_35427_35468[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35426 === (20))){
var inst_35391 = (state_35425[(7)]);
var inst_35402 = (state_35425[(2)]);
var inst_35403 = cljs.core.next(inst_35391);
var inst_35377 = inst_35403;
var inst_35378 = null;
var inst_35379 = (0);
var inst_35380 = (0);
var state_35425__$1 = (function (){var statearr_35428 = state_35425;
(statearr_35428[(8)] = inst_35379);

(statearr_35428[(9)] = inst_35378);

(statearr_35428[(10)] = inst_35402);

(statearr_35428[(11)] = inst_35380);

(statearr_35428[(12)] = inst_35377);

return statearr_35428;
})();
var statearr_35429_35469 = state_35425__$1;
(statearr_35429_35469[(2)] = null);

(statearr_35429_35469[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35426 === (1))){
var state_35425__$1 = state_35425;
var statearr_35430_35470 = state_35425__$1;
(statearr_35430_35470[(2)] = null);

(statearr_35430_35470[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35426 === (4))){
var inst_35366 = (state_35425[(13)]);
var inst_35366__$1 = (state_35425[(2)]);
var inst_35367 = (inst_35366__$1 == null);
var state_35425__$1 = (function (){var statearr_35431 = state_35425;
(statearr_35431[(13)] = inst_35366__$1);

return statearr_35431;
})();
if(cljs.core.truth_(inst_35367)){
var statearr_35432_35471 = state_35425__$1;
(statearr_35432_35471[(1)] = (5));

} else {
var statearr_35433_35472 = state_35425__$1;
(statearr_35433_35472[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35426 === (15))){
var state_35425__$1 = state_35425;
var statearr_35437_35473 = state_35425__$1;
(statearr_35437_35473[(2)] = null);

(statearr_35437_35473[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35426 === (21))){
var state_35425__$1 = state_35425;
var statearr_35438_35474 = state_35425__$1;
(statearr_35438_35474[(2)] = null);

(statearr_35438_35474[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35426 === (13))){
var inst_35379 = (state_35425[(8)]);
var inst_35378 = (state_35425[(9)]);
var inst_35380 = (state_35425[(11)]);
var inst_35377 = (state_35425[(12)]);
var inst_35387 = (state_35425[(2)]);
var inst_35388 = (inst_35380 + (1));
var tmp35434 = inst_35379;
var tmp35435 = inst_35378;
var tmp35436 = inst_35377;
var inst_35377__$1 = tmp35436;
var inst_35378__$1 = tmp35435;
var inst_35379__$1 = tmp35434;
var inst_35380__$1 = inst_35388;
var state_35425__$1 = (function (){var statearr_35439 = state_35425;
(statearr_35439[(8)] = inst_35379__$1);

(statearr_35439[(9)] = inst_35378__$1);

(statearr_35439[(14)] = inst_35387);

(statearr_35439[(11)] = inst_35380__$1);

(statearr_35439[(12)] = inst_35377__$1);

return statearr_35439;
})();
var statearr_35440_35475 = state_35425__$1;
(statearr_35440_35475[(2)] = null);

(statearr_35440_35475[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35426 === (22))){
var state_35425__$1 = state_35425;
var statearr_35441_35476 = state_35425__$1;
(statearr_35441_35476[(2)] = null);

(statearr_35441_35476[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35426 === (6))){
var inst_35366 = (state_35425[(13)]);
var inst_35375 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_35366) : f.call(null,inst_35366));
var inst_35376 = cljs.core.seq(inst_35375);
var inst_35377 = inst_35376;
var inst_35378 = null;
var inst_35379 = (0);
var inst_35380 = (0);
var state_35425__$1 = (function (){var statearr_35442 = state_35425;
(statearr_35442[(8)] = inst_35379);

(statearr_35442[(9)] = inst_35378);

(statearr_35442[(11)] = inst_35380);

(statearr_35442[(12)] = inst_35377);

return statearr_35442;
})();
var statearr_35443_35477 = state_35425__$1;
(statearr_35443_35477[(2)] = null);

(statearr_35443_35477[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35426 === (17))){
var inst_35391 = (state_35425[(7)]);
var inst_35395 = cljs.core.chunk_first(inst_35391);
var inst_35396 = cljs.core.chunk_rest(inst_35391);
var inst_35397 = cljs.core.count(inst_35395);
var inst_35377 = inst_35396;
var inst_35378 = inst_35395;
var inst_35379 = inst_35397;
var inst_35380 = (0);
var state_35425__$1 = (function (){var statearr_35444 = state_35425;
(statearr_35444[(8)] = inst_35379);

(statearr_35444[(9)] = inst_35378);

(statearr_35444[(11)] = inst_35380);

(statearr_35444[(12)] = inst_35377);

return statearr_35444;
})();
var statearr_35445_35478 = state_35425__$1;
(statearr_35445_35478[(2)] = null);

(statearr_35445_35478[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35426 === (3))){
var inst_35423 = (state_35425[(2)]);
var state_35425__$1 = state_35425;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35425__$1,inst_35423);
} else {
if((state_val_35426 === (12))){
var inst_35411 = (state_35425[(2)]);
var state_35425__$1 = state_35425;
var statearr_35446_35479 = state_35425__$1;
(statearr_35446_35479[(2)] = inst_35411);

(statearr_35446_35479[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35426 === (2))){
var state_35425__$1 = state_35425;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35425__$1,(4),in$);
} else {
if((state_val_35426 === (23))){
var inst_35419 = (state_35425[(2)]);
var state_35425__$1 = state_35425;
var statearr_35447_35480 = state_35425__$1;
(statearr_35447_35480[(2)] = inst_35419);

(statearr_35447_35480[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35426 === (19))){
var inst_35406 = (state_35425[(2)]);
var state_35425__$1 = state_35425;
var statearr_35448_35481 = state_35425__$1;
(statearr_35448_35481[(2)] = inst_35406);

(statearr_35448_35481[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35426 === (11))){
var inst_35391 = (state_35425[(7)]);
var inst_35377 = (state_35425[(12)]);
var inst_35391__$1 = cljs.core.seq(inst_35377);
var state_35425__$1 = (function (){var statearr_35449 = state_35425;
(statearr_35449[(7)] = inst_35391__$1);

return statearr_35449;
})();
if(inst_35391__$1){
var statearr_35450_35482 = state_35425__$1;
(statearr_35450_35482[(1)] = (14));

} else {
var statearr_35451_35483 = state_35425__$1;
(statearr_35451_35483[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35426 === (9))){
var inst_35413 = (state_35425[(2)]);
var inst_35414 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_35425__$1 = (function (){var statearr_35452 = state_35425;
(statearr_35452[(15)] = inst_35413);

return statearr_35452;
})();
if(cljs.core.truth_(inst_35414)){
var statearr_35453_35484 = state_35425__$1;
(statearr_35453_35484[(1)] = (21));

} else {
var statearr_35454_35485 = state_35425__$1;
(statearr_35454_35485[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35426 === (5))){
var inst_35369 = cljs.core.async.close_BANG_(out);
var state_35425__$1 = state_35425;
var statearr_35455_35486 = state_35425__$1;
(statearr_35455_35486[(2)] = inst_35369);

(statearr_35455_35486[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35426 === (14))){
var inst_35391 = (state_35425[(7)]);
var inst_35393 = cljs.core.chunked_seq_QMARK_(inst_35391);
var state_35425__$1 = state_35425;
if(inst_35393){
var statearr_35456_35487 = state_35425__$1;
(statearr_35456_35487[(1)] = (17));

} else {
var statearr_35457_35488 = state_35425__$1;
(statearr_35457_35488[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35426 === (16))){
var inst_35409 = (state_35425[(2)]);
var state_35425__$1 = state_35425;
var statearr_35458_35489 = state_35425__$1;
(statearr_35458_35489[(2)] = inst_35409);

(statearr_35458_35489[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35426 === (10))){
var inst_35378 = (state_35425[(9)]);
var inst_35380 = (state_35425[(11)]);
var inst_35385 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_35378,inst_35380);
var state_35425__$1 = state_35425;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_35425__$1,(13),out,inst_35385);
} else {
if((state_val_35426 === (18))){
var inst_35391 = (state_35425[(7)]);
var inst_35400 = cljs.core.first(inst_35391);
var state_35425__$1 = state_35425;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_35425__$1,(20),out,inst_35400);
} else {
if((state_val_35426 === (8))){
var inst_35379 = (state_35425[(8)]);
var inst_35380 = (state_35425[(11)]);
var inst_35382 = (inst_35380 < inst_35379);
var inst_35383 = inst_35382;
var state_35425__$1 = state_35425;
if(cljs.core.truth_(inst_35383)){
var statearr_35459_35490 = state_35425__$1;
(statearr_35459_35490[(1)] = (10));

} else {
var statearr_35460_35491 = state_35425__$1;
(statearr_35460_35491[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12309__auto__))
;
return ((function (switch__12197__auto__,c__12309__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__12198__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__12198__auto____0 = (function (){
var statearr_35464 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_35464[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__12198__auto__);

(statearr_35464[(1)] = (1));

return statearr_35464;
});
var cljs$core$async$mapcat_STAR__$_state_machine__12198__auto____1 = (function (state_35425){
while(true){
var ret_value__12199__auto__ = (function (){try{while(true){
var result__12200__auto__ = switch__12197__auto__(state_35425);
if(cljs.core.keyword_identical_QMARK_(result__12200__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12200__auto__;
}
break;
}
}catch (e35465){if((e35465 instanceof Object)){
var ex__12201__auto__ = e35465;
var statearr_35466_35492 = state_35425;
(statearr_35466_35492[(5)] = ex__12201__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_35425);

return cljs.core.cst$kw$recur;
} else {
throw e35465;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12199__auto__,cljs.core.cst$kw$recur)){
var G__35493 = state_35425;
state_35425 = G__35493;
continue;
} else {
return ret_value__12199__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__12198__auto__ = function(state_35425){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__12198__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__12198__auto____1.call(this,state_35425);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__12198__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__12198__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__12198__auto__;
})()
;})(switch__12197__auto__,c__12309__auto__))
})();
var state__12311__auto__ = (function (){var statearr_35467 = (f__12310__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12310__auto__.cljs$core$IFn$_invoke$arity$0() : f__12310__auto__.call(null));
(statearr_35467[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12309__auto__);

return statearr_35467;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12311__auto__);
});})(c__12309__auto__))
);

return c__12309__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args35494 = [];
var len__7484__auto___35497 = arguments.length;
var i__7485__auto___35498 = (0);
while(true){
if((i__7485__auto___35498 < len__7484__auto___35497)){
args35494.push((arguments[i__7485__auto___35498]));

var G__35499 = (i__7485__auto___35498 + (1));
i__7485__auto___35498 = G__35499;
continue;
} else {
}
break;
}

var G__35496 = args35494.length;
switch (G__35496) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args35494.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args35501 = [];
var len__7484__auto___35504 = arguments.length;
var i__7485__auto___35505 = (0);
while(true){
if((i__7485__auto___35505 < len__7484__auto___35504)){
args35501.push((arguments[i__7485__auto___35505]));

var G__35506 = (i__7485__auto___35505 + (1));
i__7485__auto___35505 = G__35506;
continue;
} else {
}
break;
}

var G__35503 = args35501.length;
switch (G__35503) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args35501.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args35508 = [];
var len__7484__auto___35559 = arguments.length;
var i__7485__auto___35560 = (0);
while(true){
if((i__7485__auto___35560 < len__7484__auto___35559)){
args35508.push((arguments[i__7485__auto___35560]));

var G__35561 = (i__7485__auto___35560 + (1));
i__7485__auto___35560 = G__35561;
continue;
} else {
}
break;
}

var G__35510 = args35508.length;
switch (G__35510) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args35508.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__12309__auto___35563 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12309__auto___35563,out){
return (function (){
var f__12310__auto__ = (function (){var switch__12197__auto__ = ((function (c__12309__auto___35563,out){
return (function (state_35534){
var state_val_35535 = (state_35534[(1)]);
if((state_val_35535 === (7))){
var inst_35529 = (state_35534[(2)]);
var state_35534__$1 = state_35534;
var statearr_35536_35564 = state_35534__$1;
(statearr_35536_35564[(2)] = inst_35529);

(statearr_35536_35564[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35535 === (1))){
var inst_35511 = null;
var state_35534__$1 = (function (){var statearr_35537 = state_35534;
(statearr_35537[(7)] = inst_35511);

return statearr_35537;
})();
var statearr_35538_35565 = state_35534__$1;
(statearr_35538_35565[(2)] = null);

(statearr_35538_35565[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35535 === (4))){
var inst_35514 = (state_35534[(8)]);
var inst_35514__$1 = (state_35534[(2)]);
var inst_35515 = (inst_35514__$1 == null);
var inst_35516 = cljs.core.not(inst_35515);
var state_35534__$1 = (function (){var statearr_35539 = state_35534;
(statearr_35539[(8)] = inst_35514__$1);

return statearr_35539;
})();
if(inst_35516){
var statearr_35540_35566 = state_35534__$1;
(statearr_35540_35566[(1)] = (5));

} else {
var statearr_35541_35567 = state_35534__$1;
(statearr_35541_35567[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35535 === (6))){
var state_35534__$1 = state_35534;
var statearr_35542_35568 = state_35534__$1;
(statearr_35542_35568[(2)] = null);

(statearr_35542_35568[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35535 === (3))){
var inst_35531 = (state_35534[(2)]);
var inst_35532 = cljs.core.async.close_BANG_(out);
var state_35534__$1 = (function (){var statearr_35543 = state_35534;
(statearr_35543[(9)] = inst_35531);

return statearr_35543;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_35534__$1,inst_35532);
} else {
if((state_val_35535 === (2))){
var state_35534__$1 = state_35534;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35534__$1,(4),ch);
} else {
if((state_val_35535 === (11))){
var inst_35514 = (state_35534[(8)]);
var inst_35523 = (state_35534[(2)]);
var inst_35511 = inst_35514;
var state_35534__$1 = (function (){var statearr_35544 = state_35534;
(statearr_35544[(7)] = inst_35511);

(statearr_35544[(10)] = inst_35523);

return statearr_35544;
})();
var statearr_35545_35569 = state_35534__$1;
(statearr_35545_35569[(2)] = null);

(statearr_35545_35569[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35535 === (9))){
var inst_35514 = (state_35534[(8)]);
var state_35534__$1 = state_35534;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_35534__$1,(11),out,inst_35514);
} else {
if((state_val_35535 === (5))){
var inst_35514 = (state_35534[(8)]);
var inst_35511 = (state_35534[(7)]);
var inst_35518 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_35514,inst_35511);
var state_35534__$1 = state_35534;
if(inst_35518){
var statearr_35547_35570 = state_35534__$1;
(statearr_35547_35570[(1)] = (8));

} else {
var statearr_35548_35571 = state_35534__$1;
(statearr_35548_35571[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35535 === (10))){
var inst_35526 = (state_35534[(2)]);
var state_35534__$1 = state_35534;
var statearr_35549_35572 = state_35534__$1;
(statearr_35549_35572[(2)] = inst_35526);

(statearr_35549_35572[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35535 === (8))){
var inst_35511 = (state_35534[(7)]);
var tmp35546 = inst_35511;
var inst_35511__$1 = tmp35546;
var state_35534__$1 = (function (){var statearr_35550 = state_35534;
(statearr_35550[(7)] = inst_35511__$1);

return statearr_35550;
})();
var statearr_35551_35573 = state_35534__$1;
(statearr_35551_35573[(2)] = null);

(statearr_35551_35573[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__12309__auto___35563,out))
;
return ((function (switch__12197__auto__,c__12309__auto___35563,out){
return (function() {
var cljs$core$async$state_machine__12198__auto__ = null;
var cljs$core$async$state_machine__12198__auto____0 = (function (){
var statearr_35555 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_35555[(0)] = cljs$core$async$state_machine__12198__auto__);

(statearr_35555[(1)] = (1));

return statearr_35555;
});
var cljs$core$async$state_machine__12198__auto____1 = (function (state_35534){
while(true){
var ret_value__12199__auto__ = (function (){try{while(true){
var result__12200__auto__ = switch__12197__auto__(state_35534);
if(cljs.core.keyword_identical_QMARK_(result__12200__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12200__auto__;
}
break;
}
}catch (e35556){if((e35556 instanceof Object)){
var ex__12201__auto__ = e35556;
var statearr_35557_35574 = state_35534;
(statearr_35557_35574[(5)] = ex__12201__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_35534);

return cljs.core.cst$kw$recur;
} else {
throw e35556;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12199__auto__,cljs.core.cst$kw$recur)){
var G__35575 = state_35534;
state_35534 = G__35575;
continue;
} else {
return ret_value__12199__auto__;
}
break;
}
});
cljs$core$async$state_machine__12198__auto__ = function(state_35534){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12198__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12198__auto____1.call(this,state_35534);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12198__auto____0;
cljs$core$async$state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12198__auto____1;
return cljs$core$async$state_machine__12198__auto__;
})()
;})(switch__12197__auto__,c__12309__auto___35563,out))
})();
var state__12311__auto__ = (function (){var statearr_35558 = (f__12310__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12310__auto__.cljs$core$IFn$_invoke$arity$0() : f__12310__auto__.call(null));
(statearr_35558[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12309__auto___35563);

return statearr_35558;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12311__auto__);
});})(c__12309__auto___35563,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args35576 = [];
var len__7484__auto___35646 = arguments.length;
var i__7485__auto___35647 = (0);
while(true){
if((i__7485__auto___35647 < len__7484__auto___35646)){
args35576.push((arguments[i__7485__auto___35647]));

var G__35648 = (i__7485__auto___35647 + (1));
i__7485__auto___35647 = G__35648;
continue;
} else {
}
break;
}

var G__35578 = args35576.length;
switch (G__35578) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args35576.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__12309__auto___35650 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12309__auto___35650,out){
return (function (){
var f__12310__auto__ = (function (){var switch__12197__auto__ = ((function (c__12309__auto___35650,out){
return (function (state_35616){
var state_val_35617 = (state_35616[(1)]);
if((state_val_35617 === (7))){
var inst_35612 = (state_35616[(2)]);
var state_35616__$1 = state_35616;
var statearr_35618_35651 = state_35616__$1;
(statearr_35618_35651[(2)] = inst_35612);

(statearr_35618_35651[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35617 === (1))){
var inst_35579 = (new Array(n));
var inst_35580 = inst_35579;
var inst_35581 = (0);
var state_35616__$1 = (function (){var statearr_35619 = state_35616;
(statearr_35619[(7)] = inst_35580);

(statearr_35619[(8)] = inst_35581);

return statearr_35619;
})();
var statearr_35620_35652 = state_35616__$1;
(statearr_35620_35652[(2)] = null);

(statearr_35620_35652[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35617 === (4))){
var inst_35584 = (state_35616[(9)]);
var inst_35584__$1 = (state_35616[(2)]);
var inst_35585 = (inst_35584__$1 == null);
var inst_35586 = cljs.core.not(inst_35585);
var state_35616__$1 = (function (){var statearr_35621 = state_35616;
(statearr_35621[(9)] = inst_35584__$1);

return statearr_35621;
})();
if(inst_35586){
var statearr_35622_35653 = state_35616__$1;
(statearr_35622_35653[(1)] = (5));

} else {
var statearr_35623_35654 = state_35616__$1;
(statearr_35623_35654[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35617 === (15))){
var inst_35606 = (state_35616[(2)]);
var state_35616__$1 = state_35616;
var statearr_35624_35655 = state_35616__$1;
(statearr_35624_35655[(2)] = inst_35606);

(statearr_35624_35655[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35617 === (13))){
var state_35616__$1 = state_35616;
var statearr_35625_35656 = state_35616__$1;
(statearr_35625_35656[(2)] = null);

(statearr_35625_35656[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35617 === (6))){
var inst_35581 = (state_35616[(8)]);
var inst_35602 = (inst_35581 > (0));
var state_35616__$1 = state_35616;
if(cljs.core.truth_(inst_35602)){
var statearr_35626_35657 = state_35616__$1;
(statearr_35626_35657[(1)] = (12));

} else {
var statearr_35627_35658 = state_35616__$1;
(statearr_35627_35658[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35617 === (3))){
var inst_35614 = (state_35616[(2)]);
var state_35616__$1 = state_35616;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35616__$1,inst_35614);
} else {
if((state_val_35617 === (12))){
var inst_35580 = (state_35616[(7)]);
var inst_35604 = cljs.core.vec(inst_35580);
var state_35616__$1 = state_35616;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_35616__$1,(15),out,inst_35604);
} else {
if((state_val_35617 === (2))){
var state_35616__$1 = state_35616;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35616__$1,(4),ch);
} else {
if((state_val_35617 === (11))){
var inst_35596 = (state_35616[(2)]);
var inst_35597 = (new Array(n));
var inst_35580 = inst_35597;
var inst_35581 = (0);
var state_35616__$1 = (function (){var statearr_35628 = state_35616;
(statearr_35628[(7)] = inst_35580);

(statearr_35628[(8)] = inst_35581);

(statearr_35628[(10)] = inst_35596);

return statearr_35628;
})();
var statearr_35629_35659 = state_35616__$1;
(statearr_35629_35659[(2)] = null);

(statearr_35629_35659[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35617 === (9))){
var inst_35580 = (state_35616[(7)]);
var inst_35594 = cljs.core.vec(inst_35580);
var state_35616__$1 = state_35616;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_35616__$1,(11),out,inst_35594);
} else {
if((state_val_35617 === (5))){
var inst_35580 = (state_35616[(7)]);
var inst_35581 = (state_35616[(8)]);
var inst_35584 = (state_35616[(9)]);
var inst_35589 = (state_35616[(11)]);
var inst_35588 = (inst_35580[inst_35581] = inst_35584);
var inst_35589__$1 = (inst_35581 + (1));
var inst_35590 = (inst_35589__$1 < n);
var state_35616__$1 = (function (){var statearr_35630 = state_35616;
(statearr_35630[(11)] = inst_35589__$1);

(statearr_35630[(12)] = inst_35588);

return statearr_35630;
})();
if(cljs.core.truth_(inst_35590)){
var statearr_35631_35660 = state_35616__$1;
(statearr_35631_35660[(1)] = (8));

} else {
var statearr_35632_35661 = state_35616__$1;
(statearr_35632_35661[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35617 === (14))){
var inst_35609 = (state_35616[(2)]);
var inst_35610 = cljs.core.async.close_BANG_(out);
var state_35616__$1 = (function (){var statearr_35634 = state_35616;
(statearr_35634[(13)] = inst_35609);

return statearr_35634;
})();
var statearr_35635_35662 = state_35616__$1;
(statearr_35635_35662[(2)] = inst_35610);

(statearr_35635_35662[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35617 === (10))){
var inst_35600 = (state_35616[(2)]);
var state_35616__$1 = state_35616;
var statearr_35636_35663 = state_35616__$1;
(statearr_35636_35663[(2)] = inst_35600);

(statearr_35636_35663[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35617 === (8))){
var inst_35580 = (state_35616[(7)]);
var inst_35589 = (state_35616[(11)]);
var tmp35633 = inst_35580;
var inst_35580__$1 = tmp35633;
var inst_35581 = inst_35589;
var state_35616__$1 = (function (){var statearr_35637 = state_35616;
(statearr_35637[(7)] = inst_35580__$1);

(statearr_35637[(8)] = inst_35581);

return statearr_35637;
})();
var statearr_35638_35664 = state_35616__$1;
(statearr_35638_35664[(2)] = null);

(statearr_35638_35664[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12309__auto___35650,out))
;
return ((function (switch__12197__auto__,c__12309__auto___35650,out){
return (function() {
var cljs$core$async$state_machine__12198__auto__ = null;
var cljs$core$async$state_machine__12198__auto____0 = (function (){
var statearr_35642 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_35642[(0)] = cljs$core$async$state_machine__12198__auto__);

(statearr_35642[(1)] = (1));

return statearr_35642;
});
var cljs$core$async$state_machine__12198__auto____1 = (function (state_35616){
while(true){
var ret_value__12199__auto__ = (function (){try{while(true){
var result__12200__auto__ = switch__12197__auto__(state_35616);
if(cljs.core.keyword_identical_QMARK_(result__12200__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12200__auto__;
}
break;
}
}catch (e35643){if((e35643 instanceof Object)){
var ex__12201__auto__ = e35643;
var statearr_35644_35665 = state_35616;
(statearr_35644_35665[(5)] = ex__12201__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_35616);

return cljs.core.cst$kw$recur;
} else {
throw e35643;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12199__auto__,cljs.core.cst$kw$recur)){
var G__35666 = state_35616;
state_35616 = G__35666;
continue;
} else {
return ret_value__12199__auto__;
}
break;
}
});
cljs$core$async$state_machine__12198__auto__ = function(state_35616){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12198__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12198__auto____1.call(this,state_35616);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12198__auto____0;
cljs$core$async$state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12198__auto____1;
return cljs$core$async$state_machine__12198__auto__;
})()
;})(switch__12197__auto__,c__12309__auto___35650,out))
})();
var state__12311__auto__ = (function (){var statearr_35645 = (f__12310__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12310__auto__.cljs$core$IFn$_invoke$arity$0() : f__12310__auto__.call(null));
(statearr_35645[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12309__auto___35650);

return statearr_35645;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12311__auto__);
});})(c__12309__auto___35650,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args35667 = [];
var len__7484__auto___35741 = arguments.length;
var i__7485__auto___35742 = (0);
while(true){
if((i__7485__auto___35742 < len__7484__auto___35741)){
args35667.push((arguments[i__7485__auto___35742]));

var G__35743 = (i__7485__auto___35742 + (1));
i__7485__auto___35742 = G__35743;
continue;
} else {
}
break;
}

var G__35669 = args35667.length;
switch (G__35669) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args35667.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__12309__auto___35745 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12309__auto___35745,out){
return (function (){
var f__12310__auto__ = (function (){var switch__12197__auto__ = ((function (c__12309__auto___35745,out){
return (function (state_35711){
var state_val_35712 = (state_35711[(1)]);
if((state_val_35712 === (7))){
var inst_35707 = (state_35711[(2)]);
var state_35711__$1 = state_35711;
var statearr_35713_35746 = state_35711__$1;
(statearr_35713_35746[(2)] = inst_35707);

(statearr_35713_35746[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35712 === (1))){
var inst_35670 = [];
var inst_35671 = inst_35670;
var inst_35672 = cljs.core.cst$kw$cljs$core$async_SLASH_nothing;
var state_35711__$1 = (function (){var statearr_35714 = state_35711;
(statearr_35714[(7)] = inst_35671);

(statearr_35714[(8)] = inst_35672);

return statearr_35714;
})();
var statearr_35715_35747 = state_35711__$1;
(statearr_35715_35747[(2)] = null);

(statearr_35715_35747[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35712 === (4))){
var inst_35675 = (state_35711[(9)]);
var inst_35675__$1 = (state_35711[(2)]);
var inst_35676 = (inst_35675__$1 == null);
var inst_35677 = cljs.core.not(inst_35676);
var state_35711__$1 = (function (){var statearr_35716 = state_35711;
(statearr_35716[(9)] = inst_35675__$1);

return statearr_35716;
})();
if(inst_35677){
var statearr_35717_35748 = state_35711__$1;
(statearr_35717_35748[(1)] = (5));

} else {
var statearr_35718_35749 = state_35711__$1;
(statearr_35718_35749[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35712 === (15))){
var inst_35701 = (state_35711[(2)]);
var state_35711__$1 = state_35711;
var statearr_35719_35750 = state_35711__$1;
(statearr_35719_35750[(2)] = inst_35701);

(statearr_35719_35750[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35712 === (13))){
var state_35711__$1 = state_35711;
var statearr_35720_35751 = state_35711__$1;
(statearr_35720_35751[(2)] = null);

(statearr_35720_35751[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35712 === (6))){
var inst_35671 = (state_35711[(7)]);
var inst_35696 = inst_35671.length;
var inst_35697 = (inst_35696 > (0));
var state_35711__$1 = state_35711;
if(cljs.core.truth_(inst_35697)){
var statearr_35721_35752 = state_35711__$1;
(statearr_35721_35752[(1)] = (12));

} else {
var statearr_35722_35753 = state_35711__$1;
(statearr_35722_35753[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35712 === (3))){
var inst_35709 = (state_35711[(2)]);
var state_35711__$1 = state_35711;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35711__$1,inst_35709);
} else {
if((state_val_35712 === (12))){
var inst_35671 = (state_35711[(7)]);
var inst_35699 = cljs.core.vec(inst_35671);
var state_35711__$1 = state_35711;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_35711__$1,(15),out,inst_35699);
} else {
if((state_val_35712 === (2))){
var state_35711__$1 = state_35711;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35711__$1,(4),ch);
} else {
if((state_val_35712 === (11))){
var inst_35679 = (state_35711[(10)]);
var inst_35675 = (state_35711[(9)]);
var inst_35689 = (state_35711[(2)]);
var inst_35690 = [];
var inst_35691 = inst_35690.push(inst_35675);
var inst_35671 = inst_35690;
var inst_35672 = inst_35679;
var state_35711__$1 = (function (){var statearr_35723 = state_35711;
(statearr_35723[(11)] = inst_35689);

(statearr_35723[(12)] = inst_35691);

(statearr_35723[(7)] = inst_35671);

(statearr_35723[(8)] = inst_35672);

return statearr_35723;
})();
var statearr_35724_35754 = state_35711__$1;
(statearr_35724_35754[(2)] = null);

(statearr_35724_35754[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35712 === (9))){
var inst_35671 = (state_35711[(7)]);
var inst_35687 = cljs.core.vec(inst_35671);
var state_35711__$1 = state_35711;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_35711__$1,(11),out,inst_35687);
} else {
if((state_val_35712 === (5))){
var inst_35679 = (state_35711[(10)]);
var inst_35675 = (state_35711[(9)]);
var inst_35672 = (state_35711[(8)]);
var inst_35679__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_35675) : f.call(null,inst_35675));
var inst_35680 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_35679__$1,inst_35672);
var inst_35681 = cljs.core.keyword_identical_QMARK_(inst_35672,cljs.core.cst$kw$cljs$core$async_SLASH_nothing);
var inst_35682 = (inst_35680) || (inst_35681);
var state_35711__$1 = (function (){var statearr_35725 = state_35711;
(statearr_35725[(10)] = inst_35679__$1);

return statearr_35725;
})();
if(cljs.core.truth_(inst_35682)){
var statearr_35726_35755 = state_35711__$1;
(statearr_35726_35755[(1)] = (8));

} else {
var statearr_35727_35756 = state_35711__$1;
(statearr_35727_35756[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35712 === (14))){
var inst_35704 = (state_35711[(2)]);
var inst_35705 = cljs.core.async.close_BANG_(out);
var state_35711__$1 = (function (){var statearr_35729 = state_35711;
(statearr_35729[(13)] = inst_35704);

return statearr_35729;
})();
var statearr_35730_35757 = state_35711__$1;
(statearr_35730_35757[(2)] = inst_35705);

(statearr_35730_35757[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35712 === (10))){
var inst_35694 = (state_35711[(2)]);
var state_35711__$1 = state_35711;
var statearr_35731_35758 = state_35711__$1;
(statearr_35731_35758[(2)] = inst_35694);

(statearr_35731_35758[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35712 === (8))){
var inst_35679 = (state_35711[(10)]);
var inst_35671 = (state_35711[(7)]);
var inst_35675 = (state_35711[(9)]);
var inst_35684 = inst_35671.push(inst_35675);
var tmp35728 = inst_35671;
var inst_35671__$1 = tmp35728;
var inst_35672 = inst_35679;
var state_35711__$1 = (function (){var statearr_35732 = state_35711;
(statearr_35732[(14)] = inst_35684);

(statearr_35732[(7)] = inst_35671__$1);

(statearr_35732[(8)] = inst_35672);

return statearr_35732;
})();
var statearr_35733_35759 = state_35711__$1;
(statearr_35733_35759[(2)] = null);

(statearr_35733_35759[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12309__auto___35745,out))
;
return ((function (switch__12197__auto__,c__12309__auto___35745,out){
return (function() {
var cljs$core$async$state_machine__12198__auto__ = null;
var cljs$core$async$state_machine__12198__auto____0 = (function (){
var statearr_35737 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_35737[(0)] = cljs$core$async$state_machine__12198__auto__);

(statearr_35737[(1)] = (1));

return statearr_35737;
});
var cljs$core$async$state_machine__12198__auto____1 = (function (state_35711){
while(true){
var ret_value__12199__auto__ = (function (){try{while(true){
var result__12200__auto__ = switch__12197__auto__(state_35711);
if(cljs.core.keyword_identical_QMARK_(result__12200__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12200__auto__;
}
break;
}
}catch (e35738){if((e35738 instanceof Object)){
var ex__12201__auto__ = e35738;
var statearr_35739_35760 = state_35711;
(statearr_35739_35760[(5)] = ex__12201__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_35711);

return cljs.core.cst$kw$recur;
} else {
throw e35738;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12199__auto__,cljs.core.cst$kw$recur)){
var G__35761 = state_35711;
state_35711 = G__35761;
continue;
} else {
return ret_value__12199__auto__;
}
break;
}
});
cljs$core$async$state_machine__12198__auto__ = function(state_35711){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12198__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12198__auto____1.call(this,state_35711);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12198__auto____0;
cljs$core$async$state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12198__auto____1;
return cljs$core$async$state_machine__12198__auto__;
})()
;})(switch__12197__auto__,c__12309__auto___35745,out))
})();
var state__12311__auto__ = (function (){var statearr_35740 = (f__12310__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12310__auto__.cljs$core$IFn$_invoke$arity$0() : f__12310__auto__.call(null));
(statearr_35740[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12309__auto___35745);

return statearr_35740;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12311__auto__);
});})(c__12309__auto___35745,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;

