// Compiled by ClojureScript 1.9.229 {:static-fns true, :optimize-constants true}
goog.provide('hatti.charting');
goog.require('cljs.core');
goog.require('chimera.js_interop');
goog.require('c2.layout.histogram');
goog.require('chimera.date');
goog.require('hatti.maths');
goog.require('cljs_time.coerce');
goog.require('c2.scale');
goog.require('cljs_time.format');
goog.require('hatti.ona.forms');
goog.require('c2.svg');
goog.require('clojure.string');
hatti.charting.millis_in_day = (86400000);
/**
 * Parse an integer from a string.
 */
hatti.charting.parse_int = (function hatti$charting$parse_int(st){
var ans = parseInt(st);
if(cljs.core.truth_(isNaN(ans))){
return null;
} else {
return ans;
}
});
hatti.charting.parse_date = (function hatti$charting$parse_date(date_string){
if(cljs.core.truth_(date_string)){
return hatti.maths.floor((cljs_time.coerce.to_long((new Date(date_string))) / hatti.charting.millis_in_day));
} else {
return null;
}
});
/**
 * Remove the colon in a time string
 *   String -> String
 */
hatti.charting.parse_time = (function hatti$charting$parse_time(time_string){
if(cljs.core.truth_(time_string)){
return hatti.charting.parse_int(clojure.string.replace(time_string,/:/,""));
} else {
return null;
}
});
/**
 * Converts string to integer, for typ (int|date).
 */
hatti.charting.str__GT_int = (function hatti$charting$str__GT_int(typ){
var G__18729 = typ;
switch (G__18729) {
case "int":
return hatti.charting.parse_int;

break;
case "date":
return hatti.charting.parse_date;

break;
case "time":
return hatti.charting.parse_time;

break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(typ)].join('')));

}
});
hatti.charting.time__GT_string = (function hatti$charting$time__GT_string(time){
return clojure.string.replace([cljs.core.str(time)].join(''),/..$/,(function (p1__18731_SHARP_){
return [cljs.core.str(":"),cljs.core.str(p1__18731_SHARP_)].join('');
}));
});
/**
 * Converts integers to strings, for type (int|date).
 * Optional digits parameter = number of digits after decimal, default is 1.
 */
hatti.charting.int__GT_str = (function hatti$charting$int__GT_str(var_args){
var args__7491__auto__ = [];
var len__7484__auto___18742 = arguments.length;
var i__7485__auto___18743 = (0);
while(true){
if((i__7485__auto___18743 < len__7484__auto___18742)){
args__7491__auto__.push((arguments[i__7485__auto___18743]));

var G__18744 = (i__7485__auto___18743 + (1));
i__7485__auto___18743 = G__18744;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return hatti.charting.int__GT_str.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

hatti.charting.int__GT_str.cljs$core$IFn$_invoke$arity$variadic = (function (typ,p__18738){
var map__18739 = p__18738;
var map__18739__$1 = ((((!((map__18739 == null)))?((((map__18739.cljs$lang$protocol_mask$partition0$ & (64))) || (map__18739.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__18739):map__18739);
var digits = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__18739__$1,cljs.core.cst$kw$digits,(1));
var int_fmt_s = [cljs.core.str("%."),cljs.core.str(digits),cljs.core.str("f")].join('');
var d__GT_millis = ((function (int_fmt_s,map__18739,map__18739__$1,digits){
return (function (p1__18732_SHARP_){
return (hatti.charting.millis_in_day * p1__18732_SHARP_);
});})(int_fmt_s,map__18739,map__18739__$1,digits))
;
var date__GT_str = ((function (int_fmt_s,d__GT_millis,map__18739,map__18739__$1,digits){
return (function (p1__18733_SHARP_){
if(cljs.core.truth_(p1__18733_SHARP_)){
return chimera.date.format_date(p1__18733_SHARP_);
} else {
return null;
}
});})(int_fmt_s,d__GT_millis,map__18739,map__18739__$1,digits))
;
var G__18741 = typ;
switch (G__18741) {
case "int":
return ((function (G__18741,int_fmt_s,d__GT_millis,date__GT_str,map__18739,map__18739__$1,digits){
return (function (p1__18734_SHARP_){
return chimera.js_interop.format.cljs$core$IFn$_invoke$arity$variadic(int_fmt_s,cljs.core.array_seq([p1__18734_SHARP_], 0));
});
;})(G__18741,int_fmt_s,d__GT_millis,date__GT_str,map__18739,map__18739__$1,digits))

break;
case "date":
return ((function (G__18741,int_fmt_s,d__GT_millis,date__GT_str,map__18739,map__18739__$1,digits){
return (function (p1__18735_SHARP_){
return date__GT_str(d__GT_millis(p1__18735_SHARP_));
});
;})(G__18741,int_fmt_s,d__GT_millis,date__GT_str,map__18739,map__18739__$1,digits))

break;
case "time":
return hatti.charting.time__GT_string;

break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(typ)].join('')));

}
});

hatti.charting.int__GT_str.cljs$lang$maxFixedArity = (1);

hatti.charting.int__GT_str.cljs$lang$applyTo = (function (seq18736){
var G__18737 = cljs.core.first(seq18736);
var seq18736__$1 = cljs.core.next(seq18736);
return hatti.charting.int__GT_str.cljs$core$IFn$_invoke$arity$variadic(G__18737,seq18736__$1);
});

/**
 * Converts a range of typ (int|date) to a string.
 */
hatti.charting.range__GT_str = (function hatti$charting$range__GT_str(p__18746,typ){
var vec__18753 = p__18746;
var minimum = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18753,(0),null);
var maximum = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18753,(1),null);
var vec__18756 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [hatti.maths.ceil(minimum),hatti.maths.floor(maximum)], null);
var minimum__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18756,(0),null);
var maximum__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18756,(1),null);
var fmt = hatti.charting.int__GT_str.cljs$core$IFn$_invoke$arity$variadic(typ,cljs.core.array_seq([cljs.core.cst$kw$digits,(0)], 0));
if((maximum__$1 <= minimum__$1)){
return (fmt.cljs$core$IFn$_invoke$arity$1 ? fmt.cljs$core$IFn$_invoke$arity$1(minimum__$1) : fmt.call(null,minimum__$1));
} else {
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(" to ",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(fmt.cljs$core$IFn$_invoke$arity$1 ? fmt.cljs$core$IFn$_invoke$arity$1(minimum__$1) : fmt.call(null,minimum__$1)),(fmt.cljs$core$IFn$_invoke$arity$1 ? fmt.cljs$core$IFn$_invoke$arity$1(maximum__$1) : fmt.call(null,maximum__$1))], null));
}
});
/**
 * Given a list of answers, returns each one as a bin, in string form.
 * nil is mapped to nil. The bins, in order, are returned as metadata.
 * eg. (evenly-spaced-bins [1 2 10] 5 'int') => ['1 to 2' '1 to 2' '9 to 10']
 * metadata of this above value would be:
 * {:bins ['1 to 2', '3 to 4', '5 to 6', '7 to 8', '9 to 10']}
 */
hatti.charting.evenly_spaced_bins = (function hatti$charting$evenly_spaced_bins(answers,bins,type_STAR_){
var numbers = cljs.core.map.cljs$core$IFn$_invoke$arity$2(hatti.charting.str__GT_int(type_STAR_),answers);
var mx = cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core.max,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,numbers));
var mn = cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core.min,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,numbers));
var s = c2.scale.linear.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.cst$kw$domain,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [mn,mx], null),cljs.core.cst$kw$range,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(bins - ((1) / (10000)))], null)], 0));
var is = cljs.core.map.cljs$core$IFn$_invoke$arity$2(hatti.maths.floor,cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (numbers,mx,mn,s){
return (function (p1__18759_SHARP_){
if(cljs.core.truth_(p1__18759_SHARP_)){
return (s.cljs$core$IFn$_invoke$arity$1 ? s.cljs$core$IFn$_invoke$arity$1(p1__18759_SHARP_) : s.call(null,p1__18759_SHARP_));
} else {
return null;
}
});})(numbers,mx,mn,s))
,numbers));
var t = c2.scale.linear.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.cst$kw$domain,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),bins], null),cljs.core.cst$kw$range,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [mn,mx], null)], 0));
var lbounds = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.float$,cljs.core.map.cljs$core$IFn$_invoke$arity$2(t,cljs.core.range.cljs$core$IFn$_invoke$arity$1(bins))));
var ubounds = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (numbers,mx,mn,s,is,t,lbounds){
return (function (p1__18760_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__18760_SHARP_,hatti.maths.floor(p1__18760_SHARP_))){
return (p1__18760_SHARP_ - (1));
} else {
return p1__18760_SHARP_;
}
});})(numbers,mx,mn,s,is,t,lbounds))
,cljs.core.drop.cljs$core$IFn$_invoke$arity$2((1),lbounds)),mx);
var fmt = hatti.charting.int__GT_str.cljs$core$IFn$_invoke$arity$variadic(type_STAR_,cljs.core.array_seq([cljs.core.cst$kw$digits,(0)], 0));
var strings = cljs.core.mapv.cljs$core$IFn$_invoke$arity$3(((function (numbers,mx,mn,s,is,t,lbounds,ubounds,fmt){
return (function (p1__18761_SHARP_,p2__18762_SHARP_){
return hatti.charting.range__GT_str(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__18761_SHARP_,p2__18762_SHARP_], null),type_STAR_);
});})(numbers,mx,mn,s,is,t,lbounds,ubounds,fmt))
,lbounds,ubounds);
var results = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (numbers,mx,mn,s,is,t,lbounds,ubounds,fmt,strings){
return (function (i){
if(cljs.core.truth_(i)){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(strings,(i | (0)));
} else {
return null;
}
});})(numbers,mx,mn,s,is,t,lbounds,ubounds,fmt,strings))
,is);
var strings__$1 = cljs.core.vec(cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(strings));
return cljs.core.with_meta(results,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$bins,((cljs.core.contains_QMARK_(cljs.core.set(answers),null))?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(strings__$1,null):strings__$1)], null));
});
/**
 * Take chart-data from the ona API, returns label->count map.
 * eg. Input: {:field_xpath 'D' :data [{:count 2 :D ['Option_1']}]}
 * Output: {:Option_1 2}
 * eg. Input: {:field_xpath 'D' :data [{:count 1 :D ['O1' 'O_2']
 * :count 2 :D ['O1']}]}
 * Output: {:Option_1 3 :O_2 1}
 */
hatti.charting.label_count_pairs = (function hatti$charting$label_count_pairs(var_args){
var args18765 = [];
var len__7484__auto___18776 = arguments.length;
var i__7485__auto___18777 = (0);
while(true){
if((i__7485__auto___18777 < len__7484__auto___18776)){
args18765.push((arguments[i__7485__auto___18777]));

var G__18778 = (i__7485__auto___18777 + (1));
i__7485__auto___18777 = G__18778;
continue;
} else {
}
break;
}

var G__18767 = args18765.length;
switch (G__18767) {
case 1:
return hatti.charting.label_count_pairs.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return hatti.charting.label_count_pairs.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18765.length)].join('')));

}
});

hatti.charting.label_count_pairs.cljs$core$IFn$_invoke$arity$1 = (function (chart_data){
return hatti.charting.label_count_pairs.cljs$core$IFn$_invoke$arity$2(chart_data,null);
});

hatti.charting.label_count_pairs.cljs$core$IFn$_invoke$arity$2 = (function (chart_data,language){
var map__18768 = chart_data;
var map__18768__$1 = ((((!((map__18768 == null)))?((((map__18768.cljs$lang$protocol_mask$partition0$ & (64))) || (map__18768.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__18768):map__18768);
var data = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18768__$1,cljs.core.cst$kw$data);
var field_xpath = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18768__$1,cljs.core.cst$kw$field_xpath);
var unboxed = (function (){var iter__7189__auto__ = ((function (map__18768,map__18768__$1,data,field_xpath){
return (function hatti$charting$iter__18770(s__18771){
return (new cljs.core.LazySeq(null,((function (map__18768,map__18768__$1,data,field_xpath){
return (function (){
var s__18771__$1 = s__18771;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__18771__$1);
if(temp__4657__auto__){
var s__18771__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__18771__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__18771__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__18773 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__18772 = (0);
while(true){
if((i__18772 < size__7188__auto__)){
var data_item = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__18772);
cljs.core.chunk_append(b__18773,(function (){var labels = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(field_xpath).call(null,data_item);
var count = cljs.core.cst$kw$count.cljs$core$IFn$_invoke$arity$1(data_item);
var labelify = ((function (i__18772,labels,count,data_item,c__7187__auto__,size__7188__auto__,b__18773,s__18771__$2,temp__4657__auto__,map__18768,map__18768__$1,data,field_xpath){
return (function (p1__18763_SHARP_){
return hatti.ona.forms.get_label.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$label,p1__18763_SHARP_], null),cljs.core.array_seq([language], 0));
});})(i__18772,labels,count,data_item,c__7187__auto__,size__7188__auto__,b__18773,s__18771__$2,temp__4657__auto__,map__18768,map__18768__$1,data,field_xpath))
;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (i__18772,labels,count,labelify,data_item,c__7187__auto__,size__7188__auto__,b__18773,s__18771__$2,temp__4657__auto__,map__18768,map__18768__$1,data,field_xpath){
return (function (p1__18764_SHARP_){
return cljs.core.PersistentHashMap.fromArrays([labelify(p1__18764_SHARP_)],[count]);
});})(i__18772,labels,count,labelify,data_item,c__7187__auto__,size__7188__auto__,b__18773,s__18771__$2,temp__4657__auto__,map__18768,map__18768__$1,data,field_xpath))
,labels);
})());

var G__18780 = (i__18772 + (1));
i__18772 = G__18780;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__18773),hatti$charting$iter__18770(cljs.core.chunk_rest(s__18771__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__18773),null);
}
} else {
var data_item = cljs.core.first(s__18771__$2);
return cljs.core.cons((function (){var labels = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(field_xpath).call(null,data_item);
var count = cljs.core.cst$kw$count.cljs$core$IFn$_invoke$arity$1(data_item);
var labelify = ((function (labels,count,data_item,s__18771__$2,temp__4657__auto__,map__18768,map__18768__$1,data,field_xpath){
return (function (p1__18763_SHARP_){
return hatti.ona.forms.get_label.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$label,p1__18763_SHARP_], null),cljs.core.array_seq([language], 0));
});})(labels,count,data_item,s__18771__$2,temp__4657__auto__,map__18768,map__18768__$1,data,field_xpath))
;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (labels,count,labelify,data_item,s__18771__$2,temp__4657__auto__,map__18768,map__18768__$1,data,field_xpath){
return (function (p1__18764_SHARP_){
return cljs.core.PersistentHashMap.fromArrays([labelify(p1__18764_SHARP_)],[count]);
});})(labels,count,labelify,data_item,s__18771__$2,temp__4657__auto__,map__18768,map__18768__$1,data,field_xpath))
,labels);
})(),hatti$charting$iter__18770(cljs.core.rest(s__18771__$2)));
}
} else {
return null;
}
break;
}
});})(map__18768,map__18768__$1,data,field_xpath))
,null,null));
});})(map__18768,map__18768__$1,data,field_xpath))
;
return iter__7189__auto__(data);
})();
return cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3(cljs.core.last,cljs.core._GT_,cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.merge_with,cljs.core._PLUS_,cljs.core.flatten(unboxed)));
});

hatti.charting.label_count_pairs.cljs$lang$maxFixedArity = 2;

/**
 * Determine number of bins if there are n possible of values of data.
 *   Custom algorithm, based on a pleasant range of bins being between
 *   roughly 7 and 15 (though customizable). Idea is that we try to divide
 *   n into a number between 
 */
hatti.charting.num_bins = (function hatti$charting$num_bins(var_args){
var args__7491__auto__ = [];
var len__7484__auto___18786 = arguments.length;
var i__7485__auto___18787 = (0);
while(true){
if((i__7485__auto___18787 < len__7484__auto___18786)){
args__7491__auto__.push((arguments[i__7485__auto___18787]));

var G__18788 = (i__7485__auto___18787 + (1));
i__7485__auto___18787 = G__18788;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return hatti.charting.num_bins.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

hatti.charting.num_bins.cljs$core$IFn$_invoke$arity$variadic = (function (n,p__18783){
var map__18784 = p__18783;
var map__18784__$1 = ((((!((map__18784 == null)))?((((map__18784.cljs$lang$protocol_mask$partition0$ & (64))) || (map__18784.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__18784):map__18784);
var data_type = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__18784__$1,cljs.core.cst$kw$data_DASH_type,"int");
var rough_min = (7);
var rough_max = (15);
var real_max = (24);
var full_range = cljs.core.range.cljs$core$IFn$_invoke$arity$2(rough_min,rough_max);
var best_guess = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.max,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(hatti.maths.gcd,n),full_range));
if((best_guess < rough_min)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$3(cljs.core.min,real_max,n),cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(hatti.maths.lcm,n),full_range));
} else {
return best_guess;
}
});

hatti.charting.num_bins.cljs$lang$maxFixedArity = (1);

hatti.charting.num_bins.cljs$lang$applyTo = (function (seq18781){
var G__18782 = cljs.core.first(seq18781);
var seq18781__$1 = cljs.core.next(seq18781);
return hatti.charting.num_bins.cljs$core$IFn$_invoke$arity$variadic(G__18782,seq18781__$1);
});

/**
 * Turn numerical / date chart-data from ona API histogram-friendly.
 *   Return data looks like [(x dx y)] with-meta {:bins num-bins}.
 */
hatti.charting.extract_data_for_histogram = (function hatti$charting$extract_data_for_histogram(var_args){
var args__7491__auto__ = [];
var len__7484__auto___18802 = arguments.length;
var i__7485__auto___18803 = (0);
while(true){
if((i__7485__auto___18803 < len__7484__auto___18802)){
args__7491__auto__.push((arguments[i__7485__auto___18803]));

var G__18804 = (i__7485__auto___18803 + (1));
i__7485__auto___18803 = G__18804;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return hatti.charting.extract_data_for_histogram.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

hatti.charting.extract_data_for_histogram.cljs$core$IFn$_invoke$arity$variadic = (function (chart_data,p__18791){
var map__18792 = p__18791;
var map__18792__$1 = ((((!((map__18792 == null)))?((((map__18792.cljs$lang$protocol_mask$partition0$ & (64))) || (map__18792.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__18792):map__18792);
var data_type = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__18792__$1,cljs.core.cst$kw$data_DASH_type,"int");
var map__18794 = chart_data;
var map__18794__$1 = ((((!((map__18794 == null)))?((((map__18794.cljs$lang$protocol_mask$partition0$ & (64))) || (map__18794.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__18794):map__18794);
var data = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18794__$1,cljs.core.cst$kw$data);
var field_xpath = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18794__$1,cljs.core.cst$kw$field_xpath);
var retype_fn = hatti.charting.str__GT_int(data_type);
var qn_key = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(field_xpath);
var retyped_data = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (map__18794,map__18794__$1,data,field_xpath,retype_fn,qn_key,map__18792,map__18792__$1,data_type){
return (function (el){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(el,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [qn_key], null),retype_fn);
});})(map__18794,map__18794__$1,data,field_xpath,retype_fn,qn_key,map__18792,map__18792__$1,data_type))
,data);
var data_range = (cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.max,cljs.core.map.cljs$core$IFn$_invoke$arity$2(qn_key,retyped_data)) - cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.min,cljs.core.map.cljs$core$IFn$_invoke$arity$2(qn_key,retyped_data)));
var bins = (((data_range === (0)))?(1):hatti.charting.num_bins.cljs$core$IFn$_invoke$arity$variadic(data_range,cljs.core.array_seq([cljs.core.cst$kw$data_DASH_type,data_type], 0)));
var binned_data = c2.layout.histogram.histogram.cljs$core$IFn$_invoke$arity$variadic(retyped_data,cljs.core.array_seq([cljs.core.cst$kw$value,qn_key,cljs.core.cst$kw$bins,bins], 0));
return cljs.core.with_meta((function (){var iter__7189__auto__ = ((function (map__18794,map__18794__$1,data,field_xpath,retype_fn,qn_key,retyped_data,data_range,bins,binned_data,map__18792,map__18792__$1,data_type){
return (function hatti$charting$iter__18796(s__18797){
return (new cljs.core.LazySeq(null,((function (map__18794,map__18794__$1,data,field_xpath,retype_fn,qn_key,retyped_data,data_range,bins,binned_data,map__18792,map__18792__$1,data_type){
return (function (){
var s__18797__$1 = s__18797;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__18797__$1);
if(temp__4657__auto__){
var s__18797__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__18797__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__18797__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__18799 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__18798 = (0);
while(true){
if((i__18798 < size__7188__auto__)){
var data_item = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__18798);
cljs.core.chunk_append(b__18799,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$x.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(data_item)),cljs.core.cst$kw$dx.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(data_item)),cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$count,data_item))], null));

var G__18805 = (i__18798 + (1));
i__18798 = G__18805;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__18799),hatti$charting$iter__18796(cljs.core.chunk_rest(s__18797__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__18799),null);
}
} else {
var data_item = cljs.core.first(s__18797__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$x.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(data_item)),cljs.core.cst$kw$dx.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(data_item)),cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$count,data_item))], null),hatti$charting$iter__18796(cljs.core.rest(s__18797__$2)));
}
} else {
return null;
}
break;
}
});})(map__18794,map__18794__$1,data,field_xpath,retype_fn,qn_key,retyped_data,data_range,bins,binned_data,map__18792,map__18792__$1,data_type))
,null,null));
});})(map__18794,map__18794__$1,data,field_xpath,retype_fn,qn_key,retyped_data,data_range,bins,binned_data,map__18792,map__18792__$1,data_type))
;
return iter__7189__auto__(binned_data);
})(),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$bins,bins], null));
});

hatti.charting.extract_data_for_histogram.cljs$lang$maxFixedArity = (1);

hatti.charting.extract_data_for_histogram.cljs$lang$applyTo = (function (seq18789){
var G__18790 = cljs.core.first(seq18789);
var seq18789__$1 = cljs.core.next(seq18789);
return hatti.charting.extract_data_for_histogram.cljs$core$IFn$_invoke$arity$variadic(G__18790,seq18789__$1);
});

/**
 * Produces a linear mapping [0,max-count] -> [0, max-length], for data which
 * is a vector, each element a map with key :count. If total-asmax?, then
 * linear map is [0,total-count] -> [0, max-length].
 */
hatti.charting.counts__GT_lengths = (function hatti$charting$counts__GT_lengths(var_args){
var args__7491__auto__ = [];
var len__7484__auto___18812 = arguments.length;
var i__7485__auto___18813 = (0);
while(true){
if((i__7485__auto___18813 < len__7484__auto___18812)){
args__7491__auto__.push((arguments[i__7485__auto___18813]));

var G__18814 = (i__7485__auto___18813 + (1));
i__7485__auto___18813 = G__18814;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((2) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((2)),(0),null)):null);
return hatti.charting.counts__GT_lengths.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7492__auto__);
});

hatti.charting.counts__GT_lengths.cljs$core$IFn$_invoke$arity$variadic = (function (data,max_length,p__18809){
var map__18810 = p__18809;
var map__18810__$1 = ((((!((map__18810 == null)))?((((map__18810.cljs$lang$protocol_mask$partition0$ & (64))) || (map__18810.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__18810):map__18810);
var total_as_max_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18810__$1,cljs.core.cst$kw$total_DASH_as_DASH_max_QMARK_);
var datamin_as_min_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18810__$1,cljs.core.cst$kw$datamin_DASH_as_DASH_min_QMARK_);
var counts = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$count,data);
var xmax = (cljs.core.truth_(total_as_max_QMARK_)?cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._PLUS_,(0),counts):cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.max,(0),counts));
var xmin = (cljs.core.truth_(datamin_as_min_QMARK_)?cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.min,(0),counts):(0));
var scale = c2.scale.linear.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.cst$kw$domain,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [xmin,xmax], null),cljs.core.cst$kw$range,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),max_length], null)], 0));
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(scale,counts);
});

hatti.charting.counts__GT_lengths.cljs$lang$maxFixedArity = (2);

hatti.charting.counts__GT_lengths.cljs$lang$applyTo = (function (seq18806){
var G__18807 = cljs.core.first(seq18806);
var seq18806__$1 = cljs.core.next(seq18806);
var G__18808 = cljs.core.first(seq18806__$1);
var seq18806__$2 = cljs.core.next(seq18806__$1);
return hatti.charting.counts__GT_lengths.cljs$core$IFn$_invoke$arity$variadic(G__18807,G__18808,seq18806__$2);
});

hatti.charting.response_count_message = (function hatti$charting$response_count_message(response_count){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$t_DASH_right$t_DASH_grey,[cljs.core.str("Based on "),cljs.core.str(response_count),cljs.core.str(" responses.")].join('')], null);
});
/**
 * Create numeric (or date) chart out of some chart-data from ona API.
 */
hatti.charting.numeric_chart = (function hatti$charting$numeric_chart(var_args){
var args__7491__auto__ = [];
var len__7484__auto___18861 = arguments.length;
var i__7485__auto___18862 = (0);
while(true){
if((i__7485__auto___18862 < len__7484__auto___18861)){
args__7491__auto__.push((arguments[i__7485__auto___18862]));

var G__18863 = (i__7485__auto___18862 + (1));
i__7485__auto___18862 = G__18863;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return hatti.charting.numeric_chart.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

hatti.charting.numeric_chart.cljs$core$IFn$_invoke$arity$variadic = (function (chart_data,p__18817){
var map__18818 = p__18817;
var map__18818__$1 = ((((!((map__18818 == null)))?((((map__18818.cljs$lang$protocol_mask$partition0$ & (64))) || (map__18818.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__18818):map__18818);
var data_type = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__18818__$1,cljs.core.cst$kw$data_DASH_type,"int");
var chart_width = 700.0;
var chart_height = 300.0;
var margin = 33.0;
var small_margin = 2.0;
var y_lim = 8.0;
var neg_margin = (-15);
var extracted_data = hatti.charting.extract_data_for_histogram.cljs$core$IFn$_invoke$arity$variadic(chart_data,cljs.core.array_seq([cljs.core.cst$kw$data_DASH_type,data_type], 0));
var map__18820 = cljs.core.meta(chart_data);
var map__18820__$1 = ((((!((map__18820 == null)))?((((map__18820.cljs$lang$protocol_mask$partition0$ & (64))) || (map__18820.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__18820):map__18820);
var nil_count = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18820__$1,cljs.core.cst$kw$nil_DASH_count);
var non_nil_count = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18820__$1,cljs.core.cst$kw$non_DASH_nil_DASH_count);
var bins = cljs.core.cst$kw$bins.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(extracted_data));
var x_series = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first,extracted_data);
var dx_series = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.second,extracted_data);
var y_series = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.last,extracted_data);
var xmin = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.min,x_series);
var xmax = (cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.max,x_series) + cljs.core.last(dx_series));
var x_scale = c2.scale.linear.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.cst$kw$domain,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [xmin,xmax], null),cljs.core.cst$kw$range,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),chart_width], null)], 0));
var y_scale = c2.scale.linear.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.cst$kw$domain,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.max,y_series)], null),cljs.core.cst$kw$range,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),chart_height], null)], 0));
var bin_width = hatti.maths.floor(((chart_width / bins) - small_margin));
var x_ticks = cljs.core.take_nth.cljs$core$IFn$_invoke$arity$2((2),cljs.core.rest(x_series));
var fmt = hatti.charting.int__GT_str(data_type);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(extracted_data))){
var vec__18822 = cljs.core.first(extracted_data);
var value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18822,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18822,(1),null);
var total = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18822,(2),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$p,total," records have identical value: ",(fmt.cljs$core$IFn$_invoke$arity$1 ? fmt.cljs$core$IFn$_invoke$arity$1(value) : fmt.call(null,value))], null)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$svg,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$width,(margin + chart_width),cljs.core.cst$kw$height,(margin + chart_height)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$g$chart,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$transform,c2.svg.translate(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [margin,(0)], null))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$g,(function (){var iter__7189__auto__ = ((function (chart_width,chart_height,margin,small_margin,y_lim,neg_margin,extracted_data,map__18820,map__18820__$1,nil_count,non_nil_count,bins,x_series,dx_series,y_series,xmin,xmax,x_scale,y_scale,bin_width,x_ticks,fmt,map__18818,map__18818__$1,data_type){
return (function hatti$charting$iter__18825(s__18826){
return (new cljs.core.LazySeq(null,((function (chart_width,chart_height,margin,small_margin,y_lim,neg_margin,extracted_data,map__18820,map__18820__$1,nil_count,non_nil_count,bins,x_series,dx_series,y_series,xmin,xmax,x_scale,y_scale,bin_width,x_ticks,fmt,map__18818,map__18818__$1,data_type){
return (function (){
var s__18826__$1 = s__18826;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__18826__$1);
if(temp__4657__auto__){
var s__18826__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__18826__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__18826__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__18828 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__18827 = (0);
while(true){
if((i__18827 < size__7188__auto__)){
var vec__18843 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__18827);
var x = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18843,(0),null);
var dx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18843,(1),null);
var y = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18843,(2),null);
cljs.core.chunk_append(b__18828,(function (){var x_scaled = (x_scale.cljs$core$IFn$_invoke$arity$1 ? x_scale.cljs$core$IFn$_invoke$arity$1(x) : x_scale.call(null,x));
var y_scaled = (y_scale.cljs$core$IFn$_invoke$arity$1 ? y_scale.cljs$core$IFn$_invoke$arity$1(y) : y_scale.call(null,y));
var vec__18846 = (((((0) < y_scaled)) && ((y_scaled < y_lim)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [small_margin,neg_margin,"out-of-bar"], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [y_scaled,small_margin,"in-bar"], null));
var y_scaled__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18846,(0),null);
var txt_ht = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18846,(1),null);
var txt_cls = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18846,(2),null);
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$g$bars,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$transform,c2.svg.translate(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [x_scaled,(chart_height - y_scaled__$1)], null))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$g,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$rect,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$x,(1),cljs.core.cst$kw$height,y_scaled__$1,cljs.core.cst$kw$width,bin_width], null)], null)], null),(((y_scaled__$1 > (0)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$text,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$y,txt_ht,cljs.core.cst$kw$x,(bin_width / 2.0),cljs.core.cst$kw$dy,"1em",cljs.core.cst$kw$text_DASH_anchor,"middle",cljs.core.cst$kw$class,txt_cls], null),y], null):null)], null);
})());

var G__18864 = (i__18827 + (1));
i__18827 = G__18864;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__18828),hatti$charting$iter__18825(cljs.core.chunk_rest(s__18826__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__18828),null);
}
} else {
var vec__18849 = cljs.core.first(s__18826__$2);
var x = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18849,(0),null);
var dx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18849,(1),null);
var y = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18849,(2),null);
return cljs.core.cons((function (){var x_scaled = (x_scale.cljs$core$IFn$_invoke$arity$1 ? x_scale.cljs$core$IFn$_invoke$arity$1(x) : x_scale.call(null,x));
var y_scaled = (y_scale.cljs$core$IFn$_invoke$arity$1 ? y_scale.cljs$core$IFn$_invoke$arity$1(y) : y_scale.call(null,y));
var vec__18852 = (((((0) < y_scaled)) && ((y_scaled < y_lim)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [small_margin,neg_margin,"out-of-bar"], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [y_scaled,small_margin,"in-bar"], null));
var y_scaled__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18852,(0),null);
var txt_ht = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18852,(1),null);
var txt_cls = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18852,(2),null);
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$g$bars,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$transform,c2.svg.translate(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [x_scaled,(chart_height - y_scaled__$1)], null))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$g,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$rect,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$x,(1),cljs.core.cst$kw$height,y_scaled__$1,cljs.core.cst$kw$width,bin_width], null)], null)], null),(((y_scaled__$1 > (0)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$text,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$y,txt_ht,cljs.core.cst$kw$x,(bin_width / 2.0),cljs.core.cst$kw$dy,"1em",cljs.core.cst$kw$text_DASH_anchor,"middle",cljs.core.cst$kw$class,txt_cls], null),y], null):null)], null);
})(),hatti$charting$iter__18825(cljs.core.rest(s__18826__$2)));
}
} else {
return null;
}
break;
}
});})(chart_width,chart_height,margin,small_margin,y_lim,neg_margin,extracted_data,map__18820,map__18820__$1,nil_count,non_nil_count,bins,x_series,dx_series,y_series,xmin,xmax,x_scale,y_scale,bin_width,x_ticks,fmt,map__18818,map__18818__$1,data_type))
,null,null));
});})(chart_width,chart_height,margin,small_margin,y_lim,neg_margin,extracted_data,map__18820,map__18820__$1,nil_count,non_nil_count,bins,x_series,dx_series,y_series,xmin,xmax,x_scale,y_scale,bin_width,x_ticks,fmt,map__18818,map__18818__$1,data_type))
;
return iter__7189__auto__(extracted_data);
})()], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$g$axis,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$transform,c2.svg.translate(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),chart_height], null))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$line,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$x1,(0),cljs.core.cst$kw$x2,chart_width], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$g,(function (){var iter__7189__auto__ = ((function (chart_width,chart_height,margin,small_margin,y_lim,neg_margin,extracted_data,map__18820,map__18820__$1,nil_count,non_nil_count,bins,x_series,dx_series,y_series,xmin,xmax,x_scale,y_scale,bin_width,x_ticks,fmt,map__18818,map__18818__$1,data_type){
return (function hatti$charting$iter__18855(s__18856){
return (new cljs.core.LazySeq(null,((function (chart_width,chart_height,margin,small_margin,y_lim,neg_margin,extracted_data,map__18820,map__18820__$1,nil_count,non_nil_count,bins,x_series,dx_series,y_series,xmin,xmax,x_scale,y_scale,bin_width,x_ticks,fmt,map__18818,map__18818__$1,data_type){
return (function (){
var s__18856__$1 = s__18856;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__18856__$1);
if(temp__4657__auto__){
var s__18856__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__18856__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__18856__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__18858 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__18857 = (0);
while(true){
if((i__18857 < size__7188__auto__)){
var x = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__18857);
cljs.core.chunk_append(b__18858,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$g$tick,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$transform,c2.svg.translate(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(x_scale.cljs$core$IFn$_invoke$arity$1 ? x_scale.cljs$core$IFn$_invoke$arity$1(x) : x_scale.call(null,x)),(0)], null))], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$text,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$y,(25),cljs.core.cst$kw$text_DASH_anchor,"middle",cljs.core.cst$kw$class,data_type], null),(fmt.cljs$core$IFn$_invoke$arity$1 ? fmt.cljs$core$IFn$_invoke$arity$1(x) : fmt.call(null,x))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$line,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$class,"tick",cljs.core.cst$kw$y2,(10),cljs.core.cst$kw$x2,(0)], null)], null)], null));

var G__18865 = (i__18857 + (1));
i__18857 = G__18865;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__18858),hatti$charting$iter__18855(cljs.core.chunk_rest(s__18856__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__18858),null);
}
} else {
var x = cljs.core.first(s__18856__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$g$tick,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$transform,c2.svg.translate(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(x_scale.cljs$core$IFn$_invoke$arity$1 ? x_scale.cljs$core$IFn$_invoke$arity$1(x) : x_scale.call(null,x)),(0)], null))], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$text,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$y,(25),cljs.core.cst$kw$text_DASH_anchor,"middle",cljs.core.cst$kw$class,data_type], null),(fmt.cljs$core$IFn$_invoke$arity$1 ? fmt.cljs$core$IFn$_invoke$arity$1(x) : fmt.call(null,x))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$line,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$class,"tick",cljs.core.cst$kw$y2,(10),cljs.core.cst$kw$x2,(0)], null)], null)], null),hatti$charting$iter__18855(cljs.core.rest(s__18856__$2)));
}
} else {
return null;
}
break;
}
});})(chart_width,chart_height,margin,small_margin,y_lim,neg_margin,extracted_data,map__18820,map__18820__$1,nil_count,non_nil_count,bins,x_series,dx_series,y_series,xmin,xmax,x_scale,y_scale,bin_width,x_ticks,fmt,map__18818,map__18818__$1,data_type))
,null,null));
});})(chart_width,chart_height,margin,small_margin,y_lim,neg_margin,extracted_data,map__18820,map__18820__$1,nil_count,non_nil_count,bins,x_series,dx_series,y_series,xmin,xmax,x_scale,y_scale,bin_width,x_ticks,fmt,map__18818,map__18818__$1,data_type))
;
return iter__7189__auto__(x_ticks);
})()], null)], null)], null)], null),hatti.charting.response_count_message(non_nil_count)], null);
}
});

hatti.charting.numeric_chart.cljs$lang$maxFixedArity = (1);

hatti.charting.numeric_chart.cljs$lang$applyTo = (function (seq18815){
var G__18816 = cljs.core.first(seq18815);
var seq18815__$1 = cljs.core.next(seq18815);
return hatti.charting.numeric_chart.cljs$core$IFn$_invoke$arity$variadic(G__18816,seq18815__$1);
});

/**
 * Create category bar chart out of some data + count data. Data of form:
 *   {'Label1' 1 'Label2' 2}, etc. where the numbers are counts.
 */
hatti.charting.table_chart_h = (function hatti$charting$table_chart_h(data,nil_count,non_nil_count,field_type){
var max_count = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.max,cljs.core.vals(data));
var percent_s = ((function (max_count){
return (function (n,total){
var s = c2.scale.linear.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.cst$kw$domain,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),total], null),cljs.core.cst$kw$range,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(100)], null)], 0));
return [cljs.core.str(chimera.js_interop.format.cljs$core$IFn$_invoke$arity$variadic("%.1f",cljs.core.array_seq([(s.cljs$core$IFn$_invoke$arity$1 ? s.cljs$core$IFn$_invoke$arity$1(n) : s.call(null,n))], 0))),cljs.core.str("%")].join('');
});})(max_count))
;
var select_mult_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(field_type,"select all that apply");
var bar_div = ((select_mult_QMARK_)?cljs.core.cst$kw$div$bars$select_DASH_mult:cljs.core.cst$kw$div$bars$select_DASH_one);
var tdr = cljs.core.cst$kw$td$t_DASH_right;
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$table_SHARP_bar_DASH_chart$table,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$thead,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$tr,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$th], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$th], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$th$t_DASH_right,"Count"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$th$t_DASH_right,"Percent"], null)], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$tfoot,((select_mult_QMARK_)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$tr$t_DASH_grey,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [tdr,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$col_DASH_span,(4)], null),hatti.charting.response_count_message(non_nil_count)], null)], null):new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$tr$t_DASH_grey,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [tdr], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tdr,"Total"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tdr,non_nil_count], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tdr,"100%"], null)], null)),(((!(select_mult_QMARK_)) && ((nil_count > (0))))?new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$tr$t_DASH_grey,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$td], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$td$t_DASH_right,"No response"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$td$t_DASH_right,nil_count], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$td], null)], null):null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$tbody,(function (){var iter__7189__auto__ = ((function (max_count,percent_s,select_mult_QMARK_,bar_div,tdr){
return (function hatti$charting$table_chart_h_$_iter__18884(s__18885){
return (new cljs.core.LazySeq(null,((function (max_count,percent_s,select_mult_QMARK_,bar_div,tdr){
return (function (){
var s__18885__$1 = s__18885;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__18885__$1);
if(temp__4657__auto__){
var s__18885__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__18885__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__18885__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__18887 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__18886 = (0);
while(true){
if((i__18886 < size__7188__auto__)){
var vec__18896 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__18886);
var label = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18896,(0),null);
var val = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18896,(1),null);
cljs.core.chunk_append(b__18887,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$tr,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$td,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$title,label], null),label], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$td,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [bar_div,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$style,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$width,percent_s(val,max_count)], null)], null)], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$td$t_DASH_right,val], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$td$t_DASH_right,percent_s(val,non_nil_count)], null)], null));

var G__18902 = (i__18886 + (1));
i__18886 = G__18902;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__18887),hatti$charting$table_chart_h_$_iter__18884(cljs.core.chunk_rest(s__18885__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__18887),null);
}
} else {
var vec__18899 = cljs.core.first(s__18885__$2);
var label = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18899,(0),null);
var val = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18899,(1),null);
return cljs.core.cons(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$tr,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$td,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$title,label], null),label], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$td,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [bar_div,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$style,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$width,percent_s(val,max_count)], null)], null)], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$td$t_DASH_right,val], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$td$t_DASH_right,percent_s(val,non_nil_count)], null)], null),hatti$charting$table_chart_h_$_iter__18884(cljs.core.rest(s__18885__$2)));
}
} else {
return null;
}
break;
}
});})(max_count,percent_s,select_mult_QMARK_,bar_div,tdr))
,null,null));
});})(max_count,percent_s,select_mult_QMARK_,bar_div,tdr))
;
return iter__7189__auto__(data);
})()], null)], null);
});
/**
 * Removes nil from Ona API chart data; adds nil- and non-nil-count metadata.
 * ex. Input:  {:field_xpath 'D' :data [{:D nil :count 5} {:D 1 :count 10}]}
 *     Output: {:field_xpath 'D' :data [{:D 1 :count 10}]}
 *             w/ metadata: {:nil-count 5 :non-nil-count 10}
 */
hatti.charting.extract_nil = (function hatti$charting$extract_nil(chart_data){
var map__18908 = chart_data;
var map__18908__$1 = ((((!((map__18908 == null)))?((((map__18908.cljs$lang$protocol_mask$partition0$ & (64))) || (map__18908.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__18908):map__18908);
var field_xpath = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18908__$1,cljs.core.cst$kw$field_xpath);
var data = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18908__$1,cljs.core.cst$kw$data);
var na_QMARK_ = ((function (map__18908,map__18908__$1,field_xpath,data){
return (function (p1__18903_SHARP_){
return ((p1__18903_SHARP_ == null)) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,p1__18903_SHARP_));
});})(map__18908,map__18908__$1,field_xpath,data))
;
var nil_data = cljs.core.first(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (map__18908,map__18908__$1,field_xpath,data,na_QMARK_){
return (function (p1__18904_SHARP_){
return na_QMARK_(cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(field_xpath).call(null,p1__18904_SHARP_));
});})(map__18908,map__18908__$1,field_xpath,data,na_QMARK_))
,data));
var non_nil_data = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(((function (map__18908,map__18908__$1,field_xpath,data,na_QMARK_,nil_data){
return (function (p1__18905_SHARP_){
return na_QMARK_(cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(field_xpath).call(null,p1__18905_SHARP_));
});})(map__18908,map__18908__$1,field_xpath,data,na_QMARK_,nil_data))
,data);
var nil_count = (function (){var temp__4655__auto__ = cljs.core.cst$kw$count.cljs$core$IFn$_invoke$arity$1(nil_data);
if(cljs.core.truth_(temp__4655__auto__)){
var n = temp__4655__auto__;
return n;
} else {
return (0);
}
})();
var non_nil_count = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$count,non_nil_data));
return cljs.core.with_meta(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(chart_data,cljs.core.cst$kw$data,non_nil_data),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$nil_DASH_count,nil_count,cljs.core.cst$kw$non_DASH_nil_DASH_count,non_nil_count], null));
});
/**
 * Make chart depending on datatype.
 */
hatti.charting.make_chart = (function hatti$charting$make_chart(var_args){
var args18911 = [];
var len__7484__auto___18919 = arguments.length;
var i__7485__auto___18920 = (0);
while(true){
if((i__7485__auto___18920 < len__7484__auto___18919)){
args18911.push((arguments[i__7485__auto___18920]));

var G__18921 = (i__7485__auto___18920 + (1));
i__7485__auto___18920 = G__18921;
continue;
} else {
}
break;
}

var G__18913 = args18911.length;
switch (G__18913) {
case 1:
return hatti.charting.make_chart.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return hatti.charting.make_chart.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18911.length)].join('')));

}
});

hatti.charting.make_chart.cljs$core$IFn$_invoke$arity$1 = (function (chart_data){
return hatti.charting.make_chart.cljs$core$IFn$_invoke$arity$2(chart_data,null);
});

hatti.charting.make_chart.cljs$core$IFn$_invoke$arity$2 = (function (chart_data,language){
var map__18914 = chart_data;
var map__18914__$1 = ((((!((map__18914 == null)))?((((map__18914.cljs$lang$protocol_mask$partition0$ & (64))) || (map__18914.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__18914):map__18914);
var field_label = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18914__$1,cljs.core.cst$kw$field_label);
var data_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18914__$1,cljs.core.cst$kw$data_type);
var field_xpath = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18914__$1,cljs.core.cst$kw$field_xpath);
var field_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18914__$1,cljs.core.cst$kw$field_type);
var chart_data__$1 = hatti.charting.extract_nil(chart_data);
var map__18915 = cljs.core.meta(chart_data__$1);
var map__18915__$1 = ((((!((map__18915 == null)))?((((map__18915.cljs$lang$protocol_mask$partition0$ & (64))) || (map__18915.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__18915):map__18915);
var nil_count = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18915__$1,cljs.core.cst$kw$nil_DASH_count);
var non_nil_count = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18915__$1,cljs.core.cst$kw$non_DASH_nil_DASH_count);
var not_supported = ((function (map__18914,map__18914__$1,field_label,data_type,field_xpath,field_type,chart_data__$1,map__18915,map__18915__$1,nil_count,non_nil_count){
return (function (p1__18910_SHARP_){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$div$t_DASH_red,[cljs.core.str("Aplogies. At the moment, making a chart of\n                                     this data type ("),cljs.core.str(p1__18910_SHARP_),cljs.core.str(") is not supported.")].join('')],null));
});})(map__18914,map__18914__$1,field_label,data_type,field_xpath,field_type,chart_data__$1,map__18915,map__18915__$1,nil_count,non_nil_count))
;
var chart = (((non_nil_count === (0)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$p,"No data"], null):(function (){var G__18918 = data_type;
switch (G__18918) {
case "categorized":
return hatti.charting.table_chart_h(hatti.charting.label_count_pairs.cljs$core$IFn$_invoke$arity$2(chart_data__$1,language),nil_count,non_nil_count,field_type);

break;
case "time_based":
return hatti.charting.numeric_chart.cljs$core$IFn$_invoke$arity$variadic(chart_data__$1,cljs.core.array_seq([cljs.core.cst$kw$data_DASH_type,"date"], 0));

break;
case "numeric":
return hatti.charting.numeric_chart(chart_data__$1);

break;
default:
return not_supported(data_type);

}
})());
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$label,field_label,cljs.core.cst$kw$name,field_xpath,cljs.core.cst$kw$chart,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div,chart], null)], null);
});

hatti.charting.make_chart.cljs$lang$maxFixedArity = 2;

