// Compiled by ClojureScript 1.9.229 {:static-fns true, :optimize-constants true}
goog.provide('hatti.map.utils');
goog.require('cljs.core');
goog.require('hatti.constants');
goog.require('cljs.core.async');
goog.require('chimera.seq');
goog.require('hatti.ona.forms');
goog.require('clojure.string');
goog.require('om.core');
goog.require('hatti.utils');
goog.require('cljs.reader');
hatti.map.utils.ona_styles = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$point,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$normal,({"radius": (6), "fillColor": "#f30", "reset": ({"fillColor": "#f30"}), "color": "#fff", "border": (8), "opacity": 0.5, "fillOpacity": 0.9}),cljs.core.cst$kw$hover,({"fillColor": "#631400"}),cljs.core.cst$kw$clicked,({"fillColor": "#ad2300"})], null),cljs.core.cst$kw$shape,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$normal,({"fillColor": "#f30", "color": "#666", "weight": (3), "dashArray": "3", "fillOpacity": 0.7, "opacity": 0.8}),cljs.core.cst$kw$hover,({"fillColor": "#631400", "color": "#222"}),cljs.core.cst$kw$clicked,({"fillColor": "#ad2300", "color": "#222"})], null),cljs.core.cst$kw$line,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$normal,({"color": "#f30", "opacity": (1), "weight": (6), "reset": ({"color": "#f30"})}),cljs.core.cst$kw$hover,({"color": "#631400"}),cljs.core.cst$kw$clicked,({"color": "#ad2300"})], null)], null);
hatti.map.utils.circle_border_id = "point-casting";
/**
 * Returns geotype (:point :line or :shape) based on marker.
 */
hatti.map.utils.marker__GT_geotype = (function hatti$map$utils$marker__GT_geotype(marker){
return new cljs.core.PersistentArrayMap(null, 3, ["Point",cljs.core.cst$kw$point,"Polygon",cljs.core.cst$kw$shape,"LineString",cljs.core.cst$kw$line], null).call(null,(((marker["feature"])["geometry"])["type"]));
});
/**
 * Appropriate style given style-type (:normal, :clicked, :hover), and
 * either a leaflet marker or clojurescript keyword (one of :point or :shape).
 */
hatti.map.utils.get_ona_style = (function hatti$map$utils$get_ona_style(var_args){
var args__7491__auto__ = [];
var len__7484__auto___17275 = arguments.length;
var i__7485__auto___17276 = (0);
while(true){
if((i__7485__auto___17276 < len__7484__auto___17275)){
args__7491__auto__.push((arguments[i__7485__auto___17276]));

var G__17277 = (i__7485__auto___17276 + (1));
i__7485__auto___17276 = G__17277;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((2) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((2)),(0),null)):null);
return hatti.map.utils.get_ona_style.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7492__auto__);
});

hatti.map.utils.get_ona_style.cljs$core$IFn$_invoke$arity$variadic = (function (marker_or_keyword,style_type,p__17271){
var map__17272 = p__17271;
var map__17272__$1 = ((((!((map__17272 == null)))?((((map__17272.cljs$lang$protocol_mask$partition0$ & (64))) || (map__17272.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__17272):map__17272);
var custom_styles = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__17272__$1,cljs.core.cst$kw$custom_DASH_styles,hatti.map.utils.ona_styles);
var kw = (((marker_or_keyword instanceof cljs.core.Keyword))?marker_or_keyword:hatti.map.utils.marker__GT_geotype(marker_or_keyword));
var G__17274 = (kw.cljs$core$IFn$_invoke$arity$1 ? kw.cljs$core$IFn$_invoke$arity$1(custom_styles) : kw.call(null,custom_styles));
return (style_type.cljs$core$IFn$_invoke$arity$1 ? style_type.cljs$core$IFn$_invoke$arity$1(G__17274) : style_type.call(null,G__17274));
});

hatti.map.utils.get_ona_style.cljs$lang$maxFixedArity = (2);

hatti.map.utils.get_ona_style.cljs$lang$applyTo = (function (seq17268){
var G__17269 = cljs.core.first(seq17268);
var seq17268__$1 = cljs.core.next(seq17268);
var G__17270 = cljs.core.first(seq17268__$1);
var seq17268__$2 = cljs.core.next(seq17268__$1);
return hatti.map.utils.get_ona_style.cljs$core$IFn$_invoke$arity$variadic(G__17269,G__17270,seq17268__$2);
});

hatti.map.utils.equivalent_style = (function hatti$map$utils$equivalent_style(s,t){

var sc = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$1(s);
var tc = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$1(t);
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.select_keys(sc,cljs.core.keys(tc)),cljs.core.select_keys(tc,cljs.core.keys(sc)));
});
hatti.map.utils.get_id = (function hatti$map$utils$get_id(marker){
return (((marker["feature"])["properties"])[hatti.constants._id]);
});
hatti.map.utils.get_rank = (function hatti$map$utils$get_rank(marker){
return (((marker["feature"])["properties"])[hatti.constants._rank]);
});
/**
 * Get the style of a marker. Second arg specifies style attribute to get.
 * eg. For marker m1, call like: (get-style m1) or (get-style m1 :fillColor)
 */
hatti.map.utils.get_style = (function hatti$map$utils$get_style(var_args){
var args17278 = [];
var len__7484__auto___17282 = arguments.length;
var i__7485__auto___17283 = (0);
while(true){
if((i__7485__auto___17283 < len__7484__auto___17282)){
args17278.push((arguments[i__7485__auto___17283]));

var G__17284 = (i__7485__auto___17283 + (1));
i__7485__auto___17283 = G__17284;
continue;
} else {
}
break;
}

var G__17280 = args17278.length;
switch (G__17280) {
case 1:
return hatti.map.utils.get_style.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return hatti.map.utils.get_style.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17278.length)].join('')));

}
});

hatti.map.utils.get_style.cljs$core$IFn$_invoke$arity$1 = (function (marker){
return (marker["options"]);
});

hatti.map.utils.get_style.cljs$core$IFn$_invoke$arity$2 = (function (marker,kw){
var G__17281 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$1(hatti.map.utils.get_style.cljs$core$IFn$_invoke$arity$1(marker));
return (kw.cljs$core$IFn$_invoke$arity$1 ? kw.cljs$core$IFn$_invoke$arity$1(G__17281) : kw.call(null,G__17281));
});

hatti.map.utils.get_style.cljs$lang$maxFixedArity = 2;

/**
 * Check whether a marker is clicked, so it's style can be preserved.
 */
hatti.map.utils.is_clicked_QMARK_ = (function hatti$map$utils$is_clicked_QMARK_(marker){
return hatti.map.utils.equivalent_style(hatti.map.utils.get_style.cljs$core$IFn$_invoke$arity$1(marker),hatti.map.utils.get_ona_style(marker,cljs.core.cst$kw$clicked));
});
/**
 * Apply a style to a marker. Style comes from a function that takes marker.
 */
hatti.map.utils.re_style_marker = (function hatti$map$utils$re_style_marker(marker__GT_style,marker){
var style = (marker__GT_style.cljs$core$IFn$_invoke$arity$1 ? marker__GT_style.cljs$core$IFn$_invoke$arity$1(marker) : marker__GT_style.call(null,marker));
if(cljs.core.truth_(hatti.map.utils.is_clicked_QMARK_(marker))){
return marker.setStyle(cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$reset,style], null)));
} else {
return marker.setStyle(cljs.core.clj__GT_js(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(style,cljs.core.cst$kw$reset,style)));
}
});
/**
 * Reset styles pulls the 'reset' property from within a markers options,
 * clearing styles to default if nothing found.
 */
hatti.map.utils.reset_style = (function hatti$map$utils$reset_style(marker){
var temp__4655__auto__ = ((marker["options"])["reset"]);
if(cljs.core.truth_(temp__4655__auto__)){
var rstyle = temp__4655__auto__;
return marker.setStyle(rstyle);
} else {
return marker.setStyle(hatti.map.utils.get_ona_style(marker,cljs.core.cst$kw$normal));
}
});
/**
 * Looks at the _id in marker, and brings to top if (1) marker clicked or
 * (2) marker's id is selected (via id-selected?)
 */
hatti.map.utils.bring_to_top_if_selected = (function hatti$map$utils$bring_to_top_if_selected(id_selected_QMARK_,marker){
if(cljs.core.truth_((function (){var or__6409__auto__ = hatti.map.utils.is_clicked_QMARK_(marker);
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
var G__17287 = hatti.map.utils.get_id(marker);
return (id_selected_QMARK_.cljs$core$IFn$_invoke$arity$1 ? id_selected_QMARK_.cljs$core$IFn$_invoke$arity$1(G__17287) : id_selected_QMARK_.call(null,G__17287));
}
})())){
return marker.bringToFront();
} else {
return null;
}
});
hatti.map.utils.apply_click_style = (function hatti$map$utils$apply_click_style(marker){
if(cljs.core.truth_(marker)){
marker.bringToFront();

return marker.setStyle(hatti.map.utils.get_ona_style(marker,cljs.core.cst$kw$clicked));
} else {
return null;
}
});
hatti.map.utils.apply_unclick_style = (function hatti$map$utils$apply_unclick_style(marker){
if(cljs.core.truth_(marker)){
return hatti.map.utils.reset_style(marker);
} else {
return null;
}
});
hatti.map.utils.apply_hover_style = (function hatti$map$utils$apply_hover_style(marker){
if(cljs.core.truth_(marker)){
marker.bringToFront();

return marker.setStyle(hatti.map.utils.get_ona_style(marker,cljs.core.cst$kw$hover));
} else {
return null;
}
});
/**
 * Sets the default style on a marker.
 */
hatti.map.utils.clear_all_styles = (function hatti$map$utils$clear_all_styles(var_args){
var args__7491__auto__ = [];
var len__7484__auto___17297 = arguments.length;
var i__7485__auto___17298 = (0);
while(true){
if((i__7485__auto___17298 < len__7484__auto___17297)){
args__7491__auto__.push((arguments[i__7485__auto___17298]));

var G__17299 = (i__7485__auto___17298 + (1));
i__7485__auto___17298 = G__17299;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return hatti.map.utils.clear_all_styles.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

hatti.map.utils.clear_all_styles.cljs$core$IFn$_invoke$arity$variadic = (function (markers,p__17290){
var map__17291 = p__17290;
var map__17291__$1 = ((((!((map__17291 == null)))?((((map__17291.cljs$lang$protocol_mask$partition0$ & (64))) || (map__17291.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__17291):map__17291);
var preserve_clicked_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__17291__$1,cljs.core.cst$kw$preserve_DASH_clicked_QMARK_,true);
var seq__17293 = cljs.core.seq(markers);
var chunk__17294 = null;
var count__17295 = (0);
var i__17296 = (0);
while(true){
if((i__17296 < count__17295)){
var marker = chunk__17294.cljs$core$IIndexed$_nth$arity$2(null,i__17296);
if(cljs.core.not((function (){var and__6397__auto__ = preserve_clicked_QMARK_;
if(cljs.core.truth_(and__6397__auto__)){
return hatti.map.utils.is_clicked_QMARK_(marker);
} else {
return and__6397__auto__;
}
})())){
marker.setStyle(hatti.map.utils.get_ona_style(marker,cljs.core.cst$kw$normal));
} else {
}

var G__17300 = seq__17293;
var G__17301 = chunk__17294;
var G__17302 = count__17295;
var G__17303 = (i__17296 + (1));
seq__17293 = G__17300;
chunk__17294 = G__17301;
count__17295 = G__17302;
i__17296 = G__17303;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq(seq__17293);
if(temp__4657__auto__){
var seq__17293__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__17293__$1)){
var c__7220__auto__ = cljs.core.chunk_first(seq__17293__$1);
var G__17304 = cljs.core.chunk_rest(seq__17293__$1);
var G__17305 = c__7220__auto__;
var G__17306 = cljs.core.count(c__7220__auto__);
var G__17307 = (0);
seq__17293 = G__17304;
chunk__17294 = G__17305;
count__17295 = G__17306;
i__17296 = G__17307;
continue;
} else {
var marker = cljs.core.first(seq__17293__$1);
if(cljs.core.not((function (){var and__6397__auto__ = preserve_clicked_QMARK_;
if(cljs.core.truth_(and__6397__auto__)){
return hatti.map.utils.is_clicked_QMARK_(marker);
} else {
return and__6397__auto__;
}
})())){
marker.setStyle(hatti.map.utils.get_ona_style(marker,cljs.core.cst$kw$normal));
} else {
}

var G__17308 = cljs.core.next(seq__17293__$1);
var G__17309 = null;
var G__17310 = (0);
var G__17311 = (0);
seq__17293 = G__17308;
chunk__17294 = G__17309;
count__17295 = G__17310;
i__17296 = G__17311;
continue;
}
} else {
return null;
}
}
break;
}
});

hatti.map.utils.clear_all_styles.cljs$lang$maxFixedArity = (1);

hatti.map.utils.clear_all_styles.cljs$lang$applyTo = (function (seq17288){
var G__17289 = cljs.core.first(seq17288);
var seq17288__$1 = cljs.core.next(seq17288);
return hatti.map.utils.clear_all_styles.cljs$core$IFn$_invoke$arity$variadic(G__17289,seq17288__$1);
});

hatti.map.utils.read_string_or_number = (function hatti$map$utils$read_string_or_number(maybe_s){
if(typeof maybe_s === 'string'){
return cljs.reader.read_string(maybe_s);
} else {
return maybe_s;
}
});
hatti.map.utils.make_feature = (function hatti$map$utils$make_feature(geometry,record_id,index){
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$type,"Feature",cljs.core.cst$kw$properties,cljs.core.PersistentArrayMap.fromArray([cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(hatti.constants._rank),(index + (1)),cljs.core.cst$kw$id,record_id,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(hatti.constants._id),record_id], true, false),cljs.core.cst$kw$geometry,geometry], null);
});
if(typeof hatti.map.utils.get_as_geom !== 'undefined'){
} else {
hatti.map.utils.get_as_geom = (function (){var method_table__7334__auto__ = (function (){var G__17312 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__17312) : cljs.core.atom.call(null,G__17312));
})();
var prefer_table__7335__auto__ = (function (){var G__17313 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__17313) : cljs.core.atom.call(null,G__17313));
})();
var method_cache__7336__auto__ = (function (){var G__17314 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__17314) : cljs.core.atom.call(null,G__17314));
})();
var cached_hierarchy__7337__auto__ = (function (){var G__17315 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__17315) : cljs.core.atom.call(null,G__17315));
})();
var hierarchy__7338__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$hierarchy,cljs.core.get_global_hierarchy());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("hatti.map.utils","get-as-geom"),((function (method_table__7334__auto__,prefer_table__7335__auto__,method_cache__7336__auto__,cached_hierarchy__7337__auto__,hierarchy__7338__auto__){
return (function() { 
var G__17320__delegate = function (record,field,p__17316){
var vec__17317 = p__17316;
var repeat_child_index = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17317,(0),null);
if(cljs.core.truth_(hatti.ona.forms.repeat_QMARK_(field))){
return cljs.core.cst$kw$repeat;
} else {
return cljs.core.cst$kw$default;

}
};
var G__17320 = function (record,field,var_args){
var p__17316 = null;
if (arguments.length > 2) {
var G__17321__i = 0, G__17321__a = new Array(arguments.length -  2);
while (G__17321__i < G__17321__a.length) {G__17321__a[G__17321__i] = arguments[G__17321__i + 2]; ++G__17321__i;}
  p__17316 = new cljs.core.IndexedSeq(G__17321__a,0);
} 
return G__17320__delegate.call(this,record,field,p__17316);};
G__17320.cljs$lang$maxFixedArity = 2;
G__17320.cljs$lang$applyTo = (function (arglist__17322){
var record = cljs.core.first(arglist__17322);
arglist__17322 = cljs.core.next(arglist__17322);
var field = cljs.core.first(arglist__17322);
var p__17316 = cljs.core.rest(arglist__17322);
return G__17320__delegate(record,field,p__17316);
});
G__17320.cljs$core$IFn$_invoke$arity$variadic = G__17320__delegate;
return G__17320;
})()
;})(method_table__7334__auto__,prefer_table__7335__auto__,method_cache__7336__auto__,cached_hierarchy__7337__auto__,hierarchy__7338__auto__))
,cljs.core.cst$kw$default,hierarchy__7338__auto__,method_table__7334__auto__,prefer_table__7335__auto__,method_cache__7336__auto__,cached_hierarchy__7337__auto__));
})();
}
hatti.map.utils.get_as_geom.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$repeat,(function (record,p__17323){
var map__17324 = p__17323;
var map__17324__$1 = ((((!((map__17324 == null)))?((((map__17324.cljs$lang$protocol_mask$partition0$ & (64))) || (map__17324.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__17324):map__17324);
var field = map__17324__$1;
var children = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17324__$1,cljs.core.cst$kw$children);
var full_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17324__$1,cljs.core.cst$kw$full_DASH_name);
var iter__7189__auto__ = ((function (map__17324,map__17324__$1,field,children,full_name){
return (function hatti$map$utils$iter__17326(s__17327){
return (new cljs.core.LazySeq(null,((function (map__17324,map__17324__$1,field,children,full_name){
return (function (){
var s__17327__$1 = s__17327;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__17327__$1);
if(temp__4657__auto__){
var s__17327__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__17327__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__17327__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__17329 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__17328 = (0);
while(true){
if((i__17328 < size__7188__auto__)){
var child_record = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__17328);
cljs.core.chunk_append(b__17329,(function (){var iter__7189__auto__ = ((function (i__17328,child_record,c__7187__auto__,size__7188__auto__,b__17329,s__17327__$2,temp__4657__auto__,map__17324,map__17324__$1,field,children,full_name){
return (function hatti$map$utils$iter__17326_$_iter__17344(s__17345){
return (new cljs.core.LazySeq(null,((function (i__17328,child_record,c__7187__auto__,size__7188__auto__,b__17329,s__17327__$2,temp__4657__auto__,map__17324,map__17324__$1,field,children,full_name){
return (function (){
var s__17345__$1 = s__17345;
while(true){
var temp__4657__auto____$1 = cljs.core.seq(s__17345__$1);
if(temp__4657__auto____$1){
var s__17345__$2 = temp__4657__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__17345__$2)){
var c__7187__auto____$1 = cljs.core.chunk_first(s__17345__$2);
var size__7188__auto____$1 = cljs.core.count(c__7187__auto____$1);
var b__17347 = cljs.core.chunk_buffer(size__7188__auto____$1);
if((function (){var i__17346 = (0);
while(true){
if((i__17346 < size__7188__auto____$1)){
var child = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto____$1,i__17346);
cljs.core.chunk_append(b__17347,(hatti.map.utils.get_as_geom.cljs$core$IFn$_invoke$arity$2 ? hatti.map.utils.get_as_geom.cljs$core$IFn$_invoke$arity$2(child_record,child) : hatti.map.utils.get_as_geom.call(null,child_record,child)));

var G__17356 = (i__17346 + (1));
i__17346 = G__17356;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__17347),hatti$map$utils$iter__17326_$_iter__17344(cljs.core.chunk_rest(s__17345__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__17347),null);
}
} else {
var child = cljs.core.first(s__17345__$2);
return cljs.core.cons((hatti.map.utils.get_as_geom.cljs$core$IFn$_invoke$arity$2 ? hatti.map.utils.get_as_geom.cljs$core$IFn$_invoke$arity$2(child_record,child) : hatti.map.utils.get_as_geom.call(null,child_record,child)),hatti$map$utils$iter__17326_$_iter__17344(cljs.core.rest(s__17345__$2)));
}
} else {
return null;
}
break;
}
});})(i__17328,child_record,c__7187__auto__,size__7188__auto__,b__17329,s__17327__$2,temp__4657__auto__,map__17324,map__17324__$1,field,children,full_name))
,null,null));
});})(i__17328,child_record,c__7187__auto__,size__7188__auto__,b__17329,s__17327__$2,temp__4657__auto__,map__17324,map__17324__$1,field,children,full_name))
;
return iter__7189__auto__(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.geofield_QMARK_,children));
})());

var G__17357 = (i__17328 + (1));
i__17328 = G__17357;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__17329),hatti$map$utils$iter__17326(cljs.core.chunk_rest(s__17327__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__17329),null);
}
} else {
var child_record = cljs.core.first(s__17327__$2);
return cljs.core.cons((function (){var iter__7189__auto__ = ((function (child_record,s__17327__$2,temp__4657__auto__,map__17324,map__17324__$1,field,children,full_name){
return (function hatti$map$utils$iter__17326_$_iter__17350(s__17351){
return (new cljs.core.LazySeq(null,((function (child_record,s__17327__$2,temp__4657__auto__,map__17324,map__17324__$1,field,children,full_name){
return (function (){
var s__17351__$1 = s__17351;
while(true){
var temp__4657__auto____$1 = cljs.core.seq(s__17351__$1);
if(temp__4657__auto____$1){
var s__17351__$2 = temp__4657__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__17351__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__17351__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__17353 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__17352 = (0);
while(true){
if((i__17352 < size__7188__auto__)){
var child = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__17352);
cljs.core.chunk_append(b__17353,(hatti.map.utils.get_as_geom.cljs$core$IFn$_invoke$arity$2 ? hatti.map.utils.get_as_geom.cljs$core$IFn$_invoke$arity$2(child_record,child) : hatti.map.utils.get_as_geom.call(null,child_record,child)));

var G__17358 = (i__17352 + (1));
i__17352 = G__17358;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__17353),hatti$map$utils$iter__17326_$_iter__17350(cljs.core.chunk_rest(s__17351__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__17353),null);
}
} else {
var child = cljs.core.first(s__17351__$2);
return cljs.core.cons((hatti.map.utils.get_as_geom.cljs$core$IFn$_invoke$arity$2 ? hatti.map.utils.get_as_geom.cljs$core$IFn$_invoke$arity$2(child_record,child) : hatti.map.utils.get_as_geom.call(null,child_record,child)),hatti$map$utils$iter__17326_$_iter__17350(cljs.core.rest(s__17351__$2)));
}
} else {
return null;
}
break;
}
});})(child_record,s__17327__$2,temp__4657__auto__,map__17324,map__17324__$1,field,children,full_name))
,null,null));
});})(child_record,s__17327__$2,temp__4657__auto__,map__17324,map__17324__$1,field,children,full_name))
;
return iter__7189__auto__(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.geofield_QMARK_,children));
})(),hatti$map$utils$iter__17326(cljs.core.rest(s__17327__$2)));
}
} else {
return null;
}
break;
}
});})(map__17324,map__17324__$1,field,children,full_name))
,null,null));
});})(map__17324,map__17324__$1,field,children,full_name))
;
return iter__7189__auto__(cljs.core.get.cljs$core$IFn$_invoke$arity$2(record,full_name));
}));
hatti.map.utils.get_as_geom.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (record,geofield){
var geotype = new cljs.core.PersistentArrayMap(null, 4, ["geopoint","Point","gps","Point","geoshape","Polygon","geotrace","LineString"], null).call(null,cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(geofield));
var parse = ((function (geotype){
return (function (s){
if((cljs.core.seq(s)) && (cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(s,"n/a"))){
var iter__7189__auto__ = ((function (geotype){
return (function hatti$map$utils$iter__17361(s__17362){
return (new cljs.core.LazySeq(null,((function (geotype){
return (function (){
var s__17362__$1 = s__17362;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__17362__$1);
if(temp__4657__auto__){
var s__17362__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__17362__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__17362__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__17364 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__17363 = (0);
while(true){
if((i__17363 < size__7188__auto__)){
var coord_string = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__17363);
cljs.core.chunk_append(b__17364,(function (){var vec__17373 = clojure.string.split.cljs$core$IFn$_invoke$arity$2(coord_string,/ /);
var lat = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17373,(0),null);
var lng = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17373,(1),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17373,(2),null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17373,(3),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.reader.read_string(lng),cljs.reader.read_string(lat)], null);
})());

var G__17380 = (i__17363 + (1));
i__17363 = G__17380;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__17364),hatti$map$utils$iter__17361(cljs.core.chunk_rest(s__17362__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__17364),null);
}
} else {
var coord_string = cljs.core.first(s__17362__$2);
return cljs.core.cons((function (){var vec__17376 = clojure.string.split.cljs$core$IFn$_invoke$arity$2(coord_string,/ /);
var lat = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17376,(0),null);
var lng = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17376,(1),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17376,(2),null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17376,(3),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.reader.read_string(lng),cljs.reader.read_string(lat)], null);
})(),hatti$map$utils$iter__17361(cljs.core.rest(s__17362__$2)));
}
} else {
return null;
}
break;
}
});})(geotype))
,null,null));
});})(geotype))
;
return iter__7189__auto__(clojure.string.split.cljs$core$IFn$_invoke$arity$2(s,/;/));
} else {
return null;
}
});})(geotype))
;
var coordfn = (function (){var G__17379 = geotype;
switch (G__17379) {
case "Point":
return ((function (G__17379,geotype,parse){
return (function (p1__17359_SHARP_){
return cljs.core.first(parse(p1__17359_SHARP_));
});
;})(G__17379,geotype,parse))

break;
case "LineString":
return parse;

break;
case "Polygon":
return ((function (G__17379,geotype,parse){
return (function (p1__17360_SHARP_){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[parse(p1__17360_SHARP_)],null));
});
;})(G__17379,geotype,parse))

break;
default:
return cljs.core.identity;

}
})();
var value = cljs.core.get.cljs$core$IFn$_invoke$arity$2(record,cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(geofield));
var coords = (coordfn.cljs$core$IFn$_invoke$arity$1 ? coordfn.cljs$core$IFn$_invoke$arity$1(value) : coordfn.call(null,value));
if(cljs.core.truth_(hatti.ona.forms.osm_QMARK_(geofield))){
return cljs.core.cst$kw$geom.cljs$core$IFn$_invoke$arity$1(value);
} else {
if(cljs.core.truth_((function (){var or__6409__auto__ = (coords == null);
if(or__6409__auto__){
return or__6409__auto__;
} else {
return cljs.core.some(cljs.core.nil_QMARK_,coords);
}
})())){
return null;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$type,geotype,cljs.core.cst$kw$coordinates,coords], null);
}
}
}));
/**
 * Given the dataset, and the form schema, get out geojson.
 * Optional specification of field will map that field data to the geom.
 */
hatti.map.utils.as_geojson = (function hatti$map$utils$as_geojson(var_args){
var args17383 = [];
var len__7484__auto___17404 = arguments.length;
var i__7485__auto___17405 = (0);
while(true){
if((i__7485__auto___17405 < len__7484__auto___17404)){
args17383.push((arguments[i__7485__auto___17405]));

var G__17406 = (i__7485__auto___17405 + (1));
i__7485__auto___17405 = G__17406;
continue;
} else {
}
break;
}

var G__17385 = args17383.length;
switch (G__17385) {
case 2:
return hatti.map.utils.as_geojson.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return hatti.map.utils.as_geojson.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17383.length)].join('')));

}
});

hatti.map.utils.as_geojson.cljs$core$IFn$_invoke$arity$2 = (function (dataset,form){
return hatti.map.utils.as_geojson.cljs$core$IFn$_invoke$arity$3(dataset,form,hatti.ona.forms.default_geofield(form));
});

hatti.map.utils.as_geojson.cljs$core$IFn$_invoke$arity$3 = (function (dataset,form,geofield){
if(cljs.core.truth_(geofield)){
var features = (function (){var iter__7189__auto__ = (function hatti$map$utils$iter__17386(s__17387){
return (new cljs.core.LazySeq(null,(function (){
var s__17387__$1 = s__17387;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__17387__$1);
if(temp__4657__auto__){
var s__17387__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__17387__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__17387__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__17389 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__17388 = (0);
while(true){
if((i__17388 < size__7188__auto__)){
var vec__17398 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__17388);
var idx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17398,(0),null);
var record = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17398,(1),null);
var geom_or_geoms = (hatti.map.utils.get_as_geom.cljs$core$IFn$_invoke$arity$2 ? hatti.map.utils.get_as_geom.cljs$core$IFn$_invoke$arity$2(record,geofield) : hatti.map.utils.get_as_geom.call(null,record,geofield));
if(cljs.core.truth_(geom_or_geoms)){
cljs.core.chunk_append(b__17389,((cljs.core.map_QMARK_(geom_or_geoms))?hatti.map.utils.make_feature(geom_or_geoms,(record.cljs$core$IFn$_invoke$arity$1 ? record.cljs$core$IFn$_invoke$arity$1(hatti.constants._id) : record.call(null,hatti.constants._id)),idx):cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (i__17388,s__17387__$1,geom_or_geoms,vec__17398,idx,record,c__7187__auto__,size__7188__auto__,b__17389,s__17387__$2,temp__4657__auto__){
return (function (p1__17382_SHARP_){
return hatti.map.utils.make_feature(p1__17382_SHARP_,(record.cljs$core$IFn$_invoke$arity$1 ? record.cljs$core$IFn$_invoke$arity$1(hatti.constants._id) : record.call(null,hatti.constants._id)),idx);
});})(i__17388,s__17387__$1,geom_or_geoms,vec__17398,idx,record,c__7187__auto__,size__7188__auto__,b__17389,s__17387__$2,temp__4657__auto__))
,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,cljs.core.flatten(geom_or_geoms)))));

var G__17408 = (i__17388 + (1));
i__17388 = G__17408;
continue;
} else {
var G__17409 = (i__17388 + (1));
i__17388 = G__17409;
continue;
}
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__17389),hatti$map$utils$iter__17386(cljs.core.chunk_rest(s__17387__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__17389),null);
}
} else {
var vec__17401 = cljs.core.first(s__17387__$2);
var idx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17401,(0),null);
var record = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17401,(1),null);
var geom_or_geoms = (hatti.map.utils.get_as_geom.cljs$core$IFn$_invoke$arity$2 ? hatti.map.utils.get_as_geom.cljs$core$IFn$_invoke$arity$2(record,geofield) : hatti.map.utils.get_as_geom.call(null,record,geofield));
if(cljs.core.truth_(geom_or_geoms)){
return cljs.core.cons(((cljs.core.map_QMARK_(geom_or_geoms))?hatti.map.utils.make_feature(geom_or_geoms,(record.cljs$core$IFn$_invoke$arity$1 ? record.cljs$core$IFn$_invoke$arity$1(hatti.constants._id) : record.call(null,hatti.constants._id)),idx):cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (s__17387__$1,geom_or_geoms,vec__17401,idx,record,s__17387__$2,temp__4657__auto__){
return (function (p1__17382_SHARP_){
return hatti.map.utils.make_feature(p1__17382_SHARP_,(record.cljs$core$IFn$_invoke$arity$1 ? record.cljs$core$IFn$_invoke$arity$1(hatti.constants._id) : record.call(null,hatti.constants._id)),idx);
});})(s__17387__$1,geom_or_geoms,vec__17401,idx,record,s__17387__$2,temp__4657__auto__))
,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,cljs.core.flatten(geom_or_geoms)))),hatti$map$utils$iter__17386(cljs.core.rest(s__17387__$2)));
} else {
var G__17410 = cljs.core.rest(s__17387__$2);
s__17387__$1 = G__17410;
continue;
}
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__(hatti.utils.indexed(dataset));
})();
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$type,"FeatureCollection",cljs.core.cst$kw$features,cljs.core.flatten(features)], null);
} else {
return null;
}
});

hatti.map.utils.as_geojson.cljs$lang$maxFixedArity = 3;

/**
 * Creates a leaflet map, rendering it to the dom element with given id.
 */
hatti.map.utils.create_map = (function hatti$map$utils$create_map(id,p__17412){
var map__17415 = p__17412;
var map__17415__$1 = ((((!((map__17415 == null)))?((((map__17415.cljs$lang$protocol_mask$partition0$ & (64))) || (map__17415.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__17415):map__17415);
var mapbox_tiles = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17415__$1,cljs.core.cst$kw$mapbox_DASH_tiles);
var include_google_maps_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17415__$1,cljs.core.cst$kw$include_DASH_google_DASH_maps_QMARK_);
var layers = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (map__17415,map__17415__$1,mapbox_tiles,include_google_maps_QMARK_){
return (function (p1__17411_SHARP_){
return L.tileLayer(cljs.core.cst$kw$url.cljs$core$IFn$_invoke$arity$1(p1__17411_SHARP_));
});})(map__17415,map__17415__$1,mapbox_tiles,include_google_maps_QMARK_))
,mapbox_tiles);
var nlayers = cljs.core.zipmap(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$name,mapbox_tiles),layers);
var named_layers = (cljs.core.truth_(include_google_maps_QMARK_)?cljs.core.clj__GT_js(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(nlayers,"Google Satellite",new L.Google)):cljs.core.clj__GT_js(nlayers));
var m = L.map(id,({"layers": cljs.core.first(layers), "zoomControl": false}));
var z = L.control.zoom.call(null,({"position": "bottomleft"}));
z.addTo(m);

L.control.layers.call(null,named_layers,null,({"position": "bottomleft"})).addTo(m);

m.setView([(0),(0)],(1));

return m;
});
/**
 * Mouse events for markers.
 *   On click or arrow, mapped-submission-to-rank events are generated.
 *   On hover, marker is brought to the front and color changed.
 */
hatti.map.utils.register_mouse_events = (function hatti$map$utils$register_mouse_events(feature,marker,event_chan){
marker.on("click",(function (){
if(cljs.core.truth_(hatti.map.utils.is_clicked_QMARK_(marker))){
return null;
} else {
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mapped_DASH_submission_DASH_to_DASH_rank,((feature["properties"])[hatti.constants._rank])], null));
}
}));

marker.on("mouseover",(function (){
if(cljs.core.truth_(hatti.map.utils.is_clicked_QMARK_(marker))){
return null;
} else {
return hatti.map.utils.apply_hover_style(marker);
}
}));

return marker.on("mouseout",(function (){
if(cljs.core.truth_(hatti.map.utils.is_clicked_QMARK_(marker))){
return null;
} else {
return hatti.map.utils.apply_unclick_style(marker);
}
}));
});
/**
 * Re-renders map by invalidating leaflet size.
 * If map is zoomed out beyond layer-bounds, re-zooms to layer.
 */
hatti.map.utils.re_render_map_BANG_ = (function hatti$map$utils$re_render_map_BANG_(leaflet_map,feature_layer){
var map_bounds = leaflet_map.getBounds();
var layer_bounds = feature_layer.getBounds();
leaflet_map.invalidateSize(false);

if(((leaflet_map.getZoom() === (0))) || (cljs.core.not(layer_bounds.contains(map_bounds)))){
return leaflet_map.fitBounds(layer_bounds);
} else {
return null;
}
});
/**
 * Create a map with the given GeoJSON data.
 * Adds mouse events and centers on the geojson features.
 */
hatti.map.utils.load_geo_json = (function hatti$map$utils$load_geo_json(var_args){
var args__7491__auto__ = [];
var len__7484__auto___17429 = arguments.length;
var i__7485__auto___17430 = (0);
while(true){
if((i__7485__auto___17430 < len__7484__auto___17429)){
args__7491__auto__.push((arguments[i__7485__auto___17430]));

var G__17431 = (i__7485__auto___17430 + (1));
i__7485__auto___17430 = G__17431;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((3) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((3)),(0),null)):null);
return hatti.map.utils.load_geo_json.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7492__auto__);
});

hatti.map.utils.load_geo_json.cljs$core$IFn$_invoke$arity$variadic = (function (m,geojson,event_chan,p__17426){
var map__17427 = p__17426;
var map__17427__$1 = ((((!((map__17427 == null)))?((((map__17427.cljs$lang$protocol_mask$partition0$ & (64))) || (map__17427.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__17427):map__17427);
var rezoom_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17427__$1,cljs.core.cst$kw$rezoom_QMARK_);
var on_events = ((function (map__17427,map__17427__$1,rezoom_QMARK_){
return (function (p1__17417_SHARP_,p2__17418_SHARP_){
return hatti.map.utils.register_mouse_events(p1__17417_SHARP_,p2__17418_SHARP_,event_chan);
});})(map__17427,map__17427__$1,rezoom_QMARK_))
;
var geometry_type = new cljs.core.PersistentArrayMap(null, 3, ["Point",cljs.core.cst$kw$point,"Polygon",cljs.core.cst$kw$shape,"LineString",cljs.core.cst$kw$line], null).call(null,cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$geometry.cljs$core$IFn$_invoke$arity$1(cljs.core.first(cljs.core.cst$kw$features.cljs$core$IFn$_invoke$arity$1(geojson)))));
var stylefn = ((function (on_events,geometry_type,map__17427,map__17427__$1,rezoom_QMARK_){
return (function (){
return hatti.map.utils.get_ona_style(geometry_type,cljs.core.cst$kw$normal);
});})(on_events,geometry_type,map__17427,map__17427__$1,rezoom_QMARK_))
;
var point__GT_marker = ((function (on_events,geometry_type,stylefn,map__17427,map__17427__$1,rezoom_QMARK_){
return (function (p1__17420_SHARP_,p2__17419_SHARP_){
return L.circleMarker(p2__17419_SHARP_);
});})(on_events,geometry_type,stylefn,map__17427,map__17427__$1,rezoom_QMARK_))
;
var feature_layer = L.geoJson(cljs.core.clj__GT_js(geojson),({"onEachFeature": on_events, "pointToLayer": point__GT_marker, "style": stylefn}));
var ids = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (on_events,geometry_type,stylefn,point__GT_marker,feature_layer,map__17427,map__17427__$1,rezoom_QMARK_){
return (function (p1__17421_SHARP_){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(p1__17421_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$properties,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(hatti.constants._id)], null));
});})(on_events,geometry_type,stylefn,point__GT_marker,feature_layer,map__17427,map__17427__$1,rezoom_QMARK_))
,cljs.core.cst$kw$features.cljs$core$IFn$_invoke$arity$1(geojson));
var markers = feature_layer.getLayers();
if(cljs.core.seq(cljs.core.cst$kw$features.cljs$core$IFn$_invoke$arity$1(geojson))){
if(cljs.core.truth_(rezoom_QMARK_)){
m.fitBounds(feature_layer.getBounds());
} else {
}

feature_layer.addTo(m);
} else {
}

return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$feature_DASH_layer,feature_layer,cljs.core.cst$kw$markers,markers,cljs.core.cst$kw$id_DASH__GT_marker,cljs.core.zipmap(ids,markers)], null);
});

hatti.map.utils.load_geo_json.cljs$lang$maxFixedArity = (3);

hatti.map.utils.load_geo_json.cljs$lang$applyTo = (function (seq17422){
var G__17423 = cljs.core.first(seq17422);
var seq17422__$1 = cljs.core.next(seq17422);
var G__17424 = cljs.core.first(seq17422__$1);
var seq17422__$2 = cljs.core.next(seq17422__$1);
var G__17425 = cljs.core.first(seq17422__$2);
var seq17422__$3 = cljs.core.next(seq17422__$2);
return hatti.map.utils.load_geo_json.cljs$core$IFn$_invoke$arity$variadic(G__17423,G__17424,G__17425,seq17422__$3);
});

/**
 * Creates a mapboxgl map, rendering it to the dom element with given id.
 */
hatti.map.utils.create_mapboxgl_map = (function hatti$map$utils$create_mapboxgl_map(id){
mapboxgl.accessToken = hatti.constants.mapboxgl_access_token;

var Map = mapboxgl.Map;
var NavigationControl = mapboxgl.NavigationControl;
var ScaleControl = mapboxgl.ScaleControl;
var m = (new Map(({"container": id, "style": "mapbox://styles/mapbox/streets-v9"})));
m.addControl((new ScaleControl(({"maxWidth": (100), "unit": "metric"}))),"bottom-left");

return m.addControl((new NavigationControl()),"bottom-left");
});
/**
 * Gets query filter and returns filters based on field type
 */
hatti.map.utils.get_filter = (function hatti$map$utils$get_filter(p__17432,flat_form){
var map__17438 = p__17432;
var map__17438__$1 = ((((!((map__17438 == null)))?((((map__17438.cljs$lang$protocol_mask$partition0$ & (64))) || (map__17438.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__17438):map__17438);
var column = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17438__$1,cljs.core.cst$kw$column);
var filter = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17438__$1,cljs.core.cst$kw$filter);
var value = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17438__$1,cljs.core.cst$kw$value);
var field = cljs.core.first(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (map__17438,map__17438__$1,column,filter,value){
return (function (p__17440){
var map__17441 = p__17440;
var map__17441__$1 = ((((!((map__17441 == null)))?((((map__17441.cljs$lang$protocol_mask$partition0$ & (64))) || (map__17441.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__17441):map__17441);
var full_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17441__$1,cljs.core.cst$kw$full_DASH_name);
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(full_name,column);
});})(map__17438,map__17438__$1,column,filter,value))
,flat_form));
if(cljs.core.truth_(hatti.ona.forms.numeric_QMARK_(field))){
return [cljs.core.str("CAST(json->>'"),cljs.core.str(column),cljs.core.str("' AS INT) "),cljs.core.str(filter),cljs.core.str(" '"),cljs.core.str(value),cljs.core.str("'")].join('');
} else {
if(cljs.core.truth_(hatti.ona.forms.time_based_QMARK_(field))){
return [cljs.core.str("CAST(json->>'"),cljs.core.str(column),cljs.core.str("' AS AS TIMESTAMP) "),cljs.core.str(filter),cljs.core.str(" '"),cljs.core.str(value),cljs.core.str("'")].join('');
} else {
return [cljs.core.str("json->>'"),cljs.core.str(column),cljs.core.str("' "),cljs.core.str(filter),cljs.core.str(" '"),cljs.core.str(value),cljs.core.str("'")].join('');

}
}
});
/**
 * Generates query params filters for filtered datasets 
 */
hatti.map.utils.generate_filter_string = (function hatti$map$utils$generate_filter_string(query,flat_form){
if(cljs.core.truth_(cljs.core.not_empty(query))){
return [cljs.core.str(" and "),cljs.core.str(clojure.string.join.cljs$core$IFn$_invoke$arity$2(" and ",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__17443_SHARP_){
return hatti.map.utils.get_filter(p1__17443_SHARP_,flat_form);
}),query)))].join('');
} else {
return null;
}
});
/**
 * Generates tiles url with appropriate filters as query params
 */
hatti.map.utils.get_tiles_endpoint = (function hatti$map$utils$get_tiles_endpoint(var_args){
var args__7491__auto__ = [];
var len__7484__auto___17453 = arguments.length;
var i__7485__auto___17454 = (0);
while(true){
if((i__7485__auto___17454 < len__7484__auto___17453)){
args__7491__auto__.push((arguments[i__7485__auto___17454]));

var G__17455 = (i__7485__auto___17454 + (1));
i__7485__auto___17454 = G__17455;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((4) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((4)),(0),null)):null);
return hatti.map.utils.get_tiles_endpoint.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__7492__auto__);
});

hatti.map.utils.get_tiles_endpoint.cljs$core$IFn$_invoke$arity$variadic = (function (tiles_server,formid,fields,flat_form,p__17449){
var vec__17450 = p__17449;
var query = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17450,(0),null);
return [cljs.core.str(tiles_server),cljs.core.str(hatti.constants.tiles_endpoint),cljs.core.str("?where=deleted_at is null and xform_id ="),cljs.core.str(formid),cljs.core.str(hatti.map.utils.generate_filter_string(query,flat_form)),cljs.core.str("&fields="),cljs.core.str(clojure.string.join.cljs$core$IFn$_invoke$arity$2(",",fields))].join('');
});

hatti.map.utils.get_tiles_endpoint.cljs$lang$maxFixedArity = (4);

hatti.map.utils.get_tiles_endpoint.cljs$lang$applyTo = (function (seq17444){
var G__17445 = cljs.core.first(seq17444);
var seq17444__$1 = cljs.core.next(seq17444);
var G__17446 = cljs.core.first(seq17444__$1);
var seq17444__$2 = cljs.core.next(seq17444__$1);
var G__17447 = cljs.core.first(seq17444__$2);
var seq17444__$3 = cljs.core.next(seq17444__$2);
var G__17448 = cljs.core.first(seq17444__$3);
var seq17444__$4 = cljs.core.next(seq17444__$3);
return hatti.map.utils.get_tiles_endpoint.cljs$core$IFn$_invoke$arity$variadic(G__17445,G__17446,G__17447,G__17448,seq17444__$4);
});

/**
 * Add map source. This is called with either tiles-url or geoson which
 *   determins the source type (Vector or  GeosJSON). 
 */
hatti.map.utils.add_mapboxgl_source = (function hatti$map$utils$add_mapboxgl_source(map,id_string,p__17456){
var map__17460 = p__17456;
var map__17460__$1 = ((((!((map__17460 == null)))?((((map__17460.cljs$lang$protocol_mask$partition0$ & (64))) || (map__17460.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__17460):map__17460);
var tiles_url = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17460__$1,cljs.core.cst$kw$tiles_DASH_url);
var geojson = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17460__$1,cljs.core.cst$kw$geojson);
var cluster = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__17460__$1,cljs.core.cst$kw$cluster,false);
var clusterRadius = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17460__$1,cljs.core.cst$kw$clusterRadius);
var clusterMaxZoom = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17460__$1,cljs.core.cst$kw$clusterMaxZoom);
var geojson_source_defn = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$type,"geojson",cljs.core.cst$kw$data,geojson,cljs.core.cst$kw$cluster,cluster], null);
var source = (cljs.core.truth_(geojson)?cljs.core.clj__GT_js((function (){var G__17462 = geojson_source_defn;
var G__17462__$1 = (cljs.core.truth_(clusterRadius)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__17462,cljs.core.cst$kw$clusterRadius,clusterRadius):G__17462);
if(cljs.core.truth_(clusterMaxZoom)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__17462__$1,cljs.core.cst$kw$clusterMaxZoom,clusterMaxZoom);
} else {
return G__17462__$1;
}
})()):(cljs.core.truth_(tiles_url)?cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$type,"vector",cljs.core.cst$kw$tiles,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [tiles_url], null)], null)):null));
if(cljs.core.truth_(map.getSource(id_string))){
return null;
} else {
return map.addSource(id_string,source);
}
});
/**
 * Add map layer from available sources.
 */
hatti.map.utils.add_mapboxgl_layer = (function hatti$map$utils$add_mapboxgl_layer(var_args){
var args__7491__auto__ = [];
var len__7484__auto___17471 = arguments.length;
var i__7485__auto___17472 = (0);
while(true){
if((i__7485__auto___17472 < len__7484__auto___17471)){
args__7491__auto__.push((arguments[i__7485__auto___17472]));

var G__17473 = (i__7485__auto___17472 + (1));
i__7485__auto___17472 = G__17473;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((3) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((3)),(0),null)):null);
return hatti.map.utils.add_mapboxgl_layer.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7492__auto__);
});

hatti.map.utils.add_mapboxgl_layer.cljs$core$IFn$_invoke$arity$variadic = (function (map,id_string,layer_type,p__17467){
var map__17468 = p__17467;
var map__17468__$1 = ((((!((map__17468 == null)))?((((map__17468.cljs$lang$protocol_mask$partition0$ & (64))) || (map__17468.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__17468):map__17468);
var layer_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17468__$1,cljs.core.cst$kw$layer_DASH_id);
var layout = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17468__$1,cljs.core.cst$kw$layout);
var paint = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17468__$1,cljs.core.cst$kw$paint);
var filter = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17468__$1,cljs.core.cst$kw$filter);
var tiles_url = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17468__$1,cljs.core.cst$kw$tiles_DASH_url);
var l_id = (function (){var or__6409__auto__ = layer_id;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return id_string;
}
})();
var layer_def = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$id,l_id,cljs.core.cst$kw$type,layer_type,cljs.core.cst$kw$source,id_string], null);
var layer = cljs.core.clj__GT_js((function (){var G__17470 = layer_def;
var G__17470__$1 = (cljs.core.truth_(tiles_url)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__17470,cljs.core.cst$kw$source_DASH_layer,hatti.constants.vector_source_layer):G__17470);
var G__17470__$2 = (cljs.core.truth_(paint)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__17470__$1,cljs.core.cst$kw$paint,paint):G__17470__$1);
var G__17470__$3 = (cljs.core.truth_(layout)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__17470__$2,cljs.core.cst$kw$layout,layout):G__17470__$2);
if(cljs.core.truth_(filter)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__17470__$3,cljs.core.cst$kw$filter,filter);
} else {
return G__17470__$3;
}
})());
if(cljs.core.truth_(map.getLayer(l_id))){
return null;
} else {
return map.addLayer(layer,id_string);
}
});

hatti.map.utils.add_mapboxgl_layer.cljs$lang$maxFixedArity = (3);

hatti.map.utils.add_mapboxgl_layer.cljs$lang$applyTo = (function (seq17463){
var G__17464 = cljs.core.first(seq17463);
var seq17463__$1 = cljs.core.next(seq17463);
var G__17465 = cljs.core.first(seq17463__$1);
var seq17463__$2 = cljs.core.next(seq17463__$1);
var G__17466 = cljs.core.first(seq17463__$2);
var seq17463__$3 = cljs.core.next(seq17463__$2);
return hatti.map.utils.add_mapboxgl_layer.cljs$core$IFn$_invoke$arity$variadic(G__17464,G__17465,G__17466,seq17463__$3);
});

/**
 * Generates a collection of input - output value pairs known
 * as stops. These stops are used by get-styles function to decide the style
 * output based on an input vaue from the dataset. e.g. _id. By defauly this
 *  function purely generates color stops.
 */
hatti.map.utils.generate_stops = (function hatti$map$utils$generate_stops(selected_id,selected_color){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),"#f30"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [selected_id,selected_color], null)], null);
});
/**
 * Generates cirlce size property stops base on values from dataset.
 */
hatti.map.utils.generate_size_stops = (function hatti$map$utils$generate_size_stops(selected_id,selected_color){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(4)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [selected_id,selected_color], null)], null);
});
/**
 * Gets predefined styles for diffent layer types and states.
 */
hatti.map.utils.get_styles = (function hatti$map$utils$get_styles(var_args){
var args__7491__auto__ = [];
var len__7484__auto___17479 = arguments.length;
var i__7485__auto___17480 = (0);
while(true){
if((i__7485__auto___17480 < len__7484__auto___17479)){
args__7491__auto__.push((arguments[i__7485__auto___17480]));

var G__17481 = (i__7485__auto___17480 + (1));
i__7485__auto___17480 = G__17481;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((0) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((0)),(0),null)):null);
return hatti.map.utils.get_styles.cljs$core$IFn$_invoke$arity$variadic(argseq__7492__auto__);
});

hatti.map.utils.get_styles.cljs$core$IFn$_invoke$arity$variadic = (function (p__17475){
var vec__17476 = p__17475;
var selected_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17476,(0),null);
var stops = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17476,(1),null);
var size_stops = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17476,(2),null);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$point,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$normal,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["circle-color",cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$property,"id",cljs.core.cst$kw$type,"categorical",cljs.core.cst$kw$stops,(cljs.core.truth_(stops)?stops:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),"#f30"], null)], null))], null))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["circle-radius",(4)], null)], null),cljs.core.cst$kw$hover,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["circle-color",cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$property,"id",cljs.core.cst$kw$type,"categorical",cljs.core.cst$kw$stops,hatti.map.utils.generate_stops(selected_id,"#631400")], null))], null)], null),cljs.core.cst$kw$clicked,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["circle-color",cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$property,"id",cljs.core.cst$kw$type,"categorical",cljs.core.cst$kw$stops,hatti.map.utils.generate_stops(selected_id,"#ad2300")], null))], null)], null),cljs.core.cst$kw$sized,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["circle-radius",cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$property,"id",cljs.core.cst$kw$type,"categorical",cljs.core.cst$kw$stops,(cljs.core.truth_(size_stops)?size_stops:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(6)], null)], null))], null))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["circle-opacity",cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$stops,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(3),0.2], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(15),0.8], null)], null)], null))], null)], null)], null),cljs.core.cst$kw$fill,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$normal,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["fill-color",cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$property,"_id",cljs.core.cst$kw$type,"categorical",cljs.core.cst$kw$stops,(cljs.core.truth_(stops)?stops:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),"#f30"], null)], null))], null))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["fill-opacity",0.7], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["fill-outline-color","#666"], null)], null),cljs.core.cst$kw$hover,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["fill-color",cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$property,"_id",cljs.core.cst$kw$type,"categorical",cljs.core.cst$kw$stops,hatti.map.utils.generate_stops(selected_id,"#631400")], null))], null)], null),cljs.core.cst$kw$clicked,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["fill-color",cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$property,"_id",cljs.core.cst$kw$type,"categorical",cljs.core.cst$kw$stops,hatti.map.utils.generate_stops(selected_id,"#ad2300")], null))], null)], null)], null),cljs.core.cst$kw$line,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$normal,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["line-color",cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$property,"_id",cljs.core.cst$kw$type,"categorical",cljs.core.cst$kw$stops,(cljs.core.truth_(stops)?stops:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),"#f30"], null)], null))], null))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["line-opacity",0.8], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["line-width",(7)], null)], null),cljs.core.cst$kw$hover,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["line-color",cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$property,"_id",cljs.core.cst$kw$type,"categorical",cljs.core.cst$kw$stops,hatti.map.utils.generate_stops(selected_id,"#631400")], null))], null)], null),cljs.core.cst$kw$clicked,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["line-color",cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$property,"_id",cljs.core.cst$kw$type,"categorical",cljs.core.cst$kw$stops,hatti.map.utils.generate_stops(selected_id,"#ad2300")], null))], null)], null)], null)], null);
});

hatti.map.utils.get_styles.cljs$lang$maxFixedArity = (0);

hatti.map.utils.get_styles.cljs$lang$applyTo = (function (seq17474){
return hatti.map.utils.get_styles.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq17474));
});

/**
 * Get style properties for layer.
 */
hatti.map.utils.get_style_properties = (function hatti$map$utils$get_style_properties(var_args){
var args__7491__auto__ = [];
var len__7484__auto___17490 = arguments.length;
var i__7485__auto___17491 = (0);
while(true){
if((i__7485__auto___17491 < len__7484__auto___17490)){
args__7491__auto__.push((arguments[i__7485__auto___17491]));

var G__17492 = (i__7485__auto___17491 + (1));
i__7485__auto___17491 = G__17492;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((2) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((2)),(0),null)):null);
return hatti.map.utils.get_style_properties.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7492__auto__);
});

hatti.map.utils.get_style_properties.cljs$core$IFn$_invoke$arity$variadic = (function (style_type,style_state,p__17485){
var map__17486 = p__17485;
var map__17486__$1 = ((((!((map__17486 == null)))?((((map__17486.cljs$lang$protocol_mask$partition0$ & (64))) || (map__17486.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__17486):map__17486);
var selected_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17486__$1,cljs.core.cst$kw$selected_DASH_id);
var stops = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17486__$1,cljs.core.cst$kw$stops);
var G__17488 = (function (){var G__17489 = hatti.map.utils.get_styles.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([selected_id,stops], 0));
return (style_type.cljs$core$IFn$_invoke$arity$1 ? style_type.cljs$core$IFn$_invoke$arity$1(G__17489) : style_type.call(null,G__17489));
})();
return (style_state.cljs$core$IFn$_invoke$arity$1 ? style_state.cljs$core$IFn$_invoke$arity$1(G__17488) : style_state.call(null,G__17488));
});

hatti.map.utils.get_style_properties.cljs$lang$maxFixedArity = (2);

hatti.map.utils.get_style_properties.cljs$lang$applyTo = (function (seq17482){
var G__17483 = cljs.core.first(seq17482);
var seq17482__$1 = cljs.core.next(seq17482);
var G__17484 = cljs.core.first(seq17482__$1);
var seq17482__$2 = cljs.core.next(seq17482__$1);
return hatti.map.utils.get_style_properties.cljs$core$IFn$_invoke$arity$variadic(G__17483,G__17484,seq17482__$2);
});

/**
 * Sets maps paint properties given layer-id and list of properties to set.
 *   properties should be a list of properties that contains the propery name
 *   and value in a vector. e.g. [[property1 value1] [property2 value2]
 */
hatti.map.utils.set_mapboxgl_paint_property = (function hatti$map$utils$set_mapboxgl_paint_property(map,layer_id,properties){
var seq__17503 = cljs.core.seq(properties);
var chunk__17504 = null;
var count__17505 = (0);
var i__17506 = (0);
while(true){
if((i__17506 < count__17505)){
var vec__17507 = chunk__17504.cljs$core$IIndexed$_nth$arity$2(null,i__17506);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17507,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17507,(1),null);
map.setPaintProperty(layer_id,p,v);

var G__17513 = seq__17503;
var G__17514 = chunk__17504;
var G__17515 = count__17505;
var G__17516 = (i__17506 + (1));
seq__17503 = G__17513;
chunk__17504 = G__17514;
count__17505 = G__17515;
i__17506 = G__17516;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq(seq__17503);
if(temp__4657__auto__){
var seq__17503__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__17503__$1)){
var c__7220__auto__ = cljs.core.chunk_first(seq__17503__$1);
var G__17517 = cljs.core.chunk_rest(seq__17503__$1);
var G__17518 = c__7220__auto__;
var G__17519 = cljs.core.count(c__7220__auto__);
var G__17520 = (0);
seq__17503 = G__17517;
chunk__17504 = G__17518;
count__17505 = G__17519;
i__17506 = G__17520;
continue;
} else {
var vec__17510 = cljs.core.first(seq__17503__$1);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17510,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17510,(1),null);
map.setPaintProperty(layer_id,p,v);

var G__17521 = cljs.core.next(seq__17503__$1);
var G__17522 = null;
var G__17523 = (0);
var G__17524 = (0);
seq__17503 = G__17521;
chunk__17504 = G__17522;
count__17505 = G__17523;
i__17506 = G__17524;
continue;
}
} else {
return null;
}
}
break;
}
});
hatti.map.utils.get_id_property = (function hatti$map$utils$get_id_property(features){
var properties = (cljs.core.first(features)["properties"]);
var or__6409__auto__ = (properties["id"]);
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return (properties[hatti.constants._id]);
}
});
/**
 * Register map mouse events.
 */
hatti.map.utils.register_mapboxgl_mouse_events = (function hatti$map$utils$register_mapboxgl_mouse_events(owner,map,event_chan,id_string,style){
var layer_id = id_string;
var mousemove_fn = ((function (layer_id){
return (function (e){
if(cljs.core.truth_(map.getLayer(layer_id))){
var features = map.queryRenderedFeatures(e.point,cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$layers,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [layer_id], null)], null)));
var no_of_features = features.length;
var view_by = om.core.get_props.cljs$core$IFn$_invoke$arity$2(owner,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$map_DASH_page,cljs.core.cst$kw$view_DASH_by], null));
var selected_id = om.core.get_props.cljs$core$IFn$_invoke$arity$2(owner,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$map_DASH_page,cljs.core.cst$kw$submission_DASH_clicked,cljs.core.cst$kw$id], null));
map.getCanvas().style.cursor = (((features.length > (0)))?"pointer":"");

if(cljs.core.truth_(view_by)){
return null;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(no_of_features,(1))){
return hatti.map.utils.set_mapboxgl_paint_property(map,layer_id,hatti.map.utils.get_style_properties.cljs$core$IFn$_invoke$arity$variadic(style,cljs.core.cst$kw$hover,cljs.core.array_seq([cljs.core.cst$kw$selected_DASH_id,hatti.map.utils.get_id_property(features)], 0)));
} else {
hatti.map.utils.set_mapboxgl_paint_property(map,layer_id,hatti.map.utils.get_style_properties(style,cljs.core.cst$kw$normal));

if(cljs.core.truth_(selected_id)){
return hatti.map.utils.set_mapboxgl_paint_property(map,layer_id,hatti.map.utils.get_style_properties.cljs$core$IFn$_invoke$arity$variadic(style,cljs.core.cst$kw$clicked,cljs.core.array_seq([cljs.core.cst$kw$selected_DASH_id,selected_id], 0)));
} else {
return null;
}
}
}
} else {
return null;
}
});})(layer_id))
;
var click_fn = ((function (layer_id,mousemove_fn){
return (function (e){
if(cljs.core.truth_(map.getLayer(layer_id))){
var features = map.queryRenderedFeatures(e.point,cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$layers,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [layer_id], null)], null)));
var no_of_features = features.length;
var view_by = om.core.get_props.cljs$core$IFn$_invoke$arity$2(owner,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$map_DASH_page,cljs.core.cst$kw$view_DASH_by], null));
if((no_of_features > (0))){
var feature_id = hatti.map.utils.get_id_property(features);
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mapped_DASH_submission_DASH_to_DASH_id,feature_id], null));

if(cljs.core.truth_(view_by)){
return null;
} else {
return hatti.map.utils.set_mapboxgl_paint_property(map,layer_id,hatti.map.utils.get_style_properties.cljs$core$IFn$_invoke$arity$variadic(style,cljs.core.cst$kw$clicked,cljs.core.array_seq([cljs.core.cst$kw$selected_DASH_id,feature_id], 0)));
}
} else {
return null;
}
} else {
return null;
}
});})(layer_id,mousemove_fn))
;
map.off("mousemove",om.core.get_state.cljs$core$IFn$_invoke$arity$2(owner,cljs.core.cst$kw$mousemove_DASH_fn));

map.off("click",om.core.get_state.cljs$core$IFn$_invoke$arity$2(owner,cljs.core.cst$kw$click_DASH_fn));

map.on("mousemove",mousemove_fn);

map.on("click",click_fn);

om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$mousemove_DASH_fn,mousemove_fn);

return om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$click_DASH_fn,click_fn);
});
/**
 * Fits map boundaries on rendered features.
 */
hatti.map.utils.fitMapBounds = (function hatti$map$utils$fitMapBounds(var_args){
var args__7491__auto__ = [];
var len__7484__auto___17532 = arguments.length;
var i__7485__auto___17533 = (0);
while(true){
if((i__7485__auto___17533 < len__7484__auto___17532)){
args__7491__auto__.push((arguments[i__7485__auto___17533]));

var G__17534 = (i__7485__auto___17533 + (1));
i__7485__auto___17533 = G__17534;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((2) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((2)),(0),null)):null);
return hatti.map.utils.fitMapBounds.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7492__auto__);
});

hatti.map.utils.fitMapBounds.cljs$core$IFn$_invoke$arity$variadic = (function (map,layer_id,p__17528){
var vec__17529 = p__17528;
var geojson = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17529,(0),null);
var features = (function (){var or__6409__auto__ = cljs.core.cst$kw$features.cljs$core$IFn$_invoke$arity$1(geojson);
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
var or__6409__auto____$1 = (cljs.core.truth_(map.getLayer(layer_id))?map.queryRenderedFeatures(cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$layers,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [layer_id], null)], null))):null);
if(cljs.core.truth_(or__6409__auto____$1)){
return or__6409__auto____$1;
} else {
return cljs.core.PersistentVector.EMPTY;
}
}
})();
var layer_data = (function (){var or__6409__auto__ = geojson;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$type,"FeatureCollection",cljs.core.cst$kw$features,features], null));
}
})();
var bbox = turf.bbox(cljs.core.clj__GT_js(layer_data));
if((cljs.core.count(features) > (0))){
return map.fitBounds(bbox,({"padding": "15", "linear": true}));
} else {
return null;
}
});

hatti.map.utils.fitMapBounds.cljs$lang$maxFixedArity = (2);

hatti.map.utils.fitMapBounds.cljs$lang$applyTo = (function (seq17525){
var G__17526 = cljs.core.first(seq17525);
var seq17525__$1 = cljs.core.next(seq17525);
var G__17527 = cljs.core.first(seq17525__$1);
var seq17525__$2 = cljs.core.next(seq17525__$1);
return hatti.map.utils.fitMapBounds.cljs$core$IFn$_invoke$arity$variadic(G__17526,G__17527,seq17525__$2);
});

/**
 * Get marker style for field type.
 */
hatti.map.utils.geotype__GT_marker_style = (function hatti$map$utils$geotype__GT_marker_style(field){
if(cljs.core.truth_(hatti.ona.forms.geoshape_QMARK_(field))){
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$layer_DASH_type,"fill",cljs.core.cst$kw$style,cljs.core.cst$kw$fill], null);
} else {
if(cljs.core.truth_(hatti.ona.forms.osm_QMARK_(field))){
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$layer_DASH_type,"fill",cljs.core.cst$kw$style,cljs.core.cst$kw$fill], null);
} else {
if(cljs.core.truth_((function (){var or__6409__auto__ = hatti.ona.forms.geotrace_QMARK_(field);
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return hatti.ona.forms.repeat_QMARK_(field);
}
})())){
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$layer_DASH_type,"line",cljs.core.cst$kw$style,cljs.core.cst$kw$line,cljs.core.cst$kw$layout,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$line_DASH_join,"round",cljs.core.cst$kw$line_DASH_cap,"round"], null)], null);
} else {
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$layer_DASH_type,"circle",cljs.core.cst$kw$style,cljs.core.cst$kw$point], null);

}
}
}
});
/**
 * Filter features and return only selected features. Returns all features
 *   features if selected-ids is nil. 
 */
hatti.map.utils.filter_selected_features = (function hatti$map$utils$filter_selected_features(features,selected_ids){
var G__17541 = features;
if(cljs.core.truth_(selected_ids)){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (G__17541){
return (function (p__17542){
var map__17543 = p__17542;
var map__17543__$1 = ((((!((map__17543 == null)))?((((map__17543.cljs$lang$protocol_mask$partition0$ & (64))) || (map__17543.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__17543):map__17543);
var map__17544 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17543__$1,cljs.core.cst$kw$properties);
var map__17544__$1 = ((((!((map__17544 == null)))?((((map__17544.cljs$lang$protocol_mask$partition0$ & (64))) || (map__17544.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__17544):map__17544);
var _id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17544__$1,cljs.core.cst$kw$_id);
return chimera.seq.in_QMARK_(selected_ids,_id);
});})(G__17541))
,G__17541);
} else {
return G__17541;
}
});
/**
 * Counts points collected into hexbins.
 */
hatti.map.utils.count_hexbin_points = (function hatti$map$utils$count_hexbin_points(hexbins){
var iter__7189__auto__ = (function hatti$map$utils$count_hexbin_points_$_iter__17569(s__17570){
return (new cljs.core.LazySeq(null,(function (){
var s__17570__$1 = s__17570;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__17570__$1);
if(temp__4657__auto__){
var s__17570__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__17570__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__17570__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__17572 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__17571 = (0);
while(true){
if((i__17571 < size__7188__auto__)){
var map__17583 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__17571);
var map__17583__$1 = ((((!((map__17583 == null)))?((((map__17583.cljs$lang$protocol_mask$partition0$ & (64))) || (map__17583.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__17583):map__17583);
var feature = map__17583__$1;
var map__17584 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17583__$1,cljs.core.cst$kw$properties);
var map__17584__$1 = ((((!((map__17584 == null)))?((((map__17584.cljs$lang$protocol_mask$partition0$ & (64))) || (map__17584.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__17584):map__17584);
var points = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17584__$1,cljs.core.cst$kw$points);
var point_count = cljs.core.count(points);
cljs.core.chunk_append(b__17572,(((point_count > (0)))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(feature,cljs.core.cst$kw$properties,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$point_DASH_count,point_count], null)):null));

var G__17591 = (i__17571 + (1));
i__17571 = G__17591;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__17572),hatti$map$utils$count_hexbin_points_$_iter__17569(cljs.core.chunk_rest(s__17570__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__17572),null);
}
} else {
var map__17587 = cljs.core.first(s__17570__$2);
var map__17587__$1 = ((((!((map__17587 == null)))?((((map__17587.cljs$lang$protocol_mask$partition0$ & (64))) || (map__17587.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__17587):map__17587);
var feature = map__17587__$1;
var map__17588 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17587__$1,cljs.core.cst$kw$properties);
var map__17588__$1 = ((((!((map__17588 == null)))?((((map__17588.cljs$lang$protocol_mask$partition0$ & (64))) || (map__17588.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__17588):map__17588);
var points = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17588__$1,cljs.core.cst$kw$points);
var point_count = cljs.core.count(points);
return cljs.core.cons((((point_count > (0)))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(feature,cljs.core.cst$kw$properties,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$point_DASH_count,point_count], null)):null),hatti$map$utils$count_hexbin_points_$_iter__17569(cljs.core.rest(s__17570__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__(cljs.core.cst$kw$features.cljs$core$IFn$_invoke$arity$1(hexbins));
});
hatti.map.utils.get_rendered_features = (function hatti$map$utils$get_rendered_features(var_args){
var args__7491__auto__ = [];
var len__7484__auto___17599 = arguments.length;
var i__7485__auto___17600 = (0);
while(true){
if((i__7485__auto___17600 < len__7484__auto___17599)){
args__7491__auto__.push((arguments[i__7485__auto___17600]));

var G__17601 = (i__7485__auto___17600 + (1));
i__7485__auto___17600 = G__17601;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((2) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((2)),(0),null)):null);
return hatti.map.utils.get_rendered_features.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7492__auto__);
});

hatti.map.utils.get_rendered_features.cljs$core$IFn$_invoke$arity$variadic = (function (map,layer_id,p__17596){
var map__17597 = p__17596;
var map__17597__$1 = ((((!((map__17597 == null)))?((((map__17597.cljs$lang$protocol_mask$partition0$ & (64))) || (map__17597.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__17597):map__17597);
var geojson = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17597__$1,cljs.core.cst$kw$geojson);
var selected_ids = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17597__$1,cljs.core.cst$kw$selected_DASH_ids);

var get_rendered_features = ((function (map__17597,map__17597__$1,geojson,selected_ids){
return (function (){
return map.queryRenderedFeatures(cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$layers,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [layer_id], null)], null)));
});})(map__17597,map__17597__$1,geojson,selected_ids))
;
var rendered_features = (function (){var or__6409__auto__ = geojson;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$type,"FeatureCollection",cljs.core.cst$kw$features,get_rendered_features()], null);
}
})();
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(rendered_features,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$features], null),((function (get_rendered_features,rendered_features,map__17597,map__17597__$1,geojson,selected_ids){
return (function (p1__17592_SHARP_){
return hatti.map.utils.filter_selected_features(p1__17592_SHARP_,selected_ids);
});})(get_rendered_features,rendered_features,map__17597,map__17597__$1,geojson,selected_ids))
);
});

hatti.map.utils.get_rendered_features.cljs$lang$maxFixedArity = (2);

hatti.map.utils.get_rendered_features.cljs$lang$applyTo = (function (seq17593){
var G__17594 = cljs.core.first(seq17593);
var seq17593__$1 = cljs.core.next(seq17593);
var G__17595 = cljs.core.first(seq17593__$1);
var seq17593__$2 = cljs.core.next(seq17593__$1);
return hatti.map.utils.get_rendered_features.cljs$core$IFn$_invoke$arity$variadic(G__17594,G__17595,seq17593__$2);
});

/**
 * Generates hexbins with point count aggregation given rendered
 *   layer-id or geojson.
 */
hatti.map.utils.generate_hexgrid = (function hatti$map$utils$generate_hexgrid(map,layer_id,geojson,p__17602){
var map__17611 = p__17602;
var map__17611__$1 = ((((!((map__17611 == null)))?((((map__17611.cljs$lang$protocol_mask$partition0$ & (64))) || (map__17611.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__17611):map__17611);
var cell_width = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17611__$1,cljs.core.cst$kw$cell_DASH_width);
var selected_ids = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17611__$1,cljs.core.cst$kw$selected_DASH_ids);
var rendered_features = hatti.map.utils.get_rendered_features.cljs$core$IFn$_invoke$arity$variadic(map,layer_id,cljs.core.array_seq([cljs.core.cst$kw$geojson,geojson,cljs.core.cst$kw$selected_DASH_ids,selected_ids], 0));
var js_rendered_features = cljs.core.clj__GT_js(rendered_features);
var bbox = turf.bbox(js_rendered_features);
var cellWidth = (function (){var or__6409__auto__ = cell_width;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return hatti.constants.hexbin_cell_width;
}
})();
var units = "kilometers";
var hexgrid = turf.hexGrid(bbox,cellWidth,units);
var hex_collection = turf.collect(hexgrid,js_rendered_features,"_id","points");
var hexbins = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(hex_collection,cljs.core.array_seq([cljs.core.cst$kw$keywordize_DASH_keys,true], 0));
var features_w_count = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,hatti.map.utils.count_hexbin_points(hexbins));
var point_counts = (function (){var iter__7189__auto__ = ((function (rendered_features,js_rendered_features,bbox,cellWidth,units,hexgrid,hex_collection,hexbins,features_w_count,map__17611,map__17611__$1,cell_width,selected_ids){
return (function hatti$map$utils$generate_hexgrid_$_iter__17613(s__17614){
return (new cljs.core.LazySeq(null,((function (rendered_features,js_rendered_features,bbox,cellWidth,units,hexgrid,hex_collection,hexbins,features_w_count,map__17611,map__17611__$1,cell_width,selected_ids){
return (function (){
var s__17614__$1 = s__17614;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__17614__$1);
if(temp__4657__auto__){
var s__17614__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__17614__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__17614__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__17616 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__17615 = (0);
while(true){
if((i__17615 < size__7188__auto__)){
var f = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__17615);
cljs.core.chunk_append(b__17616,cljs.core.cst$kw$point_DASH_count.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$properties.cljs$core$IFn$_invoke$arity$1(f)));

var G__17619 = (i__17615 + (1));
i__17615 = G__17619;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__17616),hatti$map$utils$generate_hexgrid_$_iter__17613(cljs.core.chunk_rest(s__17614__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__17616),null);
}
} else {
var f = cljs.core.first(s__17614__$2);
return cljs.core.cons(cljs.core.cst$kw$point_DASH_count.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$properties.cljs$core$IFn$_invoke$arity$1(f)),hatti$map$utils$generate_hexgrid_$_iter__17613(cljs.core.rest(s__17614__$2)));
}
} else {
return null;
}
break;
}
});})(rendered_features,js_rendered_features,bbox,cellWidth,units,hexgrid,hex_collection,hexbins,features_w_count,map__17611,map__17611__$1,cell_width,selected_ids))
,null,null));
});})(rendered_features,js_rendered_features,bbox,cellWidth,units,hexgrid,hex_collection,hexbins,features_w_count,map__17611,map__17611__$1,cell_width,selected_ids))
;
return iter__7189__auto__(features_w_count);
})();
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(hexbins,cljs.core.cst$kw$features,features_w_count,cljs.core.array_seq([cljs.core.cst$kw$properties,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$min_DASH_count,cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.min,point_counts),cljs.core.cst$kw$max_DASH_count,cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.max,point_counts)], null)], 0));
});
/**
 * Show/or hide geopoints. Hide geopoints if hide-points is true.
 */
hatti.map.utils.show_hide_points = (function hatti$map$utils$show_hide_points(var_args){
var args__7491__auto__ = [];
var len__7484__auto___17627 = arguments.length;
var i__7485__auto___17628 = (0);
while(true){
if((i__7485__auto___17628 < len__7484__auto___17627)){
args__7491__auto__.push((arguments[i__7485__auto___17628]));

var G__17629 = (i__7485__auto___17628 + (1));
i__7485__auto___17628 = G__17629;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((2) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((2)),(0),null)):null);
return hatti.map.utils.show_hide_points.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7492__auto__);
});

hatti.map.utils.show_hide_points.cljs$core$IFn$_invoke$arity$variadic = (function (map,layer_id,p__17623){
var vec__17624 = p__17623;
var hide_points_QMARK_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17624,(0),null);
var visibility = (cljs.core.truth_(hide_points_QMARK_)?"none":"visible");
if(cljs.core.truth_(map.getLayer(layer_id))){
map.setLayoutProperty(layer_id,"visibility",visibility);
} else {
}

if(cljs.core.truth_(map.getLayer(hatti.map.utils.circle_border_id))){
return map.setLayoutProperty(hatti.map.utils.circle_border_id,"visibility",visibility);
} else {
return null;
}
});

hatti.map.utils.show_hide_points.cljs$lang$maxFixedArity = (2);

hatti.map.utils.show_hide_points.cljs$lang$applyTo = (function (seq17620){
var G__17621 = cljs.core.first(seq17620);
var seq17620__$1 = cljs.core.next(seq17620);
var G__17622 = cljs.core.first(seq17620__$1);
var seq17620__$2 = cljs.core.next(seq17620__$1);
return hatti.map.utils.show_hide_points.cljs$core$IFn$_invoke$arity$variadic(G__17621,G__17622,seq17620__$2);
});

/**
 * Remove layer from map and it's source from map.
 */
hatti.map.utils.remove_layer = (function hatti$map$utils$remove_layer(var_args){
var args__7491__auto__ = [];
var len__7484__auto___17636 = arguments.length;
var i__7485__auto___17637 = (0);
while(true){
if((i__7485__auto___17637 < len__7484__auto___17636)){
args__7491__auto__.push((arguments[i__7485__auto___17637]));

var G__17638 = (i__7485__auto___17637 + (1));
i__7485__auto___17637 = G__17638;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((2) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((2)),(0),null)):null);
return hatti.map.utils.remove_layer.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7492__auto__);
});

hatti.map.utils.remove_layer.cljs$core$IFn$_invoke$arity$variadic = (function (map,id,p__17633){
var map__17634 = p__17633;
var map__17634__$1 = ((((!((map__17634 == null)))?((((map__17634.cljs$lang$protocol_mask$partition0$ & (64))) || (map__17634.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__17634):map__17634);
var keep_source_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17634__$1,cljs.core.cst$kw$keep_DASH_source_QMARK_);
if(cljs.core.truth_(map.getLayer(id))){
map.removeLayer(id);
} else {
}

if(cljs.core.truth_((function (){var and__6397__auto__ = map.getSource(id);
if(cljs.core.truth_(and__6397__auto__)){
return cljs.core.not(keep_source_QMARK_);
} else {
return and__6397__auto__;
}
})())){
return map.removeSource(id);
} else {
return null;
}
});

hatti.map.utils.remove_layer.cljs$lang$maxFixedArity = (2);

hatti.map.utils.remove_layer.cljs$lang$applyTo = (function (seq17630){
var G__17631 = cljs.core.first(seq17630);
var seq17630__$1 = cljs.core.next(seq17630);
var G__17632 = cljs.core.first(seq17630__$1);
var seq17630__$2 = cljs.core.next(seq17630__$1);
return hatti.map.utils.remove_layer.cljs$core$IFn$_invoke$arity$variadic(G__17631,G__17632,seq17630__$2);
});

/**
 * Renders hexbin layer on map.
 */
hatti.map.utils.show_hexbins = (function hatti$map$utils$show_hexbins(owner,map,id_string,geojson,p__17639){
var map__17644 = p__17639;
var map__17644__$1 = ((((!((map__17644 == null)))?((((map__17644.cljs$lang$protocol_mask$partition0$ & (64))) || (map__17644.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__17644):map__17644);
var opts = map__17644__$1;
var cell_color = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17644__$1,cljs.core.cst$kw$cell_DASH_color);
var extrusion_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17644__$1,cljs.core.cst$kw$extrusion_QMARK_);
var hide_points_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17644__$1,cljs.core.cst$kw$hide_DASH_points_QMARK_);
var hexgrid = hatti.map.utils.generate_hexgrid(map,id_string,geojson,opts);
var map__17646 = cljs.core.cst$kw$properties.cljs$core$IFn$_invoke$arity$1(hexgrid);
var map__17646__$1 = ((((!((map__17646 == null)))?((((map__17646.cljs$lang$protocol_mask$partition0$ & (64))) || (map__17646.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__17646):map__17646);
var min_count = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17646__$1,cljs.core.cst$kw$min_DASH_count);
var max_count = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17646__$1,cljs.core.cst$kw$max_DASH_count);
var max_color = (function (){var or__6409__auto__ = cell_color;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return hatti.constants.max_count_color;
}
})();
var min_color = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(min_count,max_count))?max_color:hatti.constants.min_count_color);
var property = "point-count";
var fill_color = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$property,"point-count",cljs.core.cst$kw$stops,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),"transparent"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [min_count,min_color], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [max_count,max_color], null)], null)], null);
var fill_opacity = 0.6;
var paint = (cljs.core.truth_(extrusion_QMARK_)?new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fill_DASH_extrusion_DASH_color,fill_color,cljs.core.cst$kw$fill_DASH_extrusion_DASH_opacity,fill_opacity,cljs.core.cst$kw$fill_DASH_extrusion_DASH_height,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$property,property,cljs.core.cst$kw$stops,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [min_count,(10)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [max_count,(25000)], null)], null),cljs.core.cst$kw$base,(1)], null)], null):new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fill_DASH_outline_DASH_color,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$property,property,cljs.core.cst$kw$stops,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),"transparent"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [max_count,"white"], null)], null)], null),cljs.core.cst$kw$fill_DASH_color,fill_color,cljs.core.cst$kw$fill_DASH_opacity,fill_opacity], null));
var layer_type = (cljs.core.truth_(extrusion_QMARK_)?"fill-extrusion":"fill");
var extrusion_layer_id = [cljs.core.str(hatti.constants.hexgrid_id),cljs.core.str("-extrusion")].join('');
if(cljs.core.truth_((function (){var and__6397__auto__ = min_count;
if(cljs.core.truth_(and__6397__auto__)){
return max_count;
} else {
return and__6397__auto__;
}
})())){
hatti.map.utils.add_mapboxgl_source(map,hatti.constants.hexgrid_id,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$geojson,hexgrid], null));

hatti.map.utils.add_mapboxgl_layer.cljs$core$IFn$_invoke$arity$variadic(map,hatti.constants.hexgrid_id,layer_type,cljs.core.array_seq([cljs.core.cst$kw$paint,paint], 0));

if(cljs.core.truth_(extrusion_QMARK_)){
hatti.map.utils.add_mapboxgl_layer.cljs$core$IFn$_invoke$arity$variadic(map,hatti.constants.hexgrid_id,layer_type,cljs.core.array_seq([cljs.core.cst$kw$paint,paint,cljs.core.cst$kw$layer_DASH_id,extrusion_layer_id], 0));

map.setLayoutProperty(hatti.constants.hexgrid_id,"visibility","none");
} else {
map.setLayoutProperty(hatti.constants.hexgrid_id,"visibility","visible");

hatti.map.utils.remove_layer.cljs$core$IFn$_invoke$arity$variadic(map,extrusion_layer_id,cljs.core.array_seq([cljs.core.cst$kw$keep_DASH_source_QMARK_,true], 0));
}

map.setPitch((cljs.core.truth_(extrusion_QMARK_)?(50):(0)));

hatti.map.utils.show_hide_points.cljs$core$IFn$_invoke$arity$variadic(map,id_string,cljs.core.array_seq([hide_points_QMARK_], 0));

return om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$show_DASH_hexbins_QMARK_,true);
} else {
return null;
}
});
/**
 * Renders heatmap layer on map.
 */
hatti.map.utils.show_heatmap = (function hatti$map$utils$show_heatmap(owner,map,id_string,geojson,p__17648){
var map__17667 = p__17648;
var map__17667__$1 = ((((!((map__17667 == null)))?((((map__17667.cljs$lang$protocol_mask$partition0$ & (64))) || (map__17667.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__17667):map__17667);
var selected_ids = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17667__$1,cljs.core.cst$kw$selected_DASH_ids);
var rendered_features = hatti.map.utils.get_rendered_features.cljs$core$IFn$_invoke$arity$variadic(map,id_string,cljs.core.array_seq([cljs.core.cst$kw$geojson,geojson,cljs.core.cst$kw$selected_DASH_ids,selected_ids], 0));
var layers = cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(((function (rendered_features,map__17667,map__17667__$1,selected_ids){
return (function (idx,item){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [idx,item], null);
});})(rendered_features,map__17667,map__17667__$1,selected_ids))
,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),"green"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(30),"#ffeda0"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(80),"orange"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(200),"red"], null)], null));
var layer_count = cljs.core.count(layers);
hatti.map.utils.add_mapboxgl_source(map,"heatmap",new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$geojson,rendered_features,cljs.core.cst$kw$cluster,true,cljs.core.cst$kw$clusterRadius,(20),cljs.core.cst$kw$clusterMaxZoom,(15)], null));

var seq__17669_17685 = cljs.core.seq(layers);
var chunk__17670_17686 = null;
var count__17671_17687 = (0);
var i__17672_17688 = (0);
while(true){
if((i__17672_17688 < count__17671_17687)){
var vec__17673_17689 = chunk__17670_17686.cljs$core$IIndexed$_nth$arity$2(null,i__17672_17688);
var i_17690 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17673_17689,(0),null);
var vec__17676_17691 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17673_17689,(1),null);
var point_count_17692 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17676_17691,(0),null);
var color_17693 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17676_17691,(1),null);
hatti.map.utils.add_mapboxgl_layer.cljs$core$IFn$_invoke$arity$variadic(map,"heatmap","circle",cljs.core.array_seq([cljs.core.cst$kw$layer_DASH_id,[cljs.core.str("cluster-"),cljs.core.str(i_17690)].join(''),cljs.core.cst$kw$paint,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$circle_DASH_color,color_17693,cljs.core.cst$kw$circle_DASH_radius,(70),cljs.core.cst$kw$circle_DASH_blur,(1),cljs.core.cst$kw$circle_DASH_opacity,0.7], null),cljs.core.cst$kw$filter,((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(i_17690,(layer_count - (1))))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [">=","point_count",point_count_17692], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["all",new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [">=","point_count",point_count_17692], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["<","point_count",cljs.core.first(cljs.core.second(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(layers,(i_17690 + (1)))))], null)], null))], 0));

var G__17694 = seq__17669_17685;
var G__17695 = chunk__17670_17686;
var G__17696 = count__17671_17687;
var G__17697 = (i__17672_17688 + (1));
seq__17669_17685 = G__17694;
chunk__17670_17686 = G__17695;
count__17671_17687 = G__17696;
i__17672_17688 = G__17697;
continue;
} else {
var temp__4657__auto___17698 = cljs.core.seq(seq__17669_17685);
if(temp__4657__auto___17698){
var seq__17669_17699__$1 = temp__4657__auto___17698;
if(cljs.core.chunked_seq_QMARK_(seq__17669_17699__$1)){
var c__7220__auto___17700 = cljs.core.chunk_first(seq__17669_17699__$1);
var G__17701 = cljs.core.chunk_rest(seq__17669_17699__$1);
var G__17702 = c__7220__auto___17700;
var G__17703 = cljs.core.count(c__7220__auto___17700);
var G__17704 = (0);
seq__17669_17685 = G__17701;
chunk__17670_17686 = G__17702;
count__17671_17687 = G__17703;
i__17672_17688 = G__17704;
continue;
} else {
var vec__17679_17705 = cljs.core.first(seq__17669_17699__$1);
var i_17706 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17679_17705,(0),null);
var vec__17682_17707 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17679_17705,(1),null);
var point_count_17708 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17682_17707,(0),null);
var color_17709 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17682_17707,(1),null);
hatti.map.utils.add_mapboxgl_layer.cljs$core$IFn$_invoke$arity$variadic(map,"heatmap","circle",cljs.core.array_seq([cljs.core.cst$kw$layer_DASH_id,[cljs.core.str("cluster-"),cljs.core.str(i_17706)].join(''),cljs.core.cst$kw$paint,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$circle_DASH_color,color_17709,cljs.core.cst$kw$circle_DASH_radius,(70),cljs.core.cst$kw$circle_DASH_blur,(1),cljs.core.cst$kw$circle_DASH_opacity,0.7], null),cljs.core.cst$kw$filter,((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(i_17706,(layer_count - (1))))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [">=","point_count",point_count_17708], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["all",new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [">=","point_count",point_count_17708], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["<","point_count",cljs.core.first(cljs.core.second(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(layers,(i_17706 + (1)))))], null)], null))], 0));

var G__17710 = cljs.core.next(seq__17669_17699__$1);
var G__17711 = null;
var G__17712 = (0);
var G__17713 = (0);
seq__17669_17685 = G__17710;
chunk__17670_17686 = G__17711;
count__17671_17687 = G__17712;
i__17672_17688 = G__17713;
continue;
}
} else {
}
}
break;
}

hatti.map.utils.show_hide_points.cljs$core$IFn$_invoke$arity$variadic(map,id_string,cljs.core.array_seq([true], 0));

return om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$show_DASH_heatmap_QMARK_,true);
});
/**
 * Functions that are called after map is loaded in DOM.
 */
hatti.map.utils.map_on_load = (function hatti$map$utils$map_on_load(var_args){
var args__7491__auto__ = [];
var len__7484__auto___17725 = arguments.length;
var i__7485__auto___17726 = (0);
while(true){
if((i__7485__auto___17726 < len__7484__auto___17725)){
args__7491__auto__.push((arguments[i__7485__auto___17726]));

var G__17727 = (i__7485__auto___17726 + (1));
i__7485__auto___17726 = G__17727;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((3) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((3)),(0),null)):null);
return hatti.map.utils.map_on_load.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7492__auto__);
});

hatti.map.utils.map_on_load.cljs$core$IFn$_invoke$arity$variadic = (function (map,event_chan,id_string,p__17718){
var map__17719 = p__17718;
var map__17719__$1 = ((((!((map__17719 == null)))?((((map__17719.cljs$lang$protocol_mask$partition0$ & (64))) || (map__17719.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__17719):map__17719);
var map_data = map__17719__$1;
var geofield = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17719__$1,cljs.core.cst$kw$geofield);
var owner = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17719__$1,cljs.core.cst$kw$owner);
var tiles_url = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17719__$1,cljs.core.cst$kw$tiles_DASH_url);
var geojson = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17719__$1,cljs.core.cst$kw$geojson);
var map__17721 = hatti.map.utils.geotype__GT_marker_style(geofield);
var map__17721__$1 = ((((!((map__17721 == null)))?((((map__17721.cljs$lang$protocol_mask$partition0$ & (64))) || (map__17721.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__17721):map__17721);
var layer_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17721__$1,cljs.core.cst$kw$layer_DASH_type);
var layout = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17721__$1,cljs.core.cst$kw$layout);
var style = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17721__$1,cljs.core.cst$kw$style);
var map__17722 = om.core.get_state.cljs$core$IFn$_invoke$arity$1(owner);
var map__17722__$1 = ((((!((map__17722 == null)))?((((map__17722.cljs$lang$protocol_mask$partition0$ & (64))) || (map__17722.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__17722):map__17722);
var stops = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17722__$1,cljs.core.cst$kw$stops);
var layer_opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17722__$1,cljs.core.cst$kw$layer_DASH_opts);
var show_hexbins_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17722__$1,cljs.core.cst$kw$show_DASH_hexbins_QMARK_);
var show_heatmap_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17722__$1,cljs.core.cst$kw$show_DASH_heatmap_QMARK_);
if(cljs.core.truth_((function (){var or__6409__auto__ = (cljs.core.count(cljs.core.cst$kw$features.cljs$core$IFn$_invoke$arity$1(geojson)) > (0));
if(or__6409__auto__){
return or__6409__auto__;
} else {
return tiles_url;
}
})())){
om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$loaded_QMARK_,false);

hatti.map.utils.add_mapboxgl_source(map,id_string,map_data);

hatti.map.utils.add_mapboxgl_layer.cljs$core$IFn$_invoke$arity$variadic(map,id_string,layer_type,cljs.core.array_seq([cljs.core.cst$kw$layout,layout,cljs.core.cst$kw$tiles_DASH_url,tiles_url], 0));

hatti.map.utils.register_mapboxgl_mouse_events(owner,map,event_chan,id_string,style);

hatti.map.utils.set_mapboxgl_paint_property(map,id_string,hatti.map.utils.get_style_properties.cljs$core$IFn$_invoke$arity$variadic(style,cljs.core.cst$kw$normal,cljs.core.array_seq([cljs.core.cst$kw$stops,stops], 0)));

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$point,style)){
hatti.map.utils.add_mapboxgl_layer.cljs$core$IFn$_invoke$arity$variadic(map,id_string,layer_type,cljs.core.array_seq([cljs.core.cst$kw$layer_DASH_id,hatti.map.utils.circle_border_id,cljs.core.cst$kw$tiles_DASH_url,tiles_url,cljs.core.cst$kw$paint,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$circle_DASH_color,"#fff",cljs.core.cst$kw$circle_DASH_radius,(6)], null)], 0));
} else {
if(cljs.core.truth_(map.getLayer(hatti.map.utils.circle_border_id))){
map.removeLayer(hatti.map.utils.circle_border_id);
} else {
}
}

if(cljs.core.truth_(show_hexbins_QMARK_)){
hatti.map.utils.show_hexbins(owner,map,id_string,geojson,layer_opts);
} else {
}

if(cljs.core.truth_(show_heatmap_QMARK_)){
hatti.map.utils.show_heatmap(owner,map,id_string,geojson,layer_opts);
} else {
}

om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$geojson,geojson);

om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$style,style);

return om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$loaded_QMARK_,true);
} else {
return null;
}
});

hatti.map.utils.map_on_load.cljs$lang$maxFixedArity = (3);

hatti.map.utils.map_on_load.cljs$lang$applyTo = (function (seq17714){
var G__17715 = cljs.core.first(seq17714);
var seq17714__$1 = cljs.core.next(seq17714);
var G__17716 = cljs.core.first(seq17714__$1);
var seq17714__$2 = cljs.core.next(seq17714__$1);
var G__17717 = cljs.core.first(seq17714__$2);
var seq17714__$3 = cljs.core.next(seq17714__$2);
return hatti.map.utils.map_on_load.cljs$core$IFn$_invoke$arity$variadic(G__17715,G__17716,G__17717,seq17714__$3);
});

/**
 * Set default style
 */
hatti.map.utils.clear_map_styles = (function hatti$map$utils$clear_map_styles(owner){
return hatti.map.utils.set_mapboxgl_paint_property(om.core.get_state.cljs$core$IFn$_invoke$arity$2(owner,cljs.core.cst$kw$mapboxgl_DASH_map),om.core.get_state.cljs$core$IFn$_invoke$arity$2(owner,cljs.core.cst$kw$layer_DASH_id),hatti.map.utils.get_style_properties(om.core.get_state.cljs$core$IFn$_invoke$arity$2(owner,cljs.core.cst$kw$style),cljs.core.cst$kw$normal));
});
/**
 * Update map zoom level in local component state on zoom event.
 */
hatti.map.utils.set_zoom_level = (function hatti$map$utils$set_zoom_level(owner){
var map__17730 = om.core.get_state.cljs$core$IFn$_invoke$arity$1(owner);
var map__17730__$1 = ((((!((map__17730 == null)))?((((map__17730.cljs$lang$protocol_mask$partition0$ & (64))) || (map__17730.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__17730):map__17730);
var mapboxgl_map = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17730__$1,cljs.core.cst$kw$mapboxgl_DASH_map);
var zoom = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17730__$1,cljs.core.cst$kw$zoom);
var next_zoom = mapboxgl_map.getZoom();
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(zoom,next_zoom)){
return om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$zoom,next_zoom);
} else {
return null;
}
});
