// Compiled by ClojureScript 1.9.229 {:static-fns true, :optimize-constants true}
goog.provide('hatti.ona.forms');
goog.require('cljs.core');
goog.require('chimera.js_interop');
goog.require('chimera.urls');
goog.require('chimera.date');
goog.require('cljs.pprint');
goog.require('clojure.string');
goog.require('hatti.constants');
hatti.ona.forms.currency_regex = /£|$/;
hatti.ona.forms.newline_regex = /[\n\r]/;
hatti.ona.forms.no_answer = "No Answer";
hatti.ona.forms.submission_time_field = new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$name,hatti.constants._submission_time,cljs.core.cst$kw$full_DASH_name,hatti.constants._submission_time,cljs.core.cst$kw$label,"Submission Time",cljs.core.cst$kw$type,"dateTime"], null);
hatti.ona.forms.submitted_by_field = new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$name,hatti.constants._submitted_by,cljs.core.cst$kw$full_DASH_name,hatti.constants._submitted_by,cljs.core.cst$kw$label,"Submitted by",cljs.core.cst$kw$type,"text"], null);
hatti.ona.forms.last_edited = new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$name,hatti.constants._last_edited,cljs.core.cst$kw$full_DASH_name,hatti.constants._last_edited,cljs.core.cst$kw$label,"Last Edited",cljs.core.cst$kw$type,"date"], null);
hatti.ona.forms.extra_submission_details = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [hatti.ona.forms.last_edited,hatti.ona.forms.submission_time_field,hatti.ona.forms.submitted_by_field], null);
/**
 * Format multiline answer by introducing html line breaks
 */
hatti.ona.forms.format_multiline_answer = (function hatti$ona$forms$format_multiline_answer(answer){
if(cljs.core.truth_((function (){var and__6397__auto__ = typeof answer === 'string';
if(and__6397__auto__){
return cljs.core.re_find(hatti.ona.forms.newline_regex,answer);
} else {
return and__6397__auto__;
}
})())){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__14788_SHARP_){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$p,p1__14788_SHARP_],null));
}),clojure.string.split.cljs$core$IFn$_invoke$arity$2(answer,hatti.ona.forms.newline_regex));
} else {
return answer;
}
});
/**
 * Helper function: is the :type of a field among a set of types
 */
hatti.ona.forms.field_type_in_set_QMARK_ = (function hatti$ona$forms$field_type_in_set_QMARK_(types,field){
return cljs.core.contains_QMARK_(types,cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(field));
});
/**
 * Helper function: is the :name of a field among a set of names
 */
hatti.ona.forms.field_name_in_set_QMARK_ = (function hatti$ona$forms$field_name_in_set_QMARK_(names,field){
return cljs.core.contains_QMARK_(names,cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(field));
});
/**
 * Checks whether a field in a form (ie, a field) is a group field
 */
hatti.ona.forms.group_QMARK_ = (function hatti$ona$forms$group_QMARK_(field){
return hatti.ona.forms.field_type_in_set_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["group",null], null), null),field);
});
/**
 * Checks whether a field in a form (ie, a field) is a repeat field
 */
hatti.ona.forms.repeat_QMARK_ = (function hatti$ona$forms$repeat_QMARK_(field){
return hatti.ona.forms.field_type_in_set_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["repeat",null], null), null),field);
});
/**
 * Checks whether a field is a numeric field
 */
hatti.ona.forms.numeric_QMARK_ = (function hatti$ona$forms$numeric_QMARK_(field){
return hatti.ona.forms.field_type_in_set_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["integer",null,"decimal",null], null), null),field);
});
/**
 * Checks whether a field is a date or a time field
 */
hatti.ona.forms.time_based_QMARK_ = (function hatti$ona$forms$time_based_QMARK_(field){
return hatti.ona.forms.field_type_in_set_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, ["today",null,"dateTime",null,"start",null,"time",null,"date",null,"end",null], null), null),field);
});
/**
 * Checks whether a field is a category field (select one or multiple)
 */
hatti.ona.forms.categorical_QMARK_ = (function hatti$ona$forms$categorical_QMARK_(field){
return hatti.ona.forms.field_type_in_set_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["select all that apply",null,"select one",null], null), null),field);
});
/**
 * Checks whether a field is a select one field
 */
hatti.ona.forms.select_one_QMARK_ = (function hatti$ona$forms$select_one_QMARK_(field){
return hatti.ona.forms.field_type_in_set_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["select one",null], null), null),field);
});
/**
 * Checks whether a field is a select multiple (select all that apply) field
 */
hatti.ona.forms.select_all_QMARK_ = (function hatti$ona$forms$select_all_QMARK_(field){
return hatti.ona.forms.field_type_in_set_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["select all that apply",null], null), null),field);
});
/**
 * Checks whether a field is a text / string field.
 */
hatti.ona.forms.text_QMARK_ = (function hatti$ona$forms$text_QMARK_(field){
return hatti.ona.forms.field_type_in_set_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["string",null,"text",null], null), null),field);
});
/**
 * Checks whether a field in a form (a field) is a group field
 */
hatti.ona.forms.note_QMARK_ = (function hatti$ona$forms$note_QMARK_(field){
return hatti.ona.forms.field_type_in_set_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["note",null], null), null),field);
});
hatti.ona.forms.meta_QMARK_ = (function hatti$ona$forms$meta_QMARK_(field){
var or__6409__auto__ = hatti.ona.forms.field_name_in_set_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 5, ["instanceID",null,"_duration",null,"meta",null,"__version__",null,"_submitted_by",null], null), null),field);
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return hatti.ona.forms.field_type_in_set_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 10, ["subscriberid",null,"phonenumber",null,"instanceID",null,"today",null,"deviceid",null,"uuid",null,"start",null,"imei",null,"simserial",null,"end",null], null), null),field);
}
});
hatti.ona.forms.geofield_QMARK_ = (function hatti$ona$forms$geofield_QMARK_(field){
var or__6409__auto__ = hatti.ona.forms.field_type_in_set_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 5, ["geoshape",null,"geotrace",null,"geopoint",null,"osm",null,"gps",null], null), null),field);
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
if(cljs.core.truth_(hatti.ona.forms.repeat_QMARK_(field))){
var map__14791 = field;
var map__14791__$1 = ((((!((map__14791 == null)))?((((map__14791.cljs$lang$protocol_mask$partition0$ & (64))) || (map__14791.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__14791):map__14791);
var children = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14791__$1,cljs.core.cst$kw$children);
return cljs.core.some(hatti$ona$forms$geofield_QMARK_,children);
} else {
return null;
}
}
});
hatti.ona.forms.geopoint_QMARK_ = (function hatti$ona$forms$geopoint_QMARK_(field){
var or__6409__auto__ = hatti.ona.forms.field_type_in_set_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["geopoint",null,"gps",null], null), null),field);
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
if(cljs.core.truth_(hatti.ona.forms.repeat_QMARK_(field))){
var map__14795 = field;
var map__14795__$1 = ((((!((map__14795 == null)))?((((map__14795.cljs$lang$protocol_mask$partition0$ & (64))) || (map__14795.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__14795):map__14795);
var children = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14795__$1,cljs.core.cst$kw$children);
return cljs.core.some(hatti$ona$forms$geopoint_QMARK_,children);
} else {
return null;
}
}
});
hatti.ona.forms.geoshape_QMARK_ = (function hatti$ona$forms$geoshape_QMARK_(field){
return hatti.ona.forms.field_type_in_set_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["geoshape",null], null), null),field);
});
hatti.ona.forms.geotrace_QMARK_ = (function hatti$ona$forms$geotrace_QMARK_(field){
return hatti.ona.forms.field_type_in_set_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["geotrace",null], null), null),field);
});
hatti.ona.forms.image_QMARK_ = (function hatti$ona$forms$image_QMARK_(field){
return hatti.ona.forms.field_type_in_set_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["image",null,"photo",null], null), null),field);
});
hatti.ona.forms.video_QMARK_ = (function hatti$ona$forms$video_QMARK_(field){
return hatti.ona.forms.field_type_in_set_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["video",null], null), null),field);
});
hatti.ona.forms.osm_QMARK_ = (function hatti$ona$forms$osm_QMARK_(field){
return hatti.ona.forms.field_type_in_set_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["osm",null], null), null),field);
});
/**
 * Checks whether a field is a calculate field
 */
hatti.ona.forms.calculate_QMARK_ = (function hatti$ona$forms$calculate_QMARK_(field){
return hatti.ona.forms.field_type_in_set_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["calculate",null], null), null),field);
});
/**
 * Returns false for fields such as note, group, etc. which don't have data
 */
hatti.ona.forms.has_data_QMARK_ = (function hatti$ona$forms$has_data_QMARK_(field){
return cljs.core.not((function (){var or__6409__auto__ = hatti.ona.forms.note_QMARK_(field);
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return hatti.ona.forms.group_QMARK_(field);
}
})());
});
/**
 * Get the icon relevant to the given field (depending on its type).
 */
hatti.ona.forms.get_icon = (function hatti$ona$forms$get_icon(field){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$i,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,(cljs.core.truth_(hatti.ona.forms.text_QMARK_(field))?"fa fa-font":(cljs.core.truth_(hatti.ona.forms.time_based_QMARK_(field))?"fa fa-clock-o":(cljs.core.truth_(hatti.ona.forms.numeric_QMARK_(field))?"fa fa-bar-chart":(cljs.core.truth_(hatti.ona.forms.calculate_QMARK_(field))?"fa fa-bar-chart":(cljs.core.truth_(hatti.ona.forms.categorical_QMARK_(field))?"fa fa-bar-chart fa-flip-h-rotate-90":""
)))))], null)], null);
});
/**
 * Assign class according to field type category, e.g. integer & decimals are
 * both in the numeric category
 */
hatti.ona.forms.get_column_class = (function hatti$ona$forms$get_column_class(field){
if(cljs.core.truth_(hatti.ona.forms.text_QMARK_(field))){
return "column-string";
} else {
if(cljs.core.truth_(hatti.ona.forms.numeric_QMARK_(field))){
return "column-numeric";
} else {
if(cljs.core.truth_(hatti.ona.forms.time_based_QMARK_(field))){
return "column-datetime";
} else {
if(cljs.core.truth_(hatti.ona.forms.categorical_QMARK_(field))){
return "column-categorical";
} else {
if(cljs.core.truth_(hatti.ona.forms.geofield_QMARK_(field))){
return "column-geofield";
} else {
if(cljs.core.truth_(hatti.ona.forms.image_QMARK_(field))){
return "column-image";
} else {
if(cljs.core.truth_(hatti.ona.forms.video_QMARK_(field))){
return "column-video";
} else {
if(cljs.core.truth_(hatti.ona.forms.meta_QMARK_(field))){
return "column-metadata";
} else {
return "";

}
}
}
}
}
}
}
}
});
/**
 * Gets the label object out of a map with key :label (eg. a field).
 * If multiple languages, and none specified, picks out alphabetically first.
 */
hatti.ona.forms.get_label = (function hatti$ona$forms$get_label(var_args){
var args__7491__auto__ = [];
var len__7484__auto___14807 = arguments.length;
var i__7485__auto___14808 = (0);
while(true){
if((i__7485__auto___14808 < len__7484__auto___14807)){
args__7491__auto__.push((arguments[i__7485__auto___14808]));

var G__14809 = (i__7485__auto___14808 + (1));
i__7485__auto___14808 = G__14809;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return hatti.ona.forms.get_label.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

hatti.ona.forms.get_label.cljs$core$IFn$_invoke$arity$variadic = (function (p__14799,p__14800){
var map__14801 = p__14799;
var map__14801__$1 = ((((!((map__14801 == null)))?((((map__14801.cljs$lang$protocol_mask$partition0$ & (64))) || (map__14801.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__14801):map__14801);
var label = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14801__$1,cljs.core.cst$kw$label);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14801__$1,cljs.core.cst$kw$name);
var vec__14802 = p__14800;
var language = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14802,(0),null);
if(!(cljs.core.map_QMARK_(label))){
var or__6409__auto__ = label;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return name;
}
} else {
if(cljs.core.contains_QMARK_(cljs.core.set(cljs.core.keys(label)),language)){
return (label.cljs$core$IFn$_invoke$arity$1 ? label.cljs$core$IFn$_invoke$arity$1(language) : label.call(null,language));
} else {
var G__14806 = cljs.core.first(cljs.core.sort.cljs$core$IFn$_invoke$arity$1(cljs.core.keys(label)));
return (label.cljs$core$IFn$_invoke$arity$1 ? label.cljs$core$IFn$_invoke$arity$1(G__14806) : label.call(null,G__14806));
}
}
});

hatti.ona.forms.get_label.cljs$lang$maxFixedArity = (1);

hatti.ona.forms.get_label.cljs$lang$applyTo = (function (seq14797){
var G__14798 = cljs.core.first(seq14797);
var seq14797__$1 = cljs.core.next(seq14797);
return hatti.ona.forms.get_label.cljs$core$IFn$_invoke$arity$variadic(G__14798,seq14797__$1);
});

/**
 * String representation for a particular field datapoint (answer).
 * re-formatting depends on field type, eg. name->label substitution.
 * Optional: compact? should be true if a short string needs to be returned.
 */
hatti.ona.forms.format_answer = (function hatti$ona$forms$format_answer(var_args){
var args__7491__auto__ = [];
var len__7484__auto___14827 = arguments.length;
var i__7485__auto___14828 = (0);
while(true){
if((i__7485__auto___14828 < len__7484__auto___14827)){
args__7491__auto__.push((arguments[i__7485__auto___14828]));

var G__14829 = (i__7485__auto___14828 + (1));
i__7485__auto___14828 = G__14829;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((2) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((2)),(0),null)):null);
return hatti.ona.forms.format_answer.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7492__auto__);
});

hatti.ona.forms.format_answer.cljs$core$IFn$_invoke$arity$variadic = (function (field,answer,p__14817){
var map__14818 = p__14817;
var map__14818__$1 = ((((!((map__14818 == null)))?((((map__14818.cljs$lang$protocol_mask$partition0$ & (64))) || (map__14818.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__14818):map__14818);
var language = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14818__$1,cljs.core.cst$kw$language);
var compact_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14818__$1,cljs.core.cst$kw$compact_QMARK_);
var label = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14818__$1,cljs.core.cst$kw$label);
var field_key = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__14818__$1,cljs.core.cst$kw$field_DASH_key,cljs.core.cst$kw$name);
if(clojure.string.blank_QMARK_(answer)){
return hatti.ona.forms.no_answer;
} else {
if(cljs.core.truth_(hatti.ona.forms.select_one_QMARK_(field))){
var option = cljs.core.first(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (map__14818,map__14818__$1,language,compact_QMARK_,label,field_key){
return (function (p1__14810_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(answer,(field_key.cljs$core$IFn$_invoke$arity$1 ? field_key.cljs$core$IFn$_invoke$arity$1(p1__14810_SHARP_) : field_key.call(null,p1__14810_SHARP_)));
});})(map__14818,map__14818__$1,language,compact_QMARK_,label,field_key))
,cljs.core.cst$kw$children.cljs$core$IFn$_invoke$arity$1(field)));
var formatted = hatti.ona.forms.get_label.cljs$core$IFn$_invoke$arity$variadic(option,cljs.core.array_seq([language], 0));
var or__6409__auto__ = formatted;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return answer;
}
} else {
if(cljs.core.truth_(hatti.ona.forms.select_all_QMARK_(field))){
var names = cljs.core.set(clojure.string.split.cljs$core$IFn$_invoke$arity$2(answer,/ /));
var appearance_value = cljs.core.cst$kw$appearance.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$control.cljs$core$IFn$_invoke$arity$1(field));
var uses_search_expression_QMARK_ = (function (){var and__6397__auto__ = typeof appearance_value === 'string';
if(and__6397__auto__){
return cljs.core.re_matches(/^search\(.*\)$/,appearance_value);
} else {
return and__6397__auto__;
}
})();
var multiple_select_values = (cljs.core.truth_(uses_search_expression_QMARK_)?cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (names,appearance_value,uses_search_expression_QMARK_,map__14818,map__14818__$1,language,compact_QMARK_,label,field_key){
return (function (p1__14811_SHARP_){
return cljs.core.identity(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$name,p1__14811_SHARP_], null));
});})(names,appearance_value,uses_search_expression_QMARK_,map__14818,map__14818__$1,language,compact_QMARK_,label,field_key))
,names):cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (names,appearance_value,uses_search_expression_QMARK_,map__14818,map__14818__$1,language,compact_QMARK_,label,field_key){
return (function (p1__14812_SHARP_){
return cljs.core.contains_QMARK_(names,(field_key.cljs$core$IFn$_invoke$arity$1 ? field_key.cljs$core$IFn$_invoke$arity$1(p1__14812_SHARP_) : field_key.call(null,p1__14812_SHARP_)));
});})(names,appearance_value,uses_search_expression_QMARK_,map__14818,map__14818__$1,language,compact_QMARK_,label,field_key))
,cljs.core.cst$kw$children.cljs$core$IFn$_invoke$arity$1(field)));
return clojure.string.join.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (names,appearance_value,uses_search_expression_QMARK_,multiple_select_values,map__14818,map__14818__$1,language,compact_QMARK_,label,field_key){
return (function (p1__14813_SHARP_){
return [cljs.core.str("\u2611 "),cljs.core.str(hatti.ona.forms.get_label.cljs$core$IFn$_invoke$arity$variadic(p1__14813_SHARP_,cljs.core.array_seq([language], 0))),cljs.core.str(" ")].join('');
});})(names,appearance_value,uses_search_expression_QMARK_,multiple_select_values,map__14818,map__14818__$1,language,compact_QMARK_,label,field_key))
,multiple_select_values));
} else {
if(cljs.core.truth_(hatti.ona.forms.time_based_QMARK_(field))){
return chimera.date.format_date(answer);
} else {
if(cljs.core.truth_((function (){var or__6409__auto__ = hatti.ona.forms.image_QMARK_(field);
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return hatti.ona.forms.video_QMARK_(field);
}
})())){
var image = cljs.core.cst$kw$download_url.cljs$core$IFn$_invoke$arity$1(answer);
var thumb = (function (){var or__6409__auto__ = cljs.core.cst$kw$small_download_url.cljs$core$IFn$_invoke$arity$1(answer);
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return image;
}
})();
var fname = chimera.urls.last_url_param(cljs.core.cst$kw$filename.cljs$core$IFn$_invoke$arity$1(answer));
if(typeof answer === 'string'){
return answer;
} else {
if(cljs.core.truth_(compact_QMARK_)){
return chimera.js_interop.format.cljs$core$IFn$_invoke$arity$variadic("<a href='%s' target='_blank'>\n                                      <i class='fa fa-external-link'></i>\n                                      %s </a>",cljs.core.array_seq([image,fname], 0));
} else {
if((thumb == null)){
return answer;
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$href,image,cljs.core.cst$kw$target,"_blank"], null),(cljs.core.truth_(hatti.ona.forms.image_QMARK_(field))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$img,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$width,"80px",cljs.core.cst$kw$src,thumb], null)], null):new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$i$fa$fa_DASH_file_DASH_video_DASH_o], null)," ",fname], null))], null);

}
}
}
} else {
if(cljs.core.truth_(hatti.ona.forms.osm_QMARK_(field))){
var kw__GT_name = cljs.core.name;
var map__14820 = answer;
var map__14820__$1 = ((((!((map__14820 == null)))?((((map__14820.cljs$lang$protocol_mask$partition0$ & (64))) || (map__14820.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__14820):map__14820);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14820__$1,cljs.core.cst$kw$name);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14820__$1,cljs.core.cst$kw$type);
var osm_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14820__$1,cljs.core.cst$kw$osm_DASH_id);
var type_cap = (cljs.core.truth_(type)?clojure.string.capitalize(type):null);
var title = [cljs.core.str("OSM "),cljs.core.str(type_cap),cljs.core.str(": "),cljs.core.str(name),cljs.core.str(" ("),cljs.core.str(osm_id),cljs.core.str(")")].join('');
if(cljs.core.truth_(compact_QMARK_)){
return title;
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$table$osm_DASH_data,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$thead,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$th,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$col_DASH_span,(2)], null),title], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$tbody,cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (kw__GT_name,map__14820,map__14820__$1,name,type,osm_id,type_cap,title,map__14818,map__14818__$1,language,compact_QMARK_,label,field_key){
return (function (p__14822){
var vec__14823 = p__14822;
var tk = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14823,(0),null);
var tv = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14823,(1),null);
if(clojure.string.blank_QMARK_(tv)){
return null;
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$tr,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$td$question,(kw__GT_name.cljs$core$IFn$_invoke$arity$1 ? kw__GT_name.cljs$core$IFn$_invoke$arity$1(tk) : kw__GT_name.call(null,tk))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$td$answer,tv], null)], null);
}
});})(kw__GT_name,map__14820,map__14820__$1,name,type,osm_id,type_cap,title,map__14818,map__14818__$1,language,compact_QMARK_,label,field_key))
,cljs.core.cst$kw$tags.cljs$core$IFn$_invoke$arity$1(answer))], null)], null);
}
} else {
if(cljs.core.truth_(hatti.ona.forms.repeat_QMARK_(field))){
if(cljs.core.empty_QMARK_(answer)){
return hatti.ona.forms.no_answer;
} else {
return [cljs.core.str("Repeated data with "),cljs.core.str(cljs.core.count(answer)),cljs.core.str(" answers.")].join('');
}
} else {
if(cljs.core.truth_(hatti.ona.forms.numeric_QMARK_(field))){
var temp__4655__auto__ = (function (){var G__14826 = label;
if((G__14826 == null)){
return null;
} else {
return cljs.core.re_find(hatti.ona.forms.currency_regex,G__14826);
}
})();
if(cljs.core.truth_(temp__4655__auto__)){
var currency = temp__4655__auto__;
return [cljs.core.str(currency),cljs.core.str(cljs.pprint.cl_format.cljs$core$IFn$_invoke$arity$variadic(null,"~:d",cljs.core.array_seq([answer], 0)))].join('');
} else {
return answer;
}
} else {
return hatti.ona.forms.format_multiline_answer(answer);
}

}
}
}
}
}
}
}
});

hatti.ona.forms.format_answer.cljs$lang$maxFixedArity = (2);

hatti.ona.forms.format_answer.cljs$lang$applyTo = (function (seq14814){
var G__14815 = cljs.core.first(seq14814);
var seq14814__$1 = cljs.core.next(seq14814);
var G__14816 = cljs.core.first(seq14814__$1);
var seq14814__$2 = cljs.core.next(seq14814__$1);
return hatti.ona.forms.format_answer.cljs$core$IFn$_invoke$arity$variadic(G__14815,G__14816,seq14814__$2);
});

/**
 * Try and produce a label for meta field if non-existent.
 */
hatti.ona.forms.relabel_meta_field = (function hatti$ona$forms$relabel_meta_field(p__14830){
var map__14836 = p__14830;
var map__14836__$1 = ((((!((map__14836 == null)))?((((map__14836.cljs$lang$protocol_mask$partition0$ & (64))) || (map__14836.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__14836):map__14836);
var field = map__14836__$1;
var label = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14836__$1,cljs.core.cst$kw$label);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14836__$1,cljs.core.cst$kw$name);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14836__$1,cljs.core.cst$kw$type);
var label__$1 = (cljs.core.truth_(type)?(function (){var G__14838 = type;
switch (G__14838) {
case "start":
return "Start time";

break;
case "end":
return "End time";

break;
case "today":
return "Day of survey";

break;
case "deviceid":
return "Device ID (IMEI)";

break;
case "imei":
return "IMEI";

break;
case "subscriberid":
return "IMSI";

break;
case "simserial":
return "SIM serial number";

break;
case "uuid":
return "UUID";

break;
case "instanceID":
return "Instance ID";

break;
case "phonenumber":
return "Phone number";

break;
default:
return name;

}
})():(function (){var G__14839 = name;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$sym$_submission_time,G__14839)){
return "Submission time";
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$sym$_submitted_by,G__14839)){
return "Submitted by";
} else {
return "";

}
}
})());
var G__14840 = field;
if(cljs.core.not(label__$1)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__14840,cljs.core.cst$kw$label,label__$1);
} else {
return G__14840;
}
});
hatti.ona.forms.name_label_map = (function hatti$ona$forms$name_label_map(p__14843,prefix,acc,flatten_repeats_QMARK_){
var map__14850 = p__14843;
var map__14850__$1 = ((((!((map__14850 == null)))?((((map__14850.cljs$lang$protocol_mask$partition0$ & (64))) || (map__14850.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__14850):map__14850);
var child = map__14850__$1;
var children = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14850__$1,cljs.core.cst$kw$children);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14850__$1,cljs.core.cst$kw$name);
var label = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14850__$1,cljs.core.cst$kw$label);
var full_name = (cljs.core.truth_(prefix)?[cljs.core.str(prefix),cljs.core.str("/"),cljs.core.str(name)].join(''):name);
var langs = ((cljs.core.map_QMARK_(label))?cljs.core.keys(label):null);
var updated_child = cljs.core.with_meta(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(child,cljs.core.cst$kw$full_DASH_name,full_name),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$langs,langs], null));
var childless_child = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(updated_child,cljs.core.cst$kw$children);
var make_new_children = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (full_name,langs,updated_child,childless_child,map__14850,map__14850__$1,child,children,name,label){
return (function (p1__14842_SHARP_){
return hatti$ona$forms$name_label_map(p1__14842_SHARP_,full_name,cljs.core.PersistentVector.EMPTY,flatten_repeats_QMARK_);
});})(full_name,langs,updated_child,childless_child,map__14850,map__14850__$1,child,children,name,label))
,children);
if(cljs.core.truth_((function (){var or__6409__auto__ = hatti.ona.forms.group_QMARK_(updated_child);
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
var and__6397__auto__ = flatten_repeats_QMARK_;
if(cljs.core.truth_(and__6397__auto__)){
return hatti.ona.forms.repeat_QMARK_(updated_child);
} else {
return and__6397__auto__;
}
}
})())){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,childless_child),make_new_children);
} else {
if(cljs.core.truth_(hatti.ona.forms.repeat_QMARK_(updated_child))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(updated_child,cljs.core.cst$kw$children,cljs.core.flatten(cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,make_new_children))));
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,updated_child);

}
}
});
/**
 * Input: map derived from form.json. Output: a flattened vector;
 * each element is a field; a field is a {:name .. :label .. :type ..} map.
 * By default, REPEAT BLOCKS ARE NOT FLATTENED, repeat blocks represent
 * subforms, which need special handling in most cases.
 * :flatten-repeats? overrides default behavior, also flattens repeats.
 */
hatti.ona.forms.flatten_form = (function hatti$ona$forms$flatten_form(var_args){
var args__7491__auto__ = [];
var len__7484__auto___14862 = arguments.length;
var i__7485__auto___14863 = (0);
while(true){
if((i__7485__auto___14863 < len__7484__auto___14862)){
args__7491__auto__.push((arguments[i__7485__auto___14863]));

var G__14864 = (i__7485__auto___14863 + (1));
i__7485__auto___14863 = G__14864;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return hatti.ona.forms.flatten_form.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

hatti.ona.forms.flatten_form.cljs$core$IFn$_invoke$arity$variadic = (function (p__14856,p__14857){
var map__14858 = p__14856;
var map__14858__$1 = ((((!((map__14858 == null)))?((((map__14858.cljs$lang$protocol_mask$partition0$ & (64))) || (map__14858.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__14858):map__14858);
var form = map__14858__$1;
var children = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14858__$1,cljs.core.cst$kw$children);
var map__14859 = p__14857;
var map__14859__$1 = ((((!((map__14859 == null)))?((((map__14859.cljs$lang$protocol_mask$partition0$ & (64))) || (map__14859.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__14859):map__14859);
var flatten_repeats_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14859__$1,cljs.core.cst$kw$flatten_DASH_repeats_QMARK_);
var nodes = cljs.core.flatten(cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (map__14858,map__14858__$1,form,children,map__14859,map__14859__$1,flatten_repeats_QMARK_){
return (function (p1__14852_SHARP_){
return hatti.ona.forms.name_label_map(p1__14852_SHARP_,null,cljs.core.PersistentVector.EMPTY,flatten_repeats_QMARK_);
});})(map__14858,map__14858__$1,form,children,map__14859,map__14859__$1,flatten_repeats_QMARK_))
,children));
var langs = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(cljs.core.flatten(cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (nodes,map__14858,map__14858__$1,form,children,map__14859,map__14859__$1,flatten_repeats_QMARK_){
return (function (p1__14853_SHARP_){
return cljs.core.cst$kw$langs.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(p1__14853_SHARP_));
});})(nodes,map__14858,map__14858__$1,form,children,map__14859,map__14859__$1,flatten_repeats_QMARK_))
,nodes)));
return cljs.core.with_meta(nodes,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$languages,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,langs)], null));
});

hatti.ona.forms.flatten_form.cljs$lang$maxFixedArity = (1);

hatti.ona.forms.flatten_form.cljs$lang$applyTo = (function (seq14854){
var G__14855 = cljs.core.first(seq14854);
var seq14854__$1 = cljs.core.next(seq14854);
return hatti.ona.forms.flatten_form.cljs$core$IFn$_invoke$arity$variadic(G__14855,seq14854__$1);
});

/**
 * Get just the meta fields out of the form.
 * Options to re-label meta fields, or include submission time in meta list.
 */
hatti.ona.forms.meta_fields = (function hatti$ona$forms$meta_fields(var_args){
var args__7491__auto__ = [];
var len__7484__auto___14872 = arguments.length;
var i__7485__auto___14873 = (0);
while(true){
if((i__7485__auto___14873 < len__7484__auto___14872)){
args__7491__auto__.push((arguments[i__7485__auto___14873]));

var G__14874 = (i__7485__auto___14873 + (1));
i__7485__auto___14873 = G__14874;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return hatti.ona.forms.meta_fields.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

hatti.ona.forms.meta_fields.cljs$core$IFn$_invoke$arity$variadic = (function (flat_form,p__14868){
var map__14869 = p__14868;
var map__14869__$1 = ((((!((map__14869 == null)))?((((map__14869.cljs$lang$protocol_mask$partition0$ & (64))) || (map__14869.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__14869):map__14869);
var relabel_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__14869__$1,cljs.core.cst$kw$relabel_QMARK_,true);
var with_submission_details_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14869__$1,cljs.core.cst$kw$with_DASH_submission_DASH_details_QMARK_);
var meta_fields = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.meta_QMARK_,flat_form);
var include_extra_sub_details = (cljs.core.truth_(with_submission_details_QMARK_)?((function (meta_fields,map__14869,map__14869__$1,relabel_QMARK_,with_submission_details_QMARK_){
return (function (p1__14865_SHARP_){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.vec(p1__14865_SHARP_),hatti.ona.forms.extra_submission_details);
});})(meta_fields,map__14869,map__14869__$1,relabel_QMARK_,with_submission_details_QMARK_))
:cljs.core.identity);
var relabel = (cljs.core.truth_(relabel_QMARK_)?hatti.ona.forms.relabel_meta_field:cljs.core.identity);
var G__14871 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(relabel,meta_fields);
return (include_extra_sub_details.cljs$core$IFn$_invoke$arity$1 ? include_extra_sub_details.cljs$core$IFn$_invoke$arity$1(G__14871) : include_extra_sub_details.call(null,G__14871));
});

hatti.ona.forms.meta_fields.cljs$lang$maxFixedArity = (1);

hatti.ona.forms.meta_fields.cljs$lang$applyTo = (function (seq14866){
var G__14867 = cljs.core.first(seq14866);
var seq14866__$1 = cljs.core.next(seq14866);
return hatti.ona.forms.meta_fields.cljs$core$IFn$_invoke$arity$variadic(G__14867,seq14866__$1);
});

/**
 * Get just the fields in this form that are not meta fields.
 */
hatti.ona.forms.non_meta_fields = (function hatti$ona$forms$non_meta_fields(flat_form){
return cljs.core.remove.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.meta_QMARK_,flat_form);
});
/**
 * Get just the geofields from the form.
 */
hatti.ona.forms.geofields = (function hatti$ona$forms$geofields(flat_form){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.geofield_QMARK_,flat_form);
});
/**
 * From a list of geofields, get the default one to map.
 * Implementation: pick first geoshape if any, else pick first geofield.
 */
hatti.ona.forms.default_geofield = (function hatti$ona$forms$default_geofield(flat_form){
var repeats = cljs.core.flatten(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.repeat_QMARK_,flat_form));
var geofields = hatti.ona.forms.geofields(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(flat_form,repeats));
var geoshapes = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.geoshape_QMARK_,geofields);
var geopoints = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.geopoint_QMARK_,geofields);
if(cljs.core.seq(geoshapes)){
return cljs.core.first(geoshapes);
} else {
if(cljs.core.seq(geopoints)){
return cljs.core.first(geopoints);
} else {
return cljs.core.first(geofields);

}
}
});
hatti.ona.forms.english_QMARK_ = (function hatti$ona$forms$english_QMARK_(language){
return cljs.core.re_find(/english/i,[cljs.core.str(language)].join(''));
});
/**
 * Get the languages for a given form.
 */
hatti.ona.forms.get_languages = (function hatti$ona$forms$get_languages(form){
return cljs.core.cst$kw$languages.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(form));
});
/**
 * Does this form contain labels in multiple languages?
 */
hatti.ona.forms.multilingual_QMARK_ = (function hatti$ona$forms$multilingual_QMARK_(form){
return cljs.core.seq(hatti.ona.forms.get_languages(form));
});
/**
 * Get default language (English or alphabetical first) from within a list.
 */
hatti.ona.forms.default_lang = (function hatti$ona$forms$default_lang(languages){
var temp__4655__auto__ = cljs.core.first(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.english_QMARK_,languages));
if(cljs.core.truth_(temp__4655__auto__)){
var eng = temp__4655__auto__;
return eng;
} else {
return cljs.core.first(cljs.core.sort.cljs$core$IFn$_invoke$arity$1(languages));
}
});
