// Compiled by ClojureScript 1.9.229 {:static-fns true, :optimize-constants true}
goog.provide('hatti.ona.post_process');
goog.require('cljs.core');
goog.require('chimera.js_interop');
goog.require('chimera.om.state');
goog.require('hatti.ona.forms');
goog.require('hatti.ona.urls');
goog.require('chimera.seq');
goog.require('hatti.constants');
goog.require('chimera.urls');
goog.require('clojure.string');
/**
 * Given some data in Ona format, builds a data structure that we will use
 * to link osm data to Ona data.
 */
hatti.ona.post_process.ona_osm_link = (function hatti$ona$post_process$ona_osm_link(data,form){
var osmfields = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.osm_QMARK_,form);
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,cljs.core.flatten((function (){var iter__7189__auto__ = ((function (osmfields){
return (function hatti$ona$post_process$ona_osm_link_$_iter__19697(s__19698){
return (new cljs.core.LazySeq(null,((function (osmfields){
return (function (){
var s__19698__$1 = s__19698;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__19698__$1);
if(temp__4657__auto__){
var s__19698__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__19698__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__19698__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__19700 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__19699 = (0);
while(true){
if((i__19699 < size__7188__auto__)){
var datum = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__19699);
cljs.core.chunk_append(b__19700,(function (){var iter__7189__auto__ = ((function (i__19699,datum,c__7187__auto__,size__7188__auto__,b__19700,s__19698__$2,temp__4657__auto__,osmfields){
return (function hatti$ona$post_process$ona_osm_link_$_iter__19697_$_iter__19715(s__19716){
return (new cljs.core.LazySeq(null,((function (i__19699,datum,c__7187__auto__,size__7188__auto__,b__19700,s__19698__$2,temp__4657__auto__,osmfields){
return (function (){
var s__19716__$1 = s__19716;
while(true){
var temp__4657__auto____$1 = cljs.core.seq(s__19716__$1);
if(temp__4657__auto____$1){
var s__19716__$2 = temp__4657__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__19716__$2)){
var c__7187__auto____$1 = cljs.core.chunk_first(s__19716__$2);
var size__7188__auto____$1 = cljs.core.count(c__7187__auto____$1);
var b__19718 = cljs.core.chunk_buffer(size__7188__auto____$1);
if((function (){var i__19717 = (0);
while(true){
if((i__19717 < size__7188__auto____$1)){
var field = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto____$1,i__19717);
cljs.core.chunk_append(b__19718,(function (){var osmkey = cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(field);
var osmdatum = cljs.core.get.cljs$core$IFn$_invoke$arity$2(datum,osmkey);
var osmid = (function (){var and__6397__auto__ = osmdatum;
if(cljs.core.truth_(and__6397__auto__)){
return cljs.core.re_find(/[0-9]+/,osmdatum);
} else {
return and__6397__auto__;
}
})();
if(cljs.core.truth_(osmid)){
return cljs.core.PersistentArrayMap.fromArray([osmid,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$field,field], null),cljs.core.select_keys(datum,cljs.core.PersistentHashSet.fromArray([hatti.constants._rank,hatti.constants._id], true))], 0))], true, false);
} else {
return null;
}
})());

var G__19727 = (i__19717 + (1));
i__19717 = G__19727;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__19718),hatti$ona$post_process$ona_osm_link_$_iter__19697_$_iter__19715(cljs.core.chunk_rest(s__19716__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__19718),null);
}
} else {
var field = cljs.core.first(s__19716__$2);
return cljs.core.cons((function (){var osmkey = cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(field);
var osmdatum = cljs.core.get.cljs$core$IFn$_invoke$arity$2(datum,osmkey);
var osmid = (function (){var and__6397__auto__ = osmdatum;
if(cljs.core.truth_(and__6397__auto__)){
return cljs.core.re_find(/[0-9]+/,osmdatum);
} else {
return and__6397__auto__;
}
})();
if(cljs.core.truth_(osmid)){
return cljs.core.PersistentArrayMap.fromArray([osmid,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$field,field], null),cljs.core.select_keys(datum,cljs.core.PersistentHashSet.fromArray([hatti.constants._rank,hatti.constants._id], true))], 0))], true, false);
} else {
return null;
}
})(),hatti$ona$post_process$ona_osm_link_$_iter__19697_$_iter__19715(cljs.core.rest(s__19716__$2)));
}
} else {
return null;
}
break;
}
});})(i__19699,datum,c__7187__auto__,size__7188__auto__,b__19700,s__19698__$2,temp__4657__auto__,osmfields))
,null,null));
});})(i__19699,datum,c__7187__auto__,size__7188__auto__,b__19700,s__19698__$2,temp__4657__auto__,osmfields))
;
return iter__7189__auto__(osmfields);
})());

var G__19728 = (i__19699 + (1));
i__19699 = G__19728;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__19700),hatti$ona$post_process$ona_osm_link_$_iter__19697(cljs.core.chunk_rest(s__19698__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__19700),null);
}
} else {
var datum = cljs.core.first(s__19698__$2);
return cljs.core.cons((function (){var iter__7189__auto__ = ((function (datum,s__19698__$2,temp__4657__auto__,osmfields){
return (function hatti$ona$post_process$ona_osm_link_$_iter__19697_$_iter__19721(s__19722){
return (new cljs.core.LazySeq(null,((function (datum,s__19698__$2,temp__4657__auto__,osmfields){
return (function (){
var s__19722__$1 = s__19722;
while(true){
var temp__4657__auto____$1 = cljs.core.seq(s__19722__$1);
if(temp__4657__auto____$1){
var s__19722__$2 = temp__4657__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__19722__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__19722__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__19724 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__19723 = (0);
while(true){
if((i__19723 < size__7188__auto__)){
var field = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__19723);
cljs.core.chunk_append(b__19724,(function (){var osmkey = cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(field);
var osmdatum = cljs.core.get.cljs$core$IFn$_invoke$arity$2(datum,osmkey);
var osmid = (function (){var and__6397__auto__ = osmdatum;
if(cljs.core.truth_(and__6397__auto__)){
return cljs.core.re_find(/[0-9]+/,osmdatum);
} else {
return and__6397__auto__;
}
})();
if(cljs.core.truth_(osmid)){
return cljs.core.PersistentArrayMap.fromArray([osmid,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$field,field], null),cljs.core.select_keys(datum,cljs.core.PersistentHashSet.fromArray([hatti.constants._rank,hatti.constants._id], true))], 0))], true, false);
} else {
return null;
}
})());

var G__19729 = (i__19723 + (1));
i__19723 = G__19729;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__19724),hatti$ona$post_process$ona_osm_link_$_iter__19697_$_iter__19721(cljs.core.chunk_rest(s__19722__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__19724),null);
}
} else {
var field = cljs.core.first(s__19722__$2);
return cljs.core.cons((function (){var osmkey = cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(field);
var osmdatum = cljs.core.get.cljs$core$IFn$_invoke$arity$2(datum,osmkey);
var osmid = (function (){var and__6397__auto__ = osmdatum;
if(cljs.core.truth_(and__6397__auto__)){
return cljs.core.re_find(/[0-9]+/,osmdatum);
} else {
return and__6397__auto__;
}
})();
if(cljs.core.truth_(osmid)){
return cljs.core.PersistentArrayMap.fromArray([osmid,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$field,field], null),cljs.core.select_keys(datum,cljs.core.PersistentHashSet.fromArray([hatti.constants._rank,hatti.constants._id], true))], 0))], true, false);
} else {
return null;
}
})(),hatti$ona$post_process$ona_osm_link_$_iter__19697_$_iter__19721(cljs.core.rest(s__19722__$2)));
}
} else {
return null;
}
break;
}
});})(datum,s__19698__$2,temp__4657__auto__,osmfields))
,null,null));
});})(datum,s__19698__$2,temp__4657__auto__,osmfields))
;
return iter__7189__auto__(osmfields);
})(),hatti$ona$post_process$ona_osm_link_$_iter__19697(cljs.core.rest(s__19698__$2)));
}
} else {
return null;
}
break;
}
});})(osmfields))
,null,null));
});})(osmfields))
;
return iter__7189__auto__(data);
})()));
});
/**
 * Takes OSM XML in string form, and returns cljs geojson.
 */
hatti.ona.post_process.osm_xml__GT_geojson = (function hatti$ona$post_process$osm_xml__GT_geojson(osm_xml_string){
return cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic((function (){var G__19731 = jQuery.parseXML(osm_xml_string);
return osmtogeojson(G__19731);
})(),cljs.core.array_seq([cljs.core.cst$kw$keywordize_DASH_keys,true], 0));
});
/**
 * Given some data in OSM format, an Ona Form, and osm xml string,
 * return a map from OSM ID to each osm feature. The map contains:
 * :osm-id, :name, :tags from osm xml,
 * :type, :geom from osm feature's geojson equivalent.
 */
hatti.ona.post_process.osm_id__GT_osm_data = (function hatti$ona$post_process$osm_id__GT_osm_data(data,form,osm_xml){
var ona_osm_link = hatti.ona.post_process.ona_osm_link(data,form);
var osmgeo = hatti.ona.post_process.osm_xml__GT_geojson(osm_xml);
var featureset = (function (){var G__19755 = cljs.core.cst$kw$features;
return (osmgeo.cljs$core$IFn$_invoke$arity$1 ? osmgeo.cljs$core$IFn$_invoke$arity$1(G__19755) : osmgeo.call(null,G__19755));
})();
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__7189__auto__ = ((function (ona_osm_link,osmgeo,featureset){
return (function hatti$ona$post_process$osm_id__GT_osm_data_$_iter__19756(s__19757){
return (new cljs.core.LazySeq(null,((function (ona_osm_link,osmgeo,featureset){
return (function (){
var s__19757__$1 = s__19757;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__19757__$1);
if(temp__4657__auto__){
var s__19757__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__19757__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__19757__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__19759 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__19758 = (0);
while(true){
if((i__19758 < size__7188__auto__)){
var map__19770 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__19758);
var map__19770__$1 = ((((!((map__19770 == null)))?((((map__19770.cljs$lang$protocol_mask$partition0$ & (64))) || (map__19770.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__19770):map__19770);
var feature = map__19770__$1;
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19770__$1,cljs.core.cst$kw$type);
var properties = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19770__$1,cljs.core.cst$kw$properties);
var geometry = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19770__$1,cljs.core.cst$kw$geometry);
cljs.core.chunk_append(b__19759,(function (){var map__19772 = properties;
var map__19772__$1 = ((((!((map__19772 == null)))?((((map__19772.cljs$lang$protocol_mask$partition0$ & (64))) || (map__19772.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__19772):map__19772);
var type__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19772__$1,cljs.core.cst$kw$type);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19772__$1,cljs.core.cst$kw$id);
var tags = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19772__$1,cljs.core.cst$kw$tags);
return cljs.core.PersistentArrayMap.fromArray([id,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$osm_DASH_id,id,cljs.core.cst$kw$type,type__$1,cljs.core.cst$kw$geom,geometry,cljs.core.cst$kw$name,cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(tags),cljs.core.cst$kw$tags,tags], null)], true, false);
})());

var G__19778 = (i__19758 + (1));
i__19758 = G__19778;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__19759),hatti$ona$post_process$osm_id__GT_osm_data_$_iter__19756(cljs.core.chunk_rest(s__19757__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__19759),null);
}
} else {
var map__19774 = cljs.core.first(s__19757__$2);
var map__19774__$1 = ((((!((map__19774 == null)))?((((map__19774.cljs$lang$protocol_mask$partition0$ & (64))) || (map__19774.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__19774):map__19774);
var feature = map__19774__$1;
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19774__$1,cljs.core.cst$kw$type);
var properties = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19774__$1,cljs.core.cst$kw$properties);
var geometry = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19774__$1,cljs.core.cst$kw$geometry);
return cljs.core.cons((function (){var map__19776 = properties;
var map__19776__$1 = ((((!((map__19776 == null)))?((((map__19776.cljs$lang$protocol_mask$partition0$ & (64))) || (map__19776.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__19776):map__19776);
var type__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19776__$1,cljs.core.cst$kw$type);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19776__$1,cljs.core.cst$kw$id);
var tags = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19776__$1,cljs.core.cst$kw$tags);
return cljs.core.PersistentArrayMap.fromArray([id,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$osm_DASH_id,id,cljs.core.cst$kw$type,type__$1,cljs.core.cst$kw$geom,geometry,cljs.core.cst$kw$name,cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(tags),cljs.core.cst$kw$tags,tags], null)], true, false);
})(),hatti$ona$post_process$osm_id__GT_osm_data_$_iter__19756(cljs.core.rest(s__19757__$2)));
}
} else {
return null;
}
break;
}
});})(ona_osm_link,osmgeo,featureset))
,null,null));
});})(ona_osm_link,osmgeo,featureset))
;
return iter__7189__auto__(featureset);
})());
});
/**
 * Given some data post-processed from the ona server
 * (ie, containing _id, _rank), and a string of osm-xml, produce a version with
 * relevant osm data injected in.
 */
hatti.ona.post_process.integrate_osm_data_BANG_ = (function hatti$ona$post_process$integrate_osm_data_BANG_(app_state,form,osm_xml,app_state_keys){
var osm_fields = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.osm_QMARK_,form);
if(cljs.core.seq(osm_fields)){
var data = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(app_state,app_state_keys);
var osm_data = hatti.ona.post_process.osm_id__GT_osm_data(data,form,osm_xml);
var osm_val__GT_osm_id = ((function (data,osm_data,osm_fields){
return (function (p1__19779_SHARP_){
return cljs.core.re_find(/[-]?[0-9]+/,p1__19779_SHARP_);
});})(data,osm_data,osm_fields))
;
var osm_val__GT_osm_data = ((function (data,osm_data,osm_val__GT_osm_id,osm_fields){
return (function (osm_val,osm_id){
if(typeof osm_val === 'string'){
var temp__4655__auto__ = (osm_data.cljs$core$IFn$_invoke$arity$1 ? osm_data.cljs$core$IFn$_invoke$arity$1(osm_id) : osm_data.call(null,osm_id));
if(cljs.core.truth_(temp__4655__auto__)){
var osm_submission_data = temp__4655__auto__;
return osm_submission_data;
} else {
return osm_val;
}
} else {
return osm_val;
}
});})(data,osm_data,osm_val__GT_osm_id,osm_fields))
;
var updater = ((function (data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields){
return (function (osm_key){
return ((function (data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields){
return (function (data__$1){
var iter__7189__auto__ = ((function (data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields){
return (function hatti$ona$post_process$integrate_osm_data_BANG__$_iter__19791(s__19792){
return (new cljs.core.LazySeq(null,((function (data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields){
return (function (){
var s__19792__$1 = s__19792;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__19792__$1);
if(temp__4657__auto__){
var s__19792__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__19792__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__19792__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__19794 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__19793 = (0);
while(true){
if((i__19793 < size__7188__auto__)){
var datum = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__19793);
cljs.core.chunk_append(b__19794,(function (){var osm_id = (function (){var or__6409__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(datum,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [[cljs.core.str(osm_key),cljs.core.str(":way:id")].join('')], null));
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(datum,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [[cljs.core.str(osm_key),cljs.core.str(":node:id")].join('')], null));
}
})();
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(datum,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [osm_key], null),((function (i__19793,osm_id,datum,c__7187__auto__,size__7188__auto__,b__19794,s__19792__$2,temp__4657__auto__,data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields){
return (function (p1__19780_SHARP_){
return osm_val__GT_osm_data(p1__19780_SHARP_,osm_id);
});})(i__19793,osm_id,datum,c__7187__auto__,size__7188__auto__,b__19794,s__19792__$2,temp__4657__auto__,data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields))
);
})());

var G__19801 = (i__19793 + (1));
i__19793 = G__19801;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__19794),hatti$ona$post_process$integrate_osm_data_BANG__$_iter__19791(cljs.core.chunk_rest(s__19792__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__19794),null);
}
} else {
var datum = cljs.core.first(s__19792__$2);
return cljs.core.cons((function (){var osm_id = (function (){var or__6409__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(datum,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [[cljs.core.str(osm_key),cljs.core.str(":way:id")].join('')], null));
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(datum,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [[cljs.core.str(osm_key),cljs.core.str(":node:id")].join('')], null));
}
})();
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(datum,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [osm_key], null),((function (osm_id,datum,s__19792__$2,temp__4657__auto__,data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields){
return (function (p1__19780_SHARP_){
return osm_val__GT_osm_data(p1__19780_SHARP_,osm_id);
});})(osm_id,datum,s__19792__$2,temp__4657__auto__,data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields))
);
})(),hatti$ona$post_process$integrate_osm_data_BANG__$_iter__19791(cljs.core.rest(s__19792__$2)));
}
} else {
return null;
}
break;
}
});})(data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields))
,null,null));
});})(data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields))
;
return iter__7189__auto__(data__$1);
});
;})(data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields))
});})(data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields))
;
var seq__19797 = cljs.core.seq(osm_fields);
var chunk__19798 = null;
var count__19799 = (0);
var i__19800 = (0);
while(true){
if((i__19800 < count__19799)){
var osm_field = chunk__19798.cljs$core$IIndexed$_nth$arity$2(null,i__19800);
chimera.om.state.transact_BANG_.cljs$core$IFn$_invoke$arity$3(app_state,app_state_keys,updater(cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(osm_field)));

var G__19802 = seq__19797;
var G__19803 = chunk__19798;
var G__19804 = count__19799;
var G__19805 = (i__19800 + (1));
seq__19797 = G__19802;
chunk__19798 = G__19803;
count__19799 = G__19804;
i__19800 = G__19805;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq(seq__19797);
if(temp__4657__auto__){
var seq__19797__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__19797__$1)){
var c__7220__auto__ = cljs.core.chunk_first(seq__19797__$1);
var G__19806 = cljs.core.chunk_rest(seq__19797__$1);
var G__19807 = c__7220__auto__;
var G__19808 = cljs.core.count(c__7220__auto__);
var G__19809 = (0);
seq__19797 = G__19806;
chunk__19798 = G__19807;
count__19799 = G__19808;
i__19800 = G__19809;
continue;
} else {
var osm_field = cljs.core.first(seq__19797__$1);
chimera.om.state.transact_BANG_.cljs$core$IFn$_invoke$arity$3(app_state,app_state_keys,updater(cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(osm_field)));

var G__19810 = cljs.core.next(seq__19797__$1);
var G__19811 = null;
var G__19812 = (0);
var G__19813 = (0);
seq__19797 = G__19810;
chunk__19798 = G__19811;
count__19799 = G__19812;
i__19800 = G__19813;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return null;
}
});
/**
 * Calculate full image and thumbnail urls given attachment information.
 */
hatti.ona.post_process.url_obj = (function hatti$ona$post_process$url_obj(media_obj){
var media_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(media_obj,"id");
var fname = cljs.core.get.cljs$core$IFn$_invoke$arity$2(media_obj,"filename");
var file_url = hatti.ona.urls.media_url(media_id,fname);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$filename,fname,cljs.core.cst$kw$download_url,file_url,cljs.core.cst$kw$small_download_url,[cljs.core.str(file_url),cljs.core.str("&suffix=small")].join('')], null);
});
/**
 * Gets and returns matching name for an attachment that was renamed by
 *   appending a hash on the S3 server to avoid duplicating names.
 *   e.g. if 1478203839187.jpg was renamed to 1478203839187_wijUzUf.jpg,
 *   it returns 1478203839187_wijUzUf.jpg.
 */
hatti.ona.post_process.get_matching_name = (function hatti$ona$post_process$get_matching_name(fname,fnames){
if(typeof fname === 'string'){
try{var or__6409__auto__ = (function (){var G__19823 = (function (p1__19814_SHARP_){
return cljs.core.re_find(cljs.core.re_pattern(cljs.core.first(clojure.string.split.cljs$core$IFn$_invoke$arity$2(fname,cljs.core.re_pattern("\\.")))),p1__19814_SHARP_);
});
var G__19824 = fnames;
return (chimera.seq.filter_first.cljs$core$IFn$_invoke$arity$2 ? chimera.seq.filter_first.cljs$core$IFn$_invoke$arity$2(G__19823,G__19824) : chimera.seq.filter_first.call(null,G__19823,G__19824));
})();
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return fname;
}
}catch (e19820){if((e19820 instanceof SyntaxError)){
var e = e19820;
return fname;
} else {
throw e19820;

}
}} else {
return fname;
}
});
/**
 * Helper function for integrate attachments; returns a function from
 * a filename to a `url-obj` (see specs in `url-obj` function).
 */
hatti.ona.post_process.get_attach_map = (function hatti$ona$post_process$get_attach_map(record,attachments){
var attachments__$1 = (function (){var or__6409__auto__ = attachments;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(record,hatti.constants._attachments);
}
})();
var fnames = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (attachments__$1){
return (function (p1__19825_SHARP_){
return chimera.urls.last_url_param(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__19825_SHARP_,"filename"));
});})(attachments__$1))
,attachments__$1);
var fname__GT_urlobj = cljs.core.zipmap(fnames,cljs.core.map.cljs$core$IFn$_invoke$arity$2(hatti.ona.post_process.url_obj,attachments__$1));
return ((function (attachments__$1,fnames,fname__GT_urlobj){
return (function (fname){
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(fname__GT_urlobj,hatti.ona.post_process.get_matching_name(fname,fnames),fname);
});
;})(attachments__$1,fnames,fname__GT_urlobj))
});
/**
 * Coll -> Coll
 */
hatti.ona.post_process.filter_media = (function hatti$ona$post_process$filter_media(flat_form){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__19826_SHARP_){
var or__6409__auto__ = hatti.ona.forms.video_QMARK_(p1__19826_SHARP_);
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return hatti.ona.forms.image_QMARK_(p1__19826_SHARP_);
}
}),flat_form);
});
/**
 * Inlines media data from within _attachments into each record.
 * Coll Coll -> Coll
 */
hatti.ona.post_process.integrate_attachments = (function hatti$ona$post_process$integrate_attachments(var_args){
var args__7491__auto__ = [];
var len__7484__auto___19839 = arguments.length;
var i__7485__auto___19840 = (0);
while(true){
if((i__7485__auto___19840 < len__7484__auto___19839)){
args__7491__auto__.push((arguments[i__7485__auto___19840]));

var G__19841 = (i__7485__auto___19840 + (1));
i__7485__auto___19840 = G__19841;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((2) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((2)),(0),null)):null);
return hatti.ona.post_process.integrate_attachments.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7492__auto__);
});

hatti.ona.post_process.integrate_attachments.cljs$core$IFn$_invoke$arity$variadic = (function (flat_form,data,p__19830){
var map__19831 = p__19830;
var map__19831__$1 = ((((!((map__19831 == null)))?((((map__19831.cljs$lang$protocol_mask$partition0$ & (64))) || (map__19831.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__19831):map__19831);
var attachments = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19831__$1,cljs.core.cst$kw$attachments);
var image_fields = hatti.ona.post_process.filter_media(flat_form);
var iter__7189__auto__ = ((function (image_fields,map__19831,map__19831__$1,attachments){
return (function hatti$ona$post_process$iter__19833(s__19834){
return (new cljs.core.LazySeq(null,((function (image_fields,map__19831,map__19831__$1,attachments){
return (function (){
var s__19834__$1 = s__19834;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__19834__$1);
if(temp__4657__auto__){
var s__19834__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__19834__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__19834__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__19836 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__19835 = (0);
while(true){
if((i__19835 < size__7188__auto__)){
var record = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__19835);
cljs.core.chunk_append(b__19836,(function (){var attach_map = hatti.ona.post_process.get_attach_map(record,attachments);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (i__19835,attach_map,record,c__7187__auto__,size__7188__auto__,b__19836,s__19834__$2,temp__4657__auto__,image_fields,map__19831,map__19831__$1,attachments){
return (function (record__$1,img_field){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(record__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(img_field)], null),attach_map);
});})(i__19835,attach_map,record,c__7187__auto__,size__7188__auto__,b__19836,s__19834__$2,temp__4657__auto__,image_fields,map__19831,map__19831__$1,attachments))
,record,image_fields);
})());

var G__19842 = (i__19835 + (1));
i__19835 = G__19842;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__19836),hatti$ona$post_process$iter__19833(cljs.core.chunk_rest(s__19834__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__19836),null);
}
} else {
var record = cljs.core.first(s__19834__$2);
return cljs.core.cons((function (){var attach_map = hatti.ona.post_process.get_attach_map(record,attachments);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (attach_map,record,s__19834__$2,temp__4657__auto__,image_fields,map__19831,map__19831__$1,attachments){
return (function (record__$1,img_field){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(record__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(img_field)], null),attach_map);
});})(attach_map,record,s__19834__$2,temp__4657__auto__,image_fields,map__19831,map__19831__$1,attachments))
,record,image_fields);
})(),hatti$ona$post_process$iter__19833(cljs.core.rest(s__19834__$2)));
}
} else {
return null;
}
break;
}
});})(image_fields,map__19831,map__19831__$1,attachments))
,null,null));
});})(image_fields,map__19831,map__19831__$1,attachments))
;
return iter__7189__auto__(data);
});

hatti.ona.post_process.integrate_attachments.cljs$lang$maxFixedArity = (2);

hatti.ona.post_process.integrate_attachments.cljs$lang$applyTo = (function (seq19827){
var G__19828 = cljs.core.first(seq19827);
var seq19827__$1 = cljs.core.next(seq19827);
var G__19829 = cljs.core.first(seq19827__$1);
var seq19827__$2 = cljs.core.next(seq19827__$1);
return hatti.ona.post_process.integrate_attachments.cljs$core$IFn$_invoke$arity$variadic(G__19828,G__19829,seq19827__$2);
});

/**
 * Inlines data from within _attachments into each datapoint within repeats.
 */
hatti.ona.post_process.integrate_attachments_in_repeats = (function hatti$ona$post_process$integrate_attachments_in_repeats(flat_form,data){
var repeat_fields = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.repeat_QMARK_,flat_form);
var integrate = ((function (repeat_fields){
return (function (record,rpt_field){
var key = cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(rpt_field);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(record,key,hatti.ona.post_process.integrate_attachments.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$children.cljs$core$IFn$_invoke$arity$1(rpt_field),cljs.core.get.cljs$core$IFn$_invoke$arity$2(record,key),cljs.core.array_seq([cljs.core.cst$kw$attachments,cljs.core.get.cljs$core$IFn$_invoke$arity$2(record,hatti.constants._attachments)], 0)));
});})(repeat_fields))
;
var iter__7189__auto__ = ((function (repeat_fields,integrate){
return (function hatti$ona$post_process$integrate_attachments_in_repeats_$_iter__19849(s__19850){
return (new cljs.core.LazySeq(null,((function (repeat_fields,integrate){
return (function (){
var s__19850__$1 = s__19850;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__19850__$1);
if(temp__4657__auto__){
var s__19850__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__19850__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__19850__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__19852 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__19851 = (0);
while(true){
if((i__19851 < size__7188__auto__)){
var record = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__19851);
cljs.core.chunk_append(b__19852,cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(integrate,record,repeat_fields));

var G__19855 = (i__19851 + (1));
i__19851 = G__19855;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__19852),hatti$ona$post_process$integrate_attachments_in_repeats_$_iter__19849(cljs.core.chunk_rest(s__19850__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__19852),null);
}
} else {
var record = cljs.core.first(s__19850__$2);
return cljs.core.cons(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(integrate,record,repeat_fields),hatti$ona$post_process$integrate_attachments_in_repeats_$_iter__19849(cljs.core.rest(s__19850__$2)));
}
} else {
return null;
}
break;
}
});})(repeat_fields,integrate))
,null,null));
});})(repeat_fields,integrate))
;
return iter__7189__auto__(data);
});
/**
 * Inlines data from within _attachments into each record within app-state.
 */
hatti.ona.post_process.integrate_attachments_BANG_ = (function hatti$ona$post_process$integrate_attachments_BANG_(var_args){
var args__7491__auto__ = [];
var len__7484__auto___19863 = arguments.length;
var i__7485__auto___19864 = (0);
while(true){
if((i__7485__auto___19864 < len__7484__auto___19863)){
args__7491__auto__.push((arguments[i__7485__auto___19864]));

var G__19865 = (i__7485__auto___19864 + (1));
i__7485__auto___19864 = G__19865;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((2) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((2)),(0),null)):null);
return hatti.ona.post_process.integrate_attachments_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7492__auto__);
});

hatti.ona.post_process.integrate_attachments_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (app_state,flat_form,p__19860){
var map__19861 = p__19860;
var map__19861__$1 = ((((!((map__19861 == null)))?((((map__19861.cljs$lang$protocol_mask$partition0$ & (64))) || (map__19861.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__19861):map__19861);
var app_data_keys = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__19861__$1,cljs.core.cst$kw$app_DASH_data_DASH_keys,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data], null));
return chimera.om.state.transact_BANG_.cljs$core$IFn$_invoke$arity$3(app_state,app_data_keys,((function (map__19861,map__19861__$1,app_data_keys){
return (function (p1__19856_SHARP_){
return hatti.ona.post_process.integrate_attachments_in_repeats(flat_form,hatti.ona.post_process.integrate_attachments(flat_form,p1__19856_SHARP_));
});})(map__19861,map__19861__$1,app_data_keys))
);
});

hatti.ona.post_process.integrate_attachments_BANG_.cljs$lang$maxFixedArity = (2);

hatti.ona.post_process.integrate_attachments_BANG_.cljs$lang$applyTo = (function (seq19857){
var G__19858 = cljs.core.first(seq19857);
var seq19857__$1 = cljs.core.next(seq19857);
var G__19859 = cljs.core.first(seq19857__$1);
var seq19857__$2 = cljs.core.next(seq19857__$1);
return hatti.ona.post_process.integrate_attachments_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__19858,G__19859,seq19857__$2);
});

