// Compiled by ClojureScript 1.9.229 {:static-fns true, :optimize-constants true}
goog.provide('hatti.ona.stream');
goog.require('cljs.core');
goog.require('cljs.core.async');
hatti.ona.stream.small_delay = (10);
/**
 * Calls callback on aggregated data that come via messages in channel.
 * Callback accepts two arguments: data (cljs list), and completed? (bool)
 *   If there is a parser in message, resume it after a timeout.
 */
hatti.ona.stream.process_aggregated_data_BANG_ = (function hatti$ona$stream$process_aggregated_data_BANG_(agg_data_channel,callback){
var c__12309__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12309__auto__){
return (function (){
var f__12310__auto__ = (function (){var switch__12197__auto__ = ((function (c__12309__auto__){
return (function (state_40486){
var state_val_40487 = (state_40486[(1)]);
if((state_val_40487 === (7))){
var inst_40443 = (state_40486[(7)]);
var inst_40443__$1 = (state_40486[(2)]);
var inst_40445 = (inst_40443__$1 == null);
var inst_40446 = cljs.core.not(inst_40445);
var state_40486__$1 = (function (){var statearr_40488 = state_40486;
(statearr_40488[(7)] = inst_40443__$1);

return statearr_40488;
})();
if(inst_40446){
var statearr_40489_40526 = state_40486__$1;
(statearr_40489_40526[(1)] = (8));

} else {
var statearr_40490_40527 = state_40486__$1;
(statearr_40490_40527[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40487 === (20))){
var inst_40465 = (state_40486[(8)]);
var inst_40473 = (state_40486[(2)]);
var state_40486__$1 = (function (){var statearr_40491 = state_40486;
(statearr_40491[(9)] = inst_40473);

return statearr_40491;
})();
if(cljs.core.truth_(inst_40465)){
var statearr_40492_40528 = state_40486__$1;
(statearr_40492_40528[(1)] = (21));

} else {
var statearr_40493_40529 = state_40486__$1;
(statearr_40493_40529[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40487 === (1))){
var state_40486__$1 = state_40486;
var statearr_40494_40530 = state_40486__$1;
(statearr_40494_40530[(2)] = null);

(statearr_40494_40530[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40487 === (4))){
var state_40486__$1 = state_40486;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40486__$1,(7),agg_data_channel);
} else {
if((state_val_40487 === (15))){
var inst_40443 = (state_40486[(7)]);
var state_40486__$1 = state_40486;
var statearr_40495_40531 = state_40486__$1;
(statearr_40495_40531[(2)] = inst_40443);

(statearr_40495_40531[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40487 === (21))){
var inst_40475 = cljs.core.async.close_BANG_(agg_data_channel);
var state_40486__$1 = state_40486;
var statearr_40496_40532 = state_40486__$1;
(statearr_40496_40532[(2)] = inst_40475);

(statearr_40496_40532[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40487 === (13))){
var inst_40455 = (state_40486[(2)]);
var state_40486__$1 = state_40486;
var statearr_40497_40533 = state_40486__$1;
(statearr_40497_40533[(2)] = inst_40455);

(statearr_40497_40533[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40487 === (22))){
var state_40486__$1 = state_40486;
var statearr_40498_40534 = state_40486__$1;
(statearr_40498_40534[(2)] = null);

(statearr_40498_40534[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40487 === (6))){
var inst_40482 = (state_40486[(2)]);
var state_40486__$1 = state_40486;
var statearr_40499_40535 = state_40486__$1;
(statearr_40499_40535[(2)] = inst_40482);

(statearr_40499_40535[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40487 === (17))){
var inst_40464 = (state_40486[(10)]);
var inst_40465 = (state_40486[(8)]);
var inst_40467 = (callback.cljs$core$IFn$_invoke$arity$2 ? callback.cljs$core$IFn$_invoke$arity$2(inst_40464,inst_40465) : callback.call(null,inst_40464,inst_40465));
var state_40486__$1 = state_40486;
var statearr_40500_40536 = state_40486__$1;
(statearr_40500_40536[(2)] = inst_40467);

(statearr_40500_40536[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40487 === (3))){
var inst_40484 = (state_40486[(2)]);
var state_40486__$1 = state_40486;
return cljs.core.async.impl.ioc_helpers.return_chan(state_40486__$1,inst_40484);
} else {
if((state_val_40487 === (12))){
var state_40486__$1 = state_40486;
var statearr_40501_40537 = state_40486__$1;
(statearr_40501_40537[(2)] = false);

(statearr_40501_40537[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40487 === (2))){
var state_40486__$1 = state_40486;
var statearr_40502_40538 = state_40486__$1;
(statearr_40502_40538[(1)] = (4));



return cljs.core.cst$kw$recur;
} else {
if((state_val_40487 === (23))){
var inst_40478 = (state_40486[(2)]);
var state_40486__$1 = (function (){var statearr_40504 = state_40486;
(statearr_40504[(11)] = inst_40478);

return statearr_40504;
})();
var statearr_40505_40539 = state_40486__$1;
(statearr_40505_40539[(2)] = null);

(statearr_40505_40539[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40487 === (19))){
var inst_40470 = (state_40486[(2)]);
var inst_40471 = cljs.core.async.timeout(hatti.ona.stream.small_delay);
var state_40486__$1 = (function (){var statearr_40506 = state_40486;
(statearr_40506[(12)] = inst_40470);

return statearr_40506;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40486__$1,(20),inst_40471);
} else {
if((state_val_40487 === (11))){
var state_40486__$1 = state_40486;
var statearr_40507_40540 = state_40486__$1;
(statearr_40507_40540[(2)] = true);

(statearr_40507_40540[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40487 === (9))){
var state_40486__$1 = state_40486;
var statearr_40508_40541 = state_40486__$1;
(statearr_40508_40541[(2)] = false);

(statearr_40508_40541[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40487 === (5))){
var state_40486__$1 = state_40486;
var statearr_40509_40542 = state_40486__$1;
(statearr_40509_40542[(2)] = null);

(statearr_40509_40542[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40487 === (14))){
var inst_40443 = (state_40486[(7)]);
var inst_40460 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_40443);
var state_40486__$1 = state_40486;
var statearr_40510_40543 = state_40486__$1;
(statearr_40510_40543[(2)] = inst_40460);

(statearr_40510_40543[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40487 === (16))){
var inst_40464 = (state_40486[(10)]);
var inst_40463 = (state_40486[(2)]);
var inst_40464__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_40463,cljs.core.cst$kw$data);
var inst_40465 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_40463,cljs.core.cst$kw$completed_QMARK_);
var state_40486__$1 = (function (){var statearr_40511 = state_40486;
(statearr_40511[(10)] = inst_40464__$1);

(statearr_40511[(8)] = inst_40465);

return statearr_40511;
})();
if(cljs.core.truth_(inst_40464__$1)){
var statearr_40512_40544 = state_40486__$1;
(statearr_40512_40544[(1)] = (17));

} else {
var statearr_40513_40545 = state_40486__$1;
(statearr_40513_40545[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40487 === (10))){
var inst_40458 = (state_40486[(2)]);
var state_40486__$1 = state_40486;
if(cljs.core.truth_(inst_40458)){
var statearr_40514_40546 = state_40486__$1;
(statearr_40514_40546[(1)] = (14));

} else {
var statearr_40515_40547 = state_40486__$1;
(statearr_40515_40547[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40487 === (18))){
var state_40486__$1 = state_40486;
var statearr_40516_40548 = state_40486__$1;
(statearr_40516_40548[(2)] = null);

(statearr_40516_40548[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40487 === (8))){
var inst_40443 = (state_40486[(7)]);
var inst_40448 = inst_40443.cljs$lang$protocol_mask$partition0$;
var inst_40449 = (inst_40448 & (64));
var inst_40450 = inst_40443.cljs$core$ISeq$;
var inst_40451 = (inst_40449) || (inst_40450);
var state_40486__$1 = state_40486;
if(cljs.core.truth_(inst_40451)){
var statearr_40517_40549 = state_40486__$1;
(statearr_40517_40549[(1)] = (11));

} else {
var statearr_40518_40550 = state_40486__$1;
(statearr_40518_40550[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12309__auto__))
;
return ((function (switch__12197__auto__,c__12309__auto__){
return (function() {
var hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__12198__auto__ = null;
var hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__12198__auto____0 = (function (){
var statearr_40522 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_40522[(0)] = hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__12198__auto__);

(statearr_40522[(1)] = (1));

return statearr_40522;
});
var hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__12198__auto____1 = (function (state_40486){
while(true){
var ret_value__12199__auto__ = (function (){try{while(true){
var result__12200__auto__ = switch__12197__auto__(state_40486);
if(cljs.core.keyword_identical_QMARK_(result__12200__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12200__auto__;
}
break;
}
}catch (e40523){if((e40523 instanceof Object)){
var ex__12201__auto__ = e40523;
var statearr_40524_40551 = state_40486;
(statearr_40524_40551[(5)] = ex__12201__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_40486);

return cljs.core.cst$kw$recur;
} else {
throw e40523;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12199__auto__,cljs.core.cst$kw$recur)){
var G__40552 = state_40486;
state_40486 = G__40552;
continue;
} else {
return ret_value__12199__auto__;
}
break;
}
});
hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__12198__auto__ = function(state_40486){
switch(arguments.length){
case 0:
return hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__12198__auto____0.call(this);
case 1:
return hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__12198__auto____1.call(this,state_40486);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__12198__auto____0;
hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__12198__auto____1;
return hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__12198__auto__;
})()
;})(switch__12197__auto__,c__12309__auto__))
})();
var state__12311__auto__ = (function (){var statearr_40525 = (f__12310__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12310__auto__.cljs$core$IFn$_invoke$arity$0() : f__12310__auto__.call(null));
(statearr_40525[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12309__auto__);

return statearr_40525;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12311__auto__);
});})(c__12309__auto__))
);

return c__12309__auto__;
});
/**
 * On each step of data, increment read-count atom, and put data in a list agg.
 * After a exponentially increasing # of steps have been processed,
 * the aggregated data gets flushed into a channel, and parser is paused.
 * The channel reader should resume the parser after processing the data.
 */
hatti.ona.stream.read_next_chunk_BANG_ = (function hatti$ona$stream$read_next_chunk_BANG_(data_chunk,read_count,agg,channel){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(read_count,cljs.core.inc);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(agg,cljs.core.conj,data_chunk);

if((((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(read_count) : cljs.core.deref.call(null,read_count)) >= (100))) && (cljs.core.integer_QMARK_(Math.log10((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(read_count) : cljs.core.deref.call(null,read_count)))))){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(channel,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$data,(cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(agg) : cljs.core.deref.call(null,agg))], null));

var G__40555_40557 = agg;
var G__40556_40558 = cljs.core.PersistentVector.EMPTY;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__40555_40557,G__40556_40558) : cljs.core.reset_BANG_.call(null,G__40555_40557,G__40556_40558));

return oboe.drop();
} else {
return null;
}
});
/**
 * Given url, a node pattern matcher, and a callback, streaming-read json.
 */
hatti.ona.stream.streamingly_read_json_BANG_ = (function hatti$ona$stream$streamingly_read_json_BANG_(var_args){
var args__7491__auto__ = [];
var len__7484__auto___40566 = arguments.length;
var i__7485__auto___40567 = (0);
while(true){
if((i__7485__auto___40567 < len__7484__auto___40566)){
args__7491__auto__.push((arguments[i__7485__auto___40567]));

var G__40568 = (i__7485__auto___40567 + (1));
i__7485__auto___40567 = G__40568;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((2) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((2)),(0),null)):null);
return hatti.ona.stream.streamingly_read_json_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7492__auto__);
});

hatti.ona.stream.streamingly_read_json_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (url,stepfn,p__40562){
var map__40563 = p__40562;
var map__40563__$1 = ((((!((map__40563 == null)))?((((map__40563.cljs$lang$protocol_mask$partition0$ & (64))) || (map__40563.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40563):map__40563);
var oboe_headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40563__$1,cljs.core.cst$kw$oboe_DASH_headers);
var read_count = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1((0)) : cljs.core.atom.call(null,(0)));
var agg = (function (){var G__40565 = cljs.core.PersistentVector.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__40565) : cljs.core.atom.call(null,G__40565));
})();
var channel = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var return_channel = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var oboe_params = cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$url,url,cljs.core.cst$kw$headers,oboe_headers,cljs.core.cst$kw$withCredentials,true], null));
var step = ((function (read_count,agg,channel,return_channel,oboe_params,map__40563,map__40563__$1,oboe_headers){
return (function (line){
return hatti.ona.stream.read_next_chunk_BANG_(cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$1(line),read_count,agg,channel);
});})(read_count,agg,channel,return_channel,oboe_params,map__40563,map__40563__$1,oboe_headers))
;
var done = ((function (read_count,agg,channel,return_channel,oboe_params,step,map__40563,map__40563__$1,oboe_headers){
return (function (){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(channel,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$data,(cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(agg) : cljs.core.deref.call(null,agg)),cljs.core.cst$kw$completed_QMARK_,true], null));

return cljs.core.async.close_BANG_(return_channel);
});})(read_count,agg,channel,return_channel,oboe_params,step,map__40563,map__40563__$1,oboe_headers))
;
hatti.ona.stream.process_aggregated_data_BANG_(channel,stepfn);

window.oboe(oboe_params).node("!.*",step).done(done);

return return_channel;
});

hatti.ona.stream.streamingly_read_json_BANG_.cljs$lang$maxFixedArity = (2);

hatti.ona.stream.streamingly_read_json_BANG_.cljs$lang$applyTo = (function (seq40559){
var G__40560 = cljs.core.first(seq40559);
var seq40559__$1 = cljs.core.next(seq40559);
var G__40561 = cljs.core.first(seq40559__$1);
var seq40559__$2 = cljs.core.next(seq40559__$1);
return hatti.ona.stream.streamingly_read_json_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__40560,G__40561,seq40559__$2);
});

