// Compiled by ClojureScript 1.9.229 {:static-fns true, :optimize-constants true}
goog.provide('hatti.utils');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('goog.string.format');
goog.require('goog.string');
goog.require('inflections.core');
goog.require('sablono.core');
/**
 * Convert json to js using JSON.parse
 */
hatti.utils.json__GT_js = (function hatti$utils$json__GT_js(s){
return JSON.parse(s);
});
/**
 * Given a seq, produces a two-el seq. [a b c] => [[0 a] [1 b] [2 c]].
 */
hatti.utils.indexed = (function hatti$utils$indexed(coll){
return cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,coll);
});
/**
 * Helper function to create a click function that prevents default
 */
hatti.utils.click_fn = (function hatti$utils$click_fn(f){
return (function (event){
event.preventDefault();

return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
});
});
/**
 * Create an appropriately pluralized string prefix by number.
 */
hatti.utils.pluralize_number = (function hatti$utils$pluralize_number(number,kind){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [number,((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),number))?kind:inflections.core.plural(kind))], null));
});
/**
 * True if substring is a substring of string
 */
hatti.utils.substring_QMARK_ = (function hatti$utils$substring_QMARK_(var_args){
var args38131 = [];
var len__7484__auto___38140 = arguments.length;
var i__7485__auto___38141 = (0);
while(true){
if((i__7485__auto___38141 < len__7484__auto___38140)){
args38131.push((arguments[i__7485__auto___38141]));

var G__38142 = (i__7485__auto___38141 + (1));
i__7485__auto___38141 = G__38142;
continue;
} else {
}
break;
}

var G__38136 = args38131.length;
switch (G__38136) {
case 2:
return hatti.utils.substring_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__7503__auto__ = (new cljs.core.IndexedSeq(args38131.slice((2)),(0),null));
return hatti.utils.substring_QMARK_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7503__auto__);

}
});

hatti.utils.substring_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (substring,string){
return cljs.core.complement(cljs.core.nil_QMARK_).call(null,cljs.core.re_find(cljs.core.re_pattern(substring),string));
});

hatti.utils.substring_QMARK_.cljs$core$IFn$_invoke$arity$variadic = (function (substring,string,p__38137){
var map__38138 = p__38137;
var map__38138__$1 = ((((!((map__38138 == null)))?((((map__38138.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38138.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38138):map__38138);
var case_sensitive_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38138__$1,cljs.core.cst$kw$case_DASH_sensitive_QMARK_);
if(cljs.core.truth_(case_sensitive_QMARK_)){
return hatti.utils.substring_QMARK_.cljs$core$IFn$_invoke$arity$2(substring,string);
} else {
return hatti.utils.substring_QMARK_.cljs$core$IFn$_invoke$arity$2(clojure.string.lower_case(substring),clojure.string.lower_case(string));
}
});

hatti.utils.substring_QMARK_.cljs$lang$applyTo = (function (seq38132){
var G__38133 = cljs.core.first(seq38132);
var seq38132__$1 = cljs.core.next(seq38132);
var G__38134 = cljs.core.first(seq38132__$1);
var seq38132__$2 = cljs.core.next(seq38132__$1);
return hatti.utils.substring_QMARK_.cljs$core$IFn$_invoke$arity$variadic(G__38133,G__38134,seq38132__$2);
});

hatti.utils.substring_QMARK_.cljs$lang$maxFixedArity = (2);

hatti.utils.hyphen__GT_camel_case = (function hatti$utils$hyphen__GT_camel_case(source_string){
return clojure.string.replace(source_string,/(-)(.)/,(function (p1__38144_SHARP_){
var vec__38148 = p1__38144_SHARP_;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38148,(0),null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38148,(1),null);
var letter_to_uppercase = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38148,(2),null);
return clojure.string.upper_case(letter_to_uppercase);
}));
});
hatti.utils.generate_component = (function hatti$utils$generate_component(element_definition_vector){
return sablono.interpreter.interpret(element_definition_vector);
});
/**
 * This function generates HTML from hiccup-style vectors, and concatenates
 *   the resulting markup. Strings are returned unaffected.
 */
hatti.utils.generate_html = (function hatti$utils$generate_html(var_args){
var args__7491__auto__ = [];
var len__7484__auto___38152 = arguments.length;
var i__7485__auto___38153 = (0);
while(true){
if((i__7485__auto___38153 < len__7484__auto___38152)){
args__7491__auto__.push((arguments[i__7485__auto___38153]));

var G__38154 = (i__7485__auto___38153 + (1));
i__7485__auto___38153 = G__38154;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((0) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((0)),(0),null)):null);
return hatti.utils.generate_html.cljs$core$IFn$_invoke$arity$variadic(argseq__7492__auto__);
});

hatti.utils.generate_html.cljs$core$IFn$_invoke$arity$variadic = (function (element_definition_vectors){
var components = cljs.core.map.cljs$core$IFn$_invoke$arity$2(hatti.utils.generate_component,element_definition_vectors);
var components_as_static_markup = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (components){
return (function (component){
if(typeof component === 'string'){
return component;
} else {
return sablono.core.render_static(component);
}
});})(components))
,components);
return clojure.string.join.cljs$core$IFn$_invoke$arity$1(components_as_static_markup);
});

hatti.utils.generate_html.cljs$lang$maxFixedArity = (0);

hatti.utils.generate_html.cljs$lang$applyTo = (function (seq38151){
return hatti.utils.generate_html.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq38151));
});

