// Compiled by ClojureScript 1.9.229 {:static-fns true, :optimize-constants true}
goog.provide('hatti.views.dataview');
goog.require('cljs.core');
goog.require('chimera.js_interop');
goog.require('chimera.om.state');
goog.require('hatti.views.photos');
goog.require('sablono.core');
goog.require('hatti.views.user_guide');
goog.require('cljs.core.async');
goog.require('hatti.views.map');
goog.require('hatti.views.chart');
goog.require('hatti.views.report_view');
goog.require('hatti.shared');
goog.require('chimera.metrics');
goog.require('hatti.views.saved_charts');
goog.require('hatti.ona.forms');
goog.require('hatti.constants');
goog.require('hatti.views');
goog.require('hatti.views.settings');
goog.require('om.core');
goog.require('hatti.utils');
goog.require('hatti.views.overview');
goog.require('hatti.views.table');
hatti.views.dataview.dataview_map = cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$user_DASH_guide,cljs.core.cst$kw$table,cljs.core.cst$kw$report_DASH_view,cljs.core.cst$kw$saved_DASH_charts,cljs.core.cst$kw$settings,cljs.core.cst$kw$overview,cljs.core.cst$kw$chart,cljs.core.cst$kw$photos,cljs.core.cst$kw$map],[new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$view,cljs.core.cst$kw$user_DASH_guide,cljs.core.cst$kw$label,"User Guide",cljs.core.cst$kw$component,hatti.views.user_guide_page], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$view,cljs.core.cst$kw$table,cljs.core.cst$kw$label,"Table",cljs.core.cst$kw$component,hatti.views.table_page], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$view,cljs.core.cst$kw$report_DASH_view,cljs.core.cst$kw$label,"Reports",cljs.core.cst$kw$component,hatti.views.report_view_page], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$view,cljs.core.cst$kw$saved_DASH_charts,cljs.core.cst$kw$label,"Dashboard",cljs.core.cst$kw$component,hatti.views.saved_charts_page], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$view,cljs.core.cst$kw$settings,cljs.core.cst$kw$label,"Settings",cljs.core.cst$kw$component,hatti.views.settings_page], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$view,cljs.core.cst$kw$overview,cljs.core.cst$kw$label,"Overview",cljs.core.cst$kw$component,hatti.views.overview_page], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$view,cljs.core.cst$kw$chart,cljs.core.cst$kw$label,"Charts",cljs.core.cst$kw$component,hatti.views.chart_page], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$view,cljs.core.cst$kw$photos,cljs.core.cst$kw$label,"Photos",cljs.core.cst$kw$component,hatti.views.photos_page], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$view,cljs.core.cst$kw$map,cljs.core.cst$kw$label,"Map",cljs.core.cst$kw$component,hatti.views.map_page], null)]);
/**
 * Initial Dataview State
 */
hatti.views.dataview.default_dataviews = (function hatti$views$dataview$default_dataviews(){
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(hatti.views.dataview.dataview_map) : cljs.core.atom.call(null,hatti.views.dataview.dataview_map));
});
hatti.views.dataview.view_state = hatti.views.dataview.default_dataviews();
/**
 * Build and set the tooltips for inactive views based on why they are
 * inactive.
 */
hatti.views.dataview.view__GT_inactive_tab = (function hatti$views$dataview$view__GT_inactive_tab(view,label,is_encrypted_QMARK_,not_within_pricing_limits_QMARK_){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a$inactive,[cljs.core.str(label),cljs.core.str(" ")].join(''),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$tooltip,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$tip_DASH_info$tooltip,(cljs.core.truth_(is_encrypted_QMARK_)?"This tab is disabled because this form is encrypted.":(cljs.core.truth_(not_within_pricing_limits_QMARK_)?"This tab is disabled because you are over the pricing limits.":(function (){var pred__23393 = cljs.core._EQ_;
var expr__23394 = view;
if(cljs.core.truth_((function (){var G__23396 = cljs.core.cst$kw$map;
var G__23397 = expr__23394;
return (pred__23393.cljs$core$IFn$_invoke$arity$2 ? pred__23393.cljs$core$IFn$_invoke$arity$2(G__23396,G__23397) : pred__23393.call(null,G__23396,G__23397));
})())){
return [cljs.core.str("The Map tab is disabled because this form "),cljs.core.str("has no location questions.")].join('');
} else {
if(cljs.core.truth_((function (){var G__23398 = cljs.core.cst$kw$photos;
var G__23399 = expr__23394;
return (pred__23393.cljs$core$IFn$_invoke$arity$2 ? pred__23393.cljs$core$IFn$_invoke$arity$2(G__23398,G__23399) : pred__23393.call(null,G__23398,G__23399));
})())){
return [cljs.core.str("The Photos tab is disabled because this form has no "),cljs.core.str("photo questions.")].join('');
} else {
if(cljs.core.truth_((function (){var G__23400 = cljs.core.cst$kw$table;
var G__23401 = expr__23394;
return (pred__23393.cljs$core$IFn$_invoke$arity$2 ? pred__23393.cljs$core$IFn$_invoke$arity$2(G__23400,G__23401) : pred__23393.call(null,G__23400,G__23401));
})())){
return [cljs.core.str("The table tab is disabled because you do not have "),cljs.core.str("permission to view it.")].join('');
} else {
if(cljs.core.truth_((function (){var G__23402 = cljs.core.cst$kw$chart;
var G__23403 = expr__23394;
return (pred__23393.cljs$core$IFn$_invoke$arity$2 ? pred__23393.cljs$core$IFn$_invoke$arity$2(G__23402,G__23403) : pred__23393.call(null,G__23402,G__23403));
})())){
return [cljs.core.str("The charts tab is disabled because you do not have "),cljs.core.str("permission to view it.")].join('');
} else {
if(cljs.core.truth_((function (){var G__23404 = cljs.core.cst$kw$saved_DASH_charts;
var G__23405 = expr__23394;
return (pred__23393.cljs$core$IFn$_invoke$arity$2 ? pred__23393.cljs$core$IFn$_invoke$arity$2(G__23404,G__23405) : pred__23393.call(null,G__23404,G__23405));
})())){
return [cljs.core.str("The dashboards tab is disabled because "),cljs.core.str("you do not have permission to view it.")].join('');
} else {
return "This tab is disabled.";
}
}
}
}
}
})()
))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$tip_DASH_question,"?"], null)], null)], null);
});
hatti.views.dataview_actions.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (cursor,owner){
if(typeof hatti.views.dataview.t_hatti$views$dataview23406 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.dataview.t_hatti$views$dataview23406 = (function (cursor,owner,meta23407){
this.cursor = cursor;
this.owner = owner;
this.meta23407 = meta23407;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.dataview.t_hatti$views$dataview23406.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_23408,meta23407__$1){
var self__ = this;
var _23408__$1 = this;
return (new hatti.views.dataview.t_hatti$views$dataview23406(self__.cursor,self__.owner,meta23407__$1));
});

hatti.views.dataview.t_hatti$views$dataview23406.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_23408){
var self__ = this;
var _23408__$1 = this;
return self__.meta23407;
});

hatti.views.dataview.t_hatti$views$dataview23406.prototype.om$core$IRender$ = true;

hatti.views.dataview.t_hatti$views$dataview23406.prototype.om$core$IRender$render$arity$1 = (function (this__15775__auto__){
var self__ = this;
var this__15775__auto____$1 = this;
return null;
});

hatti.views.dataview.t_hatti$views$dataview23406.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$cursor,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta23407], null);
});

hatti.views.dataview.t_hatti$views$dataview23406.cljs$lang$type = true;

hatti.views.dataview.t_hatti$views$dataview23406.cljs$lang$ctorStr = "hatti.views.dataview/t_hatti$views$dataview23406";

hatti.views.dataview.t_hatti$views$dataview23406.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"hatti.views.dataview/t_hatti$views$dataview23406");
});

hatti.views.dataview.__GT_t_hatti$views$dataview23406 = (function hatti$views$dataview$__GT_t_hatti$views$dataview23406(cursor__$1,owner__$1,meta23407){
return (new hatti.views.dataview.t_hatti$views$dataview23406(cursor__$1,owner__$1,meta23407));
});

}

return (new hatti.views.dataview.t_hatti$views$dataview23406(cursor,owner,null));
}));
hatti.views.dataview_infobar.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (p__23409,owner){
var map__23410 = p__23409;
var map__23410__$1 = ((((!((map__23410 == null)))?((((map__23410.cljs$lang$protocol_mask$partition0$ & (64))) || (map__23410.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__23410):map__23410);
var dataset_info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23410__$1,cljs.core.cst$kw$dataset_DASH_info);
var status = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23410__$1,cljs.core.cst$kw$status);
if(typeof hatti.views.dataview.t_hatti$views$dataview23412 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {om.core.IWillMount}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.dataview.t_hatti$views$dataview23412 = (function (p__23409,owner,map__23410,dataset_info,status,meta23413){
this.p__23409 = p__23409;
this.owner = owner;
this.map__23410 = map__23410;
this.dataset_info = dataset_info;
this.status = status;
this.meta23413 = meta23413;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.dataview.t_hatti$views$dataview23412.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (map__23410,map__23410__$1,dataset_info,status){
return (function (_23414,meta23413__$1){
var self__ = this;
var _23414__$1 = this;
return (new hatti.views.dataview.t_hatti$views$dataview23412(self__.p__23409,self__.owner,self__.map__23410,self__.dataset_info,self__.status,meta23413__$1));
});})(map__23410,map__23410__$1,dataset_info,status))
;

hatti.views.dataview.t_hatti$views$dataview23412.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (map__23410,map__23410__$1,dataset_info,status){
return (function (_23414){
var self__ = this;
var _23414__$1 = this;
return self__.meta23413;
});})(map__23410,map__23410__$1,dataset_info,status))
;

hatti.views.dataview.t_hatti$views$dataview23412.prototype.om$core$IWillMount$ = true;

hatti.views.dataview.t_hatti$views$dataview23412.prototype.om$core$IWillMount$will_mount$arity$1 = ((function (map__23410,map__23410__$1,dataset_info,status){
return (function (_){
var self__ = this;
var ___$1 = this;
return hatti.shared.maybe_merge_languages_BANG_(om.core.get_shared.cljs$core$IFn$_invoke$arity$2(self__.owner,cljs.core.cst$kw$flat_DASH_form));
});})(map__23410,map__23410__$1,dataset_info,status))
;

hatti.views.dataview.t_hatti$views$dataview23412.prototype.om$core$IRender$ = true;

hatti.views.dataview.t_hatti$views$dataview23412.prototype.om$core$IRender$render$arity$1 = ((function (map__23410,map__23410__$1,dataset_info,status){
return (function (_){
var self__ = this;
var ___$1 = this;
var form = om.core.get_shared.cljs$core$IFn$_invoke$arity$2(self__.owner,cljs.core.cst$kw$flat_DASH_form);
var map__23415 = om.core.get_shared.cljs$core$IFn$_invoke$arity$1(self__.owner);
var map__23415__$1 = ((((!((map__23415 == null)))?((((map__23415.cljs$lang$protocol_mask$partition0$ & (64))) || (map__23415.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__23415):map__23415);
var dataset_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23415__$1,cljs.core.cst$kw$dataset_DASH_id);
var map__23416 = self__.dataset_info;
var map__23416__$1 = ((((!((map__23416 == null)))?((((map__23416.cljs$lang$protocol_mask$partition0$ & (64))) || (map__23416.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__23416):map__23416);
var num_of_submissions = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23416__$1,cljs.core.cst$kw$num_of_submissions);
var map__23417 = self__.status;
var map__23417__$1 = ((((!((map__23417 == null)))?((((map__23417.cljs$lang$protocol_mask$partition0$ & (64))) || (map__23417.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__23417):map__23417);
var loading_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23417__$1,cljs.core.cst$kw$loading_QMARK_);
var total_records = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23417__$1,cljs.core.cst$kw$total_DASH_records);
var G__23425 = ({"className": "right rec-summary rec-margin"});
var G__23426 = (function (){var attrs23421 = (cljs.core.truth_(hatti.ona.forms.multilingual_QMARK_(form))?om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.shared.language_selector,null):null);
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(React.DOM.div,((cljs.core.map_QMARK_(attrs23421))?sablono.interpreter.attributes(sablono.util.merge_with_class.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$id,"language-selector"], null),attrs23421], 0))):({"id": "language-selector"})),cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,((cljs.core.map_QMARK_(attrs23421))?cljs.core.PersistentVector.EMPTY:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret(attrs23421)], null))));
})();
var G__23427 = (function (){var G__23430 = ({"id": "data-status"});
var G__23431 = (function (){var attrs23422 = (cljs.core.truth_(loading_QMARK_)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$i$fa$fa_DASH_spinner$fa_DASH_pulse], null):null);
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(React.DOM.span,((cljs.core.map_QMARK_(attrs23422))?sablono.interpreter.attributes(sablono.util.merge_with_class.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["rec"], null)], null),attrs23422], 0))):({"className": "rec"})),cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,((cljs.core.map_QMARK_(attrs23422))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret(hatti.utils.pluralize_number(num_of_submissions," Record"))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret(attrs23422),sablono.interpreter.interpret(hatti.utils.pluralize_number(num_of_submissions," Record"))], null))));
})();
return React.DOM.div(G__23430,G__23431);
})();
var G__23428 = (function (){var G__23432 = ({"className": "divider"});
return React.DOM.div(G__23432);
})();
var G__23429 = sablono.interpreter.interpret(om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.views.dataview_actions,dataset_id));
return React.DOM.div(G__23425,G__23426,G__23427,G__23428,G__23429);
});})(map__23410,map__23410__$1,dataset_info,status))
;

hatti.views.dataview.t_hatti$views$dataview23412.getBasis = ((function (map__23410,map__23410__$1,dataset_info,status){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p__23409,cljs.core.cst$sym$owner,cljs.core.cst$sym$map__23410,cljs.core.cst$sym$dataset_DASH_info,cljs.core.cst$sym$status,cljs.core.cst$sym$meta23413], null);
});})(map__23410,map__23410__$1,dataset_info,status))
;

hatti.views.dataview.t_hatti$views$dataview23412.cljs$lang$type = true;

hatti.views.dataview.t_hatti$views$dataview23412.cljs$lang$ctorStr = "hatti.views.dataview/t_hatti$views$dataview23412";

hatti.views.dataview.t_hatti$views$dataview23412.cljs$lang$ctorPrWriter = ((function (map__23410,map__23410__$1,dataset_info,status){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"hatti.views.dataview/t_hatti$views$dataview23412");
});})(map__23410,map__23410__$1,dataset_info,status))
;

hatti.views.dataview.__GT_t_hatti$views$dataview23412 = ((function (map__23410,map__23410__$1,dataset_info,status){
return (function hatti$views$dataview$__GT_t_hatti$views$dataview23412(p__23409__$1,owner__$1,map__23410__$2,dataset_info__$1,status__$1,meta23413){
return (new hatti.views.dataview.t_hatti$views$dataview23412(p__23409__$1,owner__$1,map__23410__$2,dataset_info__$1,status__$1,meta23413));
});})(map__23410,map__23410__$1,dataset_info,status))
;

}

return (new hatti.views.dataview.t_hatti$views$dataview23412(p__23409,owner,map__23410__$1,dataset_info,status,cljs.core.PersistentArrayMap.EMPTY));
}));
/**
 * Strip off ampersand suffixes then switch to view if result is a valid view
 */
hatti.views.dataview.activate_view_BANG_ = (function hatti$views$dataview$activate_view_BANG_(view){
var view__$1 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1((function (){var or__6409__auto__ = cljs.core.last(cljs.core.re_find(/(.*?)&/,view));
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return view;
}
})());
var views = cljs.core.cst$kw$all.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$views.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.shared.app_state) : cljs.core.deref.call(null,hatti.shared.app_state))));
if(cljs.core.contains_QMARK_(cljs.core.set(views),view__$1)){
chimera.om.state.merge_into_app_state_BANG_.cljs$core$IFn$_invoke$arity$3(hatti.shared.app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$views], null),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$selected,view__$1], null));

return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$re_DASH_render,view__$1], null));
} else {
return null;
}
});
hatti.views.dataview.activate_settings_view_BANG_ = (function hatti$views$dataview$activate_settings_view_BANG_(view,settings_section){
var view__$1 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(view);
var settings_section__$1 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(settings_section);
var views = cljs.core.cst$kw$all.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$views.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.shared.app_state) : cljs.core.deref.call(null,hatti.shared.app_state))));
var settings_views = cljs.core.cst$kw$all.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$settings.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$views.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.shared.app_state) : cljs.core.deref.call(null,hatti.shared.app_state)))));
if(cljs.core.contains_QMARK_(cljs.core.set(settings_views),settings_section__$1)){
chimera.om.state.merge_into_app_state_BANG_.cljs$core$IFn$_invoke$arity$3(hatti.shared.app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$views], null),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$selected,view__$1], null));

chimera.om.state.merge_into_app_state_BANG_.cljs$core$IFn$_invoke$arity$3(hatti.shared.app_state,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$views,cljs.core.cst$kw$settings], null),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$active_DASH_tab,settings_section__$1], null));

return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$re_DASH_render,view__$1], null));
} else {
return null;
}
});
hatti.views.dataview.activate_integrated_apps_view_BANG_ = (function hatti$views$dataview$activate_integrated_apps_view_BANG_(view,settings_section,app_type){
var view__$1 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(view);
var settings_section__$1 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(settings_section);
var settings_views = cljs.core.cst$kw$all.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$settings.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$views.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.shared.app_state) : cljs.core.deref.call(null,hatti.shared.app_state)))));
if(cljs.core.contains_QMARK_(cljs.core.set(settings_views),settings_section__$1)){
chimera.om.state.transact_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.app_state,((function (view__$1,settings_section__$1,settings_views){
return (function (app_state){
return cljs.core.assoc_in(cljs.core.assoc_in(cljs.core.assoc_in(app_state,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$views,cljs.core.cst$kw$selected], null),view__$1),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$views,cljs.core.cst$kw$settings,cljs.core.cst$kw$active_DASH_tab], null),settings_section__$1),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$views,cljs.core.cst$kw$settings,cljs.core.cst$kw$integrated_DASH_apps,cljs.core.cst$kw$active_DASH_section], null),app_type);
});})(view__$1,settings_section__$1,settings_views))
);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(app_type,hatti.constants.google_sheets)){
chimera.om.state.merge_into_app_state_BANG_.cljs$core$IFn$_invoke$arity$3(hatti.shared.app_state,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$views,cljs.core.cst$kw$settings,cljs.core.cst$kw$integrated_DASH_apps], null),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$add_QMARK_,true], null));
} else {
}

return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$re_DASH_render,view__$1], null));
} else {
return null;
}
});
hatti.views.tabbed_dataview.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (app_state,owner,opts){
if(typeof hatti.views.dataview.t_hatti$views$dataview23436 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.dataview.t_hatti$views$dataview23436 = (function (app_state,owner,opts,meta23437){
this.app_state = app_state;
this.owner = owner;
this.opts = opts;
this.meta23437 = meta23437;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.dataview.t_hatti$views$dataview23436.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_23438,meta23437__$1){
var self__ = this;
var _23438__$1 = this;
return (new hatti.views.dataview.t_hatti$views$dataview23436(self__.app_state,self__.owner,self__.opts,meta23437__$1));
});

hatti.views.dataview.t_hatti$views$dataview23436.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_23438){
var self__ = this;
var _23438__$1 = this;
return self__.meta23437;
});

hatti.views.dataview.t_hatti$views$dataview23436.prototype.om$core$IRender$ = true;

hatti.views.dataview.t_hatti$views$dataview23436.prototype.om$core$IRender$render$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var map__23439 = self__.app_state;
var map__23439__$1 = ((((!((map__23439 == null)))?((((map__23439.cljs$lang$protocol_mask$partition0$ & (64))) || (map__23439.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__23439):map__23439);
var map__23440 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23439__$1,cljs.core.cst$kw$views);
var map__23440__$1 = ((((!((map__23440 == null)))?((((map__23440.cljs$lang$protocol_mask$partition0$ & (64))) || (map__23440.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__23440):map__23440);
var active = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23440__$1,cljs.core.cst$kw$active);
var selected = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23440__$1,cljs.core.cst$kw$selected);
var is_encrypted_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23439__$1,cljs.core.cst$kw$is_DASH_encrypted_QMARK_);
var is_within_pricing_limits_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23439__$1,cljs.core.cst$kw$is_DASH_within_DASH_pricing_DASH_limits_QMARK_);
var view__GT_display = ((function (map__23439,map__23439__$1,map__23440,map__23440__$1,active,selected,is_encrypted_QMARK_,is_within_pricing_limits_QMARK_,___$1){
return (function (p1__23433_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(selected,p1__23433_SHARP_)){
return "block";
} else {
return "none";
}
});})(map__23439,map__23439__$1,map__23440,map__23440__$1,active,selected,is_encrypted_QMARK_,is_within_pricing_limits_QMARK_,___$1))
;
var view__GT_cls = ((function (map__23439,map__23439__$1,map__23440,map__23440__$1,active,selected,is_encrypted_QMARK_,is_within_pricing_limits_QMARK_,view__GT_display,___$1){
return (function (p1__23434_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(selected,p1__23434_SHARP_)){
return "clicked";
} else {
return null;
}
});})(map__23439,map__23439__$1,map__23440,map__23440__$1,active,selected,is_encrypted_QMARK_,is_within_pricing_limits_QMARK_,view__GT_display,___$1))
;
var dataviews = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,cljs.core.map.cljs$core$IFn$_invoke$arity$2((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.views.dataview.view_state) : cljs.core.deref.call(null,hatti.views.dataview.view_state)),cljs.core.cst$kw$all.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$views.cljs$core$IFn$_invoke$arity$1(self__.app_state))));
var dv__GT_link = ((function (map__23439,map__23439__$1,map__23440,map__23440__$1,active,selected,is_encrypted_QMARK_,is_within_pricing_limits_QMARK_,view__GT_display,view__GT_cls,dataviews,___$1){
return (function (p__23443){
var map__23444 = p__23443;
var map__23444__$1 = ((((!((map__23444 == null)))?((((map__23444.cljs$lang$protocol_mask$partition0$ & (64))) || (map__23444.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__23444):map__23444);
var view = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23444__$1,cljs.core.cst$kw$view);
var label = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23444__$1,cljs.core.cst$kw$label);
var active_QMARK_ = cljs.core.some(((function (map__23444,map__23444__$1,view,label,map__23439,map__23439__$1,map__23440,map__23440__$1,active,selected,is_encrypted_QMARK_,is_within_pricing_limits_QMARK_,view__GT_display,view__GT_cls,dataviews,___$1){
return (function (p1__23435_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(view,p1__23435_SHARP_);
});})(map__23444,map__23444__$1,view,label,map__23439,map__23439__$1,map__23440,map__23440__$1,active,selected,is_encrypted_QMARK_,is_within_pricing_limits_QMARK_,view__GT_display,view__GT_cls,dataviews,___$1))
,active);
if(cljs.core.truth_(active_QMARK_)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$class,view__GT_cls(view),cljs.core.cst$kw$href,[cljs.core.str("#/"),cljs.core.str(cljs.core.name(view))].join('')], null),label], null);
} else {
return hatti.views.dataview.view__GT_inactive_tab(view,label,is_encrypted_QMARK_,is_within_pricing_limits_QMARK_);
}
});})(map__23439,map__23439__$1,map__23440,map__23440__$1,active,selected,is_encrypted_QMARK_,is_within_pricing_limits_QMARK_,view__GT_display,view__GT_cls,dataviews,___$1))
;
var G__23447 = ({"className": "tab-container dataset-tabs"});
var G__23448 = (function (){var attrs23446 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(dv__GT_link,dataviews);
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(React.DOM.div,((cljs.core.map_QMARK_(attrs23446))?sablono.interpreter.attributes(sablono.util.merge_with_class.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["tab-bar"], null)], null),attrs23446], 0))):({"className": "tab-bar"})),cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,((cljs.core.map_QMARK_(attrs23446))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret(om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.views.dataview_infobar,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$dataset_DASH_info,cljs.core.cst$kw$dataset_DASH_info.cljs$core$IFn$_invoke$arity$1(self__.app_state),cljs.core.cst$kw$status,cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(self__.app_state)], null)))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret(attrs23446),sablono.interpreter.interpret(om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.views.dataview_infobar,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$dataset_DASH_info,cljs.core.cst$kw$dataset_DASH_info.cljs$core$IFn$_invoke$arity$1(self__.app_state),cljs.core.cst$kw$status,cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(self__.app_state)], null)))], null))));
})();
var G__23449 = cljs.core.into_array.cljs$core$IFn$_invoke$arity$1((function (){var iter__7189__auto__ = ((function (G__23447,G__23448,map__23439,map__23439__$1,map__23440,map__23440__$1,active,selected,is_encrypted_QMARK_,is_within_pricing_limits_QMARK_,view__GT_display,view__GT_cls,dataviews,dv__GT_link,___$1){
return (function hatti$views$dataview$iter__23450(s__23451){
return (new cljs.core.LazySeq(null,((function (G__23447,G__23448,map__23439,map__23439__$1,map__23440,map__23440__$1,active,selected,is_encrypted_QMARK_,is_within_pricing_limits_QMARK_,view__GT_display,view__GT_cls,dataviews,dv__GT_link,___$1){
return (function (){
var s__23451__$1 = s__23451;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__23451__$1);
if(temp__4657__auto__){
var s__23451__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__23451__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__23451__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__23453 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__23452 = (0);
while(true){
if((i__23452 < size__7188__auto__)){
var map__23464 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__23452);
var map__23464__$1 = ((((!((map__23464 == null)))?((((map__23464.cljs$lang$protocol_mask$partition0$ & (64))) || (map__23464.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__23464):map__23464);
var component = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23464__$1,cljs.core.cst$kw$component);
var view = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23464__$1,cljs.core.cst$kw$view);
var view_name = cljs.core.name(view);
cljs.core.chunk_append(b__23453,(function (){var G__23466 = ({"style": ({"display": view__GT_display(view)}), "className": [cljs.core.str("tab-page "),cljs.core.str(view_name),cljs.core.str("-page")].join('')});
var G__23467 = sablono.interpreter.interpret(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(selected,view))?(function (){
chimera.metrics.send_event(cljs.core.cst$kw$Dataview,[cljs.core.str(view_name),cljs.core.str("-page-load")].join(''));

return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$tab_DASH_content,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$id,[cljs.core.str("tab-content"),cljs.core.str(view_name)].join('')], null),om.core.build.cljs$core$IFn$_invoke$arity$3(component,self__.app_state,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$opts,self__.opts], null))], null);
})()
:null));
return React.DOM.div(G__23466,G__23467);
})());

var G__23472 = (i__23452 + (1));
i__23452 = G__23472;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__23453),hatti$views$dataview$iter__23450(cljs.core.chunk_rest(s__23451__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__23453),null);
}
} else {
var map__23468 = cljs.core.first(s__23451__$2);
var map__23468__$1 = ((((!((map__23468 == null)))?((((map__23468.cljs$lang$protocol_mask$partition0$ & (64))) || (map__23468.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__23468):map__23468);
var component = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23468__$1,cljs.core.cst$kw$component);
var view = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23468__$1,cljs.core.cst$kw$view);
var view_name = cljs.core.name(view);
return cljs.core.cons((function (){var G__23470 = ({"style": ({"display": view__GT_display(view)}), "className": [cljs.core.str("tab-page "),cljs.core.str(view_name),cljs.core.str("-page")].join('')});
var G__23471 = sablono.interpreter.interpret(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(selected,view))?(function (){
chimera.metrics.send_event(cljs.core.cst$kw$Dataview,[cljs.core.str(view_name),cljs.core.str("-page-load")].join(''));

return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$tab_DASH_content,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$id,[cljs.core.str("tab-content"),cljs.core.str(view_name)].join('')], null),om.core.build.cljs$core$IFn$_invoke$arity$3(component,self__.app_state,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$opts,self__.opts], null))], null);
})()
:null));
return React.DOM.div(G__23470,G__23471);
})(),hatti$views$dataview$iter__23450(cljs.core.rest(s__23451__$2)));
}
} else {
return null;
}
break;
}
});})(G__23447,G__23448,map__23439,map__23439__$1,map__23440,map__23440__$1,active,selected,is_encrypted_QMARK_,is_within_pricing_limits_QMARK_,view__GT_display,view__GT_cls,dataviews,dv__GT_link,___$1))
,null,null));
});})(G__23447,G__23448,map__23439,map__23439__$1,map__23440,map__23440__$1,active,selected,is_encrypted_QMARK_,is_within_pricing_limits_QMARK_,view__GT_display,view__GT_cls,dataviews,dv__GT_link,___$1))
;
return iter__7189__auto__(dataviews);
})());
return React.DOM.div(G__23447,G__23448,G__23449);
});

hatti.views.dataview.t_hatti$views$dataview23436.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$app_DASH_state,cljs.core.cst$sym$owner,cljs.core.cst$sym$opts,cljs.core.cst$sym$meta23437], null);
});

hatti.views.dataview.t_hatti$views$dataview23436.cljs$lang$type = true;

hatti.views.dataview.t_hatti$views$dataview23436.cljs$lang$ctorStr = "hatti.views.dataview/t_hatti$views$dataview23436";

hatti.views.dataview.t_hatti$views$dataview23436.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"hatti.views.dataview/t_hatti$views$dataview23436");
});

hatti.views.dataview.__GT_t_hatti$views$dataview23436 = (function hatti$views$dataview$__GT_t_hatti$views$dataview23436(app_state__$1,owner__$1,opts__$1,meta23437){
return (new hatti.views.dataview.t_hatti$views$dataview23436(app_state__$1,owner__$1,opts__$1,meta23437));
});

}

return (new hatti.views.dataview.t_hatti$views$dataview23436(app_state,owner,opts,cljs.core.PersistentArrayMap.EMPTY));
}));
