// Compiled by ClojureScript 1.9.229 {:static-fns true, :optimize-constants true}
goog.provide('hatti.views.record');
goog.require('cljs.core');
goog.require('chimera.js_interop');
goog.require('sablono.core');
goog.require('cljs.core.async');
goog.require('hatti.shared');
goog.require('hatti.ona.forms');
goog.require('hatti.constants');
goog.require('clojure.string');
goog.require('hatti.views');
goog.require('om.core');
goog.require('hatti.utils');
goog.require('chimera.urls');
/**
 * Wrap-with produces a partial to wrap a set of children.
 * ((wrap-with :div) 1 2 3) => [:div [1 2 3]]
 * ((wrap-with [:div {:class 0}]) 1 2 3) => [:div {:class 0} [1 2 3]]
 */
hatti.views.record.wrap_with = (function hatti$views$record$wrap_with(root){
return (function() { 
var G__19538__delegate = function (children){
if((root instanceof cljs.core.Keyword)){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [root], null),children);
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(root,children);
}
};
var G__19538 = function (var_args){
var children = null;
if (arguments.length > 0) {
var G__19539__i = 0, G__19539__a = new Array(arguments.length -  0);
while (G__19539__i < G__19539__a.length) {G__19539__a[G__19539__i] = arguments[G__19539__i + 0]; ++G__19539__i;}
  children = new cljs.core.IndexedSeq(G__19539__a,0);
} 
return G__19538__delegate.call(this,children);};
G__19538.cljs$lang$maxFixedArity = 0;
G__19538.cljs$lang$applyTo = (function (arglist__19540){
var children = cljs.core.seq(arglist__19540);
return G__19538__delegate(children);
});
G__19538.cljs$core$IFn$_invoke$arity$variadic = G__19538__delegate;
return G__19538;
})()
;
});
hatti.views.record.submission_arrow = (function hatti$views$record$submission_arrow(dir,cur_rank,view){
var icon = [cljs.core.str("fa fa-arrow-"),cljs.core.str(cljs.core.name(dir))].join('');
var new_rank = (function (){var G__19549 = (((dir instanceof cljs.core.Keyword))?dir.fqn:null);
switch (G__19549) {
case "left":
return cljs.core.dec;

break;
case "right":
return cljs.core.inc;

break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(dir)].join('')));

}
})().call(null,cur_rank);
var event_key = (function (){var pred__19550 = cljs.core._EQ_;
var expr__19551 = view;
if(cljs.core.truth_((function (){var G__19553 = cljs.core.cst$kw$map;
var G__19554 = expr__19551;
return (pred__19550.cljs$core$IFn$_invoke$arity$2 ? pred__19550.cljs$core$IFn$_invoke$arity$2(G__19553,G__19554) : pred__19550.call(null,G__19553,G__19554));
})())){
return cljs.core.cst$kw$mapped_DASH_submission_DASH_to_DASH_rank;
} else {
if(cljs.core.truth_((function (){var G__19555 = cljs.core.cst$kw$table;
var G__19556 = expr__19551;
return (pred__19550.cljs$core$IFn$_invoke$arity$2 ? pred__19550.cljs$core$IFn$_invoke$arity$2(G__19555,G__19556) : pred__19550.call(null,G__19555,G__19556));
})())){
return cljs.core.cst$kw$submission_DASH_to_DASH_rank;
} else {
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(expr__19551)].join('')));
}
}
})();
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a$pure_DASH_button$btn_DASH_default,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$on_DASH_click,hatti.utils.click_fn(((function (icon,new_rank,event_key){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_chan,cljs.core.PersistentArrayMap.fromArray([event_key,new_rank], true, false));
});})(icon,new_rank,event_key))
),cljs.core.cst$kw$href,"#"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$i,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,icon], null)], null)], null);
});
hatti.views.record.submission_closer = (function hatti$views$record$submission_closer(){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a$btn_DASH_close$right,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$on_DASH_click,hatti.utils.click_fn((function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$submission_DASH_unclicked,true], null));
})),cljs.core.cst$kw$href,"#"], null),"\u00D7"], null);
});
hatti.views.print_xls_report_btn.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (cursor,owner){
if(typeof hatti.views.record.t_hatti$views$record19558 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.record.t_hatti$views$record19558 = (function (cursor,owner,meta19559){
this.cursor = cursor;
this.owner = owner;
this.meta19559 = meta19559;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.record.t_hatti$views$record19558.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_19560,meta19559__$1){
var self__ = this;
var _19560__$1 = this;
return (new hatti.views.record.t_hatti$views$record19558(self__.cursor,self__.owner,meta19559__$1));
});

hatti.views.record.t_hatti$views$record19558.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_19560){
var self__ = this;
var _19560__$1 = this;
return self__.meta19559;
});

hatti.views.record.t_hatti$views$record19558.prototype.om$core$IRender$ = true;

hatti.views.record.t_hatti$views$record19558.prototype.om$core$IRender$render$arity$1 = (function (this__15775__auto__){
var self__ = this;
var this__15775__auto____$1 = this;
var G__19563 = ({"id": "print-xls-report"});
return React.DOM.div(G__19563);
});

hatti.views.record.t_hatti$views$record19558.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$cursor,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta19559], null);
});

hatti.views.record.t_hatti$views$record19558.cljs$lang$type = true;

hatti.views.record.t_hatti$views$record19558.cljs$lang$ctorStr = "hatti.views.record/t_hatti$views$record19558";

hatti.views.record.t_hatti$views$record19558.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"hatti.views.record/t_hatti$views$record19558");
});

hatti.views.record.__GT_t_hatti$views$record19558 = (function hatti$views$record$__GT_t_hatti$views$record19558(cursor__$1,owner__$1,meta19559){
return (new hatti.views.record.t_hatti$views$record19558(cursor__$1,owner__$1,meta19559));
});

}

return (new hatti.views.record.t_hatti$views$record19558(cursor,owner,null));
}));
hatti.views.record.qa_elements = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$map,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$row_DASH_el,cljs.core.cst$kw$div$question_DASH_answer,cljs.core.cst$kw$question_DASH_el,cljs.core.cst$kw$span$question,cljs.core.cst$kw$answer_DASH_el,cljs.core.cst$kw$span$answer], null),cljs.core.cst$kw$table,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$row_DASH_el,cljs.core.cst$kw$tr$question_DASH_answer,cljs.core.cst$kw$question_DASH_el,cljs.core.cst$kw$td$question,cljs.core.cst$kw$answer_DASH_el,cljs.core.cst$kw$td$answer], null)], null);
hatti.views.record.format_as_question_answer = (function hatti$views$record$format_as_question_answer(view,field,data,lang){
var fname = cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(field);
var flabel = hatti.ona.forms.get_label.cljs$core$IFn$_invoke$arity$variadic(field,cljs.core.array_seq([lang], 0));
var answer = cljs.core.get.cljs$core$IFn$_invoke$arity$2(data,fname);
var alabel = hatti.ona.forms.format_answer.cljs$core$IFn$_invoke$arity$variadic(field,answer,cljs.core.array_seq([cljs.core.cst$kw$language,lang], 0));
var map__19566 = (hatti.views.record.qa_elements.cljs$core$IFn$_invoke$arity$1 ? hatti.views.record.qa_elements.cljs$core$IFn$_invoke$arity$1(view) : hatti.views.record.qa_elements.call(null,view));
var map__19566__$1 = ((((!((map__19566 == null)))?((((map__19566.cljs$lang$protocol_mask$partition0$ & (64))) || (map__19566.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__19566):map__19566);
var row_el = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19566__$1,cljs.core.cst$kw$row_DASH_el);
var question_el = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19566__$1,cljs.core.cst$kw$question_DASH_el);
var answer_el = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19566__$1,cljs.core.cst$kw$answer_DASH_el);
if(cljs.core.truth_((function (){var and__6397__auto__ = alabel;
if(cljs.core.truth_(and__6397__auto__)){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(alabel,hatti.ona.forms.no_answer);
} else {
return and__6397__auto__;
}
})())){
if(cljs.core.truth_(hatti.ona.forms.repeat_QMARK_(field))){
return om.core.build.cljs$core$IFn$_invoke$arity$3(hatti.views.repeat_view,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$data,answer,cljs.core.cst$kw$repeat_DASH_field,field,cljs.core.cst$kw$lang,lang], null),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$opts,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$view,view], null)], null));
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [row_el,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [question_el,flabel], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [answer_el,alabel], null)], null);
}
} else {
return null;
}
});
hatti.views.record.submission_elements = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$map,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$top_DASH_level_DASH_wrap,hatti.views.record.wrap_with(cljs.core.cst$kw$div$legend$infobar$submission$top$right),cljs.core.cst$kw$topbar_DASH_wrap,hatti.views.record.wrap_with(cljs.core.cst$kw$div$border_DASH_bottom$legend_DASH_topbar),cljs.core.cst$kw$header_DASH_wrap,hatti.views.record.wrap_with(cljs.core.cst$kw$div$border_DASH_bottom$submission_DASH_header),cljs.core.cst$kw$submission_DASH_info_DASH_wrap,hatti.views.record.wrap_with(cljs.core.cst$kw$div$submission$info_DASH_scroll),cljs.core.cst$kw$section_DASH_wrap,hatti.views.record.wrap_with(cljs.core.cst$kw$div$border_DASH_bottom),cljs.core.cst$kw$h4_DASH_cls,"t-red"], null),cljs.core.cst$kw$table,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$top_DASH_level_DASH_wrap,hatti.views.record.wrap_with(cljs.core.cst$kw$div$widget_DASH_info_SHARP_single_DASH_submission_DASH_info),cljs.core.cst$kw$topbar_DASH_wrap,hatti.views.record.wrap_with(cljs.core.cst$kw$div$topbar),cljs.core.cst$kw$header_DASH_wrap,hatti.views.record.wrap_with(cljs.core.cst$kw$div$header),cljs.core.cst$kw$submission_DASH_info_DASH_wrap,(function() { 
var G__19568__delegate = function (tbody){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$submission,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$table$pure_DASH_table$pure_DASH_table_DASH_bordered,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$thead,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$tr,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$th,"Question"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$th,"Response"], null)], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$tbody,tbody], null)], null)], null);
};
var G__19568 = function (var_args){
var tbody = null;
if (arguments.length > 0) {
var G__19569__i = 0, G__19569__a = new Array(arguments.length -  0);
while (G__19569__i < G__19569__a.length) {G__19569__a[G__19569__i] = arguments[G__19569__i + 0]; ++G__19569__i;}
  tbody = new cljs.core.IndexedSeq(G__19569__a,0);
} 
return G__19568__delegate.call(this,tbody);};
G__19568.cljs$lang$maxFixedArity = 0;
G__19568.cljs$lang$applyTo = (function (arglist__19570){
var tbody = cljs.core.seq(arglist__19570);
return G__19568__delegate(tbody);
});
G__19568.cljs$core$IFn$_invoke$arity$variadic = G__19568__delegate;
return G__19568;
})()
,cljs.core.cst$kw$section_DASH_wrap,cljs.core.identity,cljs.core.cst$kw$show_DASH_instance_DASH_id,true,cljs.core.cst$kw$h4_DASH_cls,""], null)], null);
hatti.views.repeat_view.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (p__19572,owner,p__19573){
var map__19574 = p__19572;
var map__19574__$1 = ((((!((map__19574 == null)))?((((map__19574.cljs$lang$protocol_mask$partition0$ & (64))) || (map__19574.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__19574):map__19574);
var data = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19574__$1,cljs.core.cst$kw$data);
var repeat_field = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19574__$1,cljs.core.cst$kw$repeat_DASH_field);
var lang = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19574__$1,cljs.core.cst$kw$lang);
var map__19575 = p__19573;
var map__19575__$1 = ((((!((map__19575 == null)))?((((map__19575.cljs$lang$protocol_mask$partition0$ & (64))) || (map__19575.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__19575):map__19575);
var view = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19575__$1,cljs.core.cst$kw$view);

if(typeof hatti.views.record.t_hatti$views$record19578 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRenderState}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IInitState}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.record.t_hatti$views$record19578 = (function (p__19572,owner,p__19573,map__19574,data,repeat_field,lang,map__19575,view,meta19579){
this.p__19572 = p__19572;
this.owner = owner;
this.p__19573 = p__19573;
this.map__19574 = map__19574;
this.data = data;
this.repeat_field = repeat_field;
this.lang = lang;
this.map__19575 = map__19575;
this.view = view;
this.meta19579 = meta19579;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.record.t_hatti$views$record19578.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (map__19574,map__19574__$1,data,repeat_field,lang,map__19575,map__19575__$1,view){
return (function (_19580,meta19579__$1){
var self__ = this;
var _19580__$1 = this;
return (new hatti.views.record.t_hatti$views$record19578(self__.p__19572,self__.owner,self__.p__19573,self__.map__19574,self__.data,self__.repeat_field,self__.lang,self__.map__19575,self__.view,meta19579__$1));
});})(map__19574,map__19574__$1,data,repeat_field,lang,map__19575,map__19575__$1,view))
;

hatti.views.record.t_hatti$views$record19578.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (map__19574,map__19574__$1,data,repeat_field,lang,map__19575,map__19575__$1,view){
return (function (_19580){
var self__ = this;
var _19580__$1 = this;
return self__.meta19579;
});})(map__19574,map__19574__$1,data,repeat_field,lang,map__19575,map__19575__$1,view))
;

hatti.views.record.t_hatti$views$record19578.prototype.om$core$IInitState$ = true;

hatti.views.record.t_hatti$views$record19578.prototype.om$core$IInitState$init_state$arity$1 = ((function (map__19574,map__19574__$1,data,repeat_field,lang,map__19575,map__19575__$1,view){
return (function (_){
var self__ = this;
var ___$1 = this;
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$collapsed_QMARK_,true], null);
});})(map__19574,map__19574__$1,data,repeat_field,lang,map__19575,map__19575__$1,view))
;

hatti.views.record.t_hatti$views$record19578.prototype.om$core$IRenderState$ = true;

hatti.views.record.t_hatti$views$record19578.prototype.om$core$IRenderState$render_state$arity$2 = ((function (map__19574,map__19574__$1,data,repeat_field,lang,map__19575,map__19575__$1,view){
return (function (_,p__19581){
var self__ = this;
var map__19582 = p__19581;
var map__19582__$1 = ((((!((map__19582 == null)))?((((map__19582.cljs$lang$protocol_mask$partition0$ & (64))) || (map__19582.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__19582):map__19582);
var collapsed_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19582__$1,cljs.core.cst$kw$collapsed_QMARK_);
var ___$1 = this;
if(cljs.core.seq(self__.data)){
var collapse_BANG_ = ((function (___$1,map__19582,map__19582__$1,collapsed_QMARK_,map__19574,map__19574__$1,data,repeat_field,lang,map__19575,map__19575__$1,view){
return (function (p1__19571_SHARP_){
return om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(self__.owner,cljs.core.cst$kw$collapsed_QMARK_,p1__19571_SHARP_);
});})(___$1,map__19582,map__19582__$1,collapsed_QMARK_,map__19574,map__19574__$1,data,repeat_field,lang,map__19575,map__19575__$1,view))
;
var map__19584 = (hatti.views.record.qa_elements.cljs$core$IFn$_invoke$arity$1 ? hatti.views.record.qa_elements.cljs$core$IFn$_invoke$arity$1(self__.view) : hatti.views.record.qa_elements.call(null,self__.view));
var map__19584__$1 = ((((!((map__19584 == null)))?((((map__19584.cljs$lang$protocol_mask$partition0$ & (64))) || (map__19584.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__19584):map__19584);
var row_el = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19584__$1,cljs.core.cst$kw$row_DASH_el);
var question_el = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19584__$1,cljs.core.cst$kw$question_DASH_el);
var answer_el = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19584__$1,cljs.core.cst$kw$answer_DASH_el);
var header = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [row_el,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [question_el,hatti.ona.forms.get_label.cljs$core$IFn$_invoke$arity$variadic(self__.repeat_field,cljs.core.array_seq([self__.lang], 0))], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [answer_el,[cljs.core.str(hatti.utils.pluralize_number(cljs.core.count(self__.data)," Repeat")),cljs.core.str(" - ")].join(''),(cljs.core.truth_(collapsed_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$on_DASH_click,hatti.utils.click_fn(((function (collapse_BANG_,map__19584,map__19584__$1,row_el,question_el,answer_el,___$1,map__19582,map__19582__$1,collapsed_QMARK_,map__19574,map__19574__$1,data,repeat_field,lang,map__19575,map__19575__$1,view){
return (function (){
return collapse_BANG_(false);
});})(collapse_BANG_,map__19584,map__19584__$1,row_el,question_el,answer_el,___$1,map__19582,map__19582__$1,collapsed_QMARK_,map__19574,map__19574__$1,data,repeat_field,lang,map__19575,map__19575__$1,view))
),cljs.core.cst$kw$href,"#"], null),"Show Repeats"], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$on_DASH_click,hatti.utils.click_fn(((function (collapse_BANG_,map__19584,map__19584__$1,row_el,question_el,answer_el,___$1,map__19582,map__19582__$1,collapsed_QMARK_,map__19574,map__19574__$1,data,repeat_field,lang,map__19575,map__19575__$1,view){
return (function (){
return collapse_BANG_(true);
});})(collapse_BANG_,map__19584,map__19584__$1,row_el,question_el,answer_el,___$1,map__19582,map__19582__$1,collapsed_QMARK_,map__19574,map__19574__$1,data,repeat_field,lang,map__19575,map__19575__$1,view))
),cljs.core.cst$kw$href,"#"], null),"Hide Repeats"], null))], null)], null);
var fname = cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(self__.repeat_field);
var render_child = ((function (collapse_BANG_,map__19584,map__19584__$1,row_el,question_el,answer_el,header,fname,___$1,map__19582,map__19582__$1,collapsed_QMARK_,map__19574,map__19574__$1,data,repeat_field,lang,map__19575,map__19575__$1,view){
return (function (d){
var iter__7189__auto__ = ((function (collapse_BANG_,map__19584,map__19584__$1,row_el,question_el,answer_el,header,fname,___$1,map__19582,map__19582__$1,collapsed_QMARK_,map__19574,map__19574__$1,data,repeat_field,lang,map__19575,map__19575__$1,view){
return (function hatti$views$record$iter__19586(s__19587){
return (new cljs.core.LazySeq(null,((function (collapse_BANG_,map__19584,map__19584__$1,row_el,question_el,answer_el,header,fname,___$1,map__19582,map__19582__$1,collapsed_QMARK_,map__19574,map__19574__$1,data,repeat_field,lang,map__19575,map__19575__$1,view){
return (function (){
var s__19587__$1 = s__19587;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__19587__$1);
if(temp__4657__auto__){
var s__19587__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__19587__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__19587__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__19589 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__19588 = (0);
while(true){
if((i__19588 < size__7188__auto__)){
var field = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__19588);
cljs.core.chunk_append(b__19589,hatti.views.record.format_as_question_answer(self__.view,field,d,self__.lang));

var G__19605 = (i__19588 + (1));
i__19588 = G__19605;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__19589),hatti$views$record$iter__19586(cljs.core.chunk_rest(s__19587__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__19589),null);
}
} else {
var field = cljs.core.first(s__19587__$2);
return cljs.core.cons(hatti.views.record.format_as_question_answer(self__.view,field,d,self__.lang),hatti$views$record$iter__19586(cljs.core.rest(s__19587__$2)));
}
} else {
return null;
}
break;
}
});})(collapse_BANG_,map__19584,map__19584__$1,row_el,question_el,answer_el,header,fname,___$1,map__19582,map__19582__$1,collapsed_QMARK_,map__19574,map__19574__$1,data,repeat_field,lang,map__19575,map__19575__$1,view))
,null,null));
});})(collapse_BANG_,map__19584,map__19584__$1,row_el,question_el,answer_el,header,fname,___$1,map__19582,map__19582__$1,collapsed_QMARK_,map__19574,map__19574__$1,data,repeat_field,lang,map__19575,map__19575__$1,view))
;
return iter__7189__auto__(cljs.core.cst$kw$children.cljs$core$IFn$_invoke$arity$1(self__.repeat_field));
});})(collapse_BANG_,map__19584,map__19584__$1,row_el,question_el,answer_el,header,fname,___$1,map__19582,map__19582__$1,collapsed_QMARK_,map__19574,map__19574__$1,data,repeat_field,lang,map__19575,map__19575__$1,view))
;
var tbl = ((function (collapse_BANG_,map__19584,map__19584__$1,row_el,question_el,answer_el,header,fname,render_child,___$1,map__19582,map__19582__$1,collapsed_QMARK_,map__19574,map__19574__$1,data,repeat_field,lang,map__19575,map__19575__$1,view){
return (function() { 
var G__19606__delegate = function (cls,body){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$tr,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,cls], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$td$no_DASH_pad,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$col_DASH_span,(2)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$table,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,cls], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$tbody,body], null)], null)], null)], null);
};
var G__19606 = function (cls,var_args){
var body = null;
if (arguments.length > 1) {
var G__19607__i = 0, G__19607__a = new Array(arguments.length -  1);
while (G__19607__i < G__19607__a.length) {G__19607__a[G__19607__i] = arguments[G__19607__i + 1]; ++G__19607__i;}
  body = new cljs.core.IndexedSeq(G__19607__a,0);
} 
return G__19606__delegate.call(this,cls,body);};
G__19606.cljs$lang$maxFixedArity = 1;
G__19606.cljs$lang$applyTo = (function (arglist__19608){
var cls = cljs.core.first(arglist__19608);
var body = cljs.core.rest(arglist__19608);
return G__19606__delegate(cls,body);
});
G__19606.cljs$core$IFn$_invoke$arity$variadic = G__19606__delegate;
return G__19606;
})()
;})(collapse_BANG_,map__19584,map__19584__$1,row_el,question_el,answer_el,header,fname,render_child,___$1,map__19582,map__19582__$1,collapsed_QMARK_,map__19574,map__19574__$1,data,repeat_field,lang,map__19575,map__19575__$1,view))
;
if(cljs.core.truth_(collapsed_QMARK_)){
return sablono.interpreter.interpret(header);
} else {
return sablono.interpreter.interpret((function (){var G__19592 = (((self__.view instanceof cljs.core.Keyword))?self__.view.fqn:null);
switch (G__19592) {
case "map":
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$repeat_DASH_block,header,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$ol$repeat,(function (){var iter__7189__auto__ = ((function (G__19592,collapse_BANG_,map__19584,map__19584__$1,row_el,question_el,answer_el,header,fname,render_child,tbl,___$1,map__19582,map__19582__$1,collapsed_QMARK_,map__19574,map__19574__$1,data,repeat_field,lang,map__19575,map__19575__$1,view){
return (function hatti$views$record$iter__19593(s__19594){
return (new cljs.core.LazySeq(null,((function (G__19592,collapse_BANG_,map__19584,map__19584__$1,row_el,question_el,answer_el,header,fname,render_child,tbl,___$1,map__19582,map__19582__$1,collapsed_QMARK_,map__19574,map__19574__$1,data,repeat_field,lang,map__19575,map__19575__$1,view){
return (function (){
var s__19594__$1 = s__19594;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__19594__$1);
if(temp__4657__auto__){
var s__19594__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__19594__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__19594__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__19596 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__19595 = (0);
while(true){
if((i__19595 < size__7188__auto__)){
var d = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__19595);
cljs.core.chunk_append(b__19596,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,render_child(d)], null));

var G__19610 = (i__19595 + (1));
i__19595 = G__19610;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__19596),hatti$views$record$iter__19593(cljs.core.chunk_rest(s__19594__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__19596),null);
}
} else {
var d = cljs.core.first(s__19594__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,render_child(d)], null),hatti$views$record$iter__19593(cljs.core.rest(s__19594__$2)));
}
} else {
return null;
}
break;
}
});})(G__19592,collapse_BANG_,map__19584,map__19584__$1,row_el,question_el,answer_el,header,fname,render_child,tbl,___$1,map__19582,map__19582__$1,collapsed_QMARK_,map__19574,map__19574__$1,data,repeat_field,lang,map__19575,map__19575__$1,view))
,null,null));
});})(G__19592,collapse_BANG_,map__19584,map__19584__$1,row_el,question_el,answer_el,header,fname,render_child,tbl,___$1,map__19582,map__19582__$1,collapsed_QMARK_,map__19574,map__19574__$1,data,repeat_field,lang,map__19575,map__19575__$1,view))
;
return iter__7189__auto__(self__.data);
})()], null)], null);

break;
case "table":
return tbl.cljs$core$IFn$_invoke$arity$variadic("repeat-block",cljs.core.array_seq([header,(function (){var iter__7189__auto__ = ((function (G__19592,collapse_BANG_,map__19584,map__19584__$1,row_el,question_el,answer_el,header,fname,render_child,tbl,___$1,map__19582,map__19582__$1,collapsed_QMARK_,map__19574,map__19574__$1,data,repeat_field,lang,map__19575,map__19575__$1,view){
return (function hatti$views$record$iter__19599(s__19600){
return (new cljs.core.LazySeq(null,((function (G__19592,collapse_BANG_,map__19584,map__19584__$1,row_el,question_el,answer_el,header,fname,render_child,tbl,___$1,map__19582,map__19582__$1,collapsed_QMARK_,map__19574,map__19574__$1,data,repeat_field,lang,map__19575,map__19575__$1,view){
return (function (){
var s__19600__$1 = s__19600;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__19600__$1);
if(temp__4657__auto__){
var s__19600__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__19600__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__19600__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__19602 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__19601 = (0);
while(true){
if((i__19601 < size__7188__auto__)){
var d = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__19601);
cljs.core.chunk_append(b__19602,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$tbody$repeat,render_child(d)], null));

var G__19611 = (i__19601 + (1));
i__19601 = G__19611;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__19602),hatti$views$record$iter__19599(cljs.core.chunk_rest(s__19600__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__19602),null);
}
} else {
var d = cljs.core.first(s__19600__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$tbody$repeat,render_child(d)], null),hatti$views$record$iter__19599(cljs.core.rest(s__19600__$2)));
}
} else {
return null;
}
break;
}
});})(G__19592,collapse_BANG_,map__19584,map__19584__$1,row_el,question_el,answer_el,header,fname,render_child,tbl,___$1,map__19582,map__19582__$1,collapsed_QMARK_,map__19574,map__19574__$1,data,repeat_field,lang,map__19575,map__19575__$1,view))
,null,null));
});})(G__19592,collapse_BANG_,map__19584,map__19584__$1,row_el,question_el,answer_el,header,fname,render_child,tbl,___$1,map__19582,map__19582__$1,collapsed_QMARK_,map__19574,map__19574__$1,data,repeat_field,lang,map__19575,map__19575__$1,view))
;
return iter__7189__auto__(self__.data);
})()], 0));

break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(self__.view)].join('')));

}
})());
}
} else {
return null;
}
});})(map__19574,map__19574__$1,data,repeat_field,lang,map__19575,map__19575__$1,view))
;

hatti.views.record.t_hatti$views$record19578.getBasis = ((function (map__19574,map__19574__$1,data,repeat_field,lang,map__19575,map__19575__$1,view){
return (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p__19572,cljs.core.cst$sym$owner,cljs.core.cst$sym$p__19573,cljs.core.cst$sym$map__19574,cljs.core.cst$sym$data,cljs.core.cst$sym$repeat_DASH_field,cljs.core.cst$sym$lang,cljs.core.cst$sym$map__19575,cljs.core.cst$sym$view,cljs.core.cst$sym$meta19579], null);
});})(map__19574,map__19574__$1,data,repeat_field,lang,map__19575,map__19575__$1,view))
;

hatti.views.record.t_hatti$views$record19578.cljs$lang$type = true;

hatti.views.record.t_hatti$views$record19578.cljs$lang$ctorStr = "hatti.views.record/t_hatti$views$record19578";

hatti.views.record.t_hatti$views$record19578.cljs$lang$ctorPrWriter = ((function (map__19574,map__19574__$1,data,repeat_field,lang,map__19575,map__19575__$1,view){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"hatti.views.record/t_hatti$views$record19578");
});})(map__19574,map__19574__$1,data,repeat_field,lang,map__19575,map__19575__$1,view))
;

hatti.views.record.__GT_t_hatti$views$record19578 = ((function (map__19574,map__19574__$1,data,repeat_field,lang,map__19575,map__19575__$1,view){
return (function hatti$views$record$__GT_t_hatti$views$record19578(p__19572__$1,owner__$1,p__19573__$1,map__19574__$2,data__$1,repeat_field__$1,lang__$1,map__19575__$2,view__$1,meta19579){
return (new hatti.views.record.t_hatti$views$record19578(p__19572__$1,owner__$1,p__19573__$1,map__19574__$2,data__$1,repeat_field__$1,lang__$1,map__19575__$2,view__$1,meta19579));
});})(map__19574,map__19574__$1,data,repeat_field,lang,map__19575,map__19575__$1,view))
;

}

return (new hatti.views.record.t_hatti$views$record19578(p__19572,owner,p__19573,map__19574__$1,data,repeat_field,lang,map__19575__$1,view,cljs.core.PersistentArrayMap.EMPTY));
}));
hatti.views.record.header_note = (function hatti$views$record$header_note(view,p__19612){
var map__19615 = p__19612;
var map__19615__$1 = ((((!((map__19615 == null)))?((((map__19615.cljs$lang$protocol_mask$partition0$ & (64))) || (map__19615.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__19615):map__19615);
var geofield = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19615__$1,cljs.core.cst$kw$geofield);
var data = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19615__$1,cljs.core.cst$kw$data);
if((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(view,cljs.core.cst$kw$map)) && (cljs.core.not(cljs.core.get.cljs$core$IFn$_invoke$arity$2(data,cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(geofield))))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$no_DASH_geo$t_DASH_normal$right,"No geodata"], null);
} else {
return null;
}
});
hatti.views.edit_delete.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (instance_id,owner,p__19617){
var map__19618 = p__19617;
var map__19618__$1 = ((((!((map__19618 == null)))?((((map__19618.cljs$lang$protocol_mask$partition0$ & (64))) || (map__19618.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__19618):map__19618);
var delete_record_BANG_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19618__$1,cljs.core.cst$kw$delete_DASH_record_BANG_);
if(typeof hatti.views.record.t_hatti$views$record19620 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.record.t_hatti$views$record19620 = (function (instance_id,owner,p__19617,map__19618,delete_record_BANG_,meta19621){
this.instance_id = instance_id;
this.owner = owner;
this.p__19617 = p__19617;
this.map__19618 = map__19618;
this.delete_record_BANG_ = delete_record_BANG_;
this.meta19621 = meta19621;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.record.t_hatti$views$record19620.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (map__19618,map__19618__$1,delete_record_BANG_){
return (function (_19622,meta19621__$1){
var self__ = this;
var _19622__$1 = this;
return (new hatti.views.record.t_hatti$views$record19620(self__.instance_id,self__.owner,self__.p__19617,self__.map__19618,self__.delete_record_BANG_,meta19621__$1));
});})(map__19618,map__19618__$1,delete_record_BANG_))
;

hatti.views.record.t_hatti$views$record19620.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (map__19618,map__19618__$1,delete_record_BANG_){
return (function (_19622){
var self__ = this;
var _19622__$1 = this;
return self__.meta19621;
});})(map__19618,map__19618__$1,delete_record_BANG_))
;

hatti.views.record.t_hatti$views$record19620.prototype.om$core$IRender$ = true;

hatti.views.record.t_hatti$views$record19620.prototype.om$core$IRender$render$arity$1 = ((function (map__19618,map__19618__$1,delete_record_BANG_){
return (function (this__15775__auto__){
var self__ = this;
var this__15775__auto____$1 = this;
return null;
});})(map__19618,map__19618__$1,delete_record_BANG_))
;

hatti.views.record.t_hatti$views$record19620.getBasis = ((function (map__19618,map__19618__$1,delete_record_BANG_){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$instance_DASH_id,cljs.core.cst$sym$owner,cljs.core.cst$sym$p__19617,cljs.core.cst$sym$map__19618,cljs.core.cst$sym$delete_DASH_record_BANG_,cljs.core.cst$sym$meta19621], null);
});})(map__19618,map__19618__$1,delete_record_BANG_))
;

hatti.views.record.t_hatti$views$record19620.cljs$lang$type = true;

hatti.views.record.t_hatti$views$record19620.cljs$lang$ctorStr = "hatti.views.record/t_hatti$views$record19620";

hatti.views.record.t_hatti$views$record19620.cljs$lang$ctorPrWriter = ((function (map__19618,map__19618__$1,delete_record_BANG_){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"hatti.views.record/t_hatti$views$record19620");
});})(map__19618,map__19618__$1,delete_record_BANG_))
;

hatti.views.record.__GT_t_hatti$views$record19620 = ((function (map__19618,map__19618__$1,delete_record_BANG_){
return (function hatti$views$record$__GT_t_hatti$views$record19620(instance_id__$1,owner__$1,p__19617__$1,map__19618__$2,delete_record_BANG___$1,meta19621){
return (new hatti.views.record.t_hatti$views$record19620(instance_id__$1,owner__$1,p__19617__$1,map__19618__$2,delete_record_BANG___$1,meta19621));
});})(map__19618,map__19618__$1,delete_record_BANG_))
;

}

return (new hatti.views.record.t_hatti$views$record19620(instance_id,owner,p__19617,map__19618__$1,delete_record_BANG_,null));
}));
hatti.views.submission_view.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (cursor,owner,p__19623){
var map__19624 = p__19623;
var map__19624__$1 = ((((!((map__19624 == null)))?((((map__19624.cljs$lang$protocol_mask$partition0$ & (64))) || (map__19624.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__19624):map__19624);
var opts = map__19624__$1;
var view = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19624__$1,cljs.core.cst$kw$view);
if(typeof hatti.views.record.t_hatti$views$record19626 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRenderState}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IInitState}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.record.t_hatti$views$record19626 = (function (cursor,owner,p__19623,map__19624,opts,view,meta19627){
this.cursor = cursor;
this.owner = owner;
this.p__19623 = p__19623;
this.map__19624 = map__19624;
this.opts = opts;
this.view = view;
this.meta19627 = meta19627;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.record.t_hatti$views$record19626.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (map__19624,map__19624__$1,opts,view){
return (function (_19628,meta19627__$1){
var self__ = this;
var _19628__$1 = this;
return (new hatti.views.record.t_hatti$views$record19626(self__.cursor,self__.owner,self__.p__19623,self__.map__19624,self__.opts,self__.view,meta19627__$1));
});})(map__19624,map__19624__$1,opts,view))
;

hatti.views.record.t_hatti$views$record19626.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (map__19624,map__19624__$1,opts,view){
return (function (_19628){
var self__ = this;
var _19628__$1 = this;
return self__.meta19627;
});})(map__19624,map__19624__$1,opts,view))
;

hatti.views.record.t_hatti$views$record19626.prototype.om$core$IInitState$ = true;

hatti.views.record.t_hatti$views$record19626.prototype.om$core$IInitState$init_state$arity$1 = ((function (map__19624,map__19624__$1,opts,view){
return (function (_){
var self__ = this;
var ___$1 = this;
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$expand_DASH_meta_QMARK_,false], null);
});})(map__19624,map__19624__$1,opts,view))
;

hatti.views.record.t_hatti$views$record19626.prototype.om$core$IRenderState$ = true;

hatti.views.record.t_hatti$views$record19626.prototype.om$core$IRenderState$render_state$arity$2 = ((function (map__19624,map__19624__$1,opts,view){
return (function (_,p__19629){
var self__ = this;
var map__19630 = p__19629;
var map__19630__$1 = ((((!((map__19630 == null)))?((((map__19630.cljs$lang$protocol_mask$partition0$ & (64))) || (map__19630.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__19630):map__19630);
var expand_meta_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19630__$1,cljs.core.cst$kw$expand_DASH_meta_QMARK_);
var ___$1 = this;
var form = om.core.get_shared.cljs$core$IFn$_invoke$arity$2(self__.owner,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$flat_DASH_form], null));
var language = cljs.core.cst$kw$current.cljs$core$IFn$_invoke$arity$1(om.core.observe(self__.owner,hatti.shared.language_cursor()));
var map__19632 = self__.cursor;
var map__19632__$1 = ((((!((map__19632 == null)))?((((map__19632.cljs$lang$protocol_mask$partition0$ & (64))) || (map__19632.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__19632):map__19632);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19632__$1,cljs.core.cst$kw$id);
var data = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19632__$1,cljs.core.cst$kw$data);
var dataset_info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19632__$1,cljs.core.cst$kw$dataset_DASH_info);
var cur_rank = cljs.core.get.cljs$core$IFn$_invoke$arity$2(data,hatti.constants._rank);
var instance_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(data,"_id");
var sdatetime = (function (){var G__19635 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(data,"_submission_time");
return moment(G__19635);
})();
var map__19633 = (hatti.views.record.submission_elements.cljs$core$IFn$_invoke$arity$1 ? hatti.views.record.submission_elements.cljs$core$IFn$_invoke$arity$1(self__.view) : hatti.views.record.submission_elements.call(null,self__.view));
var map__19633__$1 = ((((!((map__19633 == null)))?((((map__19633.cljs$lang$protocol_mask$partition0$ & (64))) || (map__19633.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__19633):map__19633);
var top_level_wrap = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19633__$1,cljs.core.cst$kw$top_DASH_level_DASH_wrap);
var topbar_wrap = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19633__$1,cljs.core.cst$kw$topbar_DASH_wrap);
var header_wrap = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19633__$1,cljs.core.cst$kw$header_DASH_wrap);
var section_wrap = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19633__$1,cljs.core.cst$kw$section_DASH_wrap);
var submission_info_wrap = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19633__$1,cljs.core.cst$kw$submission_DASH_info_DASH_wrap);
var h4_cls = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19633__$1,cljs.core.cst$kw$h4_DASH_cls);
return sablono.interpreter.interpret((cljs.core.truth_((function (){var or__6409__auto__ = data;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return id;
}
})())?(function (){var G__19637 = (function (){var G__19639 = hatti.views.record.submission_arrow(cljs.core.cst$kw$left,cur_rank,self__.view);
var G__19640 = hatti.views.record.submission_arrow(cljs.core.cst$kw$right,cur_rank,self__.view);
var G__19641 = om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.views.print_xls_report_btn,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$instance_DASH_id,instance_id,cljs.core.cst$kw$dataset_DASH_info,dataset_info], null));
var G__19642 = hatti.views.record.submission_closer();
return (topbar_wrap.cljs$core$IFn$_invoke$arity$4 ? topbar_wrap.cljs$core$IFn$_invoke$arity$4(G__19639,G__19640,G__19641,G__19642) : topbar_wrap.call(null,G__19639,G__19640,G__19641,G__19642));
})();
var G__19638 = (cljs.core.truth_(data)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div,(function (){var G__19643 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$h4,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,h4_cls], null),[cljs.core.str("ID: "),cljs.core.str(instance_id)].join(''),hatti.views.record.header_note(self__.view,self__.cursor)], null);
var G__19644 = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$p,[cljs.core.str("Submitted at "),cljs.core.str(sdatetime.format("LT")),cljs.core.str(" on "),cljs.core.str(sdatetime.format("ll"))].join(''),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$br], null),om.core.build.cljs$core$IFn$_invoke$arity$3(hatti.views.edit_delete,instance_id,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$opts,self__.opts], null)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$expand_DASH_meta$right,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$href,"#",cljs.core.cst$kw$on_DASH_click,hatti.utils.click_fn(((function (G__19643,G__19637,form,language,map__19632,map__19632__$1,id,data,dataset_info,cur_rank,instance_id,sdatetime,map__19633,map__19633__$1,top_level_wrap,topbar_wrap,header_wrap,section_wrap,submission_info_wrap,h4_cls,___$1,map__19630,map__19630__$1,expand_meta_QMARK_,map__19624,map__19624__$1,opts,view){
return (function (){
return om.core.update_state_BANG_.cljs$core$IFn$_invoke$arity$3(self__.owner,cljs.core.cst$kw$expand_DASH_meta_QMARK_,cljs.core.not);
});})(G__19643,G__19637,form,language,map__19632,map__19632__$1,id,data,dataset_info,cur_rank,instance_id,sdatetime,map__19633,map__19633__$1,top_level_wrap,topbar_wrap,header_wrap,section_wrap,submission_info_wrap,h4_cls,___$1,map__19630,map__19630__$1,expand_meta_QMARK_,map__19624,map__19624__$1,opts,view))
)], null),(cljs.core.truth_(expand_meta_QMARK_)?"Hide Metadata":"Show Metadata")], null)], null)], null);
return (header_wrap.cljs$core$IFn$_invoke$arity$2 ? header_wrap.cljs$core$IFn$_invoke$arity$2(G__19643,G__19644) : header_wrap.call(null,G__19643,G__19644));
})(),(function (){var G__19645 = (cljs.core.truth_(expand_meta_QMARK_)?(function (){var G__19647 = (function (){var iter__7189__auto__ = ((function (G__19637,form,language,map__19632,map__19632__$1,id,data,dataset_info,cur_rank,instance_id,sdatetime,map__19633,map__19633__$1,top_level_wrap,topbar_wrap,header_wrap,section_wrap,submission_info_wrap,h4_cls,___$1,map__19630,map__19630__$1,expand_meta_QMARK_,map__19624,map__19624__$1,opts,view){
return (function hatti$views$record$iter__19648(s__19649){
return (new cljs.core.LazySeq(null,((function (G__19637,form,language,map__19632,map__19632__$1,id,data,dataset_info,cur_rank,instance_id,sdatetime,map__19633,map__19633__$1,top_level_wrap,topbar_wrap,header_wrap,section_wrap,submission_info_wrap,h4_cls,___$1,map__19630,map__19630__$1,expand_meta_QMARK_,map__19624,map__19624__$1,opts,view){
return (function (){
var s__19649__$1 = s__19649;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__19649__$1);
if(temp__4657__auto__){
var s__19649__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__19649__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__19649__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__19651 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__19650 = (0);
while(true){
if((i__19650 < size__7188__auto__)){
var q = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__19650);
cljs.core.chunk_append(b__19651,hatti.views.record.format_as_question_answer(self__.view,q,data,language));

var G__19661 = (i__19650 + (1));
i__19650 = G__19661;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__19651),hatti$views$record$iter__19648(cljs.core.chunk_rest(s__19649__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__19651),null);
}
} else {
var q = cljs.core.first(s__19649__$2);
return cljs.core.cons(hatti.views.record.format_as_question_answer(self__.view,q,data,language),hatti$views$record$iter__19648(cljs.core.rest(s__19649__$2)));
}
} else {
return null;
}
break;
}
});})(G__19637,form,language,map__19632,map__19632__$1,id,data,dataset_info,cur_rank,instance_id,sdatetime,map__19633,map__19633__$1,top_level_wrap,topbar_wrap,header_wrap,section_wrap,submission_info_wrap,h4_cls,___$1,map__19630,map__19630__$1,expand_meta_QMARK_,map__19624,map__19624__$1,opts,view))
,null,null));
});})(G__19637,form,language,map__19632,map__19632__$1,id,data,dataset_info,cur_rank,instance_id,sdatetime,map__19633,map__19633__$1,top_level_wrap,topbar_wrap,header_wrap,section_wrap,submission_info_wrap,h4_cls,___$1,map__19630,map__19630__$1,expand_meta_QMARK_,map__19624,map__19624__$1,opts,view))
;
return iter__7189__auto__(hatti.ona.forms.meta_fields.cljs$core$IFn$_invoke$arity$variadic(form,cljs.core.array_seq([cljs.core.cst$kw$with_DASH_submission_DASH_details_QMARK_,true], 0)));
})();
return (section_wrap.cljs$core$IFn$_invoke$arity$1 ? section_wrap.cljs$core$IFn$_invoke$arity$1(G__19647) : section_wrap.call(null,G__19647));
})():null);
var G__19646 = (function (){var G__19654 = (function (){var iter__7189__auto__ = ((function (G__19645,G__19637,form,language,map__19632,map__19632__$1,id,data,dataset_info,cur_rank,instance_id,sdatetime,map__19633,map__19633__$1,top_level_wrap,topbar_wrap,header_wrap,section_wrap,submission_info_wrap,h4_cls,___$1,map__19630,map__19630__$1,expand_meta_QMARK_,map__19624,map__19624__$1,opts,view){
return (function hatti$views$record$iter__19655(s__19656){
return (new cljs.core.LazySeq(null,((function (G__19645,G__19637,form,language,map__19632,map__19632__$1,id,data,dataset_info,cur_rank,instance_id,sdatetime,map__19633,map__19633__$1,top_level_wrap,topbar_wrap,header_wrap,section_wrap,submission_info_wrap,h4_cls,___$1,map__19630,map__19630__$1,expand_meta_QMARK_,map__19624,map__19624__$1,opts,view){
return (function (){
var s__19656__$1 = s__19656;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__19656__$1);
if(temp__4657__auto__){
var s__19656__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__19656__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__19656__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__19658 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__19657 = (0);
while(true){
if((i__19657 < size__7188__auto__)){
var q = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__19657);
cljs.core.chunk_append(b__19658,hatti.views.record.format_as_question_answer(self__.view,q,data,language));

var G__19662 = (i__19657 + (1));
i__19657 = G__19662;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__19658),hatti$views$record$iter__19655(cljs.core.chunk_rest(s__19656__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__19658),null);
}
} else {
var q = cljs.core.first(s__19656__$2);
return cljs.core.cons(hatti.views.record.format_as_question_answer(self__.view,q,data,language),hatti$views$record$iter__19655(cljs.core.rest(s__19656__$2)));
}
} else {
return null;
}
break;
}
});})(G__19645,G__19637,form,language,map__19632,map__19632__$1,id,data,dataset_info,cur_rank,instance_id,sdatetime,map__19633,map__19633__$1,top_level_wrap,topbar_wrap,header_wrap,section_wrap,submission_info_wrap,h4_cls,___$1,map__19630,map__19630__$1,expand_meta_QMARK_,map__19624,map__19624__$1,opts,view))
,null,null));
});})(G__19645,G__19637,form,language,map__19632,map__19632__$1,id,data,dataset_info,cur_rank,instance_id,sdatetime,map__19633,map__19633__$1,top_level_wrap,topbar_wrap,header_wrap,section_wrap,submission_info_wrap,h4_cls,___$1,map__19630,map__19630__$1,expand_meta_QMARK_,map__19624,map__19624__$1,opts,view))
;
return iter__7189__auto__(hatti.ona.forms.non_meta_fields(form));
})();
return (section_wrap.cljs$core$IFn$_invoke$arity$1 ? section_wrap.cljs$core$IFn$_invoke$arity$1(G__19654) : section_wrap.call(null,G__19654));
})();
return (submission_info_wrap.cljs$core$IFn$_invoke$arity$2 ? submission_info_wrap.cljs$core$IFn$_invoke$arity$2(G__19645,G__19646) : submission_info_wrap.call(null,G__19645,G__19646));
})()], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$t_DASH_center,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$i$fa$fa_DASH_spinner$fa_DASH_pulse], null),"Loading data..."], null)], null));
return (top_level_wrap.cljs$core$IFn$_invoke$arity$2 ? top_level_wrap.cljs$core$IFn$_invoke$arity$2(G__19637,G__19638) : top_level_wrap.call(null,G__19637,G__19638));
})():null));
});})(map__19624,map__19624__$1,opts,view))
;

hatti.views.record.t_hatti$views$record19626.getBasis = ((function (map__19624,map__19624__$1,opts,view){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$cursor,cljs.core.cst$sym$owner,cljs.core.cst$sym$p__19623,cljs.core.cst$sym$map__19624,cljs.core.cst$sym$opts,cljs.core.cst$sym$view,cljs.core.cst$sym$meta19627], null);
});})(map__19624,map__19624__$1,opts,view))
;

hatti.views.record.t_hatti$views$record19626.cljs$lang$type = true;

hatti.views.record.t_hatti$views$record19626.cljs$lang$ctorStr = "hatti.views.record/t_hatti$views$record19626";

hatti.views.record.t_hatti$views$record19626.cljs$lang$ctorPrWriter = ((function (map__19624,map__19624__$1,opts,view){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"hatti.views.record/t_hatti$views$record19626");
});})(map__19624,map__19624__$1,opts,view))
;

hatti.views.record.__GT_t_hatti$views$record19626 = ((function (map__19624,map__19624__$1,opts,view){
return (function hatti$views$record$__GT_t_hatti$views$record19626(cursor__$1,owner__$1,p__19623__$1,map__19624__$2,opts__$1,view__$1,meta19627){
return (new hatti.views.record.t_hatti$views$record19626(cursor__$1,owner__$1,p__19623__$1,map__19624__$2,opts__$1,view__$1,meta19627));
});})(map__19624,map__19624__$1,opts,view))
;

}

return (new hatti.views.record.t_hatti$views$record19626(cursor,owner,p__19623,map__19624__$1,opts,view,cljs.core.PersistentArrayMap.EMPTY));
}));
