// Compiled by ClojureScript 1.9.229 {:static-fns true, :optimize-constants true}
goog.provide('hatti.views.table');
goog.require('cljs.core');
goog.require('hatti.views.record');
goog.require('chimera.js_interop');
goog.require('om.dom');
goog.require('hatti.ona.forms');
goog.require('sablono.core');
goog.require('cljs.core.async');
goog.require('chimera.seq');
goog.require('hatti.shared');
goog.require('hatti.constants');
goog.require('hatti.views');
goog.require('om.core');
goog.require('hatti.utils');
goog.require('chimera.core');
goog.require('chimera.string');
goog.require('chimera.urls');
goog.require('clojure.string');
hatti.views.table.default_num_displayed_records = (25);
hatti.views.table.table_id = "submission-grid";
hatti.views.table.pager_id = "pager";
/**
 * Extra fields that will be displayed on the table.
 */
hatti.views.table.get_extra_fields = (function hatti$views$table$get_extra_fields(is_filtered_dataview_QMARK_){
var id_field = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$full_DASH_name,hatti.constants._id,cljs.core.cst$kw$label,"ID",cljs.core.cst$kw$name,hatti.constants._id,cljs.core.cst$kw$type,"integer"], null)], null);
var G__22647 = id_field;
if(cljs.core.not(is_filtered_dataview_QMARK_)){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(G__22647,hatti.ona.forms.submission_time_field);
} else {
return G__22647;
}
});
/**
 * Given a (flat-)form, returns fields for table display.
 * Puts extra fields in the beginning, metadata at the end of the table,
 * and drops fields that have no data (eg. group/note).
 */
hatti.views.table.all_fields = (function hatti$views$table$all_fields(var_args){
var args__7491__auto__ = [];
var len__7484__auto___22653 = arguments.length;
var i__7485__auto___22654 = (0);
while(true){
if((i__7485__auto___22654 < len__7484__auto___22653)){
args__7491__auto__.push((arguments[i__7485__auto___22654]));

var G__22655 = (i__7485__auto___22654 + (1));
i__7485__auto___22654 = G__22655;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return hatti.views.table.all_fields.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

hatti.views.table.all_fields.cljs$core$IFn$_invoke$arity$variadic = (function (form,p__22650){
var map__22651 = p__22650;
var map__22651__$1 = ((((!((map__22651 == null)))?((((map__22651.cljs$lang$protocol_mask$partition0$ & (64))) || (map__22651.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__22651):map__22651);
var is_filtered_dataview_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22651__$1,cljs.core.cst$kw$is_DASH_filtered_DASH_dataview_QMARK_);
return cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.has_data_QMARK_,cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic(hatti.views.table.get_extra_fields(is_filtered_dataview_QMARK_),hatti.ona.forms.non_meta_fields(form),cljs.core.array_seq([hatti.ona.forms.meta_fields.cljs$core$IFn$_invoke$arity$variadic(form,cljs.core.array_seq([cljs.core.cst$kw$with_DASH_submission_DASH_details_QMARK_,cljs.core.not(is_filtered_dataview_QMARK_)], 0))], 0))));
});

hatti.views.table.all_fields.cljs$lang$maxFixedArity = (1);

hatti.views.table.all_fields.cljs$lang$applyTo = (function (seq22648){
var G__22649 = cljs.core.first(seq22648);
var seq22648__$1 = cljs.core.next(seq22648);
return hatti.views.table.all_fields.cljs$core$IFn$_invoke$arity$variadic(G__22649,seq22648__$1);
});

/**
 * Comparator function for the slickgrid dataview.
 * args.sortCol is the column being sorted, a and b are rows to compare.
 * Claims a is bigger (return 1) if value for a > b, or a is null / empty.
 */
hatti.views.table.compfn = (function hatti$views$table$compfn(args){
return (function (a,b){
var col = (args["sortCol"]);
var lower = ((function (col){
return (function (p1__22656_SHARP_){
if(typeof p1__22656_SHARP_ === 'string'){
return clojure.string.lower_case(p1__22656_SHARP_);
} else {
return p1__22656_SHARP_;
}
});})(col))
;
var aval = lower((a[(col["field"])]));
var bval = lower((b[(col["field"])]));
if(((aval == null)) || ((aval > bval))){
return (1);
} else {
return (-1);
}
});
});
/**
 * Filter function for the slickgrid dataview, use as (partial filterfn form)
 * item is the row, args contains query.
 * Return value of false corresponds with exclusion, true with inclusion.
 */
hatti.views.table.filterfn = (function hatti$views$table$filterfn(form,item,args){
if(cljs.core.not(args)){
return true;
} else {
var indexed_form = cljs.core.zipmap(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$full_DASH_name,form),form);
var query = (args["query"]);
var fmt_subitem = ((function (indexed_form,query){
return (function (p__22662){
var vec__22663 = p__22662;
var fname = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22663,(0),null);
var answer = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22663,(1),null);
return hatti.ona.forms.format_answer.cljs$core$IFn$_invoke$arity$variadic(cljs.core.get.cljs$core$IFn$_invoke$arity$2(indexed_form,fname),answer,cljs.core.array_seq([cljs.core.cst$kw$compact_QMARK_,true], 0));
});})(indexed_form,query))
;
var filtered = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (indexed_form,query,fmt_subitem){
return (function (p1__22657_SHARP_){
return cljs.core.re_find(chimera.js_interop.safe_regex(query),[cljs.core.str(p1__22657_SHARP_)].join(''));
});})(indexed_form,query,fmt_subitem))
,cljs.core.map.cljs$core$IFn$_invoke$arity$2(fmt_subitem,cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$1(item))));
return cljs.core.seq(filtered);
}
});
/**
 * Formatter for slickgrid columns takes row,cell,value,columnDef,dataContext.
 * Get one with (partial formatter field language).
 */
hatti.views.table.formatter = (function hatti$views$table$formatter(field,language,field_key,row,cell,value,columnDef,dataContext){
var clj_value = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(value,cljs.core.array_seq([cljs.core.cst$kw$keywordize_DASH_keys,true], 0));
return hatti.ona.forms.format_answer.cljs$core$IFn$_invoke$arity$variadic(field,chimera.string.escape_for_type(clj_value),cljs.core.array_seq([cljs.core.cst$kw$language,language,cljs.core.cst$kw$compact_QMARK_,true,cljs.core.cst$kw$field_DASH_key,field_key], 0));
});
hatti.views.action_buttons.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (owner){
return (function (row,cell,value,columnDef,dataContext){
var map__22666 = cljs.core.cst$kw$dataset_DASH_info.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.shared.app_state) : cljs.core.deref.call(null,hatti.shared.app_state)));
var map__22666__$1 = ((((!((map__22666 == null)))?((((map__22666.cljs$lang$protocol_mask$partition0$ & (64))) || (map__22666.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__22666):map__22666);
var owner__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22666__$1,cljs.core.cst$kw$owner);
var project = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22666__$1,cljs.core.cst$kw$project);
var formid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22666__$1,cljs.core.cst$kw$formid);
var form_owner = chimera.urls.last_url_param(owner__$1);
var project_id = chimera.urls.last_url_param(project);
var edit_link = chimera.urls.url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([form_owner,project_id,formid,[cljs.core.str("webform?instance-id="),cljs.core.str(value)].join('')], 0));
return hatti.utils.generate_html.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([(cljs.core.truth_(value)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$ul,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li$tooltip$middle_DASH_right,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$tip_DASH_info,"View"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a$view_DASH_record,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$i$fa$fa_DASH_clone,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$data_DASH_id,value], null)], null)], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li$tooltip,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$tip_DASH_info,"Edit"], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a$edit_DASH_record,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$data_DASH_id,value,cljs.core.cst$kw$target,"_blank",cljs.core.cst$kw$href,edit_link], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$i$fa$fa_DASH_pencil_DASH_square_DASH_o], null)], null)], null)], null):null)], 0));
});
}));
/**
 * The html needed for a column name as a string.
 * String, String, Bool -> String
 */
hatti.views.table.column_name_html_string = (function hatti$views$table$column_name_html_string(column_class,label,hxl){
return [cljs.core.str("<div class=\""),cljs.core.str(column_class),cljs.core.str("\">"),cljs.core.str(label),cljs.core.str("</div>"),cljs.core.str((cljs.core.truth_(hxl)?[cljs.core.str("<div class=\"hxl-row\">"),cljs.core.str(hxl),cljs.core.str("</div>")].join(''):null))].join('');
});
hatti.views.table.actions_column = (function hatti$views$table$actions_column(owner,has_hxl_QMARK_){
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$headerCssClass,cljs.core.cst$kw$maxWidth,cljs.core.cst$kw$name,cljs.core.cst$kw$formatter,cljs.core.cst$kw$field,cljs.core.cst$kw$type,cljs.core.cst$kw$id,cljs.core.cst$kw$sortable,cljs.core.cst$kw$cssClass,cljs.core.cst$kw$toolTip],[[cljs.core.str((cljs.core.truth_(has_hxl_QMARK_)?"hxl-min-height ":null)),cljs.core.str("record-actions header")].join(''),(70),"",(hatti.views.action_buttons.cljs$core$IFn$_invoke$arity$1 ? hatti.views.action_buttons.cljs$core$IFn$_invoke$arity$1(owner) : hatti.views.action_buttons.call(null,owner)),hatti.constants._id,"text","actions",false,"record-actions",""]);
});
/**
 * Get a set of slick grid column objects when given a flat form.
 */
hatti.views.table.flat_form__GT_sg_columns = (function hatti$views$table$flat_form__GT_sg_columns(var_args){
var args__7491__auto__ = [];
var len__7484__auto___22699 = arguments.length;
var i__7485__auto___22700 = (0);
while(true){
if((i__7485__auto___22700 < len__7484__auto___22699)){
args__7491__auto__.push((arguments[i__7485__auto___22700]));

var G__22701 = (i__7485__auto___22700 + (1));
i__7485__auto___22700 = G__22701;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic = (function (form,p__22671){
var map__22672 = p__22671;
var map__22672__$1 = ((((!((map__22672 == null)))?((((map__22672.cljs$lang$protocol_mask$partition0$ & (64))) || (map__22672.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__22672):map__22672);
var hide_actions_column_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22672__$1,cljs.core.cst$kw$hide_DASH_actions_DASH_column_QMARK_);
var is_filtered_dataview_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22672__$1,cljs.core.cst$kw$is_DASH_filtered_DASH_dataview_QMARK_);
var get_label_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__22672__$1,cljs.core.cst$kw$get_DASH_label_QMARK_,true);
var language = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22672__$1,cljs.core.cst$kw$language);
var owner = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22672__$1,cljs.core.cst$kw$owner);
var has_hxl_QMARK_ = (function (){var G__22674 = cljs.core.false_QMARK_;
var G__22675 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (G__22674,map__22672,map__22672__$1,hide_actions_column_QMARK_,is_filtered_dataview_QMARK_,get_label_QMARK_,language,owner){
return (function (p1__22668_SHARP_){
return (cljs.core.cst$kw$hxl.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$instance.cljs$core$IFn$_invoke$arity$1(p1__22668_SHARP_)) == null);
});})(G__22674,map__22672,map__22672__$1,hide_actions_column_QMARK_,is_filtered_dataview_QMARK_,get_label_QMARK_,language,owner))
,form);
return (chimera.core.any_QMARK_.cljs$core$IFn$_invoke$arity$2 ? chimera.core.any_QMARK_.cljs$core$IFn$_invoke$arity$2(G__22674,G__22675) : chimera.core.any_QMARK_.call(null,G__22674,G__22675));
})();
var columns = (function (){var iter__7189__auto__ = ((function (has_hxl_QMARK_,map__22672,map__22672__$1,hide_actions_column_QMARK_,is_filtered_dataview_QMARK_,get_label_QMARK_,language,owner){
return (function hatti$views$table$iter__22676(s__22677){
return (new cljs.core.LazySeq(null,((function (has_hxl_QMARK_,map__22672,map__22672__$1,hide_actions_column_QMARK_,is_filtered_dataview_QMARK_,get_label_QMARK_,language,owner){
return (function (){
var s__22677__$1 = s__22677;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__22677__$1);
if(temp__4657__auto__){
var s__22677__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__22677__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__22677__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__22679 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__22678 = (0);
while(true){
if((i__22678 < size__7188__auto__)){
var field = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__22678);
cljs.core.chunk_append(b__22679,(function (){var map__22690 = field;
var map__22690__$1 = ((((!((map__22690 == null)))?((((map__22690.cljs$lang$protocol_mask$partition0$ & (64))) || (map__22690.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__22690):map__22690);
var map__22691 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22690__$1,cljs.core.cst$kw$instance);
var map__22691__$1 = ((((!((map__22691 == null)))?((((map__22691.cljs$lang$protocol_mask$partition0$ & (64))) || (map__22691.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__22691):map__22691);
var hxl = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22691__$1,cljs.core.cst$kw$hxl);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22690__$1,cljs.core.cst$kw$name);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22690__$1,cljs.core.cst$kw$type);
var full_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22690__$1,cljs.core.cst$kw$full_DASH_name);
var label = (cljs.core.truth_(get_label_QMARK_)?hatti.ona.forms.get_label.cljs$core$IFn$_invoke$arity$variadic(field,cljs.core.array_seq([language], 0)):name);
var column_class = hatti.ona.forms.get_column_class(field);
var field_key = (cljs.core.truth_(get_label_QMARK_)?cljs.core.cst$kw$name:cljs.core.cst$kw$label);
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$hxl,cljs.core.cst$kw$headerCssClass,cljs.core.cst$kw$name,cljs.core.cst$kw$formatter,cljs.core.cst$kw$minWidth,cljs.core.cst$kw$field,cljs.core.cst$kw$type,cljs.core.cst$kw$id,cljs.core.cst$kw$sortable,cljs.core.cst$kw$cssClass,cljs.core.cst$kw$toolTip],[hxl,(cljs.core.truth_(has_hxl_QMARK_)?"hxl-min-height":null),hatti.views.table.column_name_html_string(column_class,label,hxl),cljs.core.partial.cljs$core$IFn$_invoke$arity$4(hatti.views.table.formatter,field,language,field_key),(50),full_name,type,name,true,column_class,label]);
})());

var G__22702 = (i__22678 + (1));
i__22678 = G__22702;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__22679),hatti$views$table$iter__22676(cljs.core.chunk_rest(s__22677__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__22679),null);
}
} else {
var field = cljs.core.first(s__22677__$2);
return cljs.core.cons((function (){var map__22694 = field;
var map__22694__$1 = ((((!((map__22694 == null)))?((((map__22694.cljs$lang$protocol_mask$partition0$ & (64))) || (map__22694.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__22694):map__22694);
var map__22695 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22694__$1,cljs.core.cst$kw$instance);
var map__22695__$1 = ((((!((map__22695 == null)))?((((map__22695.cljs$lang$protocol_mask$partition0$ & (64))) || (map__22695.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__22695):map__22695);
var hxl = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22695__$1,cljs.core.cst$kw$hxl);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22694__$1,cljs.core.cst$kw$name);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22694__$1,cljs.core.cst$kw$type);
var full_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22694__$1,cljs.core.cst$kw$full_DASH_name);
var label = (cljs.core.truth_(get_label_QMARK_)?hatti.ona.forms.get_label.cljs$core$IFn$_invoke$arity$variadic(field,cljs.core.array_seq([language], 0)):name);
var column_class = hatti.ona.forms.get_column_class(field);
var field_key = (cljs.core.truth_(get_label_QMARK_)?cljs.core.cst$kw$name:cljs.core.cst$kw$label);
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$hxl,cljs.core.cst$kw$headerCssClass,cljs.core.cst$kw$name,cljs.core.cst$kw$formatter,cljs.core.cst$kw$minWidth,cljs.core.cst$kw$field,cljs.core.cst$kw$type,cljs.core.cst$kw$id,cljs.core.cst$kw$sortable,cljs.core.cst$kw$cssClass,cljs.core.cst$kw$toolTip],[hxl,(cljs.core.truth_(has_hxl_QMARK_)?"hxl-min-height":null),hatti.views.table.column_name_html_string(column_class,label,hxl),cljs.core.partial.cljs$core$IFn$_invoke$arity$4(hatti.views.table.formatter,field,language,field_key),(50),full_name,type,name,true,column_class,label]);
})(),hatti$views$table$iter__22676(cljs.core.rest(s__22677__$2)));
}
} else {
return null;
}
break;
}
});})(has_hxl_QMARK_,map__22672,map__22672__$1,hide_actions_column_QMARK_,is_filtered_dataview_QMARK_,get_label_QMARK_,language,owner))
,null,null));
});})(has_hxl_QMARK_,map__22672,map__22672__$1,hide_actions_column_QMARK_,is_filtered_dataview_QMARK_,get_label_QMARK_,language,owner))
;
return iter__7189__auto__(hatti.views.table.all_fields.cljs$core$IFn$_invoke$arity$variadic(form,cljs.core.array_seq([cljs.core.cst$kw$is_DASH_filtered_DASH_dataview_QMARK_,is_filtered_dataview_QMARK_], 0)));
})();
return cljs.core.clj__GT_js((function (){var G__22698 = columns;
if(cljs.core.not(hide_actions_column_QMARK_)){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(G__22698,hatti.views.table.actions_column(owner,has_hxl_QMARK_));
} else {
return G__22698;
}
})());
});

hatti.views.table.flat_form__GT_sg_columns.cljs$lang$maxFixedArity = (1);

hatti.views.table.flat_form__GT_sg_columns.cljs$lang$applyTo = (function (seq22669){
var G__22670 = cljs.core.first(seq22669);
var seq22669__$1 = cljs.core.next(seq22669);
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic(G__22670,seq22669__$1);
});

hatti.views.table.init_sg_pager = (function hatti$views$table$init_sg_pager(grid,dataview){
var Pager = Slick.Controls.Pager;
return (new Pager(dataview,grid,(function (){var G__22704 = [cljs.core.str("#"),cljs.core.str(hatti.views.table.pager_id)].join('');
return jQuery(G__22704);
})()));
});
hatti.views.table.resizeColumns = (function hatti$views$table$resizeColumns(grid){
return grid.registerPlugin(Slick.AutoColumnSize());
});
/**
 * Options to feed the slickgrid constructor.
 */
hatti.views.table.sg_options = ({"autoHeight": true, "enableColumnReorder": false, "enableTextSelectionOnCells": true, "rowHeight": (40), "syncColumnCellResize": false});
hatti.views.table.bind_external_sg_grid_event_handlers = (function hatti$views$table$bind_external_sg_grid_event_handlers(grid,event_handlers){
return cljs.core.doall.cljs$core$IFn$_invoke$arity$1((function (){var iter__7189__auto__ = (function hatti$views$table$bind_external_sg_grid_event_handlers_$_iter__22723(s__22724){
return (new cljs.core.LazySeq(null,(function (){
var s__22724__$1 = s__22724;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__22724__$1);
if(temp__4657__auto__){
var s__22724__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__22724__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__22724__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__22726 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__22725 = (0);
while(true){
if((i__22725 < size__7188__auto__)){
var vec__22735 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__22725);
var handler_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22735,(0),null);
var handler_function = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22735,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case(cljs.core.name(handler_key));
var event = (grid[handler_name]);
cljs.core.chunk_append(b__22726,event.subscribe(handler_function));

var G__22741 = (i__22725 + (1));
i__22725 = G__22741;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__22726),hatti$views$table$bind_external_sg_grid_event_handlers_$_iter__22723(cljs.core.chunk_rest(s__22724__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__22726),null);
}
} else {
var vec__22738 = cljs.core.first(s__22724__$2);
var handler_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22738,(0),null);
var handler_function = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22738,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case(cljs.core.name(handler_key));
var event = (grid[handler_name]);
return cljs.core.cons(event.subscribe(handler_function),hatti$views$table$bind_external_sg_grid_event_handlers_$_iter__22723(cljs.core.rest(s__22724__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__(event_handlers);
})());
});
hatti.views.table.bind_external_sg_grid_dataview_handlers = (function hatti$views$table$bind_external_sg_grid_dataview_handlers(dataview,event_handlers){
return cljs.core.doall.cljs$core$IFn$_invoke$arity$1((function (){var iter__7189__auto__ = (function hatti$views$table$bind_external_sg_grid_dataview_handlers_$_iter__22760(s__22761){
return (new cljs.core.LazySeq(null,(function (){
var s__22761__$1 = s__22761;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__22761__$1);
if(temp__4657__auto__){
var s__22761__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__22761__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__22761__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__22763 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__22762 = (0);
while(true){
if((i__22762 < size__7188__auto__)){
var vec__22772 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__22762);
var handler_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22772,(0),null);
var handler_function = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22772,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case(cljs.core.name(handler_key));
var event = (dataview[handler_name]);
cljs.core.chunk_append(b__22763,event.subscribe(handler_function));

var G__22778 = (i__22762 + (1));
i__22762 = G__22778;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__22763),hatti$views$table$bind_external_sg_grid_dataview_handlers_$_iter__22760(cljs.core.chunk_rest(s__22761__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__22763),null);
}
} else {
var vec__22775 = cljs.core.first(s__22761__$2);
var handler_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22775,(0),null);
var handler_function = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22775,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case(cljs.core.name(handler_key));
var event = (dataview[handler_name]);
return cljs.core.cons(event.subscribe(handler_function),hatti$views$table$bind_external_sg_grid_dataview_handlers_$_iter__22760(cljs.core.rest(s__22761__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__(event_handlers);
})());
});
/**
 * Creates a Slick.Grid backed by Slick.Data.DataView from data and fields.
 * Most events are handled by slickgrid. On double-click, event is put on chan.
 * Returns [grid dataview].
 */
hatti.views.table.sg_init = (function hatti$views$table$sg_init(data,form,current_language,is_filtered_dataview_QMARK_,owner,p__22779){
var map__22789 = p__22779;
var map__22789__$1 = ((((!((map__22789 == null)))?((((map__22789.cljs$lang$protocol_mask$partition0$ & (64))) || (map__22789.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__22789):map__22789);
var grid_event_handlers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22789__$1,cljs.core.cst$kw$grid_DASH_event_DASH_handlers);
var dataview_event_handlers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22789__$1,cljs.core.cst$kw$dataview_DASH_event_DASH_handlers);
var map__22791 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.shared.app_state) : cljs.core.deref.call(null,hatti.shared.app_state));
var map__22791__$1 = ((((!((map__22791 == null)))?((((map__22791.cljs$lang$protocol_mask$partition0$ & (64))) || (map__22791.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__22791):map__22791);
var map__22792 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22791__$1,cljs.core.cst$kw$table_DASH_page);
var map__22792__$1 = ((((!((map__22792 == null)))?((((map__22792.cljs$lang$protocol_mask$partition0$ & (64))) || (map__22792.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__22792):map__22792);
var map__22793 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22792__$1,cljs.core.cst$kw$paging);
var map__22793__$1 = ((((!((map__22793 == null)))?((((map__22793.cljs$lang$protocol_mask$partition0$ & (64))) || (map__22793.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__22793):map__22793);
var num_displayed_records = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22793__$1,cljs.core.cst$kw$num_DASH_displayed_DASH_records);
var total_page_count = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22793__$1,cljs.core.cst$kw$total_DASH_page_DASH_count);
var hide_actions_column_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22792__$1,cljs.core.cst$kw$hide_DASH_actions_DASH_column_QMARK_);
var columns = hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic(form,cljs.core.array_seq([cljs.core.cst$kw$language,current_language,cljs.core.cst$kw$hide_DASH_actions_DASH_column_QMARK_,hide_actions_column_QMARK_,cljs.core.cst$kw$is_DASH_filtered_DASH_dataview_QMARK_,is_filtered_dataview_QMARK_,cljs.core.cst$kw$owner,owner], 0));
var SlickGrid = Slick.Grid;
var DataView = Slick.Data.DataView;
var dataview = (new DataView());
var grid = (new SlickGrid([cljs.core.str("#"),cljs.core.str(hatti.views.table.table_id)].join(''),dataview,columns,hatti.views.table.sg_options));
hatti.views.table.bind_external_sg_grid_event_handlers(grid,grid_event_handlers);

hatti.views.table.bind_external_sg_grid_dataview_handlers(dataview,dataview_event_handlers);

dataview.onRowCountChanged.subscribe(((function (map__22791,map__22791__$1,map__22792,map__22792__$1,map__22793,map__22793__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__22789,map__22789__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
grid.updateRowCount();

return grid.render();
});})(map__22791,map__22791__$1,map__22792,map__22792__$1,map__22793,map__22793__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__22789,map__22789__$1,grid_event_handlers,dataview_event_handlers))
);

dataview.onRowsChanged.subscribe(((function (map__22791,map__22791__$1,map__22792,map__22792__$1,map__22793,map__22793__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__22789,map__22789__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
grid.invalidateRows((args["rows"]));

return grid.render();
});})(map__22791,map__22791__$1,map__22792,map__22792__$1,map__22793,map__22793__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__22789,map__22789__$1,grid_event_handlers,dataview_event_handlers))
);

grid.onDblClick.subscribe(((function (map__22791,map__22791__$1,map__22792,map__22792__$1,map__22793,map__22793__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__22789,map__22789__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
var rank = (dataview.getItem((args["row"]))[hatti.constants._rank]);
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$submission_DASH_to_DASH_rank,rank], null));
});})(map__22791,map__22791__$1,map__22792,map__22792__$1,map__22793,map__22793__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__22789,map__22789__$1,grid_event_handlers,dataview_event_handlers))
);

grid.onClick.subscribe(((function (map__22791,map__22791__$1,map__22792,map__22792__$1,map__22793,map__22793__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__22789,map__22789__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
var elem = e.target;
var row = dataview.getItem((args["row"]));
var elem_data_id = elem.getAttribute("data-id");
var data_id = (cljs.core.truth_(elem_data_id)?(function (){var G__22797 = elem.getAttribute("data-id");
return parseInt(G__22797);
})():null);
var id = (row[hatti.constants._id]);
var rank = (row[hatti.constants._rank]);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(id,data_id)){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$submission_DASH_to_DASH_rank,rank], null));
} else {
return null;
}
});})(map__22791,map__22791__$1,map__22792,map__22792__$1,map__22793,map__22793__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__22789,map__22789__$1,grid_event_handlers,dataview_event_handlers))
);

hatti.views.table.init_sg_pager(grid,dataview);

dataview.setPagingOptions(({"pageSize": (function (){var or__6409__auto__ = num_displayed_records;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return hatti.views.table.default_num_displayed_records;
}
})(), "totalPages": total_page_count}));

dataview.setFilter(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(hatti.views.table.filterfn,form));

dataview.setItems(cljs.core.clj__GT_js(data),hatti.constants._id);

hatti.views.table.resizeColumns(grid);

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [grid,dataview], null);
});
/**
 * Event loop for the table view. Processes a tap of share/event-chan,
 * and updates app-state/dataview/grid as needed.
 */
hatti.views.table.handle_table_events = (function hatti$views$table$handle_table_events(app_state,grid,dataview){
var event_chan = hatti.shared.event_tap();
var c__12158__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12158__auto__,event_chan){
return (function (){
var f__12159__auto__ = (function (){var switch__12081__auto__ = ((function (c__12158__auto__,event_chan){
return (function (state_23059){
var state_val_23060 = (state_23059[(1)]);
if((state_val_23060 === (7))){
var inst_22968 = (state_23059[(7)]);
var inst_22968__$1 = (state_23059[(2)]);
var inst_22970 = (inst_22968__$1 == null);
var inst_22971 = cljs.core.not(inst_22970);
var state_23059__$1 = (function (){var statearr_23061 = state_23059;
(statearr_23061[(7)] = inst_22968__$1);

return statearr_23061;
})();
if(inst_22971){
var statearr_23062_23129 = state_23059__$1;
(statearr_23062_23129[(1)] = (8));

} else {
var statearr_23063_23130 = state_23059__$1;
(statearr_23063_23130[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23060 === (20))){
var inst_22990 = (state_23059[(8)]);
var inst_22998 = (state_23059[(9)]);
var inst_23007 = (inst_22998.cljs$core$IFn$_invoke$arity$1 ? inst_22998.cljs$core$IFn$_invoke$arity$1(inst_22990) : inst_22998.call(null,inst_22990));
var state_23059__$1 = state_23059;
var statearr_23064_23131 = state_23059__$1;
(statearr_23064_23131[(2)] = inst_23007);

(statearr_23064_23131[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23060 === (27))){
var state_23059__$1 = state_23059;
var statearr_23065_23132 = state_23059__$1;
(statearr_23065_23132[(2)] = null);

(statearr_23065_23132[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23060 === (1))){
var state_23059__$1 = state_23059;
var statearr_23066_23133 = state_23059__$1;
(statearr_23066_23133[(2)] = null);

(statearr_23066_23133[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23060 === (24))){
var state_23059__$1 = state_23059;
var statearr_23067_23134 = state_23059__$1;
(statearr_23067_23134[(2)] = null);

(statearr_23067_23134[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23060 === (4))){
var state_23059__$1 = state_23059;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23059__$1,(7),event_chan);
} else {
if((state_val_23060 === (15))){
var inst_22968 = (state_23059[(7)]);
var state_23059__$1 = state_23059;
var statearr_23068_23135 = state_23059__$1;
(statearr_23068_23135[(2)] = inst_22968);

(statearr_23068_23135[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23060 === (21))){
var state_23059__$1 = state_23059;
var statearr_23069_23136 = state_23059__$1;
(statearr_23069_23136[(2)] = null);

(statearr_23069_23136[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23060 === (31))){
var inst_22994 = (state_23059[(10)]);
var inst_23032 = (state_23059[(2)]);
var inst_23033 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_22994,cljs.core.cst$kw$table);
var state_23059__$1 = (function (){var statearr_23070 = state_23059;
(statearr_23070[(11)] = inst_23032);

return statearr_23070;
})();
if(inst_23033){
var statearr_23071_23137 = state_23059__$1;
(statearr_23071_23137[(1)] = (32));

} else {
var statearr_23072_23138 = state_23059__$1;
(statearr_23072_23138[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23060 === (32))){
var inst_22992 = (state_23059[(12)]);
var inst_22999 = (state_23059[(13)]);
var inst_22994 = (state_23059[(10)]);
var inst_22988 = (state_23059[(14)]);
var inst_22991 = (state_23059[(15)]);
var inst_22990 = (state_23059[(8)]);
var inst_22993 = (state_23059[(16)]);
var inst_22998 = (state_23059[(9)]);
var inst_22989 = (state_23059[(17)]);
var inst_23046 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_23047 = (function (){var new_columns = inst_22993;
var c__12158__auto____$1 = inst_23046;
var submission_clicked = inst_22990;
var map__22966 = inst_22988;
var submission_unclicked = inst_22991;
var get_submission_data = inst_22999;
var re_render = inst_22994;
var update_data_BANG_ = inst_22998;
var submission_to_rank = inst_22989;
var filter_by = inst_22992;
return ((function (new_columns,c__12158__auto____$1,submission_clicked,map__22966,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,filter_by,inst_22992,inst_22999,inst_22994,inst_22988,inst_22991,inst_22990,inst_22993,inst_22998,inst_22989,inst_23046,state_val_23060,c__12158__auto__,event_chan){
return (function (){
var f__12159__auto__ = (function (){var switch__12081__auto__ = ((function (new_columns,c__12158__auto____$1,submission_clicked,map__22966,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,filter_by,inst_22992,inst_22999,inst_22994,inst_22988,inst_22991,inst_22990,inst_22993,inst_22998,inst_22989,inst_23046,state_val_23060,c__12158__auto__,event_chan){
return (function (state_23044){
var state_val_23045 = (state_23044[(1)]);
if((state_val_23045 === (1))){
var inst_23035 = cljs.core.async.timeout((20));
var state_23044__$1 = state_23044;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23044__$1,(2),inst_23035);
} else {
if((state_val_23045 === (2))){
var inst_23037 = (state_23044[(2)]);
var inst_23038 = grid.resizeCanvas();
var inst_23039 = grid.invalidateAllRows();
var inst_23040 = hatti.views.table.resizeColumns(grid);
var inst_23041 = grid.render();
var inst_23042 = hatti.views.table.init_sg_pager(grid,dataview);
var state_23044__$1 = (function (){var statearr_23073 = state_23044;
(statearr_23073[(7)] = inst_23040);

(statearr_23073[(8)] = inst_23041);

(statearr_23073[(9)] = inst_23038);

(statearr_23073[(10)] = inst_23037);

(statearr_23073[(11)] = inst_23039);

return statearr_23073;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_23044__$1,inst_23042);
} else {
return null;
}
}
});})(new_columns,c__12158__auto____$1,submission_clicked,map__22966,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,filter_by,inst_22992,inst_22999,inst_22994,inst_22988,inst_22991,inst_22990,inst_22993,inst_22998,inst_22989,inst_23046,state_val_23060,c__12158__auto__,event_chan))
;
return ((function (switch__12081__auto__,new_columns,c__12158__auto____$1,submission_clicked,map__22966,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,filter_by,inst_22992,inst_22999,inst_22994,inst_22988,inst_22991,inst_22990,inst_22993,inst_22998,inst_22989,inst_23046,state_val_23060,c__12158__auto__,event_chan){
return (function() {
var hatti$views$table$handle_table_events_$_state_machine__12082__auto__ = null;
var hatti$views$table$handle_table_events_$_state_machine__12082__auto____0 = (function (){
var statearr_23077 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23077[(0)] = hatti$views$table$handle_table_events_$_state_machine__12082__auto__);

(statearr_23077[(1)] = (1));

return statearr_23077;
});
var hatti$views$table$handle_table_events_$_state_machine__12082__auto____1 = (function (state_23044){
while(true){
var ret_value__12083__auto__ = (function (){try{while(true){
var result__12084__auto__ = switch__12081__auto__(state_23044);
if(cljs.core.keyword_identical_QMARK_(result__12084__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12084__auto__;
}
break;
}
}catch (e23078){if((e23078 instanceof Object)){
var ex__12085__auto__ = e23078;
var statearr_23079_23139 = state_23044;
(statearr_23079_23139[(5)] = ex__12085__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_23044);

return cljs.core.cst$kw$recur;
} else {
throw e23078;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12083__auto__,cljs.core.cst$kw$recur)){
var G__23140 = state_23044;
state_23044 = G__23140;
continue;
} else {
return ret_value__12083__auto__;
}
break;
}
});
hatti$views$table$handle_table_events_$_state_machine__12082__auto__ = function(state_23044){
switch(arguments.length){
case 0:
return hatti$views$table$handle_table_events_$_state_machine__12082__auto____0.call(this);
case 1:
return hatti$views$table$handle_table_events_$_state_machine__12082__auto____1.call(this,state_23044);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$handle_table_events_$_state_machine__12082__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$handle_table_events_$_state_machine__12082__auto____0;
hatti$views$table$handle_table_events_$_state_machine__12082__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$handle_table_events_$_state_machine__12082__auto____1;
return hatti$views$table$handle_table_events_$_state_machine__12082__auto__;
})()
;})(switch__12081__auto__,new_columns,c__12158__auto____$1,submission_clicked,map__22966,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,filter_by,inst_22992,inst_22999,inst_22994,inst_22988,inst_22991,inst_22990,inst_22993,inst_22998,inst_22989,inst_23046,state_val_23060,c__12158__auto__,event_chan))
})();
var state__12160__auto__ = (function (){var statearr_23080 = (f__12159__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12159__auto__.cljs$core$IFn$_invoke$arity$0() : f__12159__auto__.call(null));
(statearr_23080[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12158__auto____$1);

return statearr_23080;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12160__auto__);
});
;})(new_columns,c__12158__auto____$1,submission_clicked,map__22966,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,filter_by,inst_22992,inst_22999,inst_22994,inst_22988,inst_22991,inst_22990,inst_22993,inst_22998,inst_22989,inst_23046,state_val_23060,c__12158__auto__,event_chan))
})();
var inst_23048 = cljs.core.async.impl.dispatch.run(inst_23047);
var state_23059__$1 = (function (){var statearr_23081 = state_23059;
(statearr_23081[(18)] = inst_23048);

return statearr_23081;
})();
var statearr_23082_23141 = state_23059__$1;
(statearr_23082_23141[(2)] = inst_23046);

(statearr_23082_23141[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23060 === (33))){
var state_23059__$1 = state_23059;
var statearr_23083_23142 = state_23059__$1;
(statearr_23083_23142[(2)] = null);

(statearr_23083_23142[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23060 === (13))){
var inst_22980 = (state_23059[(2)]);
var state_23059__$1 = state_23059;
var statearr_23084_23143 = state_23059__$1;
(statearr_23084_23143[(2)] = inst_22980);

(statearr_23084_23143[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23060 === (22))){
var inst_22991 = (state_23059[(15)]);
var inst_23010 = (state_23059[(2)]);
var state_23059__$1 = (function (){var statearr_23085 = state_23059;
(statearr_23085[(19)] = inst_23010);

return statearr_23085;
})();
if(cljs.core.truth_(inst_22991)){
var statearr_23086_23144 = state_23059__$1;
(statearr_23086_23144[(1)] = (23));

} else {
var statearr_23087_23145 = state_23059__$1;
(statearr_23087_23145[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23060 === (29))){
var inst_22992 = (state_23059[(12)]);
var inst_23024 = [cljs.core.cst$kw$query];
var inst_23025 = [inst_22992];
var inst_23026 = cljs.core.PersistentHashMap.fromArrays(inst_23024,inst_23025);
var inst_23027 = cljs.core.clj__GT_js(inst_23026);
var inst_23028 = dataview.setFilterArgs(inst_23027);
var inst_23029 = dataview.refresh();
var state_23059__$1 = (function (){var statearr_23088 = state_23059;
(statearr_23088[(20)] = inst_23028);

return statearr_23088;
})();
var statearr_23089_23146 = state_23059__$1;
(statearr_23089_23146[(2)] = inst_23029);

(statearr_23089_23146[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23060 === (6))){
var inst_23055 = (state_23059[(2)]);
var state_23059__$1 = state_23059;
var statearr_23090_23147 = state_23059__$1;
(statearr_23090_23147[(2)] = inst_23055);

(statearr_23090_23147[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23060 === (28))){
var inst_22992 = (state_23059[(12)]);
var inst_23022 = (state_23059[(2)]);
var state_23059__$1 = (function (){var statearr_23091 = state_23059;
(statearr_23091[(21)] = inst_23022);

return statearr_23091;
})();
if(cljs.core.truth_(inst_22992)){
var statearr_23092_23148 = state_23059__$1;
(statearr_23092_23148[(1)] = (29));

} else {
var statearr_23093_23149 = state_23059__$1;
(statearr_23093_23149[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23060 === (25))){
var inst_22993 = (state_23059[(16)]);
var inst_23015 = (state_23059[(2)]);
var state_23059__$1 = (function (){var statearr_23094 = state_23059;
(statearr_23094[(22)] = inst_23015);

return statearr_23094;
})();
if(cljs.core.truth_(inst_22993)){
var statearr_23095_23150 = state_23059__$1;
(statearr_23095_23150[(1)] = (26));

} else {
var statearr_23096_23151 = state_23059__$1;
(statearr_23096_23151[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23060 === (34))){
var inst_23051 = (state_23059[(2)]);
var state_23059__$1 = (function (){var statearr_23097 = state_23059;
(statearr_23097[(23)] = inst_23051);

return statearr_23097;
})();
var statearr_23098_23152 = state_23059__$1;
(statearr_23098_23152[(2)] = null);

(statearr_23098_23152[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23060 === (17))){
var inst_22999 = (state_23059[(13)]);
var inst_22998 = (state_23059[(9)]);
var inst_22989 = (state_23059[(17)]);
var inst_23001 = (inst_22999.cljs$core$IFn$_invoke$arity$2 ? inst_22999.cljs$core$IFn$_invoke$arity$2(hatti.constants._rank,inst_22989) : inst_22999.call(null,hatti.constants._rank,inst_22989));
var inst_23002 = (inst_22998.cljs$core$IFn$_invoke$arity$1 ? inst_22998.cljs$core$IFn$_invoke$arity$1(inst_23001) : inst_22998.call(null,inst_23001));
var state_23059__$1 = state_23059;
var statearr_23099_23153 = state_23059__$1;
(statearr_23099_23153[(2)] = inst_23002);

(statearr_23099_23153[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23060 === (3))){
var inst_23057 = (state_23059[(2)]);
var state_23059__$1 = state_23059;
return cljs.core.async.impl.ioc_helpers.return_chan(state_23059__$1,inst_23057);
} else {
if((state_val_23060 === (12))){
var state_23059__$1 = state_23059;
var statearr_23100_23154 = state_23059__$1;
(statearr_23100_23154[(2)] = false);

(statearr_23100_23154[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23060 === (2))){
var state_23059__$1 = state_23059;
var statearr_23101_23155 = state_23059__$1;
(statearr_23101_23155[(1)] = (4));



return cljs.core.cst$kw$recur;
} else {
if((state_val_23060 === (23))){
var inst_22998 = (state_23059[(9)]);
var inst_23012 = (inst_22998.cljs$core$IFn$_invoke$arity$1 ? inst_22998.cljs$core$IFn$_invoke$arity$1(null) : inst_22998.call(null,null));
var state_23059__$1 = state_23059;
var statearr_23103_23156 = state_23059__$1;
(statearr_23103_23156[(2)] = inst_23012);

(statearr_23103_23156[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23060 === (19))){
var inst_22990 = (state_23059[(8)]);
var inst_23005 = (state_23059[(2)]);
var state_23059__$1 = (function (){var statearr_23104 = state_23059;
(statearr_23104[(24)] = inst_23005);

return statearr_23104;
})();
if(cljs.core.truth_(inst_22990)){
var statearr_23105_23157 = state_23059__$1;
(statearr_23105_23157[(1)] = (20));

} else {
var statearr_23106_23158 = state_23059__$1;
(statearr_23106_23158[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23060 === (11))){
var state_23059__$1 = state_23059;
var statearr_23107_23159 = state_23059__$1;
(statearr_23107_23159[(2)] = true);

(statearr_23107_23159[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23060 === (9))){
var state_23059__$1 = state_23059;
var statearr_23108_23160 = state_23059__$1;
(statearr_23108_23160[(2)] = false);

(statearr_23108_23160[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23060 === (5))){
var state_23059__$1 = state_23059;
var statearr_23109_23161 = state_23059__$1;
(statearr_23109_23161[(2)] = null);

(statearr_23109_23161[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23060 === (14))){
var inst_22968 = (state_23059[(7)]);
var inst_22985 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_22968);
var state_23059__$1 = state_23059;
var statearr_23110_23162 = state_23059__$1;
(statearr_23110_23162[(2)] = inst_22985);

(statearr_23110_23162[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23060 === (26))){
var inst_22993 = (state_23059[(16)]);
var inst_23017 = grid.setColumns(inst_22993);
var inst_23018 = hatti.views.table.resizeColumns(grid);
var inst_23019 = grid.render();
var state_23059__$1 = (function (){var statearr_23111 = state_23059;
(statearr_23111[(25)] = inst_23017);

(statearr_23111[(26)] = inst_23018);

return statearr_23111;
})();
var statearr_23112_23163 = state_23059__$1;
(statearr_23112_23163[(2)] = inst_23019);

(statearr_23112_23163[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23060 === (16))){
var inst_22992 = (state_23059[(12)]);
var inst_22994 = (state_23059[(10)]);
var inst_22988 = (state_23059[(14)]);
var inst_22991 = (state_23059[(15)]);
var inst_22990 = (state_23059[(8)]);
var inst_22993 = (state_23059[(16)]);
var inst_22998 = (state_23059[(9)]);
var inst_22989 = (state_23059[(17)]);
var inst_22988__$1 = (state_23059[(2)]);
var inst_22989__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22988__$1,cljs.core.cst$kw$submission_DASH_to_DASH_rank);
var inst_22990__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22988__$1,cljs.core.cst$kw$submission_DASH_clicked);
var inst_22991__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22988__$1,cljs.core.cst$kw$submission_DASH_unclicked);
var inst_22992__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22988__$1,cljs.core.cst$kw$filter_DASH_by);
var inst_22993__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22988__$1,cljs.core.cst$kw$new_DASH_columns);
var inst_22994__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22988__$1,cljs.core.cst$kw$re_DASH_render);
var inst_22995 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22996 = [cljs.core.cst$kw$table_DASH_page,cljs.core.cst$kw$submission_DASH_clicked,cljs.core.cst$kw$data];
var inst_22997 = (new cljs.core.PersistentVector(null,3,(5),inst_22995,inst_22996,null));
var inst_22998__$1 = cljs.core.partial.cljs$core$IFn$_invoke$arity$3(om.core.update_BANG_,app_state,inst_22997);
var inst_22999 = (function (){var map__22966 = inst_22988__$1;
var submission_to_rank = inst_22989__$1;
var submission_clicked = inst_22990__$1;
var submission_unclicked = inst_22991__$1;
var filter_by = inst_22992__$1;
var new_columns = inst_22993__$1;
var re_render = inst_22994__$1;
var update_data_BANG_ = inst_22998__$1;
return ((function (map__22966,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_22992,inst_22994,inst_22988,inst_22991,inst_22990,inst_22993,inst_22998,inst_22989,inst_22988__$1,inst_22989__$1,inst_22990__$1,inst_22991__$1,inst_22992__$1,inst_22993__$1,inst_22994__$1,inst_22995,inst_22996,inst_22997,inst_22998__$1,state_val_23060,c__12158__auto__,event_chan){
return (function (field,value){
return cljs.core.first(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (map__22966,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_22992,inst_22994,inst_22988,inst_22991,inst_22990,inst_22993,inst_22998,inst_22989,inst_22988__$1,inst_22989__$1,inst_22990__$1,inst_22991__$1,inst_22992__$1,inst_22993__$1,inst_22994__$1,inst_22995,inst_22996,inst_22997,inst_22998__$1,state_val_23060,c__12158__auto__,event_chan){
return (function (p1__22798_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(value,cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__22798_SHARP_,field));
});})(map__22966,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_22992,inst_22994,inst_22988,inst_22991,inst_22990,inst_22993,inst_22998,inst_22989,inst_22988__$1,inst_22989__$1,inst_22990__$1,inst_22991__$1,inst_22992__$1,inst_22993__$1,inst_22994__$1,inst_22995,inst_22996,inst_22997,inst_22998__$1,state_val_23060,c__12158__auto__,event_chan))
,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(app_state) : cljs.core.deref.call(null,app_state)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data], null))));
});
;})(map__22966,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_22992,inst_22994,inst_22988,inst_22991,inst_22990,inst_22993,inst_22998,inst_22989,inst_22988__$1,inst_22989__$1,inst_22990__$1,inst_22991__$1,inst_22992__$1,inst_22993__$1,inst_22994__$1,inst_22995,inst_22996,inst_22997,inst_22998__$1,state_val_23060,c__12158__auto__,event_chan))
})();
var state_23059__$1 = (function (){var statearr_23113 = state_23059;
(statearr_23113[(12)] = inst_22992__$1);

(statearr_23113[(13)] = inst_22999);

(statearr_23113[(10)] = inst_22994__$1);

(statearr_23113[(14)] = inst_22988__$1);

(statearr_23113[(15)] = inst_22991__$1);

(statearr_23113[(8)] = inst_22990__$1);

(statearr_23113[(16)] = inst_22993__$1);

(statearr_23113[(9)] = inst_22998__$1);

(statearr_23113[(17)] = inst_22989__$1);

return statearr_23113;
})();
if(cljs.core.truth_(inst_22989__$1)){
var statearr_23114_23164 = state_23059__$1;
(statearr_23114_23164[(1)] = (17));

} else {
var statearr_23115_23165 = state_23059__$1;
(statearr_23115_23165[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23060 === (30))){
var state_23059__$1 = state_23059;
var statearr_23116_23166 = state_23059__$1;
(statearr_23116_23166[(2)] = null);

(statearr_23116_23166[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23060 === (10))){
var inst_22983 = (state_23059[(2)]);
var state_23059__$1 = state_23059;
if(cljs.core.truth_(inst_22983)){
var statearr_23117_23167 = state_23059__$1;
(statearr_23117_23167[(1)] = (14));

} else {
var statearr_23118_23168 = state_23059__$1;
(statearr_23118_23168[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23060 === (18))){
var state_23059__$1 = state_23059;
var statearr_23119_23169 = state_23059__$1;
(statearr_23119_23169[(2)] = null);

(statearr_23119_23169[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23060 === (8))){
var inst_22968 = (state_23059[(7)]);
var inst_22973 = inst_22968.cljs$lang$protocol_mask$partition0$;
var inst_22974 = (inst_22973 & (64));
var inst_22975 = inst_22968.cljs$core$ISeq$;
var inst_22976 = (inst_22974) || (inst_22975);
var state_23059__$1 = state_23059;
if(cljs.core.truth_(inst_22976)){
var statearr_23120_23170 = state_23059__$1;
(statearr_23120_23170[(1)] = (11));

} else {
var statearr_23121_23171 = state_23059__$1;
(statearr_23121_23171[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12158__auto__,event_chan))
;
return ((function (switch__12081__auto__,c__12158__auto__,event_chan){
return (function() {
var hatti$views$table$handle_table_events_$_state_machine__12082__auto__ = null;
var hatti$views$table$handle_table_events_$_state_machine__12082__auto____0 = (function (){
var statearr_23125 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23125[(0)] = hatti$views$table$handle_table_events_$_state_machine__12082__auto__);

(statearr_23125[(1)] = (1));

return statearr_23125;
});
var hatti$views$table$handle_table_events_$_state_machine__12082__auto____1 = (function (state_23059){
while(true){
var ret_value__12083__auto__ = (function (){try{while(true){
var result__12084__auto__ = switch__12081__auto__(state_23059);
if(cljs.core.keyword_identical_QMARK_(result__12084__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12084__auto__;
}
break;
}
}catch (e23126){if((e23126 instanceof Object)){
var ex__12085__auto__ = e23126;
var statearr_23127_23172 = state_23059;
(statearr_23127_23172[(5)] = ex__12085__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_23059);

return cljs.core.cst$kw$recur;
} else {
throw e23126;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12083__auto__,cljs.core.cst$kw$recur)){
var G__23173 = state_23059;
state_23059 = G__23173;
continue;
} else {
return ret_value__12083__auto__;
}
break;
}
});
hatti$views$table$handle_table_events_$_state_machine__12082__auto__ = function(state_23059){
switch(arguments.length){
case 0:
return hatti$views$table$handle_table_events_$_state_machine__12082__auto____0.call(this);
case 1:
return hatti$views$table$handle_table_events_$_state_machine__12082__auto____1.call(this,state_23059);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$handle_table_events_$_state_machine__12082__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$handle_table_events_$_state_machine__12082__auto____0;
hatti$views$table$handle_table_events_$_state_machine__12082__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$handle_table_events_$_state_machine__12082__auto____1;
return hatti$views$table$handle_table_events_$_state_machine__12082__auto__;
})()
;})(switch__12081__auto__,c__12158__auto__,event_chan))
})();
var state__12160__auto__ = (function (){var statearr_23128 = (f__12159__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12159__auto__.cljs$core$IFn$_invoke$arity$0() : f__12159__auto__.call(null));
(statearr_23128[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12158__auto__);

return statearr_23128;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12160__auto__);
});})(c__12158__auto__,event_chan))
);

return c__12158__auto__;
});
hatti.views.table.render_options = (function hatti$views$table$render_options(options,owner,colset_BANG_){
var choose_display_key = (function (k){
om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$field_DASH_key,k);

return (colset_BANG_.cljs$core$IFn$_invoke$arity$1 ? colset_BANG_.cljs$core$IFn$_invoke$arity$1(k) : colset_BANG_.call(null,k));
});
var iter__7189__auto__ = ((function (choose_display_key){
return (function hatti$views$table$render_options_$_iter__23192(s__23193){
return (new cljs.core.LazySeq(null,((function (choose_display_key){
return (function (){
var s__23193__$1 = s__23193;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__23193__$1);
if(temp__4657__auto__){
var s__23193__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__23193__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__23193__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__23195 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__23194 = (0);
while(true){
if((i__23194 < size__7188__auto__)){
var vec__23204 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__23194);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23204,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23204,(1),null);
cljs.core.chunk_append(b__23195,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$on_DASH_click,hatti.utils.click_fn(((function (i__23194,vec__23204,k,v,c__7187__auto__,size__7188__auto__,b__23195,s__23193__$2,temp__4657__auto__,choose_display_key){
return (function (){
return choose_display_key(k);
});})(i__23194,vec__23204,k,v,c__7187__auto__,size__7188__auto__,b__23195,s__23193__$2,temp__4657__auto__,choose_display_key))
),cljs.core.cst$kw$href,"#"], null),v], null)], null));

var G__23210 = (i__23194 + (1));
i__23194 = G__23210;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__23195),hatti$views$table$render_options_$_iter__23192(cljs.core.chunk_rest(s__23193__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__23195),null);
}
} else {
var vec__23207 = cljs.core.first(s__23193__$2);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23207,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23207,(1),null);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$on_DASH_click,hatti.utils.click_fn(((function (vec__23207,k,v,s__23193__$2,temp__4657__auto__,choose_display_key){
return (function (){
return choose_display_key(k);
});})(vec__23207,k,v,s__23193__$2,temp__4657__auto__,choose_display_key))
),cljs.core.cst$kw$href,"#"], null),v], null)], null),hatti$views$table$render_options_$_iter__23192(cljs.core.rest(s__23193__$2)));
}
} else {
return null;
}
break;
}
});})(choose_display_key))
,null,null));
});})(choose_display_key))
;
return iter__7189__auto__(options);
});
hatti.views.label_changer.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (_,owner){
if(typeof hatti.views.table.t_hatti$views$table23212 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRenderState}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IInitState}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table23212 = (function (_,owner,meta23213){
this._ = _;
this.owner = owner;
this.meta23213 = meta23213;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table23212.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_23214,meta23213__$1){
var self__ = this;
var _23214__$1 = this;
return (new hatti.views.table.t_hatti$views$table23212(self__._,self__.owner,meta23213__$1));
});

hatti.views.table.t_hatti$views$table23212.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_23214){
var self__ = this;
var _23214__$1 = this;
return self__.meta23213;
});

hatti.views.table.t_hatti$views$table23212.prototype.om$core$IInitState$ = true;

hatti.views.table.t_hatti$views$table23212.prototype.om$core$IInitState$init_state$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$field_DASH_key,cljs.core.cst$kw$label], null);
});

hatti.views.table.t_hatti$views$table23212.prototype.om$core$IRenderState$ = true;

hatti.views.table.t_hatti$views$table23212.prototype.om$core$IRenderState$render_state$arity$2 = (function (___$1,p__23215){
var self__ = this;
var map__23216 = p__23215;
var map__23216__$1 = ((((!((map__23216 == null)))?((((map__23216.cljs$lang$protocol_mask$partition0$ & (64))) || (map__23216.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__23216):map__23216);
var field_key = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23216__$1,cljs.core.cst$kw$field_DASH_key);
var language = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23216__$1,cljs.core.cst$kw$language);
var ___$2 = this;
var options = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$label,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$strong,"Label"], null),cljs.core.cst$kw$name,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$strong,"Name"], null)], null);
var map__23218 = om.core.get_shared.cljs$core$IFn$_invoke$arity$1(self__.owner);
var map__23218__$1 = ((((!((map__23218 == null)))?((((map__23218.cljs$lang$protocol_mask$partition0$ & (64))) || (map__23218.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__23218):map__23218);
var flat_form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23218__$1,cljs.core.cst$kw$flat_DASH_form);
var new_language = cljs.core.cst$kw$current.cljs$core$IFn$_invoke$arity$1(om.core.observe(self__.owner,hatti.shared.language_cursor()));
var colset_BANG_ = ((function (options,map__23218,map__23218__$1,flat_form,new_language,___$2,map__23216,map__23216__$1,field_key,language){
return (function (p1__23211_SHARP_){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$new_DASH_columns,hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic(flat_form,cljs.core.array_seq([cljs.core.cst$kw$get_DASH_label_QMARK_,cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$label,p1__23211_SHARP_),cljs.core.cst$kw$language,new_language], 0))], null));
});})(options,map__23218,map__23218__$1,flat_form,new_language,___$2,map__23216,map__23216__$1,field_key,language))
;
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(new_language,language)){
om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(self__.owner,cljs.core.cst$kw$language,new_language);

colset_BANG_(field_key);
} else {
}

var G__23228 = ({"className": "label-changer"});
var G__23229 = (function (){var G__23231 = ({"className": "label-changer-label"});
var G__23232 = "Show:";
return React.DOM.span(G__23231,G__23232);
})();
var G__23230 = (function (){var G__23233 = ({"id": "header-display-dropdown", "className": "drop-hover"});
var G__23234 = (function (){var attrs23222 = (options.cljs$core$IFn$_invoke$arity$1 ? options.cljs$core$IFn$_invoke$arity$1(field_key) : options.call(null,field_key));
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(React.DOM.span,((cljs.core.map_QMARK_(attrs23222))?sablono.interpreter.attributes(attrs23222):null),cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,((cljs.core.map_QMARK_(attrs23222))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__23236 = ({"className": "fa fa-angle-down"});
return React.DOM.i(G__23236);
})()], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret(attrs23222),(function (){var G__23237 = ({"className": "fa fa-angle-down"});
return React.DOM.i(G__23237);
})()], null))));
})();
var G__23235 = (function (){var attrs23227 = hatti.views.table.render_options(options,self__.owner,colset_BANG_);
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(React.DOM.ul,((cljs.core.map_QMARK_(attrs23227))?sablono.interpreter.attributes(sablono.util.merge_with_class.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["submenu","no-dot"], null)], null),attrs23227], 0))):({"className": "submenu no-dot"})),cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,((cljs.core.map_QMARK_(attrs23227))?cljs.core.PersistentVector.EMPTY:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret(attrs23227)], null))));
})();
return React.DOM.div(G__23233,G__23234,G__23235);
})();
return React.DOM.div(G__23228,G__23229,G__23230);
});

hatti.views.table.t_hatti$views$table23212.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta23213], null);
});

hatti.views.table.t_hatti$views$table23212.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table23212.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table23212";

hatti.views.table.t_hatti$views$table23212.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"hatti.views.table/t_hatti$views$table23212");
});

hatti.views.table.__GT_t_hatti$views$table23212 = (function hatti$views$table$__GT_t_hatti$views$table23212(___$1,owner__$1,meta23213){
return (new hatti.views.table.t_hatti$views$table23212(___$1,owner__$1,meta23213));
});

}

return (new hatti.views.table.t_hatti$views$table23212(_,owner,cljs.core.PersistentArrayMap.EMPTY));
}));
/**
 * Delayed search fires a query-event on event-chan if the value of the input
 * doesn't change within 150 ms (ie, user is still typing).
 * Call on-change or on-key-up, with (.-target event) as first argument.
 */
hatti.views.table.delayed_search = (function hatti$views$table$delayed_search(input,query_event_key){
var query = input.value;
var c__12158__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12158__auto__,query){
return (function (){
var f__12159__auto__ = (function (){var switch__12081__auto__ = ((function (c__12158__auto__,query){
return (function (state_23280){
var state_val_23281 = (state_23280[(1)]);
if((state_val_23281 === (1))){
var inst_23266 = cljs.core.async.timeout((150));
var state_23280__$1 = state_23280;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23280__$1,(2),inst_23266);
} else {
if((state_val_23281 === (2))){
var inst_23268 = (state_23280[(2)]);
var inst_23269 = input.value;
var inst_23270 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(query,inst_23269);
var state_23280__$1 = (function (){var statearr_23282 = state_23280;
(statearr_23282[(7)] = inst_23268);

return statearr_23282;
})();
if(inst_23270){
var statearr_23283_23294 = state_23280__$1;
(statearr_23283_23294[(1)] = (3));

} else {
var statearr_23284_23295 = state_23280__$1;
(statearr_23284_23295[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23281 === (3))){
var inst_23272 = [query_event_key];
var inst_23273 = [query];
var inst_23274 = cljs.core.PersistentHashMap.fromArrays(inst_23272,inst_23273);
var inst_23275 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_chan,inst_23274);
var state_23280__$1 = state_23280;
var statearr_23285_23296 = state_23280__$1;
(statearr_23285_23296[(2)] = inst_23275);

(statearr_23285_23296[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23281 === (4))){
var state_23280__$1 = state_23280;
var statearr_23286_23297 = state_23280__$1;
(statearr_23286_23297[(2)] = null);

(statearr_23286_23297[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23281 === (5))){
var inst_23278 = (state_23280[(2)]);
var state_23280__$1 = state_23280;
return cljs.core.async.impl.ioc_helpers.return_chan(state_23280__$1,inst_23278);
} else {
return null;
}
}
}
}
}
});})(c__12158__auto__,query))
;
return ((function (switch__12081__auto__,c__12158__auto__,query){
return (function() {
var hatti$views$table$delayed_search_$_state_machine__12082__auto__ = null;
var hatti$views$table$delayed_search_$_state_machine__12082__auto____0 = (function (){
var statearr_23290 = [null,null,null,null,null,null,null,null];
(statearr_23290[(0)] = hatti$views$table$delayed_search_$_state_machine__12082__auto__);

(statearr_23290[(1)] = (1));

return statearr_23290;
});
var hatti$views$table$delayed_search_$_state_machine__12082__auto____1 = (function (state_23280){
while(true){
var ret_value__12083__auto__ = (function (){try{while(true){
var result__12084__auto__ = switch__12081__auto__(state_23280);
if(cljs.core.keyword_identical_QMARK_(result__12084__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12084__auto__;
}
break;
}
}catch (e23291){if((e23291 instanceof Object)){
var ex__12085__auto__ = e23291;
var statearr_23292_23298 = state_23280;
(statearr_23292_23298[(5)] = ex__12085__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_23280);

return cljs.core.cst$kw$recur;
} else {
throw e23291;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12083__auto__,cljs.core.cst$kw$recur)){
var G__23299 = state_23280;
state_23280 = G__23299;
continue;
} else {
return ret_value__12083__auto__;
}
break;
}
});
hatti$views$table$delayed_search_$_state_machine__12082__auto__ = function(state_23280){
switch(arguments.length){
case 0:
return hatti$views$table$delayed_search_$_state_machine__12082__auto____0.call(this);
case 1:
return hatti$views$table$delayed_search_$_state_machine__12082__auto____1.call(this,state_23280);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$delayed_search_$_state_machine__12082__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$delayed_search_$_state_machine__12082__auto____0;
hatti$views$table$delayed_search_$_state_machine__12082__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$delayed_search_$_state_machine__12082__auto____1;
return hatti$views$table$delayed_search_$_state_machine__12082__auto__;
})()
;})(switch__12081__auto__,c__12158__auto__,query))
})();
var state__12160__auto__ = (function (){var statearr_23293 = (f__12159__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12159__auto__.cljs$core$IFn$_invoke$arity$0() : f__12159__auto__.call(null));
(statearr_23293[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12158__auto__);

return statearr_23293;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12160__auto__);
});})(c__12158__auto__,query))
);

return c__12158__auto__;
});
hatti.views.table_search.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (_,owner){
if(typeof hatti.views.table.t_hatti$views$table23301 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table23301 = (function (_,owner,meta23302){
this._ = _;
this.owner = owner;
this.meta23302 = meta23302;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table23301.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_23303,meta23302__$1){
var self__ = this;
var _23303__$1 = this;
return (new hatti.views.table.t_hatti$views$table23301(self__._,self__.owner,meta23302__$1));
});

hatti.views.table.t_hatti$views$table23301.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_23303){
var self__ = this;
var _23303__$1 = this;
return self__.meta23302;
});

hatti.views.table.t_hatti$views$table23301.prototype.om$core$IRender$ = true;

hatti.views.table.t_hatti$views$table23301.prototype.om$core$IRender$render$arity$1 = (function (this__15775__auto__){
var self__ = this;
var this__15775__auto____$1 = this;
var G__23306 = ({"className": "table-search"});
var G__23307 = (function (){var G__23309 = ({"className": "fa fa-search"});
return React.DOM.i(G__23309);
})();
var G__23308 = (function (){var G__23310 = ({"type": "text", "placeholder": "Search", "onChange": ((function (G__23306,G__23307,this__15775__auto____$1){
return (function (p1__23300_SHARP_){
return hatti.views.table.delayed_search(p1__23300_SHARP_.target,cljs.core.cst$kw$filter_DASH_by);
});})(G__23306,G__23307,this__15775__auto____$1))
});
return (sablono.interpreter.input.cljs$core$IFn$_invoke$arity$1 ? sablono.interpreter.input.cljs$core$IFn$_invoke$arity$1(G__23310) : sablono.interpreter.input.call(null,G__23310));
})();
return React.DOM.div(G__23306,G__23307,G__23308);
});

hatti.views.table.t_hatti$views$table23301.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta23302], null);
});

hatti.views.table.t_hatti$views$table23301.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table23301.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table23301";

hatti.views.table.t_hatti$views$table23301.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"hatti.views.table/t_hatti$views$table23301");
});

hatti.views.table.__GT_t_hatti$views$table23301 = (function hatti$views$table$__GT_t_hatti$views$table23301(___$1,owner__$1,meta23302){
return (new hatti.views.table.t_hatti$views$table23301(___$1,owner__$1,meta23302));
});

}

return (new hatti.views.table.t_hatti$views$table23301(_,owner,null));
}));
hatti.views.table_header.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (cursor,owner){
if(typeof hatti.views.table.t_hatti$views$table23311 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table23311 = (function (cursor,owner,meta23312){
this.cursor = cursor;
this.owner = owner;
this.meta23312 = meta23312;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table23311.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_23313,meta23312__$1){
var self__ = this;
var _23313__$1 = this;
return (new hatti.views.table.t_hatti$views$table23311(self__.cursor,self__.owner,meta23312__$1));
});

hatti.views.table.t_hatti$views$table23311.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_23313){
var self__ = this;
var _23313__$1 = this;
return self__.meta23312;
});

hatti.views.table.t_hatti$views$table23311.prototype.om$core$IRender$ = true;

hatti.views.table.t_hatti$views$table23311.prototype.om$core$IRender$render$arity$1 = (function (this__15775__auto__){
var self__ = this;
var this__15775__auto____$1 = this;
var G__23316 = ({"className": "topbar"});
var G__23317 = (function (){var G__23321 = ({"id": hatti.views.table.pager_id});
return React.DOM.div(G__23321);
})();
var G__23318 = sablono.interpreter.interpret(om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.views.label_changer,self__.cursor));
var G__23319 = sablono.interpreter.interpret(om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.views.table_search,self__.cursor));
var G__23320 = (function (){var G__23322 = ({"style": ({"clear": "both"})});
return React.DOM.div(G__23322);
})();
return React.DOM.div(G__23316,G__23317,G__23318,G__23319,G__23320);
});

hatti.views.table.t_hatti$views$table23311.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$cursor,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta23312], null);
});

hatti.views.table.t_hatti$views$table23311.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table23311.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table23311";

hatti.views.table.t_hatti$views$table23311.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"hatti.views.table/t_hatti$views$table23311");
});

hatti.views.table.__GT_t_hatti$views$table23311 = (function hatti$views$table$__GT_t_hatti$views$table23311(cursor__$1,owner__$1,meta23312){
return (new hatti.views.table.t_hatti$views$table23311(cursor__$1,owner__$1,meta23312));
});

}

return (new hatti.views.table.t_hatti$views$table23311(cursor,owner,null));
}));
/**
 * Initializes grid + dataview, and stores them in owner's state.
 */
hatti.views.table.init_grid_BANG_ = (function hatti$views$table$init_grid_BANG_(data,owner,slick_grid_event_handlers){
if(cljs.core.seq(data)){
var map__23328 = om.core.get_shared.cljs$core$IFn$_invoke$arity$1(owner);
var map__23328__$1 = ((((!((map__23328 == null)))?((((map__23328.cljs$lang$protocol_mask$partition0$ & (64))) || (map__23328.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__23328):map__23328);
var flat_form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23328__$1,cljs.core.cst$kw$flat_DASH_form);
var is_filtered_dataview_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23328__$1,cljs.core.cst$kw$is_DASH_filtered_DASH_dataview_QMARK_);
var current_language = cljs.core.cst$kw$current.cljs$core$IFn$_invoke$arity$1(om.core.observe(owner,hatti.shared.language_cursor()));
var vec__23329 = hatti.views.table.sg_init(data,flat_form,current_language,is_filtered_dataview_QMARK_,owner,slick_grid_event_handlers);
var grid = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23329,(0),null);
var dataview = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23329,(1),null);
om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$grid,grid);

om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$dataview,dataview);

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [grid,dataview], null);
} else {
return null;
}
});
hatti.views.table.get_table_view_height = (function hatti$views$table$get_table_view_height(){
return (document.querySelector("body").clientHeight - document.querySelector(".tab-page").getBoundingClientRect().top);
});
hatti.views.table.set_window_resize_handler = (function hatti$views$table$set_window_resize_handler(owner){
var resize_handler = (function (event){
return om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$table_DASH_view_DASH_height,hatti.views.table.get_table_view_height());
});
window.addEventListener("resize",resize_handler);

return om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$resize_DASH_handler,resize_handler);
});
hatti.views.table_page.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (p__23334,owner,p__23335){
var map__23336 = p__23334;
var map__23336__$1 = ((((!((map__23336 == null)))?((((map__23336.cljs$lang$protocol_mask$partition0$ & (64))) || (map__23336.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__23336):map__23336);
var cursor = map__23336__$1;
var map__23337 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23336__$1,cljs.core.cst$kw$views);
var map__23337__$1 = ((((!((map__23337 == null)))?((((map__23337.cljs$lang$protocol_mask$partition0$ & (64))) || (map__23337.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__23337):map__23337);
var active = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23337__$1,cljs.core.cst$kw$active);
var map__23338 = p__23335;
var map__23338__$1 = ((((!((map__23338 == null)))?((((map__23338.cljs$lang$protocol_mask$partition0$ & (64))) || (map__23338.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__23338):map__23338);
var opts = map__23338__$1;
var slick_grid_event_handlers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23338__$1,cljs.core.cst$kw$slick_DASH_grid_DASH_event_DASH_handlers);

var active_QMARK_ = chimera.seq.in_QMARK_(active,cljs.core.cst$kw$table);
if(typeof hatti.views.table.t_hatti$views$table23342 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IWillUnmount}
 * @implements {om.core.IRenderState}
 * @implements {om.core.IWillReceiveProps}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IDidMount}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table23342 = (function (map__23337,owner,active_QMARK_,p__23334,slick_grid_event_handlers,map__23338,cursor,p__23335,map__23336,active,opts,meta23343){
this.map__23337 = map__23337;
this.owner = owner;
this.active_QMARK_ = active_QMARK_;
this.p__23334 = p__23334;
this.slick_grid_event_handlers = slick_grid_event_handlers;
this.map__23338 = map__23338;
this.cursor = cursor;
this.p__23335 = p__23335;
this.map__23336 = map__23336;
this.active = active;
this.opts = opts;
this.meta23343 = meta23343;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table23342.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (active_QMARK_,map__23336,map__23336__$1,cursor,map__23337,map__23337__$1,active,map__23338,map__23338__$1,opts,slick_grid_event_handlers){
return (function (_23344,meta23343__$1){
var self__ = this;
var _23344__$1 = this;
return (new hatti.views.table.t_hatti$views$table23342(self__.map__23337,self__.owner,self__.active_QMARK_,self__.p__23334,self__.slick_grid_event_handlers,self__.map__23338,self__.cursor,self__.p__23335,self__.map__23336,self__.active,self__.opts,meta23343__$1));
});})(active_QMARK_,map__23336,map__23336__$1,cursor,map__23337,map__23337__$1,active,map__23338,map__23338__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table23342.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (active_QMARK_,map__23336,map__23336__$1,cursor,map__23337,map__23337__$1,active,map__23338,map__23338__$1,opts,slick_grid_event_handlers){
return (function (_23344){
var self__ = this;
var _23344__$1 = this;
return self__.meta23343;
});})(active_QMARK_,map__23336,map__23336__$1,cursor,map__23337,map__23337__$1,active,map__23338,map__23338__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table23342.prototype.om$core$IRenderState$ = true;

hatti.views.table.t_hatti$views$table23342.prototype.om$core$IRenderState$render_state$arity$2 = ((function (active_QMARK_,map__23336,map__23336__$1,cursor,map__23337,map__23337__$1,active,map__23338,map__23338__$1,opts,slick_grid_event_handlers){
return (function (_,p__23345){
var self__ = this;
var map__23346 = p__23345;
var map__23346__$1 = ((((!((map__23346 == null)))?((((map__23346.cljs$lang$protocol_mask$partition0$ & (64))) || (map__23346.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__23346):map__23346);
var table_view_height = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23346__$1,cljs.core.cst$kw$table_DASH_view_DASH_height);
var ___$1 = this;
var map__23348 = self__.cursor;
var map__23348__$1 = ((((!((map__23348 == null)))?((((map__23348.cljs$lang$protocol_mask$partition0$ & (64))) || (map__23348.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__23348):map__23348);
var map__23349 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23348__$1,cljs.core.cst$kw$table_DASH_page);
var map__23349__$1 = ((((!((map__23349 == null)))?((((map__23349.cljs$lang$protocol_mask$partition0$ & (64))) || (map__23349.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__23349):map__23349);
var prevent_scrolling_in_table_view_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23349__$1,cljs.core.cst$kw$prevent_DASH_scrolling_DASH_in_DASH_table_DASH_view_QMARK_);
var submission_clicked = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23349__$1,cljs.core.cst$kw$submission_DASH_clicked);
var data = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23348__$1,cljs.core.cst$kw$data);
var dataset_info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23348__$1,cljs.core.cst$kw$dataset_DASH_info);
var map__23350 = dataset_info;
var map__23350__$1 = ((((!((map__23350 == null)))?((((map__23350.cljs$lang$protocol_mask$partition0$ & (64))) || (map__23350.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__23350):map__23350);
var num_of_submissions = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23350__$1,cljs.core.cst$kw$num_of_submissions);
var no_data_QMARK_ = cljs.core.empty_QMARK_(data);
var with_info = ((function (map__23348,map__23348__$1,map__23349,map__23349__$1,prevent_scrolling_in_table_view_QMARK_,submission_clicked,data,dataset_info,map__23350,map__23350__$1,num_of_submissions,no_data_QMARK_,___$1,map__23346,map__23346__$1,table_view_height,active_QMARK_,map__23336,map__23336__$1,cursor,map__23337,map__23337__$1,active,map__23338,map__23338__$1,opts,slick_grid_event_handlers){
return (function (p1__23333_SHARP_){
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([self__.cursor,p1__23333_SHARP_], 0));
});})(map__23348,map__23348__$1,map__23349,map__23349__$1,prevent_scrolling_in_table_view_QMARK_,submission_clicked,data,dataset_info,map__23350,map__23350__$1,num_of_submissions,no_data_QMARK_,___$1,map__23346,map__23346__$1,table_view_height,active_QMARK_,map__23336,map__23336__$1,cursor,map__23337,map__23337__$1,active,map__23338,map__23338__$1,opts,slick_grid_event_handlers))
;
if(cljs.core.truth_(self__.active_QMARK_)){
var G__23354 = ({"style": cljs.core.clj__GT_js((cljs.core.truth_(prevent_scrolling_in_table_view_QMARK_)?new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$height,(function (){var or__6409__auto__ = table_view_height;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return hatti.views.table.get_table_view_height();
}
})(),cljs.core.cst$kw$overflow,"hidden"], null):null)), "className": "table-view"});
var G__23355 = sablono.interpreter.interpret((cljs.core.truth_(cljs.core.cst$kw$data.cljs$core$IFn$_invoke$arity$1(submission_clicked))?om.core.build.cljs$core$IFn$_invoke$arity$3(hatti.views.submission_view,with_info(submission_clicked),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$opts,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.select_keys(self__.opts,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$role,null,cljs.core.cst$kw$delete_DASH_record_BANG_,null], null), null)),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$view,cljs.core.cst$kw$table], null)], 0))], null)):null));
var G__23356 = sablono.interpreter.interpret(om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.views.table_header,self__.cursor));
var G__23357 = (function (){var G__23358 = ({"id": hatti.views.table.table_id, "className": "slickgrid"});
var G__23359 = (((no_data_QMARK_) && ((num_of_submissions === (0))))?(function (){var G__23364 = ({"className": "alert alert-warning"});
var G__23365 = "No data";
return React.DOM.p(G__23364,G__23365);
})():(function (){var G__23366 = null;
var G__23367 = (function (){var G__23369 = ({"className": "fa fa-spinner fa-pulse"});
return React.DOM.i(G__23369);
})();
var G__23368 = "Loading...";
return React.DOM.span(G__23366,G__23367,G__23368);
})());
return React.DOM.div(G__23358,G__23359);
})();
return React.DOM.div(G__23354,G__23355,G__23356,G__23357);
} else {
return null;
}
});})(active_QMARK_,map__23336,map__23336__$1,cursor,map__23337,map__23337__$1,active,map__23338,map__23338__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table23342.prototype.om$core$IDidMount$ = true;

hatti.views.table.t_hatti$views$table23342.prototype.om$core$IDidMount$did_mount$arity$1 = ((function (active_QMARK_,map__23336,map__23336__$1,cursor,map__23337,map__23337__$1,active,map__23338,map__23338__$1,opts,slick_grid_event_handlers){
return (function (_){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.active_QMARK_)){
hatti.views.table.set_window_resize_handler(self__.owner);

var data = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.cursor,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data], null));
var temp__4657__auto__ = hatti.views.table.init_grid_BANG_(data,self__.owner,self__.slick_grid_event_handlers);
if(cljs.core.truth_(temp__4657__auto__)){
var vec__23370 = temp__4657__auto__;
var grid = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23370,(0),null);
var dataview = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23370,(1),null);
return hatti.views.table.handle_table_events(self__.cursor,grid,dataview);
} else {
return null;
}
} else {
return null;
}
});})(active_QMARK_,map__23336,map__23336__$1,cursor,map__23337,map__23337__$1,active,map__23338,map__23338__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table23342.prototype.om$core$IWillUnmount$ = true;

hatti.views.table.t_hatti$views$table23342.prototype.om$core$IWillUnmount$will_unmount$arity$1 = ((function (active_QMARK_,map__23336,map__23336__$1,cursor,map__23337,map__23337__$1,active,map__23338,map__23338__$1,opts,slick_grid_event_handlers){
return (function (_){
var self__ = this;
var ___$1 = this;
return window.removeEventListener("resize",om.core.get_state.cljs$core$IFn$_invoke$arity$2(self__.owner,cljs.core.cst$kw$resize_DASH_handler));
});})(active_QMARK_,map__23336,map__23336__$1,cursor,map__23337,map__23337__$1,active,map__23338,map__23338__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table23342.prototype.om$core$IWillReceiveProps$ = true;

hatti.views.table.t_hatti$views$table23342.prototype.om$core$IWillReceiveProps$will_receive_props$arity$2 = ((function (active_QMARK_,map__23336,map__23336__$1,cursor,map__23337,map__23337__$1,active,map__23338,map__23338__$1,opts,slick_grid_event_handlers){
return (function (_,next_props){
var self__ = this;
var ___$1 = this;

if(cljs.core.truth_(self__.active_QMARK_)){
var old_data = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(om.core.get_props.cljs$core$IFn$_invoke$arity$1(self__.owner),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data], null));
var new_data = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(next_props,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data], null));
var map__23373 = om.core.get_state.cljs$core$IFn$_invoke$arity$1(self__.owner);
var map__23373__$1 = ((((!((map__23373 == null)))?((((map__23373.cljs$lang$protocol_mask$partition0$ & (64))) || (map__23373.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__23373):map__23373);
var grid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23373__$1,cljs.core.cst$kw$grid);
var dataview = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23373__$1,cljs.core.cst$kw$dataview);
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(old_data,new_data)){
if(cljs.core.empty_QMARK_(old_data)){
var temp__4657__auto__ = hatti.views.table.init_grid_BANG_(new_data,self__.owner,self__.slick_grid_event_handlers);
if(cljs.core.truth_(temp__4657__auto__)){
var vec__23375 = temp__4657__auto__;
var grid__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23375,(0),null);
var dataview__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23375,(1),null);
return hatti.views.table.handle_table_events(self__.cursor,grid__$1,dataview__$1);
} else {
return null;
}
} else {
grid.invalidateAllRows();

dataview.setItems(cljs.core.clj__GT_js(new_data),hatti.constants._id);

return grid.render();
}
} else {
return null;
}
} else {
return null;
}
});})(active_QMARK_,map__23336,map__23336__$1,cursor,map__23337,map__23337__$1,active,map__23338,map__23338__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table23342.getBasis = ((function (active_QMARK_,map__23336,map__23336__$1,cursor,map__23337,map__23337__$1,active,map__23338,map__23338__$1,opts,slick_grid_event_handlers){
return (function (){
return new cljs.core.PersistentVector(null, 12, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$map__23337,cljs.core.cst$sym$owner,cljs.core.cst$sym$active_QMARK_,cljs.core.cst$sym$p__23334,cljs.core.cst$sym$slick_DASH_grid_DASH_event_DASH_handlers,cljs.core.cst$sym$map__23338,cljs.core.cst$sym$cursor,cljs.core.cst$sym$p__23335,cljs.core.cst$sym$map__23336,cljs.core.cst$sym$active,cljs.core.cst$sym$opts,cljs.core.cst$sym$meta23343], null);
});})(active_QMARK_,map__23336,map__23336__$1,cursor,map__23337,map__23337__$1,active,map__23338,map__23338__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table23342.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table23342.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table23342";

hatti.views.table.t_hatti$views$table23342.cljs$lang$ctorPrWriter = ((function (active_QMARK_,map__23336,map__23336__$1,cursor,map__23337,map__23337__$1,active,map__23338,map__23338__$1,opts,slick_grid_event_handlers){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"hatti.views.table/t_hatti$views$table23342");
});})(active_QMARK_,map__23336,map__23336__$1,cursor,map__23337,map__23337__$1,active,map__23338,map__23338__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.__GT_t_hatti$views$table23342 = ((function (active_QMARK_,map__23336,map__23336__$1,cursor,map__23337,map__23337__$1,active,map__23338,map__23338__$1,opts,slick_grid_event_handlers){
return (function hatti$views$table$__GT_t_hatti$views$table23342(map__23337__$2,owner__$1,active_QMARK___$1,p__23334__$1,slick_grid_event_handlers__$1,map__23338__$2,cursor__$1,p__23335__$1,map__23336__$2,active__$1,opts__$1,meta23343){
return (new hatti.views.table.t_hatti$views$table23342(map__23337__$2,owner__$1,active_QMARK___$1,p__23334__$1,slick_grid_event_handlers__$1,map__23338__$2,cursor__$1,p__23335__$1,map__23336__$2,active__$1,opts__$1,meta23343));
});})(active_QMARK_,map__23336,map__23336__$1,cursor,map__23337,map__23337__$1,active,map__23338,map__23338__$1,opts,slick_grid_event_handlers))
;

}

return (new hatti.views.table.t_hatti$views$table23342(map__23337__$1,owner,active_QMARK_,p__23334,slick_grid_event_handlers,map__23338__$1,cursor,p__23335,map__23336__$1,active,opts,cljs.core.PersistentArrayMap.EMPTY));
}));
