// Compiled by ClojureScript 1.9.229 {:static-fns true, :optimize-constants true}
goog.provide('sablono.core');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('clojure.walk');
goog.require('sablono.util');
goog.require('sablono.interpreter');
goog.require('goog.dom');
/**
 * Add an optional attribute argument to a function that returns a element vector.
 */
sablono.core.wrap_attrs = (function sablono$core$wrap_attrs(func){
return (function() { 
var G__37473__delegate = function (args){
if(cljs.core.map_QMARK_(cljs.core.first(args))){
var vec__37470 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(func,cljs.core.rest(args));
var seq__37471 = cljs.core.seq(vec__37470);
var first__37472 = cljs.core.first(seq__37471);
var seq__37471__$1 = cljs.core.next(seq__37471);
var tag = first__37472;
var body = seq__37471__$1;
if(cljs.core.map_QMARK_(cljs.core.first(body))){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$4(cljs.core.vector,tag,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.first(body),cljs.core.first(args)], 0)),cljs.core.rest(body));
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$4(cljs.core.vector,tag,cljs.core.first(args),body);
}
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(func,args);
}
};
var G__37473 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__37474__i = 0, G__37474__a = new Array(arguments.length -  0);
while (G__37474__i < G__37474__a.length) {G__37474__a[G__37474__i] = arguments[G__37474__i + 0]; ++G__37474__i;}
  args = new cljs.core.IndexedSeq(G__37474__a,0);
} 
return G__37473__delegate.call(this,args);};
G__37473.cljs$lang$maxFixedArity = 0;
G__37473.cljs$lang$applyTo = (function (arglist__37475){
var args = cljs.core.seq(arglist__37475);
return G__37473__delegate(args);
});
G__37473.cljs$core$IFn$_invoke$arity$variadic = G__37473__delegate;
return G__37473;
})()
;
});
sablono.core.update_arglists = (function sablono$core$update_arglists(arglists){
var iter__7189__auto__ = (function sablono$core$update_arglists_$_iter__37482(s__37483){
return (new cljs.core.LazySeq(null,(function (){
var s__37483__$1 = s__37483;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__37483__$1);
if(temp__4657__auto__){
var s__37483__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__37483__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__37483__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__37485 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__37484 = (0);
while(true){
if((i__37484 < size__7188__auto__)){
var args = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__37484);
cljs.core.chunk_append(b__37485,cljs.core.vec(cljs.core.cons(cljs.core.cst$sym$attr_DASH_map_QMARK_,args)));

var G__37488 = (i__37484 + (1));
i__37484 = G__37488;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__37485),sablono$core$update_arglists_$_iter__37482(cljs.core.chunk_rest(s__37483__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__37485),null);
}
} else {
var args = cljs.core.first(s__37483__$2);
return cljs.core.cons(cljs.core.vec(cljs.core.cons(cljs.core.cst$sym$attr_DASH_map_QMARK_,args)),sablono$core$update_arglists_$_iter__37482(cljs.core.rest(s__37483__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__(arglists);
});
/**
 * Render `element` as HTML string.
 */
sablono.core.render = (function sablono$core$render(element){
if(cljs.core.truth_(element)){
return React.renderToString(element);
} else {
return null;
}
});
/**
 * Render `element` as HTML string, without React internal attributes.
 */
sablono.core.render_static = (function sablono$core$render_static(element){
if(cljs.core.truth_(element)){
return React.renderToStaticMarkup(element);
} else {
return null;
}
});
/**
 * Include a list of external stylesheet files.
 */
sablono.core.include_css = (function sablono$core$include_css(var_args){
var args__7491__auto__ = [];
var len__7484__auto___37496 = arguments.length;
var i__7485__auto___37497 = (0);
while(true){
if((i__7485__auto___37497 < len__7484__auto___37496)){
args__7491__auto__.push((arguments[i__7485__auto___37497]));

var G__37498 = (i__7485__auto___37497 + (1));
i__7485__auto___37497 = G__37498;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((0) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((0)),(0),null)):null);
return sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic(argseq__7492__auto__);
});

sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic = (function (styles){
var iter__7189__auto__ = (function sablono$core$iter__37490(s__37491){
return (new cljs.core.LazySeq(null,(function (){
var s__37491__$1 = s__37491;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__37491__$1);
if(temp__4657__auto__){
var s__37491__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__37491__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__37491__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__37493 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__37492 = (0);
while(true){
if((i__37492 < size__7188__auto__)){
var style = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__37492);
cljs.core.chunk_append(b__37493,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$link,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$type,"text/css",cljs.core.cst$kw$href,sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([style], 0)),cljs.core.cst$kw$rel,"stylesheet"], null)], null));

var G__37499 = (i__37492 + (1));
i__37492 = G__37499;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__37493),sablono$core$iter__37490(cljs.core.chunk_rest(s__37491__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__37493),null);
}
} else {
var style = cljs.core.first(s__37491__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$link,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$type,"text/css",cljs.core.cst$kw$href,sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([style], 0)),cljs.core.cst$kw$rel,"stylesheet"], null)], null),sablono$core$iter__37490(cljs.core.rest(s__37491__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__(styles);
});

sablono.core.include_css.cljs$lang$maxFixedArity = (0);

sablono.core.include_css.cljs$lang$applyTo = (function (seq37489){
return sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq37489));
});

/**
 * Include the JavaScript library at `src`.
 */
sablono.core.include_js = (function sablono$core$include_js(src){
var G__37504 = goog.dom.getDocument().body;
var G__37505 = (function (){var G__37506 = "script";
var G__37507 = ({"src": src});
return goog.dom.createDom(G__37506,G__37507);
})();
return goog.dom.appendChild(G__37504,G__37505);
});
/**
 * Include Facebook's React JavaScript library.
 */
sablono.core.include_react = (function sablono$core$include_react(){
return sablono.core.include_js("http://fb.me/react-0.12.2.js");
});
/**
 * Wraps some content in a HTML hyperlink with the supplied URL.
 */
sablono.core.link_to37508 = (function sablono$core$link_to37508(var_args){
var args__7491__auto__ = [];
var len__7484__auto___37511 = arguments.length;
var i__7485__auto___37512 = (0);
while(true){
if((i__7485__auto___37512 < len__7484__auto___37511)){
args__7491__auto__.push((arguments[i__7485__auto___37512]));

var G__37513 = (i__7485__auto___37512 + (1));
i__7485__auto___37512 = G__37513;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return sablono.core.link_to37508.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

sablono.core.link_to37508.cljs$core$IFn$_invoke$arity$variadic = (function (url,content){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$href,sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([url], 0))], null),content], null);
});

sablono.core.link_to37508.cljs$lang$maxFixedArity = (1);

sablono.core.link_to37508.cljs$lang$applyTo = (function (seq37509){
var G__37510 = cljs.core.first(seq37509);
var seq37509__$1 = cljs.core.next(seq37509);
return sablono.core.link_to37508.cljs$core$IFn$_invoke$arity$variadic(G__37510,seq37509__$1);
});


sablono.core.link_to = sablono.core.wrap_attrs(sablono.core.link_to37508);
/**
 * Wraps some content in a HTML hyperlink with the supplied e-mail
 *   address. If no content provided use the e-mail address as content.
 */
sablono.core.mail_to37514 = (function sablono$core$mail_to37514(var_args){
var args__7491__auto__ = [];
var len__7484__auto___37521 = arguments.length;
var i__7485__auto___37522 = (0);
while(true){
if((i__7485__auto___37522 < len__7484__auto___37521)){
args__7491__auto__.push((arguments[i__7485__auto___37522]));

var G__37523 = (i__7485__auto___37522 + (1));
i__7485__auto___37522 = G__37523;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return sablono.core.mail_to37514.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

sablono.core.mail_to37514.cljs$core$IFn$_invoke$arity$variadic = (function (e_mail,p__37517){
var vec__37518 = p__37517;
var content = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37518,(0),null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$href,[cljs.core.str("mailto:"),cljs.core.str(e_mail)].join('')], null),(function (){var or__6409__auto__ = content;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return e_mail;
}
})()], null);
});

sablono.core.mail_to37514.cljs$lang$maxFixedArity = (1);

sablono.core.mail_to37514.cljs$lang$applyTo = (function (seq37515){
var G__37516 = cljs.core.first(seq37515);
var seq37515__$1 = cljs.core.next(seq37515);
return sablono.core.mail_to37514.cljs$core$IFn$_invoke$arity$variadic(G__37516,seq37515__$1);
});


sablono.core.mail_to = sablono.core.wrap_attrs(sablono.core.mail_to37514);
/**
 * Wrap a collection in an unordered list.
 */
sablono.core.unordered_list37524 = (function sablono$core$unordered_list37524(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$ul,(function (){var iter__7189__auto__ = (function sablono$core$unordered_list37524_$_iter__37531(s__37532){
return (new cljs.core.LazySeq(null,(function (){
var s__37532__$1 = s__37532;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__37532__$1);
if(temp__4657__auto__){
var s__37532__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__37532__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__37532__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__37534 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__37533 = (0);
while(true){
if((i__37533 < size__7188__auto__)){
var x = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__37533);
cljs.core.chunk_append(b__37534,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,x], null));

var G__37537 = (i__37533 + (1));
i__37533 = G__37537;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__37534),sablono$core$unordered_list37524_$_iter__37531(cljs.core.chunk_rest(s__37532__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__37534),null);
}
} else {
var x = cljs.core.first(s__37532__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,x], null),sablono$core$unordered_list37524_$_iter__37531(cljs.core.rest(s__37532__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__(coll);
})()], null);
});

sablono.core.unordered_list = sablono.core.wrap_attrs(sablono.core.unordered_list37524);
/**
 * Wrap a collection in an ordered list.
 */
sablono.core.ordered_list37538 = (function sablono$core$ordered_list37538(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$ol,(function (){var iter__7189__auto__ = (function sablono$core$ordered_list37538_$_iter__37545(s__37546){
return (new cljs.core.LazySeq(null,(function (){
var s__37546__$1 = s__37546;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__37546__$1);
if(temp__4657__auto__){
var s__37546__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__37546__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__37546__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__37548 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__37547 = (0);
while(true){
if((i__37547 < size__7188__auto__)){
var x = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__37547);
cljs.core.chunk_append(b__37548,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,x], null));

var G__37551 = (i__37547 + (1));
i__37547 = G__37551;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__37548),sablono$core$ordered_list37538_$_iter__37545(cljs.core.chunk_rest(s__37546__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__37548),null);
}
} else {
var x = cljs.core.first(s__37546__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,x], null),sablono$core$ordered_list37538_$_iter__37545(cljs.core.rest(s__37546__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__(coll);
})()], null);
});

sablono.core.ordered_list = sablono.core.wrap_attrs(sablono.core.ordered_list37538);
/**
 * Create an image element.
 */
sablono.core.image37552 = (function sablono$core$image37552(var_args){
var args37553 = [];
var len__7484__auto___37556 = arguments.length;
var i__7485__auto___37557 = (0);
while(true){
if((i__7485__auto___37557 < len__7484__auto___37556)){
args37553.push((arguments[i__7485__auto___37557]));

var G__37558 = (i__7485__auto___37557 + (1));
i__7485__auto___37557 = G__37558;
continue;
} else {
}
break;
}

var G__37555 = args37553.length;
switch (G__37555) {
case 1:
return sablono.core.image37552.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.image37552.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37553.length)].join('')));

}
});

sablono.core.image37552.cljs$core$IFn$_invoke$arity$1 = (function (src){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$img,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$src,sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([src], 0))], null)], null);
});

sablono.core.image37552.cljs$core$IFn$_invoke$arity$2 = (function (src,alt){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$img,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$src,sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([src], 0)),cljs.core.cst$kw$alt,alt], null)], null);
});

sablono.core.image37552.cljs$lang$maxFixedArity = 2;


sablono.core.image = sablono.core.wrap_attrs(sablono.core.image37552);
sablono.core._STAR_group_STAR_ = cljs.core.PersistentVector.EMPTY;
/**
 * Create a field name from the supplied argument the current field group.
 */
sablono.core.make_name = (function sablono$core$make_name(name){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2((function (p1__37560_SHARP_,p2__37561_SHARP_){
return [cljs.core.str(p1__37560_SHARP_),cljs.core.str("["),cljs.core.str(p2__37561_SHARP_),cljs.core.str("]")].join('');
}),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(sablono.core._STAR_group_STAR_,sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([name], 0))));
});
/**
 * Create a field id from the supplied argument and current field group.
 */
sablono.core.make_id = (function sablono$core$make_id(name){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2((function (p1__37562_SHARP_,p2__37563_SHARP_){
return [cljs.core.str(p1__37562_SHARP_),cljs.core.str("-"),cljs.core.str(p2__37563_SHARP_)].join('');
}),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(sablono.core._STAR_group_STAR_,sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([name], 0))));
});
/**
 * Creates a new <input> element.
 */
sablono.core.input_field_STAR_ = (function sablono$core$input_field_STAR_(type,name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$input,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$type,type,cljs.core.cst$kw$name,sablono.core.make_name(name),cljs.core.cst$kw$id,sablono.core.make_id(name),cljs.core.cst$kw$value,value], null)], null);
});
/**
 * Creates a color input field.
 */
sablono.core.color_field37564 = (function sablono$core$color_field37564(var_args){
var args37565 = [];
var len__7484__auto___37632 = arguments.length;
var i__7485__auto___37633 = (0);
while(true){
if((i__7485__auto___37633 < len__7484__auto___37632)){
args37565.push((arguments[i__7485__auto___37633]));

var G__37634 = (i__7485__auto___37633 + (1));
i__7485__auto___37633 = G__37634;
continue;
} else {
}
break;
}

var G__37567 = args37565.length;
switch (G__37567) {
case 1:
return sablono.core.color_field37564.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.color_field37564.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37565.length)].join('')));

}
});

sablono.core.color_field37564.cljs$core$IFn$_invoke$arity$1 = (function (name__19366__auto__){
return sablono.core.color_field37564.cljs$core$IFn$_invoke$arity$2(name__19366__auto__,null);
});

sablono.core.color_field37564.cljs$core$IFn$_invoke$arity$2 = (function (name__19366__auto__,value__19367__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$color)].join(''),name__19366__auto__,value__19367__auto__);
});

sablono.core.color_field37564.cljs$lang$maxFixedArity = 2;


sablono.core.color_field = sablono.core.wrap_attrs(sablono.core.color_field37564);

/**
 * Creates a date input field.
 */
sablono.core.date_field37568 = (function sablono$core$date_field37568(var_args){
var args37569 = [];
var len__7484__auto___37636 = arguments.length;
var i__7485__auto___37637 = (0);
while(true){
if((i__7485__auto___37637 < len__7484__auto___37636)){
args37569.push((arguments[i__7485__auto___37637]));

var G__37638 = (i__7485__auto___37637 + (1));
i__7485__auto___37637 = G__37638;
continue;
} else {
}
break;
}

var G__37571 = args37569.length;
switch (G__37571) {
case 1:
return sablono.core.date_field37568.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.date_field37568.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37569.length)].join('')));

}
});

sablono.core.date_field37568.cljs$core$IFn$_invoke$arity$1 = (function (name__19366__auto__){
return sablono.core.date_field37568.cljs$core$IFn$_invoke$arity$2(name__19366__auto__,null);
});

sablono.core.date_field37568.cljs$core$IFn$_invoke$arity$2 = (function (name__19366__auto__,value__19367__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$date)].join(''),name__19366__auto__,value__19367__auto__);
});

sablono.core.date_field37568.cljs$lang$maxFixedArity = 2;


sablono.core.date_field = sablono.core.wrap_attrs(sablono.core.date_field37568);

/**
 * Creates a datetime input field.
 */
sablono.core.datetime_field37572 = (function sablono$core$datetime_field37572(var_args){
var args37573 = [];
var len__7484__auto___37640 = arguments.length;
var i__7485__auto___37641 = (0);
while(true){
if((i__7485__auto___37641 < len__7484__auto___37640)){
args37573.push((arguments[i__7485__auto___37641]));

var G__37642 = (i__7485__auto___37641 + (1));
i__7485__auto___37641 = G__37642;
continue;
} else {
}
break;
}

var G__37575 = args37573.length;
switch (G__37575) {
case 1:
return sablono.core.datetime_field37572.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_field37572.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37573.length)].join('')));

}
});

sablono.core.datetime_field37572.cljs$core$IFn$_invoke$arity$1 = (function (name__19366__auto__){
return sablono.core.datetime_field37572.cljs$core$IFn$_invoke$arity$2(name__19366__auto__,null);
});

sablono.core.datetime_field37572.cljs$core$IFn$_invoke$arity$2 = (function (name__19366__auto__,value__19367__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$datetime)].join(''),name__19366__auto__,value__19367__auto__);
});

sablono.core.datetime_field37572.cljs$lang$maxFixedArity = 2;


sablono.core.datetime_field = sablono.core.wrap_attrs(sablono.core.datetime_field37572);

/**
 * Creates a datetime-local input field.
 */
sablono.core.datetime_local_field37576 = (function sablono$core$datetime_local_field37576(var_args){
var args37577 = [];
var len__7484__auto___37644 = arguments.length;
var i__7485__auto___37645 = (0);
while(true){
if((i__7485__auto___37645 < len__7484__auto___37644)){
args37577.push((arguments[i__7485__auto___37645]));

var G__37646 = (i__7485__auto___37645 + (1));
i__7485__auto___37645 = G__37646;
continue;
} else {
}
break;
}

var G__37579 = args37577.length;
switch (G__37579) {
case 1:
return sablono.core.datetime_local_field37576.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_local_field37576.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37577.length)].join('')));

}
});

sablono.core.datetime_local_field37576.cljs$core$IFn$_invoke$arity$1 = (function (name__19366__auto__){
return sablono.core.datetime_local_field37576.cljs$core$IFn$_invoke$arity$2(name__19366__auto__,null);
});

sablono.core.datetime_local_field37576.cljs$core$IFn$_invoke$arity$2 = (function (name__19366__auto__,value__19367__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$datetime_DASH_local)].join(''),name__19366__auto__,value__19367__auto__);
});

sablono.core.datetime_local_field37576.cljs$lang$maxFixedArity = 2;


sablono.core.datetime_local_field = sablono.core.wrap_attrs(sablono.core.datetime_local_field37576);

/**
 * Creates a email input field.
 */
sablono.core.email_field37580 = (function sablono$core$email_field37580(var_args){
var args37581 = [];
var len__7484__auto___37648 = arguments.length;
var i__7485__auto___37649 = (0);
while(true){
if((i__7485__auto___37649 < len__7484__auto___37648)){
args37581.push((arguments[i__7485__auto___37649]));

var G__37650 = (i__7485__auto___37649 + (1));
i__7485__auto___37649 = G__37650;
continue;
} else {
}
break;
}

var G__37583 = args37581.length;
switch (G__37583) {
case 1:
return sablono.core.email_field37580.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.email_field37580.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37581.length)].join('')));

}
});

sablono.core.email_field37580.cljs$core$IFn$_invoke$arity$1 = (function (name__19366__auto__){
return sablono.core.email_field37580.cljs$core$IFn$_invoke$arity$2(name__19366__auto__,null);
});

sablono.core.email_field37580.cljs$core$IFn$_invoke$arity$2 = (function (name__19366__auto__,value__19367__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$email)].join(''),name__19366__auto__,value__19367__auto__);
});

sablono.core.email_field37580.cljs$lang$maxFixedArity = 2;


sablono.core.email_field = sablono.core.wrap_attrs(sablono.core.email_field37580);

/**
 * Creates a file input field.
 */
sablono.core.file_field37584 = (function sablono$core$file_field37584(var_args){
var args37585 = [];
var len__7484__auto___37652 = arguments.length;
var i__7485__auto___37653 = (0);
while(true){
if((i__7485__auto___37653 < len__7484__auto___37652)){
args37585.push((arguments[i__7485__auto___37653]));

var G__37654 = (i__7485__auto___37653 + (1));
i__7485__auto___37653 = G__37654;
continue;
} else {
}
break;
}

var G__37587 = args37585.length;
switch (G__37587) {
case 1:
return sablono.core.file_field37584.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.file_field37584.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37585.length)].join('')));

}
});

sablono.core.file_field37584.cljs$core$IFn$_invoke$arity$1 = (function (name__19366__auto__){
return sablono.core.file_field37584.cljs$core$IFn$_invoke$arity$2(name__19366__auto__,null);
});

sablono.core.file_field37584.cljs$core$IFn$_invoke$arity$2 = (function (name__19366__auto__,value__19367__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$file)].join(''),name__19366__auto__,value__19367__auto__);
});

sablono.core.file_field37584.cljs$lang$maxFixedArity = 2;


sablono.core.file_field = sablono.core.wrap_attrs(sablono.core.file_field37584);

/**
 * Creates a hidden input field.
 */
sablono.core.hidden_field37588 = (function sablono$core$hidden_field37588(var_args){
var args37589 = [];
var len__7484__auto___37656 = arguments.length;
var i__7485__auto___37657 = (0);
while(true){
if((i__7485__auto___37657 < len__7484__auto___37656)){
args37589.push((arguments[i__7485__auto___37657]));

var G__37658 = (i__7485__auto___37657 + (1));
i__7485__auto___37657 = G__37658;
continue;
} else {
}
break;
}

var G__37591 = args37589.length;
switch (G__37591) {
case 1:
return sablono.core.hidden_field37588.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.hidden_field37588.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37589.length)].join('')));

}
});

sablono.core.hidden_field37588.cljs$core$IFn$_invoke$arity$1 = (function (name__19366__auto__){
return sablono.core.hidden_field37588.cljs$core$IFn$_invoke$arity$2(name__19366__auto__,null);
});

sablono.core.hidden_field37588.cljs$core$IFn$_invoke$arity$2 = (function (name__19366__auto__,value__19367__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$hidden)].join(''),name__19366__auto__,value__19367__auto__);
});

sablono.core.hidden_field37588.cljs$lang$maxFixedArity = 2;


sablono.core.hidden_field = sablono.core.wrap_attrs(sablono.core.hidden_field37588);

/**
 * Creates a month input field.
 */
sablono.core.month_field37592 = (function sablono$core$month_field37592(var_args){
var args37593 = [];
var len__7484__auto___37660 = arguments.length;
var i__7485__auto___37661 = (0);
while(true){
if((i__7485__auto___37661 < len__7484__auto___37660)){
args37593.push((arguments[i__7485__auto___37661]));

var G__37662 = (i__7485__auto___37661 + (1));
i__7485__auto___37661 = G__37662;
continue;
} else {
}
break;
}

var G__37595 = args37593.length;
switch (G__37595) {
case 1:
return sablono.core.month_field37592.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.month_field37592.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37593.length)].join('')));

}
});

sablono.core.month_field37592.cljs$core$IFn$_invoke$arity$1 = (function (name__19366__auto__){
return sablono.core.month_field37592.cljs$core$IFn$_invoke$arity$2(name__19366__auto__,null);
});

sablono.core.month_field37592.cljs$core$IFn$_invoke$arity$2 = (function (name__19366__auto__,value__19367__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$month)].join(''),name__19366__auto__,value__19367__auto__);
});

sablono.core.month_field37592.cljs$lang$maxFixedArity = 2;


sablono.core.month_field = sablono.core.wrap_attrs(sablono.core.month_field37592);

/**
 * Creates a number input field.
 */
sablono.core.number_field37596 = (function sablono$core$number_field37596(var_args){
var args37597 = [];
var len__7484__auto___37664 = arguments.length;
var i__7485__auto___37665 = (0);
while(true){
if((i__7485__auto___37665 < len__7484__auto___37664)){
args37597.push((arguments[i__7485__auto___37665]));

var G__37666 = (i__7485__auto___37665 + (1));
i__7485__auto___37665 = G__37666;
continue;
} else {
}
break;
}

var G__37599 = args37597.length;
switch (G__37599) {
case 1:
return sablono.core.number_field37596.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.number_field37596.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37597.length)].join('')));

}
});

sablono.core.number_field37596.cljs$core$IFn$_invoke$arity$1 = (function (name__19366__auto__){
return sablono.core.number_field37596.cljs$core$IFn$_invoke$arity$2(name__19366__auto__,null);
});

sablono.core.number_field37596.cljs$core$IFn$_invoke$arity$2 = (function (name__19366__auto__,value__19367__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$number)].join(''),name__19366__auto__,value__19367__auto__);
});

sablono.core.number_field37596.cljs$lang$maxFixedArity = 2;


sablono.core.number_field = sablono.core.wrap_attrs(sablono.core.number_field37596);

/**
 * Creates a password input field.
 */
sablono.core.password_field37600 = (function sablono$core$password_field37600(var_args){
var args37601 = [];
var len__7484__auto___37668 = arguments.length;
var i__7485__auto___37669 = (0);
while(true){
if((i__7485__auto___37669 < len__7484__auto___37668)){
args37601.push((arguments[i__7485__auto___37669]));

var G__37670 = (i__7485__auto___37669 + (1));
i__7485__auto___37669 = G__37670;
continue;
} else {
}
break;
}

var G__37603 = args37601.length;
switch (G__37603) {
case 1:
return sablono.core.password_field37600.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.password_field37600.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37601.length)].join('')));

}
});

sablono.core.password_field37600.cljs$core$IFn$_invoke$arity$1 = (function (name__19366__auto__){
return sablono.core.password_field37600.cljs$core$IFn$_invoke$arity$2(name__19366__auto__,null);
});

sablono.core.password_field37600.cljs$core$IFn$_invoke$arity$2 = (function (name__19366__auto__,value__19367__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$password)].join(''),name__19366__auto__,value__19367__auto__);
});

sablono.core.password_field37600.cljs$lang$maxFixedArity = 2;


sablono.core.password_field = sablono.core.wrap_attrs(sablono.core.password_field37600);

/**
 * Creates a range input field.
 */
sablono.core.range_field37604 = (function sablono$core$range_field37604(var_args){
var args37605 = [];
var len__7484__auto___37672 = arguments.length;
var i__7485__auto___37673 = (0);
while(true){
if((i__7485__auto___37673 < len__7484__auto___37672)){
args37605.push((arguments[i__7485__auto___37673]));

var G__37674 = (i__7485__auto___37673 + (1));
i__7485__auto___37673 = G__37674;
continue;
} else {
}
break;
}

var G__37607 = args37605.length;
switch (G__37607) {
case 1:
return sablono.core.range_field37604.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.range_field37604.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37605.length)].join('')));

}
});

sablono.core.range_field37604.cljs$core$IFn$_invoke$arity$1 = (function (name__19366__auto__){
return sablono.core.range_field37604.cljs$core$IFn$_invoke$arity$2(name__19366__auto__,null);
});

sablono.core.range_field37604.cljs$core$IFn$_invoke$arity$2 = (function (name__19366__auto__,value__19367__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$range)].join(''),name__19366__auto__,value__19367__auto__);
});

sablono.core.range_field37604.cljs$lang$maxFixedArity = 2;


sablono.core.range_field = sablono.core.wrap_attrs(sablono.core.range_field37604);

/**
 * Creates a search input field.
 */
sablono.core.search_field37608 = (function sablono$core$search_field37608(var_args){
var args37609 = [];
var len__7484__auto___37676 = arguments.length;
var i__7485__auto___37677 = (0);
while(true){
if((i__7485__auto___37677 < len__7484__auto___37676)){
args37609.push((arguments[i__7485__auto___37677]));

var G__37678 = (i__7485__auto___37677 + (1));
i__7485__auto___37677 = G__37678;
continue;
} else {
}
break;
}

var G__37611 = args37609.length;
switch (G__37611) {
case 1:
return sablono.core.search_field37608.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.search_field37608.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37609.length)].join('')));

}
});

sablono.core.search_field37608.cljs$core$IFn$_invoke$arity$1 = (function (name__19366__auto__){
return sablono.core.search_field37608.cljs$core$IFn$_invoke$arity$2(name__19366__auto__,null);
});

sablono.core.search_field37608.cljs$core$IFn$_invoke$arity$2 = (function (name__19366__auto__,value__19367__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$search)].join(''),name__19366__auto__,value__19367__auto__);
});

sablono.core.search_field37608.cljs$lang$maxFixedArity = 2;


sablono.core.search_field = sablono.core.wrap_attrs(sablono.core.search_field37608);

/**
 * Creates a tel input field.
 */
sablono.core.tel_field37612 = (function sablono$core$tel_field37612(var_args){
var args37613 = [];
var len__7484__auto___37680 = arguments.length;
var i__7485__auto___37681 = (0);
while(true){
if((i__7485__auto___37681 < len__7484__auto___37680)){
args37613.push((arguments[i__7485__auto___37681]));

var G__37682 = (i__7485__auto___37681 + (1));
i__7485__auto___37681 = G__37682;
continue;
} else {
}
break;
}

var G__37615 = args37613.length;
switch (G__37615) {
case 1:
return sablono.core.tel_field37612.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.tel_field37612.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37613.length)].join('')));

}
});

sablono.core.tel_field37612.cljs$core$IFn$_invoke$arity$1 = (function (name__19366__auto__){
return sablono.core.tel_field37612.cljs$core$IFn$_invoke$arity$2(name__19366__auto__,null);
});

sablono.core.tel_field37612.cljs$core$IFn$_invoke$arity$2 = (function (name__19366__auto__,value__19367__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$tel)].join(''),name__19366__auto__,value__19367__auto__);
});

sablono.core.tel_field37612.cljs$lang$maxFixedArity = 2;


sablono.core.tel_field = sablono.core.wrap_attrs(sablono.core.tel_field37612);

/**
 * Creates a text input field.
 */
sablono.core.text_field37616 = (function sablono$core$text_field37616(var_args){
var args37617 = [];
var len__7484__auto___37684 = arguments.length;
var i__7485__auto___37685 = (0);
while(true){
if((i__7485__auto___37685 < len__7484__auto___37684)){
args37617.push((arguments[i__7485__auto___37685]));

var G__37686 = (i__7485__auto___37685 + (1));
i__7485__auto___37685 = G__37686;
continue;
} else {
}
break;
}

var G__37619 = args37617.length;
switch (G__37619) {
case 1:
return sablono.core.text_field37616.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_field37616.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37617.length)].join('')));

}
});

sablono.core.text_field37616.cljs$core$IFn$_invoke$arity$1 = (function (name__19366__auto__){
return sablono.core.text_field37616.cljs$core$IFn$_invoke$arity$2(name__19366__auto__,null);
});

sablono.core.text_field37616.cljs$core$IFn$_invoke$arity$2 = (function (name__19366__auto__,value__19367__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$text)].join(''),name__19366__auto__,value__19367__auto__);
});

sablono.core.text_field37616.cljs$lang$maxFixedArity = 2;


sablono.core.text_field = sablono.core.wrap_attrs(sablono.core.text_field37616);

/**
 * Creates a time input field.
 */
sablono.core.time_field37620 = (function sablono$core$time_field37620(var_args){
var args37621 = [];
var len__7484__auto___37688 = arguments.length;
var i__7485__auto___37689 = (0);
while(true){
if((i__7485__auto___37689 < len__7484__auto___37688)){
args37621.push((arguments[i__7485__auto___37689]));

var G__37690 = (i__7485__auto___37689 + (1));
i__7485__auto___37689 = G__37690;
continue;
} else {
}
break;
}

var G__37623 = args37621.length;
switch (G__37623) {
case 1:
return sablono.core.time_field37620.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.time_field37620.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37621.length)].join('')));

}
});

sablono.core.time_field37620.cljs$core$IFn$_invoke$arity$1 = (function (name__19366__auto__){
return sablono.core.time_field37620.cljs$core$IFn$_invoke$arity$2(name__19366__auto__,null);
});

sablono.core.time_field37620.cljs$core$IFn$_invoke$arity$2 = (function (name__19366__auto__,value__19367__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$time)].join(''),name__19366__auto__,value__19367__auto__);
});

sablono.core.time_field37620.cljs$lang$maxFixedArity = 2;


sablono.core.time_field = sablono.core.wrap_attrs(sablono.core.time_field37620);

/**
 * Creates a url input field.
 */
sablono.core.url_field37624 = (function sablono$core$url_field37624(var_args){
var args37625 = [];
var len__7484__auto___37692 = arguments.length;
var i__7485__auto___37693 = (0);
while(true){
if((i__7485__auto___37693 < len__7484__auto___37692)){
args37625.push((arguments[i__7485__auto___37693]));

var G__37694 = (i__7485__auto___37693 + (1));
i__7485__auto___37693 = G__37694;
continue;
} else {
}
break;
}

var G__37627 = args37625.length;
switch (G__37627) {
case 1:
return sablono.core.url_field37624.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.url_field37624.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37625.length)].join('')));

}
});

sablono.core.url_field37624.cljs$core$IFn$_invoke$arity$1 = (function (name__19366__auto__){
return sablono.core.url_field37624.cljs$core$IFn$_invoke$arity$2(name__19366__auto__,null);
});

sablono.core.url_field37624.cljs$core$IFn$_invoke$arity$2 = (function (name__19366__auto__,value__19367__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$url)].join(''),name__19366__auto__,value__19367__auto__);
});

sablono.core.url_field37624.cljs$lang$maxFixedArity = 2;


sablono.core.url_field = sablono.core.wrap_attrs(sablono.core.url_field37624);

/**
 * Creates a week input field.
 */
sablono.core.week_field37628 = (function sablono$core$week_field37628(var_args){
var args37629 = [];
var len__7484__auto___37696 = arguments.length;
var i__7485__auto___37697 = (0);
while(true){
if((i__7485__auto___37697 < len__7484__auto___37696)){
args37629.push((arguments[i__7485__auto___37697]));

var G__37698 = (i__7485__auto___37697 + (1));
i__7485__auto___37697 = G__37698;
continue;
} else {
}
break;
}

var G__37631 = args37629.length;
switch (G__37631) {
case 1:
return sablono.core.week_field37628.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.week_field37628.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37629.length)].join('')));

}
});

sablono.core.week_field37628.cljs$core$IFn$_invoke$arity$1 = (function (name__19366__auto__){
return sablono.core.week_field37628.cljs$core$IFn$_invoke$arity$2(name__19366__auto__,null);
});

sablono.core.week_field37628.cljs$core$IFn$_invoke$arity$2 = (function (name__19366__auto__,value__19367__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$week)].join(''),name__19366__auto__,value__19367__auto__);
});

sablono.core.week_field37628.cljs$lang$maxFixedArity = 2;


sablono.core.week_field = sablono.core.wrap_attrs(sablono.core.week_field37628);
sablono.core.file_upload = sablono.core.file_field;
/**
 * Creates a check box.
 */
sablono.core.check_box37700 = (function sablono$core$check_box37700(var_args){
var args37701 = [];
var len__7484__auto___37704 = arguments.length;
var i__7485__auto___37705 = (0);
while(true){
if((i__7485__auto___37705 < len__7484__auto___37704)){
args37701.push((arguments[i__7485__auto___37705]));

var G__37706 = (i__7485__auto___37705 + (1));
i__7485__auto___37705 = G__37706;
continue;
} else {
}
break;
}

var G__37703 = args37701.length;
switch (G__37703) {
case 1:
return sablono.core.check_box37700.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.check_box37700.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.check_box37700.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37701.length)].join('')));

}
});

sablono.core.check_box37700.cljs$core$IFn$_invoke$arity$1 = (function (name){
return sablono.core.check_box37700.cljs$core$IFn$_invoke$arity$2(name,null);
});

sablono.core.check_box37700.cljs$core$IFn$_invoke$arity$2 = (function (name,checked_QMARK_){
return sablono.core.check_box37700.cljs$core$IFn$_invoke$arity$3(name,checked_QMARK_,"true");
});

sablono.core.check_box37700.cljs$core$IFn$_invoke$arity$3 = (function (name,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$input,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$type,"checkbox",cljs.core.cst$kw$name,sablono.core.make_name(name),cljs.core.cst$kw$id,sablono.core.make_id(name),cljs.core.cst$kw$value,value,cljs.core.cst$kw$checked,checked_QMARK_], null)], null);
});

sablono.core.check_box37700.cljs$lang$maxFixedArity = 3;


sablono.core.check_box = sablono.core.wrap_attrs(sablono.core.check_box37700);
/**
 * Creates a radio button.
 */
sablono.core.radio_button37708 = (function sablono$core$radio_button37708(var_args){
var args37709 = [];
var len__7484__auto___37712 = arguments.length;
var i__7485__auto___37713 = (0);
while(true){
if((i__7485__auto___37713 < len__7484__auto___37712)){
args37709.push((arguments[i__7485__auto___37713]));

var G__37714 = (i__7485__auto___37713 + (1));
i__7485__auto___37713 = G__37714;
continue;
} else {
}
break;
}

var G__37711 = args37709.length;
switch (G__37711) {
case 1:
return sablono.core.radio_button37708.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.radio_button37708.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.radio_button37708.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37709.length)].join('')));

}
});

sablono.core.radio_button37708.cljs$core$IFn$_invoke$arity$1 = (function (group){
return sablono.core.radio_button37708.cljs$core$IFn$_invoke$arity$2(group,null);
});

sablono.core.radio_button37708.cljs$core$IFn$_invoke$arity$2 = (function (group,checked_QMARK_){
return sablono.core.radio_button37708.cljs$core$IFn$_invoke$arity$3(group,checked_QMARK_,"true");
});

sablono.core.radio_button37708.cljs$core$IFn$_invoke$arity$3 = (function (group,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$input,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$type,"radio",cljs.core.cst$kw$name,sablono.core.make_name(group),cljs.core.cst$kw$id,sablono.core.make_id([cljs.core.str(sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([group], 0))),cljs.core.str("-"),cljs.core.str(sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([value], 0)))].join('')),cljs.core.cst$kw$value,value,cljs.core.cst$kw$checked,checked_QMARK_], null)], null);
});

sablono.core.radio_button37708.cljs$lang$maxFixedArity = 3;


sablono.core.radio_button = sablono.core.wrap_attrs(sablono.core.radio_button37708);
/**
 * Creates a seq of option tags from a collection.
 */
sablono.core.select_options37716 = (function sablono$core$select_options37716(var_args){
var args37717 = [];
var len__7484__auto___37738 = arguments.length;
var i__7485__auto___37739 = (0);
while(true){
if((i__7485__auto___37739 < len__7484__auto___37738)){
args37717.push((arguments[i__7485__auto___37739]));

var G__37740 = (i__7485__auto___37739 + (1));
i__7485__auto___37739 = G__37740;
continue;
} else {
}
break;
}

var G__37719 = args37717.length;
switch (G__37719) {
case 1:
return sablono.core.select_options37716.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.select_options37716.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37717.length)].join('')));

}
});

sablono.core.select_options37716.cljs$core$IFn$_invoke$arity$1 = (function (coll){
return sablono.core.select_options37716.cljs$core$IFn$_invoke$arity$2(coll,null);
});

sablono.core.select_options37716.cljs$core$IFn$_invoke$arity$2 = (function (coll,selected){
var iter__7189__auto__ = (function sablono$core$iter__37720(s__37721){
return (new cljs.core.LazySeq(null,(function (){
var s__37721__$1 = s__37721;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__37721__$1);
if(temp__4657__auto__){
var s__37721__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__37721__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__37721__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__37723 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__37722 = (0);
while(true){
if((i__37722 < size__7188__auto__)){
var x = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__37722);
cljs.core.chunk_append(b__37723,((cljs.core.sequential_QMARK_(x))?(function (){var vec__37732 = x;
var text = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37732,(0),null);
var val = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37732,(1),null);
var disabled_QMARK_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37732,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$(disabled_QMARK_);
if(cljs.core.sequential_QMARK_(val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$optgroup,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$label,text], null),sablono.core.select_options37716.cljs$core$IFn$_invoke$arity$2(val,selected)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$option,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$value,val,cljs.core.cst$kw$selected,cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(val,selected),cljs.core.cst$kw$disabled,disabled_QMARK___$1], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$option,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$selected,cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,selected)], null),x], null)));

var G__37742 = (i__37722 + (1));
i__37722 = G__37742;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__37723),sablono$core$iter__37720(cljs.core.chunk_rest(s__37721__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__37723),null);
}
} else {
var x = cljs.core.first(s__37721__$2);
return cljs.core.cons(((cljs.core.sequential_QMARK_(x))?(function (){var vec__37735 = x;
var text = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37735,(0),null);
var val = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37735,(1),null);
var disabled_QMARK_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37735,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$(disabled_QMARK_);
if(cljs.core.sequential_QMARK_(val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$optgroup,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$label,text], null),sablono.core.select_options37716.cljs$core$IFn$_invoke$arity$2(val,selected)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$option,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$value,val,cljs.core.cst$kw$selected,cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(val,selected),cljs.core.cst$kw$disabled,disabled_QMARK___$1], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$option,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$selected,cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,selected)], null),x], null)),sablono$core$iter__37720(cljs.core.rest(s__37721__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__(coll);
});

sablono.core.select_options37716.cljs$lang$maxFixedArity = 2;


sablono.core.select_options = sablono.core.wrap_attrs(sablono.core.select_options37716);
/**
 * Creates a drop-down box using the <select> tag.
 */
sablono.core.drop_down37743 = (function sablono$core$drop_down37743(var_args){
var args37744 = [];
var len__7484__auto___37747 = arguments.length;
var i__7485__auto___37748 = (0);
while(true){
if((i__7485__auto___37748 < len__7484__auto___37747)){
args37744.push((arguments[i__7485__auto___37748]));

var G__37749 = (i__7485__auto___37748 + (1));
i__7485__auto___37748 = G__37749;
continue;
} else {
}
break;
}

var G__37746 = args37744.length;
switch (G__37746) {
case 2:
return sablono.core.drop_down37743.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.drop_down37743.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37744.length)].join('')));

}
});

sablono.core.drop_down37743.cljs$core$IFn$_invoke$arity$2 = (function (name,options){
return sablono.core.drop_down37743.cljs$core$IFn$_invoke$arity$3(name,options,null);
});

sablono.core.drop_down37743.cljs$core$IFn$_invoke$arity$3 = (function (name,options,selected){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$name,sablono.core.make_name(name),cljs.core.cst$kw$id,sablono.core.make_id(name)], null),(sablono.core.select_options.cljs$core$IFn$_invoke$arity$2 ? sablono.core.select_options.cljs$core$IFn$_invoke$arity$2(options,selected) : sablono.core.select_options.call(null,options,selected))], null);
});

sablono.core.drop_down37743.cljs$lang$maxFixedArity = 3;


sablono.core.drop_down = sablono.core.wrap_attrs(sablono.core.drop_down37743);
/**
 * Creates a text area element.
 */
sablono.core.text_area37751 = (function sablono$core$text_area37751(var_args){
var args37752 = [];
var len__7484__auto___37755 = arguments.length;
var i__7485__auto___37756 = (0);
while(true){
if((i__7485__auto___37756 < len__7484__auto___37755)){
args37752.push((arguments[i__7485__auto___37756]));

var G__37757 = (i__7485__auto___37756 + (1));
i__7485__auto___37756 = G__37757;
continue;
} else {
}
break;
}

var G__37754 = args37752.length;
switch (G__37754) {
case 1:
return sablono.core.text_area37751.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_area37751.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37752.length)].join('')));

}
});

sablono.core.text_area37751.cljs$core$IFn$_invoke$arity$1 = (function (name){
return sablono.core.text_area37751.cljs$core$IFn$_invoke$arity$2(name,null);
});

sablono.core.text_area37751.cljs$core$IFn$_invoke$arity$2 = (function (name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$textarea,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$name,sablono.core.make_name(name),cljs.core.cst$kw$id,sablono.core.make_id(name),cljs.core.cst$kw$value,value], null)], null);
});

sablono.core.text_area37751.cljs$lang$maxFixedArity = 2;


sablono.core.text_area = sablono.core.wrap_attrs(sablono.core.text_area37751);
/**
 * Creates a label for an input field with the supplied name.
 */
sablono.core.label37759 = (function sablono$core$label37759(name,text){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$label,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$htmlFor,sablono.core.make_id(name)], null),text], null);
});

sablono.core.label = sablono.core.wrap_attrs(sablono.core.label37759);
/**
 * Creates a submit button.
 */
sablono.core.submit_button37760 = (function sablono$core$submit_button37760(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$input,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$type,"submit",cljs.core.cst$kw$value,text], null)], null);
});

sablono.core.submit_button = sablono.core.wrap_attrs(sablono.core.submit_button37760);
/**
 * Creates a form reset button.
 */
sablono.core.reset_button37761 = (function sablono$core$reset_button37761(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$input,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$type,"reset",cljs.core.cst$kw$value,text], null)], null);
});

sablono.core.reset_button = sablono.core.wrap_attrs(sablono.core.reset_button37761);
/**
 * Create a form that points to a particular method and route.
 *   e.g. (form-to [:put "/post"]
 *       ...)
 */
sablono.core.form_to37762 = (function sablono$core$form_to37762(var_args){
var args__7491__auto__ = [];
var len__7484__auto___37769 = arguments.length;
var i__7485__auto___37770 = (0);
while(true){
if((i__7485__auto___37770 < len__7484__auto___37769)){
args__7491__auto__.push((arguments[i__7485__auto___37770]));

var G__37771 = (i__7485__auto___37770 + (1));
i__7485__auto___37770 = G__37771;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return sablono.core.form_to37762.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

sablono.core.form_to37762.cljs$core$IFn$_invoke$arity$variadic = (function (p__37765,body){
var vec__37766 = p__37765;
var method = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37766,(0),null);
var action = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37766,(1),null);
var method_str = clojure.string.upper_case(cljs.core.name(method));
var action_uri = sablono.util.to_uri(action);
return cljs.core.vec(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(((cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$get,null,cljs.core.cst$kw$post,null], null), null),method))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$form,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$method,method_str,cljs.core.cst$kw$action,action_uri], null)], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$form,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$method,"POST",cljs.core.cst$kw$action,action_uri], null),(sablono.core.hidden_field.cljs$core$IFn$_invoke$arity$2 ? sablono.core.hidden_field.cljs$core$IFn$_invoke$arity$2("_method",method_str) : sablono.core.hidden_field.call(null,"_method",method_str))], null)),body));
});

sablono.core.form_to37762.cljs$lang$maxFixedArity = (1);

sablono.core.form_to37762.cljs$lang$applyTo = (function (seq37763){
var G__37764 = cljs.core.first(seq37763);
var seq37763__$1 = cljs.core.next(seq37763);
return sablono.core.form_to37762.cljs$core$IFn$_invoke$arity$variadic(G__37764,seq37763__$1);
});


sablono.core.form_to = sablono.core.wrap_attrs(sablono.core.form_to37762);
