// Compiled by ClojureScript 1.9.229 {}
goog.provide('hatti.map.viewby');
goog.require('cljs.core');
goog.require('chimera.js_interop');
goog.require('hatti.map.utils');
goog.require('chimera.seq');
goog.require('hatti.utils.style');
goog.require('hatti.charting');
goog.require('hatti.ona.forms');
goog.require('hatti.constants');
goog.require('om.core');
goog.require('clojure.string');
hatti.map.viewby.marker_styler = (function hatti$map$viewby$marker_styler(id_color,id_selected_QMARK_){
return (function (marker){
var id = hatti.map.utils.get_id.call(null,marker);
var geotype = hatti.map.utils.marker__GT_geotype.call(null,marker);
var color_key = ((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"line","line",212345235),geotype))?new cljs.core.Keyword(null,"color","color",1011675173):new cljs.core.Keyword(null,"fillColor","fillColor",-176906116));
return cljs.core.PersistentArrayMap.fromArray([color_key,(cljs.core.truth_(id_selected_QMARK_.call(null,id))?id_color.call(null,id):hatti.utils.style.grey)], true, false);
});
});
hatti.map.viewby.move_nil_to_end = (function hatti$map$viewby$move_nil_to_end(s){
var no_nil = cljs.core.vec.call(null,cljs.core.remove.call(null,cljs.core.nil_QMARK_,s));
if(cljs.core._EQ_.call(null,s,no_nil)){
return s;
} else {
return cljs.core.conj.call(null,no_nil,null);
}
});
hatti.map.viewby.all_but_nil_selected = (function hatti$map$viewby$all_but_nil_selected(answers){
return cljs.core.merge.call(null,cljs.core.zipmap.call(null,answers,cljs.core.repeat.call(null,true)),new cljs.core.PersistentArrayMap(null, 1, [null,false], null));
});
/**
 * Preproccesses answers depending on the field. For multi-selects, return type
 * is a list of list of strings. For other types, a list of strings.
 */
hatti.map.viewby.preprocess_answers = (function hatti$map$viewby$preprocess_answers(field,raw_answers){
if(cljs.core.truth_(hatti.ona.forms.select_one_QMARK_.call(null,field))){
return raw_answers;
} else {
if(cljs.core.truth_(hatti.ona.forms.text_QMARK_.call(null,field))){
return raw_answers;
} else {
if(cljs.core.truth_(hatti.ona.forms.calculate_QMARK_.call(null,field))){
return raw_answers;
} else {
if(cljs.core.truth_(hatti.ona.forms.numeric_QMARK_.call(null,field))){
return hatti.charting.evenly_spaced_bins.call(null,raw_answers,(5),"int");
} else {
if(cljs.core.truth_(hatti.ona.forms.time_based_QMARK_.call(null,field))){
return hatti.charting.evenly_spaced_bins.call(null,raw_answers,(5),(cljs.core.truth_(cljs.core.re_find.call(null,/^..:..$/,cljs.core.first.call(null,raw_answers)))?"time":"date"));
} else {
if(cljs.core.truth_(hatti.ona.forms.select_all_QMARK_.call(null,field))){
return cljs.core.map.call(null,(function (p1__22103_SHARP_){
if(cljs.core.truth_(p1__22103_SHARP_)){
return clojure.string.split.call(null,p1__22103_SHARP_,/ /);
} else {
return null;
}
}),raw_answers);
} else {
return null;
}
}
}
}
}
}
});
hatti.map.viewby.has_geolocation_QMARK_ = (function hatti$map$viewby$has_geolocation_QMARK_(p__22104){
var map__22110 = p__22104;
var map__22110__$1 = ((((!((map__22110 == null)))?((((map__22110.cljs$lang$protocol_mask$partition0$ & (64))) || (map__22110.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22110):map__22110);
var vec__22111 = cljs.core.get.call(null,map__22110__$1,"_geolocation");
var lattitude = cljs.core.nth.call(null,vec__22111,(0),null);
var longitude = cljs.core.nth.call(null,vec__22111,(1),null);
var and__6397__auto__ = lattitude;
if(cljs.core.truth_(and__6397__auto__)){
return lattitude;
} else {
return and__6397__auto__;
}
});
/**
 * Produces a set of data structures / functions for view-by.
 * answers are a list of answers, sorted by count;
 * id->answers is a mapping from id to either one or many answers
 * answer->count, answer->selected?, answer->color are maps from answer;
 * used for the legend rendering. An 'answer' is mapped from a data element,
 * eg. a bin for numbers/dates, an option for multiple/single selects.
 */
hatti.map.viewby.viewby_info = (function hatti$map$viewby$viewby_info(p__22118,data){
var map__22121 = p__22118;
var map__22121__$1 = ((((!((map__22121 == null)))?((((map__22121.cljs$lang$protocol_mask$partition0$ & (64))) || (map__22121.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22121):map__22121);
var field = map__22121__$1;
var full_name = cljs.core.get.call(null,map__22121__$1,new cljs.core.Keyword(null,"full-name","full-name",408178550));
var ids = cljs.core.map.call(null,((function (map__22121,map__22121__$1,field,full_name){
return (function (p1__22115_SHARP_){
return cljs.core.get.call(null,p1__22115_SHARP_,hatti.constants._id);
});})(map__22121,map__22121__$1,field,full_name))
,data);
var raw_answers = cljs.core.map.call(null,((function (ids,map__22121,map__22121__$1,field,full_name){
return (function (p1__22116_SHARP_){
return cljs.core.get.call(null,p1__22116_SHARP_,full_name);
});})(ids,map__22121,map__22121__$1,field,full_name))
,data);
var submissions_with_geolocation = cljs.core.filterv.call(null,hatti.map.viewby.has_geolocation_QMARK_,data);
var raw_answers_with_geolocation = cljs.core.map.call(null,((function (ids,raw_answers,submissions_with_geolocation,map__22121,map__22121__$1,field,full_name){
return (function (p1__22117_SHARP_){
return cljs.core.get.call(null,p1__22117_SHARP_,full_name);
});})(ids,raw_answers,submissions_with_geolocation,map__22121,map__22121__$1,field,full_name))
,submissions_with_geolocation);
var preprocessed_answers = hatti.map.viewby.preprocess_answers.call(null,field,raw_answers);
var answer__GT_count = cljs.core.frequencies.call(null,cljs.core.flatten.call(null,preprocessed_answers));
var answer__GT_count_with_geolocations = cljs.core.frequencies.call(null,cljs.core.flatten.call(null,hatti.map.viewby.preprocess_answers.call(null,field,raw_answers_with_geolocation)));
var sorted_answers = (cljs.core.truth_((function (){var or__6409__auto__ = hatti.ona.forms.categorical_QMARK_.call(null,field);
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
var or__6409__auto____$1 = hatti.ona.forms.text_QMARK_.call(null,field);
if(cljs.core.truth_(or__6409__auto____$1)){
return or__6409__auto____$1;
} else {
return hatti.ona.forms.calculate_QMARK_.call(null,field);
}
}
})())?cljs.core.map.call(null,cljs.core.first,cljs.core.sort_by.call(null,cljs.core.second,cljs.core._GT_,answer__GT_count)):(cljs.core.truth_((function (){var or__6409__auto__ = hatti.ona.forms.time_based_QMARK_.call(null,field);
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return hatti.ona.forms.numeric_QMARK_.call(null,field);
}
})())?new cljs.core.Keyword(null,"bins","bins",1670395210).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,preprocessed_answers)):null));
var sorted_answers_with_nil_at_end = hatti.map.viewby.move_nil_to_end.call(null,sorted_answers);
var answer__GT_color_map = hatti.utils.style.answer__GT_color.call(null,field,sorted_answers);
var defaults = new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"answers","answers",-2066449770),sorted_answers_with_nil_at_end,new cljs.core.Keyword(null,"id->answers","id->answers",-655129337),cljs.core.zipmap.call(null,ids,preprocessed_answers),new cljs.core.Keyword(null,"answer->count","answer->count",-99425122),answer__GT_count,new cljs.core.Keyword(null,"answer->count-with-geolocations","answer->count-with-geolocations",1238784312),answer__GT_count_with_geolocations,new cljs.core.Keyword(null,"answer->selected?","answer->selected?",2082517958),hatti.map.viewby.all_but_nil_selected.call(null,sorted_answers),new cljs.core.Keyword(null,"answer->color","answer->color",-142632854),answer__GT_color_map,new cljs.core.Keyword(null,"visible-answers","visible-answers",-771956023),sorted_answers_with_nil_at_end,new cljs.core.Keyword(null,"field","field",-1302436500),field], null);
if(cljs.core.truth_(hatti.ona.forms.select_all_QMARK_.call(null,field))){
return cljs.core.merge.call(null,defaults,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"id-color","id-color",-484052665),((function (ids,raw_answers,submissions_with_geolocation,raw_answers_with_geolocation,preprocessed_answers,answer__GT_count,answer__GT_count_with_geolocations,sorted_answers,sorted_answers_with_nil_at_end,answer__GT_color_map,defaults,map__22121,map__22121__$1,field,full_name){
return (function (){
return cljs.core.first.call(null,cljs.core.vals.call(null,answer__GT_color_map));
});})(ids,raw_answers,submissions_with_geolocation,raw_answers_with_geolocation,preprocessed_answers,answer__GT_count,answer__GT_count_with_geolocations,sorted_answers,sorted_answers_with_nil_at_end,answer__GT_color_map,defaults,map__22121,map__22121__$1,field,full_name))
], null));
} else {
return defaults;

}
});
/**
 * Produces a set of data structures / functions for view-by.
 * answers are a list of answers, sorted by count;
 * id->answers is a mapping from id to either one or many answers
 * answer->count, answer->selected?, answer->color are maps from answer;
 * used for the legend rendering. An 'answer' is mapped from a data element,
 * eg. a bin for numbers/dates, an option for multiple/single selects.
 */
hatti.map.viewby.viewby_data = (function hatti$map$viewby$viewby_data(p__22125,data){
var map__22128 = p__22125;
var map__22128__$1 = ((((!((map__22128 == null)))?((((map__22128.cljs$lang$protocol_mask$partition0$ & (64))) || (map__22128.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22128):map__22128);
var field = map__22128__$1;
var full_name = cljs.core.get.call(null,map__22128__$1,new cljs.core.Keyword(null,"full-name","full-name",408178550));
if(cljs.core.seq_QMARK_.call(null,cljs.core.seq.call(null,data))){
var ids = cljs.core.map.call(null,((function (map__22128,map__22128__$1,field,full_name){
return (function (p1__22123_SHARP_){
return cljs.core.get.call(null,p1__22123_SHARP_,hatti.constants._id);
});})(map__22128,map__22128__$1,field,full_name))
,data);
var raw_answers = cljs.core.map.call(null,((function (ids,map__22128,map__22128__$1,field,full_name){
return (function (p1__22124_SHARP_){
return cljs.core.get.call(null,p1__22124_SHARP_,full_name);
});})(ids,map__22128,map__22128__$1,field,full_name))
,data);
var preprocessed_answers = hatti.map.viewby.preprocess_answers.call(null,field,raw_answers);
var answer__GT_count = cljs.core.frequencies.call(null,cljs.core.flatten.call(null,preprocessed_answers));
var sorted_answers = (cljs.core.truth_((function (){var or__6409__auto__ = hatti.ona.forms.categorical_QMARK_.call(null,field);
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
var or__6409__auto____$1 = hatti.ona.forms.text_QMARK_.call(null,field);
if(cljs.core.truth_(or__6409__auto____$1)){
return or__6409__auto____$1;
} else {
return hatti.ona.forms.calculate_QMARK_.call(null,field);
}
}
})())?cljs.core.map.call(null,cljs.core.first,cljs.core.sort_by.call(null,cljs.core.second,cljs.core._GT_,answer__GT_count)):(cljs.core.truth_((function (){var or__6409__auto__ = hatti.ona.forms.time_based_QMARK_.call(null,field);
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return hatti.ona.forms.numeric_QMARK_.call(null,field);
}
})())?new cljs.core.Keyword(null,"bins","bins",1670395210).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,preprocessed_answers)):null));
var sorted_answers_with_nil_at_end = hatti.map.viewby.move_nil_to_end.call(null,sorted_answers);
var answer__GT_color_map = hatti.utils.style.answer__GT_color.call(null,field,sorted_answers);
var defaults = new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"ids","ids",-998535796),ids,new cljs.core.Keyword(null,"answers","answers",-2066449770),sorted_answers_with_nil_at_end,new cljs.core.Keyword(null,"id->answers","id->answers",-655129337),cljs.core.zipmap.call(null,ids,preprocessed_answers),new cljs.core.Keyword(null,"answer->count","answer->count",-99425122),answer__GT_count,new cljs.core.Keyword(null,"answer->selected?","answer->selected?",2082517958),hatti.map.viewby.all_but_nil_selected.call(null,sorted_answers),new cljs.core.Keyword(null,"answer->color","answer->color",-142632854),answer__GT_color_map,new cljs.core.Keyword(null,"visible-answers","visible-answers",-771956023),sorted_answers_with_nil_at_end,new cljs.core.Keyword(null,"field","field",-1302436500),field], null);
if(cljs.core.truth_(hatti.ona.forms.select_all_QMARK_.call(null,field))){
return cljs.core.merge.call(null,defaults,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"id-color","id-color",-484052665),((function (ids,raw_answers,preprocessed_answers,answer__GT_count,sorted_answers,sorted_answers_with_nil_at_end,answer__GT_color_map,defaults,map__22128,map__22128__$1,field,full_name){
return (function (){
return cljs.core.first.call(null,cljs.core.vals.call(null,answer__GT_color_map));
});})(ids,raw_answers,preprocessed_answers,answer__GT_count,sorted_answers,sorted_answers_with_nil_at_end,answer__GT_color_map,defaults,map__22128,map__22128__$1,field,full_name))
], null));
} else {
return defaults;

}
} else {
return null;
}
});
/**
 * Generates id-color and id-selected? functions based on viewby-info.
 */
hatti.map.viewby.id_color_selected = (function hatti$map$viewby$id_color_selected(p__22132){
var map__22136 = p__22132;
var map__22136__$1 = ((((!((map__22136 == null)))?((((map__22136.cljs$lang$protocol_mask$partition0$ & (64))) || (map__22136.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22136):map__22136);
var field = cljs.core.get.call(null,map__22136__$1,new cljs.core.Keyword(null,"field","field",-1302436500));
var id__GT_answers = cljs.core.get.call(null,map__22136__$1,new cljs.core.Keyword(null,"id->answers","id->answers",-655129337));
var answer__GT_color = cljs.core.get.call(null,map__22136__$1,new cljs.core.Keyword(null,"answer->color","answer->color",-142632854));
var answer__GT_selected_QMARK_ = cljs.core.get.call(null,map__22136__$1,new cljs.core.Keyword(null,"answer->selected?","answer->selected?",2082517958));
var G__22138 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(field);
switch (G__22138) {
case "select all that apply":
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"id-color","id-color",-484052665),((function (G__22138,map__22136,map__22136__$1,field,id__GT_answers,answer__GT_color,answer__GT_selected_QMARK_){
return (function (){
return cljs.core.first.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["#f30"], null));
});})(G__22138,map__22136,map__22136__$1,field,id__GT_answers,answer__GT_color,answer__GT_selected_QMARK_))
,new cljs.core.Keyword(null,"id-selected?","id-selected?",1326938375),((function (G__22138,map__22136,map__22136__$1,field,id__GT_answers,answer__GT_color,answer__GT_selected_QMARK_){
return (function (id){
var answers = id__GT_answers.call(null,id);
if((answers == null)){
return cljs.core.get.call(null,answer__GT_selected_QMARK_,answers);
} else {
return cljs.core.some.call(null,cljs.core.identity,cljs.core.map.call(null,answer__GT_selected_QMARK_,answers));
}
});})(G__22138,map__22136,map__22136__$1,field,id__GT_answers,answer__GT_color,answer__GT_selected_QMARK_))
], null);

break;
default:
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"id-color","id-color",-484052665),((function (G__22138,map__22136,map__22136__$1,field,id__GT_answers,answer__GT_color,answer__GT_selected_QMARK_){
return (function (p1__22130_SHARP_){
return answer__GT_color.call(null,id__GT_answers.call(null,p1__22130_SHARP_));
});})(G__22138,map__22136,map__22136__$1,field,id__GT_answers,answer__GT_color,answer__GT_selected_QMARK_))
,new cljs.core.Keyword(null,"id-selected?","id-selected?",1326938375),((function (G__22138,map__22136,map__22136__$1,field,id__GT_answers,answer__GT_color,answer__GT_selected_QMARK_){
return (function (p1__22131_SHARP_){
return answer__GT_selected_QMARK_.call(null,id__GT_answers.call(null,p1__22131_SHARP_));
});})(G__22138,map__22136,map__22136__$1,field,id__GT_answers,answer__GT_color,answer__GT_selected_QMARK_))
], null);

}
});
hatti.map.viewby.view_by_BANG_ = (function hatti$map$viewby$view_by_BANG_(view_by_info,markers){
var map__22146 = hatti.map.viewby.id_color_selected.call(null,view_by_info);
var map__22146__$1 = ((((!((map__22146 == null)))?((((map__22146.cljs$lang$protocol_mask$partition0$ & (64))) || (map__22146.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22146):map__22146);
var id_selected_QMARK_ = cljs.core.get.call(null,map__22146__$1,new cljs.core.Keyword(null,"id-selected?","id-selected?",1326938375));
var id_color = cljs.core.get.call(null,map__22146__$1,new cljs.core.Keyword(null,"id-color","id-color",-484052665));
var m__GT_s = hatti.map.viewby.marker_styler.call(null,id_color,id_selected_QMARK_);
var seq__22148 = cljs.core.seq.call(null,markers);
var chunk__22149 = null;
var count__22150 = (0);
var i__22151 = (0);
while(true){
if((i__22151 < count__22150)){
var marker = cljs.core._nth.call(null,chunk__22149,i__22151);
hatti.map.utils.re_style_marker.call(null,m__GT_s,marker);

hatti.map.utils.bring_to_top_if_selected.call(null,id_selected_QMARK_,marker);

var G__22152 = seq__22148;
var G__22153 = chunk__22149;
var G__22154 = count__22150;
var G__22155 = (i__22151 + (1));
seq__22148 = G__22152;
chunk__22149 = G__22153;
count__22150 = G__22154;
i__22151 = G__22155;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__22148);
if(temp__4657__auto__){
var seq__22148__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__22148__$1)){
var c__7220__auto__ = cljs.core.chunk_first.call(null,seq__22148__$1);
var G__22156 = cljs.core.chunk_rest.call(null,seq__22148__$1);
var G__22157 = c__7220__auto__;
var G__22158 = cljs.core.count.call(null,c__7220__auto__);
var G__22159 = (0);
seq__22148 = G__22156;
chunk__22149 = G__22157;
count__22150 = G__22158;
i__22151 = G__22159;
continue;
} else {
var marker = cljs.core.first.call(null,seq__22148__$1);
hatti.map.utils.re_style_marker.call(null,m__GT_s,marker);

hatti.map.utils.bring_to_top_if_selected.call(null,id_selected_QMARK_,marker);

var G__22160 = cljs.core.next.call(null,seq__22148__$1);
var G__22161 = null;
var G__22162 = (0);
var G__22163 = (0);
seq__22148 = G__22160;
chunk__22149 = G__22161;
count__22150 = G__22162;
i__22151 = G__22163;
continue;
}
} else {
return null;
}
}
break;
}
});
hatti.map.viewby.apply_view_by_BANG_ = (function hatti$map$viewby$apply_view_by_BANG_(p__22165,owner){
var map__22170 = p__22165;
var map__22170__$1 = ((((!((map__22170 == null)))?((((map__22170.cljs$lang$protocol_mask$partition0$ & (64))) || (map__22170.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22170):map__22170);
var view_by_info = map__22170__$1;
var id__GT_answers = cljs.core.get.call(null,map__22170__$1,new cljs.core.Keyword(null,"id->answers","id->answers",-655129337));
var map__22172 = hatti.map.viewby.id_color_selected.call(null,view_by_info);
var map__22172__$1 = ((((!((map__22172 == null)))?((((map__22172.cljs$lang$protocol_mask$partition0$ & (64))) || (map__22172.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22172):map__22172);
var id_selected_QMARK_ = cljs.core.get.call(null,map__22172__$1,new cljs.core.Keyword(null,"id-selected?","id-selected?",1326938375));
var id_color = cljs.core.get.call(null,map__22172__$1,new cljs.core.Keyword(null,"id-color","id-color",-484052665));
var ids = cljs.core.sort.call(null,cljs.core.keys.call(null,id__GT_answers));
var stops = cljs.core.mapv.call(null,((function (map__22172,map__22172__$1,id_selected_QMARK_,id_color,ids,map__22170,map__22170__$1,view_by_info,id__GT_answers){
return (function (p1__22164_SHARP_){
if(cljs.core.truth_(id_selected_QMARK_.call(null,p1__22164_SHARP_))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__22164_SHARP_,id_color.call(null,p1__22164_SHARP_)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__22164_SHARP_,hatti.utils.style.grey], null);
}
});})(map__22172,map__22172__$1,id_selected_QMARK_,id_color,ids,map__22170,map__22170__$1,view_by_info,id__GT_answers))
,ids);
var id_string = om.core.get_props.call(null,owner,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dataset-info","dataset-info",-1196999563),new cljs.core.Keyword(null,"id_string","id_string",-821912001)], null));
var style = om.core.get_state.call(null,owner,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"style","style",-496642736)], null));
if(cljs.core.seq_QMARK_.call(null,cljs.core.seq.call(null,stops))){
hatti.map.utils.set_mapboxgl_paint_property.call(null,om.core.get_state.call(null,owner,new cljs.core.Keyword(null,"mapboxgl-map","mapboxgl-map",1585466246)),id_string,hatti.map.utils.get_style_properties.call(null,style,new cljs.core.Keyword(null,"normal","normal",-1519123858),new cljs.core.Keyword(null,"stops","stops",-1205459005),stops));

return om.core.set_state_BANG_.call(null,owner,new cljs.core.Keyword(null,"stops","stops",-1205459005),stops);
} else {
return null;
}
});
/**
 * Given a list of answers + query, returns map from answers to true/false.
 * True if query is in the answer, false if not.
 */
hatti.map.viewby.filter_answer_data_structures = (function hatti$map$viewby$filter_answer_data_structures(answers,query,field,language){
var query_present_QMARK_ = (function (ans){
if(cljs.core.truth_(ans)){
return cljs.core.re_find.call(null,chimera.js_interop.safe_regex.call(null,query),hatti.ona.forms.format_answer.call(null,field,ans,new cljs.core.Keyword(null,"language","language",-1591107564),language));
} else {
return null;
}
});
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"visible-answers","visible-answers",-771956023),cljs.core.filter.call(null,query_present_QMARK_,answers),new cljs.core.Keyword(null,"answer->selected?","answer->selected?",2082517958),cljs.core.zipmap.call(null,answers,cljs.core.map.call(null,query_present_QMARK_,answers))], null);
});
/**
 * This function appropriately toggles answer->selected? when answer is clicked
 * answer->selected? is a map from answers to true/false. Special rules:
 * First click = select the answer. If nothing clicked, make everything
 * clicked.
 */
hatti.map.viewby.toggle_answer_selected = (function hatti$map$viewby$toggle_answer_selected(answer__GT_selected_QMARK_,visible_answers,answer){
var all_answers = cljs.core.vals.call(null,answer__GT_selected_QMARK_);
var all_visible_selected_QMARK_ = ((function (all_answers){
return (function (a__GT_s,visible){
return cljs.core._EQ_.call(null,cljs.core.set.call(null,visible),cljs.core.set.call(null,cljs.core.keys.call(null,cljs.core.filter.call(null,cljs.core.second,a__GT_s))));
});})(all_answers))
;
if((answer == null)){
return answer__GT_selected_QMARK_;
} else {
if(cljs.core.truth_(all_visible_selected_QMARK_.call(null,answer__GT_selected_QMARK_,visible_answers))){
return cljs.core.merge.call(null,cljs.core.zipmap.call(null,all_answers,cljs.core.repeat.call(null,false)),cljs.core.PersistentArrayMap.fromArray([answer,true], true, false));
} else {
var toggled = cljs.core.update_in.call(null,answer__GT_selected_QMARK_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [answer], null),cljs.core.not);
if(cljs.core.every_QMARK_.call(null,cljs.core.false_QMARK_,cljs.core.vals.call(null,toggled))){
return cljs.core.merge.call(null,cljs.core.zipmap.call(null,all_answers,cljs.core.repeat.call(null,false)),hatti.map.viewby.all_but_nil_selected.call(null,visible_answers));
} else {
return toggled;
}
}
}
});
/**
 * Returns selected ids from view-by data
 */
hatti.map.viewby.get_selected_ids = (function hatti$map$viewby$get_selected_ids(view_by){
var map__22185 = view_by;
var map__22185__$1 = ((((!((map__22185 == null)))?((((map__22185.cljs$lang$protocol_mask$partition0$ & (64))) || (map__22185.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22185):map__22185);
var answer__GT_selected_QMARK_ = cljs.core.get.call(null,map__22185__$1,new cljs.core.Keyword(null,"answer->selected?","answer->selected?",2082517958));
var id__GT_answers = cljs.core.get.call(null,map__22185__$1,new cljs.core.Keyword(null,"id->answers","id->answers",-655129337));
var answer__GT_color = cljs.core.get.call(null,map__22185__$1,new cljs.core.Keyword(null,"answer->color","answer->color",-142632854));
var into_map = ((function (map__22185,map__22185__$1,answer__GT_selected_QMARK_,id__GT_answers,answer__GT_color){
return (function (p1__22174_SHARP_){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,p1__22174_SHARP_);
});})(map__22185,map__22185__$1,answer__GT_selected_QMARK_,id__GT_answers,answer__GT_color))
;
var selected_answers = cljs.core.keys.call(null,into_map.call(null,cljs.core.filter.call(null,((function (map__22185,map__22185__$1,answer__GT_selected_QMARK_,id__GT_answers,answer__GT_color,into_map){
return (function (p__22187){
var vec__22188 = p__22187;
var _ = cljs.core.nth.call(null,vec__22188,(0),null);
var v = cljs.core.nth.call(null,vec__22188,(1),null);
return v;
});})(map__22185,map__22185__$1,answer__GT_selected_QMARK_,id__GT_answers,answer__GT_color,into_map))
,answer__GT_selected_QMARK_)));
var selected_ids = cljs.core.keys.call(null,into_map.call(null,cljs.core.filter.call(null,((function (map__22185,map__22185__$1,answer__GT_selected_QMARK_,id__GT_answers,answer__GT_color,into_map,selected_answers){
return (function (p__22191){
var vec__22192 = p__22191;
var k = cljs.core.nth.call(null,vec__22192,(0),null);
var v = cljs.core.nth.call(null,vec__22192,(1),null);
return chimera.seq.in_QMARK_.call(null,selected_answers,v);
});})(map__22185,map__22185__$1,answer__GT_selected_QMARK_,id__GT_answers,answer__GT_color,into_map,selected_answers))
,id__GT_answers)));
var color = ((cljs.core._EQ_.call(null,(1),cljs.core.count.call(null,selected_answers)))?cljs.core.get.call(null,answer__GT_color,cljs.core.first.call(null,selected_answers)):null);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"selected-ids","selected-ids",-1154760141),selected_ids,new cljs.core.Keyword(null,"cell-color","cell-color",83713438),color], null);
});
