// Compiled by ClojureScript 1.9.229 {}
goog.provide('hatti.maths');
goog.require('cljs.core');
hatti.maths.floor = (function hatti$maths$floor(n){
if(cljs.core.truth_(n)){
return Math.floor(n);
} else {
return null;
}
});
hatti.maths.ceil = (function hatti$maths$ceil(n){
if(cljs.core.truth_(n)){
return Math.ceil(n);
} else {
return null;
}
});
hatti.maths.round = (function hatti$maths$round(n){
if(cljs.core.truth_(n)){
return Math.round(n);
} else {
return null;
}
});
hatti.maths.abs = (function hatti$maths$abs(n){
if(cljs.core.truth_(n)){
return Math.abs(n);
} else {
return null;
}
});
/**
 * (gcd a b) returns the greatest common divisor of a and b
 */
hatti.maths.gcd = (function hatti$maths$gcd(a,b){
if((!(cljs.core.integer_QMARK_.call(null,a))) || (!(cljs.core.integer_QMARK_.call(null,b)))){
throw (new IllegalArgumentException("gcd requires two integers"));
} else {
var a__$1 = hatti.maths.abs.call(null,a);
var b__$1 = hatti.maths.abs.call(null,b);
while(true){
if((b__$1 === (0))){
return a__$1;
} else {
var G__20808 = b__$1;
var G__20809 = cljs.core.mod.call(null,a__$1,b__$1);
a__$1 = G__20808;
b__$1 = G__20809;
continue;
}
break;
}
}
});
/**
 * (lcm a b) returns the least common multiple of a and b
 */
hatti.maths.lcm = (function hatti$maths$lcm(a,b){
if((!(cljs.core.integer_QMARK_.call(null,a))) || (!(cljs.core.integer_QMARK_.call(null,b)))){
throw (new IllegalArgumentException("lcm requires two integers"));
} else {
}

if((a === (0))){
return (0);
} else {
if((b === (0))){
return (0);
} else {
return hatti.maths.abs.call(null,(b * cljs.core.quot.call(null,a,hatti.maths.gcd.call(null,a,b))));

}
}
});
