// Compiled by ClojureScript 1.9.229 {}
goog.provide('hatti.views.record');
goog.require('cljs.core');
goog.require('chimera.js_interop');
goog.require('sablono.core');
goog.require('cljs.core.async');
goog.require('hatti.shared');
goog.require('hatti.ona.forms');
goog.require('hatti.constants');
goog.require('clojure.string');
goog.require('hatti.views');
goog.require('om.core');
goog.require('hatti.utils');
goog.require('chimera.urls');
/**
 * Wrap-with produces a partial to wrap a set of children.
 * ((wrap-with :div) 1 2 3) => [:div [1 2 3]]
 * ((wrap-with [:div {:class 0}]) 1 2 3) => [:div {:class 0} [1 2 3]]
 */
hatti.views.record.wrap_with = (function hatti$views$record$wrap_with(root){
return (function() { 
var G__22546__delegate = function (children){
if((root instanceof cljs.core.Keyword)){
return cljs.core.conj.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [root], null),children);
} else {
return cljs.core.conj.call(null,root,children);
}
};
var G__22546 = function (var_args){
var children = null;
if (arguments.length > 0) {
var G__22547__i = 0, G__22547__a = new Array(arguments.length -  0);
while (G__22547__i < G__22547__a.length) {G__22547__a[G__22547__i] = arguments[G__22547__i + 0]; ++G__22547__i;}
  children = new cljs.core.IndexedSeq(G__22547__a,0);
} 
return G__22546__delegate.call(this,children);};
G__22546.cljs$lang$maxFixedArity = 0;
G__22546.cljs$lang$applyTo = (function (arglist__22548){
var children = cljs.core.seq(arglist__22548);
return G__22546__delegate(children);
});
G__22546.cljs$core$IFn$_invoke$arity$variadic = G__22546__delegate;
return G__22546;
})()
;
});
hatti.views.record.submission_arrow = (function hatti$views$record$submission_arrow(dir,cur_rank,view){
var icon = [cljs.core.str("fa fa-arrow-"),cljs.core.str(cljs.core.name.call(null,dir))].join('');
var new_rank = (function (){var G__22553 = (((dir instanceof cljs.core.Keyword))?dir.fqn:null);
switch (G__22553) {
case "left":
return cljs.core.dec;

break;
case "right":
return cljs.core.inc;

break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(dir)].join('')));

}
})().call(null,cur_rank);
var event_key = (function (){var pred__22554 = cljs.core._EQ_;
var expr__22555 = view;
if(cljs.core.truth_(pred__22554.call(null,new cljs.core.Keyword(null,"map","map",1371690461),expr__22555))){
return new cljs.core.Keyword(null,"mapped-submission-to-rank","mapped-submission-to-rank",-1281314361);
} else {
if(cljs.core.truth_(pred__22554.call(null,new cljs.core.Keyword(null,"table","table",-564943036),expr__22555))){
return new cljs.core.Keyword(null,"submission-to-rank","submission-to-rank",1214938797);
} else {
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(expr__22555)].join('')));
}
}
})();
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a.pure-button.btn-default","a.pure-button.btn-default",-1117383068),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"on-click","on-click",1632826543),hatti.utils.click_fn.call(null,((function (icon,new_rank,event_key){
return (function (){
return cljs.core.async.put_BANG_.call(null,hatti.shared.event_chan,cljs.core.PersistentArrayMap.fromArray([event_key,new_rank], true, false));
});})(icon,new_rank,event_key))
),new cljs.core.Keyword(null,"href","href",-793805698),"#"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"i","i",-1386841315),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),icon], null)], null)], null);
});
hatti.views.record.submission_closer = (function hatti$views$record$submission_closer(){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a.btn-close.right","a.btn-close.right",-1684667393),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"on-click","on-click",1632826543),hatti.utils.click_fn.call(null,(function (){
return cljs.core.async.put_BANG_.call(null,hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"submission-unclicked","submission-unclicked",-2099539520),true], null));
})),new cljs.core.Keyword(null,"href","href",-793805698),"#"], null),"\u00D7"], null);
});
cljs.core._add_method.call(null,hatti.views.print_xls_report_btn,new cljs.core.Keyword(null,"default","default",-1987822328),(function (cursor,owner){
if(typeof hatti.views.record.t_hatti$views$record22558 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.record.t_hatti$views$record22558 = (function (cursor,owner,meta22559){
this.cursor = cursor;
this.owner = owner;
this.meta22559 = meta22559;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.record.t_hatti$views$record22558.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_22560,meta22559__$1){
var self__ = this;
var _22560__$1 = this;
return (new hatti.views.record.t_hatti$views$record22558(self__.cursor,self__.owner,meta22559__$1));
});

hatti.views.record.t_hatti$views$record22558.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_22560){
var self__ = this;
var _22560__$1 = this;
return self__.meta22559;
});

hatti.views.record.t_hatti$views$record22558.prototype.om$core$IRender$ = true;

hatti.views.record.t_hatti$views$record22558.prototype.om$core$IRender$render$arity$1 = (function (this__18254__auto__){
var self__ = this;
var this__18254__auto____$1 = this;
return React.DOM.div(({"id": "print-xls-report"}));
});

hatti.views.record.t_hatti$views$record22558.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"cursor","cursor",-1642498285,null),new cljs.core.Symbol(null,"owner","owner",1247919588,null),new cljs.core.Symbol(null,"meta22559","meta22559",-2057000955,null)], null);
});

hatti.views.record.t_hatti$views$record22558.cljs$lang$type = true;

hatti.views.record.t_hatti$views$record22558.cljs$lang$ctorStr = "hatti.views.record/t_hatti$views$record22558";

hatti.views.record.t_hatti$views$record22558.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"hatti.views.record/t_hatti$views$record22558");
});

hatti.views.record.__GT_t_hatti$views$record22558 = (function hatti$views$record$__GT_t_hatti$views$record22558(cursor__$1,owner__$1,meta22559){
return (new hatti.views.record.t_hatti$views$record22558(cursor__$1,owner__$1,meta22559));
});

}

return (new hatti.views.record.t_hatti$views$record22558(cursor,owner,null));
}));
hatti.views.record.qa_elements = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"map","map",1371690461),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"row-el","row-el",-1433801362),new cljs.core.Keyword(null,"div.question-answer","div.question-answer",370303396),new cljs.core.Keyword(null,"question-el","question-el",-572061899),new cljs.core.Keyword(null,"span.question","span.question",826624133),new cljs.core.Keyword(null,"answer-el","answer-el",-306379371),new cljs.core.Keyword(null,"span.answer","span.answer",1128039098)], null),new cljs.core.Keyword(null,"table","table",-564943036),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"row-el","row-el",-1433801362),new cljs.core.Keyword(null,"tr.question-answer","tr.question-answer",1117674171),new cljs.core.Keyword(null,"question-el","question-el",-572061899),new cljs.core.Keyword(null,"td.question","td.question",-381922608),new cljs.core.Keyword(null,"answer-el","answer-el",-306379371),new cljs.core.Keyword(null,"td.answer","td.answer",1235375692)], null)], null);
hatti.views.record.format_as_question_answer = (function hatti$views$record$format_as_question_answer(view,field,data,lang){
var fname = new cljs.core.Keyword(null,"full-name","full-name",408178550).cljs$core$IFn$_invoke$arity$1(field);
var flabel = hatti.ona.forms.get_label.call(null,field,lang);
var answer = cljs.core.get.call(null,data,fname);
var alabel = hatti.ona.forms.format_answer.call(null,field,answer,new cljs.core.Keyword(null,"language","language",-1591107564),lang);
var map__22565 = hatti.views.record.qa_elements.call(null,view);
var map__22565__$1 = ((((!((map__22565 == null)))?((((map__22565.cljs$lang$protocol_mask$partition0$ & (64))) || (map__22565.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22565):map__22565);
var row_el = cljs.core.get.call(null,map__22565__$1,new cljs.core.Keyword(null,"row-el","row-el",-1433801362));
var question_el = cljs.core.get.call(null,map__22565__$1,new cljs.core.Keyword(null,"question-el","question-el",-572061899));
var answer_el = cljs.core.get.call(null,map__22565__$1,new cljs.core.Keyword(null,"answer-el","answer-el",-306379371));
if(cljs.core.truth_((function (){var and__6397__auto__ = alabel;
if(cljs.core.truth_(and__6397__auto__)){
return cljs.core.not_EQ_.call(null,alabel,hatti.ona.forms.no_answer);
} else {
return and__6397__auto__;
}
})())){
if(cljs.core.truth_(hatti.ona.forms.repeat_QMARK_.call(null,field))){
return om.core.build.call(null,hatti.views.repeat_view,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"data","data",-232669377),answer,new cljs.core.Keyword(null,"repeat-field","repeat-field",-2099292535),field,new cljs.core.Keyword(null,"lang","lang",-1819677104),lang], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"view","view",1247994814),view], null)], null));
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [row_el,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [question_el,flabel], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [answer_el,alabel], null)], null);
}
} else {
return null;
}
});
hatti.views.record.submission_elements = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"map","map",1371690461),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"top-level-wrap","top-level-wrap",366303456),hatti.views.record.wrap_with.call(null,new cljs.core.Keyword(null,"div.legend.infobar.submission.top.right","div.legend.infobar.submission.top.right",726433654)),new cljs.core.Keyword(null,"topbar-wrap","topbar-wrap",1084926998),hatti.views.record.wrap_with.call(null,new cljs.core.Keyword(null,"div.border-bottom.legend-topbar","div.border-bottom.legend-topbar",-1940089808)),new cljs.core.Keyword(null,"header-wrap","header-wrap",517152474),hatti.views.record.wrap_with.call(null,new cljs.core.Keyword(null,"div.border-bottom.submission-header","div.border-bottom.submission-header",1572822310)),new cljs.core.Keyword(null,"submission-info-wrap","submission-info-wrap",-1360099904),hatti.views.record.wrap_with.call(null,new cljs.core.Keyword(null,"div.submission.info-scroll","div.submission.info-scroll",1628305488)),new cljs.core.Keyword(null,"section-wrap","section-wrap",28486716),hatti.views.record.wrap_with.call(null,new cljs.core.Keyword(null,"div.border-bottom","div.border-bottom",1472282167)),new cljs.core.Keyword(null,"h4-cls","h4-cls",-1006591520),"t-red"], null),new cljs.core.Keyword(null,"table","table",-564943036),new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"top-level-wrap","top-level-wrap",366303456),hatti.views.record.wrap_with.call(null,new cljs.core.Keyword(null,"div.widget-info#single-submission-info","div.widget-info#single-submission-info",-714613242)),new cljs.core.Keyword(null,"topbar-wrap","topbar-wrap",1084926998),hatti.views.record.wrap_with.call(null,new cljs.core.Keyword(null,"div.topbar","div.topbar",1355117265)),new cljs.core.Keyword(null,"header-wrap","header-wrap",517152474),hatti.views.record.wrap_with.call(null,new cljs.core.Keyword(null,"div.header","div.header",1964513620)),new cljs.core.Keyword(null,"submission-info-wrap","submission-info-wrap",-1360099904),(function() { 
var G__22567__delegate = function (tbody){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.submission","div.submission",1371621120),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"table.pure-table.pure-table-bordered","table.pure-table.pure-table-bordered",-1577425751),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"thead","thead",-291875296),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"tr","tr",-1424774646),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"th","th",-545608566),"Question"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"th","th",-545608566),"Response"], null)], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"tbody","tbody",-80678300),tbody], null)], null)], null);
};
var G__22567 = function (var_args){
var tbody = null;
if (arguments.length > 0) {
var G__22568__i = 0, G__22568__a = new Array(arguments.length -  0);
while (G__22568__i < G__22568__a.length) {G__22568__a[G__22568__i] = arguments[G__22568__i + 0]; ++G__22568__i;}
  tbody = new cljs.core.IndexedSeq(G__22568__a,0);
} 
return G__22567__delegate.call(this,tbody);};
G__22567.cljs$lang$maxFixedArity = 0;
G__22567.cljs$lang$applyTo = (function (arglist__22569){
var tbody = cljs.core.seq(arglist__22569);
return G__22567__delegate(tbody);
});
G__22567.cljs$core$IFn$_invoke$arity$variadic = G__22567__delegate;
return G__22567;
})()
,new cljs.core.Keyword(null,"section-wrap","section-wrap",28486716),cljs.core.identity,new cljs.core.Keyword(null,"show-instance-id","show-instance-id",-2119784356),true,new cljs.core.Keyword(null,"h4-cls","h4-cls",-1006591520),""], null)], null);
cljs.core._add_method.call(null,hatti.views.repeat_view,new cljs.core.Keyword(null,"default","default",-1987822328),(function (p__22571,owner,p__22572){
var map__22573 = p__22571;
var map__22573__$1 = ((((!((map__22573 == null)))?((((map__22573.cljs$lang$protocol_mask$partition0$ & (64))) || (map__22573.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22573):map__22573);
var data = cljs.core.get.call(null,map__22573__$1,new cljs.core.Keyword(null,"data","data",-232669377));
var repeat_field = cljs.core.get.call(null,map__22573__$1,new cljs.core.Keyword(null,"repeat-field","repeat-field",-2099292535));
var lang = cljs.core.get.call(null,map__22573__$1,new cljs.core.Keyword(null,"lang","lang",-1819677104));
var map__22574 = p__22572;
var map__22574__$1 = ((((!((map__22574 == null)))?((((map__22574.cljs$lang$protocol_mask$partition0$ & (64))) || (map__22574.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22574):map__22574);
var view = cljs.core.get.call(null,map__22574__$1,new cljs.core.Keyword(null,"view","view",1247994814));

if(typeof hatti.views.record.t_hatti$views$record22577 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRenderState}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IInitState}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.record.t_hatti$views$record22577 = (function (p__22571,owner,p__22572,map__22573,data,repeat_field,lang,map__22574,view,meta22578){
this.p__22571 = p__22571;
this.owner = owner;
this.p__22572 = p__22572;
this.map__22573 = map__22573;
this.data = data;
this.repeat_field = repeat_field;
this.lang = lang;
this.map__22574 = map__22574;
this.view = view;
this.meta22578 = meta22578;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.record.t_hatti$views$record22577.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (map__22573,map__22573__$1,data,repeat_field,lang,map__22574,map__22574__$1,view){
return (function (_22579,meta22578__$1){
var self__ = this;
var _22579__$1 = this;
return (new hatti.views.record.t_hatti$views$record22577(self__.p__22571,self__.owner,self__.p__22572,self__.map__22573,self__.data,self__.repeat_field,self__.lang,self__.map__22574,self__.view,meta22578__$1));
});})(map__22573,map__22573__$1,data,repeat_field,lang,map__22574,map__22574__$1,view))
;

hatti.views.record.t_hatti$views$record22577.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (map__22573,map__22573__$1,data,repeat_field,lang,map__22574,map__22574__$1,view){
return (function (_22579){
var self__ = this;
var _22579__$1 = this;
return self__.meta22578;
});})(map__22573,map__22573__$1,data,repeat_field,lang,map__22574,map__22574__$1,view))
;

hatti.views.record.t_hatti$views$record22577.prototype.om$core$IInitState$ = true;

hatti.views.record.t_hatti$views$record22577.prototype.om$core$IInitState$init_state$arity$1 = ((function (map__22573,map__22573__$1,data,repeat_field,lang,map__22574,map__22574__$1,view){
return (function (_){
var self__ = this;
var ___$1 = this;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"collapsed?","collapsed?",-1661420674),true], null);
});})(map__22573,map__22573__$1,data,repeat_field,lang,map__22574,map__22574__$1,view))
;

hatti.views.record.t_hatti$views$record22577.prototype.om$core$IRenderState$ = true;

hatti.views.record.t_hatti$views$record22577.prototype.om$core$IRenderState$render_state$arity$2 = ((function (map__22573,map__22573__$1,data,repeat_field,lang,map__22574,map__22574__$1,view){
return (function (_,p__22580){
var self__ = this;
var map__22581 = p__22580;
var map__22581__$1 = ((((!((map__22581 == null)))?((((map__22581.cljs$lang$protocol_mask$partition0$ & (64))) || (map__22581.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22581):map__22581);
var collapsed_QMARK_ = cljs.core.get.call(null,map__22581__$1,new cljs.core.Keyword(null,"collapsed?","collapsed?",-1661420674));
var ___$1 = this;
if(cljs.core.seq.call(null,self__.data)){
var collapse_BANG_ = ((function (___$1,map__22581,map__22581__$1,collapsed_QMARK_,map__22573,map__22573__$1,data,repeat_field,lang,map__22574,map__22574__$1,view){
return (function (p1__22570_SHARP_){
return om.core.set_state_BANG_.call(null,self__.owner,new cljs.core.Keyword(null,"collapsed?","collapsed?",-1661420674),p1__22570_SHARP_);
});})(___$1,map__22581,map__22581__$1,collapsed_QMARK_,map__22573,map__22573__$1,data,repeat_field,lang,map__22574,map__22574__$1,view))
;
var map__22583 = hatti.views.record.qa_elements.call(null,self__.view);
var map__22583__$1 = ((((!((map__22583 == null)))?((((map__22583.cljs$lang$protocol_mask$partition0$ & (64))) || (map__22583.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22583):map__22583);
var row_el = cljs.core.get.call(null,map__22583__$1,new cljs.core.Keyword(null,"row-el","row-el",-1433801362));
var question_el = cljs.core.get.call(null,map__22583__$1,new cljs.core.Keyword(null,"question-el","question-el",-572061899));
var answer_el = cljs.core.get.call(null,map__22583__$1,new cljs.core.Keyword(null,"answer-el","answer-el",-306379371));
var header = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [row_el,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [question_el,hatti.ona.forms.get_label.call(null,self__.repeat_field,self__.lang)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [answer_el,[cljs.core.str(hatti.utils.pluralize_number.call(null,cljs.core.count.call(null,self__.data)," Repeat")),cljs.core.str(" - ")].join(''),(cljs.core.truth_(collapsed_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"on-click","on-click",1632826543),hatti.utils.click_fn.call(null,((function (collapse_BANG_,map__22583,map__22583__$1,row_el,question_el,answer_el,___$1,map__22581,map__22581__$1,collapsed_QMARK_,map__22573,map__22573__$1,data,repeat_field,lang,map__22574,map__22574__$1,view){
return (function (){
return collapse_BANG_.call(null,false);
});})(collapse_BANG_,map__22583,map__22583__$1,row_el,question_el,answer_el,___$1,map__22581,map__22581__$1,collapsed_QMARK_,map__22573,map__22573__$1,data,repeat_field,lang,map__22574,map__22574__$1,view))
),new cljs.core.Keyword(null,"href","href",-793805698),"#"], null),"Show Repeats"], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"on-click","on-click",1632826543),hatti.utils.click_fn.call(null,((function (collapse_BANG_,map__22583,map__22583__$1,row_el,question_el,answer_el,___$1,map__22581,map__22581__$1,collapsed_QMARK_,map__22573,map__22573__$1,data,repeat_field,lang,map__22574,map__22574__$1,view){
return (function (){
return collapse_BANG_.call(null,true);
});})(collapse_BANG_,map__22583,map__22583__$1,row_el,question_el,answer_el,___$1,map__22581,map__22581__$1,collapsed_QMARK_,map__22573,map__22573__$1,data,repeat_field,lang,map__22574,map__22574__$1,view))
),new cljs.core.Keyword(null,"href","href",-793805698),"#"], null),"Hide Repeats"], null))], null)], null);
var fname = new cljs.core.Keyword(null,"full-name","full-name",408178550).cljs$core$IFn$_invoke$arity$1(self__.repeat_field);
var render_child = ((function (collapse_BANG_,map__22583,map__22583__$1,row_el,question_el,answer_el,header,fname,___$1,map__22581,map__22581__$1,collapsed_QMARK_,map__22573,map__22573__$1,data,repeat_field,lang,map__22574,map__22574__$1,view){
return (function (d){
var iter__7189__auto__ = ((function (collapse_BANG_,map__22583,map__22583__$1,row_el,question_el,answer_el,header,fname,___$1,map__22581,map__22581__$1,collapsed_QMARK_,map__22573,map__22573__$1,data,repeat_field,lang,map__22574,map__22574__$1,view){
return (function hatti$views$record$iter__22585(s__22586){
return (new cljs.core.LazySeq(null,((function (collapse_BANG_,map__22583,map__22583__$1,row_el,question_el,answer_el,header,fname,___$1,map__22581,map__22581__$1,collapsed_QMARK_,map__22573,map__22573__$1,data,repeat_field,lang,map__22574,map__22574__$1,view){
return (function (){
var s__22586__$1 = s__22586;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__22586__$1);
if(temp__4657__auto__){
var s__22586__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__22586__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__22586__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__22588 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__22587 = (0);
while(true){
if((i__22587 < size__7188__auto__)){
var field = cljs.core._nth.call(null,c__7187__auto__,i__22587);
cljs.core.chunk_append.call(null,b__22588,hatti.views.record.format_as_question_answer.call(null,self__.view,field,d,self__.lang));

var G__22598 = (i__22587 + (1));
i__22587 = G__22598;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__22588),hatti$views$record$iter__22585.call(null,cljs.core.chunk_rest.call(null,s__22586__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__22588),null);
}
} else {
var field = cljs.core.first.call(null,s__22586__$2);
return cljs.core.cons.call(null,hatti.views.record.format_as_question_answer.call(null,self__.view,field,d,self__.lang),hatti$views$record$iter__22585.call(null,cljs.core.rest.call(null,s__22586__$2)));
}
} else {
return null;
}
break;
}
});})(collapse_BANG_,map__22583,map__22583__$1,row_el,question_el,answer_el,header,fname,___$1,map__22581,map__22581__$1,collapsed_QMARK_,map__22573,map__22573__$1,data,repeat_field,lang,map__22574,map__22574__$1,view))
,null,null));
});})(collapse_BANG_,map__22583,map__22583__$1,row_el,question_el,answer_el,header,fname,___$1,map__22581,map__22581__$1,collapsed_QMARK_,map__22573,map__22573__$1,data,repeat_field,lang,map__22574,map__22574__$1,view))
;
return iter__7189__auto__.call(null,new cljs.core.Keyword(null,"children","children",-940561982).cljs$core$IFn$_invoke$arity$1(self__.repeat_field));
});})(collapse_BANG_,map__22583,map__22583__$1,row_el,question_el,answer_el,header,fname,___$1,map__22581,map__22581__$1,collapsed_QMARK_,map__22573,map__22573__$1,data,repeat_field,lang,map__22574,map__22574__$1,view))
;
var tbl = ((function (collapse_BANG_,map__22583,map__22583__$1,row_el,question_el,answer_el,header,fname,render_child,___$1,map__22581,map__22581__$1,collapsed_QMARK_,map__22573,map__22573__$1,data,repeat_field,lang,map__22574,map__22574__$1,view){
return (function() { 
var G__22599__delegate = function (cls,body){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"tr","tr",-1424774646),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),cls], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"td.no-pad","td.no-pad",1626503288),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"col-span","col-span",-232603210),(2)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"table","table",-564943036),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),cls], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"tbody","tbody",-80678300),body], null)], null)], null)], null);
};
var G__22599 = function (cls,var_args){
var body = null;
if (arguments.length > 1) {
var G__22600__i = 0, G__22600__a = new Array(arguments.length -  1);
while (G__22600__i < G__22600__a.length) {G__22600__a[G__22600__i] = arguments[G__22600__i + 1]; ++G__22600__i;}
  body = new cljs.core.IndexedSeq(G__22600__a,0);
} 
return G__22599__delegate.call(this,cls,body);};
G__22599.cljs$lang$maxFixedArity = 1;
G__22599.cljs$lang$applyTo = (function (arglist__22601){
var cls = cljs.core.first(arglist__22601);
var body = cljs.core.rest(arglist__22601);
return G__22599__delegate(cls,body);
});
G__22599.cljs$core$IFn$_invoke$arity$variadic = G__22599__delegate;
return G__22599;
})()
;})(collapse_BANG_,map__22583,map__22583__$1,row_el,question_el,answer_el,header,fname,render_child,___$1,map__22581,map__22581__$1,collapsed_QMARK_,map__22573,map__22573__$1,data,repeat_field,lang,map__22574,map__22574__$1,view))
;
if(cljs.core.truth_(collapsed_QMARK_)){
return sablono.interpreter.interpret.call(null,header);
} else {
return sablono.interpreter.interpret.call(null,(function (){var G__22589 = (((self__.view instanceof cljs.core.Keyword))?self__.view.fqn:null);
switch (G__22589) {
case "map":
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.repeat-block","div.repeat-block",500963170),header,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ol.repeat","ol.repeat",-1422933218),(function (){var iter__7189__auto__ = ((function (G__22589,collapse_BANG_,map__22583,map__22583__$1,row_el,question_el,answer_el,header,fname,render_child,tbl,___$1,map__22581,map__22581__$1,collapsed_QMARK_,map__22573,map__22573__$1,data,repeat_field,lang,map__22574,map__22574__$1,view){
return (function hatti$views$record$iter__22590(s__22591){
return (new cljs.core.LazySeq(null,((function (G__22589,collapse_BANG_,map__22583,map__22583__$1,row_el,question_el,answer_el,header,fname,render_child,tbl,___$1,map__22581,map__22581__$1,collapsed_QMARK_,map__22573,map__22573__$1,data,repeat_field,lang,map__22574,map__22574__$1,view){
return (function (){
var s__22591__$1 = s__22591;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__22591__$1);
if(temp__4657__auto__){
var s__22591__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__22591__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__22591__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__22593 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__22592 = (0);
while(true){
if((i__22592 < size__7188__auto__)){
var d = cljs.core._nth.call(null,c__7187__auto__,i__22592);
cljs.core.chunk_append.call(null,b__22593,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),render_child.call(null,d)], null));

var G__22603 = (i__22592 + (1));
i__22592 = G__22603;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__22593),hatti$views$record$iter__22590.call(null,cljs.core.chunk_rest.call(null,s__22591__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__22593),null);
}
} else {
var d = cljs.core.first.call(null,s__22591__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),render_child.call(null,d)], null),hatti$views$record$iter__22590.call(null,cljs.core.rest.call(null,s__22591__$2)));
}
} else {
return null;
}
break;
}
});})(G__22589,collapse_BANG_,map__22583,map__22583__$1,row_el,question_el,answer_el,header,fname,render_child,tbl,___$1,map__22581,map__22581__$1,collapsed_QMARK_,map__22573,map__22573__$1,data,repeat_field,lang,map__22574,map__22574__$1,view))
,null,null));
});})(G__22589,collapse_BANG_,map__22583,map__22583__$1,row_el,question_el,answer_el,header,fname,render_child,tbl,___$1,map__22581,map__22581__$1,collapsed_QMARK_,map__22573,map__22573__$1,data,repeat_field,lang,map__22574,map__22574__$1,view))
;
return iter__7189__auto__.call(null,self__.data);
})()], null)], null);

break;
case "table":
return tbl.call(null,"repeat-block",header,(function (){var iter__7189__auto__ = ((function (G__22589,collapse_BANG_,map__22583,map__22583__$1,row_el,question_el,answer_el,header,fname,render_child,tbl,___$1,map__22581,map__22581__$1,collapsed_QMARK_,map__22573,map__22573__$1,data,repeat_field,lang,map__22574,map__22574__$1,view){
return (function hatti$views$record$iter__22594(s__22595){
return (new cljs.core.LazySeq(null,((function (G__22589,collapse_BANG_,map__22583,map__22583__$1,row_el,question_el,answer_el,header,fname,render_child,tbl,___$1,map__22581,map__22581__$1,collapsed_QMARK_,map__22573,map__22573__$1,data,repeat_field,lang,map__22574,map__22574__$1,view){
return (function (){
var s__22595__$1 = s__22595;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__22595__$1);
if(temp__4657__auto__){
var s__22595__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__22595__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__22595__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__22597 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__22596 = (0);
while(true){
if((i__22596 < size__7188__auto__)){
var d = cljs.core._nth.call(null,c__7187__auto__,i__22596);
cljs.core.chunk_append.call(null,b__22597,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"tbody.repeat","tbody.repeat",575514719),render_child.call(null,d)], null));

var G__22604 = (i__22596 + (1));
i__22596 = G__22604;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__22597),hatti$views$record$iter__22594.call(null,cljs.core.chunk_rest.call(null,s__22595__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__22597),null);
}
} else {
var d = cljs.core.first.call(null,s__22595__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"tbody.repeat","tbody.repeat",575514719),render_child.call(null,d)], null),hatti$views$record$iter__22594.call(null,cljs.core.rest.call(null,s__22595__$2)));
}
} else {
return null;
}
break;
}
});})(G__22589,collapse_BANG_,map__22583,map__22583__$1,row_el,question_el,answer_el,header,fname,render_child,tbl,___$1,map__22581,map__22581__$1,collapsed_QMARK_,map__22573,map__22573__$1,data,repeat_field,lang,map__22574,map__22574__$1,view))
,null,null));
});})(G__22589,collapse_BANG_,map__22583,map__22583__$1,row_el,question_el,answer_el,header,fname,render_child,tbl,___$1,map__22581,map__22581__$1,collapsed_QMARK_,map__22573,map__22573__$1,data,repeat_field,lang,map__22574,map__22574__$1,view))
;
return iter__7189__auto__.call(null,self__.data);
})());

break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(self__.view)].join('')));

}
})());
}
} else {
return null;
}
});})(map__22573,map__22573__$1,data,repeat_field,lang,map__22574,map__22574__$1,view))
;

hatti.views.record.t_hatti$views$record22577.getBasis = ((function (map__22573,map__22573__$1,data,repeat_field,lang,map__22574,map__22574__$1,view){
return (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p__22571","p__22571",1808067109,null),new cljs.core.Symbol(null,"owner","owner",1247919588,null),new cljs.core.Symbol(null,"p__22572","p__22572",-110326812,null),new cljs.core.Symbol(null,"map__22573","map__22573",-1787407542,null),new cljs.core.Symbol(null,"data","data",1407862150,null),new cljs.core.Symbol(null,"repeat-field","repeat-field",-458761008,null),new cljs.core.Symbol(null,"lang","lang",-179145577,null),new cljs.core.Symbol(null,"map__22574","map__22574",1510393097,null),new cljs.core.Symbol(null,"view","view",-1406440955,null),new cljs.core.Symbol(null,"meta22578","meta22578",-939435359,null)], null);
});})(map__22573,map__22573__$1,data,repeat_field,lang,map__22574,map__22574__$1,view))
;

hatti.views.record.t_hatti$views$record22577.cljs$lang$type = true;

hatti.views.record.t_hatti$views$record22577.cljs$lang$ctorStr = "hatti.views.record/t_hatti$views$record22577";

hatti.views.record.t_hatti$views$record22577.cljs$lang$ctorPrWriter = ((function (map__22573,map__22573__$1,data,repeat_field,lang,map__22574,map__22574__$1,view){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"hatti.views.record/t_hatti$views$record22577");
});})(map__22573,map__22573__$1,data,repeat_field,lang,map__22574,map__22574__$1,view))
;

hatti.views.record.__GT_t_hatti$views$record22577 = ((function (map__22573,map__22573__$1,data,repeat_field,lang,map__22574,map__22574__$1,view){
return (function hatti$views$record$__GT_t_hatti$views$record22577(p__22571__$1,owner__$1,p__22572__$1,map__22573__$2,data__$1,repeat_field__$1,lang__$1,map__22574__$2,view__$1,meta22578){
return (new hatti.views.record.t_hatti$views$record22577(p__22571__$1,owner__$1,p__22572__$1,map__22573__$2,data__$1,repeat_field__$1,lang__$1,map__22574__$2,view__$1,meta22578));
});})(map__22573,map__22573__$1,data,repeat_field,lang,map__22574,map__22574__$1,view))
;

}

return (new hatti.views.record.t_hatti$views$record22577(p__22571,owner,p__22572,map__22573__$1,data,repeat_field,lang,map__22574__$1,view,cljs.core.PersistentArrayMap.EMPTY));
}));
hatti.views.record.header_note = (function hatti$views$record$header_note(view,p__22605){
var map__22608 = p__22605;
var map__22608__$1 = ((((!((map__22608 == null)))?((((map__22608.cljs$lang$protocol_mask$partition0$ & (64))) || (map__22608.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22608):map__22608);
var geofield = cljs.core.get.call(null,map__22608__$1,new cljs.core.Keyword(null,"geofield","geofield",578715548));
var data = cljs.core.get.call(null,map__22608__$1,new cljs.core.Keyword(null,"data","data",-232669377));
if((cljs.core._EQ_.call(null,view,new cljs.core.Keyword(null,"map","map",1371690461))) && (cljs.core.not.call(null,cljs.core.get.call(null,data,new cljs.core.Keyword(null,"full-name","full-name",408178550).cljs$core$IFn$_invoke$arity$1(geofield))))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span.no-geo.t-normal.right","span.no-geo.t-normal.right",-1340634035),"No geodata"], null);
} else {
return null;
}
});
cljs.core._add_method.call(null,hatti.views.edit_delete,new cljs.core.Keyword(null,"default","default",-1987822328),(function (instance_id,owner,p__22610){
var map__22611 = p__22610;
var map__22611__$1 = ((((!((map__22611 == null)))?((((map__22611.cljs$lang$protocol_mask$partition0$ & (64))) || (map__22611.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22611):map__22611);
var delete_record_BANG_ = cljs.core.get.call(null,map__22611__$1,new cljs.core.Keyword(null,"delete-record!","delete-record!",1411848194));
if(typeof hatti.views.record.t_hatti$views$record22613 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.record.t_hatti$views$record22613 = (function (instance_id,owner,p__22610,map__22611,delete_record_BANG_,meta22614){
this.instance_id = instance_id;
this.owner = owner;
this.p__22610 = p__22610;
this.map__22611 = map__22611;
this.delete_record_BANG_ = delete_record_BANG_;
this.meta22614 = meta22614;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.record.t_hatti$views$record22613.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (map__22611,map__22611__$1,delete_record_BANG_){
return (function (_22615,meta22614__$1){
var self__ = this;
var _22615__$1 = this;
return (new hatti.views.record.t_hatti$views$record22613(self__.instance_id,self__.owner,self__.p__22610,self__.map__22611,self__.delete_record_BANG_,meta22614__$1));
});})(map__22611,map__22611__$1,delete_record_BANG_))
;

hatti.views.record.t_hatti$views$record22613.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (map__22611,map__22611__$1,delete_record_BANG_){
return (function (_22615){
var self__ = this;
var _22615__$1 = this;
return self__.meta22614;
});})(map__22611,map__22611__$1,delete_record_BANG_))
;

hatti.views.record.t_hatti$views$record22613.prototype.om$core$IRender$ = true;

hatti.views.record.t_hatti$views$record22613.prototype.om$core$IRender$render$arity$1 = ((function (map__22611,map__22611__$1,delete_record_BANG_){
return (function (this__18254__auto__){
var self__ = this;
var this__18254__auto____$1 = this;
return null;
});})(map__22611,map__22611__$1,delete_record_BANG_))
;

hatti.views.record.t_hatti$views$record22613.getBasis = ((function (map__22611,map__22611__$1,delete_record_BANG_){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"instance-id","instance-id",-1703074506,null),new cljs.core.Symbol(null,"owner","owner",1247919588,null),new cljs.core.Symbol(null,"p__22610","p__22610",1490324217,null),new cljs.core.Symbol(null,"map__22611","map__22611",199945270,null),new cljs.core.Symbol(null,"delete-record!","delete-record!",-1242587575,null),new cljs.core.Symbol(null,"meta22614","meta22614",1880724551,null)], null);
});})(map__22611,map__22611__$1,delete_record_BANG_))
;

hatti.views.record.t_hatti$views$record22613.cljs$lang$type = true;

hatti.views.record.t_hatti$views$record22613.cljs$lang$ctorStr = "hatti.views.record/t_hatti$views$record22613";

hatti.views.record.t_hatti$views$record22613.cljs$lang$ctorPrWriter = ((function (map__22611,map__22611__$1,delete_record_BANG_){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"hatti.views.record/t_hatti$views$record22613");
});})(map__22611,map__22611__$1,delete_record_BANG_))
;

hatti.views.record.__GT_t_hatti$views$record22613 = ((function (map__22611,map__22611__$1,delete_record_BANG_){
return (function hatti$views$record$__GT_t_hatti$views$record22613(instance_id__$1,owner__$1,p__22610__$1,map__22611__$2,delete_record_BANG___$1,meta22614){
return (new hatti.views.record.t_hatti$views$record22613(instance_id__$1,owner__$1,p__22610__$1,map__22611__$2,delete_record_BANG___$1,meta22614));
});})(map__22611,map__22611__$1,delete_record_BANG_))
;

}

return (new hatti.views.record.t_hatti$views$record22613(instance_id,owner,p__22610,map__22611__$1,delete_record_BANG_,null));
}));
cljs.core._add_method.call(null,hatti.views.submission_view,new cljs.core.Keyword(null,"default","default",-1987822328),(function (cursor,owner,p__22616){
var map__22617 = p__22616;
var map__22617__$1 = ((((!((map__22617 == null)))?((((map__22617.cljs$lang$protocol_mask$partition0$ & (64))) || (map__22617.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22617):map__22617);
var opts = map__22617__$1;
var view = cljs.core.get.call(null,map__22617__$1,new cljs.core.Keyword(null,"view","view",1247994814));
if(typeof hatti.views.record.t_hatti$views$record22619 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRenderState}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IInitState}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.record.t_hatti$views$record22619 = (function (cursor,owner,p__22616,map__22617,opts,view,meta22620){
this.cursor = cursor;
this.owner = owner;
this.p__22616 = p__22616;
this.map__22617 = map__22617;
this.opts = opts;
this.view = view;
this.meta22620 = meta22620;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.record.t_hatti$views$record22619.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (map__22617,map__22617__$1,opts,view){
return (function (_22621,meta22620__$1){
var self__ = this;
var _22621__$1 = this;
return (new hatti.views.record.t_hatti$views$record22619(self__.cursor,self__.owner,self__.p__22616,self__.map__22617,self__.opts,self__.view,meta22620__$1));
});})(map__22617,map__22617__$1,opts,view))
;

hatti.views.record.t_hatti$views$record22619.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (map__22617,map__22617__$1,opts,view){
return (function (_22621){
var self__ = this;
var _22621__$1 = this;
return self__.meta22620;
});})(map__22617,map__22617__$1,opts,view))
;

hatti.views.record.t_hatti$views$record22619.prototype.om$core$IInitState$ = true;

hatti.views.record.t_hatti$views$record22619.prototype.om$core$IInitState$init_state$arity$1 = ((function (map__22617,map__22617__$1,opts,view){
return (function (_){
var self__ = this;
var ___$1 = this;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"expand-meta?","expand-meta?",-1578417082),false], null);
});})(map__22617,map__22617__$1,opts,view))
;

hatti.views.record.t_hatti$views$record22619.prototype.om$core$IRenderState$ = true;

hatti.views.record.t_hatti$views$record22619.prototype.om$core$IRenderState$render_state$arity$2 = ((function (map__22617,map__22617__$1,opts,view){
return (function (_,p__22622){
var self__ = this;
var map__22623 = p__22622;
var map__22623__$1 = ((((!((map__22623 == null)))?((((map__22623.cljs$lang$protocol_mask$partition0$ & (64))) || (map__22623.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22623):map__22623);
var expand_meta_QMARK_ = cljs.core.get.call(null,map__22623__$1,new cljs.core.Keyword(null,"expand-meta?","expand-meta?",-1578417082));
var ___$1 = this;
var form = om.core.get_shared.call(null,self__.owner,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"flat-form","flat-form",-468858211)], null));
var language = new cljs.core.Keyword(null,"current","current",-1088038603).cljs$core$IFn$_invoke$arity$1(om.core.observe.call(null,self__.owner,hatti.shared.language_cursor.call(null)));
var map__22625 = self__.cursor;
var map__22625__$1 = ((((!((map__22625 == null)))?((((map__22625.cljs$lang$protocol_mask$partition0$ & (64))) || (map__22625.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22625):map__22625);
var id = cljs.core.get.call(null,map__22625__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var data = cljs.core.get.call(null,map__22625__$1,new cljs.core.Keyword(null,"data","data",-232669377));
var dataset_info = cljs.core.get.call(null,map__22625__$1,new cljs.core.Keyword(null,"dataset-info","dataset-info",-1196999563));
var cur_rank = cljs.core.get.call(null,data,hatti.constants._rank);
var instance_id = cljs.core.get.call(null,data,"_id");
var sdatetime = moment(cljs.core.get.call(null,data,"_submission_time"));
var map__22626 = hatti.views.record.submission_elements.call(null,self__.view);
var map__22626__$1 = ((((!((map__22626 == null)))?((((map__22626.cljs$lang$protocol_mask$partition0$ & (64))) || (map__22626.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22626):map__22626);
var top_level_wrap = cljs.core.get.call(null,map__22626__$1,new cljs.core.Keyword(null,"top-level-wrap","top-level-wrap",366303456));
var topbar_wrap = cljs.core.get.call(null,map__22626__$1,new cljs.core.Keyword(null,"topbar-wrap","topbar-wrap",1084926998));
var header_wrap = cljs.core.get.call(null,map__22626__$1,new cljs.core.Keyword(null,"header-wrap","header-wrap",517152474));
var section_wrap = cljs.core.get.call(null,map__22626__$1,new cljs.core.Keyword(null,"section-wrap","section-wrap",28486716));
var submission_info_wrap = cljs.core.get.call(null,map__22626__$1,new cljs.core.Keyword(null,"submission-info-wrap","submission-info-wrap",-1360099904));
var h4_cls = cljs.core.get.call(null,map__22626__$1,new cljs.core.Keyword(null,"h4-cls","h4-cls",-1006591520));
return sablono.interpreter.interpret.call(null,(cljs.core.truth_((function (){var or__6409__auto__ = data;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return id;
}
})())?top_level_wrap.call(null,topbar_wrap.call(null,hatti.views.record.submission_arrow.call(null,new cljs.core.Keyword(null,"left","left",-399115937),cur_rank,self__.view),hatti.views.record.submission_arrow.call(null,new cljs.core.Keyword(null,"right","right",-452581833),cur_rank,self__.view),om.core.build.call(null,hatti.views.print_xls_report_btn,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"instance-id","instance-id",951361263),instance_id,new cljs.core.Keyword(null,"dataset-info","dataset-info",-1196999563),dataset_info], null)),hatti.views.record.submission_closer.call(null)),(cljs.core.truth_(data)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),header_wrap.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"h4","h4",2004862993),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),h4_cls], null),[cljs.core.str("ID: "),cljs.core.str(instance_id)].join(''),hatti.views.record.header_note.call(null,self__.view,self__.cursor)], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"p","p",151049309),[cljs.core.str("Submitted at "),cljs.core.str(sdatetime.format("LT")),cljs.core.str(" on "),cljs.core.str(sdatetime.format("ll"))].join(''),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"br","br",934104792)], null),om.core.build.call(null,hatti.views.edit_delete,instance_id,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"opts","opts",155075701),self__.opts], null)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span.expand-meta.right","span.expand-meta.right",1357089760),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"href","href",-793805698),"#",new cljs.core.Keyword(null,"on-click","on-click",1632826543),hatti.utils.click_fn.call(null,((function (form,language,map__22625,map__22625__$1,id,data,dataset_info,cur_rank,instance_id,sdatetime,map__22626,map__22626__$1,top_level_wrap,topbar_wrap,header_wrap,section_wrap,submission_info_wrap,h4_cls,___$1,map__22623,map__22623__$1,expand_meta_QMARK_,map__22617,map__22617__$1,opts,view){
return (function (){
return om.core.update_state_BANG_.call(null,self__.owner,new cljs.core.Keyword(null,"expand-meta?","expand-meta?",-1578417082),cljs.core.not);
});})(form,language,map__22625,map__22625__$1,id,data,dataset_info,cur_rank,instance_id,sdatetime,map__22626,map__22626__$1,top_level_wrap,topbar_wrap,header_wrap,section_wrap,submission_info_wrap,h4_cls,___$1,map__22623,map__22623__$1,expand_meta_QMARK_,map__22617,map__22617__$1,opts,view))
)], null),(cljs.core.truth_(expand_meta_QMARK_)?"Hide Metadata":"Show Metadata")], null)], null)], null)),submission_info_wrap.call(null,(cljs.core.truth_(expand_meta_QMARK_)?section_wrap.call(null,(function (){var iter__7189__auto__ = ((function (form,language,map__22625,map__22625__$1,id,data,dataset_info,cur_rank,instance_id,sdatetime,map__22626,map__22626__$1,top_level_wrap,topbar_wrap,header_wrap,section_wrap,submission_info_wrap,h4_cls,___$1,map__22623,map__22623__$1,expand_meta_QMARK_,map__22617,map__22617__$1,opts,view){
return (function hatti$views$record$iter__22629(s__22630){
return (new cljs.core.LazySeq(null,((function (form,language,map__22625,map__22625__$1,id,data,dataset_info,cur_rank,instance_id,sdatetime,map__22626,map__22626__$1,top_level_wrap,topbar_wrap,header_wrap,section_wrap,submission_info_wrap,h4_cls,___$1,map__22623,map__22623__$1,expand_meta_QMARK_,map__22617,map__22617__$1,opts,view){
return (function (){
var s__22630__$1 = s__22630;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__22630__$1);
if(temp__4657__auto__){
var s__22630__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__22630__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__22630__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__22632 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__22631 = (0);
while(true){
if((i__22631 < size__7188__auto__)){
var q = cljs.core._nth.call(null,c__7187__auto__,i__22631);
cljs.core.chunk_append.call(null,b__22632,hatti.views.record.format_as_question_answer.call(null,self__.view,q,data,language));

var G__22637 = (i__22631 + (1));
i__22631 = G__22637;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__22632),hatti$views$record$iter__22629.call(null,cljs.core.chunk_rest.call(null,s__22630__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__22632),null);
}
} else {
var q = cljs.core.first.call(null,s__22630__$2);
return cljs.core.cons.call(null,hatti.views.record.format_as_question_answer.call(null,self__.view,q,data,language),hatti$views$record$iter__22629.call(null,cljs.core.rest.call(null,s__22630__$2)));
}
} else {
return null;
}
break;
}
});})(form,language,map__22625,map__22625__$1,id,data,dataset_info,cur_rank,instance_id,sdatetime,map__22626,map__22626__$1,top_level_wrap,topbar_wrap,header_wrap,section_wrap,submission_info_wrap,h4_cls,___$1,map__22623,map__22623__$1,expand_meta_QMARK_,map__22617,map__22617__$1,opts,view))
,null,null));
});})(form,language,map__22625,map__22625__$1,id,data,dataset_info,cur_rank,instance_id,sdatetime,map__22626,map__22626__$1,top_level_wrap,topbar_wrap,header_wrap,section_wrap,submission_info_wrap,h4_cls,___$1,map__22623,map__22623__$1,expand_meta_QMARK_,map__22617,map__22617__$1,opts,view))
;
return iter__7189__auto__.call(null,hatti.ona.forms.meta_fields.call(null,form,new cljs.core.Keyword(null,"with-submission-details?","with-submission-details?",524960549),true));
})()):null),section_wrap.call(null,(function (){var iter__7189__auto__ = ((function (form,language,map__22625,map__22625__$1,id,data,dataset_info,cur_rank,instance_id,sdatetime,map__22626,map__22626__$1,top_level_wrap,topbar_wrap,header_wrap,section_wrap,submission_info_wrap,h4_cls,___$1,map__22623,map__22623__$1,expand_meta_QMARK_,map__22617,map__22617__$1,opts,view){
return (function hatti$views$record$iter__22633(s__22634){
return (new cljs.core.LazySeq(null,((function (form,language,map__22625,map__22625__$1,id,data,dataset_info,cur_rank,instance_id,sdatetime,map__22626,map__22626__$1,top_level_wrap,topbar_wrap,header_wrap,section_wrap,submission_info_wrap,h4_cls,___$1,map__22623,map__22623__$1,expand_meta_QMARK_,map__22617,map__22617__$1,opts,view){
return (function (){
var s__22634__$1 = s__22634;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__22634__$1);
if(temp__4657__auto__){
var s__22634__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__22634__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__22634__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__22636 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__22635 = (0);
while(true){
if((i__22635 < size__7188__auto__)){
var q = cljs.core._nth.call(null,c__7187__auto__,i__22635);
cljs.core.chunk_append.call(null,b__22636,hatti.views.record.format_as_question_answer.call(null,self__.view,q,data,language));

var G__22638 = (i__22635 + (1));
i__22635 = G__22638;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__22636),hatti$views$record$iter__22633.call(null,cljs.core.chunk_rest.call(null,s__22634__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__22636),null);
}
} else {
var q = cljs.core.first.call(null,s__22634__$2);
return cljs.core.cons.call(null,hatti.views.record.format_as_question_answer.call(null,self__.view,q,data,language),hatti$views$record$iter__22633.call(null,cljs.core.rest.call(null,s__22634__$2)));
}
} else {
return null;
}
break;
}
});})(form,language,map__22625,map__22625__$1,id,data,dataset_info,cur_rank,instance_id,sdatetime,map__22626,map__22626__$1,top_level_wrap,topbar_wrap,header_wrap,section_wrap,submission_info_wrap,h4_cls,___$1,map__22623,map__22623__$1,expand_meta_QMARK_,map__22617,map__22617__$1,opts,view))
,null,null));
});})(form,language,map__22625,map__22625__$1,id,data,dataset_info,cur_rank,instance_id,sdatetime,map__22626,map__22626__$1,top_level_wrap,topbar_wrap,header_wrap,section_wrap,submission_info_wrap,h4_cls,___$1,map__22623,map__22623__$1,expand_meta_QMARK_,map__22617,map__22617__$1,opts,view))
;
return iter__7189__auto__.call(null,hatti.ona.forms.non_meta_fields.call(null,form));
})()))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.t-center","div.t-center",150921790),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"i.fa.fa-spinner.fa-pulse","i.fa.fa-spinner.fa-pulse",869871146)], null),"Loading data..."], null)], null))):null));
});})(map__22617,map__22617__$1,opts,view))
;

hatti.views.record.t_hatti$views$record22619.getBasis = ((function (map__22617,map__22617__$1,opts,view){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"cursor","cursor",-1642498285,null),new cljs.core.Symbol(null,"owner","owner",1247919588,null),new cljs.core.Symbol(null,"p__22616","p__22616",896412662,null),new cljs.core.Symbol(null,"map__22617","map__22617",1452941728,null),new cljs.core.Symbol(null,"opts","opts",1795607228,null),new cljs.core.Symbol(null,"view","view",-1406440955,null),new cljs.core.Symbol(null,"meta22620","meta22620",608054673,null)], null);
});})(map__22617,map__22617__$1,opts,view))
;

hatti.views.record.t_hatti$views$record22619.cljs$lang$type = true;

hatti.views.record.t_hatti$views$record22619.cljs$lang$ctorStr = "hatti.views.record/t_hatti$views$record22619";

hatti.views.record.t_hatti$views$record22619.cljs$lang$ctorPrWriter = ((function (map__22617,map__22617__$1,opts,view){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"hatti.views.record/t_hatti$views$record22619");
});})(map__22617,map__22617__$1,opts,view))
;

hatti.views.record.__GT_t_hatti$views$record22619 = ((function (map__22617,map__22617__$1,opts,view){
return (function hatti$views$record$__GT_t_hatti$views$record22619(cursor__$1,owner__$1,p__22616__$1,map__22617__$2,opts__$1,view__$1,meta22620){
return (new hatti.views.record.t_hatti$views$record22619(cursor__$1,owner__$1,p__22616__$1,map__22617__$2,opts__$1,view__$1,meta22620));
});})(map__22617,map__22617__$1,opts,view))
;

}

return (new hatti.views.record.t_hatti$views$record22619(cursor,owner,p__22616,map__22617__$1,opts,view,cljs.core.PersistentArrayMap.EMPTY));
}));
