// Compiled by ClojureScript 1.9.229 {}
goog.provide('sablono.core');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('clojure.walk');
goog.require('sablono.util');
goog.require('sablono.interpreter');
goog.require('goog.dom');
/**
 * Add an optional attribute argument to a function that returns a element vector.
 */
sablono.core.wrap_attrs = (function sablono$core$wrap_attrs(func){
return (function() { 
var G__19537__delegate = function (args){
if(cljs.core.map_QMARK_.call(null,cljs.core.first.call(null,args))){
var vec__19534 = cljs.core.apply.call(null,func,cljs.core.rest.call(null,args));
var seq__19535 = cljs.core.seq.call(null,vec__19534);
var first__19536 = cljs.core.first.call(null,seq__19535);
var seq__19535__$1 = cljs.core.next.call(null,seq__19535);
var tag = first__19536;
var body = seq__19535__$1;
if(cljs.core.map_QMARK_.call(null,cljs.core.first.call(null,body))){
return cljs.core.apply.call(null,cljs.core.vector,tag,cljs.core.merge.call(null,cljs.core.first.call(null,body),cljs.core.first.call(null,args)),cljs.core.rest.call(null,body));
} else {
return cljs.core.apply.call(null,cljs.core.vector,tag,cljs.core.first.call(null,args),body);
}
} else {
return cljs.core.apply.call(null,func,args);
}
};
var G__19537 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__19538__i = 0, G__19538__a = new Array(arguments.length -  0);
while (G__19538__i < G__19538__a.length) {G__19538__a[G__19538__i] = arguments[G__19538__i + 0]; ++G__19538__i;}
  args = new cljs.core.IndexedSeq(G__19538__a,0);
} 
return G__19537__delegate.call(this,args);};
G__19537.cljs$lang$maxFixedArity = 0;
G__19537.cljs$lang$applyTo = (function (arglist__19539){
var args = cljs.core.seq(arglist__19539);
return G__19537__delegate(args);
});
G__19537.cljs$core$IFn$_invoke$arity$variadic = G__19537__delegate;
return G__19537;
})()
;
});
sablono.core.update_arglists = (function sablono$core$update_arglists(arglists){
var iter__7189__auto__ = (function sablono$core$update_arglists_$_iter__19544(s__19545){
return (new cljs.core.LazySeq(null,(function (){
var s__19545__$1 = s__19545;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__19545__$1);
if(temp__4657__auto__){
var s__19545__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__19545__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__19545__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__19547 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__19546 = (0);
while(true){
if((i__19546 < size__7188__auto__)){
var args = cljs.core._nth.call(null,c__7187__auto__,i__19546);
cljs.core.chunk_append.call(null,b__19547,cljs.core.vec.call(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"attr-map?","attr-map?",116307443,null),args)));

var G__19548 = (i__19546 + (1));
i__19546 = G__19548;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__19547),sablono$core$update_arglists_$_iter__19544.call(null,cljs.core.chunk_rest.call(null,s__19545__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__19547),null);
}
} else {
var args = cljs.core.first.call(null,s__19545__$2);
return cljs.core.cons.call(null,cljs.core.vec.call(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"attr-map?","attr-map?",116307443,null),args)),sablono$core$update_arglists_$_iter__19544.call(null,cljs.core.rest.call(null,s__19545__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__.call(null,arglists);
});
/**
 * Render `element` as HTML string.
 */
sablono.core.render = (function sablono$core$render(element){
if(cljs.core.truth_(element)){
return React.renderToString(element);
} else {
return null;
}
});
/**
 * Render `element` as HTML string, without React internal attributes.
 */
sablono.core.render_static = (function sablono$core$render_static(element){
if(cljs.core.truth_(element)){
return React.renderToStaticMarkup(element);
} else {
return null;
}
});
/**
 * Include a list of external stylesheet files.
 */
sablono.core.include_css = (function sablono$core$include_css(var_args){
var args__7491__auto__ = [];
var len__7484__auto___19554 = arguments.length;
var i__7485__auto___19555 = (0);
while(true){
if((i__7485__auto___19555 < len__7484__auto___19554)){
args__7491__auto__.push((arguments[i__7485__auto___19555]));

var G__19556 = (i__7485__auto___19555 + (1));
i__7485__auto___19555 = G__19556;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((0) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((0)),(0),null)):null);
return sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic(argseq__7492__auto__);
});

sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic = (function (styles){
var iter__7189__auto__ = (function sablono$core$iter__19550(s__19551){
return (new cljs.core.LazySeq(null,(function (){
var s__19551__$1 = s__19551;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__19551__$1);
if(temp__4657__auto__){
var s__19551__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__19551__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__19551__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__19553 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__19552 = (0);
while(true){
if((i__19552 < size__7188__auto__)){
var style = cljs.core._nth.call(null,c__7187__auto__,i__19552);
cljs.core.chunk_append.call(null,b__19553,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"link","link",-1769163468),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"text/css",new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,style),new cljs.core.Keyword(null,"rel","rel",1378823488),"stylesheet"], null)], null));

var G__19557 = (i__19552 + (1));
i__19552 = G__19557;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__19553),sablono$core$iter__19550.call(null,cljs.core.chunk_rest.call(null,s__19551__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__19553),null);
}
} else {
var style = cljs.core.first.call(null,s__19551__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"link","link",-1769163468),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"text/css",new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,style),new cljs.core.Keyword(null,"rel","rel",1378823488),"stylesheet"], null)], null),sablono$core$iter__19550.call(null,cljs.core.rest.call(null,s__19551__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__.call(null,styles);
});

sablono.core.include_css.cljs$lang$maxFixedArity = (0);

sablono.core.include_css.cljs$lang$applyTo = (function (seq19549){
return sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq19549));
});

/**
 * Include the JavaScript library at `src`.
 */
sablono.core.include_js = (function sablono$core$include_js(src){
return goog.dom.appendChild(goog.dom.getDocument().body,goog.dom.createDom("script",({"src": src})));
});
/**
 * Include Facebook's React JavaScript library.
 */
sablono.core.include_react = (function sablono$core$include_react(){
return sablono.core.include_js.call(null,"http://fb.me/react-0.12.2.js");
});
/**
 * Wraps some content in a HTML hyperlink with the supplied URL.
 */
sablono.core.link_to19558 = (function sablono$core$link_to19558(var_args){
var args__7491__auto__ = [];
var len__7484__auto___19561 = arguments.length;
var i__7485__auto___19562 = (0);
while(true){
if((i__7485__auto___19562 < len__7484__auto___19561)){
args__7491__auto__.push((arguments[i__7485__auto___19562]));

var G__19563 = (i__7485__auto___19562 + (1));
i__7485__auto___19562 = G__19563;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return sablono.core.link_to19558.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

sablono.core.link_to19558.cljs$core$IFn$_invoke$arity$variadic = (function (url,content){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,url)], null),content], null);
});

sablono.core.link_to19558.cljs$lang$maxFixedArity = (1);

sablono.core.link_to19558.cljs$lang$applyTo = (function (seq19559){
var G__19560 = cljs.core.first.call(null,seq19559);
var seq19559__$1 = cljs.core.next.call(null,seq19559);
return sablono.core.link_to19558.cljs$core$IFn$_invoke$arity$variadic(G__19560,seq19559__$1);
});


sablono.core.link_to = sablono.core.wrap_attrs.call(null,sablono.core.link_to19558);
/**
 * Wraps some content in a HTML hyperlink with the supplied e-mail
 *   address. If no content provided use the e-mail address as content.
 */
sablono.core.mail_to19564 = (function sablono$core$mail_to19564(var_args){
var args__7491__auto__ = [];
var len__7484__auto___19571 = arguments.length;
var i__7485__auto___19572 = (0);
while(true){
if((i__7485__auto___19572 < len__7484__auto___19571)){
args__7491__auto__.push((arguments[i__7485__auto___19572]));

var G__19573 = (i__7485__auto___19572 + (1));
i__7485__auto___19572 = G__19573;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return sablono.core.mail_to19564.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

sablono.core.mail_to19564.cljs$core$IFn$_invoke$arity$variadic = (function (e_mail,p__19567){
var vec__19568 = p__19567;
var content = cljs.core.nth.call(null,vec__19568,(0),null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",-793805698),[cljs.core.str("mailto:"),cljs.core.str(e_mail)].join('')], null),(function (){var or__6409__auto__ = content;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return e_mail;
}
})()], null);
});

sablono.core.mail_to19564.cljs$lang$maxFixedArity = (1);

sablono.core.mail_to19564.cljs$lang$applyTo = (function (seq19565){
var G__19566 = cljs.core.first.call(null,seq19565);
var seq19565__$1 = cljs.core.next.call(null,seq19565);
return sablono.core.mail_to19564.cljs$core$IFn$_invoke$arity$variadic(G__19566,seq19565__$1);
});


sablono.core.mail_to = sablono.core.wrap_attrs.call(null,sablono.core.mail_to19564);
/**
 * Wrap a collection in an unordered list.
 */
sablono.core.unordered_list19574 = (function sablono$core$unordered_list19574(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ul","ul",-1349521403),(function (){var iter__7189__auto__ = (function sablono$core$unordered_list19574_$_iter__19579(s__19580){
return (new cljs.core.LazySeq(null,(function (){
var s__19580__$1 = s__19580;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__19580__$1);
if(temp__4657__auto__){
var s__19580__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__19580__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__19580__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__19582 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__19581 = (0);
while(true){
if((i__19581 < size__7188__auto__)){
var x = cljs.core._nth.call(null,c__7187__auto__,i__19581);
cljs.core.chunk_append.call(null,b__19582,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null));

var G__19583 = (i__19581 + (1));
i__19581 = G__19583;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__19582),sablono$core$unordered_list19574_$_iter__19579.call(null,cljs.core.chunk_rest.call(null,s__19580__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__19582),null);
}
} else {
var x = cljs.core.first.call(null,s__19580__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null),sablono$core$unordered_list19574_$_iter__19579.call(null,cljs.core.rest.call(null,s__19580__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__.call(null,coll);
})()], null);
});

sablono.core.unordered_list = sablono.core.wrap_attrs.call(null,sablono.core.unordered_list19574);
/**
 * Wrap a collection in an ordered list.
 */
sablono.core.ordered_list19584 = (function sablono$core$ordered_list19584(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ol","ol",932524051),(function (){var iter__7189__auto__ = (function sablono$core$ordered_list19584_$_iter__19589(s__19590){
return (new cljs.core.LazySeq(null,(function (){
var s__19590__$1 = s__19590;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__19590__$1);
if(temp__4657__auto__){
var s__19590__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__19590__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__19590__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__19592 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__19591 = (0);
while(true){
if((i__19591 < size__7188__auto__)){
var x = cljs.core._nth.call(null,c__7187__auto__,i__19591);
cljs.core.chunk_append.call(null,b__19592,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null));

var G__19593 = (i__19591 + (1));
i__19591 = G__19593;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__19592),sablono$core$ordered_list19584_$_iter__19589.call(null,cljs.core.chunk_rest.call(null,s__19590__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__19592),null);
}
} else {
var x = cljs.core.first.call(null,s__19590__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null),sablono$core$ordered_list19584_$_iter__19589.call(null,cljs.core.rest.call(null,s__19590__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__.call(null,coll);
})()], null);
});

sablono.core.ordered_list = sablono.core.wrap_attrs.call(null,sablono.core.ordered_list19584);
/**
 * Create an image element.
 */
sablono.core.image19594 = (function sablono$core$image19594(var_args){
var args19595 = [];
var len__7484__auto___19598 = arguments.length;
var i__7485__auto___19599 = (0);
while(true){
if((i__7485__auto___19599 < len__7484__auto___19598)){
args19595.push((arguments[i__7485__auto___19599]));

var G__19600 = (i__7485__auto___19599 + (1));
i__7485__auto___19599 = G__19600;
continue;
} else {
}
break;
}

var G__19597 = args19595.length;
switch (G__19597) {
case 1:
return sablono.core.image19594.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.image19594.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19595.length)].join('')));

}
});

sablono.core.image19594.cljs$core$IFn$_invoke$arity$1 = (function (src){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"img","img",1442687358),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"src","src",-1651076051),sablono.util.as_str.call(null,src)], null)], null);
});

sablono.core.image19594.cljs$core$IFn$_invoke$arity$2 = (function (src,alt){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"img","img",1442687358),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"src","src",-1651076051),sablono.util.as_str.call(null,src),new cljs.core.Keyword(null,"alt","alt",-3214426),alt], null)], null);
});

sablono.core.image19594.cljs$lang$maxFixedArity = 2;


sablono.core.image = sablono.core.wrap_attrs.call(null,sablono.core.image19594);
sablono.core._STAR_group_STAR_ = cljs.core.PersistentVector.EMPTY;
/**
 * Create a field name from the supplied argument the current field group.
 */
sablono.core.make_name = (function sablono$core$make_name(name){
return cljs.core.reduce.call(null,(function (p1__19602_SHARP_,p2__19603_SHARP_){
return [cljs.core.str(p1__19602_SHARP_),cljs.core.str("["),cljs.core.str(p2__19603_SHARP_),cljs.core.str("]")].join('');
}),cljs.core.conj.call(null,sablono.core._STAR_group_STAR_,sablono.util.as_str.call(null,name)));
});
/**
 * Create a field id from the supplied argument and current field group.
 */
sablono.core.make_id = (function sablono$core$make_id(name){
return cljs.core.reduce.call(null,(function (p1__19604_SHARP_,p2__19605_SHARP_){
return [cljs.core.str(p1__19604_SHARP_),cljs.core.str("-"),cljs.core.str(p2__19605_SHARP_)].join('');
}),cljs.core.conj.call(null,sablono.core._STAR_group_STAR_,sablono.util.as_str.call(null,name)));
});
/**
 * Creates a new <input> element.
 */
sablono.core.input_field_STAR_ = (function sablono$core$input_field_STAR_(type,name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),type,new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),value], null)], null);
});
/**
 * Creates a color input field.
 */
sablono.core.color_field19606 = (function sablono$core$color_field19606(var_args){
var args19607 = [];
var len__7484__auto___19674 = arguments.length;
var i__7485__auto___19675 = (0);
while(true){
if((i__7485__auto___19675 < len__7484__auto___19674)){
args19607.push((arguments[i__7485__auto___19675]));

var G__19676 = (i__7485__auto___19675 + (1));
i__7485__auto___19675 = G__19676;
continue;
} else {
}
break;
}

var G__19609 = args19607.length;
switch (G__19609) {
case 1:
return sablono.core.color_field19606.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.color_field19606.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19607.length)].join('')));

}
});

sablono.core.color_field19606.cljs$core$IFn$_invoke$arity$1 = (function (name__19451__auto__){
return sablono.core.color_field19606.call(null,name__19451__auto__,null);
});

sablono.core.color_field19606.cljs$core$IFn$_invoke$arity$2 = (function (name__19451__auto__,value__19452__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"color","color",-1642760596,null))].join(''),name__19451__auto__,value__19452__auto__);
});

sablono.core.color_field19606.cljs$lang$maxFixedArity = 2;


sablono.core.color_field = sablono.core.wrap_attrs.call(null,sablono.core.color_field19606);

/**
 * Creates a date input field.
 */
sablono.core.date_field19610 = (function sablono$core$date_field19610(var_args){
var args19611 = [];
var len__7484__auto___19678 = arguments.length;
var i__7485__auto___19679 = (0);
while(true){
if((i__7485__auto___19679 < len__7484__auto___19678)){
args19611.push((arguments[i__7485__auto___19679]));

var G__19680 = (i__7485__auto___19679 + (1));
i__7485__auto___19679 = G__19680;
continue;
} else {
}
break;
}

var G__19613 = args19611.length;
switch (G__19613) {
case 1:
return sablono.core.date_field19610.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.date_field19610.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19611.length)].join('')));

}
});

sablono.core.date_field19610.cljs$core$IFn$_invoke$arity$1 = (function (name__19451__auto__){
return sablono.core.date_field19610.call(null,name__19451__auto__,null);
});

sablono.core.date_field19610.cljs$core$IFn$_invoke$arity$2 = (function (name__19451__auto__,value__19452__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"date","date",177097065,null))].join(''),name__19451__auto__,value__19452__auto__);
});

sablono.core.date_field19610.cljs$lang$maxFixedArity = 2;


sablono.core.date_field = sablono.core.wrap_attrs.call(null,sablono.core.date_field19610);

/**
 * Creates a datetime input field.
 */
sablono.core.datetime_field19614 = (function sablono$core$datetime_field19614(var_args){
var args19615 = [];
var len__7484__auto___19682 = arguments.length;
var i__7485__auto___19683 = (0);
while(true){
if((i__7485__auto___19683 < len__7484__auto___19682)){
args19615.push((arguments[i__7485__auto___19683]));

var G__19684 = (i__7485__auto___19683 + (1));
i__7485__auto___19683 = G__19684;
continue;
} else {
}
break;
}

var G__19617 = args19615.length;
switch (G__19617) {
case 1:
return sablono.core.datetime_field19614.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_field19614.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19615.length)].join('')));

}
});

sablono.core.datetime_field19614.cljs$core$IFn$_invoke$arity$1 = (function (name__19451__auto__){
return sablono.core.datetime_field19614.call(null,name__19451__auto__,null);
});

sablono.core.datetime_field19614.cljs$core$IFn$_invoke$arity$2 = (function (name__19451__auto__,value__19452__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"datetime","datetime",2135207229,null))].join(''),name__19451__auto__,value__19452__auto__);
});

sablono.core.datetime_field19614.cljs$lang$maxFixedArity = 2;


sablono.core.datetime_field = sablono.core.wrap_attrs.call(null,sablono.core.datetime_field19614);

/**
 * Creates a datetime-local input field.
 */
sablono.core.datetime_local_field19618 = (function sablono$core$datetime_local_field19618(var_args){
var args19619 = [];
var len__7484__auto___19686 = arguments.length;
var i__7485__auto___19687 = (0);
while(true){
if((i__7485__auto___19687 < len__7484__auto___19686)){
args19619.push((arguments[i__7485__auto___19687]));

var G__19688 = (i__7485__auto___19687 + (1));
i__7485__auto___19687 = G__19688;
continue;
} else {
}
break;
}

var G__19621 = args19619.length;
switch (G__19621) {
case 1:
return sablono.core.datetime_local_field19618.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_local_field19618.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19619.length)].join('')));

}
});

sablono.core.datetime_local_field19618.cljs$core$IFn$_invoke$arity$1 = (function (name__19451__auto__){
return sablono.core.datetime_local_field19618.call(null,name__19451__auto__,null);
});

sablono.core.datetime_local_field19618.cljs$core$IFn$_invoke$arity$2 = (function (name__19451__auto__,value__19452__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"datetime-local","datetime-local",-507312697,null))].join(''),name__19451__auto__,value__19452__auto__);
});

sablono.core.datetime_local_field19618.cljs$lang$maxFixedArity = 2;


sablono.core.datetime_local_field = sablono.core.wrap_attrs.call(null,sablono.core.datetime_local_field19618);

/**
 * Creates a email input field.
 */
sablono.core.email_field19622 = (function sablono$core$email_field19622(var_args){
var args19623 = [];
var len__7484__auto___19690 = arguments.length;
var i__7485__auto___19691 = (0);
while(true){
if((i__7485__auto___19691 < len__7484__auto___19690)){
args19623.push((arguments[i__7485__auto___19691]));

var G__19692 = (i__7485__auto___19691 + (1));
i__7485__auto___19691 = G__19692;
continue;
} else {
}
break;
}

var G__19625 = args19623.length;
switch (G__19625) {
case 1:
return sablono.core.email_field19622.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.email_field19622.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19623.length)].join('')));

}
});

sablono.core.email_field19622.cljs$core$IFn$_invoke$arity$1 = (function (name__19451__auto__){
return sablono.core.email_field19622.call(null,name__19451__auto__,null);
});

sablono.core.email_field19622.cljs$core$IFn$_invoke$arity$2 = (function (name__19451__auto__,value__19452__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"email","email",-1238619063,null))].join(''),name__19451__auto__,value__19452__auto__);
});

sablono.core.email_field19622.cljs$lang$maxFixedArity = 2;


sablono.core.email_field = sablono.core.wrap_attrs.call(null,sablono.core.email_field19622);

/**
 * Creates a file input field.
 */
sablono.core.file_field19626 = (function sablono$core$file_field19626(var_args){
var args19627 = [];
var len__7484__auto___19694 = arguments.length;
var i__7485__auto___19695 = (0);
while(true){
if((i__7485__auto___19695 < len__7484__auto___19694)){
args19627.push((arguments[i__7485__auto___19695]));

var G__19696 = (i__7485__auto___19695 + (1));
i__7485__auto___19695 = G__19696;
continue;
} else {
}
break;
}

var G__19629 = args19627.length;
switch (G__19629) {
case 1:
return sablono.core.file_field19626.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.file_field19626.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19627.length)].join('')));

}
});

sablono.core.file_field19626.cljs$core$IFn$_invoke$arity$1 = (function (name__19451__auto__){
return sablono.core.file_field19626.call(null,name__19451__auto__,null);
});

sablono.core.file_field19626.cljs$core$IFn$_invoke$arity$2 = (function (name__19451__auto__,value__19452__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"file","file",370885649,null))].join(''),name__19451__auto__,value__19452__auto__);
});

sablono.core.file_field19626.cljs$lang$maxFixedArity = 2;


sablono.core.file_field = sablono.core.wrap_attrs.call(null,sablono.core.file_field19626);

/**
 * Creates a hidden input field.
 */
sablono.core.hidden_field19630 = (function sablono$core$hidden_field19630(var_args){
var args19631 = [];
var len__7484__auto___19698 = arguments.length;
var i__7485__auto___19699 = (0);
while(true){
if((i__7485__auto___19699 < len__7484__auto___19698)){
args19631.push((arguments[i__7485__auto___19699]));

var G__19700 = (i__7485__auto___19699 + (1));
i__7485__auto___19699 = G__19700;
continue;
} else {
}
break;
}

var G__19633 = args19631.length;
switch (G__19633) {
case 1:
return sablono.core.hidden_field19630.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.hidden_field19630.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19631.length)].join('')));

}
});

sablono.core.hidden_field19630.cljs$core$IFn$_invoke$arity$1 = (function (name__19451__auto__){
return sablono.core.hidden_field19630.call(null,name__19451__auto__,null);
});

sablono.core.hidden_field19630.cljs$core$IFn$_invoke$arity$2 = (function (name__19451__auto__,value__19452__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"hidden","hidden",1328025435,null))].join(''),name__19451__auto__,value__19452__auto__);
});

sablono.core.hidden_field19630.cljs$lang$maxFixedArity = 2;


sablono.core.hidden_field = sablono.core.wrap_attrs.call(null,sablono.core.hidden_field19630);

/**
 * Creates a month input field.
 */
sablono.core.month_field19634 = (function sablono$core$month_field19634(var_args){
var args19635 = [];
var len__7484__auto___19702 = arguments.length;
var i__7485__auto___19703 = (0);
while(true){
if((i__7485__auto___19703 < len__7484__auto___19702)){
args19635.push((arguments[i__7485__auto___19703]));

var G__19704 = (i__7485__auto___19703 + (1));
i__7485__auto___19703 = G__19704;
continue;
} else {
}
break;
}

var G__19637 = args19635.length;
switch (G__19637) {
case 1:
return sablono.core.month_field19634.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.month_field19634.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19635.length)].join('')));

}
});

sablono.core.month_field19634.cljs$core$IFn$_invoke$arity$1 = (function (name__19451__auto__){
return sablono.core.month_field19634.call(null,name__19451__auto__,null);
});

sablono.core.month_field19634.cljs$core$IFn$_invoke$arity$2 = (function (name__19451__auto__,value__19452__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"month","month",-319717006,null))].join(''),name__19451__auto__,value__19452__auto__);
});

sablono.core.month_field19634.cljs$lang$maxFixedArity = 2;


sablono.core.month_field = sablono.core.wrap_attrs.call(null,sablono.core.month_field19634);

/**
 * Creates a number input field.
 */
sablono.core.number_field19638 = (function sablono$core$number_field19638(var_args){
var args19639 = [];
var len__7484__auto___19706 = arguments.length;
var i__7485__auto___19707 = (0);
while(true){
if((i__7485__auto___19707 < len__7484__auto___19706)){
args19639.push((arguments[i__7485__auto___19707]));

var G__19708 = (i__7485__auto___19707 + (1));
i__7485__auto___19707 = G__19708;
continue;
} else {
}
break;
}

var G__19641 = args19639.length;
switch (G__19641) {
case 1:
return sablono.core.number_field19638.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.number_field19638.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19639.length)].join('')));

}
});

sablono.core.number_field19638.cljs$core$IFn$_invoke$arity$1 = (function (name__19451__auto__){
return sablono.core.number_field19638.call(null,name__19451__auto__,null);
});

sablono.core.number_field19638.cljs$core$IFn$_invoke$arity$2 = (function (name__19451__auto__,value__19452__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"number","number",-1084057331,null))].join(''),name__19451__auto__,value__19452__auto__);
});

sablono.core.number_field19638.cljs$lang$maxFixedArity = 2;


sablono.core.number_field = sablono.core.wrap_attrs.call(null,sablono.core.number_field19638);

/**
 * Creates a password input field.
 */
sablono.core.password_field19642 = (function sablono$core$password_field19642(var_args){
var args19643 = [];
var len__7484__auto___19710 = arguments.length;
var i__7485__auto___19711 = (0);
while(true){
if((i__7485__auto___19711 < len__7484__auto___19710)){
args19643.push((arguments[i__7485__auto___19711]));

var G__19712 = (i__7485__auto___19711 + (1));
i__7485__auto___19711 = G__19712;
continue;
} else {
}
break;
}

var G__19645 = args19643.length;
switch (G__19645) {
case 1:
return sablono.core.password_field19642.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.password_field19642.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19643.length)].join('')));

}
});

sablono.core.password_field19642.cljs$core$IFn$_invoke$arity$1 = (function (name__19451__auto__){
return sablono.core.password_field19642.call(null,name__19451__auto__,null);
});

sablono.core.password_field19642.cljs$core$IFn$_invoke$arity$2 = (function (name__19451__auto__,value__19452__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"password","password",2057553998,null))].join(''),name__19451__auto__,value__19452__auto__);
});

sablono.core.password_field19642.cljs$lang$maxFixedArity = 2;


sablono.core.password_field = sablono.core.wrap_attrs.call(null,sablono.core.password_field19642);

/**
 * Creates a range input field.
 */
sablono.core.range_field19646 = (function sablono$core$range_field19646(var_args){
var args19647 = [];
var len__7484__auto___19714 = arguments.length;
var i__7485__auto___19715 = (0);
while(true){
if((i__7485__auto___19715 < len__7484__auto___19714)){
args19647.push((arguments[i__7485__auto___19715]));

var G__19716 = (i__7485__auto___19715 + (1));
i__7485__auto___19715 = G__19716;
continue;
} else {
}
break;
}

var G__19649 = args19647.length;
switch (G__19649) {
case 1:
return sablono.core.range_field19646.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.range_field19646.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19647.length)].join('')));

}
});

sablono.core.range_field19646.cljs$core$IFn$_invoke$arity$1 = (function (name__19451__auto__){
return sablono.core.range_field19646.call(null,name__19451__auto__,null);
});

sablono.core.range_field19646.cljs$core$IFn$_invoke$arity$2 = (function (name__19451__auto__,value__19452__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"range","range",-1014743483,null))].join(''),name__19451__auto__,value__19452__auto__);
});

sablono.core.range_field19646.cljs$lang$maxFixedArity = 2;


sablono.core.range_field = sablono.core.wrap_attrs.call(null,sablono.core.range_field19646);

/**
 * Creates a search input field.
 */
sablono.core.search_field19650 = (function sablono$core$search_field19650(var_args){
var args19651 = [];
var len__7484__auto___19718 = arguments.length;
var i__7485__auto___19719 = (0);
while(true){
if((i__7485__auto___19719 < len__7484__auto___19718)){
args19651.push((arguments[i__7485__auto___19719]));

var G__19720 = (i__7485__auto___19719 + (1));
i__7485__auto___19719 = G__19720;
continue;
} else {
}
break;
}

var G__19653 = args19651.length;
switch (G__19653) {
case 1:
return sablono.core.search_field19650.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.search_field19650.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19651.length)].join('')));

}
});

sablono.core.search_field19650.cljs$core$IFn$_invoke$arity$1 = (function (name__19451__auto__){
return sablono.core.search_field19650.call(null,name__19451__auto__,null);
});

sablono.core.search_field19650.cljs$core$IFn$_invoke$arity$2 = (function (name__19451__auto__,value__19452__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"search","search",-1089495947,null))].join(''),name__19451__auto__,value__19452__auto__);
});

sablono.core.search_field19650.cljs$lang$maxFixedArity = 2;


sablono.core.search_field = sablono.core.wrap_attrs.call(null,sablono.core.search_field19650);

/**
 * Creates a tel input field.
 */
sablono.core.tel_field19654 = (function sablono$core$tel_field19654(var_args){
var args19655 = [];
var len__7484__auto___19722 = arguments.length;
var i__7485__auto___19723 = (0);
while(true){
if((i__7485__auto___19723 < len__7484__auto___19722)){
args19655.push((arguments[i__7485__auto___19723]));

var G__19724 = (i__7485__auto___19723 + (1));
i__7485__auto___19723 = G__19724;
continue;
} else {
}
break;
}

var G__19657 = args19655.length;
switch (G__19657) {
case 1:
return sablono.core.tel_field19654.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.tel_field19654.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19655.length)].join('')));

}
});

sablono.core.tel_field19654.cljs$core$IFn$_invoke$arity$1 = (function (name__19451__auto__){
return sablono.core.tel_field19654.call(null,name__19451__auto__,null);
});

sablono.core.tel_field19654.cljs$core$IFn$_invoke$arity$2 = (function (name__19451__auto__,value__19452__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"tel","tel",1864669686,null))].join(''),name__19451__auto__,value__19452__auto__);
});

sablono.core.tel_field19654.cljs$lang$maxFixedArity = 2;


sablono.core.tel_field = sablono.core.wrap_attrs.call(null,sablono.core.tel_field19654);

/**
 * Creates a text input field.
 */
sablono.core.text_field19658 = (function sablono$core$text_field19658(var_args){
var args19659 = [];
var len__7484__auto___19726 = arguments.length;
var i__7485__auto___19727 = (0);
while(true){
if((i__7485__auto___19727 < len__7484__auto___19726)){
args19659.push((arguments[i__7485__auto___19727]));

var G__19728 = (i__7485__auto___19727 + (1));
i__7485__auto___19727 = G__19728;
continue;
} else {
}
break;
}

var G__19661 = args19659.length;
switch (G__19661) {
case 1:
return sablono.core.text_field19658.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_field19658.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19659.length)].join('')));

}
});

sablono.core.text_field19658.cljs$core$IFn$_invoke$arity$1 = (function (name__19451__auto__){
return sablono.core.text_field19658.call(null,name__19451__auto__,null);
});

sablono.core.text_field19658.cljs$core$IFn$_invoke$arity$2 = (function (name__19451__auto__,value__19452__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"text","text",-150030170,null))].join(''),name__19451__auto__,value__19452__auto__);
});

sablono.core.text_field19658.cljs$lang$maxFixedArity = 2;


sablono.core.text_field = sablono.core.wrap_attrs.call(null,sablono.core.text_field19658);

/**
 * Creates a time input field.
 */
sablono.core.time_field19662 = (function sablono$core$time_field19662(var_args){
var args19663 = [];
var len__7484__auto___19730 = arguments.length;
var i__7485__auto___19731 = (0);
while(true){
if((i__7485__auto___19731 < len__7484__auto___19730)){
args19663.push((arguments[i__7485__auto___19731]));

var G__19732 = (i__7485__auto___19731 + (1));
i__7485__auto___19731 = G__19732;
continue;
} else {
}
break;
}

var G__19665 = args19663.length;
switch (G__19665) {
case 1:
return sablono.core.time_field19662.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.time_field19662.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19663.length)].join('')));

}
});

sablono.core.time_field19662.cljs$core$IFn$_invoke$arity$1 = (function (name__19451__auto__){
return sablono.core.time_field19662.call(null,name__19451__auto__,null);
});

sablono.core.time_field19662.cljs$core$IFn$_invoke$arity$2 = (function (name__19451__auto__,value__19452__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"time","time",-1268547887,null))].join(''),name__19451__auto__,value__19452__auto__);
});

sablono.core.time_field19662.cljs$lang$maxFixedArity = 2;


sablono.core.time_field = sablono.core.wrap_attrs.call(null,sablono.core.time_field19662);

/**
 * Creates a url input field.
 */
sablono.core.url_field19666 = (function sablono$core$url_field19666(var_args){
var args19667 = [];
var len__7484__auto___19734 = arguments.length;
var i__7485__auto___19735 = (0);
while(true){
if((i__7485__auto___19735 < len__7484__auto___19734)){
args19667.push((arguments[i__7485__auto___19735]));

var G__19736 = (i__7485__auto___19735 + (1));
i__7485__auto___19735 = G__19736;
continue;
} else {
}
break;
}

var G__19669 = args19667.length;
switch (G__19669) {
case 1:
return sablono.core.url_field19666.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.url_field19666.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19667.length)].join('')));

}
});

sablono.core.url_field19666.cljs$core$IFn$_invoke$arity$1 = (function (name__19451__auto__){
return sablono.core.url_field19666.call(null,name__19451__auto__,null);
});

sablono.core.url_field19666.cljs$core$IFn$_invoke$arity$2 = (function (name__19451__auto__,value__19452__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"url","url",1916828573,null))].join(''),name__19451__auto__,value__19452__auto__);
});

sablono.core.url_field19666.cljs$lang$maxFixedArity = 2;


sablono.core.url_field = sablono.core.wrap_attrs.call(null,sablono.core.url_field19666);

/**
 * Creates a week input field.
 */
sablono.core.week_field19670 = (function sablono$core$week_field19670(var_args){
var args19671 = [];
var len__7484__auto___19738 = arguments.length;
var i__7485__auto___19739 = (0);
while(true){
if((i__7485__auto___19739 < len__7484__auto___19738)){
args19671.push((arguments[i__7485__auto___19739]));

var G__19740 = (i__7485__auto___19739 + (1));
i__7485__auto___19739 = G__19740;
continue;
} else {
}
break;
}

var G__19673 = args19671.length;
switch (G__19673) {
case 1:
return sablono.core.week_field19670.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.week_field19670.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19671.length)].join('')));

}
});

sablono.core.week_field19670.cljs$core$IFn$_invoke$arity$1 = (function (name__19451__auto__){
return sablono.core.week_field19670.call(null,name__19451__auto__,null);
});

sablono.core.week_field19670.cljs$core$IFn$_invoke$arity$2 = (function (name__19451__auto__,value__19452__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"week","week",314058249,null))].join(''),name__19451__auto__,value__19452__auto__);
});

sablono.core.week_field19670.cljs$lang$maxFixedArity = 2;


sablono.core.week_field = sablono.core.wrap_attrs.call(null,sablono.core.week_field19670);
sablono.core.file_upload = sablono.core.file_field;
/**
 * Creates a check box.
 */
sablono.core.check_box19742 = (function sablono$core$check_box19742(var_args){
var args19743 = [];
var len__7484__auto___19746 = arguments.length;
var i__7485__auto___19747 = (0);
while(true){
if((i__7485__auto___19747 < len__7484__auto___19746)){
args19743.push((arguments[i__7485__auto___19747]));

var G__19748 = (i__7485__auto___19747 + (1));
i__7485__auto___19747 = G__19748;
continue;
} else {
}
break;
}

var G__19745 = args19743.length;
switch (G__19745) {
case 1:
return sablono.core.check_box19742.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.check_box19742.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.check_box19742.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19743.length)].join('')));

}
});

sablono.core.check_box19742.cljs$core$IFn$_invoke$arity$1 = (function (name){
return sablono.core.check_box19742.call(null,name,null);
});

sablono.core.check_box19742.cljs$core$IFn$_invoke$arity$2 = (function (name,checked_QMARK_){
return sablono.core.check_box19742.call(null,name,checked_QMARK_,"true");
});

sablono.core.check_box19742.cljs$core$IFn$_invoke$arity$3 = (function (name,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),"checkbox",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),value,new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_], null)], null);
});

sablono.core.check_box19742.cljs$lang$maxFixedArity = 3;


sablono.core.check_box = sablono.core.wrap_attrs.call(null,sablono.core.check_box19742);
/**
 * Creates a radio button.
 */
sablono.core.radio_button19750 = (function sablono$core$radio_button19750(var_args){
var args19751 = [];
var len__7484__auto___19754 = arguments.length;
var i__7485__auto___19755 = (0);
while(true){
if((i__7485__auto___19755 < len__7484__auto___19754)){
args19751.push((arguments[i__7485__auto___19755]));

var G__19756 = (i__7485__auto___19755 + (1));
i__7485__auto___19755 = G__19756;
continue;
} else {
}
break;
}

var G__19753 = args19751.length;
switch (G__19753) {
case 1:
return sablono.core.radio_button19750.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.radio_button19750.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.radio_button19750.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19751.length)].join('')));

}
});

sablono.core.radio_button19750.cljs$core$IFn$_invoke$arity$1 = (function (group){
return sablono.core.radio_button19750.call(null,group,null);
});

sablono.core.radio_button19750.cljs$core$IFn$_invoke$arity$2 = (function (group,checked_QMARK_){
return sablono.core.radio_button19750.call(null,group,checked_QMARK_,"true");
});

sablono.core.radio_button19750.cljs$core$IFn$_invoke$arity$3 = (function (group,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),"radio",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,group),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,[cljs.core.str(sablono.util.as_str.call(null,group)),cljs.core.str("-"),cljs.core.str(sablono.util.as_str.call(null,value))].join('')),new cljs.core.Keyword(null,"value","value",305978217),value,new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_], null)], null);
});

sablono.core.radio_button19750.cljs$lang$maxFixedArity = 3;


sablono.core.radio_button = sablono.core.wrap_attrs.call(null,sablono.core.radio_button19750);
/**
 * Creates a seq of option tags from a collection.
 */
sablono.core.select_options19758 = (function sablono$core$select_options19758(var_args){
var args19759 = [];
var len__7484__auto___19778 = arguments.length;
var i__7485__auto___19779 = (0);
while(true){
if((i__7485__auto___19779 < len__7484__auto___19778)){
args19759.push((arguments[i__7485__auto___19779]));

var G__19780 = (i__7485__auto___19779 + (1));
i__7485__auto___19779 = G__19780;
continue;
} else {
}
break;
}

var G__19761 = args19759.length;
switch (G__19761) {
case 1:
return sablono.core.select_options19758.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.select_options19758.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19759.length)].join('')));

}
});

sablono.core.select_options19758.cljs$core$IFn$_invoke$arity$1 = (function (coll){
return sablono.core.select_options19758.call(null,coll,null);
});

sablono.core.select_options19758.cljs$core$IFn$_invoke$arity$2 = (function (coll,selected){
var iter__7189__auto__ = (function sablono$core$iter__19762(s__19763){
return (new cljs.core.LazySeq(null,(function (){
var s__19763__$1 = s__19763;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__19763__$1);
if(temp__4657__auto__){
var s__19763__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__19763__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__19763__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__19765 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__19764 = (0);
while(true){
if((i__19764 < size__7188__auto__)){
var x = cljs.core._nth.call(null,c__7187__auto__,i__19764);
cljs.core.chunk_append.call(null,b__19765,((cljs.core.sequential_QMARK_.call(null,x))?(function (){var vec__19772 = x;
var text = cljs.core.nth.call(null,vec__19772,(0),null);
var val = cljs.core.nth.call(null,vec__19772,(1),null);
var disabled_QMARK_ = cljs.core.nth.call(null,vec__19772,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$.call(null,disabled_QMARK_);
if(cljs.core.sequential_QMARK_.call(null,val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"optgroup","optgroup",1738282218),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"label","label",1718410804),text], null),sablono.core.select_options19758.call(null,val,selected)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"value","value",305978217),val,new cljs.core.Keyword(null,"selected","selected",574897764),cljs.core._EQ_.call(null,val,selected),new cljs.core.Keyword(null,"disabled","disabled",-1529784218),disabled_QMARK___$1], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"selected","selected",574897764),cljs.core._EQ_.call(null,x,selected)], null),x], null)));

var G__19782 = (i__19764 + (1));
i__19764 = G__19782;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__19765),sablono$core$iter__19762.call(null,cljs.core.chunk_rest.call(null,s__19763__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__19765),null);
}
} else {
var x = cljs.core.first.call(null,s__19763__$2);
return cljs.core.cons.call(null,((cljs.core.sequential_QMARK_.call(null,x))?(function (){var vec__19775 = x;
var text = cljs.core.nth.call(null,vec__19775,(0),null);
var val = cljs.core.nth.call(null,vec__19775,(1),null);
var disabled_QMARK_ = cljs.core.nth.call(null,vec__19775,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$.call(null,disabled_QMARK_);
if(cljs.core.sequential_QMARK_.call(null,val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"optgroup","optgroup",1738282218),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"label","label",1718410804),text], null),sablono.core.select_options19758.call(null,val,selected)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"value","value",305978217),val,new cljs.core.Keyword(null,"selected","selected",574897764),cljs.core._EQ_.call(null,val,selected),new cljs.core.Keyword(null,"disabled","disabled",-1529784218),disabled_QMARK___$1], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"selected","selected",574897764),cljs.core._EQ_.call(null,x,selected)], null),x], null)),sablono$core$iter__19762.call(null,cljs.core.rest.call(null,s__19763__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__.call(null,coll);
});

sablono.core.select_options19758.cljs$lang$maxFixedArity = 2;


sablono.core.select_options = sablono.core.wrap_attrs.call(null,sablono.core.select_options19758);
/**
 * Creates a drop-down box using the <select> tag.
 */
sablono.core.drop_down19783 = (function sablono$core$drop_down19783(var_args){
var args19784 = [];
var len__7484__auto___19787 = arguments.length;
var i__7485__auto___19788 = (0);
while(true){
if((i__7485__auto___19788 < len__7484__auto___19787)){
args19784.push((arguments[i__7485__auto___19788]));

var G__19789 = (i__7485__auto___19788 + (1));
i__7485__auto___19788 = G__19789;
continue;
} else {
}
break;
}

var G__19786 = args19784.length;
switch (G__19786) {
case 2:
return sablono.core.drop_down19783.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.drop_down19783.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19784.length)].join('')));

}
});

sablono.core.drop_down19783.cljs$core$IFn$_invoke$arity$2 = (function (name,options){
return sablono.core.drop_down19783.call(null,name,options,null);
});

sablono.core.drop_down19783.cljs$core$IFn$_invoke$arity$3 = (function (name,options,selected){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name)], null),sablono.core.select_options.call(null,options,selected)], null);
});

sablono.core.drop_down19783.cljs$lang$maxFixedArity = 3;


sablono.core.drop_down = sablono.core.wrap_attrs.call(null,sablono.core.drop_down19783);
/**
 * Creates a text area element.
 */
sablono.core.text_area19791 = (function sablono$core$text_area19791(var_args){
var args19792 = [];
var len__7484__auto___19795 = arguments.length;
var i__7485__auto___19796 = (0);
while(true){
if((i__7485__auto___19796 < len__7484__auto___19795)){
args19792.push((arguments[i__7485__auto___19796]));

var G__19797 = (i__7485__auto___19796 + (1));
i__7485__auto___19796 = G__19797;
continue;
} else {
}
break;
}

var G__19794 = args19792.length;
switch (G__19794) {
case 1:
return sablono.core.text_area19791.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_area19791.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19792.length)].join('')));

}
});

sablono.core.text_area19791.cljs$core$IFn$_invoke$arity$1 = (function (name){
return sablono.core.text_area19791.call(null,name,null);
});

sablono.core.text_area19791.cljs$core$IFn$_invoke$arity$2 = (function (name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"textarea","textarea",-650375824),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),value], null)], null);
});

sablono.core.text_area19791.cljs$lang$maxFixedArity = 2;


sablono.core.text_area = sablono.core.wrap_attrs.call(null,sablono.core.text_area19791);
/**
 * Creates a label for an input field with the supplied name.
 */
sablono.core.label19799 = (function sablono$core$label19799(name,text){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"label","label",1718410804),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"htmlFor","htmlFor",-1050291720),sablono.core.make_id.call(null,name)], null),text], null);
});

sablono.core.label = sablono.core.wrap_attrs.call(null,sablono.core.label19799);
/**
 * Creates a submit button.
 */
sablono.core.submit_button19800 = (function sablono$core$submit_button19800(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"submit",new cljs.core.Keyword(null,"value","value",305978217),text], null)], null);
});

sablono.core.submit_button = sablono.core.wrap_attrs.call(null,sablono.core.submit_button19800);
/**
 * Creates a form reset button.
 */
sablono.core.reset_button19801 = (function sablono$core$reset_button19801(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"reset",new cljs.core.Keyword(null,"value","value",305978217),text], null)], null);
});

sablono.core.reset_button = sablono.core.wrap_attrs.call(null,sablono.core.reset_button19801);
/**
 * Create a form that points to a particular method and route.
 *   e.g. (form-to [:put "/post"]
 *       ...)
 */
sablono.core.form_to19802 = (function sablono$core$form_to19802(var_args){
var args__7491__auto__ = [];
var len__7484__auto___19809 = arguments.length;
var i__7485__auto___19810 = (0);
while(true){
if((i__7485__auto___19810 < len__7484__auto___19809)){
args__7491__auto__.push((arguments[i__7485__auto___19810]));

var G__19811 = (i__7485__auto___19810 + (1));
i__7485__auto___19810 = G__19811;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return sablono.core.form_to19802.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

sablono.core.form_to19802.cljs$core$IFn$_invoke$arity$variadic = (function (p__19805,body){
var vec__19806 = p__19805;
var method = cljs.core.nth.call(null,vec__19806,(0),null);
var action = cljs.core.nth.call(null,vec__19806,(1),null);
var method_str = clojure.string.upper_case.call(null,cljs.core.name.call(null,method));
var action_uri = sablono.util.to_uri.call(null,action);
return cljs.core.vec.call(null,cljs.core.concat.call(null,((cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"get","get",1683182755),null,new cljs.core.Keyword(null,"post","post",269697687),null], null), null),method))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),method_str,new cljs.core.Keyword(null,"action","action",-811238024),action_uri], null)], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),"POST",new cljs.core.Keyword(null,"action","action",-811238024),action_uri], null),sablono.core.hidden_field.call(null,"_method",method_str)], null)),body));
});

sablono.core.form_to19802.cljs$lang$maxFixedArity = (1);

sablono.core.form_to19802.cljs$lang$applyTo = (function (seq19803){
var G__19804 = cljs.core.first.call(null,seq19803);
var seq19803__$1 = cljs.core.next.call(null,seq19803);
return sablono.core.form_to19802.cljs$core$IFn$_invoke$arity$variadic(G__19804,seq19803__$1);
});


sablono.core.form_to = sablono.core.wrap_attrs.call(null,sablono.core.form_to19802);
