// Compiled by ClojureScript 1.7.145 {}
goog.provide('c2.dom');
goog.require('cljs.core');
goog.require('goog.dom.forms');
goog.require('goog.dom');
goog.require('goog.dom.classes');
goog.require('singult.core');
goog.require('goog.style');
goog.require('clojure.string');
Element.prototype.matchesSelector = Element.prototype.webkitMatchesSelector || Element.prototype.mozMatchesSelector || Element.prototype.msMatchesSelector || Element.prototype.oMatchesSelector;
if(cljs.core.truth_(typeof NodeList != "undefined")){
NodeList.prototype.cljs$core$ISeqable$ = true;

NodeList.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (array){
var array__$1 = this;
return cljs.core.array_seq.call(null,array__$1,(0));
});
} else {
}
HTMLCollection.prototype.cljs$core$ISeqable$ = true;

HTMLCollection.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (array){
var array__$1 = this;
return cljs.core.array_seq.call(null,array__$1,(0));
});
c2.dom.select;

/**
 * @interface
 */
c2.dom.IDom = function(){};

/**
 * Converts x to a live DOM node
 */
c2.dom.__GT_dom = (function c2$dom$__GT_dom(x){
if((!((x == null))) && (!((x.c2$dom$IDom$__GT_dom$arity$1 == null)))){
return x.c2$dom$IDom$__GT_dom$arity$1(x);
} else {
var x__5224__auto__ = (((x == null))?null:x);
var m__5225__auto__ = (c2.dom.__GT_dom[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return m__5225__auto__.call(null,x);
} else {
var m__5225__auto____$1 = (c2.dom.__GT_dom["_"]);
if(!((m__5225__auto____$1 == null))){
return m__5225__auto____$1.call(null,x);
} else {
throw cljs.core.missing_protocol.call(null,"IDom.->dom",x);
}
}
}
});

(c2.dom.IDom["string"] = true);

(c2.dom.__GT_dom["string"] = (function (selector){
return c2.dom.select.call(null,selector);
}));

cljs.core.PersistentVector.prototype.c2$dom$IDom$ = true;

cljs.core.PersistentVector.prototype.c2$dom$IDom$__GT_dom$arity$1 = (function (v){
var v__$1 = this;
return singult.core.render.call(null,v__$1);
});
if(cljs.core.truth_(typeof Node != "undefined")){
Node.prototype.c2$dom$IDom$ = true;

Node.prototype.c2$dom$IDom$__GT_dom$arity$1 = (function (node){
var node__$1 = this;
return node__$1;
});
} else {
}
/**
 * Select a single DOM node via CSS selector, optionally scoped by second arg.
 */
c2.dom.select = (function c2$dom$select(var_args){
var args23982 = [];
var len__5627__auto___23985 = arguments.length;
var i__5628__auto___23986 = (0);
while(true){
if((i__5628__auto___23986 < len__5627__auto___23985)){
args23982.push((arguments[i__5628__auto___23986]));

var G__23987 = (i__5628__auto___23986 + (1));
i__5628__auto___23986 = G__23987;
continue;
} else {
}
break;
}

var G__23984 = args23982.length;
switch (G__23984) {
case 1:
return c2.dom.select.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.select.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23982.length)].join('')));

}
});

c2.dom.select.cljs$core$IFn$_invoke$arity$1 = (function (selector){
return document.querySelector(selector);
});

c2.dom.select.cljs$core$IFn$_invoke$arity$2 = (function (selector,container){
return c2.dom.__GT_dom.call(null,container).querySelector(selector);
});

c2.dom.select.cljs$lang$maxFixedArity = 2;
/**
 * Like select, but returns a collection of nodes.
 */
c2.dom.select_all = (function c2$dom$select_all(var_args){
var args23989 = [];
var len__5627__auto___23992 = arguments.length;
var i__5628__auto___23993 = (0);
while(true){
if((i__5628__auto___23993 < len__5627__auto___23992)){
args23989.push((arguments[i__5628__auto___23993]));

var G__23994 = (i__5628__auto___23993 + (1));
i__5628__auto___23993 = G__23994;
continue;
} else {
}
break;
}

var G__23991 = args23989.length;
switch (G__23991) {
case 1:
return c2.dom.select_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.select_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23989.length)].join('')));

}
});

c2.dom.select_all.cljs$core$IFn$_invoke$arity$1 = (function (selector){
return document.querySelectorAll(selector);
});

c2.dom.select_all.cljs$core$IFn$_invoke$arity$2 = (function (selector,container){
return c2.dom.__GT_dom.call(null,container).querySelectorAll(selector);
});

c2.dom.select_all.cljs$lang$maxFixedArity = 2;
/**
 * Does live `node` match CSS `selector`?
 */
c2.dom.matches_selector_QMARK_ = (function c2$dom$matches_selector_QMARK_(node,selector){
if(cljs.core.truth_(node)){
return node.matchesSelector(selector);
} else {
return null;
}
});
/**
 * Return the children of a live DOM element.
 */
c2.dom.children = (function c2$dom$children(node){
if(cljs.core.truth_(node)){
return c2.dom.__GT_dom.call(null,node).children;
} else {
return null;
}
});
/**
 * Return parent of a live DOM node.
 */
c2.dom.parent = (function c2$dom$parent(node){
if(cljs.core.truth_(c2$dom$parent)){
return c2.dom.__GT_dom.call(null,node).parentNode;
} else {
return null;
}
});
/**
 * Make element last child of container.
 * Returns live child.
 */
c2.dom.append_BANG_ = (function c2$dom$append_BANG_(container,el){
var el__$1 = c2.dom.__GT_dom.call(null,el);
goog.dom.appendChild(c2.dom.__GT_dom.call(null,container),el__$1);

return el__$1;
});
/**
 * Make element first child of container.
 * Returns live DOM child.
 */
c2.dom.prepend_BANG_ = (function c2$dom$prepend_BANG_(container,el){
var el__$1 = c2.dom.__GT_dom.call(null,el);
goog.dom.insertChildAt(c2.dom.__GT_dom.call(null,container),el__$1,(0));

return el__$1;
});
/**
 * Remove element from DOM and return it.
 * > *el* CSS selector or live DOM node
 */
c2.dom.remove_BANG_ = (function c2$dom$remove_BANG_(el){
return goog.dom.removeNode(c2.dom.__GT_dom.call(null,el));
});
/**
 * Replace live DOM node with a new one, returning the latter.
 * > *old* CSS selector or live DOM node
 * > *new* CSS selector, live DOM node, or hiccup vector
 */
c2.dom.replace_BANG_ = (function c2$dom$replace_BANG_(old,new$){
var new$__$1 = c2.dom.__GT_dom.call(null,new$);
goog.dom.replaceNode(new$__$1,c2.dom.__GT_dom.call(null,old));

return new$__$1;
});
/**
 * Get or set inline element style.
 * 
 * `(style el)`                map of inline element styles
 * 
 * `(style el :keyword)`       value of style :keyword
 * 
 * `(style el {:keyword val})` sets inline style according to map, returns element
 * 
 * `(style el :keyword val)`   sets single style, returns element
 */
c2.dom.style = (function c2$dom$style(var_args){
var args23996 = [];
var len__5627__auto___24005 = arguments.length;
var i__5628__auto___24006 = (0);
while(true){
if((i__5628__auto___24006 < len__5627__auto___24005)){
args23996.push((arguments[i__5628__auto___24006]));

var G__24007 = (i__5628__auto___24006 + (1));
i__5628__auto___24006 = G__24007;
continue;
} else {
}
break;
}

var G__23998 = args23996.length;
switch (G__23998) {
case 1:
return c2.dom.style.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.style.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return c2.dom.style.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23996.length)].join('')));

}
});

c2.dom.style.cljs$core$IFn$_invoke$arity$1 = (function (el){
throw (new Error("TODO: return map of element styles"));
});

c2.dom.style.cljs$core$IFn$_invoke$arity$2 = (function (el,x){
var el__$1 = c2.dom.__GT_dom.call(null,el);
if((x instanceof cljs.core.Keyword)){
return goog.style.getComputedStyle(el__$1,cljs.core.name.call(null,x));
} else {
if(cljs.core.map_QMARK_.call(null,x)){
var seq__23999_24009 = cljs.core.seq.call(null,x);
var chunk__24000_24010 = null;
var count__24001_24011 = (0);
var i__24002_24012 = (0);
while(true){
if((i__24002_24012 < count__24001_24011)){
var vec__24003_24013 = cljs.core._nth.call(null,chunk__24000_24010,i__24002_24012);
var k_24014 = cljs.core.nth.call(null,vec__24003_24013,(0),null);
var v_24015 = cljs.core.nth.call(null,vec__24003_24013,(1),null);
c2.dom.style.call(null,el__$1,k_24014,v_24015);

var G__24016 = seq__23999_24009;
var G__24017 = chunk__24000_24010;
var G__24018 = count__24001_24011;
var G__24019 = (i__24002_24012 + (1));
seq__23999_24009 = G__24016;
chunk__24000_24010 = G__24017;
count__24001_24011 = G__24018;
i__24002_24012 = G__24019;
continue;
} else {
var temp__4425__auto___24020 = cljs.core.seq.call(null,seq__23999_24009);
if(temp__4425__auto___24020){
var seq__23999_24021__$1 = temp__4425__auto___24020;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__23999_24021__$1)){
var c__5372__auto___24022 = cljs.core.chunk_first.call(null,seq__23999_24021__$1);
var G__24023 = cljs.core.chunk_rest.call(null,seq__23999_24021__$1);
var G__24024 = c__5372__auto___24022;
var G__24025 = cljs.core.count.call(null,c__5372__auto___24022);
var G__24026 = (0);
seq__23999_24009 = G__24023;
chunk__24000_24010 = G__24024;
count__24001_24011 = G__24025;
i__24002_24012 = G__24026;
continue;
} else {
var vec__24004_24027 = cljs.core.first.call(null,seq__23999_24021__$1);
var k_24028 = cljs.core.nth.call(null,vec__24004_24027,(0),null);
var v_24029 = cljs.core.nth.call(null,vec__24004_24027,(1),null);
c2.dom.style.call(null,el__$1,k_24028,v_24029);

var G__24030 = cljs.core.next.call(null,seq__23999_24021__$1);
var G__24031 = null;
var G__24032 = (0);
var G__24033 = (0);
seq__23999_24009 = G__24030;
chunk__24000_24010 = G__24031;
count__24001_24011 = G__24032;
i__24002_24012 = G__24033;
continue;
}
} else {
}
}
break;
}

return el__$1;
} else {
return null;
}
}
});

c2.dom.style.cljs$core$IFn$_invoke$arity$3 = (function (el,k,v){
goog.style.setStyle(c2.dom.__GT_dom.call(null,el),cljs.core.name.call(null,k),((typeof v === 'string')?v:((typeof v === 'number')?(cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"bottom","bottom",-1550509018),null,new cljs.core.Keyword(null,"top","top",-1856271961),null,new cljs.core.Keyword(null,"width","width",-384071477),null,new cljs.core.Keyword(null,"right","right",-452581833),null,new cljs.core.Keyword(null,"height","height",1025178622),null,new cljs.core.Keyword(null,"left","left",-399115937),null], null), null).call(null,cljs.core.keyword.call(null,k)))?[cljs.core.str(v),cljs.core.str("px")].join(''):v):null)));

return el;
});

c2.dom.style.cljs$lang$maxFixedArity = 3;
/**
 * Get or set element attributes.
 * 
 * `(attr el)`                map of element attributes
 * 
 * `(attr el :keyword)`       value of attr :keyword
 * 
 * `(attr el {:keyword val})` sets element attributes according to map, returns element
 * 
 * `(attr el :keyword val)`   sets single attr, returns element
 */
c2.dom.attr = (function c2$dom$attr(var_args){
var args24034 = [];
var len__5627__auto___24047 = arguments.length;
var i__5628__auto___24048 = (0);
while(true){
if((i__5628__auto___24048 < len__5627__auto___24047)){
args24034.push((arguments[i__5628__auto___24048]));

var G__24049 = (i__5628__auto___24048 + (1));
i__5628__auto___24048 = G__24049;
continue;
} else {
}
break;
}

var G__24036 = args24034.length;
switch (G__24036) {
case 1:
return c2.dom.attr.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.attr.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return c2.dom.attr.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args24034.length)].join('')));

}
});

c2.dom.attr.cljs$core$IFn$_invoke$arity$1 = (function (el){
var attrs = c2.dom.__GT_dom.call(null,el).attributes;
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__5341__auto__ = ((function (attrs){
return (function c2$dom$iter__24037(s__24038){
return (new cljs.core.LazySeq(null,((function (attrs){
return (function (){
var s__24038__$1 = s__24038;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__24038__$1);
if(temp__4425__auto__){
var s__24038__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__24038__$2)){
var c__5339__auto__ = cljs.core.chunk_first.call(null,s__24038__$2);
var size__5340__auto__ = cljs.core.count.call(null,c__5339__auto__);
var b__24040 = cljs.core.chunk_buffer.call(null,size__5340__auto__);
if((function (){var i__24039 = (0);
while(true){
if((i__24039 < size__5340__auto__)){
var i = cljs.core._nth.call(null,c__5339__auto__,i__24039);
cljs.core.chunk_append.call(null,b__24040,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.keyword.call(null,(attrs[i]).name),(attrs[i]).value], null));

var G__24051 = (i__24039 + (1));
i__24039 = G__24051;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__24040),c2$dom$iter__24037.call(null,cljs.core.chunk_rest.call(null,s__24038__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__24040),null);
}
} else {
var i = cljs.core.first.call(null,s__24038__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.keyword.call(null,(attrs[i]).name),(attrs[i]).value], null),c2$dom$iter__24037.call(null,cljs.core.rest.call(null,s__24038__$2)));
}
} else {
return null;
}
break;
}
});})(attrs))
,null,null));
});})(attrs))
;
return iter__5341__auto__.call(null,cljs.core.range.call(null,attrs.length));
})());
});

c2.dom.attr.cljs$core$IFn$_invoke$arity$2 = (function (el,x){
var el__$1 = c2.dom.__GT_dom.call(null,el);
if((x instanceof cljs.core.Keyword)){
return el__$1.getAttribute(cljs.core.name.call(null,x));
} else {
if(cljs.core.map_QMARK_.call(null,x)){
var seq__24041_24052 = cljs.core.seq.call(null,x);
var chunk__24042_24053 = null;
var count__24043_24054 = (0);
var i__24044_24055 = (0);
while(true){
if((i__24044_24055 < count__24043_24054)){
var vec__24045_24056 = cljs.core._nth.call(null,chunk__24042_24053,i__24044_24055);
var k_24057 = cljs.core.nth.call(null,vec__24045_24056,(0),null);
var v_24058 = cljs.core.nth.call(null,vec__24045_24056,(1),null);
c2.dom.attr.call(null,el__$1,k_24057,v_24058);

var G__24059 = seq__24041_24052;
var G__24060 = chunk__24042_24053;
var G__24061 = count__24043_24054;
var G__24062 = (i__24044_24055 + (1));
seq__24041_24052 = G__24059;
chunk__24042_24053 = G__24060;
count__24043_24054 = G__24061;
i__24044_24055 = G__24062;
continue;
} else {
var temp__4425__auto___24063 = cljs.core.seq.call(null,seq__24041_24052);
if(temp__4425__auto___24063){
var seq__24041_24064__$1 = temp__4425__auto___24063;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__24041_24064__$1)){
var c__5372__auto___24065 = cljs.core.chunk_first.call(null,seq__24041_24064__$1);
var G__24066 = cljs.core.chunk_rest.call(null,seq__24041_24064__$1);
var G__24067 = c__5372__auto___24065;
var G__24068 = cljs.core.count.call(null,c__5372__auto___24065);
var G__24069 = (0);
seq__24041_24052 = G__24066;
chunk__24042_24053 = G__24067;
count__24043_24054 = G__24068;
i__24044_24055 = G__24069;
continue;
} else {
var vec__24046_24070 = cljs.core.first.call(null,seq__24041_24064__$1);
var k_24071 = cljs.core.nth.call(null,vec__24046_24070,(0),null);
var v_24072 = cljs.core.nth.call(null,vec__24046_24070,(1),null);
c2.dom.attr.call(null,el__$1,k_24071,v_24072);

var G__24073 = cljs.core.next.call(null,seq__24041_24064__$1);
var G__24074 = null;
var G__24075 = (0);
var G__24076 = (0);
seq__24041_24052 = G__24073;
chunk__24042_24053 = G__24074;
count__24043_24054 = G__24075;
i__24044_24055 = G__24076;
continue;
}
} else {
}
}
break;
}

return el__$1;
} else {
return null;
}
}
});

c2.dom.attr.cljs$core$IFn$_invoke$arity$3 = (function (el,k,v){
var el__$1 = c2.dom.__GT_dom.call(null,el);
if((v == null)){
el__$1.removeAttribute(cljs.core.name.call(null,k));
} else {
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"style","style",-496642736),k)){
c2.dom.style.call(null,el__$1,v);
} else {
el__$1.setAttribute(cljs.core.name.call(null,k),v);
}
}

return el__$1;
});

c2.dom.attr.cljs$lang$maxFixedArity = 3;
/**
 * Get or set element text, returning element
 */
c2.dom.text = (function c2$dom$text(var_args){
var args24077 = [];
var len__5627__auto___24080 = arguments.length;
var i__5628__auto___24081 = (0);
while(true){
if((i__5628__auto___24081 < len__5627__auto___24080)){
args24077.push((arguments[i__5628__auto___24081]));

var G__24082 = (i__5628__auto___24081 + (1));
i__5628__auto___24081 = G__24082;
continue;
} else {
}
break;
}

var G__24079 = args24077.length;
switch (G__24079) {
case 1:
return c2.dom.text.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.text.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args24077.length)].join('')));

}
});

c2.dom.text.cljs$core$IFn$_invoke$arity$1 = (function (el){
return goog.dom.getTextContent(c2.dom.__GT_dom.call(null,el));
});

c2.dom.text.cljs$core$IFn$_invoke$arity$2 = (function (el,v){
var el__$1 = c2.dom.__GT_dom.call(null,el);
goog.dom.setTextContent(el__$1,v);

return el__$1;
});

c2.dom.text.cljs$lang$maxFixedArity = 2;
/**
 * Get or set element value.
 */
c2.dom.val = (function c2$dom$val(var_args){
var args24084 = [];
var len__5627__auto___24087 = arguments.length;
var i__5628__auto___24088 = (0);
while(true){
if((i__5628__auto___24088 < len__5627__auto___24087)){
args24084.push((arguments[i__5628__auto___24088]));

var G__24089 = (i__5628__auto___24088 + (1));
i__5628__auto___24088 = G__24089;
continue;
} else {
}
break;
}

var G__24086 = args24084.length;
switch (G__24086) {
case 1:
return c2.dom.val.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.val.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args24084.length)].join('')));

}
});

c2.dom.val.cljs$core$IFn$_invoke$arity$1 = (function (el){
return goog.dom.forms.getValue(c2.dom.__GT_dom.call(null,el));
});

c2.dom.val.cljs$core$IFn$_invoke$arity$2 = (function (el,v){
var el__$1 = c2.dom.__GT_dom.call(null,el);
goog.dom.forms.setValue(el__$1,v);

return el__$1;
});

c2.dom.val.cljs$lang$maxFixedArity = 2;
/**
 * Add or remove `class` to element based on boolean `classed?`, returning element.
 */
c2.dom.classed_BANG_ = (function c2$dom$classed_BANG_(el,class$,classed_QMARK_){
goog.dom.classes.enable(c2.dom.__GT_dom.call(null,el),cljs.core.name.call(null,class$),classed_QMARK_);

return el;
});
c2.dom.add_class_BANG_ = (function c2$dom$add_class_BANG_(el,class$){
return c2.dom.classed_BANG_.call(null,el,class$,true);
});
c2.dom.remove_class_BANG_ = (function c2$dom$remove_class_BANG_(el,class$){
return c2.dom.classed_BANG_.call(null,el,class$,false);
});
c2.dom.request_animation_frame = (function (){var or__4569__auto__ = window.requestAnimationFrame;
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
var or__4569__auto____$1 = window.webkitRequestAnimationFrame;
if(cljs.core.truth_(or__4569__auto____$1)){
return or__4569__auto____$1;
} else {
return ((function (or__4569__auto____$1,or__4569__auto__){
return (function (p1__24091_SHARP_){
return setTimeout(((function (or__4569__auto____$1,or__4569__auto__){
return (function (){
return p1__24091_SHARP_.call(null);
});})(or__4569__auto____$1,or__4569__auto__))
,(10));
});
;})(or__4569__auto____$1,or__4569__auto__))
}
}
})();
