// Compiled by ClojureScript 1.9.229 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var args12184 = [];
var len__7484__auto___12190 = arguments.length;
var i__7485__auto___12191 = (0);
while(true){
if((i__7485__auto___12191 < len__7484__auto___12190)){
args12184.push((arguments[i__7485__auto___12191]));

var G__12192 = (i__7485__auto___12191 + (1));
i__7485__auto___12191 = G__12192;
continue;
} else {
}
break;
}

var G__12186 = args12184.length;
switch (G__12186) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12184.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async12187 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12187 = (function (f,blockable,meta12188){
this.f = f;
this.blockable = blockable;
this.meta12188 = meta12188;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async12187.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_12189,meta12188__$1){
var self__ = this;
var _12189__$1 = this;
return (new cljs.core.async.t_cljs$core$async12187(self__.f,self__.blockable,meta12188__$1));
});

cljs.core.async.t_cljs$core$async12187.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_12189){
var self__ = this;
var _12189__$1 = this;
return self__.meta12188;
});

cljs.core.async.t_cljs$core$async12187.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async12187.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async12187.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async12187.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async12187.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta12188","meta12188",1636603601,null)], null);
});

cljs.core.async.t_cljs$core$async12187.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async12187.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12187";

cljs.core.async.t_cljs$core$async12187.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"cljs.core.async/t_cljs$core$async12187");
});

cljs.core.async.__GT_t_cljs$core$async12187 = (function cljs$core$async$__GT_t_cljs$core$async12187(f__$1,blockable__$1,meta12188){
return (new cljs.core.async.t_cljs$core$async12187(f__$1,blockable__$1,meta12188));
});

}

return (new cljs.core.async.t_cljs$core$async12187(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || (buff.cljs$core$async$impl$protocols$UnblockingBuffer$)){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args12196 = [];
var len__7484__auto___12199 = arguments.length;
var i__7485__auto___12200 = (0);
while(true){
if((i__7485__auto___12200 < len__7484__auto___12199)){
args12196.push((arguments[i__7485__auto___12200]));

var G__12201 = (i__7485__auto___12200 + (1));
i__7485__auto___12200 = G__12201;
continue;
} else {
}
break;
}

var G__12198 = args12196.length;
switch (G__12198) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12196.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str("buf-or-n")].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var args12203 = [];
var len__7484__auto___12206 = arguments.length;
var i__7485__auto___12207 = (0);
while(true){
if((i__7485__auto___12207 < len__7484__auto___12206)){
args12203.push((arguments[i__7485__auto___12207]));

var G__12208 = (i__7485__auto___12207 + (1));
i__7485__auto___12207 = G__12208;
continue;
} else {
}
break;
}

var G__12205 = args12203.length;
switch (G__12205) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12203.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args12210 = [];
var len__7484__auto___12213 = arguments.length;
var i__7485__auto___12214 = (0);
while(true){
if((i__7485__auto___12214 < len__7484__auto___12213)){
args12210.push((arguments[i__7485__auto___12214]));

var G__12215 = (i__7485__auto___12214 + (1));
i__7485__auto___12214 = G__12215;
continue;
} else {
}
break;
}

var G__12212 = args12210.length;
switch (G__12212) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12210.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_12217 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_12217);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_12217,ret){
return (function (){
return fn1.call(null,val_12217);
});})(val_12217,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args12218 = [];
var len__7484__auto___12221 = arguments.length;
var i__7485__auto___12222 = (0);
while(true){
if((i__7485__auto___12222 < len__7484__auto___12221)){
args12218.push((arguments[i__7485__auto___12222]));

var G__12223 = (i__7485__auto___12222 + (1));
i__7485__auto___12222 = G__12223;
continue;
} else {
}
break;
}

var G__12220 = args12218.length;
switch (G__12220) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12218.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4655__auto__)){
var ret = temp__4655__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__4655__auto__)){
var retb = temp__4655__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__4655__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__4655__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__7324__auto___12225 = n;
var x_12226 = (0);
while(true){
if((x_12226 < n__7324__auto___12225)){
(a[x_12226] = (0));

var G__12227 = (x_12226 + (1));
x_12226 = G__12227;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__12228 = (i + (1));
i = G__12228;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async12232 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12232 = (function (alt_flag,flag,meta12233){
this.alt_flag = alt_flag;
this.flag = flag;
this.meta12233 = meta12233;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async12232.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_12234,meta12233__$1){
var self__ = this;
var _12234__$1 = this;
return (new cljs.core.async.t_cljs$core$async12232(self__.alt_flag,self__.flag,meta12233__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async12232.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_12234){
var self__ = this;
var _12234__$1 = this;
return self__.meta12233;
});})(flag))
;

cljs.core.async.t_cljs$core$async12232.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async12232.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async12232.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async12232.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async12232.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-flag","alt-flag",-1794972754,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(cljs.core.PersistentVector.EMPTY))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta12233","meta12233",1419753328,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async12232.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async12232.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12232";

cljs.core.async.t_cljs$core$async12232.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"cljs.core.async/t_cljs$core$async12232");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async12232 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async12232(alt_flag__$1,flag__$1,meta12233){
return (new cljs.core.async.t_cljs$core$async12232(alt_flag__$1,flag__$1,meta12233));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async12232(cljs$core$async$alt_flag,flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async12238 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12238 = (function (alt_handler,flag,cb,meta12239){
this.alt_handler = alt_handler;
this.flag = flag;
this.cb = cb;
this.meta12239 = meta12239;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async12238.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_12240,meta12239__$1){
var self__ = this;
var _12240__$1 = this;
return (new cljs.core.async.t_cljs$core$async12238(self__.alt_handler,self__.flag,self__.cb,meta12239__$1));
});

cljs.core.async.t_cljs$core$async12238.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_12240){
var self__ = this;
var _12240__$1 = this;
return self__.meta12239;
});

cljs.core.async.t_cljs$core$async12238.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async12238.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async12238.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async12238.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async12238.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-handler","alt-handler",963786170,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null)], null)))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta12239","meta12239",2078604627,null)], null);
});

cljs.core.async.t_cljs$core$async12238.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async12238.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12238";

cljs.core.async.t_cljs$core$async12238.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"cljs.core.async/t_cljs$core$async12238");
});

cljs.core.async.__GT_t_cljs$core$async12238 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async12238(alt_handler__$1,flag__$1,cb__$1,meta12239){
return (new cljs.core.async.t_cljs$core$async12238(alt_handler__$1,flag__$1,cb__$1,meta12239));
});

}

return (new cljs.core.async.t_cljs$core$async12238(cljs$core$async$alt_handler,flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__12241_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__12241_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__12242_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__12242_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__6409__auto__ = wport;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return port;
}
})()], null));
} else {
var G__12243 = (i + (1));
i = G__12243;
continue;
}
} else {
return null;
}
break;
}
})();
var or__6409__auto__ = ret;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__4657__auto__ = (function (){var and__6397__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__6397__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__6397__auto__;
}
})();
if(cljs.core.truth_(temp__4657__auto__)){
var got = temp__4657__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__7491__auto__ = [];
var len__7484__auto___12249 = arguments.length;
var i__7485__auto___12250 = (0);
while(true){
if((i__7485__auto___12250 < len__7484__auto___12249)){
args__7491__auto__.push((arguments[i__7485__auto___12250]));

var G__12251 = (i__7485__auto___12250 + (1));
i__7485__auto___12250 = G__12251;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__12246){
var map__12247 = p__12246;
var map__12247__$1 = ((((!((map__12247 == null)))?((((map__12247.cljs$lang$protocol_mask$partition0$ & (64))) || (map__12247.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__12247):map__12247);
var opts = map__12247__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq12244){
var G__12245 = cljs.core.first.call(null,seq12244);
var seq12244__$1 = cljs.core.next.call(null,seq12244);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__12245,seq12244__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args12252 = [];
var len__7484__auto___12302 = arguments.length;
var i__7485__auto___12303 = (0);
while(true){
if((i__7485__auto___12303 < len__7484__auto___12302)){
args12252.push((arguments[i__7485__auto___12303]));

var G__12304 = (i__7485__auto___12303 + (1));
i__7485__auto___12303 = G__12304;
continue;
} else {
}
break;
}

var G__12254 = args12252.length;
switch (G__12254) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12252.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__12139__auto___12306 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__12139__auto___12306){
return (function (){
var f__12140__auto__ = (function (){var switch__12027__auto__ = ((function (c__12139__auto___12306){
return (function (state_12278){
var state_val_12279 = (state_12278[(1)]);
if((state_val_12279 === (7))){
var inst_12274 = (state_12278[(2)]);
var state_12278__$1 = state_12278;
var statearr_12280_12307 = state_12278__$1;
(statearr_12280_12307[(2)] = inst_12274);

(statearr_12280_12307[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12279 === (1))){
var state_12278__$1 = state_12278;
var statearr_12281_12308 = state_12278__$1;
(statearr_12281_12308[(2)] = null);

(statearr_12281_12308[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12279 === (4))){
var inst_12257 = (state_12278[(7)]);
var inst_12257__$1 = (state_12278[(2)]);
var inst_12258 = (inst_12257__$1 == null);
var state_12278__$1 = (function (){var statearr_12282 = state_12278;
(statearr_12282[(7)] = inst_12257__$1);

return statearr_12282;
})();
if(cljs.core.truth_(inst_12258)){
var statearr_12283_12309 = state_12278__$1;
(statearr_12283_12309[(1)] = (5));

} else {
var statearr_12284_12310 = state_12278__$1;
(statearr_12284_12310[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12279 === (13))){
var state_12278__$1 = state_12278;
var statearr_12285_12311 = state_12278__$1;
(statearr_12285_12311[(2)] = null);

(statearr_12285_12311[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12279 === (6))){
var inst_12257 = (state_12278[(7)]);
var state_12278__$1 = state_12278;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12278__$1,(11),to,inst_12257);
} else {
if((state_val_12279 === (3))){
var inst_12276 = (state_12278[(2)]);
var state_12278__$1 = state_12278;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12278__$1,inst_12276);
} else {
if((state_val_12279 === (12))){
var state_12278__$1 = state_12278;
var statearr_12286_12312 = state_12278__$1;
(statearr_12286_12312[(2)] = null);

(statearr_12286_12312[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12279 === (2))){
var state_12278__$1 = state_12278;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12278__$1,(4),from);
} else {
if((state_val_12279 === (11))){
var inst_12267 = (state_12278[(2)]);
var state_12278__$1 = state_12278;
if(cljs.core.truth_(inst_12267)){
var statearr_12287_12313 = state_12278__$1;
(statearr_12287_12313[(1)] = (12));

} else {
var statearr_12288_12314 = state_12278__$1;
(statearr_12288_12314[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12279 === (9))){
var state_12278__$1 = state_12278;
var statearr_12289_12315 = state_12278__$1;
(statearr_12289_12315[(2)] = null);

(statearr_12289_12315[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12279 === (5))){
var state_12278__$1 = state_12278;
if(cljs.core.truth_(close_QMARK_)){
var statearr_12290_12316 = state_12278__$1;
(statearr_12290_12316[(1)] = (8));

} else {
var statearr_12291_12317 = state_12278__$1;
(statearr_12291_12317[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12279 === (14))){
var inst_12272 = (state_12278[(2)]);
var state_12278__$1 = state_12278;
var statearr_12292_12318 = state_12278__$1;
(statearr_12292_12318[(2)] = inst_12272);

(statearr_12292_12318[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12279 === (10))){
var inst_12264 = (state_12278[(2)]);
var state_12278__$1 = state_12278;
var statearr_12293_12319 = state_12278__$1;
(statearr_12293_12319[(2)] = inst_12264);

(statearr_12293_12319[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12279 === (8))){
var inst_12261 = cljs.core.async.close_BANG_.call(null,to);
var state_12278__$1 = state_12278;
var statearr_12294_12320 = state_12278__$1;
(statearr_12294_12320[(2)] = inst_12261);

(statearr_12294_12320[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12139__auto___12306))
;
return ((function (switch__12027__auto__,c__12139__auto___12306){
return (function() {
var cljs$core$async$state_machine__12028__auto__ = null;
var cljs$core$async$state_machine__12028__auto____0 = (function (){
var statearr_12298 = [null,null,null,null,null,null,null,null];
(statearr_12298[(0)] = cljs$core$async$state_machine__12028__auto__);

(statearr_12298[(1)] = (1));

return statearr_12298;
});
var cljs$core$async$state_machine__12028__auto____1 = (function (state_12278){
while(true){
var ret_value__12029__auto__ = (function (){try{while(true){
var result__12030__auto__ = switch__12027__auto__.call(null,state_12278);
if(cljs.core.keyword_identical_QMARK_.call(null,result__12030__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12030__auto__;
}
break;
}
}catch (e12299){if((e12299 instanceof Object)){
var ex__12031__auto__ = e12299;
var statearr_12300_12321 = state_12278;
(statearr_12300_12321[(5)] = ex__12031__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12278);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12299;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__12029__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12322 = state_12278;
state_12278 = G__12322;
continue;
} else {
return ret_value__12029__auto__;
}
break;
}
});
cljs$core$async$state_machine__12028__auto__ = function(state_12278){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12028__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12028__auto____1.call(this,state_12278);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12028__auto____0;
cljs$core$async$state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12028__auto____1;
return cljs$core$async$state_machine__12028__auto__;
})()
;})(switch__12027__auto__,c__12139__auto___12306))
})();
var state__12141__auto__ = (function (){var statearr_12301 = f__12140__auto__.call(null);
(statearr_12301[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12139__auto___12306);

return statearr_12301;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__12141__auto__);
});})(c__12139__auto___12306))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__12510){
var vec__12511 = p__12510;
var v = cljs.core.nth.call(null,vec__12511,(0),null);
var p = cljs.core.nth.call(null,vec__12511,(1),null);
var job = vec__12511;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__12139__auto___12697 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__12139__auto___12697,res,vec__12511,v,p,job,jobs,results){
return (function (){
var f__12140__auto__ = (function (){var switch__12027__auto__ = ((function (c__12139__auto___12697,res,vec__12511,v,p,job,jobs,results){
return (function (state_12518){
var state_val_12519 = (state_12518[(1)]);
if((state_val_12519 === (1))){
var state_12518__$1 = state_12518;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12518__$1,(2),res,v);
} else {
if((state_val_12519 === (2))){
var inst_12515 = (state_12518[(2)]);
var inst_12516 = cljs.core.async.close_BANG_.call(null,res);
var state_12518__$1 = (function (){var statearr_12520 = state_12518;
(statearr_12520[(7)] = inst_12515);

return statearr_12520;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12518__$1,inst_12516);
} else {
return null;
}
}
});})(c__12139__auto___12697,res,vec__12511,v,p,job,jobs,results))
;
return ((function (switch__12027__auto__,c__12139__auto___12697,res,vec__12511,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__12028__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__12028__auto____0 = (function (){
var statearr_12524 = [null,null,null,null,null,null,null,null];
(statearr_12524[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__12028__auto__);

(statearr_12524[(1)] = (1));

return statearr_12524;
});
var cljs$core$async$pipeline_STAR__$_state_machine__12028__auto____1 = (function (state_12518){
while(true){
var ret_value__12029__auto__ = (function (){try{while(true){
var result__12030__auto__ = switch__12027__auto__.call(null,state_12518);
if(cljs.core.keyword_identical_QMARK_.call(null,result__12030__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12030__auto__;
}
break;
}
}catch (e12525){if((e12525 instanceof Object)){
var ex__12031__auto__ = e12525;
var statearr_12526_12698 = state_12518;
(statearr_12526_12698[(5)] = ex__12031__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12518);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12525;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__12029__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12699 = state_12518;
state_12518 = G__12699;
continue;
} else {
return ret_value__12029__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__12028__auto__ = function(state_12518){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__12028__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__12028__auto____1.call(this,state_12518);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__12028__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__12028__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__12028__auto__;
})()
;})(switch__12027__auto__,c__12139__auto___12697,res,vec__12511,v,p,job,jobs,results))
})();
var state__12141__auto__ = (function (){var statearr_12527 = f__12140__auto__.call(null);
(statearr_12527[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12139__auto___12697);

return statearr_12527;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__12141__auto__);
});})(c__12139__auto___12697,res,vec__12511,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__12528){
var vec__12529 = p__12528;
var v = cljs.core.nth.call(null,vec__12529,(0),null);
var p = cljs.core.nth.call(null,vec__12529,(1),null);
var job = vec__12529;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__7324__auto___12700 = n;
var __12701 = (0);
while(true){
if((__12701 < n__7324__auto___12700)){
var G__12532_12702 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__12532_12702) {
case "compute":
var c__12139__auto___12704 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__12701,c__12139__auto___12704,G__12532_12702,n__7324__auto___12700,jobs,results,process,async){
return (function (){
var f__12140__auto__ = (function (){var switch__12027__auto__ = ((function (__12701,c__12139__auto___12704,G__12532_12702,n__7324__auto___12700,jobs,results,process,async){
return (function (state_12545){
var state_val_12546 = (state_12545[(1)]);
if((state_val_12546 === (1))){
var state_12545__$1 = state_12545;
var statearr_12547_12705 = state_12545__$1;
(statearr_12547_12705[(2)] = null);

(statearr_12547_12705[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12546 === (2))){
var state_12545__$1 = state_12545;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12545__$1,(4),jobs);
} else {
if((state_val_12546 === (3))){
var inst_12543 = (state_12545[(2)]);
var state_12545__$1 = state_12545;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12545__$1,inst_12543);
} else {
if((state_val_12546 === (4))){
var inst_12535 = (state_12545[(2)]);
var inst_12536 = process.call(null,inst_12535);
var state_12545__$1 = state_12545;
if(cljs.core.truth_(inst_12536)){
var statearr_12548_12706 = state_12545__$1;
(statearr_12548_12706[(1)] = (5));

} else {
var statearr_12549_12707 = state_12545__$1;
(statearr_12549_12707[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12546 === (5))){
var state_12545__$1 = state_12545;
var statearr_12550_12708 = state_12545__$1;
(statearr_12550_12708[(2)] = null);

(statearr_12550_12708[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12546 === (6))){
var state_12545__$1 = state_12545;
var statearr_12551_12709 = state_12545__$1;
(statearr_12551_12709[(2)] = null);

(statearr_12551_12709[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12546 === (7))){
var inst_12541 = (state_12545[(2)]);
var state_12545__$1 = state_12545;
var statearr_12552_12710 = state_12545__$1;
(statearr_12552_12710[(2)] = inst_12541);

(statearr_12552_12710[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__12701,c__12139__auto___12704,G__12532_12702,n__7324__auto___12700,jobs,results,process,async))
;
return ((function (__12701,switch__12027__auto__,c__12139__auto___12704,G__12532_12702,n__7324__auto___12700,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__12028__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__12028__auto____0 = (function (){
var statearr_12556 = [null,null,null,null,null,null,null];
(statearr_12556[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__12028__auto__);

(statearr_12556[(1)] = (1));

return statearr_12556;
});
var cljs$core$async$pipeline_STAR__$_state_machine__12028__auto____1 = (function (state_12545){
while(true){
var ret_value__12029__auto__ = (function (){try{while(true){
var result__12030__auto__ = switch__12027__auto__.call(null,state_12545);
if(cljs.core.keyword_identical_QMARK_.call(null,result__12030__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12030__auto__;
}
break;
}
}catch (e12557){if((e12557 instanceof Object)){
var ex__12031__auto__ = e12557;
var statearr_12558_12711 = state_12545;
(statearr_12558_12711[(5)] = ex__12031__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12545);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12557;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__12029__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12712 = state_12545;
state_12545 = G__12712;
continue;
} else {
return ret_value__12029__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__12028__auto__ = function(state_12545){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__12028__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__12028__auto____1.call(this,state_12545);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__12028__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__12028__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__12028__auto__;
})()
;})(__12701,switch__12027__auto__,c__12139__auto___12704,G__12532_12702,n__7324__auto___12700,jobs,results,process,async))
})();
var state__12141__auto__ = (function (){var statearr_12559 = f__12140__auto__.call(null);
(statearr_12559[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12139__auto___12704);

return statearr_12559;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__12141__auto__);
});})(__12701,c__12139__auto___12704,G__12532_12702,n__7324__auto___12700,jobs,results,process,async))
);


break;
case "async":
var c__12139__auto___12713 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__12701,c__12139__auto___12713,G__12532_12702,n__7324__auto___12700,jobs,results,process,async){
return (function (){
var f__12140__auto__ = (function (){var switch__12027__auto__ = ((function (__12701,c__12139__auto___12713,G__12532_12702,n__7324__auto___12700,jobs,results,process,async){
return (function (state_12572){
var state_val_12573 = (state_12572[(1)]);
if((state_val_12573 === (1))){
var state_12572__$1 = state_12572;
var statearr_12574_12714 = state_12572__$1;
(statearr_12574_12714[(2)] = null);

(statearr_12574_12714[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12573 === (2))){
var state_12572__$1 = state_12572;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12572__$1,(4),jobs);
} else {
if((state_val_12573 === (3))){
var inst_12570 = (state_12572[(2)]);
var state_12572__$1 = state_12572;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12572__$1,inst_12570);
} else {
if((state_val_12573 === (4))){
var inst_12562 = (state_12572[(2)]);
var inst_12563 = async.call(null,inst_12562);
var state_12572__$1 = state_12572;
if(cljs.core.truth_(inst_12563)){
var statearr_12575_12715 = state_12572__$1;
(statearr_12575_12715[(1)] = (5));

} else {
var statearr_12576_12716 = state_12572__$1;
(statearr_12576_12716[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12573 === (5))){
var state_12572__$1 = state_12572;
var statearr_12577_12717 = state_12572__$1;
(statearr_12577_12717[(2)] = null);

(statearr_12577_12717[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12573 === (6))){
var state_12572__$1 = state_12572;
var statearr_12578_12718 = state_12572__$1;
(statearr_12578_12718[(2)] = null);

(statearr_12578_12718[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12573 === (7))){
var inst_12568 = (state_12572[(2)]);
var state_12572__$1 = state_12572;
var statearr_12579_12719 = state_12572__$1;
(statearr_12579_12719[(2)] = inst_12568);

(statearr_12579_12719[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__12701,c__12139__auto___12713,G__12532_12702,n__7324__auto___12700,jobs,results,process,async))
;
return ((function (__12701,switch__12027__auto__,c__12139__auto___12713,G__12532_12702,n__7324__auto___12700,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__12028__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__12028__auto____0 = (function (){
var statearr_12583 = [null,null,null,null,null,null,null];
(statearr_12583[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__12028__auto__);

(statearr_12583[(1)] = (1));

return statearr_12583;
});
var cljs$core$async$pipeline_STAR__$_state_machine__12028__auto____1 = (function (state_12572){
while(true){
var ret_value__12029__auto__ = (function (){try{while(true){
var result__12030__auto__ = switch__12027__auto__.call(null,state_12572);
if(cljs.core.keyword_identical_QMARK_.call(null,result__12030__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12030__auto__;
}
break;
}
}catch (e12584){if((e12584 instanceof Object)){
var ex__12031__auto__ = e12584;
var statearr_12585_12720 = state_12572;
(statearr_12585_12720[(5)] = ex__12031__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12572);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12584;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__12029__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12721 = state_12572;
state_12572 = G__12721;
continue;
} else {
return ret_value__12029__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__12028__auto__ = function(state_12572){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__12028__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__12028__auto____1.call(this,state_12572);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__12028__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__12028__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__12028__auto__;
})()
;})(__12701,switch__12027__auto__,c__12139__auto___12713,G__12532_12702,n__7324__auto___12700,jobs,results,process,async))
})();
var state__12141__auto__ = (function (){var statearr_12586 = f__12140__auto__.call(null);
(statearr_12586[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12139__auto___12713);

return statearr_12586;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__12141__auto__);
});})(__12701,c__12139__auto___12713,G__12532_12702,n__7324__auto___12700,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__12722 = (__12701 + (1));
__12701 = G__12722;
continue;
} else {
}
break;
}

var c__12139__auto___12723 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__12139__auto___12723,jobs,results,process,async){
return (function (){
var f__12140__auto__ = (function (){var switch__12027__auto__ = ((function (c__12139__auto___12723,jobs,results,process,async){
return (function (state_12608){
var state_val_12609 = (state_12608[(1)]);
if((state_val_12609 === (1))){
var state_12608__$1 = state_12608;
var statearr_12610_12724 = state_12608__$1;
(statearr_12610_12724[(2)] = null);

(statearr_12610_12724[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12609 === (2))){
var state_12608__$1 = state_12608;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12608__$1,(4),from);
} else {
if((state_val_12609 === (3))){
var inst_12606 = (state_12608[(2)]);
var state_12608__$1 = state_12608;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12608__$1,inst_12606);
} else {
if((state_val_12609 === (4))){
var inst_12589 = (state_12608[(7)]);
var inst_12589__$1 = (state_12608[(2)]);
var inst_12590 = (inst_12589__$1 == null);
var state_12608__$1 = (function (){var statearr_12611 = state_12608;
(statearr_12611[(7)] = inst_12589__$1);

return statearr_12611;
})();
if(cljs.core.truth_(inst_12590)){
var statearr_12612_12725 = state_12608__$1;
(statearr_12612_12725[(1)] = (5));

} else {
var statearr_12613_12726 = state_12608__$1;
(statearr_12613_12726[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12609 === (5))){
var inst_12592 = cljs.core.async.close_BANG_.call(null,jobs);
var state_12608__$1 = state_12608;
var statearr_12614_12727 = state_12608__$1;
(statearr_12614_12727[(2)] = inst_12592);

(statearr_12614_12727[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12609 === (6))){
var inst_12594 = (state_12608[(8)]);
var inst_12589 = (state_12608[(7)]);
var inst_12594__$1 = cljs.core.async.chan.call(null,(1));
var inst_12595 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_12596 = [inst_12589,inst_12594__$1];
var inst_12597 = (new cljs.core.PersistentVector(null,2,(5),inst_12595,inst_12596,null));
var state_12608__$1 = (function (){var statearr_12615 = state_12608;
(statearr_12615[(8)] = inst_12594__$1);

return statearr_12615;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12608__$1,(8),jobs,inst_12597);
} else {
if((state_val_12609 === (7))){
var inst_12604 = (state_12608[(2)]);
var state_12608__$1 = state_12608;
var statearr_12616_12728 = state_12608__$1;
(statearr_12616_12728[(2)] = inst_12604);

(statearr_12616_12728[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12609 === (8))){
var inst_12594 = (state_12608[(8)]);
var inst_12599 = (state_12608[(2)]);
var state_12608__$1 = (function (){var statearr_12617 = state_12608;
(statearr_12617[(9)] = inst_12599);

return statearr_12617;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12608__$1,(9),results,inst_12594);
} else {
if((state_val_12609 === (9))){
var inst_12601 = (state_12608[(2)]);
var state_12608__$1 = (function (){var statearr_12618 = state_12608;
(statearr_12618[(10)] = inst_12601);

return statearr_12618;
})();
var statearr_12619_12729 = state_12608__$1;
(statearr_12619_12729[(2)] = null);

(statearr_12619_12729[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__12139__auto___12723,jobs,results,process,async))
;
return ((function (switch__12027__auto__,c__12139__auto___12723,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__12028__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__12028__auto____0 = (function (){
var statearr_12623 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_12623[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__12028__auto__);

(statearr_12623[(1)] = (1));

return statearr_12623;
});
var cljs$core$async$pipeline_STAR__$_state_machine__12028__auto____1 = (function (state_12608){
while(true){
var ret_value__12029__auto__ = (function (){try{while(true){
var result__12030__auto__ = switch__12027__auto__.call(null,state_12608);
if(cljs.core.keyword_identical_QMARK_.call(null,result__12030__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12030__auto__;
}
break;
}
}catch (e12624){if((e12624 instanceof Object)){
var ex__12031__auto__ = e12624;
var statearr_12625_12730 = state_12608;
(statearr_12625_12730[(5)] = ex__12031__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12608);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12624;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__12029__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12731 = state_12608;
state_12608 = G__12731;
continue;
} else {
return ret_value__12029__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__12028__auto__ = function(state_12608){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__12028__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__12028__auto____1.call(this,state_12608);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__12028__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__12028__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__12028__auto__;
})()
;})(switch__12027__auto__,c__12139__auto___12723,jobs,results,process,async))
})();
var state__12141__auto__ = (function (){var statearr_12626 = f__12140__auto__.call(null);
(statearr_12626[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12139__auto___12723);

return statearr_12626;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__12141__auto__);
});})(c__12139__auto___12723,jobs,results,process,async))
);


var c__12139__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__12139__auto__,jobs,results,process,async){
return (function (){
var f__12140__auto__ = (function (){var switch__12027__auto__ = ((function (c__12139__auto__,jobs,results,process,async){
return (function (state_12664){
var state_val_12665 = (state_12664[(1)]);
if((state_val_12665 === (7))){
var inst_12660 = (state_12664[(2)]);
var state_12664__$1 = state_12664;
var statearr_12666_12732 = state_12664__$1;
(statearr_12666_12732[(2)] = inst_12660);

(statearr_12666_12732[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12665 === (20))){
var state_12664__$1 = state_12664;
var statearr_12667_12733 = state_12664__$1;
(statearr_12667_12733[(2)] = null);

(statearr_12667_12733[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12665 === (1))){
var state_12664__$1 = state_12664;
var statearr_12668_12734 = state_12664__$1;
(statearr_12668_12734[(2)] = null);

(statearr_12668_12734[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12665 === (4))){
var inst_12629 = (state_12664[(7)]);
var inst_12629__$1 = (state_12664[(2)]);
var inst_12630 = (inst_12629__$1 == null);
var state_12664__$1 = (function (){var statearr_12669 = state_12664;
(statearr_12669[(7)] = inst_12629__$1);

return statearr_12669;
})();
if(cljs.core.truth_(inst_12630)){
var statearr_12670_12735 = state_12664__$1;
(statearr_12670_12735[(1)] = (5));

} else {
var statearr_12671_12736 = state_12664__$1;
(statearr_12671_12736[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12665 === (15))){
var inst_12642 = (state_12664[(8)]);
var state_12664__$1 = state_12664;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12664__$1,(18),to,inst_12642);
} else {
if((state_val_12665 === (21))){
var inst_12655 = (state_12664[(2)]);
var state_12664__$1 = state_12664;
var statearr_12672_12737 = state_12664__$1;
(statearr_12672_12737[(2)] = inst_12655);

(statearr_12672_12737[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12665 === (13))){
var inst_12657 = (state_12664[(2)]);
var state_12664__$1 = (function (){var statearr_12673 = state_12664;
(statearr_12673[(9)] = inst_12657);

return statearr_12673;
})();
var statearr_12674_12738 = state_12664__$1;
(statearr_12674_12738[(2)] = null);

(statearr_12674_12738[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12665 === (6))){
var inst_12629 = (state_12664[(7)]);
var state_12664__$1 = state_12664;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12664__$1,(11),inst_12629);
} else {
if((state_val_12665 === (17))){
var inst_12650 = (state_12664[(2)]);
var state_12664__$1 = state_12664;
if(cljs.core.truth_(inst_12650)){
var statearr_12675_12739 = state_12664__$1;
(statearr_12675_12739[(1)] = (19));

} else {
var statearr_12676_12740 = state_12664__$1;
(statearr_12676_12740[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12665 === (3))){
var inst_12662 = (state_12664[(2)]);
var state_12664__$1 = state_12664;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12664__$1,inst_12662);
} else {
if((state_val_12665 === (12))){
var inst_12639 = (state_12664[(10)]);
var state_12664__$1 = state_12664;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12664__$1,(14),inst_12639);
} else {
if((state_val_12665 === (2))){
var state_12664__$1 = state_12664;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12664__$1,(4),results);
} else {
if((state_val_12665 === (19))){
var state_12664__$1 = state_12664;
var statearr_12677_12741 = state_12664__$1;
(statearr_12677_12741[(2)] = null);

(statearr_12677_12741[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12665 === (11))){
var inst_12639 = (state_12664[(2)]);
var state_12664__$1 = (function (){var statearr_12678 = state_12664;
(statearr_12678[(10)] = inst_12639);

return statearr_12678;
})();
var statearr_12679_12742 = state_12664__$1;
(statearr_12679_12742[(2)] = null);

(statearr_12679_12742[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12665 === (9))){
var state_12664__$1 = state_12664;
var statearr_12680_12743 = state_12664__$1;
(statearr_12680_12743[(2)] = null);

(statearr_12680_12743[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12665 === (5))){
var state_12664__$1 = state_12664;
if(cljs.core.truth_(close_QMARK_)){
var statearr_12681_12744 = state_12664__$1;
(statearr_12681_12744[(1)] = (8));

} else {
var statearr_12682_12745 = state_12664__$1;
(statearr_12682_12745[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12665 === (14))){
var inst_12642 = (state_12664[(8)]);
var inst_12644 = (state_12664[(11)]);
var inst_12642__$1 = (state_12664[(2)]);
var inst_12643 = (inst_12642__$1 == null);
var inst_12644__$1 = cljs.core.not.call(null,inst_12643);
var state_12664__$1 = (function (){var statearr_12683 = state_12664;
(statearr_12683[(8)] = inst_12642__$1);

(statearr_12683[(11)] = inst_12644__$1);

return statearr_12683;
})();
if(inst_12644__$1){
var statearr_12684_12746 = state_12664__$1;
(statearr_12684_12746[(1)] = (15));

} else {
var statearr_12685_12747 = state_12664__$1;
(statearr_12685_12747[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12665 === (16))){
var inst_12644 = (state_12664[(11)]);
var state_12664__$1 = state_12664;
var statearr_12686_12748 = state_12664__$1;
(statearr_12686_12748[(2)] = inst_12644);

(statearr_12686_12748[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12665 === (10))){
var inst_12636 = (state_12664[(2)]);
var state_12664__$1 = state_12664;
var statearr_12687_12749 = state_12664__$1;
(statearr_12687_12749[(2)] = inst_12636);

(statearr_12687_12749[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12665 === (18))){
var inst_12647 = (state_12664[(2)]);
var state_12664__$1 = state_12664;
var statearr_12688_12750 = state_12664__$1;
(statearr_12688_12750[(2)] = inst_12647);

(statearr_12688_12750[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12665 === (8))){
var inst_12633 = cljs.core.async.close_BANG_.call(null,to);
var state_12664__$1 = state_12664;
var statearr_12689_12751 = state_12664__$1;
(statearr_12689_12751[(2)] = inst_12633);

(statearr_12689_12751[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12139__auto__,jobs,results,process,async))
;
return ((function (switch__12027__auto__,c__12139__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__12028__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__12028__auto____0 = (function (){
var statearr_12693 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12693[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__12028__auto__);

(statearr_12693[(1)] = (1));

return statearr_12693;
});
var cljs$core$async$pipeline_STAR__$_state_machine__12028__auto____1 = (function (state_12664){
while(true){
var ret_value__12029__auto__ = (function (){try{while(true){
var result__12030__auto__ = switch__12027__auto__.call(null,state_12664);
if(cljs.core.keyword_identical_QMARK_.call(null,result__12030__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12030__auto__;
}
break;
}
}catch (e12694){if((e12694 instanceof Object)){
var ex__12031__auto__ = e12694;
var statearr_12695_12752 = state_12664;
(statearr_12695_12752[(5)] = ex__12031__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12664);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12694;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__12029__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12753 = state_12664;
state_12664 = G__12753;
continue;
} else {
return ret_value__12029__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__12028__auto__ = function(state_12664){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__12028__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__12028__auto____1.call(this,state_12664);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__12028__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__12028__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__12028__auto__;
})()
;})(switch__12027__auto__,c__12139__auto__,jobs,results,process,async))
})();
var state__12141__auto__ = (function (){var statearr_12696 = f__12140__auto__.call(null);
(statearr_12696[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12139__auto__);

return statearr_12696;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__12141__auto__);
});})(c__12139__auto__,jobs,results,process,async))
);

return c__12139__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args12754 = [];
var len__7484__auto___12757 = arguments.length;
var i__7485__auto___12758 = (0);
while(true){
if((i__7485__auto___12758 < len__7484__auto___12757)){
args12754.push((arguments[i__7485__auto___12758]));

var G__12759 = (i__7485__auto___12758 + (1));
i__7485__auto___12758 = G__12759;
continue;
} else {
}
break;
}

var G__12756 = args12754.length;
switch (G__12756) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12754.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args12761 = [];
var len__7484__auto___12764 = arguments.length;
var i__7485__auto___12765 = (0);
while(true){
if((i__7485__auto___12765 < len__7484__auto___12764)){
args12761.push((arguments[i__7485__auto___12765]));

var G__12766 = (i__7485__auto___12765 + (1));
i__7485__auto___12765 = G__12766;
continue;
} else {
}
break;
}

var G__12763 = args12761.length;
switch (G__12763) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12761.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args12768 = [];
var len__7484__auto___12821 = arguments.length;
var i__7485__auto___12822 = (0);
while(true){
if((i__7485__auto___12822 < len__7484__auto___12821)){
args12768.push((arguments[i__7485__auto___12822]));

var G__12823 = (i__7485__auto___12822 + (1));
i__7485__auto___12822 = G__12823;
continue;
} else {
}
break;
}

var G__12770 = args12768.length;
switch (G__12770) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12768.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__12139__auto___12825 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__12139__auto___12825,tc,fc){
return (function (){
var f__12140__auto__ = (function (){var switch__12027__auto__ = ((function (c__12139__auto___12825,tc,fc){
return (function (state_12796){
var state_val_12797 = (state_12796[(1)]);
if((state_val_12797 === (7))){
var inst_12792 = (state_12796[(2)]);
var state_12796__$1 = state_12796;
var statearr_12798_12826 = state_12796__$1;
(statearr_12798_12826[(2)] = inst_12792);

(statearr_12798_12826[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12797 === (1))){
var state_12796__$1 = state_12796;
var statearr_12799_12827 = state_12796__$1;
(statearr_12799_12827[(2)] = null);

(statearr_12799_12827[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12797 === (4))){
var inst_12773 = (state_12796[(7)]);
var inst_12773__$1 = (state_12796[(2)]);
var inst_12774 = (inst_12773__$1 == null);
var state_12796__$1 = (function (){var statearr_12800 = state_12796;
(statearr_12800[(7)] = inst_12773__$1);

return statearr_12800;
})();
if(cljs.core.truth_(inst_12774)){
var statearr_12801_12828 = state_12796__$1;
(statearr_12801_12828[(1)] = (5));

} else {
var statearr_12802_12829 = state_12796__$1;
(statearr_12802_12829[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12797 === (13))){
var state_12796__$1 = state_12796;
var statearr_12803_12830 = state_12796__$1;
(statearr_12803_12830[(2)] = null);

(statearr_12803_12830[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12797 === (6))){
var inst_12773 = (state_12796[(7)]);
var inst_12779 = p.call(null,inst_12773);
var state_12796__$1 = state_12796;
if(cljs.core.truth_(inst_12779)){
var statearr_12804_12831 = state_12796__$1;
(statearr_12804_12831[(1)] = (9));

} else {
var statearr_12805_12832 = state_12796__$1;
(statearr_12805_12832[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12797 === (3))){
var inst_12794 = (state_12796[(2)]);
var state_12796__$1 = state_12796;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12796__$1,inst_12794);
} else {
if((state_val_12797 === (12))){
var state_12796__$1 = state_12796;
var statearr_12806_12833 = state_12796__$1;
(statearr_12806_12833[(2)] = null);

(statearr_12806_12833[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12797 === (2))){
var state_12796__$1 = state_12796;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12796__$1,(4),ch);
} else {
if((state_val_12797 === (11))){
var inst_12773 = (state_12796[(7)]);
var inst_12783 = (state_12796[(2)]);
var state_12796__$1 = state_12796;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12796__$1,(8),inst_12783,inst_12773);
} else {
if((state_val_12797 === (9))){
var state_12796__$1 = state_12796;
var statearr_12807_12834 = state_12796__$1;
(statearr_12807_12834[(2)] = tc);

(statearr_12807_12834[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12797 === (5))){
var inst_12776 = cljs.core.async.close_BANG_.call(null,tc);
var inst_12777 = cljs.core.async.close_BANG_.call(null,fc);
var state_12796__$1 = (function (){var statearr_12808 = state_12796;
(statearr_12808[(8)] = inst_12776);

return statearr_12808;
})();
var statearr_12809_12835 = state_12796__$1;
(statearr_12809_12835[(2)] = inst_12777);

(statearr_12809_12835[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12797 === (14))){
var inst_12790 = (state_12796[(2)]);
var state_12796__$1 = state_12796;
var statearr_12810_12836 = state_12796__$1;
(statearr_12810_12836[(2)] = inst_12790);

(statearr_12810_12836[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12797 === (10))){
var state_12796__$1 = state_12796;
var statearr_12811_12837 = state_12796__$1;
(statearr_12811_12837[(2)] = fc);

(statearr_12811_12837[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12797 === (8))){
var inst_12785 = (state_12796[(2)]);
var state_12796__$1 = state_12796;
if(cljs.core.truth_(inst_12785)){
var statearr_12812_12838 = state_12796__$1;
(statearr_12812_12838[(1)] = (12));

} else {
var statearr_12813_12839 = state_12796__$1;
(statearr_12813_12839[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12139__auto___12825,tc,fc))
;
return ((function (switch__12027__auto__,c__12139__auto___12825,tc,fc){
return (function() {
var cljs$core$async$state_machine__12028__auto__ = null;
var cljs$core$async$state_machine__12028__auto____0 = (function (){
var statearr_12817 = [null,null,null,null,null,null,null,null,null];
(statearr_12817[(0)] = cljs$core$async$state_machine__12028__auto__);

(statearr_12817[(1)] = (1));

return statearr_12817;
});
var cljs$core$async$state_machine__12028__auto____1 = (function (state_12796){
while(true){
var ret_value__12029__auto__ = (function (){try{while(true){
var result__12030__auto__ = switch__12027__auto__.call(null,state_12796);
if(cljs.core.keyword_identical_QMARK_.call(null,result__12030__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12030__auto__;
}
break;
}
}catch (e12818){if((e12818 instanceof Object)){
var ex__12031__auto__ = e12818;
var statearr_12819_12840 = state_12796;
(statearr_12819_12840[(5)] = ex__12031__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12796);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12818;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__12029__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12841 = state_12796;
state_12796 = G__12841;
continue;
} else {
return ret_value__12029__auto__;
}
break;
}
});
cljs$core$async$state_machine__12028__auto__ = function(state_12796){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12028__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12028__auto____1.call(this,state_12796);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12028__auto____0;
cljs$core$async$state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12028__auto____1;
return cljs$core$async$state_machine__12028__auto__;
})()
;})(switch__12027__auto__,c__12139__auto___12825,tc,fc))
})();
var state__12141__auto__ = (function (){var statearr_12820 = f__12140__auto__.call(null);
(statearr_12820[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12139__auto___12825);

return statearr_12820;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__12141__auto__);
});})(c__12139__auto___12825,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__12139__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__12139__auto__){
return (function (){
var f__12140__auto__ = (function (){var switch__12027__auto__ = ((function (c__12139__auto__){
return (function (state_12905){
var state_val_12906 = (state_12905[(1)]);
if((state_val_12906 === (7))){
var inst_12901 = (state_12905[(2)]);
var state_12905__$1 = state_12905;
var statearr_12907_12928 = state_12905__$1;
(statearr_12907_12928[(2)] = inst_12901);

(statearr_12907_12928[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12906 === (1))){
var inst_12885 = init;
var state_12905__$1 = (function (){var statearr_12908 = state_12905;
(statearr_12908[(7)] = inst_12885);

return statearr_12908;
})();
var statearr_12909_12929 = state_12905__$1;
(statearr_12909_12929[(2)] = null);

(statearr_12909_12929[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12906 === (4))){
var inst_12888 = (state_12905[(8)]);
var inst_12888__$1 = (state_12905[(2)]);
var inst_12889 = (inst_12888__$1 == null);
var state_12905__$1 = (function (){var statearr_12910 = state_12905;
(statearr_12910[(8)] = inst_12888__$1);

return statearr_12910;
})();
if(cljs.core.truth_(inst_12889)){
var statearr_12911_12930 = state_12905__$1;
(statearr_12911_12930[(1)] = (5));

} else {
var statearr_12912_12931 = state_12905__$1;
(statearr_12912_12931[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12906 === (6))){
var inst_12892 = (state_12905[(9)]);
var inst_12885 = (state_12905[(7)]);
var inst_12888 = (state_12905[(8)]);
var inst_12892__$1 = f.call(null,inst_12885,inst_12888);
var inst_12893 = cljs.core.reduced_QMARK_.call(null,inst_12892__$1);
var state_12905__$1 = (function (){var statearr_12913 = state_12905;
(statearr_12913[(9)] = inst_12892__$1);

return statearr_12913;
})();
if(inst_12893){
var statearr_12914_12932 = state_12905__$1;
(statearr_12914_12932[(1)] = (8));

} else {
var statearr_12915_12933 = state_12905__$1;
(statearr_12915_12933[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12906 === (3))){
var inst_12903 = (state_12905[(2)]);
var state_12905__$1 = state_12905;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12905__$1,inst_12903);
} else {
if((state_val_12906 === (2))){
var state_12905__$1 = state_12905;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12905__$1,(4),ch);
} else {
if((state_val_12906 === (9))){
var inst_12892 = (state_12905[(9)]);
var inst_12885 = inst_12892;
var state_12905__$1 = (function (){var statearr_12916 = state_12905;
(statearr_12916[(7)] = inst_12885);

return statearr_12916;
})();
var statearr_12917_12934 = state_12905__$1;
(statearr_12917_12934[(2)] = null);

(statearr_12917_12934[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12906 === (5))){
var inst_12885 = (state_12905[(7)]);
var state_12905__$1 = state_12905;
var statearr_12918_12935 = state_12905__$1;
(statearr_12918_12935[(2)] = inst_12885);

(statearr_12918_12935[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12906 === (10))){
var inst_12899 = (state_12905[(2)]);
var state_12905__$1 = state_12905;
var statearr_12919_12936 = state_12905__$1;
(statearr_12919_12936[(2)] = inst_12899);

(statearr_12919_12936[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12906 === (8))){
var inst_12892 = (state_12905[(9)]);
var inst_12895 = cljs.core.deref.call(null,inst_12892);
var state_12905__$1 = state_12905;
var statearr_12920_12937 = state_12905__$1;
(statearr_12920_12937[(2)] = inst_12895);

(statearr_12920_12937[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__12139__auto__))
;
return ((function (switch__12027__auto__,c__12139__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__12028__auto__ = null;
var cljs$core$async$reduce_$_state_machine__12028__auto____0 = (function (){
var statearr_12924 = [null,null,null,null,null,null,null,null,null,null];
(statearr_12924[(0)] = cljs$core$async$reduce_$_state_machine__12028__auto__);

(statearr_12924[(1)] = (1));

return statearr_12924;
});
var cljs$core$async$reduce_$_state_machine__12028__auto____1 = (function (state_12905){
while(true){
var ret_value__12029__auto__ = (function (){try{while(true){
var result__12030__auto__ = switch__12027__auto__.call(null,state_12905);
if(cljs.core.keyword_identical_QMARK_.call(null,result__12030__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12030__auto__;
}
break;
}
}catch (e12925){if((e12925 instanceof Object)){
var ex__12031__auto__ = e12925;
var statearr_12926_12938 = state_12905;
(statearr_12926_12938[(5)] = ex__12031__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12905);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12925;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__12029__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12939 = state_12905;
state_12905 = G__12939;
continue;
} else {
return ret_value__12029__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__12028__auto__ = function(state_12905){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__12028__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__12028__auto____1.call(this,state_12905);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__12028__auto____0;
cljs$core$async$reduce_$_state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__12028__auto____1;
return cljs$core$async$reduce_$_state_machine__12028__auto__;
})()
;})(switch__12027__auto__,c__12139__auto__))
})();
var state__12141__auto__ = (function (){var statearr_12927 = f__12140__auto__.call(null);
(statearr_12927[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12139__auto__);

return statearr_12927;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__12141__auto__);
});})(c__12139__auto__))
);

return c__12139__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = xform.call(null,f);
var c__12139__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__12139__auto__,f__$1){
return (function (){
var f__12140__auto__ = (function (){var switch__12027__auto__ = ((function (c__12139__auto__,f__$1){
return (function (state_12959){
var state_val_12960 = (state_12959[(1)]);
if((state_val_12960 === (1))){
var inst_12954 = cljs.core.async.reduce.call(null,f__$1,init,ch);
var state_12959__$1 = state_12959;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12959__$1,(2),inst_12954);
} else {
if((state_val_12960 === (2))){
var inst_12956 = (state_12959[(2)]);
var inst_12957 = f__$1.call(null,inst_12956);
var state_12959__$1 = state_12959;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12959__$1,inst_12957);
} else {
return null;
}
}
});})(c__12139__auto__,f__$1))
;
return ((function (switch__12027__auto__,c__12139__auto__,f__$1){
return (function() {
var cljs$core$async$transduce_$_state_machine__12028__auto__ = null;
var cljs$core$async$transduce_$_state_machine__12028__auto____0 = (function (){
var statearr_12964 = [null,null,null,null,null,null,null];
(statearr_12964[(0)] = cljs$core$async$transduce_$_state_machine__12028__auto__);

(statearr_12964[(1)] = (1));

return statearr_12964;
});
var cljs$core$async$transduce_$_state_machine__12028__auto____1 = (function (state_12959){
while(true){
var ret_value__12029__auto__ = (function (){try{while(true){
var result__12030__auto__ = switch__12027__auto__.call(null,state_12959);
if(cljs.core.keyword_identical_QMARK_.call(null,result__12030__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12030__auto__;
}
break;
}
}catch (e12965){if((e12965 instanceof Object)){
var ex__12031__auto__ = e12965;
var statearr_12966_12968 = state_12959;
(statearr_12966_12968[(5)] = ex__12031__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12959);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12965;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__12029__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12969 = state_12959;
state_12959 = G__12969;
continue;
} else {
return ret_value__12029__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__12028__auto__ = function(state_12959){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__12028__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__12028__auto____1.call(this,state_12959);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__12028__auto____0;
cljs$core$async$transduce_$_state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__12028__auto____1;
return cljs$core$async$transduce_$_state_machine__12028__auto__;
})()
;})(switch__12027__auto__,c__12139__auto__,f__$1))
})();
var state__12141__auto__ = (function (){var statearr_12967 = f__12140__auto__.call(null);
(statearr_12967[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12139__auto__);

return statearr_12967;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__12141__auto__);
});})(c__12139__auto__,f__$1))
);

return c__12139__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args12970 = [];
var len__7484__auto___13022 = arguments.length;
var i__7485__auto___13023 = (0);
while(true){
if((i__7485__auto___13023 < len__7484__auto___13022)){
args12970.push((arguments[i__7485__auto___13023]));

var G__13024 = (i__7485__auto___13023 + (1));
i__7485__auto___13023 = G__13024;
continue;
} else {
}
break;
}

var G__12972 = args12970.length;
switch (G__12972) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12970.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__12139__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__12139__auto__){
return (function (){
var f__12140__auto__ = (function (){var switch__12027__auto__ = ((function (c__12139__auto__){
return (function (state_12997){
var state_val_12998 = (state_12997[(1)]);
if((state_val_12998 === (7))){
var inst_12979 = (state_12997[(2)]);
var state_12997__$1 = state_12997;
var statearr_12999_13026 = state_12997__$1;
(statearr_12999_13026[(2)] = inst_12979);

(statearr_12999_13026[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12998 === (1))){
var inst_12973 = cljs.core.seq.call(null,coll);
var inst_12974 = inst_12973;
var state_12997__$1 = (function (){var statearr_13000 = state_12997;
(statearr_13000[(7)] = inst_12974);

return statearr_13000;
})();
var statearr_13001_13027 = state_12997__$1;
(statearr_13001_13027[(2)] = null);

(statearr_13001_13027[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12998 === (4))){
var inst_12974 = (state_12997[(7)]);
var inst_12977 = cljs.core.first.call(null,inst_12974);
var state_12997__$1 = state_12997;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12997__$1,(7),ch,inst_12977);
} else {
if((state_val_12998 === (13))){
var inst_12991 = (state_12997[(2)]);
var state_12997__$1 = state_12997;
var statearr_13002_13028 = state_12997__$1;
(statearr_13002_13028[(2)] = inst_12991);

(statearr_13002_13028[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12998 === (6))){
var inst_12982 = (state_12997[(2)]);
var state_12997__$1 = state_12997;
if(cljs.core.truth_(inst_12982)){
var statearr_13003_13029 = state_12997__$1;
(statearr_13003_13029[(1)] = (8));

} else {
var statearr_13004_13030 = state_12997__$1;
(statearr_13004_13030[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12998 === (3))){
var inst_12995 = (state_12997[(2)]);
var state_12997__$1 = state_12997;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12997__$1,inst_12995);
} else {
if((state_val_12998 === (12))){
var state_12997__$1 = state_12997;
var statearr_13005_13031 = state_12997__$1;
(statearr_13005_13031[(2)] = null);

(statearr_13005_13031[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12998 === (2))){
var inst_12974 = (state_12997[(7)]);
var state_12997__$1 = state_12997;
if(cljs.core.truth_(inst_12974)){
var statearr_13006_13032 = state_12997__$1;
(statearr_13006_13032[(1)] = (4));

} else {
var statearr_13007_13033 = state_12997__$1;
(statearr_13007_13033[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12998 === (11))){
var inst_12988 = cljs.core.async.close_BANG_.call(null,ch);
var state_12997__$1 = state_12997;
var statearr_13008_13034 = state_12997__$1;
(statearr_13008_13034[(2)] = inst_12988);

(statearr_13008_13034[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12998 === (9))){
var state_12997__$1 = state_12997;
if(cljs.core.truth_(close_QMARK_)){
var statearr_13009_13035 = state_12997__$1;
(statearr_13009_13035[(1)] = (11));

} else {
var statearr_13010_13036 = state_12997__$1;
(statearr_13010_13036[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12998 === (5))){
var inst_12974 = (state_12997[(7)]);
var state_12997__$1 = state_12997;
var statearr_13011_13037 = state_12997__$1;
(statearr_13011_13037[(2)] = inst_12974);

(statearr_13011_13037[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12998 === (10))){
var inst_12993 = (state_12997[(2)]);
var state_12997__$1 = state_12997;
var statearr_13012_13038 = state_12997__$1;
(statearr_13012_13038[(2)] = inst_12993);

(statearr_13012_13038[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12998 === (8))){
var inst_12974 = (state_12997[(7)]);
var inst_12984 = cljs.core.next.call(null,inst_12974);
var inst_12974__$1 = inst_12984;
var state_12997__$1 = (function (){var statearr_13013 = state_12997;
(statearr_13013[(7)] = inst_12974__$1);

return statearr_13013;
})();
var statearr_13014_13039 = state_12997__$1;
(statearr_13014_13039[(2)] = null);

(statearr_13014_13039[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12139__auto__))
;
return ((function (switch__12027__auto__,c__12139__auto__){
return (function() {
var cljs$core$async$state_machine__12028__auto__ = null;
var cljs$core$async$state_machine__12028__auto____0 = (function (){
var statearr_13018 = [null,null,null,null,null,null,null,null];
(statearr_13018[(0)] = cljs$core$async$state_machine__12028__auto__);

(statearr_13018[(1)] = (1));

return statearr_13018;
});
var cljs$core$async$state_machine__12028__auto____1 = (function (state_12997){
while(true){
var ret_value__12029__auto__ = (function (){try{while(true){
var result__12030__auto__ = switch__12027__auto__.call(null,state_12997);
if(cljs.core.keyword_identical_QMARK_.call(null,result__12030__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12030__auto__;
}
break;
}
}catch (e13019){if((e13019 instanceof Object)){
var ex__12031__auto__ = e13019;
var statearr_13020_13040 = state_12997;
(statearr_13020_13040[(5)] = ex__12031__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12997);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13019;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__12029__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13041 = state_12997;
state_12997 = G__13041;
continue;
} else {
return ret_value__12029__auto__;
}
break;
}
});
cljs$core$async$state_machine__12028__auto__ = function(state_12997){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12028__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12028__auto____1.call(this,state_12997);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12028__auto____0;
cljs$core$async$state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12028__auto____1;
return cljs$core$async$state_machine__12028__auto__;
})()
;})(switch__12027__auto__,c__12139__auto__))
})();
var state__12141__auto__ = (function (){var statearr_13021 = f__12140__auto__.call(null);
(statearr_13021[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12139__auto__);

return statearr_13021;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__12141__auto__);
});})(c__12139__auto__))
);

return c__12139__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__7072__auto__ = (((_ == null))?null:_);
var m__7073__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return m__7073__auto__.call(null,_);
} else {
var m__7073__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return m__7073__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__7072__auto__ = (((m == null))?null:m);
var m__7073__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return m__7073__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__7073__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return m__7073__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__7072__auto__ = (((m == null))?null:m);
var m__7073__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return m__7073__auto__.call(null,m,ch);
} else {
var m__7073__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return m__7073__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__7072__auto__ = (((m == null))?null:m);
var m__7073__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return m__7073__auto__.call(null,m);
} else {
var m__7073__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return m__7073__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async13267 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async13267 = (function (mult,ch,cs,meta13268){
this.mult = mult;
this.ch = ch;
this.cs = cs;
this.meta13268 = meta13268;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async13267.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_13269,meta13268__$1){
var self__ = this;
var _13269__$1 = this;
return (new cljs.core.async.t_cljs$core$async13267(self__.mult,self__.ch,self__.cs,meta13268__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async13267.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_13269){
var self__ = this;
var _13269__$1 = this;
return self__.meta13268;
});})(cs))
;

cljs.core.async.t_cljs$core$async13267.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async13267.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async13267.prototype.cljs$core$async$Mult$ = true;

cljs.core.async.t_cljs$core$async13267.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async13267.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async13267.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async13267.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"mult","mult",-1187640995,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mult(iple) of the supplied channel. Channels\n  containing copies of the channel can be created with 'tap', and\n  detached with 'untap'.\n\n  Each item is distributed to all taps in parallel and synchronously,\n  i.e. each tap must accept before the next item is distributed. Use\n  buffering/windowing to prevent slow taps from holding up the mult.\n\n  Items received when there are no taps get dropped.\n\n  If a tap puts to a closed channel, it will be removed from the mult."], null)),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta13268","meta13268",1925933830,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async13267.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async13267.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async13267";

cljs.core.async.t_cljs$core$async13267.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"cljs.core.async/t_cljs$core$async13267");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async13267 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async13267(mult__$1,ch__$1,cs__$1,meta13268){
return (new cljs.core.async.t_cljs$core$async13267(mult__$1,ch__$1,cs__$1,meta13268));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async13267(cljs$core$async$mult,ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__12139__auto___13492 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__12139__auto___13492,cs,m,dchan,dctr,done){
return (function (){
var f__12140__auto__ = (function (){var switch__12027__auto__ = ((function (c__12139__auto___13492,cs,m,dchan,dctr,done){
return (function (state_13404){
var state_val_13405 = (state_13404[(1)]);
if((state_val_13405 === (7))){
var inst_13400 = (state_13404[(2)]);
var state_13404__$1 = state_13404;
var statearr_13406_13493 = state_13404__$1;
(statearr_13406_13493[(2)] = inst_13400);

(statearr_13406_13493[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13405 === (20))){
var inst_13303 = (state_13404[(7)]);
var inst_13315 = cljs.core.first.call(null,inst_13303);
var inst_13316 = cljs.core.nth.call(null,inst_13315,(0),null);
var inst_13317 = cljs.core.nth.call(null,inst_13315,(1),null);
var state_13404__$1 = (function (){var statearr_13407 = state_13404;
(statearr_13407[(8)] = inst_13316);

return statearr_13407;
})();
if(cljs.core.truth_(inst_13317)){
var statearr_13408_13494 = state_13404__$1;
(statearr_13408_13494[(1)] = (22));

} else {
var statearr_13409_13495 = state_13404__$1;
(statearr_13409_13495[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13405 === (27))){
var inst_13345 = (state_13404[(9)]);
var inst_13352 = (state_13404[(10)]);
var inst_13272 = (state_13404[(11)]);
var inst_13347 = (state_13404[(12)]);
var inst_13352__$1 = cljs.core._nth.call(null,inst_13345,inst_13347);
var inst_13353 = cljs.core.async.put_BANG_.call(null,inst_13352__$1,inst_13272,done);
var state_13404__$1 = (function (){var statearr_13410 = state_13404;
(statearr_13410[(10)] = inst_13352__$1);

return statearr_13410;
})();
if(cljs.core.truth_(inst_13353)){
var statearr_13411_13496 = state_13404__$1;
(statearr_13411_13496[(1)] = (30));

} else {
var statearr_13412_13497 = state_13404__$1;
(statearr_13412_13497[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13405 === (1))){
var state_13404__$1 = state_13404;
var statearr_13413_13498 = state_13404__$1;
(statearr_13413_13498[(2)] = null);

(statearr_13413_13498[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13405 === (24))){
var inst_13303 = (state_13404[(7)]);
var inst_13322 = (state_13404[(2)]);
var inst_13323 = cljs.core.next.call(null,inst_13303);
var inst_13281 = inst_13323;
var inst_13282 = null;
var inst_13283 = (0);
var inst_13284 = (0);
var state_13404__$1 = (function (){var statearr_13414 = state_13404;
(statearr_13414[(13)] = inst_13282);

(statearr_13414[(14)] = inst_13281);

(statearr_13414[(15)] = inst_13284);

(statearr_13414[(16)] = inst_13283);

(statearr_13414[(17)] = inst_13322);

return statearr_13414;
})();
var statearr_13415_13499 = state_13404__$1;
(statearr_13415_13499[(2)] = null);

(statearr_13415_13499[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13405 === (39))){
var state_13404__$1 = state_13404;
var statearr_13419_13500 = state_13404__$1;
(statearr_13419_13500[(2)] = null);

(statearr_13419_13500[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13405 === (4))){
var inst_13272 = (state_13404[(11)]);
var inst_13272__$1 = (state_13404[(2)]);
var inst_13273 = (inst_13272__$1 == null);
var state_13404__$1 = (function (){var statearr_13420 = state_13404;
(statearr_13420[(11)] = inst_13272__$1);

return statearr_13420;
})();
if(cljs.core.truth_(inst_13273)){
var statearr_13421_13501 = state_13404__$1;
(statearr_13421_13501[(1)] = (5));

} else {
var statearr_13422_13502 = state_13404__$1;
(statearr_13422_13502[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13405 === (15))){
var inst_13282 = (state_13404[(13)]);
var inst_13281 = (state_13404[(14)]);
var inst_13284 = (state_13404[(15)]);
var inst_13283 = (state_13404[(16)]);
var inst_13299 = (state_13404[(2)]);
var inst_13300 = (inst_13284 + (1));
var tmp13416 = inst_13282;
var tmp13417 = inst_13281;
var tmp13418 = inst_13283;
var inst_13281__$1 = tmp13417;
var inst_13282__$1 = tmp13416;
var inst_13283__$1 = tmp13418;
var inst_13284__$1 = inst_13300;
var state_13404__$1 = (function (){var statearr_13423 = state_13404;
(statearr_13423[(13)] = inst_13282__$1);

(statearr_13423[(14)] = inst_13281__$1);

(statearr_13423[(15)] = inst_13284__$1);

(statearr_13423[(16)] = inst_13283__$1);

(statearr_13423[(18)] = inst_13299);

return statearr_13423;
})();
var statearr_13424_13503 = state_13404__$1;
(statearr_13424_13503[(2)] = null);

(statearr_13424_13503[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13405 === (21))){
var inst_13326 = (state_13404[(2)]);
var state_13404__$1 = state_13404;
var statearr_13428_13504 = state_13404__$1;
(statearr_13428_13504[(2)] = inst_13326);

(statearr_13428_13504[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13405 === (31))){
var inst_13352 = (state_13404[(10)]);
var inst_13356 = done.call(null,null);
var inst_13357 = cljs.core.async.untap_STAR_.call(null,m,inst_13352);
var state_13404__$1 = (function (){var statearr_13429 = state_13404;
(statearr_13429[(19)] = inst_13356);

return statearr_13429;
})();
var statearr_13430_13505 = state_13404__$1;
(statearr_13430_13505[(2)] = inst_13357);

(statearr_13430_13505[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13405 === (32))){
var inst_13344 = (state_13404[(20)]);
var inst_13346 = (state_13404[(21)]);
var inst_13345 = (state_13404[(9)]);
var inst_13347 = (state_13404[(12)]);
var inst_13359 = (state_13404[(2)]);
var inst_13360 = (inst_13347 + (1));
var tmp13425 = inst_13344;
var tmp13426 = inst_13346;
var tmp13427 = inst_13345;
var inst_13344__$1 = tmp13425;
var inst_13345__$1 = tmp13427;
var inst_13346__$1 = tmp13426;
var inst_13347__$1 = inst_13360;
var state_13404__$1 = (function (){var statearr_13431 = state_13404;
(statearr_13431[(20)] = inst_13344__$1);

(statearr_13431[(22)] = inst_13359);

(statearr_13431[(21)] = inst_13346__$1);

(statearr_13431[(9)] = inst_13345__$1);

(statearr_13431[(12)] = inst_13347__$1);

return statearr_13431;
})();
var statearr_13432_13506 = state_13404__$1;
(statearr_13432_13506[(2)] = null);

(statearr_13432_13506[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13405 === (40))){
var inst_13372 = (state_13404[(23)]);
var inst_13376 = done.call(null,null);
var inst_13377 = cljs.core.async.untap_STAR_.call(null,m,inst_13372);
var state_13404__$1 = (function (){var statearr_13433 = state_13404;
(statearr_13433[(24)] = inst_13376);

return statearr_13433;
})();
var statearr_13434_13507 = state_13404__$1;
(statearr_13434_13507[(2)] = inst_13377);

(statearr_13434_13507[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13405 === (33))){
var inst_13363 = (state_13404[(25)]);
var inst_13365 = cljs.core.chunked_seq_QMARK_.call(null,inst_13363);
var state_13404__$1 = state_13404;
if(inst_13365){
var statearr_13435_13508 = state_13404__$1;
(statearr_13435_13508[(1)] = (36));

} else {
var statearr_13436_13509 = state_13404__$1;
(statearr_13436_13509[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13405 === (13))){
var inst_13293 = (state_13404[(26)]);
var inst_13296 = cljs.core.async.close_BANG_.call(null,inst_13293);
var state_13404__$1 = state_13404;
var statearr_13437_13510 = state_13404__$1;
(statearr_13437_13510[(2)] = inst_13296);

(statearr_13437_13510[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13405 === (22))){
var inst_13316 = (state_13404[(8)]);
var inst_13319 = cljs.core.async.close_BANG_.call(null,inst_13316);
var state_13404__$1 = state_13404;
var statearr_13438_13511 = state_13404__$1;
(statearr_13438_13511[(2)] = inst_13319);

(statearr_13438_13511[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13405 === (36))){
var inst_13363 = (state_13404[(25)]);
var inst_13367 = cljs.core.chunk_first.call(null,inst_13363);
var inst_13368 = cljs.core.chunk_rest.call(null,inst_13363);
var inst_13369 = cljs.core.count.call(null,inst_13367);
var inst_13344 = inst_13368;
var inst_13345 = inst_13367;
var inst_13346 = inst_13369;
var inst_13347 = (0);
var state_13404__$1 = (function (){var statearr_13439 = state_13404;
(statearr_13439[(20)] = inst_13344);

(statearr_13439[(21)] = inst_13346);

(statearr_13439[(9)] = inst_13345);

(statearr_13439[(12)] = inst_13347);

return statearr_13439;
})();
var statearr_13440_13512 = state_13404__$1;
(statearr_13440_13512[(2)] = null);

(statearr_13440_13512[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13405 === (41))){
var inst_13363 = (state_13404[(25)]);
var inst_13379 = (state_13404[(2)]);
var inst_13380 = cljs.core.next.call(null,inst_13363);
var inst_13344 = inst_13380;
var inst_13345 = null;
var inst_13346 = (0);
var inst_13347 = (0);
var state_13404__$1 = (function (){var statearr_13441 = state_13404;
(statearr_13441[(27)] = inst_13379);

(statearr_13441[(20)] = inst_13344);

(statearr_13441[(21)] = inst_13346);

(statearr_13441[(9)] = inst_13345);

(statearr_13441[(12)] = inst_13347);

return statearr_13441;
})();
var statearr_13442_13513 = state_13404__$1;
(statearr_13442_13513[(2)] = null);

(statearr_13442_13513[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13405 === (43))){
var state_13404__$1 = state_13404;
var statearr_13443_13514 = state_13404__$1;
(statearr_13443_13514[(2)] = null);

(statearr_13443_13514[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13405 === (29))){
var inst_13388 = (state_13404[(2)]);
var state_13404__$1 = state_13404;
var statearr_13444_13515 = state_13404__$1;
(statearr_13444_13515[(2)] = inst_13388);

(statearr_13444_13515[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13405 === (44))){
var inst_13397 = (state_13404[(2)]);
var state_13404__$1 = (function (){var statearr_13445 = state_13404;
(statearr_13445[(28)] = inst_13397);

return statearr_13445;
})();
var statearr_13446_13516 = state_13404__$1;
(statearr_13446_13516[(2)] = null);

(statearr_13446_13516[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13405 === (6))){
var inst_13336 = (state_13404[(29)]);
var inst_13335 = cljs.core.deref.call(null,cs);
var inst_13336__$1 = cljs.core.keys.call(null,inst_13335);
var inst_13337 = cljs.core.count.call(null,inst_13336__$1);
var inst_13338 = cljs.core.reset_BANG_.call(null,dctr,inst_13337);
var inst_13343 = cljs.core.seq.call(null,inst_13336__$1);
var inst_13344 = inst_13343;
var inst_13345 = null;
var inst_13346 = (0);
var inst_13347 = (0);
var state_13404__$1 = (function (){var statearr_13447 = state_13404;
(statearr_13447[(30)] = inst_13338);

(statearr_13447[(20)] = inst_13344);

(statearr_13447[(21)] = inst_13346);

(statearr_13447[(29)] = inst_13336__$1);

(statearr_13447[(9)] = inst_13345);

(statearr_13447[(12)] = inst_13347);

return statearr_13447;
})();
var statearr_13448_13517 = state_13404__$1;
(statearr_13448_13517[(2)] = null);

(statearr_13448_13517[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13405 === (28))){
var inst_13344 = (state_13404[(20)]);
var inst_13363 = (state_13404[(25)]);
var inst_13363__$1 = cljs.core.seq.call(null,inst_13344);
var state_13404__$1 = (function (){var statearr_13449 = state_13404;
(statearr_13449[(25)] = inst_13363__$1);

return statearr_13449;
})();
if(inst_13363__$1){
var statearr_13450_13518 = state_13404__$1;
(statearr_13450_13518[(1)] = (33));

} else {
var statearr_13451_13519 = state_13404__$1;
(statearr_13451_13519[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13405 === (25))){
var inst_13346 = (state_13404[(21)]);
var inst_13347 = (state_13404[(12)]);
var inst_13349 = (inst_13347 < inst_13346);
var inst_13350 = inst_13349;
var state_13404__$1 = state_13404;
if(cljs.core.truth_(inst_13350)){
var statearr_13452_13520 = state_13404__$1;
(statearr_13452_13520[(1)] = (27));

} else {
var statearr_13453_13521 = state_13404__$1;
(statearr_13453_13521[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13405 === (34))){
var state_13404__$1 = state_13404;
var statearr_13454_13522 = state_13404__$1;
(statearr_13454_13522[(2)] = null);

(statearr_13454_13522[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13405 === (17))){
var state_13404__$1 = state_13404;
var statearr_13455_13523 = state_13404__$1;
(statearr_13455_13523[(2)] = null);

(statearr_13455_13523[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13405 === (3))){
var inst_13402 = (state_13404[(2)]);
var state_13404__$1 = state_13404;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13404__$1,inst_13402);
} else {
if((state_val_13405 === (12))){
var inst_13331 = (state_13404[(2)]);
var state_13404__$1 = state_13404;
var statearr_13456_13524 = state_13404__$1;
(statearr_13456_13524[(2)] = inst_13331);

(statearr_13456_13524[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13405 === (2))){
var state_13404__$1 = state_13404;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13404__$1,(4),ch);
} else {
if((state_val_13405 === (23))){
var state_13404__$1 = state_13404;
var statearr_13457_13525 = state_13404__$1;
(statearr_13457_13525[(2)] = null);

(statearr_13457_13525[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13405 === (35))){
var inst_13386 = (state_13404[(2)]);
var state_13404__$1 = state_13404;
var statearr_13458_13526 = state_13404__$1;
(statearr_13458_13526[(2)] = inst_13386);

(statearr_13458_13526[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13405 === (19))){
var inst_13303 = (state_13404[(7)]);
var inst_13307 = cljs.core.chunk_first.call(null,inst_13303);
var inst_13308 = cljs.core.chunk_rest.call(null,inst_13303);
var inst_13309 = cljs.core.count.call(null,inst_13307);
var inst_13281 = inst_13308;
var inst_13282 = inst_13307;
var inst_13283 = inst_13309;
var inst_13284 = (0);
var state_13404__$1 = (function (){var statearr_13459 = state_13404;
(statearr_13459[(13)] = inst_13282);

(statearr_13459[(14)] = inst_13281);

(statearr_13459[(15)] = inst_13284);

(statearr_13459[(16)] = inst_13283);

return statearr_13459;
})();
var statearr_13460_13527 = state_13404__$1;
(statearr_13460_13527[(2)] = null);

(statearr_13460_13527[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13405 === (11))){
var inst_13281 = (state_13404[(14)]);
var inst_13303 = (state_13404[(7)]);
var inst_13303__$1 = cljs.core.seq.call(null,inst_13281);
var state_13404__$1 = (function (){var statearr_13461 = state_13404;
(statearr_13461[(7)] = inst_13303__$1);

return statearr_13461;
})();
if(inst_13303__$1){
var statearr_13462_13528 = state_13404__$1;
(statearr_13462_13528[(1)] = (16));

} else {
var statearr_13463_13529 = state_13404__$1;
(statearr_13463_13529[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13405 === (9))){
var inst_13333 = (state_13404[(2)]);
var state_13404__$1 = state_13404;
var statearr_13464_13530 = state_13404__$1;
(statearr_13464_13530[(2)] = inst_13333);

(statearr_13464_13530[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13405 === (5))){
var inst_13279 = cljs.core.deref.call(null,cs);
var inst_13280 = cljs.core.seq.call(null,inst_13279);
var inst_13281 = inst_13280;
var inst_13282 = null;
var inst_13283 = (0);
var inst_13284 = (0);
var state_13404__$1 = (function (){var statearr_13465 = state_13404;
(statearr_13465[(13)] = inst_13282);

(statearr_13465[(14)] = inst_13281);

(statearr_13465[(15)] = inst_13284);

(statearr_13465[(16)] = inst_13283);

return statearr_13465;
})();
var statearr_13466_13531 = state_13404__$1;
(statearr_13466_13531[(2)] = null);

(statearr_13466_13531[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13405 === (14))){
var state_13404__$1 = state_13404;
var statearr_13467_13532 = state_13404__$1;
(statearr_13467_13532[(2)] = null);

(statearr_13467_13532[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13405 === (45))){
var inst_13394 = (state_13404[(2)]);
var state_13404__$1 = state_13404;
var statearr_13468_13533 = state_13404__$1;
(statearr_13468_13533[(2)] = inst_13394);

(statearr_13468_13533[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13405 === (26))){
var inst_13336 = (state_13404[(29)]);
var inst_13390 = (state_13404[(2)]);
var inst_13391 = cljs.core.seq.call(null,inst_13336);
var state_13404__$1 = (function (){var statearr_13469 = state_13404;
(statearr_13469[(31)] = inst_13390);

return statearr_13469;
})();
if(inst_13391){
var statearr_13470_13534 = state_13404__$1;
(statearr_13470_13534[(1)] = (42));

} else {
var statearr_13471_13535 = state_13404__$1;
(statearr_13471_13535[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13405 === (16))){
var inst_13303 = (state_13404[(7)]);
var inst_13305 = cljs.core.chunked_seq_QMARK_.call(null,inst_13303);
var state_13404__$1 = state_13404;
if(inst_13305){
var statearr_13472_13536 = state_13404__$1;
(statearr_13472_13536[(1)] = (19));

} else {
var statearr_13473_13537 = state_13404__$1;
(statearr_13473_13537[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13405 === (38))){
var inst_13383 = (state_13404[(2)]);
var state_13404__$1 = state_13404;
var statearr_13474_13538 = state_13404__$1;
(statearr_13474_13538[(2)] = inst_13383);

(statearr_13474_13538[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13405 === (30))){
var state_13404__$1 = state_13404;
var statearr_13475_13539 = state_13404__$1;
(statearr_13475_13539[(2)] = null);

(statearr_13475_13539[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13405 === (10))){
var inst_13282 = (state_13404[(13)]);
var inst_13284 = (state_13404[(15)]);
var inst_13292 = cljs.core._nth.call(null,inst_13282,inst_13284);
var inst_13293 = cljs.core.nth.call(null,inst_13292,(0),null);
var inst_13294 = cljs.core.nth.call(null,inst_13292,(1),null);
var state_13404__$1 = (function (){var statearr_13476 = state_13404;
(statearr_13476[(26)] = inst_13293);

return statearr_13476;
})();
if(cljs.core.truth_(inst_13294)){
var statearr_13477_13540 = state_13404__$1;
(statearr_13477_13540[(1)] = (13));

} else {
var statearr_13478_13541 = state_13404__$1;
(statearr_13478_13541[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13405 === (18))){
var inst_13329 = (state_13404[(2)]);
var state_13404__$1 = state_13404;
var statearr_13479_13542 = state_13404__$1;
(statearr_13479_13542[(2)] = inst_13329);

(statearr_13479_13542[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13405 === (42))){
var state_13404__$1 = state_13404;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13404__$1,(45),dchan);
} else {
if((state_val_13405 === (37))){
var inst_13363 = (state_13404[(25)]);
var inst_13272 = (state_13404[(11)]);
var inst_13372 = (state_13404[(23)]);
var inst_13372__$1 = cljs.core.first.call(null,inst_13363);
var inst_13373 = cljs.core.async.put_BANG_.call(null,inst_13372__$1,inst_13272,done);
var state_13404__$1 = (function (){var statearr_13480 = state_13404;
(statearr_13480[(23)] = inst_13372__$1);

return statearr_13480;
})();
if(cljs.core.truth_(inst_13373)){
var statearr_13481_13543 = state_13404__$1;
(statearr_13481_13543[(1)] = (39));

} else {
var statearr_13482_13544 = state_13404__$1;
(statearr_13482_13544[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13405 === (8))){
var inst_13284 = (state_13404[(15)]);
var inst_13283 = (state_13404[(16)]);
var inst_13286 = (inst_13284 < inst_13283);
var inst_13287 = inst_13286;
var state_13404__$1 = state_13404;
if(cljs.core.truth_(inst_13287)){
var statearr_13483_13545 = state_13404__$1;
(statearr_13483_13545[(1)] = (10));

} else {
var statearr_13484_13546 = state_13404__$1;
(statearr_13484_13546[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12139__auto___13492,cs,m,dchan,dctr,done))
;
return ((function (switch__12027__auto__,c__12139__auto___13492,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__12028__auto__ = null;
var cljs$core$async$mult_$_state_machine__12028__auto____0 = (function (){
var statearr_13488 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_13488[(0)] = cljs$core$async$mult_$_state_machine__12028__auto__);

(statearr_13488[(1)] = (1));

return statearr_13488;
});
var cljs$core$async$mult_$_state_machine__12028__auto____1 = (function (state_13404){
while(true){
var ret_value__12029__auto__ = (function (){try{while(true){
var result__12030__auto__ = switch__12027__auto__.call(null,state_13404);
if(cljs.core.keyword_identical_QMARK_.call(null,result__12030__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12030__auto__;
}
break;
}
}catch (e13489){if((e13489 instanceof Object)){
var ex__12031__auto__ = e13489;
var statearr_13490_13547 = state_13404;
(statearr_13490_13547[(5)] = ex__12031__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13404);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13489;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__12029__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13548 = state_13404;
state_13404 = G__13548;
continue;
} else {
return ret_value__12029__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__12028__auto__ = function(state_13404){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__12028__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__12028__auto____1.call(this,state_13404);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__12028__auto____0;
cljs$core$async$mult_$_state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__12028__auto____1;
return cljs$core$async$mult_$_state_machine__12028__auto__;
})()
;})(switch__12027__auto__,c__12139__auto___13492,cs,m,dchan,dctr,done))
})();
var state__12141__auto__ = (function (){var statearr_13491 = f__12140__auto__.call(null);
(statearr_13491[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12139__auto___13492);

return statearr_13491;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__12141__auto__);
});})(c__12139__auto___13492,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args13549 = [];
var len__7484__auto___13552 = arguments.length;
var i__7485__auto___13553 = (0);
while(true){
if((i__7485__auto___13553 < len__7484__auto___13552)){
args13549.push((arguments[i__7485__auto___13553]));

var G__13554 = (i__7485__auto___13553 + (1));
i__7485__auto___13553 = G__13554;
continue;
} else {
}
break;
}

var G__13551 = args13549.length;
switch (G__13551) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13549.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__7072__auto__ = (((m == null))?null:m);
var m__7073__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return m__7073__auto__.call(null,m,ch);
} else {
var m__7073__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return m__7073__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__7072__auto__ = (((m == null))?null:m);
var m__7073__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return m__7073__auto__.call(null,m,ch);
} else {
var m__7073__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return m__7073__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__7072__auto__ = (((m == null))?null:m);
var m__7073__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return m__7073__auto__.call(null,m);
} else {
var m__7073__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return m__7073__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__7072__auto__ = (((m == null))?null:m);
var m__7073__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return m__7073__auto__.call(null,m,state_map);
} else {
var m__7073__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return m__7073__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__7072__auto__ = (((m == null))?null:m);
var m__7073__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return m__7073__auto__.call(null,m,mode);
} else {
var m__7073__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return m__7073__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__7491__auto__ = [];
var len__7484__auto___13566 = arguments.length;
var i__7485__auto___13567 = (0);
while(true){
if((i__7485__auto___13567 < len__7484__auto___13566)){
args__7491__auto__.push((arguments[i__7485__auto___13567]));

var G__13568 = (i__7485__auto___13567 + (1));
i__7485__auto___13567 = G__13568;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((3) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7492__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__13560){
var map__13561 = p__13560;
var map__13561__$1 = ((((!((map__13561 == null)))?((((map__13561.cljs$lang$protocol_mask$partition0$ & (64))) || (map__13561.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__13561):map__13561);
var opts = map__13561__$1;
var statearr_13563_13569 = state;
(statearr_13563_13569[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__4657__auto__ = cljs.core.async.do_alts.call(null,((function (map__13561,map__13561__$1,opts){
return (function (val){
var statearr_13564_13570 = state;
(statearr_13564_13570[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__13561,map__13561__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4657__auto__)){
var cb = temp__4657__auto__;
var statearr_13565_13571 = state;
(statearr_13565_13571[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq13556){
var G__13557 = cljs.core.first.call(null,seq13556);
var seq13556__$1 = cljs.core.next.call(null,seq13556);
var G__13558 = cljs.core.first.call(null,seq13556__$1);
var seq13556__$2 = cljs.core.next.call(null,seq13556__$1);
var G__13559 = cljs.core.first.call(null,seq13556__$2);
var seq13556__$3 = cljs.core.next.call(null,seq13556__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__13557,G__13558,G__13559,seq13556__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async13737 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async13737 = (function (change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta13738){
this.change = change;
this.mix = mix;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta13738 = meta13738;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async13737.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_13739,meta13738__$1){
var self__ = this;
var _13739__$1 = this;
return (new cljs.core.async.t_cljs$core$async13737(self__.change,self__.mix,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta13738__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async13737.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_13739){
var self__ = this;
var _13739__$1 = this;
return self__.meta13738;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async13737.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async13737.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async13737.prototype.cljs$core$async$Mix$ = true;

cljs.core.async.t_cljs$core$async13737.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async13737.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async13737.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async13737.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async13737.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str("(solo-modes mode)")].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async13737.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),cljs.core.with_meta(new cljs.core.Symbol(null,"mix","mix",2121373763,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mix of one or more input channels which will\n  be put on the supplied out channel. Input sources can be added to\n  the mix with 'admix', and removed with 'unmix'. A mix supports\n  soloing, muting and pausing multiple inputs atomically using\n  'toggle', and can solo using either muting or pausing as determined\n  by 'solo-mode'.\n\n  Each channel can have zero or more boolean modes set via 'toggle':\n\n  :solo - when true, only this (ond other soloed) channel(s) will appear\n          in the mix output channel. :mute and :pause states of soloed\n          channels are ignored. If solo-mode is :mute, non-soloed\n          channels are muted, if :pause, non-soloed channels are\n          paused.\n\n  :mute - muted channels will have their contents consumed but not included in the mix\n  :pause - paused channels will not have their contents consumed (and thus also not included in the mix)\n"], null)),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta13738","meta13738",-371811357,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async13737.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async13737.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async13737";

cljs.core.async.t_cljs$core$async13737.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"cljs.core.async/t_cljs$core$async13737");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async13737 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async13737(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta13738){
return (new cljs.core.async.t_cljs$core$async13737(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta13738));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async13737(change,cljs$core$async$mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__12139__auto___13902 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__12139__auto___13902,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__12140__auto__ = (function (){var switch__12027__auto__ = ((function (c__12139__auto___13902,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_13839){
var state_val_13840 = (state_13839[(1)]);
if((state_val_13840 === (7))){
var inst_13755 = (state_13839[(2)]);
var state_13839__$1 = state_13839;
var statearr_13841_13903 = state_13839__$1;
(statearr_13841_13903[(2)] = inst_13755);

(statearr_13841_13903[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13840 === (20))){
var inst_13767 = (state_13839[(7)]);
var state_13839__$1 = state_13839;
var statearr_13842_13904 = state_13839__$1;
(statearr_13842_13904[(2)] = inst_13767);

(statearr_13842_13904[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13840 === (27))){
var state_13839__$1 = state_13839;
var statearr_13843_13905 = state_13839__$1;
(statearr_13843_13905[(2)] = null);

(statearr_13843_13905[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13840 === (1))){
var inst_13743 = (state_13839[(8)]);
var inst_13743__$1 = calc_state.call(null);
var inst_13745 = (inst_13743__$1 == null);
var inst_13746 = cljs.core.not.call(null,inst_13745);
var state_13839__$1 = (function (){var statearr_13844 = state_13839;
(statearr_13844[(8)] = inst_13743__$1);

return statearr_13844;
})();
if(inst_13746){
var statearr_13845_13906 = state_13839__$1;
(statearr_13845_13906[(1)] = (2));

} else {
var statearr_13846_13907 = state_13839__$1;
(statearr_13846_13907[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13840 === (24))){
var inst_13799 = (state_13839[(9)]);
var inst_13790 = (state_13839[(10)]);
var inst_13813 = (state_13839[(11)]);
var inst_13813__$1 = inst_13790.call(null,inst_13799);
var state_13839__$1 = (function (){var statearr_13847 = state_13839;
(statearr_13847[(11)] = inst_13813__$1);

return statearr_13847;
})();
if(cljs.core.truth_(inst_13813__$1)){
var statearr_13848_13908 = state_13839__$1;
(statearr_13848_13908[(1)] = (29));

} else {
var statearr_13849_13909 = state_13839__$1;
(statearr_13849_13909[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13840 === (4))){
var inst_13758 = (state_13839[(2)]);
var state_13839__$1 = state_13839;
if(cljs.core.truth_(inst_13758)){
var statearr_13850_13910 = state_13839__$1;
(statearr_13850_13910[(1)] = (8));

} else {
var statearr_13851_13911 = state_13839__$1;
(statearr_13851_13911[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13840 === (15))){
var inst_13784 = (state_13839[(2)]);
var state_13839__$1 = state_13839;
if(cljs.core.truth_(inst_13784)){
var statearr_13852_13912 = state_13839__$1;
(statearr_13852_13912[(1)] = (19));

} else {
var statearr_13853_13913 = state_13839__$1;
(statearr_13853_13913[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13840 === (21))){
var inst_13789 = (state_13839[(12)]);
var inst_13789__$1 = (state_13839[(2)]);
var inst_13790 = cljs.core.get.call(null,inst_13789__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_13791 = cljs.core.get.call(null,inst_13789__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_13792 = cljs.core.get.call(null,inst_13789__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_13839__$1 = (function (){var statearr_13854 = state_13839;
(statearr_13854[(12)] = inst_13789__$1);

(statearr_13854[(10)] = inst_13790);

(statearr_13854[(13)] = inst_13791);

return statearr_13854;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_13839__$1,(22),inst_13792);
} else {
if((state_val_13840 === (31))){
var inst_13821 = (state_13839[(2)]);
var state_13839__$1 = state_13839;
if(cljs.core.truth_(inst_13821)){
var statearr_13855_13914 = state_13839__$1;
(statearr_13855_13914[(1)] = (32));

} else {
var statearr_13856_13915 = state_13839__$1;
(statearr_13856_13915[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13840 === (32))){
var inst_13798 = (state_13839[(14)]);
var state_13839__$1 = state_13839;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13839__$1,(35),out,inst_13798);
} else {
if((state_val_13840 === (33))){
var inst_13789 = (state_13839[(12)]);
var inst_13767 = inst_13789;
var state_13839__$1 = (function (){var statearr_13857 = state_13839;
(statearr_13857[(7)] = inst_13767);

return statearr_13857;
})();
var statearr_13858_13916 = state_13839__$1;
(statearr_13858_13916[(2)] = null);

(statearr_13858_13916[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13840 === (13))){
var inst_13767 = (state_13839[(7)]);
var inst_13774 = inst_13767.cljs$lang$protocol_mask$partition0$;
var inst_13775 = (inst_13774 & (64));
var inst_13776 = inst_13767.cljs$core$ISeq$;
var inst_13777 = (inst_13775) || (inst_13776);
var state_13839__$1 = state_13839;
if(cljs.core.truth_(inst_13777)){
var statearr_13859_13917 = state_13839__$1;
(statearr_13859_13917[(1)] = (16));

} else {
var statearr_13860_13918 = state_13839__$1;
(statearr_13860_13918[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13840 === (22))){
var inst_13798 = (state_13839[(14)]);
var inst_13799 = (state_13839[(9)]);
var inst_13797 = (state_13839[(2)]);
var inst_13798__$1 = cljs.core.nth.call(null,inst_13797,(0),null);
var inst_13799__$1 = cljs.core.nth.call(null,inst_13797,(1),null);
var inst_13800 = (inst_13798__$1 == null);
var inst_13801 = cljs.core._EQ_.call(null,inst_13799__$1,change);
var inst_13802 = (inst_13800) || (inst_13801);
var state_13839__$1 = (function (){var statearr_13861 = state_13839;
(statearr_13861[(14)] = inst_13798__$1);

(statearr_13861[(9)] = inst_13799__$1);

return statearr_13861;
})();
if(cljs.core.truth_(inst_13802)){
var statearr_13862_13919 = state_13839__$1;
(statearr_13862_13919[(1)] = (23));

} else {
var statearr_13863_13920 = state_13839__$1;
(statearr_13863_13920[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13840 === (36))){
var inst_13789 = (state_13839[(12)]);
var inst_13767 = inst_13789;
var state_13839__$1 = (function (){var statearr_13864 = state_13839;
(statearr_13864[(7)] = inst_13767);

return statearr_13864;
})();
var statearr_13865_13921 = state_13839__$1;
(statearr_13865_13921[(2)] = null);

(statearr_13865_13921[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13840 === (29))){
var inst_13813 = (state_13839[(11)]);
var state_13839__$1 = state_13839;
var statearr_13866_13922 = state_13839__$1;
(statearr_13866_13922[(2)] = inst_13813);

(statearr_13866_13922[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13840 === (6))){
var state_13839__$1 = state_13839;
var statearr_13867_13923 = state_13839__$1;
(statearr_13867_13923[(2)] = false);

(statearr_13867_13923[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13840 === (28))){
var inst_13809 = (state_13839[(2)]);
var inst_13810 = calc_state.call(null);
var inst_13767 = inst_13810;
var state_13839__$1 = (function (){var statearr_13868 = state_13839;
(statearr_13868[(7)] = inst_13767);

(statearr_13868[(15)] = inst_13809);

return statearr_13868;
})();
var statearr_13869_13924 = state_13839__$1;
(statearr_13869_13924[(2)] = null);

(statearr_13869_13924[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13840 === (25))){
var inst_13835 = (state_13839[(2)]);
var state_13839__$1 = state_13839;
var statearr_13870_13925 = state_13839__$1;
(statearr_13870_13925[(2)] = inst_13835);

(statearr_13870_13925[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13840 === (34))){
var inst_13833 = (state_13839[(2)]);
var state_13839__$1 = state_13839;
var statearr_13871_13926 = state_13839__$1;
(statearr_13871_13926[(2)] = inst_13833);

(statearr_13871_13926[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13840 === (17))){
var state_13839__$1 = state_13839;
var statearr_13872_13927 = state_13839__$1;
(statearr_13872_13927[(2)] = false);

(statearr_13872_13927[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13840 === (3))){
var state_13839__$1 = state_13839;
var statearr_13873_13928 = state_13839__$1;
(statearr_13873_13928[(2)] = false);

(statearr_13873_13928[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13840 === (12))){
var inst_13837 = (state_13839[(2)]);
var state_13839__$1 = state_13839;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13839__$1,inst_13837);
} else {
if((state_val_13840 === (2))){
var inst_13743 = (state_13839[(8)]);
var inst_13748 = inst_13743.cljs$lang$protocol_mask$partition0$;
var inst_13749 = (inst_13748 & (64));
var inst_13750 = inst_13743.cljs$core$ISeq$;
var inst_13751 = (inst_13749) || (inst_13750);
var state_13839__$1 = state_13839;
if(cljs.core.truth_(inst_13751)){
var statearr_13874_13929 = state_13839__$1;
(statearr_13874_13929[(1)] = (5));

} else {
var statearr_13875_13930 = state_13839__$1;
(statearr_13875_13930[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13840 === (23))){
var inst_13798 = (state_13839[(14)]);
var inst_13804 = (inst_13798 == null);
var state_13839__$1 = state_13839;
if(cljs.core.truth_(inst_13804)){
var statearr_13876_13931 = state_13839__$1;
(statearr_13876_13931[(1)] = (26));

} else {
var statearr_13877_13932 = state_13839__$1;
(statearr_13877_13932[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13840 === (35))){
var inst_13824 = (state_13839[(2)]);
var state_13839__$1 = state_13839;
if(cljs.core.truth_(inst_13824)){
var statearr_13878_13933 = state_13839__$1;
(statearr_13878_13933[(1)] = (36));

} else {
var statearr_13879_13934 = state_13839__$1;
(statearr_13879_13934[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13840 === (19))){
var inst_13767 = (state_13839[(7)]);
var inst_13786 = cljs.core.apply.call(null,cljs.core.hash_map,inst_13767);
var state_13839__$1 = state_13839;
var statearr_13880_13935 = state_13839__$1;
(statearr_13880_13935[(2)] = inst_13786);

(statearr_13880_13935[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13840 === (11))){
var inst_13767 = (state_13839[(7)]);
var inst_13771 = (inst_13767 == null);
var inst_13772 = cljs.core.not.call(null,inst_13771);
var state_13839__$1 = state_13839;
if(inst_13772){
var statearr_13881_13936 = state_13839__$1;
(statearr_13881_13936[(1)] = (13));

} else {
var statearr_13882_13937 = state_13839__$1;
(statearr_13882_13937[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13840 === (9))){
var inst_13743 = (state_13839[(8)]);
var state_13839__$1 = state_13839;
var statearr_13883_13938 = state_13839__$1;
(statearr_13883_13938[(2)] = inst_13743);

(statearr_13883_13938[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13840 === (5))){
var state_13839__$1 = state_13839;
var statearr_13884_13939 = state_13839__$1;
(statearr_13884_13939[(2)] = true);

(statearr_13884_13939[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13840 === (14))){
var state_13839__$1 = state_13839;
var statearr_13885_13940 = state_13839__$1;
(statearr_13885_13940[(2)] = false);

(statearr_13885_13940[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13840 === (26))){
var inst_13799 = (state_13839[(9)]);
var inst_13806 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_13799);
var state_13839__$1 = state_13839;
var statearr_13886_13941 = state_13839__$1;
(statearr_13886_13941[(2)] = inst_13806);

(statearr_13886_13941[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13840 === (16))){
var state_13839__$1 = state_13839;
var statearr_13887_13942 = state_13839__$1;
(statearr_13887_13942[(2)] = true);

(statearr_13887_13942[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13840 === (38))){
var inst_13829 = (state_13839[(2)]);
var state_13839__$1 = state_13839;
var statearr_13888_13943 = state_13839__$1;
(statearr_13888_13943[(2)] = inst_13829);

(statearr_13888_13943[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13840 === (30))){
var inst_13799 = (state_13839[(9)]);
var inst_13790 = (state_13839[(10)]);
var inst_13791 = (state_13839[(13)]);
var inst_13816 = cljs.core.empty_QMARK_.call(null,inst_13790);
var inst_13817 = inst_13791.call(null,inst_13799);
var inst_13818 = cljs.core.not.call(null,inst_13817);
var inst_13819 = (inst_13816) && (inst_13818);
var state_13839__$1 = state_13839;
var statearr_13889_13944 = state_13839__$1;
(statearr_13889_13944[(2)] = inst_13819);

(statearr_13889_13944[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13840 === (10))){
var inst_13743 = (state_13839[(8)]);
var inst_13763 = (state_13839[(2)]);
var inst_13764 = cljs.core.get.call(null,inst_13763,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_13765 = cljs.core.get.call(null,inst_13763,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_13766 = cljs.core.get.call(null,inst_13763,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_13767 = inst_13743;
var state_13839__$1 = (function (){var statearr_13890 = state_13839;
(statearr_13890[(16)] = inst_13765);

(statearr_13890[(7)] = inst_13767);

(statearr_13890[(17)] = inst_13764);

(statearr_13890[(18)] = inst_13766);

return statearr_13890;
})();
var statearr_13891_13945 = state_13839__$1;
(statearr_13891_13945[(2)] = null);

(statearr_13891_13945[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13840 === (18))){
var inst_13781 = (state_13839[(2)]);
var state_13839__$1 = state_13839;
var statearr_13892_13946 = state_13839__$1;
(statearr_13892_13946[(2)] = inst_13781);

(statearr_13892_13946[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13840 === (37))){
var state_13839__$1 = state_13839;
var statearr_13893_13947 = state_13839__$1;
(statearr_13893_13947[(2)] = null);

(statearr_13893_13947[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13840 === (8))){
var inst_13743 = (state_13839[(8)]);
var inst_13760 = cljs.core.apply.call(null,cljs.core.hash_map,inst_13743);
var state_13839__$1 = state_13839;
var statearr_13894_13948 = state_13839__$1;
(statearr_13894_13948[(2)] = inst_13760);

(statearr_13894_13948[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12139__auto___13902,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__12027__auto__,c__12139__auto___13902,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__12028__auto__ = null;
var cljs$core$async$mix_$_state_machine__12028__auto____0 = (function (){
var statearr_13898 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_13898[(0)] = cljs$core$async$mix_$_state_machine__12028__auto__);

(statearr_13898[(1)] = (1));

return statearr_13898;
});
var cljs$core$async$mix_$_state_machine__12028__auto____1 = (function (state_13839){
while(true){
var ret_value__12029__auto__ = (function (){try{while(true){
var result__12030__auto__ = switch__12027__auto__.call(null,state_13839);
if(cljs.core.keyword_identical_QMARK_.call(null,result__12030__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12030__auto__;
}
break;
}
}catch (e13899){if((e13899 instanceof Object)){
var ex__12031__auto__ = e13899;
var statearr_13900_13949 = state_13839;
(statearr_13900_13949[(5)] = ex__12031__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13839);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13899;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__12029__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13950 = state_13839;
state_13839 = G__13950;
continue;
} else {
return ret_value__12029__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__12028__auto__ = function(state_13839){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__12028__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__12028__auto____1.call(this,state_13839);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__12028__auto____0;
cljs$core$async$mix_$_state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__12028__auto____1;
return cljs$core$async$mix_$_state_machine__12028__auto__;
})()
;})(switch__12027__auto__,c__12139__auto___13902,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__12141__auto__ = (function (){var statearr_13901 = f__12140__auto__.call(null);
(statearr_13901[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12139__auto___13902);

return statearr_13901;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__12141__auto__);
});})(c__12139__auto___13902,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__7072__auto__ = (((p == null))?null:p);
var m__7073__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return m__7073__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__7073__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return m__7073__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__7072__auto__ = (((p == null))?null:p);
var m__7073__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return m__7073__auto__.call(null,p,v,ch);
} else {
var m__7073__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return m__7073__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args13951 = [];
var len__7484__auto___13954 = arguments.length;
var i__7485__auto___13955 = (0);
while(true){
if((i__7485__auto___13955 < len__7484__auto___13954)){
args13951.push((arguments[i__7485__auto___13955]));

var G__13956 = (i__7485__auto___13955 + (1));
i__7485__auto___13955 = G__13956;
continue;
} else {
}
break;
}

var G__13953 = args13951.length;
switch (G__13953) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13951.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__7072__auto__ = (((p == null))?null:p);
var m__7073__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return m__7073__auto__.call(null,p);
} else {
var m__7073__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return m__7073__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__7072__auto__ = (((p == null))?null:p);
var m__7073__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return m__7073__auto__.call(null,p,v);
} else {
var m__7073__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return m__7073__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args13959 = [];
var len__7484__auto___14084 = arguments.length;
var i__7485__auto___14085 = (0);
while(true){
if((i__7485__auto___14085 < len__7484__auto___14084)){
args13959.push((arguments[i__7485__auto___14085]));

var G__14086 = (i__7485__auto___14085 + (1));
i__7485__auto___14085 = G__14086;
continue;
} else {
}
break;
}

var G__13961 = args13959.length;
switch (G__13961) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13959.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__6409__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__6409__auto__,mults){
return (function (p1__13958_SHARP_){
if(cljs.core.truth_(p1__13958_SHARP_.call(null,topic))){
return p1__13958_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__13958_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__6409__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async13962 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async13962 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta13963){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta13963 = meta13963;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async13962.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_13964,meta13963__$1){
var self__ = this;
var _13964__$1 = this;
return (new cljs.core.async.t_cljs$core$async13962(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta13963__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async13962.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_13964){
var self__ = this;
var _13964__$1 = this;
return self__.meta13963;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async13962.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async13962.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async13962.prototype.cljs$core$async$Pub$ = true;

cljs.core.async.t_cljs$core$async13962.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async13962.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4657__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__4657__auto__)){
var m = temp__4657__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async13962.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async13962.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async13962.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta13963","meta13963",-885965519,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async13962.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async13962.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async13962";

cljs.core.async.t_cljs$core$async13962.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"cljs.core.async/t_cljs$core$async13962");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async13962 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async13962(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta13963){
return (new cljs.core.async.t_cljs$core$async13962(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta13963));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async13962(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__12139__auto___14088 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__12139__auto___14088,mults,ensure_mult,p){
return (function (){
var f__12140__auto__ = (function (){var switch__12027__auto__ = ((function (c__12139__auto___14088,mults,ensure_mult,p){
return (function (state_14036){
var state_val_14037 = (state_14036[(1)]);
if((state_val_14037 === (7))){
var inst_14032 = (state_14036[(2)]);
var state_14036__$1 = state_14036;
var statearr_14038_14089 = state_14036__$1;
(statearr_14038_14089[(2)] = inst_14032);

(statearr_14038_14089[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14037 === (20))){
var state_14036__$1 = state_14036;
var statearr_14039_14090 = state_14036__$1;
(statearr_14039_14090[(2)] = null);

(statearr_14039_14090[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14037 === (1))){
var state_14036__$1 = state_14036;
var statearr_14040_14091 = state_14036__$1;
(statearr_14040_14091[(2)] = null);

(statearr_14040_14091[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14037 === (24))){
var inst_14015 = (state_14036[(7)]);
var inst_14024 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_14015);
var state_14036__$1 = state_14036;
var statearr_14041_14092 = state_14036__$1;
(statearr_14041_14092[(2)] = inst_14024);

(statearr_14041_14092[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14037 === (4))){
var inst_13967 = (state_14036[(8)]);
var inst_13967__$1 = (state_14036[(2)]);
var inst_13968 = (inst_13967__$1 == null);
var state_14036__$1 = (function (){var statearr_14042 = state_14036;
(statearr_14042[(8)] = inst_13967__$1);

return statearr_14042;
})();
if(cljs.core.truth_(inst_13968)){
var statearr_14043_14093 = state_14036__$1;
(statearr_14043_14093[(1)] = (5));

} else {
var statearr_14044_14094 = state_14036__$1;
(statearr_14044_14094[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14037 === (15))){
var inst_14009 = (state_14036[(2)]);
var state_14036__$1 = state_14036;
var statearr_14045_14095 = state_14036__$1;
(statearr_14045_14095[(2)] = inst_14009);

(statearr_14045_14095[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14037 === (21))){
var inst_14029 = (state_14036[(2)]);
var state_14036__$1 = (function (){var statearr_14046 = state_14036;
(statearr_14046[(9)] = inst_14029);

return statearr_14046;
})();
var statearr_14047_14096 = state_14036__$1;
(statearr_14047_14096[(2)] = null);

(statearr_14047_14096[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14037 === (13))){
var inst_13991 = (state_14036[(10)]);
var inst_13993 = cljs.core.chunked_seq_QMARK_.call(null,inst_13991);
var state_14036__$1 = state_14036;
if(inst_13993){
var statearr_14048_14097 = state_14036__$1;
(statearr_14048_14097[(1)] = (16));

} else {
var statearr_14049_14098 = state_14036__$1;
(statearr_14049_14098[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14037 === (22))){
var inst_14021 = (state_14036[(2)]);
var state_14036__$1 = state_14036;
if(cljs.core.truth_(inst_14021)){
var statearr_14050_14099 = state_14036__$1;
(statearr_14050_14099[(1)] = (23));

} else {
var statearr_14051_14100 = state_14036__$1;
(statearr_14051_14100[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14037 === (6))){
var inst_13967 = (state_14036[(8)]);
var inst_14015 = (state_14036[(7)]);
var inst_14017 = (state_14036[(11)]);
var inst_14015__$1 = topic_fn.call(null,inst_13967);
var inst_14016 = cljs.core.deref.call(null,mults);
var inst_14017__$1 = cljs.core.get.call(null,inst_14016,inst_14015__$1);
var state_14036__$1 = (function (){var statearr_14052 = state_14036;
(statearr_14052[(7)] = inst_14015__$1);

(statearr_14052[(11)] = inst_14017__$1);

return statearr_14052;
})();
if(cljs.core.truth_(inst_14017__$1)){
var statearr_14053_14101 = state_14036__$1;
(statearr_14053_14101[(1)] = (19));

} else {
var statearr_14054_14102 = state_14036__$1;
(statearr_14054_14102[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14037 === (25))){
var inst_14026 = (state_14036[(2)]);
var state_14036__$1 = state_14036;
var statearr_14055_14103 = state_14036__$1;
(statearr_14055_14103[(2)] = inst_14026);

(statearr_14055_14103[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14037 === (17))){
var inst_13991 = (state_14036[(10)]);
var inst_14000 = cljs.core.first.call(null,inst_13991);
var inst_14001 = cljs.core.async.muxch_STAR_.call(null,inst_14000);
var inst_14002 = cljs.core.async.close_BANG_.call(null,inst_14001);
var inst_14003 = cljs.core.next.call(null,inst_13991);
var inst_13977 = inst_14003;
var inst_13978 = null;
var inst_13979 = (0);
var inst_13980 = (0);
var state_14036__$1 = (function (){var statearr_14056 = state_14036;
(statearr_14056[(12)] = inst_14002);

(statearr_14056[(13)] = inst_13977);

(statearr_14056[(14)] = inst_13980);

(statearr_14056[(15)] = inst_13978);

(statearr_14056[(16)] = inst_13979);

return statearr_14056;
})();
var statearr_14057_14104 = state_14036__$1;
(statearr_14057_14104[(2)] = null);

(statearr_14057_14104[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14037 === (3))){
var inst_14034 = (state_14036[(2)]);
var state_14036__$1 = state_14036;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14036__$1,inst_14034);
} else {
if((state_val_14037 === (12))){
var inst_14011 = (state_14036[(2)]);
var state_14036__$1 = state_14036;
var statearr_14058_14105 = state_14036__$1;
(statearr_14058_14105[(2)] = inst_14011);

(statearr_14058_14105[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14037 === (2))){
var state_14036__$1 = state_14036;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14036__$1,(4),ch);
} else {
if((state_val_14037 === (23))){
var state_14036__$1 = state_14036;
var statearr_14059_14106 = state_14036__$1;
(statearr_14059_14106[(2)] = null);

(statearr_14059_14106[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14037 === (19))){
var inst_13967 = (state_14036[(8)]);
var inst_14017 = (state_14036[(11)]);
var inst_14019 = cljs.core.async.muxch_STAR_.call(null,inst_14017);
var state_14036__$1 = state_14036;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14036__$1,(22),inst_14019,inst_13967);
} else {
if((state_val_14037 === (11))){
var inst_13977 = (state_14036[(13)]);
var inst_13991 = (state_14036[(10)]);
var inst_13991__$1 = cljs.core.seq.call(null,inst_13977);
var state_14036__$1 = (function (){var statearr_14060 = state_14036;
(statearr_14060[(10)] = inst_13991__$1);

return statearr_14060;
})();
if(inst_13991__$1){
var statearr_14061_14107 = state_14036__$1;
(statearr_14061_14107[(1)] = (13));

} else {
var statearr_14062_14108 = state_14036__$1;
(statearr_14062_14108[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14037 === (9))){
var inst_14013 = (state_14036[(2)]);
var state_14036__$1 = state_14036;
var statearr_14063_14109 = state_14036__$1;
(statearr_14063_14109[(2)] = inst_14013);

(statearr_14063_14109[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14037 === (5))){
var inst_13974 = cljs.core.deref.call(null,mults);
var inst_13975 = cljs.core.vals.call(null,inst_13974);
var inst_13976 = cljs.core.seq.call(null,inst_13975);
var inst_13977 = inst_13976;
var inst_13978 = null;
var inst_13979 = (0);
var inst_13980 = (0);
var state_14036__$1 = (function (){var statearr_14064 = state_14036;
(statearr_14064[(13)] = inst_13977);

(statearr_14064[(14)] = inst_13980);

(statearr_14064[(15)] = inst_13978);

(statearr_14064[(16)] = inst_13979);

return statearr_14064;
})();
var statearr_14065_14110 = state_14036__$1;
(statearr_14065_14110[(2)] = null);

(statearr_14065_14110[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14037 === (14))){
var state_14036__$1 = state_14036;
var statearr_14069_14111 = state_14036__$1;
(statearr_14069_14111[(2)] = null);

(statearr_14069_14111[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14037 === (16))){
var inst_13991 = (state_14036[(10)]);
var inst_13995 = cljs.core.chunk_first.call(null,inst_13991);
var inst_13996 = cljs.core.chunk_rest.call(null,inst_13991);
var inst_13997 = cljs.core.count.call(null,inst_13995);
var inst_13977 = inst_13996;
var inst_13978 = inst_13995;
var inst_13979 = inst_13997;
var inst_13980 = (0);
var state_14036__$1 = (function (){var statearr_14070 = state_14036;
(statearr_14070[(13)] = inst_13977);

(statearr_14070[(14)] = inst_13980);

(statearr_14070[(15)] = inst_13978);

(statearr_14070[(16)] = inst_13979);

return statearr_14070;
})();
var statearr_14071_14112 = state_14036__$1;
(statearr_14071_14112[(2)] = null);

(statearr_14071_14112[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14037 === (10))){
var inst_13977 = (state_14036[(13)]);
var inst_13980 = (state_14036[(14)]);
var inst_13978 = (state_14036[(15)]);
var inst_13979 = (state_14036[(16)]);
var inst_13985 = cljs.core._nth.call(null,inst_13978,inst_13980);
var inst_13986 = cljs.core.async.muxch_STAR_.call(null,inst_13985);
var inst_13987 = cljs.core.async.close_BANG_.call(null,inst_13986);
var inst_13988 = (inst_13980 + (1));
var tmp14066 = inst_13977;
var tmp14067 = inst_13978;
var tmp14068 = inst_13979;
var inst_13977__$1 = tmp14066;
var inst_13978__$1 = tmp14067;
var inst_13979__$1 = tmp14068;
var inst_13980__$1 = inst_13988;
var state_14036__$1 = (function (){var statearr_14072 = state_14036;
(statearr_14072[(17)] = inst_13987);

(statearr_14072[(13)] = inst_13977__$1);

(statearr_14072[(14)] = inst_13980__$1);

(statearr_14072[(15)] = inst_13978__$1);

(statearr_14072[(16)] = inst_13979__$1);

return statearr_14072;
})();
var statearr_14073_14113 = state_14036__$1;
(statearr_14073_14113[(2)] = null);

(statearr_14073_14113[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14037 === (18))){
var inst_14006 = (state_14036[(2)]);
var state_14036__$1 = state_14036;
var statearr_14074_14114 = state_14036__$1;
(statearr_14074_14114[(2)] = inst_14006);

(statearr_14074_14114[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14037 === (8))){
var inst_13980 = (state_14036[(14)]);
var inst_13979 = (state_14036[(16)]);
var inst_13982 = (inst_13980 < inst_13979);
var inst_13983 = inst_13982;
var state_14036__$1 = state_14036;
if(cljs.core.truth_(inst_13983)){
var statearr_14075_14115 = state_14036__$1;
(statearr_14075_14115[(1)] = (10));

} else {
var statearr_14076_14116 = state_14036__$1;
(statearr_14076_14116[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12139__auto___14088,mults,ensure_mult,p))
;
return ((function (switch__12027__auto__,c__12139__auto___14088,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__12028__auto__ = null;
var cljs$core$async$state_machine__12028__auto____0 = (function (){
var statearr_14080 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14080[(0)] = cljs$core$async$state_machine__12028__auto__);

(statearr_14080[(1)] = (1));

return statearr_14080;
});
var cljs$core$async$state_machine__12028__auto____1 = (function (state_14036){
while(true){
var ret_value__12029__auto__ = (function (){try{while(true){
var result__12030__auto__ = switch__12027__auto__.call(null,state_14036);
if(cljs.core.keyword_identical_QMARK_.call(null,result__12030__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12030__auto__;
}
break;
}
}catch (e14081){if((e14081 instanceof Object)){
var ex__12031__auto__ = e14081;
var statearr_14082_14117 = state_14036;
(statearr_14082_14117[(5)] = ex__12031__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14036);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14081;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__12029__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14118 = state_14036;
state_14036 = G__14118;
continue;
} else {
return ret_value__12029__auto__;
}
break;
}
});
cljs$core$async$state_machine__12028__auto__ = function(state_14036){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12028__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12028__auto____1.call(this,state_14036);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12028__auto____0;
cljs$core$async$state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12028__auto____1;
return cljs$core$async$state_machine__12028__auto__;
})()
;})(switch__12027__auto__,c__12139__auto___14088,mults,ensure_mult,p))
})();
var state__12141__auto__ = (function (){var statearr_14083 = f__12140__auto__.call(null);
(statearr_14083[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12139__auto___14088);

return statearr_14083;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__12141__auto__);
});})(c__12139__auto___14088,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args14119 = [];
var len__7484__auto___14122 = arguments.length;
var i__7485__auto___14123 = (0);
while(true){
if((i__7485__auto___14123 < len__7484__auto___14122)){
args14119.push((arguments[i__7485__auto___14123]));

var G__14124 = (i__7485__auto___14123 + (1));
i__7485__auto___14123 = G__14124;
continue;
} else {
}
break;
}

var G__14121 = args14119.length;
switch (G__14121) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14119.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args14126 = [];
var len__7484__auto___14129 = arguments.length;
var i__7485__auto___14130 = (0);
while(true){
if((i__7485__auto___14130 < len__7484__auto___14129)){
args14126.push((arguments[i__7485__auto___14130]));

var G__14131 = (i__7485__auto___14130 + (1));
i__7485__auto___14130 = G__14131;
continue;
} else {
}
break;
}

var G__14128 = args14126.length;
switch (G__14128) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14126.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args14133 = [];
var len__7484__auto___14204 = arguments.length;
var i__7485__auto___14205 = (0);
while(true){
if((i__7485__auto___14205 < len__7484__auto___14204)){
args14133.push((arguments[i__7485__auto___14205]));

var G__14206 = (i__7485__auto___14205 + (1));
i__7485__auto___14205 = G__14206;
continue;
} else {
}
break;
}

var G__14135 = args14133.length;
switch (G__14135) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14133.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__12139__auto___14208 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__12139__auto___14208,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__12140__auto__ = (function (){var switch__12027__auto__ = ((function (c__12139__auto___14208,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_14174){
var state_val_14175 = (state_14174[(1)]);
if((state_val_14175 === (7))){
var state_14174__$1 = state_14174;
var statearr_14176_14209 = state_14174__$1;
(statearr_14176_14209[(2)] = null);

(statearr_14176_14209[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14175 === (1))){
var state_14174__$1 = state_14174;
var statearr_14177_14210 = state_14174__$1;
(statearr_14177_14210[(2)] = null);

(statearr_14177_14210[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14175 === (4))){
var inst_14138 = (state_14174[(7)]);
var inst_14140 = (inst_14138 < cnt);
var state_14174__$1 = state_14174;
if(cljs.core.truth_(inst_14140)){
var statearr_14178_14211 = state_14174__$1;
(statearr_14178_14211[(1)] = (6));

} else {
var statearr_14179_14212 = state_14174__$1;
(statearr_14179_14212[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14175 === (15))){
var inst_14170 = (state_14174[(2)]);
var state_14174__$1 = state_14174;
var statearr_14180_14213 = state_14174__$1;
(statearr_14180_14213[(2)] = inst_14170);

(statearr_14180_14213[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14175 === (13))){
var inst_14163 = cljs.core.async.close_BANG_.call(null,out);
var state_14174__$1 = state_14174;
var statearr_14181_14214 = state_14174__$1;
(statearr_14181_14214[(2)] = inst_14163);

(statearr_14181_14214[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14175 === (6))){
var state_14174__$1 = state_14174;
var statearr_14182_14215 = state_14174__$1;
(statearr_14182_14215[(2)] = null);

(statearr_14182_14215[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14175 === (3))){
var inst_14172 = (state_14174[(2)]);
var state_14174__$1 = state_14174;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14174__$1,inst_14172);
} else {
if((state_val_14175 === (12))){
var inst_14160 = (state_14174[(8)]);
var inst_14160__$1 = (state_14174[(2)]);
var inst_14161 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_14160__$1);
var state_14174__$1 = (function (){var statearr_14183 = state_14174;
(statearr_14183[(8)] = inst_14160__$1);

return statearr_14183;
})();
if(cljs.core.truth_(inst_14161)){
var statearr_14184_14216 = state_14174__$1;
(statearr_14184_14216[(1)] = (13));

} else {
var statearr_14185_14217 = state_14174__$1;
(statearr_14185_14217[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14175 === (2))){
var inst_14137 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_14138 = (0);
var state_14174__$1 = (function (){var statearr_14186 = state_14174;
(statearr_14186[(9)] = inst_14137);

(statearr_14186[(7)] = inst_14138);

return statearr_14186;
})();
var statearr_14187_14218 = state_14174__$1;
(statearr_14187_14218[(2)] = null);

(statearr_14187_14218[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14175 === (11))){
var inst_14138 = (state_14174[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_14174,(10),Object,null,(9));
var inst_14147 = chs__$1.call(null,inst_14138);
var inst_14148 = done.call(null,inst_14138);
var inst_14149 = cljs.core.async.take_BANG_.call(null,inst_14147,inst_14148);
var state_14174__$1 = state_14174;
var statearr_14188_14219 = state_14174__$1;
(statearr_14188_14219[(2)] = inst_14149);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14174__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14175 === (9))){
var inst_14138 = (state_14174[(7)]);
var inst_14151 = (state_14174[(2)]);
var inst_14152 = (inst_14138 + (1));
var inst_14138__$1 = inst_14152;
var state_14174__$1 = (function (){var statearr_14189 = state_14174;
(statearr_14189[(10)] = inst_14151);

(statearr_14189[(7)] = inst_14138__$1);

return statearr_14189;
})();
var statearr_14190_14220 = state_14174__$1;
(statearr_14190_14220[(2)] = null);

(statearr_14190_14220[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14175 === (5))){
var inst_14158 = (state_14174[(2)]);
var state_14174__$1 = (function (){var statearr_14191 = state_14174;
(statearr_14191[(11)] = inst_14158);

return statearr_14191;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14174__$1,(12),dchan);
} else {
if((state_val_14175 === (14))){
var inst_14160 = (state_14174[(8)]);
var inst_14165 = cljs.core.apply.call(null,f,inst_14160);
var state_14174__$1 = state_14174;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14174__$1,(16),out,inst_14165);
} else {
if((state_val_14175 === (16))){
var inst_14167 = (state_14174[(2)]);
var state_14174__$1 = (function (){var statearr_14192 = state_14174;
(statearr_14192[(12)] = inst_14167);

return statearr_14192;
})();
var statearr_14193_14221 = state_14174__$1;
(statearr_14193_14221[(2)] = null);

(statearr_14193_14221[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14175 === (10))){
var inst_14142 = (state_14174[(2)]);
var inst_14143 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_14174__$1 = (function (){var statearr_14194 = state_14174;
(statearr_14194[(13)] = inst_14142);

return statearr_14194;
})();
var statearr_14195_14222 = state_14174__$1;
(statearr_14195_14222[(2)] = inst_14143);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14174__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14175 === (8))){
var inst_14156 = (state_14174[(2)]);
var state_14174__$1 = state_14174;
var statearr_14196_14223 = state_14174__$1;
(statearr_14196_14223[(2)] = inst_14156);

(statearr_14196_14223[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12139__auto___14208,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__12027__auto__,c__12139__auto___14208,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__12028__auto__ = null;
var cljs$core$async$state_machine__12028__auto____0 = (function (){
var statearr_14200 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14200[(0)] = cljs$core$async$state_machine__12028__auto__);

(statearr_14200[(1)] = (1));

return statearr_14200;
});
var cljs$core$async$state_machine__12028__auto____1 = (function (state_14174){
while(true){
var ret_value__12029__auto__ = (function (){try{while(true){
var result__12030__auto__ = switch__12027__auto__.call(null,state_14174);
if(cljs.core.keyword_identical_QMARK_.call(null,result__12030__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12030__auto__;
}
break;
}
}catch (e14201){if((e14201 instanceof Object)){
var ex__12031__auto__ = e14201;
var statearr_14202_14224 = state_14174;
(statearr_14202_14224[(5)] = ex__12031__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14174);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14201;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__12029__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14225 = state_14174;
state_14174 = G__14225;
continue;
} else {
return ret_value__12029__auto__;
}
break;
}
});
cljs$core$async$state_machine__12028__auto__ = function(state_14174){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12028__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12028__auto____1.call(this,state_14174);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12028__auto____0;
cljs$core$async$state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12028__auto____1;
return cljs$core$async$state_machine__12028__auto__;
})()
;})(switch__12027__auto__,c__12139__auto___14208,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__12141__auto__ = (function (){var statearr_14203 = f__12140__auto__.call(null);
(statearr_14203[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12139__auto___14208);

return statearr_14203;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__12141__auto__);
});})(c__12139__auto___14208,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args14227 = [];
var len__7484__auto___14285 = arguments.length;
var i__7485__auto___14286 = (0);
while(true){
if((i__7485__auto___14286 < len__7484__auto___14285)){
args14227.push((arguments[i__7485__auto___14286]));

var G__14287 = (i__7485__auto___14286 + (1));
i__7485__auto___14286 = G__14287;
continue;
} else {
}
break;
}

var G__14229 = args14227.length;
switch (G__14229) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14227.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__12139__auto___14289 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__12139__auto___14289,out){
return (function (){
var f__12140__auto__ = (function (){var switch__12027__auto__ = ((function (c__12139__auto___14289,out){
return (function (state_14261){
var state_val_14262 = (state_14261[(1)]);
if((state_val_14262 === (7))){
var inst_14241 = (state_14261[(7)]);
var inst_14240 = (state_14261[(8)]);
var inst_14240__$1 = (state_14261[(2)]);
var inst_14241__$1 = cljs.core.nth.call(null,inst_14240__$1,(0),null);
var inst_14242 = cljs.core.nth.call(null,inst_14240__$1,(1),null);
var inst_14243 = (inst_14241__$1 == null);
var state_14261__$1 = (function (){var statearr_14263 = state_14261;
(statearr_14263[(7)] = inst_14241__$1);

(statearr_14263[(8)] = inst_14240__$1);

(statearr_14263[(9)] = inst_14242);

return statearr_14263;
})();
if(cljs.core.truth_(inst_14243)){
var statearr_14264_14290 = state_14261__$1;
(statearr_14264_14290[(1)] = (8));

} else {
var statearr_14265_14291 = state_14261__$1;
(statearr_14265_14291[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14262 === (1))){
var inst_14230 = cljs.core.vec.call(null,chs);
var inst_14231 = inst_14230;
var state_14261__$1 = (function (){var statearr_14266 = state_14261;
(statearr_14266[(10)] = inst_14231);

return statearr_14266;
})();
var statearr_14267_14292 = state_14261__$1;
(statearr_14267_14292[(2)] = null);

(statearr_14267_14292[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14262 === (4))){
var inst_14231 = (state_14261[(10)]);
var state_14261__$1 = state_14261;
return cljs.core.async.ioc_alts_BANG_.call(null,state_14261__$1,(7),inst_14231);
} else {
if((state_val_14262 === (6))){
var inst_14257 = (state_14261[(2)]);
var state_14261__$1 = state_14261;
var statearr_14268_14293 = state_14261__$1;
(statearr_14268_14293[(2)] = inst_14257);

(statearr_14268_14293[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14262 === (3))){
var inst_14259 = (state_14261[(2)]);
var state_14261__$1 = state_14261;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14261__$1,inst_14259);
} else {
if((state_val_14262 === (2))){
var inst_14231 = (state_14261[(10)]);
var inst_14233 = cljs.core.count.call(null,inst_14231);
var inst_14234 = (inst_14233 > (0));
var state_14261__$1 = state_14261;
if(cljs.core.truth_(inst_14234)){
var statearr_14270_14294 = state_14261__$1;
(statearr_14270_14294[(1)] = (4));

} else {
var statearr_14271_14295 = state_14261__$1;
(statearr_14271_14295[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14262 === (11))){
var inst_14231 = (state_14261[(10)]);
var inst_14250 = (state_14261[(2)]);
var tmp14269 = inst_14231;
var inst_14231__$1 = tmp14269;
var state_14261__$1 = (function (){var statearr_14272 = state_14261;
(statearr_14272[(10)] = inst_14231__$1);

(statearr_14272[(11)] = inst_14250);

return statearr_14272;
})();
var statearr_14273_14296 = state_14261__$1;
(statearr_14273_14296[(2)] = null);

(statearr_14273_14296[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14262 === (9))){
var inst_14241 = (state_14261[(7)]);
var state_14261__$1 = state_14261;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14261__$1,(11),out,inst_14241);
} else {
if((state_val_14262 === (5))){
var inst_14255 = cljs.core.async.close_BANG_.call(null,out);
var state_14261__$1 = state_14261;
var statearr_14274_14297 = state_14261__$1;
(statearr_14274_14297[(2)] = inst_14255);

(statearr_14274_14297[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14262 === (10))){
var inst_14253 = (state_14261[(2)]);
var state_14261__$1 = state_14261;
var statearr_14275_14298 = state_14261__$1;
(statearr_14275_14298[(2)] = inst_14253);

(statearr_14275_14298[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14262 === (8))){
var inst_14241 = (state_14261[(7)]);
var inst_14240 = (state_14261[(8)]);
var inst_14231 = (state_14261[(10)]);
var inst_14242 = (state_14261[(9)]);
var inst_14245 = (function (){var cs = inst_14231;
var vec__14236 = inst_14240;
var v = inst_14241;
var c = inst_14242;
return ((function (cs,vec__14236,v,c,inst_14241,inst_14240,inst_14231,inst_14242,state_val_14262,c__12139__auto___14289,out){
return (function (p1__14226_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__14226_SHARP_);
});
;})(cs,vec__14236,v,c,inst_14241,inst_14240,inst_14231,inst_14242,state_val_14262,c__12139__auto___14289,out))
})();
var inst_14246 = cljs.core.filterv.call(null,inst_14245,inst_14231);
var inst_14231__$1 = inst_14246;
var state_14261__$1 = (function (){var statearr_14276 = state_14261;
(statearr_14276[(10)] = inst_14231__$1);

return statearr_14276;
})();
var statearr_14277_14299 = state_14261__$1;
(statearr_14277_14299[(2)] = null);

(statearr_14277_14299[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__12139__auto___14289,out))
;
return ((function (switch__12027__auto__,c__12139__auto___14289,out){
return (function() {
var cljs$core$async$state_machine__12028__auto__ = null;
var cljs$core$async$state_machine__12028__auto____0 = (function (){
var statearr_14281 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14281[(0)] = cljs$core$async$state_machine__12028__auto__);

(statearr_14281[(1)] = (1));

return statearr_14281;
});
var cljs$core$async$state_machine__12028__auto____1 = (function (state_14261){
while(true){
var ret_value__12029__auto__ = (function (){try{while(true){
var result__12030__auto__ = switch__12027__auto__.call(null,state_14261);
if(cljs.core.keyword_identical_QMARK_.call(null,result__12030__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12030__auto__;
}
break;
}
}catch (e14282){if((e14282 instanceof Object)){
var ex__12031__auto__ = e14282;
var statearr_14283_14300 = state_14261;
(statearr_14283_14300[(5)] = ex__12031__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14261);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14282;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__12029__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14301 = state_14261;
state_14261 = G__14301;
continue;
} else {
return ret_value__12029__auto__;
}
break;
}
});
cljs$core$async$state_machine__12028__auto__ = function(state_14261){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12028__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12028__auto____1.call(this,state_14261);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12028__auto____0;
cljs$core$async$state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12028__auto____1;
return cljs$core$async$state_machine__12028__auto__;
})()
;})(switch__12027__auto__,c__12139__auto___14289,out))
})();
var state__12141__auto__ = (function (){var statearr_14284 = f__12140__auto__.call(null);
(statearr_14284[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12139__auto___14289);

return statearr_14284;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__12141__auto__);
});})(c__12139__auto___14289,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args14302 = [];
var len__7484__auto___14351 = arguments.length;
var i__7485__auto___14352 = (0);
while(true){
if((i__7485__auto___14352 < len__7484__auto___14351)){
args14302.push((arguments[i__7485__auto___14352]));

var G__14353 = (i__7485__auto___14352 + (1));
i__7485__auto___14352 = G__14353;
continue;
} else {
}
break;
}

var G__14304 = args14302.length;
switch (G__14304) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14302.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__12139__auto___14355 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__12139__auto___14355,out){
return (function (){
var f__12140__auto__ = (function (){var switch__12027__auto__ = ((function (c__12139__auto___14355,out){
return (function (state_14328){
var state_val_14329 = (state_14328[(1)]);
if((state_val_14329 === (7))){
var inst_14310 = (state_14328[(7)]);
var inst_14310__$1 = (state_14328[(2)]);
var inst_14311 = (inst_14310__$1 == null);
var inst_14312 = cljs.core.not.call(null,inst_14311);
var state_14328__$1 = (function (){var statearr_14330 = state_14328;
(statearr_14330[(7)] = inst_14310__$1);

return statearr_14330;
})();
if(inst_14312){
var statearr_14331_14356 = state_14328__$1;
(statearr_14331_14356[(1)] = (8));

} else {
var statearr_14332_14357 = state_14328__$1;
(statearr_14332_14357[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14329 === (1))){
var inst_14305 = (0);
var state_14328__$1 = (function (){var statearr_14333 = state_14328;
(statearr_14333[(8)] = inst_14305);

return statearr_14333;
})();
var statearr_14334_14358 = state_14328__$1;
(statearr_14334_14358[(2)] = null);

(statearr_14334_14358[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14329 === (4))){
var state_14328__$1 = state_14328;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14328__$1,(7),ch);
} else {
if((state_val_14329 === (6))){
var inst_14323 = (state_14328[(2)]);
var state_14328__$1 = state_14328;
var statearr_14335_14359 = state_14328__$1;
(statearr_14335_14359[(2)] = inst_14323);

(statearr_14335_14359[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14329 === (3))){
var inst_14325 = (state_14328[(2)]);
var inst_14326 = cljs.core.async.close_BANG_.call(null,out);
var state_14328__$1 = (function (){var statearr_14336 = state_14328;
(statearr_14336[(9)] = inst_14325);

return statearr_14336;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14328__$1,inst_14326);
} else {
if((state_val_14329 === (2))){
var inst_14305 = (state_14328[(8)]);
var inst_14307 = (inst_14305 < n);
var state_14328__$1 = state_14328;
if(cljs.core.truth_(inst_14307)){
var statearr_14337_14360 = state_14328__$1;
(statearr_14337_14360[(1)] = (4));

} else {
var statearr_14338_14361 = state_14328__$1;
(statearr_14338_14361[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14329 === (11))){
var inst_14305 = (state_14328[(8)]);
var inst_14315 = (state_14328[(2)]);
var inst_14316 = (inst_14305 + (1));
var inst_14305__$1 = inst_14316;
var state_14328__$1 = (function (){var statearr_14339 = state_14328;
(statearr_14339[(10)] = inst_14315);

(statearr_14339[(8)] = inst_14305__$1);

return statearr_14339;
})();
var statearr_14340_14362 = state_14328__$1;
(statearr_14340_14362[(2)] = null);

(statearr_14340_14362[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14329 === (9))){
var state_14328__$1 = state_14328;
var statearr_14341_14363 = state_14328__$1;
(statearr_14341_14363[(2)] = null);

(statearr_14341_14363[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14329 === (5))){
var state_14328__$1 = state_14328;
var statearr_14342_14364 = state_14328__$1;
(statearr_14342_14364[(2)] = null);

(statearr_14342_14364[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14329 === (10))){
var inst_14320 = (state_14328[(2)]);
var state_14328__$1 = state_14328;
var statearr_14343_14365 = state_14328__$1;
(statearr_14343_14365[(2)] = inst_14320);

(statearr_14343_14365[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14329 === (8))){
var inst_14310 = (state_14328[(7)]);
var state_14328__$1 = state_14328;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14328__$1,(11),out,inst_14310);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__12139__auto___14355,out))
;
return ((function (switch__12027__auto__,c__12139__auto___14355,out){
return (function() {
var cljs$core$async$state_machine__12028__auto__ = null;
var cljs$core$async$state_machine__12028__auto____0 = (function (){
var statearr_14347 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_14347[(0)] = cljs$core$async$state_machine__12028__auto__);

(statearr_14347[(1)] = (1));

return statearr_14347;
});
var cljs$core$async$state_machine__12028__auto____1 = (function (state_14328){
while(true){
var ret_value__12029__auto__ = (function (){try{while(true){
var result__12030__auto__ = switch__12027__auto__.call(null,state_14328);
if(cljs.core.keyword_identical_QMARK_.call(null,result__12030__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12030__auto__;
}
break;
}
}catch (e14348){if((e14348 instanceof Object)){
var ex__12031__auto__ = e14348;
var statearr_14349_14366 = state_14328;
(statearr_14349_14366[(5)] = ex__12031__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14328);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14348;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__12029__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14367 = state_14328;
state_14328 = G__14367;
continue;
} else {
return ret_value__12029__auto__;
}
break;
}
});
cljs$core$async$state_machine__12028__auto__ = function(state_14328){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12028__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12028__auto____1.call(this,state_14328);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12028__auto____0;
cljs$core$async$state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12028__auto____1;
return cljs$core$async$state_machine__12028__auto__;
})()
;})(switch__12027__auto__,c__12139__auto___14355,out))
})();
var state__12141__auto__ = (function (){var statearr_14350 = f__12140__auto__.call(null);
(statearr_14350[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12139__auto___14355);

return statearr_14350;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__12141__auto__);
});})(c__12139__auto___14355,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async14375 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async14375 = (function (map_LT_,f,ch,meta14376){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta14376 = meta14376;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async14375.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_14377,meta14376__$1){
var self__ = this;
var _14377__$1 = this;
return (new cljs.core.async.t_cljs$core$async14375(self__.map_LT_,self__.f,self__.ch,meta14376__$1));
});

cljs.core.async.t_cljs$core$async14375.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_14377){
var self__ = this;
var _14377__$1 = this;
return self__.meta14376;
});

cljs.core.async.t_cljs$core$async14375.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async14375.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async14375.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async14375.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async14375.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async14378 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async14378 = (function (map_LT_,f,ch,meta14376,_,fn1,meta14379){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta14376 = meta14376;
this._ = _;
this.fn1 = fn1;
this.meta14379 = meta14379;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async14378.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_14380,meta14379__$1){
var self__ = this;
var _14380__$1 = this;
return (new cljs.core.async.t_cljs$core$async14378(self__.map_LT_,self__.f,self__.ch,self__.meta14376,self__._,self__.fn1,meta14379__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async14378.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_14380){
var self__ = this;
var _14380__$1 = this;
return self__.meta14379;
});})(___$1))
;

cljs.core.async.t_cljs$core$async14378.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async14378.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async14378.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async14378.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__14368_SHARP_){
return f1.call(null,(((p1__14368_SHARP_ == null))?null:self__.f.call(null,p1__14368_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async14378.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta14376","meta14376",-651110994,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async14375","cljs.core.async/t_cljs$core$async14375",-872893731,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta14379","meta14379",-174580070,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async14378.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async14378.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async14378";

cljs.core.async.t_cljs$core$async14378.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"cljs.core.async/t_cljs$core$async14378");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async14378 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async14378(map_LT___$1,f__$1,ch__$1,meta14376__$1,___$2,fn1__$1,meta14379){
return (new cljs.core.async.t_cljs$core$async14378(map_LT___$1,f__$1,ch__$1,meta14376__$1,___$2,fn1__$1,meta14379));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async14378(self__.map_LT_,self__.f,self__.ch,self__.meta14376,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__6397__auto__ = ret;
if(cljs.core.truth_(and__6397__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__6397__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async14375.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async14375.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async14375.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta14376","meta14376",-651110994,null)], null);
});

cljs.core.async.t_cljs$core$async14375.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async14375.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async14375";

cljs.core.async.t_cljs$core$async14375.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"cljs.core.async/t_cljs$core$async14375");
});

cljs.core.async.__GT_t_cljs$core$async14375 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async14375(map_LT___$1,f__$1,ch__$1,meta14376){
return (new cljs.core.async.t_cljs$core$async14375(map_LT___$1,f__$1,ch__$1,meta14376));
});

}

return (new cljs.core.async.t_cljs$core$async14375(cljs$core$async$map_LT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async14384 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async14384 = (function (map_GT_,f,ch,meta14385){
this.map_GT_ = map_GT_;
this.f = f;
this.ch = ch;
this.meta14385 = meta14385;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async14384.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_14386,meta14385__$1){
var self__ = this;
var _14386__$1 = this;
return (new cljs.core.async.t_cljs$core$async14384(self__.map_GT_,self__.f,self__.ch,meta14385__$1));
});

cljs.core.async.t_cljs$core$async14384.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_14386){
var self__ = this;
var _14386__$1 = this;
return self__.meta14385;
});

cljs.core.async.t_cljs$core$async14384.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async14384.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async14384.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async14384.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async14384.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async14384.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async14384.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map>","map>",1676369295,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta14385","meta14385",-1878399773,null)], null);
});

cljs.core.async.t_cljs$core$async14384.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async14384.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async14384";

cljs.core.async.t_cljs$core$async14384.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"cljs.core.async/t_cljs$core$async14384");
});

cljs.core.async.__GT_t_cljs$core$async14384 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async14384(map_GT___$1,f__$1,ch__$1,meta14385){
return (new cljs.core.async.t_cljs$core$async14384(map_GT___$1,f__$1,ch__$1,meta14385));
});

}

return (new cljs.core.async.t_cljs$core$async14384(cljs$core$async$map_GT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async14390 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async14390 = (function (filter_GT_,p,ch,meta14391){
this.filter_GT_ = filter_GT_;
this.p = p;
this.ch = ch;
this.meta14391 = meta14391;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async14390.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_14392,meta14391__$1){
var self__ = this;
var _14392__$1 = this;
return (new cljs.core.async.t_cljs$core$async14390(self__.filter_GT_,self__.p,self__.ch,meta14391__$1));
});

cljs.core.async.t_cljs$core$async14390.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_14392){
var self__ = this;
var _14392__$1 = this;
return self__.meta14391;
});

cljs.core.async.t_cljs$core$async14390.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async14390.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async14390.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async14390.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async14390.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async14390.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async14390.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async14390.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"filter>","filter>",-37644455,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta14391","meta14391",-746554758,null)], null);
});

cljs.core.async.t_cljs$core$async14390.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async14390.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async14390";

cljs.core.async.t_cljs$core$async14390.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"cljs.core.async/t_cljs$core$async14390");
});

cljs.core.async.__GT_t_cljs$core$async14390 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async14390(filter_GT___$1,p__$1,ch__$1,meta14391){
return (new cljs.core.async.t_cljs$core$async14390(filter_GT___$1,p__$1,ch__$1,meta14391));
});

}

return (new cljs.core.async.t_cljs$core$async14390(cljs$core$async$filter_GT_,p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args14393 = [];
var len__7484__auto___14437 = arguments.length;
var i__7485__auto___14438 = (0);
while(true){
if((i__7485__auto___14438 < len__7484__auto___14437)){
args14393.push((arguments[i__7485__auto___14438]));

var G__14439 = (i__7485__auto___14438 + (1));
i__7485__auto___14438 = G__14439;
continue;
} else {
}
break;
}

var G__14395 = args14393.length;
switch (G__14395) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14393.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__12139__auto___14441 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__12139__auto___14441,out){
return (function (){
var f__12140__auto__ = (function (){var switch__12027__auto__ = ((function (c__12139__auto___14441,out){
return (function (state_14416){
var state_val_14417 = (state_14416[(1)]);
if((state_val_14417 === (7))){
var inst_14412 = (state_14416[(2)]);
var state_14416__$1 = state_14416;
var statearr_14418_14442 = state_14416__$1;
(statearr_14418_14442[(2)] = inst_14412);

(statearr_14418_14442[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14417 === (1))){
var state_14416__$1 = state_14416;
var statearr_14419_14443 = state_14416__$1;
(statearr_14419_14443[(2)] = null);

(statearr_14419_14443[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14417 === (4))){
var inst_14398 = (state_14416[(7)]);
var inst_14398__$1 = (state_14416[(2)]);
var inst_14399 = (inst_14398__$1 == null);
var state_14416__$1 = (function (){var statearr_14420 = state_14416;
(statearr_14420[(7)] = inst_14398__$1);

return statearr_14420;
})();
if(cljs.core.truth_(inst_14399)){
var statearr_14421_14444 = state_14416__$1;
(statearr_14421_14444[(1)] = (5));

} else {
var statearr_14422_14445 = state_14416__$1;
(statearr_14422_14445[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14417 === (6))){
var inst_14398 = (state_14416[(7)]);
var inst_14403 = p.call(null,inst_14398);
var state_14416__$1 = state_14416;
if(cljs.core.truth_(inst_14403)){
var statearr_14423_14446 = state_14416__$1;
(statearr_14423_14446[(1)] = (8));

} else {
var statearr_14424_14447 = state_14416__$1;
(statearr_14424_14447[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14417 === (3))){
var inst_14414 = (state_14416[(2)]);
var state_14416__$1 = state_14416;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14416__$1,inst_14414);
} else {
if((state_val_14417 === (2))){
var state_14416__$1 = state_14416;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14416__$1,(4),ch);
} else {
if((state_val_14417 === (11))){
var inst_14406 = (state_14416[(2)]);
var state_14416__$1 = state_14416;
var statearr_14425_14448 = state_14416__$1;
(statearr_14425_14448[(2)] = inst_14406);

(statearr_14425_14448[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14417 === (9))){
var state_14416__$1 = state_14416;
var statearr_14426_14449 = state_14416__$1;
(statearr_14426_14449[(2)] = null);

(statearr_14426_14449[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14417 === (5))){
var inst_14401 = cljs.core.async.close_BANG_.call(null,out);
var state_14416__$1 = state_14416;
var statearr_14427_14450 = state_14416__$1;
(statearr_14427_14450[(2)] = inst_14401);

(statearr_14427_14450[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14417 === (10))){
var inst_14409 = (state_14416[(2)]);
var state_14416__$1 = (function (){var statearr_14428 = state_14416;
(statearr_14428[(8)] = inst_14409);

return statearr_14428;
})();
var statearr_14429_14451 = state_14416__$1;
(statearr_14429_14451[(2)] = null);

(statearr_14429_14451[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14417 === (8))){
var inst_14398 = (state_14416[(7)]);
var state_14416__$1 = state_14416;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14416__$1,(11),out,inst_14398);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__12139__auto___14441,out))
;
return ((function (switch__12027__auto__,c__12139__auto___14441,out){
return (function() {
var cljs$core$async$state_machine__12028__auto__ = null;
var cljs$core$async$state_machine__12028__auto____0 = (function (){
var statearr_14433 = [null,null,null,null,null,null,null,null,null];
(statearr_14433[(0)] = cljs$core$async$state_machine__12028__auto__);

(statearr_14433[(1)] = (1));

return statearr_14433;
});
var cljs$core$async$state_machine__12028__auto____1 = (function (state_14416){
while(true){
var ret_value__12029__auto__ = (function (){try{while(true){
var result__12030__auto__ = switch__12027__auto__.call(null,state_14416);
if(cljs.core.keyword_identical_QMARK_.call(null,result__12030__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12030__auto__;
}
break;
}
}catch (e14434){if((e14434 instanceof Object)){
var ex__12031__auto__ = e14434;
var statearr_14435_14452 = state_14416;
(statearr_14435_14452[(5)] = ex__12031__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14416);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14434;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__12029__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14453 = state_14416;
state_14416 = G__14453;
continue;
} else {
return ret_value__12029__auto__;
}
break;
}
});
cljs$core$async$state_machine__12028__auto__ = function(state_14416){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12028__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12028__auto____1.call(this,state_14416);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12028__auto____0;
cljs$core$async$state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12028__auto____1;
return cljs$core$async$state_machine__12028__auto__;
})()
;})(switch__12027__auto__,c__12139__auto___14441,out))
})();
var state__12141__auto__ = (function (){var statearr_14436 = f__12140__auto__.call(null);
(statearr_14436[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12139__auto___14441);

return statearr_14436;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__12141__auto__);
});})(c__12139__auto___14441,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args14454 = [];
var len__7484__auto___14457 = arguments.length;
var i__7485__auto___14458 = (0);
while(true){
if((i__7485__auto___14458 < len__7484__auto___14457)){
args14454.push((arguments[i__7485__auto___14458]));

var G__14459 = (i__7485__auto___14458 + (1));
i__7485__auto___14458 = G__14459;
continue;
} else {
}
break;
}

var G__14456 = args14454.length;
switch (G__14456) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14454.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__12139__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__12139__auto__){
return (function (){
var f__12140__auto__ = (function (){var switch__12027__auto__ = ((function (c__12139__auto__){
return (function (state_14626){
var state_val_14627 = (state_14626[(1)]);
if((state_val_14627 === (7))){
var inst_14622 = (state_14626[(2)]);
var state_14626__$1 = state_14626;
var statearr_14628_14669 = state_14626__$1;
(statearr_14628_14669[(2)] = inst_14622);

(statearr_14628_14669[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14627 === (20))){
var inst_14592 = (state_14626[(7)]);
var inst_14603 = (state_14626[(2)]);
var inst_14604 = cljs.core.next.call(null,inst_14592);
var inst_14578 = inst_14604;
var inst_14579 = null;
var inst_14580 = (0);
var inst_14581 = (0);
var state_14626__$1 = (function (){var statearr_14629 = state_14626;
(statearr_14629[(8)] = inst_14603);

(statearr_14629[(9)] = inst_14581);

(statearr_14629[(10)] = inst_14579);

(statearr_14629[(11)] = inst_14578);

(statearr_14629[(12)] = inst_14580);

return statearr_14629;
})();
var statearr_14630_14670 = state_14626__$1;
(statearr_14630_14670[(2)] = null);

(statearr_14630_14670[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14627 === (1))){
var state_14626__$1 = state_14626;
var statearr_14631_14671 = state_14626__$1;
(statearr_14631_14671[(2)] = null);

(statearr_14631_14671[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14627 === (4))){
var inst_14567 = (state_14626[(13)]);
var inst_14567__$1 = (state_14626[(2)]);
var inst_14568 = (inst_14567__$1 == null);
var state_14626__$1 = (function (){var statearr_14632 = state_14626;
(statearr_14632[(13)] = inst_14567__$1);

return statearr_14632;
})();
if(cljs.core.truth_(inst_14568)){
var statearr_14633_14672 = state_14626__$1;
(statearr_14633_14672[(1)] = (5));

} else {
var statearr_14634_14673 = state_14626__$1;
(statearr_14634_14673[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14627 === (15))){
var state_14626__$1 = state_14626;
var statearr_14638_14674 = state_14626__$1;
(statearr_14638_14674[(2)] = null);

(statearr_14638_14674[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14627 === (21))){
var state_14626__$1 = state_14626;
var statearr_14639_14675 = state_14626__$1;
(statearr_14639_14675[(2)] = null);

(statearr_14639_14675[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14627 === (13))){
var inst_14581 = (state_14626[(9)]);
var inst_14579 = (state_14626[(10)]);
var inst_14578 = (state_14626[(11)]);
var inst_14580 = (state_14626[(12)]);
var inst_14588 = (state_14626[(2)]);
var inst_14589 = (inst_14581 + (1));
var tmp14635 = inst_14579;
var tmp14636 = inst_14578;
var tmp14637 = inst_14580;
var inst_14578__$1 = tmp14636;
var inst_14579__$1 = tmp14635;
var inst_14580__$1 = tmp14637;
var inst_14581__$1 = inst_14589;
var state_14626__$1 = (function (){var statearr_14640 = state_14626;
(statearr_14640[(14)] = inst_14588);

(statearr_14640[(9)] = inst_14581__$1);

(statearr_14640[(10)] = inst_14579__$1);

(statearr_14640[(11)] = inst_14578__$1);

(statearr_14640[(12)] = inst_14580__$1);

return statearr_14640;
})();
var statearr_14641_14676 = state_14626__$1;
(statearr_14641_14676[(2)] = null);

(statearr_14641_14676[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14627 === (22))){
var state_14626__$1 = state_14626;
var statearr_14642_14677 = state_14626__$1;
(statearr_14642_14677[(2)] = null);

(statearr_14642_14677[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14627 === (6))){
var inst_14567 = (state_14626[(13)]);
var inst_14576 = f.call(null,inst_14567);
var inst_14577 = cljs.core.seq.call(null,inst_14576);
var inst_14578 = inst_14577;
var inst_14579 = null;
var inst_14580 = (0);
var inst_14581 = (0);
var state_14626__$1 = (function (){var statearr_14643 = state_14626;
(statearr_14643[(9)] = inst_14581);

(statearr_14643[(10)] = inst_14579);

(statearr_14643[(11)] = inst_14578);

(statearr_14643[(12)] = inst_14580);

return statearr_14643;
})();
var statearr_14644_14678 = state_14626__$1;
(statearr_14644_14678[(2)] = null);

(statearr_14644_14678[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14627 === (17))){
var inst_14592 = (state_14626[(7)]);
var inst_14596 = cljs.core.chunk_first.call(null,inst_14592);
var inst_14597 = cljs.core.chunk_rest.call(null,inst_14592);
var inst_14598 = cljs.core.count.call(null,inst_14596);
var inst_14578 = inst_14597;
var inst_14579 = inst_14596;
var inst_14580 = inst_14598;
var inst_14581 = (0);
var state_14626__$1 = (function (){var statearr_14645 = state_14626;
(statearr_14645[(9)] = inst_14581);

(statearr_14645[(10)] = inst_14579);

(statearr_14645[(11)] = inst_14578);

(statearr_14645[(12)] = inst_14580);

return statearr_14645;
})();
var statearr_14646_14679 = state_14626__$1;
(statearr_14646_14679[(2)] = null);

(statearr_14646_14679[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14627 === (3))){
var inst_14624 = (state_14626[(2)]);
var state_14626__$1 = state_14626;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14626__$1,inst_14624);
} else {
if((state_val_14627 === (12))){
var inst_14612 = (state_14626[(2)]);
var state_14626__$1 = state_14626;
var statearr_14647_14680 = state_14626__$1;
(statearr_14647_14680[(2)] = inst_14612);

(statearr_14647_14680[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14627 === (2))){
var state_14626__$1 = state_14626;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14626__$1,(4),in$);
} else {
if((state_val_14627 === (23))){
var inst_14620 = (state_14626[(2)]);
var state_14626__$1 = state_14626;
var statearr_14648_14681 = state_14626__$1;
(statearr_14648_14681[(2)] = inst_14620);

(statearr_14648_14681[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14627 === (19))){
var inst_14607 = (state_14626[(2)]);
var state_14626__$1 = state_14626;
var statearr_14649_14682 = state_14626__$1;
(statearr_14649_14682[(2)] = inst_14607);

(statearr_14649_14682[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14627 === (11))){
var inst_14592 = (state_14626[(7)]);
var inst_14578 = (state_14626[(11)]);
var inst_14592__$1 = cljs.core.seq.call(null,inst_14578);
var state_14626__$1 = (function (){var statearr_14650 = state_14626;
(statearr_14650[(7)] = inst_14592__$1);

return statearr_14650;
})();
if(inst_14592__$1){
var statearr_14651_14683 = state_14626__$1;
(statearr_14651_14683[(1)] = (14));

} else {
var statearr_14652_14684 = state_14626__$1;
(statearr_14652_14684[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14627 === (9))){
var inst_14614 = (state_14626[(2)]);
var inst_14615 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_14626__$1 = (function (){var statearr_14653 = state_14626;
(statearr_14653[(15)] = inst_14614);

return statearr_14653;
})();
if(cljs.core.truth_(inst_14615)){
var statearr_14654_14685 = state_14626__$1;
(statearr_14654_14685[(1)] = (21));

} else {
var statearr_14655_14686 = state_14626__$1;
(statearr_14655_14686[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14627 === (5))){
var inst_14570 = cljs.core.async.close_BANG_.call(null,out);
var state_14626__$1 = state_14626;
var statearr_14656_14687 = state_14626__$1;
(statearr_14656_14687[(2)] = inst_14570);

(statearr_14656_14687[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14627 === (14))){
var inst_14592 = (state_14626[(7)]);
var inst_14594 = cljs.core.chunked_seq_QMARK_.call(null,inst_14592);
var state_14626__$1 = state_14626;
if(inst_14594){
var statearr_14657_14688 = state_14626__$1;
(statearr_14657_14688[(1)] = (17));

} else {
var statearr_14658_14689 = state_14626__$1;
(statearr_14658_14689[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14627 === (16))){
var inst_14610 = (state_14626[(2)]);
var state_14626__$1 = state_14626;
var statearr_14659_14690 = state_14626__$1;
(statearr_14659_14690[(2)] = inst_14610);

(statearr_14659_14690[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14627 === (10))){
var inst_14581 = (state_14626[(9)]);
var inst_14579 = (state_14626[(10)]);
var inst_14586 = cljs.core._nth.call(null,inst_14579,inst_14581);
var state_14626__$1 = state_14626;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14626__$1,(13),out,inst_14586);
} else {
if((state_val_14627 === (18))){
var inst_14592 = (state_14626[(7)]);
var inst_14601 = cljs.core.first.call(null,inst_14592);
var state_14626__$1 = state_14626;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14626__$1,(20),out,inst_14601);
} else {
if((state_val_14627 === (8))){
var inst_14581 = (state_14626[(9)]);
var inst_14580 = (state_14626[(12)]);
var inst_14583 = (inst_14581 < inst_14580);
var inst_14584 = inst_14583;
var state_14626__$1 = state_14626;
if(cljs.core.truth_(inst_14584)){
var statearr_14660_14691 = state_14626__$1;
(statearr_14660_14691[(1)] = (10));

} else {
var statearr_14661_14692 = state_14626__$1;
(statearr_14661_14692[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12139__auto__))
;
return ((function (switch__12027__auto__,c__12139__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__12028__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__12028__auto____0 = (function (){
var statearr_14665 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14665[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__12028__auto__);

(statearr_14665[(1)] = (1));

return statearr_14665;
});
var cljs$core$async$mapcat_STAR__$_state_machine__12028__auto____1 = (function (state_14626){
while(true){
var ret_value__12029__auto__ = (function (){try{while(true){
var result__12030__auto__ = switch__12027__auto__.call(null,state_14626);
if(cljs.core.keyword_identical_QMARK_.call(null,result__12030__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12030__auto__;
}
break;
}
}catch (e14666){if((e14666 instanceof Object)){
var ex__12031__auto__ = e14666;
var statearr_14667_14693 = state_14626;
(statearr_14667_14693[(5)] = ex__12031__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14626);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14666;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__12029__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14694 = state_14626;
state_14626 = G__14694;
continue;
} else {
return ret_value__12029__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__12028__auto__ = function(state_14626){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__12028__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__12028__auto____1.call(this,state_14626);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__12028__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__12028__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__12028__auto__;
})()
;})(switch__12027__auto__,c__12139__auto__))
})();
var state__12141__auto__ = (function (){var statearr_14668 = f__12140__auto__.call(null);
(statearr_14668[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12139__auto__);

return statearr_14668;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__12141__auto__);
});})(c__12139__auto__))
);

return c__12139__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args14695 = [];
var len__7484__auto___14698 = arguments.length;
var i__7485__auto___14699 = (0);
while(true){
if((i__7485__auto___14699 < len__7484__auto___14698)){
args14695.push((arguments[i__7485__auto___14699]));

var G__14700 = (i__7485__auto___14699 + (1));
i__7485__auto___14699 = G__14700;
continue;
} else {
}
break;
}

var G__14697 = args14695.length;
switch (G__14697) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14695.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args14702 = [];
var len__7484__auto___14705 = arguments.length;
var i__7485__auto___14706 = (0);
while(true){
if((i__7485__auto___14706 < len__7484__auto___14705)){
args14702.push((arguments[i__7485__auto___14706]));

var G__14707 = (i__7485__auto___14706 + (1));
i__7485__auto___14706 = G__14707;
continue;
} else {
}
break;
}

var G__14704 = args14702.length;
switch (G__14704) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14702.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args14709 = [];
var len__7484__auto___14760 = arguments.length;
var i__7485__auto___14761 = (0);
while(true){
if((i__7485__auto___14761 < len__7484__auto___14760)){
args14709.push((arguments[i__7485__auto___14761]));

var G__14762 = (i__7485__auto___14761 + (1));
i__7485__auto___14761 = G__14762;
continue;
} else {
}
break;
}

var G__14711 = args14709.length;
switch (G__14711) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14709.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__12139__auto___14764 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__12139__auto___14764,out){
return (function (){
var f__12140__auto__ = (function (){var switch__12027__auto__ = ((function (c__12139__auto___14764,out){
return (function (state_14735){
var state_val_14736 = (state_14735[(1)]);
if((state_val_14736 === (7))){
var inst_14730 = (state_14735[(2)]);
var state_14735__$1 = state_14735;
var statearr_14737_14765 = state_14735__$1;
(statearr_14737_14765[(2)] = inst_14730);

(statearr_14737_14765[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14736 === (1))){
var inst_14712 = null;
var state_14735__$1 = (function (){var statearr_14738 = state_14735;
(statearr_14738[(7)] = inst_14712);

return statearr_14738;
})();
var statearr_14739_14766 = state_14735__$1;
(statearr_14739_14766[(2)] = null);

(statearr_14739_14766[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14736 === (4))){
var inst_14715 = (state_14735[(8)]);
var inst_14715__$1 = (state_14735[(2)]);
var inst_14716 = (inst_14715__$1 == null);
var inst_14717 = cljs.core.not.call(null,inst_14716);
var state_14735__$1 = (function (){var statearr_14740 = state_14735;
(statearr_14740[(8)] = inst_14715__$1);

return statearr_14740;
})();
if(inst_14717){
var statearr_14741_14767 = state_14735__$1;
(statearr_14741_14767[(1)] = (5));

} else {
var statearr_14742_14768 = state_14735__$1;
(statearr_14742_14768[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14736 === (6))){
var state_14735__$1 = state_14735;
var statearr_14743_14769 = state_14735__$1;
(statearr_14743_14769[(2)] = null);

(statearr_14743_14769[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14736 === (3))){
var inst_14732 = (state_14735[(2)]);
var inst_14733 = cljs.core.async.close_BANG_.call(null,out);
var state_14735__$1 = (function (){var statearr_14744 = state_14735;
(statearr_14744[(9)] = inst_14732);

return statearr_14744;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14735__$1,inst_14733);
} else {
if((state_val_14736 === (2))){
var state_14735__$1 = state_14735;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14735__$1,(4),ch);
} else {
if((state_val_14736 === (11))){
var inst_14715 = (state_14735[(8)]);
var inst_14724 = (state_14735[(2)]);
var inst_14712 = inst_14715;
var state_14735__$1 = (function (){var statearr_14745 = state_14735;
(statearr_14745[(10)] = inst_14724);

(statearr_14745[(7)] = inst_14712);

return statearr_14745;
})();
var statearr_14746_14770 = state_14735__$1;
(statearr_14746_14770[(2)] = null);

(statearr_14746_14770[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14736 === (9))){
var inst_14715 = (state_14735[(8)]);
var state_14735__$1 = state_14735;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14735__$1,(11),out,inst_14715);
} else {
if((state_val_14736 === (5))){
var inst_14715 = (state_14735[(8)]);
var inst_14712 = (state_14735[(7)]);
var inst_14719 = cljs.core._EQ_.call(null,inst_14715,inst_14712);
var state_14735__$1 = state_14735;
if(inst_14719){
var statearr_14748_14771 = state_14735__$1;
(statearr_14748_14771[(1)] = (8));

} else {
var statearr_14749_14772 = state_14735__$1;
(statearr_14749_14772[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14736 === (10))){
var inst_14727 = (state_14735[(2)]);
var state_14735__$1 = state_14735;
var statearr_14750_14773 = state_14735__$1;
(statearr_14750_14773[(2)] = inst_14727);

(statearr_14750_14773[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14736 === (8))){
var inst_14712 = (state_14735[(7)]);
var tmp14747 = inst_14712;
var inst_14712__$1 = tmp14747;
var state_14735__$1 = (function (){var statearr_14751 = state_14735;
(statearr_14751[(7)] = inst_14712__$1);

return statearr_14751;
})();
var statearr_14752_14774 = state_14735__$1;
(statearr_14752_14774[(2)] = null);

(statearr_14752_14774[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__12139__auto___14764,out))
;
return ((function (switch__12027__auto__,c__12139__auto___14764,out){
return (function() {
var cljs$core$async$state_machine__12028__auto__ = null;
var cljs$core$async$state_machine__12028__auto____0 = (function (){
var statearr_14756 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_14756[(0)] = cljs$core$async$state_machine__12028__auto__);

(statearr_14756[(1)] = (1));

return statearr_14756;
});
var cljs$core$async$state_machine__12028__auto____1 = (function (state_14735){
while(true){
var ret_value__12029__auto__ = (function (){try{while(true){
var result__12030__auto__ = switch__12027__auto__.call(null,state_14735);
if(cljs.core.keyword_identical_QMARK_.call(null,result__12030__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12030__auto__;
}
break;
}
}catch (e14757){if((e14757 instanceof Object)){
var ex__12031__auto__ = e14757;
var statearr_14758_14775 = state_14735;
(statearr_14758_14775[(5)] = ex__12031__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14735);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14757;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__12029__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14776 = state_14735;
state_14735 = G__14776;
continue;
} else {
return ret_value__12029__auto__;
}
break;
}
});
cljs$core$async$state_machine__12028__auto__ = function(state_14735){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12028__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12028__auto____1.call(this,state_14735);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12028__auto____0;
cljs$core$async$state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12028__auto____1;
return cljs$core$async$state_machine__12028__auto__;
})()
;})(switch__12027__auto__,c__12139__auto___14764,out))
})();
var state__12141__auto__ = (function (){var statearr_14759 = f__12140__auto__.call(null);
(statearr_14759[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12139__auto___14764);

return statearr_14759;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__12141__auto__);
});})(c__12139__auto___14764,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args14777 = [];
var len__7484__auto___14847 = arguments.length;
var i__7485__auto___14848 = (0);
while(true){
if((i__7485__auto___14848 < len__7484__auto___14847)){
args14777.push((arguments[i__7485__auto___14848]));

var G__14849 = (i__7485__auto___14848 + (1));
i__7485__auto___14848 = G__14849;
continue;
} else {
}
break;
}

var G__14779 = args14777.length;
switch (G__14779) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14777.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__12139__auto___14851 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__12139__auto___14851,out){
return (function (){
var f__12140__auto__ = (function (){var switch__12027__auto__ = ((function (c__12139__auto___14851,out){
return (function (state_14817){
var state_val_14818 = (state_14817[(1)]);
if((state_val_14818 === (7))){
var inst_14813 = (state_14817[(2)]);
var state_14817__$1 = state_14817;
var statearr_14819_14852 = state_14817__$1;
(statearr_14819_14852[(2)] = inst_14813);

(statearr_14819_14852[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14818 === (1))){
var inst_14780 = (new Array(n));
var inst_14781 = inst_14780;
var inst_14782 = (0);
var state_14817__$1 = (function (){var statearr_14820 = state_14817;
(statearr_14820[(7)] = inst_14781);

(statearr_14820[(8)] = inst_14782);

return statearr_14820;
})();
var statearr_14821_14853 = state_14817__$1;
(statearr_14821_14853[(2)] = null);

(statearr_14821_14853[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14818 === (4))){
var inst_14785 = (state_14817[(9)]);
var inst_14785__$1 = (state_14817[(2)]);
var inst_14786 = (inst_14785__$1 == null);
var inst_14787 = cljs.core.not.call(null,inst_14786);
var state_14817__$1 = (function (){var statearr_14822 = state_14817;
(statearr_14822[(9)] = inst_14785__$1);

return statearr_14822;
})();
if(inst_14787){
var statearr_14823_14854 = state_14817__$1;
(statearr_14823_14854[(1)] = (5));

} else {
var statearr_14824_14855 = state_14817__$1;
(statearr_14824_14855[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14818 === (15))){
var inst_14807 = (state_14817[(2)]);
var state_14817__$1 = state_14817;
var statearr_14825_14856 = state_14817__$1;
(statearr_14825_14856[(2)] = inst_14807);

(statearr_14825_14856[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14818 === (13))){
var state_14817__$1 = state_14817;
var statearr_14826_14857 = state_14817__$1;
(statearr_14826_14857[(2)] = null);

(statearr_14826_14857[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14818 === (6))){
var inst_14782 = (state_14817[(8)]);
var inst_14803 = (inst_14782 > (0));
var state_14817__$1 = state_14817;
if(cljs.core.truth_(inst_14803)){
var statearr_14827_14858 = state_14817__$1;
(statearr_14827_14858[(1)] = (12));

} else {
var statearr_14828_14859 = state_14817__$1;
(statearr_14828_14859[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14818 === (3))){
var inst_14815 = (state_14817[(2)]);
var state_14817__$1 = state_14817;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14817__$1,inst_14815);
} else {
if((state_val_14818 === (12))){
var inst_14781 = (state_14817[(7)]);
var inst_14805 = cljs.core.vec.call(null,inst_14781);
var state_14817__$1 = state_14817;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14817__$1,(15),out,inst_14805);
} else {
if((state_val_14818 === (2))){
var state_14817__$1 = state_14817;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14817__$1,(4),ch);
} else {
if((state_val_14818 === (11))){
var inst_14797 = (state_14817[(2)]);
var inst_14798 = (new Array(n));
var inst_14781 = inst_14798;
var inst_14782 = (0);
var state_14817__$1 = (function (){var statearr_14829 = state_14817;
(statearr_14829[(7)] = inst_14781);

(statearr_14829[(10)] = inst_14797);

(statearr_14829[(8)] = inst_14782);

return statearr_14829;
})();
var statearr_14830_14860 = state_14817__$1;
(statearr_14830_14860[(2)] = null);

(statearr_14830_14860[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14818 === (9))){
var inst_14781 = (state_14817[(7)]);
var inst_14795 = cljs.core.vec.call(null,inst_14781);
var state_14817__$1 = state_14817;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14817__$1,(11),out,inst_14795);
} else {
if((state_val_14818 === (5))){
var inst_14785 = (state_14817[(9)]);
var inst_14781 = (state_14817[(7)]);
var inst_14790 = (state_14817[(11)]);
var inst_14782 = (state_14817[(8)]);
var inst_14789 = (inst_14781[inst_14782] = inst_14785);
var inst_14790__$1 = (inst_14782 + (1));
var inst_14791 = (inst_14790__$1 < n);
var state_14817__$1 = (function (){var statearr_14831 = state_14817;
(statearr_14831[(12)] = inst_14789);

(statearr_14831[(11)] = inst_14790__$1);

return statearr_14831;
})();
if(cljs.core.truth_(inst_14791)){
var statearr_14832_14861 = state_14817__$1;
(statearr_14832_14861[(1)] = (8));

} else {
var statearr_14833_14862 = state_14817__$1;
(statearr_14833_14862[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14818 === (14))){
var inst_14810 = (state_14817[(2)]);
var inst_14811 = cljs.core.async.close_BANG_.call(null,out);
var state_14817__$1 = (function (){var statearr_14835 = state_14817;
(statearr_14835[(13)] = inst_14810);

return statearr_14835;
})();
var statearr_14836_14863 = state_14817__$1;
(statearr_14836_14863[(2)] = inst_14811);

(statearr_14836_14863[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14818 === (10))){
var inst_14801 = (state_14817[(2)]);
var state_14817__$1 = state_14817;
var statearr_14837_14864 = state_14817__$1;
(statearr_14837_14864[(2)] = inst_14801);

(statearr_14837_14864[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14818 === (8))){
var inst_14781 = (state_14817[(7)]);
var inst_14790 = (state_14817[(11)]);
var tmp14834 = inst_14781;
var inst_14781__$1 = tmp14834;
var inst_14782 = inst_14790;
var state_14817__$1 = (function (){var statearr_14838 = state_14817;
(statearr_14838[(7)] = inst_14781__$1);

(statearr_14838[(8)] = inst_14782);

return statearr_14838;
})();
var statearr_14839_14865 = state_14817__$1;
(statearr_14839_14865[(2)] = null);

(statearr_14839_14865[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12139__auto___14851,out))
;
return ((function (switch__12027__auto__,c__12139__auto___14851,out){
return (function() {
var cljs$core$async$state_machine__12028__auto__ = null;
var cljs$core$async$state_machine__12028__auto____0 = (function (){
var statearr_14843 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14843[(0)] = cljs$core$async$state_machine__12028__auto__);

(statearr_14843[(1)] = (1));

return statearr_14843;
});
var cljs$core$async$state_machine__12028__auto____1 = (function (state_14817){
while(true){
var ret_value__12029__auto__ = (function (){try{while(true){
var result__12030__auto__ = switch__12027__auto__.call(null,state_14817);
if(cljs.core.keyword_identical_QMARK_.call(null,result__12030__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12030__auto__;
}
break;
}
}catch (e14844){if((e14844 instanceof Object)){
var ex__12031__auto__ = e14844;
var statearr_14845_14866 = state_14817;
(statearr_14845_14866[(5)] = ex__12031__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14817);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14844;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__12029__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14867 = state_14817;
state_14817 = G__14867;
continue;
} else {
return ret_value__12029__auto__;
}
break;
}
});
cljs$core$async$state_machine__12028__auto__ = function(state_14817){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12028__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12028__auto____1.call(this,state_14817);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12028__auto____0;
cljs$core$async$state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12028__auto____1;
return cljs$core$async$state_machine__12028__auto__;
})()
;})(switch__12027__auto__,c__12139__auto___14851,out))
})();
var state__12141__auto__ = (function (){var statearr_14846 = f__12140__auto__.call(null);
(statearr_14846[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12139__auto___14851);

return statearr_14846;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__12141__auto__);
});})(c__12139__auto___14851,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args14868 = [];
var len__7484__auto___14942 = arguments.length;
var i__7485__auto___14943 = (0);
while(true){
if((i__7485__auto___14943 < len__7484__auto___14942)){
args14868.push((arguments[i__7485__auto___14943]));

var G__14944 = (i__7485__auto___14943 + (1));
i__7485__auto___14943 = G__14944;
continue;
} else {
}
break;
}

var G__14870 = args14868.length;
switch (G__14870) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14868.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__12139__auto___14946 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__12139__auto___14946,out){
return (function (){
var f__12140__auto__ = (function (){var switch__12027__auto__ = ((function (c__12139__auto___14946,out){
return (function (state_14912){
var state_val_14913 = (state_14912[(1)]);
if((state_val_14913 === (7))){
var inst_14908 = (state_14912[(2)]);
var state_14912__$1 = state_14912;
var statearr_14914_14947 = state_14912__$1;
(statearr_14914_14947[(2)] = inst_14908);

(statearr_14914_14947[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14913 === (1))){
var inst_14871 = [];
var inst_14872 = inst_14871;
var inst_14873 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_14912__$1 = (function (){var statearr_14915 = state_14912;
(statearr_14915[(7)] = inst_14872);

(statearr_14915[(8)] = inst_14873);

return statearr_14915;
})();
var statearr_14916_14948 = state_14912__$1;
(statearr_14916_14948[(2)] = null);

(statearr_14916_14948[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14913 === (4))){
var inst_14876 = (state_14912[(9)]);
var inst_14876__$1 = (state_14912[(2)]);
var inst_14877 = (inst_14876__$1 == null);
var inst_14878 = cljs.core.not.call(null,inst_14877);
var state_14912__$1 = (function (){var statearr_14917 = state_14912;
(statearr_14917[(9)] = inst_14876__$1);

return statearr_14917;
})();
if(inst_14878){
var statearr_14918_14949 = state_14912__$1;
(statearr_14918_14949[(1)] = (5));

} else {
var statearr_14919_14950 = state_14912__$1;
(statearr_14919_14950[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14913 === (15))){
var inst_14902 = (state_14912[(2)]);
var state_14912__$1 = state_14912;
var statearr_14920_14951 = state_14912__$1;
(statearr_14920_14951[(2)] = inst_14902);

(statearr_14920_14951[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14913 === (13))){
var state_14912__$1 = state_14912;
var statearr_14921_14952 = state_14912__$1;
(statearr_14921_14952[(2)] = null);

(statearr_14921_14952[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14913 === (6))){
var inst_14872 = (state_14912[(7)]);
var inst_14897 = inst_14872.length;
var inst_14898 = (inst_14897 > (0));
var state_14912__$1 = state_14912;
if(cljs.core.truth_(inst_14898)){
var statearr_14922_14953 = state_14912__$1;
(statearr_14922_14953[(1)] = (12));

} else {
var statearr_14923_14954 = state_14912__$1;
(statearr_14923_14954[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14913 === (3))){
var inst_14910 = (state_14912[(2)]);
var state_14912__$1 = state_14912;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14912__$1,inst_14910);
} else {
if((state_val_14913 === (12))){
var inst_14872 = (state_14912[(7)]);
var inst_14900 = cljs.core.vec.call(null,inst_14872);
var state_14912__$1 = state_14912;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14912__$1,(15),out,inst_14900);
} else {
if((state_val_14913 === (2))){
var state_14912__$1 = state_14912;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14912__$1,(4),ch);
} else {
if((state_val_14913 === (11))){
var inst_14880 = (state_14912[(10)]);
var inst_14876 = (state_14912[(9)]);
var inst_14890 = (state_14912[(2)]);
var inst_14891 = [];
var inst_14892 = inst_14891.push(inst_14876);
var inst_14872 = inst_14891;
var inst_14873 = inst_14880;
var state_14912__$1 = (function (){var statearr_14924 = state_14912;
(statearr_14924[(7)] = inst_14872);

(statearr_14924[(11)] = inst_14892);

(statearr_14924[(8)] = inst_14873);

(statearr_14924[(12)] = inst_14890);

return statearr_14924;
})();
var statearr_14925_14955 = state_14912__$1;
(statearr_14925_14955[(2)] = null);

(statearr_14925_14955[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14913 === (9))){
var inst_14872 = (state_14912[(7)]);
var inst_14888 = cljs.core.vec.call(null,inst_14872);
var state_14912__$1 = state_14912;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14912__$1,(11),out,inst_14888);
} else {
if((state_val_14913 === (5))){
var inst_14873 = (state_14912[(8)]);
var inst_14880 = (state_14912[(10)]);
var inst_14876 = (state_14912[(9)]);
var inst_14880__$1 = f.call(null,inst_14876);
var inst_14881 = cljs.core._EQ_.call(null,inst_14880__$1,inst_14873);
var inst_14882 = cljs.core.keyword_identical_QMARK_.call(null,inst_14873,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_14883 = (inst_14881) || (inst_14882);
var state_14912__$1 = (function (){var statearr_14926 = state_14912;
(statearr_14926[(10)] = inst_14880__$1);

return statearr_14926;
})();
if(cljs.core.truth_(inst_14883)){
var statearr_14927_14956 = state_14912__$1;
(statearr_14927_14956[(1)] = (8));

} else {
var statearr_14928_14957 = state_14912__$1;
(statearr_14928_14957[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14913 === (14))){
var inst_14905 = (state_14912[(2)]);
var inst_14906 = cljs.core.async.close_BANG_.call(null,out);
var state_14912__$1 = (function (){var statearr_14930 = state_14912;
(statearr_14930[(13)] = inst_14905);

return statearr_14930;
})();
var statearr_14931_14958 = state_14912__$1;
(statearr_14931_14958[(2)] = inst_14906);

(statearr_14931_14958[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14913 === (10))){
var inst_14895 = (state_14912[(2)]);
var state_14912__$1 = state_14912;
var statearr_14932_14959 = state_14912__$1;
(statearr_14932_14959[(2)] = inst_14895);

(statearr_14932_14959[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14913 === (8))){
var inst_14872 = (state_14912[(7)]);
var inst_14880 = (state_14912[(10)]);
var inst_14876 = (state_14912[(9)]);
var inst_14885 = inst_14872.push(inst_14876);
var tmp14929 = inst_14872;
var inst_14872__$1 = tmp14929;
var inst_14873 = inst_14880;
var state_14912__$1 = (function (){var statearr_14933 = state_14912;
(statearr_14933[(7)] = inst_14872__$1);

(statearr_14933[(8)] = inst_14873);

(statearr_14933[(14)] = inst_14885);

return statearr_14933;
})();
var statearr_14934_14960 = state_14912__$1;
(statearr_14934_14960[(2)] = null);

(statearr_14934_14960[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12139__auto___14946,out))
;
return ((function (switch__12027__auto__,c__12139__auto___14946,out){
return (function() {
var cljs$core$async$state_machine__12028__auto__ = null;
var cljs$core$async$state_machine__12028__auto____0 = (function (){
var statearr_14938 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14938[(0)] = cljs$core$async$state_machine__12028__auto__);

(statearr_14938[(1)] = (1));

return statearr_14938;
});
var cljs$core$async$state_machine__12028__auto____1 = (function (state_14912){
while(true){
var ret_value__12029__auto__ = (function (){try{while(true){
var result__12030__auto__ = switch__12027__auto__.call(null,state_14912);
if(cljs.core.keyword_identical_QMARK_.call(null,result__12030__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12030__auto__;
}
break;
}
}catch (e14939){if((e14939 instanceof Object)){
var ex__12031__auto__ = e14939;
var statearr_14940_14961 = state_14912;
(statearr_14940_14961[(5)] = ex__12031__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14912);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14939;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__12029__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14962 = state_14912;
state_14912 = G__14962;
continue;
} else {
return ret_value__12029__auto__;
}
break;
}
});
cljs$core$async$state_machine__12028__auto__ = function(state_14912){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12028__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12028__auto____1.call(this,state_14912);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12028__auto____0;
cljs$core$async$state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12028__auto____1;
return cljs$core$async$state_machine__12028__auto__;
})()
;})(switch__12027__auto__,c__12139__auto___14946,out))
})();
var state__12141__auto__ = (function (){var statearr_14941 = f__12140__auto__.call(null);
(statearr_14941[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12139__auto___14946);

return statearr_14941;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__12141__auto__);
});})(c__12139__auto___14946,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;

