// Compiled by ClojureScript 1.9.229 {}
goog.provide('cljs_time.coerce');
goog.require('cljs.core');
goog.require('cljs_time.core');
goog.require('cljs_time.format');
goog.require('goog.date');

/**
 * @interface
 */
cljs_time.coerce.ICoerce = function(){};

/**
 * Convert `obj` to a goog.date.DateTime instance.
 */
cljs_time.coerce.to_date_time = (function cljs_time$coerce$to_date_time(obj){
if((!((obj == null))) && (!((obj.cljs_time$coerce$ICoerce$to_date_time$arity$1 == null)))){
return obj.cljs_time$coerce$ICoerce$to_date_time$arity$1(obj);
} else {
var x__7072__auto__ = (((obj == null))?null:obj);
var m__7073__auto__ = (cljs_time.coerce.to_date_time[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return m__7073__auto__.call(null,obj);
} else {
var m__7073__auto____$1 = (cljs_time.coerce.to_date_time["_"]);
if(!((m__7073__auto____$1 == null))){
return m__7073__auto____$1.call(null,obj);
} else {
throw cljs.core.missing_protocol.call(null,"ICoerce.to-date-time",obj);
}
}
}
});

/**
 * Returns a DateTime instance in the UTC time zone corresponding to the given
 *   number of milliseconds after the Unix epoch.
 */
cljs_time.coerce.from_long = (function cljs_time$coerce$from_long(millis){
var G__20274 = (new goog.date.UtcDateTime());
G__20274.setTime(millis);

return G__20274;
});
/**
 * Returns DateTime instance from string using formatters in clj-time.format,
 *   returning first which parses
 */
cljs_time.coerce.from_string = (function cljs_time$coerce$from_string(s){
return cljs.core.first.call(null,(function (){var iter__7189__auto__ = (function cljs_time$coerce$from_string_$_iter__20283(s__20284){
return (new cljs.core.LazySeq(null,(function (){
var s__20284__$1 = s__20284;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__20284__$1);
if(temp__4657__auto__){
var s__20284__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__20284__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__20284__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__20286 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__20285 = (0);
while(true){
if((i__20285 < size__7188__auto__)){
var f = cljs.core._nth.call(null,c__7187__auto__,i__20285);
var d = (function (){try{return cljs_time.format.parse.call(null,f,s);
}catch (e20289){if((e20289 instanceof Error)){
var _ = e20289;
return null;
} else {
throw e20289;

}
}})();
if(cljs.core.truth_(d)){
cljs.core.chunk_append.call(null,b__20286,d);

var G__20291 = (i__20285 + (1));
i__20285 = G__20291;
continue;
} else {
var G__20292 = (i__20285 + (1));
i__20285 = G__20292;
continue;
}
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20286),cljs_time$coerce$from_string_$_iter__20283.call(null,cljs.core.chunk_rest.call(null,s__20284__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20286),null);
}
} else {
var f = cljs.core.first.call(null,s__20284__$2);
var d = (function (){try{return cljs_time.format.parse.call(null,f,s);
}catch (e20290){if((e20290 instanceof Error)){
var _ = e20290;
return null;
} else {
throw e20290;

}
}})();
if(cljs.core.truth_(d)){
return cljs.core.cons.call(null,d,cljs_time$coerce$from_string_$_iter__20283.call(null,cljs.core.rest.call(null,s__20284__$2)));
} else {
var G__20293 = cljs.core.rest.call(null,s__20284__$2);
s__20284__$1 = G__20293;
continue;
}
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__.call(null,cljs.core.vals.call(null,cljs_time.format.formatters));
})());
});
/**
 * Returns a DateTime instance in the UTC time zone corresponding to the given
 *   Java Date object.
 */
cljs_time.coerce.from_date = (function cljs_time$coerce$from_date(date){
return cljs_time.coerce.from_long.call(null,date.getTime());
});
/**
 * Convert `obj` to the number of milliseconds after the Unix epoch.
 */
cljs_time.coerce.to_long = (function cljs_time$coerce$to_long(obj){
var temp__4655__auto__ = cljs_time.coerce.to_date_time.call(null,obj);
if(cljs.core.truth_(temp__4655__auto__)){
var dt = temp__4655__auto__;
return dt.getTime();
} else {
return null;
}
});
/**
 * Convert `obj` to Unix epoch.
 */
cljs_time.coerce.to_epoch = (function cljs_time$coerce$to_epoch(obj){
var millis = cljs_time.coerce.to_long.call(null,obj);
var and__6397__auto__ = millis;
if(cljs.core.truth_(and__6397__auto__)){
return (millis / (1000));
} else {
return and__6397__auto__;
}
});
/**
 * Convert `obj` to a JavaScript Date instance.
 */
cljs_time.coerce.to_date = (function cljs_time$coerce$to_date(obj){
var temp__4655__auto__ = cljs_time.coerce.to_date_time.call(null,obj);
if(cljs.core.truth_(temp__4655__auto__)){
var dt = temp__4655__auto__;
return (new Date(dt.getTime()));
} else {
return null;
}
});
/**
 * Returns a string representation of obj in UTC time-zone
 *   using (ISODateTimeFormat/dateTime) date-time representation.
 */
cljs_time.coerce.to_string = (function cljs_time$coerce$to_string(obj){
var temp__4655__auto__ = cljs_time.coerce.to_date_time.call(null,obj);
if(cljs.core.truth_(temp__4655__auto__)){
var dt = temp__4655__auto__;
return cljs_time.format.unparse.call(null,new cljs.core.Keyword(null,"date-time","date-time",177938180).cljs$core$IFn$_invoke$arity$1(cljs_time.format.formatters),dt);
} else {
return null;
}
});
/**
 * Convert `obj` to a goog.date.Date instance
 */
cljs_time.coerce.to_local_date = (function cljs_time$coerce$to_local_date(obj){
var temp__4655__auto__ = cljs_time.coerce.to_date_time.call(null,obj);
if(cljs.core.truth_(temp__4655__auto__)){
var dt = temp__4655__auto__;
var G__20295 = (new goog.date.Date());
G__20295.setYear(dt.getYear());

G__20295.setMonth(dt.getMonth());

G__20295.setDate(dt.getDate());

return G__20295;
} else {
return null;
}
});
/**
 * Convert `obj` to a goog.date.DateTime instance
 */
cljs_time.coerce.to_local_date_time = (function cljs_time$coerce$to_local_date_time(obj){
var temp__4655__auto__ = cljs_time.coerce.to_date_time.call(null,obj);
if(cljs.core.truth_(temp__4655__auto__)){
var dt = temp__4655__auto__;
var G__20297 = (new goog.date.DateTime());
G__20297.setYear(dt.getYear());

G__20297.setMonth(dt.getMonth());

G__20297.setDate(dt.getDate());

G__20297.setHours(dt.getHours());

G__20297.setMinutes(dt.getMinutes());

G__20297.setSeconds(dt.getSeconds());

G__20297.setMilliseconds(dt.getMilliseconds());

return G__20297;
} else {
return null;
}
});
(cljs_time.coerce.ICoerce["null"] = true);

(cljs_time.coerce.to_date_time["null"] = (function (_){
return null;
}));

Date.prototype.cljs_time$coerce$ICoerce$ = true;

Date.prototype.cljs_time$coerce$ICoerce$to_date_time$arity$1 = (function (date){
var date__$1 = this;
return cljs_time.coerce.from_date.call(null,date__$1);
});

goog.date.Date.prototype.cljs_time$coerce$ICoerce$ = true;

goog.date.Date.prototype.cljs_time$coerce$ICoerce$to_date_time$arity$1 = (function (local_date){
var local_date__$1 = this;
return cljs_time.core.date_time.call(null,cljs_time.core.year.call(null,local_date__$1),cljs_time.core.month.call(null,local_date__$1),cljs_time.core.day.call(null,local_date__$1));
});

goog.date.DateTime.prototype.cljs_time$coerce$ICoerce$ = true;

goog.date.DateTime.prototype.cljs_time$coerce$ICoerce$to_date_time$arity$1 = (function (local_date_time){
var local_date_time__$1 = this;
return cljs_time.core.date_time.call(null,cljs_time.core.year.call(null,local_date_time__$1),cljs_time.core.month.call(null,local_date_time__$1),cljs_time.core.day.call(null,local_date_time__$1),cljs_time.core.hour.call(null,local_date_time__$1),cljs_time.core.minute.call(null,local_date_time__$1),cljs_time.core.second.call(null,local_date_time__$1),cljs_time.core.milli.call(null,local_date_time__$1));
});

goog.date.UtcDateTime.prototype.cljs_time$coerce$ICoerce$ = true;

goog.date.UtcDateTime.prototype.cljs_time$coerce$ICoerce$to_date_time$arity$1 = (function (date_time){
var date_time__$1 = this;
return date_time__$1;
});

(cljs_time.coerce.ICoerce["number"] = true);

(cljs_time.coerce.to_date_time["number"] = (function (long$){
return cljs_time.coerce.from_long.call(null,long$);
}));

(cljs_time.coerce.ICoerce["string"] = true);

(cljs_time.coerce.to_date_time["string"] = (function (string){
return cljs_time.coerce.from_string.call(null,string);
}));
